List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["When-Equations", "Title"], Cell[TextData[List["\n", StyleBox["When", Rule[FontFamily, "Courier"]], "-equations have been introduced in Modelica to express instantaneous equations (equations that are valid only at certain points when specific conditions become ", StyleBox["true", Rule[FontFamily, "Courier"]], "). Then equations in the ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equation are activated when at least one of the conditions become ", StyleBox["true", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[CellGroupData[List[Cell["Bouncing Ball", "Section"], Cell[TextData[List["A bouncing ball is a good example of a hybrid system for which the when-equation is appropriate when modeled. The motion of the ball is characterized by the variable ", StyleBox["height", Rule[FontFamily, "Courier"]], " above the ground and the vertical ", StyleBox["velocity", Rule[FontFamily, "Courier"]], ". The ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " equation is a special from of equation that can be used in ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equations to define new values for continuous-time state variables of a model at an ", ButtonBox["event", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "DiscreteHybrid"], "SampleClock.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ".\n"]], "Text"], Cell[TextData[List["model BouncingBall \t\t\t\t\t\t\"The bouncing ball model\"\n  constant Real g = 9.81;\t\t\t\t// Gravitational acceleration\n  parameter Real c = 0.9;\t\t\t\t// Elasticity constant of ball\n  parameter Real radius = 0.1;\t \t\t// Radius of the ball\n  Real height(start = 1);\t\t\t\t// height above ground of the ball center\n  Real velocity(start = 0);\t\t\t\t// Velocity of the ball\nequation\n  der(height) = velocity;\n  der(velocity) = -g;\n  ", StyleBox["when height <= radius then \n    reinit(velocity, -c*pre(velocity));\n  end when;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend BouncingBall;"]], "ModelicaInput"], Cell["", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0002V80@0006`000020000000003D1002`0000\n00000000001j7P00RA000215CDH00040R2T00;D000080000000000000000000000D0000400100@00\nl0000000000000000000003R1020Z@<0AP00090?00243`00AdA9@`4008000`00/8PNB000001/3`00\n0@090003]PL000T0<0000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030:P02L170000?/2l?l00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iR\nmGO7H_Eg0@000000<0040000;@4000D000020@40000500002@8000020`0001h01`0001H4X00W0@00\n000@00009PH?01H0ooooo`00oooooooooolX0@00X@0000<0000N00D0000^0@00000500002P800000\n1@0000T2000000D000010_ooo`070000o0810000000000@0000]0@4020000?X21@010000000000@0\n000]0@80100000<1200500002`8000001@0000`2j0<d1a@0000V1Pl07P3ooooo100D0000EfmbI0h0\nCFUSLVmcKfId85M_LV@5000030;X0c@770000?/240070000002l0P0000040002DgUcM6E]07M00000\nS0T:b[iRmGO7H_Eg0@000000<0040000;@4300D000020@40000L0000n`:]o`0000000901000000A0\n019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0000]0@@01@0000T2000000D000020@40\n000@00009PH?01H0ooooo`00;P@00;43000m1000c0<000@0000]0@801`000?`20000000000040000\n;@4500D000060@80000500002`800000<00002@35P0k1;P3;`Bh0bl4a0<_1<@3<@C80c<4b@<e1<X3\n=`C90cT4b0<k1<@3>`Bn0bl4_P<_1<@3>`C40cT4`0<g1;l3=@Bn0c<4_`<a1<03;`C40cD4a0<k1<@3\n1@0000H10@0000P0003j0P000000000000040000;@4600L0003l0P00oooo0000100002d11`040000\nl04500P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`000@000;X3000]1`00d0<000@0000]0@80\n1`000?`20000000000040000;@4500D000060@80000<000090<400/0^`<;0<d38PO>0b87_0<50000\n1P410000100002d11P040000;@4700@0003`0@D0200002H63`060?ooool100L0003l0P00P8200000\n100002d11@080000nP8000H000000002100002d12007000060C^01d10P0l00@0000]0@L010000?01\n1@040000;@4600@0003`0@P0400002H63`0F0?ooool001T1001_0000O`800<P300040000;@4200L0\n003l0P0000000000100002d11@0500001P420000400002@31P0N0G007P5h0301N@0m0G/0?P5d0301\nL@0@000090<605H1N`1C0H80H@6806l1T01c0HX0I`620100000T0`H0R06G08<1W@2B0JX0VP6b0:01\n[02H0J@0400002@31P2a0Kh0Z`730;41bP2o0M`0a@7G0;L1a00D000090<80=<1jP3=0Nl0cP7a0=`1\n1`7N0@X1i0460N810@7D0N/0400002@31P3a0A/1jP4O0OL1>07i0CX1008g0Od1<P4J000090<;00X2\nC@430U01109B0A02KP4C0V/13`9[0@l2KP4F0V/15`9[0AH2J04:0T`1400002@31P0O0X4160:40AX2\nR@4S0Z81:P:O0B82R@4@000090<60382]P4[0[P1;`;70C@2e`4k0]D1=`;70A00000T0`H0@P;/0C/2\nkP520P/2@`8=0TX22`9:0P/2400002@31P1?0R82B08T0TX2;P9?0T@2EP920U82;P8@000090<605/2\nFP9D0U/2F@9h0UX2NP9Q0WT2H@9h0P`0000T0`@0I0:A0Ud2TP9R0[42J@:`0P`0000T0`@0K@;80VD2\nb@9X0^T2L0;X0Q00000T0`H0L`800f/20@=]0QL3KP8Q0gH280=e0QL3300002@3101g0SP3K`8i0g42\nF@=i0UP3300002@3101j0W03LP9`0g<2T0=k0Y03300002@3101k0ZP3L`:X0g@2`@=l0/431@0000H1\n0@0000@0000]0@H0100002d11`040000l04500P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`00\nl@D008l300111P00f`<000@0000]0@801`000?`20000000000040000;@4500D000060@80000J0000\n90<;03L6_`<n1[h3>@J]0cP6ZP<d1Z<3<@JO0b/6X`<^1ZT3<PJ`0cD6[@<a1Zd39P0002@34@0J1YP3\n6PJ@0aP6T0<C1Y433@JC0`X6U0<51YL30@JK0od5X@<31ZH31`JQ0`/6W@<@1YX33@JG0`d6V`<C1YT3\n60JH0``0000T0`@0nPFj0o<5^0?c1KT3nPFk0`D000060@4000040000;@4600@0000]0@L010000?01\n1@0800009PH?00H0ooooo`40400002H63`0F0?ooool004H5000a0`00o0D00<D300040000;@4200L0\n003l0P0000000000100002d11@0500001P420000400002@31P3a1Kd3n@Fm0oL5XP?f1Id3k`FN0nl5\nXP<F000090<90>X5Q`?a1HD3j`Ea0nX5KP?U1FH3gPEZ0n@5M0?W1G43h`Ea0aP0000T0`X0dPEF0mP5\nD@?C1DX3c0E30l@5?P>o1C/3^`E10kh5A0?61DT3c@E@0aP0000T0`X0Y`Dk0jL5<`>P1C83U`Dc0hl5\n=@>61CP3R@Do0hl5?@>G1C/3X0Dj0aP0000T0`X0M`E<0g85AP=]1DX3I`EB0f45F`=N1F43I0ET0fL5\nH@=]1EP3L`E@0a00000T0`H0F`Ej0e@5N0=>1HT3B`FG0e85V0=F1HT3300002@3101@1Jl3B0F_0dL5\n_P=?1Kh31@0000H10@0000@0000]0@H0100002d11`040000l04500P0000V1Pl01P3ooooo0@0@0000\n9PH?01H0ooooo`00=`@00=`2001=1@00a0<000@0000]0@801`000?`20000000000040000;@4500D0\n00060@80000@000090<60485^`=:1K/3B@FU0dP5V`=01I`3@@FU0a@0000T0`P0?PF40dD5P`=41GX3\n?`EV0ch5H`<g1FD3=`EV0c`5NP<J000090<;0305C`<g1D`3<`E10c85?P<Z1Bd3:PD^0b@5<P<T1C<3\n;0E40bl5@@<[1D43500002@3200H1Ad37PDI0aP540<>1@<32PGo0P@51@<81@T34PDF0ah0000T0`d0\nlPCe0_L4k`;g1>l2j`CX0]l4hP;L1>42f@CQ0]L4j0;L1>T2g0CU0]T4j0;U1>h2l@Ce0QX0000T0`/0\n`0CU0/04g@:c1=h2YPCR0Z<4h`:P1>@2X`C[0ZT4j@:V1>H2YPCZ0[<4iP8D000090<808l4mP::1?02\nOPCi0W<410=b10H3N0@;0gT42P>41?l2500002@3201Z11h3I0@J0f047`=G12h3E0@f0e/4>@=M13@3\nIP@U0a@0000T0`P0DPA@0d/4C@=815@3@PAX0d84K0=916h3BPAX0e04E0<@000090<604D4Q@<m18@3\n>`BA0cT4Y0=11:D3@`BA0``0000T0`@0@0Bl0cP4_0<h1;d3@0Bm0`D000060@4000040000;@4600@0\n000]0@L010000?011@0800009PH?00H0ooooo`40400002H63`0F0?ooool007X200080P00?P@00<L3\n00040000;@4200L0003l0P0000000000100002d11@0500001P420000300002@3100c1;`3>`Bl0cX4\nW0<b19`3400002@31P0a18D3>@B40cH4I@<f16@3;PAU0bh4I@<@000090<602/4C@<c14`3<@@l0bd4\n;0<V12d3:@@l0a00000T0`H08P@F0bT45@<Y11@38@Ce0QX4m`8Q11@3400002@31P0D1>026`CN0QD4\nb`8A1;l22PC20Pd4b`8F000090<90044[0881:T220BY0PL4YP;k0h`2m0>?0P44[0841:T200BY0Q00\n000T0`H0j@=j0^l3MP;Y0f`2g@=K0]L3G`;S0g82400002@31P390dd2c`=80/H3?P:h0c02/`<f0/03\nA08N000090<=0:03:0:U0b82W`<M0YD360::0a<2Q`<B0XL34P:50aT2Q`<J0XL35P:40aT2S`<N0YT3\n8`8H000090<:06l34`9`0`/2IP<:0U/32@9@0`X2C`<:0U034P9@0a82F`<A0VH34P8J000090<;03T3\n5P8g0`l2;`<B0R`34`8Q0aP26@<M0Qd38`8W0ah2<P<I0Rl35P8_0aX2500002@320090c021@<Z0P83\n;0;_0Sh2k@910_<2AP;e0T@220<b0Q@0000T0`P0i09H0]h2D`;M0U@2c09]0/`2KP;B0W82dP9c0^<2\nFP8@000090<60<H2Q`;00X<2_0:90[82X@:i0Z@2`P:?0Q00000T0`H0/0:j0ZT2]`:P0/`2WP;E0ZD2\ne`:X0/`2400002@31P2N0^h2U`;/0YD2l0:?0P/3UP8=0id2l08@000090<6094290>:0R<3Q@8n0h@2\n@`><0T@3S@8n0a00000T0`H0R@9L0h42F`=o0VP3OP9k0hH2O0>70VP3400002@31P240Y<3O0:B0g`2\nT`=k0[<3P`:c0h@2T`<500001P410000100002d11P040000;@4700@0003`0@D0200002H63`060?oo\nool100@0000]0@<010000?0110070000o0800?ooo`0000@0000]0@@020000?X200000000000000@0\n000]0@D0100002L1ool800009PH?00H0ooooo`40100002L1oolL0000n`8@00L000000;`200000042\n0R9CNG=dIFd000002P0000@0000000P000010000000`00@0000]0@P00`0000004@0000`000080000\n2`000100000h0@00]@0000T0000@0000>0400;D0000:000040000000000000002@000100000W0@00\nX0000580001`0@000@000?3oool0000000000000002@0@00000000A0019D06T0K@1U07<0801>06D0\nM`0P0580K`1]0640KP000000000000000000000000000000000000000000000000000002000001<0\nh9hJ07P14`0T1000D;KlMaJeo7L]]Oag00000800003hkQT0000C02P<4`0N0000R=hE09cc4P2H1AX3\nN04C09P56P=h0A<0ooooofSe4P101Q<0:0`C000000000000kP<Q6OSc4P2/^hl1?4=>0?Sc4P0001X3\nN04C0?816P000000@0HC02cd4P2H1AX3N04C09P56P=h0A<0T0DJ0hQNT@7b0AX0R5jA0@00001eUd<0\n000C09P56P=h0A<0N04C09056P>H1AX3N04C09056P<00000000000T0003hkQT0Z?@B0:@_6P32`?Ag\n0@0006Af00P000009@0000`0000100004P0000`000010000600000`0000000028@0000P0000N0000\n60000000000000009`400:00000Q0000200001H0000<0000000007P0000@000000000000000H0000\n30000000000I000030000?ooo`0U0000300000D0080U0000300000P0080:00004000000000000000\n2@000100000d1`00j0<000T0000@0000=0L00>P3001B0000L0400080000@00001`00000000000000\n_080000000040002D`1i07<0M01U06d0000000000000000000000000000000000000000000000000\n000000000000000000000000@`0001<0V0DJ0gP14`1h0A<0T0DJ0iP56P=h0A<0T0DJ0`0000000000\n2@000?S^6@2Xm180Y2lJ0<;0m7L10000I7H02000002H1AX3N04C0?oooomXmA80@0HC02P<4`000000\n00000>h38AWhla80[;^?0Ca3CP3hla80000J0gP14`3b0AX0000004064`0/m180V0DJ0gP14`2H1AX3\nN04C09056P>8GY4142;dMlC`oGl0h?eo0@0000000000000000000:480000@000X@P4N`40001Tm180\n9@000?S^6@090000n>hI0:Sd4P3F<1X0`/3dM`40001TMP08000002D0000<00000P000180000<0000\n0@000580001`0@000`000:goool0000000000000002@0@00000000A0019D06T0K@1U07<0801>06D0\nM`0P0580K`1]0640KP00000000000000000000000000000000000000000000000000000000000000\n00000:480000@000X@P4N`40001Tm1809@000?S^6@090000n>hI0:Sd4P3F<1X0`/3dM`40001TMP08\n000009P56P=h0A<0ooooofSe4P101Q<0:0`C000000000000kP<Q6OSc4P2/^hl1?4=>0?Sc4P0001X3\nN04C0?816P000000@0HC02cd4P2H1AX3N04C09P56P=h0A<0T0DJ0hQNT@4@8_Aga?3mO`3PoGl10000\n0000000000000000X@P00010002Q20Ak0@0006Cd4P0U0000n>hI08Sd4P0Z2@00E<3dM`40000I0;01\n:PT:@VAf00P000009@0000`000030000600000`0000000004P0000`0000100009@0000`000080020\n9`0001P00004000000000000000000009@0000`0000400004`0000`0000200002P00010000000000\n000005H0001d0000]@000:`0002g0000/00001H0000k1;P3;`Bh0bl4a0<_1<@3<@C80c<4b@<e1<X3\n=`C90cT4b0<k1<@3>`Bn0bl4_P<_1<@3>`C40cT4`0<g1;l3=@Bn0c<4_`<a1<03;`C40cD4a0<k1<@3\n4`0000`0000100009P0001`0000500000000000000000000000002D0000<00001@0002L0000H0000\n1P000000003oool0000002D0000<00001P0002P0000<0000100002D0000<00002000P2L0000H0000\n1000000000000000000002D0000<0000100001<0000<00000P0005H0000/00000P000:d0000e0@00\n/00000@0000;0;/32`3=0b87cP<R1k`34`0000`0000100009@0000`0000500009@0000`000060000\n:00000`0000400009`0001P00004000000000820P00000009@0000`0000400009P0001`000070000\n000000H00000000000000RD0000<00001`0002X0000H0000?0000080000G0@00j00002D0000<0000\n1P0002P0000<0000100002D0000<00001@0002P0000<00001`0002D0000<00002000P2L0000H0000\n1`00000000000000000002D0000<00001`0001<0000<00000P0005H0000d0000<00001@0000f0000\n5P0000H0000N0G007P5h0301N@0m0G/0?P5d0301L@1F0000=00003T0000F0000?`0001X000060000\nEP5k05<1PP1Q0HP0K`6@07<1RP1W0H80EP0003@0001200006`0004H0000P00001P0008P1U`230Id0\nTP6Z09X1/P2P0J`0V06T05H0000d0000B0000280001=0000:00000H0002a0Kh0Z`730;41bP2o0M`0\na@7G0;L1a01F0000?00004h0000Z0000DP00030000080000d`7Z0<d1k`3>0O40g0470Mh12P7T0@H1\nhP410M@1j`1F0000=00005<0000c0000E`0003T000060000l@4K0NX17`7g0CP1n@4j0@02=`7m0C81\nEP0004P0001G0000?00005/0001200002`0000X2C@430U01109B0A02KP4C0V/13`9[0@l2KP4F0V/1\n5`9[0AH2J04:0T`1EP0003@0001K0000AP0005h0001<00001P0001l2P@4H0X@16P:90B<2XP4Z0Yl1\n8P:90EH0000d0000GP0004l0001Q0000E@0000H0000b0[H1:`:h0Bl2a`4d0]L1>`;E0CL2a`5F0000\n=0000640001I0000H`0005l000060000@P;/0C/2kP520P/2@`8=0TX22`9:0P/2EP0003@0001S0000\nH`0006D0001Y00001P0004l28P980R@2BP8^0Tl2A09F0T82DP8^0UH0000d0000I@0006d0001W0000\nL`0000H0001K0UX2E09K0UT2N09J0WX2H@9i0V42N09F0000;00006H0001g0000J00007d000040000\nI0:A0Ud2TP9R0[42J@:`0UH0000/0000J0000840001Z0000Q`0000@0001]0/P2I@;90VP2j@9`0^P2\nEP0003@0001Y0000R`0006/0002A00001P0007<200=[0P43K@8G0fh28@=f0R03M@8G0eH0000/0000\nJ@0009D0001[0000V`0000@0001g0SP3K`8i0g42F@=i0UP3EP0002`0001Z0000W`0006/0002U0000\n100007X2L0=b0W03L`:@0g/2T0=F0000;00006X0002Y0000K0000:h000040000N`:X0g<2Z0=d0/43\nO0;10a<0000<00000@0002D0000<00001@0002D0000<00001P0002P0000<00001`0002D0000<0000\n2000P2L0000H00001`00000000000000000002D0000<00001`0001<0000<00000P0005H000180000\n2`400:P0000>0@00[P0000/0000g1[l3?PJn0cT6[@<h1ZX3=0JS0c46W`<[1Z<3;PJY0c86/0<e1Zd3\n<@J]0eH0001P00000`400:D000080@00Z@000140000J1YP36PJ@0aP6T0<C1Y433@JC0`X6U0<51YL3\n0@JK0od5X@<31ZH31`JQ0`/6W@<@1YX33@JG0`d6V`<C1YT360JH0eH0000/00000P400:`000030@00\n[@0000@0003j1KX3l`Fh0o<5^@?j1K/34`0000`0000100009@0000`0000500009@0000`000060000\n:00000`0000700009@0000`0000800209`0001P00007000000000000000000009@0000`000070000\n4`0000`000020000EP0003@000010@00Y`0000<1002]00001P000?45_@?i1Kd3m`FR0oH5W@?_1Ih3\nk`FR0eH000100000oP0009h000010@00X`0000T0003Z1HL3l@F50n/5L@?Z1Fh3i@EV0mh5JP?T1G@3\ni`Ea0n<5L@=F0000A0000?P0002F0000o@0009/0000:0000dPEF0mP5D@?C1DX3c0E30l@5?P>o1C/3\n^`E10kh5A0?61DT3c@E@0eH000140000k`0009@0003e0000UP0000X0002W1C/3Y`Dc0j05<P>G1C<3\nS`De0hH5>0>91Cl3S`Dm0iL5>`>P1CX3EP0004@0003Y0000V0000>d0002M00002P0007L5C0=b1DH3\nK@E:0fL5DP=Q1E/3GPEQ0f@5I0=W1F43K@EH0g<5D0=F0000=0000>D0002Q0000j0000:L000060000\nF`Ej0e@5N0=>1HT3B`FG0e85V0=F1HT3EP0002`0003U0000Z`000>H0002]000010000505[`=81Jl3\nA`Fn0dl5_P<C000030000040000U0000300000D0000U0000300000H0000X0000300000L0000U0000\n300000P0080W0000600000L00000000000000000000U0000300000L0000C000030000080001F0000\n=0000><0002W0000i@000:d000060000@PFk0dX5^`=91JD3B0FK0d05W0=11JD3EP0003`0003R0000\nW@000>@0002S0000200003h5Q0=51H<3A0Ej0cl5IP<n1F<3=`EU0cL5IP<l1GX3EP0004P0003O0000\nT`000>80002I00002`000305C`<g1D`3<`E10c85?P<Z1Bd3:PD^0b@5<P<T1C<3;0E40bl5@@<[1D43\nEP0003`0003I0000R`000=h0002@0000200001P57@<N1AT360D@0`h50`<:1Ol210D50`P52@<B1AH3\nEP000500003B0000Q@000=L0002900003@000?84m@;g1>l2m`C_0^/4j0;O1>82g0CQ0]T4h@;G1>P2\ng0CY0]`4i@;I1>P2i@C^0_44m@9F0000B0000<P000250000cP0008L0000;0000`0CU0/04g@:c1=h2\nYPCR0Z<4h`:P1>@2X`C[0ZT4j@:V1>H2YPCZ0[<4iP9F0000?0000<4000280000a@0008d000080000\nS`Cf0XX4l09n1?T2L`@40g841P=h10/3N@@:0h@4o`9F0000?0000;`0002@0000_`0009D000080000\nJP@N0f@46P=P11l3E`@^0e@4=P=K13T3G@@d0fH49@=F0000?0000;P0002I0000^`0009l000080000\nDPA@0d/4C@=815@3@PAX0d84K0=916h3BPAX0e04E0=F0000=0000;L0002S0000^@000:T000060000\nA@B50cd4Q0<k1943>@BT0d44Y@=31943EP0002`0002g0000[@000;P0002]000010000404_0<h1;`3\n>0Bm0d04_@<C000030000040000U0000300000D0000U0000300000H0000X0000300000L0000U0000\n300000P0080W0000600000L00000000000000000000U0000300000L0000C000030000080001F0000\n;0000;H0002W0000]`000:d000040000<`Bl0c/4_0<j19`3<PBL0eH0000d0000]@0009d0002g0000\nX`0000H0000a18D3>@B40cH4I@<f16@3;PAU0bh4I@=F0000=0000;@0002C0000]P0009T000060000\n:`A=0c<4C0<a13`3;@@/0bH4;@<Y13`3EP0003@0002b0000R@000;@0002?00001P0002845P<Y11D3\n:@@D0b44m@8J1?L28@@D0eH0000d0000[`0007l0002b0000Q@0000H0000D1>026`CN0QD4b`8A1;l2\n2PC20Pd4b`9F0000@0000:/0001f0000[`0007`0000900000@B/0PP4Z@881:T21`BV0_/3S0;d0hl2\n0@B/0P@4Z@801:T2EP0003@0002V0000K@000:X0001c00001P000>T3NP;_0gH2j@=/0]d3F`;G0el2\nh`=b0UH0000d0000X00006D0002U0000J`0000H000390dd2c`=80/H3?P:h0c02/`<f0/03A09F0000\nD00009P0001P0000WP0006@0000=0000X0<X0ZD38P:O0ad2U@<H0XX34`:70a82Q`<B0XD36@:70aX2\nQ`<F0X@36@:?0ah2V@<S0UH000140000S`0005h0002E0000H00000X0001_0a<2L0<;0VH32P9K0`T2\nD0<:0Tl32P9@0a82D0<B0U/34@9V0a82EP0004P000260000G`0008`0001S00002`0003T35P8g0`l2\n;`<B0R`34`8Q0aP26@<M0Qd38`8W0ah2<P<I0Rl35P8_0aX2EP0003`0001o0000I00008<0001Y0000\n200000T3<0850bX20P</0^l2?P;]0T42l`960_D2A0880c82EP0003`0001i0000K00007d0001b0000\n20000>@2F0;N0U<2g@9D0/`2K@;<0Vh2dP9b0]82L`;S0UX2EP0003@0001e0000M00007P0001j0000\n1P000<H2Q`;00X<2_0:90[82X@:i0Z@2`P:?0UH0000d0000L@0007h0001d0000Q00000H0002`0[X2\nZ@:g0Z02c0:N0]D2Y@;G0ZP2c09F0000=00006l000270000L@0008d000060000WP;^0YL2k0:E0_02\nS`8;0iH23@>M0_02EP0003@0001]0000T@0006l0002G00001P00094290>:0R<3Q@8n0h@2@`><0T@3\nS@8n0eH0000d0000K00009`0001^0000X@0000H000290U`3P@9K0gl2J0=n0W/3QP9l0hL2J0=F0000\n=00006/0002U0000K@000:/000060000Q0:C0g`2TP=l0Y<3N`:c0h<2/`>40Y<34`0000`000010000\n9@0000`0000500009@0000`000060000:00000`0000700009@0000`000020000:00000`000030000\n9`0001P00003000000000?ooo`0000009@0000`0000300009P0001`0000700000000000000000000\n000002D0000<00001`000280000<0000ooooob80000<0000oooooe80001`0@001000010000070000\n00000000002l0P00000000420R9C07T0L`1d06D0K@00000000000000000000000000000000000000\n00000000000000000000000000000000000G051j5`00000000000:480000@000X@P4N`40001Tm180\n9@000?S^6@28m180c?<B0000003U>?Qg000C0=Qk5`000000Z?<B08P64`1Lm180UB_hM`004`040000\n0?@B042go7OH1a<00G/G00H0001Xla800000033d4P000?Qg63KhMooooom0m180PW?XM`004`000000\nD7XG0:D72P5@NQL0883gMj480000@0001`000=]Bm7L<m18000000<3e4P1F6>Yg/7GXM`00003oool0\n0000051j5`2ma_AgkP<Q6G3d4P01P000H<KdMnh38AU`m180/83gMfAf00P000009@0000`000040000\n9@0000`0000700209@0000`000000020<00000`0000?00209@0000`0000=0020B`00010000000000\n1@0002P0000<00000@0002P0000<00000P0002P0000<00000`0002P0000<00001`0002P0000<0000\n1@0002P0000<00001P0002P0000<0000100000h0000D000000000100000D0000\n"], "Text", Rule[ImageSize, List[307, 176]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[BoxData[RowBox[List["A", " ", "bouncing", " ", "ball"]]], "NumberedFigure"]], Open]], Cell[CellGroupData[List[Cell["Simulation 1 of Bouncing Ball ", "Section"], Cell["When we simulate the BouncingBall model from 0 to 8 we see how it bounces ", "Text"], Cell["simulate( BouncingBall, stopTime=8 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(BouncingBall\\) : 2004-1-30 9:53:11.5965585 : \\!\\({0.`, 8.`}\\) : 658 data points : 39 events : 7 variables>\\n\\!\\({\\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"g\\\", HoldForm], \\*TagBox[\\\"height\\\", HoldForm], \\*TagBox[\\\"radius\\\", HoldForm], \\*TagBox[\\\"velocity\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"height\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"velocity\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( { height, velocity } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.119048 0.324507 0.0737223 [\n[.2619 .31201 -3 -9 ]\n[.2619 .31201 3 0 ]\n[.5 .31201 -3 -9 ]\n[.5 .31201 3 0 ]\n[.7381 .31201 -3 -9 ]\n[.7381 .31201 3 0 ]\n[.97619 .31201 -3 -9 ]\n[.97619 .31201 3 0 ]\n[1.025 .32451 0 -6.28125 ]\n[1.025 .32451 10 6.28125 ]\n[.01131 .02962 -12 -4.5 ]\n[.01131 .02962 0 4.5 ]\n[.01131 .17706 -12 -4.5 ]\n[.01131 .17706 0 4.5 ]\n[.01131 .47195 -6 -4.5 ]\n[.01131 .47195 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .32451 m\n.2619 .33076 L\ns\n[(2)] .2619 .31201 0 1 Mshowa\n.5 .32451 m\n.5 .33076 L\ns\n[(4)] .5 .31201 0 1 Mshowa\n.7381 .32451 m\n.7381 .33076 L\ns\n[(6)] .7381 .31201 0 1 Mshowa\n.97619 .32451 m\n.97619 .33076 L\ns\n[(8)] .97619 .31201 0 1 Mshowa\n.125 Mabswid\n.08333 .32451 m\n.08333 .32826 L\ns\n.14286 .32451 m\n.14286 .32826 L\ns\n.20238 .32451 m\n.20238 .32826 L\ns\n.32143 .32451 m\n.32143 .32826 L\ns\n.38095 .32451 m\n.38095 .32826 L\ns\n.44048 .32451 m\n.44048 .32826 L\ns\n.55952 .32451 m\n.55952 .32826 L\ns\n.61905 .32451 m\n.61905 .32826 L\ns\n.67857 .32451 m\n.67857 .32826 L\ns\n.79762 .32451 m\n.79762 .32826 L\ns\n.85714 .32451 m\n.85714 .32826 L\ns\n.91667 .32451 m\n.91667 .32826 L\ns\n.25 Mabswid\n0 .32451 m\n1 .32451 L\ns\ngsave\n1.025 .32451 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .02962 m\n.03006 .02962 L\ns\n[(-4)] .01131 .02962 1 0 Mshowa\n.02381 .17706 m\n.03006 .17706 L\ns\n[(-2)] .01131 .17706 1 0 Mshowa\n.02381 .47195 m\n.03006 .47195 L\ns\n[(2)] .01131 .47195 1 0 Mshowa\n.125 Mabswid\n.02381 .06648 m\n.02756 .06648 L\ns\n.02381 .10334 m\n.02756 .10334 L\ns\n.02381 .1402 m\n.02756 .1402 L\ns\n.02381 .21392 m\n.02756 .21392 L\ns\n.02381 .25078 m\n.02756 .25078 L\ns\n.02381 .28765 m\n.02756 .28765 L\ns\n.02381 .36137 m\n.02756 .36137 L\ns\n.02381 .39823 m\n.02756 .39823 L\ns\n.02381 .43509 m\n.02756 .43509 L\ns\n.02381 .50881 m\n.02756 .50881 L\ns\n.02381 .54567 m\n.02756 .54567 L\ns\n.02381 .58253 m\n.02756 .58253 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .39823 m\n.02571 .39814 L\n.02762 .39786 L\n.02952 .3974 L\n.03143 .39675 L\n.03333 .39591 L\n.03524 .3949 L\n.03714 .39369 L\n.03905 .3923 L\n.04095 .39073 L\n.04286 .38897 L\n.04476 .38703 L\n.04667 .3849 L\n.04857 .38258 L\n.05048 .38008 L\n.05238 .3774 L\n.05429 .37453 L\n.05619 .37148 L\n.0581 .36824 L\n.06 .36481 L\n.0619 .3612 L\n.06381 .3574 L\n.06571 .35342 L\n.06762 .34926 L\n.06952 .34491 L\n.07143 .34037 L\n.07333 .33565 L\n.0748 .33188 L\n.0748 .33188 L\n.0748 .33188 L\n.0748 .33188 L\n.07524 .33289 L\n.07714 .33722 L\n.07905 .34136 L\n.08095 .34531 L\n.08286 .34908 L\n.08476 .35267 L\n.08667 .35607 L\n.08857 .35929 L\n.09048 .36232 L\n.09238 .36516 L\n.09429 .36782 L\n.09619 .3703 L\n.0981 .37259 L\n.1 .37469 L\n.1019 .37661 L\n.10381 .37834 L\n.10571 .37989 L\n.10762 .38126 L\n.10952 .38244 L\nMistroke\n.11143 .38343 L\n.11333 .38424 L\n.11524 .38486 L\n.11714 .3853 L\n.11905 .38555 L\n.12095 .38562 L\n.12286 .3855 L\n.12476 .3852 L\n.12667 .38471 L\n.12857 .38404 L\n.13048 .38318 L\n.13238 .38214 L\n.13429 .38091 L\n.13619 .3795 L\n.1381 .3779 L\n.14 .37612 L\n.1419 .37415 L\n.14381 .37199 L\n.14571 .36966 L\n.14762 .36713 L\n.14952 .36442 L\n.15143 .36153 L\n.15333 .35845 L\n.15524 .35518 L\n.15714 .35173 L\n.15905 .3481 L\n.16095 .34428 L\n.16286 .34027 L\n.16476 .33608 L\n.16659 .33188 L\n.16659 .33188 L\n.16659 .33188 L\n.16659 .33188 L\n.16667 .33203 L\n.16857 .33595 L\n.17048 .33968 L\n.17238 .34322 L\n.17429 .34658 L\n.17619 .34976 L\n.1781 .35275 L\n.18 .35555 L\n.1819 .35817 L\n.18381 .3606 L\n.18571 .36285 L\n.18762 .36492 L\n.18952 .3668 L\n.19143 .36849 L\n.19333 .37 L\n.19524 .37132 L\n.19714 .37246 L\nMistroke\n.19905 .37341 L\n.20095 .37418 L\n.20286 .37476 L\n.20476 .37516 L\n.20667 .37537 L\n.20857 .3754 L\n.21048 .37524 L\n.21238 .3749 L\n.21429 .37437 L\n.21619 .37366 L\n.2181 .37276 L\n.22 .37167 L\n.2219 .37041 L\n.22381 .36895 L\n.22571 .36731 L\n.22762 .36549 L\n.22952 .36348 L\n.23143 .36129 L\n.23333 .35891 L\n.23524 .35634 L\n.23714 .35359 L\n.23905 .35066 L\n.24095 .34754 L\n.24286 .34423 L\n.24476 .34074 L\n.24667 .33706 L\n.24857 .3332 L\n.2492 .33188 L\n.2492 .33188 L\n.2492 .33188 L\n.2492 .33188 L\n.25048 .33425 L\n.25238 .33765 L\n.25429 .34086 L\n.25619 .34389 L\n.2581 .34673 L\n.26 .34938 L\n.2619 .35186 L\n.26381 .35414 L\n.26571 .35624 L\n.26762 .35816 L\n.26952 .35989 L\n.27143 .36144 L\n.27333 .3628 L\n.27524 .36397 L\n.27714 .36496 L\n.27905 .36577 L\n.28095 .36639 L\n.28286 .36682 L\n.28476 .36707 L\nMistroke\n.28667 .36714 L\n.28857 .36702 L\n.29048 .36671 L\n.29238 .36622 L\n.29429 .36555 L\n.29619 .36468 L\n.2981 .36364 L\n.3 .36241 L\n.3019 .36099 L\n.30381 .35939 L\n.30571 .3576 L\n.30762 .35563 L\n.30952 .35347 L\n.31143 .35113 L\n.31333 .3486 L\n.31524 .34589 L\n.31714 .34299 L\n.31905 .33991 L\n.32095 .33664 L\n.32286 .33319 L\n.32355 .33188 L\n.32355 .33188 L\n.32355 .33188 L\n.32355 .33188 L\n.32476 .3339 L\n.32667 .33695 L\n.32857 .3398 L\n.33048 .34247 L\n.33238 .34496 L\n.33429 .34726 L\n.33619 .34938 L\n.3381 .35131 L\n.34 .35306 L\n.3419 .35462 L\n.34381 .35599 L\n.34571 .35718 L\n.34762 .35819 L\n.34952 .35901 L\n.35143 .35964 L\n.35333 .3601 L\n.35524 .36036 L\n.35714 .36044 L\n.35905 .36033 L\n.36095 .36004 L\n.36286 .35957 L\n.36476 .35891 L\n.36667 .35806 L\n.36857 .35703 L\n.37048 .35581 L\n.37238 .35441 L\nMistroke\n.37429 .35283 L\n.37619 .35106 L\n.3781 .3491 L\n.38 .34696 L\n.3819 .34463 L\n.38381 .34212 L\n.38571 .33942 L\n.38762 .33654 L\n.38952 .33347 L\n.39047 .33188 L\n.39047 .33188 L\n.39047 .33188 L\n.39047 .33188 L\n.39143 .33333 L\n.39333 .33607 L\n.39524 .33863 L\n.39714 .341 L\n.39905 .34318 L\n.40095 .34518 L\n.40286 .347 L\n.40476 .34863 L\n.40667 .35007 L\n.40857 .35133 L\n.41048 .35241 L\n.41238 .3533 L\n.41429 .354 L\n.41619 .35452 L\n.4181 .35486 L\n.42 .35501 L\n.4219 .35497 L\n.42381 .35475 L\n.42571 .35434 L\n.42762 .35375 L\n.42952 .35297 L\n.43143 .35201 L\n.43333 .35086 L\n.43524 .34953 L\n.43714 .34802 L\n.43905 .34631 L\n.44095 .34443 L\n.44286 .34235 L\n.44476 .34009 L\n.44667 .33765 L\n.44857 .33502 L\n.45048 .33221 L\n.45069 .33188 L\n.45069 .33188 L\n.45069 .33188 L\n.45069 .33188 L\n.45238 .33414 L\nMistroke\n.45429 .33652 L\n.45619 .33871 L\n.4581 .34072 L\n.46 .34254 L\n.4619 .34418 L\n.46381 .34563 L\n.46571 .3469 L\n.46762 .34798 L\n.46952 .34887 L\n.47143 .34958 L\n.47333 .35011 L\n.47524 .35045 L\n.47714 .35061 L\n.47905 .35058 L\n.48095 .35036 L\n.48286 .34996 L\n.48476 .34938 L\n.48667 .34861 L\n.48857 .34765 L\n.49048 .34651 L\n.49238 .34519 L\n.49429 .34368 L\n.49619 .34198 L\n.4981 .3401 L\n.5 .33804 L\n.5019 .33578 L\n.50381 .33335 L\n.50489 .33188 L\n.50489 .33188 L\n.50489 .33188 L\n.50489 .33188 L\n.50571 .33288 L\n.50762 .33508 L\n.50952 .33709 L\n.51143 .33892 L\n.51333 .34057 L\n.51524 .34202 L\n.51714 .3433 L\n.51905 .34438 L\n.52095 .34529 L\n.52286 .346 L\n.52476 .34654 L\n.52667 .34688 L\n.52857 .34704 L\n.53048 .34702 L\n.53238 .34681 L\n.53429 .34642 L\n.53619 .34584 L\n.5381 .34508 L\n.54 .34413 L\nMistroke\n.5419 .34299 L\n.54381 .34167 L\n.54571 .34017 L\n.54762 .33848 L\n.54952 .33661 L\n.55143 .33455 L\n.55333 .3323 L\n.55367 .33188 L\n.55367 .33188 L\n.55367 .33188 L\n.55367 .33188 L\n.55524 .33357 L\n.55714 .33546 L\n.55905 .33716 L\n.56095 .33868 L\n.56286 .34001 L\n.56476 .34116 L\n.56667 .34213 L\n.56857 .3429 L\n.57048 .3435 L\n.57238 .3439 L\n.57429 .34413 L\n.57619 .34417 L\n.5781 .34402 L\n.58 .34369 L\n.5819 .34317 L\n.58381 .34246 L\n.58571 .34158 L\n.58762 .3405 L\n.58952 .33925 L\n.59143 .3378 L\n.59333 .33617 L\n.59524 .33436 L\n.59714 .33236 L\n.59758 .33188 L\n.59758 .33188 L\n.59758 .33188 L\n.59758 .33188 L\n.59905 .33331 L\n.60095 .33499 L\n.60286 .33649 L\n.60476 .3378 L\n.60667 .33893 L\n.60857 .33988 L\n.61048 .34064 L\n.61238 .34121 L\n.61429 .3416 L\n.61619 .3418 L\n.6181 .34182 L\n.62 .34166 L\nMistroke\n.6219 .3413 L\n.62381 .34077 L\n.62571 .34005 L\n.62762 .33914 L\n.62952 .33805 L\n.63143 .33677 L\n.63333 .33531 L\n.63524 .33366 L\n.63709 .33188 L\n.63709 .33188 L\n.63709 .33188 L\n.63709 .33188 L\n.63714 .33193 L\n.63905 .33356 L\n.64095 .335 L\n.64286 .33626 L\n.64476 .33734 L\n.64667 .33823 L\n.64857 .33893 L\n.65048 .33945 L\n.65238 .33979 L\n.65429 .33994 L\n.65619 .3399 L\n.6581 .33968 L\n.66 .33927 L\n.6619 .33868 L\n.66381 .33791 L\n.66571 .33695 L\n.66762 .3358 L\n.66952 .33447 L\n.67143 .33295 L\n.67265 .33188 L\n.67265 .33188 L\n.67265 .33188 L\n.67265 .33188 L\n.67333 .33242 L\n.67524 .33382 L\n.67714 .33503 L\n.67905 .33606 L\n.68095 .3369 L\n.68286 .33756 L\n.68476 .33803 L\n.68667 .33831 L\n.68857 .33841 L\n.69048 .33833 L\n.69238 .33806 L\n.69429 .3376 L\n.69619 .33696 L\n.6981 .33614 L\n.7 .33513 L\nMistroke\n.7019 .33393 L\n.70381 .33255 L\n.70466 .33188 L\n.70466 .33188 L\n.70466 .33188 L\n.70466 .33188 L\n.70571 .33263 L\n.70762 .33383 L\n.70952 .33485 L\n.71143 .33569 L\n.71333 .33633 L\n.71524 .3368 L\n.71714 .33708 L\n.71905 .33717 L\n.72095 .33708 L\n.72286 .3368 L\n.72476 .33634 L\n.72667 .33569 L\n.72857 .33486 L\n.73048 .33385 L\n.73238 .33264 L\n.73346 .33188 L\n.73346 .33188 L\n.73346 .33188 L\n.73346 .33188 L\n.73429 .33241 L\n.73619 .33349 L\n.7381 .3344 L\n.74 .33511 L\n.7419 .33564 L\n.74381 .33599 L\n.74571 .33615 L\n.74762 .33613 L\n.74952 .33592 L\n.75143 .33553 L\n.75333 .33495 L\n.75524 .33418 L\n.75714 .33323 L\n.75905 .3321 L\n.75939 .33188 L\n.75939 .33188 L\n.75939 .33188 L\n.75939 .33188 L\n.76095 .33275 L\n.76286 .33364 L\n.76476 .33434 L\n.76667 .33486 L\n.76857 .33519 L\n.77048 .33534 L\n.77238 .33531 L\nMistroke\n.77429 .33508 L\n.77619 .33468 L\n.7781 .33409 L\n.78 .33331 L\n.7819 .33235 L\n.78272 .33188 L\n.78272 .33188 L\n.78272 .33188 L\n.78272 .33188 L\n.78381 .33243 L\n.78571 .33326 L\n.78762 .33389 L\n.78952 .33434 L\n.79143 .33461 L\n.79333 .33469 L\n.79524 .33459 L\n.79714 .3343 L\n.79905 .33382 L\n.80095 .33316 L\n.80286 .33232 L\n.80372 .33188 L\n.80372 .33188 L\n.80372 .33188 L\n.80372 .33188 L\n.80476 .33236 L\n.80667 .33308 L\n.80857 .33362 L\n.81048 .33397 L\n.81238 .33414 L\n.81429 .33412 L\n.81619 .33392 L\n.8181 .33354 L\n.82 .33297 L\n.8219 .33221 L\n.82261 .33188 L\n.82261 .33188 L\n.82261 .33188 L\n.82261 .33188 L\n.82381 .33236 L\n.82571 .33298 L\n.82762 .33341 L\n.82952 .33366 L\n.83143 .33372 L\n.83333 .3336 L\n.83524 .33329 L\n.83714 .3328 L\n.83905 .33212 L\n.83962 .33188 L\n.83962 .33188 L\n.83962 .33188 L\nMistroke\n.83962 .33188 L\n.84095 .33235 L\n.84286 .33288 L\n.84476 .33321 L\n.84667 .33336 L\n.84857 .33333 L\n.85048 .33311 L\n.85238 .33271 L\n.85429 .33212 L\n.85493 .33188 L\n.85493 .33188 L\n.85493 .33188 L\n.85493 .33188 L\n.85619 .33228 L\n.8581 .33274 L\n.86 .33301 L\n.8619 .33309 L\n.86381 .33299 L\n.86571 .3327 L\n.86762 .33223 L\n.86871 .33188 L\n.86871 .33188 L\n.86871 .33188 L\n.86871 .33188 L\n.86952 .33212 L\n.87143 .33255 L\n.87333 .3328 L\n.87524 .33286 L\n.87714 .33273 L\n.87905 .33242 L\n.88095 .33193 L\n.88111 .33188 L\n.88111 .33188 L\n.88111 .33188 L\n.88111 .33188 L\n.88286 .3323 L\n.88476 .33258 L\n.88667 .33267 L\n.88857 .33258 L\n.89048 .33231 L\n.89227 .33188 L\n.89227 .33188 L\n.89227 .33188 L\n.89227 .33188 L\n.89238 .33191 L\n.89429 .33229 L\n.89619 .33249 L\n.8981 .33251 L\n.9 .33233 L\n.9019 .33198 L\nMistroke\n.90231 .33188 L\n.90231 .33188 L\n.90231 .33188 L\n.90231 .33188 L\n.90381 .33217 L\n.90571 .33237 L\n.90762 .33238 L\n.90952 .33221 L\n.91135 .33188 L\n.91135 .33188 L\n.91135 .33188 L\n.91135 .33188 L\n.91143 .33189 L\n.91333 .33219 L\n.91524 .3323 L\n.91714 .33223 L\n.91905 .33196 L\n.91949 .33188 L\n.91949 .33188 L\n.91949 .33188 L\n.91949 .33188 L\n.92095 .3321 L\n.92286 .33222 L\n.92476 .33215 L\n.92667 .3319 L\n.92681 .33188 L\n.92681 .33188 L\n.92681 .33188 L\n.92681 .33188 L\n.92857 .3321 L\n.93048 .33215 L\n.93238 .33202 L\n.9334 .33188 L\n.9334 .33188 L\n.9334 .33188 L\n.9334 .33188 L\n.93429 .33199 L\n.93619 .3321 L\n.9381 .33203 L\n.93933 .33188 L\n.93933 .33188 L\n.93933 .33188 L\n.93933 .33188 L\n.94 .33196 L\n.9419 .33206 L\n.94381 .33198 L\n.94466 .33188 L\n.94466 .33188 L\n.94466 .33188 L\n.94466 .33188 L\nMistroke\n.94571 .33198 L\n.94762 .33202 L\n.94947 .33188 L\n.94947 .33188 L\n.94947 .33188 L\n.94947 .33188 L\n.94952 .33188 L\n.95143 .332 L\n.95333 .33192 L\n.95379 .33188 L\n.95379 .33188 L\n.95379 .33188 L\n.95379 .33188 L\n.95524 .33197 L\n.95714 .33192 L\n.95768 .33188 L\n.95768 .33188 L\n.95768 .33188 L\n.95768 .33188 L\n.95905 .33195 L\n.96095 .3319 L\n.96118 .33188 L\n.96118 .33188 L\n.96118 .33188 L\n.96118 .33188 L\n.96286 .33194 L\n.96434 .33188 L\n.96434 .33188 L\n.96434 .33188 L\n.96434 .33188 L\n.96476 .3319 L\n.96667 .33191 L\n.96717 .33188 L\n.96717 .33188 L\n.96717 .33188 L\n.96717 .33188 L\n.96857 .33192 L\n.96973 .33188 L\n.96973 .33188 L\n.96973 .33188 L\n.96973 .33188 L\n.97048 .33191 L\n.97202 .33188 L\n.97202 .33188 L\n.97202 .33188 L\n.97202 .33188 L\n.97238 .33189 L\n.97409 .33188 L\n.97409 .33188 L\n.97409 .33188 L\nMistroke\n.97409 .33188 L\n.97429 .33189 L\n.97595 .33188 L\n.97595 .33188 L\n.97595 .33188 L\n.97595 .33188 L\n.97619 .33189 L\nMfstroke\n0 .5 0 r\n.02381 .32451 m\n.02571 .31294 L\n.02762 .30136 L\n.02952 .28979 L\n.03143 .27822 L\n.03333 .26665 L\n.03524 .25508 L\n.03714 .24351 L\n.03905 .23193 L\n.04095 .22036 L\n.04286 .20879 L\n.04476 .19722 L\n.04667 .18565 L\n.04857 .17408 L\n.05048 .16251 L\n.05238 .15093 L\n.05429 .13936 L\n.05619 .12779 L\n.0581 .11622 L\n.06 .10465 L\n.0619 .09308 L\n.06381 .08151 L\n.06571 .06993 L\n.06762 .05836 L\n.06952 .04679 L\n.07143 .03522 L\n.07333 .02365 L\n.0748 .01472 L\n.0748 .60332 L\n.0748 .60332 L\n.0748 .60332 L\n.07524 .60068 L\n.07714 .58911 L\n.07905 .57754 L\n.08095 .56597 L\n.08286 .5544 L\n.08476 .54282 L\n.08667 .53125 L\n.08857 .51968 L\n.09048 .50811 L\n.09238 .49654 L\n.09429 .48497 L\n.09619 .4734 L\n.0981 .46182 L\n.1 .45025 L\n.1019 .43868 L\n.10381 .42711 L\n.10571 .41554 L\n.10762 .40397 L\n.10952 .3924 L\nMistroke\n.11143 .38082 L\n.11333 .36925 L\n.11524 .35768 L\n.11714 .34611 L\n.11905 .33454 L\n.12095 .32297 L\n.12286 .3114 L\n.12476 .29982 L\n.12667 .28825 L\n.12857 .27668 L\n.13048 .26511 L\n.13238 .25354 L\n.13429 .24197 L\n.13619 .23039 L\n.1381 .21882 L\n.14 .20725 L\n.1419 .19568 L\n.14381 .18411 L\n.14571 .17254 L\n.14762 .16097 L\n.14952 .14939 L\n.15143 .13782 L\n.15333 .12625 L\n.15524 .11468 L\n.15714 .10311 L\n.15905 .09154 L\n.16095 .07997 L\n.16286 .06839 L\n.16476 .05682 L\n.16659 .04569 L\n.16659 .57544 L\n.16659 .57544 L\n.16659 .57544 L\n.16667 .575 L\n.16857 .56342 L\n.17048 .55185 L\n.17238 .54028 L\n.17429 .52871 L\n.17619 .51714 L\n.1781 .50557 L\n.18 .494 L\n.1819 .48242 L\n.18381 .47085 L\n.18571 .45928 L\n.18762 .44771 L\n.18952 .43614 L\n.19143 .42457 L\n.19333 .41299 L\n.19524 .40142 L\n.19714 .38985 L\nMistroke\n.19905 .37828 L\n.20095 .36671 L\n.20286 .35514 L\n.20476 .34357 L\n.20667 .33199 L\n.20857 .32042 L\n.21048 .30885 L\n.21238 .29728 L\n.21429 .28571 L\n.21619 .27414 L\n.2181 .26257 L\n.22 .25099 L\n.2219 .23942 L\n.22381 .22785 L\n.22571 .21628 L\n.22762 .20471 L\n.22952 .19314 L\n.23143 .18157 L\n.23333 .16999 L\n.23524 .15842 L\n.23714 .14685 L\n.23905 .13528 L\n.24095 .12371 L\n.24286 .11214 L\n.24476 .10057 L\n.24667 .08899 L\n.24857 .07742 L\n.2492 .07358 L\n.2492 .55034 L\n.2492 .55034 L\n.2492 .55034 L\n.25048 .54262 L\n.25238 .53105 L\n.25429 .51948 L\n.25619 .50791 L\n.2581 .49633 L\n.26 .48476 L\n.2619 .47319 L\n.26381 .46162 L\n.26571 .45005 L\n.26762 .43848 L\n.26952 .42691 L\n.27143 .41533 L\n.27333 .40376 L\n.27524 .39219 L\n.27714 .38062 L\n.27905 .36905 L\n.28095 .35748 L\n.28286 .34591 L\n.28476 .33433 L\nMistroke\n.28667 .32276 L\n.28857 .31119 L\n.29048 .29962 L\n.29238 .28805 L\n.29429 .27648 L\n.29619 .26491 L\n.2981 .25333 L\n.3 .24176 L\n.3019 .23019 L\n.30381 .21862 L\n.30571 .20705 L\n.30762 .19548 L\n.30952 .18391 L\n.31143 .17233 L\n.31333 .16076 L\n.31524 .14919 L\n.31714 .13762 L\n.31905 .12605 L\n.32095 .11448 L\n.32286 .10291 L\n.32355 .09867 L\n.32355 .52776 L\n.32355 .52776 L\n.32355 .52776 L\n.32476 .52043 L\n.32667 .50885 L\n.32857 .49728 L\n.33048 .48571 L\n.33238 .47414 L\n.33429 .46257 L\n.33619 .451 L\n.3381 .43943 L\n.34 .42785 L\n.3419 .41628 L\n.34381 .40471 L\n.34571 .39314 L\n.34762 .38157 L\n.34952 .37 L\n.35143 .35843 L\n.35333 .34685 L\n.35524 .33528 L\n.35714 .32371 L\n.35905 .31214 L\n.36095 .30057 L\n.36286 .289 L\n.36476 .27743 L\n.36667 .26585 L\n.36857 .25428 L\n.37048 .24271 L\n.37238 .23114 L\nMistroke\n.37429 .21957 L\n.37619 .208 L\n.3781 .19643 L\n.38 .18485 L\n.3819 .17328 L\n.38381 .16171 L\n.38571 .15014 L\n.38762 .13857 L\n.38952 .127 L\n.39047 .12125 L\n.39047 .50744 L\n.39047 .50744 L\n.39047 .50744 L\n.39143 .50161 L\n.39333 .49004 L\n.39524 .47847 L\n.39714 .46689 L\n.39905 .45532 L\n.40095 .44375 L\n.40286 .43218 L\n.40476 .42061 L\n.40667 .40904 L\n.40857 .39747 L\n.41048 .38589 L\n.41238 .37432 L\n.41429 .36275 L\n.41619 .35118 L\n.4181 .33961 L\n.42 .32804 L\n.4219 .31647 L\n.42381 .30489 L\n.42571 .29332 L\n.42762 .28175 L\n.42952 .27018 L\n.43143 .25861 L\n.43333 .24704 L\n.43524 .23547 L\n.43714 .22389 L\n.43905 .21232 L\n.44095 .20075 L\n.44286 .18918 L\n.44476 .17761 L\n.44667 .16604 L\n.44857 .15447 L\n.45048 .14289 L\n.45069 .14158 L\n.45069 .48914 L\n.45069 .48914 L\n.45069 .48914 L\n.45238 .47889 L\nMistroke\n.45429 .46732 L\n.45619 .45574 L\n.4581 .44417 L\n.46 .4326 L\n.4619 .42103 L\n.46381 .40946 L\n.46571 .39789 L\n.46762 .38632 L\n.46952 .37474 L\n.47143 .36317 L\n.47333 .3516 L\n.47524 .34003 L\n.47714 .32846 L\n.47905 .31689 L\n.48095 .30532 L\n.48286 .29374 L\n.48476 .28217 L\n.48667 .2706 L\n.48857 .25903 L\n.49048 .24746 L\n.49238 .23589 L\n.49429 .22432 L\n.49619 .21274 L\n.4981 .20117 L\n.5 .1896 L\n.5019 .17803 L\n.50381 .16646 L\n.50489 .15987 L\n.50489 .47268 L\n.50489 .47268 L\n.50489 .47268 L\n.50571 .46769 L\n.50762 .45612 L\n.50952 .44455 L\n.51143 .43298 L\n.51333 .42141 L\n.51524 .40984 L\n.51714 .39827 L\n.51905 .38669 L\n.52095 .37512 L\n.52286 .36355 L\n.52476 .35198 L\n.52667 .34041 L\n.52857 .32884 L\n.53048 .31727 L\n.53238 .30569 L\n.53429 .29412 L\n.53619 .28255 L\n.5381 .27098 L\n.54 .25941 L\nMistroke\n.5419 .24784 L\n.54381 .23627 L\n.54571 .22469 L\n.54762 .21312 L\n.54952 .20155 L\n.55143 .18998 L\n.55333 .17841 L\n.55367 .17633 L\n.55367 .45786 L\n.55367 .45786 L\n.55367 .45786 L\n.55524 .44836 L\n.55714 .43679 L\n.55905 .42522 L\n.56095 .41365 L\n.56286 .40208 L\n.56476 .39051 L\n.56667 .37894 L\n.56857 .36736 L\n.57048 .35579 L\n.57238 .34422 L\n.57429 .33265 L\n.57619 .32108 L\n.5781 .30951 L\n.58 .29794 L\n.5819 .28636 L\n.58381 .27479 L\n.58571 .26322 L\n.58762 .25165 L\n.58952 .24008 L\n.59143 .22851 L\n.59333 .21694 L\n.59524 .20536 L\n.59714 .19379 L\n.59758 .19115 L\n.59758 .44453 L\n.59758 .44453 L\n.59758 .44453 L\n.59905 .4356 L\n.60095 .42402 L\n.60286 .41245 L\n.60476 .40088 L\n.60667 .38931 L\n.60857 .37774 L\n.61048 .36617 L\n.61238 .3546 L\n.61429 .34302 L\n.61619 .33145 L\n.6181 .31988 L\n.62 .30831 L\nMistroke\n.6219 .29674 L\n.62381 .28517 L\n.62571 .2736 L\n.62762 .26202 L\n.62952 .25045 L\n.63143 .23888 L\n.63333 .22731 L\n.63524 .21574 L\n.63709 .20449 L\n.63709 .43252 L\n.63709 .43252 L\n.63709 .43252 L\n.63714 .4322 L\n.63905 .42063 L\n.64095 .40906 L\n.64286 .39749 L\n.64476 .38592 L\n.64667 .37435 L\n.64857 .36277 L\n.65048 .3512 L\n.65238 .33963 L\n.65429 .32806 L\n.65619 .31649 L\n.6581 .30492 L\n.66 .29335 L\n.6619 .28177 L\n.66381 .2702 L\n.66571 .25863 L\n.66762 .24706 L\n.66952 .23549 L\n.67143 .22392 L\n.67265 .21649 L\n.67265 .42172 L\n.67265 .42172 L\n.67265 .42172 L\n.67333 .41758 L\n.67524 .40601 L\n.67714 .39444 L\n.67905 .38287 L\n.68095 .37129 L\n.68286 .35972 L\n.68476 .34815 L\n.68667 .33658 L\n.68857 .32501 L\n.69048 .31344 L\n.69238 .30187 L\n.69429 .29029 L\n.69619 .27872 L\n.6981 .26715 L\n.7 .25558 L\nMistroke\n.7019 .24401 L\n.70381 .23244 L\n.70466 .22729 L\n.70466 .412 L\n.70466 .412 L\n.70466 .412 L\n.70571 .40557 L\n.70762 .394 L\n.70952 .38243 L\n.71143 .37086 L\n.71333 .35929 L\n.71524 .34772 L\n.71714 .33615 L\n.71905 .32457 L\n.72095 .313 L\n.72286 .30143 L\n.72476 .28986 L\n.72667 .27829 L\n.72857 .26672 L\n.73048 .25515 L\n.73238 .24357 L\n.73346 .23701 L\n.73346 .40325 L\n.73346 .40325 L\n.73346 .40325 L\n.73429 .39824 L\n.73619 .38667 L\n.7381 .3751 L\n.74 .36353 L\n.7419 .35196 L\n.74381 .34038 L\n.74571 .32881 L\n.74762 .31724 L\n.74952 .30567 L\n.75143 .2941 L\n.75333 .28253 L\n.75524 .27096 L\n.75714 .25938 L\n.75905 .24781 L\n.75939 .24576 L\n.75939 .39538 L\n.75939 .39538 L\n.75939 .39538 L\n.76095 .38586 L\n.76286 .37429 L\n.76476 .36271 L\n.76667 .35114 L\n.76857 .33957 L\n.77048 .328 L\n.77238 .31643 L\nMistroke\n.77429 .30486 L\n.77619 .29329 L\n.7781 .28171 L\n.78 .27014 L\n.7819 .25857 L\n.78272 .25364 L\n.78272 .38829 L\n.78272 .38829 L\n.78272 .38829 L\n.78381 .38165 L\n.78571 .37008 L\n.78762 .35851 L\n.78952 .34694 L\n.79143 .33537 L\n.79333 .3238 L\n.79524 .31222 L\n.79714 .30065 L\n.79905 .28908 L\n.80095 .27751 L\n.80286 .26594 L\n.80372 .26072 L\n.80372 .38191 L\n.80372 .38191 L\n.80372 .38191 L\n.80476 .37556 L\n.80667 .36398 L\n.80857 .35241 L\n.81048 .34084 L\n.81238 .32927 L\n.81429 .3177 L\n.81619 .30613 L\n.8181 .29456 L\n.82 .28298 L\n.8219 .27141 L\n.82261 .2671 L\n.82261 .37617 L\n.82261 .37617 L\n.82261 .37617 L\n.82381 .36891 L\n.82571 .35734 L\n.82762 .34577 L\n.82952 .3342 L\n.83143 .32262 L\n.83333 .31105 L\n.83524 .29948 L\n.83714 .28791 L\n.83905 .27634 L\n.83962 .27284 L\n.83962 .371 L\n.83962 .371 L\nMistroke\n.83962 .371 L\n.84095 .36293 L\n.84286 .35136 L\n.84476 .33979 L\n.84667 .32822 L\n.84857 .31664 L\n.85048 .30507 L\n.85238 .2935 L\n.85429 .28193 L\n.85493 .27801 L\n.85493 .36635 L\n.85493 .36635 L\n.85493 .36635 L\n.85619 .3587 L\n.8581 .34713 L\n.86 .33556 L\n.8619 .32399 L\n.86381 .31242 L\n.86571 .30085 L\n.86762 .28928 L\n.86871 .28266 L\n.86871 .36217 L\n.86871 .36217 L\n.86871 .36217 L\n.86952 .35722 L\n.87143 .34564 L\n.87333 .33407 L\n.87524 .3225 L\n.87714 .31093 L\n.87905 .29936 L\n.88095 .28779 L\n.88111 .28684 L\n.88111 .3584 L\n.88111 .3584 L\n.88111 .3584 L\n.88286 .34778 L\n.88476 .3362 L\n.88667 .32463 L\n.88857 .31306 L\n.89048 .30149 L\n.89227 .29061 L\n.89227 .35501 L\n.89227 .35501 L\n.89227 .35501 L\n.89238 .35432 L\n.89429 .34275 L\n.89619 .33118 L\n.8981 .31961 L\n.9 .30804 L\n.9019 .29647 L\nMistroke\n.90231 .294 L\n.90231 .35196 L\n.90231 .35196 L\n.90231 .35196 L\n.90381 .34286 L\n.90571 .33129 L\n.90762 .31972 L\n.90952 .30814 L\n.91135 .29705 L\n.91135 .34922 L\n.91135 .34922 L\n.91135 .34922 L\n.91143 .34874 L\n.91333 .33717 L\n.91524 .3256 L\n.91714 .31403 L\n.91905 .30245 L\n.91949 .2998 L\n.91949 .34675 L\n.91949 .34675 L\n.91949 .34675 L\n.92095 .33783 L\n.92286 .32626 L\n.92476 .31469 L\n.92667 .30312 L\n.92681 .30227 L\n.92681 .34452 L\n.92681 .34452 L\n.92681 .34452 L\n.92857 .3338 L\n.93048 .32223 L\n.93238 .31066 L\n.9334 .30449 L\n.9334 .34252 L\n.9334 .34252 L\n.9334 .34252 L\n.93429 .33712 L\n.93619 .32555 L\n.9381 .31398 L\n.93933 .30649 L\n.93933 .34072 L\n.93933 .34072 L\n.93933 .34072 L\n.94 .33663 L\n.9419 .32506 L\n.94381 .31349 L\n.94466 .30829 L\n.94466 .3391 L\n.94466 .3391 L\n.94466 .3391 L\nMistroke\n.94571 .33272 L\n.94762 .32115 L\n.94947 .30992 L\n.94947 .33764 L\n.94947 .33764 L\n.94947 .33764 L\n.94952 .3373 L\n.95143 .32573 L\n.95333 .31416 L\n.95379 .31137 L\n.95379 .33633 L\n.95379 .33633 L\n.95379 .33633 L\n.95524 .32754 L\n.95714 .31597 L\n.95768 .31269 L\n.95768 .33514 L\n.95768 .33514 L\n.95768 .33514 L\n.95905 .32685 L\n.96095 .31528 L\n.96118 .31387 L\n.96118 .33408 L\n.96118 .33408 L\n.96118 .33408 L\n.96286 .32392 L\n.96434 .31493 L\n.96434 .33312 L\n.96434 .33312 L\n.96434 .33312 L\n.96476 .33054 L\n.96667 .31897 L\n.96717 .31589 L\n.96717 .33226 L\n.96717 .33226 L\n.96717 .33226 L\n.96857 .32376 L\n.96973 .31675 L\n.96973 .33149 L\n.96973 .33149 L\n.96973 .33149 L\n.97048 .32693 L\n.97202 .31753 L\n.97202 .33079 L\n.97202 .33079 L\n.97202 .33079 L\n.97238 .32861 L\n.97409 .31823 L\n.97409 .33016 L\n.97409 .33016 L\nMistroke\n.97409 .33016 L\n.97429 .32898 L\n.97595 .31885 L\n.97595 .32959 L\n.97595 .32959 L\n.97595 .32959 L\n.97619 .32815 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(velocity) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(@) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n123.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(height) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI\n000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0o`3IfMT8\n0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WIf@P0fMWI000F0=WIf@030000003IfMT0fMWI00T0\nfMWI00<007l00=WIf@3IfMT0n`3IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI\n0=WIf@3k0=WIf@00403IfMT3000000<0fMWI00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WI\nf@3k0=WIf@004@3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00T0fMWI00<007l0\n0=WIf@3IfMT0n`3IfMT000h0fMWI1@0000030=WIf@8000002@3IfMT2001o0?d0fMWI00080=WIf@@0\n00000P3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00P0fMWI0P00O`3m0=WI\nf@003`3IfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI00P0fMWI0P00O`3m0=WIf@00\n403IfMT2000000@0fMWI00<000000=WIf@3IfMT0203IfMT2001o0?d0fMWI000F0=WIf@030000003I\nfMT0fMWI00P0fMWI0P00O`0F0=WIf@03001o003IfMT0fMWI0>@0fMWI000F0=WIf@030000003IfMT0\nfMWI00P0fMWI0P00O`0E0=WIf@8007l0iP3IfMT001H0fMWI00<000000=WIf@3IfMT01`3IfMT00`00\nO`00fMWI001o000E0=WIf@8007l0iP3IfMT001H0fMWI00<000000=WIf@3IfMT01`3IfMT00`00O`00\nfMWI001o000E0=WIf@8007l0iP3IfMT001H0fMWI00<000000=WIf@3IfMT01`3IfMT00`00O`00fMWI\n001o000E0=WIf@8007l0iP3IfMT001H0fMWI0P0000080=WIf@03001o003IfMT007l001D0fMWI0P00\nO`3V0=WIf@005P3IfMT00`000000fMWI0=WIf@070=WIf@03001o003IfMT007l001D0fMWI0P00O`0C\n0=WIf@03001o003IfMT0fMWI0=00fMWI000F0=WIf@030000003IfMT0fMWI00H0fMWI00@007l00=WI\nf@3IfMT007l05@3IfMT2001o01<0fMWI00<007l00=WIf@3IfMT0d03IfMT001H0fMWI00<000000=WI\nf@3IfMT01P3IfMT01000O`00fMWI0=WIf@00O`0E0=WIf@8007l04`3IfMT00`00O`00fMWI0=WIf@3@\n0=WIf@005P3IfMT00`000000fMWI0=WIf@060=WIf@04001o003IfMT0fMWI001o01D0fMWI0P00O`0C\n0=WIf@03001o003IfMT0fMWI0=00fMWI000F0=WIf@030000003IfMT0fMWI00H0fMWI00@007l00=WI\nf@3IfMT007l0503IfMT00`00O`00fMWI001o000C0=WIf@03001o003IfMT0fMWI0=00fMWI000F0=WI\nf@030000003IfMT0fMWI00H0fMWI00@007l00=WIf@3IfMT007l0503IfMT00`00O`00fMWI001o000C\n0=WIf@03001o003IfMT0fMWI0=00fMWI000F0=WIf@030000003IfMT0fMWI00H0fMWI00@007l00=WI\nf@3IfMT007l0503IfMT00`00O`00fMWI001o000B0=WIf@8007l0dP3IfMT001H0fMWI00<000000=WI\nf@3IfMT01P3IfMT01000O`00fMWI0=WIf@00O`0D0=WIf@03001o003IfMT007l00180fMWI0P00O`0B\n0=WIf@03001o003IfMT0fMWI0;d0fMWI000F0=WIf@8000001`3IfMT01000O`00fMWI0=WIf@00O`0D\n0=WIf@03001o003IfMT007l00180fMWI0P00O`0B0=WIf@03001o003IfMT0fMWI0;d0fMWI000F0=WI\nf@030000003IfMT0fMWI00H0fMWI00@007l00=WIf@3IfMT007l0503IfMT00`00O`00fMWI001o000B\n0=WIf@8007l04P3IfMT00`00O`00fMWI0=WIf@2m0=WIf@005P3IfMT00`000000fMWI0=WIf@050=WI\nf@05001o003IfMT0fMWI0=WIf@00O`004`3IfMT01000O`00fMWI0=WIf@00O`0B0=WIf@8007l04@3I\nfMT2001o0;l0fMWI000F0=WIf@030000003IfMT0fMWI00D0fMWI00D007l00=WIf@3IfMT0fMWI001o\n000C0=WIf@04001o003IfMT0fMWI001o0180fMWI0P00O`0A0=WIf@8007l0_`3IfMT001H0fMWI00<0\n00000=WIf@3IfMT01@3IfMT01@00O`00fMWI0=WIf@3IfMT007l001<0fMWI00@007l00=WIf@3IfMT0\n07l04@3IfMT00`00O`00fMWI001o000A0=WIf@8007l03`3IfMT00`00O`00fMWI0=WIf@2]0=WIf@00\n5P3IfMT00`000000fMWI0=WIf@050=WIf@05001o003IfMT0fMWI0=WIf@00O`004`3IfMT01000O`00\nfMWI0=WIf@00O`0A0=WIf@03001o003IfMT007l00140fMWI0P00O`0?0=WIf@03001o003IfMT0fMWI\n0:d0fMWI000F0=WIf@030000003IfMT0fMWI00D0fMWI00D007l00=WIf@3IfMT0fMWI001o000C0=WI\nf@04001o003IfMT0fMWI001o0140fMWI00<007l00=WIf@00O`004@3IfMT2001o00l0fMWI00<007l0\n0=WIf@3IfMT0[@3IfMT001H0fMWI00<000000=WIf@3IfMT01@3IfMT01@00O`00fMWI0=WIf@3IfMT0\n07l00180fMWI00D007l00=WIf@3IfMT0fMWI001o000A0=WIf@03001o003IfMT007l00100fMWI00<0\n07l00=WIf@00O`003`3IfMT00`00O`00fMWI0=WIf@2]0=WIf@005P3IfMT00`000000fMWI0=WIf@04\n0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0403IfMT01@00O`00fMWI0=WIf@3I\nfMT007l00140fMWI00<007l00=WIf@00O`00403IfMT00`00O`00fMWI001o000?0=WIf@03001o003I\nfMT0fMWI0:d0fMWI000F0=WIf@8000001@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0\nfMWI0100fMWI00D007l00=WIf@3IfMT0fMWI001o000A0=WIf@03001o003IfMT007l00100fMWI00<0\n07l00=WIf@00O`003`3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI09h0fMWI000F\n0=WIf@030000003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0@\n0=WIf@05001o003IfMT0fMWI0=WIf@00O`00403IfMT01000O`00fMWI0=WIf@00O`0@0=WIf@03001o\n003IfMT007l000h0fMWI0P00O`0>0=WIf@03001o003IfMT0fMWI09h0fMWI000F0=WIf@030000003I\nfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0@0=WIf@05001o003I\nfMT0fMWI0=WIf@00O`00403IfMT01000O`00fMWI0=WIf@00O`0@0=WIf@03001o003IfMT007l000h0\nfMWI0P00O`0>0=WIf@03001o003IfMT0fMWI09h0fMWI000F0=WIf@030000003IfMT0fMWI00@0fMWI\n00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0@0=WIf@05001o003IfMT0fMWI0=WIf@00\nO`00403IfMT01000O`00fMWI0=WIf@00O`0@0=WIf@03001o003IfMT007l000h0fMWI0P00O`0>0=WI\nf@03001o003IfMT0fMWI09h0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3I\nfMT03P3IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@04001o003IfMT0fMWI001o00h0fMWI0P00O`0>\n0=WIf@03001o003IfMT0fMWI09h0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<007l00=WI\nf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WI\nf@3IfMT03P3IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@04001o003IfMT0fMWI001o00h0fMWI0P00\nO`0=0=WIf@8007l03@3IfMT00`00O`00fMWI0=WIf@2@0=WIf@005P3IfMT00`000000fMWI0=WIf@03\n0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03`3IfMT00`00O`00fMWI0=WIf@02\n0=WIf@03001o003IfMT0fMWI00d0fMWI00D007l00=WIf@3IfMT0fMWI001o000?0=WIf@04001o003I\nfMT0fMWI001o00h0fMWI0P00O`0=0=WIf@8007l0303IfMT2001o0980fMWI000>0=WIf@@00000103I\nfMT00`000000fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03`3I\nfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00d0fMWI00D007l00=WIf@3IfMT0fMWI\n001o000?0=WIf@04001o003IfMT0fMWI001o00d0fMWI00<007l00=WIf@00O`003@3IfMT2001o00`0\nfMWI0P00O`2B0=WIf@003P3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI\n00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI0080fMWI\n00<007l00=WIf@3IfMT03@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000l0fMWI00@007l00=WIf@3I\nfMT007l03@3IfMT00`00O`00fMWI001o000=0=WIf@8007l0303IfMT2001o0980fMWI000?0=WIf@03\n0000003IfMT0fMWI00@0fMWI0P0000040=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3I\nfMT03`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00d0fMWI00D007l00=WIf@3I\nfMT0fMWI001o000?0=WIf@04001o003IfMT0fMWI001o00d0fMWI00<007l00=WIf@00O`003@3IfMT2\n001o00`0fMWI0P00O`0;0=WIf@03001o003IfMT0fMWI08@0fMWI00080=WIf@@00000103IfMT00`00\n0000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0103IfMT00`00\nO`00fMWI0=WIf@0>0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03@3IfMT01@00\nO`00fMWI0=WIf@3IfMT007l000h0fMWI00D007l00=WIf@3IfMT0fMWI001o000=0=WIf@03001o003I\nfMT007l000d0fMWI0P00O`0<0=WIf@8007l02`3IfMT00`00O`00fMWI0=WIf@240=WIf@003P3IfMT0\n10000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0103I\nfMT00`00O`00fMWI0=WIf@0>0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03@3I\nfMT01@00O`00fMWI0=WIf@3IfMT007l000h0fMWI00D007l00=WIf@3IfMT0fMWI001o000=0=WIf@03\n001o003IfMT007l000`0fMWI00<007l00=WIf@00O`002`3IfMT00`00O`00fMWI001o000:0=WIf@80\n07l0QP3IfMT000l0fMWI0P0000050=WIf@030000003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n103IfMT00`00O`00fMWI0=WIf@0>0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0\n3@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000h0fMWI00D007l00=WIf@3IfMT0fMWI001o000=0=WI\nf@03001o003IfMT007l000`0fMWI00<007l00=WIf@00O`002`3IfMT00`00O`00fMWI001o000:0=WI\nf@8007l0QP3IfMT001H0fMWI00<000000=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@040=WIf@03\n001o003IfMT0fMWI00h0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0=0=WIf@05\n001o003IfMT0fMWI0=WIf@00O`003P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000`0fMWI00@007l0\n0=WIf@3IfMT007l0303IfMT00`00O`00fMWI001o000;0=WIf@03001o003IfMT007l000X0fMWI0P00\nO`0:0=WIf@03001o003IfMT0fMWI07T0fMWI000F0=WIf@030000003IfMT0fMWI0080fMWI00<007l0\n0=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0>0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l0\n0=WIf@3IfMT03@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000h0fMWI00D007l00=WIf@3IfMT0fMWI\n001o000<0=WIf@04001o003IfMT0fMWI001o00`0fMWI00<007l00=WIf@00O`002`3IfMT00`00O`00\nfMWI001o000:0=WIf@8007l02P3IfMT00`00O`00fMWI0=WIf@1i0=WIf@005P3IfMT00`000000fMWI\n0=WIf@020=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT03P3IfMT00`00O`00fMWI\n0=WIf@030=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI\n0=WIf@0;0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02P3IfMT01000O`00fMWI\n0=WIf@00O`0<0=WIf@03001o003IfMT007l000/0fMWI00<007l00=WIf@00O`002P3IfMT2001o00T0\nfMWI0P00O`1k0=WIf@005P3IfMT01@000000fMWI0=WIf@3IfMT007l000L0fMWI00<007l00=WIf@3I\nfMT03@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3I\nfMT00P3IfMT00`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3I\nfMT02P3IfMT01000O`00fMWI0=WIf@00O`0<0=WIf@03001o003IfMT007l000/0fMWI00<007l00=WI\nf@00O`002P3IfMT2001o00T0fMWI0P00O`080=WIf@03001o003IfMT0fMWI0700fMWI000F0=WIf@05\n0000003IfMT0fMWI0=WIf@00O`001`3IfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI\n00@0fMWI00<007l00=WIf@3IfMT0303IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI\n00/0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@04001o003IfMT0fMWI\n001o00/0fMWI00@007l00=WIf@3IfMT007l02`3IfMT00`00O`00fMWI001o00090=WIf@03001o003I\nfMT007l000T0fMWI0P00O`080=WIf@03001o003IfMT0fMWI0700fMWI000F0=WIf@8000000P3IfMT0\n0`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0103IfMT0\n0`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02`3IfMT0\n0`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00X0fMWI00@007l00=WIf@3IfMT007l02`3I\nfMT01000O`00fMWI0=WIf@00O`0;0=WIf@03001o003IfMT007l000T0fMWI00<007l00=WIf@00O`00\n2@3IfMT2001o00P0fMWI00<007l00=WIf@3IfMT0L03IfMT001H0fMWI00D000000=WIf@3IfMT0fMWI\n001o00070=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI\n0=WIf@0<0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI\n0=WIf@020=WIf@03001o003IfMT0fMWI00T0fMWI00D007l00=WIf@3IfMT0fMWI001o000;0=WIf@04\n001o003IfMT0fMWI001o00/0fMWI00<007l00=WIf@00O`002@3IfMT00`00O`00fMWI001o00090=WI\nf@8007l0203IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI06L0fMWI000F0=WIf@05\n0000003IfMT0fMWI0=WIf@00O`001`3IfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI\n00@0fMWI00<007l00=WIf@3IfMT0303IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI\n00/0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@090=WIf@05001o003IfMT0fMWI\n0=WIf@00O`002`3IfMT01000O`00fMWI0=WIf@00O`0:0=WIf@04001o003IfMT0fMWI001o00T0fMWI\n00<007l00=WIf@00O`002@3IfMT2001o00L0fMWI0P00O`080=WIf@03001o003IfMT0fMWI06L0fMWI\n000F0=WIf@050000003IfMT0fMWI0=WIf@00O`001`3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o\n003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o\n003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@090=WIf@05001o\n003IfMT0fMWI0=WIf@00O`002`3IfMT01000O`00fMWI0=WIf@00O`0:0=WIf@04001o003IfMT0fMWI\n001o00T0fMWI00<007l00=WIf@00O`00203IfMT00`00O`00fMWI001o00070=WIf@8007l0203IfMT0\n0`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI05l0fMWI000F0=WIf@040000003IfMT0fMWI\n001o00P0fMWI00<007l00=WIf@3IfMT0303IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0\nfMWI00/0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0\nfMWI00<0fMWI00<007l00=WIf@3IfMT02@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000/0fMWI00@0\n07l00=WIf@3IfMT007l02P3IfMT01000O`00fMWI0=WIf@00O`090=WIf@03001o003IfMT007l000P0\nfMWI00<007l00=WIf@00O`001`3IfMT2001o00P0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00\nfMWI0=WIf@1O0=WIf@005P3IfMT010000000fMWI0=WIf@00O`080=WIf@03001o003IfMT0fMWI00`0\nfMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI00<0\nfMWI00<007l00=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00T0\nfMWI00D007l00=WIf@3IfMT0fMWI001o000:0=WIf@05001o003IfMT0fMWI0=WIf@00O`002P3IfMT0\n1000O`00fMWI0=WIf@00O`080=WIf@04001o003IfMT0fMWI001o00P0fMWI00<007l00=WIf@00O`00\n1`3IfMT2001o00L0fMWI0P00O`070=WIf@03001o003IfMT0fMWI05l0fMWI000F0=WIf@040000003I\nfMT0fMWI001o00P0fMWI00<007l00=WIf@3IfMT0303IfMT00`00O`00fMWI0=WIf@050=WIf@03001o\n003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o\n003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@020=WIf@03001o\n003IfMT0fMWI00P0fMWI00D007l00=WIf@3IfMT0fMWI001o000:0=WIf@04001o003IfMT0fMWI001o\n00P0fMWI00@007l00=WIf@3IfMT007l0203IfMT00`00O`00fMWI001o00070=WIf@8007l01`3IfMT2\n001o00L0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@1H0=WIf@005P3IfMT01000\n0000fMWI0=WIf@00O`080=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT01@3IfMT0\n0`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT02P3IfMT0\n0`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT00P3IfMT0\n0`00O`00fMWI0=WIf@080=WIf@05001o003IfMT0fMWI0=WIf@00O`002@3IfMT01@00O`00fMWI0=WI\nf@3IfMT007l000P0fMWI00@007l00=WIf@3IfMT007l0203IfMT00`00O`00fMWI001o00070=WIf@80\n07l01`3IfMT2001o00H0fMWI0P00O`060=WIf@03001o003IfMT0fMWI05P0fMWI000F0=WIf@040000\n003IfMT0fMWI001o00P0fMWI00<007l00=WIf@3IfMT0303IfMT00`00O`00fMWI0=WIf@050=WIf@03\n001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0:0=WIf@03\n001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@020=WIf@03\n001o003IfMT0fMWI00P0fMWI00D007l00=WIf@3IfMT0fMWI001o00090=WIf@05001o003IfMT0fMWI\n0=WIf@00O`00203IfMT01000O`00fMWI0=WIf@00O`080=WIf@03001o003IfMT007l000L0fMWI0P00\nO`070=WIf@8007l01P3IfMT2001o00H0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WI\nf@1A0=WIf@005P3IfMT200000003001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT02`3IfMT0\n0`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0103IfMT0\n0`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT0203IfMT0\n0`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00P0fMWI00D007l00=WIf@3IfMT0fMWI001o\n00090=WIf@05001o003IfMT0fMWI0=WIf@00O`00203IfMT01000O`00fMWI0=WIf@00O`070=WIf@04\n001o003IfMT0fMWI001o00L0fMWI0P00O`070=WIf@8007l01P3IfMT2001o00H0fMWI00<007l00=WI\nf@3IfMT0103IfMT00`00O`00fMWI0=WIf@1A0=WIf@005P3IfMT00`000000fMWI001o00090=WIf@03\n001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03\n001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WIf@03\n001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@080=WIf@05\n001o003IfMT0fMWI0=WIf@00O`002@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000L0fMWI00D007l0\n0=WIf@3IfMT0fMWI001o00070=WIf@04001o003IfMT0fMWI001o00L0fMWI0P00O`060=WIf@03001o\n003IfMT007l000H0fMWI0P00O`060=WIf@03001o003IfMT0fMWI00<0fMWI0P00O`040=WIf@03001o\n003IfMT0fMWI04`0fMWI000F0=WIf@030000003IfMT007l000T0fMWI00<007l00=WIf@3IfMT02`3I\nfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0103I\nfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT0203I\nfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00P0fMWI00D007l00=WIf@3IfMT0fMWI\n001o00090=WIf@05001o003IfMT0fMWI0=WIf@00O`001`3IfMT01@00O`00fMWI0=WIf@3IfMT007l0\n00L0fMWI00@007l00=WIf@3IfMT007l01P3IfMT00`00O`00fMWI001o00060=WIf@03001o003IfMT0\n07l000H0fMWI0P00O`060=WIf@03001o003IfMT0fMWI00<0fMWI0P00O`040=WIf@03001o003IfMT0\nfMWI04`0fMWI000F0=WIf@030000003IfMT007l000T0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00\nO`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0103IfMT00`00\nO`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00\nO`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00P0fMWI00D007l00=WIf@3IfMT0fMWI001o0009\n0=WIf@05001o003IfMT0fMWI0=WIf@00O`001`3IfMT01@00O`00fMWI0=WIf@3IfMT007l000L0fMWI\n00@007l00=WIf@3IfMT007l01P3IfMT00`00O`00fMWI001o00060=WIf@03001o003IfMT007l000H0\nfMWI0P00O`050=WIf@8007l01@3IfMT2001o00@0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00\nfMWI0=WIf@160=WIf@005P3IfMT00`000000fMWI001o00090=WIf@03001o003IfMT0fMWI00/0fMWI\n00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00@0fMWI\n00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00L0fMWI\n00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI0080fMWI\n00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00D0fMWI\n00D007l00=WIf@3IfMT0fMWI001o00070=WIf@04001o003IfMT0fMWI001o00H0fMWI00<007l00=WI\nf@00O`001P3IfMT00`00O`00fMWI001o00060=WIf@8007l01@3IfMT2001o00D0fMWI0P00O`040=WI\nf@03001o003IfMT0fMWI0080fMWI0P00O`030=WIf@03001o003IfMT0fMWI0480fMWI000F0=WIf@03\n0000003IfMT007l000T0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@060=WIf@03\n001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@090=WIf@03\n001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@030=WIf@03\n001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@060=WIf@03\n001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01@3IfMT01@00O`00fMWI0=WIf@3IfMT007l0\n00H0fMWI00D007l00=WIf@3IfMT0fMWI001o00060=WIf@03001o003IfMT007l000H0fMWI00<007l0\n0=WIf@00O`001P3IfMT2001o00D0fMWI0P00O`050=WIf@8007l0103IfMT00`00O`00fMWI0=WIf@02\n0=WIf@8007l00`3IfMT00`00O`00fMWI0=WIf@120=WIf@005P3IfMT00`00000007l00=WIf@090=WI\nf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@090=WI\nf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WI\nf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@070=WI\nf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@020=WI\nf@03001o003IfMT0fMWI00D0fMWI00D007l00=WIf@3IfMT0fMWI001o00060=WIf@05001o003IfMT0\nfMWI0=WIf@00O`001P3IfMT00`00O`00fMWI001o00060=WIf@03001o003IfMT007l000D0fMWI00<0\n07l00=WIf@00O`001@3IfMT2001o00D0fMWI0P00O`040=WIf@03001o003IfMT0fMWI0080fMWI0P00\nO`030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0?@3IfMT001H0fMWI00<00000\n001o003IfMT02@3IfMT00`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI00H0fMWI00<007l0\n0=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0000000<000001P3IfMT0\n0`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00`3IfMT0\n0`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01P3IfMT0\n0`00O`00fMWI0=WIf@0200000003001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00P3IfMT0\n0`00O`00fMWI0=WIf@040=WIf@05001o003IfMT0fMWI0=WIf@00O`001P3IfMT00`00O`00fMWI001o\n00060=WIf@03001o003IfMT007l000D0fMWI00<007l00=WIf@00O`001@3IfMT2001o00070000003I\nfMT0fMWI0=WIf@00O`00fMWI001o00030=WIf@8007l0103IfMT2001o00<0fMWI00@007l00=WIf@3I\nfMT0fMWI0P00O`020=WIf@03001o003IfMT0fMWI01X0fMWI0P00000N0=WIf@005P3IfMT00`000000\n07l00=WIf@090=WIf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00\nfMWI0=WIf@090=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@0000002@3IfMT00`00O`00\nfMWI0=WIf@040=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00\nfMWI0=WIf@070=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01P3IfMT01P00O`00\nfMWI0=WIf@3IfMT00000001o00H0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@04\n0=WIf@05001o003IfMT0fMWI0=WIf@00O`001@3IfMT01000O`00fMWI0=WIf@00O`060=WIf@03001o\n003IfMT007l000D0fMWI00<007l00=WIf@00O`001@3IfMT2001o00070=WIf@000000fMWI0=WIf@00\nO`00fMWI001o00030=WIf@8007l0103IfMT2001o00<0fMWI00@007l00=WIf@3IfMT0fMWI0P00O`02\n0=WIf@05001o003IfMT0fMWI0=WIf@00O`005`3IfMT010000000fMWI0=WIf@00000M0=WIf@005P3I\nfMT00`00000007l00=WIf@090=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT01`3I\nfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00D0fMWI00@007l00=WIf@3IfMT00000\n1`3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT0\n0`3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n1P3IfMT00`00O`0000000000000200000003001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT0\n0P3IfMT00`00O`00fMWI0=WIf@040=WIf@05001o003IfMT0fMWI0=WIf@00O`001@3IfMT01000O`00\nfMWI0=WIf@00O`060=WIf@03001o003IfMT007l000D0fMWI00<007l00=WIf@00O`00103IfMT01@00\nO`000000001o003IfMT000000080fMWI00<007l00=WIf@00O`000`3IfMT2001o00@0fMWI0P00O`03\n0=WIf@04001o003IfMT0fMWI0=WIf@8007l00P3IfMT00`00O`00fMWI0=WIf@02001o0080fMWI00<0\n07l00=WIf@3IfMT04P3IfMT010000000fMWI0=WIf@00000M0=WIf@005P3IfMT00`00000007l00=WI\nf@090=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WI\nf@090=WIf@03001o003IfMT0fMWI00D0fMWI00D007l00=WIf@3IfMT0fMWI000000060=WIf@03001o\n003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o\n003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o\n003IfMT000000080fMWI00<00000001o003IfMT01@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o\n003IfMT0fMWI00@0fMWI00D007l00=WIf@3IfMT0fMWI001o00050=WIf@04001o003IfMT0fMWI001o\n00D0fMWI00@007l00=WIf@3IfMT007l01@3IfMT00`00O`00fMWI001o00040=WIf@04001o00000000\n07l0000000<0fMWI00<007l00=WIf@00O`000`3IfMT2001o00@0fMWI0P00O`020=WIf@8007l00`3I\nfMT2001o0080fMWI00<007l00=WIf@3IfMT00P00O`020=WIf@04001o003IfMT0fMWI001o0180fMWI\n0P00000N0=WIf@005P3IfMT00`00000007l00=WIf@090=WIf@03001o003IfMT0fMWI00X0fMWI00<0\n07l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00H0fMWI00<0\n07l00=WIf@0000000P3IfMT00`000000fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00D0fMWI00<0\n07l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00H0fMWI00<0\n07l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@050=WIf@07001o003IfMT0fMWI0000003IfMT0\n0000001o00060=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00\nfMWI0=WIf@020=WIf@03001o003IfMT0fMWI00<0fMWI00@007l00=WIf@3IfMT007l01@3IfMT01000\nO`00fMWI0=WIf@00O`050=WIf@03001o003IfMT007l000@0fMWI00<007l00=WIf@00O`00103IfMT0\n0`00O`00fMWI001o00030=WIf@8007l0103IfMT2001o0080fMWI0P00O`020=WIf@03001o003IfMT0\n07l00080fMWI00<007l00=WIf@3IfMT00P00O`000`3IfMT007l0001o00020=WIf@03001o003IfMT0\n07l000l0fMWI00@000000=WIf@3IfMT000007@3IfMT001H0fMWI00<00000001o003IfMT02@3IfMT0\n0`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT0203IfMT0\n0`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI008000001P3IfMT00`00O`00fMWI0=WIf@05\n0=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@06\n0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT01@3IfMT01000O`00fMWI0=WIf@3I\nfMT200000003001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WI\nf@030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00`3IfMT01000O`00fMWI0=WI\nf@00O`050=WIf@04001o003IfMT0fMWI001o00@0fMWI00@007l00=WIf@3IfMT007l0103IfMT00`00\nO`00fMWI001o000200000080fMWI00<007l00=WIf@00O`000`3IfMT2001o00<0fMWI00<007l00=WI\nf@00O`000P3IfMT2001o0080fMWI00<007l00=WIf@00O`000P3IfMT00`00O`00fMWI0=WIf@02001o\n00040=WIf@00O`0007l00=WIf@8007l000H0fMWI001o003IfMT007l00=WIf@00O`0<0=WIf@800000\n7P3IfMT001H0fMWI00<00000001o003IfMT02@3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003I\nfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003I\nfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003I\nfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003I\nfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003I\nfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003I\nfMT0fMWI00<0fMWI00@007l00=WIf@3IfMT007l01@3IfMT01000O`00fMWI0=WIf@00O`040=WIf@04\n001o003IfMT0fMWI001o00@0fMWI00<007l00=WIf@00O`000`3IfMT01000O`00fMWI0=WIf@00O`02\n0=WIf@03001o003IfMT007l000<0fMWI00<007l00=WIf@00O`000P3IfMT2001o0080fMWI00@007l0\n0=WIf@00O`00fMWI0P00O`020=WIf@8007l000@0fMWI001o0000O`00fMWI1000O`001P3IfMT007l0\n0=WIf@00O`00fMWI001o02X0fMWI000F0=WIf@0300000000O`00fMWI00T0fMWI00<007l00=WIf@3I\nfMT02@3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3I\nfMT01P3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3I\nfMT01P3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3I\nfMT00P3IfMT00`00O`00fMWI0=WIf@020=WIf@05001o003IfMT0fMWI0=WIf@00O`001@3IfMT01000\nO`00fMWI0=WIf@00O`040=WIf@04001o003IfMT0fMWI001o00@0fMWI00<007l00=WIf@00O`000`3I\nfMT01000O`00fMWI0=WIf@00O`020=WIf@03001o003IfMT007l000<0fMWI00<007l00=WIf@00O`00\n0P3IfMT2001o0080fMWI00@007l00=WIf@00O`00fMWI0P00O`020=WIf@8007l000@0fMWI001o0000\nO`00fMWI1000O`001`3IfMT007l00=WIf@00O`00fMWI001o003IfMT00P00O`0W0=WIf@005P3IfMT0\n0`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0203IfMT0\n0`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT01`3IfMT0\n0`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT0103IfMT0\n0`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT01@3IfMT0\n0`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT00`3IfMT0\n0`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00P3IfMT0\n1@00O`00fMWI0=WIf@3IfMT007l000D0fMWI00@007l00=WIf@3IfMT007l0103IfMT01000O`00fMWI\n0=WIf@00O`030=WIf@04001o003IfMT0fMWI001o00<0fMWI00@007l00=WIf@3IfMT007l00P3IfMT0\n0`00O`00fMWI001o00030=WIf@03001o003IfMT007l00080fMWI0P00O`020=WIf@04001o003IfMT0\n07l00=WIf@8007l00P3IfMT2001o00040=WIf@00O`0007l00=WIf@@007l000L0fMWI001o003IfMT0\n07l00=WIf@00O`00fMWI008007l000@0fMWI001o0000O`0007l08`3IfMT001H0fMWI00<007l00=WI\nf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WI\nf@3IfMT0203IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WI\nf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WI\nf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WI\nf@3IfMT0103IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WI\nf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI0080fMWI00D007l00=WI\nf@3IfMT0fMWI001o00040=WIf@05001o003IfMT0fMWI0=WIf@00O`00103IfMT01000O`00fMWI0=WI\nf@00O`030=WIf@04001o003IfMT0fMWI001o00<0fMWI00@007l00=WIf@3IfMT007l00P3IfMT00`00\nO`00fMWI001o00030=WIf@07001o003IfMT007l00=WIf@00O`00fMWI001o00020=WIf@04001o003I\nfMT007l00=WIf@8007l00P3IfMT2001o00040=WIf@00O`0007l00=WIf@H007l000D0fMWI001o003I\nfMT007l00=WIf@09001o0200fMWI000F0=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3I\nfMT02@3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3I\nfMT01`3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3I\nfMT01@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3I\nfMT0103IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@05001o003IfMT0fMWI0=WIf@00O`00103IfMT01@00\nO`00fMWI0=WIf@3IfMT007l000@0fMWI00@007l00=WIf@3IfMT007l00`3IfMT01000O`00fMWI0=WI\nf@00O`030=WIf@04001o003IfMT0fMWI001o0080fMWI00<007l00=WIf@00O`000P3IfMT02000O`00\nfMWI0=WIf@00O`00fMWI001o003IfMT007l00P3IfMT01000O`00fMWI001o003IfMT2001o00030=WI\nf@00O`00fMWI008007l000<0fMWI001o003IfMT01P00O`000`3IfMT007l00=WIf@0=001o00l0fMWI\n0P00000=0=WIf@005P3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00T0fMWI00<0\n07l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00L0fMWI00<0\n07l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00D0fMWI00<0\n07l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00@0fMWI00<0\n07l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00<0fMWI00<0\n07l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00<0fMWI00<0\n07l00=WIf@3IfMT00P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000@0fMWI00D007l00=WIf@3IfMT0\nfMWI001o00030=WIf@05001o003IfMT0fMWI0=WIf@00O`000`3IfMT01000O`00fMWI0=WIf@00O`03\n0=WIf@06001o003IfMT0fMWI001o003IfMT007l00P3IfMT01000O`00fMWI0=WIf@00O`020=WIf@05\n001o003IfMT007l00=WIf@00O`000P3IfMT02@00O`00fMWI001o0000O`00fMWI001o003IfMT007l0\n0=WIf@02001o00040=WIf@00O`0007l00=WIfAD007l03P3IfMT010000000fMWI0=WIf@00000<0=WI\nf@00403IfMT600000003001o00000000000000T0000000<007l00000000000002@0000000`00O`00\n00000000000800000003001o00000000000000L0000000<007l00000000000001`0000000`00O`00\n00000000000700000003001o00000000000000H0000000<007l00000000000001@0000000`00O`00\n00000000000500000003001o00000000000000D0000000<007l0000000000000100000000`00O`00\n00000000000400000003001o00000000000000@0000000<007l00000000000000`0000000`00O`00\n00000000000300000003001o0000000000000080000000<007l00000000000000`0000001@00O`00\n000000000000000007l000@0000000<007l00000000000000P0000001@00O`000000000000000000\n07l000<0000000D007l00000000000000000001o000300000004001o000000000000001o00800000\n00L007l00000000000000000001o0000000007l00080000000@007l000000000000007l00P000000\n1@00O`000000001o0000000007l00080000000T007l000000000O`0007l000000000O`000000001o\n000000000P00O`001000000007l0001o0000000F001o00D00000203IfMT00`000000fMWI0=WIf@0=\n0=WIf@005P3IfMT00`000000fMWI0=WIf@090=WIf@03001o00000?l0fMWI00P0fMWI00<007l00=WI\nf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00L0fMWI00D007l00000\no`3IfMT0fMWI000000040=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT01@3IfMT0\n0`00O`00fMWI0=WIf@050=WIf@03001o00000?l0fMWI00D0fMWI00<007l00=WIf@3IfMT0103IfMT0\n0`00O`00003o0=WIf@040=WIf@03001o003IfMT0fMWI0080fMWI00<000000=WIf@00O`001@3IfMT0\n0`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00`3IfMT0\n1@00O`00fMWI0=WIf@3IfMT007l000@0fMWI00<007l00000o`3IfMT00P3IfMT01P00O`00fMWI0=WI\nf@3IfMT007l00000o`80fMWI00P007l00=WIf@3IfMT0fMWI001o00000?l0fMWI001o00<0fMWI00@0\n07l00000o`3IfMT007l00`3IfMT00`00O`00fMWI001o00020=WIf@0?001o00000?l0fMWI001o003I\nfMT0003o001o003IfMT007l00=WIf@00O`00003o001o003IfMT0003o008007l000D0fMWI001o0000\n0?l007l00000o`02001o00040=WIf@00O`0007l00000oaD007l000<0003o0=WIf@3IfMT02P3IfMT5\n000000`0fMWI000F0=WIf@030000003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0203IfMT00`00\nO`00fMWI0=WIf@080=WIf@030000o`00O`00fMWI00P0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00\nO`00003o0=WIf@060=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00\nO`00fMWI0=WIf@050=WIf@03001o00000?l0fMWI00@0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00\nO`00003o0=WIf@030=WIf@03001o003IfMT0fMWI00@0fMWI00<0003o001o003IfMT00`3IfMT00`00\nO`00fMWI0=WIf@030=WIf@030000o`00O`00003o00<0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00\n0?l007l00=WIf@020=WIf@06001o003IfMT0fMWI0=WIf@000?l007l00P000?l00`3IfMT007l00=WI\nf@020=WIf@060000o`00O`00003o0000o`3IfMT007l00P3IfMT01P000?l007l00000o`000?l007l0\n0=WIf@80003o00@007l00000o`000?l007l00`000?l00`00O`00003o001o00020000o`04001o0000\n0?l0003o001o0080003o00L007l00000o`00O`00003o001o00000?l007l00080003o0P00O`001@00\n0?l007l00000o`00O`00003o008007l000@0003o001o0000O`00003o3000O`000`3IfMT007l0001o\n0003001o0140fMWI00<000000=WIf@3IfMT03@3IfMT001H0fMWI00<000000=WIf@3IfMT0203IfMT0\n0`000?l007l00000o`090=WIf@03001o003IfMT0fMWI00P0fMWI00<0003o001o00000?l01`3IfMT0\n0`00O`00fMWI0=WIf@080=WIf@03001o00000?l0fMWI00H0fMWI00<007l00=WIf@3IfMT01P3IfMT0\n0`000?l007l00000o`060=WIf@03001o003IfMT0fMWI00@0fMWI00@0003o001o003IfMT0003o103I\nfMT00`00O`00fMWI0=WIf@040=WIf@040000o`00O`00003o0000o`<0fMWI00<007l00=WIf@3IfMT0\n0`3IfMT010000?l0fMWI001o00000?l30=WIf@03001o003IfMT0fMWI0080fMWI0P000?l01@00O`00\n003o0000o`3IfMT007l000@0fMWI00<0003o0=WIf@00O`000P000?l0103IfMT007l00=WIf@3IfMT2\n0000o`05001o003IfMT0003o0000o`00O`000`000?l00`3IfMT007l00=WIf@020000o`05001o0000\n0?l0003o0=WIf@00O`000P3IfMT01@00O`00003o0000o`3IfMT007l00080fMWI00L007l00=WIf@3I\nfMT0fMWI001o003IfMT007l00080fMWI00@007l00=WIf@3IfMT007l00P3IfMT2001o0080fMWI00<0\n07l00=WIf@00O`000P3IfMT2001o00050=WIf@00O`00fMWI001o003IfMT00P00O`00203IfMT007l0\n001o003IfMT007l00=WIf@00O`00fMWI2`00O`0T0=WIf@005P3IfMT00`000000fMWI0=WIf@080=WI\nf@030000o`00O`00003o00T0fMWI00<007l00=WIf@3IfMT0203IfMT00`000?l007l00000o`070=WI\nf@03001o003IfMT0fMWI00L0fMWI00@0003o001o003IfMT0003o1P3IfMT00`00O`00fMWI0=WIf@05\n0=WIf@050000o`3IfMT007l00=WIf@000?l0103IfMT00`00O`00fMWI0=WIf@050=WIf@040000o`00\nO`00fMWI0000o`@0fMWI00<007l00=WIf@3IfMT00`3IfMT010000?l0fMWI001o003IfMT20000o`80\nfMWI00<007l00=WIf@3IfMT00P3IfMT20000o`030=WIf@00O`00fMWI0080003o00@0fMWI001o003I\nfMT0fMWI0P000?l20=WIf@05001o003IfMT0fMWI0000o`00O`0010000?l20=WIf@05001o003IfMT0\nfMWI0000o`00O`000P000?l20=WIf@05001o003IfMT0fMWI0=WIf@00O`00103IfMT01000O`00fMWI\n0=WIf@00O`040=WIf@04001o003IfMT0fMWI001o00<0fMWI00@007l00=WIf@3IfMT007l00`3IfMT0\n0`00O`00fMWI001o00020=WIf@03001o003IfMT007l000<0fMWI0P00O`020=WIf@03001o003IfMT0\n07l00080fMWI0P00O`000`3IfMT007l0001o00020=WIf@04001o003IfMT0fMWI001o0080fMWI00@0\n07l00=WIf@00O`00fMWI0`00O`000`3IfMT007l0001o0002001o02L0fMWI000F0=WIf@030000003I\nfMT0fMWI00P0fMWI00@0003o001o003IfMT0003o203IfMT00`00O`00fMWI0=WIf@070=WIf@050000\no`3IfMT007l00=WIf@000?l01P3IfMT00`00O`00fMWI0=WIf@060=WIf@030000o`3IfMT007l00080\nfMWI00<0003o0=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@050=WIf@050000o`3IfMT007l00=WI\nf@000?l0103IfMT00`00O`00fMWI0=WIf@040=WIf@030000o`3IfMT007l00080fMWI00D0003o0=WI\nf@3IfMT0fMWI001o00040=WIf@040000o`3IfMT0fMWI001o00<0fMWI00<0003o0=WIf@00O`000`3I\nfMT20000o`80fMWI00H007l00=WIf@3IfMT0fMWI0000o`00O`030000o`<0fMWI00D007l00=WIf@3I\nfMT0fMWI001o00060=WIf@05001o003IfMT0fMWI0=WIf@00O`00103IfMT01@00O`00fMWI0=WIf@3I\nfMT007l000@0fMWI00@007l00=WIf@3IfMT007l0103IfMT01000O`00fMWI0=WIf@00O`030=WIf@03\n001o003IfMT007l000@0fMWI0P00O`030=WIf@03001o003IfMT007l000<0fMWI0P00O`020=WIf@03\n001o003IfMT007l00080fMWI00<007l00=WIf@3IfMT00P00O`020=WIf@04001o003IfMT0fMWI001o\n0080fMWI00@007l00=WIf@00O`00fMWI1@00O`0Z0=WIf@005P3IfMT00`000000fMWI0=WIf@070=WI\nf@050000o`3IfMT007l00=WIf@000?l0203IfMT00`00O`00fMWI0=WIf@070=WIf@050000o`3IfMT0\n07l00=WIf@000?l01P3IfMT00`00O`00fMWI0=WIf@060=WIf@030000o`3IfMT007l00080fMWI0P00\n0?l40=WIf@03001o003IfMT0fMWI00@0fMWI00@0003o0=WIf@3IfMT007l00P3IfMT01@000?l0fMWI\n0=WIf@3IfMT007l000D0fMWI00@0003o0=WIf@3IfMT007l00`3IfMT20000o`030=WIf@00O`00fMWI\n0080fMWI00D0003o0=WIf@3IfMT0fMWI001o00040=WIf@030000o`00O`00003o0080003o103IfMT0\n0`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00@0fMWI00D007l00=WIf@3IfMT0fMWI001o\n00060=WIf@04001o003IfMT0fMWI001o00D0fMWI00D007l00=WIf@3IfMT0fMWI001o00040=WIf@04\n001o003IfMT0fMWI001o00@0fMWI00@007l00=WIf@3IfMT007l00`3IfMT00`00O`00fMWI001o0004\n0=WIf@8007l00`3IfMT00`00O`00fMWI001o00030=WIf@8007l00P3IfMT00`00O`00fMWI001o0002\n0=WIf@03001o003IfMT0fMWI008007l00P3IfMT01000O`00fMWI0=WIf@00O`020=WIf@03001o003I\nfMT007l0008007l0;P3IfMT001H0fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI001o0002\n0=WIf@030000o`3IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT01`3IfMT010000?l0fMWI0=WIf@00\nO`020=WIf@030000o`3IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT01@3IfMT010000?l0fMWI0=WI\nf@00O`030=WIf@050000o`3IfMT0fMWI0=WIf@00O`001P3IfMT01@000?l0fMWI0=WIf@3IfMT007l0\n00<0fMWI0P000?l00`3IfMT007l00=WIf@020=WIf@80003o0`3IfMT00`00O`00fMWI0=WIf@030=WI\nf@030000o`00O`00003o0080003o103IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI\n00D0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@040=WIf@05001o003IfMT0fMWI\n0=WIf@00O`001P3IfMT01000O`00fMWI0=WIf@00O`050=WIf@05001o003IfMT0fMWI0=WIf@00O`00\n103IfMT01000O`00fMWI0=WIf@00O`040=WIf@03001o003IfMT007l000@0fMWI00<007l00=WIf@00\nO`00103IfMT2001o00<0fMWI00<007l00=WIf@00O`000`3IfMT2001o0080fMWI0P00O`030=WIf@03\n001o003IfMT0fMWI008007l00P3IfMT01000O`00fMWI0=WIf@00O`020=WIf@03001o003IfMT0fMWI\n0300fMWI000F0=WIf@030000003IfMT0fMWI00H0fMWI00@0003o0=WIf@3IfMT007l00`3IfMT00`00\n0?l0fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00L0fMWI00@0003o0=WIf@3IfMT007l00`3IfMT0\n0`000?l0fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00@0fMWI00D0003o0=WIf@3IfMT0fMWI001o\n00040=WIf@040000o`3IfMT0fMWI001o00D0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`00O`00fMWI\n0=WIf@020=WIf@80003o00<007l00000o`000?l00P000?l40=WIf@03001o003IfMT0fMWI00<0fMWI\n00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00H0fMWI\n00D007l00=WIf@3IfMT0fMWI001o00070=WIf@05001o003IfMT0fMWI0=WIf@00O`001P3IfMT01000\nO`00fMWI0=WIf@00O`050=WIf@04001o003IfMT0fMWI001o00D0fMWI00@007l00=WIf@3IfMT007l0\n103IfMT00`00O`00fMWI001o00040=WIf@03001o003IfMT007l000@0fMWI0P00O`030=WIf@03001o\n003IfMT007l000<0fMWI00@007l00=WIf@3IfMT0fMWI0P00O`030=WIf@03001o003IfMT0fMWI0080\n07l00P3IfMT01000O`00fMWI0=WIf@00O`0e0=WIf@005P3IfMT2000000L0fMWI00@0003o0=WIf@3I\nfMT007l00`3IfMT00`000?l0fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00H0fMWI00D0003o0=WI\nf@3IfMT0fMWI001o00040=WIf@040000o`3IfMT0fMWI001o00L0fMWI00D0003o0=WIf@3IfMT0fMWI\n001o00050=WIf@80003o00@007l00=WIf@3IfMT0fMWI0P000?l50=WIf@03001o003IfMT0fMWI00@0\nfMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00H0\nfMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@060=WIf@05001o003IfMT0fMWI0=WI\nf@00O`001`3IfMT01000O`00fMWI0=WIf@00O`070=WIf@04001o003IfMT0fMWI001o00D0fMWI00@0\n07l00=WIf@3IfMT007l01@3IfMT01000O`00fMWI0=WIf@00O`040=WIf@03001o003IfMT007l000@0\nfMWI00<007l00=WIf@00O`00103IfMT2001o00<0fMWI00<007l00=WIf@00O`000`3IfMT01000O`00\nfMWI0=WIf@3IfMT2001o00<0fMWI00<007l00=WIf@3IfMT00P00O`020=WIf@03001o003IfMT0fMWI\n03H0fMWI000F0=WIf@030000003IfMT0fMWI00D0fMWI0P000?l20=WIf@03001o003IfMT0fMWI0080\nfMWI00<0003o0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0080\nfMWI00<007l00=WIf@3IfMT00P3IfMT20000o`030=WIf@00O`00fMWI00D0fMWI00<0003o0=WIf@3I\nfMT00P3IfMT00`00O`00fMWI0=WIf@040=WIf@030000o`00O`00003o00<0003o1P3IfMT00`00O`00\nfMWI0=WIf@030=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00\nfMWI0=WIf@060=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01P3IfMT01@00O`00\nfMWI0=WIf@3IfMT007l000L0fMWI00@007l00=WIf@3IfMT007l01`3IfMT01000O`00fMWI0=WIf@00\nO`050=WIf@04001o003IfMT0fMWI001o00D0fMWI00<007l00=WIf@00O`001@3IfMT00`00O`00fMWI\n001o00040=WIf@03001o003IfMT007l000@0fMWI0P00O`030=WIf@8007l0103IfMT01000O`00fMWI\n0=WIf@3IfMT2001o00<0fMWI00@007l00=WIf@3IfMT007l0?03IfMT001H0fMWI00<000000=WIf@3I\nfMT01@3IfMT01@000?l0fMWI0=WIf@3IfMT007l000D0fMWI00D0003o0=WIf@3IfMT0fMWI001o0006\n0=WIf@80003o103IfMT00`00O`00fMWI0=WIf@040=WIf@030000o`00O`00fMWI00<0fMWI0P000?l5\n0=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@03\n0=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@06\n0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01P3IfMT01@00O`00fMWI0=WIf@3I\nfMT007l000L0fMWI00@007l00=WIf@3IfMT007l01`3IfMT01000O`00fMWI0=WIf@00O`050=WIf@04\n001o003IfMT0fMWI001o00D0fMWI00<007l00=WIf@00O`001@3IfMT00`00O`00fMWI001o00040=WI\nf@8007l01@3IfMT2001o00<0fMWI0P00O`040=WIf@04001o003IfMT0fMWI0=WIf@8007l00`3IfMT0\n0`00O`00fMWI0=WIf@0m0=WIf@005P3IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI\n0080fMWI00<007l00=WIf@3IfMT00`3IfMT20000o`030=WIf@00O`00fMWI00D0fMWI0P000?l50=WI\nf@03001o003IfMT0fMWI00D0fMWI00<007l00000o`000?l00P000?l70=WIf@03001o003IfMT0fMWI\n00@0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI\n00L0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI\n0080fMWI00<007l00=WIf@3IfMT01P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000L0fMWI00@007l0\n0=WIf@3IfMT007l01`3IfMT00`00O`00fMWI001o00060=WIf@04001o003IfMT0fMWI001o00D0fMWI\n00<007l00=WIf@00O`001@3IfMT00`00O`00fMWI001o00040=WIf@8007l01@3IfMT2001o00<0fMWI\n0P00O`040=WIf@04001o003IfMT0fMWI0=WIf@8007l0@`3IfMT001H0fMWI00<000000=WIf@3IfMT0\n0`3IfMT20000o`@0fMWI00<007l00=WIf@3IfMT0103IfMT20000o`03001o003IfMT0fMWI00<0fMWI\n0P000?l60=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI\n0=WIf@040=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI\n0=WIf@070=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI\n0=WIf@020=WIf@03001o003IfMT0fMWI00H0fMWI00D007l00=WIf@3IfMT0fMWI001o00070=WIf@04\n001o003IfMT0fMWI001o00L0fMWI00<007l00=WIf@00O`001P3IfMT01000O`00fMWI0=WIf@00O`05\n0=WIf@03001o003IfMT007l000D0fMWI0P00O`050=WIf@8007l01@3IfMT2001o00<0fMWI0P00O`04\n0=WIf@03001o003IfMT0fMWI04H0fMWI000F0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WI\nf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@050=WIf@030000o`00O`00003o0080fMWI0`000?l70=WI\nf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WI\nf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@070=WI\nf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01`3IfMT01@00O`00fMWI0=WIf@3IfMT0\n07l000T0fMWI00@007l00=WIf@3IfMT007l0203IfMT01000O`00fMWI0=WIf@00O`070=WIf@03001o\n003IfMT007l000H0fMWI00<007l00=WIf@00O`001P3IfMT00`00O`00fMWI001o00050=WIf@8007l0\n1@3IfMT2001o00D0fMWI00<007l00=WIf@3IfMT00P3IfMT2001o00@0fMWI00<007l00=WIf@3IfMT0\nAP3IfMT001H0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@040=WIf@03001o003I\nfMT0fMWI00H0fMWI00<007l00=WIf@000?l00P000?l90=WIf@03001o003IfMT0fMWI00D0fMWI00<0\n07l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00T0fMWI00<0\n07l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI0080fMWI00<0\n07l00=WIf@3IfMT01`3IfMT01@00O`00fMWI0=WIf@3IfMT007l000T0fMWI00@007l00=WIf@3IfMT0\n07l0203IfMT01000O`00fMWI0=WIf@00O`070=WIf@03001o003IfMT007l000H0fMWI00<007l00=WI\nf@00O`001P3IfMT00`00O`00fMWI001o00050=WIf@8007l01@3IfMT2001o00D0fMWI00<007l00=WI\nf@3IfMT00P3IfMT2001o04d0fMWI000F0=WIf@030000003IfMT0fMWI0080003o1`3IfMT00`00O`00\nfMWI0=WIf@060=WIf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00\nfMWI0=WIf@090=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00\nfMWI0=WIf@020=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00\nfMWI0=WIf@070=WIf@05001o003IfMT0fMWI0=WIf@00O`002@3IfMT01000O`00fMWI0=WIf@00O`08\n0=WIf@04001o003IfMT0fMWI001o00L0fMWI00<007l00=WIf@00O`001P3IfMT00`00O`00fMWI001o\n00060=WIf@8007l01P3IfMT2001o00D0fMWI0P00O`050=WIf@03001o003IfMT0fMWI0540fMWI000F\n0=WIf@04000000000?l0003o0000o`P0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WI\nf@0;0=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WI\nf@040=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WI\nf@080=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01`3IfMT01@00O`00fMWI0=WI\nf@3IfMT007l000T0fMWI00@007l00=WIf@3IfMT007l0203IfMT01000O`00fMWI0=WIf@00O`070=WI\nf@8007l01`3IfMT00`00O`00fMWI001o00060=WIf@8007l01P3IfMT2001o00D0fMWI00<007l00=WI\nf@3IfMT0103IfMT00`00O`00fMWI0=WIf@1A0=WIf@005P3IfMT20000o`X0fMWI00<007l00=WIf@3I\nfMT01@3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3I\nfMT02P3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3I\nfMT00P3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3I\nfMT01`3IfMT01@00O`00fMWI0=WIf@3IfMT007l000T0fMWI00@007l00=WIf@3IfMT007l0203IfMT0\n0`00O`00fMWI001o00080=WIf@8007l01`3IfMT00`00O`00fMWI001o00060=WIf@8007l01P3IfMT2\n001o00D0fMWI00<007l00=WIf@3IfMT0F03IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT00`00\nO`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT0103IfMT00`00\nO`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT02P3IfMT00`00\nO`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00P0fMWI00D007l00=WIf@3IfMT0fMWI001o000:\n0=WIf@05001o003IfMT0fMWI0=WIf@00O`002@3IfMT01000O`00fMWI0=WIf@00O`080=WIf@03001o\n003IfMT007l000P0fMWI0P00O`070=WIf@8007l01`3IfMT2001o00H0fMWI00<007l00=WIf@3IfMT0\n103IfMT2001o05T0fMWI000F0=WIf@030000003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT01@3I\nfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT02P3I\nfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT00P3I\nfMT00`00O`00fMWI0=WIf@080=WIf@05001o003IfMT0fMWI0=WIf@00O`002P3IfMT01@00O`00fMWI\n0=WIf@3IfMT007l000T0fMWI00<007l00=WIf@00O`002@3IfMT00`00O`00fMWI001o00080=WIf@80\n07l01`3IfMT2001o00L0fMWI0P00O`060=WIf@03001o003IfMT0fMWI05l0fMWI000F0=WIf@030000\n003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o\n003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o\n003IfMT0fMWI00X0fMWI00D007l00=WIf@3IfMT0fMWI001o000;0=WIf@05001o003IfMT0fMWI0=WI\nf@00O`002P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000T0fMWI00<007l00=WIf@00O`002@3IfMT0\n0`00O`00fMWI001o00080=WIf@8007l01`3IfMT2001o00L0fMWI0P00O`060=WIf@8007l0H03IfMT0\n01H0fMWI00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI\n00`0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI\n00<0fMWI00<007l00=WIf@3IfMT02P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000/0fMWI00D007l0\n0=WIf@3IfMT0fMWI001o000:0=WIf@04001o003IfMT0fMWI001o00X0fMWI00<007l00=WIf@00O`00\n2@3IfMT00`00O`00fMWI001o00080=WIf@8007l01`3IfMT2001o00L0fMWI00<007l00=WIf@3IfMT0\nI`3IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003I\nfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0;0=WIf@03001o003I\nfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT02P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000/0fMWI\n00D007l00=WIf@3IfMT0fMWI001o000:0=WIf@04001o003IfMT0fMWI001o00X0fMWI00<007l00=WI\nf@00O`002@3IfMT2001o00T0fMWI00<007l00=WIf@3IfMT01P3IfMT2001o00L0fMWI0P00O`1X0=WI\nf@005P3IfMT00`000000fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3I\nfMT03@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3I\nfMT00P3IfMT00`00O`00fMWI0=WIf@0;0=WIf@05001o003IfMT0fMWI0=WIf@00O`002`3IfMT01@00\nO`00fMWI0=WIf@3IfMT007l000X0fMWI00@007l00=WIf@3IfMT007l02P3IfMT00`00O`00fMWI001o\n00090=WIf@8007l02@3IfMT00`00O`00fMWI0=WIf@060=WIf@8007l01`3IfMT00`00O`00fMWI0=WI\nf@1W0=WIf@005P3IfMT00`000000fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00@0fMWI00<007l0\n0=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00/0fMWI00<007l0\n0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0;0=WIf@05001o003IfMT0fMWI0=WIf@00O`002`3I\nfMT01000O`00fMWI0=WIf@00O`0;0=WIf@04001o003IfMT0fMWI001o00X0fMWI0P00O`0:0=WIf@80\n07l02@3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI0700fMWI000F0=WIf@030000\n003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o\n003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o\n003IfMT0fMWI00/0fMWI00D007l00=WIf@3IfMT0fMWI001o000;0=WIf@04001o003IfMT0fMWI001o\n00/0fMWI00@007l00=WIf@3IfMT007l02P3IfMT2001o00X0fMWI0P00O`090=WIf@03001o003IfMT0\nfMWI00H0fMWI0P00O`1a0=WIf@005P3IfMT2000000X0fMWI00<007l00=WIf@3IfMT0103IfMT00`00\nO`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00\nO`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00/0fMWI00@007l00=WIf@3IfMT007l0303IfMT0\n1000O`00fMWI0=WIf@00O`0;0=WIf@04001o003IfMT0fMWI001o00X0fMWI0P00O`0:0=WIf@8007l0\n2@3IfMT00`00O`00fMWI0=WIf@1i0=WIf@005P3IfMT00`000000fMWI0=WIf@090=WIf@03001o003I\nfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003I\nfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0;0=WIf@04001o003I\nfMT0fMWI001o00`0fMWI00@007l00=WIf@3IfMT007l02`3IfMT00`00O`00fMWI001o000;0=WIf@80\n07l02P3IfMT2001o00T0fMWI00<007l00=WIf@3IfMT0N@3IfMT001H0fMWI00<000000=WIf@3IfMT0\n2@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0\n0P3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n2`3IfMT01000O`00fMWI0=WIf@00O`0<0=WIf@04001o003IfMT0fMWI001o00/0fMWI00<007l00=WI\nf@00O`002`3IfMT2001o00X0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@1i0=WI\nf@005P3IfMT00`000000fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3I\nfMT03P3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00`0fMWI00D007l00=WIf@3I\nfMT0fMWI001o000>0=WIf@04001o003IfMT0fMWI001o00`0fMWI00@007l00=WIf@3IfMT007l02`3I\nfMT00`00O`00fMWI001o000;0=WIf@8007l02P3IfMT00`00O`00fMWI0=WIf@240=WIf@005P3IfMT0\n0`000000fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03P3IfMT0\n0`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00`0fMWI00D007l00=WIf@3IfMT0fMWI001o\n000>0=WIf@04001o003IfMT0fMWI001o00`0fMWI00<007l00=WIf@00O`00303IfMT00`00O`00fMWI\n001o000;0=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0Q03IfMT001H0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00h0fMWI00<0\n07l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0<0=WIf@05001o003IfMT0fMWI0=WIf@00O`00\n3P3IfMT01000O`00fMWI0=WIf@00O`0<0=WIf@03001o003IfMT007l000`0fMWI00<007l00=WIf@00\nO`002`3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI08@0fMWI000F0=WIf@030000\n003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0>0=WIf@03001o\n003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0303IfMT01@00O`00fMWI0=WIf@3IfMT007l000h0\nfMWI00<007l00=WIf@00O`003@3IfMT00`00O`00fMWI001o000<0=WIf@03001o003IfMT007l000/0\nfMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@240=WIf@003P3IfMT4000000@0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00h0fMWI\n00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0<0=WIf@05001o003IfMT0fMWI0=WIf@00\nO`003P3IfMT00`00O`00fMWI001o000=0=WIf@03001o003IfMT007l000`0fMWI0P00O`0<0=WIf@03\n001o003IfMT0fMWI0900fMWI000>0=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT0\n2@3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00h0fMWI00D007l00=WIf@3IfMT0\nfMWI001o000?0=WIf@05001o003IfMT0fMWI0=WIf@00O`003P3IfMT00`00O`00fMWI001o000=0=WI\nf@03001o003IfMT007l000`0fMWI0P00O`0<0=WIf@03001o003IfMT0fMWI0900fMWI000?0=WIf@03\n0000003IfMT0fMWI00@0fMWI0P00000:0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3I\nfMT03P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000l0fMWI00D007l00=WIf@3IfMT0fMWI001o000>\n0=WIf@03001o003IfMT007l000d0fMWI00<007l00=WIf@00O`00303IfMT2001o00`0fMWI00<007l0\n0=WIf@3IfMT0T03IfMT00100fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@090=WI\nf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03P3IfMT01@00O`00fMWI0=WIf@3IfMT0\n07l000l0fMWI00D007l00=WIf@3IfMT0fMWI001o000>0=WIf@03001o003IfMT007l000d0fMWI00<0\n07l00=WIf@00O`00303IfMT2001o09l0fMWI000>0=WIf@040000003IfMT0fMWI000000@0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00l0fMWI00D0\n07l00=WIf@3IfMT0fMWI001o000?0=WIf@04001o003IfMT0fMWI001o00l0fMWI00<007l00=WIf@00\nO`003@3IfMT00`00O`00fMWI001o000<0=WIf@8007l0W`3IfMT000l0fMWI0P0000050=WIf@030000\n003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0?0=WIf@05001o\n003IfMT0fMWI0=WIf@00O`003`3IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@03001o003IfMT007l0\n00d0fMWI00<007l00=WIf@00O`00303IfMT00`00O`00fMWI0=WIf@2N0=WIf@005P3IfMT00`000000\nfMWI0=WIf@090=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT03`3IfMT01@00O`00\nfMWI0=WIf@3IfMT007l000l0fMWI00@007l00=WIf@3IfMT007l03`3IfMT00`00O`00fMWI001o000=\n0=WIf@8007l03@3IfMT2001o09l0fMWI000F0=WIf@030000003IfMT0fMWI00T0fMWI00<007l00=WI\nf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0?0=WIf@04001o003IfMT0fMWI001o0100fMWI00@007l0\n0=WIf@3IfMT007l03`3IfMT2001o00h0fMWI0P00O`2^0=WIf@005P3IfMT00`000000fMWI0=WIf@09\n0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT03`3IfMT01000O`00fMWI0=WIf@00\nO`0@0=WIf@04001o003IfMT0fMWI001o00l0fMWI0P00O`0>0=WIf@8007l0[P3IfMT001H0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00l0fMWI00@0\n07l00=WIf@3IfMT007l0403IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@8007l03P3IfMT2001o0:h0\nfMWI000F0=WIf@030000003IfMT0fMWI00T0fMWI00D007l00=WIf@3IfMT0fMWI001o000B0=WIf@04\n001o003IfMT0fMWI001o0100fMWI00<007l00=WIf@00O`00403IfMT2001o00h0fMWI0P00O`2^0=WI\nf@005P3IfMT2000000X0fMWI00D007l00=WIf@3IfMT0fMWI001o000B0=WIf@04001o003IfMT0fMWI\n001o0100fMWI00<007l00=WIf@00O`00403IfMT2001o00h0fMWI00<007l00=WIf@3IfMT0[@3IfMT0\n01H0fMWI00<000000=WIf@3IfMT02@3IfMT01@00O`00fMWI0=WIf@3IfMT007l00180fMWI00<007l0\n0=WIf@00O`004@3IfMT00`00O`00fMWI001o000@0=WIf@8007l0_P3IfMT001H0fMWI00<000000=WI\nf@3IfMT02@3IfMT01@00O`00fMWI0=WIf@3IfMT007l00180fMWI00<007l00=WIf@00O`004@3IfMT0\n0`00O`00fMWI001o000@0=WIf@03001o003IfMT0fMWI0;d0fMWI000F0=WIf@030000003IfMT0fMWI\n00T0fMWI00D007l00=WIf@3IfMT0fMWI001o000B0=WIf@03001o003IfMT007l00140fMWI00<007l0\n0=WIf@00O`00403IfMT00`00O`00fMWI0=WIf@2m0=WIf@005P3IfMT00`000000fMWI0=WIf@090=WI\nf@05001o003IfMT0fMWI0=WIf@00O`004P3IfMT00`00O`00fMWI001o000A0=WIf@03001o003IfMT0\n07l00100fMWI00<007l00=WIf@3IfMT0_@3IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT01000\nO`00fMWI0=WIf@00O`0C0=WIf@03001o003IfMT007l00140fMWI0P00O`0A0=WIf@03001o003IfMT0\nfMWI0;d0fMWI000F0=WIf@030000003IfMT0fMWI00T0fMWI00@007l00=WIf@3IfMT007l04`3IfMT0\n0`00O`00fMWI001o000A0=WIf@8007l0d@3IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT01000\nO`00fMWI0=WIf@00O`0C0=WIf@8007l04P3IfMT2001o0=40fMWI000F0=WIf@030000003IfMT0fMWI\n00T0fMWI00@007l00=WIf@3IfMT007l04`3IfMT2001o0180fMWI0P00O`3A0=WIf@005P3IfMT20000\n00X0fMWI00@007l00=WIf@3IfMT007l04`3IfMT2001o0180fMWI0P00O`3A0=WIf@005P3IfMT00`00\n0000fMWI0=WIf@090=WIf@03001o003IfMT007l001@0fMWI0P00O`0B0=WIf@8007l0d@3IfMT001H0\nfMWI00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI001o000D0=WIf@8007l0i@3IfMT001H0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI001o000D0=WIf@8007l0i@3IfMT001H0fMWI00<0\n00000=WIf@3IfMT02@3IfMT00`00O`00fMWI001o000D0=WIf@03001o003IfMT0fMWI0>@0fMWI000F\n0=WIf@030000003IfMT0fMWI00T0fMWI00<007l00=WIf@00O`00503IfMT00`00O`00fMWI0=WIf@3T\n0=WIf@005P3IfMT00`000000fMWI0=WIf@090=WIf@03001o003IfMT007l001@0fMWI00<007l00=WI\nf@3IfMT0i03IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT2001o01D0fMWI00<007l00=WIf@3I\nfMT0i03IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT2001o01D0fMWI00<007l00=WIf@3IfMT0\ni03IfMT001H0fMWI0P00000:0=WIf@8007l0o03IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT2\n001o0?`0fMWI000F0=WIf@030000003IfMT0fMWI00T0fMWI0P00O`3l0=WIf@005P3IfMT00`000000\nfMWI0=WIf@090=WIf@8007l0o03IfMT001H0fMWI00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI\n0=WIf@3k0=WIf@005P3IfMT00`000000fMWI0=WIf@090=WIf@8007l0o03IfMT001H0fMWI00<00000\n0=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@3k0=WIf@005P3IfMT00`000000fMWI0=WIf@3o0=WI\nf@P0fMWI000F0=WIf@030000003IfMT0fMWI0?l0fMWI203IfMT001H0fMWI00<000000=WIf@3IfMT0\no`3IfMT80=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00C03IfMT2000000H0\nfMWI0P0000080=WIf@800000`03IfMT004d0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI0;h0fMWI000S0=WIf@800000103IfMT300000080fMWI0`00\n00040=WIf@800000103IfMT3000000<0fMWI0`0000030=WIf@8000001@3IfMT00`000000fMWI0=WI\nf@030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0;h0fMWI000S\n0=WIf@8000000`3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI0080fMWI00@00000\n0=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@050=WIf@050000003IfMT0fMWI0=WIf@000000\n0P3IfMT01`000000fMWI0=WIf@3IfMT000000=WIf@000000103IfMT01@000000fMWI0=WIf@3IfMT0\n00000080fMWI00D000000=WIf@3IfMT0fMWI000000300=WIf@005P3IfMT8001o00@0fMWI00@00000\n0=WIf@3IfMT000000P3IfMT4000000<0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WI\nf@0000020=WIf@030000003IfMT0fMWI00D0fMWI00D000000=WIf@3IfMT0fMWI000000050=WIf@04\n0000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0\nfMWI0;h0fMWI000Q0=WIf@8000000P3IfMT200000080fMWI0P0000040=WIf@030000003IfMT0fMWI\n00<0fMWI0P0000040=WIf@<000000`3IfMT200000080fMWI1@0000001@3IfMT00000000000000000\nfMWI008000000`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0_P3IfMT0\n02l0fMWI00<000000=WIf@3IfMT0503IfMT00`000000fMWI0=WIf@0;0=WIf@050000003IfMT0fMWI\n0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2n0=WIf@00;P3IfMT200000180fMWI00<000000=WI\nf@3IfMT03`3IfMT2000000P0fMWI0P0000300=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00=03IfMT300000140fMWI\n0P0000080=WIf@800000c03IfMT003L0fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI0<X0fMWI000Q0=WIf@<0000000<0fMWI0000000000000P3IfMT3\n000000<0fMWI0`0000030=WIf@<0000000D0fMWI00000000000000000=WIf@0200000080fMWI0P00\n00050=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0<X0fMWI000F\n0=WIf@P0003o103IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00D0fMWI00D0\n00000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3I\nfMT000000P3IfMT00`000000fMWI0=WIf@020=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n1@000000fMWI0=WIf@3IfMT000000<`0fMWI000R0=WIf@040000003IfMT0fMWI00000080fMWI1000\n00040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@04\n0000003IfMT0fMWI000000L0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0\nfMWI0<X0fMWI000R0=WIf@<00000103IfMT2000000@0fMWI0P0000040=WIf@@0000000@0fMWI0000\n0000000000000P3IfMT5000000@0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0\nfMWI0<X0fMWI000R0=WIf@030000003IfMT0fMWI01D0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@050=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3:\n0=WIf@008@3IfMT2000000d0fMWI00<000000=WIf@3IfMT01P3IfMT2000000d0fMWI0P0000080=WI\nf@800000c03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.749764`, -5.11263`, 0.033933`, 0.0547955`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Simulation 2 of Bouncing Ball ", "Section"], Cell[TextData[List["When we Simulate BouncingBall a little further then it bounces faster and faster. Then the simulation fails and it looks like the ball bounces under the floor. This is called the Zeno effect.", StyleBox[" ", Rule[FontWeight, "Bold"]], "An execution of a hybrid system is called Zeno, if it takes infinitely many discrete transitions in a finite time interval. \n"]], "Text"], Cell["simulate( BouncingBall, stopTime=20 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(BouncingBall\\) : 2004-1-30 9:55:50.8560677 : \\!\\({0.`, 20.`}\\) : 860 data points : 40 events : 7 variables>\\n\\!\\({\\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"g\\\", HoldForm], \\*TagBox[\\\"height\\\", HoldForm], \\*TagBox[\\\"radius\\\", HoldForm], \\*TagBox[\\\"velocity\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"height\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"velocity\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( { height, velocity } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.047619 0.600111 0.000848238 [\n[.2619 .58761 -3 -9 ]\n[.2619 .58761 3 0 ]\n[.5 .58761 -6 -9 ]\n[.5 .58761 6 0 ]\n[.7381 .58761 -6 -9 ]\n[.7381 .58761 6 0 ]\n[.97619 .58761 -6 -9 ]\n[.97619 .58761 6 0 ]\n[1.025 .60011 0 -6.28125 ]\n[1.025 .60011 10 6.28125 ]\n[.01131 .00634 -24 -4.5 ]\n[.01131 .00634 0 4.5 ]\n[.01131 .09117 -24 -4.5 ]\n[.01131 .09117 0 4.5 ]\n[.01131 .17599 -24 -4.5 ]\n[.01131 .17599 0 4.5 ]\n[.01131 .26082 -24 -4.5 ]\n[.01131 .26082 0 4.5 ]\n[.01131 .34564 -24 -4.5 ]\n[.01131 .34564 0 4.5 ]\n[.01131 .43046 -24 -4.5 ]\n[.01131 .43046 0 4.5 ]\n[.01131 .51529 -24 -4.5 ]\n[.01131 .51529 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .60011 m\n.2619 .60636 L\ns\n[(5)] .2619 .58761 0 1 Mshowa\n.5 .60011 m\n.5 .60636 L\ns\n[(10)] .5 .58761 0 1 Mshowa\n.7381 .60011 m\n.7381 .60636 L\ns\n[(15)] .7381 .58761 0 1 Mshowa\n.97619 .60011 m\n.97619 .60636 L\ns\n[(20)] .97619 .58761 0 1 Mshowa\n.125 Mabswid\n.07143 .60011 m\n.07143 .60386 L\ns\n.11905 .60011 m\n.11905 .60386 L\ns\n.16667 .60011 m\n.16667 .60386 L\ns\n.21429 .60011 m\n.21429 .60386 L\ns\n.30952 .60011 m\n.30952 .60386 L\ns\n.35714 .60011 m\n.35714 .60386 L\ns\n.40476 .60011 m\n.40476 .60386 L\ns\n.45238 .60011 m\n.45238 .60386 L\ns\n.54762 .60011 m\n.54762 .60386 L\ns\n.59524 .60011 m\n.59524 .60386 L\ns\n.64286 .60011 m\n.64286 .60386 L\ns\n.69048 .60011 m\n.69048 .60386 L\ns\n.78571 .60011 m\n.78571 .60386 L\ns\n.83333 .60011 m\n.83333 .60386 L\ns\n.88095 .60011 m\n.88095 .60386 L\ns\n.92857 .60011 m\n.92857 .60386 L\ns\n.25 Mabswid\n0 .60011 m\n1 .60011 L\ns\ngsave\n1.025 .60011 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .00634 m\n.03006 .00634 L\ns\n[(-700)] .01131 .00634 1 0 Mshowa\n.02381 .09117 m\n.03006 .09117 L\ns\n[(-600)] .01131 .09117 1 0 Mshowa\n.02381 .17599 m\n.03006 .17599 L\ns\n[(-500)] .01131 .17599 1 0 Mshowa\n.02381 .26082 m\n.03006 .26082 L\ns\n[(-400)] .01131 .26082 1 0 Mshowa\n.02381 .34564 m\n.03006 .34564 L\ns\n[(-300)] .01131 .34564 1 0 Mshowa\n.02381 .43046 m\n.03006 .43046 L\ns\n[(-200)] .01131 .43046 1 0 Mshowa\n.02381 .51529 m\n.03006 .51529 L\ns\n[(-100)] .01131 .51529 1 0 Mshowa\n.125 Mabswid\n.02381 .02331 m\n.02756 .02331 L\ns\n.02381 .04027 m\n.02756 .04027 L\ns\n.02381 .05724 m\n.02756 .05724 L\ns\n.02381 .0742 m\n.02756 .0742 L\ns\n.02381 .10813 m\n.02756 .10813 L\ns\n.02381 .1251 m\n.02756 .1251 L\ns\n.02381 .14206 m\n.02756 .14206 L\ns\n.02381 .15903 m\n.02756 .15903 L\ns\n.02381 .19296 m\n.02756 .19296 L\ns\n.02381 .20992 m\n.02756 .20992 L\ns\n.02381 .22689 m\n.02756 .22689 L\ns\n.02381 .24385 m\n.02756 .24385 L\ns\n.02381 .27778 m\n.02756 .27778 L\ns\n.02381 .29475 m\n.02756 .29475 L\ns\n.02381 .31171 m\n.02756 .31171 L\ns\n.02381 .32867 m\n.02756 .32867 L\ns\n.02381 .3626 m\n.02756 .3626 L\ns\n.02381 .37957 m\n.02756 .37957 L\ns\n.02381 .39653 m\n.02756 .39653 L\ns\n.02381 .4135 m\n.02756 .4135 L\ns\n.02381 .44743 m\n.02756 .44743 L\ns\n.02381 .46439 m\n.02756 .46439 L\ns\n.02381 .48136 m\n.02756 .48136 L\ns\n.02381 .49832 m\n.02756 .49832 L\ns\n.02381 .53225 m\n.02756 .53225 L\ns\n.02381 .54922 m\n.02756 .54922 L\ns\n.02381 .56618 m\n.02756 .56618 L\ns\n.02381 .58315 m\n.02756 .58315 L\ns\n.02381 .61708 m\n.02756 .61708 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60096 m\n.02571 .60095 L\n.02762 .60093 L\n.02952 .6009 L\n.03143 .60085 L\n.03333 .60079 L\n.03524 .60072 L\n.03714 .60063 L\n.03905 .60053 L\n.04095 .60042 L\n.04286 .60029 L\n.04421 .6002 L\n.04421 .6002 L\n.04421 .6002 L\n.04421 .6002 L\n.04476 .60023 L\n.04667 .60035 L\n.04857 .60045 L\n.05048 .60055 L\n.05238 .60062 L\n.05429 .60069 L\n.05619 .60074 L\n.0581 .60078 L\n.06 .6008 L\n.0619 .60081 L\n.06381 .60081 L\n.06571 .6008 L\n.06762 .60077 L\n.06952 .60073 L\n.07143 .60067 L\n.07333 .6006 L\n.07524 .60052 L\n.07714 .60042 L\n.07905 .60032 L\n.08092 .6002 L\n.08092 .6002 L\n.08092 .6002 L\n.08092 .6002 L\n.08095 .6002 L\n.08286 .60031 L\n.08476 .6004 L\n.08667 .60048 L\n.08857 .60055 L\n.09048 .60061 L\n.09238 .60065 L\n.09429 .60068 L\n.09619 .60069 L\n.0981 .6007 L\n.1 .60068 L\n.1019 .60066 L\nMistroke\n.10381 .60062 L\n.10571 .60057 L\n.10762 .60051 L\n.10952 .60043 L\n.11143 .60034 L\n.11333 .60023 L\n.11397 .6002 L\n.11397 .6002 L\n.11397 .6002 L\n.11397 .6002 L\n.11524 .60026 L\n.11714 .60035 L\n.11905 .60043 L\n.12095 .60049 L\n.12286 .60054 L\n.12476 .60057 L\n.12667 .60059 L\n.12857 .6006 L\n.13048 .6006 L\n.13238 .60058 L\n.13429 .60055 L\n.13619 .6005 L\n.1381 .60044 L\n.14 .60037 L\n.1419 .60029 L\n.14371 .6002 L\n.14371 .6002 L\n.14371 .6002 L\n.14371 .6002 L\n.14381 .6002 L\n.14571 .60029 L\n.14762 .60036 L\n.14952 .60042 L\n.15143 .60047 L\n.15333 .6005 L\n.15524 .60052 L\n.15714 .60052 L\n.15905 .60052 L\n.16095 .6005 L\n.16286 .60046 L\n.16476 .60042 L\n.16667 .60036 L\n.16857 .60028 L\n.17047 .6002 L\n.17047 .6002 L\n.17047 .6002 L\n.17047 .6002 L\n.17048 .6002 L\n.17238 .60027 L\n.17429 .60034 L\nMistroke\n.17619 .60039 L\n.1781 .60043 L\n.18 .60045 L\n.1819 .60046 L\n.18381 .60046 L\n.18571 .60044 L\n.18762 .60041 L\n.18952 .60037 L\n.19143 .60032 L\n.19333 .60025 L\n.19456 .6002 L\n.19456 .6002 L\n.19456 .6002 L\n.19456 .6002 L\n.19524 .60022 L\n.19714 .60029 L\n.19905 .60034 L\n.20095 .60038 L\n.20286 .6004 L\n.20476 .60041 L\n.20667 .60041 L\n.20857 .60039 L\n.21048 .60036 L\n.21238 .60032 L\n.21429 .60027 L\n.21619 .6002 L\n.21624 .6002 L\n.21624 .6002 L\n.21624 .6002 L\n.21624 .6002 L\n.2181 .60026 L\n.22 .6003 L\n.2219 .60034 L\n.22381 .60036 L\n.22571 .60037 L\n.22762 .60037 L\n.22952 .60035 L\n.23143 .60032 L\n.23333 .60027 L\n.23524 .60021 L\n.23576 .6002 L\n.23576 .6002 L\n.23576 .6002 L\n.23576 .6002 L\n.23714 .60024 L\n.23905 .60028 L\n.24095 .60031 L\n.24286 .60033 L\n.24476 .60034 L\n.24667 .60033 L\nMistroke\n.24857 .60031 L\n.25048 .60027 L\n.25238 .60022 L\n.25332 .6002 L\n.25332 .6002 L\n.25332 .6002 L\n.25332 .6002 L\n.25429 .60022 L\n.25619 .60026 L\n.2581 .60029 L\n.26 .60031 L\n.2619 .60031 L\n.26381 .6003 L\n.26571 .60027 L\n.26762 .60024 L\n.26912 .6002 L\n.26912 .6002 L\n.26912 .6002 L\n.26912 .6002 L\n.26952 .60021 L\n.27143 .60025 L\n.27333 .60027 L\n.27524 .60029 L\n.27714 .60029 L\n.27905 .60027 L\n.28095 .60025 L\n.28286 .60021 L\n.28335 .6002 L\n.28335 .6002 L\n.28335 .6002 L\n.28335 .6002 L\n.28476 .60023 L\n.28667 .60025 L\n.28857 .60027 L\n.29048 .60027 L\n.29238 .60026 L\n.29429 .60023 L\n.29615 .6002 L\n.29615 .6002 L\n.29615 .6002 L\n.29615 .6002 L\n.29619 .6002 L\n.2981 .60023 L\n.3 .60025 L\n.3019 .60026 L\n.30381 .60025 L\n.30571 .60023 L\n.30762 .6002 L\n.30767 .6002 L\n.30767 .6002 L\nMistroke\n.30767 .6002 L\n.30767 .6002 L\n.30952 .60022 L\n.31143 .60024 L\n.31333 .60024 L\n.31524 .60023 L\n.31714 .60021 L\n.31804 .6002 L\n.31804 .6002 L\n.31804 .6002 L\n.31804 .6002 L\n.31905 .60021 L\n.32095 .60023 L\n.32286 .60024 L\n.32476 .60023 L\n.32667 .60021 L\n.32737 .6002 L\n.32737 .6002 L\n.32737 .6002 L\n.32737 .6002 L\n.32857 .60021 L\n.33048 .60023 L\n.33238 .60023 L\n.33429 .60021 L\n.33577 .6002 L\n.33577 .6002 L\n.33577 .6002 L\n.33577 .6002 L\n.33619 .6002 L\n.3381 .60022 L\n.34 .60022 L\n.3419 .60021 L\n.34333 .6002 L\n.34333 .6002 L\n.34333 .6002 L\n.34333 .6002 L\n.34381 .6002 L\n.34571 .60022 L\n.34762 .60022 L\n.34952 .6002 L\n.35013 .6002 L\n.35013 .6002 L\n.35013 .6002 L\n.35013 .6002 L\n.35143 .60021 L\n.35333 .60021 L\n.35524 .60021 L\n.35626 .6002 L\n.35626 .6002 L\n.35626 .6002 L\nMistroke\n.35626 .6002 L\n.35714 .6002 L\n.35905 .60021 L\n.36095 .6002 L\n.36177 .6002 L\n.36177 .6002 L\n.36177 .6002 L\n.36177 .6002 L\n.36286 .6002 L\n.36476 .60021 L\n.36667 .6002 L\n.36673 .6002 L\n.36673 .6002 L\n.36673 .6002 L\n.36673 .6002 L\n.36857 .6002 L\n.37048 .6002 L\n.37119 .6002 L\n.37119 .6002 L\n.37119 .6002 L\n.37119 .6002 L\n.37238 .6002 L\n.37429 .6002 L\n.37521 .6002 L\n.37521 .6002 L\n.37521 .6002 L\n.37521 .6002 L\n.37619 .6002 L\n.3781 .6002 L\n.37883 .6002 L\n.37883 .6002 L\n.37883 .6002 L\n.37883 .6002 L\n.38 .6002 L\n.3819 .6002 L\n.38208 .6002 L\n.38208 .6002 L\n.38208 .6002 L\n.38208 .6002 L\n.38381 .6002 L\n.38501 .6002 L\n.38501 .6002 L\n.38501 .6002 L\n.38501 .6002 L\n.38571 .6002 L\n.38762 .6002 L\n.38764 .6002 L\n.38764 .6002 L\n.38764 .6002 L\n.38764 .6002 L\nMistroke\n.38952 .6002 L\n.39002 .6002 L\n.39002 .6002 L\n.39002 .6002 L\n.39002 .6002 L\n.39143 .6002 L\n.39215 .6002 L\n.39215 .6002 L\n.39215 .6002 L\n.39215 .6002 L\n.39333 .6002 L\n.39407 .6002 L\n.39407 .6002 L\n.39407 .6002 L\n.39407 .6002 L\n.39524 .6002 L\n.3958 .6002 L\n.3958 .6002 L\n.3958 .6002 L\n.3958 .6002 L\n.39714 .6002 L\n.39736 .6002 L\n.39736 .6002 L\n.39736 .6002 L\n.39736 .6002 L\n.39876 .6002 L\n.39876 .6002 L\n.39876 .6002 L\n.39876 .6002 L\n.39905 .6002 L\n.40002 .6002 L\n.40002 .6002 L\n.40002 .6002 L\n.40002 .6002 L\n.40095 .6002 L\n.40115 .6002 L\n.40115 .6002 L\n.40115 .6002 L\n.40115 .6002 L\n.40218 .6002 L\n.40218 .6002 L\n.40218 .6002 L\n.40218 .6002 L\n.40286 .6002 L\n.40309 .6002 L\n.40309 .6002 L\n.40309 .6002 L\n.40309 .6002 L\n.40392 .6002 L\n.40392 .6002 L\nMistroke\n.40392 .6002 L\n.40392 .6002 L\n.40467 .6002 L\n.40467 .6002 L\n.40467 .6002 L\n.40467 .6002 L\n.40476 .6002 L\n.40534 .6002 L\n.40534 .6002 L\n.40534 .6002 L\n.40534 .6002 L\n.40594 .6002 L\n.40594 .6002 L\n.40594 .6002 L\n.40594 .6002 L\n.40648 .6002 L\n.40648 .6002 L\n.40648 .6002 L\n.40648 .6002 L\n.40667 .6002 L\n.40697 .6002 L\n.40697 .6002 L\n.40697 .6002 L\n.40697 .6002 L\n.40741 .6002 L\n.40741 .6002 L\n.40741 .6002 L\n.40741 .6002 L\n.40781 .6002 L\n.40781 .6002 L\n.40781 .6002 L\n.40781 .6002 L\n.40816 .6002 L\n.40816 .6002 L\n.40816 .6002 L\n.40816 .6002 L\n.40848 .6002 L\n.40848 .6002 L\n.40848 .6002 L\n.40848 .6002 L\n.40857 .6002 L\n.40877 .6002 L\n.40877 .6002 L\n.40877 .6002 L\n.40877 .6002 L\n.40903 .6002 L\n.40903 .6002 L\n.40903 .6002 L\n.40903 .6002 L\n.40926 .6002 L\nMistroke\n.40926 .6002 L\n.40926 .6002 L\n.40926 .6002 L\n.40947 .6002 L\n.40947 .6002 L\n.40947 .6002 L\n.40947 .6002 L\n.40966 .6002 L\n.40966 .6002 L\n.40966 .6002 L\n.40966 .6002 L\n.40983 .6002 L\n.40983 .6002 L\n.40983 .6002 L\n.40983 .6002 L\n.40999 .6002 L\n.40999 .6002 L\n.40999 .6002 L\n.40999 .6002 L\n.41012 .6002 L\n.41012 .6002 L\n.41012 .6002 L\n.41012 .6002 L\n.41025 .6002 L\n.41025 .6002 L\n.41025 .6002 L\n.41025 .6002 L\n.41036 .6002 L\n.41036 .6002 L\n.41036 .6002 L\n.41036 .6002 L\n.41046 .6002 L\n.41046 .6002 L\n.41046 .6002 L\n.41046 .6002 L\n.41048 .6002 L\n.41055 .6002 L\n.41055 .6002 L\n.41055 .6002 L\n.41055 .6002 L\n.41063 .6002 L\n.41063 .6002 L\n.41063 .6002 L\n.41063 .6002 L\n.4107 .6002 L\n.4107 .6002 L\n.4107 .6002 L\n.4107 .6002 L\n.41077 .6002 L\n.41077 .6002 L\nMistroke\n.41077 .6002 L\n.41077 .6002 L\n.41083 .6002 L\n.41083 .6002 L\n.41083 .6002 L\n.41083 .6002 L\n.41088 .6002 L\n.41088 .6002 L\n.41088 .6002 L\n.41088 .6002 L\n.41093 .6002 L\n.41093 .6002 L\n.41093 .6002 L\n.41093 .6002 L\n.41097 .6002 L\n.41097 .6002 L\n.41097 .6002 L\n.41097 .6002 L\n.41101 .6002 L\n.41101 .6002 L\n.41101 .6002 L\n.41101 .6002 L\n.41105 .6002 L\n.41105 .6002 L\n.41105 .6002 L\n.41105 .6002 L\n.41108 .6002 L\n.41108 .6002 L\n.41108 .6002 L\n.41108 .6002 L\n.41111 .6002 L\n.41111 .6002 L\n.41111 .6002 L\n.41111 .6002 L\n.41113 .6002 L\n.41113 .6002 L\n.41113 .6002 L\n.41113 .6002 L\n.41115 .6002 L\n.41115 .6002 L\n.41115 .6002 L\n.41115 .6002 L\n.41117 .6002 L\n.41117 .6002 L\n.41117 .6002 L\n.41117 .6002 L\n.41119 .6002 L\n.41119 .6002 L\n.41119 .6002 L\n.41119 .6002 L\nMistroke\n.41121 .6002 L\n.41121 .6002 L\n.41121 .6002 L\n.41121 .6002 L\n.41122 .6002 L\n.41122 .6002 L\n.41122 .6002 L\n.41122 .6002 L\n.41123 .6002 L\n.41123 .6002 L\n.41123 .6002 L\n.41123 .6002 L\n.41125 .6002 L\n.41125 .6002 L\n.41125 .6002 L\n.41125 .6002 L\n.41126 .6002 L\n.41126 .6002 L\n.41126 .6002 L\n.41126 .6002 L\n.41127 .6002 L\n.41127 .6002 L\n.41127 .6002 L\n.41127 .6002 L\n.41127 .6002 L\n.41127 .6002 L\n.41127 .6002 L\n.41127 .6002 L\n.41128 .6002 L\n.41128 .6002 L\n.41128 .6002 L\n.41128 .6002 L\n.41129 .6002 L\n.41129 .6002 L\n.41129 .6002 L\n.41129 .6002 L\n.41129 .6002 L\n.41129 .6002 L\n.41129 .6002 L\n.41129 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\nMistroke\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.4113 .6002 L\n.41131 .6002 L\n.41131 .6002 L\n.41131 .6002 L\n.41131 .6002 L\n.41131 .6002 L\n.41131 .6002 L\n.41238 .60019 L\n.41429 .60018 L\n.41619 .60015 L\n.4181 .60011 L\n.42 .60006 L\n.4219 .59999 L\n.42381 .59991 L\n.42571 .59981 L\n.42762 .59971 L\n.42952 .59959 L\n.43143 .59945 L\n.43333 .59931 L\n.43524 .59914 L\n.43714 .59897 L\n.43905 .59878 L\n.44095 .59858 L\n.44286 .59837 L\n.44476 .59814 L\n.44667 .5979 L\n.44857 .59765 L\n.45048 .59738 L\n.45238 .5971 L\n.45429 .59681 L\n.45619 .5965 L\n.4581 .59618 L\n.46 .59585 L\n.4619 .5955 L\n.46381 .59514 L\n.46571 .59476 L\n.46762 .59438 L\n.46952 .59398 L\n.47143 .59356 L\n.47333 .59314 L\n.47524 .5927 L\n.47714 .59224 L\n.47905 .59178 L\n.48095 .5913 L\n.48286 .5908 L\nMistroke\n.48476 .5903 L\n.48667 .58978 L\n.48857 .58924 L\n.49048 .5887 L\n.49238 .58814 L\n.49429 .58756 L\n.49619 .58698 L\n.4981 .58638 L\n.5 .58576 L\n.5019 .58514 L\n.50381 .5845 L\n.50571 .58384 L\n.50762 .58318 L\n.50952 .5825 L\n.51143 .5818 L\n.51333 .5811 L\n.51524 .58038 L\n.51714 .57964 L\n.51905 .5789 L\n.52095 .57814 L\n.52286 .57736 L\n.52476 .57658 L\n.52667 .57578 L\n.52857 .57497 L\n.53048 .57414 L\n.53238 .5733 L\n.53429 .57245 L\n.53619 .57158 L\n.5381 .5707 L\n.54 .56981 L\n.5419 .5689 L\n.54381 .56798 L\n.54571 .56705 L\n.54762 .5661 L\n.54952 .56514 L\n.55143 .56417 L\n.55333 .56318 L\n.55524 .56219 L\n.55714 .56117 L\n.55905 .56015 L\n.56095 .55911 L\n.56286 .55805 L\n.56476 .55699 L\n.56667 .55591 L\n.56857 .55482 L\n.57048 .55371 L\n.57238 .55259 L\n.57429 .55146 L\n.57619 .55031 L\n.5781 .54915 L\nMistroke\n.58 .54798 L\n.5819 .5468 L\n.58381 .5456 L\n.58571 .54438 L\n.58762 .54316 L\n.58952 .54192 L\n.59143 .54067 L\n.59333 .5394 L\n.59524 .53812 L\n.59714 .53683 L\n.59905 .53552 L\n.60095 .53421 L\n.60286 .53287 L\n.60476 .53153 L\n.60667 .53017 L\n.60857 .5288 L\n.61048 .52741 L\n.61238 .52601 L\n.61429 .5246 L\n.61619 .52318 L\n.6181 .52174 L\n.62 .52028 L\n.6219 .51882 L\n.62381 .51734 L\n.62571 .51585 L\n.62762 .51434 L\n.62952 .51282 L\n.63143 .51129 L\n.63333 .50975 L\n.63524 .50819 L\n.63714 .50662 L\n.63905 .50503 L\n.64095 .50343 L\n.64286 .50182 L\n.64476 .5002 L\n.64667 .49856 L\n.64857 .49691 L\n.65048 .49524 L\n.65238 .49356 L\n.65429 .49187 L\n.65619 .49017 L\n.6581 .48845 L\n.66 .48672 L\n.6619 .48497 L\n.66381 .48321 L\n.66571 .48144 L\n.66762 .47966 L\n.66952 .47786 L\n.67143 .47605 L\n.67333 .47422 L\nMistroke\n.67524 .47238 L\n.67714 .47053 L\n.67905 .46867 L\n.68095 .46679 L\n.68286 .4649 L\n.68476 .46299 L\n.68667 .46107 L\n.68857 .45914 L\n.69048 .4572 L\n.69238 .45524 L\n.69429 .45327 L\n.69619 .45128 L\n.6981 .44929 L\n.7 .44727 L\n.7019 .44525 L\n.70381 .44321 L\n.70571 .44116 L\n.70762 .4391 L\n.70952 .43702 L\n.71143 .43493 L\n.71333 .43282 L\n.71524 .43071 L\n.71714 .42857 L\n.71905 .42643 L\n.72095 .42427 L\n.72286 .4221 L\n.72476 .41992 L\n.72667 .41772 L\n.72857 .41551 L\n.73048 .41328 L\n.73238 .41105 L\n.73429 .4088 L\n.73619 .40653 L\n.7381 .40425 L\n.74 .40196 L\n.7419 .39966 L\n.74381 .39734 L\n.74571 .39501 L\n.74762 .39267 L\n.74952 .39031 L\n.75143 .38794 L\n.75333 .38555 L\n.75524 .38316 L\n.75714 .38075 L\n.75905 .37832 L\n.76095 .37589 L\n.76286 .37343 L\n.76476 .37097 L\n.76667 .36849 L\n.76857 .366 L\nMistroke\n.77048 .3635 L\n.77238 .36098 L\n.77429 .35845 L\n.77619 .35591 L\n.7781 .35335 L\n.78 .35078 L\n.7819 .3482 L\n.78381 .3456 L\n.78571 .34299 L\n.78762 .34036 L\n.78952 .33773 L\n.79143 .33508 L\n.79333 .33241 L\n.79524 .32974 L\n.79714 .32705 L\n.79905 .32434 L\n.80095 .32163 L\n.80286 .3189 L\n.80476 .31615 L\n.80667 .3134 L\n.80857 .31063 L\n.81048 .30784 L\n.81238 .30505 L\n.81429 .30224 L\n.81619 .29941 L\n.8181 .29658 L\n.82 .29373 L\n.8219 .29086 L\n.82381 .28799 L\n.82571 .2851 L\n.82762 .28219 L\n.82952 .27928 L\n.83143 .27635 L\n.83333 .2734 L\n.83524 .27045 L\n.83714 .26748 L\n.83905 .26449 L\n.84095 .2615 L\n.84286 .25849 L\n.84476 .25546 L\n.84667 .25243 L\n.84857 .24938 L\n.85048 .24631 L\n.85238 .24324 L\n.85429 .24015 L\n.85619 .23704 L\n.8581 .23393 L\n.86 .2308 L\n.8619 .22766 L\n.86381 .2245 L\nMistroke\n.86571 .22133 L\n.86762 .21815 L\n.86952 .21495 L\n.87143 .21174 L\n.87333 .20852 L\n.87524 .20528 L\n.87714 .20203 L\n.87905 .19877 L\n.88095 .19549 L\n.88286 .1922 L\n.88476 .1889 L\n.88667 .18559 L\n.88857 .18226 L\n.89048 .17891 L\n.89238 .17556 L\n.89429 .17219 L\n.89619 .16881 L\n.8981 .16541 L\n.9 .162 L\n.9019 .15858 L\n.90381 .15514 L\n.90571 .15169 L\n.90762 .14823 L\n.90952 .14476 L\n.91143 .14127 L\n.91333 .13776 L\n.91524 .13425 L\n.91714 .13072 L\n.91905 .12718 L\n.92095 .12362 L\n.92286 .12005 L\n.92476 .11647 L\n.92667 .11287 L\n.92857 .10927 L\n.93048 .10564 L\n.93238 .10201 L\n.93429 .09836 L\n.93619 .0947 L\n.9381 .09102 L\n.94 .08733 L\n.9419 .08363 L\n.94381 .07991 L\n.94571 .07619 L\n.94762 .07244 L\n.94952 .06869 L\n.95143 .06492 L\n.95333 .06114 L\n.95524 .05734 L\n.95714 .05353 L\n.95905 .04971 L\nMistroke\n.96095 .04588 L\n.96286 .04203 L\n.96476 .03817 L\n.96667 .03429 L\n.96857 .0304 L\n.97048 .0265 L\n.97238 .02259 L\n.97429 .01866 L\n.97619 .01472 L\nMfstroke\n0 .5 0 r\n.02381 .60011 m\n.02571 .59978 L\n.02762 .59945 L\n.02952 .59911 L\n.03143 .59878 L\n.03333 .59845 L\n.03524 .59811 L\n.03714 .59778 L\n.03905 .59745 L\n.04095 .59712 L\n.04286 .59678 L\n.04421 .59655 L\n.04421 .60332 L\n.04421 .60332 L\n.04421 .60332 L\n.04476 .60322 L\n.04667 .60289 L\n.04857 .60256 L\n.05048 .60222 L\n.05238 .60189 L\n.05429 .60156 L\n.05619 .60122 L\n.0581 .60089 L\n.06 .60056 L\n.0619 .60023 L\n.06381 .59989 L\n.06571 .59956 L\n.06762 .59923 L\n.06952 .59889 L\n.07143 .59856 L\n.07333 .59823 L\n.07524 .5979 L\n.07714 .59756 L\n.07905 .59723 L\n.08092 .5969 L\n.08092 .603 L\n.08092 .603 L\n.08092 .603 L\n.08095 .60299 L\n.08286 .60266 L\n.08476 .60233 L\n.08667 .60199 L\n.08857 .60166 L\n.09048 .60133 L\n.09238 .601 L\n.09429 .60066 L\n.09619 .60033 L\n.0981 .6 L\n.1 .59966 L\n.1019 .59933 L\nMistroke\n.10381 .599 L\n.10571 .59867 L\n.10762 .59833 L\n.10952 .598 L\n.11143 .59767 L\n.11333 .59733 L\n.11397 .59722 L\n.11397 .60271 L\n.11397 .60271 L\n.11397 .60271 L\n.11524 .60249 L\n.11714 .60215 L\n.11905 .60182 L\n.12095 .60149 L\n.12286 .60116 L\n.12476 .60082 L\n.12667 .60049 L\n.12857 .60016 L\n.13048 .59982 L\n.13238 .59949 L\n.13429 .59916 L\n.13619 .59883 L\n.1381 .59849 L\n.14 .59816 L\n.1419 .59783 L\n.14371 .59751 L\n.14371 .60245 L\n.14371 .60245 L\n.14371 .60245 L\n.14381 .60243 L\n.14571 .6021 L\n.14762 .60177 L\n.14952 .60143 L\n.15143 .6011 L\n.15333 .60077 L\n.15524 .60043 L\n.15714 .6001 L\n.15905 .59977 L\n.16095 .59944 L\n.16286 .5991 L\n.16476 .59877 L\n.16667 .59844 L\n.16857 .5981 L\n.17047 .59777 L\n.17047 .60222 L\n.17047 .60222 L\n.17047 .60222 L\n.17048 .60222 L\n.17238 .60188 L\n.17429 .60155 L\nMistroke\n.17619 .60122 L\n.1781 .60088 L\n.18 .60055 L\n.1819 .60022 L\n.18381 .59989 L\n.18571 .59955 L\n.18762 .59922 L\n.18952 .59889 L\n.19143 .59855 L\n.19333 .59822 L\n.19456 .59801 L\n.19456 .60201 L\n.19456 .60201 L\n.19456 .60201 L\n.19524 .60189 L\n.19714 .60155 L\n.19905 .60122 L\n.20095 .60089 L\n.20286 .60056 L\n.20476 .60022 L\n.20667 .59989 L\n.20857 .59956 L\n.21048 .59922 L\n.21238 .59889 L\n.21429 .59856 L\n.21619 .59823 L\n.21624 .59822 L\n.21624 .60182 L\n.21624 .60182 L\n.21624 .60182 L\n.2181 .60149 L\n.22 .60116 L\n.2219 .60083 L\n.22381 .60049 L\n.22571 .60016 L\n.22762 .59983 L\n.22952 .5995 L\n.23143 .59916 L\n.23333 .59883 L\n.23524 .5985 L\n.23576 .59841 L\n.23576 .60165 L\n.23576 .60165 L\n.23576 .60165 L\n.23714 .6014 L\n.23905 .60107 L\n.24095 .60074 L\n.24286 .6004 L\n.24476 .60007 L\n.24667 .59974 L\nMistroke\n.24857 .59941 L\n.25048 .59907 L\n.25238 .59874 L\n.25332 .59858 L\n.25332 .60149 L\n.25332 .60149 L\n.25332 .60149 L\n.25429 .60132 L\n.25619 .60099 L\n.2581 .60066 L\n.26 .60032 L\n.2619 .59999 L\n.26381 .59966 L\n.26571 .59933 L\n.26762 .59899 L\n.26912 .59873 L\n.26912 .60135 L\n.26912 .60135 L\n.26912 .60135 L\n.26952 .60128 L\n.27143 .60095 L\n.27333 .60062 L\n.27524 .60028 L\n.27714 .59995 L\n.27905 .59962 L\n.28095 .59929 L\n.28286 .59895 L\n.28335 .59887 L\n.28335 .60123 L\n.28335 .60123 L\n.28335 .60123 L\n.28476 .60098 L\n.28667 .60065 L\n.28857 .60032 L\n.29048 .59998 L\n.29238 .59965 L\n.29429 .59932 L\n.29615 .59899 L\n.29615 .60112 L\n.29615 .60112 L\n.29615 .60112 L\n.29619 .60111 L\n.2981 .60078 L\n.3 .60044 L\n.3019 .60011 L\n.30381 .59978 L\n.30571 .59945 L\n.30762 .59911 L\n.30767 .5991 L\n.30767 .60102 L\nMistroke\n.30767 .60102 L\n.30767 .60102 L\n.30952 .60069 L\n.31143 .60036 L\n.31333 .60003 L\n.31524 .59969 L\n.31714 .59936 L\n.31804 .5992 L\n.31804 .60093 L\n.31804 .60093 L\n.31804 .60093 L\n.31905 .60075 L\n.32095 .60042 L\n.32286 .60008 L\n.32476 .59975 L\n.32667 .59942 L\n.32737 .5993 L\n.32737 .60084 L\n.32737 .60084 L\n.32737 .60084 L\n.32857 .60064 L\n.33048 .6003 L\n.33238 .59997 L\n.33429 .59964 L\n.33577 .59938 L\n.33577 .60077 L\n.33577 .60077 L\n.33577 .60077 L\n.33619 .6007 L\n.3381 .60037 L\n.34 .60003 L\n.3419 .5997 L\n.34333 .59945 L\n.34333 .60071 L\n.34333 .60071 L\n.34333 .60071 L\n.34381 .60062 L\n.34571 .60029 L\n.34762 .59996 L\n.34952 .59962 L\n.35013 .59952 L\n.35013 .60065 L\n.35013 .60065 L\n.35013 .60065 L\n.35143 .60042 L\n.35333 .60009 L\n.35524 .59975 L\n.35626 .59958 L\n.35626 .60059 L\n.35626 .60059 L\nMistroke\n.35626 .60059 L\n.35714 .60044 L\n.35905 .6001 L\n.36095 .59977 L\n.36177 .59963 L\n.36177 .60054 L\n.36177 .60054 L\n.36177 .60054 L\n.36286 .60035 L\n.36476 .60002 L\n.36667 .59969 L\n.36673 .59968 L\n.36673 .6005 L\n.36673 .6005 L\n.36673 .6005 L\n.36857 .60018 L\n.37048 .59985 L\n.37119 .59972 L\n.37119 .60046 L\n.37119 .60046 L\n.37119 .60046 L\n.37238 .60025 L\n.37429 .59992 L\n.37521 .59976 L\n.37521 .60043 L\n.37521 .60043 L\n.37521 .60043 L\n.37619 .60026 L\n.3781 .59992 L\n.37883 .5998 L\n.37883 .6004 L\n.37883 .6004 L\n.37883 .6004 L\n.38 .60019 L\n.3819 .59986 L\n.38208 .59983 L\n.38208 .60037 L\n.38208 .60037 L\n.38208 .60037 L\n.38381 .60006 L\n.38501 .59986 L\n.38501 .60034 L\n.38501 .60034 L\n.38501 .60034 L\n.38571 .60022 L\n.38762 .59989 L\n.38764 .59988 L\n.38764 .60032 L\n.38764 .60032 L\n.38764 .60032 L\nMistroke\n.38952 .59999 L\n.39002 .5999 L\n.39002 .6003 L\n.39002 .6003 L\n.39002 .6003 L\n.39143 .60005 L\n.39215 .59992 L\n.39215 .60028 L\n.39215 .60028 L\n.39215 .60028 L\n.39333 .60007 L\n.39407 .59994 L\n.39407 .60026 L\n.39407 .60026 L\n.39407 .60026 L\n.39524 .60006 L\n.3958 .59996 L\n.3958 .60025 L\n.3958 .60025 L\n.3958 .60025 L\n.39714 .60001 L\n.39736 .59997 L\n.39736 .60023 L\n.39736 .60023 L\n.39736 .60023 L\n.39876 .59999 L\n.39876 .60022 L\n.39876 .60022 L\n.39876 .60022 L\n.39905 .60017 L\n.40002 .6 L\n.40002 .60021 L\n.40002 .60021 L\n.40002 .60021 L\n.40095 .60005 L\n.40115 .60001 L\n.40115 .6002 L\n.40115 .6002 L\n.40115 .6002 L\n.40218 .60002 L\n.40218 .60019 L\n.40218 .60019 L\n.40218 .60019 L\n.40286 .60007 L\n.40309 .60003 L\n.40309 .60018 L\n.40309 .60018 L\n.40309 .60018 L\n.40392 .60004 L\n.40392 .60018 L\nMistroke\n.40392 .60018 L\n.40392 .60018 L\n.40467 .60005 L\n.40467 .60017 L\n.40467 .60017 L\n.40467 .60017 L\n.40476 .60015 L\n.40534 .60005 L\n.40534 .60016 L\n.40534 .60016 L\n.40534 .60016 L\n.40594 .60006 L\n.40594 .60016 L\n.40594 .60016 L\n.40594 .60016 L\n.40648 .60006 L\n.40648 .60015 L\n.40648 .60015 L\n.40648 .60015 L\n.40667 .60012 L\n.40697 .60007 L\n.40697 .60015 L\n.40697 .60015 L\n.40697 .60015 L\n.40741 .60007 L\n.40741 .60015 L\n.40741 .60015 L\n.40741 .60015 L\n.40781 .60008 L\n.40781 .60014 L\n.40781 .60014 L\n.40781 .60014 L\n.40816 .60008 L\n.40816 .60014 L\n.40816 .60014 L\n.40816 .60014 L\n.40848 .60008 L\n.40848 .60014 L\n.40848 .60014 L\n.40848 .60014 L\n.40857 .60012 L\n.40877 .60009 L\n.40877 .60013 L\n.40877 .60013 L\n.40877 .60013 L\n.40903 .60009 L\n.40903 .60013 L\n.40903 .60013 L\n.40903 .60013 L\n.40926 .60009 L\nMistroke\n.40926 .60013 L\n.40926 .60013 L\n.40926 .60013 L\n.40947 .60009 L\n.40947 .60013 L\n.40947 .60013 L\n.40947 .60013 L\n.40966 .60009 L\n.40966 .60013 L\n.40966 .60013 L\n.40966 .60013 L\n.40983 .6001 L\n.40983 .60012 L\n.40983 .60012 L\n.40983 .60012 L\n.40999 .6001 L\n.40999 .60012 L\n.40999 .60012 L\n.40999 .60012 L\n.41012 .6001 L\n.41012 .60012 L\n.41012 .60012 L\n.41012 .60012 L\n.41025 .6001 L\n.41025 .60012 L\n.41025 .60012 L\n.41025 .60012 L\n.41036 .6001 L\n.41036 .60012 L\n.41036 .60012 L\n.41036 .60012 L\n.41046 .6001 L\n.41046 .60012 L\n.41046 .60012 L\n.41046 .60012 L\n.41048 .60012 L\n.41055 .6001 L\n.41055 .60012 L\n.41055 .60012 L\n.41055 .60012 L\n.41063 .6001 L\n.41063 .60012 L\n.41063 .60012 L\n.41063 .60012 L\n.4107 .6001 L\n.4107 .60012 L\n.4107 .60012 L\n.4107 .60012 L\n.41077 .60011 L\n.41077 .60012 L\nMistroke\n.41077 .60012 L\n.41077 .60012 L\n.41083 .60011 L\n.41083 .60012 L\n.41083 .60012 L\n.41083 .60012 L\n.41088 .60011 L\n.41088 .60012 L\n.41088 .60012 L\n.41088 .60012 L\n.41093 .60011 L\n.41093 .60011 L\n.41093 .60011 L\n.41093 .60011 L\n.41097 .60011 L\n.41097 .60011 L\n.41097 .60011 L\n.41097 .60011 L\n.41101 .60011 L\n.41101 .60011 L\n.41101 .60011 L\n.41101 .60011 L\n.41105 .60011 L\n.41105 .60011 L\n.41105 .60011 L\n.41105 .60011 L\n.41108 .60011 L\n.41108 .60011 L\n.41108 .60011 L\n.41108 .60011 L\n.41111 .60011 L\n.41111 .60011 L\n.41111 .60011 L\n.41111 .60011 L\n.41113 .60011 L\n.41113 .60011 L\n.41113 .60011 L\n.41113 .60011 L\n.41115 .60011 L\n.41115 .60011 L\n.41115 .60011 L\n.41115 .60011 L\n.41117 .60011 L\n.41117 .60011 L\n.41117 .60011 L\n.41117 .60011 L\n.41119 .60011 L\n.41119 .60011 L\n.41119 .60011 L\n.41119 .60011 L\nMistroke\n.41121 .60011 L\n.41121 .60011 L\n.41121 .60011 L\n.41121 .60011 L\n.41122 .60011 L\n.41122 .60011 L\n.41122 .60011 L\n.41122 .60011 L\n.41123 .60011 L\n.41123 .60011 L\n.41123 .60011 L\n.41123 .60011 L\n.41125 .60011 L\n.41125 .60011 L\n.41125 .60011 L\n.41125 .60011 L\n.41126 .60011 L\n.41126 .60011 L\n.41126 .60011 L\n.41126 .60011 L\n.41127 .60011 L\n.41127 .60011 L\n.41127 .60011 L\n.41127 .60011 L\n.41127 .60011 L\n.41127 .60011 L\n.41127 .60011 L\n.41127 .60011 L\n.41128 .60011 L\n.41128 .60011 L\n.41128 .60011 L\n.41128 .60011 L\n.41129 .60011 L\n.41129 .60011 L\n.41129 .60011 L\n.41129 .60011 L\n.41129 .60011 L\n.41129 .60011 L\n.41129 .60011 L\n.41129 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\nMistroke\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.4113 .60011 L\n.41131 .60011 L\n.41131 .60011 L\n.41131 .60011 L\n.41131 .60011 L\n.41131 .60011 L\n.41131 .60011 L\n.41238 .59992 L\n.41429 .59959 L\n.41619 .59926 L\n.4181 .59892 L\n.42 .59859 L\n.4219 .59826 L\n.42381 .59793 L\n.42571 .59759 L\n.42762 .59726 L\n.42952 .59693 L\n.43143 .59659 L\n.43333 .59626 L\n.43524 .59593 L\n.43714 .5956 L\n.43905 .59526 L\n.44095 .59493 L\n.44286 .5946 L\n.44476 .59426 L\n.44667 .59393 L\n.44857 .5936 L\n.45048 .59327 L\n.45238 .59293 L\n.45429 .5926 L\n.45619 .59227 L\n.4581 .59193 L\n.46 .5916 L\n.4619 .59127 L\n.46381 .59094 L\n.46571 .5906 L\n.46762 .59027 L\n.46952 .58994 L\n.47143 .58961 L\n.47333 .58927 L\n.47524 .58894 L\n.47714 .58861 L\n.47905 .58827 L\n.48095 .58794 L\n.48286 .58761 L\nMistroke\n.48476 .58728 L\n.48667 .58694 L\n.48857 .58661 L\n.49048 .58628 L\n.49238 .58594 L\n.49429 .58561 L\n.49619 .58528 L\n.4981 .58495 L\n.5 .58461 L\n.5019 .58428 L\n.50381 .58395 L\n.50571 .58361 L\n.50762 .58328 L\n.50952 .58295 L\n.51143 .58262 L\n.51333 .58228 L\n.51524 .58195 L\n.51714 .58162 L\n.51905 .58128 L\n.52095 .58095 L\n.52286 .58062 L\n.52476 .58029 L\n.52667 .57995 L\n.52857 .57962 L\n.53048 .57929 L\n.53238 .57895 L\n.53429 .57862 L\n.53619 .57829 L\n.5381 .57796 L\n.54 .57762 L\n.5419 .57729 L\n.54381 .57696 L\n.54571 .57662 L\n.54762 .57629 L\n.54952 .57596 L\n.55143 .57563 L\n.55333 .57529 L\n.55524 .57496 L\n.55714 .57463 L\n.55905 .57429 L\n.56095 .57396 L\n.56286 .57363 L\n.56476 .5733 L\n.56667 .57296 L\n.56857 .57263 L\n.57048 .5723 L\n.57238 .57196 L\n.57429 .57163 L\n.57619 .5713 L\n.5781 .57097 L\nMistroke\n.58 .57063 L\n.5819 .5703 L\n.58381 .56997 L\n.58571 .56963 L\n.58762 .5693 L\n.58952 .56897 L\n.59143 .56864 L\n.59333 .5683 L\n.59524 .56797 L\n.59714 .56764 L\n.59905 .5673 L\n.60095 .56697 L\n.60286 .56664 L\n.60476 .56631 L\n.60667 .56597 L\n.60857 .56564 L\n.61048 .56531 L\n.61238 .56497 L\n.61429 .56464 L\n.61619 .56431 L\n.6181 .56398 L\n.62 .56364 L\n.6219 .56331 L\n.62381 .56298 L\n.62571 .56264 L\n.62762 .56231 L\n.62952 .56198 L\n.63143 .56165 L\n.63333 .56131 L\n.63524 .56098 L\n.63714 .56065 L\n.63905 .56031 L\n.64095 .55998 L\n.64286 .55965 L\n.64476 .55932 L\n.64667 .55898 L\n.64857 .55865 L\n.65048 .55832 L\n.65238 .55798 L\n.65429 .55765 L\n.65619 .55732 L\n.6581 .55699 L\n.66 .55665 L\n.6619 .55632 L\n.66381 .55599 L\n.66571 .55565 L\n.66762 .55532 L\n.66952 .55499 L\n.67143 .55466 L\n.67333 .55432 L\nMistroke\n.67524 .55399 L\n.67714 .55366 L\n.67905 .55332 L\n.68095 .55299 L\n.68286 .55266 L\n.68476 .55233 L\n.68667 .55199 L\n.68857 .55166 L\n.69048 .55133 L\n.69238 .55099 L\n.69429 .55066 L\n.69619 .55033 L\n.6981 .55 L\n.7 .54966 L\n.7019 .54933 L\n.70381 .549 L\n.70571 .54866 L\n.70762 .54833 L\n.70952 .548 L\n.71143 .54767 L\n.71333 .54733 L\n.71524 .547 L\n.71714 .54667 L\n.71905 .54633 L\n.72095 .546 L\n.72286 .54567 L\n.72476 .54534 L\n.72667 .545 L\n.72857 .54467 L\n.73048 .54434 L\n.73238 .544 L\n.73429 .54367 L\n.73619 .54334 L\n.7381 .54301 L\n.74 .54267 L\n.7419 .54234 L\n.74381 .54201 L\n.74571 .54167 L\n.74762 .54134 L\n.74952 .54101 L\n.75143 .54068 L\n.75333 .54034 L\n.75524 .54001 L\n.75714 .53968 L\n.75905 .53934 L\n.76095 .53901 L\n.76286 .53868 L\n.76476 .53835 L\n.76667 .53801 L\n.76857 .53768 L\nMistroke\n.77048 .53735 L\n.77238 .53701 L\n.77429 .53668 L\n.77619 .53635 L\n.7781 .53602 L\n.78 .53568 L\n.7819 .53535 L\n.78381 .53502 L\n.78571 .53468 L\n.78762 .53435 L\n.78952 .53402 L\n.79143 .53369 L\n.79333 .53335 L\n.79524 .53302 L\n.79714 .53269 L\n.79905 .53236 L\n.80095 .53202 L\n.80286 .53169 L\n.80476 .53136 L\n.80667 .53102 L\n.80857 .53069 L\n.81048 .53036 L\n.81238 .53003 L\n.81429 .52969 L\n.81619 .52936 L\n.8181 .52903 L\n.82 .52869 L\n.8219 .52836 L\n.82381 .52803 L\n.82571 .5277 L\n.82762 .52736 L\n.82952 .52703 L\n.83143 .5267 L\n.83333 .52636 L\n.83524 .52603 L\n.83714 .5257 L\n.83905 .52537 L\n.84095 .52503 L\n.84286 .5247 L\n.84476 .52437 L\n.84667 .52403 L\n.84857 .5237 L\n.85048 .52337 L\n.85238 .52304 L\n.85429 .5227 L\n.85619 .52237 L\n.8581 .52204 L\n.86 .5217 L\n.8619 .52137 L\n.86381 .52104 L\nMistroke\n.86571 .52071 L\n.86762 .52037 L\n.86952 .52004 L\n.87143 .51971 L\n.87333 .51937 L\n.87524 .51904 L\n.87714 .51871 L\n.87905 .51838 L\n.88095 .51804 L\n.88286 .51771 L\n.88476 .51738 L\n.88667 .51704 L\n.88857 .51671 L\n.89048 .51638 L\n.89238 .51605 L\n.89429 .51571 L\n.89619 .51538 L\n.8981 .51505 L\n.9 .51471 L\n.9019 .51438 L\n.90381 .51405 L\n.90571 .51372 L\n.90762 .51338 L\n.90952 .51305 L\n.91143 .51272 L\n.91333 .51238 L\n.91524 .51205 L\n.91714 .51172 L\n.91905 .51139 L\n.92095 .51105 L\n.92286 .51072 L\n.92476 .51039 L\n.92667 .51005 L\n.92857 .50972 L\n.93048 .50939 L\n.93238 .50906 L\n.93429 .50872 L\n.93619 .50839 L\n.9381 .50806 L\n.94 .50772 L\n.9419 .50739 L\n.94381 .50706 L\n.94571 .50673 L\n.94762 .50639 L\n.94952 .50606 L\n.95143 .50573 L\n.95333 .50539 L\n.95524 .50506 L\n.95714 .50473 L\n.95905 .5044 L\nMistroke\n.96095 .50406 L\n.96286 .50373 L\n.96476 .5034 L\n.96667 .50306 L\n.96857 .50273 L\n.97048 .5024 L\n.97238 .50207 L\n.97429 .50173 L\n.97619 .5014 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(velocity) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(@) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n123.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(height) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00403IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT2000000@0\nfMWI00<000000=WIf@3IfMT0o03IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@04\n0000003IfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI0000003n0=WIf@00403IfMT01@00\n0000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@3IfMT300000?`0fMWI00080=WIf@@000001@3IfMT010000000fMWI0=WIf@0000020=WIf@040000\n003IfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI0000003n0=WIf@003P3IfMT010000000\nfMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3I\nfMT00`000000fMWI0=WIf@3N0=WIf@030000o`3IfMT0fMWI01/0fMWI000>0=WIf@@000000`3IfMT2\n000000@0fMWI0P0000040=WIf@030000003IfMT0fMWI0=d0fMWI00<0003o0=WIf@3IfMT0703IfMT0\n0240fMWI0P00003N0=WIf@030000o`3IfMT0fMWI01`0fMWI000Q0=WIf@030000003IfMT0fMWI0=d0\nfMWI00<0003o0=WIf@3IfMT0703IfMT00240fMWI00<000000=WIf@3IfMT0g03IfMT00`000?l0fMWI\n0=WIf@0M0=WIf@008@3IfMT00`000000fMWI0=WIf@3K0=WIf@030000o`3IfMT0fMWI01h0fMWI000Q\n0=WIf@800000g03IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3IfMT00`000000fMWI0=WIf@3J0=WI\nf@030000o`3IfMT0fMWI01l0fMWI000Q0=WIf@030000003IfMT0fMWI0=X0fMWI00<0003o0=WIf@3I\nfMT07`3IfMT00240fMWI00<000000=WIf@3IfMT0f@3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3I\nfMT200000=X0fMWI00<0003o0=WIf@3IfMT0803IfMT00240fMWI00<000000=WIf@3IfMT0f@3IfMT0\n0`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@3H0=WIf@030000o`3IfMT0fMWI\n0240fMWI000Q0=WIf@030000003IfMT0fMWI0=L0fMWI0P000?lS0=WIf@008@3IfMT200000=P0fMWI\n00<0003o0=WIf@3IfMT08P3IfMT00240fMWI00<000000=WIf@3IfMT0eP3IfMT00`000?l0fMWI0=WI\nf@0S0=WIf@003P3IfMT3000000@0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@3F\n0=WIf@030000o`3IfMT0fMWI02<0fMWI000>0=WIf@040000003IfMT0fMWI00000080fMWI00@00000\n0=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0=D0fMWI\n00<0003o0=WIf@3IfMT0903IfMT000h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000000<0fMWI0`00003E0=WIf@030000o`3IfMT0fMWI\n02@0fMWI00080=WIf@@000000P3IfMT3000000<0fMWI00@000000=WIf@3IfMT000000P3IfMT01000\n0000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0=D0fMWI00<0003o0=WIf@3IfMT0903IfMT0\n00l0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0\nfMWI000000<0fMWI00<000000=WIf@3IfMT0e03IfMT00`000?l0fMWI0=WIf@0U0=WIf@003`3IfMT3\n000000<0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@3C0=WIf@030000o`3IfMT0\nfMWI02H0fMWI000Q0=WIf@800000e03IfMT00`000?l0fMWI0=WIf@0V0=WIf@008@3IfMT00`000000\nfMWI0=WIf@3B0=WIf@030000o`3IfMT0fMWI02L0fMWI000Q0=WIf@030000003IfMT0fMWI0=80fMWI\n00<0003o0=WIf@3IfMT09`3IfMT00240fMWI00<000000=WIf@3IfMT0d@3IfMT00`000?l0fMWI0=WI\nf@0X0=WIf@008@3IfMT200000=40fMWI00<0003o0=WIf@3IfMT0:@3IfMT00240fMWI00<000000=WI\nf@3IfMT0d03IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000fMWI0=WIf@3@0=WIf@03\n0000o`3IfMT0fMWI02T0fMWI000Q0=WIf@030000003IfMT0fMWI0<l0fMWI00<0003o0=WIf@3IfMT0\n:P3IfMT00240fMWI0P00003?0=WIf@80003o;03IfMT00240fMWI00<000000=WIf@3IfMT0cP3IfMT0\n0`000?l0fMWI0=WIf@0[0=WIf@008@3IfMT00`000000fMWI0=WIf@3=0=WIf@030000o`3IfMT0fMWI\n02`0fMWI000Q0=WIf@030000003IfMT0fMWI0<d0fMWI00<0003o0=WIf@3IfMT0;03IfMT00240fMWI\n0P00003=0=WIf@030000o`3IfMT0fMWI02d0fMWI000Q0=WIf@030000003IfMT0fMWI0<`0fMWI00<0\n003o0=WIf@3IfMT0;@3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<00000\n0=WIf@3IfMT0b`3IfMT00`000?l0fMWI0=WIf@0^0=WIf@003P3IfMT010000000fMWI0=WIf@000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI\n0=WIf@3;0=WIf@030000o`3IfMT0fMWI02h0fMWI000A0=WIf@040000003IfMT0fMWI00000080fMWI\n00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@3IfMT300000<X0fMWI00<0003o0=WI\nf@3IfMT0;`3IfMT000P0fMWI100000030=WIf@8000000`3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0b@3IfMT20000oc40fMWI000?0=WI\nf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00\n00030=WIf@030000003IfMT0fMWI0<T0fMWI00<0003o0=WIf@3IfMT0<03IfMT000l0fMWI0`000003\n0=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0b03IfMT00`000?l0fMWI0=WIf@0a\n0=WIf@008@3IfMT200000<P0fMWI0P000?lc0=WIf@008@3IfMT00`000000fMWI0=WIf@370=WIf@03\n0000o`3IfMT0fMWI0380fMWI000Q0=WIf@030000003IfMT0fMWI0<L0fMWI00<0003o0=WIf@3IfMT0\n<P3IfMT00240fMWI00<000000=WIf@3IfMT0aP3IfMT00`000?l0fMWI0=WIf@0c0=WIf@008@3IfMT2\n00000<H0fMWI0P000?le0=WIf@008@3IfMT00`000000fMWI0=WIf@350=WIf@030000o`3IfMT0fMWI\n03@0fMWI000Q0=WIf@030000003IfMT0fMWI0<@0fMWI00<0003o0=WIf@3IfMT0=@3IfMT00240fMWI\n00<000000=WIf@3IfMT0``3IfMT20000ocL0fMWI000Q0=WIf@800000a03IfMT00`000?l0fMWI0=WI\nf@0f0=WIf@008@3IfMT00`000000fMWI0=WIf@320=WIf@80003o>03IfMT00240fMWI00<000000=WI\nf@3IfMT0`P3IfMT00`000?l0fMWI0=WIf@0g0=WIf@008@3IfMT00`000000fMWI0=WIf@310=WIf@03\n0000o`3IfMT0fMWI03P0fMWI000Q0=WIf@800000`@3IfMT20000ocX0fMWI000Q0=WIf@030000003I\nfMT0fMWI0<00fMWI00<0003o0=WIf@3IfMT0>@3IfMT00100fMWI0`0000020=WIf@800000103IfMT2\n000000@0fMWI00<000000=WIf@3IfMT0_`3IfMT00`000?l0fMWI0=WIf@0j0=WIf@004@3IfMT01000\n0000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI\n000000310=WIf@030000o`3IfMT0fMWI03X0fMWI000>0=WIf@D0000000D0fMWI0000003IfMT0fMWI\n000000020=WIf@040000003IfMT0fMWI000000<0fMWI0`00002n0=WIf@030000o`3IfMT0fMWI03/0\nfMWI00080=WIf@@000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0000\n0080fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@2m0=WIf@80003o?@3IfMT0\n00l0fMWI00<000000=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0\nfMWI000000<0fMWI00<000000=WIf@3IfMT0_@3IfMT00`000?l0fMWI0=WIf@0l0=WIf@00403IfMT2\n000000<0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@2l0=WIf@030000o`3IfMT0\nfMWI03d0fMWI000Q0=WIf@800000_03IfMT00`000?l0fMWI0=WIf@0n0=WIf@008@3IfMT00`000000\nfMWI0=WIf@2k0=WIf@030000o`3IfMT0fMWI03h0fMWI000Q0=WIf@030000003IfMT0fMWI0;X0fMWI\n00<0003o0=WIf@3IfMT0?`3IfMT00240fMWI00<000000=WIf@3IfMT0^P3IfMT00`000?l0fMWI0=WI\nf@0o0=WIf@008@3IfMT200000;X0fMWI00<0003o0=WIf@3IfMT0@03IfMT00240fMWI00<000000=WI\nf@3IfMT0^03IfMT00`000?l0fMWI0=WIf@110=WIf@008@3IfMT00`000000fMWI0=WIf@2g0=WIf@80\n003o@`3IfMT00240fMWI00<000000=WIf@3IfMT0]`3IfMT00`000?l0fMWI0=WIf@120=WIf@008@3I\nfMT200000;L0fMWI00<0003o0=WIf@3IfMT0@`3IfMT00240fMWI00<000000=WIf@3IfMT0]P3IfMT0\n0`000?l0fMWI0=WIf@130=WIf@008@3IfMT00`000000fMWI0=WIf@2e0=WIf@030000o`3IfMT0fMWI\n04@0fMWI000Q0=WIf@030000003IfMT0fMWI0;@0fMWI00<0003o0=WIf@3IfMT0A@3IfMT00240fMWI\n0P00002d0=WIf@030000o`3IfMT0fMWI04H0fMWI000Q0=WIf@030000003IfMT0fMWI0;80fMWI0P00\n0?m80=WIf@003`3IfMT2000000@0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@2b\n0=WIf@030000o`3IfMT0fMWI04L0fMWI000>0=WIf@040000003IfMT0fMWI00000080fMWI00@00000\n0=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0;40fMWI\n00<0003o0=WIf@3IfMT0B03IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000\n003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT0fMWI0`00002`0=WIf@80003oBP3IfMT000P0\nfMWI100000050=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT0\n1@000000fMWI0=WIf@3IfMT000000;80fMWI00<0003o0=WIf@3IfMT0B@3IfMT000h0fMWI00@00000\n0=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000<0\nfMWI00<000000=WIf@3IfMT0[`3IfMT00`000?l0fMWI0=WIf@1:0=WIf@003`3IfMT2000000@0fMWI\n0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@2^0=WIf@030000o`3IfMT0fMWI04/0fMWI\n000Q0=WIf@800000[P3IfMT00`000?l0fMWI0=WIf@1<0=WIf@008@3IfMT00`000000fMWI0=WIf@2]\n0=WIf@030000o`3IfMT0fMWI04`0fMWI000Q0=WIf@030000003IfMT0fMWI0:`0fMWI00<0003o0=WI\nf@3IfMT0C@3IfMT00240fMWI00<000000=WIf@3IfMT0Z`3IfMT00`000?l0fMWI0=WIf@1>0=WIf@00\n8@3IfMT200000:/0fMWI0P000?m@0=WIf@008@3IfMT00`000000fMWI0=WIf@2Y0=WIf@80003oD@3I\nfMT00240fMWI00<000000=WIf@3IfMT0Z@3IfMT00`000?l0fMWI0=WIf@1@0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2X0=WIf@030000o`3IfMT0fMWI0540fMWI000Q0=WIf@800000Z03IfMT00`000?l0\nfMWI0=WIf@1B0=WIf@008@3IfMT00`000000fMWI0=WIf@2V0=WIf@80003oE03IfMT00240fMWI00<0\n00000=WIf@3IfMT0Y@3IfMT20000oeD0fMWI000Q0=WIf@030000003IfMT0fMWI0:@0fMWI0P000?mF\n0=WIf@008@3IfMT200000:D0fMWI00<0003o0=WIf@3IfMT0E@3IfMT00240fMWI00<000000=WIf@3I\nfMT0X`3IfMT00`000?l0fMWI0=WIf@1F0=WIf@003P3IfMT4000000<0fMWI0P0000040=WIf@800000\n103IfMT00`000000fMWI0=WIf@2R0=WIf@030000o`3IfMT0fMWI05L0fMWI000>0=WIf@030000003I\nfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@03\n0000003IfMT0fMWI0:40fMWI00<0003o0=WIf@3IfMT0F03IfMT000l0fMWI00<000000=WIf@3IfMT0\n0P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000<0fMWI0`00002P0=WI\nf@030000o`3IfMT0fMWI05T0fMWI00080=WIf@@00000103IfMT01@000000fMWI0=WIf@3IfMT00000\n0080fMWI00@000000=WIf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT000000:40fMWI0P00\n0?mK0=WIf@003P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI\n00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@2N0=WIf@80003oG03IfMT000l0fMWI\n0P0000040=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0W@3IfMT20000oed0fMWI\n000Q0=WIf@800000W@3IfMT20000oeh0fMWI000Q0=WIf@030000003IfMT0fMWI09/0fMWI0P000?mO\n0=WIf@008@3IfMT00`000000fMWI0=WIf@2K0=WIf@030000o`3IfMT0fMWI05h0fMWI000Q0=WIf@03\n0000003IfMT0fMWI09T0fMWI0P000?mQ0=WIf@008@3IfMT2000009T0fMWI0P000?mR0=WIf@008@3I\nfMT00`000000fMWI0=WIf@2G0=WIf@80003oH`3IfMT00240fMWI00<000000=WIf@3IfMT0U`3IfMT0\n0`000?l0fMWI0=WIf@1R0=WIf@008@3IfMT00`000000fMWI0=WIf@2E0=WIf@80003oI@3IfMT00240\nfMWI0P00002E0=WIf@80003oIP3IfMT00240fMWI00<000000=WIf@3IfMT0T`3IfMT20000ofL0fMWI\n000Q0=WIf@030000003IfMT0fMWI0980fMWI0P000?mX0=WIf@008@3IfMT00`000000fMWI0=WIf@2A\n0=WIf@80003oJ@3IfMT00240fMWI0P00002A0=WIf@030000o`3IfMT0fMWI06T0fMWI000Q0=WIf@03\n0000003IfMT0fMWI08h0fMWI0P000?m90=WIf@H007l07@3IfMT000h0fMWI1@0000020=WIf@800000\n103IfMT2000000@0fMWI00<000000=WIf@3IfMT0SP3IfMT00`000?l0fMWI0=WIf@120=WIf@H007l0\n8`3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080\nfMWI00D000000=WIf@3IfMT0fMWI0000002>0=WIf@80003o?`3IfMT6001o02T0fMWI000@0=WIf@05\n0000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0\nfMWI0=WIf@<00000R`3IfMT20000ocX0fMWI1`00O`0^0=WIf@00203IfMT4000000@0fMWI00D00000\n0=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0\nfMWI0000002<0=WIf@030000o`3IfMT0fMWI03D0fMWI1P00O`0d0=WIf@00403IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT0\n000008X0fMWI0P000?lb0=WIf@H007l0>P3IfMT000l0fMWI0P0000040=WIf@800000103IfMT20000\n00@0fMWI00<000000=WIf@3IfMT0Q`3IfMT20000obd0fMWI1`00O`0o0=WIf@008@3IfMT2000008H0\nfMWI0P000?lZ0=WIf@H007l0A@3IfMT00240fMWI00<000000=WIf@3IfMT0Q03IfMT20000obD0fMWI\n1P00O`1;0=WIf@008@3IfMT00`000000fMWI0=WIf@220=WIf@80003o8@3IfMT6001o0540fMWI000Q\n0=WIf@030000003IfMT0fMWI0840fMWI0P000?lM0=WIf@H007l0EP3IfMT00240fMWI0P0000200=WI\nf@<0003o603IfMT6001o05`0fMWI000Q0=WIf@030000003IfMT0fMWI03D0fMWI0P00000b0=WIf@D0\n00000P3IfMT2000000/0fMWI0`000?lD0=WIf@H007l01`3IfMT500000080fMWI0P00000_0=WIf@@0\n00000`3IfMT2000001X0fMWI000Q0=WIf@030000003IfMT0fMWI03@0fMWI00@000000=WIf@3IfMT0\n0000<`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT01`3IfMT20000\noa00fMWI1P00O`0?0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0/\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000006@3IfMT00240fMWI00<00000\n0=WIf@3IfMT0=`3IfMT00`000000fMWI0=WIf@0a0=WIf@050000003IfMT0fMWI0=WIf@0000000P3I\nfMT00`000000fMWI0=WIf@050=WIf@80003o3@3IfMT6001o01@0fMWI00<000000=WIf@3IfMT0103I\nfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT00000\n6@3IfMT00240fMWI0P00000f0=WIf@800000=03IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00<000000=WIf@3IfMT00`3IfMT20000o`T0fMWI1P00O`0J0=WIf@030000003IfMT0fMWI0080fMWI\n0P00000a0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@0G0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0e0=WIf@030000003IfMT0fMWI03<0fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@030000003IfMT0fMWI00<0003o1@3IfMT6001o0200fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0=WIf@0^0=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WI\nf@3IfMT000006@3IfMT00240fMWI00<000000=WIf@3IfMT0=@3IfMT300000380fMWI0P0000040=WI\nf@80000000@0fMWI0000o`000?l0003o0P3IfMT6001o02@0fMWI0P0000040=WIf@<00000;`3IfMT2\n000000@0fMWI0P00000J0=WIf@008@3IfMT00`000000fMWI0=WIf@1`0=WIf@80003o1P00O`240=WI\nf@008@3IfMT2000006d0fMWI1P00O`2:0=WIf@008@3IfMT00`000000fMWI0=WIf@1V0=WIf@H007l0\n0P000?n>0=WIf@008@3IfMT00`000000fMWI0=WIf@1Q0=WIf@H007l010000?n20=WIf@8000003@3I\nfMT00240fMWI00<000000=WIf@00O`000`00O`000`000?l0fMWI0=WIf@030=WIf@<007l01@3IfMT3\n001o00@0fMWI0`00O`040=WIf@8007l0103IfMT2001o00<0fMWI0P00O`030=WIf@04001o00000?l0\nfMWI0=WIf@8007l00P3IfMT01@00O`00003o0=WIf@3IfMT0003o0080fMWI00d0003o0=WIf@3IfMT0\n07l00=WIf@000?l0fMWI0000o`3IfMT0003o0=WIf@000?l0fMWI008007l000<0fMWI001o0000O`00\n2P00O`000`3IfMT007l0001o0004001o00H0003oQ@3IfMT010000000fMWI0=WIf@00000<0=WIf@00\n703IfMT5000000<007l00P000?l7001o0080003o1P00O`020000o`H007l000<0003o001o0000O`00\n0`00O`000`000?l007l0001o000i001o00D0003oQ@0000070=WIf@030000003IfMT0fMWI00d0fMWI\n000Q0=WIf@030000003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0103IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@008@3IfMT00`000000fMWI0=WIf@3/\n0=WIf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@030000003IfMT0fMWI0?`0fMWI000Q0=WIf@80\n0000o@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT004`0fMWI0P0000060=WIf@800000203IfMT200000<00fMWI001=\n0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@2n\n0=WIf@008`3IfMT2000000@0fMWI0`0000020=WIf@<00000103IfMT2000000@0fMWI0`0000030=WI\nf@<000000`3IfMT2000000D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WI\nf@800000103IfMT00`000000fMWI0=WIf@2n0=WIf@008`3IfMT2000000<0fMWI00<000000=WIf@3I\nfMT0103IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT01@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00L000000=WIf@3IfMT0fMWI0000\n003IfMT0000000@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WI\nf@000000`03IfMT001H0fMWI2000O`040=WIf@040000003IfMT0fMWI00000080fMWI100000030=WI\nf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@05\n0=WIf@050000003IfMT0fMWI0=WIf@0000001@3IfMT010000000fMWI0=WIf@0000040=WIf@050000\n003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2n0=WIf@008@3IfMT200000080fMWI\n0P0000020=WIf@800000103IfMT00`000000fMWI0=WIf@030=WIf@800000103IfMT3000000<0fMWI\n0P0000020=WIf@D0000000D0fMWI00000000000000000=WIf@02000000<0fMWI00<000000=WIf@3I\nfMT01@0000030=WIf@030000003IfMT0fMWI0;h0fMWI000_0=WIf@030000003IfMT0fMWI01@0fMWI\n00<000000=WIf@3IfMT02`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3I\nfMT0_P3IfMT002h0fMWI0P00000B0=WIf@030000003IfMT0fMWI00l0fMWI0P0000080=WIf@800000\n`03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT003@0fMWI0`00000A0=WIf@800000203IfMT200000<`0fMWI000g0=WI\nf@030000003IfMT0fMWI00h0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3:0=WI\nf@008@3IfMT3000000030=WIf@00000000000080fMWI0`0000030=WIf@<000000`3IfMT300000005\n0=WIf@00000000000000003IfMT00P0000020=WIf@8000001@3IfMT00`000000fMWI0=WIf@020=WI\nf@800000103IfMT00`000000fMWI0=WIf@3:0=WIf@005P3IfMT80000o`@0fMWI00@000000=WIf@3I\nfMT000000P3IfMT00`000000fMWI0=WIf@050=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT0\n10000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0\n0P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000003<0=WI\nf@008P3IfMT010000000fMWI0=WIf@0000020=WIf@@00000103IfMT01@000000fMWI0=WIf@3IfMT0\n00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000070=WIf@050000\n003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3:0=WIf@008P3IfMT3000000@0fMWI\n0P0000040=WIf@800000103IfMT4000000040=WIf@000000000000000080fMWI1@0000040=WIf@03\n0000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@3:0=WIf@008P3IfMT00`000000fMWI\n0=WIf@0E0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@3IfMT01@000000fMWI\n0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0bP3IfMT00240fMWI0P00000=0=WIf@030000\n003IfMT0fMWI00H0fMWI0P00000=0=WIf@800000203IfMT200000<`0fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-3.02449`, -793.034`, 0.0890933`, 5.00158`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[923, 788]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]