List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Redeclarations of Annotation Choices", "Title"], Cell[TextData[List["\nThe user interface can suggest reasonable redeclarations, where the string comment in the choice declaration can be used as a textual explanation of a choice. Based on the interactions with the user, the GUI  then generates the appropriate Modelica code. The annotation can also be used as a hint to the user doing textual Modelica programming. In order to support this mode of operation, an ", StyleBox["annotation", Rule[FontFamily, "Courier"]], " called ", StyleBox["choices", Rule[FontFamily, "Courier"]], " containing choice elements is predefined to be recognized with certain semantics in Modelica, including recognition of redeclaration statements in the annotation. "]], "Text"], Cell[CellGroupData[List[Cell["Resistor", "Section"], Cell["class Resistor \t\t\t\t\t\t\t\"Ideal linear electrical Resistor\"\n  extends TwoPin;\t\t\t\t\t\t// Same as OnePort\n  parameter Real R(unit = \"Ohm\") \t\t\"Resistance\";\nequation\n  R*i = v;\nend Resistor;  \t\t\t\t\t\t\t// From Modelica.Electrical.Analog.Basic ", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["MyResistor", "Section"], Cell["model ReplResistor\nreplaceable model MyResistor = Resistor \n  annotation(choices(\n  \t \t\t          choice(redeclare model MyResistor = lib2.Resistor(a={2})),\t\n  \t\t\t          choice(redeclare model MyResistor = lib2.Resistor)\n  \t\t\t        )\n  \t\t\t );\nend ReplResistor;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["If the user would choose the first alternative, the following code might be produced if ", StyleBox["MyResistor", Rule[FontFamily, "Courier"]], " is part of the class ", StyleBox["MyCircuit", Rule[FontFamily, "Courier"]], " and the chosen name of the instantiated component is x:"]], "Text"], Cell["\t\t\tMyCircuit x(redeclare MyResistor=lib2.Resistor(a={2}))", "Program"], Cell["Additional examples of replaceable class declarations with redeclaration choices are shown below.", "Text"]], Open]], Cell[CellGroupData[List[Cell["Simulation of ReplResistor", "Section"], Cell["simulate( ReplResistor );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ReplResistor\\) : 2004-1-30 11:58:30.2572564 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 2 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["Electrical Connectors", "Section"], Cell["connector Pin \t\t\t\t\"Pin of an electrical component\"\n   Voltage v \t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\"Current flowing into the pin\";\nend Pin;  \t\t\t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["connector PositivePin \t\t\"Positive pin of an electrical component\"\n   Voltage v \t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\"Current flowing into the pin\";\nend PositivePin;  \t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["connector NegativePin \t\t\"Negative pin of an electrical component\"\n   Voltage v \t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\"Current flowing into the pin\";\nend NegativePin;  \t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Electrical Components", "Section"], Cell["partial model TwoPin\t\t// Same as OnePort in Modelica.Electrical.Analog.Interfaces\n\t\t\t\t\t\t\t\"Component with two electrical pins p and n and current i from p to n\"\n  Voltage v\t\t\t\t\t\"Voltage drop between the two pins (= p.v - n.v)\";\n  Current i\t\t\t\t\t\"Current flowing from pin p to pin n\";\n  PositivePin p;\n  NegativePin n;\nequation\n  v = p.v - n.v;\n  0 = p.i + n.i;\n  i = p.i;\nend TwoPin;\t\t\t\t\t", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Replaceable Resistor", "Section"], Cell["model R\nreplaceable Resistor Load(R=2) \n  extends TwoPin;\n  annotation(choices(\n  \t\t\t  choice(redeclare lib2.Resistor Load(a = {2}) ),\n  \t\t\t  choice(redeclare Capacitor Load(L = 3) )));\nend R;  \t\t\t  ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Friction", "Section"], Cell["model Friction\n  // ...\nend Friction;", "ModelicaInput"], Cell["", "Text"], Cell["model FF\nreplaceable FrictionFunction a(func = exp) \n  extends Friction;\n  annotation(choices(\n  \t\t\t  choice(redeclare ConstantFriction a(c = 1) ),\n  \t\t\t  choice(redeclare TableFriction a(table = \"a\") ),\n  \t\t\t  choice(redeclare FunctionFriction a(func = exp) )));\nend FF;   ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["KindOfController", "Section"], Cell[TextData[List["The ", StyleBox["choices annotation", Rule[FontFamily, "Courier"]], " is not restricted to replaceable elements. It is also applicable to nonreplaceable elements, simple variables and types used for enummerations. For example, consider the following Integer type called ", StyleBox["KindOfController", Rule[FontFamily, "Courier"]], " used to represent a choice of controlle in the modeling process out of the following enumeration of three recommended alternatives.\n"]], "Text"], Cell["type KindOfController = Integer(min=1, max=3)\n  annotation(choices(\n  \t\t\t\tchoice = 1 \"P\",\n  \t\t\t\tchoice = 2 \"PI\",\n  \t\t\t\tchoice = 3 \"PID\"));", "ModelicaInput"], Cell[TextData[List["\nAssume that ", StyleBox["KindOfController", Rule[FontFamily, "Courier"]], " is used in a model ", StyleBox["KindOfControllerInst", Rule[FontFamily, "Courier"]], " as below:"]], "Text"], Cell["model KindOfControllerInst\n  KindOfController x;\t\t\t// Instance of KindOfController\nend KindOfControllerInst;", "ModelicaInput"], Cell["\nAn interactive choice of the third alternative from a menu containing the alternatives {\"P\", \"PI\", \"PID\"} would result in the default value 3 for the instatiated variable x in the following code for an instance a2 of the model A.", "Text"], Cell["class KOCInst\n  KindOfControllerInst a2(x = 3 \"PID\");\nend KOCInst;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of KindOfController", "Section"], Cell["simulate( KOCInst );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(KOCInst\\) : 2004-1-30 11:58:50.7726188 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\(a2 . x\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[908, 900]], Rule[WindowMargins, List[List[3, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]