List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Modification Prevention Prefix Final", "Title"], Cell[CellGroupData[List[Cell["Simple Example", "Section"], Cell[TextData[List["A variable declared as final in a member modification cannot be further modified by another modification. All members of a ", StyleBox["final", Rule[FontFamily, "Courier"]], " member are also ", StyleBox["final", Rule[FontFamily, "Courier"]], ",  e.g. the fields of a ", StyleBox["final", Rule[FontFamily, "Courier"]], " member that is a ", StyleBox["record", Rule[FontFamily, "Courier"]], " are ", StyleBox["final", Rule[FontFamily, "Courier"]], ". \n"]], "Text"], Cell[TextData[List["type Angle = Real(final quantity = \"Angle\",\n\t\t\t\t ", StyleBox[" final unit \t\t\t= \"rad\",", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\t\t\t\t  displayUnit \t\t\t= \"deg\");"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class AngleInst\t\t\t\t  \n ", StyleBox[" parameter Angle a1(unit = \"deg\");\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\t// Error, since unit declared as final", "\n  parameter Angle a2(displayUnit = \"rad\");\t\t\t\t// Fine\nend AngleInst;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Angle", "Section"], Cell[TextData[List["When we simulate the class ", StyleBox["AngleInst", Rule[FontFamily, "Courier"]], " we see that there is an error, since we try to modify the unit which is declared as final. We also get a warning because ", StyleBox["a1", Rule[FontFamily, "Courier"]], " and ", StyleBox["a2", Rule[FontFamily, "Courier"]], " do not have any default values."]], "Text"], Cell["simulate( AngleInst );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AngleInst\\) : 2004-1-30 11:56:16.5870924 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"a1\\\", HoldForm], \\*TagBox[\\\"a2\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell["getLog();", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\nError: Overriding final modifier for unit.\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 6\\\\nOverriding found at:  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 2\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"AngleInst\\\\\\\")\\\\nTranslation started\\\\n  \\\\nSTATISTICS\\\\n  \\\\nOriginal Model\\\\n  Number of components: 1\\\\n  Variables: 2\\\\n    Constants: 0\\\\n    Parameters: 2 (2 scalars)\\\\n    Unknowns: 0\\\\n    Differentiated variables: 0\\\\n  Equations: 0\\\\n    Nontrivial : 0\\\\n\\\\n   \\\\nTranslated Model\\\\n  Constants: 0\\\\n  Free parameters: 2 scalars\\\\n  Parameter depending: 0\\\\n  Inputs: 0\\\\n  Outputs: 0\\\\n  Continuous time states: 0\\\\n  Time-varying variables: 0\\\\n  Alias variables: 0\\\\n  Number of mixed real/discrete systems of equations: 0\\\\n  Sizes of linear systems of equations: { }\\\\n  Sizes after manipulation of the linear systems: { }\\\\n  Sizes of nonlinear systems of equations: { }\\\\n  Sizes after manipulation of the nonlinear systems: { }\\\\n  Number of numerical Jacobians: 0\\\\n   \\\\nWarning: The following parameters have no default values\\\\n  a1\\\\n  a2\\\\nFinished\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"]], Open]], Cell[CellGroupData[List[Cell["More Advanced Example", "Section"], Cell[TextData[List["Here is another, slightly more advanced, example of the use of ", StyleBox["final", Rule[FontFamily, "Courier"]], ". This example invovles a model that is used as a transfer function within a PI controller. "]], "Text"], Cell["block TransferBlock \t\t\t\t\t\t\t// Works like a transfer function\n  parameter Real a[:] = {1, 1} \t\t\t\t\t\"denominator coefficient vector\";\n  parameter Real b[:] = {1} \t\t\t\t\t\"numerator coefficient vector\";\nprotected\n  parameter Integer nb(max = na) = size(b, 1);\n  parameter Integer na\t\t\t= size(a, 1);\n  parameter Integer n\t\t\t= na - 1;\n  parameter Real[n]\t\t   x\t\t\t\t\t\t\t\"State vector\";\n  parameter Real[na] \t\t   b0 \t\t\t= cat(1, zeros(na - nb), b);\nend TransferBlock;", "ModelicaInput"], Cell["", "Text"], Cell["model PI \t\t\t\t\t\t\t\t\t\t\"PI controller\"\n  parameter Real k = 1\t\t\t\t\t\t\t\"gain\";\n  parameter Real T = 1\t\t\t\t\t\t\t\"time constant\";\n  TransferBlock tf(final a = {T, 0}, final b = {T, 1});\nend PI;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["model Test \n  ", StyleBox["PI c1(k = 2, T = 3);\t\t\t\t\t\t\t// Fine", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  ", StyleBox["PI c2(tf.b = {1});\t\t\t\t\t\t\t// Error: b is declared as final", Rule[FontColor, RGBColor[1, 0, 0]]], "\nend Test;  "]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["model Test2 \n", StyleBox["  PI c1(k = 2, T = 3);\t\t\t\t\t\t\t// Fine\n  ", Rule[FontColor, RGBColor[0, 0, 1]]], "end Test2;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of PI", "Section"], Cell["simulate( TransferBlock );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TransferBlock\\) : 2004-1-30 11:57:0.2740332 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(b \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell["simulate( PI );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(PI\\) : 2004-1-30 11:57:6.3677052 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"k\\\", HoldForm], \\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\(\\(\\(tf . a\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(tf . a\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(tf . b\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(tf . b\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell["simulate( Test2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Test2\\) : 2004-1-30 11:57:12.4613772 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\(c1 . k\\), HoldForm], \\*TagBox[\\(c1 . T\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . a\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . a\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . b\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . b\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell[TextData[List["We see in the simulation of ", StyleBox["Test", Rule[FontFamily, "Courier"]], " that an error occurs because we try to modify b, which is declared as final."]], "Text"], Cell["simulate( Test );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Test\\) : 2004-1-30 11:57:18.7581716 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 13 variables>\\n\\!\\({\\*TagBox[\\(c1 . k\\), HoldForm], \\*TagBox[\\(c1 . T\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . a\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . a\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . b\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c1 . tf . b\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c2 . k\\), HoldForm], \\*TagBox[\\(c2 . T\\), HoldForm], \\*TagBox[\\(\\(\\(c2 . tf . a\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c2 . tf . a\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(c2 . tf . b\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell["getLog();", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\nError: Overriding final modifier for b.\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 13\\\\nOverriding found at:  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 7\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"Test\\\\\\\")\\\\nTranslation started\\\\n  \\\\nSTATISTICS\\\\n  \\\\nOriginal Model\\\\n  Number of components: 5\\\\n  Variables: 18\\\\n    Constants: 0\\\\n    Parameters: 18 (23 scalars)\\\\n    Unknowns: 0\\\\n    Differentiated variables: 0\\\\n  Equations: 0\\\\n    Nontrivial : 0\\\\n\\\\n   \\\\nTranslated Model\\\\n  Constants: 11 scalars\\\\n  Free parameters: 7 scalars\\\\n  Parameter depending: 5 scalars\\\\n  Inputs: 0\\\\n  Outputs: 0\\\\n  Continuous time states: 0\\\\n  Time-varying variables: 0\\\\n  Alias variables: 0\\\\n  Number of mixed real/discrete systems of equations: 0\\\\n  Sizes of linear systems of equations: { }\\\\n  Sizes after manipulation of the linear systems: { }\\\\n  Sizes of nonlinear systems of equations: { }\\\\n  Sizes after manipulation of the nonlinear systems: { }\\\\n  Number of numerical Jacobians: 0\\\\n   \\\\nWarning: The following parameters have no default values\\\\n  c1.tf.x[1]\\\\n  c2.tf.x[1]\\\\nFinished\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[913, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]