List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Redeclaration", "Title"], Cell[TextData[List["\nBy using the keyword ", StyleBox["redeclare", Rule[FontFamily, "Courier"]], " it is possible to modify the type and/or the prefixes and possibly the dimension sizes of a declared element. This kind of modification is called a redeclaration. In most cases a declaration that can be redeclared must include the prefix ", StyleBox["replaceable", Rule[FontFamily, "Courier"]], ".\n\nThe element in a redeclaration must have a type that is either a subtype of the replaceable element in the modified class or a subtype of a constraining type. An example is shown below with the concepts of redeclaration."]], "Text"], Cell[CellGroupData[List[Cell["Connector Classes", "Section"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(unit = \"A\");", "ModelicaInput"], Cell["", "Text"], Cell["connector Pin\n  Voltage \t\tv;\n  flow Current \ti;\nend Pin;\t\t\t\t", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Resistor and TempResistor", "Section"], Cell["model Resistor\t\n  Pin \t\t\tp, n\t\t\t\t\t\t\t\t\"Positive and Negative Pins\";\n  Voltage \t\tv;\n  Current \t\ti;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\t\"Resistance\";\nequation \n  v = R*i;\nend Resistor;", "ModelicaInput"], Cell["", "Text"], Cell["model TempResistor\t\t\t\t\t\t\t\t\t\"Temperature dependent Resistor\"\n  Pin \t\t\tp, n\t\t\t\t\t\t\t\t\"Positive and Negative Pins\";\n  Voltage \t\tv;\n  Current \t\ti;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\t\"Resistance at reference Temperature\";\n  parameter Real RT(unit = \"Ohm/degC\") \t= 0 \t\t\"Temperature dependent Resistance\";\n  parameter Real Tref(unit = \"degC\") \t= 20\t\t\"Reference Temperature\";\n  Real \t\t\t Temp \t\t\t\t\t= 20\t\t\"Actual Temperature\";\nequation \n  v = i*(R + RT*(Temp - Tref));\nend TempResistor;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["MiniCircuit", "Section"], Cell["class MiniCircuit\n  replaceable discrete Resistor R1;\nend MiniCircuit;", "ModelicaInput"], Cell[TextData[List["\nThe redeclaration of the ", StyleBox["R1", Rule[FontFamily, "Courier"]], " element changes its type from ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " to ", StyleBox["TempResisto", Rule[FontFamily, "Courier"]], "r", " and its prefix from discrete to parameter. "]], "Text"], Cell[TextData[List["class MiniCircuitRed\n  ", StyleBox["MiniCircuit tempcircuit(redeclare parameter TempResistor R1);\t", Rule[FontColor, RGBColor[0, 0, 1]]], " \nend MiniCircuitRed;"]], "ModelicaInput"], Cell["\nThe MiniCircuitRed class can be rewritten as the MiniCircuit2", "Text"], Cell["class MiniCircuit2\n  parameter TempResistor R1;\nend MiniCircuit2;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Redeclaration with Extends Clause", "Section"], Cell[TextData[List["The next example illustrates a redeclaration used in an ", StyleBox["extends clause", Rule[FontSlant, "Italic"]], "."]], "Text"], Cell["class RedA\n  parameter Real x;\nend RedA;", "ModelicaInput"], Cell["", "Text"], Cell["class RedA2\t\t\t\t\t\t\t\t\t\t// A2 is a subtype of A\n  parameter Real x = 3.14;\n  parameter Real y;\nend RedA2;  ", "ModelicaInput"], Cell["", "Text"], Cell["class RedB\n  replaceable RedA a(x = 1);\t\t\t\t\t\t\nend RedB;", "ModelicaInput"], Cell[TextData[List["\nThe redeclaration ", StyleBox["redeclare RedA2 a(y=2)", Rule[FontFamily, "Courier"]], " is used in an extends clause to replace the original declaration Red", StyleBox["A a(x=1)", Rule[FontFamily, "Courier"]], " from class RedB, but merging the original nested modifier ", StyleBox["(x=1)", Rule[FontFamily, "Courier"]], " with the modifiers in the redeclaration to effectively get Red", StyleBox["A2 a(x=1,y=2)", Rule[FontFamily, "Courier"]], ". The type of the redeclared field ", StyleBox["a", Rule[FontFamily, "Courier"]], " in class RedB is changed from RedA to RedA2 in class RedB2 which is correct since RedA2 is a subtype of RedA.\n"]], "Text"], Cell["class RedB2\n  extends RedB(redeclare RedA2 a(y = 2));\t\t// The result after redeclaration is RedA2 a(x = 1, y = 2) \nend RedB2;", "ModelicaInput"], Cell["\nThe class RedB, is equivalent to the class B2expanded below.", "Text"], Cell["class B2expanded\n  RedA2 a(x = 1, y = 2);\nend B2expanded;", "ModelicaInput"], Cell[CellGroupData[List[Cell["GetFlatDefinition on RedB, B2expanded", "Subsection"], Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", "RedB2", "]"]], "//", "ToModelica"]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", "B2expanded", "]"]], "//", "ToModelica"]]], "Input"]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[910, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]