List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Modification Prefix Replaceable and Redeclare", "Title"], Cell[CellGroupData[List[Cell["Replaceable", "Section"], Cell[TextData[List["A declared element of a class must have the prefix replaceable in oder to be redeclared, apart from redeclarations that only chnge the attribute value and/or restricts the variability and possibly the dimension sizes. The main motivation for this rule is that a class need to be ", StyleBox["designed", Rule[FontSlant, "Italic"]], " for inheritance that includes redeclaration. Otherwise unexpected errors may occur. \n"]], "Text"], Cell[TextData[List["class MicroCircuit\n  ", StyleBox["replaceable", Rule[FontColor, RGBColor[0, 0, 1]]], " Resistor R1;\nend MicroCircuit;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Connector Classes", "Section"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(unit = \"A\");", "ModelicaInput"], Cell["", "Text"], Cell["connector Pin\n  Voltage \t\tv;\n  flow Current \ti;\nend Pin;\t\t\t\t", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Resistor and TempResistor", "Section"], Cell["model Resistor\t\n  Pin \t\t\tp, n\t\t\t\t\t\t\t\t\"Positive and Negative Pins\";\n  Voltage \t\tv;\n  Current \t\ti;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\t\"Resistance\";\nequation \n  v = R*i;\nend Resistor;", "ModelicaInput"], Cell["", "Text"], Cell["model TempResistor\t\t\t\t\t\t\t\t\t\"Temperature dependent Resistor\"\n  Pin \t\t\tp, n\t\t\t\t\t\t\t\t\"Positive and Negative Pins\";\n  Voltage \t\tv;\n  Current \t\ti;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\t\"Resistance at reference Temperature\";\n  parameter Real RT(unit = \"Ohm/degC\") \t= 0 \t\t\"Temperature dependent Resistance\";\n  parameter Real Tref(unit = \"degC\") \t= 20\t\t\"Reference Temperature\";\n  Real \t\t\t Temp \t\t\t\t\t= 20\t\t\"Actual Temperature\";\nequation \n  v = i*(R + RT*(Temp - Tref));\nend TempResistor;", "ModelicaInput"], Cell["", "Text"], Cell["model SuperTempResistor\t\t\t\t\t\t\t\t\"Temperature dependent Resistor\"\n  Pin \t\t\tp, n\t\t\t\t\t\t\t\t\"Positive and Negative Pins\";\n  Voltage \t\tv;\n  Current \t\ti;\n  parameter Real R(unit = \"Ohm\")\t\t\t\t\t\"Resistance at reference Temperature\";\n  parameter Real RT(unit = \"Ohm/degC\") \t= 0 \t\t\"Temperature dependent Resistance\";\n  parameter Real Tref(unit = \"degC\") \t= 20\t\t\"Reference Temperature\";\n  Real \t\t\t Temp \t\t\t\t\t= 20\t\t\"Actual Temperature\";\n  parameter Boolean Super\t\t\t \t= true;\nequation \n  v = i*(R + RT*(Temp - Tref));\nend TempResistor;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Redeclare", "Section", Rule[CellTags, "Redeclare"]], Cell[TextData[List["The ", StyleBox["redeclare", Rule[FontFamily, "Courier"]], " prefix is used at the front of a modifier containing a new variable or type declaration", StyleBox[" t", Rule[FontFamily, "TimesNewRoman"]], "hat ", StyleBox["replaces", Rule[FontSlant, "Italic"]], " the original variable or type declaration element in the modified class.The reason for requiring a special keyword like ", StyleBox["redeclare", Rule[FontFamily, "Courier"]], " is to reduce the risk for accidental programming errors that otherwise might occur when whole declarations are replaced by declarations of different types. \n"]], "Text"], Cell[TextData[List["class TempMicroCiruit = MicroCircuit(", StyleBox["redeclare", Rule[FontColor, RGBColor[0, 0, 1]]], " TempResistor R1);"]], "ModelicaInput"], Cell["\nIn order to allow further redeclaration of a redeclared element the replaceable prefix should be present also in the modifier.", "Text"], Cell[TextData[List["class TempMicroCiruit2 = MicroCircuit(", StyleBox["redeclare replaceable", Rule[FontColor, RGBColor[0, 0, 1]]], " TempResistor R1);"]], "ModelicaInput"], Cell[TextData[List["\nIn the class ", StyleBox["SuperTempMicroCircuit", Rule[FontFamily, "Courier"]], " the keyword ", StyleBox["replaceable", Rule[FontFamily, "Courier"]], " is left out, which means that no further redeclaration is possible."]], "Text"], Cell[TextData[List["class SuperTempMicroCiruit = TempMicroCiruit2(", StyleBox["redeclare", Rule[FontColor, RGBColor[0, 0, 1]]], " SuperTempResistor R1);"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["GetFlatDefinition on MicroCircuit, TempMicroCiruit2", "Subsection"], Cell[CellGroupData[List[Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", " ", "MicroCircuit", " ", "]"]], "//", "ToModelica"]]], "Input"], Cell[BoxData["\"model MicroCircuit\\n   Real(unit=\\\"V\\\") R1.p.v;\\n   flow Real(unit=\\\"A\\\") R1.p.i;\\n   Real(unit=\\\"V\\\") R1.n.v;\\n   flow Real(unit=\\\"A\\\") R1.n.i;\\n   Real(unit=\\\"V\\\") R1.v;\\n   Real(unit=\\\"A\\\") R1.i;\\n   parameter Real R1.R(unit=\\\"Ohm\\\") \\\"Resistance\\\";\\n   \\nequation\\n   R1.v = R1.R*R1.i ;\\n   \\nequation\\n   R1.p.i = 0;\\n   R1.n.i = 0 ;\\nend MicroCircuit;\""], "Output", Rule[GeneratedCell, False], Rule[CellAutoOverwrite, False]]], Open]], Cell[CellGroupData[List[Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", "TempMicroCiruit2", "]"]], "//", "ToModelica"]]], "Input"], Cell[BoxData["\"model TempMicroCiruit2\\n   Real(unit=\\\"V\\\") R1.p.v;\\n   flow Real(unit=\\\"A\\\") R1.p.i;\\n   Real(unit=\\\"V\\\") R1.n.v;\\n   flow Real(unit=\\\"A\\\") R1.n.i;\\n   Real(unit=\\\"V\\\") R1.v;\\n   Real(unit=\\\"A\\\") R1.i;\\n   parameter Real R1.R(unit=\\\"Ohm\\\") \\\"Resistance at reference Temperature\\\";\\n   parameter Real R1.RT(unit=\\\"Ohm/degC\\\")=0 \\\"Temperature dependent Resistance\\\";\\n   parameter Real R1.Tref(unit=\\\"degC\\\")=20 \\\"Reference Temperature\\\";\\n   Real R1.Temp=20 \\\"Actual Temperature\\\";\\n   \\nequation\\n   R1.v = R1.i*(R1.R+R1.RT*(R1.Temp-R1.Tref)) ;\\n   \\nequation\\n   R1.p.i = 0;\\n   R1.n.i = 0 ;\\nend TempMicroCiruit2;\""], "Output", Rule[GeneratedCell, False], Rule[CellAutoOverwrite, False]]], Open]], Cell[CellGroupData[List[Cell[BoxData[RowBox[List[RowBox[List["GetFlatDefinition", "[", "SuperTempMicroCiruit", "]"]], "//", "ToModelica"]]], "Input"], Cell[BoxData["\"model SuperTempMicroCiruit\\n   Real(unit=\\\"V\\\") R1.p.v;\\n   flow Real(unit=\\\"A\\\") R1.p.i;\\n   Real(unit=\\\"V\\\") R1.n.v;\\n   flow Real(unit=\\\"A\\\") R1.n.i;\\n   Real(unit=\\\"V\\\") R1.v;\\n   Real(unit=\\\"A\\\") R1.i;\\n   parameter Real R1.R(unit=\\\"Ohm\\\") \\\"Resistance at reference Temperature\\\";\\n   parameter Real R1.RT(unit=\\\"Ohm/degC\\\")=0 \\\"Temperature dependent Resistance\\\";\\n   parameter Real R1.Tref(unit=\\\"degC\\\")=20 \\\"Reference Temperature\\\";\\n   Real R1.Temp=20 \\\"Actual Temperature\\\";\\n   parameter Boolean R1.Super=true;\\n   \\nequation\\n   R1.v = R1.i*(R1.R+R1.RT*(R1.Temp-R1.Tref)) ;\\n   \\nequation\\n   R1.p.i = 0;\\n   R1.n.i = 0 ;\\nend SuperTempMicroCiruit;\""], "Output", Rule[GeneratedCell, False], Rule[CellAutoOverwrite, False]]], Open]]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.0 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1600], List[0, 1127]]], Rule[WindowSize, List[908, 924]], Rule[WindowMargins, List[List[Automatic, 289], List[Automatic, 72]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]