List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Constraining Type of Replaceable Elements ", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["A declaration of a ", StyleBox["replaceable", Rule[FontFamily, "Courier"]], " element of a class can represent either a variable (as ", StyleBox["comp1", Rule[FontFamily, "Courier"]], " in ", StyleBox["MicroCircuit", Rule[FontFamily, "Courier"]], ") or a local class declaration (as ", StyleBox["type CompType = Resistor", Rule[FontFamily, "Courier"]], " in Gen", StyleBox["MicroCircuit2", Rule[FontFamily, "Courier"]], "). The ", StyleBox["extends", Rule[FontFamily, "Courier"]], " keyword in the second form has nothing to do with inheritance, it is just a reuse of the keyword for a different purpose. It is however recommended to avoid modifiers in the constraining type (the expression after the ", StyleBox["extends", Rule[FontFamily, "Courier"]], " keyword)."]], "Text"]], Open]], Cell[CellGroupData[List[Cell["MicroCircuit", "Section"], Cell["class MicroCircuit\n  replaceable Resistor comp1;\t\nend MicroCircuit;", "ModelicaInput"], Cell[TextData[List["\nIn the class ", StyleBox["TempMicroCircuit", Rule[FontFamily, "Courier"]], " the instance ", StyleBox["comp1", Rule[FontFamily, "Courier"]], " is modified to have the type ", StyleBox["TempResistor", Rule[FontFamily, "Courier"]], " instead of ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class TempMicroCircuit = MicroCircuit(redeclare TempResistor comp1);", "ModelicaInput"], Cell[TextData[List["\nA more generic circuit expressing the same thing as ", StyleBox["TempMicroCircuit", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class GenMicroCircuit\n  replaceable type CompType = Resistor;\n  replaceable CompType comp1;\nend GenMicroCircuit;  ", "ModelicaInput"], Cell[TextData[List["\nType ", "Error", ", ", StyleBox["Inductor", Rule[FontFamily, "Courier"]], " is not subtype of ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], ". By extending ", StyleBox["CompType = Resistor", Rule[FontFamily, "Courier"]], " with ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], " the redeclaration can be successfully done."]], "Text"], Cell[TextData[List["class InductorMicroCircuit =\n  \t\t\t\tGenMicroCircuit(redeclare type CompType = ", StyleBox["Inductor", Rule[FontColor, RGBColor[1, 0, 0]]], ");"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Electrical Units", "Section"], Cell["type Voltage = Real(Unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(Unit = \"A\");", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Connectors", "Section"], Cell["connector Pin\n  Voltage v;\n  flow Current i;\nend Pin;  ", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Component TwoPin", "Section"], Cell["partial class TwoPin\n  \"Superclass of elements with two electrical pins\"\n  Pin p, n;\n  Voltage v;\n  Current i;\nequation\n  v = p.v - n.v;\n  p.i + n.i = 0;\n  i = p.i;\nend TwoPin;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Generic MicroCircuit", "Section"], Cell[TextData[List["After changing the ", StyleBox["GenMicroCircuit", Rule[FontFamily, "Courier"]], " class there is no problem to define a more specific circuit, e.g. using the component type ", StyleBox["Capacitor", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class GenMicroCircuit2\n  replaceable type CompType = Resistor extends TwoPin;\t\t\t// No inheritance!\n  replaceable CompType comp1;\nend GenMicroCircuit2;  ", "ModelicaInput"], Cell["", "Text"], Cell["class CapacitorMicroCircuit =\n  \t\t\t\tGenMicroCircuit2(redeclare type CompType = Capacitor);", "ModelicaInput"], Cell[TextData[List["\nThe ", StyleBox["CapacitorMicroCircuit", Rule[FontFamily, "Courier"]], " has no replaceable ", StyleBox["CompType", Rule[FontFamily, "Courier"]], " declaration left since the original replaceable declaration was replaced. Therefore we need to perform a redeclaration with ", StyleBox["redeclare replaceable", Rule[FontFamily, "Courier"]], " to be able to perform further modifications. \n"]], "Text"], Cell["class GenCapacitorMicroCircuit = \n\t\t\t\t\tGenMicroCircuit2(redeclare replaceable type CompType = TempCapacitor);", "ModelicaInput"], Cell[TextData[List["\nThe constraining type of a replaceable redeclaration must be a subtype of the constraining type of the declaration it redeclares. This condition is fulfilled for ", StyleBox["GenCapacitorMicroCircuit", Rule[FontFamily, "Courier"]], " above, since the constraining type ", StyleBox["GenCapacitor", Rule[FontFamily, "Courier"]], " is a subtype of ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], ". Thus the modifier ", StyleBox["R = 20", Rule[FontFamily, "Courier"]], " in the definition of ", StyleBox["MicroCircuit3", Rule[FontFamily, "Courier"]], " is propagated to both the declaration and the constraining type, which is apparent in the class ", StyleBox["MicroCircuit3expanded", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["class MicroCircuit2\n  replaceable TempResistor R1 extends Resistor;\nend MicroCircuit2;", "ModelicaInput"], Cell["", "Text"], Cell["class MicroCircuit3 = MicroCircuit2(R1 (R = 20));", "ModelicaInput"], Cell["", "Text"], Cell["class MicroCircuit3expanded\n  replaceable TempResistor R1(R = 20) extends Resistor(R = 20);\nend MicroCircuit3expanded;    ", "ModelicaInput"], Cell[TextData[List["\nIn an element redeclaration of a replaceable element the modifiers of the replaced constraining type are mergerd to both the new declaration and to the new constraining type. The modifier ", StyleBox["R=30", Rule[FontFamily, "Courier"]], " for the constraining type ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " below is propagated to the new type ", StyleBox["TempResistor2", Rule[FontFamily, "Courier"]], " and the new constrining type ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], "2.\n"]], "Text"], Cell["class MicroCircuit4\n  replaceable TempResistor R1 extends Resistor(R=30);\nend MicroCircuit4;", "ModelicaInput"], Cell["", "Text"], Cell["class MicroCircuit5 =\n\t\tMicroCircuit4(redeclare replaceable TempResistor2 R1 extends Resistor2);", "ModelicaInput"], Cell["", "Text"], Cell["class MicroCircuit5expanded  \n  replaceable TempResistor2 R1(R = 30) extends Restistor2(R=30);\nend MicroCircuit5expanded;", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[908, 897]], Rule[WindowMargins, List[List[6, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]