List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Using the Object Oriented Component-Based Approach", "Title"], Cell[CellGroupData[List[Cell["Tank System with a Continuous PI Controller", "Section"], Cell["Now we show the tank model using the object oriented component-based approach. The structure of the tank system model using this approach is clearly visible in Figure 1 below.\n", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0003[l0@0006`0000100001P0000X1002C0000\n00000000001_6000N0h00215CDH00040o3X006<1000>0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0003`B000`4P00AdA9@`4008000`00nX5IG`00000H4P00\n0@09000330T000l07@000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030:<0>`070000?/240070000002l0P0000010P8RDgUcM6E]000000X000040000\n003ooooo0@000000<0040000;@4000D000020@40000500002@80000270000?/2l?l00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4100<0000N00L0000F18`0\nk0000000400002H63`0F0?ooool00?ooooooooookP0008d0000300007P050000;P4000001@0000X2\n000000D000090P00000500000@;oool01`000?`20@00000000040000;@4200P0003j0PD00@000000\n00040000;@4300@000030@P01`000184S02<0>`0k@0500002`8000001@0000`2J`?91A@0000V1Pl0\n7P3ooooo100D0000EfmbI0h0CFUSLVmcKfId85M_LV@50000309[0lT570000?/250090000002l0P00\n00040P8RDgUcM6E]07M00000g`P:D;iRmGO7H_Eg0@000000<0040000;@4400D000020@40000L0000\nn`:]o`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0000]0@D0\n1@0000T200000PD0000;0P00000=0000<PYX0`000@04000000391F/386TU0100000V1Pl05P3ooooo\n000;10009@400285001D0@0020000?X200020000000000@0000]0@H0100002d10P0800009@<200d4\n?07g13`1100002d10`040000l04600L0003l0P0000000000100002d11P0:000090<30?D4DP4P1C`1\nm@@W0@P0003j0P000000000000040000;@4700L0003l0P00oooo0000100002d120040000l04600P0\n000V1Pl01P3ooooo0@040000;@4200@0000]0@<01`0001/4/P3h14T08`440000;@4800@0000]0@L0\n0`0001h01`0001H4/03h14X08`4500000P41000070000?/2[Ol00000002l0P000004@00BE6U]IG<P\nCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4601@0000b2Td0Q@8600@08`5:0?L4/01DHFi[\nD4Tg02X0;`0]03<0800=0000<PY=09D30@0402<1BP3g1;00800^00@0000W0Ooo100002d10P080000\nnP8000H000000002100002d12@0700006`AX0l<58`0300@0000]0@P0100002d11`040000l04900L0\n003l0P00oooo0000100002d12@080000nP8000H000000002100002d12P0700006`@O0`/4@P8K0P@0\n000]0@P010000?012@040000;@4700@0003`0@X0100002d10P040000;@4300L0000K1=/2hP=h0T<2\n100002d120040000;@4700<0000N00L0000F1=T2h@=h0T<21@0000810@0001`0003k0[Go00000000\nT040000014004UAYKFEc84iUMb1BKfeQKP2nH_Egaf;eM`4000000300100002d12@0500002@800002\n7@00038:NP970P`010130WP2h0?I0W1Y@fm^M6U^MFmeLbH05@0b02D09P0E01D09@0V02D09P0M00d0\n000b2WX2g0<100@0@`9h0^03f@8P0240100002L1ool70000o0800?ooo`0000@0000]0@X020000?X2\n0006000000000P@0000]0@/01`0001/4a`8W18/2j`<40000;@4800@0003`0@X0100002d11`040000\nl04;00L0003l0P00oooo0000100002d12P080000nP8000H000000002100002d12`0700006`C70S/2\nR`;n0@@0000]0@P010000?012P040000;@4700@0003`0@/01`000?`2003oool000040000;@4:00P0\n003j0P001P00000000840000;@4;00L0000K1>4130@40A/2100002d120040000l04:00@0000]0@L0\n10000?012`040000;@4200@0000]0@<01`0001/4Y@5b0d81/P840000;@4800@0000]0@L00`0001h0\n1`0001H4X`5b0d81/P8500000P41000070000?/2]Ol00000002@0@000004@00R@G9YHF`0mGM00000\nh0P:3kiRmGO7H_Eg0@000000<0040000;@4:00D000090P00008A0000<PY30LX210040;82@P5a0j<1\nM65^JaD0:P0Z02H0100002d12@0=0000<PY30ET30@040;82@P5a0j<1800Q00@0000W0Ooo1`000?`2\n003oool000040000;@4;00P0003j0P001P00000000840000;@4<00L0000K1<<1?0:70Ol1100002d1\n20040000l04;00@0000]0@L010000?0130070000o0800?ooo`0000@0000]0@/020000?X200060000\n00000P@0000]0@`01`0001/4FP4V11h1j@<40000;@4800@0003`0@/0100002d11`040000l04<00@0\n000]0@80100002d10`0700006`@90T<5^P4Q10@0000]0@P0100002d11`0300007P0700005P@80T<5\n^P4Q10D000020@40000L0000n`:mo`0000000901000000A00291LVUQK03eMd00003S20XE_V;eMlMR\nmGL10000000`00@0000]0@/01@0000T200000QT0000b2[/1:`@900@08@Bj0D85209d@F=dMF5dKg80\n4`0/02804`0U02D04`0U01H070000?/2_Ol00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iR\nmGO7H_Eg0@000000<0040000;@4<00d0000b2[/1=`D100@08@Bj0D85208P21d0100002L1ool40000\n;@4200@0000]0@<01`0001/41`8I0[P190440000;@4800@0000]0@L00`0001h01`0001H41P8I0[P1\n904500000P410000100002d12`0500002@8000025P00038:^@4[0@L0100T0KP160860WACIFicKg80\n4`0]02D0900R02D05P040000;@4<00d0000b2[T14@8100@0906h0AP21P8P21h0100002L1ool70000\no0800?ooo`0000@0000]0@d020000?X20006000000000P@0000]0@h01`0001/4FP4j0Qh1oP440000\n;@4800@0003`0@d0100002d11`040000l04>00L0003l0P00oooo0000100002d13@080000nP8000H0\n00000002100002d13P0700006`C30BH4Q`7Y0`@0000]0@P010000?013@040000;@4700@0003`0@h0\n100002d10P040000;@4300L0000K12h12`;O07d1100002d120040000;@4700<0000N00L0000F12d1\n2P;O07d11@0000810@0000@0000]0@/01@0000T200000Q00000b2^00U@4300@0O@7O00T2;@5aBFh0\n9@0C02D0100002d1300=0000<P[P0?810@0407d1g`090Rd1800N00@0000W0Ooo100002d10P040000\n;@4300L0000K12h1k@CO02L4100002d120040000;@4700<0000N00L0000F12d1k@CO02L41@000081\n0@0000@0000]0@/01@0000T200000Q40000b2^00@@@400@09`CO0>`4;@5aCgEd9@0d02D04`040000\n;@4<00d0000b2^00dP@100@09`CO0>`4;@4P01h0100002L1ool@00009PH?01H0ooooo`00BP400281\n00010P00D@4000P0003j0P000P00000000040000;@4=00@0000]0@80200002D30P1<0CT1eP4i0@@0\n000]0@<010000?013@070000o0800000000000@0000]0@d02P0002@30`3D0Dl1oP4j0M@190440000\n;@4700@0000]0@P010000?013@0800009PH?00H0ooooo`40100002d10P040000;@4300L0000K1?d2\na@B]0R/4100002d120040000;@4700<0000N00L0000F1?`2a0B^0R/41@0000810@0000@0000]0@/0\n1@0000T200000Q40000b2Zl2<0@400@0:`B^0/<4o09SCgEd8P0d02D04`040000;@4<00d0000b2Zl2\n_P@100@0:`B^0/<4o08P01d0100002L1ool40000;@4200@0000]0@<01`0001/4oP;o0Jl2P@440000\n;@4800@0000]0@L00`0001h01`0001H4o@;n0Jl2P@4500000P410000100002d12`0500002@800002\n4000038:/0:B0@<010210Jl2o@7m0V=9KW@R01<09@040000;@4<00d0000b2[02k04100@0P@6_0_d1\no@8P01d0100002L1ool@00009PH?01H0ooooo`006@4009l1003n0@00`@8000P0003j0P000P000000\n00040000;@4=00@0000]0@80300002D3103C0JT26`6Y0Q/1X@7k0J41100002d10`040000l04=00L0\n003l0P0000000000100002d13@0:000090<30=41_`;l0JX2d@6D0P@0000]0@L0100002d120040000\nl04=00P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`0080@008d1001:1@00Z`8000P0003j0P00\n0P00000000040000;@4=00@0000]0@80300002D3100Y1:P2A`FX0TL5Y05:1:@1100002d10`040000\nl04=00L0003l0P0000000000100002d13@0:000090<304d4S`4R1:@1C@Bj0@@0000]0@L0100002d1\n20040000l04=00P0000V1Pl01P3ooooo0@040000;@4200@0000]0@<01`0001/4?@0m004000040000\n;@4800@0000]0@L0400002H63`0F0?ooool004T0003d0000J`4007X100070000o0800?ooo`0000@0\n000]0@d020000?X20006000000000P@0000]0@h01`0001/4N`5>0OD0B@040000;@4800@0003`0@d0\n100002d11`040000l04>00@0000]0@80100002d10`0700006`AJ0C812`5>00@0000]0@P0100002d1\n1`0300007P0700005PAH0C812P5>00D000020@4000040000;@4;00D000090P00008D0000<PX;0E/0\n1P0404h02P4a0EP1LfmeLV=U8P0U02D05P0R02D0100002d1300=0000<PX;0B@10@0404h02P4a0EP1\n800M00@0000W0Ooo1`000?`2003oool000040000;@4=00P0003j0P001P00000000840000;@4>00L0\n000K15P1K04K0Bl1100002d120040000l04=00@0000]0@L010000?013P040000;@4400@0003`0@D0\n10000?011P040000l04900@0003`0@X010000?012`040000l04<00L0003l0P00oooo0000100002d1\n1@080000nP80000000000000100002d11P0400009`7oo`P0000V1Pl01P3ooooo0@0400009`7oo`@0\n000]0@000`0000004@0000`0000800002`000100000;0@00U00000T0000@00002`4009@0000:0000\n40000000000000002@000100003/0000S0000580001`0@000@0001000007000000000000002l0P00\n000000420R9C07T0L`1d06D0K@000000000000000000000000000000000000000000000000000000\n000000000000000000000002000001<0H6@J07P14`1d0@00D;KlMaJeo7L]]Oag00000800003PnQL0\n000C02P<4`0N0000L=dE09cc4P3HhAT0N04C0=SQ6@1h0A<0ooooofSe4P101Q<0:0`C000000000000\nh0PQ49RGB`;lla80f>4I07P14`000180A?@B00000000080o@0HC0100001Dm180V=Z=0GCd4P3R:5@0\n83@0020d003h0S/2`4V@0OP2>`9h0O40000C0=SQ6@1h0A<0N04C0=3Q6@1@]_ag5[GlMbfeo7L00000\n000000T0003PnQL0Z?@B07cb6@32`?Ag0@0006Af00P000009@0000`0000100004P0000`000010000\n600000`000000002DP00070100020000l?ooo`0000000000000009010000000014004U@0J@1]06D0\nL`0P04h0I@1g0200DP1_06d0H@1^0000000000000000000000000000000000000000000000000?40\n000C0=SQ6@1h0A<0N04C0=3Q6@1@]_ag5[GlMbfeo7L00000000000T0003PnQL0Z?@B07cb6@32`?Ag\n0@0006Af00P00000f>4I07P14`3oooooJ?DB04064`0X31<000000000003P224@V9M;0_cc4P3HhAT0\nN04C00004P14m18000000000P3m01Q<0400005Cd4P2HfXd1M?@B0>8XE00P=00083@00?P2>`;0BI01\nn08k0WP1l@0001<0f>4I07P14`1h0A<0d>4I052fo7LF]Oag;KGlMbD0003PnQL0R?@B0>48001D`?Ag\n0@0001T0/07Q20Y0I7H02000000U000030000080000Q0000200001h0000H000000000000003/0000\nS0000240000800005P0000`000000000N000010000000000000001P0000<0000000001T0000<0000\noooo02D0000<00001@00P2D0000<00002000P1l0000H0000k@000>`0002<0000S00000X0000@0000\n000000000009000040000<T5001[0`002@00010000391@00J`<00580001`0@000`0001@000090000\n00000000002l0P00000000@20R9C07T0L`1d06D0K@00000000000000000000000000000000000000\n00000000000000000000000000000000003a00004`3HhAT0N04C07P14`3@hAT0D;KlMaJeo7L]]Oag\n9@000>3j5`28m180h@P005C0m7L100006@2`0N482T1TMP0800000=SQ6@1h0A<0ooooofSe4P101Q<0\n:0`C000000000000h0PQ49RGB`;lla80f>4I07P14`000180A?@B00000000080o@0HC0100001Dm180\nV=Z=0GCd4P3R:5@083@0020d000@8_Aga?3mO`3PoGl100000000000000000000IPL00010001V1`C=\n0@0006Cd4P0U0000h?XG00T0003PnQL0Z?@B0?cc6@32`?Ag0@0006Af00P000009@0000`000030000\n4P0000`000010000DP00070100040000[Oooo`0000000000000009010000000014004U@0J@1]06D0\nL`0P04h0I@1g0200DP1_06d0H@1^0000000000000000000000000000000000000000000000000000\n0000000000000000IPL00010001V1`C=0@0006Cd4P0U0000h?XG00T0003PnQL0Z?@B0?cc6@32`?Ag\n0@0006Af00P00000f>4I07P14`3oooooJ?DB04064`0X31<000000000003P224@V9M;0_cc4P3HhAT0\nN04C00004P14m18000000000P3m01Q<0400005Cd4P2HfXd1M?@B0>8XE00P=00083@0010Rm7O4l?eo\n0>3mO`400000000000000000001V1`00040006H71<d10000I?@B02D0003PnQL0R?@B0>L8001D`?Ag\n0@0001T0/07W20X:I7H02000000U0000300000@0000H000030000000008:00004000000000000000\nE00005@00000000000000?oooooooooo0@0001NhQd1eD8M0000006P300010000C00000@000000000\n00000<T5001[0`00D0000200000U00009P0001`0000500000000008000000000000002D0000<0000\n1@0002D0000<00001@00P5L0000T0000_00003D0003V0000=@000080000=13`1m`@l0BD0000<0000\n2000P2P0000<00001@0002L0000H00001@00000000000000000002D0000<00001@0005H0000X0000\niP000380003]0000>@0000<0003e158180Dl0OD49`4V0000700000H0000000000000000000000000\n9@0000`0000600009`0001P00007000000000?ooo`0000009@0000`000070000:00000`000050000\n9@0000`0000500209@0000`000080020:`0001P0000S0@00B@000?<4002/00009@0000`000070000\n9@0000`0000600008@0000P0000N0000600002<1001:0000n0@00;00000B000030000040001B0000\nL04000D0002]oooo0000000000000000_08000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0\nK@1Q06h00000000000000000000000000000000000000000000000005`3@L1L000000000001V1`00\n040006H71<d10000I?@B02D0003PnQL0R?@B0<cc4P000000iCShM`004`38C1L000000:Sc4P281Q<0\nG?@B09D[n7L001<01000003d4P10]oagB0LC005<5`030000J?<B0000000`m180003hMaPfn7Oooooo\n@?@B089cj7L001<000000=1`5`1>1A0Od70G0220mgL4cP0042;dMlC`oGl0h?eo0@00000000000000\n000006H70000@000IPL4c`40001Tm180l37dMfH71<oP224@IPL4c`000004c`00P?@B093Bm7MTMP08\n000002D0000<00001@0005@0001`0000M@0000d0002V00007@000040000G^8M0ME27@8D2001=0000\n1P0004`0000400008`4004X0003g1000/00005P0001D0640KP1[0500B@0g0000:P0002l0000]0000\n<`000200001D0000E0000:H0000=0000[P0001d0000100005kR7@7E@Qd2E0`00C@000040001<0000\n100002<1001:0000m`@00;00001@0000800002h0000R000030000?oooolU0000300000D0080V0000\n700000P0000000001P000000000000029@0000`000080000:`0001P0000300008`000;h5001R0`00\n9@0000`0000700009@0000`000060000:00000`0000800009`0001P00008000000000?ooo`000000\n9@0000`0000800009P0001`000090000000000H00000000000000RD0000<00002@0002/0000H0000\n6`800482000610006@<002D0000<00001`0002P0000<0000200002D0000<00001P0002P0000<0000\n2@0002D0000<00001@00P2D0000<00002000P2/0000H0000@`8007P2003L0`00e@8002D0000<0000\n1`0002D0000<00001P000240000800007P0001P000130P00N0800>43003I0P004P0000`000010000\nDP00070100090000]Oooo`0000000000000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200\nDP1_06d0H@1^00000000000000000000000000000000000000000000000001H0<08F000000000000\nIPL00010001V1`C?0@0006Cd4P3`<OAgIPL4cn088A3<la8000000>Dhn7L001<0V;<N0000002Xla80\nR0HC05cd4P2E:oQg000C00@00000m180@;OlMnP64`01/ah042;dMa0Rm7O4l?eo0>3mO`0000000000\n000002850000@0008PD4a@40000Tm180l37dMb851<GP224@0@00010Rm7O4l?eo0>3mO`4000000000\n00000000001V1`00040006H71=810000I?@B0?0am7MV1`CBh0PQ46H71=8000001=80083d4P2@d_Ag\nI7H02000000U0000300000T0000H000030000000009D0000U00006X0001[0000/`0007T000010000\n5kR7@7E@Qd170P00NP8000`0001<0000100004<2001h0P00h0<00=T2001T0000L01Y04<0K`1^07@0\nJ@1^07D0K`1e07<09P0001D0000b00009@0002H0000E00005@0002D0000V00009@0002H0000M0000\nE00005@0002c0000J`000;<0001i00000@0001NhQd1eD8M0g0<007X200010000C00000@000130P00\nN0800>03003I0P00D0000200000Q00008P0000`0003ooooo9`0001P00008000000000?ooo`000000\n9@0000`0000800009P0001`0000:0000000000H00000000000000RD0000<00002P0002/0000H0000\nj`<008/2000R1000`@8002D0000<00001`0002P0000<0000200002D0000<00001P0002P0000<0000\n2P0002L0000H00002P000000003oool0000002D0000<00002P0002H0000L00002000000000060000\n00000000008U0000300000P0000[000060000?h1002;0P00=@800<42000U0000300000L0000X0000\n300000X0000U0000300000H0000X0000300000P0000W0000600000P000000000oooo0000000U0000\n300000P0000V0000700000X0000000001P000000000000029@0000`0000:0000:`0001P0000K0P00\n104000L4003K0@009@0000`000070000:00000`0000800009@0000`000060000:00000`0000:0000\n9@0000`0000500209@0000`000080020:`0001P0002b0P00@P4006d3002O0@009@0000`000070000\n9@0000`0000600008@0000P0000N000060000;8200120@00LP<00:<1000B000030000040001B0000\nL04000X0002eoooo0000000000000000T04000000004@00R@@1b06T0H@1/00000000000000000000\n000000000000000000000000000000000000000000000000000000005`2HgAL0M@1c0000001V1`00\n040006H71=810000I?@B0?0am7MV1`CBh0PQ4<cc4P000000iCShM`004`2H/ah000000:Sc4P281Q<0\nG?@B09D[n7L001<01000003d4P10]oagj0HC006c7P0@8_Ag42;dMlC`oGl0h?eo0000000000000000\nIPL00010001V1`CC0@0002Cd4P3`<OAgIPL4dn088A01000042;dMlC`oGl0h?eo0@00000000000000\n000002850000@0008PD4b040001Tm180l37dMb851<SP224@8PD4b0000004b000P?@B093Bm7MTMP08\n000002D0000<00002P0001P0000<000000000U@0001T0000P@0003L0002J0000AP000040000G^8M0\nME27@<X200130@00100004`000040000/P800481001a0`00X`4005@0001d0640KP1[01D0000Z0000\n:P0002H0000U0000300000T0001D0000E00009/0000g0000WP0004D0000100005kR7@7E@Qd1I0`00\n@`400040001<000010000;8200120@00L@<00:<1001@000080000240000R000030000?oooolW0000\n600000P000000000oooo0000000U0000300000P0000V0000700000/0000000001P00000000000002\n9@0000`0000;0000:`0001P0003o0@00Q`4003H2002m0@009@0000`000070000:00000`000080000\n9@0000`000060000:00000`0000;00009`0001P0000;000000000?ooo`0000009@0000`0000;0000\n9P0001`000080000000000H00000000000000RD0000<0000200002/0000H0000j@<001h1000Q1000\nE04002D0000<00001`0002P0000<00002`0002D0000<00001P0002P0000<0000200002D0000<0000\n1@00P2D0000<00002000P2/0000H00008@@00;X1000m1@000`8002D0000<00001`0002D0000<0000\n1P000240000800007P0001P0000Q1000^P4004<500080P004P0000`000010000DP00070100080000\n_Oooo`0000000000000009010000000014008T40LP1Y0640K0000000000000000000000000000000\n0000000000000000000000000000000000000000000001L0N5DG0000000000008PD00010000R1@C8\n0@0006Cd4P3`<OAg8PD4b>088A3<la8000000>Dhn7L001<0V;<N0000002Xla80R0HC05cd4P2E:oQg\n000C00@00000m180@;OlMnP64`01/ah042;dMa0Rm7O4l?eo0>3mO`0000000000000002850000@000\n8PD4b@40000Tm180l37dMb851<WP224@0@00010Rm7O4l?eo0>3mO`400000000000000000001V1`00\n040006H71=H10000I?@B0?0am7MV1`CFh0PQ46H71=H000001=H0083d4P2@d_AgI7H02000000U0000\n300000P0000H000030000000009D0000Q0000<00001;0000l@0005L0000100005kR7@7E@Qd0[1000\n^`4000T0001<000010000244002j0@00@PD000P2001P0000M01106<0M01e0640M01_0780000C0000\n;0000280000C00009@0002D0000C00009@0001H0001B0000L04000/0002moooo0000000000000000\nT04000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h0000000000000000000000000\n000000000000000000000000K`1b000000000000001V1`00040006H71=H10000I?@B0?0am7MV1`CF\nh0PQ4<cc4P000000iCShM`004`2HEQL000000:Sc4P281Q<0G?@B09D[n7LP>OQgooooofcd4P10]oag\nZ0LC0:1F5`2PEQL0G?/I0:1F5`00h?eo00000000000000008PD00010000R1@C90@0000004`3`<OAg\n8PD4bN088A01000002;dM`H00000h?eo0@00000000000000000000004`06000005HG0300001Tm180\n0@0000T0003Lla80Q0000:Cd4P2E:oQg63KhMooooomTMP08000002D0000<00002`0005@0001D0000\nlP0004/0003c0000E`000040000G^8M0ME27@3L5002k0@000@0004`0000400008@@00;X100121@00\n20800500000P00007@000280000<0000ooooobD0000<00001@00P2D0000<00002000P2/0000H0000\n90400;P1000D0P000@8002D0000<00001`0002D0000<00001P000240000800007P0001P0000T0@00\n^04001T200060P004P0000`0000100009@0000`000080000600000`000000002E00007P0000e0000\nB`0005l0001G00000@0001NhQd1eD8M0:`400;T100070000C00000@0000T0@00^04001P200060P00\nG00007@0D`1U06h0L`1_0780000C0000;@0002D0000T00008P0002D0000F00009@0000`0000;0000\nE00005@0001P0000B`000600001G00000@0001NhQd1eD8M04@800;T100010000C00000@0000T0@00\n^04001P200060P00D0000200000N00008P0000`0003ooooo9`0001P0000<000000000?ooo`000000\n9@0000`0000<00009P0001`0000=0000000000H00000000000000RD0000<00003@0002/0000H0000\noP4001h1000d0P00E04002D0000<00001`0002P0000<0000300002D0000<00001P0002P0000<0000\n3@0002L0000H00003@000000003oool0000002D0000<00003@0002H0000L00003000000000060000\n00000000008U0000300000`0000[000060000>T300270@008@@00;d1000U0000300000L0000X0000\n300000d0000U0000300000H0000X0000300000`0000U0000300000D0080U0000300000P0080[0000\n600007d1003O00001@8002P1000U0000300000L0000U0000300000H0000Q0000200001h0000H0000\nO@400=l0000:0P00;@400180000<00000@0002D0000<0000200001P0000<000000000U@0001P0000\nB@0002H0001I0000<P000040000G^8M0ME27@9D1003P00000`0004`000040000O@400=l000090P00\n;@4005@0001a04T0KP0002D0000C00009@0002D0000<00002`0005@0001D0000FP0002H0001M0000\n<P000040000G^8M0ME27@?81003P00000@0004`000040000O@400=l000090P00;@400500000P0000\n7P000280000<0000ooooobD0000<00001@00P2D0000<00002000P2/0000H00009`@00=l0003W1000\n:04002D0000<00001`0002D0000<00001P000240000800007P0001P0000W1000g`000>d4000]0@00\n4P0000`0000100009@0000`000080000600000`000000002E00006@0003500009P000=l0000b0000\n0@0001NhQd1eD8M0@@@00>0000040000C00000@0000W1000g`000>`4000]0@00E0000740C`1e07@0\n9@0003@0000U00004`0002D0000<00002`0005@0001D0000g`0002H0003S0000<P000040000G^8M0\nME27@=84003P00000@0004`0000400009`@00=l0003/1000;@400500000P00007P000280000<0000\nooooobH0000L0000300000000002000000000000000U0000300000`0000U0000300000D0081G0000\n900003`0000e0000E@0003D000020000C04i0MH1>@4U0000300000P0080X0000300000`0000W0000\n600000`00000000000000000000U0000300000`0001F0000:00005D0000a0000G00003T000030000\ne05?0Oh1>P7D0B@19@0000`0000600009@0000`000070000:00000`0000<00009@0000`000050020\n9@0000`000080020:`0001P0000[1000[@800;l4003g0P009@0000`0000700009@0000`000060000\n8@0000P0000N0000600002/4002^0P00a0@00?`2000B000030000040000U0000300000P0000H0000\n30000000009D0000I0000<80001d0000f`000800000100005kR7@7E@Qd0`1000[`8000@0001<0000\n100002/4002^0P00``@00?`2001D0000H`1?07D0M00R0000=00002D0000C00009@0000`0000;0000\nE00005@0003L0000M0000=`0002000000@0001NhQd1eD8M0_P@00:l200010000C00000@0000[1000\n[P800<<4003l0P00D0000200000M00008P0000`0003ooooo9@0000`0000500209@0000`000080020\n:`0001P000210@00[`800?X1003h0P009@0000`0000700009@0000`0000600008@0000P0000N0000\n60000841002_0P00oP400?d2000B000030000040000U0000300000P0000H000030000000009D0000\nH00004T0001d0000F@000800000100005kR7@7E@Qd2B0@00/08000<0001<000010000841002_0P00\no@400?d2001D0000H`1906h0000R00004`0002D0000U0000300000/0001D0000E00005T0001d0000\nF`000800000100005kR7@7E@Qd3/0@00/0800040001<000010000841002_0P00o@400?d2001@0000\n800001d0000R000030000?oooolV0000700000`0000000000P000000000000009@0000`0000<0000\n9@0000`000050020E`0002`0000c0000A`0005`0001c000010000=<1Z@8K0JT26`6Q0O/1X@4U0000\n300000P0080X0000300000`0000W0000600000`00000000000000000000U0000300000`0001F0000\n:00005@0001`0000G00007L000030000d@6o0_`1ZP;A0I@29@0000`0000600009@0000`000070000\n:00000`0000<00009P0001`0000<00000000008000000000000002D0000<0000300002D0000<0000\n1@00P5L0000/0000`@0004L0003d0000L`0000@0000Y1:P2A`FX0TL5Y05:1:@19@0000`000080020\n:00000`0000<00009`0001P0000<000000000000000000009@0000`0000<0000EP0002P0002o0000\nA0000<L0001;00000`0004d4S`4R1:@1C@Bj0BD0000<00001P0002D0000<00001`0002P0000<0000\n300002D0000<00001@00P2D0000<00002000P2/0000H000000000040000h0000=`0002D0000<0000\n1`0002D0000<00001P0002L0000H000030000000003oool0000002D0000<0000300002H0000L0000\n3@0000000006000000000000008U0000300000d0000[0000600004T0003e0000B04007D1000U0000\n300000L0000X0000300000`0000U0000300000H0000X0000300000d0000U0000300000D0080U0000\n300000P0080[0000600004h0000;0@00;04005@1000U0000300000L0000U0000300000H0000Q0000\n200001h0000H0000CP0000X1000b0@00F0400180000<00000@0002D0000<0000200001P0000<0000\n00000U@0001`0000400002d0000d0000>@000040000G^8M0ME27@5/0000;0@001P0004`000040000\nCP0000X1000a0@00F04005P0001c06l0M@1b06<0I@0R00009@0002D0000F00008P0002D0000U0000\n300000/0001D0000E00003D0000]0000=P0003T0000100005kR7@7E@Qd0T0@002`400040001<0000\n100004h0000:0@00<@4005P1001@0000800001d0000R000030000?oooolW0000600000d000000000\noooo0000000U0000300000d0000V0000700000`0000000001P000000000000029@0000`0000<0000\n:`0001P0000_0@006`4006L1001B0@009@0000`000070000:00000`0000=00009@0000`000060000\n:00000`0000<00009@0000`000030000:00000`000040000:00000`000050000:00000`000090000\n:00000`0000:0000:00000`000080000:00000`0000;00009`0001P0000;000000000?ooo`000000\n9@0000`0000;00009P0001`0000800000000000000000000000002D0000<000020000280000<0000\nooooob80000<0000ooooobD0000<00000@0002D0000<00001`00P2D0000<00000000P300000<0000\n3`00P2D0000<00003@00P4/0000@0000000000D0000X000030000040000X000030000080000X0000\n300000<0000X0000300000/0000X0000300000P0000X0000300000H0000X0000300000L0000>0000\n50000000000@00005000\n"], "Text", Rule[ImageSize, List[265, 141]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[" A tank system with a continuous PI controller and a source for liquid.", "NumberedFigure"], Cell[TextData[List["\nThe three components of the tank system: the tank, the PI controller and the source of liquid are explicit in Figure 1 and in the declaration of the class ", StyleBox["TankPI", Rule[FontFamily, "Courier"]], " below. Tank instances of t", StyleBox["ank", Rule[FontFamily, "Courier"]], ", ", StyleBox["source", Rule[FontFamily, "Courier"]], " and ", StyleBox["piContinuous", Rule[FontFamily, "Courier"]], " are connected to controllers and liquid sources through their connectors.\n"]], "Text"], Cell["model TankPI\n  LiquidSource           source(flowLevel=0.02);\n  PIcontinuousController piContinuous(ref=0.25);\n  Tank                   tank(area=1);\nequation\n  connect(source.qOut, tank.qIn);\n  connect(tank.tActuator, piContinuous.cOut);\n  connect(tank.tSensor, piContinuous.cIn);\nend TankPI;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Tank", "Section"], Cell[TextData[List["The tank has four connectors: ", StyleBox["qIn", Rule[FontFamily, "Courier"]], " for input flow, ", StyleBox["qOut", Rule[FontFamily, "Courier"]], " for output flow, ", StyleBox["tSensor", Rule[FontFamily, "Courier"]], " for providing fluid level measurements, and ", StyleBox["tActuator", Rule[FontFamily, "Courier"]], " for setting the position of the valve at the outlet of the tank.\n\nThe central equation regulating the behavior of the tank is the mass balance equation, which in the current simple form assumes constant pressure. The output flow is related to the valve position by a ", StyleBox["flowGain", Rule[FontFamily, "Courier"]], " parameter, and by a limiter that guarantees that the flow does not exceed what corresponds to the open/closed positions of the valve.\n"]], "Text"], Cell["model Tank\n  ReadSignal     tSensor    \t\t\t\t\t\"Connector, sensor reading tank level (m)\";\n  ActSignal      tActuator  \t\t\t\t\t\"Connector, actuator controlling input flow\";\n  LiquidFlow     qIn        \t\t\t\t\t\"Connector, flow (m3/s) through input valve\";\n  LiquidFlow     qOut       \t\t\t\t\t\"Connector, flow (m3/s) through output valve\";\n  parameter Real area(unit = \"m2\")       =  0.5;\n  parameter Real flowGain(unit = \"m2/s\") = 0.05;\n  parameter Real minV= 0, maxV = 10; \t\t    // Limits for output valve flow\n  Real           h(start = 0.0, unit = \"m\") \t\"Tank level\";\n equation\n  assert(minV>=0,\"minV - minimum Valve level must be >= 0 \");\n  der(h)      = (qIn.lflow - qOut.lflow)/area;   \t\t\t\t\t\t// Mass balance equation\n  qOut.lflow  = LimitValue(minV, maxV, -flowGain*tActuator.act);\n  tSensor.val = h;\nend Tank;", "ModelicaInput"], Cell[CellGroupData[List[Cell["LimitValue", "Subsection"], Cell["A limiter function is needed in the model to reflect minimum and maximum flows through the output valve:", "Text"], Cell["function LimitValue\n  input  Real pMin;\n  input  Real pMax;\n  input  Real p;\n  output Real pLim;\n algorithm\n  pLim := if p>pMax then pMax\n          else if p<pMin then pMin \n          else p;\nend LimitValue;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Connectors", "Subsection"], Cell["As already stated, the tank has four connectors. These are instances of the following three connector classes:", "Text"], Cell["connector ReadSignal\t\t\t\t\t\"Reading fluid level\"\n  Real val(unit = \"m\");\nend ReadSignal;", "ModelicaInput"], Cell["", "Text"], Cell["connector ActSignal\t\t\t\t\t\t\"Signal to actuator for setting valve position\"\n  Real act;\nend ActSignal;", "ModelicaInput"], Cell["", "Text"], Cell["connector LiquidFlow\t\t\t\t\t\"Liquid flow at inlets or outlets\"\n  Real lflow(unit = \"m3/s\");\nend LiquidFlow;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["LiquidSource", "Subsection"], Cell["The fluid entering the tank must come from somewhere. Therefore we have a liquid source component in the tank system. The flow increases sharply at time = 150 to factor of three of the previous flow level, which creates an interesting control problem that the controller of the tank has to handle.\n", "Text"], Cell["model LiquidSource\n  LiquidFlow qOut;\n  parameter Real flowLevel = 0.02;\nequation\t\t\n  qOut.lflow = if time > 150 then 3*flowLevel else flowLevel;\nend LiquidSource;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["PIcontinuousController", "Subsection"], Cell["The controller needs to be specified. We will initially choose a PI controller but later replace this by other kinds of controllers. ", "Text"], Cell["model PIcontinuousController\n  extends BaseController(K = 2, T = 10);\n  Real  x  \"State variable of continuous PI controller\";\nequation\n  der(x) = error/T;\n  outCtr = K*(error + x);\nend PIcontinuousController;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["BaseController", "Subsection"], Cell[TextData[List["Both the ", StyleBox["PI controller", Rule[FontFamily, "Courier"]], " and the ", StyleBox["PID controller", Rule[FontFamily, "Courier"]], " to be defined later inherit the partial controller class ", StyleBox["BaseController", Rule[FontFamily, "Courier"]], ", containing common parameters, state variables, and two connectors: one to read the sensor and one to control the valve actuator.\n"]], "Text"], Cell["partial model BaseController\n  parameter Real Ts(unit = \"s\") = 0.1\t\"Time period between discrete samples\";\n  parameter Real K = 2\t\t\t\t\t\"Gain\";\n  parameter Real T(unit = \"s\") = 10\t\t\"Time constant\";\n  ReadSignal cIn\t\t\t\t\t\t\"Input sensor level, connector\";\n  ActSignal  cOut\t\t\t\t\t\t\"Control to actuator, connector\";\n  parameter Real ref\t\t\t\t\t\"Reference level\";\n  Real error\t\t\t\t\t\t\t\"Deviation from reference level\";\n  Real outCtr\t\t\t\t\t\t\t\"Output control signal\";\nequation\n  error = ref - cIn.val;\n  cOut.act = outCtr;  \nend BaseController;", "ModelicaInput"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Simulation of TankPI", "Section"], Cell[TextData[List["We simulate the ", StyleBox["TankPI", Rule[FontFamily, "Courier"]], " model and obtain the same response as for the ", StyleBox["FlatTank", Rule[FontFamily, "Courier"]], " model, which is not surprising given that both models have the same basic equations. \n"]], "Text"], Cell["simulate( TankPI, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankPI\\) : 2004-1-30 15:44:55.3583264 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 22 variables>\\n\\!\\({\\*TagBox[\\(piContinuous . cIn . val\\), HoldForm], \\*TagBox[\\(piContinuous . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous . error\\), HoldForm], \\*TagBox[\\(piContinuous . K\\), HoldForm], \\*TagBox[\\(piContinuous . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous . ref\\), HoldForm], \\*TagBox[\\(piContinuous . T\\), HoldForm], \\*TagBox[\\(piContinuous . Ts\\), HoldForm], \\*TagBox[\\(piContinuous . x\\), HoldForm], \\*TagBox[\\(source . flowLevel\\), HoldForm], \\*TagBox[\\(source . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank . area\\), HoldForm], \\*TagBox[\\(tank . flowGain\\), HoldForm], \\*TagBox[\\(tank . h\\), HoldForm], \\*TagBox[\\(tank . maxV\\), HoldForm], \\*TagBox[\\(tank . minV\\), HoldForm], \\*TagBox[\\(tank . qIn . lflow\\), HoldForm], \\*TagBox[\\(tank . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank . tActuator . act\\), HoldForm], \\*TagBox[\\(tank . tSensor . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tank . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tank.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 1.25617 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14033 -18 -4.5 ]\n[.01131 .14033 0 4.5 ]\n[.01131 .26595 -18 -4.5 ]\n[.01131 .26595 0 4.5 ]\n[.01131 .39157 -18 -4.5 ]\n[.01131 .39157 0 4.5 ]\n[.01131 .51718 -18 -4.5 ]\n[.01131 .51718 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14033 m\n.03006 .14033 L\ns\n[(0.1)] .01131 .14033 1 0 Mshowa\n.02381 .26595 m\n.03006 .26595 L\ns\n[(0.2)] .01131 .26595 1 0 Mshowa\n.02381 .39157 m\n.03006 .39157 L\ns\n[(0.3)] .01131 .39157 1 0 Mshowa\n.02381 .51718 m\n.03006 .51718 L\ns\n[(0.4)] .01131 .51718 1 0 Mshowa\n.125 Mabswid\n.02381 .03984 m\n.02756 .03984 L\ns\n.02381 .06496 m\n.02756 .06496 L\ns\n.02381 .09009 m\n.02756 .09009 L\ns\n.02381 .11521 m\n.02756 .11521 L\ns\n.02381 .16546 m\n.02756 .16546 L\ns\n.02381 .19058 m\n.02756 .19058 L\ns\n.02381 .2157 m\n.02756 .2157 L\ns\n.02381 .24083 m\n.02756 .24083 L\ns\n.02381 .29107 m\n.02756 .29107 L\ns\n.02381 .3162 m\n.02756 .3162 L\ns\n.02381 .34132 m\n.02756 .34132 L\ns\n.02381 .36644 m\n.02756 .36644 L\ns\n.02381 .41669 m\n.02756 .41669 L\ns\n.02381 .44181 m\n.02756 .44181 L\ns\n.02381 .46694 m\n.02756 .46694 L\ns\n.02381 .49206 m\n.02756 .49206 L\ns\n.02381 .54231 m\n.02756 .54231 L\ns\n.02381 .56743 m\n.02756 .56743 L\ns\n.02381 .59255 m\n.02756 .59255 L\ns\n.02381 .61768 m\n.02756 .61768 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .02728 L\n.02762 .03984 L\n.02952 .0524 L\n.03143 .06496 L\n.03333 .07752 L\n.03524 .09009 L\n.03714 .10265 L\n.03905 .11521 L\n.04095 .12777 L\n.04286 .14033 L\n.04476 .15289 L\n.04667 .16546 L\n.04857 .17802 L\n.05048 .19058 L\n.05238 .20314 L\n.05429 .2157 L\n.05619 .22826 L\n.0581 .24083 L\n.06 .25339 L\n.0619 .26595 L\n.06381 .27851 L\n.06571 .29107 L\n.06762 .30363 L\n.06952 .3162 L\n.07143 .32876 L\n.07333 .34132 L\n.07524 .35388 L\n.07714 .36644 L\n.07905 .379 L\n.08095 .39157 L\n.08286 .40413 L\n.08476 .41669 L\n.08667 .42925 L\n.08857 .44181 L\n.09048 .45438 L\n.09238 .46694 L\n.09429 .47937 L\n.09619 .49129 L\n.0981 .50236 L\n.1 .5125 L\n.1019 .5217 L\n.10381 .52998 L\n.10571 .53735 L\n.10762 .54386 L\n.10952 .54952 L\n.11143 .55437 L\n.11333 .55843 L\n.11524 .56174 L\n.11714 .56431 L\nMistroke\n.11905 .56619 L\n.12095 .56739 L\n.12286 .56795 L\n.12476 .56791 L\n.12667 .56728 L\n.12857 .5661 L\n.13048 .56439 L\n.13238 .5622 L\n.13429 .55954 L\n.13619 .55645 L\n.1381 .55295 L\n.14 .54908 L\n.1419 .54486 L\n.14381 .54032 L\n.14571 .53548 L\n.14762 .53038 L\n.14952 .52504 L\n.15143 .51947 L\n.15333 .51372 L\n.15524 .50779 L\n.15714 .50172 L\n.15905 .49552 L\n.16095 .48921 L\n.16286 .48283 L\n.16476 .47638 L\n.16667 .46988 L\n.16857 .46336 L\n.17048 .45683 L\n.17238 .45031 L\n.17429 .4438 L\n.17619 .43734 L\n.1781 .43092 L\n.18 .42457 L\n.1819 .41829 L\n.18381 .41211 L\n.18571 .40602 L\n.18762 .40004 L\n.18952 .39418 L\n.19143 .38844 L\n.19333 .38284 L\n.19524 .37738 L\n.19714 .37207 L\n.19905 .36691 L\n.20095 .36191 L\n.20286 .35707 L\n.20476 .3524 L\n.20667 .3479 L\n.20857 .34357 L\n.21048 .33942 L\n.21238 .33544 L\nMistroke\n.21429 .33164 L\n.21619 .32802 L\n.2181 .32458 L\n.22 .32132 L\n.2219 .31823 L\n.22381 .31532 L\n.22571 .31259 L\n.22762 .31003 L\n.22952 .30763 L\n.23143 .30541 L\n.23333 .30335 L\n.23524 .30146 L\n.23714 .29972 L\n.23905 .29814 L\n.24095 .29671 L\n.24286 .29543 L\n.24476 .29429 L\n.24667 .29329 L\n.24857 .29242 L\n.25048 .29169 L\n.25238 .29108 L\n.25429 .29059 L\n.25619 .29022 L\n.2581 .28995 L\n.26 .2898 L\n.2619 .28975 L\n.26381 .28979 L\n.26571 .28993 L\n.26762 .29015 L\n.26952 .29046 L\n.27143 .29084 L\n.27333 .2913 L\n.27524 .29183 L\n.27714 .29241 L\n.27905 .29306 L\n.28095 .29377 L\n.28286 .29452 L\n.28476 .29532 L\n.28667 .29617 L\n.28857 .29705 L\n.29048 .29796 L\n.29238 .29891 L\n.29429 .29988 L\n.29619 .30087 L\n.2981 .30189 L\n.3 .30292 L\n.3019 .30396 L\n.30381 .30502 L\n.30571 .30608 L\n.30762 .30714 L\nMistroke\n.30952 .3082 L\n.31143 .30926 L\n.31333 .31032 L\n.31524 .31137 L\n.31714 .31241 L\n.31905 .31345 L\n.32095 .31446 L\n.32286 .31547 L\n.32476 .31645 L\n.32667 .31742 L\n.32857 .31837 L\n.33048 .3193 L\n.33238 .32021 L\n.33429 .32109 L\n.33619 .32195 L\n.3381 .32278 L\n.34 .32359 L\n.3419 .32437 L\n.34381 .32512 L\n.34571 .32585 L\n.34762 .32655 L\n.34952 .32721 L\n.35143 .32786 L\n.35333 .32847 L\n.35524 .32905 L\n.35714 .3296 L\n.35905 .33012 L\n.36095 .33062 L\n.36286 .33108 L\n.36476 .33152 L\n.36667 .33193 L\n.36857 .33232 L\n.37048 .33267 L\n.37238 .333 L\n.37429 .3333 L\n.37619 .33358 L\n.3781 .33383 L\n.38 .33406 L\n.3819 .33426 L\n.38381 .33444 L\n.38571 .3346 L\n.38762 .33474 L\n.38952 .33485 L\n.39143 .33494 L\n.39333 .33502 L\n.39524 .33508 L\n.39714 .33511 L\n.39905 .33513 L\n.40095 .33514 L\n.40286 .33513 L\nMistroke\n.40476 .3351 L\n.40667 .33506 L\n.40857 .33501 L\n.41048 .33494 L\n.41238 .33486 L\n.41429 .33477 L\n.41619 .33467 L\n.4181 .33457 L\n.42 .33445 L\n.4219 .33432 L\n.42381 .33419 L\n.42571 .33405 L\n.42762 .3339 L\n.42952 .33375 L\n.43143 .3336 L\n.43333 .33344 L\n.43524 .33327 L\n.43714 .33311 L\n.43905 .33294 L\n.44095 .33276 L\n.44286 .33259 L\n.44476 .33242 L\n.44667 .33224 L\n.44857 .33207 L\n.45048 .3319 L\n.45238 .33172 L\n.45429 .33155 L\n.45619 .33138 L\n.4581 .33121 L\n.46 .33105 L\n.4619 .33089 L\n.46381 .33073 L\n.46571 .33057 L\n.46762 .33041 L\n.46952 .33026 L\n.47143 .33012 L\n.47333 .32997 L\n.47524 .32983 L\n.47714 .3297 L\n.47905 .32957 L\n.48095 .32944 L\n.48286 .32932 L\n.48476 .3292 L\n.48667 .32909 L\n.48857 .32898 L\n.49048 .32888 L\n.49238 .32878 L\n.49429 .32869 L\n.49619 .3286 L\n.4981 .32851 L\nMistroke\n.5 .32843 L\n.5019 .32836 L\n.50381 .32829 L\n.50571 .32822 L\n.50762 .32816 L\n.50952 .3281 L\n.51143 .32805 L\n.51333 .328 L\n.51524 .32796 L\n.51714 .32792 L\n.51905 .32788 L\n.52095 .32785 L\n.52286 .32782 L\n.52476 .3278 L\n.52667 .32777 L\n.52857 .32776 L\n.53048 .32774 L\n.53238 .32773 L\n.53429 .32772 L\n.53619 .32772 L\n.5381 .32771 L\n.54 .32771 L\n.5419 .32771 L\n.54381 .32772 L\n.54571 .32773 L\n.54762 .32773 L\n.54952 .32775 L\n.55143 .32776 L\n.55333 .32777 L\n.55524 .32779 L\n.55714 .32781 L\n.55905 .32783 L\n.56095 .32785 L\n.56286 .32787 L\n.56476 .32789 L\n.56667 .32792 L\n.56857 .32795 L\n.57048 .32797 L\n.57238 .328 L\n.57429 .32803 L\n.57619 .32805 L\n.5781 .32808 L\n.58 .32811 L\n.5819 .32814 L\n.58381 .32817 L\n.58571 .3282 L\n.58762 .32823 L\n.58952 .32826 L\n.59143 .32829 L\n.59333 .32831 L\nMistroke\n.59524 .32834 L\n.59524 .32834 L\n.59524 .32834 L\n.59714 .35286 L\n.59905 .37613 L\n.60095 .39815 L\n.60286 .41893 L\n.60476 .43847 L\n.60667 .4568 L\n.60857 .47392 L\n.61048 .48986 L\n.61238 .50462 L\n.61429 .51823 L\n.61619 .53072 L\n.6181 .5421 L\n.62 .55241 L\n.6219 .56167 L\n.62381 .56992 L\n.62571 .57717 L\n.62762 .58345 L\n.62952 .58882 L\n.63143 .59328 L\n.63333 .59688 L\n.63524 .59965 L\n.63714 .60162 L\n.63905 .60283 L\n.64095 .60332 L\n.64286 .60311 L\n.64476 .60224 L\n.64667 .60075 L\n.64857 .59867 L\n.65048 .59603 L\n.65238 .59287 L\n.65429 .58922 L\n.65619 .58511 L\n.6581 .58058 L\n.66 .57566 L\n.6619 .57037 L\n.66381 .56476 L\n.66571 .55884 L\n.66762 .55265 L\n.66952 .54621 L\n.67143 .53957 L\n.67333 .53273 L\n.67524 .52573 L\n.67714 .51859 L\n.67905 .51133 L\n.68095 .50399 L\n.68286 .49657 L\n.68476 .48911 L\nMistroke\n.68667 .48163 L\n.68857 .47413 L\n.69048 .46665 L\n.69238 .45919 L\n.69429 .45178 L\n.69619 .44444 L\n.6981 .43716 L\n.7 .42998 L\n.7019 .4229 L\n.70381 .41594 L\n.70571 .4091 L\n.70762 .40241 L\n.70952 .39585 L\n.71143 .38946 L\n.71333 .38323 L\n.71524 .37717 L\n.71714 .37129 L\n.71905 .36559 L\n.72095 .36008 L\n.72286 .35476 L\n.72476 .34964 L\n.72667 .34472 L\n.72857 .34 L\n.73048 .33549 L\n.73238 .33118 L\n.73429 .32707 L\n.73619 .32317 L\n.7381 .31947 L\n.74 .31597 L\n.7419 .31267 L\n.74381 .30958 L\n.74571 .30668 L\n.74762 .30398 L\n.74952 .30147 L\n.75143 .29915 L\n.75333 .29701 L\n.75524 .29506 L\n.75714 .29327 L\n.75905 .29167 L\n.76095 .29023 L\n.76286 .28895 L\n.76476 .28783 L\n.76667 .28687 L\n.76857 .28605 L\n.77048 .28538 L\n.77238 .28484 L\n.77429 .28444 L\n.77619 .28416 L\n.7781 .284 L\n.78 .28396 L\nMistroke\n.7819 .28403 L\n.78381 .28421 L\n.78571 .28448 L\n.78762 .28485 L\n.78952 .28531 L\n.79143 .28585 L\n.79333 .28647 L\n.79524 .28716 L\n.79714 .28791 L\n.79905 .28873 L\n.80095 .28961 L\n.80286 .29054 L\n.80476 .29152 L\n.80667 .29254 L\n.80857 .2936 L\n.81048 .29469 L\n.81238 .29582 L\n.81429 .29696 L\n.81619 .29813 L\n.8181 .29932 L\n.82 .30053 L\n.8219 .30174 L\n.82381 .30295 L\n.82571 .30417 L\n.82762 .3054 L\n.82952 .30661 L\n.83143 .30783 L\n.83333 .30903 L\n.83524 .31023 L\n.83714 .31141 L\n.83905 .31258 L\n.84095 .31373 L\n.84286 .31485 L\n.84476 .31596 L\n.84667 .31705 L\n.84857 .31811 L\n.85048 .31914 L\n.85238 .32015 L\n.85429 .32113 L\n.85619 .32208 L\n.8581 .323 L\n.86 .32389 L\n.8619 .32475 L\n.86381 .32557 L\n.86571 .32637 L\n.86762 .32713 L\n.86952 .32786 L\n.87143 .32855 L\n.87333 .32921 L\n.87524 .32984 L\nMistroke\n.87714 .33044 L\n.87905 .331 L\n.88095 .33153 L\n.88286 .33203 L\n.88476 .33249 L\n.88667 .33292 L\n.88857 .33333 L\n.89048 .3337 L\n.89238 .33404 L\n.89429 .33435 L\n.89619 .33464 L\n.8981 .33489 L\n.9 .33512 L\n.9019 .33532 L\n.90381 .3355 L\n.90571 .33565 L\n.90762 .33578 L\n.90952 .33588 L\n.91143 .33596 L\n.91333 .33602 L\n.91524 .33606 L\n.91714 .33608 L\n.91905 .33608 L\n.92095 .33607 L\n.92286 .33603 L\n.92476 .33599 L\n.92667 .33592 L\n.92857 .33584 L\n.93048 .33575 L\n.93238 .33564 L\n.93429 .33553 L\n.93619 .3354 L\n.9381 .33526 L\n.94 .33512 L\n.9419 .33496 L\n.94381 .3348 L\n.94571 .33463 L\n.94762 .33446 L\n.94952 .33428 L\n.95143 .33409 L\n.95333 .3339 L\n.95524 .33371 L\n.95714 .33352 L\n.95905 .33332 L\n.96095 .33312 L\n.96286 .33292 L\n.96476 .33272 L\n.96667 .33252 L\n.96857 .33232 L\n.97048 .33213 L\nMistroke\n.97238 .33193 L\n.97429 .33173 L\n.97619 .33154 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n105.000 12.813 moveto\n(L) show\n111.000 12.813 moveto\n(@) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n123.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00AP3IfMT2000000@0fMWI0P00000R0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000O0=WIf@D000000P3IfMT2000000@0fMWI0P00000O0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000O0=WIf@@000000`3IfMT2000000@0fMWI0P00000G0=WIf@00A@3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000002<0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000N\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@00000F0=WIf@00B03IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI0240fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07P3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000007`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI00000080\nfMWI00<000000=WIf@3IfMT0503IfMT004H0fMWI0P0000030=WIf@040000003IfMT0fMWI000002<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00\n000P0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00@000000=WIf@3I\nfMT000005P3IfMT004H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000S0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003I\nfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000001H0fMWI00160=WIf@<000000`3IfMT2000002<0fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT200000200fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT2000001L0fMWI003o\n0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT6000000030000o`00\n000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0fMWI0=WIf@3a0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o\n0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0003o0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI\n000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003o\no`3IfMT10=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003I\nfMT0fMWI0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703I\nfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0\no`3IfMT000T0fMWI0P0000040=WIf@8000000`3IfMT5000000<0fMWI00D000000=WIf@3IfMT0fMWI\n0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI\n00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@03\n0000003IfMT0fMWI00<0fMWI0P0000020=WIf@030000o`3IfMT0fMWI0?d0fMWI00080=WIf@040000\n003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o\n0?l0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT00`00\n0000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI00090=WIf@8000002P3IfMT2000000D0\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00703IfMT00`000000fMWI\n0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0\n003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l\n0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT0\n0`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3I\nfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI\n00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WI\nf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000\no`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3I\nfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`00\n0000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L\n0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@03\n0000o`3IfMT0fMWI0?T0fMWI00090=WIf@800000103IfMT2000000<0fMWI100000040=WIf@030000\n003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n203IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\nn03IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@040=WIf@800000\n1`3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@00203I\nfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@3h0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000\n003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0n03IfMT001`0fMWI00<000000=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@2W0=WIf@L0003oBP3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT0\n0`000?l0fMWI0=WIf@0Z0=WIf@D0003oMP3IfMT20000o`D0fMWI10000?m70=WIf@00703IfMT00`00\n0000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02P0fMWI0`000?l30=WIf@@0003oLP3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@<0003oA@3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0\nfMWI0=WIf@0W0=WIf@030000o`3IfMT0fMWI00P0fMWI0P000?m_0=WIf@030000o`3IfMT0fMWI00/0\nfMWI0P000?m40=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02H0fMWI\n00<0003o0=WIf@3IfMT02P3IfMT30000of`0fMWI00<0003o0=WIf@3IfMT03@3IfMT30000od80fMWI\n000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@80003oJ@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@80003o@@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@0C0=WIf@80003o?`3IfMT001`0fMWI00<000000=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3IfMT0fMWI01<0fMWI0P000?mU0=WI\nf@030000o`3IfMT0fMWI01@0fMWI0P000?ln0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@03\n0000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT05P3IfMT30000of40fMWI0P000?lH0=WIf@80\n003o?03IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000\no`3IfMT0fMWI01P0fMWI0`000?mO0=WIf@030000o`3IfMT0fMWI01T0fMWI0P000?lj0=WIf@00703I\nfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT06`3I\nfMT30000obT0fMWI2P000?l80=WIf@030000o`3IfMT0fMWI01h0fMWI00<0003o0=WIf@3IfMT0703I\nfMT20000ocP0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0803IfMT0\n0`000?l0fMWI0=WIf@0N0=WIf@@0003o503IfMTA0000o`X0fMWI2@000?lP0=WIf@030000o`3IfMT0\nfMWI01h0fMWI10000?lE0=WIf@80003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0O0=WIf@030000o`3IfMT0fMWI02<0fMWI50000?lS0=WIf@030000o`3IfMT0fMWI\n01d0fMWI00<0003o0=WIf@3IfMT08P3IfMTF0000oal0fMWI000L0=WIf@030000003IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0E`3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0N0=WIf@030000o`3IfMT0fMWI05/0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI\n0=WIf@1H0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI01h0fMWI00<0\n003o0=WIf@3IfMT0F`3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05P0fMWI000L\n0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1L\n0=WIf@030000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05`0fMWI00<0003o0=WI\nf@3IfMT06`3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@0K0=WIf@03\n0000o`3IfMT0fMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n6`3IfMT00`000?l0fMWI0=WIf@1M0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WIf@3IfMT0\nF@3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@030000o`3I\nfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT0G`3IfMT0\n0`000?l0fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI05X0fMWI000L0=WIf@030000003IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n01T0fMWI00<0003o0=WIf@3IfMT0FP3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1K0=WIf@002@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI\n0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI01P0\nfMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI05/0\nfMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT2000000/0\nfMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0\nfMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0603IfMT00`000?l0\nfMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000P0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI\n00/0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1Q0=WIf@030000o`3IfMT0fMWI\n01L0fMWI00<0003o0=WIf@3IfMT0G03IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0H@3IfMT00`000?l0\nfMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI05`0fMWI000L0=WIf@030000003IfMT0fMWI00/0fMWI\n00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@1R0=WIf@030000o`3IfMT0fMWI01H0fMWI\n00<0003o0=WIf@3IfMT0G@3IfMT001`0fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0E0=WIf@030000o`3IfMT0fMWI0680fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WI\nf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01D0fMWI00<0003o\n0=WIf@3IfMT0HP3IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0fMWI05d0fMWI000L0=WI\nf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@1S0=WI\nf@030000o`3IfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT0GP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0303IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WIf@3I\nfMT05@3IfMT00`000?l0fMWI0=WIf@1N0=WIf@00703IfMT00`000000fMWI0=WIf@0<0=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0H`3IfMT00`000?l0fMWI0=WIf@0E0=WIf@030000\no`3IfMT0fMWI05h0fMWI000L0=WIf@030000003IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0G`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI06D0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@1O0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0I@3IfMT00`00\n0?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI05l0fMWI000L0=WIf@030000003IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT0G`3IfMT001`0fMWI00<000000=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@1O0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0100fMWI00<0\n003o0=WIf@3IfMT0IP3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0600fMWI000L\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1V\n0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0H03IfMT001`0fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI06H0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@1P0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0I`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI0600fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@1X0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0\nH@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1Q0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0J@3IfMT0\n0`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0640fMWI000L0=WIf@030000003IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT0H@3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI06T0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0\nfMWI0=WIf@1R0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00`0fMWI\n00<0003o0=WIf@3IfMT0JP3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI0680fMWI\n000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WI\nf@1Z0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0HP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06/0fMWI00<0003o\n0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@1S0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WI\nf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0J`3IfMT00`000?l0fMWI0=WIf@0=0=WI\nf@030000o`3IfMT0fMWI06<0fMWI00090=WIf@800000103IfMT2000000D0fMWI0`0000030=WIf@03\n0000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@1/0=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT0\n00002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1/0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3I\nfMT0H`3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT5000000<0fMWI0P00000@0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI06@0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06@0fMWI00080=WIf@04\n0000003IfMT0fMWI000000T0fMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0K@3IfMT00`000?l0fMWI0=WIf@0<0=WI\nf@030000o`3IfMT0fMWI06@0fMWI00090=WIf@8000002`3IfMT2000000@0fMWI00<000000=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06l0fMWI00<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`000000fMWI0=WIf@0@0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0K`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000\no`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0I@3I\nfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI06l0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@1U0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0L03IfMT00`00\n0?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI06D0fMWI000L0=WIf@030000003IfMT0fMWI0140\nfMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@1a0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<000000=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI0780fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@1V0=WIf@00703IfMT00`000000fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI0080fMWI0P00\n0?md0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0IP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT04`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o07D0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@1W0=WIf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@@0003oMP3IfMT0\n0`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI06L0fMWI000L0=WIf@030000003IfMT0fMWI\n01@0fMWI0P000?mg0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0I`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0S@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI06P0\nfMWI000L0=WIf@030000003IfMT0fMWI08h0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@1X0=WIf@00703IfMT00`000000fMWI0=WIf@2>0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0\n003o0=WIf@3IfMT0J03IfMT001`0fMWI00<000000=WIf@3IfMT0SP3IfMT00`000?l0fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI06T0fMWI000L0=WIf@030000003IfMT0fMWI08l0fMWI00<0003o0=WI\nf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@1Y0=WIf@00703IfMT00`000000fMWI0=WIf@2?0=WIf@03\n0000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0JP3IfMT001`0fMWI00<000000=WIf@3IfMT0\nT03IfMT010000?l0fMWI0=WIf@000?m]0=WIf@00703IfMT00`000000fMWI0=WIf@2A0=WIf@<0003o\nK@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@009@3IfMT00`000000fMWI0=WIf@0T0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@80\n0000`03IfMT002@0fMWI00<000000=WIf@3IfMT09P3IfMT00`000000fMWI0=WIf@040=WIf@030000\n003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0_P3IfMT002<0fMWI00<000000=WIf@3IfMT00`3I\nfMT2000000<0fMWI1`0000020=WIf@@0000000<0fMWI0000000000000`3IfMT200000080fMWI0`00\n00000`3IfMT00000000000030=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3I\nfMT2000000@0fMWI00<000000=WIf@3IfMT0_P3IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT0\n10000000fMWI0=WIf@0000020=WIf@@000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000\n003IfMT0000000T0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@030=WIf@05\n0000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000<00fMWI000F0=WI\nf@P0003o1@3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00H0fMWI00@000000=WI\nf@3IfMT000000P3IfMT00`000000fMWI0=WIf@03000000T0fMWI00@000000=WIf@3IfMT00000103I\nfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI\n0=WIf@2n0=WIf@008`3IfMT010000000fMWI0=WIf@3IfMT5000000<0fMWI0`0000000`3IfMT00000\n00000002000000<0fMWI00@000000=WIf@0000000000203IfMT3000000D0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0_P3IfMT002@0fMWI\n00D000000=WIf@3IfMT0fMWI0000000A0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3I\nfMT0103IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`00\n0000fMWI0=WIf@2n0=WIf@009@3IfMT00`000000fMWI0=WIf@0A0=WIf@8000002P3IfMT2000000D0\nfMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P0000300=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.4421`, -0.0744245`, 1.08639`, 0.00329462`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Tank with PID Continuous Controller", "Section"], Cell[TextData[List["We define a ", StyleBox["TankPID", Rule[FontFamily, "Courier"]], " system which is the same as the ", StyleBox["TankPI", Rule[FontFamily, "Courier"]], " system except that the PI controller has been the replaced by a PID controller. Here we see a clear advantage of the object oriented component-based approach over the traditional modeling approach, since system components can easily be replaced and changed in a plug-and-play manner.\n"]], "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0003[L0@0006`0000100001P0000L1002C0000\n00000000000f6000N0h00215CDH00040g3X00641000>0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP00030B000R4P00AdA9@`4008000`00Vi=Fb000000:4P00\n0@0900031@T000l07`000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030:<0>X070000?/240070000002l0P0000010P8RDgUcM6E]000000X000040000\n003ooooo0@000000<0040000;@4001`0003k0_3o00000000T040000014004UAYKFEc84iUMb1BKfeQ\nKP2nH_Egaf;eM`4000000300100002d10@0500000P4100001@0000T200000P<0000N00L0000F18`0\njP000000400002H63`0F0?ooool00?ooooooooook00008d0000300007P050000;P4000001@0000X2\n000000D000090P00000500000@;oool01`000?`20@00000000040000;@4200P0003j0PD00@000000\n00040000;@4300@000030@P01`000184S02<0>X0j`0500002`8000001@0000`2J`>m1A@0000V1Pl0\n7P3ooooo100D0000EfmbI0h0CFUSLVmcKfId85M_LV@50000309[0kd570000?/250090000002l0P00\n00040P8RDgUcM6E]07M00000d`P:5KiRmGO7H_Eg0@000000<0040000;@4400D000020@40000L0000\nn`:]o`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0000]0@D0\n1@0000T200000PD0000;0P00000=0000<PYX0ooo0@040000002m1F/3800U0100000V1Pl05P3ooooo\n001:10009@400685001D0@0020000?X200020000000000@0000]0@H0100002d10P0800009@<204`4\n?04g1C`1100002d10`040000l04600L0003l0P0000000000100002d11P0:000090<303D5DP5P1C`1\n=@DW0@P0003j0P000000000000040000;@4700L0003l0P00oooo0000100002d120040000l04600P0\n000V1Pl01P3ooooo0@040000;@4200@0000]0@<01`0001/4/P3[14T05P440000;@4800@0000]0@L0\n0`0001h01`0001H4/03[14X05P4500000P41000070000?/2[Ol00000002l0P000004@00BE6U]IG<P\nCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4601H0000b2Td0FP8700@05P5:0>X4/01DHFi[\nD4U4LSL0:P0_02d0<`0P03`03@00038:C@2V0`40100F0DX0jPB`0200;P0400009`7oo`@0000]0@80\n20000?X20006000000000P@0000]0@T01`0001/4J0>j1B<010040000;@4800@0000]0@L010000?01\n2@040000;@4200@0000]0@<01`0001/4f`8717P2=P840000;@4800@0000]0@L00`0001h01`0001H4\nf@8617P2=P8500000P41000070000?/2]Ol00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iR\nmGO7H_Eg0@000000<0040000;@4900D000090P00008O0000<PYj0T023@0403H2N0851=T2L6UT@fm^\nM6U^MFmeL`0V01D09P0a02H09P0E01@09P0U02H09P0M00d0000b2WX2n`<100@0=P9h0PD4f@8P0240\n100002L1ool40000;@4200P0003j0P001P00000000840000;@4:00L0000K11l3;@A20Ph2100002d1\n20040000;@4700@0003`0@X01`000?`2003oool000040000;@4:00P0003j0P001P00000000840000\n;@4;00L0000K1>41;P@40@h2100002d120040000l04:00@0000]0@L010000?012`040000;@4200@0\n000]0@<01`0001/4Y@600d81`0840000;@4800@0000]0@L00`0001h01`0001H4X`600d81`0850000\n0P41000070000?/2]Ol00000002@0@000004@00R@G9YHF`0mGM000008`T:3kiRmGO7H_Eg0@000000\n<0040000;@4:00D000090P00008A0000<PY30MP210040<02@P5o0j<1M65^JaD0:P0Z02H0100002d1\n2@0=0000<PY30FL30@040<02@P5o0j<1800Q00@0000W0Ooo1`000?`2003oool000040000;@4;00P0\n003j0P001P00000000840000;@4<00L0000K1<<1;`:70O81100002d120040000l04;00@0000]0@L0\n10000?0130070000o0800?ooo`0000@0000]0@/020000?X20006000000000P@0000]0@`01`0001/4\nFP5>11h14P@40000;@4800@0003`0@/0100002d11`040000l04<00@0000]0@80100002d10`070000\n6`@90VP5^P5610@0000]0@P0100002d11`0300007P0700005P@80VP5^P5610D000020@40000L0000\nn`:mo`0000000901000000A00291LVUQK03eMd00000U2@XA_V;eMlMRmGL10000000`00@0000]0@/0\n1@0000T200000QT0000b2[/1D0@900@0APBj0FL5209d@F=dMF5dKg804`0/02804`0U02D04`0U01H0\n70000?/2_Ol00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000\n;@4<00d0000b2[/1G0D100@0APBj0FL5208P01d0100002L1ool40000;@4200@0000]0@<01`0001/4\n1`8<0[P15`440000;@4800@0000]0@L00`0001h01`0001H41P8<0[P15`4500000P410000100002d1\n2`0500002@8000025P00038:^@4N0@L0100G0KP12`860WACIFicKg804`0]02D0900R02D05P040000\n;@4<00d0000b2[T1108100@05`6h0@/21P8P01h0100002L1ool70000o0800?ooo`0000@0000]0@d0\n20000?X20006000000000P@0000]0@h01`0001/4FP4]0Qh1l@440000;@4800@0003`0@d0100002d1\n1`040000l04>00L0003l0P00oooo0000100002d13@080000nP8000H000000002100002d13P070000\n6`C30Dh4Q`4B10@0000]0@P010000?013@040000;@4700@0003`0@h0100002d10P040000;@4300L0\n000K12h1oP7O0701100002d120040000;@4700<0000N00L0000F12d1o@7O07011@0000810@0000@0\n000]0@/01@0000T200000Q00000b2^00R04300@0L07O0?`1;@5aBFh09@0C02D0100002d1300=0000\n<P[P0>D10@040701g`3l0Bd1800N00@0000W0Ooo100002d10P040000;@4300L0000K12/11@GL03h4\n100002d120040000;@4700<0000N00L0000F12X110GL03h41@0000810@0000@0000]0@/01@0000T2\n00000Q40000b2]d0F0@400@0?PCL00<5:P5aCgEd9@0d02D04`040000;@4<00d0000b2]d0j@@100@0\n?PCL00<5:P4P01h0100002L1ool@00009PH?01H0ooooo`00?P400281003d0@00D@4000P0003j0P00\n0P00000000040000;@4=00@0000]0@80200002D30P100CT1b@4i0@@0000]0@<010000?013@070000\no0800000000000@0000]0@d02P0002@30`370Dl1lP4j0LL190440000;@4700@0000]0@P010000?01\n3@0800009PH?00H0ooooo`40100002d10P040000;@4300L0000K1?T2jPBZ0U04100002d120040000\n;@4700<0000N00L0000F1?P2j@BZ0U041@0000810@0000@0000]0@/01@0000T200000Q40000b2Z/2\nE@@400@0D0BZ0^P4n09SCgEd8P0d02D04`040000;@4<00d0000b2Z/2h`@100@0D0BZ0^P4n08P01d0\n100002L1ool40000;@4200@0000]0@<01`0001/4oP;b0Jl2M@440000;@4800@0000]0@L00`0001h0\n1`0001H4o@;a0Jl2M04500000P410000100002d12`0500002@8000024000038:/0:50@<0101d0Jl2\nl07m0V=9KW@R01<09@040000;@4<00d0000b2[02g`4100@0M06_0_01o@8P01d0100002L1ool@0000\n9PH?01H0ooooo`00304009l1003a0@00`@8000P0003j0P000P00000000040000;@4=00@0000]0@80\n300002D310360JT23P6Y0Ph1X@7^0J41100002d10`040000l04=00L0003l0P0000000000100002d1\n3@0:000090<30<@1_`;^0JX2a06D0P@0000]0@L0100002d120040000l04=00P0000V1Pl01P3ooooo\n0@0@00009PH?01H0ooooo`00A@@008d1001_1@00Z`8000P0003j0P000P00000000040000;@4=00@0\n000]0@80300002D3101>1:P2K0FX0V`5Y05_1:@1100002d10`040000l04=00L0003l0P0000000000\n100002d13@0:000090<30784S`581:@1LPBj0@@0000]0@L0100002d120040000l04=00P0000V1Pl0\n1P3ooooo0@070000o0800?ooo`0000@0000]0@d020000?X20006000000000P@0000]0@h01`0001/4\na`9918/230@40000;@4800@0003`0@d0100002d11`040000l04>00L0003l0P00oooo0000100002d1\n3@080000nP8000H000000002100002d13P0700006`C70Rh2R`;a0@@0000]0@P010000?013@040000\n;@4700@0003`0@h0100002d10P040000;@4300L0000K13d0?@010000100002d120040000;@470100\n000V1Pl05P3ooooo000l0000n00005h1001m0@001`000?`2003oool000040000;@4=00P0003j0P00\n1P00000000840000;@4>00L0000K17h1@P7h03d0100002d120040000l04=00@0000]0@L010000?01\n3P040000;@4200@0000]0@<01`0001/4G@4V0@h1@@040000;@4800@0000]0@L00`0001h01`0001H4\nG04U0@h1@00500000P410000100002d12`0500002@8000025000038:3`5=00H0101000h1905L0G=_\nMG9SIB809@0U01H08P0U00@0000]0@`03@00038:3`4F0@40101000h1905L0B007@0400009`7oo`L0\n003l0P00oooo0000100002d13@080000nP8000H000000002100002d13P0700006`AK0El17P4R0@@0\n000]0@P010000?013@040000;@4700@0003`0@h0100002d110040000l04500@0003`0@H010000?01\n2@040000l04:00@0003`0@/010000?0130070000o0800?ooo`0000@0000]0@D020000?X200000000\n000000@0000]0@H0100002L1ool800009PH?00H0ooooo`40100002L1ool40000;@4000<000000000\n4@0000`0000800002`00010000080@00U00000T0000@0000204009@0000:00004000000000000000\n2@000100003Z0000S0000580001`0@000@0001000007000000000000002l0P00000000420R9C07T0\nL`1d06D0K@0000000000000000000000000000000000000000000000000000000000000000000000\n00000002000001<0>94J07P14`3I1@00D;KlMaJeo7L]]Oag00000800003PnQL0000C02P<4`0N0000\nL=dE09cc4P1h0A<0N04C09D[n7Nh>OQgooooofSe4P101Q<0:0`C0000000000008`TQ49QbD0;lla80\nN04C07P14`000180A?@B00000000080o@0HC0100001Dm180V=Z=0GCd4P3R:5@083@0020d00002000\n/;e@0W03003`0@40000C07P14`1h0A<0N04C0>Ce4P3S/oag5[GlMbfeo7L00000000000T0003PnQL0\nZ?@B05`O6P32`?Ag0@0006Af00P000009@0000`000010000DP00070100020000l?ooo`0000000000\n000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000\n00000000000000000000000000000040000C07P14`1h0A<0N04C0>Ce4P3S/oag5[GlMbfeo7L00000\n000000T0003PnQL0Z?@B05`O6P32`?Ag0@0006Af00P00000UB_hMkPin7OoooooJ?DB04064`0X31<0\n00000000000S2B4@V79@0_cc4P1h0A<0N04C00004P14m18000000000P3m01Q<0400005Cd4P2HfXd1\nM?@B0>8XE00P=00083@00008002`_E02L0<00?010@0001<0N04C07P14`1h0A<0i?DB0>>co7LF]Oag\n;KGlMbD0003PnQL0R?@B0209001D`?Ag0@0001T0/04P2@XAI7H02000000U000030000080000B0000\n30000040000H000030000000008Q0000200001h0000H000000000000003Z0000S000024000080000\n5P0000`000000000N000010000000000000001P0000<0000000001T0000<0000oooo02D0000<0000\n1@00P2D0000<00002000P1l0000H0000j`000>X0002<0000S00000X0000@00000000000000090000\n40000;d5001[0`002@000100002m1@00J`<00580001`0@000`0001@00009000000000000002l0P00\n000000@20R9C07T0L`1d06D0K@000000000000000000000000000000000000000000000000000000\n0000000000000000000100004`1h0A<0N04C07P14`3TmA80hk?lMaJeo7L]]Oag9@000>3j5`28m180\n80T005C0m7L100006@2`0B092Q5TMP08000009D[n7Nh>OQgooooofSe4P101Q<0:0`C000000000000\n8`TQ49QbD0;lla80N04C07P14`000180A?@B00000000080o@0HC0100001Dm180V=Z=0GCd4P3R:5@0\n83@0020d000@8_Aga?3mO`3PoGl100000000000000000000IPL00010001V1`@R0@0006Cd4P0U0000\nh?XG00T0003PnQL0Z?@B0=`P6P32`?Ag0@0006Af00P000009@0000`0000300004P0000`000010000\nDP00070100040000[Oooo`0000000000000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200\nDP1_06d0H@1^00000000000000000000000000000000000000000000000000000000000000000000\nIPL00010001V1`@R0@0006Cd4P0U0000h?XG00T0003PnQL0Z?@B0=`P6P32`?Ag0@0006Af00P00000\nUB_hMkPin7OoooooJ?DB04064`0X31<000000000000S2B4@V79@0_cc4P1h0A<0N04C00004P14m180\n00000000P3m01Q<0400005Cd4P2HfXd1M?@B0>8XE00P=00083@0010Rm7O4l?eo0>3mO`4000000000\n00000000001V1`00040006H712810000I?@B02D0003PnQL0R?@B01h9001D`?Ag0@0001T0/04N2@XK\nI7H02000000U0000300000@0000H000030000000008:00004000000000000000E00005@000000000\n00000?oooooooooo0@000<m;Qd1eD8M0ooooofP300010000C00000@00000000000000;d5001[0`00\nD0000200000U00009P0001`0000500000000008000000000000002D0000<00001@0002D0000<0000\n1@00P5L0000T0000aP0003D0003a0000=@000080001<13`1=`Dl0BD0000<00002000P2P0000<0000\n1@0002L0000H00001@00000000000000000002D0000<00001@0005H0000X0000l0000380003h0000\n>@0000<0000e1E81H0Dl0CD59`4V0000700000H00000000000000000000000009@0000`000060000\n9`0001P00007000000000?ooo`0000009@0000`000070000:00000`0000500009@0000`000050020\n9@0000`000080020:`0001P0000F0@00B@000>H4002/00009@0000`0000700009@0000`000060000\n8@0000P0000N0000600001H1001:0000j`@00;00000B000030000040001B0000L04000D0002]oooo\n0000000000000000_08000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000\n00000000000000000000000000000000000000005P3H[aH000000000001V1`00040006H712810000\nI?@B02D0003PnQL0R?@B0<cc4P000000iCShM`004`3PV1L000000:Sc4P281Q<0G?@B09D[n7L001<0\n1000003d4P10]oagB0LC006H5`030000J?<B0000000`m180003hMaPfn7Oooooo@?@B089cj7L001<0\n00000=R_5P3Y210;f:lF0220mgL48`0042;dMlC`oGl0h?eo0@00000000000000000006H70000@000\nIPL49040001Tm180l37dMfH712@S2B4@IPL4900000049000P?@B093Bm7MTMP08000002D0000<0000\n1@0005@0001h0000K@0000d0002X00007@000040003?BhM0ME27@5X2001=00001`0004`000040000\n5P4004X0003Z1000/00005`0001D0640KP1[0500B@140000=`0002X0000_0000;@0003<0000P0000\n?00005@0001D0000Z@0000d0002a00007@000040003?BhM0ME27@:H3001=00000@0004`000040000\n5P4004X0003Z1000/0000500000P0000;P000280000<0000ooooobD0000<00001@00P2H0000L0000\n200000000006000000000000008U0000300000P0000[0000600000@0000S0000]0D00683000U0000\n300000L0000U0000300000H0000X0000300000P0000U0000300000D0080U0000300000P0080[0000\n600003H2001h0P000P@00=D2000U0000300000L0000U0000300000H0000Q0000200001h0000H0000\n=P8007P200061000f@800180000<00000@000580001`0@0020000;Goool0000000000000002@0@00\n000000A0019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP000000000000000000000000000000\n0000000000000000000G09SM5`000000000006H70000@000IPL49040001Tm180l37dMfH712@S2B4@\nc?<B0000003U>?Qg000C023I5`000000Z?<B08P64`1Lm180UB_hM`004`0400000?@B042go7OX1Q<0\n0MTG010Rm7L@8_Aga?3mO`3PoGl0000000000000000R1@00040002851>D100009?@B0?0am7LR1@CU\n8`TQ4040000@8_Aga?3mO`3PoGl100000000000000000000IPL00010001V1`@W0@0006Cd4P3`<OAg\nIPL49b<98A1V1`@W000000@W0020m180T=;dMfAf00P000009@0000`000080000600000`000000002\nE00009`0001X0000J`000;L0001i00000@000<m;Qd1eD8M0@08007X2000=0000C00000@0000f0P00\nN08000D4003I0P00J0000700J@1T04<0K`1^07@0J@1^07D0K`1e07<0000V00005@0002H0000a0000\n9P0002H0000E0000500002H0000U00009P0002H0000M0000E00005@0002h0000J`000;T0001i0000\n0@000<m;Qd1eD8M0n`<007X200010000C00000@0000f0P00N08000D4003I0P00D0000200000Q0000\n8P0000`0003ooooo9@0000`0000500209P0001`000090000000000H00000000000000RD0000<0000\n2@0002/0000H00003P800482000W10006@<002D0000<00001`0002D0000<00001P0002P0000<0000\n2@0002L0000H00002@000000003oool0000002D0000<00002@0002H0000L00002P00000000060000\n00000000008U0000300000X0000[0000600000h200040@00:0@00=/1000U0000300000L0000X0000\n300000T0000U0000300000H0000X0000300000X0000U0000300000D0080U0000300000P0080[0000\n60000<0200120@00NP<009l1000U0000300000L0000U0000300000H0000Q0000200001h0000H0000\n`080048100200`00X`400180000<00000@000580001`0@002P000;Goool0000000000000002@0@00\n000000A002910780J@1Q06`000000000000000000000000000000000000000000000000000000000\n0000000000000000000G0=1`5`1_07D0L`0006H70000@000IPL49`40001Tm180l37dMfH712LS2B4@\nc?<B0000003U>?Qg000C023I5`000000Z?<B08P64`1Lm180UB_hM`004`0400000?@B042go7OX1Q<0\n0MTG010Rm7L@8_Aga?3mO`3PoGl0000000000000001V1`00040006H712P100009?@B0?0am7MV1`@X\n8`TQ4040000@8_Aga?3mO`3PoGl1000000000000000000008PD00010000R1@CX0@0006Cd4P3`<OAg\n8PD4j2<98A0R1@CX000000CX0020m180T=;dMfAf00P000009@0000`0000:0000600000`000000002\nE00006@000230000=`0009`0001600000@000<m;Qd1eD8M0f08004<100040000C00000@000300P00\n@P4007l3002S0@00E00007@0H@1^06/05@0002X0000Z00009P0002D0000<0000200005@0001D0000\nW@0003L0002P0000A@000040003?BhM0ME27@6L300130@000@0004`000040000`0800481001o0`00\nX`400500000P00008@000280000<0000ooooobL0000H00002@000000003oool0000002D0000<0000\n2@0002H0000L00002`0000000006000000000000008U0000300000/0000[000060000?8100270@00\n:@800;d1000U0000300000L0000X0000300000T0000U0000300000H0000X0000300000/0000W0000\n600000/000000000oooo0000000U0000300000/0000V0000700000T0000000001P00000000000002\n9@0000`000090000:`0001P0000B10007P4004T4001D0@009@0000`000070000:00000`0000;0000\n9@0000`000060000:00000`0000900009@0000`0000500209@0000`000080020:`0001P000161000\n^P4006<500030P009@0000`0000700009@0000`0000600008@0000P0000N0000600004H4002j0@00\nJ0D000P2000B000030000040001B0000L04000T0002moooo0000000000000000T04000000004@00R\n@@1b06T0H@1/00000000000000000000000000000000000000000000000000000000000000000000\n000000005P0`0QH000000000000R1@00040002851>P10000I?@B0?0am7LR1@CX8`TQ4<cc4P000000\niCShM`004`0PfAL000000:Sc4P281Q<0G?@B09D[n7L001<01000003d4P10]oagj0HC007I5`0@8_Ag\n42;dMlC`oGl0h?eo00000000000000008PD00010000R1@CY0@0002Cd4P3`<OAg8PD4jB<98A010000\n42;dMlC`oGl0h?eo0@00000000000000000006H70000@000IPL4:`40001Tm180l37dMfH712/S2B4@\nIPL4:`000004:`00P?@B093Bm7MTMP08000002D0000<00002@0001P0000<000000000U@000240000\naP0004/0003g0000E`000040003?BhM0ME27@504002k0@002@0004`000040000AP@00;X1001W1@00\n20800600001d0440H`1d07D0H@1d06l0LP0001<0000/00008P0001<0000U00009@0001<0000U0000\n5P000580001`0@002`000;goool0000000000000002@0@00000000A0019D06T0K@1U07<0801>06D0\nM`0P0580K`1]0640KP0000000000000000000000000000000000000000000000001_078000000000\n000006H70000@000IPL4:`40001Tm180l37dMfH712/S2B4@c?<B0000003U>?Qg000C09QF5`000000\nZ?<B08P64`1Lm180UB_hMb0in7OoooooK?@B042go7NX1a<0X5HG0:1F5`1f9aX0X5HG003PoGl00000\n00000000000R1@00040002851>T10000000C0?0am7LR1@CY8`TQ404000008_Ag1P00003PoGl10000\n0000000000000000000C00H00000EQL0<00006Cd4P0100002@000=cc4P240000Y?@B09D[n7LH=_Qg\nooooofAf00P000009@0000`0000;0000E00005@0003h0000B`000?T0001G00000@000<m;Qd1eD8M0\nG0D00;/100010000C00000@000161000^P4006L500080P00D0000200000M00008P0000`0003ooooo\n9@0000`0000500209@0000`000080020:`0001P0000G0@00^04000H200010P009@0000`000070000\n9@0000`0000600008@0000P0000N0000600001L1002h0@00308000H2000B000030000040000U0000\n300000T0000H000030000000009D0000N00003<0001;0000G@0005L000010000cd^7@7E@Qd0N0@00\n^@4000L0001<0000100001L1002h0@002`8000H2001L0000M01C06D0KP1c06l0LP0001<0000]0000\n9@0002@0000R00009@0001H0000U0000300000/0001D0000E00005d0001;0000G@0005L000010000\ncd^7@7E@Qd040P00^@400040001<0000100001L1002h0@002`8000H2001@0000800001h0000R0000\n30000?oooolW0000600000`000000000oooo0000000U0000300000`0000V0000700000d000000000\n1P000000000000029@0000`0000=0000:`0001P0003a0@007P4002P2001D0@009@0000`000070000\n:00000`0000<00009@0000`000060000:00000`0000=00009`0001P0000=000000000?ooo`000000\n9@0000`0000=00009P0001`0000<0000000000H00000000000000RD0000<0000300002/0000H0000\n4P@008L100191000_@4002D0000<00001`0002P0000<00003@0002D0000<00001P0002P0000<0000\n300002D0000<00001@00P2D0000<00002000P2/0000H0000L0400=l0003h0@00:04002D0000<0000\n1`0002D0000<00001P000240000800007P0001P0001`0@00g`000?d1000]0@004P0000`000010000\n9@0000`000090000600000`000000002E0000600001700009P0005L0000b00000@000<m;Qd1eD8M0\nR0400>0000030000C00000@0001`0@00g`000?`1000]0@00E0000740B@1^00009@0001<0000U0000\n9@0000`0000;0000E00005@0001H00009P0005/0000b00000@000<m;Qd1eD8M0i@400>0000010000\nC00000@0001`0@00g`000?`1000]0@00D0000200000N00008P0000`0003ooooo9@0000`000050020\n9@0000`000080020:`0001P0000n1000g0000?l4000U0@009@0000`0000700009@0000`000060000\n8@0000P0000N0000600003h4003L000010D002X1000B000030000040000U0000300000T0000H0000\n30000000009D0000I0000<T0000U0000h`00034000010000cd^7@7E@Qd1H1000g@0000@0001<0000\n100003h4003L00000`D002X1001D0000L@1?07D0M00U0000=00002D0000C00009@0000`0000;0000\nE00005@0003S00009@000>H0000a00000@000<m;Qd1eD8M0j@@00=d000010000C00000@0000n1000\ng00000<5000Z0@00D0000200000N00008P0000`0003ooooo9P0001`0000<00000000008000000000\n000002D0000<0000300002D0000<00001@00P5L0000T0000>P0003D0001B0000=@00008000100CT1\nb@4i0BD0000<00002000P2P0000<0000300002L0000H00003000000000000000000002D0000<0000\n300005H0000X0000DP000340001J0000>@0000<000370Dl1lP4j0LL1904U0000300000H0000U0000\n300000L0000X0000300000`0000U0000300000D0080U0000300000P0080[000060000504002Z0P00\ni0@00?<2000U0000300000L0000U0000300000H0000Q0000200001h0000H0000D0@00:X2003Y1000\nn0800180000<00000@0002D0000<00002@0001P0000<000000000U@0001T0000b00007@0003Q0000\nP0000040003?BhM0ME27@5D4002[0P00100004`000040000D0@00:X2003X1000n08005@0001S04l0\nM@1d0280000d00009@0001<0000U0000300000/0001D0000E0000>80001d0000hP00080000010000\ncd^7@7E@Qd3S1000Z`800040001<000010000504002Z0P00j0@00?P2001@0000800001d0000R0000\n30000?oooolU0000300000D0080U0000300000P0080[0000600007D1002_0P00k0400?P2000U0000\n300000L0000U0000300000H0000Q0000200001h0000H0000M0400:l2003a0@00o@800180000<0000\n0@0002D0000<00002@0001P0000<000000000U@0001P0000AP0007@0001F0000P0000040003?BhM0\nME27@8D1002`0P000`0004`000040000M0400:l2003`0@00o@8005@0001S04T0KP000280000C0000\n9@0002D0000<00002`0005@0001D0000EP0007@0001I0000P0000040003?BhM0ME27@=l1002`0P00\n0@0004`000040000M0400:l2003`0@00o@800500000P00007@000280000<0000ooooobH0000L0000\n300000000002000000000000000U0000300000`0000U0000300000D0081G0000;000034000170000\nF@0007<000040000aP6Y0Ph1Z@8>0J41kP6Q0BD0000<00002000P2P0000<0000300002L0000H0000\n3000000000000000000002D0000<0000300005H0000X0000DP000700001I0000M`0000<000340Kl2\nkP6Z0/@1U08U0000300000H0000U0000300000L0000X0000300000`0000V0000700000`000000000\n0P000000000000009@0000`0000<00009@0000`000050020E`0002`000370000A`000?X0001c0000\n100004h4Z09/1JP2K0FT0Fl4Y04U0000300000P0080X0000300000`0000W0000600000`000000000\n00000000000U0000300000`0001F0000:0000<H000140000c@0004/000030000LPB?0DP4Y05b1;X1\n9@0000`0000600009@0000`000070000:00000`0000<00009`0001P0000<000000000?ooo`000000\n9@0000`0000<00009P0001`0000=0000000000H00000000000000RD0000<00003@0002/0000H0000\n30@008/200131000`@8002D0000<00001`0002P0000<0000300002D0000<00001P0002P0000<0000\n3@0002L0000H00003@000000003oool0000002D0000<00003@0002H0000L00003000000000060000\n00000000008U0000300000`0000[000060000?41002;0P00:@800<42000U0000300000L0000X0000\n300000d0000U0000300000H0000X0000300000`0000U0000300000D0080U0000300000P0080[0000\n6000000000010000=`0003L0000U0000300000L0000U0000300000H0000W0000600000`000000000\noooo0000000U0000300000`0000V0000700000d0000000001P000000000000029@0000`0000=0000\n:`0001P0000m0000n00003`1001h0@009@0000`000070000:00000`0000<00009@0000`000060000\n:00000`0000=00009@0000`0000500209@0000`000080020:`0001P0001100003P400241001G0@00\n9@0000`0000700009@0000`0000600008@0000P0000N000060000400000>0@009@4005`1000B0000\n30000040000U0000300000T0000H000030000000009D0000L00000h0000^0000<P0003X000010000\ncd^7@7E@Qd1=00003`4000H0001<000010000400000>0@00904005`1001H0000L`1_07D0LP1S06D0\n8P0002D0000U00005P000280000U00009@0000`0000;0000E00005@0000b0000;P0003@0000j0000\n0@000<m;Qd1eD8M05P4000l100010000C00000@0001000003P4002@1001L0@00D0000200000M0000\n8P0000`0003ooooo9`0001P0000=000000000?ooo`0000009@0000`0000=00009P0001`0000<0000\n000000H00000000000000RD0000<0000300002/0000H00008P4001h1001I0@00E@4002D0000<0000\n1`0002P0000<00003@0002D0000<00001P0002P0000<0000300002D0000<00000`0002P0000<0000\n100002P0000<00001@0002P0000<0000200002P0000<00002P0002P0000<00002@0002P0000<0000\n2`0002L0000H00002`000000003oool0000002D0000<00002`0002H0000L00002@00000000000000\n00000000000U0000300000T0000R000030000?oooolR000030000?oooolU000030000040000U0000\n300000L0080U000030000000080`0000300000l0080U0000300000d0081;00004000000000050000\n:00000`000010000:00000`000020000:00000`000030000:00000`0000;0000:00000`000090000\n:00000`000060000:00000`0000700003P0001@000000000400001@0\n"], "Text", Rule[ImageSize, List[262, 141]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[BoxData[StyleBox[RowBox[List["The", " ", "tank", " ", "system", " ", "with", " ", "the", " ", "PI", " ", "controller", " ", "replaced", " ", "by", " ", "a", " ", "PID", " ", RowBox[List["controller", "."]]]], Rule[FontFamily, "Times New Roman"]]], "NumberedFigure"], Cell[TextData[List["\nThe Modelica class declaration for the ", StyleBox["TankPID", Rule[FontFamily, "Courier"]], " system appears as follows:"]], "Text"], Cell[TextData[StyleBox["model TankPID\n  LiquidSource            source(flowLevel  = 0.02);\n  PIDcontinuousController pidContinuous(ref = 0.25);\n  Tank                    tank(area = 1);\nequation\n  connect(source.qOut, tank.qIn);\n  connect(tank.tActuator, pidContinuous.cOut);\n  connect(tank.tSensor, pidContinuous.cIn);\nend TankPID;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"], Cell[TextData[List["\nWe create a ", StyleBox["PIDcontinuousController", Rule[FontFamily, "Courier"]], " class in Modelica containing the three defining equations:"]], "Text"], Cell["model PIDcontinuousController\n  extends BaseController(K = 2, T = 10);\n  Real  x; \t\t\t\t\t\t\t\t\t// State variable of continuous PID controller\n  Real  y; \t\t\t\t\t\t\t\t\t// State variable of continuous PID controller\nequation\n  der(x) = error/T;\n  y      = T*der(error);\n  outCtr = K*(error + x + y);\nend PIDcontinuousController;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of TankPID", "Section"], Cell["We simulate the tank model once more but now including the PID controller:", "Text"], Cell["simulate( TankPID, stopTime=250 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TankPID\\) : 2004-1-30 15:45:8.0612888 : \\!\\({0.`, 250.`}\\) : 504 data points : 2 events : 24 variables>\\n\\!\\({\\*TagBox[\\(pidContinuous . cIn . val\\), HoldForm], \\*TagBox[\\(pidContinuous . cOut . act\\), HoldForm], \\*TagBox[\\(pidContinuous . error\\), HoldForm], \\*TagBox[\\(pidContinuous . K\\), HoldForm], \\*TagBox[\\(pidContinuous . outCtr\\), HoldForm], \\*TagBox[\\(pidContinuous . ref\\), HoldForm], \\*TagBox[\\(pidContinuous . T\\), HoldForm], \\*TagBox[\\(pidContinuous . Ts\\), HoldForm], \\*TagBox[\\(pidContinuous . x\\), HoldForm], \\*TagBox[\\(pidContinuous . y\\), HoldForm], \\*TagBox[\\(source . flowLevel\\), HoldForm], \\*TagBox[\\(source . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank . area\\), HoldForm], \\*TagBox[\\(tank . flowGain\\), HoldForm], \\*TagBox[\\(tank . h\\), HoldForm], \\*TagBox[\\(tank . maxV\\), HoldForm], \\*TagBox[\\(tank . minV\\), HoldForm], \\*TagBox[\\(tank . qIn . lflow\\), HoldForm], \\*TagBox[\\(tank . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank . tActuator . act\\), HoldForm], \\*TagBox[\\(tank . tSensor . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((pidContinuous . error)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((pidContinuous . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tank . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( tank.h );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00380952 0.0147151 1.38483 [\n[.21429 .00222 -6 -9 ]\n[.21429 .00222 6 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .1532 -18 -4.5 ]\n[.01131 .1532 0 4.5 ]\n[.01131 .29168 -18 -4.5 ]\n[.01131 .29168 0 4.5 ]\n[.01131 .43017 -18 -4.5 ]\n[.01131 .43017 0 4.5 ]\n[.01131 .56865 -18 -4.5 ]\n[.01131 .56865 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(50)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(100)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(150)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(200)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(250)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.0619 .01472 m\n.0619 .01847 L\ns\n.1 .01472 m\n.1 .01847 L\ns\n.1381 .01472 m\n.1381 .01847 L\ns\n.17619 .01472 m\n.17619 .01847 L\ns\n.25238 .01472 m\n.25238 .01847 L\ns\n.29048 .01472 m\n.29048 .01847 L\ns\n.32857 .01472 m\n.32857 .01847 L\ns\n.36667 .01472 m\n.36667 .01847 L\ns\n.44286 .01472 m\n.44286 .01847 L\ns\n.48095 .01472 m\n.48095 .01847 L\ns\n.51905 .01472 m\n.51905 .01847 L\ns\n.55714 .01472 m\n.55714 .01847 L\ns\n.63333 .01472 m\n.63333 .01847 L\ns\n.67143 .01472 m\n.67143 .01847 L\ns\n.70952 .01472 m\n.70952 .01847 L\ns\n.74762 .01472 m\n.74762 .01847 L\ns\n.82381 .01472 m\n.82381 .01847 L\ns\n.8619 .01472 m\n.8619 .01847 L\ns\n.9 .01472 m\n.9 .01847 L\ns\n.9381 .01472 m\n.9381 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .1532 m\n.03006 .1532 L\ns\n[(0.1)] .01131 .1532 1 0 Mshowa\n.02381 .29168 m\n.03006 .29168 L\ns\n[(0.2)] .01131 .29168 1 0 Mshowa\n.02381 .43017 m\n.03006 .43017 L\ns\n[(0.3)] .01131 .43017 1 0 Mshowa\n.02381 .56865 m\n.03006 .56865 L\ns\n[(0.4)] .01131 .56865 1 0 Mshowa\n.125 Mabswid\n.02381 .04241 m\n.02756 .04241 L\ns\n.02381 .07011 m\n.02756 .07011 L\ns\n.02381 .09781 m\n.02756 .09781 L\ns\n.02381 .1255 m\n.02756 .1255 L\ns\n.02381 .1809 m\n.02756 .1809 L\ns\n.02381 .20859 m\n.02756 .20859 L\ns\n.02381 .23629 m\n.02756 .23629 L\ns\n.02381 .26399 m\n.02756 .26399 L\ns\n.02381 .31938 m\n.02756 .31938 L\ns\n.02381 .34708 m\n.02756 .34708 L\ns\n.02381 .37477 m\n.02756 .37477 L\ns\n.02381 .40247 m\n.02756 .40247 L\ns\n.02381 .45786 m\n.02756 .45786 L\ns\n.02381 .48556 m\n.02756 .48556 L\ns\n.02381 .51326 m\n.02756 .51326 L\ns\n.02381 .54095 m\n.02756 .54095 L\ns\n.02381 .59635 m\n.02756 .59635 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .02856 L\n.02762 .04241 L\n.02952 .05626 L\n.03143 .07011 L\n.03333 .08396 L\n.03524 .09781 L\n.03714 .11165 L\n.03905 .1255 L\n.04095 .13935 L\n.04286 .1532 L\n.04476 .16705 L\n.04667 .1809 L\n.04857 .19474 L\n.05048 .20859 L\n.05238 .22244 L\n.05429 .23629 L\n.05619 .2501 L\n.0581 .26388 L\n.06 .27765 L\n.0619 .29141 L\n.06381 .30501 L\n.06571 .31839 L\n.06762 .33155 L\n.06952 .34441 L\n.07143 .35698 L\n.07333 .36926 L\n.07524 .38122 L\n.07714 .39287 L\n.07905 .40419 L\n.08095 .41519 L\n.08286 .42584 L\n.08476 .43615 L\n.08667 .44612 L\n.08857 .45574 L\n.09048 .46501 L\n.09238 .47392 L\n.09429 .48248 L\n.09619 .49067 L\n.0981 .49849 L\n.1 .50596 L\n.1019 .51307 L\n.10381 .5198 L\n.10571 .52618 L\n.10762 .5322 L\n.10952 .53785 L\n.11143 .54315 L\n.11333 .54809 L\n.11524 .55268 L\n.11714 .55691 L\nMistroke\n.11905 .5608 L\n.12095 .56435 L\n.12286 .56756 L\n.12476 .57043 L\n.12667 .57297 L\n.12857 .57518 L\n.13048 .57708 L\n.13238 .57865 L\n.13429 .57992 L\n.13619 .58089 L\n.1381 .58156 L\n.14 .58195 L\n.1419 .58205 L\n.14381 .58188 L\n.14571 .58144 L\n.14762 .58073 L\n.14952 .57977 L\n.15143 .57856 L\n.15333 .57712 L\n.15524 .57544 L\n.15714 .57354 L\n.15905 .57143 L\n.16095 .5691 L\n.16286 .56658 L\n.16476 .56386 L\n.16667 .56096 L\n.16857 .55789 L\n.17048 .55465 L\n.17238 .55126 L\n.17429 .5477 L\n.17619 .54401 L\n.1781 .54018 L\n.18 .53622 L\n.1819 .53215 L\n.18381 .52797 L\n.18571 .52368 L\n.18762 .5193 L\n.18952 .51483 L\n.19143 .51028 L\n.19333 .50566 L\n.19524 .50097 L\n.19714 .49623 L\n.19905 .49144 L\n.20095 .48661 L\n.20286 .48174 L\n.20476 .47684 L\n.20667 .47192 L\n.20857 .46699 L\n.21048 .46205 L\n.21238 .4571 L\nMistroke\n.21429 .45216 L\n.21619 .44723 L\n.2181 .44232 L\n.22 .43742 L\n.2219 .43255 L\n.22381 .42772 L\n.22571 .42292 L\n.22762 .41816 L\n.22952 .41345 L\n.23143 .40879 L\n.23333 .40419 L\n.23524 .39965 L\n.23714 .39517 L\n.23905 .39076 L\n.24095 .38642 L\n.24286 .38216 L\n.24476 .37798 L\n.24667 .37388 L\n.24857 .36986 L\n.25048 .36594 L\n.25238 .3621 L\n.25429 .35835 L\n.25619 .35471 L\n.2581 .35115 L\n.26 .3477 L\n.2619 .34435 L\n.26381 .34111 L\n.26571 .33797 L\n.26762 .33493 L\n.26952 .332 L\n.27143 .32918 L\n.27333 .32647 L\n.27524 .32387 L\n.27714 .32137 L\n.27905 .31899 L\n.28095 .31672 L\n.28286 .31456 L\n.28476 .31251 L\n.28667 .31057 L\n.28857 .30874 L\n.29048 .30702 L\n.29238 .30541 L\n.29429 .3039 L\n.29619 .30251 L\n.2981 .30122 L\n.3 .30004 L\n.3019 .29896 L\n.30381 .29798 L\n.30571 .29711 L\n.30762 .29634 L\nMistroke\n.30952 .29566 L\n.31143 .29508 L\n.31333 .2946 L\n.31524 .29421 L\n.31714 .29391 L\n.31905 .29371 L\n.32095 .29359 L\n.32286 .29356 L\n.32476 .29361 L\n.32667 .29374 L\n.32857 .29395 L\n.33048 .29424 L\n.33238 .29461 L\n.33429 .29504 L\n.33619 .29555 L\n.3381 .29613 L\n.34 .29677 L\n.3419 .29748 L\n.34381 .29824 L\n.34571 .29907 L\n.34762 .29995 L\n.34952 .30088 L\n.35143 .30187 L\n.35333 .3029 L\n.35524 .30398 L\n.35714 .30511 L\n.35905 .30627 L\n.36095 .30747 L\n.36286 .30871 L\n.36476 .30999 L\n.36667 .31129 L\n.36857 .31263 L\n.37048 .31399 L\n.37238 .31537 L\n.37429 .31678 L\n.37619 .31821 L\n.3781 .31965 L\n.38 .32111 L\n.3819 .32258 L\n.38381 .32406 L\n.38571 .32556 L\n.38762 .32706 L\n.38952 .32856 L\n.39143 .33007 L\n.39333 .33157 L\n.39524 .33308 L\n.39714 .33458 L\n.39905 .33608 L\n.40095 .33758 L\n.40286 .33906 L\nMistroke\n.40476 .34053 L\n.40667 .342 L\n.40857 .34345 L\n.41048 .34489 L\n.41238 .34631 L\n.41429 .34771 L\n.41619 .3491 L\n.4181 .35046 L\n.42 .35181 L\n.4219 .35313 L\n.42381 .35443 L\n.42571 .35571 L\n.42762 .35696 L\n.42952 .35818 L\n.43143 .35938 L\n.43333 .36055 L\n.43524 .36169 L\n.43714 .36281 L\n.43905 .36389 L\n.44095 .36494 L\n.44286 .36596 L\n.44476 .36695 L\n.44667 .36791 L\n.44857 .36884 L\n.45048 .36973 L\n.45238 .37059 L\n.45429 .37142 L\n.45619 .37221 L\n.4581 .37297 L\n.46 .37369 L\n.4619 .37439 L\n.46381 .37504 L\n.46571 .37567 L\n.46762 .37626 L\n.46952 .37681 L\n.47143 .37733 L\n.47333 .37782 L\n.47524 .37828 L\n.47714 .3787 L\n.47905 .37909 L\n.48095 .37945 L\n.48286 .37978 L\n.48476 .38007 L\n.48667 .38034 L\n.48857 .38057 L\n.49048 .38078 L\n.49238 .38095 L\n.49429 .3811 L\n.49619 .38122 L\n.4981 .38131 L\nMistroke\n.5 .38137 L\n.5019 .38141 L\n.50381 .38142 L\n.50571 .3814 L\n.50762 .38136 L\n.50952 .3813 L\n.51143 .38121 L\n.51333 .3811 L\n.51524 .38097 L\n.51714 .38082 L\n.51905 .38064 L\n.52095 .38045 L\n.52286 .38024 L\n.52476 .38 L\n.52667 .37976 L\n.52857 .37949 L\n.53048 .37921 L\n.53238 .37891 L\n.53429 .3786 L\n.53619 .37827 L\n.5381 .37793 L\n.54 .37758 L\n.5419 .37722 L\n.54381 .37685 L\n.54571 .37646 L\n.54762 .37607 L\n.54952 .37567 L\n.55143 .37526 L\n.55333 .37484 L\n.55524 .37441 L\n.55714 .37398 L\n.55905 .37355 L\n.56095 .37311 L\n.56286 .37266 L\n.56476 .37222 L\n.56667 .37176 L\n.56857 .37131 L\n.57048 .37086 L\n.57238 .3704 L\n.57429 .36995 L\n.57619 .36949 L\n.5781 .36904 L\n.58 .36858 L\n.5819 .36813 L\n.58381 .36768 L\n.58571 .36724 L\n.58762 .36679 L\n.58952 .36635 L\n.59143 .36592 L\n.59333 .36549 L\nMistroke\n.59524 .36506 L\n.59524 .36506 L\n.59524 .36506 L\n.59714 .37831 L\n.59905 .39122 L\n.60095 .40376 L\n.60286 .41594 L\n.60476 .42775 L\n.60667 .43918 L\n.60857 .45024 L\n.61048 .46092 L\n.61238 .47121 L\n.61429 .48111 L\n.61619 .49063 L\n.6181 .49975 L\n.62 .50848 L\n.6219 .51681 L\n.62381 .52474 L\n.62571 .53228 L\n.62762 .53942 L\n.62952 .54616 L\n.63143 .55251 L\n.63333 .55847 L\n.63524 .56403 L\n.63714 .56921 L\n.63905 .57399 L\n.64095 .57841 L\n.64286 .58244 L\n.64476 .58609 L\n.64667 .58938 L\n.64857 .59231 L\n.65048 .59487 L\n.65238 .59709 L\n.65429 .59895 L\n.65619 .60048 L\n.6581 .60167 L\n.66 .60254 L\n.6619 .60309 L\n.66381 .60332 L\n.66571 .60325 L\n.66762 .60288 L\n.66952 .60222 L\n.67143 .60127 L\n.67333 .60006 L\n.67524 .59857 L\n.67714 .59683 L\n.67905 .59484 L\n.68095 .59261 L\n.68286 .59014 L\n.68476 .58746 L\nMistroke\n.68667 .58456 L\n.68857 .58145 L\n.69048 .57815 L\n.69238 .57466 L\n.69429 .57099 L\n.69619 .56716 L\n.6981 .56317 L\n.7 .55903 L\n.7019 .55474 L\n.70381 .55032 L\n.70571 .54577 L\n.70762 .54111 L\n.70952 .53634 L\n.71143 .53148 L\n.71333 .52653 L\n.71524 .52149 L\n.71714 .51638 L\n.71905 .5112 L\n.72095 .50596 L\n.72286 .50068 L\n.72476 .49536 L\n.72667 .49 L\n.72857 .48461 L\n.73048 .47921 L\n.73238 .47379 L\n.73429 .46836 L\n.73619 .46294 L\n.7381 .45753 L\n.74 .45213 L\n.7419 .44675 L\n.74381 .4414 L\n.74571 .43608 L\n.74762 .4308 L\n.74952 .42557 L\n.75143 .42038 L\n.75333 .41526 L\n.75524 .41019 L\n.75714 .40518 L\n.75905 .40024 L\n.76095 .39538 L\n.76286 .3906 L\n.76476 .38589 L\n.76667 .38127 L\n.76857 .37675 L\n.77048 .37231 L\n.77238 .36797 L\n.77429 .36373 L\n.77619 .35959 L\n.7781 .35556 L\n.78 .35163 L\nMistroke\n.7819 .34781 L\n.78381 .3441 L\n.78571 .3405 L\n.78762 .33702 L\n.78952 .33365 L\n.79143 .3304 L\n.79333 .32727 L\n.79524 .32426 L\n.79714 .32136 L\n.79905 .31859 L\n.80095 .31594 L\n.80286 .31341 L\n.80476 .311 L\n.80667 .30871 L\n.80857 .30654 L\n.81048 .30449 L\n.81238 .30256 L\n.81429 .30075 L\n.81619 .29906 L\n.8181 .29749 L\n.82 .29604 L\n.8219 .2947 L\n.82381 .29348 L\n.82571 .29237 L\n.82762 .29137 L\n.82952 .29048 L\n.83143 .2897 L\n.83333 .28903 L\n.83524 .28846 L\n.83714 .288 L\n.83905 .28764 L\n.84095 .28737 L\n.84286 .28721 L\n.84476 .28714 L\n.84667 .28716 L\n.84857 .28727 L\n.85048 .28748 L\n.85238 .28776 L\n.85429 .28813 L\n.85619 .28858 L\n.8581 .28911 L\n.86 .28972 L\n.8619 .2904 L\n.86381 .29114 L\n.86571 .29196 L\n.86762 .29284 L\n.86952 .29378 L\n.87143 .29478 L\n.87333 .29584 L\n.87524 .29696 L\nMistroke\n.87714 .29812 L\n.87905 .29934 L\n.88095 .30059 L\n.88286 .3019 L\n.88476 .30324 L\n.88667 .30462 L\n.88857 .30604 L\n.89048 .30749 L\n.89238 .30897 L\n.89429 .31047 L\n.89619 .31201 L\n.8981 .31356 L\n.9 .31514 L\n.9019 .31673 L\n.90381 .31834 L\n.90571 .31996 L\n.90762 .32159 L\n.90952 .32323 L\n.91143 .32487 L\n.91333 .32652 L\n.91524 .32817 L\n.91714 .32982 L\n.91905 .33147 L\n.92095 .33312 L\n.92286 .33475 L\n.92476 .33638 L\n.92667 .338 L\n.92857 .33961 L\n.93048 .3412 L\n.93238 .34278 L\n.93429 .34435 L\n.93619 .34589 L\n.9381 .34742 L\n.94 .34892 L\n.9419 .3504 L\n.94381 .35186 L\n.94571 .35329 L\n.94762 .3547 L\n.94952 .35608 L\n.95143 .35743 L\n.95333 .35876 L\n.95524 .36005 L\n.95714 .36131 L\n.95905 .36254 L\n.96095 .36374 L\n.96286 .36491 L\n.96476 .36604 L\n.96667 .36713 L\n.96857 .3682 L\n.97048 .36922 L\nMistroke\n.97238 .37022 L\n.97429 .37117 L\n.97619 .37209 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank) show\n93.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n105.000 12.813 moveto\n(L) show\n111.000 12.813 moveto\n(@) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n123.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00AP3IfMT2000000@0fMWI0P00000R0=WIf@D000000P3IfMT2000000@0\nfMWI0P00000O0=WIf@D000000P3IfMT2000000@0fMWI0P00000O0=WIf@@000000`3IfMT2000000@0\nfMWI0P00000O0=WIf@@000000`3IfMT2000000@0fMWI0P00000G0=WIf@00A@3IfMT010000000fMWI\n0=WIf@0000020=WIf@040000003IfMT0fMWI000002<0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT07P3IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00000N\n0=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WI\nf@00000F0=WIf@00B03IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI0240fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WI\nf@3IfMT07P3IfMT00`000000fMWI0=WIf@040=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00@0\n00000=WIf@3IfMT000007`3IfMT00`000000fMWI0=WIf@050=WIf@040000003IfMT0fMWI00000080\nfMWI00<000000=WIf@3IfMT0503IfMT004H0fMWI0P0000030=WIf@040000003IfMT0fMWI000002<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT07P3IfMT00`000000fMWI0=WIf@020=WIf@8000000`3IfMT010000000fMWI0=WIf@00\n000P0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@03\n0000003IfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI00@000000=WIf@3I\nfMT000005P3IfMT004H0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00000S0=WI\nf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003I\nfMT0fMWI01h0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000001H0fMWI00160=WIf@<000000`3IfMT2000002<0fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT200000200fMWI0P00\n00040=WIf@800000103IfMT200000200fMWI0P0000040=WIf@<000000`3IfMT2000001L0fMWI003o\n0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT6000000030000o`00\n000000000>T00000203IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00L0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT01P3IfMT00`000000fMWI0=WIf@07\n0=WIf@030000003IfMT0fMWI00X0fMWI1@00000<0=WIf@00703IfMT00`000?l0fMWI0=WIf@3a0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<0003o0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000o`3IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0003o0=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000?l0fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000000o`3IfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o\n0=WIf@80fMWI000L0=WIf@03000000000?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000000o`3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000003o0=WIf@3o0=WIf@80fMWI000L0=WIf@0300000000\n0?l0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0000o`3o0=WIf@80fMWI000L0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@000?l0o`3IfMT20=WIf@00703IfMT00`000000fMWI0000o`3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0003o0?l0fMWI0P3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT1\n0=WIf@00703IfMT010000000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003IfMT0fMWI\n0000ool0fMWI0@3IfMT001`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703IfMT01000\n0000fMWI0=WIf@000?oo0=WIf@40fMWI000L0=WIf@040000003IfMT0fMWI0000ool0fMWI0@3IfMT0\n01`0fMWI00@000000=WIf@3IfMT0003oo`3IfMT10=WIf@00703IfMT01@000000fMWI0=WIf@3IfMT0\n003o0?l0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0o`3IfMT000T0fMWI0P0000040=WI\nf@8000000`3IfMT5000000<0fMWI00D000000=WIf@3IfMT0fMWI0000o`3o0=WIf@00203IfMT01000\n0000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI0000\no`3o0=WIf@00203IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI0P00\n00020=WIf@030000o`3IfMT0fMWI0?d0fMWI00080=WIf@040000003IfMT0fMWI000000X0fMWI00<0\n00000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o0?l0fMWI00080=WIf@040000003I\nfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0003o0?l0\nfMWI00090=WIf@8000002P3IfMT2000000D0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0?`0fMWI000L\n0=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@03\n0000o`3IfMT0fMWI0?`0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0\no03IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT0\n0`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI\n00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0\nfMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0?/0fMWI\n000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0n`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703IfMT00`000000fMWI0=WIf@030=WI\nf@030000o`3IfMT0fMWI0?/0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT0n`3IfMT001`0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@3k0=WIf@00703I\nfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT00`00\n0?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0?X0\nfMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0nP3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@3j0=WIf@00703IfMT00`000000fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI0?X0fMWI000L0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WI\nf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@3i0=WIf@00\n703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0?T0fMWI000L0=WIf@030000003I\nfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0n@3IfMT001`0fMWI00<000000=WIf@3IfMT01@3IfMT0\n0`000?l0fMWI0=WIf@3i0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI\n0?T0fMWI00090=WIf@800000103IfMT2000000<0fMWI100000040=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0n@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000\nfMWI0=WIf@050=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0]P3IfMT90000ocT0\nfMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0103IfMT2000000L0\nfMWI00<0003o0=WIf@3IfMT0>@3IfMT60000ogD0fMWI0`000?l70=WIf@<0003o=`3IfMT000P0fMWI\n00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0=`3IfMT30000o`D0fMWI0`000?ma0=WIf@80003o2`3IfMT30000ocD0\nfMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`00\n0000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI03D0fMWI0`000?l90=WIf@<0003oKP3IfMT20000\no`h0fMWI0P000?ld0=WIf@002@3IfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0=03IfMT20000o`h0fMWI0P000?m[0=WIf@80003o4@3IfMT00`000?l0\nfMWI0=WIf@0a0=WIf@00703IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI03<0fMWI\n00<0003o0=WIf@3IfMT03`3IfMT20000ofT0fMWI0P000?lC0=WIf@80003o<@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0a0=WIf@80003o4`3IfMT20000ofL0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT20000oc00fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT0<03IfMT20000oaD0fMWI0P000?mU0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o\n0=WIf@3IfMT0;@3IfMT001`0fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0`0=WI\nf@030000o`3IfMT0fMWI01D0fMWI0P000?mS0=WIf@030000o`3IfMT0fMWI01P0fMWI0P000?l]0=WI\nf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02l0fMWI00<0003o0=WIf@3I\nfMT0603IfMT00`000?l0fMWI0=WIf@1O0=WIf@80003o6`3IfMT00`000?l0fMWI0=WIf@0[0=WIf@00\n703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02h0fMWI00<0003o0=WIf@3IfMT0\n6P3IfMT20000oel0fMWI00<0003o0=WIf@3IfMT06`3IfMT20000ob/0fMWI000L0=WIf@030000003I\nfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0;@3IfMT20000oad0fMWI0P000?mN0=WIf@030000o`3I\nfMT0fMWI01`0fMWI0P000?lZ0=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI02d0fMWI00<0003o0=WIf@3IfMT07P3IfMT00`000?l0fMWI0=WIf@1J0=WIf@030000o`3IfMT0\nfMWI01h0fMWI0P000?lY0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI\n02/0fMWI0P000?lQ0=WIf@030000o`3IfMT0fMWI05P0fMWI0P000?lR0=WIf@80003o9`3IfMT001`0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0[0=WIf@030000o`3IfMT0fMWI0240\nfMWI0P000?mH0=WIf@030000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3IfMT09@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Z0=WIf@030000o`3IfMT0fMWI02<0fMWI\n0P000?mF0=WIf@030000o`3IfMT0fMWI02@0fMWI0P000?lU0=WIf@00703IfMT00`000000fMWI0=WI\nf@080=WIf@030000o`3IfMT0fMWI02X0fMWI00<0003o0=WIf@3IfMT09@3IfMT20000oe@0fMWI00<0\n003o0=WIf@3IfMT09@3IfMT20000ob@0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o\n0=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@0W0=WIf@80003oDP3IfMT00`000?l0fMWI0=WIf@0X\n0=WIf@80003o8P3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0Y0=WI\nf@030000o`3IfMT0fMWI02T0fMWI0P000?lU0=WIf@030000o`3IfMT0fMWI02P0fMWI00<0003o0=WI\nf@3IfMT0:@3IfMT20000ob40fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3I\nfMT0:03IfMT00`000?l0fMWI0=WIf@0/0=WIf@80003o7P3IfMT60000obT0fMWI00<0003o0=WIf@3I\nfMT0;03IfMT20000oal0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0\n:03IfMT00`000?l0fMWI0=WIf@0^0=WIf@80003o603IfMT50000o`@0fMWI00<0003o0=WIf@3IfMT0\n9`3IfMT00`000?l0fMWI0=WIf@0^0=WIf@80003o7@3IfMT001`0fMWI00<000000=WIf@3IfMT0203I\nfMT00`000?l0fMWI0=WIf@0W0=WIf@030000o`3IfMT0fMWI0340fMWI10000?l@0=WIf@D0003o203I\nfMT00`000?l0fMWI0=WIf@0V0=WIf@030000o`3IfMT0fMWI04h0fMWI000L0=WIf@030000003IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT09P3IfMT00`000?l0fMWI0=WIf@0d0=WIfA40003o3@3IfMT0\n0`000?l0fMWI0=WIf@0V0=WIf@030000o`3IfMT0fMWI04h0fMWI000L0=WIf@030000003IfMT0fMWI\n00T0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI\n02H0fMWI00<0003o0=WIf@3IfMT0CP3IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0\nfMWI0=WIf@0U0=WIf@030000o`3IfMT0fMWI05@0fMWI00<0003o0=WIf@3IfMT09@3IfMT00`000?l0\nfMWI0=WIf@1>0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI02D0fMWI\n00<0003o0=WIf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@0T0=WIf@030000o`3IfMT0fMWI04l0fMWI\n000L0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0903IfMT00`000?l0fMWI0=WI\nf@1E0=WIf@030000o`3IfMT0fMWI02@0fMWI00<0003o0=WIf@3IfMT0C`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0S0=WIf@030000o`3IfMT0fMWI05D0fMWI00<0003o\n0=WIf@3IfMT08`3IfMT00`000?l0fMWI0=WIf@1@0=WIf@00703IfMT00`000000fMWI0=WIf@0:0=WI\nf@030000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3IfMT0EP3IfMT00`000?l0fMWI0=WIf@0S0=WI\nf@030000o`3IfMT0fMWI0500fMWI000L0=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3I\nfMT08P3IfMT00`000?l0fMWI0=WIf@1F0=WIf@030000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3I\nfMT0D@3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@030000\no`3IfMT0fMWI05L0fMWI00<0003o0=WIf@3IfMT08P3IfMT00`000?l0fMWI0=WIf@1A0=WIf@00703I\nfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0E`3I\nfMT00`000?l0fMWI0=WIf@0R0=WIf@030000o`3IfMT0fMWI0540fMWI00090=WIf@800000103IfMT2\n000000@0fMWI0P0000050=WIf@030000003IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0803IfMT0\n0`000?l0fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI0240fMWI00<0003o0=WIf@3IfMT0DP3IfMT0\n00P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003I\nfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1I0=WIf@030000o`3I\nfMT0fMWI0200fMWI00<0003o0=WIf@3IfMT0DP3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3I\nfMT00`000000fMWI0=WIf@030=WIf@800000303IfMT00`000?l0fMWI0=WIf@0O0=WIf@030000o`3I\nfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1C0=WIf@00203IfMT0\n10000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02`3I\nfMT00`000?l0fMWI0=WIf@0N0=WIf@030000o`3IfMT0fMWI05X0fMWI00<0003o0=WIf@3IfMT07`3I\nfMT00`000?l0fMWI0=WIf@1C0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0N0=WIf@030000\no`3IfMT0fMWI05X0fMWI00<0003o0=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@1C0=WIf@002@3I\nfMT2000000X0fMWI0P0000050=WIf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT07@3I\nfMT00`000?l0fMWI0=WIf@1K0=WIf@030000o`3IfMT0fMWI01h0fMWI00<0003o0=WIf@3IfMT0E03I\nfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0\nfMWI05`0fMWI00<0003o0=WIf@3IfMT07@3IfMT00`000?l0fMWI0=WIf@1D0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI01`0fMWI00<0003o0=WIf@3IfMT0G03IfMT00`00\n0?l0fMWI0=WIf@0M0=WIf@030000o`3IfMT0fMWI05@0fMWI000L0=WIf@030000003IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI0=WIf@1L0=WIf@030000o`3IfMT0fMWI01d0\nfMWI00<0003o0=WIf@3IfMT0E03IfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@0K0=WIf@030000o`3IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0703IfMT00`000?l0fMWI\n0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI01X0fMWI00<0\n003o0=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI05D0fMWI000L\n0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1N\n0=WIf@030000o`3IfMT0fMWI01/0fMWI00<0003o0=WIf@3IfMT0EP3IfMT001`0fMWI00<000000=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI05l0fMWI00<0003o0=WI\nf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@1F0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI01P0fMWI00<0003o0=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@0J0=WIf@03\n0000o`3IfMT0fMWI05H0fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n603IfMT00`000?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI01T0fMWI00<0003o0=WIf@3IfMT0\nE`3IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0G0=WIf@030000o`3I\nfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@1G0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0H@3IfMT0\n0`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0fMWI05P0fMWI000L0=WIf@030000003IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT05P3IfMT00`000?l0fMWI0=WIf@1R0=WIf@030000o`3IfMT0fMWI\n01L0fMWI00<0003o0=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@0E0=WIf@030000o`3IfMT0fMWI06<0fMWI00<0003o0=WIf@3IfMT05`3IfMT00`000?l0\nfMWI0=WIf@1H0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI01D0fMWI\n00<0003o0=WIf@3IfMT0H`3IfMT00`000?l0fMWI0=WIf@0F0=WIf@030000o`3IfMT0fMWI05T0fMWI\n000L0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WI\nf@1T0=WIf@030000o`3IfMT0fMWI01H0fMWI00<0003o0=WIf@3IfMT0F@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI06D0fMWI00<0003o\n0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WIf@0E0=WI\nf@030000o`3IfMT0fMWI05T0fMWI000L0=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@1U0=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT0FP3IfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000\no`3IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@1J0=WIf@00703I\nfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0IP3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI05/0fMWI000L0=WIf@030000003IfMT0\nfMWI0100fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@1W0=WIf@030000o`3IfMT0\nfMWI01<0fMWI00<0003o0=WIf@3IfMT0F`3IfMT001`0fMWI00<000000=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI06P0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00\n0?l0fMWI0=WIf@1K0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT0J@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI05`0\nfMWI000L0=WIf@030000003IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI\n0=WIf@1Y0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0G03IfMT001`0fMWI00<0\n00000=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI06/0fMWI00<0\n003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@1M0=WIf@00703IfMT00`000000fMWI0=WIf@0B\n0=WIf@030000o`3IfMT0fMWI00/0fMWI0P000?m]0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o\n0=WIf@3IfMT0G@3IfMT001`0fMWI00<000000=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0:0=WI\nf@030000o`3IfMT0fMWI06`0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@1N0=WI\nf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3I\nfMT0K@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI05h0fMWI00090=WIf@800000\n103IfMT2000000D0fMWI0`0000030=WIf@030000003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@1^0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\nG`3IfMT000P0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000\n003IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT01`3IfMT20000og00fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@1O0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@D00000\n0`3IfMT2000001H0fMWI00<0003o0=WIf@3IfMT01@3IfMT20000og80fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@1O0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000\n003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT05@3IfMT20000o`D0fMWI0P000?mc0=WIf@03\n0000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0H03IfMT000P0fMWI00@000000=WIf@3IfMT0\n00002@3IfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI01H0fMWI0P000?l30=WIf@80\n003oM@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0600fMWI00090=WIf@800000\n2`3IfMT2000000@0fMWI00<000000=WIf@3IfMT0603IfMT30000ogL0fMWI00<0003o0=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@1Q0=WIf@00703IfMT00`000000fMWI0=WIf@2C0=WIf@030000o`3I\nfMT0fMWI00H0fMWI0P000?mS0=WIf@00703IfMT00`000000fMWI0=WIf@2C0=WIf@030000o`3IfMT0\nfMWI00D0fMWI0P000?mT0=WIf@00703IfMT00`000000fMWI0=WIf@2D0=WIf@030000o`3IfMT0fMWI\n00<0fMWI0P000?mU0=WIf@00703IfMT00`000000fMWI0=WIf@2D0=WIf@80003o0`3IfMT20000ofH0\nfMWI000L0=WIf@030000003IfMT0fMWI09H0fMWI10000?mW0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI02@0\nfMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P0000300=WIf@00903IfMT00`000000fMWI\n0=WIf@0V0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@2n0=WIf@008`3IfMT00`000000fMWI0=WIf@030=WIf@8000000`3IfMT700000080fMWI1000\n00000`3IfMT00000000000030=WIf@8000000P3IfMT3000000030=WIf@000000000000<0fMWI00<0\n00000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WI\nf@2n0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI1000\n00020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@0000002@3IfMT010000000fMWI\n0=WIf@0000040=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@050000003IfMT0fMWI0=WIf@000000`03IfMT001H0fMWI20000?l50=WIf@030000003IfMT0fMWI\n0080fMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0\nfMWI00<000002@3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00<0fMWI00D0\n00000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;h0fMWI000S0=WIf@040000003I\nfMT0fMWI0=WIf@D000000`3IfMT3000000030=WIf@0000000000008000000`3IfMT010000000fMWI\n0000000000080=WIf@<000001@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D0\n00000`3IfMT00`000000fMWI0=WIf@2n0=WIf@00903IfMT01@000000fMWI0=WIf@3IfMT000000140\nfMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00@0\nfMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;h0fMWI000U0=WIf@03\n0000003IfMT0fMWI0140fMWI0P00000:0=WIf@8000001@3IfMT00`000000fMWI0=WIf@050=WIf@80\n0000203IfMT200000<00fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-30.4421`, -0.06751`, 1.08639`, 0.00298853`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Two Tanks Connected Together", "Section"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0005U<0@0006`00003000000000=d1002D0000\n00000000003F:`00T`h00215CDH00040C5T004@2000=0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0002PM000L7@00AdA9@`4008000`00i`alj00000047@00\n0@090003PPh000h08`000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P0000050000309a0e/:70000?/2W?l00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iR\nmGO7H_Eg0@000000<0040000;@4000D000020@40000500002@8000020`0001h01`0001H4L@=K2P00\n000@00009PH?01H0ooooo`00oooooooooomQ2P00LP<000<0000N00D0000^0@00000500002P800000\n1@0000T2000000D000010_ooo`070000o0810000000000@0000]0@4020000?X21@010000000000@0\n000]0@80100000<1200700004PAa0g43F`YP2PD0000;0P0000050000309a0f0:500002H63`0N0?oo\nool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0000<0W43H0XL0000n`8D00T000000;`2000000@2\n0R9CNG=dIFd0Md00003720X4_V;eMlMRmGL10000000`00@0000]0@<01@0000810@0001`0003k0Zgo\n00000000T040000014004UAYKFEc84iUMb1BKfeQKP2nH_Egaf;eM`4000000300100002d110050000\n2@8000021@0000/2000000d0000b2Vh3000100@00000060:L@<PJBD0400002H63`0F0?ooool001h4\n000[0@00UPH005X100080000nP80008000000000100002d11@040000;@4100P0000U0`8080A20F/6\n@P440000;@4200@0003`0@D01`000?`20000000000040000;@4500X0000T0`<0J@IH0I@6@P5Y1Rd1\n20000?X200000000000000@0000]0@H01`000?`2003oool000040000;@4700@0003`0@D0200002H6\n3`060?ooool100@0000]0@40100002d10P0700006`B^0?l6AP0:10@0000]0@L0100002d11P030000\n7P0700005PB/0?l6A@0:10D000020@40000L0000n`:]o`0000000;`2000000A0019DJFeULb1>IGLP\nDVm]HFh0_V;eMlMRmGL10000000`00@0000]0@D08`00038:B00^1100100:14D0oPJ/05AQKV]c@fm^\nKVESM6ETD4Tg02X0;`0]0240?00Z02h0;P0U02D0700U02h0<`0P00d0000b2TP0fPH100@02PA50?h6\n[00P02h0100002L1ool40000;@4100P0003j0P001P00000000840000;@4800L0000K16h3F`XY01<0\n100002d11`040000;@4600@0003`0@P01`000?`2003oool000040000;@4800P0003j0P001P000000\n00840000;@4900L0000K12H37PA90Rh2100002d11`040000l04800@0000]0@H010000?012@040000\n;@4100@0000]0@801`0001/4h@;e0gh2EP840000;@4700@0000]0@H00`0001h01`0001H4g`;d0gh2\nEP8500000P41000070000?/2]Ol00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg\n0@000000<0040000;@4800D000090P00008M0000<PZ00UX2300405H2OP;c0ml2L6U3KfidJFieKgEc\n9P0E03809@0V01D05@0U02H09@0V01d03@00038:P0;_0`40101F0Wh2l`?O0R008@0400009`7oo`L0\n003l0P00oooo0000100002d12@080000nP8000H000000002100002d12P0700006`C>0SX4T@;n0`@0\n000]0@L010000?012@040000;@4600@0003`0@X01`000?`2003oool000040000;@4900P0003j0P00\n1P00000000840000;@4:00L0000K1<h2CP:A0Q42100002d11`040000l04900@0000]0@H010000?01\n2P070000o0800?ooo`0000@0000]0@T020000?X20006000000000P@0000]0@X01`0001/4i`4O10X1\n;P840000;@4700@0003`0@T0100002d11P040000l04:00@0000]0@40100002d10P0700006`B[0HD3\nB0750P@0000]0@L0100002d11P0300007P0700005PBY0HD3B0750PD000020@40000L0000n`:eo`00\n00000901000000A00291LVUQK03eMd00001E2@YE_V;eMlMRmGL10000000`00@0000]0@T01@0000T2\n00000Q<0000b2TT1b08500@0a@980H@3Z@5dHFi[<@4E02X0:P0U02X0100002d1200=0000<PY90H03\n0@040<D2B0640jT1800Q00@0000W0Ooo1`000?`2003oool000040000;@4:00P0003j0P001P000000\n00840000;@4;00L0000K1<X1C`:=0A82100002d11`040000l04:00@0000]0@H010000?012`070000\no0800?ooo`0000@0000]0@X020000?X20006000000000P@0000]0@/01`0001/4H@4i12@1o0<40000\n;@4700@0003`0@X0100002d11P040000l04;00@0000]0@40100002d10P0700006`@@0UH5`04d10@0\n000]0@L0100002d11P0300007P0700005P@>0UH5`04d10D000020@40000L0000n`:mo`0000000901\n000000A00291LVUQK03eMd00002`2@YG_V;eMlMRmGL10000000`00@0000]0@X01@0000T200000QT0\n000b2/41?P@900@0=0C00ED53P9d@F=dMF5dKg804`0/02804`0U02D04`0U01H070000?/2_Ol00000\n002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4;00d0000b2/41\nBPD100@0=0C00ED53P8P01d0100002L1ool40000;@4100@0000]0@801`0001/43P8/0[h1=`440000\n;@4700@0000]0@H00`0001h01`0001H4308/0[h1=`4500000P410000100002d12P0500002@800002\n5P00038:_`4n0@L0100g0Kh1:`8<0WACIFicKg804`0]02D0900R02D05P040000;@4;00d0000b2[l1\n908100@0=`6n0B/2308P01h0100002L1ool70000o0800?ooo`0000@0000]0@`020000?X200060000\n00000P@0000]0@d01`0001/4H@5=0R@14@840000;@4700@0003`0@`0100002d11P040000l04=00L0\n003l0P00oooo0000100002d130080000nP8000H000000002100002d13@0700006`C:0CT4S@7l0`@0\n000]0@L010000?0130040000;@4600@0003`0@d0100002d10@040000;@4200L0000K13D17P;U0901\n100002d11`040000;@4600<0000N00L0000F13<17@;U09011@0000810@0000@0000]0@X01@0000T2\n00000Q00000b2^H0Z04300@0T07U01`2<`5aBFh09@0C02D0100002d12`0=0000<P[V00D20@040901\ni@0L0S<1800N00@0000W0Ooo100002d10@040000;@4200L0000K13D100GU03X4100002d11`040000\n;@4600<0000N00L0000F13<100GU03X41@0000810@0000@0000]0@X01@0000T200000Q40000b2^H0\nE0@400@0>PCU0?l4<`5aCgEd9@0d02D04`040000;@4;00d0000b2^H0i@@100@0>PCU0?l4<`4P01h0\n100002L1ool@00009PH?01H0ooooo`00GP4002/1000D0P00FP4000P0003j0P000P00000000040000\n;@4<00@0000]0@40200002D30P1P0D81j@520@@0000]0@8010000?0130070000o0800000000000@0\n000]0@`02P0002@30`3W0EP14P920NL1;@440000;@4600@0000]0@L010000?01300800009PH?00H0\nooooo`40100002d10@040000;@4200L0000K10<3f0Bd0Sh4100002d11`040000;@4600<0000N00L0\n000F1083e`Bd0Sh41@0000810@0000@0000]0@X01@0000T200000Q40000b2[D2@`@400@0?PBd0]H4\n0P=SCgEd8P0d02D04`040000;@4;00d0000b2[D2d@@100@0?PBd0]H40P<P01d0100002L1ool40000\n;@4100@0000]0@801`0001/410<B0[D2U@440000;@4700@0000]0@H00`0001h01`0001H40`<A0[D2\nU04500000P410000100002d12P0500002@8000024000038:]P:U0@<0102D0KD240830f=9KW@R01<0\n9@040000;@4;00d0000b2[H2o`4100@0U06e0Q020`<P01d0100002L1ool@00009PH?01H0ooooo`00\n;0400:H1000A0P00a`8000P0003j0P000P00000000040000;@4<00@0000]0@40300002D3103V0Jl2\n;P6_0Rh1Z04>0ZP1100002d10P040000l04<00L0003l0P0000000000100002d1300:000090<30>@1\na@8>0[02i06J0P@0000]0@H0100002d11`040000l04<00P0000V1Pl01P3ooooo0@0@00009PH?01H0\nooooo`00<`@009<1001M1@00/@8000P0003j0P000P00000000040000;@4<00@0000]0@40300002D3\n100l1:h2FPF^0UX5ZP5M1:X1100002d10P040000l04<00L0003l0P0000000000100002d1300:0000\n90<30604U@4f1:X1H0C00@@0000]0@H0100002d11`040000l04<00P0000V1Pl01P3ooooo0@070000\no0800?ooo`0000@0000]0@`020000?X20006000000000P@0000]0@d01`0001/49P>S24T2/`H40000\n;@4700@0003`0@`0100002d11P040000l04=00@0000]0@40100002d10P0700006`CQ0WT8OP;K1P@0\n000]0@L0100002d11P0300007P0700005PCO0WT8OP;J1PD000020@4000040000;@4800D000090P00\n008M0000<PZ00]h630040=X6OP9h2=l2L6U3KfidJFieKgEc9P0E03809@0V01D05@0U02H09@0V01d0\n3@00038:P09c2040103J1Wh2N0SO0R008@0400009`7oo`L0003l0P00oooo0000100002d130080000\nnP8000H000000002100002d13@0700006`C>0[l8T@:220@0000]0@L010000?0130040000;@4600@0\n003`0@d01`000?`2003oool000040000;@4<00P0003j0P001P00000000840000;@4=00L0000K1<h2\ndPJA0YH6100002d11`040000l04<00@0000]0@H010000?013@070000o0800?ooo`0000@0000]0@`0\n20000?X20006000000000P@0000]0@d01`0001/4i`6T20X1/`H40000;@4700@0003`0@`0100002d1\n1P040000l04=00@0000]0@40100002d10P0700006`B[0@X8B05:1`@0000]0@L0100002d11P030000\n7P0700005PBY0@X8B05:1`D000020@4000040000;@4900D000090P00008C0000<PY90Dd71@0404X7\nB0492:T1M65^Jc815@0Z02X09@0Z00@0000]0@P03@00038:B@452040101:1dP12@RY0B008@040000\n9`7oo`L0003l0P00oooo0000100002d130080000nP8000H000000002100002d13@0700006`C:0M@6\nS@6G1P@0000]0@L010000?0130040000;@4600@0003`0@d01`000?`2003oool000040000;@4<00P0\n003j0P001P00000000840000;@4=00L0000K1641_PPT0H48100002d11`040000l04<00@0000]0@H0\n10000?013@040000;@4100@0000]0@801`0001/440;K2L01^@P40000;@4700@0000]0@H00`0001h0\n1`0001H43P;K2L01^@P500000P410000100002d12P0500002@8000026@00038:`@7320T0102i2<01\nfPT>0WA1HgAeHGA_LP0C02`08P0C02D09@0C02D05P040000;@4;00d0000b2/41c`T100@0^@S00MX9\n3P8P01d0100002L1ool40000;@4100@0000]0@801`0001/43P:a1[h1_0D40000;@4700@0000]0@H0\n0`0001h01`0001H430:a1[h1_0D500000P410000100002d12P0500002@8000025P00038:_`731@L0\n102l1Kh1/0H<0WACIFicKg804`0]02D0900R02D05P040000;@4;00d0000b2[l1Z@H100@0_0Fn0K06\n308P01h0100002L1ool70000o0800?ooo`0000@0000]0@`020000?X20006000000000P@0000]0@d0\n1`0001/4H@7B1R@1U@H40000;@4700@0003`0@`0100002d11P040000l04=00L0003l0P00oooo0000\n100002d130080000nP8000H000000002100002d13@0700006`C:0Kh8S@6120@0000]0@L010000?01\n30040000;@4600@0003`0@d0100002d10@040000;@4200L0000K13D1X`KU01D6100002d11`040000\n;@4600<0000N00L0000F13<1XPKU01D61@0000810@0000@0000]0@X01@0000T200000Q00000b2^H0\n;@H300@05@KU0:46<`5aBFh09@0C02D0100002d12`0=0000<P[V08X60@0401D6i@2Q1S<1800N00@0\n000W0Ooo100002d10@040000;@4200L0000K13D1Q@WU0;h8100002d11`040000;@4600<0000N00L0\n000F13<1Q0WU0;h81@0000810@0000@0000]0@X01@0000T200000Q40000b2^H0f0P400@0_PSU08<9\n<`5aCgEd9@0d02D04`040000;@4;00d0000b2^H0J@T100@0_PSU08<9<`4P01h0100002L1ool@0000\n9PH?01H0ooooo`00_0P002h1001c2@00G@4000P0003j0P000P00000000040000;@4<00@0000]0@40\n200002D30P2n24D1B0U50@@0000]0@8010000?0130070000o0800000000000@0000]0@`02P0002@3\n0`162E/1L0U60DH9<0440000;@4600@0000]0@L010000?01300800009PH?00H0ooooo`40100002d1\n0@040000;@4200L0000K10<3G0Vd0/<8100002d11`040000;@4600<0000N00L0000F1083G0Vd0/<8\n1@0000810@0000@0000]0@X01@0000T200000Q40000b2[D2b0P400@0``Rd0U/90P=SCgEd8P0d02D0\n4`040000;@4;00d0000b2[D2EPT100@0``Rd0U/90P<P01d0100002L1ool40000;@4100@0000]0@80\n1`0001/410>F1[D26@H40000;@4700@0000]0@H00`0001h01`0001H40`>F1[D26@H500000P410000\n100002d12P0500002@8000024000038:]P8Z1P<0100I1[D2U@H30f=9KW@R01<09@040000;@4;00d0\n000b2[H2Q0H100@06@Je0YD60`<P01d0100002L1ool@00009PH?01H0ooooo`00/@D00:H1002E1P00\na`8000P0003j0P000P00000000040000;@4<00@0000]0@40300002D3101Z1Zl2/`F_0[<5Z06B1ZP1\n100002d10P040000l04<00L0003l0P0000000000100002d1300:000090<306P6a@:B1[02J0JJ0P@0\n000]0@H0100002d11`040000l04<00P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`00^0P009<1\n003R2@00/@8000P0003j0P000P00000000040000;@4<00@0000]0@40300002D310302:h2g`V^0]l9\nZP7R2:X1100002d10P040000l04<00L0003l0P0000000000100002d1300:000090<30>D8U@6j2:X1\ni@S00@@0000]0@H0100002d11`040000l04<00P0000V1Pl01P3ooooo0@040000;@4100@0000]0@80\n1`0001/4DP2A00<00`040000;@4700@0000]0@H00`0001h01`0001H4D02A00800`0500000P410000\n100002d12`0500002@8000023@00038:0P19004010030080T01@02007P0400009`7ooa00000V1Pl0\n5P3ooooo001C0000oP0007@100230@001`000?`2003oool000040000;@4<00P0003j0P001P000000\n00840000;@4=00L0000K18D1E`7n0580100002d11`040000l04<00@0000]0@H010000?013@040000\n;@4100@0000]0@801`0001/4I04k0A@1EP040000;@4700@0000]0@H00`0001h01`0001H4HP4k0A@1\nE`0500000P410000100002d12P0500002@8000025000038:5@5T00H0101G01@1>P5R0G=_MG9SIB80\n9@0U01H08P0U00@0000]0@/03@00038:5@4]0@40101G01@1>P5R0B007@0400009`7oo`L0003l0P00\noooo0000100002d130080000nP8000H000000002100002d13@0700006`AQ0G@19@4h0@@0000]0@L0\n10000?0130040000;@4600@0003`0@d0100002d10`040000l04400@0003`0@D010000?0120040000\nl04900@0003`0@X010000?012`070000o0800?ooo`0000@0000]0@@020000?X200000000000000@0\n000]0@D0100002L1ool800009PH?00H0ooooo`40100002L1oolL0000n`8@00L000000;`200000042\n0R9CNG=dIFd000002P0000@0000000P000010000000`00@0000]0@P00`0000004@0000`000080000\n2`000100003O0@00U@0000T0000@0000g`4009D0000:000040000000000000002@000100001K2P00\nL@<00580001`0@000@0009coool0000000000000002@0@00000000A0019D06T0K@1U07<0801>06D0\nM`0P0580K`1]0640KP000000000000000000000000000000000000000000000000000002000001<0\n4:8I07P14`2n1@00D;KlMaJeo7L]]Oag00000800000H?aT0000C02P<4`0N0000l>dF00Sc4P1h0A<0\nN04C07P14`1h0A<0ooooomCd4P101Q<0:0`C000000000000E@TQEX42000XWGh0N04C07P14`000000\nP_0B00TchGNXDGh0@0HC03Qcl@0HFi41H05M0601G@23l941H05M08;`T@400000MIM303Qcl@20Fi41\n000C07P14`1h0A<0N04C053e4P3S/oag5[GlMbfeo7L00000000000T0000H?aT05?@B04`R6@32`?Ag\n0@0006Af00P000009@0000`0000100004P0000`000010000600000`0000000028@0000P0000N0000\n6000000000000000F`X00743000Q0000200001H0000<0000000007P0000@000000000000000H0000\n30000000000I000030000?ooo`0U0000300000D0080U0000300000P0080O00006000060:001K2P00\nL@<00743000:000040000000000000002@000100001P2P00L@<000T0000@0000H0X00743001B0000\nL0400080000D00002@00000000000000_080000000040P8RD`1i07<0M01U06d00000000000000000\n00000000000000000000000000000000000000000000000000000000T@4001<0N04C07P14`1h0A<0\nD?DB0>>co7LF]Oag;KGlM`00000000002@0001Po6@0Dm180C28I0<;0m7L10000I7H02000001h0A<0\nN04C0?oooooDm180@0HC02P<4`000000000005D98EJ10P00:9en07P14`1h0A<0000008;`4P09<n5g\nZ55n04064`0hLo4065^A0F01G@1P0Ed0Po2A0F01G@22l94142;dMlC`oGl0h?eo0@00000000000000\n000009H60000@000UPH4H040003@la809@0001Po6@09000063lI01Cd4P2<8aT0`/3dM`40001TMP08\n000002D0000<00000P000180000<00000@000580001`0@000`000:goool0000000000000002@0@00\n000000A0019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP000000000000000000000000000000\n00000000000000000000000000000000000009H60000@000UPH4H040003@la809@0001Po6@090000\n63lI01Cd4P2<8aT0`/3dM`40001TMP08000007P14`1h0A<0ooooomCd4P101Q<0:0`C000000000000\nE@TQEX42000XWGh0N04C07P14`000000P_0B00TchGNXDGh0@0HC03Qcl@0HFi41H05M0601G@23l941\nH05M08;`T@4@8_Aga?3mO`3PoGl100000000000000000000UPH00010002F1PAP0@000=3c4P0U0000\n63lI0?Cc4P372000E<3dM`40000I0;01a`P:1FAf00P000009@0000`000030000600000`000000002\n2P00010000000000000005@0001D000000000000003oooooooooo`400021@XM00Df7@000001^0`00\n0@0004`00004000000000000001P2P00L@<00500000P00009@0002H0000L00001000000000020000\n00000000000U0000300000@0000U0000300000D0081G000090000;h0000f0000:04003H000020000\n80A20F/6@P4U0000300000P0080X0000300000@0000W0000600000@00000000000000000000U0000\n300000@0001F0000:00002P1000c0000<04003X000030000J@IH0I@6@P5Y1Rd19P0001`000050000\n0000000000000000000002D0000<00001@0002L0000H00001P000000003oool0000002D0000<0000\n1P0002P0000<0000100002D0000<00001@00P2D0000<00002000P2/0000H00002P@004H0003i1P00\nZ00002D0000<00001P0002D0000<00001@000240000800007P0001P0000:1000A@000?l6002/0000\n4P0000`000010000DP00070100040000[Oooo`000000000000000;`20000000014004U@0J@1]06D0\nL`0P04h0I@1g0200DP1_06d0H@1^00000000000000000000000000000000000000000000000001L0\nl14G000000000000UPH00010002F1PAP0@000=3c4P0U000063lI0?Cc4P0hla8000000>Dhn7L001<0\nN;DN0000000Dla80R0HC0<Sc4P2E:oQg000C00@00000la80@;OlMdP74`01]Ah00`000=Cb4P000000\nW?<B0000n7LH=_Qgooooojcc4P22LnQg000C0000003`4AL0GP@@i?0A5`0PP?Mg1640010Rm7O4l?eo\n0>3mO`400000000000000000002F1P00040009H616810000d?<B0?0am7NF1PARE@TQEYH616800000\n16800>cc4P2@d_AgI7H02000000U0000300000@0001D0000[0000<40000<0000?04001`000010000\nPD:7@05=Qd0^1000B0000100001<0000100000X400150000oPH00:`0001/0000E01Q06h0J`1c04<0\nK`1^06h0I@1S07@0I@1T0500B@0g0000:P0002l0000]00008@0003`0000Z0000;P0002h0000U0000\n9@0001`0000U0000;P0003<0000P0000E00005@0000l0@0030000481000L00000@000852Qd01CHM0\nfPH004P000010000C00000@0000:1000A@000?h6002/0000D0000200000^00008P0000`0003ooooo\n9@0000`0000500209P0001`000070000000000H00000000000000RD0000<00001`0002/0000H0000\n4`0002T0001F2P00J0<002D0000<00001P0002D0000<00001@0002P0000<00001`0002L0000H0000\n1`000000003oool0000002D0000<00001`0002H0000L0000200000000006000000000000008U0000\n300000P0000[0000600002h200190P0060@00203000U0000300000H0000X0000300000L0000U0000\n300000D0000X0000300000P0000U0000300000D0080U0000300000P0080[0000600005H2001n0P00\nk`<00=/2000U0000300000H0000U0000300000D0000Q0000200001h0000H0000EP8007h2003d0`00\ng`800180000<00000@000580001`0@0020000;Goool0000000000000002@0@00000000A0019D06T0\nK@1U07<0801>06D0M`0P0580K`1]0640KP0000000000000000000000000000000000000000000000\n000G010:5`1S07@0I@1T0500B@00@000UPH4HP40003@la80l37dMiH6169E2B5F>?<B0000003U>?Qg\n000C01P45P0000005?<B08P64`38la80UB_hM`004`0400000?<B042go7OX1Q<00@@F010Rm7L@8_Ag\na?3mO`3PoGl0000000000000000=1P00040000d612L10000T?<B0?0am7L=1P@WE@TQEP40000@8_Ag\na?3mO`3PoGl100000000000000000000UPH00010002F1PAU0@000=3c4P3`<OAgUPH4IED98EJF1PAU\n000000AU003/la80T=;dMfAf00P000009@0000`000080000600000`000000002E00009@0001]0000\nK0000;D0001j00000@000852Qd01CHM0FP800802000<0000C00000@0001F0P00OP800?<3003O0P00\nI0000700J@1306l0KP1d06T0KP1e06l0M@1c02H0000E0000<P0002D0000V00005@0001D0000U0000\n9P0002D0000V00007@0005@0001D000000000000003oooooooooo`400021@XM00Df7@>l300200P00\n0@0004`000040000EP8007h2003c0`00g`800500000P00008@000280000<0000ooooobL0000H0000\n1`000000003oool0000002D0000<00001`0002H0000L00002@0000000006000000000000008U0000\n300000T0000[000060000?h3002A0P00=0@00<P2000U0000300000H0000X0000300000L0000U0000\n300000D0000X0000300000T0000W0000600000T000000000oooo0000000U0000300000T0000V0000\n700000L0000000001P000000000000029@0000`000070000:`0001P0000A0P00T@8004P200380P00\n9@0000`000060000:00000`0000900009@0000`000050000:00000`0000700009`0001P000070000\n00000?ooo`0000009@0000`0000700009P0001`000090000000000H00000000000000RD0000<0000\n2@0002/0000H0000;P8000X1000I1000h@4002D0000<00001P0002P0000<00001`0002D0000<0000\n1@0002P0000<00002@0002D0000<00001@00P2D0000<00002000P2/0000H0000a@8004P1001o0`00\nY@4002D0000<00001P0002D0000<00001@000240000800007P0001P000350P00B04008D3002Y0@00\n4P0000`000010000DP00070100090000]Oooo`0000000000000009010000000014008T40LP1Y0640\nK00000000000000000000000000000000000000000000000000000000000000000000000000001H0\n4?0F07D0L`000000UPH00010002F1PAU0@000=3c4P3`<OAgUPH4IED98EHhla8000000>Dhn7L001<0\n60@F0000000Dla80R0HC0<Sc4P2E:oQg000C00@00000la80@;OlMnP64`0111H042;dMa0Rm7O4l?eo\n0>3mO`0000000000000009H60000@000UPH4IP40002@la80l37dMiH616IE2B5F0@00010Rm7O4l?eo\n0>3mO`400000000000000000000=1P00040000d612X10000d?<B0?0am7L=1P@ZE@TQEPd612X00000\n12X00>cc4P2@d_AgI7H02000000U0000300000T0000H000030000000009D0000K0000800000h0000\nX@0004L000010000PD:7@05=Qd380P00B@4000D0001<000010000<D200180@00Q0<00:T1001H0000\nM01Q06h0J`0a00005@0002X0000Z00009@0002X0000U0000300000P0001D0000E000000000000000\nooooooooool10000PD:7@05=Qd200`00B@400040001<000010000<D200180@00Q0<00:T1001@0000\n80000240000R000030000?oooolW0000600000L000000000oooo0000000U0000300000L0000V0000\n700000X0000000001P000000000000029@0000`0000:0000:`0001P0000B0P00S@4004T200340@00\n9@0000`000060000:00000`0000700009@0000`000050000:00000`0000:00009`0001P0000:0000\n00000?ooo`0000009@0000`0000:00009P0001`000070000000000H00000000000000RD0000<0000\n1`0002/0000H0000o0<002@1000c1000F`4002D0000<00001P0002P0000<00002P0002D0000<0000\n1@0002P0000<00001`0002D0000<00001@00P2D0000<00002000P2/0000H0000=0@00<01001A1@00\n2P8002D0000<00001P0002D0000<00001@000240000800007P0001P0000d1000`04005H5000>0P00\n4P0000`000010000DP00070100070000_Oooo`0000000000000009010000000014008T40LP1Y0640\nK00000000000000000000000000000000000000000000000000000000000000000000000000001L0\n@38G0000000000003@H00010000=1P@Z0@000=3c4P3`<OAg3@H4:UD98EHhla8000000>Dhn7L001<0\n60@F0000000Dla80R0HC0<Sc4P2E:oQg000C00@00000la80@;OlMnP64`0111H042;dMa0Rm7O4l?eo\n0>3mO`0000000000000000d60000@0003@H4:`40002@la80l37dM`d612]E2B5F0@00010Rm7O4l?eo\n0>3mO`400000000000000000002F1P00040009H616T10000d?<B0?0am7NF1PAYE@TQEYH616T00000\n16T00>cc4P2@d_AgI7H02000000U0000300000L0000H000030000000009D0000Q0000<<0001<0000\nm00005P000010000PD:7@05=Qd0n1000`@4000T0001<0000100003@400300@00E@D000h2001P0000\nM01106<0M01e0640M01_0780000C0000;0000280000C00009@0002D0000C00009@0001H0001B0000\nL04000X0002moooo0000000000000000T04000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0\nK@1Q06h0000000000000000000000000000000000000000000000000K`1b000000000000002F1P00\n040009H616T10000d?<B0?0am7NF1PAYE@TQESSc4P000000iCShM`004`3`31L0000001Cc4P281Q<0\nb?<B09D[n7LP>OQgooooomSc4P10]oagZ0LC0?P<5`3h31L03R/I0?P<5`00h?eo0000000000000000\n3@H00010000=1P@[0@0000004`3`<OAg3@H4:eD98EH1000002;dM`H00000h?eo0@00000000000000\n000000004`06000000`G0300003@la800@0000T00018la80Q000013d4P2E:oQg63KhMooooomTMP08\n000002D0000<00002P0005@0001D0000m00004`0003e0000F00000400021@XM00Df7@4X500310@00\n0@0004`000040000=0@00<01001E1@003P800500000P00007@000280000<0000ooooobD0000<0000\n1@00P2D0000<00002000P2/0000H0000=`400;h1000V0P00208002D0000<00001P0002D0000<0000\n1@000240000800007P0001P0000g0@00_P4002`2000<0P004P0000`0000100009@0000`000070000\n600000`000000002E00007P0000h0000C0000680001H00000@000852Qd01CHM0?P400;l100070000\nC00000@0000g0@00_P4002/2000<0P00G00007@0D`1U06h0L`1_0780000C0000;@0002D0000T0000\n8P0002D0000F00009@0000`0000:0000E00005@0001S0000C00006<0001H00000@000852Qd01CHM0\n90800;l100010000C00000@0000g0@00_P4002/2000<0P00D0000200000N00008P0000`0003ooooo\n9`0001P0000;000000000?ooo`0000009@0000`0000;00009P0001`0000<0000000000H000000000\n00000RD0000<0000300002/0000H00004@8002@100180P00F`4002D0000<00001P0002P0000<0000\n2`0002D0000<00001@0002P0000<0000300002L0000H000030000000003oool0000002D0000<0000\n300002H0000L00002`0000000006000000000000008U0000300000/0000[000060000?`3002=0@00\n<`@00<@1000U0000300000H0000X0000300000`0000U0000300000D0000X0000300000/0000U0000\n300000D0080U0000300000P0080[000060000901003U0000608002l1000U0000300000H0000U0000\n300000D0000Q0000200001h0000H0000T0400>D0000M0P00<`400180000<00000@0002D0000<0000\n1`0001P0000<000000000U@0001P0000C00002L0001L0000<`0000400021@XM00Df7@:P1003V0000\n0`0004`000040000T0400>D0000L0P00<`4005@0001a04T0KP0002D0000C00009@0002D0000<0000\n2P0005@0001D0000G@0002L0001P0000<`0000400021@XM00Df7@0D2003V00000@0004`000040000\nT0400>D0000L0P00<`400500000P00007P000280000<0000ooooobD0000<00001@00P2D0000<0000\n2000P2/0000H0000>P@00>D0003j1000;`4002D0000<00001P0002D0000<00001@00024000080000\n7P0001P0000j1000i@000005000c0@004P0000`0000100009@0000`000070000600000`000000002\nE00006@0003800009`000>80000c00000@000852Qd01CHM0E0@00>H000040000C00000@0000j1000\ni@000?l4000c0@00E0000740C`1e07@09@0003@0000U00004`0002D0000<00002P0005@0001D0000\nhP0002L0003V0000<`0000400021@XM00Df7@>D4003V00000@0004`000040000>P@00>D0003o1000\n<`400500000P00007P000280000<0000ooooobH0000L00002`0000000002000000000000000U0000\n300000/0000U0000300000D0081G000090000400000f0000F00003H000020000H0520NT1@P4U0000\n300000P0080X0000300000/0000W0000600000/00000000000000000000U0000300000/0001F0000\n:00005P0000c0000H00003X000030000i`5H0A82@P7W0Bd19@0000`0000500009@0000`000060000\n:00000`0000;00009@0000`0000500209@0000`000080020:`0001P0000n1000]0800=84003m0P00\n9@0000`0000600009@0000`0000500008@0000P0000N0000600003h4002d0P00e`@00083000B0000\n30000040000U0000300000L0000H000030000000009D0000I0000<D0001e0000gP00084000010000\nPD:7@05=Qd131000]@8000@0001<0000100003h4002d0P00eP@00083001D0000H`1?07D0M00R0000\n=00002D0000C00009@0000`0000:0000E00005@0003N0000M@000=h0002100000@000852Qd01CHM0\nd@@00;D200010000C00000@0000n1000]0800=H400020`00D0000200000M00008P0000`0003ooooo\n9@0000`0000500209@0000`000080020:`0001P0002E0@00]@8000`2003n0P009@0000`000060000\n9@0000`0000500008@0000P0000N0000600009@1002e0P004@8000<3000B000030000040000U0000\n300000L0000H000030000000009D0000H00004`0001e0000G000084000010000PD:7@05=Qd2U0@00\n]P8000<0001<0000100009@1002e0P00408000<3001D0000H`1906h0000R00004`0002D0000U0000\n300000X0001D0000E00005`0001e0000GP00084000010000PD:7@05=Qd3o0@00]P800040001<0000\n100009@1002e0P00408000<3001@0000800001d0000R000030000?oooolV0000700000/000000000\n0P000000000000009@0000`0000;00009@0000`000050020E`0002`0000f0000B00005l0001d0000\n10000>H1[`8^0Jl2;P6X0@h2Z04U0000300000P0080X0000300000/0000W0000600000/000000000\n00000000000U0000300000/0001F0000:00005L0001a0000G`0007P000030000i0750Ph2/0;T0IX2\n9@0000`0000500009@0000`000060000:00000`0000;00009P0001`0000;00000000008000000000\n000002D0000<00002`0002D0000<00001@00P5L0000/0000``0004P0003g0000M00000@0000l1:h2\nFPF^0UX5ZP5M1:X19@0000`000080020:00000`0000;00009`0001P0000;00000000000000000000\n9@0000`0000;0000EP0002P000320000A@000<X0001<00000`000604U@4f1:X1H0C00BD0000<0000\n1@0002D0000<00001P0002P0000<00002`0002L0000H00002`000000003oool0000002D0000<0000\n2`0002H0000L0000300000000006000000000000008U0000300000`0000[000060000;<600190P00\nW@P00203000U0000300000H0000X0000300000/0000U0000300000D0000X0000300000`0000U0000\n300000D0080U0000300000P0080[000060000=/6001n0P00M0P00=/2000U0000300000H0000U0000\n300000D0000Q0000200001h0000H0000fPH007h2001i2000g`800180000<00000@0002D0000<0000\n200001P0000<000000000U@0002D0000?@4006`000260@00NP0000400021@XM00Df7@=h600200P00\n300004`000040000fPH007h2001h2000g`8006@0001`06T0@`1_06h0M01Y06h0M@1_07D0L`0V0000\n5@000380000U00009P0001D0000E00009@0002H0000U00009P0001d0001D0000E00008H1001/0000\nQP4007X000010000PD:7@05=Qd1c2000P0800040001<000010000=X6001n0P00N0P00=l2001@0000\n80000240000R000030000?oooolW0000600000`000000000oooo0000000U0000300000`0000V0000\n700000/0000000001P000000000000029@0000`0000;0000:`0001P000222000T@800;X800380P00\n9@0000`000060000:00000`0000<00009@0000`000050000:00000`0000;00009`0001P0000;0000\n00000?ooo`0000009@0000`0000;00009P0001`0000<0000000000H00000000000000RD0000<0000\n300002/0000H0000UPH00942003<1P00b08002D0000<00001P0002P0000<00002`0002D0000<0000\n1@0002P0000<0000300002L0000H000030000000003oool0000002D0000<0000300002H0000L0000\n2`0000000006000000000000008U0000300000/0000[000060000;<6000:0@00W`P00>41000U0000\n300000H0000X0000300000`0000U0000300000D0000X0000300000/0000U0000300000D0080U0000\n300000P0080[0000600004X700180@0010P00:D1000U0000300000H0000U0000300000D0000Q0000\n200001h0000H0000BPL004P1000:2000Z@400180000<00000@0002D0000<00002@0001P0000<0000\n00000U@0001/0000D@4003P0001b0@00A`0000400021@XM00Df7@4d700190@001@0004`000040000\nBPL004P100092000Z@4005P0001d0640KP1[0380000E0000:P0002X0000U0000:P0002D0000<0000\n200005@0001D0000LP4003P0001b0@00AP0000400021@XM00Df7@0D800190@000@0004`000040000\nBPL004P100092000Z@400500000P00008@000280000<0000ooooobL0000H00002`000000003oool0\n000002D0000<00002`0002H0000L0000300000000006000000000000008U0000300000`0000[0000\n600009L6002=0@00cPH00<@1000U0000300000H0000X0000300000/0000U0000300000D0000X0000\n300000`0000W0000600000`000000000oooo0000000U0000300000`0000V0000700000/000000000\n1P000000000000029@0000`0000;0000:`0001P00021200090400;T8001K0@009@0000`000060000\n:00000`0000<00009@0000`000050000:00000`0000;00009@0000`0000500209@0000`000080020\n:`0001P0002i2000`0400=D9000:0P009@0000`0000600009@0000`0000500008@0000P0000N0000\n60000;T800300@00f`T000h2000B000030000040000U0000300000L0000H000030000000009D0000\nQ00009@1001<0000a@4005P000010000PD:7@05=Qd332000`@4000T0001<000010000;T800300@00\nfPT000h2001P0000M01106<0M01e0640M01_0780000C0000;0000280000C00009@0002D0000C0000\n9@0001H0000U0000300000X0001D0000E0000<D1001<0000aP4005P000010000PD:7@05=Qd3?2@00\n`@400040001<000010000;T800300@00fPT000h2001@0000800001d0000R000030000?oooolU0000\n300000D0080U0000300000P0080[000060000;`5002n0@00Z`H000P2000U0000300000H0000U0000\n300000D0000Q0000200001h0000H0000_0D00;h1002a1P0030800180000<00000@0002D0000<0000\n1`0001P0000<000000000U@0001h00002@4004`0000c0@00F00000400021@XM00Df7@<<5002o0@00\n1`0004`000040000_0D00;h1002`1P00308005`0001d05<0I@1^07<0K`1b00004`0002d0000U0000\n90000280000U00005P0002D0000<00002P0005@0001D0000=04004`0000d0@00F00000400021@XM0\n0Df7@:T6002o0@000@0004`000040000_0D00;h1002`1P0030800500000P00007P000280000<0000\nooooobL0000H00002`000000003oool0000002D0000<00002`0002H0000L00003000000000060000\n00000000008U0000300000`0000[0000600009D6000T0@00c0H005/1000U0000300000H0000X0000\n300000/0000U0000300000D0000X0000300000`0000W0000600000`000000000oooo0000000U0000\n300000`0000V0000700000/0000000001P000000000000029@0000`0000;0000:`0001P000212000\nS@400;T800340@009@0000`000060000:00000`0000<00009@0000`000050000:00000`0000;0000\n9@0000`0000500209@0000`000080020:`0001P0000E1P00i@0009h6000_0@009@0000`000060000\n9@0000`0000500008@0000P0000N0000600001D6003U0000XPH003<1000B000030000040000U0000\n300000L0000H000030000000009D0000H00001d1000W0000;@4003<000010000PD:7@05=Qd0]1P00\niP0000<0001<0000100001D6003U0000X@H003<1001D0000L@1906h0000U00004`0002D0000U0000\n300000X0001D0000E00002h1000W0000<@4003<000010000PD:7@05=Qd2:1P00iP000040001<0000\n100001D6003U0000X@H003<1001@0000800001h0000R000030000?oooolU0000300000D0080U0000\n300000P0080[000060000;h8003U0000O`T002l1000U0000300000H0000U0000300000D0000Q0000\n200001h0000H0000_PP00>D000242@00<`400180000<00000@0002D0000<00001`0001P0000<0000\n00000U@0001T0000V04002L0002b0@00<`0000400021@XM00Df7@=P8003V0000100004`000040000\n_PP00>D000232@00<`4005@0001a04l0M@1d02D0000d00009@0001<0000U0000300000X0001D0000\nE0000;81000W0000]P4003<000010000PD:7@05=Qd1Y2@00iP000040001<000010000;h8003U0000\nP`T003<1001@0000800001h0000R000030000?oooolV0000700000/0000000000P00000000000000\n9@0000`0000;00009@0000`000050020E`0002@0002D0@00=`000:d1000g00000P000;h8A@582DD1\n9@0000`000080020:00000`0000;00009`0001P0000;000000000000000000009@0000`0000;0000\nEP0002P0002/0@00<`000;@1000k00000`0004H9F`5`2DH1APT`0BD0000<00001@0002D0000<0000\n1P0002P0000<00002`0002D0000<00001@00P2D0000<00002000P2/0000H0000``P00;@2001G2@00\no@8002D0000<00001P0002D0000<00001@000240000800007P0001P000332000]08005`900020`00\n4P0000`0000100009@0000`000070000600000`000000002E00006@0002E0@00M@000:h100210000\n0@000852Qd01CHM0b0P00;D200040000C00000@000332000]08005/900020`00E00006<0C`1e07@0\n8P0003@0000U00004`0002D0000<00002P0005@0001D0000[`4007D0002_0@00P@0000400021@XM0\n0Df7@5H9002e0P000@0004`000040000``P00;@2001K2@000P<00500000P00007@000280000<0000\nooooobD0000<00001@00P2D0000<00002000P2/0000H00006@H00;D2002@1P00oP8002D0000<0000\n1P0002D0000<00001@000240000800007P0001P0000I1P00]@8009H600030`004P0000`000010000\n9@0000`000070000600000`000000002E0000600000M0@00M@0002d1002100000@000852Qd01CHM0\n:PH00;H200030000C00000@0000I1P00]@8009D600030`00E00006<0B@1^00008P0001<0000U0000\n9@0000`0000:0000E00005@0000]0@00M@0002l1002100000@000852Qd01CHM0Q0H00;H200010000\nC00000@0000I1P00]@8009D600030`00D0000200000M00008P0000`0003ooooo9P0001`0000;0000\n0000008000000000000002D0000<00002`0002D0000<00001@00P5L0000/00001`4004P0000_0@00\nM00000@0001Z1Zl2/`F_0[<5Z06B1ZP19@0000`000080020:00000`0000;00009`0001P0000;0000\n00000000000000009@0000`0000;0000EP0002P0000X0@00L@0002l1001h00000`0006P6a@:B1[02\nJ0JJ0RD0000<00001@0002D0000<00001P0002P0000<00002`0002H0000L00002`00000000020000\n00000000000U0000300000/0000U0000300000D0081G0000;00009@100180000b04007@000040000\n`0R^0]l9[P;O2JX1hPRZ0BD0000<00002000P2P0000<00002`0002L0000H00002`00000000000000\n000002D0000<00002`0005H0000X0000T`4004D0002K0@00C00000<0003U29D1^PRZ0ND8`04U0000\n300000D0000U0000300000H0000X0000300000/0000U0000300000D0080U0000300000P0080[0000\n600000<000030000R`0004`0000U0000300000H0000U0000300000D0000Q0000200001h0000H0000\n0`000080002A0000D0000180000<00000@0002D0000<00002P0001P0000<000000000U@0001D0000\n3@000000000B00003@0000400021@XM00Df7@4T0000200000@0004`0000400000`000080002@0000\nD0000500000P00007P000280000<0000ooooobL0000H00002`000000003oool0000002D0000<0000\n2`0002H0000L0000300000000006000000000000008U0000300000`0000[000060000580003n0000\nDP4007l1000U0000300000H0000X0000300000/0000U0000300000D0000X0000300000`0000U0000\n300000D0080U0000300000P0080[0000600005H0000D0@00=@4005h1000U0000300000H0000U0000\n300000D0000Q0000200001h0000H0000E`0001@1000k0@00HP400180000<00000@0002D0000<0000\n1`0001P0000<000000000U@0001`00004P0002l0000f0000>`0000400021@XM00Df7@6@0000E0@00\n1P0004`000040000E`0001@1000j0@00HP4005P0001c06l0M@1b06<0I@0R00009@0002D0000F0000\n8P0002D0000U0000300000X0001D0000E00003H0000_0000>00003/000010000PD:7@05=Qd0]0@00\n5@400040001<0000100005L0000D0@00>P400681001@0000800001d0000R000030000?oooolW0000\n600000`000000000oooo0000000U0000300000`0000V0000700000/0000000001P00000000000002\n9@0000`0000;0000:`0001P0000h0@009@4006h1001K0@009@0000`000060000:00000`0000<0000\n9@0000`000050000:00000`0000;00009@0000`000020000:00000`000030000:00000`000040000\n:00000`000080000:00000`000090000:00000`000070000:00000`0000:00009`0001P0000:0000\n00000?ooo`0000009@0000`0000:00009P0001`0000700000000000000000000000002D0000<0000\n1`000280000<0000ooooob80000<0000oooooe80001`0@002@0001000007000000000000002l0P00\n000000420R9C07T0L`1d06D0K@000000000000000000000000000000000000000000000000000000\n0000000000000000000G0;0R5`1e07<0000000004`06000000`G0300003@la800@0000T00018la80\n>?<B0000003U>?Qg000C01P45P0000005?<B08P64`38la80UB_hM`004`0400000?<B042go7OX1Q<0\n0@@F02045P3DlQ80000009cc4P000?Qg63KhMa0Rm7L@8_Aga?3mO`3PoGl1000000000000000=1P00\n040000d614P10000Z?<B0?0am7L=1PA800000040000=1PA814P00>cc4P2O^OAg00040080002ma_Ag\nE@TQE]cc4P01P000H<KdMeD98EKLla80/83gMfAf00P000009@0000`0000900009@0000`000070020\n9@0000`000000020<00000`0000?00209@0000`0000=0020B`000100000000001@0002P0000<0000\n0@0002P0000<00000P0002P0000<00002P0002P0000<00001`0002P0000<00001@0002P0000<0000\n1P0002P0000<00002@0000h0000D000000000100000D0000\n"], "Text", Rule[GeneratedCell, False], Rule[CellAutoOverwrite, False], Rule[ImageSize, List[474, 148]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[BoxData[StyleBox[RowBox[List["Two", " ", "connected", " ", "tanks", " ", "with", " ", "PI", " ", "controllers", " ", "and", " ", "a", " ", "source", " ", "for", " ", "liquid", " ", "connected", " ", "to", " ", "the", " ", "first", " ", RowBox[List["tank", ".", " "]]]], Rule[FontFamily, "Times New Roman"]]], "NumberedFigure"], Cell[TextData[List["\nThe Modelica model ", StyleBox["TanksConnectedPI", Rule[FontFamily, "Courier"]], " corresponding to Figure 3 appears as follows:"]], "Text"], Cell["model TanksConnectedPI\n  LiquidSource  source(flowLevel = 0.02);\n  Tank          tank1(area = 1);\n  Tank          tank2(area = 1.3);\n  PIcontinuousController piContinuous1(ref = 0.25);\n  PIcontinuousController piContinuous2(ref = 0.4);\n equation\n  connect(source.qOut,tank1.qIn);\n  connect(tank1.tActuator,piContinuous1.cOut);\n  connect(tank1.tSensor,piContinuous1.cIn);\n  connect(tank1.qOut,tank2.qIn);\n  connect(tank2.tActuator,piContinuous2.cOut);\n  connect(tank2.tSensor,piContinuous2.cIn);\nend TanksConnectedPI;", "ModelicaInput"], Cell["\nWe simulate the connected tank system. We clearly see the tank level responses of the first and second tank to the changes in fluid flow from the source, where the response from the first tank of course appears earlier in time than the response of the second tank.", "Text"]], Open]], Cell[CellGroupData[List[Cell["Simulation of TanksConnectedPI", "Section"], Cell["simulate( TanksConnectedPI, stopTime=400 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(TanksConnectedPI\\) : 2004-1-30 15:45:20.3265100 : \\!\\({0.`, 400.`}\\) : 504 data points : 2 events : 42 variables>\\n\\!\\({\\*TagBox[\\(piContinuous1 . cIn . val\\), HoldForm], \\*TagBox[\\(piContinuous1 . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous1 . error\\), HoldForm], \\*TagBox[\\(piContinuous1 . K\\), HoldForm], \\*TagBox[\\(piContinuous1 . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous1 . ref\\), HoldForm], \\*TagBox[\\(piContinuous1 . T\\), HoldForm], \\*TagBox[\\(piContinuous1 . Ts\\), HoldForm], \\*TagBox[\\(piContinuous1 . x\\), HoldForm], \\*TagBox[\\(piContinuous2 . cIn . val\\), HoldForm], \\*TagBox[\\(piContinuous2 . cOut . act\\), HoldForm], \\*TagBox[\\(piContinuous2 . error\\), HoldForm], \\*TagBox[\\(piContinuous2 . K\\), HoldForm], \\*TagBox[\\(piContinuous2 . outCtr\\), HoldForm], \\*TagBox[\\(piContinuous2 . ref\\), HoldForm], \\*TagBox[\\(piContinuous2 . T\\), HoldForm], \\*TagBox[\\(piContinuous2 . Ts\\), HoldForm], \\*TagBox[\\(piContinuous2 . x\\), HoldForm], \\*TagBox[\\(source . flowLevel\\), HoldForm], \\*TagBox[\\(source . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank1 . area\\), HoldForm], \\*TagBox[\\(tank1 . flowGain\\), HoldForm], \\*TagBox[\\(tank1 . h\\), HoldForm], \\*TagBox[\\(tank1 . maxV\\), HoldForm], \\*TagBox[\\(tank1 . minV\\), HoldForm], \\*TagBox[\\(tank1 . qIn . lflow\\), HoldForm], \\*TagBox[\\(tank1 . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank1 . tActuator . act\\), HoldForm], \\*TagBox[\\(tank1 . tSensor . val\\), HoldForm], \\*TagBox[\\(tank2 . area\\), HoldForm], \\*TagBox[\\(tank2 . flowGain\\), HoldForm], \\*TagBox[\\(tank2 . h\\), HoldForm], \\*TagBox[\\(tank2 . maxV\\), HoldForm], \\*TagBox[\\(tank2 . minV\\), HoldForm], \\*TagBox[\\(tank2 . qIn . lflow\\), HoldForm], \\*TagBox[\\(tank2 . qOut . lflow\\), HoldForm], \\*TagBox[\\(tank2 . tActuator . act\\), HoldForm], \\*TagBox[\\(tank2 . tSensor . val\\), HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous1 . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((piContinuous2 . x)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tank1 . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((tank2 . h)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( {tank1.h,tank2.h} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.00238095 0.0147151 0.631254 [\n[.2619 .00222 -9 -9 ]\n[.2619 .00222 9 0 ]\n[.5 .00222 -9 -9 ]\n[.5 .00222 9 0 ]\n[.7381 .00222 -9 -9 ]\n[.7381 .00222 9 0 ]\n[.97619 .00222 -9 -9 ]\n[.97619 .00222 9 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14097 -18 -4.5 ]\n[.01131 .14097 0 4.5 ]\n[.01131 .26722 -18 -4.5 ]\n[.01131 .26722 0 4.5 ]\n[.01131 .39347 -18 -4.5 ]\n[.01131 .39347 0 4.5 ]\n[.01131 .51972 -18 -4.5 ]\n[.01131 .51972 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .01472 m\n.2619 .02097 L\ns\n[(100)] .2619 .00222 0 1 Mshowa\n.5 .01472 m\n.5 .02097 L\ns\n[(200)] .5 .00222 0 1 Mshowa\n.7381 .01472 m\n.7381 .02097 L\ns\n[(300)] .7381 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(400)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.21429 .01472 m\n.21429 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.40476 .01472 m\n.40476 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.59524 .01472 m\n.59524 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.78571 .01472 m\n.78571 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14097 m\n.03006 .14097 L\ns\n[(0.2)] .01131 .14097 1 0 Mshowa\n.02381 .26722 m\n.03006 .26722 L\ns\n[(0.4)] .01131 .26722 1 0 Mshowa\n.02381 .39347 m\n.03006 .39347 L\ns\n[(0.6)] .01131 .39347 1 0 Mshowa\n.02381 .51972 m\n.03006 .51972 L\ns\n[(0.8)] .01131 .51972 1 0 Mshowa\n.125 Mabswid\n.02381 .04628 m\n.02756 .04628 L\ns\n.02381 .07784 m\n.02756 .07784 L\ns\n.02381 .1094 m\n.02756 .1094 L\ns\n.02381 .17253 m\n.02756 .17253 L\ns\n.02381 .20409 m\n.02756 .20409 L\ns\n.02381 .23565 m\n.02756 .23565 L\ns\n.02381 .29878 m\n.02756 .29878 L\ns\n.02381 .33034 m\n.02756 .33034 L\ns\n.02381 .36191 m\n.02756 .36191 L\ns\n.02381 .42503 m\n.02756 .42503 L\ns\n.02381 .45659 m\n.02756 .45659 L\ns\n.02381 .48816 m\n.02756 .48816 L\ns\n.02381 .55128 m\n.02756 .55128 L\ns\n.02381 .58284 m\n.02756 .58284 L\ns\n.02381 .61441 m\n.02756 .61441 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .02482 L\n.02762 .03492 L\n.02952 .04502 L\n.03143 .05512 L\n.03333 .06522 L\n.03524 .07532 L\n.03714 .08542 L\n.03905 .09552 L\n.04095 .10562 L\n.04286 .11572 L\n.04476 .12582 L\n.04667 .13592 L\n.04857 .14602 L\n.05048 .15612 L\n.05238 .16622 L\n.05429 .17632 L\n.05619 .18642 L\n.0581 .19652 L\n.06 .20662 L\n.0619 .21672 L\n.06381 .22682 L\n.06571 .23692 L\n.06762 .24688 L\n.06952 .25636 L\n.07143 .26476 L\n.07333 .27195 L\n.07524 .27798 L\n.07714 .28289 L\n.07905 .28675 L\n.08095 .28961 L\n.08286 .29153 L\n.08476 .29257 L\n.08667 .29279 L\n.08857 .29225 L\n.09048 .29102 L\n.09238 .28915 L\n.09429 .2867 L\n.09619 .28374 L\n.0981 .28032 L\n.1 .2765 L\n.1019 .27234 L\n.10381 .26787 L\n.10571 .26317 L\n.10762 .25826 L\n.10952 .25321 L\n.11143 .24805 L\n.11333 .24282 L\n.11524 .23757 L\n.11714 .23232 L\nMistroke\n.11905 .2271 L\n.12095 .22195 L\n.12286 .2169 L\n.12476 .21196 L\n.12667 .20716 L\n.12857 .20251 L\n.13048 .19804 L\n.13238 .19375 L\n.13429 .18966 L\n.13619 .18579 L\n.1381 .18212 L\n.14 .17869 L\n.1419 .17547 L\n.14381 .17249 L\n.14571 .16974 L\n.14762 .16722 L\n.14952 .16492 L\n.15143 .16285 L\n.15333 .16099 L\n.15524 .15935 L\n.15714 .15792 L\n.15905 .15668 L\n.16095 .15564 L\n.16286 .15478 L\n.16476 .15409 L\n.16667 .15357 L\n.16857 .15321 L\n.17048 .15299 L\n.17238 .15291 L\n.17429 .15296 L\n.17619 .15312 L\n.1781 .15339 L\n.18 .15376 L\n.1819 .15421 L\n.18381 .15474 L\n.18571 .15534 L\n.18762 .156 L\n.18952 .15671 L\n.19143 .15747 L\n.19333 .15826 L\n.19524 .15907 L\n.19714 .15991 L\n.19905 .16075 L\n.20095 .16161 L\n.20286 .16247 L\n.20476 .16332 L\n.20667 .16416 L\n.20857 .165 L\n.21048 .16581 L\n.21238 .1666 L\nMistroke\n.21429 .16737 L\n.21619 .16811 L\n.2181 .16882 L\n.22 .1695 L\n.2219 .17015 L\n.22381 .17076 L\n.22571 .17133 L\n.22762 .17187 L\n.22952 .17237 L\n.23143 .17283 L\n.23333 .17326 L\n.23524 .17364 L\n.23714 .174 L\n.23905 .17431 L\n.24095 .17459 L\n.24286 .17484 L\n.24476 .17505 L\n.24667 .17523 L\n.24857 .17538 L\n.25048 .1755 L\n.25238 .17559 L\n.25429 .17566 L\n.25619 .1757 L\n.2581 .17572 L\n.26 .17572 L\n.2619 .1757 L\n.26381 .17566 L\n.26571 .17561 L\n.26762 .17554 L\n.26952 .17545 L\n.27143 .17536 L\n.27333 .17525 L\n.27524 .17514 L\n.27714 .17502 L\n.27905 .17489 L\n.28095 .17476 L\n.28286 .17463 L\n.28476 .17449 L\n.28667 .17435 L\n.28857 .17421 L\n.29048 .17407 L\n.29238 .17394 L\n.29429 .1738 L\n.29619 .17367 L\n.2981 .17354 L\n.3 .17341 L\n.3019 .17329 L\n.30381 .17317 L\n.30571 .17306 L\n.30762 .17295 L\nMistroke\n.30952 .17285 L\n.31143 .17276 L\n.31333 .17267 L\n.31524 .17259 L\n.31714 .17251 L\n.31905 .17244 L\n.32095 .17237 L\n.32286 .17231 L\n.32476 .17226 L\n.32667 .17221 L\n.32857 .17217 L\n.33048 .17213 L\n.33238 .1721 L\n.33429 .17207 L\n.33619 .17205 L\n.3381 .17204 L\n.34 .17202 L\n.3419 .17202 L\n.34381 .17201 L\n.34571 .17201 L\n.34762 .17201 L\n.34952 .17202 L\n.35143 .17202 L\n.35333 .17203 L\n.35524 .17205 L\n.35714 .17206 L\n.35905 .17208 L\n.36095 .1721 L\n.36286 .17212 L\n.36476 .17214 L\n.36667 .17216 L\n.36857 .17218 L\n.37048 .1722 L\n.37238 .17222 L\n.37429 .17225 L\n.37619 .17227 L\n.3781 .17229 L\n.38 .17231 L\n.38095 .17232 L\n.38095 .17232 L\n.3819 .18223 L\n.38381 .20084 L\n.38571 .21785 L\n.38762 .23328 L\n.38952 .24716 L\n.39143 .25951 L\n.39333 .27039 L\n.39524 .27982 L\n.39714 .28787 L\n.39905 .29459 L\nMistroke\n.40095 .30004 L\n.40286 .30428 L\n.40476 .30739 L\n.40667 .30943 L\n.40857 .31047 L\n.41048 .31058 L\n.41238 .30983 L\n.41429 .30829 L\n.41619 .30604 L\n.4181 .30314 L\n.42 .29965 L\n.4219 .29566 L\n.42381 .29121 L\n.42571 .28638 L\n.42762 .28122 L\n.42952 .27579 L\n.43143 .27014 L\n.43333 .26433 L\n.43524 .2584 L\n.43714 .25239 L\n.43905 .24636 L\n.44095 .24034 L\n.44286 .23437 L\n.44476 .22847 L\n.44667 .22269 L\n.44857 .21704 L\n.45048 .21155 L\n.45238 .20625 L\n.45429 .20114 L\n.45619 .19626 L\n.4581 .1916 L\n.46 .18718 L\n.4619 .18301 L\n.46381 .1791 L\n.46571 .17545 L\n.46762 .17206 L\n.46952 .16893 L\n.47143 .16607 L\n.47333 .16346 L\n.47524 .16111 L\n.47714 .15901 L\n.47905 .15716 L\n.48095 .15554 L\n.48286 .15415 L\n.48476 .15298 L\n.48667 .15202 L\n.48857 .15126 L\n.49048 .15069 L\n.49238 .15029 L\n.49429 .15007 L\nMistroke\n.49619 .15 L\n.4981 .15007 L\n.5 .15027 L\n.5019 .1506 L\n.50381 .15103 L\n.50571 .15157 L\n.50762 .15219 L\n.50952 .15289 L\n.51143 .15365 L\n.51333 .15447 L\n.51524 .15534 L\n.51714 .15625 L\n.51905 .15719 L\n.52095 .15815 L\n.52286 .15913 L\n.52476 .16011 L\n.52667 .16109 L\n.52857 .16207 L\n.53048 .16304 L\n.53238 .16399 L\n.53429 .16492 L\n.53619 .16583 L\n.5381 .1667 L\n.54 .16755 L\n.5419 .16836 L\n.54381 .16914 L\n.54571 .16987 L\n.54762 .17057 L\n.54952 .17122 L\n.55143 .17184 L\n.55333 .1724 L\n.55524 .17293 L\n.55714 .17341 L\n.55905 .17386 L\n.56095 .17425 L\n.56286 .17461 L\n.56476 .17493 L\n.56667 .17521 L\n.56857 .17545 L\n.57048 .17565 L\n.57238 .17582 L\n.57429 .17596 L\n.57619 .17606 L\n.5781 .17614 L\n.58 .17619 L\n.5819 .17621 L\n.58381 .1762 L\n.58571 .17618 L\n.58762 .17613 L\n.58952 .17607 L\nMistroke\n.59143 .17599 L\n.59333 .17589 L\n.59524 .17578 L\n.59714 .17566 L\n.59905 .17553 L\n.60095 .17539 L\n.60286 .17524 L\n.60476 .17509 L\n.60667 .17493 L\n.60857 .17478 L\n.61048 .17462 L\n.61238 .17446 L\n.61429 .1743 L\n.61619 .17414 L\n.6181 .17398 L\n.62 .17383 L\n.6219 .17368 L\n.62381 .17353 L\n.62571 .17339 L\n.62762 .17326 L\n.62952 .17313 L\n.63143 .17301 L\n.63333 .17289 L\n.63524 .17278 L\n.63714 .17268 L\n.63905 .17258 L\n.64095 .17249 L\n.64286 .17241 L\n.64476 .17234 L\n.64667 .17227 L\n.64857 .17221 L\n.65048 .17216 L\n.65238 .17211 L\n.65429 .17207 L\n.65619 .17203 L\n.6581 .172 L\n.66 .17198 L\n.6619 .17196 L\n.66381 .17194 L\n.66571 .17193 L\n.66762 .17193 L\n.66952 .17193 L\n.67143 .17193 L\n.67333 .17194 L\n.67524 .17195 L\n.67714 .17196 L\n.67905 .17197 L\n.68095 .17199 L\n.68286 .17201 L\n.68476 .17203 L\nMistroke\n.68667 .17205 L\n.68857 .17208 L\n.69048 .1721 L\n.69238 .17212 L\n.69429 .17215 L\n.69619 .17217 L\n.6981 .1722 L\n.7 .17223 L\n.7019 .17225 L\n.70381 .17228 L\n.70571 .1723 L\n.70762 .17233 L\n.70952 .17235 L\n.71143 .17237 L\n.71333 .17239 L\n.71524 .17241 L\n.71714 .17243 L\n.71905 .17245 L\n.72095 .17247 L\n.72286 .17249 L\n.72476 .1725 L\n.72667 .17252 L\n.72857 .17253 L\n.73048 .17254 L\n.73238 .17256 L\n.73429 .17257 L\n.73619 .17258 L\n.7381 .17259 L\n.74 .17259 L\n.7419 .1726 L\n.74381 .17261 L\n.74571 .17261 L\n.74762 .17261 L\n.74952 .17262 L\n.75143 .17262 L\n.75333 .17262 L\n.75524 .17262 L\n.75714 .17262 L\n.75905 .17262 L\n.76095 .17262 L\n.76286 .17262 L\n.76476 .17262 L\n.76667 .17262 L\n.76857 .17262 L\n.77048 .17262 L\n.77238 .17261 L\n.77429 .17261 L\n.77619 .17261 L\n.7781 .1726 L\n.78 .1726 L\nMistroke\n.7819 .1726 L\n.78381 .17259 L\n.78571 .17259 L\n.78762 .17258 L\n.78952 .17258 L\n.79143 .17257 L\n.79333 .17257 L\n.79524 .17257 L\n.79714 .17256 L\n.79905 .17256 L\n.80095 .17255 L\n.80286 .17255 L\n.80476 .17255 L\n.80667 .17254 L\n.80857 .17254 L\n.81048 .17254 L\n.81238 .17253 L\n.81429 .17253 L\n.81619 .17253 L\n.8181 .17253 L\n.82 .17253 L\n.8219 .17252 L\n.82381 .17252 L\n.82571 .17252 L\n.82762 .17252 L\n.82952 .17252 L\n.83143 .17252 L\n.83333 .17252 L\n.83524 .17251 L\n.83714 .17251 L\n.83905 .17251 L\n.84095 .17251 L\n.84286 .17251 L\n.84476 .17251 L\n.84667 .17251 L\n.84857 .17251 L\n.85048 .17251 L\n.85238 .17251 L\n.85429 .17251 L\n.85619 .17251 L\n.8581 .17251 L\n.86 .17252 L\n.8619 .17252 L\n.86381 .17252 L\n.86571 .17252 L\n.86762 .17252 L\n.86952 .17252 L\n.87143 .17252 L\n.87333 .17252 L\n.87524 .17252 L\nMistroke\n.87714 .17252 L\n.87905 .17252 L\n.88095 .17252 L\n.88286 .17252 L\n.88476 .17252 L\n.88667 .17252 L\n.88857 .17252 L\n.89048 .17252 L\n.89238 .17253 L\n.89429 .17253 L\n.89619 .17253 L\n.8981 .17253 L\n.9 .17253 L\n.9019 .17253 L\n.90381 .17253 L\n.90571 .17253 L\n.90762 .17253 L\n.90952 .17253 L\n.91143 .17253 L\n.91333 .17253 L\n.91524 .17253 L\n.91714 .17253 L\n.91905 .17253 L\n.92095 .17253 L\n.92286 .17253 L\n.92476 .17253 L\n.92667 .17253 L\n.92857 .17253 L\n.93048 .17253 L\n.93238 .17253 L\n.93429 .17253 L\n.93619 .17253 L\n.9381 .17253 L\n.94 .17253 L\n.9419 .17253 L\n.94381 .17253 L\n.94571 .17253 L\n.94762 .17253 L\n.94952 .17253 L\n.95143 .17253 L\n.95333 .17253 L\n.95524 .17253 L\n.95714 .17253 L\n.95905 .17253 L\n.96095 .17253 L\n.96286 .17253 L\n.96476 .17253 L\n.96667 .17253 L\n.96857 .17253 L\n.97048 .17253 L\nMistroke\n.97238 .17253 L\n.97429 .17253 L\n.97619 .17253 L\nMfstroke\n0 .5 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01482 L\n.06952 .0153 L\n.07143 .01661 L\n.07333 .01884 L\n.07524 .02198 L\n.07714 .02596 L\n.07905 .03077 L\n.08095 .03634 L\n.08286 .04263 L\n.08476 .0496 L\n.08667 .0572 L\n.08857 .06538 L\n.09048 .0741 L\n.09238 .08331 L\n.09429 .09296 L\n.09619 .103 L\n.0981 .1134 L\n.1 .12411 L\n.1019 .13509 L\n.10381 .14629 L\n.10571 .15768 L\n.10762 .16922 L\n.10952 .18088 L\n.11143 .19261 L\n.11333 .2044 L\n.11524 .21622 L\n.11714 .22802 L\nMistroke\n.11905 .2398 L\n.12095 .25153 L\n.12286 .26319 L\n.12476 .27476 L\n.12667 .28623 L\n.12857 .29757 L\n.13048 .30878 L\n.13238 .31985 L\n.13429 .33076 L\n.13619 .34151 L\n.1381 .3521 L\n.14 .36251 L\n.1419 .37275 L\n.14381 .38281 L\n.14571 .3927 L\n.14762 .40241 L\n.14952 .41195 L\n.15143 .42131 L\n.15333 .43051 L\n.15524 .43954 L\n.15714 .44841 L\n.15905 .45713 L\n.16095 .4657 L\n.16286 .47413 L\n.16476 .48243 L\n.16667 .4906 L\n.16857 .49865 L\n.17048 .50658 L\n.17238 .51441 L\n.17429 .52215 L\n.17619 .52979 L\n.1781 .53735 L\n.18 .54484 L\n.1819 .55226 L\n.18381 .55962 L\n.18571 .56693 L\n.18762 .57419 L\n.18952 .58141 L\n.19143 .58859 L\n.19333 .59511 L\n.19524 .59982 L\n.19714 .6025 L\n.19905 .60332 L\n.20095 .60248 L\n.20286 .60012 L\n.20476 .59633 L\n.20667 .59121 L\n.20857 .58486 L\n.21048 .57739 L\n.21238 .56889 L\nMistroke\n.21429 .55948 L\n.21619 .54925 L\n.2181 .5383 L\n.22 .52674 L\n.2219 .51465 L\n.22381 .50212 L\n.22571 .48925 L\n.22762 .47612 L\n.22952 .4628 L\n.23143 .44937 L\n.23333 .4359 L\n.23524 .42246 L\n.23714 .40911 L\n.23905 .39591 L\n.24095 .3829 L\n.24286 .37015 L\n.24476 .35768 L\n.24667 .34556 L\n.24857 .33381 L\n.25048 .32246 L\n.25238 .31155 L\n.25429 .3011 L\n.25619 .29113 L\n.2581 .28166 L\n.26 .2727 L\n.2619 .26427 L\n.26381 .25637 L\n.26571 .24901 L\n.26762 .24219 L\n.26952 .2359 L\n.27143 .23015 L\n.27333 .22492 L\n.27524 .22022 L\n.27714 .21604 L\n.27905 .21235 L\n.28095 .20914 L\n.28286 .20641 L\n.28476 .20413 L\n.28667 .2023 L\n.28857 .20087 L\n.29048 .19986 L\n.29238 .19922 L\n.29429 .19894 L\n.29619 .199 L\n.2981 .19938 L\n.3 .20006 L\n.3019 .20101 L\n.30381 .20222 L\n.30571 .20366 L\n.30762 .20531 L\nMistroke\n.30952 .20716 L\n.31143 .20918 L\n.31333 .21135 L\n.31524 .21365 L\n.31714 .21607 L\n.31905 .21859 L\n.32095 .22118 L\n.32286 .22383 L\n.32476 .22652 L\n.32667 .22925 L\n.32857 .23199 L\n.33048 .23473 L\n.33238 .23746 L\n.33429 .24016 L\n.33619 .24283 L\n.3381 .24545 L\n.34 .24801 L\n.3419 .25051 L\n.34381 .25294 L\n.34571 .25529 L\n.34762 .25755 L\n.34952 .25972 L\n.35143 .2618 L\n.35333 .26377 L\n.35524 .26565 L\n.35714 .26742 L\n.35905 .26907 L\n.36095 .27063 L\n.36286 .27207 L\n.36476 .2734 L\n.36667 .27462 L\n.36857 .27573 L\n.37048 .27674 L\n.37238 .27764 L\n.37429 .27843 L\n.37619 .27913 L\n.3781 .27973 L\n.38 .28023 L\n.38095 .28045 L\n.38095 .28045 L\n.3819 .28079 L\n.38381 .2823 L\n.38571 .28483 L\n.38762 .2883 L\n.38952 .29262 L\n.39143 .29769 L\n.39333 .30343 L\n.39524 .30974 L\n.39714 .3165 L\n.39905 .32362 L\nMistroke\n.40095 .331 L\n.40286 .33853 L\n.40476 .34612 L\n.40667 .35367 L\n.40857 .36112 L\n.41048 .36835 L\n.41238 .37532 L\n.41429 .38193 L\n.41619 .38814 L\n.4181 .39388 L\n.42 .39911 L\n.4219 .40377 L\n.42381 .40785 L\n.42571 .41129 L\n.42762 .41409 L\n.42952 .41622 L\n.43143 .41768 L\n.43333 .41845 L\n.43524 .41854 L\n.43714 .41796 L\n.43905 .41671 L\n.44095 .41482 L\n.44286 .4123 L\n.44476 .40918 L\n.44667 .40548 L\n.44857 .40124 L\n.45048 .3965 L\n.45238 .39129 L\n.45429 .38564 L\n.45619 .37961 L\n.4581 .37323 L\n.46 .36655 L\n.4619 .35961 L\n.46381 .35245 L\n.46571 .34511 L\n.46762 .33765 L\n.46952 .33011 L\n.47143 .32252 L\n.47333 .31492 L\n.47524 .30736 L\n.47714 .29988 L\n.47905 .2925 L\n.48095 .28526 L\n.48286 .27821 L\n.48476 .27135 L\n.48667 .26473 L\n.48857 .25837 L\n.49048 .25229 L\n.49238 .24651 L\n.49429 .24105 L\nMistroke\n.49619 .23592 L\n.4981 .23115 L\n.5 .22673 L\n.5019 .22268 L\n.50381 .219 L\n.50571 .2157 L\n.50762 .21277 L\n.50952 .21022 L\n.51143 .20805 L\n.51333 .20624 L\n.51524 .2048 L\n.51714 .20372 L\n.51905 .20297 L\n.52095 .20257 L\n.52286 .20248 L\n.52476 .2027 L\n.52667 .20322 L\n.52857 .20402 L\n.53048 .20507 L\n.53238 .20637 L\n.53429 .2079 L\n.53619 .20964 L\n.5381 .21158 L\n.54 .21368 L\n.5419 .21594 L\n.54381 .21834 L\n.54571 .22086 L\n.54762 .22347 L\n.54952 .22617 L\n.55143 .22894 L\n.55333 .23176 L\n.55524 .23461 L\n.55714 .23747 L\n.55905 .24034 L\n.56095 .2432 L\n.56286 .24603 L\n.56476 .24882 L\n.56667 .25157 L\n.56857 .25425 L\n.57048 .25686 L\n.57238 .25939 L\n.57429 .26184 L\n.57619 .26418 L\n.5781 .26643 L\n.58 .26856 L\n.5819 .27058 L\n.58381 .27248 L\n.58571 .27426 L\n.58762 .27591 L\n.58952 .27744 L\nMistroke\n.59143 .27884 L\n.59333 .28011 L\n.59524 .28126 L\n.59714 .28228 L\n.59905 .28317 L\n.60095 .28394 L\n.60286 .28459 L\n.60476 .28512 L\n.60667 .28554 L\n.60857 .28585 L\n.61048 .28605 L\n.61238 .28615 L\n.61429 .28615 L\n.61619 .28606 L\n.6181 .28589 L\n.62 .28563 L\n.6219 .2853 L\n.62381 .2849 L\n.62571 .28444 L\n.62762 .28391 L\n.62952 .28334 L\n.63143 .28271 L\n.63333 .28205 L\n.63524 .28135 L\n.63714 .28062 L\n.63905 .27986 L\n.64095 .27908 L\n.64286 .27829 L\n.64476 .27749 L\n.64667 .27668 L\n.64857 .27587 L\n.65048 .27506 L\n.65238 .27425 L\n.65429 .27346 L\n.65619 .27268 L\n.6581 .27192 L\n.66 .27117 L\n.6619 .27045 L\n.66381 .26975 L\n.66571 .26908 L\n.66762 .26843 L\n.66952 .26782 L\n.67143 .26723 L\n.67333 .26668 L\n.67524 .26616 L\n.67714 .26567 L\n.67905 .26522 L\n.68095 .26481 L\n.68286 .26443 L\n.68476 .26408 L\nMistroke\n.68667 .26377 L\n.68857 .2635 L\n.69048 .26326 L\n.69238 .26305 L\n.69429 .26287 L\n.69619 .26273 L\n.6981 .26261 L\n.7 .26253 L\n.7019 .26247 L\n.70381 .26243 L\n.70571 .26242 L\n.70762 .26244 L\n.70952 .26247 L\n.71143 .26253 L\n.71333 .26261 L\n.71524 .2627 L\n.71714 .26282 L\n.71905 .26294 L\n.72095 .26308 L\n.72286 .26323 L\n.72476 .26339 L\n.72667 .26356 L\n.72857 .26373 L\n.73048 .26392 L\n.73238 .2641 L\n.73429 .2643 L\n.73619 .26449 L\n.7381 .26469 L\n.74 .26488 L\n.7419 .26508 L\n.74381 .26527 L\n.74571 .26546 L\n.74762 .26565 L\n.74952 .26584 L\n.75143 .26602 L\n.75333 .2662 L\n.75524 .26637 L\n.75714 .26653 L\n.75905 .26669 L\n.76095 .26684 L\n.76286 .26699 L\n.76476 .26712 L\n.76667 .26725 L\n.76857 .26738 L\n.77048 .2675 L\n.77238 .2676 L\n.77429 .2677 L\n.77619 .26779 L\n.7781 .26788 L\n.78 .26795 L\nMistroke\n.7819 .26802 L\n.78381 .26808 L\n.78571 .26814 L\n.78762 .26818 L\n.78952 .26822 L\n.79143 .26825 L\n.79333 .26828 L\n.79524 .2683 L\n.79714 .26831 L\n.79905 .26832 L\n.80095 .26832 L\n.80286 .26831 L\n.80476 .2683 L\n.80667 .26829 L\n.80857 .26827 L\n.81048 .26825 L\n.81238 .26822 L\n.81429 .26819 L\n.81619 .26816 L\n.8181 .26813 L\n.82 .26809 L\n.8219 .26805 L\n.82381 .26801 L\n.82571 .26797 L\n.82762 .26792 L\n.82952 .26788 L\n.83143 .26784 L\n.83333 .26779 L\n.83524 .26774 L\n.83714 .2677 L\n.83905 .26765 L\n.84095 .26761 L\n.84286 .26757 L\n.84476 .26752 L\n.84667 .26748 L\n.84857 .26744 L\n.85048 .2674 L\n.85238 .26737 L\n.85429 .26733 L\n.85619 .2673 L\n.8581 .26726 L\n.86 .26723 L\n.8619 .2672 L\n.86381 .26717 L\n.86571 .26715 L\n.86762 .26713 L\n.86952 .2671 L\n.87143 .26708 L\n.87333 .26707 L\n.87524 .26705 L\nMistroke\n.87714 .26704 L\n.87905 .26702 L\n.88095 .26701 L\n.88286 .267 L\n.88476 .26699 L\n.88667 .26699 L\n.88857 .26698 L\n.89048 .26698 L\n.89238 .26698 L\n.89429 .26698 L\n.89619 .26698 L\n.8981 .26698 L\n.9 .26698 L\n.9019 .26698 L\n.90381 .26699 L\n.90571 .26699 L\n.90762 .267 L\n.90952 .267 L\n.91143 .26701 L\n.91333 .26702 L\n.91524 .26703 L\n.91714 .26703 L\n.91905 .26704 L\n.92095 .26705 L\n.92286 .26706 L\n.92476 .26707 L\n.92667 .26708 L\n.92857 .26709 L\n.93048 .2671 L\n.93238 .26711 L\n.93429 .26712 L\n.93619 .26713 L\n.9381 .26714 L\n.94 .26715 L\n.9419 .26716 L\n.94381 .26716 L\n.94571 .26717 L\n.94762 .26718 L\n.94952 .26719 L\n.95143 .2672 L\n.95333 .2672 L\n.95524 .26721 L\n.95714 .26722 L\n.95905 .26722 L\n.96095 .26723 L\n.96286 .26724 L\n.96476 .26724 L\n.96667 .26724 L\n.96857 .26725 L\n.97048 .26725 L\nMistroke\n.97238 .26726 L\n.97429 .26726 L\n.97619 .26726 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank2) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(tank1) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(h) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00C@3IfMT500000080fMWI0P0000040=WIf@800000:`3IfMT4000000<0\nfMWI0P0000040=WIf@800000:`3IfMT2000000@0fMWI0P0000040=WIf@800000;@3IfMT300000080\nfMWI0P0000040=WIf@8000005`3IfMT004l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@04\n0000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:03IfMT00`000000fMWI0=WIf@030=WI\nf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT00000:@3IfMT010000000fMWI0=WI\nf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT00000;@3IfMT01000\n0000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0503I\nfMT004l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI\n00<000000=WIf@3IfMT0:@3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080\nfMWI00@000000=WIf@3IfMT00000:`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@00000\n0=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@0X0=WIf@D0000000D0fMWI0000003IfMT0fMWI\n000000020=WIf@040000003IfMT0fMWI000001H0fMWI001?0=WIf@050000003IfMT0fMWI0=WIf@00\n00000P3IfMT010000000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI02X0fMWI00D000000=WI\nf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:P3I\nfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00<000000=WIf@3I\nfMT0:03IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00@00000\n0=WIf@3IfMT000005P3IfMT004l0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00<000000=WIf@3IfMT0:03IfMT010000000fMWI0=WIf@0000020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT00000:@3IfMT010000000fMWI0=WIf@00\n00020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT00000:`3IfMT00`000000\nfMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000005P3IfMT0\n04h0fMWI0P0000040=WIf@800000103IfMT2000002`0fMWI0P0000040=WIf@800000103IfMT20000\n02/0fMWI0P0000040=WIf@800000103IfMT2000002d0fMWI0P0000030=WIf@800000103IfMT20000\n01L0fMWI003o0=WIfB40fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3b0=WIf@8000003@3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0l@3IfMT010000000fMWI0=WIf@00000<0=WIf@005P3IfMT60000\n00`007l0h00000080=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<007l00=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0:0=WIf@D00000303IfMT001`0fMWI\n00<0003o0=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@3U0=WIf@030000003IfMT0fMWI00d0fMWI\n000L0=WIf@030000o`3IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0m@3IfMT001`0fMWI00<0003o\n0=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@3d0=WIf@00703IfMT00`000?l0fMWI0=WIf@0:0=WI\nf@03001o003IfMT0fMWI0?@0fMWI000L0=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3I\nfMT0m03IfMT001`0fMWI00<000000000o`3IfMT02`3IfMT00`00O`00fMWI0=WIf@3c0=WIf@00703I\nfMT00`000000003o0=WIf@0;0=WIf@03001o003IfMT0fMWI0?<0fMWI000L0=WIf@03000000000?l0\nfMWI00/0fMWI00<007l00=WIf@3IfMT0l`3IfMT001`0fMWI00<000000000o`3IfMT0303IfMT00`00\nO`00fMWI0=WIf@3b0=WIf@00703IfMT00`000000003o0=WIf@0<0=WIf@03001o003IfMT0fMWI0?80\nfMWI000L0=WIf@030000003IfMT0003o00`0fMWI00<007l00=WIf@3IfMT0lP3IfMT001`0fMWI00<0\n00000=WIf@000?l0303IfMT00`00O`00fMWI0=WIf@3b0=WIf@00703IfMT00`000000fMWI0000o`0=\n0=WIf@03001o003IfMT0fMWI0?40fMWI000L0=WIf@030000003IfMT0003o00d0fMWI00<007l00=WI\nf@3IfMT0l@3IfMT001`0fMWI00@000000=WIf@3IfMT0003o303IfMT00`00O`00fMWI0=WIf@3a0=WI\nf@00703IfMT010000000fMWI0=WIf@000?l<0=WIf@03001o003IfMT0fMWI0?40fMWI000L0=WIf@04\n0000003IfMT0fMWI0000o`d0fMWI00<007l00=WIf@3IfMT0l03IfMT001`0fMWI00@000000=WIf@3I\nfMT0003o3@3IfMT00`00O`00fMWI0=WIf@3`0=WIf@00703IfMT010000000fMWI0=WIf@000?l=0=WI\nf@03001o003IfMT0fMWI0?00fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0303IfMT00`00\nO`00fMWI0=WIf@3`0=WIf@00703IfMT01@000000fMWI0=WIf@3IfMT0003o00`0fMWI00<007l00=WI\nf@3IfMT0l03IfMT001`0fMWI00D000000=WIf@3IfMT0fMWI0000o`0<0=WIf@03001o003IfMT0fMWI\n0?00fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@000?l0303IfMT00`00O`00fMWI0=WIf@3`0=WI\nf@00703IfMT01@000000fMWI0=WIf@3IfMT0003o00`0fMWI00<007l00=WIf@3IfMT0l03IfMT001`0\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI0>l0\nfMWI000L0=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00O`00fMWI\n0=WIf@3_0=WIf@002@3IfMT2000000@0fMWI0P0000030=WIf@@00000103IfMT00`000000fMWI0=WI\nf@020=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0k`3IfMT000P0fMWI00@00000\n0=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI0080fMWI00<0\n003o0=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@3_0=WIf@00203IfMT010000000fMWI0=WIf@00\n00090=WIf@030000003IfMT0fMWI00@0fMWI0P0000030=WIf@030000o`3IfMT0fMWI00X0fMWI00<0\n07l00=WIf@3IfMT0k`3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WI\nf@030=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WI\nf@3^0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI0>h0fMWI\n00090=WIf@8000002P3IfMT2000000D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@0:0=WIf@03001o003IfMT0fMWI00`0fMWI10000?m90=WIf@L0003oSP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00X0fMWI0`000?l3\n0=WIf@<0003oA@3IfMT00`000?l0fMWI0=WIf@050=WIf@<0003oR`3IfMT001`0fMWI00<000000=WI\nf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT01P3IfMT30000od80fMWI00<0003o0=WIf@3IfMT0203IfMT20000ohX0fMWI000L0=WIf@03\n0000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@070=WIf@03\n0000o`3IfMT0fMWI00X0fMWI0`000?ln0=WIf@030000o`3IfMT0fMWI00/0fMWI0P000?n80=WIf@00\n703IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT0\n1P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@<0003o9P3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000\no`3IfMT0fMWI00h0fMWI0`000?n50=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000o`3I\nfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@D0003o2@3I\nfMTI0000oa@0fMWI00<0003o0=WIf@3IfMT04@3IfMT40000o`X0fMWIFP000?lM0=WIf@00703IfMT0\n0`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT01@3IfMT0\n0`000?l0fMWI0=WIf@0E0=WIf@/0003o5`3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0\nfMWI01D0fMWI30000?mf0=WIf@00703IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI\n00X0fMWI00<007l00=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI\n0140fMWI00<0003o0=WIf@3IfMT0U`3IfMT001`0fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0\nfMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`000?l0\nfMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI09P0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI\n00<0003o0=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI03T0fMWI\n00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@2H0=WIf@00703IfMT00`000000fMWI0=WI\nf@050=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WI\nf@0j0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0V@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@05001o003IfMT0fMWI0=WIf@000?l09P3I\nfMT3001o01@0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@2I0=WIf@00703IfMT0\n0`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00X0fMWI00D007l00=WIf@3IfMT0fMWI0000\no`0U0=WIf@8007l000@0fMWI001o0000O`0007l04P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000\no`3IfMT0fMWI00`0fMWI0`00O`2:0=WIf@00703IfMT00`000000fMWI0=WIf@050=WIf@030000o`3I\nfMT0fMWI00X0fMWI00@007l00=WIf@3IfMT0003o9@3IfMT2001o00@0fMWI0P00O`0A0=WIf@030000\no`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0303IfMT2001o00030=WIf@00O`0007l008T0fMWI\n000L0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT02P3IfMT01000O`00fMWI0=WI\nf@000?lU0=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT03`3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT00`3IfMT2001o08L0fMWI\n000L0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00O`00003o0=WI\nf@0T0=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WI\nf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01@3IfMT2001o08H0fMWI000L\n0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00O`00003o0=WIf@0S\n0=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0<\n0=WIf@030000o`3IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@24\n0=WIf@00703IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00000\no`3IfMT08`3IfMT00`00O`00fMWI0=WIf@080=WIf@8007l03P3IfMT00`000?l0fMWI0=WIf@0<0=WI\nf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@230=WI\nf@00703IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00000o`3I\nfMT08`3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00`0fMWI00<0003o0=WIf@3I\nfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3I\nfMT0PP3IfMT001`0fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o\n003IfMT0fMWI0280fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@0;0=WIf@030000\no`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o\n003IfMT0fMWI0880fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT02@3I\nfMT00`000?l007l00=WIf@0R0=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT02P3I\nfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT02`3I\nfMT00`00O`00fMWI0=WIf@210=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI00T0fMWI00<0003o001o003IfMT08@3IfMT00`00O`00fMWI0=WIf@0=0=WIf@8007l02`3IfMT0\n0`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0303IfMT2\n001o0880fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0?l0fMWI001o000R0=WIf@03001o003IfMT0fMWI00h0fMWI00<007l00=WIf@3IfMT02P3IfMT00`00\n0?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00\nO`00fMWI0=WIf@200=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@00O`008P3IfMT00`00O`00fMWI0=WIf@0>0=WIf@8007l02`3IfMT00`000?l0\nfMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT03P3IfMT00`00O`00\nfMWI0=WIf@1o0=WIf@00703IfMT00`000000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00L0fMWI\n00@0003o0=WIf@3IfMT007l08P3IfMT00`00O`00fMWI0=WIf@0?0=WIf@8007l02P3IfMT00`000?l0\nfMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0403IfMT00`00O`00\nfMWI0=WIf@1n0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00H0fMWI\n00@0003o0=WIf@3IfMT007l08P3IfMT00`00O`00fMWI0=WIf@0@0=WIf@03001o003IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI0100\nfMWI0P00O`1o0=WIf@002@3IfMT2000000@0fMWI0P0000050=WIf@<000000`3IfMT00`000000fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00H0fMWI00@0003o0=WIf@3IfMT007l08@3IfMT00`00O`00\nfMWI0=WIf@0B0=WIf@03001o003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0\nfMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI0140fMWI00<007l00=WIf@3IfMT0O@3IfMT000P0fMWI\n00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT01@3IfMT01@000?l0fMWI0=WIf@3IfMT007l00240fMWI00<007l00=WI\nf@3IfMT04`3IfMT2001o00L0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0:0=WI\nf@03001o003IfMT0fMWI01<0fMWI00<007l00=WIf@3IfMT05@3IfMTB001o05D0fMWI00080=WIf@04\n0000003IfMT0fMWI000000P0fMWI1@0000030=WIf@8000002@3IfMT00`000?l0fMWI0=WIf@050=WI\nf@050000o`3IfMT0fMWI0=WIf@00O`008@3IfMT00`00O`00fMWI0=WIf@0D0=WIf@8007l01`3IfMT0\n0`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT04`3IfMT2\n001o01<0fMWI1000O`0A0=WIfCP007l07@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT0\n10000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@030=WIf@03001o003IfMT0fMWI01h0fMWI00<007l00=WIf@3IfMT05@3I\nfMT2001o00H0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003I\nfMT0fMWI01@0fMWI0P00O`0@0=WIf@<007l0J@3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3I\nfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT00`3I\nfMT00`000?l0fMWI0=WIf@030=WIf@03001o003IfMT0fMWI01d0fMWI00<007l00=WIf@3IfMT05`3I\nfMT3001o00@0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@090=WIf@03001o003I\nfMT0fMWI01H0fMWI0P00O`0=0=WIf@8007l0K03IfMT000T0fMWI0P00000;0=WIf@800000103IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0103IfMT0\n0`00O`00fMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI01T0fMWI1000O`000`3IfMT0003o0=WIf@06\n0=WIf@030000o`3IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0603IfMT2001o00P0fMWI0`00O`1^\n0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WI\nf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI01`0fMWI00<007l00=WI\nf@000?l01`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI01X0fMWI2000O`1a0=WI\nf@00703IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI0080003o1P3IfMT00`00O`00\nfMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI01`0fMWI00@007l00=WIf@3IfMT0003o1@3IfMT00`00\n0?l0fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI09<0fMWI000L0=WIf@030000003IfMT0fMWI00/0\nfMWI0`000?l80=WIf@03001o003IfMT0fMWI01`0fMWI00<007l00=WIf@3IfMT07@3IfMT00`00O`00\nfMWI0000o`050=WIf@030000o`3IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT0T`3IfMT001`0fMWI\n00<000000=WIf@3IfMT05P3IfMT00`00O`00fMWI0=WIf@0K0=WIf@03001o003IfMT0fMWI01h0fMWI\n00<007l00=WIf@000?l01@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI09@0fMWI\n000L0=WIf@030000003IfMT0fMWI01H0fMWI00<007l00=WIf@3IfMT06`3IfMT00`00O`00fMWI0=WI\nf@0N0=WIf@04001o003IfMT0fMWI0000o`<0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`00O`00fMWI\n0=WIf@2D0=WIf@00703IfMT00`000000fMWI0=WIf@0F0=WIf@03001o003IfMT0fMWI01/0fMWI00<0\n07l00=WIf@3IfMT07`3IfMT00`00O`00fMWI0000o`020=WIf@80003o3@3IfMT00`00O`00fMWI0=WI\nf@2D0=WIf@00703IfMT00`000000fMWI0=WIf@0F0=WIf@03001o003IfMT0fMWI01/0fMWI00<007l0\n0=WIf@3IfMT07`3IfMT00`00O`00fMWI0=WIf@030000o`h0fMWI00<007l00=WIf@3IfMT0U03IfMT0\n01`0fMWI00<000000=WIf@3IfMT05P3IfMT00`00O`00fMWI0=WIf@0K0=WIf@03001o003IfMT0fMWI\n01l0fMWI00<007l00=WIf@3IfMT0403IfMT00`00O`00fMWI0=WIf@2E0=WIf@00703IfMT00`000000\nfMWI0=WIf@0G0=WIf@03001o003IfMT0fMWI01T0fMWI00<007l00=WIf@3IfMT08@3IfMT00`00O`00\nfMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI09D0fMWI000L0=WIf@030000003IfMT0fMWI01L0fMWI\n00<007l00=WIf@3IfMT06@3IfMT00`00O`00fMWI0=WIf@0Q0=WIf@03001o003IfMT0fMWI00l0fMWI\n00<007l00=WIf@3IfMT0U@3IfMT001`0fMWI00<000000=WIf@3IfMT05`3IfMT00`00O`00fMWI0=WI\nf@0I0=WIf@03001o003IfMT0fMWI0240fMWI00<007l00=WIf@3IfMT03P3IfMT00`00O`00fMWI0=WI\nf@2F0=WIf@00703IfMT00`000000fMWI0=WIf@0G0=WIf@03001o003IfMT0fMWI01T0fMWI00<007l0\n0=WIf@3IfMT08P3IfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI09H0fMWI000L0=WI\nf@030000003IfMT0fMWI01L0fMWI00<007l00=WIf@3IfMT06@3IfMT00`00O`00fMWI0=WIf@0R0=WI\nf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0UP3IfMT001`0fMWI00<000000=WIf@3I\nfMT0603IfMT00`00O`00fMWI0=WIf@0H0=WIf@03001o003IfMT0fMWI0280fMWI00<007l00=WIf@3I\nfMT03@3IfMT00`00O`00fMWI0=WIf@2F0=WIf@00703IfMT00`000000fMWI0=WIf@0H0=WIf@03001o\n003IfMT0fMWI01L0fMWI00<007l00=WIf@3IfMT08`3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o\n003IfMT0fMWI09L0fMWI000L0=WIf@030000003IfMT0fMWI01P0fMWI00<007l00=WIf@3IfMT05`3I\nfMT00`00O`00fMWI0=WIf@0T0=WIf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT0U`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0603IfMT00`00O`00fMWI0=WIf@0G0=WIf@03001o003IfMT0\nfMWI02@0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@2G0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0H0=WIf@03001o003IfMT0fMWI01L0fMWI00<007l00=WIf@3IfMT0903IfMT00`00\nO`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI09P0fMWI000L0=WIf@030000003IfMT0fMWI01T0\nfMWI00<007l00=WIf@3IfMT05P3IfMT00`00O`00fMWI0=WIf@0T0=WIf@03001o003IfMT0fMWI00X0\nfMWI00<007l00=WIf@3IfMT0V03IfMT001`0fMWI00<000000=WIf@3IfMT06@3IfMT00`00O`00fMWI\n0=WIf@0F0=WIf@03001o003IfMT0fMWI02@0fMWI00<007l00=WIf@3IfMT02P3IfMT00`00O`00fMWI\n0=WIf@2H0=WIf@00703IfMT00`000000fMWI0=WIf@0I0=WIf@03001o003IfMT0fMWI01D0fMWI00<0\n07l00=WIf@3IfMT09P3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI09P0fMWI000L\n0=WIf@030000003IfMT0fMWI01T0fMWI00<007l00=WIf@3IfMT05@3IfMT00`00O`00fMWI0=WIf@0V\n0=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT0V@3IfMT001`0fMWI00<000000=WI\nf@3IfMT06@3IfMT00`00O`00fMWI0=WIf@0E0=WIf@03001o003IfMT0fMWI02H0fMWI00<007l00=WI\nf@3IfMT0203IfMT00`00O`00fMWI0=WIf@2I0=WIf@00703IfMT00`000000fMWI0=WIf@0J0=WIf@03\n001o003IfMT0fMWI01@0fMWI00<007l00=WIf@3IfMT09P3IfMT00`00O`00fMWI0=WIf@080=WIf@03\n001o003IfMT0fMWI09T0fMWI00090=WIf@800000103IfMT2000000<0fMWI0`0000050=WIf@030000\n003IfMT0fMWI01X0fMWI00<007l00=WIf@3IfMT0503IfMT00`00O`00fMWI0=WIf@0W0=WIf@03001o\n003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT0V@3IfMT000P0fMWI00@000000=WIf@3IfMT00000\n203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI01X0fMWI00<007l00=WIf@3I\nfMT0503IfMT00`00O`00fMWI0=WIf@0W0=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3I\nfMT0VP3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WI\nf@8000006`3IfMT00`00O`00fMWI0=WIf@0D0=WIf@03001o003IfMT0fMWI02P0fMWI00<007l00=WI\nf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@2J0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WI\nf@<000001@3IfMT00`000000fMWI0=WIf@0J0=WIf@03001o003IfMT0fMWI01@0fMWI00<007l00=WI\nf@3IfMT0:03IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI09X0fMWI00080=WIf@04\n0000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@0J0=WI\nf@03001o003IfMT0fMWI01@0fMWI00<007l00=WIf@3IfMT0:03IfMT00`00O`00fMWI0=WIf@040=WI\nf@03001o003IfMT0fMWI09/0fMWI00090=WIf@8000002P3IfMT3000000@0fMWI00<000000=WIf@3I\nfMT06P3IfMT00`00O`00fMWI0=WIf@0C0=WIf@03001o003IfMT0fMWI02X0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@2K0=WIf@00703IfMT00`000000fMWI0=WIf@0J0=WIf@03001o\n003IfMT0fMWI01<0fMWI00<007l00=WIf@3IfMT0:P3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o\n003IfMT0fMWI09`0fMWI000L0=WIf@030000003IfMT0fMWI01/0fMWI00<007l00=WIf@3IfMT04P3I\nfMT00`00O`00fMWI0=WIf@0[0=WIf@05001o003IfMT0fMWI0=WIf@00O`00WP3IfMT001`0fMWI00<0\n00000=WIf@3IfMT06`3IfMT00`00O`00fMWI0=WIf@0B0=WIf@03001o003IfMT0fMWI02`0fMWI0`00\nO`2O0=WIf@00703IfMT00`000000fMWI0=WIf@0K0=WIf@03001o003IfMT0fMWI0180fMWI00<007l0\n0=WIf@3IfMT0cP3IfMT001`0fMWI00<000000=WIf@3IfMT06`3IfMT00`00O`00fMWI0=WIf@0B0=WI\nf@03001o003IfMT0fMWI0<h0fMWI000L0=WIf@030000003IfMT0fMWI01`0fMWI00<007l00=WIf@3I\nfMT0403IfMT00`00O`00fMWI0=WIf@3?0=WIf@00703IfMT00`000000fMWI0=WIf@0L0=WIf@03001o\n003IfMT0fMWI0100fMWI00<007l00=WIf@3IfMT0c`3IfMT001`0fMWI00<000000=WIf@3IfMT0703I\nfMT00`00O`00fMWI0=WIf@0@0=WIf@03001o003IfMT0fMWI0<l0fMWI000L0=WIf@030000003IfMT0\nfMWI01`0fMWI00<007l00=WIf@3IfMT0403IfMT00`00O`00fMWI0=WIf@3?0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT0c`3IfMT001`0\nfMWI00<000000=WIf@3IfMT07@3IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI0<l0\nfMWI000L0=WIf@030000003IfMT0fMWI01d0fMWI00<007l00=WIf@3IfMT03`3IfMT00`00O`00fMWI\n0=WIf@3?0=WIf@00703IfMT00`000000fMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI00h0fMWI00<0\n07l00=WIf@3IfMT0d03IfMT001`0fMWI00<000000=WIf@3IfMT07@3IfMT00`00O`00fMWI0=WIf@0>\n0=WIf@03001o003IfMT0fMWI0=00fMWI000L0=WIf@030000003IfMT0fMWI01h0fMWI00<007l00=WI\nf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@3@0=WIf@00703IfMT00`000000fMWI0=WIf@0N0=WIf@03\n001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0d03IfMT001`0fMWI00<000000=WIf@3IfMT0\n7P3IfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI0=00fMWI000L0=WIf@030000003I\nfMT0fMWI01h0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@3@0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0O0=WIf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT0d@3IfMT0\n01`0fMWI00<000000=WIf@3IfMT07`3IfMT00`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI\n0=40fMWI000L0=WIf@030000003IfMT0fMWI01l0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00\nfMWI0=WIf@3A0=WIf@00703IfMT00`000000fMWI0=WIf@0O0=WIf@03001o003IfMT0fMWI00/0fMWI\n00<007l00=WIf@3IfMT0d@3IfMT001`0fMWI00<000000=WIf@3IfMT0803IfMT00`00O`00fMWI0=WI\nf@0:0=WIf@03001o003IfMT0fMWI0=40fMWI000L0=WIf@030000003IfMT0fMWI0200fMWI00<007l0\n0=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@3A0=WIf@00703IfMT00`000000fMWI0=WIf@0P0=WI\nf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0d@3IfMT000T0fMWI0P0000040=WIf@80\n0000103IfMT2000000D0fMWI00<000000=WIf@3IfMT0803IfMT00`00O`00fMWI0=WIf@090=WIf@03\n001o003IfMT0fMWI0=80fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3I\nfMT00000103IfMT00`000000fMWI0=WIf@0P0=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WI\nf@3IfMT0dP3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@000004\n0=WIf@8000008P3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI0=80fMWI00080=WI\nf@040000003IfMT0fMWI000000T0fMWI0P0000050=WIf@030000003IfMT0fMWI0240fMWI00<007l0\n0=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@3B0=WIf@00203IfMT010000000fMWI0=WIf@000008\n0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT08@3IfMT00`00O`00fMWI0=WI\nf@080=WIf@03001o003IfMT0fMWI0=80fMWI00090=WIf@8000002P3IfMT2000000D0fMWI00<00000\n0=WIf@3IfMT08@3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI0=<0fMWI000L0=WI\nf@030000003IfMT0fMWI0280fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@3C0=WI\nf@00703IfMT00`000000fMWI0=WIf@0R0=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3I\nfMT0d`3IfMT001`0fMWI00<000000=WIf@3IfMT08P3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o\n003IfMT0fMWI0=<0fMWI000L0=WIf@030000003IfMT0fMWI0280fMWI00<007l00=WIf@3IfMT01P3I\nfMT00`00O`00fMWI0=WIf@3C0=WIf@00703IfMT00`000000fMWI0=WIf@0S0=WIf@03001o003IfMT0\nfMWI00D0fMWI00<007l00=WIf@3IfMT0d`3IfMT001`0fMWI00<000000=WIf@3IfMT08`3IfMT00`00\nO`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI0=<0fMWI000L0=WIf@030000003IfMT0fMWI02<0\nfMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@3C0=WIf@00703IfMT00`000000fMWI\n0=WIf@0T0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0e03IfMT001`0fMWI00<0\n00000=WIf@3IfMT0903IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI0=@0fMWI000L\n0=WIf@030000003IfMT0fMWI02@0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@3D\n0=WIf@00703IfMT00`000000fMWI0=WIf@0T0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WI\nf@3IfMT0e03IfMT001`0fMWI00<000000=WIf@3IfMT09@3IfMT01@00O`00fMWI0=WIf@3IfMT007l0\n0=L0fMWI000L0=WIf@030000003IfMT0fMWI02D0fMWI00D007l00=WIf@3IfMT0fMWI001o003G0=WI\nf@00703IfMT00`000000fMWI0=WIf@0U0=WIf@05001o003IfMT0fMWI0=WIf@00O`00e`3IfMT001`0\nfMWI00<000000=WIf@3IfMT09@3IfMT01000O`00fMWI0=WIf@00O`3H0=WIf@00703IfMT00`000000\nfMWI0=WIf@0V0=WIf@03001o003IfMT007l00=P0fMWI000L0=WIf@030000003IfMT0fMWI02H0fMWI\n0P00O`3I0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0\nfMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000\nfMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI02X0fMWI00<000000=WIf@3IfMT0\n1@3IfMT2000000P0fMWI0P00002j0=WIf@00903IfMT00`000000fMWI0=WIf@0/0=WIf@030000003I\nfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@2h0=WIf@008`3IfMT0\n0`000000fMWI0=WIf@030=WIf@8000000`3IfMT700000080fMWI100000000`3IfMT0000000000002\n0=WIf@@000000`3IfMT200000080fMWI0`0000000`3IfMT00000000000030=WIf@030000003IfMT0\nfMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0^03IfMT0\n02<0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@0000020=WIf@@000000P3IfMT0\n10000000fMWI0=WIf@0000020=WIf@030000003IfMT0000000<0fMWI00<000000=WIf@3IfMT02@3I\nfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000^P3IfMT001H0fMWI2000O`050=WIf@03\n0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT01P3IfMT010000000fMWI0=WIf@0000020=WI\nf@030000003IfMT0fMWI00<00000103IfMT00`000000fMWI0=WIf@080=WIf@040000003IfMT0fMWI\n000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<0\n00000=WIf@3IfMT0^03IfMT002<0fMWI00@000000=WIf@3IfMT0fMWI1@0000030=WIf@<0000000<0\nfMWI0000000000000P0000030=WIf@040000003IfMT00000000000@0fMWI00<000000=WIf@3IfMT0\n1`3IfMT3000000D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI\n00<000000=WIf@3IfMT0^03IfMT002@0fMWI00D000000=WIf@3IfMT0fMWI0000000A0=WIf@030000\n003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@040=WIf@03\n0000003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI\n0;P0fMWI000U0=WIf@030000003IfMT0fMWI0140fMWI0P0000060=WIf@800000203IfMT2000000D0\nfMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00002j0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@009@3I\nfMT00`000000fMWI0=WIf@0Z0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000^P3I\nfMT002@0fMWI00<000000=WIf@3IfMT0;03IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0\nfMWI00P0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00<000000=WIf@3IfMT00`3IfMT20000\n00<0fMWI1`0000020=WIf@@0000000<0fMWI0000000000000P3IfMT500000080fMWI0P0000020=WI\nf@<0000000<0fMWI0000000000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI\n0080fMWI0P0000040=WIf@030000003IfMT0fMWI0;P0fMWI000F0=WIf@P0003o1@3IfMT00`000000\nfMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI100000020=WIf@040000003IfMT0fMWI\n00000080fMWI00<000000=WIf@0000001@3IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0\nfMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00D000000=WIf@3IfMT0fMWI0000002j0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@030000\n003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@03000000D0\nfMWI00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI\n00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WI\nf@040000003IfMT0fMWI0=WIf@D000000`3IfMT3000000030=WIf@0000000000008000000`3IfMT0\n10000000fMWI0000000000040=WIf@030000003IfMT0fMWI00L0fMWI0`0000050=WIf@030000003I\nfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0;P0fMWI000T\n0=WIf@050000003IfMT0fMWI0=WIf@0000004@3IfMT00`000000fMWI0=WIf@050=WIf@030000003I\nfMT0fMWI00L0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@040=WIf@050000003I\nfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2h0=WIf@009@3IfMT00`000000fMWI0=WI\nf@0A0=WIf@8000001P3IfMT2000000P0fMWI0P0000050=WIf@030000003IfMT0fMWI00D0fMWI0P00\n00080=WIf@800000^P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-48.7073`, -0.148102`, 1.73822`, 0.00655617`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[890, 920]], Rule[WindowMargins, List[List[49, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]