List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Fields and Variables", "Title"], Cell[TextData[List["\nIn the class ", StyleBox["CelestialBody", Rule[FontFamily, "Courier"]], " ", StyleBox["radius, name", Rule[FontFamily, "Courier"]], " and ", StyleBox["mass", Rule[FontFamily, "Courier"]], " are examples of fields. Every object of the type ", StyleBox["CelestialBody", Rule[FontFamily, "Courier"]], " has its own instances of these fields. Changing the mass field in one object will not affect the mass in another object.\n"]], "Text"], Cell["class CelestialBody\n  constant Real g = 6.672e-11;\n  parameter Real radius;\n  parameter String name;\n  Real mass;\nend CelestialBody;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Duplicate Field Names", "Section"], Cell["Duplicate field names is not allowed in class declarations. The name of a declared element must be different from the names of all other declared elements in the class.\n", "Text"], Cell[TextData[List["class IllegalDuplicate\n  parameter Real duplicate = 4.0;\n", StyleBox["  parameter Integer duplicate = 6;\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// Error! Illegal duplicate field name.", StyleBox["\n", Rule[FontColor, RGBColor[1, 0, 0]]], "end IllegalDuplicate;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of IllegalDuplicate", "Section"], Cell[TextData[List["As we can see when simulating ", StyleBox["IllegalDuplicate", Rule[FontFamily, "Courier"]], ", the class generates an error for trying to redefine the field ", StyleBox["duplicate", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["checkModel( IllegalDuplicate );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"- savelog\\\\n- openModel(\\\\\\\"model.mo\\\\\\\")\\\\nIllegalDuplicate\\\\nError: local redefinition of duplicate\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 3\\\\nLocation of previous declaration:\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 2\\\\nERROR: 1 error was found\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]], Cell[CellGroupData[List[Cell["Identical Field Names and Type Names", "Section"], Cell[CellGroupData[List[Cell["Voltage", "Subsection"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["IllegalTypeAsField", "Subsection"], Cell["It is not allowed to have the same name of a field and its type specifier.", "Text"], Cell[TextData[List["class IllegalTypeAsField\n", StyleBox["  Voltage Voltage;\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// Error! ", StyleBox["\n", Rule[FontColor, RGBColor[1, 0, 0]]], StyleBox["  Voltage voltage;\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Legal, Voltage and voltage are two different names", StyleBox["\n", Rule[FontColor, RGBColor[0, 0, 1]]], "end IllegalTypeAsField;"]], "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Simulation of IllegalTypeAsField", "Section"], Cell["As we can see when simulating IllegalTypeAsField we get a warning for trying to name our variable Voltage, which is the same as the type name.", "Text"], Cell["checkModel( IllegalTypeAsField );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"- savelog\\\\n- openModel(\\\\\\\"model.mo\\\\\\\")\\\\nIllegalTypeAsField\\\\nWarning: component Voltage has the same name as its type\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 2\\\\nIllegalDuplicate\\\\nError: local redefinition of duplicate\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 8\\\\nLocation of previous declaration:\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 7\\\\nERROR: 1 error was found\\\\nWARNING: 1 warning was issued\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[813, 868]], Rule[WindowMargins, List[List[86, Automatic], List[Automatic, 35]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]