/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.BasicStroke;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import ptolemy.plot.EPSGraphics;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class Plot
extends PlotBox {
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected int _marks;
    private int _pointsPersistence = 0;
    private double _xPersistence = 0.0;
    private boolean _bars = false;
    private double barWidth = 0.5;
    private double _barOffset = 0.05;
    private boolean _connected = true;
    private boolean _impulses = false;
    private int _maxDataset = -1;
    private boolean _reuseDatasets = false;
    private boolean _firstInSet = true;
    private boolean _sawFirstDataSet = false;
    private int _radius = 3;
    private int _diameter = 6;
    private Vector _prevx = new Vector();
    private Vector _prevy = new Vector();
    private static final int _ERRORBAR_LEG_LENGTH = 5;
    private static final int _MAX_MARKS = 10;
    private static final BasicStroke _lineStroke1 = new BasicStroke(1.0f, 0, 1);
    private static final BasicStroke _lineStroke2 = new BasicStroke(2.0f, 0, 1);
    private boolean _xyInvalid = true;
    private boolean _showing = false;
    private Vector _formats = new Vector();

    public synchronized void addLegend(int dataset, String legend) {
        this._checkDatasetIndex(dataset);
        if (!this._reuseDatasets) {
            super.addLegend(dataset, legend);
        } else {
            String possibleLegend = this.getLegend(dataset);
            if (possibleLegend == null || possibleLegend != null && !possibleLegend.equals(legend)) {
                super.addLegend(dataset, legend);
            }
        }
    }

    public synchronized void addPoint(final int dataset, final double x, final double y, final boolean connected) {
        Runnable doAddPoint = new Runnable(){

            public void run() {
                Plot.this._addPoint(dataset, x, y, 0.0, 0.0, connected, false);
            }
        };
        this.deferIfNecessary(doAddPoint);
    }

    public synchronized void addPointWithErrorBars(final int dataset, final double x, final double y, final double yLowEB, final double yHighEB, final boolean connected) {
        Runnable doAddPoint = new Runnable(){

            public void run() {
                Plot.this._addPoint(dataset, x, y, yLowEB, yHighEB, connected, true);
            }
        };
        this.deferIfNecessary(doAddPoint);
    }

    public synchronized void clear(final boolean format) {
        Runnable doClear = new Runnable(){

            public void run() {
                Plot.this._clear(format);
            }
        };
        this.deferIfNecessary(doClear);
    }

    public synchronized void clear(final int dataset) {
        Runnable doClear = new Runnable(){

            public void run() {
                Plot.this._clear(dataset);
            }
        };
        this.deferIfNecessary(doClear);
    }

    public synchronized void erasePoint(final int dataset, final int index) {
        Runnable doErasePoint = new Runnable(){

            public void run() {
                Plot.this._erasePoint(dataset, index);
            }
        };
        this.deferIfNecessary(doErasePoint);
    }

    public synchronized void fillPlot() {
        Runnable doFill = new Runnable(){

            public void run() {
                Plot.this._fillPlot();
            }
        };
        this.deferIfNecessary(doFill);
    }

    public boolean getConnected() {
        return this._connected;
    }

    public boolean getImpulses() {
        return this._impulses;
    }

    public synchronized String getMarksStyle() {
        if (this._marks == 0) {
            return "none";
        }
        if (this._marks == 1) {
            return "points";
        }
        if (this._marks == 2) {
            return "dots";
        }
        if (this._marks == 3) {
            return "various";
        }
        return "pixels";
    }

    public int getMaxDataSets() {
        return Integer.MAX_VALUE;
    }

    public synchronized int getNumDataSets() {
        return this._points.size();
    }

    public boolean getReuseDatasets() {
        return this._reuseDatasets;
    }

    public void parseFile(String filespec, URL documentBase) {
        this._firstInSet = true;
        this._sawFirstDataSet = false;
        super.parseFile(filespec, documentBase);
    }

    public synchronized void read(InputStream inputStream) throws IOException {
        super.read(inputStream);
        this._firstInSet = true;
        this._sawFirstDataSet = false;
    }

    public synchronized void samplePlot() {
        Runnable sample = new Runnable(){

            public void run() {
                Plot plot = Plot.this;
                synchronized (plot) {
                    Plot.this.clear(true);
                    Plot.this.setTitle("Sample plot");
                    Plot.this.setYRange(-4.0, 4.0);
                    Plot.this.setXRange(0.0, 100.0);
                    Plot.this.setXLabel("time");
                    Plot.this.setYLabel("value");
                    Plot.this.addYTick("-PI", -Math.PI);
                    Plot.this.addYTick("-PI/2", -1.5707963267948966);
                    Plot.this.addYTick("0", 0.0);
                    Plot.this.addYTick("PI/2", 1.5707963267948966);
                    Plot.this.addYTick("PI", Math.PI);
                    Plot.this.setMarksStyle("none");
                    Plot.this.setImpulses(true);
                    boolean first = true;
                    int i = 0;
                    while (i <= 100) {
                        double xvalue = i;
                        Plot.this.addPoint(0, xvalue, 5.0 * Math.cos(Math.PI * (double)i / 20.0), !first);
                        Plot.this.addPoint(1, xvalue, 4.5 * Math.cos(Math.PI * (double)i / 25.0), !first);
                        Plot.this.addPoint(2, xvalue, 4.0 * Math.cos(Math.PI * (double)i / 30.0), !first);
                        Plot.this.addPoint(3, xvalue, 3.5 * Math.cos(Math.PI * (double)i / 35.0), !first);
                        Plot.this.addPoint(4, xvalue, 3.0 * Math.cos(Math.PI * (double)i / 40.0), !first);
                        Plot.this.addPoint(5, xvalue, 2.5 * Math.cos(Math.PI * (double)i / 45.0), !first);
                        Plot.this.addPoint(6, xvalue, 2.0 * Math.cos(Math.PI * (double)i / 50.0), !first);
                        Plot.this.addPoint(7, xvalue, 1.5 * Math.cos(Math.PI * (double)i / 55.0), !first);
                        Plot.this.addPoint(8, xvalue, 1.0 * Math.cos(Math.PI * (double)i / 60.0), !first);
                        Plot.this.addPoint(9, xvalue, 0.5 * Math.cos(Math.PI * (double)i / 65.0), !first);
                        first = false;
                        ++i;
                    }
                }
                Plot.this.repaint();
            }
        };
        this.deferIfNecessary(sample);
    }

    public void setBars(boolean on) {
        this._plotImage = null;
        this._bars = on;
    }

    public synchronized void setBars(double width, double offset) {
        this._plotImage = null;
        this.barWidth = width;
        this._barOffset = offset;
        this._bars = true;
    }

    public void setConnected(boolean on) {
        this._plotImage = null;
        this._connected = on;
    }

    public synchronized void setConnected(boolean on, int dataset) {
        this._plotImage = null;
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        fmt.connected = on;
        fmt.connectedUseDefault = false;
    }

    public synchronized void setImpulses(boolean on) {
        this._plotImage = null;
        this._impulses = on;
    }

    public synchronized void setImpulses(boolean on, int dataset) {
        this._plotImage = null;
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        fmt.impulses = on;
        fmt.impulsesUseDefault = false;
    }

    public synchronized void setMarksStyle(String style) {
        this._plotImage = null;
        if (style.equalsIgnoreCase("none")) {
            this._marks = 0;
        } else if (style.equalsIgnoreCase("points")) {
            this._marks = 1;
        } else if (style.equalsIgnoreCase("dots")) {
            this._marks = 2;
        } else if (style.equalsIgnoreCase("various")) {
            this._marks = 3;
        } else if (style.equalsIgnoreCase("pixels")) {
            this._marks = 4;
        }
    }

    public synchronized void setMarksStyle(String style, int dataset) {
        this._plotImage = null;
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (style.equalsIgnoreCase("none")) {
            fmt.marks = 0;
        } else if (style.equalsIgnoreCase("points")) {
            fmt.marks = 1;
        } else if (style.equalsIgnoreCase("dots")) {
            fmt.marks = 2;
        } else if (style.equalsIgnoreCase("various")) {
            fmt.marks = 3;
        } else if (style.equalsIgnoreCase("pixels")) {
            fmt.marks = 4;
        }
        fmt.marksUseDefault = false;
    }

    public void setNumSets(int numSets) {
        this._plotImage = null;
        if (numSets < 1) {
            throw new IllegalArgumentException("Number of data sets (" + numSets + ") must be greater than 0.");
        }
        this._currentdataset = -1;
        this._points.removeAllElements();
        this._formats.removeAllElements();
        this._prevx.removeAllElements();
        this._prevy.removeAllElements();
        int i = 0;
        while (i < numSets) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
            ++i;
        }
    }

    public void setPointsPersistence(int persistence) {
        this._plotImage = null;
        this._pointsPersistence = persistence;
    }

    public void setReuseDatasets(boolean on) {
        this._plotImage = null;
        this._reuseDatasets = on;
    }

    public void setXPersistence(double persistence) {
        this._plotImage = null;
        this._xPersistence = persistence;
    }

    public synchronized void writeData(PrintWriter output) {
        super.writeData(output);
        int dataset = 0;
        while (dataset < this._points.size()) {
            String legend;
            StringBuffer options = new StringBuffer();
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (!fmt.connectedUseDefault) {
                if (this._isConnected(dataset)) {
                    options.append(" connected=\"yes\"");
                } else {
                    options.append(" connected=\"no\"");
                }
            }
            if (!fmt.impulsesUseDefault) {
                if (fmt.impulses) {
                    options.append(" stems=\"yes\"");
                } else {
                    output.println(" stems=\"no\"");
                }
            }
            if (!fmt.marksUseDefault) {
                switch (fmt.marks) {
                    case 0: {
                        options.append(" marks=\"none\"");
                        break;
                    }
                    case 1: {
                        options.append(" marks=\"points\"");
                        break;
                    }
                    case 2: {
                        options.append(" marks=\"dots\"");
                        break;
                    }
                    case 3: {
                        options.append(" marks=\"various\"");
                        break;
                    }
                    case 4: {
                        options.append(" marks=\"pixels\"");
                    }
                }
            }
            if ((legend = this.getLegend(dataset)) != null) {
                options.append(" name=\"" + this.getLegend(dataset) + "\"");
            }
            output.println("<dataset" + options.toString() + ">");
            Vector pts = (Vector)this._points.elementAt(dataset);
            int pointnum = 0;
            while (pointnum < pts.size()) {
                PlotPoint pt = (PlotPoint)pts.elementAt(pointnum);
                if (!pt.connected) {
                    output.print("<m ");
                } else {
                    output.print("<p ");
                }
                output.print("x=\"" + pt.x + "\" y=\"" + pt.y + "\"");
                if (pt.errorBar) {
                    output.print(" lowErrorBar=\"" + pt.yLowEB + "\" highErrorBar=\"" + pt.yHighEB + "\"");
                }
                output.println("/>");
                ++pointnum;
            }
            output.println("</dataset>");
            ++dataset;
        }
    }

    public synchronized void writeFormat(PrintWriter output) {
        super.writeFormat(output);
        if (this._reuseDatasets) {
            output.println("<reuseDatasets/>");
        }
        StringBuffer defaults = new StringBuffer();
        if (!this._connected) {
            defaults.append(" connected=\"no\"");
        }
        switch (this._marks) {
            case 1: {
                defaults.append(" marks=\"points\"");
                break;
            }
            case 2: {
                defaults.append(" marks=\"dots\"");
                break;
            }
            case 3: {
                defaults.append(" marks=\"various\"");
                break;
            }
            case 4: {
                defaults.append(" marks=\"pixels\"");
            }
        }
        if (this._impulses) {
            defaults.append(" stems=\"yes\"");
        }
        if (defaults.length() > 0) {
            output.println("<default" + defaults.toString() + "/>");
        }
        if (this._bars) {
            output.println("<barGraph width=\"" + this.barWidth + "\" offset=\"" + this._barOffset + "\"/>");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void _checkDatasetIndex(int dataset) {
        if (dataset >= 0) ** GOTO lbl7
        throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
lbl-1000:
        // 1 sources

        {
            this._points.addElement(new Vector<E>());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
lbl7:
            // 2 sources

            ** while (dataset >= this._points.size())
        }
lbl8:
        // 1 sources

    }

    protected void _drawBar(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (clip) {
            if (ypos < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            long zeroypos;
            int barlx = (int)((double)xpos - this.barWidth * this._xscale / 2.0 + (double)dataset * this._barOffset * this._xscale);
            int barrx = (int)((double)barlx + this.barWidth * this._xscale);
            if (barlx < this._ulx) {
                barlx = this._ulx;
            }
            if (barrx > this._lrx) {
                barrx = this._lrx;
            }
            if (barlx >= barrx) {
                barrx = barlx + 1;
            }
            if ((long)this._lry < (zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                zeroypos = this._lry;
            }
            if ((long)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            if (this._yMin >= 0.0 || ypos <= zeroypos) {
                graphics.fillRect(barlx, (int)ypos, barrx - barlx, (int)(zeroypos - ypos));
            } else {
                graphics.fillRect(barlx, (int)zeroypos, barrx - barlx, (int)(ypos - zeroypos));
            }
        }
    }

    protected void _drawErrorBar(Graphics graphics, int dataset, long xpos, long yLowEBPos, long yHighEBPos, boolean clip) {
        this._drawLine(graphics, dataset, xpos - 5L, yHighEBPos, xpos + 5L, yHighEBPos, clip);
        this._drawLine(graphics, dataset, xpos, yLowEBPos, xpos, yHighEBPos, clip);
        this._drawLine(graphics, dataset, xpos - 5L, yLowEBPos, xpos + 5L, yLowEBPos, clip);
    }

    protected void _drawImpulse(Graphics graphics, long xpos, long ypos, boolean clip) {
        if (clip) {
            if (ypos < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            double zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale);
            if ((double)this._lry < zeroypos) {
                zeroypos = this._lry;
            }
            if ((double)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            this._setWidth(graphics, 1.0f);
            graphics.drawLine((int)xpos, (int)ypos, (int)xpos, (int)zeroypos);
        }
    }

    protected void _drawLine(Graphics graphics, int dataset, long startx, long starty, long endx, long endy, boolean clip) {
        this._drawLine(graphics, dataset, startx, starty, endx, endy, clip, 1.0f);
    }

    protected void _drawLine(Graphics graphics, int dataset, long startx, long starty, long endx, long endy, boolean clip, float width) {
        this._setWidth(graphics, width);
        if (clip) {
            if (!(endx <= (long)this._ulx && startx <= (long)this._ulx || endx >= (long)this._lrx && startx >= (long)this._lrx || endy <= (long)this._uly && starty <= (long)this._uly || endy >= (long)this._lry && starty >= (long)this._lry)) {
                if (startx != endx) {
                    if (endx < (long)this._ulx) {
                        endy = (int)(endy + (starty - endy) * ((long)this._ulx - endx) / (startx - endx));
                        endx = this._ulx;
                    } else if (endx > (long)this._lrx) {
                        endy = (int)(endy + (starty - endy) * ((long)this._lrx - endx) / (startx - endx));
                        endx = this._lrx;
                    }
                }
                if (starty != endy) {
                    if (endy < (long)this._uly) {
                        endx = (int)(endx + (startx - endx) * ((long)this._uly - endy) / (starty - endy));
                        endy = this._uly;
                    } else if (endy > (long)this._lry) {
                        endx = (int)(endx + (startx - endx) * ((long)this._lry - endy) / (starty - endy));
                        endy = this._lry;
                    }
                }
                if (startx != endx) {
                    if (startx < (long)this._ulx) {
                        starty = (int)(starty + (endy - starty) * ((long)this._ulx - startx) / (endx - startx));
                        startx = this._ulx;
                    } else if (startx > (long)this._lrx) {
                        starty = (int)(starty + (endy - starty) * ((long)this._lrx - startx) / (endx - startx));
                        startx = this._lrx;
                    }
                }
                if (starty != endy) {
                    if (starty < (long)this._uly) {
                        startx = (int)(startx + (endx - startx) * ((long)this._uly - starty) / (endy - starty));
                        starty = this._uly;
                    } else if (starty > (long)this._lry) {
                        startx = (int)(startx + (endx - startx) * ((long)this._lry - starty) / (endy - starty));
                        starty = this._lry;
                    }
                }
            }
            if (endx >= (long)this._ulx && endx <= (long)this._lrx && endy >= (long)this._uly && endy <= (long)this._lry && startx >= (long)this._ulx && startx <= (long)this._lrx && starty >= (long)this._uly && starty <= (long)this._lry) {
                graphics.drawLine((int)startx, (int)starty, (int)endx, (int)endy);
            }
        } else {
            graphics.drawLine((int)startx, (int)starty, (int)endx, (int)endy);
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean clearfirst, Rectangle drawRectangle) {
        super._drawPlot(graphics, clearfirst, drawRectangle);
        int dataset = this._points.size() - 1;
        while (dataset >= 0) {
            Vector data = (Vector)this._points.elementAt(dataset);
            int pointnum = 0;
            while (pointnum < data.size()) {
                this._drawPlotPoint(graphics, dataset, pointnum);
                ++pointnum;
            }
            --dataset;
        }
        this._showing = true;
    }

    protected void _drawPoint(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        boolean pointinside;
        boolean bl = pointinside = ypos <= (long)this._lry && ypos >= (long)this._uly && xpos <= (long)this._lrx && xpos >= (long)this._ulx;
        if (!clip || pointinside) {
            int xposi = (int)xpos;
            int yposi = (int)ypos;
            Format fmt = (Format)this._formats.elementAt(dataset);
            int marks = this._marks;
            if (!fmt.marksUseDefault) {
                marks = fmt.marks;
            }
            if (!pointinside && marks != 3 && this._isConnected(dataset) && graphics instanceof EPSGraphics) {
                graphics.drawLine(xposi - 6, yposi, xposi + 6, yposi);
            } else {
                switch (marks) {
                    case 0: {
                        graphics.fillRect(xposi - 6, yposi - 6, 6, 6);
                        break;
                    }
                    case 1: {
                        graphics.fillOval(xposi - 1, yposi - 1, 3, 3);
                        break;
                    }
                    case 2: {
                        graphics.fillOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 3: {
                        int mark = dataset % 10;
                        switch (mark) {
                            case 0: {
                                graphics.fillOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 1: {
                                graphics.drawLine(xposi - this._radius, yposi - this._radius, xposi + this._radius, yposi + this._radius);
                                graphics.drawLine(xposi + this._radius, yposi - this._radius, xposi - this._radius, yposi + this._radius);
                                break;
                            }
                            case 2: {
                                graphics.drawRect(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 3: {
                                int[] xpoints = new int[4];
                                int[] ypoints = new int[4];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi + this._radius;
                                xpoints[2] = xposi - this._radius;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi;
                                ypoints[3] = yposi - this._radius;
                                graphics.fillPolygon(xpoints, ypoints, 4);
                                break;
                            }
                            case 4: {
                                int[] xpoints = new int[5];
                                int[] ypoints = new int[5];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi;
                                xpoints[2] = xposi;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi - this._radius;
                                ypoints[3] = yposi;
                                xpoints[4] = xposi;
                                ypoints[4] = yposi - this._radius;
                                graphics.drawPolygon(xpoints, ypoints, 5);
                                break;
                            }
                            case 5: {
                                graphics.drawOval(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 6: {
                                graphics.drawLine(xposi, yposi - this._radius, xposi, yposi + this._radius);
                                graphics.drawLine(xposi - this._radius, yposi, xposi + this._radius, yposi);
                                break;
                            }
                            case 7: {
                                graphics.fillRect(xposi - this._radius, yposi - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 8: {
                                int[] xpoints = new int[4];
                                int[] ypoints = new int[4];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi + this._radius;
                                xpoints[2] = xposi - this._radius;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi;
                                ypoints[3] = yposi - this._radius;
                                graphics.drawPolygon(xpoints, ypoints, 4);
                                break;
                            }
                            case 9: {
                                int[] xpoints = new int[5];
                                int[] ypoints = new int[5];
                                xpoints[0] = xposi;
                                ypoints[0] = yposi - this._radius;
                                xpoints[1] = xposi + this._radius;
                                ypoints[1] = yposi;
                                xpoints[2] = xposi;
                                ypoints[2] = yposi + this._radius;
                                xpoints[3] = xposi - this._radius;
                                ypoints[3] = yposi;
                                xpoints[4] = xposi;
                                ypoints[4] = yposi - this._radius;
                                graphics.fillPolygon(xpoints, ypoints, 5);
                            }
                        }
                        break;
                    }
                    case 4: {
                        graphics.fillRect(xposi, yposi, 1, 1);
                    }
                }
            }
        }
    }

    protected boolean _parseLine(String line) {
        boolean connected = false;
        if (this._isConnected(this._currentdataset)) {
            connected = true;
        }
        if (super._parseLine(line)) {
            return true;
        }
        String lcLine = line.toLowerCase();
        if (lcLine.startsWith("marks:")) {
            String style = line.substring(6).trim();
            if (this._sawFirstDataSet) {
                this.setMarksStyle(style, this._currentdataset);
            } else {
                this.setMarksStyle(style);
            }
            return true;
        }
        if (lcLine.startsWith("numsets:")) {
            return true;
        }
        if (lcLine.startsWith("reusedatasets:")) {
            if (lcLine.indexOf("off", 16) >= 0) {
                this.setReuseDatasets(false);
            } else {
                this.setReuseDatasets(true);
            }
            return true;
        }
        if (lcLine.startsWith("dataset:")) {
            String legend;
            if (this._reuseDatasets && lcLine.length() > 0) {
                String tlegend = line.substring(8).trim();
                this._currentdataset = -1;
                int i = 0;
                while (i <= this._maxDataset) {
                    if (this.getLegend(i).compareTo(tlegend) == 0) {
                        this._currentdataset = i;
                    }
                    ++i;
                }
                if (this._currentdataset != -1) {
                    return true;
                }
                this._currentdataset = this._maxDataset;
            }
            this._firstInSet = true;
            this._sawFirstDataSet = true;
            ++this._currentdataset;
            if (lcLine.length() > 0 && (legend = line.substring(8).trim()) != null && legend.length() > 0) {
                this.addLegend(this._currentdataset, legend);
            }
            this._maxDataset = this._currentdataset;
            return true;
        }
        if (lcLine.startsWith("lines:")) {
            if (this._sawFirstDataSet) {
                Enumeration formats = this._formats.elements();
                while (formats.hasMoreElements()) {
                    Format format = (Format)formats.nextElement();
                    if (!format.connectedUseDefault) continue;
                    format.connectedUseDefault = false;
                    format.connected = this._connected;
                }
            }
            if (lcLine.indexOf("off", 6) >= 0) {
                this.setConnected(false);
            } else {
                this.setConnected(true);
            }
            return true;
        }
        if (lcLine.startsWith("impulses:")) {
            if (this._sawFirstDataSet) {
                if (lcLine.indexOf("off", 9) >= 0) {
                    this.setImpulses(false, this._currentdataset);
                } else {
                    this.setImpulses(true, this._currentdataset);
                }
            } else if (lcLine.indexOf("off", 9) >= 0) {
                this.setImpulses(false);
            } else {
                this.setImpulses(true);
            }
            return true;
        }
        if (lcLine.startsWith("bars:")) {
            if (lcLine.indexOf("off", 5) >= 0) {
                this.setBars(false);
            } else {
                String barwidth;
                this.setBars(true);
                int comma = line.indexOf(",", 5);
                String baroffset = null;
                if (comma > 0) {
                    barwidth = line.substring(5, comma).trim();
                    baroffset = line.substring(comma + 1).trim();
                } else {
                    barwidth = line.substring(5).trim();
                }
                try {
                    Double bwidth = new Double(barwidth);
                    double boffset = this._barOffset;
                    if (baroffset != null) {
                        boffset = new Double(baroffset);
                    }
                    this.setBars(bwidth, boffset);
                }
                catch (NumberFormatException bwidth) {
                    // empty catch block
                }
            }
            return true;
        }
        if (line.startsWith("move:")) {
            connected = false;
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("move")) {
            connected = false;
            line = line.substring(4, line.length()).trim();
        } else if (line.startsWith("draw:")) {
            line = line.substring(5, line.length()).trim();
        } else if (line.startsWith("draw")) {
            line = line.substring(4, line.length()).trim();
        }
        line = line.trim();
        int fieldsplit = line.indexOf(",");
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf(" ");
        }
        if (fieldsplit == -1) {
            fieldsplit = line.indexOf("\t");
        }
        if (fieldsplit > 0) {
            String x = line.substring(0, fieldsplit).trim();
            String y = line.substring(fieldsplit + 1).trim();
            int fieldsplit2 = y.indexOf(",");
            if (fieldsplit2 == -1) {
                fieldsplit2 = y.indexOf(" ");
            }
            if (fieldsplit2 == -1) {
                fieldsplit2 = y.indexOf("\t");
            }
            if (fieldsplit2 > 0) {
                line = y.substring(fieldsplit2 + 1).trim();
                y = y.substring(0, fieldsplit2).trim();
            }
            try {
                Double xpt = new Double(x);
                Double ypt = new Double(y);
                if (fieldsplit2 > 0) {
                    int fieldsplit3 = line.indexOf(",");
                    if (fieldsplit3 == -1) {
                        fieldsplit3 = line.indexOf(" ");
                    }
                    if (fieldsplit3 > 0) {
                        String yl = line.substring(0, fieldsplit3).trim();
                        String yh = line.substring(fieldsplit3 + 1).trim();
                        Double yLowEB = new Double(yl);
                        Double yHighEB = new Double(yh);
                        connected = this._addLegendIfNecessary(connected);
                        this.addPointWithErrorBars(this._currentdataset, xpt, ypt, yLowEB, yHighEB, connected);
                        return true;
                    }
                    connected = this._addLegendIfNecessary(connected);
                    this.addPoint(this._currentdataset, xpt, ypt, connected);
                    return true;
                }
                connected = this._addLegendIfNecessary(connected);
                this.addPoint(this._currentdataset, xpt, ypt, connected);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void _setWidth(Graphics graphics, float width) {
        if (graphics instanceof Graphics2D) {
            if (width == 1.0f) {
                ((Graphics2D)graphics).setStroke(_lineStroke1);
            } else if (width == 2.0f) {
                ((Graphics2D)graphics).setStroke(_lineStroke2);
            } else {
                ((Graphics2D)graphics).setStroke(new BasicStroke(width, 0, 1));
            }
        }
    }

    protected void _writeOldSyntax(PrintWriter output) {
        super._writeOldSyntax(output);
        if (this._reuseDatasets) {
            output.println("ReuseDatasets: on");
        }
        if (!this._connected) {
            output.println("Lines: off");
        }
        if (this._bars) {
            output.println("Bars: " + this.barWidth + ", " + this._barOffset);
        }
        if (this._impulses) {
            output.println("Impulses: on");
        }
        switch (this._marks) {
            case 1: {
                output.println("Marks: points");
                break;
            }
            case 2: {
                output.println("Marks: dots");
                break;
            }
            case 3: {
                output.println("Marks: various");
                break;
            }
            case 4: {
                output.println("Marks: pixels");
            }
        }
        int dataset = 0;
        while (dataset < this._points.size()) {
            String legend = this.getLegend(dataset);
            if (legend != null) {
                output.println("DataSet: " + this.getLegend(dataset));
            } else {
                output.println("DataSet:");
            }
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (!fmt.impulsesUseDefault) {
                if (fmt.impulses) {
                    output.println("Impulses: on");
                } else {
                    output.println("Impulses: off");
                }
            }
            if (!fmt.marksUseDefault) {
                switch (fmt.marks) {
                    case 0: {
                        output.println("Marks: none");
                        break;
                    }
                    case 1: {
                        output.println("Marks: points");
                        break;
                    }
                    case 2: {
                        output.println("Marks: dots");
                        break;
                    }
                    case 3: {
                        output.println("Marks: various");
                        break;
                    }
                    case 4: {
                        output.println("Marks: pixels");
                    }
                }
            }
            Vector pts = (Vector)this._points.elementAt(dataset);
            int pointnum = 0;
            while (pointnum < pts.size()) {
                PlotPoint pt = (PlotPoint)pts.elementAt(pointnum);
                if (!pt.connected) {
                    output.print("move: ");
                }
                if (pt.errorBar) {
                    output.println(String.valueOf(pt.x) + ", " + pt.y + ", " + pt.yLowEB + ", " + pt.yHighEB);
                } else {
                    output.println(String.valueOf(pt.x) + ", " + pt.y);
                }
                ++pointnum;
            }
            ++dataset;
        }
    }

    private boolean _addLegendIfNecessary(boolean connected) {
        if (!(this._sawFirstDataSet && this._currentdataset >= 0 || this._reuseDatasets)) {
            this._sawFirstDataSet = true;
            ++this._currentdataset;
        }
        if (!this._sawFirstDataSet && this.getLegend(this._currentdataset) == null) {
            this._firstInSet = true;
            this._sawFirstDataSet = true;
            this.addLegend(this._currentdataset, "Set " + this._currentdataset);
        }
        if (this._firstInSet && !this._reuseDatasets) {
            connected = false;
            this._firstInSet = false;
        }
        return connected;
    }

    private void _addPoint(int dataset, double x, double y, double yLowEB, double yHighEB, boolean connected, boolean errorBar) {
        this._plotImage = null;
        this._checkDatasetIndex(dataset);
        if (this._xlog) {
            if (x <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + x);
                return;
            }
            x = Math.log(x) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (y <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + y);
                return;
            }
            y = Math.log(y) * PlotBox._LOG10SCALE;
            if (errorBar) {
                if (yLowEB <= 0.0 || yHighEB <= 0.0) {
                    System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + y);
                    return;
                }
                yLowEB = Math.log(yLowEB) * PlotBox._LOG10SCALE;
                yHighEB = Math.log(yHighEB) * PlotBox._LOG10SCALE;
            }
        }
        Vector pts = (Vector)this._points.elementAt(dataset);
        if (this._xPersistence > 0.0) {
            int numToDelete = 0;
            while (numToDelete < pts.size()) {
                PlotPoint old = (PlotPoint)pts.elementAt(numToDelete);
                if (x - old.originalx <= this._xPersistence) break;
                ++numToDelete;
            }
            int i = 0;
            while (i < numToDelete) {
                this.erasePoint(dataset, 0);
                ++i;
            }
        }
        int size = pts.size();
        PlotPoint pt = new PlotPoint();
        pt.originalx = x;
        if (this._wrap) {
            double width = this._wrapHigh - this._wrapLow;
            if (x < this._wrapLow) {
                x += width * Math.floor(1.0 + (this._wrapLow - x) / width);
            } else if (x > this._wrapHigh && (x -= width * Math.floor(1.0 + (x - this._wrapHigh) / width)) == this._wrapLow) {
                x = this._wrapHigh;
            }
        }
        if (x < this._xBottom) {
            this._xBottom = x;
        }
        if (x > this._xTop) {
            this._xTop = x;
        }
        if (y < this._yBottom) {
            this._yBottom = y;
        }
        if (y > this._yTop) {
            this._yTop = y;
        }
        pt.x = x;
        pt.y = y;
        boolean bl = pt.connected = connected && this._isConnected(dataset);
        if (errorBar) {
            if (yLowEB < this._yBottom) {
                this._yBottom = yLowEB;
            }
            if (yLowEB > this._yTop) {
                this._yTop = yLowEB;
            }
            if (yHighEB < this._yBottom) {
                this._yBottom = yHighEB;
            }
            if (yHighEB > this._yTop) {
                this._yTop = yHighEB;
            }
            pt.yLowEB = yLowEB;
            pt.yHighEB = yHighEB;
            pt.errorBar = true;
        }
        if (size == 0) {
            pt.connected = false;
        } else if (this._wrap) {
            PlotPoint old = (PlotPoint)pts.elementAt(size - 1);
            if (old.x > x) {
                pt.connected = false;
            }
        }
        pts.addElement(pt);
        if (this._pointsPersistence > 0 && size > this._pointsPersistence) {
            this.erasePoint(dataset, 0);
        }
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            if ((this._pointsPersistence > 0 || this._xPersistence > 0.0) && this.isDoubleBuffered()) {
                this.setDoubleBuffered(false);
                Container parent = this.getParent();
                while (parent != null) {
                    if (parent instanceof JComponent) {
                        ((JComponent)parent).setDoubleBuffered(false);
                    }
                    parent = parent.getParent();
                }
            }
            this._drawPlotPoint(graphics, dataset, pts.size() - 1);
        }
        if (this._wrap && x == this._wrapHigh) {
            this._addPoint(dataset, this._wrapLow, y, yLowEB, yHighEB, false, errorBar);
        }
    }

    private void _clear(boolean format) {
        this._plotImage = null;
        super.clear(format);
        this._currentdataset = -1;
        this._points = new Vector();
        this._prevx = new Vector();
        this._prevy = new Vector();
        this._maxDataset = -1;
        this._firstInSet = true;
        this._sawFirstDataSet = false;
        this._xyInvalid = true;
        if (format) {
            this._showing = false;
            this._formats = new Vector();
            this._marks = 0;
            this._pointsPersistence = 0;
            this._xPersistence = 0.0;
            this._bars = false;
            this.barWidth = 0.5;
            this._barOffset = 0.05;
            this._connected = true;
            this._impulses = false;
            this._reuseDatasets = false;
        }
    }

    private void _clear(int dataset) {
        this._plotImage = null;
        this._checkDatasetIndex(dataset);
        this._xyInvalid = true;
        Vector points = (Vector)this._points.elementAt(dataset);
        points.clear();
        this._points.setElementAt(points, dataset);
        this.repaint();
    }

    private void _drawPlotPoint(Graphics graphics, int dataset, int index) {
        if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
            if (this._background == null) {
                graphics.setXORMode(this.getBackground());
            } else {
                graphics.setXORMode(this._background);
            }
        }
        if (this._usecolor) {
            int color = dataset % PlotBox._colors.length;
            graphics.setColor(PlotBox._colors[color]);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector pts = (Vector)this._points.elementAt(dataset);
        PlotPoint pt = (PlotPoint)pts.elementAt(index);
        long ypos = (long)this._lry - (long)((pt.y - this._yMin) * this._yscale);
        long xpos = (long)this._ulx + (long)((pt.x - this._xMin) * this._xscale);
        long prevx = (Long)this._prevx.elementAt(dataset);
        long prevy = (Long)this._prevy.elementAt(dataset);
        if (xpos != prevx || ypos != prevy || pts.size() == 1) {
            if (pt.connected) {
                this._drawLine(graphics, dataset, xpos, ypos, prevx, prevy, true, 2.0f);
            }
            this._prevx.setElementAt(new Long(xpos), dataset);
            this._prevy.setElementAt(new Long(ypos), dataset);
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (fmt.impulsesUseDefault) {
                if (this._impulses) {
                    this._drawImpulse(graphics, xpos, ypos, true);
                }
            } else if (fmt.impulses) {
                this._drawImpulse(graphics, xpos, ypos, true);
            }
            int marks = this._marks;
            if (!fmt.marksUseDefault) {
                marks = fmt.marks;
            }
            if (marks != 0) {
                this._drawPoint(graphics, dataset, xpos, ypos, true);
            }
            if (this._bars) {
                this._drawBar(graphics, dataset, xpos, ypos, true);
            }
        }
        if (pt.errorBar) {
            this._drawErrorBar(graphics, dataset, xpos, (long)this._lry - (long)((pt.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((pt.yHighEB - this._yMin) * this._yscale), true);
        }
        graphics.setColor(this._foreground);
        if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
            graphics.setPaintMode();
        }
    }

    private void _erasePoint(int dataset, int index) {
        Vector points;
        PlotPoint pt;
        this._plotImage = null;
        this._checkDatasetIndex(dataset);
        Graphics graphics = this.getGraphics();
        if (this._showing && graphics != null) {
            if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
                if (this._background == null) {
                    graphics.setXORMode(this.getBackground());
                } else {
                    graphics.setXORMode(this._background);
                }
            }
            if (this._usecolor) {
                int color = dataset % PlotBox._colors.length;
                graphics.setColor(PlotBox._colors[color]);
            } else {
                graphics.setColor(this._foreground);
            }
            Vector pts = (Vector)this._points.elementAt(dataset);
            pt = (PlotPoint)pts.elementAt(index);
            long ypos = (long)this._lry - (long)((pt.y - this._yMin) * this._yscale);
            long xpos = (long)this._ulx + (long)((pt.x - this._xMin) * this._xscale);
            if (index < pts.size() - 1) {
                PlotPoint nextp = (PlotPoint)pts.elementAt(index + 1);
                int nextx = this._ulx + (int)((nextp.x - this._xMin) * this._xscale);
                int nexty = this._lry - (int)((nextp.y - this._yMin) * this._yscale);
                if (nextp.connected) {
                    this._drawLine(graphics, dataset, nextx, nexty, xpos, ypos, true, 2.0f);
                }
                nextp.connected = false;
            }
            Format fmt = (Format)this._formats.elementAt(dataset);
            if (fmt.impulsesUseDefault) {
                if (this._impulses) {
                    this._drawImpulse(graphics, xpos, ypos, true);
                }
            } else if (fmt.impulses) {
                this._drawImpulse(graphics, xpos, ypos, true);
            }
            int marks = this._marks;
            if (!fmt.marksUseDefault) {
                marks = fmt.marks;
            }
            if (marks != 0) {
                this._drawPoint(graphics, dataset, xpos, ypos, true);
            }
            if (this._bars) {
                this._drawBar(graphics, dataset, xpos, ypos, true);
            }
            if (pt.errorBar) {
                this._drawErrorBar(graphics, dataset, xpos, (long)this._lry - (long)((pt.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((pt.yHighEB - this._yMin) * this._yscale), true);
            }
            graphics.setColor(this._foreground);
            if (this._pointsPersistence > 0 || this._xPersistence > 0.0) {
                graphics.setPaintMode();
            }
        }
        if ((points = (Vector)this._points.elementAt(dataset)) != null && (pt = (PlotPoint)points.elementAt(index)) != null) {
            if (pt.x == this._xBottom || pt.x == this._xTop || pt.y == this._yBottom || pt.y == this._yTop) {
                this._xyInvalid = true;
            }
            points.removeElementAt(index);
        }
    }

    private void _fillPlot() {
        if (this._xyInvalid) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -1.7976931348623157E308;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -1.7976931348623157E308;
            int dataset = 0;
            while (dataset < this._points.size()) {
                Vector points = (Vector)this._points.elementAt(dataset);
                int index = 0;
                while (index < points.size()) {
                    PlotPoint pt = (PlotPoint)points.elementAt(index);
                    if (pt.x < this._xBottom) {
                        this._xBottom = pt.x;
                    }
                    if (pt.x > this._xTop) {
                        this._xTop = pt.x;
                    }
                    if (pt.y < this._yBottom) {
                        this._yBottom = pt.y;
                    }
                    if (pt.y > this._yTop) {
                        this._yTop = pt.y;
                    }
                    ++index;
                }
                ++dataset;
            }
        }
        this._xyInvalid = false;
        if (this._bars) {
            if (this._yBottom > 0.0) {
                this._yBottom = 0.0;
            }
            if (this._yTop < 0.0) {
                this._yTop = 0.0;
            }
        }
        super.fillPlot();
    }

    private boolean _isConnected(int dataset) {
        if (dataset < 0) {
            return this._connected;
        }
        this._checkDatasetIndex(dataset);
        Format fmt = (Format)this._formats.elementAt(dataset);
        if (fmt.connectedUseDefault) {
            return this._connected;
        }
        return fmt.connected;
    }

    private class Format
    implements Serializable {
        public boolean connected;
        public boolean connectedUseDefault = true;
        public boolean impulses;
        public boolean impulsesUseDefault = true;
        public int marks;
        public boolean marksUseDefault = true;

        Format() {
        }
    }
}

