model HeatingRectifier "Heating rectifier"
   extends Modelica.Icons.Example;
   Modelica.Electrical.Analog.Semiconductors.HeatingDiode HeatingDiode1 annotation (Placement(transformation(x=-10.,y=50.,scale=0.1,aspectRatio=1.),iconTransformation(x=-10.,y=50.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground G annotation (Placement(transformation(x=-70.,y=10.,scale=0.1,aspectRatio=1.),iconTransformation(x=-70.,y=10.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1 annotation (Placement(transformation(x=-70.,y=40.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=-70.,y=40.,scale=0.1,aspectRatio=1.,rotation=270)));
   annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-94.,102.},{0.,74.}},textString="HeatingRectifier",fillColor={0,0,255})}));
   Modelica.Electrical.Analog.Basic.Capacitor Capacitor1 annotation (Placement(transformation(x=30.,y=50.,scale=0.1,aspectRatio=1.),iconTransformation(x=30.,y=50.,scale=0.1,aspectRatio=1.)));
   Modelica.Thermal.HeatTransfer.HeatCapacitor HeatCapacitor1(C=1) annotation (Placement(transformation(x=-10.,y=-50.,scale=0.1,aspectRatio=1.,rotation=180),iconTransformation(x=-10.,y=-50.,scale=0.1,aspectRatio=1.,rotation=180)));
   Modelica.Thermal.HeatTransfer.ThermalConductor ThermalConductor1(G=10) annotation (Placement(transformation(x=-10.,y=-10.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=-10.,y=-10.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Electrical.Analog.Basic.Resistor R(R=1) annotation (Placement(transformation(x=30.,y=80.,scale=0.1,aspectRatio=1.),iconTransformation(x=30.,y=80.,scale=0.1,aspectRatio=1.)));
   
equation
   connect(SineVoltage1.p, HeatingDiode1.p) annotation (Line(points={{-70.,50.},{-20.,50.}},color={0,0,255}));
   connect(SineVoltage1.n, G.p) annotation (Line(points={{-70.,30.},{-70.,20.}},color={0,0,255}));
   connect(Capacitor1.n, G.p) annotation (Line(points={{40.,50.},{40.,20.},{-70.,20.}},color={0,0,255}));
   connect(HeatingDiode1.n, Capacitor1.p) annotation (Line(points={{0.,50.},{20.,50.}},color={0,0,255}));
   connect(HeatingDiode1.heatPort, ThermalConductor1.port_a) annotation (Line(points={{-10.,40.},{-10.,20.5},{-10.,1.},{-10.,1.}},color={191,0,0}));
   connect(ThermalConductor1.port_b, HeatCapacitor1.port) annotation (Line(points={{-10.,-21.},{-10.,-25.75},{-10.,-25.75},{-10.,-30.5},{-10.,-40.},{-10.,-40.}},color={191,0,0}));
   connect(R.p, Capacitor1.p) annotation (Line(points={{20.,80.},{20.,50.}},color={0,0,255}));
   connect(R.n, Capacitor1.n) annotation (Line(points={{40.,80.},{40.,50.}},color={0,0,255}));
   annotation (Documentation(info="<HTML>
 <P>
 The heating rectifier shows a heat flow always if the electrical capacitor is loaded.
 </P>
 <P>
 Simulate until T=5 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 SineVoltage1.v  and  Capacitor1.p.v <br>
 HeatCapacitor1.port.T and HeatingDiode1.heatPort.T<br>
 HeatingDiode1.heatPort.Q_flow<br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 6, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=5));
end HeatingRectifier;