encapsulated model DifferenceAmplifier
   import Modelica.Electrical.Analog.Basic;
   import Modelica.Electrical.Analog.Sources;
   import Modelica.Electrical.Analog.Examples.Utilities;
   annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-90.,90.},{90.,-90.}},lineColor={128,128,128},lineThickness=0.5,fillColor={192,192,192},fillPattern=FillPattern.Solid),Text(extent={{-77.,20.},{79.,-20.}},textString="DifferenceAmplifier",fillColor={0,0,0})}),Documentation(info="<html>
 <p>
 It is a simple NPN transistor amplifier circuit. The voltage difference between R1.p and R3.n is amplified. The output signal is the voltage between R2.n and R4.n. In this example the voltage at V1 is amplified because R3.n is grounded.
 <p>
 The simulation end time should be set to 1e- 8. Please plot the input voltage V1.v, and the output voltages R2.n.v, and R4.n.v.
 <p>
 
 <dl>
 <dt>
 <b>Reference:</b>
 <dd>
 Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 59
 <p>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 
 <p>
 <dt>
 <b>Version:</b>
 <dd>
 $Id: DifferenceAmplifier.mo,v 1.8 2003/10/31 11:11:52 SvenErik Exp $<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
   Sources.ExpSineVoltage V1(V=0.2,freqHz=2.e8,damping=1.e7) annotation (Placement(transformation(x=-90.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=-90.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Sources.RampVoltage V2(V=15,duration=1/1000000000) annotation (Placement(transformation(x=80.,y=50.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=80.,y=50.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Sources.RampCurrent I1(I=0.16,duration=1/1000000000) annotation (Placement(transformation(x=-10.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=-10.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Resistor R1(R=0.0001) annotation (Placement(transformation(x=-80.,y=-10.,scale=0.1,aspectRatio=1.),iconTransformation(x=-80.,y=-10.,scale=0.1,aspectRatio=1.)));
   Basic.Resistor R2(R=100) annotation (Placement(transformation(x=-40.,y=30.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=-40.,y=30.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Resistor R3(R=0.0001) annotation (Placement(transformation(x=80.,y=-10.,scale=0.1,aspectRatio=1.),iconTransformation(x=80.,y=-10.,scale=0.1,aspectRatio=1.)));
   Basic.Resistor R4(R=100) annotation (Placement(transformation(x=40.,y=30.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=40.,y=30.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Capacitor C1(C=1/10000000000) annotation (Placement(transformation(x=-60.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=-60.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Capacitor C4(C=1/10000000000) annotation (Placement(transformation(x=20.,y=-4.,scale=0.1,aspectRatio=1.),iconTransformation(x=20.,y=-4.,scale=0.1,aspectRatio=1.)));
   Basic.Capacitor C5(C=1/10000000000) annotation (Placement(transformation(x=10.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=10.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Capacitor C2(C=1/10000000000) annotation (Placement(transformation(x=-20.,y=-4.,scale=0.1,aspectRatio=1.),iconTransformation(x=-20.,y=-4.,scale=0.1,aspectRatio=1.)));
   Basic.Capacitor C3(C=1/10000000000) annotation (Placement(transformation(x=60.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=60.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Ground Gnd1 annotation (Placement(transformation(x=-90.,y=-75.,scale=0.05,aspectRatio=1.),iconTransformation(x=-90.,y=-75.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd9 annotation (Placement(transformation(x=80.,y=25.,scale=0.05,aspectRatio=1.),iconTransformation(x=80.,y=25.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd3 annotation (Placement(transformation(x=-10.,y=-15.,scale=0.05,aspectRatio=1.),iconTransformation(x=-10.,y=-15.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd2 annotation (Placement(transformation(x=-60.,y=-75.,scale=0.05,aspectRatio=1.),iconTransformation(x=-60.,y=-75.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd6 annotation (Placement(transformation(x=10.,y=-15.,scale=0.05,aspectRatio=1.),iconTransformation(x=10.,y=-15.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd7 annotation (Placement(transformation(x=-10.,y=-75.,scale=0.05,aspectRatio=1.),iconTransformation(x=-10.,y=-75.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd8 annotation (Placement(transformation(x=10.,y=-75.,scale=0.05,aspectRatio=1.),iconTransformation(x=10.,y=-75.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd5 annotation (Placement(transformation(x=60.,y=-75.,scale=0.05,aspectRatio=1.),iconTransformation(x=60.,y=-75.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd4 annotation (Placement(transformation(x=90.,y=-45.,scale=0.05,aspectRatio=1.),iconTransformation(x=90.,y=-45.,scale=0.05,aspectRatio=1.)));
   Utilities.Transistor Transistor1 annotation (Placement(transformation(x=-50.,y=-10.,scale=0.1,aspectRatio=1.),iconTransformation(x=-50.,y=-10.,scale=0.1,aspectRatio=1.)));
   Utilities.Transistor Transistor2 annotation (Placement(transformation(x=50.,y=-10.,scale=0.1,aspectRatio=1.,flipHorizontal=true),iconTransformation(x=50.,y=-10.,scale=0.1,aspectRatio=1.,flipHorizontal=true)));
   
equation
   connect(V1.n, Gnd1.p) annotation (Line(points={{-90.,-60.},{-90.,-70.}},color={0,0,255}));
   connect(C1.n, Gnd2.p) annotation (Line(points={{-60.,-60.},{-60.,-70.}},color={0,0,255}));
   connect(I1.n, Gnd7.p) annotation (Line(points={{-10.,-60.},{-10.,-70.}},color={0,0,255}));
   connect(C5.n, Gnd8.p) annotation (Line(points={{10.,-60.},{10.,-70.}},color={0,0,255}));
   connect(C3.n, Gnd5.p) annotation (Line(points={{60.,-60.},{60.,-70.}},color={0,0,255}));
   connect(R3.n, Gnd4.p) annotation (Line(points={{90.,-10.},{90.,-40.}},color={0,0,255}));
   connect(C2.n, Gnd3.p) annotation (Line(points={{-10.,-4.},{-10.,-10.}},color={0,0,255}));
   connect(C4.p, Gnd6.p) annotation (Line(points={{10.,-4.},{10.,-10.}},color={0,0,255}));
   connect(I1.p, C5.p) annotation (Line(points={{-10.,-40.},{10.,-40.}},color={0,0,255}));
   connect(R1.p, V1.p) annotation (Line(points={{-90.,-10.},{-90.,-40.}},color={0,0,255}));
   connect(R2.p, V2.p) annotation (Line(points={{-40.,40.},{-40.,70.},{80.,70.},{80.,60.}},color={0,0,255}));
   connect(R4.p, V2.p) annotation (Line(points={{40.,40.},{40.,70.},{80.,70.},{80.,60.}},color={0,0,255}));
   connect(V2.n, Gnd9.p) annotation (Line(points={{80.,40.},{80.,30.}},color={0,0,255}));
   connect(R1.n, Transistor1.b) annotation (Line(points={{-70.,-10.},{-60.,-10.}},color={0,0,255}));
   connect(Transistor1.b, C1.p) annotation (Line(points={{-60.,-10.},{-60.,-40.}},color={0,0,255}));
   connect(Transistor1.c, C2.p) annotation (Line(points={{-40.,-4.},{-30.,-4.}},color={0,0,255}));
   connect(R2.n, Transistor1.c) annotation (Line(points={{-40.,20.},{-40.,-4.}},color={0,0,255}));
   connect(Transistor1.e, I1.p) annotation (Line(points={{-40.,-16.},{-30.,-16.},{-30.,-40.},{-10.,-40.}},color={0,0,255}));
   connect(Transistor2.b, R3.p) annotation (Line(points={{60.,-10.},{70.,-10.}},color={0,0,255}));
   connect(Transistor2.b, C3.p) annotation (Line(points={{60.,-10.},{60.,-40.}},color={0,0,255}));
   connect(C4.n, Transistor2.c) annotation (Line(points={{30.,-4.},{40.,-4.}},color={0,0,255}));
   connect(R4.n, Transistor2.c) annotation (Line(points={{40.,20.},{40.,-4.}},color={0,0,255}));
   connect(C5.p, Transistor2.e) annotation (Line(points={{10.,-40.},{30.,-40.},{30.,-16.},{40.,-16.}},color={0,0,255}));
end DifferenceAmplifier;