package Logical "Components with Boolean input and output signals"
   extends Modelica.Icons.Library;
   annotation (preferedView="info",Documentation(info="<html>
 <p>
 This package provides blocks with Boolean input and output signals
 to describe logical networks. A typical example for a logical
 network built with package Logical is shown in the next figure:
 </p>
 <p align=\"center\">
 <img src=\"../Images/LogicalNetwork1.png\">
 </p>
 </html>"));
   model And "Logical 'and': y = u1 and u2"
      extends Blocks.Interfaces.partialBooleanSI2SO;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,40.},{90.,-40.}},textString="and",fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = u1 and u2;
   end And;
   model Or "Logical 'or': y = u1 or u2"
      extends Blocks.Interfaces.partialBooleanSI2SO;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,40.},{90.,-40.}},textString="or",fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = u1 or u2;
   end Or;
   model Xor "Logical 'xor': y = u1 xor u2"
      extends Blocks.Interfaces.partialBooleanSI2SO;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,40.},{90.,-40.}},textString="xor",fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = not (u1 and u2 or not u1 and not u2);
   end Xor;
   model Nor "Logical 'nor': y = not (u1 or u2)"
      extends Blocks.Interfaces.partialBooleanSI2SO;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,40.},{90.,-40.}},textString="nor",fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = not (u1 or u2);
   end Nor;
   model Nand "Logical 'nand': y = not (u1 and u2)"
      extends Blocks.Interfaces.partialBooleanSI2SO;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,40.},{90.,-40.}},textString="nand",fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = not (u1 and u2);
   end Nand;
   model Not "Logical 'not': y = not u"
      extends Blocks.Interfaces.partialBooleanSISO;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,40.},{90.,-40.}},textString="not",fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = not u;
   end Not;




   block GreaterThreshold "Output y is true, if input u is greater than threshold"
      extends Blocks.Interfaces.partialBooleanThresholdComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,-40.},{60.,40.}},fillColor={0,0,0},textString=">")}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = u > threshold;
   end GreaterThreshold;
   block GreaterEqualThreshold "Output y is true, if input u is greater or equal than threshold"
      extends Blocks.Interfaces.partialBooleanThresholdComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,-40.},{60.,40.}},fillColor={0,0,0},textString=">=")}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = u >= threshold;
   end GreaterEqualThreshold;
   block LessThreshold "Output y is true, if input u is less than threshold"
      extends Blocks.Interfaces.partialBooleanThresholdComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,-40.},{60.,40.}},fillColor={0,0,0},textString="<")}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = u < threshold;
   end LessThreshold;
   block LessEqualThreshold "Output y is true, if input u is less or equal than threshold"
      extends Blocks.Interfaces.partialBooleanThresholdComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-90.,-40.},{60.,40.}},fillColor={0,0,0},textString="<=")}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = u <= threshold;
   end LessEqualThreshold;
   block Greater "Output y is true, if input u1 is greater as input u2"
      extends Blocks.Interfaces.partialBooleanComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{32.,10.},{52.,-10.}},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Line(points={{-100.,-80.},{42.,-80.},{42.,0.}},color={0,0,255}),Text(extent={{-80.,-60.},{20.,60.}},fillColor={0,0,0},textString=">")}),Documentation(info=""));
      
   equation
      y = u1 > u2;
   end Greater;
   block GreaterEqual "Output y is true, if input u1 is greater or equal as input u2"
      extends Blocks.Interfaces.partialBooleanComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{32.,10.},{52.,-10.}},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Line(points={{-100.,-80.},{42.,-80.},{42.,0.}},color={0,0,255}),Text(extent={{-80.,-60.},{20.,60.}},fillColor={0,0,0},textString=">=")}),Documentation(info=""));
      
   equation
      y = u1 >= u2;
   end GreaterEqual;
   block Less "Output y is true, if input u1 is less as input u2"
      extends Blocks.Interfaces.partialBooleanComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{32.,10.},{52.,-10.}},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Line(points={{-100.,-80.},{42.,-80.},{42.,0.}},color={0,0,255}),Text(extent={{-80.,-60.},{20.,60.}},fillColor={0,0,0},textString="<")}),Documentation(info=""));
      
   equation
      y = u1 < u2;
   end Less;
   block LessEqual "Output y is true, if input u1 is less or equal as input u2"
      extends Blocks.Interfaces.partialBooleanComparison;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{32.,10.},{52.,-10.}},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Line(points={{-100.,-80.},{42.,-80.},{42.,0.}},color={0,0,255}),Text(extent={{-80.,-60.},{20.,60.}},fillColor={0,0,0},textString="<=")}),Documentation(info=""));
      
   equation
      y = u1 <= u2;
   end LessEqual;

   block LogicalSwitch "Logical Switch"
      extends Blocks.Interfaces.partialBooleanSI3SO;
      annotation (Documentation(info="<html>
 <p>The LogicalSwitch switches, depending on the
 Boolean u2 connector (the middle connector),
 between the two possible input signals
 u1 (upper connector) and u3 (lower connector).</p>
 <p>If u2 is true, connector y is set equal to
 u1, else it is set equal to u2.</p>
 </html>
 "),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Line(points={{12.,0.},{100.,0.}},color={255,0,255},pattern=LinePattern.Solid,thickness=0.25,arrow={Arrow.None,Arrow.None}),Line(points={{-100.,0.},{-40.,0.}},color={255,0,255},pattern=LinePattern.Solid,thickness=0.25,arrow={Arrow.None,Arrow.None}),Line(points={{-100.,-80.},{-40.,-80.},{-40.,-80.}},color={255,0,255},pattern=LinePattern.Solid,thickness=0.25,arrow={Arrow.None,Arrow.None}),Line(points={{-40.,12.},{-40.,-10.}},color={255,0,255}),Line(points={{-100.,80.},{-40.,80.}},color={255,0,255}),Line(points={{-40.,80.},{8.,2.}},color={255,0,127},thickness=1.),Ellipse(extent={{2.,8.},{18.,-6.}},fillColor={0,0,0},fillPattern=FillPattern.Solid,lineColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = if u2 then
         u1
      else
         u3;
   end LogicalSwitch;
   block Switch "Switch between two Real signals"
      extends Blocks.Interfaces.partialBooleanBlockIcon;
      Blocks.Interfaces.RealInput u1 annotation (Placement(transformation(x=-120.,y=80.,scale=0.2,aspectRatio=1.),iconTransformation(x=-120.,y=80.,scale=0.2,aspectRatio=1.)));
      Blocks.Interfaces.BooleanInput u2 annotation (Placement(transformation(x=-120.,y=0.,scale=0.2,aspectRatio=1.),iconTransformation(x=-120.,y=0.,scale=0.2,aspectRatio=1.)));
      Blocks.Interfaces.RealInput u3 annotation (Placement(transformation(x=-120.,y=-80.,scale=0.2,aspectRatio=1.),iconTransformation(x=-120.,y=-80.,scale=0.2,aspectRatio=1.)));
      Blocks.Interfaces.RealOutput y annotation (Placement(transformation(x=110.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=110.,y=0.,scale=0.1,aspectRatio=1.)));
      annotation (Documentation(info="<html>
 <p>The Logical.Switch switches, depending on the
 logical connector u2 (the middle connector)
 between the two possible input signals
 u1 (upper connector) and u3 (lower connector).</p>
 <p>If u2 is <b>true</b>, the output signal y is set equal to
 u1, else it is set equal to u3.</p>
 </html>
 "),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Line(points={{12.,0.},{100.,0.}},pattern=LinePattern.Solid,thickness=0.25,arrow={Arrow.None,Arrow.None},color={0,0,255}),Line(points={{-100.,0.},{-40.,0.}},color={255,0,127},pattern=LinePattern.Solid,thickness=0.25,arrow={Arrow.None,Arrow.None}),Line(points={{-100.,-80.},{-40.,-80.},{-40.,-80.}},pattern=LinePattern.Solid,thickness=0.25,arrow={Arrow.None,Arrow.None},color={0,0,255}),Line(points={{-40.,12.},{-40.,-12.}},color={255,0,127}),Line(points={{-100.,80.},{-38.,80.}},color={0,0,255}),Line(points={{-38.,80.},{6.,2.}},thickness=1.,color={0,0,255}),Ellipse(extent={{2.,8.},{18.,-6.}},fillColor={0,0,0},fillPattern=FillPattern.Solid,lineColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
      
   equation
      y = if u2 then
         u1
      else
         u3;
   end Switch;
   block Hysteresis "Transform Real to Boolean signal with Hysteresis"
      extends Blocks.Interfaces.partialBooleanBlockIcon;
      parameter Real uLow=0 "if y=true and u<=uLow, switch to y=false";
      parameter Real uHigh=1 "if y=false and u>=uHigh, switch to y=true";
      parameter Boolean pre_y_start=false "Value of pre(y) at initial time";
      Blocks.Interfaces.RealInput u annotation (Placement(transformation(x=-120.,y=0.,scale=0.2,aspectRatio=1.),iconTransformation(x=-120.,y=0.,scale=0.2,aspectRatio=1.)));
      Blocks.Interfaces.BooleanOutput y annotation (Placement(transformation(x=110.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=110.,y=0.,scale=0.1,aspectRatio=1.)));
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Polygon(points={{-65.,89.},{-73.,67.},{-57.,67.},{-65.,89.}},lineColor={192,192,192},fillColor={192,192,192},fillPattern=FillPattern.Solid),Line(points={{-65.,67.},{-65.,-81.}},color={192,192,192}),Line(points={{-90.,-70.},{82.,-70.}},color={192,192,192}),Polygon(points={{90.,-70.},{68.,-62.},{68.,-78.},{90.,-70.}},lineColor={192,192,192},fillColor={192,192,192},fillPattern=FillPattern.Solid),Text(extent={{70.,-80.},{94.,-100.}},textString="time",fillColor={160,160,160}),Text(extent={{-65.,93.},{-12.,75.}},fillColor={160,160,160},textString="y"),Line(points={{-80.,-70.},{30.,-70.}},color={0,0,0},thickness=0.5),Line(points={{-50.,10.},{80.,10.}},color={0,0,0},thickness=0.5),Line(points={{-50.,10.},{-50.,-70.}},color={0,0,0},thickness=0.5),Line(points={{30.,10.},{30.,-70.}},color={0,0,0},thickness=0.5),Line(points={{-10.,-65.},{0.,-70.},{-10.,-75.}},color={0,0,0},thickness=0.5),Line(points={{-10.,15.},{-20.,10.},{-10.,5.}},color={0,0,0},thickness=0.5),Line(points={{-55.,-20.},{-50.,-30.},{-44.,-20.}},color={0,0,0},thickness=0.5),Line(points={{25.,-30.},{30.,-19.},{35.,-30.}},color={0,0,0},thickness=0.5),Text(extent={{-99.,2.},{-70.,18.}},textString="true",fillColor={160,160,160}),Text(extent={{-98.,-87.},{-66.,-73.}},textString="false",fillColor={160,160,160}),Text(extent={{19.,-87.},{44.,-70.}},textString="uHigh",fillColor={0,0,0}),Text(extent={{-63.,-88.},{-38.,-71.}},textString="uLow",fillColor={0,0,0}),Line(points={{-69.,10.},{-60.,10.}},color={160,160,160})}),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Polygon(points={{-80.,90.},{-88.,68.},{-72.,68.},{-80.,90.}},lineColor={192,192,192},fillColor={192,192,192},fillPattern=FillPattern.Solid),Line(points={{-80.,68.},{-80.,-29.}},color={192,192,192}),Polygon(points={{92.,-29.},{70.,-21.},{70.,-37.},{92.,-29.}},lineColor={192,192,192},fillColor={192,192,192},fillPattern=FillPattern.Solid),Line(points={{-79.,-29.},{84.,-29.}},color={192,192,192}),Line(points={{-79.,-29.},{41.,-29.}},color={0,0,0}),Line(points={{-15.,-21.},{1.,-29.},{-15.,-36.}},color={0,0,0}),Line(points={{41.,51.},{41.,-29.}},color={0,0,0}),Line(points={{33.,3.},{41.,22.},{50.,3.}},color={0,0,0}),Line(points={{-49.,51.},{81.,51.}},color={0,0,0}),Line(points={{-4.,59.},{-19.,51.},{-4.,43.}},color={0,0,0}),Line(points={{-59.,29.},{-49.,11.},{-39.,29.}},color={0,0,0}),Line(points={{-49.,51.},{-49.,-29.}},color={0,0,0}),Text(extent={{-92.,-49.},{-9.,-92.}},textString="%uLow",fillColor={192,192,192}),Text(extent={{2.,-49.},{91.,-92.}},textString="%uHigh",fillColor={192,192,192}),Rectangle(extent={{-91.,-49.},{-8.,-92.}},lineColor={192,192,192}),Line(points={{-49.,-29.},{-49.,-49.}},color={192,192,192}),Rectangle(extent={{2.,-49.},{91.,-92.}},lineColor={192,192,192}),Line(points={{41.,-29.},{41.,-49.}},color={192,192,192})}),Documentation(info="<HTML>
 <p>
 This block transforms a <b>Real</b> input signal into a <b>Boolean</b>
 output signal:
 </p>
 <ul>
 <li> When the output was <b>false</b> and the input becomes
      <b>greater</b> than parameter <b>uHigh</b>, the output
      switches to <b>true</b>.</li>
 <li> When the output was <b>true</b> and the input becomes
      <b>less</b> than parameter <b>uLow</b>, the output
      switches to <b>false</b>.</li>
 </ul>
 <p>
 The start value of the output is defined via parameter
 <b>pre_y_start</b> (= value of pre(y) at initial time).
 The default value of this parameter is <b>false</b>.
 </p>
 </HTML>
 "));
      
   initial equation
      pre(y) = pre_y_start;
      
   equation
      y = u > uHigh or pre(y) and u >= uLow;
   end Hysteresis;

 

end Logical;