model HeatingMOSInverter "Heating MOS Inverter"
   extends Modelica.Icons.Example;
   Modelica.Electrical.Analog.Basic.Ground G annotation (Placement(transformation(x=-70.,y=-30.,scale=0.1,aspectRatio=1.),iconTransformation(x=-70.,y=-30.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Sources.SineVoltage Sin(V=5) annotation (Placement(transformation(x=-70.,y=0.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=-70.,y=0.,scale=0.1,aspectRatio=1.,rotation=270)));
   annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-100.,100.},{-6.,72.}},textString="Heating MOS Inverter",fillColor={0,0,255})}));
   Modelica.Electrical.Analog.Basic.Capacitor Capacitor1(C=0.00001) annotation (Placement(transformation(x=30.,y=10.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=30.,y=10.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Thermal.HeatTransfer.HeatCapacitor HeatCapacitor1(C=0.01) annotation (Placement(transformation(x=70.,y=-60.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=70.,y=-60.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Thermal.HeatTransfer.ThermalConductor TC1(G=0.01) annotation (Placement(transformation(x=10.,y=-40.,scale=0.1,aspectRatio=1.,rotation=0),iconTransformation(x=10.,y=-40.,scale=0.1,aspectRatio=1.,rotation=0)));
   Semiconductors.HeatingPMOS H_PMOS annotation (Placement(transformation(x=-30.,y=50.,scale=0.1,aspectRatio=1.),iconTransformation(x=-30.,y=50.,scale=0.1,aspectRatio=1.)));
   Semiconductors.HeatingNMOS H_NMOS annotation (Placement(transformation(x=-30.,y=10.,scale=0.1,aspectRatio=1.),iconTransformation(x=-30.,y=10.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Sources.RampVoltage V(V=5,duration=0.01) annotation (Placement(transformation(x=50.,y=50.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=50.,y=50.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Thermal.HeatTransfer.ThermalConductor TC2(G=0.01) annotation (Placement(transformation(x=10.,y=-80.,scale=0.1,aspectRatio=1.,rotation=0),iconTransformation(x=10.,y=-80.,scale=0.1,aspectRatio=1.,rotation=0)));
   Modelica.Thermal.HeatTransfer.FixedTemperature FixedTemperature1(T=300) annotation (Placement(transformation(x=88.,y=-28.,scale=0.1,aspectRatio=1.,rotation=180),iconTransformation(x=88.,y=-28.,scale=0.1,aspectRatio=1.,rotation=180)));
   Modelica.Thermal.HeatTransfer.ThermalConductor TC3(G=0.01) annotation (Placement(transformation(x=56.,y=-30.,scale=0.1,aspectRatio=1.,rotation=0),iconTransformation(x=56.,y=-30.,scale=0.1,aspectRatio=1.,rotation=0)));
   
equation
   connect(Sin.n, G.p) annotation (Line(points={{-70.,-10.},{-70.,-20.}},color={0,0,255}));
   connect(Capacitor1.n, G.p) annotation (Line(points={{30.,0.},{30.,-20.},{-70.,-20.}},color={0,0,255}));
   annotation (Documentation(info="<HTML>
 <P>
 The heating MOS inverter shows a heat flow always if a transistor is leading.
 </P>
 <P>
 Simulate until T=5 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 Sin.p.v  and  Capacitor1.p.v <br>
 HeatCapacitor1.port.T and H_PMOS.heatPort.T and H_NMOS.heatPort.T<br>
 H_PMOS.heatPort.Q_flow and H_NMOS.heatPort.Q_flow<br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 6, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=5));
   connect(H_NMOS.G, H_PMOS.G) annotation (Line(points={{-40.,5.},{-40.,45.}},color={0,0,255}));
   connect(H_NMOS.G, Sin.p) annotation (Line(points={{-40.,5.},{-40.,10.},{-70.,10.}},color={0,0,255}));
   connect(H_PMOS.S, H_NMOS.D) annotation (Line(points={{-20.,45.},{-20.,15.}},color={0,0,255}));
   connect(H_NMOS.D, Capacitor1.p) annotation (Line(points={{-20.,15.},{-20.,20.},{30.,20.}},color={0,0,255}));
   connect(H_NMOS.B, H_NMOS.S) annotation (Line(points={{-20.,10.},{-20.,5.}},color={0,0,255}));
   connect(H_NMOS.S, G.p) annotation (Line(points={{-20.,5.},{-20.,-20.},{-70.,-20.}},color={0,0,255}));
   connect(H_PMOS.B, H_PMOS.D) annotation (Line(points={{-20.,50.},{-20.,55.}},color={0,0,255}));
   connect(V.p, H_PMOS.D) annotation (Line(points={{50.,60.},{-20.,60.},{-20.,55.}},color={0,0,255}));
   connect(V.n, G.p) annotation (Line(points={{50.,40.},{50.,-20.},{-70.,-20.}},color={0,0,255}));
   connect(TC1.port_b, HeatCapacitor1.port) annotation (Line(points={{21.,-40.},{40.,-40.},{40.,-60.},{60.,-60.}},color={191,0,0}));
   connect(TC2.port_b, HeatCapacitor1.port) annotation (Line(points={{21.,-80.},{40.,-80.},{40.,-60.},{60.,-60.}},color={191,0,0}));
   connect(TC1.port_a, H_PMOS.heatPort) annotation (Line(points={{-1.,-40.},{-10.,-40.},{-10.,40.},{-30.,40.}},color={191,0,0}));
   connect(TC2.port_a, H_NMOS.heatPort) annotation (Line(points={{-1.,-80.},{-30.,-80.},{-30.,0.}},color={191,0,0}));
   connect(TC3.port_b, FixedTemperature1.port) annotation (Line(points={{67.,-30.},{70.,-30.},{70.,-28.},{77.,-28.}},color={191,0,0}));
   connect(TC3.port_a, HeatCapacitor1.port) annotation (Line(points={{45.,-30.},{52.,-30.},{52.,-60.},{60.,-60.}},color={191,0,0}));
end HeatingMOSInverter;