model Circuito
  parameter Real referencia =5;
  parameter Real offset =0.5;
  Boolean control_sw (start = false);
  Modelica.Electrical.Analog.Basic.Resistor R1(R=0.1);
  Modelica.Electrical.Analog.Basic.Capacitor C1(C=0.01);
  Modelica.Electrical.Analog.Basic.Resistor R2(R=1);
  Modelica.Electrical.Analog.Basic.Capacitor C2(C=0.01);
  Modelica.Electrical.Analog.Sources.ConstantVoltage Vin(V=10);
  Modelica.Electrical.Analog.Ideal.IdealCommutingSwitch SW;
  Modelica.Electrical.Analog.Basic.Ground G;
equation
  connect(Vin.p,SW.p);
  connect(SW.control,control_sw);
  connect(SW.n2,R2.p);
  connect(SW.n1,R1.p);
  connect(R1.n ,G.p);
  connect(R2.n,G.p);
  connect(C1.p,R1.p);
  connect(C1.n,G.p);
  connect(Vin.n,G.p);
  connect(C2.p,R2.p);
  connect(C2.n,G.p );
algorithm
  //referencia:=sin(2*3.141592354*10*time);
  if C1.v > referencia+offset then
    control_sw:=true;
  end if;
  if C1.v < referencia-offset then
    control_sw:=false;
  end if;
end Circuito;
