functor LrValsFun(structure Token : TOKEN 
			    ) = 
struct
structure ParserData=
struct
structure Header = 
struct
(* DO NOT CHANGE THIS FILE -- this file was generated from cd.grm *)

(* Copyright (c) 1998 by Lucent Technologies *)

(* new comments from Satish Chandra, 6/21/99 *)
(* Overriding design approach: 
 *
 * Accept all legal programs, but possibly some illegal ones at this stage. 
 * Do not attempt to make a really tight grammar. Our tools are supposed to
 * work on "correct" C programs (i.e. those that cc -ansi would compile without
 * warnings). Of course, a type checker on the parse tree can report some errors
 * as syntax errors.
 *
 * Note on MARK:
 *
 * externalDecl, statement, and expression are the non-terms that are marked.
 * Compound statements are not separately marked.
 * declarations eventually become either a statement or a externalDecl
 *   if they are outside any function. They are marked accordingly.
 *
 * Note on function definitions:
 *
 * The order of the paramaters will always come from the FuncDecr.
 * The types of the parameter may come from the second declaration list  
 * (in K&R style)
 *
 * Note on the structure of the grammar:
 *
 * It is difficult to write a LALR(1) grammar based on the grammar given at
 * the back of the K&R book. The basic difficulty is that both TYPE_NAME and
 * ID are tokens that are strings, but it depends on the context whether
 * a given string is to be treated as an ID or a TYPE_NAME.
 * We have borrowed the solution used in GCC's parser specification. In this
 * scheme, the lexer always return the token TYPE_NAME if a name has been 
 * defined as a type name (via a typedef) in an applicable scope. The grammar 
 * productions are heavily rearranged (from K&R's grammar) to do the right 
 * thing. In this rearrangement, the basic idea is that a TYPE_NAME is  
 * allowed to appear in a declaration as a plain identifier only after a type 
 * specifier has previously appeared in the declaration. Also, a TYPE_NAME may 
 * appear only once in a declaration as a type specifier.
 *)

(* old comments below *)
(* Shortcomings *)
(* 1. No floating-point whatsoever *)

(* Notes on MARK:
 * externalDecl and statement are the non-terms that are marked.
 * Compound statements are not separately marked.
 * expressions are not marked at all.
 * declarations eventually become either a statement or a externalDecl
 *   if they are outside any function. they are marked accordingly.
 *)
 
(* Overriding theme: accept all legal programs, but also some illegal ones at this
 * stage. Do not attempt to make a really tight grammar. Our tools are supposed to
 * work on "correct" C programs (i.e. those that cc -ansi would compile without
 * warnings). Of course, a type checker on the parse tree can report some errors
 * as syntax errors.
 *)

(* About function definitions:
 * The order of the paramaters will always come from the FuncDecr thing 
 * The types of the parameter may come from the second declaration list  (in K&R style)
 *)

open ParseTree (* PortingHelp *)

fun markExternalDecl srcMap (d,left,right) = 
    MARKexternalDecl(SourceMap.location srcMap (left,right), d)

fun markDeclaration srcMap (d,left,right) = 
    MARKdeclaration(SourceMap.location srcMap (left,right), d)

fun markDeclarator srcMap (d,left,right) = 
    MARKdeclarator(SourceMap.location srcMap (left,right), d)

fun markStatement srcMap (s,left,right) = 
    MARKstatement(SourceMap.location srcMap (left, right), s)

fun markExpression srcMap (s,left,right) = 
    MARKexpression(SourceMap.location srcMap (left, right), s)

val unknown = {storage=[],qualifiers=[],specifiers=[]}:decltype

(* this code duplicated in BuildAst in function processDeclarator *)
fun ctypeDecrToTypeName (typ as {qualifiers, specifiers},decr) =
      let fun mkTyp spc = {qualifiers=[], specifiers=[spc]}
	  fun addQual q = {qualifiers=q::qualifiers, specifiers=specifiers}
       in case decr
	    of VarDecr x => (typ,SOME x)
	     | PointerDecr x =>
		ctypeDecrToTypeName (mkTyp (Pointer typ),x)
	     | ArrayDecr (x,sz) =>
		ctypeDecrToTypeName (mkTyp (Array (sz,typ)),x)
	     | FuncDecr (x,lst) =>
		ctypeDecrToTypeName (mkTyp (Function{retType=typ,params=lst}),x)
	     | QualDecr (q,decr) =>
		ctypeDecrToTypeName (addQual q, decr)
	     | EmptyDecr => (typ, NONE)
	     | EllipsesDecr => (mkTyp Ellipses, SOME("**ellipses**"))
	     | DecrExt _ => (typ, NONE)  (* should call decr extension? *)
	     | MARKdeclarator(loc, decr) => ctypeDecrToTypeName(typ, decr)
      end

fun dclr2str dcl = 
  (case ctypeDecrToTypeName ({qualifiers=[],specifiers=[]}, dcl)
     of (_,SOME s) => s
      | (_,NONE) => "")

fun combineDecltypes ( {qualifiers=q1,storage=st1,specifiers=sp1}
	           , {qualifiers=q2,storage=st2,specifiers=sp2}
	           ) =
  {qualifiers=q1@q2,storage=st1@st2,specifiers=sp1@sp2}  (* @ ok *)

fun applyPointer (PointerDecr x,rest) = PointerDecr (applyPointer (x,rest))
  | applyPointer (QualDecr (q,x),rest) = QualDecr (q, applyPointer (x,rest))
  | applyPointer (EmptyDecr, rest) = rest
  | applyPointer (_, rest) = rest  
    (* NCH/DBM[6/14/99]: this case can never occur  *)

fun addStorage(st, {qualifiers,storage,specifiers}) =
        {qualifiers=qualifiers,storage=st::storage,specifiers=specifiers}

fun addQualifiers(qs, {qualifiers,storage,specifiers}) =
	{qualifiers=qs@qualifiers,storage=storage,specifiers=specifiers} (* @ ok *)

fun addQualifier(q, {qualifiers,storage,specifiers}) =
	{qualifiers=q::qualifiers,storage=storage,specifiers=specifiers}

fun addSpecifier(sp, {qualifiers,storage,specifiers}) =
	{qualifiers=qualifiers,storage=storage,specifiers=sp::specifiers}

val addAll = combineDecltypes

fun loopQd (q::rst, acc) = loopQd(rst, QualDecr(q, acc))
  | loopQd (nil, acc) = acc

fun mkCtype typ = typ

(* DBM: major kludge, using TYPEDEF as storage class *)
fun insertDeclNames ({storage,...}: decltype, idl) =
    case storage
      of [TYPEDEF] =>  List.app (fn x as (dcl,_) => TypeDefs.addTdef (dclr2str dcl)) idl
       | _ => List.app (fn x as (dcl,_) => TypeDefs.addNoTdef (dclr2str dcl)) idl

fun insertFuncName dcl =
  let
    val name = dclr2str dcl
  in
    TypeDefs.addNoTdef name
  end

fun insertFuncParams (FuncDecr (_,params)) : unit = 
     let
       fun getName (ct, dclr) = dclr2str dclr
       val names = map getName params
     in
       List.app TypeDefs.addNoTdef names
     end
  | insertFuncParams (ArrayDecr(dcl,_)) = insertFuncParams dcl
  | insertFuncParams (PointerDecr dcl) = insertFuncParams dcl
  | insertFuncParams _ = ()  (* this is actually an error, but it will be caught in
		              * BuildAst when processing a PT.FunctionDef *)

abstype 'a seq = SEQ of 'a list
with val emptySeq = SEQ nil
     fun singletonSeq x = SEQ[x]
     fun addToSeq(x, SEQ yl) = SEQ(x :: yl)  (* add to end of sequence! *)
  (* fun addListToEnd(xl, yl) = SEQ((List.rev xl) @ yl) *)
     fun addOptToEnd(NONE, yl) = yl
       | addOptToEnd(SOME x, SEQ yl) = SEQ(x :: yl)
     fun seqToList(SEQ yl) = List.rev yl
end


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\000\000\000\000\
\\001\000\002\000\169\000\004\000\070\000\022\000\042\000\026\000\041\000\
\\089\000\069\000\000\000\
\\001\000\002\000\174\000\004\000\043\000\022\000\042\000\026\000\041\000\
\\071\000\034\000\072\000\033\000\073\000\032\000\074\000\031\000\
\\075\000\030\000\076\000\029\000\077\000\028\000\080\000\027\000\
\\081\000\026\000\082\000\025\000\083\000\024\000\084\000\023\000\
\\089\000\021\000\000\000\
\\001\000\002\000\226\000\000\000\
\\001\000\002\000\075\001\011\000\178\000\000\000\
\\001\000\002\000\115\001\011\000\178\000\000\000\
\\001\000\003\000\083\002\006\000\130\002\011\000\083\002\027\000\139\000\
\\052\000\130\002\053\000\130\002\054\000\130\002\055\000\130\002\
\\056\000\130\002\057\000\130\002\071\000\130\002\072\000\130\002\
\\073\000\130\002\074\000\130\002\075\000\130\002\076\000\130\002\
\\077\000\130\002\080\000\130\002\081\000\130\002\082\000\130\002\
\\083\000\130\002\084\000\130\002\086\000\130\002\089\000\130\002\000\000\
\\001\000\003\000\087\002\006\000\131\002\011\000\087\002\027\000\135\000\
\\052\000\131\002\053\000\131\002\054\000\131\002\055\000\131\002\
\\056\000\131\002\057\000\131\002\071\000\131\002\072\000\131\002\
\\073\000\131\002\074\000\131\002\075\000\131\002\076\000\131\002\
\\077\000\131\002\080\000\131\002\081\000\131\002\082\000\131\002\
\\083\000\131\002\084\000\131\002\086\000\131\002\089\000\131\002\000\000\
\\001\000\003\000\048\000\000\000\
\\001\000\003\000\127\000\004\000\126\000\006\000\054\000\007\000\194\001\
\\014\000\125\000\016\000\124\000\018\000\123\000\019\000\122\000\
\\021\000\121\000\022\000\120\000\023\000\119\000\024\000\118\000\
\\026\000\117\000\048\000\116\000\049\000\115\000\050\000\114\000\
\\051\000\113\000\052\000\156\002\053\000\156\002\054\000\156\002\
\\055\000\156\002\056\000\156\002\057\000\156\002\058\000\112\000\
\\061\000\111\000\062\000\110\000\063\000\109\000\064\000\108\000\
\\065\000\107\000\066\000\106\000\067\000\105\000\068\000\104\000\
\\069\000\103\000\070\000\102\000\071\000\156\002\072\000\156\002\
\\073\000\156\002\074\000\156\002\075\000\156\002\076\000\156\002\
\\077\000\156\002\080\000\156\002\081\000\156\002\082\000\156\002\
\\083\000\156\002\084\000\156\002\085\000\101\000\086\000\156\002\
\\089\000\156\002\000\000\
\\001\000\003\000\127\000\004\000\126\000\006\000\054\000\014\000\125\000\
\\016\000\124\000\018\000\123\000\019\000\122\000\021\000\121\000\
\\022\000\120\000\023\000\119\000\024\000\118\000\026\000\117\000\
\\048\000\116\000\049\000\115\000\050\000\114\000\051\000\113\000\
\\058\000\112\000\061\000\111\000\062\000\110\000\063\000\109\000\
\\064\000\108\000\065\000\107\000\066\000\106\000\067\000\105\000\
\\068\000\104\000\069\000\103\000\070\000\102\000\085\000\101\000\000\000\
\\001\000\003\000\179\000\011\000\178\000\000\000\
\\001\000\003\000\221\000\000\000\
\\001\000\003\000\222\000\000\000\
\\001\000\003\000\021\001\011\000\020\001\000\000\
\\001\000\003\000\025\001\011\000\024\001\000\000\
\\001\000\003\000\071\001\000\000\
\\001\000\003\000\072\001\000\000\
\\001\000\003\000\124\001\000\000\
\\001\000\003\000\159\001\000\000\
\\001\000\003\000\161\001\000\000\
\\001\000\004\000\043\000\022\000\042\000\026\000\041\000\000\000\
\\001\000\004\000\043\000\022\000\042\000\026\000\041\000\052\000\040\000\
\\053\000\039\000\054\000\038\000\055\000\037\000\056\000\036\000\
\\057\000\035\000\071\000\034\000\072\000\033\000\073\000\032\000\
\\074\000\031\000\075\000\030\000\076\000\029\000\077\000\028\000\
\\080\000\027\000\081\000\026\000\082\000\025\000\083\000\024\000\
\\084\000\023\000\086\000\022\000\089\000\021\000\000\000\
\\001\000\004\000\043\000\026\000\041\000\000\000\
\\001\000\004\000\070\000\022\000\042\000\026\000\041\000\089\000\069\000\000\000\
\\001\000\004\000\070\000\026\000\041\000\089\000\069\000\000\000\
\\001\000\004\000\126\000\005\000\069\001\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\126\000\006\000\242\000\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\126\000\009\000\145\000\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\126\000\009\000\245\000\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\126\000\009\000\098\001\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\126\000\009\000\130\001\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\126\000\009\000\137\001\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\126\000\014\000\125\000\016\000\124\000\018\000\123\000\
\\019\000\122\000\021\000\121\000\022\000\120\000\023\000\119\000\
\\024\000\118\000\026\000\144\000\048\000\116\000\049\000\115\000\
\\050\000\114\000\051\000\113\000\056\000\036\000\057\000\035\000\
\\071\000\034\000\072\000\033\000\073\000\032\000\074\000\031\000\
\\075\000\030\000\076\000\029\000\077\000\028\000\080\000\027\000\
\\081\000\026\000\082\000\025\000\083\000\024\000\084\000\023\000\
\\085\000\101\000\089\000\021\000\000\000\
\\001\000\004\000\126\000\014\000\125\000\016\000\124\000\018\000\123\000\
\\019\000\122\000\021\000\121\000\022\000\120\000\023\000\119\000\
\\024\000\118\000\026\000\144\000\048\000\116\000\049\000\115\000\
\\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\215\000\008\000\214\000\009\000\252\000\010\000\213\000\
\\012\000\212\000\013\000\211\000\014\000\210\000\015\000\209\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\020\000\205\000\
\\022\000\204\000\023\000\203\000\024\000\202\000\025\000\201\000\
\\027\000\200\000\028\000\199\000\029\000\198\000\030\000\197\000\
\\031\000\196\000\032\000\195\000\033\000\194\000\034\000\193\000\
\\035\000\192\000\036\000\191\000\037\000\190\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\042\000\185\000\
\\043\000\184\000\044\000\183\000\045\000\182\000\046\000\181\000\
\\047\000\180\000\000\000\
\\001\000\004\000\215\000\008\000\214\000\009\000\088\001\010\000\213\000\
\\012\000\212\000\013\000\211\000\014\000\210\000\015\000\209\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\020\000\205\000\
\\022\000\204\000\023\000\203\000\024\000\202\000\025\000\201\000\
\\027\000\200\000\028\000\199\000\029\000\198\000\030\000\197\000\
\\031\000\196\000\032\000\195\000\033\000\194\000\034\000\193\000\
\\035\000\192\000\036\000\191\000\037\000\190\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\042\000\185\000\
\\043\000\184\000\044\000\183\000\045\000\182\000\046\000\181\000\
\\047\000\180\000\000\000\
\\001\000\004\000\215\000\008\000\214\000\009\000\133\001\010\000\213\000\
\\012\000\212\000\013\000\211\000\014\000\210\000\015\000\209\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\020\000\205\000\
\\022\000\204\000\023\000\203\000\024\000\202\000\025\000\201\000\
\\027\000\200\000\028\000\199\000\029\000\198\000\030\000\197\000\
\\031\000\196\000\032\000\195\000\033\000\194\000\034\000\193\000\
\\035\000\192\000\036\000\191\000\037\000\190\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\042\000\185\000\
\\043\000\184\000\044\000\183\000\045\000\182\000\046\000\181\000\
\\047\000\180\000\000\000\
\\001\000\004\000\215\000\008\000\214\000\009\000\153\001\010\000\213\000\
\\012\000\212\000\013\000\211\000\014\000\210\000\015\000\209\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\020\000\205\000\
\\022\000\204\000\023\000\203\000\024\000\202\000\025\000\201\000\
\\027\000\200\000\028\000\199\000\029\000\198\000\030\000\197\000\
\\031\000\196\000\032\000\195\000\033\000\194\000\034\000\193\000\
\\035\000\192\000\036\000\191\000\037\000\190\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\042\000\185\000\
\\043\000\184\000\044\000\183\000\045\000\182\000\046\000\181\000\
\\047\000\180\000\000\000\
\\001\000\004\000\215\000\008\000\214\000\009\000\155\001\010\000\213\000\
\\012\000\212\000\013\000\211\000\014\000\210\000\015\000\209\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\020\000\205\000\
\\022\000\204\000\023\000\203\000\024\000\202\000\025\000\201\000\
\\027\000\200\000\028\000\199\000\029\000\198\000\030\000\197\000\
\\031\000\196\000\032\000\195\000\033\000\194\000\034\000\193\000\
\\035\000\192\000\036\000\191\000\037\000\190\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\042\000\185\000\
\\043\000\184\000\044\000\183\000\045\000\182\000\046\000\181\000\
\\047\000\180\000\000\000\
\\001\000\004\000\219\000\014\000\125\000\016\000\124\000\018\000\123\000\
\\019\000\122\000\021\000\121\000\022\000\120\000\023\000\119\000\
\\024\000\118\000\026\000\144\000\048\000\116\000\049\000\115\000\
\\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\001\000\004\000\225\000\000\000\
\\001\000\004\000\228\000\000\000\
\\001\000\004\000\230\000\000\000\
\\001\000\004\000\231\000\000\000\
\\001\000\004\000\006\001\005\000\101\001\008\000\005\001\022\000\042\000\
\\026\000\041\000\052\000\040\000\053\000\039\000\054\000\038\000\
\\055\000\037\000\056\000\036\000\057\000\035\000\071\000\034\000\
\\072\000\033\000\073\000\032\000\074\000\031\000\075\000\030\000\
\\076\000\029\000\077\000\028\000\080\000\027\000\081\000\026\000\
\\082\000\025\000\083\000\024\000\084\000\023\000\086\000\022\000\
\\089\000\021\000\000\000\
\\001\000\004\000\006\001\008\000\005\001\022\000\042\000\026\000\041\000\
\\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\086\000\022\000\089\000\021\000\000\000\
\\001\000\004\000\083\001\005\000\101\001\008\000\005\001\022\000\042\000\
\\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\086\000\022\000\089\000\021\000\000\000\
\\001\000\004\000\123\001\000\000\
\\001\000\005\000\153\000\026\000\152\000\052\000\040\000\053\000\039\000\
\\054\000\038\000\055\000\037\000\056\000\036\000\057\000\035\000\
\\071\000\034\000\072\000\033\000\073\000\032\000\074\000\031\000\
\\075\000\030\000\076\000\029\000\077\000\028\000\080\000\027\000\
\\081\000\026\000\082\000\025\000\083\000\024\000\084\000\023\000\
\\086\000\022\000\089\000\021\000\000\000\
\\001\000\005\000\161\000\000\000\
\\001\000\005\000\248\000\026\000\152\000\052\000\040\000\053\000\039\000\
\\054\000\038\000\055\000\037\000\056\000\036\000\057\000\035\000\
\\071\000\034\000\072\000\033\000\073\000\032\000\074\000\031\000\
\\075\000\030\000\076\000\029\000\077\000\028\000\080\000\027\000\
\\081\000\026\000\082\000\025\000\083\000\024\000\084\000\023\000\
\\086\000\022\000\089\000\021\000\000\000\
\\001\000\005\000\251\000\000\000\
\\001\000\005\000\253\000\000\000\
\\001\000\005\000\000\001\011\000\255\000\000\000\
\\001\000\005\000\084\001\000\000\
\\001\000\005\000\085\001\011\000\178\000\000\000\
\\001\000\005\000\089\001\000\000\
\\001\000\005\000\090\001\011\000\255\000\000\000\
\\001\000\005\000\118\001\011\000\117\001\000\000\
\\001\000\005\000\119\001\000\000\
\\001\000\005\000\120\001\011\000\178\000\000\000\
\\001\000\005\000\122\001\011\000\178\000\000\000\
\\001\000\005\000\125\001\011\000\178\000\000\000\
\\001\000\005\000\132\001\052\000\040\000\053\000\039\000\054\000\038\000\
\\055\000\037\000\056\000\036\000\057\000\035\000\071\000\034\000\
\\072\000\033\000\073\000\032\000\074\000\031\000\075\000\030\000\
\\076\000\029\000\077\000\028\000\080\000\027\000\081\000\026\000\
\\082\000\025\000\083\000\024\000\084\000\023\000\086\000\022\000\
\\089\000\021\000\000\000\
\\001\000\005\000\134\001\000\000\
\\001\000\005\000\135\001\000\000\
\\001\000\005\000\140\001\026\000\152\000\052\000\040\000\053\000\039\000\
\\054\000\038\000\055\000\037\000\056\000\036\000\057\000\035\000\
\\071\000\034\000\072\000\033\000\073\000\032\000\074\000\031\000\
\\075\000\030\000\076\000\029\000\077\000\028\000\080\000\027\000\
\\081\000\026\000\082\000\025\000\083\000\024\000\084\000\023\000\
\\086\000\022\000\089\000\021\000\000\000\
\\001\000\005\000\154\001\000\000\
\\001\000\005\000\156\001\000\000\
\\001\000\005\000\157\001\011\000\255\000\000\000\
\\001\000\005\000\158\001\011\000\178\000\000\000\
\\001\000\005\000\164\001\000\000\
\\001\000\006\000\047\000\026\000\046\000\089\000\045\000\000\000\
\\001\000\006\000\054\000\052\000\040\000\053\000\039\000\054\000\038\000\
\\055\000\037\000\056\000\036\000\057\000\035\000\071\000\034\000\
\\072\000\033\000\073\000\032\000\074\000\031\000\075\000\030\000\
\\076\000\029\000\077\000\028\000\080\000\027\000\081\000\026\000\
\\082\000\025\000\083\000\024\000\084\000\023\000\086\000\022\000\
\\089\000\021\000\000\000\
\\001\000\006\000\076\000\026\000\075\000\089\000\074\000\000\000\
\\001\000\007\000\165\000\056\000\036\000\057\000\035\000\071\000\034\000\
\\072\000\033\000\073\000\032\000\074\000\031\000\075\000\030\000\
\\076\000\029\000\077\000\028\000\080\000\027\000\081\000\026\000\
\\082\000\025\000\083\000\024\000\084\000\023\000\089\000\021\000\000\000\
\\001\000\007\000\217\000\000\000\
\\001\000\007\000\018\001\056\000\036\000\057\000\035\000\071\000\034\000\
\\072\000\033\000\073\000\032\000\074\000\031\000\075\000\030\000\
\\076\000\029\000\077\000\028\000\080\000\027\000\081\000\026\000\
\\082\000\025\000\083\000\024\000\084\000\023\000\089\000\021\000\000\000\
\\001\000\007\000\019\001\056\000\036\000\057\000\035\000\071\000\034\000\
\\072\000\033\000\073\000\032\000\074\000\031\000\075\000\030\000\
\\076\000\029\000\077\000\028\000\080\000\027\000\081\000\026\000\
\\082\000\025\000\083\000\024\000\084\000\023\000\089\000\021\000\000\000\
\\001\000\007\000\107\001\000\000\
\\001\000\007\000\141\001\000\000\
\\001\000\007\000\142\001\000\000\
\\001\000\007\000\143\001\000\000\
\\001\000\007\000\151\001\000\000\
\\001\000\009\000\116\001\011\000\178\000\000\000\
\\001\000\026\000\158\000\000\000\
\\001\000\026\000\220\000\000\000\
\\001\000\026\000\054\001\089\000\053\001\000\000\
\\001\000\026\000\065\001\089\000\064\001\000\000\
\\001\000\026\000\093\001\000\000\
\\001\000\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\086\000\022\000\088\000\092\001\
\\089\000\021\000\000\000\
\\001\000\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\086\000\022\000\089\000\021\000\000\000\
\\001\000\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\089\000\021\000\000\000\
\\001\000\066\000\077\001\000\000\
\\001\000\071\000\034\000\072\000\033\000\073\000\032\000\074\000\031\000\
\\075\000\030\000\076\000\029\000\077\000\028\000\080\000\027\000\
\\081\000\026\000\082\000\025\000\083\000\024\000\084\000\023\000\
\\089\000\021\000\000\000\
\\167\001\003\000\044\000\004\000\043\000\022\000\042\000\026\000\041\000\
\\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\086\000\022\000\089\000\021\000\000\000\
\\168\001\000\000\
\\169\001\000\000\
\\170\001\000\000\
\\171\001\000\000\
\\172\001\000\000\
\\173\001\000\000\
\\174\001\000\000\
\\175\001\000\000\
\\176\001\000\000\
\\177\001\000\000\
\\178\001\000\000\
\\179\001\000\000\
\\180\001\000\000\
\\181\001\000\000\
\\182\001\000\000\
\\183\001\000\000\
\\184\001\000\000\
\\185\001\060\000\160\001\000\000\
\\186\001\000\000\
\\187\001\000\000\
\\188\001\000\000\
\\189\001\000\000\
\\190\001\004\000\070\000\022\000\042\000\026\000\041\000\089\000\069\000\000\000\
\\191\001\011\000\141\000\000\000\
\\192\001\011\000\136\000\000\000\
\\193\001\003\000\127\000\004\000\126\000\006\000\054\000\014\000\125\000\
\\016\000\124\000\018\000\123\000\019\000\122\000\021\000\121\000\
\\022\000\120\000\023\000\119\000\024\000\118\000\026\000\117\000\
\\048\000\116\000\049\000\115\000\050\000\114\000\051\000\113\000\
\\058\000\112\000\061\000\111\000\062\000\110\000\063\000\109\000\
\\064\000\108\000\065\000\107\000\066\000\106\000\067\000\105\000\
\\068\000\104\000\069\000\103\000\070\000\102\000\085\000\101\000\000\000\
\\194\001\003\000\127\000\004\000\126\000\006\000\054\000\014\000\125\000\
\\016\000\124\000\018\000\123\000\019\000\122\000\021\000\121\000\
\\022\000\120\000\023\000\119\000\024\000\118\000\026\000\117\000\
\\048\000\116\000\049\000\115\000\050\000\114\000\051\000\113\000\
\\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\058\000\112\000\061\000\111\000\
\\062\000\110\000\063\000\109\000\064\000\108\000\065\000\107\000\
\\066\000\106\000\067\000\105\000\068\000\104\000\069\000\103\000\
\\070\000\102\000\071\000\034\000\072\000\033\000\073\000\032\000\
\\074\000\031\000\075\000\030\000\076\000\029\000\077\000\028\000\
\\080\000\027\000\081\000\026\000\082\000\025\000\083\000\024\000\
\\084\000\023\000\085\000\101\000\086\000\022\000\089\000\021\000\000\000\
\\195\001\000\000\
\\196\001\000\000\
\\197\001\000\000\
\\198\001\000\000\
\\199\001\000\000\
\\200\001\000\000\
\\201\001\000\000\
\\202\001\000\000\
\\203\001\000\000\
\\204\001\000\000\
\\205\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\042\000\185\000\
\\043\000\184\000\044\000\183\000\045\000\182\000\046\000\181\000\
\\047\000\180\000\000\000\
\\206\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\207\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\208\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\209\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\210\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\211\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\212\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\213\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\214\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\215\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\216\001\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\217\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\014\000\210\000\015\000\209\000\017\000\208\000\018\000\207\000\
\\019\000\206\000\020\000\205\000\022\000\204\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\218\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\014\000\210\000\015\000\209\000\017\000\208\000\018\000\207\000\
\\019\000\206\000\020\000\205\000\022\000\204\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\046\000\181\000\047\000\180\000\000\000\
\\219\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\014\000\210\000\017\000\208\000\018\000\207\000\019\000\206\000\
\\020\000\205\000\022\000\204\000\023\000\203\000\024\000\202\000\
\\025\000\201\000\038\000\189\000\039\000\188\000\040\000\187\000\
\\041\000\186\000\042\000\185\000\043\000\184\000\046\000\181\000\
\\047\000\180\000\000\000\
\\220\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\014\000\210\000\017\000\208\000\018\000\207\000\019\000\206\000\
\\022\000\204\000\023\000\203\000\024\000\202\000\025\000\201\000\
\\038\000\189\000\039\000\188\000\040\000\187\000\041\000\186\000\
\\042\000\185\000\043\000\184\000\046\000\181\000\047\000\180\000\000\000\
\\221\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\042\000\185\000\
\\043\000\184\000\046\000\181\000\047\000\180\000\000\000\
\\222\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\046\000\181\000\
\\047\000\180\000\000\000\
\\223\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\038\000\189\000\
\\039\000\188\000\040\000\187\000\041\000\186\000\046\000\181\000\
\\047\000\180\000\000\000\
\\224\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\046\000\181\000\
\\047\000\180\000\000\000\
\\225\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\046\000\181\000\
\\047\000\180\000\000\000\
\\226\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\046\000\181\000\
\\047\000\180\000\000\000\
\\227\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\046\000\181\000\
\\047\000\180\000\000\000\
\\228\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\000\000\
\\229\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\018\000\207\000\019\000\206\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\000\000\
\\230\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\022\000\204\000\023\000\203\000\024\000\202\000\
\\025\000\201\000\000\000\
\\231\001\004\000\215\000\008\000\214\000\010\000\213\000\013\000\211\000\
\\017\000\208\000\022\000\204\000\023\000\203\000\024\000\202\000\
\\025\000\201\000\000\000\
\\232\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\233\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\234\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\235\001\000\000\
\\236\001\000\000\
\\237\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\238\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\239\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\240\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\241\001\004\000\215\000\008\000\214\000\010\000\213\000\023\000\203\000\
\\024\000\202\000\025\000\201\000\000\000\
\\242\001\004\000\126\000\016\000\124\000\021\000\121\000\023\000\119\000\
\\024\000\118\000\026\000\144\000\048\000\116\000\049\000\115\000\
\\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\243\001\000\000\
\\244\001\000\000\
\\245\001\000\000\
\\246\001\000\000\
\\247\001\000\000\
\\248\001\000\000\
\\249\001\000\000\
\\250\001\000\000\
\\251\001\000\000\
\\252\001\000\000\
\\253\001\000\000\
\\254\001\000\000\
\\254\001\002\000\233\000\000\000\
\\255\001\000\000\
\\000\002\050\000\114\000\000\000\
\\001\002\000\000\
\\002\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\003\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\004\002\004\000\126\000\014\000\125\000\016\000\124\000\018\000\123\000\
\\019\000\122\000\021\000\121\000\022\000\120\000\023\000\119\000\
\\024\000\118\000\026\000\144\000\048\000\116\000\049\000\115\000\
\\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\005\002\011\000\178\000\000\000\
\\006\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\007\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\008\002\004\000\083\001\008\000\005\001\022\000\042\000\000\000\
\\009\002\000\000\
\\010\002\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\086\000\022\000\000\000\
\\011\002\052\000\040\000\053\000\039\000\054\000\038\000\055\000\037\000\
\\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\086\000\022\000\000\000\
\\012\002\000\000\
\\013\002\000\000\
\\014\002\000\000\
\\015\002\000\000\
\\016\002\000\000\
\\017\002\000\000\
\\018\002\000\000\
\\019\002\000\000\
\\020\002\000\000\
\\021\002\000\000\
\\022\002\000\000\
\\023\002\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\000\000\
\\024\002\056\000\036\000\057\000\035\000\071\000\034\000\072\000\033\000\
\\073\000\032\000\074\000\031\000\075\000\030\000\076\000\029\000\
\\077\000\028\000\080\000\027\000\081\000\026\000\082\000\025\000\
\\083\000\024\000\084\000\023\000\000\000\
\\025\002\000\000\
\\026\002\000\000\
\\027\002\056\000\036\000\057\000\035\000\000\000\
\\028\002\000\000\
\\029\002\000\000\
\\030\002\000\000\
\\031\002\000\000\
\\032\002\000\000\
\\033\002\000\000\
\\034\002\000\000\
\\035\002\000\000\
\\036\002\000\000\
\\037\002\000\000\
\\038\002\000\000\
\\039\002\000\000\
\\040\002\000\000\
\\041\002\000\000\
\\042\002\000\000\
\\043\002\000\000\
\\044\002\000\000\
\\045\002\006\000\082\000\000\000\
\\046\002\006\000\081\000\000\000\
\\047\002\000\000\
\\048\002\000\000\
\\049\002\000\000\
\\050\002\000\000\
\\051\002\000\000\
\\052\002\000\000\
\\053\002\000\000\
\\054\002\000\000\
\\055\002\000\000\
\\056\002\000\000\
\\057\002\002\000\022\001\000\000\
\\058\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\059\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\060\002\002\000\027\001\000\000\
\\061\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\062\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\063\002\000\000\
\\064\002\000\000\
\\065\002\000\000\
\\066\002\000\000\
\\067\002\000\000\
\\068\002\006\000\155\000\000\000\
\\069\002\006\000\154\000\000\000\
\\070\002\000\000\
\\071\002\000\000\
\\072\002\027\000\017\001\000\000\
\\073\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\074\002\000\000\
\\075\002\000\000\
\\076\002\000\000\
\\077\002\000\000\
\\078\002\000\000\
\\079\002\011\000\016\001\000\000\
\\079\002\011\000\128\001\000\000\
\\080\002\004\000\126\000\006\000\242\000\014\000\125\000\016\000\124\000\
\\018\000\123\000\019\000\122\000\021\000\121\000\022\000\120\000\
\\023\000\119\000\024\000\118\000\026\000\144\000\048\000\116\000\
\\049\000\115\000\050\000\114\000\051\000\113\000\085\000\101\000\000\000\
\\080\002\026\000\158\000\000\000\
\\081\002\000\000\
\\082\002\000\000\
\\083\002\027\000\139\000\000\000\
\\084\002\000\000\
\\085\002\000\000\
\\086\002\000\000\
\\087\002\027\000\135\000\000\000\
\\088\002\000\000\
\\089\002\000\000\
\\090\002\000\000\
\\091\002\004\000\138\000\008\000\137\000\000\000\
\\092\002\004\000\138\000\008\000\137\000\000\000\
\\093\002\004\000\072\000\008\000\071\000\000\000\
\\094\002\004\000\072\000\008\000\071\000\000\000\
\\095\002\004\000\103\001\008\000\102\001\000\000\
\\096\002\004\000\103\001\008\000\102\001\000\000\
\\097\002\022\000\042\000\056\000\036\000\057\000\035\000\000\000\
\\098\002\022\000\042\000\000\000\
\\099\002\000\000\
\\100\002\000\000\
\\101\002\000\000\
\\102\002\000\000\
\\103\002\000\000\
\\104\002\000\000\
\\105\002\000\000\
\\106\002\000\000\
\\107\002\000\000\
\\108\002\000\000\
\\109\002\000\000\
\\110\002\000\000\
\\111\002\000\000\
\\112\002\000\000\
\\113\002\000\000\
\\114\002\000\000\
\\115\002\000\000\
\\116\002\000\000\
\\117\002\000\000\
\\118\002\000\000\
\\119\002\000\000\
\\120\002\000\000\
\\121\002\004\000\215\000\008\000\214\000\010\000\213\000\012\000\212\000\
\\013\000\211\000\014\000\210\000\015\000\209\000\017\000\208\000\
\\018\000\207\000\019\000\206\000\020\000\205\000\022\000\204\000\
\\023\000\203\000\024\000\202\000\025\000\201\000\027\000\200\000\
\\028\000\199\000\029\000\198\000\030\000\197\000\031\000\196\000\
\\032\000\195\000\033\000\194\000\034\000\193\000\035\000\192\000\
\\036\000\191\000\037\000\190\000\038\000\189\000\039\000\188\000\
\\040\000\187\000\041\000\186\000\042\000\185\000\043\000\184\000\
\\044\000\183\000\045\000\182\000\046\000\181\000\047\000\180\000\000\000\
\\122\002\000\000\
\\123\002\000\000\
\\124\002\000\000\
\\125\002\000\000\
\\126\002\000\000\
\\127\002\000\000\
\\128\002\000\000\
\\129\002\000\000\
\\132\002\000\000\
\\133\002\000\000\
\\134\002\004\000\006\001\008\000\005\001\026\000\041\000\000\000\
\\134\002\004\000\006\001\008\000\005\001\026\000\041\000\089\000\012\001\000\000\
\\134\002\004\000\083\001\008\000\005\001\000\000\
\\135\002\004\000\096\001\008\000\095\001\000\000\
\\136\002\004\000\096\001\008\000\095\001\000\000\
\\137\002\000\000\
\\138\002\000\000\
\\139\002\000\000\
\\140\002\000\000\
\\141\002\000\000\
\\142\002\000\000\
\\143\002\000\000\
\\144\002\000\000\
\\145\002\000\000\
\\146\002\011\000\254\000\000\000\
\\147\002\000\000\
\\148\002\000\000\
\\149\002\000\000\
\\150\002\000\000\
\\151\002\000\000\
\\152\002\004\000\006\001\008\000\005\001\022\000\042\000\026\000\041\000\
\\089\000\012\001\000\000\
\\153\002\000\000\
\\154\002\000\000\
\\155\002\000\000\
\\157\002\000\000\
\"
val actionRowNumbers =
"\097\000\096\000\073\000\098\000\
\\008\000\099\000\101\000\074\000\
\\216\000\217\000\207\000\215\000\
\\198\000\205\000\022\000\119\000\
\\025\001\061\001\023\000\218\000\
\\008\001\219\000\226\000\227\000\
\\234\000\233\000\221\000\223\000\
\\222\000\224\000\075\000\225\000\
\\220\000\250\000\249\000\007\001\
\\005\001\006\001\004\001\040\001\
\\029\001\021\000\100\000\232\000\
\\231\000\093\000\118\000\057\001\
\\074\000\022\000\119\000\062\001\
\\009\000\196\000\208\000\198\000\
\\206\000\007\000\121\000\017\001\
\\023\001\022\001\021\001\006\000\
\\025\000\120\000\013\001\033\001\
\\024\000\028\000\049\000\026\001\
\\255\000\254\000\086\000\030\001\
\\213\000\031\001\050\000\093\000\
\\093\000\235\000\076\000\001\000\
\\002\000\211\000\058\001\063\001\
\\019\001\015\001\185\000\092\000\
\\034\000\011\000\188\000\110\000\
\\122\000\077\000\124\000\040\000\
\\087\000\012\000\013\000\190\000\
\\041\000\003\000\034\000\042\000\
\\010\000\043\000\044\000\182\000\
\\186\000\181\000\180\000\184\000\
\\034\000\034\000\129\000\133\000\
\\131\000\130\000\132\000\128\000\
\\033\000\117\000\203\000\204\000\
\\202\000\201\000\200\000\199\000\
\\197\000\027\000\024\000\029\000\
\\051\000\027\000\024\001\024\000\
\\052\000\035\000\183\000\042\001\
\\080\001\053\000\078\001\054\000\
\\046\000\084\001\059\001\044\001\
\\086\000\086\000\001\001\009\001\
\\002\001\032\001\214\000\041\001\
\\078\000\079\000\236\000\228\000\
\\014\000\239\000\243\000\034\000\
\\015\000\241\000\211\000\246\000\
\\034\000\209\000\123\000\168\000\
\\034\000\116\000\034\000\034\000\
\\034\000\034\000\034\000\034\000\
\\034\000\034\000\034\000\034\000\
\\034\000\034\000\034\000\034\000\
\\034\000\034\000\034\000\034\000\
\\034\000\034\000\034\000\088\000\
\\165\000\164\000\034\000\034\000\
\\034\000\034\000\034\000\034\000\
\\034\000\034\000\034\000\089\000\
\\034\000\026\000\125\000\127\000\
\\169\000\033\000\016\000\107\000\
\\106\000\191\000\017\000\034\000\
\\010\000\004\000\034\000\094\000\
\\190\000\034\000\187\000\010\000\
\\167\000\166\000\194\000\095\000\
\\055\000\056\000\020\001\053\001\
\\027\000\018\001\036\000\035\001\
\\057\000\058\000\037\001\016\001\
\\014\001\034\001\043\001\045\001\
\\091\000\090\000\046\001\086\001\
\\064\001\067\001\087\001\030\000\
\\045\000\027\001\083\001\082\001\
\\065\001\085\001\047\001\009\001\
\\009\001\080\000\012\001\034\000\
\\230\000\229\000\001\000\237\000\
\\034\000\244\000\001\000\238\000\
\\210\000\034\000\247\000\212\000\
\\088\001\189\000\158\000\157\000\
\\147\000\146\000\152\000\151\000\
\\154\000\153\000\156\000\155\000\
\\144\000\143\000\142\000\141\000\
\\138\000\137\000\139\000\140\000\
\\136\000\135\000\145\000\178\000\
\\176\000\161\000\149\000\160\000\
\\159\000\162\000\148\000\150\000\
\\163\000\005\000\177\000\175\000\
\\085\000\059\000\192\000\173\000\
\\060\000\109\000\108\000\061\000\
\\112\000\010\000\062\000\048\000\
\\018\000\063\000\111\000\066\001\
\\195\000\047\000\034\000\179\000\
\\010\001\055\001\036\001\038\001\
\\039\001\081\001\079\001\060\001\
\\068\001\031\000\064\000\037\000\
\\070\001\065\000\066\000\074\001\
\\032\000\067\000\028\001\081\000\
\\082\000\251\000\000\001\003\001\
\\240\000\245\000\242\000\248\000\
\\083\000\034\000\172\000\034\000\
\\174\000\171\000\010\000\113\000\
\\010\000\034\000\190\000\010\000\
\\170\000\084\000\011\001\038\000\
\\072\001\068\000\076\001\071\001\
\\075\001\069\001\039\000\048\001\
\\069\000\070\000\050\001\253\000\
\\252\000\126\000\134\000\193\000\
\\103\000\104\000\071\000\019\000\
\\114\000\054\001\056\001\073\001\
\\077\001\049\001\051\001\052\001\
\\020\000\190\000\010\000\105\000\
\\072\000\115\000\010\000\102\000\
\\000\000"
val gotoT =
"\
\\001\000\164\001\002\000\001\000\000\000\
\\021\000\018\000\024\000\017\000\027\000\016\000\029\000\015\000\
\\030\000\014\000\036\000\013\000\038\000\012\000\039\000\011\000\
\\040\000\010\000\043\000\009\000\044\000\008\000\045\000\007\000\
\\048\000\006\000\049\000\005\000\050\000\004\000\051\000\003\000\
\\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\006\000\051\000\029\000\050\000\030\000\049\000\036\000\013\000\
\\038\000\012\000\039\000\011\000\040\000\010\000\043\000\009\000\
\\044\000\008\000\046\000\048\000\049\000\047\000\050\000\004\000\
\\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\031\000\053\000\000\000\
\\000\000\
\\018\000\059\000\020\000\058\000\021\000\018\000\024\000\057\000\
\\027\000\016\000\036\000\056\000\038\000\055\000\039\000\011\000\
\\040\000\054\000\043\000\009\000\044\000\008\000\055\000\002\000\000\000\
\\017\000\066\000\019\000\065\000\021\000\064\000\022\000\063\000\
\\023\000\062\000\024\000\061\000\026\000\060\000\027\000\016\000\000\000\
\\000\000\
\\000\000\
\\027\000\071\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\021\000\077\000\040\000\076\000\041\000\075\000\000\000\
\\021\000\018\000\024\000\078\000\027\000\016\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\084\000\
\\042\000\083\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\060\000\082\000\061\000\081\000\000\000\
\\000\000\
\\000\000\
\\006\000\087\000\029\000\050\000\030\000\049\000\036\000\013\000\
\\038\000\012\000\039\000\011\000\040\000\010\000\043\000\009\000\
\\044\000\008\000\049\000\086\000\050\000\004\000\055\000\002\000\000\000\
\\018\000\059\000\020\000\058\000\021\000\018\000\024\000\088\000\
\\027\000\016\000\036\000\056\000\038\000\055\000\039\000\011\000\
\\040\000\054\000\043\000\009\000\044\000\008\000\055\000\002\000\000\000\
\\017\000\066\000\019\000\065\000\021\000\064\000\022\000\089\000\
\\023\000\062\000\024\000\061\000\026\000\060\000\027\000\016\000\000\000\
\\000\000\
\\003\000\098\000\004\000\097\000\005\000\096\000\006\000\095\000\
\\007\000\094\000\009\000\093\000\010\000\092\000\062\000\091\000\
\\064\000\090\000\000\000\
\\032\000\131\000\036\000\130\000\039\000\129\000\040\000\128\000\
\\043\000\127\000\044\000\126\000\055\000\002\000\000\000\
\\000\000\
\\031\000\132\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\026\000\138\000\027\000\071\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\021\000\064\000\023\000\140\000\024\000\078\000\026\000\060\000\
\\027\000\016\000\000\000\
\\007\000\141\000\010\000\092\000\064\000\090\000\000\000\
\\029\000\149\000\030\000\148\000\036\000\013\000\038\000\012\000\
\\039\000\011\000\040\000\010\000\043\000\009\000\044\000\008\000\
\\047\000\147\000\052\000\146\000\053\000\145\000\054\000\144\000\
\\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\013\000\155\000\014\000\154\000\000\000\
\\021\000\157\000\000\000\
\\040\000\076\000\041\000\158\000\000\000\
\\000\000\
\\000\000\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\084\000\
\\042\000\083\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\060\000\160\000\061\000\081\000\000\000\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\084\000\
\\042\000\083\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\060\000\161\000\061\000\081\000\000\000\
\\000\000\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\084\000\
\\042\000\083\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\061\000\162\000\000\000\
\\021\000\064\000\022\000\166\000\023\000\062\000\024\000\061\000\
\\026\000\060\000\027\000\016\000\056\000\165\000\058\000\164\000\000\000\
\\021\000\018\000\024\000\171\000\027\000\016\000\038\000\170\000\
\\039\000\011\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\057\000\169\000\059\000\168\000\000\000\
\\033\000\173\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\029\000\050\000\030\000\049\000\036\000\013\000\038\000\012\000\
\\039\000\011\000\040\000\010\000\043\000\009\000\044\000\008\000\
\\046\000\174\000\049\000\047\000\050\000\004\000\055\000\002\000\000\000\
\\007\000\175\000\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\214\000\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\007\000\216\000\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\094\000\008\000\222\000\009\000\221\000\010\000\092\000\
\\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\007\000\094\000\009\000\225\000\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\003\000\227\000\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\064\000\230\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\232\000\010\000\092\000\064\000\090\000\000\000\
\\007\000\233\000\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\094\000\009\000\237\000\010\000\092\000\037\000\236\000\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\235\000\
\\042\000\234\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\032\000\131\000\036\000\130\000\039\000\129\000\040\000\128\000\
\\043\000\127\000\044\000\126\000\055\000\002\000\000\000\
\\007\000\239\000\010\000\092\000\034\000\238\000\064\000\090\000\000\000\
\\017\000\241\000\021\000\064\000\022\000\089\000\023\000\062\000\
\\024\000\061\000\026\000\060\000\027\000\016\000\000\000\
\\007\000\242\000\010\000\092\000\064\000\090\000\000\000\
\\029\000\149\000\030\000\148\000\036\000\013\000\038\000\012\000\
\\039\000\011\000\040\000\010\000\043\000\009\000\044\000\008\000\
\\047\000\245\000\052\000\146\000\053\000\244\000\054\000\144\000\
\\055\000\002\000\000\000\
\\007\000\239\000\010\000\092\000\034\000\247\000\064\000\090\000\000\000\
\\000\000\
\\017\000\248\000\021\000\064\000\022\000\089\000\023\000\062\000\
\\024\000\061\000\026\000\060\000\027\000\016\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\002\001\016\000\001\001\021\000\000\001\024\000\255\000\
\\027\000\016\000\036\000\056\000\038\000\055\000\039\000\011\000\
\\040\000\054\000\043\000\009\000\044\000\008\000\055\000\002\000\000\000\
\\015\000\009\001\016\000\001\001\021\000\008\001\024\000\007\001\
\\025\000\006\001\027\000\016\000\028\000\005\001\000\000\
\\000\000\
\\000\000\
\\013\000\011\001\014\000\154\000\000\000\
\\013\000\012\001\014\000\154\000\000\000\
\\000\000\
\\012\000\013\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\084\000\
\\042\000\083\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\061\000\162\000\000\000\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\084\000\
\\042\000\083\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\061\000\162\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\021\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\033\000\024\001\000\000\
\\000\000\
\\007\000\026\001\010\000\092\000\064\000\090\000\000\000\
\\032\000\027\001\039\000\129\000\040\000\128\000\043\000\127\000\
\\044\000\126\000\055\000\002\000\000\000\
\\003\000\098\000\004\000\028\001\005\000\096\000\006\000\095\000\
\\007\000\094\000\009\000\093\000\010\000\092\000\029\000\050\000\
\\030\000\049\000\036\000\013\000\038\000\012\000\039\000\011\000\
\\040\000\010\000\043\000\009\000\044\000\008\000\049\000\086\000\
\\050\000\004\000\055\000\002\000\064\000\090\000\000\000\
\\000\000\
\\007\000\029\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\007\000\030\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\031\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\032\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\033\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\034\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\035\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\036\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\037\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\038\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\039\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\040\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\041\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\042\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\043\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\044\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\045\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\046\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\047\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\048\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\049\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\050\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\053\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\054\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\055\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\056\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\057\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\058\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\059\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\060\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\094\000\009\000\061\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\007\000\094\000\009\000\064\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\066\001\010\000\092\000\011\000\065\001\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\094\000\009\000\237\000\010\000\092\000\037\000\068\001\
\\038\000\085\000\039\000\011\000\040\000\076\000\041\000\235\000\
\\042\000\234\000\043\000\009\000\044\000\008\000\055\000\002\000\
\\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\094\000\009\000\071\001\010\000\092\000\064\000\090\000\000\000\
\\003\000\072\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\007\000\094\000\009\000\074\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\007\000\094\000\008\000\076\001\009\000\221\000\010\000\092\000\
\\064\000\090\000\000\000\
\\007\000\094\000\009\000\077\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\003\000\078\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\015\000\080\001\016\000\001\001\021\000\079\001\000\000\
\\038\000\170\000\039\000\011\000\043\000\009\000\044\000\008\000\
\\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\239\000\010\000\092\000\034\000\085\001\035\000\084\001\
\\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\029\000\149\000\030\000\148\000\036\000\013\000\038\000\012\000\
\\039\000\011\000\040\000\010\000\043\000\009\000\044\000\008\000\
\\054\000\089\001\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\016\000\092\001\027\000\071\000\000\000\
\\000\000\
\\000\000\
\\007\000\095\001\010\000\092\000\064\000\090\000\000\000\
\\015\000\098\001\016\000\001\001\021\000\000\001\024\000\078\000\
\\027\000\016\000\029\000\149\000\030\000\148\000\036\000\013\000\
\\038\000\012\000\039\000\011\000\040\000\010\000\043\000\009\000\
\\044\000\008\000\052\000\146\000\053\000\097\001\054\000\144\000\
\\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\016\000\092\001\027\000\071\000\028\000\102\001\000\000\
\\000\000\
\\000\000\
\\012\000\103\001\000\000\
\\012\000\104\001\000\000\
\\000\000\
\\014\000\106\001\000\000\
\\007\000\107\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\021\000\064\000\022\000\166\000\023\000\062\000\024\000\061\000\
\\026\000\060\000\027\000\016\000\056\000\108\001\000\000\
\\000\000\
\\007\000\109\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\021\000\064\000\022\000\166\000\023\000\062\000\024\000\061\000\
\\026\000\060\000\027\000\016\000\056\000\110\001\000\000\
\\000\000\
\\032\000\027\001\039\000\129\000\040\000\128\000\043\000\127\000\
\\044\000\126\000\055\000\002\000\000\000\
\\007\000\111\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\063\000\112\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\119\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\016\000\092\001\000\000\
\\000\000\
\\015\000\098\001\016\000\001\001\021\000\079\001\029\000\149\000\
\\030\000\148\000\036\000\013\000\038\000\012\000\039\000\011\000\
\\040\000\010\000\043\000\009\000\044\000\008\000\052\000\146\000\
\\053\000\097\001\054\000\144\000\055\000\002\000\000\000\
\\007\000\124\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\012\000\125\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\127\001\010\000\092\000\064\000\090\000\000\000\
\\029\000\149\000\030\000\148\000\036\000\013\000\038\000\012\000\
\\039\000\011\000\040\000\010\000\043\000\009\000\044\000\008\000\
\\052\000\146\000\053\000\129\001\054\000\144\000\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\134\001\010\000\092\000\064\000\090\000\000\000\
\\029\000\149\000\030\000\148\000\036\000\013\000\038\000\012\000\
\\039\000\011\000\040\000\010\000\043\000\009\000\044\000\008\000\
\\047\000\137\001\052\000\146\000\053\000\136\001\054\000\144\000\
\\055\000\002\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\142\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\007\000\143\001\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\007\000\124\001\010\000\092\000\064\000\090\000\000\000\
\\003\000\144\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\003\000\145\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\007\000\094\000\009\000\146\001\010\000\092\000\064\000\090\000\000\000\
\\007\000\094\000\008\000\147\001\009\000\221\000\010\000\092\000\
\\064\000\090\000\000\000\
\\003\000\148\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\007\000\239\000\010\000\092\000\034\000\150\001\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\094\000\008\000\160\001\009\000\221\000\010\000\092\000\
\\064\000\090\000\000\000\
\\003\000\161\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\163\001\006\000\095\000\007\000\094\000\009\000\093\000\
\\010\000\092\000\064\000\090\000\000\000\
\\000\000\
\\000\000\
\"
val numstates = 421
val numrules = 247
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
       fun f i =
            if i=numstates then g i
            else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in f 0 handle Subscript => ()
          end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = SourceMap.sourcemap
structure MlyValue = 
struct
datatype svalue = VOID' | ntVOID of unit | TYPE_NAME of  (string)
 | CCONST of  (LargeInt.int) | STRING of  (string)
 | REALNUM of  (real) | DECNUM of  (LargeInt.int) | ID of  (string)
 | strings of  (string) | popScope of  (unit) | pushScope of  (unit)
 | structDeclaration of  ( ( ctype * (declarator * expression) list ) )
 | structDeclarationList of  ( ( ctype * (declarator * expression) list )  seq)
 | notypeStructDeclaratorList of  ( ( declarator * expression )  seq)
 | structDeclaratorList of  ( ( declarator * expression )  seq)
 | notypeStructDeclarator of  ( ( declarator * expression ) )
 | structDeclarator of  ( ( declarator * expression ) )
 | structOrUnion of  (bool)
 | parameterDeclaration of  ( ( decltype * declarator ) )
 | parameterTypeList of  ( ( decltype * declarator )  list)
 | parameterList of  ( ( decltype * declarator )  seq)
 | externalDeclaration of  (externalDecl option)
 | declaration1 of  (declaration) | declaration of  (declaration)
 | functionDefinition of  (externalDecl)
 | identlist of  ( ( string * int * int )  seq)
 | declarationList of  (declaration seq)
 | fDefDeclaration of  ( ( decltype * declarator ) )
 | structOrUnionSpecifier of  (specifier)
 | enumSpecifier of  (specifier) | specifierQualifierList of  (ctype)
 | typeQualifierList of  (qualifier list)
 | typeQualifier of  (qualifier)
 | typeSpecifierReserved of  (specifier)
 | typeSpecifier of  (specifier) | typeName of  (ctype)
 | storageClassSpecifier of  (storage)
 | initializerList of  (expression seq) | initializer of  (expression)
 | reservedSpecifierQualifiers of  (ctype)
 | specifierQualifierReserved of  (ctype)
 | reservedDeclarationSpecifier of  (decltype)
 | declarationModifiers of  (decltype)
 | declarationSpecifiers of  (decltype)
 | parmDirectDeclarator of  (declarator)
 | notypeDirectDeclarator of  (declarator)
 | aftertypeDirectDeclarator of  (declarator)
 | parmDeclarator of  (declarator) | notypeDeclarator of  (declarator)
 | aftertypeDeclarator of  (declarator) | declarator of  (declarator)
 | pointer of  (declarator)
 | notypeInitDeclaratorList of  ( ( declarator * expression )  seq)
 | initDeclaratorList of  ( ( declarator * expression )  seq)
 | notypeInitDeclarator of  ( ( declarator * expression ) )
 | initDeclarator of  ( ( declarator * expression ) )
 | directAbstractDeclarator of  (declarator)
 | abstractDeclarator of  (declarator)
 | enumerator of  ( ( string * expression ) )
 | enumeratorList of  ( ( string * expression )  seq)
 | trailingComma of  (bool) | argumentExprList of  (expression seq)
 | unaryOperator of  (operator) | exprWComma of  (expression)
 | opExpr of  (expression) | expr of  (expression)
 | compoundStatement of  (statement)
 | statementlist of  (statement seq)
 | ostatementlist of  (statement list) | statement of  (statement)
 | tu of  (externalDecl seq) | translationUnit of  (externalDecl list)
end
type svalue = MlyValue.svalue
type result = externalDecl list
end
structure EC=
struct
open LrTable
infix 5 $$
fun x $$ y = y::x
val is_keyword =
fn (T 11) => true | (T 57) => true | (T 58) => true | (T 59) => true
 | (T 60) => true | (T 61) => true | (T 62) => true | (T 63) => true
 | (T 64) => true | (T 65) => true | (T 66) => true | (T 67) => true
 | (T 68) => true | (T 69) => true | _ => false
val preferred_change : (term list * term list) list = 
(nil
 $$ (T 25),nil
 $$ (T 88))::
nil
val noShift = 
fn (T 0) => true | _ => false
val showTerminal =
fn (T 0) => "EOF"
  | (T 1) => "COLON"
  | (T 2) => "SEMICOLON"
  | (T 3) => "LPAREN"
  | (T 4) => "RPAREN"
  | (T 5) => "LCURLY"
  | (T 6) => "RCURLY"
  | (T 7) => "LBRACE"
  | (T 8) => "RBRACE"
  | (T 9) => "DOT"
  | (T 10) => "COMMA"
  | (T 11) => "QUESTION"
  | (T 12) => "PERCENT"
  | (T 13) => "AMP"
  | (T 14) => "BAR"
  | (T 15) => "TILDE"
  | (T 16) => "DIVIDE"
  | (T 17) => "PLUS"
  | (T 18) => "MINUS"
  | (T 19) => "HAT"
  | (T 20) => "BANG"
  | (T 21) => "TIMES"
  | (T 22) => "INC"
  | (T 23) => "DEC"
  | (T 24) => "ARROW"
  | (T 25) => "ID"
  | (T 26) => "EQUALS"
  | (T 27) => "PLUSEQUALS"
  | (T 28) => "MINUSEQUALS"
  | (T 29) => "XOREQUALS"
  | (T 30) => "MODEQUALS"
  | (T 31) => "TIMESEQUALS"
  | (T 32) => "DIVEQUALS"
  | (T 33) => "OREQUALS"
  | (T 34) => "ANDEQUALS"
  | (T 35) => "LSHIFTEQUALS"
  | (T 36) => "RSHIFTEQUALS"
  | (T 37) => "LTE"
  | (T 38) => "GTE"
  | (T 39) => "LT"
  | (T 40) => "GT"
  | (T 41) => "EQ"
  | (T 42) => "NEQ"
  | (T 43) => "OR"
  | (T 44) => "AND"
  | (T 45) => "LSHIFT"
  | (T 46) => "RSHIFT"
  | (T 47) => "DECNUM"
  | (T 48) => "REALNUM"
  | (T 49) => "STRING"
  | (T 50) => "CCONST"
  | (T 51) => "EXTERN"
  | (T 52) => "AUTO"
  | (T 53) => "STATIC"
  | (T 54) => "REGISTER"
  | (T 55) => "CONST"
  | (T 56) => "VOLATILE"
  | (T 57) => "IF"
  | (T 58) => "THEN"
  | (T 59) => "ELSE"
  | (T 60) => "FOR"
  | (T 61) => "DO"
  | (T 62) => "SWITCH"
  | (T 63) => "CASE"
  | (T 64) => "DEFAULT"
  | (T 65) => "WHILE"
  | (T 66) => "RETURN"
  | (T 67) => "BREAK"
  | (T 68) => "CONTINUE"
  | (T 69) => "GOTO"
  | (T 70) => "CHAR"
  | (T 71) => "DOUBLE"
  | (T 72) => "ENUM"
  | (T 73) => "FLOAT"
  | (T 74) => "INT"
  | (T 75) => "LONG"
  | (T 76) => "SHORT"
  | (T 77) => "FRACTIONAL"
  | (T 78) => "SATURATE"
  | (T 79) => "STRUCT"
  | (T 80) => "UNION"
  | (T 81) => "UNSIGNED"
  | (T 82) => "SIGNED"
  | (T 83) => "VOID"
  | (T 84) => "SIZEOF"
  | (T 85) => "TYPEDEF"
  | (T 86) => "UNARY"
  | (T 87) => "ELIPSIS"
  | (T 88) => "TYPE_NAME"
  | _ => "bogus-term"
local open Header in
val errtermvalue=
fn (T 88) => MlyValue.TYPE_NAME((
Error.hint "Likely cause: missing typedef declaration.\n"; "bogus")) | 
_ => MlyValue.VOID'
end
val terms : term list = nil
 $$ (T 87) $$ (T 86) $$ (T 85) $$ (T 84) $$ (T 83) $$ (T 82) $$ (T 81)
 $$ (T 80) $$ (T 79) $$ (T 78) $$ (T 77) $$ (T 76) $$ (T 75) $$ (T 74)
 $$ (T 73) $$ (T 72) $$ (T 71) $$ (T 70) $$ (T 69) $$ (T 68) $$ (T 67)
 $$ (T 66) $$ (T 65) $$ (T 64) $$ (T 63) $$ (T 62) $$ (T 61) $$ (T 60)
 $$ (T 59) $$ (T 58) $$ (T 57) $$ (T 56) $$ (T 55) $$ (T 54) $$ (T 53)
 $$ (T 52) $$ (T 51) $$ (T 46) $$ (T 45) $$ (T 44) $$ (T 43) $$ (T 42)
 $$ (T 41) $$ (T 40) $$ (T 39) $$ (T 38) $$ (T 37) $$ (T 36) $$ (T 35)
 $$ (T 34) $$ (T 33) $$ (T 32) $$ (T 31) $$ (T 30) $$ (T 29) $$ (T 28)
 $$ (T 27) $$ (T 26) $$ (T 24) $$ (T 23) $$ (T 22) $$ (T 21) $$ (T 20)
 $$ (T 19) $$ (T 18) $$ (T 17) $$ (T 16) $$ (T 15) $$ (T 14) $$ (T 13)
 $$ (T 12) $$ (T 11) $$ (T 10) $$ (T 9) $$ (T 8) $$ (T 7) $$ (T 6) $$ 
(T 5) $$ (T 4) $$ (T 3) $$ (T 2) $$ (T 1) $$ (T 0)end
structure Actions =
struct 
type int = Int.int
exception mlyAction of int
local open Header in
val actions = 
fn (i392:int,defaultPos,stack,
    (srcMap):arg) =>
case (i392,stack)
of  ( 0, ( ( _, ( MlyValue.tu tu, tu1left, tu1right)) :: rest671)) =>
 let val  result = MlyValue.translationUnit (seqToList tu)
 in ( LrTable.NT 0, ( result, tu1left, tu1right), rest671)
end
|  ( 1, ( rest671)) => let val  result = MlyValue.tu (emptySeq)
 in ( LrTable.NT 1, ( result, defaultPos, defaultPos), rest671)
end
|  ( 2, ( ( _, ( MlyValue.externalDeclaration externalDeclaration, _, 
externalDeclaration1right)) :: ( _, ( MlyValue.tu tu, tu1left, _)) :: 
rest671)) => let val  result = MlyValue.tu (
addOptToEnd(externalDeclaration, tu))
 in ( LrTable.NT 1, ( result, tu1left, externalDeclaration1right), 
rest671)
end
|  ( 3, ( ( _, ( MlyValue.declaration declaration, (declarationleft
 as declaration1left), (declarationright as declaration1right))) :: 
rest671)) => let val  result = MlyValue.externalDeclaration (
SOME(markExternalDecl srcMap (ExternalDecl declaration,
						                       declarationleft,
								       declarationright))
)
 in ( LrTable.NT 50, ( result, declaration1left, declaration1right), 
rest671)
end
|  ( 4, ( ( _, ( _, SEMICOLON1left, SEMICOLON1right)) :: rest671)) =>
 let val  result = MlyValue.externalDeclaration (NONE)
 in ( LrTable.NT 50, ( result, SEMICOLON1left, SEMICOLON1right), 
rest671)
end
|  ( 5, ( ( _, ( MlyValue.functionDefinition functionDefinition, (
functionDefinitionleft as functionDefinition1left), (
functionDefinitionright as functionDefinition1right))) :: rest671)) =>
 let val  result = MlyValue.externalDeclaration (
SOME(markExternalDecl srcMap (functionDefinition,
						   	               functionDefinitionleft,
							               functionDefinitionright))
)
 in ( LrTable.NT 50, ( result, functionDefinition1left, 
functionDefinition1right), rest671)
end
|  ( 6, ( ( _, ( MlyValue.statement statement, _, (statementright as 
statement1right))) :: _ :: ( _, ( MlyValue.opExpr opExpr3, _, _)) :: _
 :: ( _, ( MlyValue.opExpr opExpr2, _, _)) :: _ :: ( _, ( 
MlyValue.opExpr opExpr1, _, _)) :: _ :: ( _, ( _, (FORleft as FOR1left
), _)) :: rest671)) => let val  result = MlyValue.statement (
markStatement srcMap (For(opExpr1,opExpr2,opExpr3,statement),
							FORleft, statementright)
)
 in ( LrTable.NT 2, ( result, FOR1left, statement1right), rest671)
end
|  ( 7, ( ( _, ( MlyValue.statement statement, _, (statementright as 
statement1right))) :: _ :: ( _, ( MlyValue.exprWComma exprWComma, _, _
)) :: _ :: ( _, ( _, (WHILEleft as WHILE1left), _)) :: rest671)) =>
 let val  result = MlyValue.statement (
markStatement srcMap (While(exprWComma,statement),
							WHILEleft, statementright)
)
 in ( LrTable.NT 2, ( result, WHILE1left, statement1right), rest671)

end
|  ( 8, ( ( _, ( MlyValue.statement statement, _, (statementright as 
statement1right))) :: _ :: ( _, ( MlyValue.exprWComma exprWComma, _, _
)) :: _ :: ( _, ( _, (SWITCHleft as SWITCH1left), _)) :: rest671)) =>
 let val  result = MlyValue.statement (
markStatement srcMap (Switch(exprWComma,statement),
							SWITCHleft, statementright)
)
 in ( LrTable.NT 2, ( result, SWITCH1left, statement1right), rest671)

end
|  ( 9, ( ( _, ( _, _, (SEMICOLONright as SEMICOLON1right))) :: _ :: (
 _, ( MlyValue.exprWComma exprWComma, _, _)) :: _ :: _ :: ( _, ( 
MlyValue.statement statement, _, _)) :: ( _, ( _, (DOleft as DO1left),
 _)) :: rest671)) => let val  result = MlyValue.statement (
markStatement srcMap (Do(exprWComma,statement),
							DOleft, SEMICOLONright)
)
 in ( LrTable.NT 2, ( result, DO1left, SEMICOLON1right), rest671)
end
|  ( 10, ( ( _, ( _, _, (SEMICOLONright as SEMICOLON1right))) :: ( _, 
( _, (BREAKleft as BREAK1left), _)) :: rest671)) => let val  result = 
MlyValue.statement (
markStatement srcMap (Break, 
							BREAKleft, SEMICOLONright))
 in ( LrTable.NT 2, ( result, BREAK1left, SEMICOLON1right), rest671)

end
|  ( 11, ( ( _, ( _, _, (SEMICOLONright as SEMICOLON1right))) :: ( _, 
( _, (CONTINUEleft as CONTINUE1left), _)) :: rest671)) => let val  
result = MlyValue.statement (
markStatement srcMap (Continue, 
							CONTINUEleft, SEMICOLONright))
 in ( LrTable.NT 2, ( result, CONTINUE1left, SEMICOLON1right), rest671
)
end
|  ( 12, ( ( _, ( _, _, (SEMICOLONright as SEMICOLON1right))) :: ( _, 
( MlyValue.opExpr opExpr, _, _)) :: ( _, ( _, (RETURNleft as 
RETURN1left), _)) :: rest671)) => let val  result = MlyValue.statement
 (
markStatement srcMap (Return(opExpr), 
							RETURNleft, SEMICOLONright)
)
 in ( LrTable.NT 2, ( result, RETURN1left, SEMICOLON1right), rest671)

end
|  ( 13, ( ( _, ( _, _, (SEMICOLONright as SEMICOLON1right))) :: ( _, 
( MlyValue.ID ID, _, _)) :: ( _, ( _, (GOTOleft as GOTO1left), _)) :: 
rest671)) => let val  result = MlyValue.statement (
markStatement srcMap (Goto(ID), 
							GOTOleft, SEMICOLONright))
 in ( LrTable.NT 2, ( result, GOTO1left, SEMICOLON1right), rest671)

end
|  ( 14, ( ( _, ( MlyValue.compoundStatement compoundStatement, 
compoundStatement1left, compoundStatement1right)) :: rest671)) => let
 val  result = MlyValue.statement (compoundStatement)
 in ( LrTable.NT 2, ( result, compoundStatement1left, 
compoundStatement1right), rest671)
end
|  ( 15, ( ( _, ( MlyValue.statement statement, _, (statementright as 
statement1right))) :: _ :: ( _, ( MlyValue.ID ID, (IDleft as ID1left),
 _)) :: rest671)) => let val  result = MlyValue.statement (
markStatement srcMap (Labeled(ID,statement),
							IDleft,statementright)
)
 in ( LrTable.NT 2, ( result, ID1left, statement1right), rest671)
end
|  ( 16, ( ( _, ( MlyValue.statement statement, _, (statementright as 
statement1right))) :: _ :: ( _, ( _, (DEFAULTleft as DEFAULT1left), _)
) :: rest671)) => let val  result = MlyValue.statement (
markStatement srcMap (DefaultLabel(statement),
							DEFAULTleft, statementright)
)
 in ( LrTable.NT 2, ( result, DEFAULT1left, statement1right), rest671)

end
|  ( 17, ( ( _, ( MlyValue.statement statement, _, (statementright as 
statement1right))) :: _ :: ( _, ( MlyValue.exprWComma exprWComma, _, _
)) :: ( _, ( _, (CASEleft as CASE1left), _)) :: rest671)) => let val  
result = MlyValue.statement (
markStatement srcMap (CaseLabel(exprWComma,statement),
							CASEleft, statementright)
)
 in ( LrTable.NT 2, ( result, CASE1left, statement1right), rest671)

end
|  ( 18, ( ( _, ( MlyValue.statement statement, _, (statementright as 
statement1right))) :: _ :: ( _, ( MlyValue.exprWComma exprWComma, _, _
)) :: _ :: ( _, ( _, (IFleft as IF1left), _)) :: rest671)) => let val 
 result = MlyValue.statement (
markStatement srcMap (IfThen(exprWComma,statement),
							IFleft, statementright)
)
 in ( LrTable.NT 2, ( result, IF1left, statement1right), rest671)
end
|  ( 19, ( ( _, ( MlyValue.statement statement2, _, statement2right))
 :: _ :: ( _, ( MlyValue.statement statement1, _, _)) :: _ :: ( _, ( 
MlyValue.exprWComma exprWComma, _, _)) :: _ :: ( _, ( _, (IFleft as 
IF1left), _)) :: rest671)) => let val  result = MlyValue.statement (
markStatement srcMap (IfThenElse(exprWComma,statement1,statement2),
							IFleft,
							statement2right)
)
 in ( LrTable.NT 2, ( result, IF1left, statement2right), rest671)
end
|  ( 20, ( ( _, ( _, _, (SEMICOLONright as SEMICOLON1right))) :: ( _, 
( MlyValue.exprWComma exprWComma, (exprWCommaleft as exprWComma1left),
 _)) :: rest671)) => let val  result = MlyValue.statement (
markStatement srcMap (Expr(exprWComma),
							exprWCommaleft, SEMICOLONright)
)
 in ( LrTable.NT 2, ( result, exprWComma1left, SEMICOLON1right), 
rest671)
end
|  ( 21, ( ( _, ( _, (SEMICOLONleft as SEMICOLON1left), (
SEMICOLONright as SEMICOLON1right))) :: rest671)) => let val  result =
 MlyValue.statement (
markStatement srcMap (Expr(EmptyExpr),
							SEMICOLONleft, SEMICOLONright)
)
 in ( LrTable.NT 2, ( result, SEMICOLON1left, SEMICOLON1right), 
rest671)
end
|  ( 22, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( 
MlyValue.declaration1 declaration1, declaration11left, _)) :: rest671)
) => let val  result = MlyValue.declaration (declaration1)
 in ( LrTable.NT 48, ( result, declaration11left, SEMICOLON1right), 
rest671)
end
|  ( 23, ( ( _, ( MlyValue.declarationSpecifiers declarationSpecifiers
, (declarationSpecifiersleft as declarationSpecifiers1left), (
declarationSpecifiersright as declarationSpecifiers1right))) :: 
rest671)) => let val  result = MlyValue.declaration1 (
insertDeclNames (declarationSpecifiers, []);
		 markDeclaration srcMap
		   (Declaration(declarationSpecifiers, []), 
		    declarationSpecifiersleft, declarationSpecifiersright)
)
 in ( LrTable.NT 49, ( result, declarationSpecifiers1left, 
declarationSpecifiers1right), rest671)
end
|  ( 24, ( ( _, ( MlyValue.initDeclaratorList initDeclaratorList, _, (
initDeclaratorListright as initDeclaratorList1right))) :: ( _, ( 
MlyValue.declarationSpecifiers declarationSpecifiers, (
declarationSpecifiersleft as declarationSpecifiers1left), _)) :: 
rest671)) => let val  result = MlyValue.declaration1 (
let val decl = (declarationSpecifiers, seqToList initDeclaratorList)
		  in insertDeclNames decl;
		     markDeclaration srcMap
		       (Declaration decl, declarationSpecifiersleft, initDeclaratorListright)
	         end
)
 in ( LrTable.NT 49, ( result, declarationSpecifiers1left, 
initDeclaratorList1right), rest671)
end
|  ( 25, ( ( _, ( MlyValue.notypeInitDeclaratorList 
notypeInitDeclaratorList, _, (notypeInitDeclaratorListright as 
notypeInitDeclaratorList1right))) :: ( _, ( 
MlyValue.declarationModifiers declarationModifiers, (
declarationModifiersleft as declarationModifiers1left), _)) :: rest671
)) => let val  result = MlyValue.declaration1 (
let val decl = (declarationModifiers, seqToList notypeInitDeclaratorList)
		  in insertDeclNames decl;
		     markDeclaration srcMap
		       (Declaration decl, declarationModifiersleft, notypeInitDeclaratorListright)
	         end
)
 in ( LrTable.NT 49, ( result, declarationModifiers1left, 
notypeInitDeclaratorList1right), rest671)
end
|  ( 26, ( ( _, ( MlyValue.statementlist statementlist, 
statementlist1left, statementlist1right)) :: rest671)) => let val  
result = MlyValue.ostatementlist (seqToList statementlist)
 in ( LrTable.NT 3, ( result, statementlist1left, statementlist1right)
, rest671)
end
|  ( 27, ( rest671)) => let val  result = MlyValue.ostatementlist ([])
 in ( LrTable.NT 3, ( result, defaultPos, defaultPos), rest671)
end
|  ( 28, ( ( _, ( MlyValue.statement statement, statement1left, 
statement1right)) :: rest671)) => let val  result = 
MlyValue.statementlist (singletonSeq statement)
 in ( LrTable.NT 4, ( result, statement1left, statement1right), 
rest671)
end
|  ( 29, ( ( _, ( MlyValue.statement statement, _, statement1right))
 :: ( _, ( MlyValue.statementlist statementlist, statementlist1left, _
)) :: rest671)) => let val  result = MlyValue.statementlist (
addToSeq(statement, statementlist))
 in ( LrTable.NT 4, ( result, statementlist1left, statement1right), 
rest671)
end
|  ( 30, ( ( _, ( _, _, (RCURLYright as RCURLY1right))) :: _ :: ( _, (
 MlyValue.ostatementlist ostatementlist, _, _)) :: ( _, ( 
MlyValue.declarationList declarationList, _, _)) :: _ :: ( _, ( _, (
LCURLYleft as LCURLY1left), _)) :: rest671)) => let val  result = 
MlyValue.compoundStatement (
markStatement srcMap (Compound ((map Decl (seqToList declarationList)) @ ostatementlist), LCURLYleft, RCURLYright)
)
 in ( LrTable.NT 5, ( result, LCURLY1left, RCURLY1right), rest671)
end
|  ( 31, ( ( _, ( _, _, (RCURLYright as RCURLY1right))) :: ( _, ( 
MlyValue.ostatementlist ostatementlist, _, _)) :: ( _, ( _, (
LCURLYleft as LCURLY1left), _)) :: rest671)) => let val  result = 
MlyValue.compoundStatement (
markStatement srcMap (Compound (ostatementlist), LCURLYleft, RCURLYright)
)
 in ( LrTable.NT 5, ( result, LCURLY1left, RCURLY1right), rest671)
end
|  ( 32, ( ( _, ( _, AMP1left, AMP1right)) :: rest671)) => let val  
result = MlyValue.unaryOperator (AddrOf)
 in ( LrTable.NT 9, ( result, AMP1left, AMP1right), rest671)
end
|  ( 33, ( ( _, ( _, TIMES1left, TIMES1right)) :: rest671)) => let
 val  result = MlyValue.unaryOperator (Star)
 in ( LrTable.NT 9, ( result, TIMES1left, TIMES1right), rest671)
end
|  ( 34, ( ( _, ( _, PLUS1left, PLUS1right)) :: rest671)) => let val  
result = MlyValue.unaryOperator (Uplus)
 in ( LrTable.NT 9, ( result, PLUS1left, PLUS1right), rest671)
end
|  ( 35, ( ( _, ( _, MINUS1left, MINUS1right)) :: rest671)) => let
 val  result = MlyValue.unaryOperator (Negate)
 in ( LrTable.NT 9, ( result, MINUS1left, MINUS1right), rest671)
end
|  ( 36, ( ( _, ( _, TILDE1left, TILDE1right)) :: rest671)) => let
 val  result = MlyValue.unaryOperator (BitNot)
 in ( LrTable.NT 9, ( result, TILDE1left, TILDE1right), rest671)
end
|  ( 37, ( ( _, ( _, BANG1left, BANG1right)) :: rest671)) => let val  
result = MlyValue.unaryOperator (Not)
 in ( LrTable.NT 9, ( result, BANG1left, BANG1right), rest671)
end
|  ( 38, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.exprWComma exprWComma1, _, _)) :: _ :: ( _, ( MlyValue.expr 
expr1, expr1left, _)) :: rest671)) => let val  result = MlyValue.expr
 (
markExpression srcMap (QuestionColon(expr1,exprWComma1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 39, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(PlusAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 40, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(MinusAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 41, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(TimesAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 42, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(DivAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 43, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(ModAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 44, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(XorAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 45, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(OrAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 46, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(AndAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 47, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(LshiftAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 48, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(RshiftAssign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 49, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Assign,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 50, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Or,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 51, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(And,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 52, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(BitOr,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 53, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(BitXor,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 54, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(BitAnd,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 55, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Eq,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 56, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Neq,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 57, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Lt,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 58, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Gt,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 59, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Lte,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 60, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Gte,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 61, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Lshift,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 62, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Rshift,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 63, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Plus,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 64, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Minus,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 65, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Times,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 66, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Divide,expr1,expr2),expr1left,expr2right)
)
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 67, ( ( _, ( MlyValue.expr expr2, _, expr2right)) :: _ :: ( _, ( 
MlyValue.expr expr1, expr1left, _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Mod,expr1,expr2),expr1left,expr2right))
 in ( LrTable.NT 6, ( result, expr1left, expr2right), rest671)
end
|  ( 68, ( ( _, ( _, _, (INCright as INC1right))) :: ( _, ( 
MlyValue.expr expr, (exprleft as expr1left), _)) :: rest671)) => let
 val  result = MlyValue.expr (
markExpression srcMap (Unop(PostInc,expr),exprleft,INCright))
 in ( LrTable.NT 6, ( result, expr1left, INC1right), rest671)
end
|  ( 69, ( ( _, ( _, _, (DECright as DEC1right))) :: ( _, ( 
MlyValue.expr expr, (exprleft as expr1left), _)) :: rest671)) => let
 val  result = MlyValue.expr (
markExpression srcMap (Unop(PostDec,expr),exprleft,DECright))
 in ( LrTable.NT 6, ( result, expr1left, DEC1right), rest671)
end
|  ( 70, ( ( _, ( MlyValue.expr expr, _, (exprright as expr1right)))
 :: ( _, ( _, (INCleft as INC1left), _)) :: rest671)) => let val  
result = MlyValue.expr (
markExpression srcMap (Unop(PreInc,expr),INCleft,exprright))
 in ( LrTable.NT 6, ( result, INC1left, expr1right), rest671)
end
|  ( 71, ( ( _, ( MlyValue.expr expr, _, (exprright as expr1right)))
 :: ( _, ( _, (DECleft as DEC1left), _)) :: rest671)) => let val  
result = MlyValue.expr (
markExpression srcMap (Unop(PreDec,expr),DECleft,exprright))
 in ( LrTable.NT 6, ( result, DEC1left, expr1right), rest671)
end
|  ( 72, ( ( _, ( MlyValue.expr expr, _, (exprright as expr1right)))
 :: ( _, ( MlyValue.unaryOperator unaryOperator, (unaryOperatorleft
 as unaryOperator1left), _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Unop(unaryOperator,expr),unaryOperatorleft,exprright)
)
 in ( LrTable.NT 6, ( result, unaryOperator1left, expr1right), rest671
)
end
|  ( 73, ( ( _, ( MlyValue.expr expr, _, (exprright as expr1right)))
 :: ( _, ( _, (SIZEOFleft as SIZEOF1left), _)) :: rest671)) => let
 val  result = MlyValue.expr (
markExpression srcMap (Unop(Sizeof,expr),SIZEOFleft,exprright))
 in ( LrTable.NT 6, ( result, SIZEOF1left, expr1right), rest671)
end
|  ( 74, ( ( _, ( MlyValue.expr expr, _, (exprright as expr1right)))
 :: _ :: ( _, ( MlyValue.typeName typeName, _, _)) :: ( _, ( _, (
LPARENleft as LPAREN1left), _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Cast (typeName,expr),LPARENleft,exprright))
 in ( LrTable.NT 6, ( result, LPAREN1left, expr1right), rest671)
end
|  ( 75, ( ( _, ( _, _, (RPARENright as RPAREN1right))) :: ( _, ( 
MlyValue.typeName typeName, _, _)) :: _ :: ( _, ( _, (SIZEOFleft as 
SIZEOF1left), _)) :: rest671)) => let val  result = MlyValue.expr (
markExpression srcMap (Unop(SizeofType typeName,EmptyExpr),SIZEOFleft,RPARENright)
)
 in ( LrTable.NT 6, ( result, SIZEOF1left, RPAREN1right), rest671)
end
|  ( 76, ( ( _, ( _, _, (RBRACEright as RBRACE1right))) :: ( _, ( 
MlyValue.exprWComma exprWComma, _, _)) :: _ :: ( _, ( MlyValue.expr 
expr, (exprleft as expr1left), _)) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (Binop(Sub,expr,exprWComma),exprleft,RBRACEright)
)
 in ( LrTable.NT 6, ( result, expr1left, RBRACE1right), rest671)
end
|  ( 77, ( ( _, ( _, _, (RPARENright as RPAREN1right))) :: _ :: ( _, (
 MlyValue.expr expr, (exprleft as expr1left), _)) :: rest671)) => let
 val  result = MlyValue.expr (
markExpression srcMap (Call(expr,[]),exprleft,RPARENright))
 in ( LrTable.NT 6, ( result, expr1left, RPAREN1right), rest671)
end
|  ( 78, ( ( _, ( _, _, (RPARENright as RPAREN1right))) :: ( _, ( 
MlyValue.argumentExprList argumentExprList, _, _)) :: _ :: ( _, ( 
MlyValue.expr expr, (exprleft as expr1left), _)) :: rest671)) => let
 val  result = MlyValue.expr (
markExpression srcMap (Call(expr, seqToList argumentExprList),exprleft,RPARENright)
)
 in ( LrTable.NT 6, ( result, expr1left, RPAREN1right), rest671)
end
|  ( 79, ( ( _, ( MlyValue.ID ID, _, (IDright as ID1right))) :: _ :: (
 _, ( MlyValue.expr expr, (exprleft as expr1left), _)) :: rest671)) =>
 let val  result = MlyValue.expr (
markExpression srcMap (Binop(Dot,expr,Id(ID)),exprleft,IDright))
 in ( LrTable.NT 6, ( result, expr1left, ID1right), rest671)
end
|  ( 80, ( ( _, ( MlyValue.ID ID, _, (IDright as ID1right))) :: _ :: (
 _, ( MlyValue.expr expr, (exprleft as expr1left), _)) :: rest671)) =>
 let val  result = MlyValue.expr (
markExpression srcMap (Binop(Arrow,expr,Id(ID)),exprleft,IDright))
 in ( LrTable.NT 6, ( result, expr1left, ID1right), rest671)
end
|  ( 81, ( ( _, ( MlyValue.TYPE_NAME TYPE_NAME, _, (TYPE_NAMEright as 
TYPE_NAME1right))) :: _ :: ( _, ( MlyValue.expr expr, (exprleft as 
expr1left), _)) :: rest671)) => let val  result = MlyValue.expr (
markExpression srcMap (Binop(Dot,expr,Id(TYPE_NAME)),exprleft,TYPE_NAMEright)
)
 in ( LrTable.NT 6, ( result, expr1left, TYPE_NAME1right), rest671)

end
|  ( 82, ( ( _, ( MlyValue.TYPE_NAME TYPE_NAME, _, (TYPE_NAMEright as 
TYPE_NAME1right))) :: _ :: ( _, ( MlyValue.expr expr, (exprleft as 
expr1left), _)) :: rest671)) => let val  result = MlyValue.expr (
markExpression srcMap (Binop(Arrow,expr,Id(TYPE_NAME)),exprleft,TYPE_NAMEright)
)
 in ( LrTable.NT 6, ( result, expr1left, TYPE_NAME1right), rest671)

end
|  ( 83, ( ( _, ( _, _, (RPARENright as RPAREN1right))) :: ( _, ( 
MlyValue.exprWComma exprWComma, _, _)) :: ( _, ( _, (LPARENleft as 
LPAREN1left), _)) :: rest671)) => let val  result = MlyValue.expr (
markExpression srcMap (exprWComma,LPARENleft,RPARENright))
 in ( LrTable.NT 6, ( result, LPAREN1left, RPAREN1right), rest671)
end
|  ( 84, ( ( _, ( MlyValue.DECNUM DECNUM, (DECNUMleft as DECNUM1left),
 (DECNUMright as DECNUM1right))) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (IntConst DECNUM,DECNUMleft,DECNUMright))
 in ( LrTable.NT 6, ( result, DECNUM1left, DECNUM1right), rest671)
end
|  ( 85, ( ( _, ( MlyValue.REALNUM REALNUM, (REALNUMleft as 
REALNUM1left), (REALNUMright as REALNUM1right))) :: rest671)) => let
 val  result = MlyValue.expr (
markExpression srcMap (RealConst REALNUM, REALNUMleft,REALNUMright))
 in ( LrTable.NT 6, ( result, REALNUM1left, REALNUM1right), rest671)

end
|  ( 86, ( ( _, ( MlyValue.CCONST CCONST, (CCONSTleft as CCONST1left),
 (CCONSTright as CCONST1right))) :: rest671)) => let val  result = 
MlyValue.expr (
markExpression srcMap (IntConst CCONST, CCONSTleft,CCONSTright))
 in ( LrTable.NT 6, ( result, CCONST1left, CCONST1right), rest671)
end
|  ( 87, ( ( _, ( MlyValue.ID ID, (IDleft as ID1left), (IDright as 
ID1right))) :: rest671)) => let val  result = MlyValue.expr (
markExpression srcMap (Id(ID), IDleft, IDright))
 in ( LrTable.NT 6, ( result, ID1left, ID1right), rest671)
end
|  ( 88, ( ( _, ( MlyValue.strings strings, (stringsleft as 
strings1left), (stringsright as strings1right))) :: rest671)) => let
 val  result = MlyValue.expr (
markExpression srcMap (String(strings),stringsleft,stringsright))
 in ( LrTable.NT 6, ( result, strings1left, strings1right), rest671)

end
|  ( 89, ( ( _, ( MlyValue.STRING STRING, STRING1left, STRING1right))
 :: rest671)) => let val  result = MlyValue.strings (STRING)
 in ( LrTable.NT 63, ( result, STRING1left, STRING1right), rest671)

end
|  ( 90, ( ( _, ( MlyValue.strings strings, _, strings1right)) :: ( _,
 ( MlyValue.STRING STRING, STRING1left, _)) :: rest671)) => let val  
result = MlyValue.strings (STRING ^ strings)
 in ( LrTable.NT 63, ( result, STRING1left, strings1right), rest671)

end
|  ( 91, ( ( _, ( MlyValue.expr expr, expr1left, expr1right)) :: 
rest671)) => let val  result = MlyValue.exprWComma (expr)
 in ( LrTable.NT 8, ( result, expr1left, expr1right), rest671)
end
|  ( 92, ( ( _, ( MlyValue.expr expr, _, (exprright as expr1right)))
 :: _ :: ( _, ( MlyValue.exprWComma exprWComma, (exprWCommaleft as 
exprWComma1left), _)) :: rest671)) => let val  result = 
MlyValue.exprWComma (
markExpression srcMap (Binop(Comma,exprWComma,expr),exprWCommaleft,exprright)
)
 in ( LrTable.NT 8, ( result, exprWComma1left, expr1right), rest671)

end
|  ( 93, ( rest671)) => let val  result = MlyValue.opExpr (EmptyExpr)
 in ( LrTable.NT 7, ( result, defaultPos, defaultPos), rest671)
end
|  ( 94, ( ( _, ( MlyValue.exprWComma exprWComma, exprWComma1left, 
exprWComma1right)) :: rest671)) => let val  result = MlyValue.opExpr (
exprWComma)
 in ( LrTable.NT 7, ( result, exprWComma1left, exprWComma1right), 
rest671)
end
|  ( 95, ( ( _, ( MlyValue.expr expr, expr1left, expr1right)) :: 
rest671)) => let val  result = MlyValue.argumentExprList (
singletonSeq expr)
 in ( LrTable.NT 10, ( result, expr1left, expr1right), rest671)
end
|  ( 96, ( ( _, ( MlyValue.expr expr, _, expr1right)) :: _ :: ( _, ( 
MlyValue.argumentExprList argumentExprList, argumentExprList1left, _))
 :: rest671)) => let val  result = MlyValue.argumentExprList (
addToSeq(expr, argumentExprList))
 in ( LrTable.NT 10, ( result, argumentExprList1left, expr1right), 
rest671)
end
|  ( 97, ( ( _, ( MlyValue.specifierQualifierList 
specifierQualifierList, specifierQualifierList1left, 
specifierQualifierList1right)) :: rest671)) => let val  result = 
MlyValue.typeName (specifierQualifierList)
 in ( LrTable.NT 36, ( result, specifierQualifierList1left, 
specifierQualifierList1right), rest671)
end
|  ( 98, ( ( _, ( MlyValue.abstractDeclarator abstractDeclarator, _, 
abstractDeclarator1right)) :: ( _, ( MlyValue.specifierQualifierList 
specifierQualifierList, specifierQualifierList1left, _)) :: rest671))
 => let val  result = MlyValue.typeName (
#1 (ctypeDecrToTypeName (specifierQualifierList, abstractDeclarator)))
 in ( LrTable.NT 36, ( result, specifierQualifierList1left, 
abstractDeclarator1right), rest671)
end
|  ( 99, ( ( _, ( MlyValue.reservedDeclarationSpecifier 
reservedDeclarationSpecifier, _, reservedDeclarationSpecifier1right))
 :: ( _, ( MlyValue.typeSpecifier typeSpecifier, typeSpecifier1left, _
)) :: rest671)) => let val  result = MlyValue.declarationSpecifiers (
addSpecifier (typeSpecifier,
						        reservedDeclarationSpecifier)
)
 in ( LrTable.NT 28, ( result, typeSpecifier1left, 
reservedDeclarationSpecifier1right), rest671)
end
|  ( 100, ( ( _, ( MlyValue.reservedDeclarationSpecifier 
reservedDeclarationSpecifier, _, reservedDeclarationSpecifier1right))
 :: ( _, ( MlyValue.typeSpecifier typeSpecifier, _, _)) :: ( _, ( 
MlyValue.declarationModifiers declarationModifiers, 
declarationModifiers1left, _)) :: rest671)) => let val  result = 
MlyValue.declarationSpecifiers (
addAll (declarationModifiers,
                                                  addSpecifier (typeSpecifier,
							         reservedDeclarationSpecifier))
)
 in ( LrTable.NT 28, ( result, declarationModifiers1left, 
reservedDeclarationSpecifier1right), rest671)
end
|  ( 101, ( rest671)) => let val  result = 
MlyValue.reservedDeclarationSpecifier (unknown)
 in ( LrTable.NT 30, ( result, defaultPos, defaultPos), rest671)
end
|  ( 102, ( ( _, ( MlyValue.specifierQualifierReserved 
specifierQualifierReserved, _, specifierQualifierReserved1right)) :: (
 _, ( MlyValue.reservedDeclarationSpecifier 
reservedDeclarationSpecifier, reservedDeclarationSpecifier1left, _))
 :: rest671)) => let val  result = 
MlyValue.reservedDeclarationSpecifier (
let val {qualifiers,specifiers} = specifierQualifierReserved
					     val decltype = {qualifiers=qualifiers,specifiers=specifiers,storage=[]}
	   				 in addAll (decltype, reservedDeclarationSpecifier) end 
)
 in ( LrTable.NT 30, ( result, reservedDeclarationSpecifier1left, 
specifierQualifierReserved1right), rest671)
end
|  ( 103, ( ( _, ( MlyValue.storageClassSpecifier 
storageClassSpecifier, _, storageClassSpecifier1right)) :: ( _, ( 
MlyValue.reservedDeclarationSpecifier reservedDeclarationSpecifier, 
reservedDeclarationSpecifier1left, _)) :: rest671)) => let val  result
 = MlyValue.reservedDeclarationSpecifier (
addStorage (storageClassSpecifier,
                                                      reservedDeclarationSpecifier)
)
 in ( LrTable.NT 30, ( result, reservedDeclarationSpecifier1left, 
storageClassSpecifier1right), rest671)
end
|  ( 104, ( ( _, ( MlyValue.typeSpecifierReserved 
typeSpecifierReserved, typeSpecifierReserved1left, 
typeSpecifierReserved1right)) :: rest671)) => let val  result = 
MlyValue.specifierQualifierReserved (
{qualifiers=[],specifiers=[typeSpecifierReserved]})
 in ( LrTable.NT 31, ( result, typeSpecifierReserved1left, 
typeSpecifierReserved1right), rest671)
end
|  ( 105, ( ( _, ( MlyValue.typeQualifier typeQualifier, 
typeQualifier1left, typeQualifier1right)) :: rest671)) => let val  
result = MlyValue.specifierQualifierReserved (
{qualifiers=[typeQualifier],specifiers=[]})
 in ( LrTable.NT 31, ( result, typeQualifier1left, typeQualifier1right
), rest671)
end
|  ( 106, ( ( _, ( MlyValue.structOrUnionSpecifier 
structOrUnionSpecifier, structOrUnionSpecifier1left, 
structOrUnionSpecifier1right)) :: rest671)) => let val  result = 
MlyValue.specifierQualifierReserved (
{qualifiers=[],specifiers=[structOrUnionSpecifier]})
 in ( LrTable.NT 31, ( result, structOrUnionSpecifier1left, 
structOrUnionSpecifier1right), rest671)
end
|  ( 107, ( ( _, ( MlyValue.enumSpecifier enumSpecifier, 
enumSpecifier1left, enumSpecifier1right)) :: rest671)) => let val  
result = MlyValue.specifierQualifierReserved (
{qualifiers=[],specifiers=[enumSpecifier]})
 in ( LrTable.NT 31, ( result, enumSpecifier1left, enumSpecifier1right
), rest671)
end
|  ( 108, ( ( _, ( MlyValue.storageClassSpecifier 
storageClassSpecifier, storageClassSpecifier1left, 
storageClassSpecifier1right)) :: rest671)) => let val  result = 
MlyValue.declarationModifiers (
{storage = [storageClassSpecifier],
					  qualifiers = [],
					  specifiers = []}
)
 in ( LrTable.NT 29, ( result, storageClassSpecifier1left, 
storageClassSpecifier1right), rest671)
end
|  ( 109, ( ( _, ( MlyValue.storageClassSpecifier 
storageClassSpecifier, _, storageClassSpecifier1right)) :: ( _, ( 
MlyValue.declarationModifiers declarationModifiers, 
declarationModifiers1left, _)) :: rest671)) => let val  result = 
MlyValue.declarationModifiers (
addStorage(storageClassSpecifier,declarationModifiers))
 in ( LrTable.NT 29, ( result, declarationModifiers1left, 
storageClassSpecifier1right), rest671)
end
|  ( 110, ( ( _, ( MlyValue.typeQualifier typeQualifier, 
typeQualifier1left, typeQualifier1right)) :: rest671)) => let val  
result = MlyValue.declarationModifiers (
{specifiers = [],
	 				  storage = [], 
					  qualifiers = [typeQualifier]}
)
 in ( LrTable.NT 29, ( result, typeQualifier1left, typeQualifier1right
), rest671)
end
|  ( 111, ( ( _, ( MlyValue.typeQualifier typeQualifier, _, 
typeQualifier1right)) :: ( _, ( MlyValue.declarationModifiers 
declarationModifiers, declarationModifiers1left, _)) :: rest671)) =>
 let val  result = MlyValue.declarationModifiers (
addQualifier(typeQualifier, declarationModifiers))
 in ( LrTable.NT 29, ( result, declarationModifiers1left, 
typeQualifier1right), rest671)
end
|  ( 112, ( ( _, ( MlyValue.reservedSpecifierQualifiers 
reservedSpecifierQualifiers, _, reservedSpecifierQualifiers1right)) ::
 ( _, ( MlyValue.typeSpecifier typeSpecifier, typeSpecifier1left, _))
 :: rest671)) => let val  result = MlyValue.specifierQualifierList (
let val {specifiers, qualifiers} = reservedSpecifierQualifiers
	                                 in {specifiers=typeSpecifier::specifiers,qualifiers=qualifiers} end
)
 in ( LrTable.NT 41, ( result, typeSpecifier1left, 
reservedSpecifierQualifiers1right), rest671)
end
|  ( 113, ( ( _, ( MlyValue.reservedSpecifierQualifiers 
reservedSpecifierQualifiers, _, reservedSpecifierQualifiers1right)) ::
 ( _, ( MlyValue.typeSpecifier typeSpecifier, _, _)) :: ( _, ( 
MlyValue.typeQualifierList typeQualifierList, typeQualifierList1left,
 _)) :: rest671)) => let val  result = MlyValue.specifierQualifierList
 (
let val {specifiers, qualifiers} = reservedSpecifierQualifiers
	                                 in {specifiers=typeSpecifier::specifiers
					    ,qualifiers=typeQualifierList@qualifiers
                                            }
                                         end
)
 in ( LrTable.NT 41, ( result, typeQualifierList1left, 
reservedSpecifierQualifiers1right), rest671)
end
|  ( 114, ( rest671)) => let val  result = 
MlyValue.reservedSpecifierQualifiers ({qualifiers=[],specifiers=[]})
 in ( LrTable.NT 32, ( result, defaultPos, defaultPos), rest671)
end
|  ( 115, ( ( _, ( MlyValue.specifierQualifierReserved 
specifierQualifierReserved, _, specifierQualifierReserved1right)) :: (
 _, ( MlyValue.reservedSpecifierQualifiers reservedSpecifierQualifiers
, reservedSpecifierQualifiers1left, _)) :: rest671)) => let val  
result = MlyValue.reservedSpecifierQualifiers (
let val {specifiers=s1, qualifiers=q1} = reservedSpecifierQualifiers
					     val {specifiers=s2, qualifiers=q2} = specifierQualifierReserved
	                                 in {specifiers=s1@s2, qualifiers=q1@q2} end
)
 in ( LrTable.NT 32, ( result, reservedSpecifierQualifiers1left, 
specifierQualifierReserved1right), rest671)
end
|  ( 116, ( ( _, ( MlyValue.typeQualifier typeQualifier, 
typeQualifier1left, typeQualifier1right)) :: rest671)) => let val  
result = MlyValue.typeQualifierList ([typeQualifier])
 in ( LrTable.NT 40, ( result, typeQualifier1left, typeQualifier1right
), rest671)
end
|  ( 117, ( ( _, ( MlyValue.typeQualifierList typeQualifierList, _, 
typeQualifierList1right)) :: ( _, ( MlyValue.typeQualifier 
typeQualifier, typeQualifier1left, _)) :: rest671)) => let val  result
 = MlyValue.typeQualifierList (typeQualifier::typeQualifierList)
 in ( LrTable.NT 40, ( result, typeQualifier1left, 
typeQualifierList1right), rest671)
end
|  ( 118, ( ( _, ( MlyValue.typeSpecifierReserved 
typeSpecifierReserved, typeSpecifierReserved1left, 
typeSpecifierReserved1right)) :: rest671)) => let val  result = 
MlyValue.typeSpecifier (typeSpecifierReserved)
 in ( LrTable.NT 37, ( result, typeSpecifierReserved1left, 
typeSpecifierReserved1right), rest671)
end
|  ( 119, ( ( _, ( MlyValue.structOrUnionSpecifier 
structOrUnionSpecifier, structOrUnionSpecifier1left, 
structOrUnionSpecifier1right)) :: rest671)) => let val  result = 
MlyValue.typeSpecifier (structOrUnionSpecifier)
 in ( LrTable.NT 37, ( result, structOrUnionSpecifier1left, 
structOrUnionSpecifier1right), rest671)
end
|  ( 120, ( ( _, ( MlyValue.enumSpecifier enumSpecifier, 
enumSpecifier1left, enumSpecifier1right)) :: rest671)) => let val  
result = MlyValue.typeSpecifier (enumSpecifier)
 in ( LrTable.NT 37, ( result, enumSpecifier1left, enumSpecifier1right
), rest671)
end
|  ( 121, ( ( _, ( MlyValue.TYPE_NAME TYPE_NAME, TYPE_NAME1left, 
TYPE_NAME1right)) :: rest671)) => let val  result = 
MlyValue.typeSpecifier (TypedefName TYPE_NAME)
 in ( LrTable.NT 37, ( result, TYPE_NAME1left, TYPE_NAME1right), 
rest671)
end
|  ( 122, ( ( _, ( _, VOID1left, VOID1right)) :: rest671)) => let val 
 result = MlyValue.typeSpecifierReserved (Void)
 in ( LrTable.NT 38, ( result, VOID1left, VOID1right), rest671)
end
|  ( 123, ( ( _, ( _, CHAR1left, CHAR1right)) :: rest671)) => let val 
 result = MlyValue.typeSpecifierReserved (Char)
 in ( LrTable.NT 38, ( result, CHAR1left, CHAR1right), rest671)
end
|  ( 124, ( ( _, ( _, SHORT1left, SHORT1right)) :: rest671)) => let
 val  result = MlyValue.typeSpecifierReserved (Short)
 in ( LrTable.NT 38, ( result, SHORT1left, SHORT1right), rest671)
end
|  ( 125, ( ( _, ( _, INT1left, INT1right)) :: rest671)) => let val  
result = MlyValue.typeSpecifierReserved (Int)
 in ( LrTable.NT 38, ( result, INT1left, INT1right), rest671)
end
|  ( 126, ( ( _, ( _, LONG1left, LONG1right)) :: rest671)) => let val 
 result = MlyValue.typeSpecifierReserved (Long)
 in ( LrTable.NT 38, ( result, LONG1left, LONG1right), rest671)
end
|  ( 127, ( ( _, ( _, FLOAT1left, FLOAT1right)) :: rest671)) => let
 val  result = MlyValue.typeSpecifierReserved (Float)
 in ( LrTable.NT 38, ( result, FLOAT1left, FLOAT1right), rest671)
end
|  ( 128, ( ( _, ( _, DOUBLE1left, DOUBLE1right)) :: rest671)) => let
 val  result = MlyValue.typeSpecifierReserved (Double)
 in ( LrTable.NT 38, ( result, DOUBLE1left, DOUBLE1right), rest671)

end
|  ( 129, ( ( _, ( _, SIGNED1left, SIGNED1right)) :: rest671)) => let
 val  result = MlyValue.typeSpecifierReserved (Signed)
 in ( LrTable.NT 38, ( result, SIGNED1left, SIGNED1right), rest671)

end
|  ( 130, ( ( _, ( _, UNSIGNED1left, UNSIGNED1right)) :: rest671)) =>
 let val  result = MlyValue.typeSpecifierReserved (Unsigned)
 in ( LrTable.NT 38, ( result, UNSIGNED1left, UNSIGNED1right), rest671
)
end
|  ( 131, ( ( _, ( _, _, RCURLY1right)) :: ( _, ( 
MlyValue.structDeclarationList structDeclarationList, _, _)) :: _ :: (
 _, ( MlyValue.structOrUnion structOrUnion, structOrUnion1left, _)) ::
 rest671)) => let val  result = MlyValue.structOrUnionSpecifier (
Struct{isStruct=structOrUnion, tagOpt=NONE, members=seqToList structDeclarationList}
)
 in ( LrTable.NT 43, ( result, structOrUnion1left, RCURLY1right), 
rest671)
end
|  ( 132, ( ( _, ( _, _, RCURLY1right)) :: ( _, ( 
MlyValue.structDeclarationList structDeclarationList, _, _)) :: _ :: (
 _, ( MlyValue.ID ID, _, _)) :: ( _, ( MlyValue.structOrUnion 
structOrUnion, structOrUnion1left, _)) :: rest671)) => let val  result
 = MlyValue.structOrUnionSpecifier (
Struct{isStruct=structOrUnion, tagOpt=SOME ID, members=seqToList structDeclarationList}
)
 in ( LrTable.NT 43, ( result, structOrUnion1left, RCURLY1right), 
rest671)
end
|  ( 133, ( ( _, ( _, _, RCURLY1right)) :: ( _, ( 
MlyValue.structDeclarationList structDeclarationList, _, _)) :: _ :: (
 _, ( MlyValue.TYPE_NAME TYPE_NAME, _, _)) :: ( _, ( 
MlyValue.structOrUnion structOrUnion, structOrUnion1left, _)) :: 
rest671)) => let val  result = MlyValue.structOrUnionSpecifier (
Struct{isStruct=structOrUnion, tagOpt=SOME TYPE_NAME, members=seqToList structDeclarationList}
)
 in ( LrTable.NT 43, ( result, structOrUnion1left, RCURLY1right), 
rest671)
end
|  ( 134, ( ( _, ( MlyValue.ID ID, _, ID1right)) :: ( _, ( 
MlyValue.structOrUnion structOrUnion, structOrUnion1left, _)) :: 
rest671)) => let val  result = MlyValue.structOrUnionSpecifier (
StructTag {isStruct=structOrUnion, name=ID})
 in ( LrTable.NT 43, ( result, structOrUnion1left, ID1right), rest671)

end
|  ( 135, ( ( _, ( MlyValue.TYPE_NAME TYPE_NAME, _, TYPE_NAME1right))
 :: ( _, ( MlyValue.structOrUnion structOrUnion, structOrUnion1left, _
)) :: rest671)) => let val  result = MlyValue.structOrUnionSpecifier (
StructTag {isStruct=structOrUnion, name=TYPE_NAME})
 in ( LrTable.NT 43, ( result, structOrUnion1left, TYPE_NAME1right), 
rest671)
end
|  ( 136, ( ( _, ( _, STRUCT1left, STRUCT1right)) :: rest671)) => let
 val  result = MlyValue.structOrUnion (true)
 in ( LrTable.NT 54, ( result, STRUCT1left, STRUCT1right), rest671)

end
|  ( 137, ( ( _, ( _, UNION1left, UNION1right)) :: rest671)) => let
 val  result = MlyValue.structOrUnion (false)
 in ( LrTable.NT 54, ( result, UNION1left, UNION1right), rest671)
end
|  ( 138, ( ( _, ( MlyValue.structDeclaration structDeclaration, 
structDeclaration1left, structDeclaration1right)) :: rest671)) => let
 val  result = MlyValue.structDeclarationList (
singletonSeq structDeclaration)
 in ( LrTable.NT 59, ( result, structDeclaration1left, 
structDeclaration1right), rest671)
end
|  ( 139, ( ( _, ( MlyValue.structDeclaration structDeclaration, _, 
structDeclaration1right)) :: ( _, ( MlyValue.structDeclarationList 
structDeclarationList, structDeclarationList1left, _)) :: rest671)) =>
 let val  result = MlyValue.structDeclarationList (
addToSeq(structDeclaration, structDeclarationList))
 in ( LrTable.NT 59, ( result, structDeclarationList1left, 
structDeclaration1right), rest671)
end
|  ( 140, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( 
MlyValue.structDeclaratorList structDeclaratorList, _, _)) :: ( _, ( 
MlyValue.specifierQualifierList specifierQualifierList, 
specifierQualifierList1left, _)) :: rest671)) => let val  result = 
MlyValue.structDeclaration (
(specifierQualifierList, seqToList structDeclaratorList))
 in ( LrTable.NT 60, ( result, specifierQualifierList1left, 
SEMICOLON1right), rest671)
end
|  ( 141, ( ( _, ( _, _, SEMICOLON1right)) :: ( _, ( 
MlyValue.notypeStructDeclaratorList notypeStructDeclaratorList, _, _))
 :: ( _, ( MlyValue.typeQualifierList typeQualifierList, 
typeQualifierList1left, _)) :: rest671)) => let val  result = 
MlyValue.structDeclaration (
let
					    val ct = {qualifiers=typeQualifierList, specifiers=[]}
					 in
					   (ct, seqToList notypeStructDeclaratorList)
					 end
)
 in ( LrTable.NT 60, ( result, typeQualifierList1left, SEMICOLON1right
), rest671)
end
|  ( 142, ( ( _, ( MlyValue.structDeclarator structDeclarator, 
structDeclarator1left, structDeclarator1right)) :: rest671)) => let
 val  result = MlyValue.structDeclaratorList (
singletonSeq structDeclarator)
 in ( LrTable.NT 57, ( result, structDeclarator1left, 
structDeclarator1right), rest671)
end
|  ( 143, ( ( _, ( MlyValue.structDeclarator structDeclarator, _, 
structDeclarator1right)) :: _ :: ( _, ( MlyValue.structDeclaratorList 
structDeclaratorList, structDeclaratorList1left, _)) :: rest671)) =>
 let val  result = MlyValue.structDeclaratorList (
addToSeq(structDeclarator, structDeclaratorList))
 in ( LrTable.NT 57, ( result, structDeclaratorList1left, 
structDeclarator1right), rest671)
end
|  ( 144, ( ( _, ( MlyValue.notypeStructDeclarator 
notypeStructDeclarator, notypeStructDeclarator1left, 
notypeStructDeclarator1right)) :: rest671)) => let val  result = 
MlyValue.notypeStructDeclaratorList (
singletonSeq notypeStructDeclarator)
 in ( LrTable.NT 58, ( result, notypeStructDeclarator1left, 
notypeStructDeclarator1right), rest671)
end
|  ( 145, ( ( _, ( MlyValue.structDeclarator structDeclarator, _, 
structDeclarator1right)) :: _ :: ( _, ( 
MlyValue.notypeStructDeclaratorList notypeStructDeclaratorList, 
notypeStructDeclaratorList1left, _)) :: rest671)) => let val  result =
 MlyValue.notypeStructDeclaratorList (
addToSeq(structDeclarator, notypeStructDeclaratorList))
 in ( LrTable.NT 58, ( result, notypeStructDeclaratorList1left, 
structDeclarator1right), rest671)
end
|  ( 146, ( ( _, ( MlyValue.declarator declarator, declarator1left, 
declarator1right)) :: rest671)) => let val  result = 
MlyValue.structDeclarator (declarator, EmptyExpr)
 in ( LrTable.NT 55, ( result, declarator1left, declarator1right), 
rest671)
end
|  ( 147, ( ( _, ( MlyValue.expr expr, _, expr1right)) :: ( _, ( _, 
COLON1left, _)) :: rest671)) => let val  result = 
MlyValue.structDeclarator (EmptyDecr, expr)
 in ( LrTable.NT 55, ( result, COLON1left, expr1right), rest671)
end
|  ( 148, ( ( _, ( MlyValue.expr expr, _, expr1right)) :: _ :: ( _, ( 
MlyValue.declarator declarator, declarator1left, _)) :: rest671)) =>
 let val  result = MlyValue.structDeclarator (declarator, expr)
 in ( LrTable.NT 55, ( result, declarator1left, expr1right), rest671)

end
|  ( 149, ( ( _, ( MlyValue.notypeDeclarator notypeDeclarator, 
notypeDeclarator1left, notypeDeclarator1right)) :: rest671)) => let
 val  result = MlyValue.notypeStructDeclarator (
notypeDeclarator, EmptyExpr)
 in ( LrTable.NT 56, ( result, notypeDeclarator1left, 
notypeDeclarator1right), rest671)
end
|  ( 150, ( ( _, ( MlyValue.expr expr, _, expr1right)) :: ( _, ( _, 
COLON1left, _)) :: rest671)) => let val  result = 
MlyValue.notypeStructDeclarator (EmptyDecr, expr)
 in ( LrTable.NT 56, ( result, COLON1left, expr1right), rest671)
end
|  ( 151, ( ( _, ( MlyValue.expr expr, _, expr1right)) :: _ :: ( _, ( 
MlyValue.notypeDeclarator notypeDeclarator, notypeDeclarator1left, _))
 :: rest671)) => let val  result = MlyValue.notypeStructDeclarator (
notypeDeclarator, expr)
 in ( LrTable.NT 56, ( result, notypeDeclarator1left, expr1right), 
rest671)
end
|  ( 152, ( ( _, ( _, CONST1left, CONST1right)) :: rest671)) => let
 val  result = MlyValue.typeQualifier (CONST)
 in ( LrTable.NT 39, ( result, CONST1left, CONST1right), rest671)
end
|  ( 153, ( ( _, ( _, VOLATILE1left, VOLATILE1right)) :: rest671)) =>
 let val  result = MlyValue.typeQualifier (VOLATILE)
 in ( LrTable.NT 39, ( result, VOLATILE1left, VOLATILE1right), rest671
)
end
|  ( 154, ( ( _, ( _, _, RCURLY1right)) :: ( _, ( 
MlyValue.trailingComma trailingComma, _, _)) :: ( _, ( 
MlyValue.enumeratorList enumeratorList, _, _)) :: _ :: ( _, ( _, 
ENUM1left, _)) :: rest671)) => let val  result = 
MlyValue.enumSpecifier (
Enum{tagOpt=NONE, enumerators=seqToList enumeratorList, trailingComma=trailingComma}
)
 in ( LrTable.NT 42, ( result, ENUM1left, RCURLY1right), rest671)
end
|  ( 155, ( ( _, ( _, _, RCURLY1right)) :: ( _, ( 
MlyValue.trailingComma trailingComma, _, _)) :: ( _, ( 
MlyValue.enumeratorList enumeratorList, _, _)) :: _ :: ( _, ( 
MlyValue.ID ID, _, _)) :: ( _, ( _, ENUM1left, _)) :: rest671)) => let
 val  result = MlyValue.enumSpecifier (
Enum{tagOpt=SOME(ID), enumerators=seqToList enumeratorList, trailingComma=trailingComma}
)
 in ( LrTable.NT 42, ( result, ENUM1left, RCURLY1right), rest671)
end
|  ( 156, ( ( _, ( _, _, RCURLY1right)) :: ( _, ( 
MlyValue.trailingComma trailingComma, _, _)) :: ( _, ( 
MlyValue.enumeratorList enumeratorList, _, _)) :: _ :: ( _, ( 
MlyValue.TYPE_NAME TYPE_NAME, _, _)) :: ( _, ( _, ENUM1left, _)) :: 
rest671)) => let val  result = MlyValue.enumSpecifier (
Enum{tagOpt=SOME(TYPE_NAME), enumerators=seqToList enumeratorList, trailingComma=trailingComma}
)
 in ( LrTable.NT 42, ( result, ENUM1left, RCURLY1right), rest671)
end
|  ( 157, ( ( _, ( MlyValue.ID ID, _, ID1right)) :: ( _, ( _, 
ENUM1left, _)) :: rest671)) => let val  result = 
MlyValue.enumSpecifier (EnumTag(ID))
 in ( LrTable.NT 42, ( result, ENUM1left, ID1right), rest671)
end
|  ( 158, ( ( _, ( MlyValue.TYPE_NAME TYPE_NAME, _, TYPE_NAME1right))
 :: ( _, ( _, ENUM1left, _)) :: rest671)) => let val  result = 
MlyValue.enumSpecifier (EnumTag(TYPE_NAME))
 in ( LrTable.NT 42, ( result, ENUM1left, TYPE_NAME1right), rest671)

end
|  ( 159, ( ( _, ( MlyValue.enumerator enumerator, _, enumerator1right
)) :: _ :: ( _, ( MlyValue.enumeratorList enumeratorList, 
enumeratorList1left, _)) :: rest671)) => let val  result = 
MlyValue.enumeratorList (addToSeq(enumerator, enumeratorList))
 in ( LrTable.NT 12, ( result, enumeratorList1left, enumerator1right),
 rest671)
end
|  ( 160, ( ( _, ( MlyValue.enumerator enumerator, enumerator1left, 
enumerator1right)) :: rest671)) => let val  result = 
MlyValue.enumeratorList (
(TypeDefs.addNoTdef(#1(enumerator)));
					 singletonSeq enumerator)
 in ( LrTable.NT 12, ( result, enumerator1left, enumerator1right), 
rest671)
end
|  ( 161, ( ( _, ( MlyValue.ID ID, ID1left, ID1right)) :: rest671)) =>
 let val  result = MlyValue.enumerator ((ID,ParseTree.EmptyExpr))
 in ( LrTable.NT 13, ( result, ID1left, ID1right), rest671)
end
|  ( 162, ( ( _, ( MlyValue.expr expr, _, expr1right)) :: _ :: ( _, ( 
MlyValue.ID ID, ID1left, _)) :: rest671)) => let val  result = 
MlyValue.enumerator (ID,expr)
 in ( LrTable.NT 13, ( result, ID1left, expr1right), rest671)
end
|  ( 163, ( ( _, ( _, EXTERN1left, EXTERN1right)) :: rest671)) => let
 val  result = MlyValue.storageClassSpecifier (EXTERN)
 in ( LrTable.NT 35, ( result, EXTERN1left, EXTERN1right), rest671)

end
|  ( 164, ( ( _, ( _, STATIC1left, STATIC1right)) :: rest671)) => let
 val  result = MlyValue.storageClassSpecifier (STATIC)
 in ( LrTable.NT 35, ( result, STATIC1left, STATIC1right), rest671)

end
|  ( 165, ( ( _, ( _, AUTO1left, AUTO1right)) :: rest671)) => let val 
 result = MlyValue.storageClassSpecifier (AUTO)
 in ( LrTable.NT 35, ( result, AUTO1left, AUTO1right), rest671)
end
|  ( 166, ( ( _, ( _, REGISTER1left, REGISTER1right)) :: rest671)) =>
 let val  result = MlyValue.storageClassSpecifier (REGISTER)
 in ( LrTable.NT 35, ( result, REGISTER1left, REGISTER1right), rest671
)
end
|  ( 167, ( ( _, ( _, TYPEDEF1left, TYPEDEF1right)) :: rest671)) =>
 let val  result = MlyValue.storageClassSpecifier (TYPEDEF)
 in ( LrTable.NT 35, ( result, TYPEDEF1left, TYPEDEF1right), rest671)

end
|  ( 168, ( rest671)) => let val  result = MlyValue.trailingComma (
false)
 in ( LrTable.NT 11, ( result, defaultPos, defaultPos), rest671)
end
|  ( 169, ( ( _, ( _, COMMA1left, COMMA1right)) :: rest671)) => let
 val  result = MlyValue.trailingComma (true)
 in ( LrTable.NT 11, ( result, COMMA1left, COMMA1right), rest671)
end
|  ( 170, ( ( _, ( MlyValue.initDeclarator initDeclarator, 
initDeclarator1left, initDeclarator1right)) :: rest671)) => let val  
result = MlyValue.initDeclaratorList (singletonSeq initDeclarator)
 in ( LrTable.NT 18, ( result, initDeclarator1left, 
initDeclarator1right), rest671)
end
|  ( 171, ( ( _, ( MlyValue.initDeclarator initDeclarator, _, 
initDeclarator1right)) :: _ :: ( _, ( MlyValue.initDeclaratorList 
initDeclaratorList, initDeclaratorList1left, _)) :: rest671)) => let
 val  result = MlyValue.initDeclaratorList (
addToSeq(initDeclarator, initDeclaratorList))
 in ( LrTable.NT 18, ( result, initDeclaratorList1left, 
initDeclarator1right), rest671)
end
|  ( 172, ( ( _, ( MlyValue.declarator declarator, declarator1left, 
declarator1right)) :: rest671)) => let val  result = 
MlyValue.initDeclarator ((declarator,EmptyExpr))
 in ( LrTable.NT 16, ( result, declarator1left, declarator1right), 
rest671)
end
|  ( 173, ( ( _, ( MlyValue.initializer initializer, _, 
initializer1right)) :: _ :: ( _, ( MlyValue.declarator declarator, 
declarator1left, _)) :: rest671)) => let val  result = 
MlyValue.initDeclarator (declarator,initializer)
 in ( LrTable.NT 16, ( result, declarator1left, initializer1right), 
rest671)
end
|  ( 174, ( ( _, ( MlyValue.notypeInitDeclarator notypeInitDeclarator,
 notypeInitDeclarator1left, notypeInitDeclarator1right)) :: rest671))
 => let val  result = MlyValue.notypeInitDeclaratorList (
singletonSeq notypeInitDeclarator)
 in ( LrTable.NT 19, ( result, notypeInitDeclarator1left, 
notypeInitDeclarator1right), rest671)
end
|  ( 175, ( ( _, ( MlyValue.initDeclarator initDeclarator, _, 
initDeclarator1right)) :: _ :: ( _, ( 
MlyValue.notypeInitDeclaratorList notypeInitDeclaratorList, 
notypeInitDeclaratorList1left, _)) :: rest671)) => let val  result = 
MlyValue.notypeInitDeclaratorList (
addToSeq(initDeclarator, notypeInitDeclaratorList))
 in ( LrTable.NT 19, ( result, notypeInitDeclaratorList1left, 
initDeclarator1right), rest671)
end
|  ( 176, ( ( _, ( MlyValue.notypeDeclarator notypeDeclarator, 
notypeDeclarator1left, notypeDeclarator1right)) :: rest671)) => let
 val  result = MlyValue.notypeInitDeclarator (
(notypeDeclarator,EmptyExpr))
 in ( LrTable.NT 17, ( result, notypeDeclarator1left, 
notypeDeclarator1right), rest671)
end
|  ( 177, ( ( _, ( MlyValue.initializer initializer, _, 
initializer1right)) :: _ :: ( _, ( MlyValue.notypeDeclarator 
notypeDeclarator, notypeDeclarator1left, _)) :: rest671)) => let val  
result = MlyValue.notypeInitDeclarator (notypeDeclarator,initializer)
 in ( LrTable.NT 17, ( result, notypeDeclarator1left, 
initializer1right), rest671)
end
|  ( 178, ( ( _, ( MlyValue.aftertypeDeclarator aftertypeDeclarator, 
aftertypeDeclarator1left, aftertypeDeclarator1right)) :: rest671)) =>
 let val  result = MlyValue.declarator (aftertypeDeclarator)
 in ( LrTable.NT 21, ( result, aftertypeDeclarator1left, 
aftertypeDeclarator1right), rest671)
end
|  ( 179, ( ( _, ( MlyValue.notypeDeclarator notypeDeclarator, 
notypeDeclarator1left, notypeDeclarator1right)) :: rest671)) => let
 val  result = MlyValue.declarator (notypeDeclarator)
 in ( LrTable.NT 21, ( result, notypeDeclarator1left, 
notypeDeclarator1right), rest671)
end
|  ( 180, ( ( _, ( MlyValue.aftertypeDirectDeclarator 
aftertypeDirectDeclarator, aftertypeDirectDeclarator1left, 
aftertypeDirectDeclarator1right)) :: rest671)) => let val  result = 
MlyValue.aftertypeDeclarator (aftertypeDirectDeclarator)
 in ( LrTable.NT 22, ( result, aftertypeDirectDeclarator1left, 
aftertypeDirectDeclarator1right), rest671)
end
|  ( 181, ( ( _, ( MlyValue.aftertypeDirectDeclarator 
aftertypeDirectDeclarator, _, aftertypeDirectDeclarator1right)) :: ( _
, ( MlyValue.pointer pointer, pointer1left, _)) :: rest671)) => let
 val  result = MlyValue.aftertypeDeclarator (
applyPointer(pointer,aftertypeDirectDeclarator))
 in ( LrTable.NT 22, ( result, pointer1left, 
aftertypeDirectDeclarator1right), rest671)
end
|  ( 182, ( ( _, ( MlyValue.notypeDirectDeclarator 
notypeDirectDeclarator, notypeDirectDeclarator1left, 
notypeDirectDeclarator1right)) :: rest671)) => let val  result = 
MlyValue.notypeDeclarator (notypeDirectDeclarator)
 in ( LrTable.NT 23, ( result, notypeDirectDeclarator1left, 
notypeDirectDeclarator1right), rest671)
end
|  ( 183, ( ( _, ( MlyValue.notypeDirectDeclarator 
notypeDirectDeclarator, _, notypeDirectDeclarator1right)) :: ( _, ( 
MlyValue.pointer pointer, pointer1left, _)) :: rest671)) => let val  
result = MlyValue.notypeDeclarator (
applyPointer(pointer, notypeDirectDeclarator))
 in ( LrTable.NT 23, ( result, pointer1left, 
notypeDirectDeclarator1right), rest671)
end
|  ( 184, ( ( _, ( MlyValue.parmDirectDeclarator parmDirectDeclarator,
 parmDirectDeclarator1left, parmDirectDeclarator1right)) :: rest671))
 => let val  result = MlyValue.parmDeclarator (parmDirectDeclarator)
 in ( LrTable.NT 24, ( result, parmDirectDeclarator1left, 
parmDirectDeclarator1right), rest671)
end
|  ( 185, ( ( _, ( MlyValue.parmDirectDeclarator parmDirectDeclarator,
 _, parmDirectDeclarator1right)) :: ( _, ( MlyValue.pointer pointer, 
pointer1left, _)) :: rest671)) => let val  result = 
MlyValue.parmDeclarator (applyPointer(pointer, parmDirectDeclarator))
 in ( LrTable.NT 24, ( result, pointer1left, 
parmDirectDeclarator1right), rest671)
end
|  ( 186, ( ( _, ( _, TIMES1left, TIMES1right)) :: rest671)) => let
 val  result = MlyValue.pointer (PointerDecr(EmptyDecr))
 in ( LrTable.NT 20, ( result, TIMES1left, TIMES1right), rest671)
end
|  ( 187, ( ( _, ( MlyValue.typeQualifierList typeQualifierList, _, 
typeQualifierList1right)) :: ( _, ( _, TIMES1left, _)) :: rest671)) =>
 let val  result = MlyValue.pointer (
PointerDecr(loopQd(typeQualifierList,EmptyDecr)))
 in ( LrTable.NT 20, ( result, TIMES1left, typeQualifierList1right), 
rest671)
end
|  ( 188, ( ( _, ( MlyValue.pointer pointer, _, pointer1right)) :: ( _
, ( _, TIMES1left, _)) :: rest671)) => let val  result = 
MlyValue.pointer (PointerDecr(pointer))
 in ( LrTable.NT 20, ( result, TIMES1left, pointer1right), rest671)

end
|  ( 189, ( ( _, ( MlyValue.pointer pointer, _, pointer1right)) :: ( _
, ( MlyValue.typeQualifierList typeQualifierList, _, _)) :: ( _, ( _, 
TIMES1left, _)) :: rest671)) => let val  result = MlyValue.pointer (
PointerDecr(loopQd(typeQualifierList,pointer)))
 in ( LrTable.NT 20, ( result, TIMES1left, pointer1right), rest671)

end
|  ( 190, ( ( _, ( MlyValue.TYPE_NAME TYPE_NAME, (TYPE_NAMEleft as 
TYPE_NAME1left), (TYPE_NAMEright as TYPE_NAME1right))) :: rest671)) =>
 let val  result = MlyValue.aftertypeDirectDeclarator (
markDeclarator srcMap (VarDecr TYPE_NAME,TYPE_NAMEleft,TYPE_NAMEright)
)
 in ( LrTable.NT 25, ( result, TYPE_NAME1left, TYPE_NAME1right), 
rest671)
end
|  ( 191, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.aftertypeDeclarator aftertypeDeclarator, _, _)) :: ( _, ( _, 
LPAREN1left, _)) :: rest671)) => let val  result = 
MlyValue.aftertypeDirectDeclarator (aftertypeDeclarator)
 in ( LrTable.NT 25, ( result, LPAREN1left, RPAREN1right), rest671)

end
|  ( 192, ( ( _, ( _, _, RBRACE1right)) :: _ :: ( _, ( 
MlyValue.aftertypeDirectDeclarator aftertypeDirectDeclarator, 
aftertypeDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.aftertypeDirectDeclarator (
ArrayDecr (aftertypeDirectDeclarator,EmptyExpr))
 in ( LrTable.NT 25, ( result, aftertypeDirectDeclarator1left, 
RBRACE1right), rest671)
end
|  ( 193, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.expr expr,
 _, _)) :: _ :: ( _, ( MlyValue.aftertypeDirectDeclarator 
aftertypeDirectDeclarator, aftertypeDirectDeclarator1left, _)) :: 
rest671)) => let val  result = MlyValue.aftertypeDirectDeclarator (
ArrayDecr (aftertypeDirectDeclarator,expr))
 in ( LrTable.NT 25, ( result, aftertypeDirectDeclarator1left, 
RBRACE1right), rest671)
end
|  ( 194, ( ( _, ( _, _, RPAREN1right)) :: _ :: ( _, ( 
MlyValue.aftertypeDirectDeclarator aftertypeDirectDeclarator, 
aftertypeDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.aftertypeDirectDeclarator (
FuncDecr (aftertypeDirectDeclarator,nil))
 in ( LrTable.NT 25, ( result, aftertypeDirectDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 195, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.parameterTypeList parameterTypeList, _, _)) :: _ :: ( _, ( 
MlyValue.aftertypeDirectDeclarator aftertypeDirectDeclarator, 
aftertypeDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.aftertypeDirectDeclarator (
FuncDecr (aftertypeDirectDeclarator,parameterTypeList))
 in ( LrTable.NT 25, ( result, aftertypeDirectDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 196, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.identlist 
identlist, _, _)) :: _ :: ( _, ( MlyValue.aftertypeDirectDeclarator 
aftertypeDirectDeclarator, aftertypeDirectDeclarator1left, _)) :: 
rest671)) => let val  result = MlyValue.aftertypeDirectDeclarator (
FuncDecr (aftertypeDirectDeclarator,
					    map (fn (x,y,z) => (unknown,markDeclarator srcMap (VarDecr x,y,z))) (seqToList identlist))
)
 in ( LrTable.NT 25, ( result, aftertypeDirectDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 197, ( ( _, ( MlyValue.ID ID, (IDleft as ID1left), (IDright as 
ID1right))) :: rest671)) => let val  result = 
MlyValue.notypeDirectDeclarator (
markDeclarator srcMap (VarDecr ID,IDleft,IDright))
 in ( LrTable.NT 26, ( result, ID1left, ID1right), rest671)
end
|  ( 198, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.notypeDeclarator notypeDeclarator, _, _)) :: ( _, ( _, 
LPAREN1left, _)) :: rest671)) => let val  result = 
MlyValue.notypeDirectDeclarator (notypeDeclarator)
 in ( LrTable.NT 26, ( result, LPAREN1left, RPAREN1right), rest671)

end
|  ( 199, ( ( _, ( _, _, RBRACE1right)) :: _ :: ( _, ( 
MlyValue.notypeDirectDeclarator notypeDirectDeclarator, 
notypeDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.notypeDirectDeclarator (
ArrayDecr (notypeDirectDeclarator,EmptyExpr))
 in ( LrTable.NT 26, ( result, notypeDirectDeclarator1left, 
RBRACE1right), rest671)
end
|  ( 200, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.expr expr,
 _, _)) :: _ :: ( _, ( MlyValue.notypeDirectDeclarator 
notypeDirectDeclarator, notypeDirectDeclarator1left, _)) :: rest671))
 => let val  result = MlyValue.notypeDirectDeclarator (
ArrayDecr (notypeDirectDeclarator,expr))
 in ( LrTable.NT 26, ( result, notypeDirectDeclarator1left, 
RBRACE1right), rest671)
end
|  ( 201, ( ( _, ( _, _, RPAREN1right)) :: _ :: ( _, ( 
MlyValue.notypeDirectDeclarator notypeDirectDeclarator, 
notypeDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.notypeDirectDeclarator (FuncDecr (notypeDirectDeclarator,nil)
)
 in ( LrTable.NT 26, ( result, notypeDirectDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 202, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.parameterTypeList parameterTypeList, _, _)) :: _ :: ( _, ( 
MlyValue.notypeDirectDeclarator notypeDirectDeclarator, 
notypeDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.notypeDirectDeclarator (
FuncDecr (notypeDirectDeclarator,parameterTypeList))
 in ( LrTable.NT 26, ( result, notypeDirectDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 203, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.identlist 
identlist, _, _)) :: _ :: ( _, ( MlyValue.notypeDirectDeclarator 
notypeDirectDeclarator, notypeDirectDeclarator1left, _)) :: rest671))
 => let val  result = MlyValue.notypeDirectDeclarator (
FuncDecr (notypeDirectDeclarator,
 						   map (fn (x,y,z) => (unknown,markDeclarator srcMap (VarDecr x,y,z))) (seqToList identlist))
)
 in ( LrTable.NT 26, ( result, notypeDirectDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 204, ( ( _, ( MlyValue.TYPE_NAME TYPE_NAME, (TYPE_NAMEleft as 
TYPE_NAME1left), (TYPE_NAMEright as TYPE_NAME1right))) :: rest671)) =>
 let val  result = MlyValue.parmDirectDeclarator (
markDeclarator srcMap (VarDecr TYPE_NAME,TYPE_NAMEleft,TYPE_NAMEright)
)
 in ( LrTable.NT 27, ( result, TYPE_NAME1left, TYPE_NAME1right), 
rest671)
end
|  ( 205, ( ( _, ( _, _, RBRACE1right)) :: _ :: ( _, ( 
MlyValue.parmDirectDeclarator parmDirectDeclarator, 
parmDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.parmDirectDeclarator (
ArrayDecr (parmDirectDeclarator,EmptyExpr))
 in ( LrTable.NT 27, ( result, parmDirectDeclarator1left, RBRACE1right
), rest671)
end
|  ( 206, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.expr expr,
 _, _)) :: _ :: ( _, ( MlyValue.parmDirectDeclarator 
parmDirectDeclarator, parmDirectDeclarator1left, _)) :: rest671)) =>
 let val  result = MlyValue.parmDirectDeclarator (
ArrayDecr (parmDirectDeclarator,expr))
 in ( LrTable.NT 27, ( result, parmDirectDeclarator1left, RBRACE1right
), rest671)
end
|  ( 207, ( ( _, ( _, _, RPAREN1right)) :: _ :: ( _, ( 
MlyValue.parmDirectDeclarator parmDirectDeclarator, 
parmDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.parmDirectDeclarator (FuncDecr (parmDirectDeclarator,nil))
 in ( LrTable.NT 27, ( result, parmDirectDeclarator1left, RPAREN1right
), rest671)
end
|  ( 208, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.parameterTypeList parameterTypeList, _, _)) :: _ :: ( _, ( 
MlyValue.parmDirectDeclarator parmDirectDeclarator, 
parmDirectDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.parmDirectDeclarator (
FuncDecr (parmDirectDeclarator,parameterTypeList))
 in ( LrTable.NT 27, ( result, parmDirectDeclarator1left, RPAREN1right
), rest671)
end
|  ( 209, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( MlyValue.identlist 
identlist, _, _)) :: _ :: ( _, ( MlyValue.parmDirectDeclarator 
parmDirectDeclarator, parmDirectDeclarator1left, _)) :: rest671)) =>
 let val  result = MlyValue.parmDirectDeclarator (
FuncDecr (parmDirectDeclarator,
						    map (fn (x,y,z) => (unknown,markDeclarator srcMap (VarDecr x,y,z))) (seqToList identlist))
)
 in ( LrTable.NT 27, ( result, parmDirectDeclarator1left, RPAREN1right
), rest671)
end
|  ( 210, ( ( _, ( MlyValue.expr expr, expr1left, expr1right)) :: 
rest671)) => let val  result = MlyValue.initializer (expr)
 in ( LrTable.NT 33, ( result, expr1left, expr1right), rest671)
end
|  ( 211, ( ( _, ( _, _, (RCURLYright as RCURLY1right))) :: _ :: ( _, 
( MlyValue.initializerList initializerList, _, _)) :: ( _, ( _, (
LCURLYleft as LCURLY1left), _)) :: rest671)) => let val  result = 
MlyValue.initializer (
markExpression srcMap (InitList(seqToList initializerList),LCURLYleft,RCURLYright)
)
 in ( LrTable.NT 33, ( result, LCURLY1left, RCURLY1right), rest671)

end
|  ( 212, ( ( _, ( MlyValue.initializer initializer, initializer1left,
 initializer1right)) :: rest671)) => let val  result = 
MlyValue.initializerList (singletonSeq initializer)
 in ( LrTable.NT 34, ( result, initializer1left, initializer1right), 
rest671)
end
|  ( 213, ( ( _, ( MlyValue.initializer initializer, _, 
initializer1right)) :: _ :: ( _, ( MlyValue.initializerList 
initializerList, initializerList1left, _)) :: rest671)) => let val  
result = MlyValue.initializerList (
addToSeq(initializer, initializerList))
 in ( LrTable.NT 34, ( result, initializerList1left, initializer1right
), rest671)
end
|  ( 214, ( ( _, ( MlyValue.declaration declaration, (declarationleft
 as declaration1left), (declarationright as declaration1right))) :: 
rest671)) => let val  result = MlyValue.declarationList (
singletonSeq(markDeclaration srcMap (declaration,
									      declarationleft,
								              declarationright))
)
 in ( LrTable.NT 45, ( result, declaration1left, declaration1right), 
rest671)
end
|  ( 215, ( ( _, ( MlyValue.declaration declaration, declarationleft,
 (declarationright as declaration1right))) :: ( _, ( 
MlyValue.declarationList declarationList, declarationList1left, _)) ::
 rest671)) => let val  result = MlyValue.declarationList (
addToSeq(markDeclaration srcMap (declaration,
							            	  declarationleft,
									  declarationright),
						  declarationList)
)
 in ( LrTable.NT 45, ( result, declarationList1left, declaration1right
), rest671)
end
|  ( 216, ( ( _, ( MlyValue.ID ID, (IDleft as ID1left), (IDright as 
ID1right))) :: rest671)) => let val  result = MlyValue.identlist (
singletonSeq (ID,IDleft,IDright))
 in ( LrTable.NT 46, ( result, ID1left, ID1right), rest671)
end
|  ( 217, ( ( _, ( MlyValue.ID ID, IDleft, (IDright as ID1right))) ::
 _ :: ( _, ( MlyValue.identlist identlist, identlist1left, _)) :: 
rest671)) => let val  result = MlyValue.identlist (
addToSeq((ID,IDleft,IDright),identlist))
 in ( LrTable.NT 46, ( result, identlist1left, ID1right), rest671)
end
|  ( 218, ( ( _, ( MlyValue.notypeDeclarator notypeDeclarator, 
notypeDeclarator1left, notypeDeclarator1right)) :: rest671)) => let
 val  result = MlyValue.fDefDeclaration (
insertFuncName(notypeDeclarator);
					 TypeDefs.pushScope();
					 insertFuncParams(notypeDeclarator);
					 (unknown, notypeDeclarator)
)
 in ( LrTable.NT 44, ( result, notypeDeclarator1left, 
notypeDeclarator1right), rest671)
end
|  ( 219, ( ( _, ( MlyValue.declarator declarator, _, declarator1right
)) :: ( _, ( MlyValue.declarationSpecifiers declarationSpecifiers, 
declarationSpecifiers1left, _)) :: rest671)) => let val  result = 
MlyValue.fDefDeclaration (
insertFuncName(declarator);
					 TypeDefs.pushScope();
					 insertFuncParams(declarator);
					 (declarationSpecifiers, declarator)
)
 in ( LrTable.NT 44, ( result, declarationSpecifiers1left, 
declarator1right), rest671)
end
|  ( 220, ( ( _, ( MlyValue.notypeDeclarator notypeDeclarator, _, 
notypeDeclarator1right)) :: ( _, ( MlyValue.declarationModifiers 
declarationModifiers, declarationModifiers1left, _)) :: rest671)) =>
 let val  result = MlyValue.fDefDeclaration (
insertFuncName(notypeDeclarator);
					 TypeDefs.pushScope();
					 insertFuncParams(notypeDeclarator);
					 (declarationModifiers, notypeDeclarator)
)
 in ( LrTable.NT 44, ( result, declarationModifiers1left, 
notypeDeclarator1right), rest671)
end
|  ( 221, ( ( _, ( MlyValue.compoundStatement compoundStatement, _, 
compoundStatement1right)) :: ( _, ( MlyValue.fDefDeclaration 
fDefDeclaration, fDefDeclaration1left, _)) :: rest671)) => let val  
result = MlyValue.functionDefinition (
TypeDefs.popScope();
					 FunctionDef
					    {retType = #1 fDefDeclaration,
					     funDecr = #2 fDefDeclaration,
                                             krParams = [],
                                             body = compoundStatement}
)
 in ( LrTable.NT 47, ( result, fDefDeclaration1left, 
compoundStatement1right), rest671)
end
|  ( 222, ( ( _, ( MlyValue.compoundStatement compoundStatement, _, 
compoundStatement1right)) :: ( _, ( MlyValue.declarationList 
declarationList, _, _)) :: ( _, ( MlyValue.fDefDeclaration 
fDefDeclaration, fDefDeclaration1left, _)) :: rest671)) => let val  
result = MlyValue.functionDefinition (
TypeDefs.popScope();
					 FunctionDef 
					    {retType = #1 fDefDeclaration,
					     funDecr = #2 fDefDeclaration,
                                             krParams = seqToList declarationList,
                                             body = compoundStatement}
)
 in ( LrTable.NT 47, ( result, fDefDeclaration1left, 
compoundStatement1right), rest671)
end
|  ( 223, ( ( _, ( MlyValue.pointer pointer, pointer1left, 
pointer1right)) :: rest671)) => let val  result = 
MlyValue.abstractDeclarator (applyPointer (pointer, EmptyDecr))
 in ( LrTable.NT 14, ( result, pointer1left, pointer1right), rest671)

end
|  ( 224, ( ( _, ( MlyValue.directAbstractDeclarator 
directAbstractDeclarator, directAbstractDeclarator1left, 
directAbstractDeclarator1right)) :: rest671)) => let val  result = 
MlyValue.abstractDeclarator (directAbstractDeclarator)
 in ( LrTable.NT 14, ( result, directAbstractDeclarator1left, 
directAbstractDeclarator1right), rest671)
end
|  ( 225, ( ( _, ( MlyValue.directAbstractDeclarator 
directAbstractDeclarator, _, directAbstractDeclarator1right)) :: ( _, 
( MlyValue.pointer pointer, pointer1left, _)) :: rest671)) => let val 
 result = MlyValue.abstractDeclarator (
applyPointer(pointer, directAbstractDeclarator))
 in ( LrTable.NT 14, ( result, pointer1left, 
directAbstractDeclarator1right), rest671)
end
|  ( 226, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.abstractDeclarator abstractDeclarator, _, _)) :: ( _, ( _, 
LPAREN1left, _)) :: rest671)) => let val  result = 
MlyValue.directAbstractDeclarator (abstractDeclarator)
 in ( LrTable.NT 15, ( result, LPAREN1left, RPAREN1right), rest671)

end
|  ( 227, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( _, LBRACE1left, _))
 :: rest671)) => let val  result = MlyValue.directAbstractDeclarator (
ArrayDecr(EmptyDecr, EmptyExpr))
 in ( LrTable.NT 15, ( result, LBRACE1left, RBRACE1right), rest671)

end
|  ( 228, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.expr expr,
 _, _)) :: ( _, ( _, LBRACE1left, _)) :: rest671)) => let val  result
 = MlyValue.directAbstractDeclarator (ArrayDecr(EmptyDecr, expr))
 in ( LrTable.NT 15, ( result, LBRACE1left, RBRACE1right), rest671)

end
|  ( 229, ( ( _, ( _, _, RBRACE1right)) :: _ :: ( _, ( 
MlyValue.directAbstractDeclarator directAbstractDeclarator, 
directAbstractDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.directAbstractDeclarator (
ArrayDecr (directAbstractDeclarator,EmptyExpr))
 in ( LrTable.NT 15, ( result, directAbstractDeclarator1left, 
RBRACE1right), rest671)
end
|  ( 230, ( ( _, ( _, _, RBRACE1right)) :: ( _, ( MlyValue.expr expr,
 _, _)) :: _ :: ( _, ( MlyValue.directAbstractDeclarator 
directAbstractDeclarator, directAbstractDeclarator1left, _)) :: 
rest671)) => let val  result = MlyValue.directAbstractDeclarator (
ArrayDecr (directAbstractDeclarator,expr))
 in ( LrTable.NT 15, ( result, directAbstractDeclarator1left, 
RBRACE1right), rest671)
end
|  ( 231, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( _, LPAREN1left, _))
 :: rest671)) => let val  result = MlyValue.directAbstractDeclarator (
FuncDecr (EmptyDecr ,nil))
 in ( LrTable.NT 15, ( result, LPAREN1left, RPAREN1right), rest671)

end
|  ( 232, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.parameterTypeList parameterTypeList, _, _)) :: ( _, ( _, 
LPAREN1left, _)) :: rest671)) => let val  result = 
MlyValue.directAbstractDeclarator (
FuncDecr (EmptyDecr, parameterTypeList))
 in ( LrTable.NT 15, ( result, LPAREN1left, RPAREN1right), rest671)

end
|  ( 233, ( ( _, ( _, _, RPAREN1right)) :: _ :: ( _, ( 
MlyValue.directAbstractDeclarator directAbstractDeclarator, 
directAbstractDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.directAbstractDeclarator (
FuncDecr (directAbstractDeclarator,nil))
 in ( LrTable.NT 15, ( result, directAbstractDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 234, ( ( _, ( _, _, RPAREN1right)) :: ( _, ( 
MlyValue.parameterTypeList parameterTypeList, _, _)) :: _ :: ( _, ( 
MlyValue.directAbstractDeclarator directAbstractDeclarator, 
directAbstractDeclarator1left, _)) :: rest671)) => let val  result = 
MlyValue.directAbstractDeclarator (
FuncDecr (directAbstractDeclarator, parameterTypeList))
 in ( LrTable.NT 15, ( result, directAbstractDeclarator1left, 
RPAREN1right), rest671)
end
|  ( 235, ( ( _, ( MlyValue.parameterList parameterList, 
parameterList1left, parameterList1right)) :: rest671)) => let val  
result = MlyValue.parameterTypeList (seqToList parameterList)
 in ( LrTable.NT 52, ( result, parameterList1left, parameterList1right
), rest671)
end
|  ( 236, ( ( _, ( _, _, ELIPSIS1right)) :: _ :: ( _, ( 
MlyValue.parameterList parameterList, parameterList1left, _)) :: 
rest671)) => let val  result = MlyValue.parameterTypeList (
let val decltype = {specifiers=[Ellipses],qualifiers=[],storage=[]}
	        		 in (seqToList parameterList) @ [(decltype, EllipsesDecr)] end
)
 in ( LrTable.NT 52, ( result, parameterList1left, ELIPSIS1right), 
rest671)
end
|  ( 237, ( ( _, ( MlyValue.parameterDeclaration parameterDeclaration,
 (parameterDeclarationleft as parameterDeclaration1left), (
parameterDeclarationright as parameterDeclaration1right))) :: rest671)
) => let val  result = MlyValue.parameterList (
singletonSeq(#1 parameterDeclaration,
                                              markDeclarator srcMap (#2 parameterDeclaration,
							             parameterDeclarationleft,
								     parameterDeclarationright))
)
 in ( LrTable.NT 51, ( result, parameterDeclaration1left, 
parameterDeclaration1right), rest671)
end
|  ( 238, ( ( _, ( MlyValue.parameterDeclaration parameterDeclaration,
 parameterDeclarationleft, (parameterDeclarationright as 
parameterDeclaration1right))) :: _ :: ( _, ( MlyValue.parameterList 
parameterList, parameterList1left, _)) :: rest671)) => let val  result
 = MlyValue.parameterList (
addToSeq((#1 parameterDeclaration,
	                                           markDeclarator
	                                            srcMap 
                                                     (#2 parameterDeclaration,
						      parameterDeclarationleft,
						      parameterDeclarationright)),
					  parameterList)
)
 in ( LrTable.NT 51, ( result, parameterList1left, 
parameterDeclaration1right), rest671)
end
|  ( 239, ( ( _, ( MlyValue.notypeDeclarator notypeDeclarator, _, 
notypeDeclarator1right)) :: ( _, ( MlyValue.declarationSpecifiers 
declarationSpecifiers, declarationSpecifiers1left, _)) :: rest671)) =>
 let val  result = MlyValue.parameterDeclaration (
(declarationSpecifiers, notypeDeclarator))
 in ( LrTable.NT 53, ( result, declarationSpecifiers1left, 
notypeDeclarator1right), rest671)
end
|  ( 240, ( ( _, ( MlyValue.parmDeclarator parmDeclarator, _, 
parmDeclarator1right)) :: ( _, ( MlyValue.declarationSpecifiers 
declarationSpecifiers, declarationSpecifiers1left, _)) :: rest671)) =>
 let val  result = MlyValue.parameterDeclaration (
(declarationSpecifiers, parmDeclarator))
 in ( LrTable.NT 53, ( result, declarationSpecifiers1left, 
parmDeclarator1right), rest671)
end
|  ( 241, ( ( _, ( MlyValue.declarationSpecifiers 
declarationSpecifiers, declarationSpecifiers1left, 
declarationSpecifiers1right)) :: rest671)) => let val  result = 
MlyValue.parameterDeclaration ((declarationSpecifiers, EmptyDecr))
 in ( LrTable.NT 53, ( result, declarationSpecifiers1left, 
declarationSpecifiers1right), rest671)
end
|  ( 242, ( ( _, ( MlyValue.abstractDeclarator abstractDeclarator, _, 
abstractDeclarator1right)) :: ( _, ( MlyValue.declarationSpecifiers 
declarationSpecifiers, declarationSpecifiers1left, _)) :: rest671)) =>
 let val  result = MlyValue.parameterDeclaration (
(declarationSpecifiers, abstractDeclarator))
 in ( LrTable.NT 53, ( result, declarationSpecifiers1left, 
abstractDeclarator1right), rest671)
end
|  ( 243, ( ( _, ( MlyValue.notypeDeclarator notypeDeclarator, _, 
notypeDeclarator1right)) :: ( _, ( MlyValue.declarationModifiers 
declarationModifiers, declarationModifiers1left, _)) :: rest671)) =>
 let val  result = MlyValue.parameterDeclaration (
(declarationModifiers, notypeDeclarator))
 in ( LrTable.NT 53, ( result, declarationModifiers1left, 
notypeDeclarator1right), rest671)
end
|  ( 244, ( ( _, ( MlyValue.abstractDeclarator abstractDeclarator, _, 
abstractDeclarator1right)) :: ( _, ( MlyValue.declarationModifiers 
declarationModifiers, declarationModifiers1left, _)) :: rest671)) =>
 let val  result = MlyValue.parameterDeclaration (
(declarationModifiers, abstractDeclarator))
 in ( LrTable.NT 53, ( result, declarationModifiers1left, 
abstractDeclarator1right), rest671)
end
|  ( 245, ( rest671)) => let val  result = MlyValue.pushScope (
TypeDefs.pushScope())
 in ( LrTable.NT 61, ( result, defaultPos, defaultPos), rest671)
end
|  ( 246, ( rest671)) => let val  result = MlyValue.popScope (
TypeDefs.popScope())
 in ( LrTable.NT 62, ( result, defaultPos, defaultPos), rest671)
end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID'
val extract = fn a => (fn MlyValue.translationUnit x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : C_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID',p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID',p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID',p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID',p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID',p1,p2))
fun LCURLY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID',p1,p2))
fun RCURLY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.VOID',p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID',p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID',p1,p2))
fun DOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID',p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID',p1,p2))
fun QUESTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID',p1,p2))
fun PERCENT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID',p1,p2))
fun AMP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID',p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID',p1,p2))
fun TILDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID',p1,p2))
fun DIVIDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID',p1,p2))
fun PLUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID',p1,p2))
fun MINUS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID',p1,p2))
fun HAT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID',p1,p2))
fun BANG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID',p1,p2))
fun TIMES (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID',p1,p2))
fun INC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID',p1,p2))
fun DEC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID',p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID',p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.ID i,p1,p2))
fun EQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID',p1,p2))
fun PLUSEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID',p1,p2))
fun MINUSEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID',p1,p2))
fun XOREQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID',p1,p2))
fun MODEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID',p1,p2))
fun TIMESEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID',p1,p2))
fun DIVEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID',p1,p2))
fun OREQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID',p1,p2))
fun ANDEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID',p1,p2))
fun LSHIFTEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID',p1,p2))
fun RSHIFTEQUALS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID',p1,p2))
fun LTE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID',p1,p2))
fun GTE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID',p1,p2))
fun LT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID',p1,p2))
fun GT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID',p1,p2))
fun EQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID',p1,p2))
fun NEQ (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID',p1,p2))
fun OR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID',p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID',p1,p2))
fun LSHIFT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID',p1,p2))
fun RSHIFT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID',p1,p2))
fun DECNUM (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.DECNUM i,p1,p2))
fun REALNUM (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.REALNUM i,p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.STRING i,p1,p2))
fun CCONST (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.CCONST i,p1,p2))
fun EXTERN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID',p1,p2))
fun AUTO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID',p1,p2))
fun STATIC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID',p1,p2))
fun REGISTER (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID',p1,p2))
fun CONST (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID',p1,p2))
fun VOLATILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID',p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID',p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID',p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID',p1,p2))
fun FOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID',p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID',p1,p2))
fun SWITCH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID',p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID',p1,p2))
fun DEFAULT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID',p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.VOID',p1,p2))
fun RETURN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID',p1,p2))
fun BREAK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.VOID',p1,p2))
fun CONTINUE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID',p1,p2))
fun GOTO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 69,(
ParserData.MlyValue.VOID',p1,p2))
fun CHAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 70,(
ParserData.MlyValue.VOID',p1,p2))
fun DOUBLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 71,(
ParserData.MlyValue.VOID',p1,p2))
fun ENUM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 72,(
ParserData.MlyValue.VOID',p1,p2))
fun FLOAT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 73,(
ParserData.MlyValue.VOID',p1,p2))
fun INT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 74,(
ParserData.MlyValue.VOID',p1,p2))
fun LONG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 75,(
ParserData.MlyValue.VOID',p1,p2))
fun SHORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 76,(
ParserData.MlyValue.VOID',p1,p2))
fun FRACTIONAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 77,(
ParserData.MlyValue.VOID',p1,p2))
fun SATURATE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 78,(
ParserData.MlyValue.VOID',p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 79,(
ParserData.MlyValue.VOID',p1,p2))
fun UNION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 80,(
ParserData.MlyValue.VOID',p1,p2))
fun UNSIGNED (p1,p2) = Token.TOKEN (ParserData.LrTable.T 81,(
ParserData.MlyValue.VOID',p1,p2))
fun SIGNED (p1,p2) = Token.TOKEN (ParserData.LrTable.T 82,(
ParserData.MlyValue.VOID',p1,p2))
fun VOID (p1,p2) = Token.TOKEN (ParserData.LrTable.T 83,(
ParserData.MlyValue.VOID',p1,p2))
fun SIZEOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 84,(
ParserData.MlyValue.VOID',p1,p2))
fun TYPEDEF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 85,(
ParserData.MlyValue.VOID',p1,p2))
fun UNARY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 86,(
ParserData.MlyValue.VOID',p1,p2))
fun ELIPSIS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 87,(
ParserData.MlyValue.VOID',p1,p2))
fun TYPE_NAME (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 88,(
ParserData.MlyValue.TYPE_NAME i,p1,p2))
end
end
