/* $ANTLR 2.7.4: "walker.g" -> "AntlrNotebookTreeParser.cpp"$ */
#include "AntlrNotebookTreeParser.hpp"
#include <antlr/Token.hpp>
#include <antlr/AST.hpp>
#include <antlr/NoViableAltException.hpp>
#include <antlr/MismatchedTokenException.hpp>
#include <antlr/SemanticException.hpp>
#include <antlr/BitSet.hpp>
AntlrNotebookTreeParser::AntlrNotebookTreeParser()
	: ANTLR_USE_NAMESPACE(antlr)TreeParser() {
}

void AntlrNotebookTreeParser::document(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	Cell *ws, Factory *f, int readmode
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST document_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	//This is in NotebookTreeParser.cpp
	factory = f;
	workspace = ws;
	
	
	// AF
	imagePartOfText = false;
	readmode_ = readmode;
	
	if( readmode_ == READMODE_CONVERTING_ONB )
			convertingToONB = true;
		else
			convertingToONB = false;
	
	
	result_t result(output);// = new result_t; //??
	
	
	try {      // for error handling
		expr(_t,result);
		_t = _retTree;
		
		//cout << (*result).first.str() << endl;
		
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::expr(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	result_t &result
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST expr_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	string val;
	string attr;
	
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case MODULENAME:
		case LIST:
		case LIST_SMALL:
		case NOTEBOOK:
		case CELL:
		case TEXTDATA:
		case CELLGROUPDATA:
		case GRAYLEVEL:
		case RGBCOLOR:
		case FILENAME:
		case STYLEBOX:
		case STYLEDATA:
		case BOXDATA:
		case BUTTONBOX:
		case FORMBOX:
		case ROWBOX:
		case GRIDBOX:
		case TAGBOX:
		case COUNTERBOX:
		case ADJUSTMENTBOX:
		case SUPERSCRBOX:
		case SUBSCRBOX:
		case SUBSUPERSCRIPTBOX:
		case UNDERSCRIPTBOX:
		case OVERSCRIPTBOX:
		case UNDEROVERSCRIPTBOX:
		case FRACTIONBOX:
		case SQRTBOX:
		case RADICALBOX:
		case INTERPRETATIONBOX:
		case ANNOTATION:
		case EQUAL:
		case DIAGRAM:
		case ICON:
		case POLYGON:
		case ELLIPSE:
		case LINE:
		case DIREXTEDINFINITY:
		case NOT_MATH_OLEDATE:
		case GRAPHICSDATA:
		case LISTBODY:
		{
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == MODULENAME)) {
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp1_AST_in = _t;
					match(_t,MODULENAME);
					_t = _t->getNextSibling();
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp2_AST_in = _t;
					match(_t,THICK);
					_t = _t->getNextSibling();
				}
				else {
					goto _loop4;
				}
				
			}
			_loop4:;
			} // ( ... )*
			exprheader(_t,result);
			_t = _retTree;
			
			
			break;
		}
		case VALUERIGHT:
		case VALUELEFT:
		case VALUECENTER:
		case VALUESMALLER:
		case INHERITED:
		case PAPERWIDTH:
		case WINDOWWIDTH:
		case TRUE_:
		case FALSE_:
		case AUTOMATIC:
		case TRADITIONALFORM:
		case STANDARDFORM:
		case INPUTFORM:
		case OUTPUTFORM:
		case DEFAULTINPUTFORMATTYPE:
		case NULLSYM:
		case NONESYM:
		case ALLSYM:
		case NUMBER:
		case QSTRING:
		{
			val=value(_t);
			_t = _retTree;
			
			result.first << val;
			
			break;
		}
		case FONTSLANT:
		case FONTSIZE:
		case FONTCOLOR:
		case FONTWEIGHT:
		case FONTFAMILY:
		case FONTVARIATIONS:
		case TEXTALIGNMENT:
		case TEXTJUSTIFICATION:
		case INITIALIZATIONCELL:
		case FORMATTYPE_TOKEN:
		case PAGEWIDTH:
		case PAGEHEADERS:
		case PAGEHEADERLINES:
		case PAGEFOOTERS:
		case PAGEFOOTERLINES:
		case PAGEBREAKBELOW:
		case PAGEBREAKWITHIN:
		case BOXMARGINS:
		case BOXBASELINESHIFT:
		case LINESPACING:
		case HYPHENATION:
		case ACTIVE_TOKEN:
		case VISIBLE_TOKEN:
		case EVALUATABLE:
		case BUTTONFUNCTION:
		case BUTTONDATA:
		case BUTTONEVALUATOR:
		case BUTTONSTYLE:
		case CHARACHTERENCODING:
		case SHOWSTRINGCHARACTERS:
		case SCREENRECTANGLE:
		case AUTOGENERATEDPACKAGE:
		case AUTOITALICWORDS:
		case INPUTAUTOREPLACEMENTS:
		case SCRIPTMINSIZE:
		case STYLEMEMULISTING:
		case COUNTERINCREMENTS:
		case COUNTERASSIGNMENTS:
		case PRIVATEEVALOPTIONS:
		case GROUPPAGEBREAKWITHIN:
		case DEFAULTFORMATTYPE:
		case NUMBERMARKS:
		case LINEBREAKADJUSTMENTS:
		case VISIOLINEFORMAT:
		case VISIOFILLFORMAT:
		case EXTENT:
		case NAMEPOSITION:
		case CELLTAGS:
		case CELLFRAME:
		case CELLFRAMECOLOR:
		case CELLFRAMELABELS:
		case CELLFRAMEMARGINS:
		case CELLFRAMELABELMARGINS:
		case CELLLABRLMARGINS:
		case CELLLABELPOSITIONING:
		case CELLMARGINS:
		case CELLDINGBAT:
		case CELLHORIZONTALSCROLL:
		case CELLOPEN:
		case CELLGENERATED:
		case SHOWCELLBRACKET:
		case SHOWCELLLABEL:
		case CELLBRACKETOPT:
		case EDITABLE:
		case CELLGROUPINGRULES:
		case WINDOWSIZE:
		case WINDOWMARGINS:
		case WINDOWFRAME:
		case WINDOWELEMENTS:
		case WINDOWTITLE:
		case WINDOWTOOLBARS:
		case WINDOWMOVEABLE:
		case WINDOWFLOATING:
		case WINDOWCLICKSELECT:
		case STYLEDEFINITIONS:
		case FRONTENDVERSION:
		case SCREENSTYLEENV:
		case PRINTINGSTYLEENV:
		case PRINTINGOPTIONS:
		case PRINTINGCOPIES:
		case PRINTINGPAGERANGE:
		case PRIVATEFONTOPTIONS:
		case IMAGESIZE:
		case IMAGEMARGINS:
		case IMAGEREGION:
		case IMAGERANGECACHE:
		case IMAGECACHE:
		case NOT_MATH_MODELEDITOR:
		case CELLAUTOOVRT:
		case MAGNIFICATION:
		case BACKGROUND:
		case GENERATEDCELL:
		{
			attr=attribute(_t);
			_t = _retTree;
			
			result.first << attr;
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::exprheader(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	result_t &result
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST exprheader_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST style = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST opengroup = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST closegroup = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST sbstyle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST type = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST data = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST infinitytype = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST red = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST green = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST blue = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	rules_t rules;
	
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case NOTEBOOK:
		{
			
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t6 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp3_AST_in = _t;
			match(_t,NOTEBOOK);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop8;
				}
				
			}
			_loop8:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop10;
				}
				
			}
			_loop10:;
			} // ( ... )*
			_t = __t6;
			_t = _t->getNextSibling();
			
			
			break;
		}
		case LIST:
		{
			
			ostringstream listoutput;
			result_t list(listoutput);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t11 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp4_AST_in = _t;
			match(_t,LIST);
			_t = _t->getFirstChild();
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					listelement(_t,list);
					_t = _retTree;
				}
				else {
					goto _loop13;
				}
				
			}
			_loop13:;
			} // ( ... )*
			_t = __t11;
			_t = _t->getNextSibling();
			
						//2005-11-09 AF, Added a function for adding/removeing some
						//chars/symbols from the text
			string str = StripString::stripNBString( list.first.str() );
			
						result.first << str << endl;
			
			break;
		}
		case LISTBODY:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t14 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp5_AST_in = _t;
			match(_t,LISTBODY);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			_t = __t14;
			_t = _t->getNextSibling();
			
			
			break;
		}
		case CELL:
		{
			
				    ostringstream contentoutput;
			result_t content(contentoutput);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t15 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp6_AST_in = _t;
			match(_t,CELL);
			_t = _t->getFirstChild();
			expr(_t,content);
			_t = _retTree;
			{
			if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
				_t = ASTNULL;
			switch ( _t->getType()) {
			case QSTRING:
			{
				style = _t;
				match(_t,QSTRING);
				_t = _t->getNextSibling();
				break;
			}
			case 3:
			case RULE:
			case RULE_SMALL:
			case RULEDELAYED:
			{
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
			}
			}
			}
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop18;
				}
				
			}
			_loop18:;
			} // ( ... )*
			_t = __t15;
			_t = _t->getNextSibling();
			
						//2005-11-09 AF, Added a function for adding/removeing some
						//chars/symbols from the text
			string cnt = StripString::stripNBString( content.first.str() );
			
			if(style)
			{
							QString qcnt(cnt.c_str());
				            	
							string s1 = style->getText();
							s1.assign(s1, 1, s1.length()-2);
			
							QString cellstyle(s1.c_str());
							
							// 2005-11-09 AF,	
							// if the cellstyle is "Graphics" a new cell shouldn't always be added, sometimes
							// a image should be added in the existing cell
							if( cellstyle == "Graphics" )
							{
								// TODO: DEBUG code, remove when doing release
								/*
								if( imagePartOfText )
								{
									result.first << "IMAGE" << endl;
								}
								else
								{
									Cell *text = factory->createCell("Text", workspace);
									text->setText("IMAGE CELL");
									text->setStyle("Text");
									
									workspace->addChild(text);
								}
								*/
							}
							else
							{	
								Cell *text = factory->createCell(cellstyle, workspace);
				                
								//RULES
								//Rules from content.
								for(rules_t::iterator i=content.second.begin();i!=content.second.end();++i)
								{
									//AF text->setStyle(QString((*i).first.c_str()), QString((*i).second.c_str()));
									//text->addRule(new Rule(QString((*i).first.c_str()), QString((*i).second.c_str())));
								}
				                
								//Rules from tag.
								for(rules_t::iterator j = rules.begin(); j != rules.end(); j++)
								{
									//AF text->setStyle(QString((*j).first.c_str()), QString((*j).second.c_str()));
									text->addRule(new Rule(QString((*j).first.c_str()), QString((*j).second.c_str())));
								}
				                
								//STYLE
								// 2005-11-08 AF, ndrat ordningen s att setText grs fre setStyle
								text->setText( qcnt );
								//text->setStyle( cellstyle );
				                
								workspace->addChild(text);
							}
			}
			else
			{   //This is really ugly, but it works most of the time. 
			//This is only happening when a Cell does not have a style. It seems 
			//to happen only with cells inside textdata-expressions. 
			result.first << cnt;
			}
			
			break;
		}
		case CELLGROUPDATA:
		{
			
			//CellGroup *group = new CellGroup(workspace->doc());
			//CellGroup *parent = workspace;
			Cell *group = factory->createCell("cellgroup", workspace);
			Cell *parent = workspace;
			workspace = group;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t19 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp7_AST_in = _t;
			match(_t,CELLGROUPDATA);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{
			if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
				_t = ASTNULL;
			switch ( _t->getType()) {
			case CELLGROUPOPEN:
			{
				opengroup = _t;
				match(_t,CELLGROUPOPEN);
				_t = _t->getNextSibling();
				break;
			}
			case CELLGROUPCLOSED:
			{
				closegroup = _t;
				match(_t,CELLGROUPCLOSED);
				_t = _t->getNextSibling();
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
			}
			}
			}
			_t = __t19;
			_t = _t->getNextSibling();
			
				if( opengroup )
							group->setClosed( false );
						else if( closegroup )
							group->setClosed( true );
					
								
			workspace = parent;
			workspace->addChild(group);
			
			break;
		}
		case STYLEBOX:
		{
			
				    ostringstream sboutput;
			result_t sbcontent(sboutput);
			rules_t stylerules;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t21 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp8_AST_in = _t;
			match(_t,STYLEBOX);
			_t = _t->getFirstChild();
			expr(_t,sbcontent);
			_t = _retTree;
			{
			if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
				_t = ASTNULL;
			switch ( _t->getType()) {
			case QSTRING:
			{
				sbstyle = _t;
				match(_t,QSTRING);
				_t = _t->getNextSibling();
				break;
			}
			case RULE:
			case RULE_SMALL:
			case RULEDELAYED:
			{
				{ // ( ... )+
				int _cnt24=0;
				for (;;) {
					if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
						_t = ASTNULL;
					if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
						rule(_t,stylerules);
						_t = _retTree;
					}
					else {
						if ( _cnt24>=1 ) { goto _loop24; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);}
					}
					
					_cnt24++;
				}
				_loop24:;
				}  // ( ... )+
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
			}
			}
			}
			_t = __t21;
			_t = _t->getNextSibling();
			
			if(sbstyle)
			{
			//What happends if a style is added here?
			}
			else
			{   
			rules_t::iterator i = stylerules.begin();
			for(; i != stylerules.end();++i)
			{
			//cout << "STYLERULES: " << (*i).first << "->" << (*i).second << endl;
			result.second.push_back(*i);
			}
			}
			
			//2005-11-09 AF, Added a function for adding/removeing some
						//chars/symbols from the text
			string str = StripString::stripNBString( sbcontent.first.str() );
			
			// 2005-12-06 AF, Apply the rules to the text
			str = StripString::applyRulesToText( str, stylerules );
			
			result.first << str; //sbcontent.first.str();
			
			break;
		}
		case TEXTDATA:
		{
			
						imagePartOfText = true;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t25 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp9_AST_in = _t;
			match(_t,TEXTDATA);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop27;
				}
				
			}
			_loop27:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop29;
				}
				
			}
			_loop29:;
			} // ( ... )*
			_t = __t25;
			_t = _t->getNextSibling();
			
			imagePartOfText = false;
			
			break;
		}
		case SUPERSCRBOX:
		{
			
			ostringstream baseoutput;
			ostringstream expoutput;
			result_t base(baseoutput);
			result_t exp(expoutput);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t30 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp10_AST_in = _t;
			match(_t,SUPERSCRBOX);
			_t = _t->getFirstChild();
			expr(_t,base);
			_t = _retTree;
			expr(_t,exp);
			_t = _retTree;
			_t = __t30;
			_t = _t->getNextSibling();
			
			result.first << base.first.str() << "<sup>" << exp.first.str() << "</sup>";
			
			rules_t::iterator i = base.second.begin();
			for(; i != base.second.end(); ++i)
			{
			result.second.push_back((*i));               
			}
			rules_t::iterator j = exp.second.begin();
			for(; j != exp.second.end(); ++j)
			{
			result.second.push_back((*j));               
			}
			
			break;
		}
		case SUBSCRBOX:
		{
			
						ostringstream baseoutputSub;
			ostringstream expoutputSub;
			result_t baseSub(baseoutputSub);
			result_t expSub(expoutputSub);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t31 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp11_AST_in = _t;
			match(_t,SUBSCRBOX);
			_t = _t->getFirstChild();
			expr(_t,baseSub);
			_t = _retTree;
			expr(_t,expSub);
			_t = _retTree;
			_t = __t31;
			_t = _t->getNextSibling();
			
						result.first << baseSub.first.str() << "<sub>" << expSub.first.str() << "</sub>";
			
			rules_t::iterator i = baseSub.second.begin();
			for(; i != baseSub.second.end(); ++i)
			{
			result.second.push_back((*i));               
			}
			rules_t::iterator j = expSub.second.begin();
			for(; j != expSub.second.end(); ++j)
			{
			result.second.push_back((*j));               
			}
			
			break;
		}
		case BUTTONBOX:
		{
			
			//Translates all buttons into hyperlinks.
			ostringstream btoutput;
			result_t buttonTitle(btoutput);
			rules_t buttonRules;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t32 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp12_AST_in = _t;
			match(_t,BUTTONBOX);
			_t = _t->getFirstChild();
			expr(_t,buttonTitle);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop34;
				}
				
			}
			_loop34:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,buttonRules);
					_t = _retTree;
				}
				else {
					goto _loop36;
				}
				
			}
			_loop36:;
			} // ( ... )*
			_t = __t32;
			_t = _t->getNextSibling();
			
			string filename;
			//Check rules. Look for ButtonData ->Filename and ButtonStyle=Hyperlink
			rules_t::iterator i = buttonRules.begin();
			for(; i != buttonRules.end();++i)
			{
			if((*i).first == "ButtonData")
			{
			//cout << "BUTTONBOX RULES: " << (*i).first << "->" 
			//     << (*i).second << endl;
			filename = (*i).second;
			}
			//result.second.push_back(*i);
			}
			
			
			// 2006-02-10 AF, Add '#' to filename. Links should have '#'
			// for specifing internel references. For example internal 
			// referenses for a link;
			// HTML link: Dir/filename.html#ChaperSeven
			// filename looks like: Dir/filename.htmlChapterSeven
			// have to insert # symbol
			filename = StripString::fixFilename( filename );
			
			// 2006-03-21 AF, if convertion to ONB - replace .nb with .onb
			if( convertingToONB )
			{
							string::size_type index = filename.find( ".nb" );
							if( index != string::npos )
							{
								filename.replace( index, 3, ".onb" );
							}
			}
			
			
			result.first << "<a href=\"" << filename << "\">" 
			<< buttonTitle.first.str() << "</a>";
			
			break;
		}
		case INTERPRETATIONBOX:
		{
			
			// InpterpretationBox contains hidden information in Mathematica
			ostringstream boxesoutput;
			result_t boxes(boxesoutput);
			
			ostringstream interpretationdataoutput;
			result_t interpretationdata(interpretationdataoutput);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t37 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp13_AST_in = _t;
			match(_t,INTERPRETATIONBOX);
			_t = _t->getFirstChild();
			expr(_t,boxes);
			_t = _retTree;
			expr(_t,interpretationdata);
			_t = _retTree;
			_t = __t37;
			_t = _t->getNextSibling();
			
			
			break;
		}
		case FILENAME:
		{
			
				    ostringstream diroutput;
				    ostringstream filenameoutput;
			result_t dir(diroutput);
			result_t filename(filenameoutput);
			rules_t filenameRules;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t38 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp14_AST_in = _t;
			match(_t,FILENAME);
			_t = _t->getFirstChild();
			expr(_t,dir);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,filename);
					_t = _retTree;
				}
				else {
					goto _loop40;
				}
				
			}
			_loop40:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,filenameRules);
					_t = _retTree;
				}
				else {
					goto _loop42;
				}
				
			}
			_loop42:;
			} // ( ... )*
			_t = __t38;
			_t = _t->getNextSibling();
			
			//Delete strange newline in directory string.
			string d = dir.first.str();
			d.assign(d, 0, d.length()-1);
			
			result.first << d << "/" << filename.first.str();
			
			break;
		}
		case GRAPHICSDATA:
		{
			
					
			ANTLR_USE_NAMESPACE(antlr)RefAST __t43 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp15_AST_in = _t;
			match(_t,GRAPHICSDATA);
			_t = _t->getFirstChild();
			type = _t;
			match(_t,QSTRING);
			_t = _t->getNextSibling();
			data = _t;
			match(_t,QSTRING);
			_t = _t->getNextSibling();
			_t = __t43;
			_t = _t->getNextSibling();
			
					
			break;
		}
		case DIREXTEDINFINITY:
		{
			
				
			ANTLR_USE_NAMESPACE(antlr)RefAST __t44 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp16_AST_in = _t;
			match(_t,DIREXTEDINFINITY);
			_t = _t->getFirstChild();
			infinitytype = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			_t = __t44;
			_t = _t->getNextSibling();
			
				
			break;
		}
		case BOXDATA:
		{
			
						ostringstream boxdataoutput;
			result_t boxdata(boxdataoutput);
					
			ANTLR_USE_NAMESPACE(antlr)RefAST __t45 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp17_AST_in = _t;
			match(_t,BOXDATA);
			_t = _t->getFirstChild();
			expr(_t,boxdata);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop47;
				}
				
			}
			_loop47:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop49;
				}
				
			}
			_loop49:;
			} // ( ... )*
			_t = __t45;
			_t = _t->getNextSibling();
			
						result.first << StripString::stripSimulationData(boxdata.first.str());
					
			break;
		}
		case RGBCOLOR:
		{
			
					
			ANTLR_USE_NAMESPACE(antlr)RefAST __t50 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp18_AST_in = _t;
			match(_t,RGBCOLOR);
			_t = _t->getFirstChild();
			red = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			green = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			blue = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			_t = __t50;
			_t = _t->getNextSibling();
			
						if( red && green && blue )
							result.first << red->getText() << ":" << green->getText() << ":" << blue->getText();
						else
							result.first << "7777:3333:2222";
					
			break;
		}
		case LIST_SMALL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t51 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp19_AST_in = _t;
			match(_t,LIST_SMALL);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop53;
				}
				
			}
			_loop53:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop55;
				}
				
			}
			_loop55:;
			} // ( ... )*
			_t = __t51;
			_t = _t->getNextSibling();
			break;
		}
		case ROWBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t56 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp20_AST_in = _t;
			match(_t,ROWBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop58;
				}
				
			}
			_loop58:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop60;
				}
				
			}
			_loop60:;
			} // ( ... )*
			_t = __t56;
			_t = _t->getNextSibling();
			break;
		}
		case GRIDBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t61 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp21_AST_in = _t;
			match(_t,GRIDBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop63;
				}
				
			}
			_loop63:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop65;
				}
				
			}
			_loop65:;
			} // ( ... )*
			_t = __t61;
			_t = _t->getNextSibling();
			break;
		}
		case FORMBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t66 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp22_AST_in = _t;
			match(_t,FORMBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop68;
				}
				
			}
			_loop68:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop70;
				}
				
			}
			_loop70:;
			} // ( ... )*
			_t = __t66;
			_t = _t->getNextSibling();
			break;
		}
		case TAGBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t71 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp23_AST_in = _t;
			match(_t,TAGBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop73;
				}
				
			}
			_loop73:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop75;
				}
				
			}
			_loop75:;
			} // ( ... )*
			_t = __t71;
			_t = _t->getNextSibling();
			break;
		}
		case COUNTERBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t76 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp24_AST_in = _t;
			match(_t,COUNTERBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop78;
				}
				
			}
			_loop78:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop80;
				}
				
			}
			_loop80:;
			} // ( ... )*
			_t = __t76;
			_t = _t->getNextSibling();
			break;
		}
		case ADJUSTMENTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t81 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp25_AST_in = _t;
			match(_t,ADJUSTMENTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop83;
				}
				
			}
			_loop83:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop85;
				}
				
			}
			_loop85:;
			} // ( ... )*
			_t = __t81;
			_t = _t->getNextSibling();
			break;
		}
		case SUBSUPERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t86 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp26_AST_in = _t;
			match(_t,SUBSUPERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop88;
				}
				
			}
			_loop88:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop90;
				}
				
			}
			_loop90:;
			} // ( ... )*
			_t = __t86;
			_t = _t->getNextSibling();
			break;
		}
		case UNDERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t91 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp27_AST_in = _t;
			match(_t,UNDERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop93;
				}
				
			}
			_loop93:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop95;
				}
				
			}
			_loop95:;
			} // ( ... )*
			_t = __t91;
			_t = _t->getNextSibling();
			break;
		}
		case OVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t96 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp28_AST_in = _t;
			match(_t,OVERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop98;
				}
				
			}
			_loop98:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop100;
				}
				
			}
			_loop100:;
			} // ( ... )*
			_t = __t96;
			_t = _t->getNextSibling();
			break;
		}
		case UNDEROVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t101 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp29_AST_in = _t;
			match(_t,UNDEROVERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop103;
				}
				
			}
			_loop103:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop105;
				}
				
			}
			_loop105:;
			} // ( ... )*
			_t = __t101;
			_t = _t->getNextSibling();
			break;
		}
		case FRACTIONBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t106 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp30_AST_in = _t;
			match(_t,FRACTIONBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop108;
				}
				
			}
			_loop108:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop110;
				}
				
			}
			_loop110:;
			} // ( ... )*
			_t = __t106;
			_t = _t->getNextSibling();
			break;
		}
		case SQRTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t111 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp31_AST_in = _t;
			match(_t,SQRTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop113;
				}
				
			}
			_loop113:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop115;
				}
				
			}
			_loop115:;
			} // ( ... )*
			_t = __t111;
			_t = _t->getNextSibling();
			break;
		}
		case RADICALBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t116 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp32_AST_in = _t;
			match(_t,RADICALBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop118;
				}
				
			}
			_loop118:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop120;
				}
				
			}
			_loop120:;
			} // ( ... )*
			_t = __t116;
			_t = _t->getNextSibling();
			break;
		}
		case ANNOTATION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t121 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp33_AST_in = _t;
			match(_t,ANNOTATION);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop123;
				}
				
			}
			_loop123:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop125;
				}
				
			}
			_loop125:;
			} // ( ... )*
			_t = __t121;
			_t = _t->getNextSibling();
			break;
		}
		case EQUAL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t126 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp34_AST_in = _t;
			match(_t,EQUAL);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop128;
				}
				
			}
			_loop128:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop130;
				}
				
			}
			_loop130:;
			} // ( ... )*
			_t = __t126;
			_t = _t->getNextSibling();
			break;
		}
		case DIAGRAM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t131 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp35_AST_in = _t;
			match(_t,DIAGRAM);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop133;
				}
				
			}
			_loop133:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop135;
				}
				
			}
			_loop135:;
			} // ( ... )*
			_t = __t131;
			_t = _t->getNextSibling();
			break;
		}
		case ICON:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t136 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp36_AST_in = _t;
			match(_t,ICON);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop138;
				}
				
			}
			_loop138:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop140;
				}
				
			}
			_loop140:;
			} // ( ... )*
			_t = __t136;
			_t = _t->getNextSibling();
			break;
		}
		case POLYGON:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t141 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp37_AST_in = _t;
			match(_t,POLYGON);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop143;
				}
				
			}
			_loop143:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop145;
				}
				
			}
			_loop145:;
			} // ( ... )*
			_t = __t141;
			_t = _t->getNextSibling();
			break;
		}
		case ELLIPSE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t146 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp38_AST_in = _t;
			match(_t,ELLIPSE);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop148;
				}
				
			}
			_loop148:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop150;
				}
				
			}
			_loop150:;
			} // ( ... )*
			_t = __t146;
			_t = _t->getNextSibling();
			break;
		}
		case LINE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t151 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp39_AST_in = _t;
			match(_t,LINE);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop153;
				}
				
			}
			_loop153:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop155;
				}
				
			}
			_loop155:;
			} // ( ... )*
			_t = __t151;
			_t = _t->getNextSibling();
			break;
		}
		case GRAYLEVEL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t156 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp40_AST_in = _t;
			match(_t,GRAYLEVEL);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop158;
				}
				
			}
			_loop158:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop160;
				}
				
			}
			_loop160:;
			} // ( ... )*
			_t = __t156;
			_t = _t->getNextSibling();
			break;
		}
		case STYLEDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t161 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp41_AST_in = _t;
			match(_t,STYLEDATA);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop163;
				}
				
			}
			_loop163:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop165;
				}
				
			}
			_loop165:;
			} // ( ... )*
			_t = __t161;
			_t = _t->getNextSibling();
			break;
		}
		case NOT_MATH_OLEDATE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t166 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp42_AST_in = _t;
			match(_t,NOT_MATH_OLEDATE);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop168;
				}
				
			}
			_loop168:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if (((_t->getType() >= RULE && _t->getType() <= RULEDELAYED))) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop170;
				}
				
			}
			_loop170:;
			} // ( ... )*
			_t = __t166;
			_t = _t->getNextSibling();
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

string  AntlrNotebookTreeParser::value(ANTLR_USE_NAMESPACE(antlr)RefAST _t) {
	string value;
	ANTLR_USE_NAMESPACE(antlr)RefAST value_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST str = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST num = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST tr = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fl = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST rightval = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST leftval = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST centerval = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST smallerval = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST inherited = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST paperwidth = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowwidth = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST tradform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST stdform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST inputform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST outputform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST defaultinputformattype = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST automatic = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST none = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST nullsym = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST allsym = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case QSTRING:
		{
			str = _t;
			match(_t,QSTRING);
			_t = _t->getNextSibling();
			
			//Move this to TextCell.
			
			//Delete quotes
			value = str->getText();
			value.assign(value, 1, value.length()-2);            
			
			break;
		}
		case NUMBER:
		{
			num = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			
			value = string(num->getText());   
			
			break;
		}
		case TRUE_:
		{
			tr = _t;
			match(_t,TRUE_);
			_t = _t->getNextSibling();
			
			value = string(tr->getText()); 
			
			break;
		}
		case FALSE_:
		{
			fl = _t;
			match(_t,FALSE_);
			_t = _t->getNextSibling();
			
			value =string(fl->getText());
			
			break;
		}
		case VALUERIGHT:
		{
			rightval = _t;
			match(_t,VALUERIGHT);
			_t = _t->getNextSibling();
			
			value = string(rightval->getText()); 
			
			break;
		}
		case VALUELEFT:
		{
			leftval = _t;
			match(_t,VALUELEFT);
			_t = _t->getNextSibling();
			
			value = string(leftval->getText()); 
			
			break;
		}
		case VALUECENTER:
		{
			centerval = _t;
			match(_t,VALUECENTER);
			_t = _t->getNextSibling();
			
			value = string(centerval->getText());
			
			break;
		}
		case VALUESMALLER:
		{
			smallerval = _t;
			match(_t,VALUESMALLER);
			_t = _t->getNextSibling();
			
			value = string(smallerval->getText());
			
			break;
		}
		case INHERITED:
		{
			inherited = _t;
			match(_t,INHERITED);
			_t = _t->getNextSibling();
			
					    value = string(inherited->getText());
					
			break;
		}
		case PAPERWIDTH:
		{
			paperwidth = _t;
			match(_t,PAPERWIDTH);
			_t = _t->getNextSibling();
			
				        value = string(paperwidth->getText());
				
			break;
		}
		case WINDOWWIDTH:
		{
			windowwidth = _t;
			match(_t,WINDOWWIDTH);
			_t = _t->getNextSibling();
			
				        value = string(windowwidth->getText());
				
			break;
		}
		case TRADITIONALFORM:
		{
			tradform = _t;
			match(_t,TRADITIONALFORM);
			_t = _t->getNextSibling();
			
			//value = string(tradform->getText()); 
			
			break;
		}
		case STANDARDFORM:
		{
			stdform = _t;
			match(_t,STANDARDFORM);
			_t = _t->getNextSibling();
			
			//value = string(stdform->getText()); 
			
			break;
		}
		case INPUTFORM:
		{
			inputform = _t;
			match(_t,INPUTFORM);
			_t = _t->getNextSibling();
			
			//value = string(inputform->getText()); 
			
			break;
		}
		case OUTPUTFORM:
		{
			outputform = _t;
			match(_t,OUTPUTFORM);
			_t = _t->getNextSibling();
			
			//value = string(outputform->getText()); 
			
			break;
		}
		case DEFAULTINPUTFORMATTYPE:
		{
			defaultinputformattype = _t;
			match(_t,DEFAULTINPUTFORMATTYPE);
			_t = _t->getNextSibling();
			
			value = string(defaultinputformattype->getText());
			
			break;
		}
		case AUTOMATIC:
		{
			automatic = _t;
			match(_t,AUTOMATIC);
			_t = _t->getNextSibling();
			
			//value = string(automatic->getText()); 
			
			break;
		}
		case NONESYM:
		{
			none = _t;
			match(_t,NONESYM);
			_t = _t->getNextSibling();
			
			//value = string(none->getText()); 
			
			break;
		}
		case NULLSYM:
		{
			nullsym = _t;
			match(_t,NULLSYM);
			_t = _t->getNextSibling();
			
			value = string(nullsym->getText());
			
			break;
		}
		case ALLSYM:
		{
			allsym = _t;
			match(_t,ALLSYM);
			_t = _t->getNextSibling();
			
			value = string(allsym->getText());
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
	return value;
}

string  AntlrNotebookTreeParser::attribute(ANTLR_USE_NAMESPACE(antlr)RefAST _t) {
	string value;
	ANTLR_USE_NAMESPACE(antlr)RefAST attribute_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontslant = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontsize = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontcolor = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontweight = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontfamily = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontvariations = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST textalignment = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST textjustification = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST initializationcell = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST formattype = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pagewidth = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pageheaders = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pageheaderlines = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pagefooters = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pagefooterlines = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pagebreakbelow = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pagebreakwithin = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST boxmargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST boxbaselineshift = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST linespacing = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST hyphenation = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST activetoken = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST visibletoken = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST evaluatable = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttonfunction = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttondata = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttonevaluator = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttonstyle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST characterencoding = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST showstringcharacters = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST screenrectangle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST autogeneratedpackage = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST autoitalicwords = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST inputautoreplacements = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST scriptminsize = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST stylemenulisting = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST counterincrements = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST counterassignments = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST privateevaloptions = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST grouppagewithin = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST defaultformattype = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST numbermarks = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST linebreakadjustments = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST visiolineformat = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST visiofillformat = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST extent = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST nameposition = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST celltags = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellframe = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellframecolor = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellframelabels = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellframemargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellframelabelmargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST celllabelmargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST celllabelpositioning = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellmargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST celldingbat = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellhorizontalscrolling = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellopen = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellgenerated = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellshowbracket = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellshowlabel = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellbracketoptions = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST editable = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST background = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellgroupingrules = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowsize = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowmargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowframe = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowelements = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowtitle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowtoolbars = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowmoveable = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowfloating = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowclickselect = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST styledefinitions = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST frontendversion = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST screenstyleenv = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST printingstyleenv = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST printingoptions = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST printingcopies = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST printingpagerange = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST privatefontoption = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST magnification = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST generatedCell = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellautoovrt = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagesize = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagemargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imageregion = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagerangecache = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagecache = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST modeleditor = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case FONTSLANT:
		{
			fontslant = _t;
			match(_t,FONTSLANT);
			_t = _t->getNextSibling();
			
			value = string(fontslant->getText());
			
			break;
		}
		case FONTSIZE:
		{
			fontsize = _t;
			match(_t,FONTSIZE);
			_t = _t->getNextSibling();
			
			value = string(fontsize->getText());
			
			break;
		}
		case FONTCOLOR:
		{
			fontcolor = _t;
			match(_t,FONTCOLOR);
			_t = _t->getNextSibling();
			
			value = string(fontcolor->getText());
			
			break;
		}
		case FONTWEIGHT:
		{
			fontweight = _t;
			match(_t,FONTWEIGHT);
			_t = _t->getNextSibling();
			
			value = string(fontweight->getText());
			
			break;
		}
		case FONTFAMILY:
		{
			fontfamily = _t;
			match(_t,FONTFAMILY);
			_t = _t->getNextSibling();
			
			value = string(fontfamily->getText());
			
			break;
		}
		case FONTVARIATIONS:
		{
			fontvariations = _t;
			match(_t,FONTVARIATIONS);
			_t = _t->getNextSibling();
			
			value = string(fontvariations->getText());
			
			break;
		}
		case TEXTALIGNMENT:
		{
			textalignment = _t;
			match(_t,TEXTALIGNMENT);
			_t = _t->getNextSibling();
			
			value = string(textalignment->getText());
			
			break;
		}
		case TEXTJUSTIFICATION:
		{
			textjustification = _t;
			match(_t,TEXTJUSTIFICATION);
			_t = _t->getNextSibling();
			
			value = string(textjustification->getText());
			
			break;
		}
		case INITIALIZATIONCELL:
		{
			initializationcell = _t;
			match(_t,INITIALIZATIONCELL);
			_t = _t->getNextSibling();
			
			value = string(initializationcell->getText());
			
			break;
		}
		case FORMATTYPE_TOKEN:
		{
			formattype = _t;
			match(_t,FORMATTYPE_TOKEN);
			_t = _t->getNextSibling();
			
			value = string(formattype->getText());
			
			break;
		}
		case PAGEWIDTH:
		{
			pagewidth = _t;
			match(_t,PAGEWIDTH);
			_t = _t->getNextSibling();
			
			value = string(pagewidth->getText());
			
			break;
		}
		case PAGEHEADERS:
		{
			pageheaders = _t;
			match(_t,PAGEHEADERS);
			_t = _t->getNextSibling();
			
			value = string(pageheaders->getText());
			
			break;
		}
		case PAGEHEADERLINES:
		{
			pageheaderlines = _t;
			match(_t,PAGEHEADERLINES);
			_t = _t->getNextSibling();
			
			value = string(pageheaderlines->getText());
			
			break;
		}
		case PAGEFOOTERS:
		{
			pagefooters = _t;
			match(_t,PAGEFOOTERS);
			_t = _t->getNextSibling();
			
			value = string(pagefooters->getText());
			
			break;
		}
		case PAGEFOOTERLINES:
		{
			pagefooterlines = _t;
			match(_t,PAGEFOOTERLINES);
			_t = _t->getNextSibling();
			
			value = string(pagefooterlines->getText());
			
			break;
		}
		case PAGEBREAKBELOW:
		{
			pagebreakbelow = _t;
			match(_t,PAGEBREAKBELOW);
			_t = _t->getNextSibling();
			
			value = string(pagebreakbelow->getText());
			
			break;
		}
		case PAGEBREAKWITHIN:
		{
			pagebreakwithin = _t;
			match(_t,PAGEBREAKWITHIN);
			_t = _t->getNextSibling();
			
			value = string(pagebreakwithin->getText());
			
			break;
		}
		case BOXMARGINS:
		{
			boxmargins = _t;
			match(_t,BOXMARGINS);
			_t = _t->getNextSibling();
			
			value = string(boxmargins->getText());
			
			break;
		}
		case BOXBASELINESHIFT:
		{
			boxbaselineshift = _t;
			match(_t,BOXBASELINESHIFT);
			_t = _t->getNextSibling();
			
			value = string(boxbaselineshift->getText());
			
			break;
		}
		case LINESPACING:
		{
			linespacing = _t;
			match(_t,LINESPACING);
			_t = _t->getNextSibling();
			
			value = string(linespacing->getText());
			
			break;
		}
		case HYPHENATION:
		{
			hyphenation = _t;
			match(_t,HYPHENATION);
			_t = _t->getNextSibling();
			
			value = string(hyphenation->getText());
			
			break;
		}
		case ACTIVE_TOKEN:
		{
			activetoken = _t;
			match(_t,ACTIVE_TOKEN);
			_t = _t->getNextSibling();
			
			value = string(activetoken->getText());
			
			break;
		}
		case VISIBLE_TOKEN:
		{
			visibletoken = _t;
			match(_t,VISIBLE_TOKEN);
			_t = _t->getNextSibling();
			
			value = string(visibletoken->getText());
			
			break;
		}
		case EVALUATABLE:
		{
			evaluatable = _t;
			match(_t,EVALUATABLE);
			_t = _t->getNextSibling();
			
			value = string(evaluatable->getText());
			
			break;
		}
		case BUTTONFUNCTION:
		{
			buttonfunction = _t;
			match(_t,BUTTONFUNCTION);
			_t = _t->getNextSibling();
			
			value = string(buttonfunction->getText());
			
			break;
		}
		case BUTTONDATA:
		{
			buttondata = _t;
			match(_t,BUTTONDATA);
			_t = _t->getNextSibling();
			
			value = string(buttondata->getText());
			
			break;
		}
		case BUTTONEVALUATOR:
		{
			buttonevaluator = _t;
			match(_t,BUTTONEVALUATOR);
			_t = _t->getNextSibling();
			
			value = string(buttonevaluator->getText());
			
			break;
		}
		case BUTTONSTYLE:
		{
			buttonstyle = _t;
			match(_t,BUTTONSTYLE);
			_t = _t->getNextSibling();
			
			value = string(buttonstyle->getText());
			
			break;
		}
		case CHARACHTERENCODING:
		{
			characterencoding = _t;
			match(_t,CHARACHTERENCODING);
			_t = _t->getNextSibling();
			
			value = string(characterencoding->getText());
			
			break;
		}
		case SHOWSTRINGCHARACTERS:
		{
			showstringcharacters = _t;
			match(_t,SHOWSTRINGCHARACTERS);
			_t = _t->getNextSibling();
			
			value = string(showstringcharacters->getText());
			
			break;
		}
		case SCREENRECTANGLE:
		{
			screenrectangle = _t;
			match(_t,SCREENRECTANGLE);
			_t = _t->getNextSibling();
			
			value = string(screenrectangle->getText());
			
			break;
		}
		case AUTOGENERATEDPACKAGE:
		{
			autogeneratedpackage = _t;
			match(_t,AUTOGENERATEDPACKAGE);
			_t = _t->getNextSibling();
			
			value = string(autogeneratedpackage->getText());
			
			break;
		}
		case AUTOITALICWORDS:
		{
			autoitalicwords = _t;
			match(_t,AUTOITALICWORDS);
			_t = _t->getNextSibling();
			
			value = string(autoitalicwords->getText());
			
			break;
		}
		case INPUTAUTOREPLACEMENTS:
		{
			inputautoreplacements = _t;
			match(_t,INPUTAUTOREPLACEMENTS);
			_t = _t->getNextSibling();
			
			value = string(inputautoreplacements->getText());
			
			break;
		}
		case SCRIPTMINSIZE:
		{
			scriptminsize = _t;
			match(_t,SCRIPTMINSIZE);
			_t = _t->getNextSibling();
			
			value = string(scriptminsize->getText());
			
			break;
		}
		case STYLEMEMULISTING:
		{
			stylemenulisting = _t;
			match(_t,STYLEMEMULISTING);
			_t = _t->getNextSibling();
			
			value = string(stylemenulisting->getText());
			
			break;
		}
		case COUNTERINCREMENTS:
		{
			counterincrements = _t;
			match(_t,COUNTERINCREMENTS);
			_t = _t->getNextSibling();
			
			value = string(counterincrements->getText());
			
			break;
		}
		case COUNTERASSIGNMENTS:
		{
			counterassignments = _t;
			match(_t,COUNTERASSIGNMENTS);
			_t = _t->getNextSibling();
			
			value = string(counterassignments->getText());
			
			break;
		}
		case PRIVATEEVALOPTIONS:
		{
			privateevaloptions = _t;
			match(_t,PRIVATEEVALOPTIONS);
			_t = _t->getNextSibling();
			
			value = string(privateevaloptions->getText());
			
			break;
		}
		case GROUPPAGEBREAKWITHIN:
		{
			grouppagewithin = _t;
			match(_t,GROUPPAGEBREAKWITHIN);
			_t = _t->getNextSibling();
			
			value = string(grouppagewithin->getText());
			
			break;
		}
		case DEFAULTFORMATTYPE:
		{
			defaultformattype = _t;
			match(_t,DEFAULTFORMATTYPE);
			_t = _t->getNextSibling();
			
			value = string(defaultformattype->getText());
			
			break;
		}
		case NUMBERMARKS:
		{
			numbermarks = _t;
			match(_t,NUMBERMARKS);
			_t = _t->getNextSibling();
			
			value = string(numbermarks->getText());
			
			break;
		}
		case LINEBREAKADJUSTMENTS:
		{
			linebreakadjustments = _t;
			match(_t,LINEBREAKADJUSTMENTS);
			_t = _t->getNextSibling();
			
			value = string(linebreakadjustments->getText());
			
			break;
		}
		case VISIOLINEFORMAT:
		{
			visiolineformat = _t;
			match(_t,VISIOLINEFORMAT);
			_t = _t->getNextSibling();
			
			value = string(visiolineformat->getText());
			
			break;
		}
		case VISIOFILLFORMAT:
		{
			visiofillformat = _t;
			match(_t,VISIOFILLFORMAT);
			_t = _t->getNextSibling();
			
			value = string(visiofillformat->getText());
			
			break;
		}
		case EXTENT:
		{
			extent = _t;
			match(_t,EXTENT);
			_t = _t->getNextSibling();
			
			value = string(extent->getText());
			
			break;
		}
		case NAMEPOSITION:
		{
			nameposition = _t;
			match(_t,NAMEPOSITION);
			_t = _t->getNextSibling();
			
			value = string(nameposition->getText());
			
			break;
		}
		case CELLTAGS:
		{
			celltags = _t;
			match(_t,CELLTAGS);
			_t = _t->getNextSibling();
			
			value = string(celltags->getText());
			
			break;
		}
		case CELLFRAME:
		{
			cellframe = _t;
			match(_t,CELLFRAME);
			_t = _t->getNextSibling();
			
			value = string(cellframe->getText());
			
			break;
		}
		case CELLFRAMECOLOR:
		{
			cellframecolor = _t;
			match(_t,CELLFRAMECOLOR);
			_t = _t->getNextSibling();
			
			value = string(cellframecolor->getText());
			
			break;
		}
		case CELLFRAMELABELS:
		{
			cellframelabels = _t;
			match(_t,CELLFRAMELABELS);
			_t = _t->getNextSibling();
			
			value = string(cellframelabels->getText());
			
			break;
		}
		case CELLFRAMEMARGINS:
		{
			cellframemargins = _t;
			match(_t,CELLFRAMEMARGINS);
			_t = _t->getNextSibling();
			
			value = string(cellframemargins->getText());
			
			break;
		}
		case CELLFRAMELABELMARGINS:
		{
			cellframelabelmargins = _t;
			match(_t,CELLFRAMELABELMARGINS);
			_t = _t->getNextSibling();
			
			value = string(cellframelabelmargins->getText());
			
			break;
		}
		case CELLLABRLMARGINS:
		{
			celllabelmargins = _t;
			match(_t,CELLLABRLMARGINS);
			_t = _t->getNextSibling();
			
			value = string(celllabelmargins->getText());
			
			break;
		}
		case CELLLABELPOSITIONING:
		{
			celllabelpositioning = _t;
			match(_t,CELLLABELPOSITIONING);
			_t = _t->getNextSibling();
			
			value = string(celllabelpositioning->getText());
			
			break;
		}
		case CELLMARGINS:
		{
			cellmargins = _t;
			match(_t,CELLMARGINS);
			_t = _t->getNextSibling();
			
					    value = string(cellmargins->getText());
					
			break;
		}
		case CELLDINGBAT:
		{
			celldingbat = _t;
			match(_t,CELLDINGBAT);
			_t = _t->getNextSibling();
			
				        value = string(celldingbat->getText());
				
			break;
		}
		case CELLHORIZONTALSCROLL:
		{
			cellhorizontalscrolling = _t;
			match(_t,CELLHORIZONTALSCROLL);
			_t = _t->getNextSibling();
			
				        value = string(cellhorizontalscrolling->getText());
				
			break;
		}
		case CELLOPEN:
		{
			cellopen = _t;
			match(_t,CELLOPEN);
			_t = _t->getNextSibling();
			
				        value = string(cellopen->getText());
				
			break;
		}
		case CELLGENERATED:
		{
			cellgenerated = _t;
			match(_t,CELLGENERATED);
			_t = _t->getNextSibling();
			
			value = string(cellgenerated->getText());
			
			break;
		}
		case SHOWCELLBRACKET:
		{
			cellshowbracket = _t;
			match(_t,SHOWCELLBRACKET);
			_t = _t->getNextSibling();
			
			value = string(cellshowbracket->getText());
			
			break;
		}
		case SHOWCELLLABEL:
		{
			cellshowlabel = _t;
			match(_t,SHOWCELLLABEL);
			_t = _t->getNextSibling();
			
			value = string(cellshowlabel->getText());
			
			break;
		}
		case CELLBRACKETOPT:
		{
			cellbracketoptions = _t;
			match(_t,CELLBRACKETOPT);
			_t = _t->getNextSibling();
			
			value = string(cellbracketoptions->getText());
			
			break;
		}
		case EDITABLE:
		{
			editable = _t;
			match(_t,EDITABLE);
			_t = _t->getNextSibling();
			
			value = string(editable->getText());
			
			break;
		}
		case BACKGROUND:
		{
			background = _t;
			match(_t,BACKGROUND);
			_t = _t->getNextSibling();
			
			value = string(background->getText());
			
			break;
		}
		case CELLGROUPINGRULES:
		{
			cellgroupingrules = _t;
			match(_t,CELLGROUPINGRULES);
			_t = _t->getNextSibling();
			
			value = string(cellgroupingrules->getText());
			
			break;
		}
		case WINDOWSIZE:
		{
			windowsize = _t;
			match(_t,WINDOWSIZE);
			_t = _t->getNextSibling();
			
			value = string(windowsize->getText());
			
			break;
		}
		case WINDOWMARGINS:
		{
			windowmargins = _t;
			match(_t,WINDOWMARGINS);
			_t = _t->getNextSibling();
			
			value = string(windowmargins->getText());
			
			break;
		}
		case WINDOWFRAME:
		{
			windowframe = _t;
			match(_t,WINDOWFRAME);
			_t = _t->getNextSibling();
			
			value = string(windowframe->getText());
			
			break;
		}
		case WINDOWELEMENTS:
		{
			windowelements = _t;
			match(_t,WINDOWELEMENTS);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWTITLE:
		{
			windowtitle = _t;
			match(_t,WINDOWTITLE);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWTOOLBARS:
		{
			windowtoolbars = _t;
			match(_t,WINDOWTOOLBARS);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWMOVEABLE:
		{
			windowmoveable = _t;
			match(_t,WINDOWMOVEABLE);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWFLOATING:
		{
			windowfloating = _t;
			match(_t,WINDOWFLOATING);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWCLICKSELECT:
		{
			windowclickselect = _t;
			match(_t,WINDOWCLICKSELECT);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case STYLEDEFINITIONS:
		{
			styledefinitions = _t;
			match(_t,STYLEDEFINITIONS);
			_t = _t->getNextSibling();
			
			value = string(styledefinitions->getText());
			
			break;
		}
		case FRONTENDVERSION:
		{
			frontendversion = _t;
			match(_t,FRONTENDVERSION);
			_t = _t->getNextSibling();
			
			value = string(frontendversion->getText());
			
			break;
		}
		case SCREENSTYLEENV:
		{
			screenstyleenv = _t;
			match(_t,SCREENSTYLEENV);
			_t = _t->getNextSibling();
			
			value = string(screenstyleenv->getText());
			
			break;
		}
		case PRINTINGSTYLEENV:
		{
			printingstyleenv = _t;
			match(_t,PRINTINGSTYLEENV);
			_t = _t->getNextSibling();
			
			value = string(printingstyleenv->getText());
			
			break;
		}
		case PRINTINGOPTIONS:
		{
			printingoptions = _t;
			match(_t,PRINTINGOPTIONS);
			_t = _t->getNextSibling();
			
			value = string(printingoptions->getText());
			
			break;
		}
		case PRINTINGCOPIES:
		{
			printingcopies = _t;
			match(_t,PRINTINGCOPIES);
			_t = _t->getNextSibling();
			
			value = string(printingcopies->getText());
			
			break;
		}
		case PRINTINGPAGERANGE:
		{
			printingpagerange = _t;
			match(_t,PRINTINGPAGERANGE);
			_t = _t->getNextSibling();
			
			value = string(printingpagerange->getText());
			
			break;
		}
		case PRIVATEFONTOPTIONS:
		{
			privatefontoption = _t;
			match(_t,PRIVATEFONTOPTIONS);
			_t = _t->getNextSibling();
			
			value = string(privatefontoption->getText());
			
			break;
		}
		case MAGNIFICATION:
		{
			magnification = _t;
			match(_t,MAGNIFICATION);
			_t = _t->getNextSibling();
			
			value = string(magnification->getText());
			
			break;
		}
		case GENERATEDCELL:
		{
			generatedCell = _t;
			match(_t,GENERATEDCELL);
			_t = _t->getNextSibling();
			
			value = string(generatedCell->getText());
			
			break;
		}
		case CELLAUTOOVRT:
		{
			cellautoovrt = _t;
			match(_t,CELLAUTOOVRT);
			_t = _t->getNextSibling();
			
			value = string(cellautoovrt->getText());
			
			break;
		}
		case IMAGESIZE:
		{
			imagesize = _t;
			match(_t,IMAGESIZE);
			_t = _t->getNextSibling();
			
			value = string(imagesize->getText());
			
			break;
		}
		case IMAGEMARGINS:
		{
			imagemargins = _t;
			match(_t,IMAGEMARGINS);
			_t = _t->getNextSibling();
			
			value = string(imagemargins->getText());
			
			break;
		}
		case IMAGEREGION:
		{
			imageregion = _t;
			match(_t,IMAGEREGION);
			_t = _t->getNextSibling();
			
			value = string(imageregion->getText());
			
			break;
		}
		case IMAGERANGECACHE:
		{
			imagerangecache = _t;
			match(_t,IMAGERANGECACHE);
			_t = _t->getNextSibling();
			
			value = string(imagerangecache->getText());
			
			break;
		}
		case IMAGECACHE:
		{
			imagecache = _t;
			match(_t,IMAGECACHE);
			_t = _t->getNextSibling();
			
			value = string(imagecache->getText());
			
			break;
		}
		case NOT_MATH_MODELEDITOR:
		{
			modeleditor = _t;
			match(_t,NOT_MATH_MODELEDITOR);
			_t = _t->getNextSibling();
			
			value = string(modeleditor->getText());
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
	return value;
}

void AntlrNotebookTreeParser::rule(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	rules_t &rules
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST rule_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	ostringstream attoutput;
	ostringstream valoutput;
	result_t attribute(attoutput);
	result_t value(valoutput);
	
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case RULE:
		{
			
			
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t173 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp43_AST_in = _t;
			match(_t,RULE);
			_t = _t->getFirstChild();
			expr(_t,attribute);
			_t = _retTree;
			expr(_t,value);
			_t = _retTree;
			_t = __t173;
			_t = _t->getNextSibling();
			
			//rules.push_back(Rule(attribute.first.str(), value.first.str()));
			rules.push_back(rule_t(attribute.first.str(), value.first.str()));
			
			break;
		}
		case RULE_SMALL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t174 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp44_AST_in = _t;
			match(_t,RULE_SMALL);
			_t = _t->getFirstChild();
			expr(_t,attribute);
			_t = _retTree;
			expr(_t,value);
			_t = _retTree;
			_t = __t174;
			_t = _t->getNextSibling();
			
			
			break;
		}
		case RULEDELAYED:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t175 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp45_AST_in = _t;
			match(_t,RULEDELAYED);
			_t = _t->getFirstChild();
			expr(_t,attribute);
			_t = _retTree;
			expr(_t,value);
			_t = _retTree;
			_t = __t175;
			_t = _t->getNextSibling();
			
			//rules.push_back(Rule(attribute.first.str(), value.first.str()));
			rules.push_back(rule_t(attribute.first.str(), value.first.str()));
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::listelement(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	result_t &list
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST listelement_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	ostringstream resoutput;
	result_t result(resoutput);
	
	
	try {      // for error handling
		expr(_t,result);
		_t = _retTree;
		
		list.first << result.first.str();
		
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& )
{
}
const char* AntlrNotebookTreeParser::tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"\"FrontEnd\"",
	"\"List\"",
	"\"list\"",
	"\"Notebook\"",
	"\"Cell\"",
	"\"TextData\"",
	"\"CellGroupData\"",
	"\"Rule\"",
	"\"rule\"",
	"\"RuleDelayed\"",
	"\"GrayLevel\"",
	"\"RGBColor\"",
	"\"FileName\"",
	"\"StyleBox\"",
	"\"StyleData\"",
	"\"BoxData\"",
	"\"ButtonBox\"",
	"\"FormBox\"",
	"\"RowBox\"",
	"\"GridBox\"",
	"\"TagBox\"",
	"\"CounterBox\"",
	"\"AdjustmentBox\"",
	"\"SuperscriptBox\"",
	"\"SubscriptBox\"",
	"\"SubsuperscriptBox\"",
	"\"UnderscriptBox\"",
	"\"OverscriptBox\"",
	"\"UnderoverscriptBox\"",
	"\"FractionBox\"",
	"\"SqrtBox\"",
	"\"RadicalBox\"",
	"\"InterpretationBox\"",
	"\"Annotation\"",
	"\"Equal\"",
	"\"Diagram\"",
	"\"Icon\"",
	"\"Polygon\"",
	"\"Ellipse\"",
	"\"Line\"",
	"\"DirectedInfinity\"",
	"\"StartModelEditor\"",
	"\"OLEData\"",
	"\"FontSlant\"",
	"\"FontSize\"",
	"\"FontColor\"",
	"\"FontWeight\"",
	"\"FontFamily\"",
	"\"FontVariations\"",
	"\"TextAlignment\"",
	"\"TextJustification\"",
	"\"InitializationCell\"",
	"\"FormatType\"",
	"\"PageWidth\"",
	"\"PageHeaders\"",
	"\"PageHeaderLines\"",
	"\"PageFooters\"",
	"\"PageFooterLines\"",
	"\"PageBreakBelow\"",
	"\"PageBreakWithin\"",
	"\"BoxMargins\"",
	"\"BoxBaselineShift\"",
	"\"LineSpacing\"",
	"\"Hyphenation\"",
	"\"Active\"",
	"\"Visible\"",
	"\"Evaluatable\"",
	"\"ButtonFunction\"",
	"\"ButtonData\"",
	"\"ButtonEvaluator\"",
	"\"ButtonStyle\"",
	"\"CharacterEncoding\"",
	"\"ShowStringCharacters\"",
	"\"ScreenRectangle\"",
	"\"AutoGeneratedPackage\"",
	"\"AutoItalicWords\"",
	"\"InputAutoReplacements\"",
	"\"ScriptMinSize\"",
	"\"StyleMenuListing\"",
	"\"CounterIncrements\"",
	"\"CounterAssignments\"",
	"\"PrivateEvaluationOptions\"",
	"\"GroupPageBreakWithin\"",
	"\"DefaultFormatType\"",
	"\"NumberMarks\"",
	"\"LinebreakAdjustments\"",
	"\"VisioLineFormat\"",
	"\"VisioFillFormat\"",
	"\"Extent\"",
	"\"NamePosition\"",
	"\"CellTags\"",
	"\"CellFrame\"",
	"\"CellFrameColor\"",
	"\"CellFrameLabels\"",
	"\"CellFrameMargins\"",
	"\"CellFrameLabelMargins\"",
	"\"CellLabelMargins\"",
	"\"CellLabelPositioning\"",
	"\"CellMargins\"",
	"\"CellDingbat\"",
	"\"CellHorizontalScrolling\"",
	"\"CellOpen\"",
	"\"GeneratedCell\"",
	"\"ShowCellBracket\"",
	"\"ShowCellLabel\"",
	"\"CellBracketOptions\"",
	"\"Editable\"",
	"\"Background\"",
	"\"CellGroupingRules\"",
	"\"WindowSize\"",
	"\"WindowMargins\"",
	"\"WindowFrame\"",
	"\"WindowElements\"",
	"\"WindowTitle\"",
	"\"WindowToolbars\"",
	"\"WindowMoveable\"",
	"\"WindowFloating\"",
	"\"WindowClickSelect\"",
	"\"StyleDefinitions\"",
	"\"FrontEndVersion\"",
	"\"ScreenStyleEnvironment\"",
	"\"PrintingStyleEnvironment\"",
	"\"PrintingOptions\"",
	"\"PrintingCopies\"",
	"\"PrintingPageRange\"",
	"\"PrivateFontOptions\"",
	"\"Open\"",
	"\"Closed\"",
	"\"Right\"",
	"\"Left\"",
	"\"Center\"",
	"\"Smaller\"",
	"\"Inherited\"",
	"\"PaperWidth\"",
	"\"WindowWidth\"",
	"\"True\"",
	"\"False\"",
	"\"Automatic\"",
	"\"TraditionalForm\"",
	"\"StandardForm\"",
	"\"InputForm\"",
	"\"OutputForm\"",
	"\"DefaultInputFormatType\"",
	"\"Null\"",
	"\"None\"",
	"\"All\"",
	"\"GraphicsData\"",
	"\"ImageSize\"",
	"\"ImageMargins\"",
	"\"ImageRegion\"",
	"\"ImageRangeCache\"",
	"\"ImageCache\"",
	"\"ModelEditor\"",
	"\"GenerateCell\"",
	"\"CellAutoOverwrite\"",
	"\"Magnification\"",
	"\"ParentDirectory\"",
	"RBRACK",
	"LBRACK",
	"RCURLY",
	"LCURLY",
	"COMMA",
	"THICK",
	"COMMENTSTART",
	"COMMENTEND",
	"NUMBER",
	"ID",
	"EXP",
	"DIGIT",
	"QSTRING",
	"WHITESPACE",
	"COMMENT",
	"LISTBODY",
	"BACKGROUND",
	"GENERATEDCELL",
	0
};

const unsigned long AntlrNotebookTreeParser::_tokenSet_0_data_[] = { 4294952944UL, 4294959103UL, 4294967295UL, 4294934527UL, 3758096371UL, 467456UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// "FrontEnd" "List" "list" "Notebook" "Cell" "TextData" "CellGroupData" 
// "GrayLevel" "RGBColor" "FileName" "StyleBox" "StyleData" "BoxData" "ButtonBox" 
// "FormBox" "RowBox" "GridBox" "TagBox" "CounterBox" "AdjustmentBox" "SuperscriptBox" 
// "SubscriptBox" "SubsuperscriptBox" "UnderscriptBox" "OverscriptBox" 
// "UnderoverscriptBox" "FractionBox" "SqrtBox" "RadicalBox" "InterpretationBox" 
// "Annotation" "Equal" "Diagram" "Icon" "Polygon" "Ellipse" "Line" "DirectedInfinity" 
// "OLEData" "FontSlant" "FontSize" "FontColor" "FontWeight" "FontFamily" 
// "FontVariations" "TextAlignment" "TextJustification" "InitializationCell" 
// "FormatType" "PageWidth" "PageHeaders" "PageHeaderLines" "PageFooters" 
// "PageFooterLines" "PageBreakBelow" "PageBreakWithin" "BoxMargins" "BoxBaselineShift" 
// "LineSpacing" "Hyphenation" "Active" "Visible" "Evaluatable" "ButtonFunction" 
// "ButtonData" "ButtonEvaluator" "ButtonStyle" "CharacterEncoding" "ShowStringCharacters" 
// "ScreenRectangle" "AutoGeneratedPackage" "AutoItalicWords" "InputAutoReplacements" 
// "ScriptMinSize" "StyleMenuListing" "CounterIncrements" "CounterAssignments" 
// "PrivateEvaluationOptions" "GroupPageBreakWithin" "DefaultFormatType" 
// "NumberMarks" "LinebreakAdjustments" "VisioLineFormat" "VisioFillFormat" 
// "Extent" "NamePosition" "CellTags" "CellFrame" "CellFrameColor" "CellFrameLabels" 
// "CellFrameMargins" "CellFrameLabelMargins" "CellLabelMargins" "CellLabelPositioning" 
// "CellMargins" "CellDingbat" "CellHorizontalScrolling" "CellOpen" "GeneratedCell" 
// "ShowCellBracket" "ShowCellLabel" "CellBracketOptions" "Editable" "CellGroupingRules" 
// "WindowSize" "WindowMargins" "WindowFrame" "WindowElements" "WindowTitle" 
// "WindowToolbars" "WindowMoveable" "WindowFloating" "WindowClickSelect" 
// "StyleDefinitions" "FrontEndVersion" "ScreenStyleEnvironment" "PrintingStyleEnvironment" 
// "PrintingOptions" "PrintingCopies" "PrintingPageRange" "PrivateFontOptions" 
// "Right" "Left" "Center" "Smaller" "Inherited" "PaperWidth" "WindowWidth" 
// "True" "False" "Automatic" "TraditionalForm" "StandardForm" "InputForm" 
// "OutputForm" "DefaultInputFormatType" "Null" "None" "All" "GraphicsData" 
// "ImageSize" "ImageMargins" "ImageRegion" "ImageRangeCache" "ImageCache" 
// "ModelEditor" "CellAutoOverwrite" "Magnification" NUMBER QSTRING LISTBODY 
// BACKGROUND GENERATEDCELL 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookTreeParser::_tokenSet_0(_tokenSet_0_data_,12);


