// name:     Extends3
// keywords: extends basictype operators
// status:   correct
// 
// Testing extending basic type and matrix multiplication operators (MC bug #643)

connector RealSignal
  replaceable type SignalType = Real;
  extends SignalType;
end RealSignal;

connector RealInput = input RealSignal;
connector RealOutput = output RealSignal;

block SS
  RealInput u[nin];
  RealOutput y[nout];
  parameter Integer nin=1;
  parameter Integer nout=2;
  parameter Real B[2,1] = {{1},{2}};
equation
  y = B*u;
end SS;

// fclass SS
// Real u[1];
// Real y[1];
// Real y[2];
// parameter Integer nin = 1;
// parameter Integer nout = 2;
// parameter Real B[1,1] = 1;
// parameter Real B[2,1] = 2;
// equation
//   y[1] = B[1,1] * u[1];
//   y[2] = B[2,1] * u[1];
// end SS;


