package Mechanics "Library for mechanical systems"
   extends Modelica.Icons.Library2;
   annotation (preferedView="info",Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-5.,-40.},{45.,-70.}},fillColor={192,192,192},lineColor={0,0,0},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder),Ellipse(extent={{-90.,-50.},{-80.,-60.}},lineColor={0,0,0}),Line(points={{-85.,-55.},{-60.,-21.}},color={0,0,0},thickness=0.5),Ellipse(extent={{-65.,-16.},{-55.,-26.}},lineColor={0,0,0}),Line(points={{-60.,-21.},{9.,-55.}},color={0,0,0},thickness=0.5),Ellipse(extent={{4.,-50.},{14.,-60.}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid),Line(points={{-10.,-34.},{72.,-34.},{72.,-76.},{-10.,-76.}},color={0,0,0})}),Documentation(info="<HTML>
 <p>
 This package contains components to model <b>mechanical systems</b>.
 Currently, the following subpackages are available:</p>
 <pre>
    <b>MultiBody</b>      3-dimensional mechanical components.
    <b>Rotational</b>     1-dimensional rotational mechanical components.
    <b>Translational</b>  1-dimensional translational mechanical components.
 </pre>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>June 23, 2004</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        included the Mechanics.MultiBody library 1.0 and adapted it to the new
        Blocks connectors.</li>
 <li><i>Oct. 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Bearing torque computation added to package <b>Rotational</b>.</li>
 <li><i>Oct. 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New components and examples in package <b>Rotational</b>.</li>
 <li><i>Oct. 24, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Changes according to the Twente meeting introduced. Especially,
        package Rotational1D renamed to Rotational and package
        Translational1D renamed to Translational. For the particular
        changes in these packages, see the corresponding package
        release notes.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized a first version for 1-dimensional rotational mechanical
        systems based on an existing Dymola library of Martin Otter and
        Hilding Elmqvist.</li>
 </ul>
 </html>"));
end Mechanics;