/* $ANTLR 2.7.4: "parser.g" -> "AntlrNotebookParser.cpp"$ */
#include "AntlrNotebookParser.hpp"
#include <antlr/NoViableAltException.hpp>
#include <antlr/SemanticException.hpp>
#include <antlr/ASTFactory.hpp>
AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,k)
{
}

AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,2)
{
}

AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,k)
{
}

AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,2)
{
}

AntlrNotebookParser::AntlrNotebookParser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(state,2)
{
}

void AntlrNotebookParser::document() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST document_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		expr();
		astFactory->addASTChild( currentAST, returnAST );
		document_AST = currentAST.root;
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	returnAST = document_AST;
}

void AntlrNotebookParser::expr() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST expr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case MODULENAME:
		case LIST:
		case NOTEBOOK:
		case CELL:
		case TEXTDATA:
		case CELLGROUPDATA:
		case GRAYLEVEL:
		case RGBCOLOR:
		case FILENAME:
		case STYLEBOX:
		case BOXDATA:
		case BUTTONBOX:
		case FORMBOX:
		case ROWBOX:
		case SUPERSCRBOX:
		case SUBSUPERSCRIPTBOX:
		case UNDERSCRIPTBOX:
		case OVERSCRIPTBOX:
		case UNDEROVERSCRIPTBOX:
		case FRACTIONBOX:
		case SQRTBOX:
		case RADICALBOX:
		case GRAPHICSDATA:
		case PARENTDIRECTORY:
		{
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == MODULENAME)) {
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
					tmp1_AST = astFactory->create(LT(1));
					astFactory->addASTChild(currentAST, tmp1_AST);
					match(MODULENAME);
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
					tmp2_AST = astFactory->create(LT(1));
					astFactory->addASTChild(currentAST, tmp2_AST);
					match(THICK);
				}
				else {
					goto _loop4;
				}
				
			}
			_loop4:;
			} // ( ... )*
			exprheader();
			astFactory->addASTChild( currentAST, returnAST );
			expr_AST = currentAST.root;
			break;
		}
		case VALUERIGHT:
		case VALUELEFT:
		case TRUE_:
		case FALSE_:
		case AUTOMATIC:
		case TRADITIONALFORM:
		case STANDARDFORM:
		case INPUTFORM:
		case OUTPUTFORM:
		case NULLSYM:
		case NONESYM:
		case NUMBER:
		case QSTRING:
		{
			value();
			astFactory->addASTChild( currentAST, returnAST );
			expr_AST = currentAST.root;
			break;
		}
		case FONTSLANT:
		case FONTSIZE:
		case FONTCOLOR:
		case FONTWEIGHT:
		case FONTFAMILY:
		case FONTVARIATIONS:
		case TEXTALIGNMENT:
		case TEXTJUSTIFICATION:
		case INITIALIZATIONCELL:
		case BUTTONDATA:
		case BUTTONSTYLE:
		case CHARACHTERENCODING:
		case SCREENRECTANGLE:
		case AUTOGENERATEDPACKAGE:
		case CELLTAGS:
		case CELLFRAME:
		case EDITABLE:
		case BACKGROUNT:
		case WINDOWSIZE:
		case WINDOWMARGINS:
		case WINDOWFRAME:
		case WINDOWELEMENTS:
		case WINDOWTITLE:
		case WINDOWTOOLBARS:
		case WINDOWMOVEABLE:
		case WINDOWFLOATING:
		case WINDOWCLICKSELECT:
		case STYLEDEFINITIONS:
		case FRONTENDVERSION:
		case IMAGESIZE:
		case IMAGEMARGINS:
		case IMAGEREGION:
		case IMAGERANGECACHE:
		case IMAGECACHE:
		case CELLAUTOOVRT:
		case MAGNIFICATION:
		case GENERATEDCELL:
		{
			attribute();
			astFactory->addASTChild( currentAST, returnAST );
			expr_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = expr_AST;
}

void AntlrNotebookParser::exprheader() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST exprheader_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case NOTEBOOK:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp3_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp3_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp3_AST);
			match(NOTEBOOK);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop7;
				}
				
			}
			_loop7:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case LIST:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp7_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp7_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp7_AST);
			match(LIST);
			match(LBRACK);
			listbody();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					listbody();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop9;
				}
				
			}
			_loop9:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case CELL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp11_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp11_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp11_AST);
			match(CELL);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
				match(COMMA);
				expr();
				astFactory->addASTChild( currentAST, returnAST );
			}
			else if ((LA(1) == RBRACK || LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
			}
			else {
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			
			}
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop12;
				}
				
			}
			_loop12:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case CELLGROUPDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp16_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp16_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp16_AST);
			match(CELLGROUPDATA);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			match(COMMA);
			{
			switch ( LA(1)) {
			case CELLGROUPOPEN:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp19_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				tmp19_AST = astFactory->create(LT(1));
				astFactory->addASTChild(currentAST, tmp19_AST);
				match(CELLGROUPOPEN);
				break;
			}
			case CELLGROUPCLOSED:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp20_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				tmp20_AST = astFactory->create(LT(1));
				astFactory->addASTChild(currentAST, tmp20_AST);
				match(CELLGROUPCLOSED);
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			}
			}
			}
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case TEXTDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp22_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp22_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp22_AST);
			match(TEXTDATA);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop16;
				}
				
			}
			_loop16:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop18;
				}
				
			}
			_loop18:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case STYLEBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp27_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp27_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp27_AST);
			match(STYLEBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop20;
				}
				
			}
			_loop20:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop22;
				}
				
			}
			_loop22:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case SUPERSCRBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp32_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp32_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp32_AST);
			match(SUPERSCRBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case SUBSUPERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp36_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp36_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp36_AST);
			match(SUBSUPERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop24;
				}
				
			}
			_loop24:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop26;
				}
				
			}
			_loop26:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case UNDERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp41_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp41_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp41_AST);
			match(UNDERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop28;
				}
				
			}
			_loop28:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop30;
				}
				
			}
			_loop30:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case OVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp46_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp46_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp46_AST);
			match(OVERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop32;
				}
				
			}
			_loop32:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop34;
				}
				
			}
			_loop34:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case UNDEROVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp51_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp51_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp51_AST);
			match(UNDEROVERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop36;
				}
				
			}
			_loop36:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop38;
				}
				
			}
			_loop38:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case FRACTIONBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp56_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp56_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp56_AST);
			match(FRACTIONBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop40;
				}
				
			}
			_loop40:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop42;
				}
				
			}
			_loop42:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case SQRTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp61_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp61_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp61_AST);
			match(SQRTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop44;
				}
				
			}
			_loop44:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop46;
				}
				
			}
			_loop46:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case RADICALBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp66_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp66_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp66_AST);
			match(RADICALBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop48;
				}
				
			}
			_loop48:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop50;
				}
				
			}
			_loop50:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case BOXDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp71_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp71_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp71_AST);
			match(BOXDATA);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop52;
				}
				
			}
			_loop52:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop54;
				}
				
			}
			_loop54:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case ROWBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp76_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp76_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp76_AST);
			match(ROWBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop56;
				}
				
			}
			_loop56:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop58;
				}
				
			}
			_loop58:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case FORMBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp81_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp81_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp81_AST);
			match(FORMBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop60;
				}
				
			}
			_loop60:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop62;
				}
				
			}
			_loop62:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case BUTTONBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp86_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp86_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp86_AST);
			match(BUTTONBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop64;
				}
				
			}
			_loop64:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop66;
				}
				
			}
			_loop66:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case GRAYLEVEL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp91_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp91_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp91_AST);
			match(GRAYLEVEL);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop68;
				}
				
			}
			_loop68:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop70;
				}
				
			}
			_loop70:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case RGBCOLOR:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp96_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp96_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp96_AST);
			match(RGBCOLOR);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop72;
				}
				
			}
			_loop72:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop74;
				}
				
			}
			_loop74:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case FILENAME:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp101_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp101_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp101_AST);
			match(FILENAME);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop76;
				}
				
			}
			_loop76:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop78;
				}
				
			}
			_loop78:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case PARENTDIRECTORY:
		{
			match(PARENTDIRECTORY);
			match(LBRACK);
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case GRAPHICSDATA:
		{
			match(GRAPHICSDATA);
			match(LBRACK);
			match(QSTRING);
			match(COMMA);
			match(QSTRING);
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
				}
				else {
					goto _loop80;
				}
				
			}
			_loop80:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = exprheader_AST;
}

void AntlrNotebookParser::value() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST value_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case QSTRING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp116_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp116_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp116_AST);
			match(QSTRING);
			value_AST = currentAST.root;
			break;
		}
		case NUMBER:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp117_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp117_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp117_AST);
			match(NUMBER);
			value_AST = currentAST.root;
			break;
		}
		case TRUE_:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp118_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp118_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp118_AST);
			match(TRUE_);
			value_AST = currentAST.root;
			break;
		}
		case FALSE_:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp119_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp119_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp119_AST);
			match(FALSE_);
			value_AST = currentAST.root;
			break;
		}
		case VALUERIGHT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp120_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp120_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp120_AST);
			match(VALUERIGHT);
			value_AST = currentAST.root;
			break;
		}
		case VALUELEFT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp121_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp121_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp121_AST);
			match(VALUELEFT);
			value_AST = currentAST.root;
			break;
		}
		case TRADITIONALFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp122_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp122_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp122_AST);
			match(TRADITIONALFORM);
			value_AST = currentAST.root;
			break;
		}
		case STANDARDFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp123_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp123_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp123_AST);
			match(STANDARDFORM);
			value_AST = currentAST.root;
			break;
		}
		case INPUTFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp124_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp124_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp124_AST);
			match(INPUTFORM);
			value_AST = currentAST.root;
			break;
		}
		case OUTPUTFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp125_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp125_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp125_AST);
			match(OUTPUTFORM);
			value_AST = currentAST.root;
			break;
		}
		case AUTOMATIC:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp126_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp126_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp126_AST);
			match(AUTOMATIC);
			value_AST = currentAST.root;
			break;
		}
		case NONESYM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp127_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp127_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp127_AST);
			match(NONESYM);
			value_AST = currentAST.root;
			break;
		}
		case NULLSYM:
		{
			match(NULLSYM);
			value_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = value_AST;
}

void AntlrNotebookParser::attribute() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST attribute_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case FONTSLANT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp129_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp129_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp129_AST);
			match(FONTSLANT);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTSIZE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp130_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp130_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp130_AST);
			match(FONTSIZE);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTCOLOR:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp131_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp131_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp131_AST);
			match(FONTCOLOR);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTWEIGHT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp132_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp132_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp132_AST);
			match(FONTWEIGHT);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTFAMILY:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp133_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp133_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp133_AST);
			match(FONTFAMILY);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTVARIATIONS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp134_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp134_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp134_AST);
			match(FONTVARIATIONS);
			attribute_AST = currentAST.root;
			break;
		}
		case TEXTALIGNMENT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp135_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp135_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp135_AST);
			match(TEXTALIGNMENT);
			attribute_AST = currentAST.root;
			break;
		}
		case TEXTJUSTIFICATION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp136_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp136_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp136_AST);
			match(TEXTJUSTIFICATION);
			attribute_AST = currentAST.root;
			break;
		}
		case INITIALIZATIONCELL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp137_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp137_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp137_AST);
			match(INITIALIZATIONCELL);
			attribute_AST = currentAST.root;
			break;
		}
		case BUTTONDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp138_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp138_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp138_AST);
			match(BUTTONDATA);
			attribute_AST = currentAST.root;
			break;
		}
		case BUTTONSTYLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp139_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp139_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp139_AST);
			match(BUTTONSTYLE);
			attribute_AST = currentAST.root;
			break;
		}
		case CHARACHTERENCODING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp140_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp140_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp140_AST);
			match(CHARACHTERENCODING);
			attribute_AST = currentAST.root;
			break;
		}
		case SCREENRECTANGLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp141_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp141_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp141_AST);
			match(SCREENRECTANGLE);
			attribute_AST = currentAST.root;
			break;
		}
		case AUTOGENERATEDPACKAGE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp142_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp142_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp142_AST);
			match(AUTOGENERATEDPACKAGE);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLTAGS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp143_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp143_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp143_AST);
			match(CELLTAGS);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLFRAME:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp144_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp144_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp144_AST);
			match(CELLFRAME);
			attribute_AST = currentAST.root;
			break;
		}
		case EDITABLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp145_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp145_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp145_AST);
			match(EDITABLE);
			attribute_AST = currentAST.root;
			break;
		}
		case BACKGROUNT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp146_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp146_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp146_AST);
			match(BACKGROUNT);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWSIZE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp147_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp147_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp147_AST);
			match(WINDOWSIZE);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp148_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp148_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp148_AST);
			match(WINDOWMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWFRAME:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp149_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp149_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp149_AST);
			match(WINDOWFRAME);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWELEMENTS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp150_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp150_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp150_AST);
			match(WINDOWELEMENTS);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWTITLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp151_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp151_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp151_AST);
			match(WINDOWTITLE);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWTOOLBARS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp152_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp152_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp152_AST);
			match(WINDOWTOOLBARS);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWMOVEABLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp153_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp153_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp153_AST);
			match(WINDOWMOVEABLE);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWFLOATING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp154_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp154_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp154_AST);
			match(WINDOWFLOATING);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWCLICKSELECT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp155_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp155_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp155_AST);
			match(WINDOWCLICKSELECT);
			attribute_AST = currentAST.root;
			break;
		}
		case STYLEDEFINITIONS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp156_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp156_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp156_AST);
			match(STYLEDEFINITIONS);
			attribute_AST = currentAST.root;
			break;
		}
		case FRONTENDVERSION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp157_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp157_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp157_AST);
			match(FRONTENDVERSION);
			attribute_AST = currentAST.root;
			break;
		}
		case MAGNIFICATION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp158_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp158_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp158_AST);
			match(MAGNIFICATION);
			attribute_AST = currentAST.root;
			break;
		}
		case GENERATEDCELL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp159_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp159_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp159_AST);
			match(GENERATEDCELL);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLAUTOOVRT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp160_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp160_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp160_AST);
			match(CELLAUTOOVRT);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGESIZE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp161_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp161_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp161_AST);
			match(IMAGESIZE);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGEMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp162_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp162_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp162_AST);
			match(IMAGEMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGEREGION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp163_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp163_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp163_AST);
			match(IMAGEREGION);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGERANGECACHE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp164_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp164_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp164_AST);
			match(IMAGERANGECACHE);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGECACHE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp165_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp165_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp165_AST);
			match(IMAGECACHE);
			attribute_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = attribute_AST;
}

void AntlrNotebookParser::rule() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST rule_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case RULE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp166_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp166_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp166_AST);
			match(RULE);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			}
			match(RBRACK);
			rule_AST = currentAST.root;
			break;
		}
		case RULEDELAYED:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp170_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp170_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp170_AST);
			match(RULEDELAYED);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			}
			match(RBRACK);
			rule_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_4);
	}
	returnAST = rule_AST;
}

void AntlrNotebookParser::listbody() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST listbody_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		{
		switch ( LA(1)) {
		case MODULENAME:
		case LIST:
		case NOTEBOOK:
		case CELL:
		case TEXTDATA:
		case CELLGROUPDATA:
		case GRAYLEVEL:
		case RGBCOLOR:
		case FILENAME:
		case STYLEBOX:
		case BOXDATA:
		case BUTTONBOX:
		case FORMBOX:
		case ROWBOX:
		case SUPERSCRBOX:
		case SUBSUPERSCRIPTBOX:
		case UNDERSCRIPTBOX:
		case OVERSCRIPTBOX:
		case UNDEROVERSCRIPTBOX:
		case FRACTIONBOX:
		case SQRTBOX:
		case RADICALBOX:
		case FONTSLANT:
		case FONTSIZE:
		case FONTCOLOR:
		case FONTWEIGHT:
		case FONTFAMILY:
		case FONTVARIATIONS:
		case TEXTALIGNMENT:
		case TEXTJUSTIFICATION:
		case INITIALIZATIONCELL:
		case BUTTONDATA:
		case BUTTONSTYLE:
		case CHARACHTERENCODING:
		case SCREENRECTANGLE:
		case AUTOGENERATEDPACKAGE:
		case CELLTAGS:
		case CELLFRAME:
		case EDITABLE:
		case BACKGROUNT:
		case WINDOWSIZE:
		case WINDOWMARGINS:
		case WINDOWFRAME:
		case WINDOWELEMENTS:
		case WINDOWTITLE:
		case WINDOWTOOLBARS:
		case WINDOWMOVEABLE:
		case WINDOWFLOATING:
		case WINDOWCLICKSELECT:
		case STYLEDEFINITIONS:
		case FRONTENDVERSION:
		case VALUERIGHT:
		case VALUELEFT:
		case TRUE_:
		case FALSE_:
		case AUTOMATIC:
		case TRADITIONALFORM:
		case STANDARDFORM:
		case INPUTFORM:
		case OUTPUTFORM:
		case NULLSYM:
		case NONESYM:
		case GRAPHICSDATA:
		case IMAGESIZE:
		case IMAGEMARGINS:
		case IMAGEREGION:
		case IMAGERANGECACHE:
		case IMAGECACHE:
		case CELLAUTOOVRT:
		case MAGNIFICATION:
		case PARENTDIRECTORY:
		case NUMBER:
		case QSTRING:
		case GENERATEDCELL:
		{
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			break;
		}
		case RULE:
		case RULEDELAYED:
		{
			rule();
			astFactory->addASTChild( currentAST, returnAST );
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
		}
		listbody_AST = currentAST.root;
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_4);
	}
	returnAST = listbody_AST;
}

void AntlrNotebookParser::initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory )
{
	factory.setMaxNodeType(97);
}
const char* AntlrNotebookParser::tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"\"FrontEnd\"",
	"\"List\"",
	"\"Notebook\"",
	"\"Cell\"",
	"\"TextData\"",
	"\"CellGroupData\"",
	"\"Rule\"",
	"\"RuleDelayed\"",
	"\"GrayLevel\"",
	"\"RGBColor\"",
	"\"FileName\"",
	"\"StyleBox\"",
	"\"BoxData\"",
	"\"ButtonBox\"",
	"\"FormBox\"",
	"\"RowBox\"",
	"\"GridBox\"",
	"\"SuperscriptBox\"",
	"\"SubscriptBox\"",
	"\"SubsuperscriptBox\"",
	"\"UnderscriptBox\"",
	"\"OverscriptBox\"",
	"\"UnderoverscriptBox\"",
	"\"FractionBox\"",
	"\"SqrtBox\"",
	"\"RadicalBox\"",
	"\"FontSlant\"",
	"\"FontSize\"",
	"\"FontColor\"",
	"\"FontWeight\"",
	"\"FontFamily\"",
	"\"FontVariations\"",
	"\"TextAlignment\"",
	"\"TextJustification\"",
	"\"InitializationCell\"",
	"\"ButtonData\"",
	"\"ButtonStyle\"",
	"\"CharacterEncoding\"",
	"\"ScreenRectangle\"",
	"\"AutoGeneratedPackage\"",
	"\"CellTags\"",
	"\"CellFrame\"",
	"\"Editable\"",
	"\"Background\"",
	"\"WindowSize\"",
	"\"WindowMargins\"",
	"\"WindowFrame\"",
	"\"WindowElements\"",
	"\"WindowTitle\"",
	"\"WindowToolbars\"",
	"\"WindowMoveable\"",
	"\"WindowFloating\"",
	"\"WindowClickSelect\"",
	"\"StyleDefinitions\"",
	"\"FrontEndVersion\"",
	"\"Open\"",
	"\"Closed\"",
	"\"Right\"",
	"\"Left\"",
	"\"True\"",
	"\"False\"",
	"\"Automatic\"",
	"\"TraditionalForm\"",
	"\"StandardForm\"",
	"\"InputForm\"",
	"\"OutputForm\"",
	"\"Null\"",
	"\"None\"",
	"\"GraphicsData\"",
	"\"ImageSize\"",
	"\"ImageMargins\"",
	"\"ImageRegion\"",
	"\"ImageRangeCache\"",
	"\"ImageCache\"",
	"\"GenerateCell\"",
	"\"CellAutoOverwrite\"",
	"\"Magnification\"",
	"\"ParentDirectory\"",
	"RBRACK",
	"LBRACK",
	"RCURLY",
	"LCURLY",
	"COMMA",
	"THICK",
	"COMMENTSTART",
	"COMMENTEND",
	"NUMBER",
	"ID",
	"EXP",
	"DIGIT",
	"QSTRING",
	"WHITESPACE",
	"COMMENT",
	"GENERATEDCELL",
	0
};

const unsigned long AntlrNotebookParser::_tokenSet_0_data_[] = { 2UL, 0UL, 0UL, 0UL };
// EOF 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_0(_tokenSet_0_data_,4);
const unsigned long AntlrNotebookParser::_tokenSet_1_data_[] = { 2UL, 0UL, 4456448UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// EOF RBRACK COMMA 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_1(_tokenSet_1_data_,8);
const unsigned long AntlrNotebookParser::_tokenSet_2_data_[] = { 4289721328UL, 3892314111UL, 1141096447UL, 2UL, 0UL, 0UL, 0UL, 0UL };
// "FrontEnd" "List" "Notebook" "Cell" "TextData" "CellGroupData" "GrayLevel" 
// "RGBColor" "FileName" "StyleBox" "BoxData" "ButtonBox" "FormBox" "RowBox" 
// "SuperscriptBox" "SubsuperscriptBox" "UnderscriptBox" "OverscriptBox" 
// "UnderoverscriptBox" "FractionBox" "SqrtBox" "RadicalBox" "FontSlant" 
// "FontSize" "FontColor" "FontWeight" "FontFamily" "FontVariations" "TextAlignment" 
// "TextJustification" "InitializationCell" "ButtonData" "ButtonStyle" 
// "CharacterEncoding" "ScreenRectangle" "AutoGeneratedPackage" "CellTags" 
// "CellFrame" "Editable" "Background" "WindowSize" "WindowMargins" "WindowFrame" 
// "WindowElements" "WindowTitle" "WindowToolbars" "WindowMoveable" "WindowFloating" 
// "WindowClickSelect" "StyleDefinitions" "FrontEndVersion" "Right" "Left" 
// "True" "False" "Automatic" "TraditionalForm" "StandardForm" "InputForm" 
// "OutputForm" "Null" "None" "GraphicsData" "ImageSize" "ImageMargins" 
// "ImageRegion" "ImageRangeCache" "ImageCache" "CellAutoOverwrite" "Magnification" 
// "ParentDirectory" NUMBER QSTRING GENERATEDCELL 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_2(_tokenSet_2_data_,8);
const unsigned long AntlrNotebookParser::_tokenSet_3_data_[] = { 3074UL, 0UL, 4456448UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// EOF "Rule" "RuleDelayed" RBRACK COMMA 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_3(_tokenSet_3_data_,8);
const unsigned long AntlrNotebookParser::_tokenSet_4_data_[] = { 0UL, 0UL, 4456448UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// RBRACK COMMA 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_4(_tokenSet_4_data_,8);


