package Modelica "Modelica Standard Library"
  extends Icons.Library;
  annotation(preferedView="info",version="2.2",versionDate="2005-04-15",conversion(from(version="1.6",ModelicaAdditions(version="1.5"),MultiBody(version="1.0.1"),MultiBody(version="1.0"),Matrices(version="0.8"),script="Scripts/ConvertModelica_from_1.6_to_2.1.mos"),from(version="2.1 Beta1",script="Scripts/ConvertModelica_from_2.1Beta1_to_2.1.mos"),noneFromVersion="2.1"),Settings(NewStateSelection=true),Documentation(info="<HTML>
 <p>
 Package <b>Modelica</b> is a <b>standardized</b> and <b>pre-defined</b> package
 that is developed together with the Modelica language from the
 Modelica Association, see
 <a href=\"http://www.Modelica.org\">http://www.Modelica.org</a>.
 It is also called <b>Modelica Standard Library</b>.
 It provides constants, types, connectors, partial models and model
 components
 in various disciplines.
 </p>
 <p>
 For an introduction, have especially a look at:
 </p>
 <ul>
 <li> <a href=\"Modelica://Modelica.UsersGuide\">Users Guide</a>
      discusses the most important aspects of this library.</li>
 <li><a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes\">Release Notes</a>
     summarizes the changes of new versions of this package.</li>
 <li> Packages <b>Examples</b> in the various subpackages, provide
      demos of the corresponding subpackage.</li>
 </ul>
 <p>
 The Modelica package consists currently of the following subpackages
 </p>
 
 <table border=1 cellspacing=0 cellpadding=2>
   <tr><td><a href=\"Modelica://Modelica.Blocks\">Blocks</a></td>
       <td>Continuous, discrete and logical input/output blocks</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Constants\">Constants</a></td>
       <td>Mathematical and physical constants (pi, eps, h, ...)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Electrical\">Electrical</a></td>
       <td> Electric and electronic components<br>
            (<a href=\"Modelica://Modelica.Electrical.Analog\">Analog</a>,
             <a href=\"Modelica://Modelica.Electrical.Digital\">Digital</a>,
             <a href=\"Modelica://Modelica.Electrical.Machines\">Machines</a>,
             <a href=\"Modelica://Modelica.Electrical.MultiPhase\">MultiPhase</a>)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Icons\">Icons</a></td>
       <td>Icon definitions</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Math\">Math</a></td>
       <td>Mathematical functions for scalars and 
           <a href=\"Modelica://Modelica.Math.Matrices\">Matrices</a><br>
          (such as sin, cos, solve, eigenValues, singular values)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Mechanics\">Mechanics</a></td>
       <td>Mechanical components<br>
           (<a href=\"Modelica://Modelica.Mechanics.Rotational\">1D-rotational</a>,
            <a href=\"Modelica://Modelica.Mechanics.Translational\">1D-translational</a>,
            <a href=\"Modelica://Modelica.Mechanics.MultiBody\">3D multi-body</a>)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Media\">Media</a></td>
       <td>Media models for liquids and gases<br>
           (about 1250 media, including high precision water model)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.SIunits\">SIunits</a></td>
       <td>SI-unit type definitions (such as Voltage, Torque)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.StateGraph\">StateGraph</a></td>
       <td>Hierarchical state machines (similiar power as Statecharts)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Thermal\">Thermal</a></td>
       <td>Thermal components<br>
           (<a href=\"Modelica://Modelica.Thermal.HeatTransfer\">1-D lumped heat transfer</a>,
           <a href=\"Modelica://Modelica.Thermal.FluidHeatFlow\">1-D incompressible thermo-fluid flow</a>)</td>
   </tr>
 
   <tr><td><a href=\"Modelica://Modelica.Utilities\">Utilities</a></td>
       <td>Utility functions especially for scripting<br> 
           (<a href=\"Modelica://Modelica.Utilities.Files\">Files</a>,
           <a href=\"Modelica://Modelica.Utilities.Streams\">Streams</a>,
           <a href=\"Modelica://Modelica.Utilities.Strings\">Strings</a>,
           <a href=\"Modelica://Modelica.Utilities.System\">System</a>)</td>
   </tr>
 </table>
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 </HTML>
 "));
  package UsersGuide "Users Guide"
      annotation(DocumentationClass=true,Documentation(info="<html>
 <h3><font color=\"#008000\" size=5>Users Guide of the Modelica Standard Library</font></h3>
 <p>
 Package <b>Modelica</b> is a <b>standardized</b> and <b>pre-defined</b> package
 that is developed together with the Modelica language from the
 Modelica Association, see
 <a href=\"http://www.Modelica.org\">http://www.Modelica.org</a>.
 It is also called <b>Modelica Standard Library</b>.
 It provides constants, types, connectors, partial models and model
 components in various disciplines.
 </p>
 <p>
 This package contains the <b>users guide</b> for 
 the library and has the following content
 (this users guide will be improved in the future):
 </p>
 <ol>
 <li><a href=\"Modelica://Modelica.UsersGuide.OverView\">Overview of library</a>
      gives an overview of the library.</li>
 <li><a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes\">Release Notes</a>
     summarizes the differences between different versions of this library.</li>
 <li><a href=\"Modelica://Modelica.UsersGuide.Contact\">Contact</a> 
     provides information about the authors of the library as well as
     acknowledgments.</li>
 <li><a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">ModelicaLicense</a> 
     defines the license conditions for using this library.</li>
 </ol>
 </html>"));
    class OverView "Overview of library"
          annotation(Documentation(info="<html>
 <h3><font color=\"#008000\" size=5>Overview of Library Modelica</font></h3>
 <p>
 An overview of the Modelica Standard Library
 will be given here.
 </p>
 <p>
 <br><br><br>
 </p>
 <p>
 In the Modelica package the following conventions are used:
 </p>
 <ul>
 <li>
 Class and instance names are written in upper and lower case
 letters, e.g., \"ElectricCurrent\". An underscore is only used
 at the end of a name to characterize a lower or upper index,
 e.g., body_low_up.<br><br>
 </li>
 <li>
 Type names start always with an upper case letter.
 Instance names start always with a lower case letter with only
 a few exceptions, such as \"T\" for a temperature instance,
 if this is common sense.<br><br>
 </li>
 <li>
 A package XXX has its interface definitions in subpackage
 XXX.Interfaces, e.g., Electrical.Interfaces. <br><br>
 </li>
 <li>
 Preferred instance names for connectors:
 <pre>
   p,n: positive and negative side of a partial model.
   a,b: side \"a\" and side \"b\" of a partial model
        (= connectors are completely equivalent).
 </pre>
 </li>
 </ul>
 </html>
 "));
    end OverView;
    class ReleaseNotes "Release notes"
          annotation(Documentation(info="<html>
 <h3><font color=\"#008000\" size=5>Release notes</font></h3>
 
 <p>
 This section summarizes the changes that have been performed
 on the Modelica standard library.
 </p>
 
 <ul>
 <li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_2_2\">Version 2.2</a> (April 6, 2005)</li>
 <li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_2_1\">Version 2.1</a> (Nov. 11, 2004)</li>
 <li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_1_6\">Version 1.6</a> (June 21, 2004)</li>
 <li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_1_5\">Version 1.5</a> (Dec. 16, 2002)</li>
 <li> <a href=\"Modelica://Modelica.UsersGuide.ReleaseNotes.Version_1_4\">Version 1.4</a> (June 28, 2001
      and previous versions)</li>
 </ul>
 
 </html>
 "));
      class Version_2_2 "Version 2.2"
              annotation(Documentation(info="<html>
 <h3><font color=\"#008000\">Version 2.2 (April 6, 2005)</font></h3>
 
 <p>
 Version 2.2 is backward compatible to version 2.1.
 </p>
 
 The following <b>new libraries</b> have been added:
 </p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td><a href=\"Modelica://Modelica.Media\">Modelica.Media</a></td>
       <td> Property models of liquids and gases, especially
            <ul>
            <li>1241 detailed gas models,</li>
            <li> moist air,</li>
            <li> high precision water model (according to IAPWS/IF97 standard), </li>
            <li> incompressible media defined by tables (cp(T), rho(t), eta(T), etc. are defined by tables).</li>
            </ul>
            The user can conveniently define mixtures of gases between the 
            1241 gas models. The models are
            designed to work well in dynamic simulations. They
            are based on a new standard interface for media with
            single and multiple substances and one or multiple phases
            with the following features:
            <ul>
            <li> The independent variables of a medium model do not influence the 
                 definition of a fluid connector port or how the
                 balance equations have to be implemented.<br>
                 Used independent variables: \"p,T\", \"p,T,X\", \"p,h\", \"d,T\".</li>
            <li> Optional variables, e.g., dynamic viscosity, are only computed 
                 if needed.<li>
            <li> The medium models are implemented with regards to efficient 
                 dynamic simulation.</li>
            </ul>
       </td><tr>
   <tr><td><a href=\"Modelica://Modelica.Thermal.FluidHeatFlow\">Modelica.Thermal.FluidHeatFlow</a></td>
       <td> Simple components for 1-dim., incompressible thermo-fluid flow 
            to model coolant flows, e.g., of electrical machines.
            Components can be connected arbitrarily together (= ideal mixing
            at connection points) and fluid may reverse direction of flow. 
   </td><tr>
 </table>
 
 <p>
 The following <b>changes</b> have been performed in the
 <b>Modelica.Mechanics.MultiBody</b> library:
 </p>
 
 <ul>
 <li> Component MultiBody.World has a new parameter
      <b>driveTrainMechanics3D</b>. If set to <b>true</b>, 3D mechanical effects
      of MultiBody.Parts.Mounting1D/Rotor1D/BevelGear1D are taken into account. If set to 
      <b>false</b> (= default), 3D mechanical effects in these elements
      are not taken into account and the
      frame connectors to connect to 3D parts are disabled (all
      connections to such a disabled connector are also disabled, due to the
      new feature of conditional declarations in Modelica language 2.2)</li>
 <li> All references to \"MultiBody.xxx\" have
      been changed to \"Modelica.Mechanics.MultiBodys.xxx\" in order that after
      copying of a component outside of the Modelica library, the references
      still remain valid.</li>
 </ul>
 </html>
 "));
      end Version_2_2;
      class Version_2_1 "Version 2.1"
              annotation(Documentation(info="<html>
 
 <h3><font color=\"#008000\">Version 2.1 (November 11, 2004)</font></h3>
 <p> This is a major change with respect to previous versions of the
     Modelica Standard Library, because <b>many new libraries</b> and components
     are included and because the input/output blocks (Modelica.Blocks)
     have been considerably simplified:
 </p>
 <ul>
 <li> An input/output connector is defined <b>without</b> a hierarchy (this is possible
      due to new features of the Modelica language). For example, the input
      signal of a block \"FirstOrder\" was previously accessed as \"FirstOrder.inPort.signal[1]\".
      Now it is accessed as \"FirstOrder.u\". This simplifies the understanding and usage 
      especially for beginners.</li>
 <li> De-vectorized the <b>Modelica.Blocks</b> library. All blocks in the
      Modelica.Blocks library are now scalar blocks. As a result,
      the parameters of the Blocks are scalars and no vectors any
      more. For example, a parameter \"amplitude\" that might had
      a value of \"{1}\" previously, has now a value of \"1\". This simplifies
      the understanding and usage especially for beginners.<br>
      If a vector of blocks is needed, this can be easily
      accomplished by adding a dimension to the instance. For example
      \"Constant const[3](k={1,2,3}\" defines three Constant blocks. 
      An additional advantage of the new approach is that
      the implementation of Modelica.Blocks is much simpler and is easier to
      understand.
 </li>
 </ul>
      
 <p>
 The discussed changes of Modelica.Blocks are not backward compatible.
 A script to <b>automatically</b> convert models to this new version is
 provided. There might be rare cases, where this script does not convert. 
 In this case models have to be manually converted.
 In any case you should make a back-up copy of your model
 before automatic conversion is performed. 
 </p>
 <p>
 The following <b>new libraries</b> have been added:
 </p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td><a href=\"Modelica://Modelica.Electrical.Digital\">Modelica.Electrical.Digital</a></td>
       <td>Digital electrical components based on 2-,3-,4-, and 9-valued logic<br>
           according to the VHDL standard</td><tr>
   <tr><td><a href=\"Modelica://Modelica.Electrical.Machines\">Modelica.Electrical.Machines</a></td>
       <td>Asynchronous, synchronous and DC motor and generator models</td><tr>
   <tr><td><a href=\"Modelica://Modelica.Math.Matrices\">Modelica.Math.Matrices</a></td>
       <td>Functions operatinng on matrices such as solve() (A*x=b), leastSquares(),<br>
           norm(), LU(), QR(),  eigenValues(), singularValues(), exp(), ...</td><tr>
   <tr><td><a href=\"Modelica://Modelica.StateGraph\">Modelica.StateGraph</a></td>
       <td> Modeling of <b>discrete event</b> and <b>reactive</b> systems in a convenient way using<br>
            <b>hierarchical state machines</b> and <b>Modelica</b> as <b>action language</b>. <br>
            It is based on JGraphChart and Grafcet and  has a similar modeling power as <br>
            StateCharts. It avoids deficiences of usually used action languages. <br>
            This library makes the ModelicaAdditions.PetriNets library obsolet.</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Utilities.Files\">Modelica.Utilities.Files</a></td>
       <td>Functions to operate on files and directories (copy, move, remove files etc.)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Utilities.Streams\">Modelica.Utilities.Streams</a></td>
       <td>Read from files and write to files (print, readLine, readFile, error, ...)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Utilities.Strings\">Modelica.Utilities.Strings</a></td>
       <td>Operations on strings (substring, find, replace, sort, scanToken, ...)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Utilities.System\">Modelica.Utilities.System</a></td>
       <td>Get/set current directory, get/set environment variable, execute shell command, etc.</td></tr>
 </table>
 <p>
 The following existing libraries outside of the Modelica standard library
 have been improved and added as <b>new libraries</b>
 (models using the previous libraries are automatically converted
 to the new sublibraries inside package Modelica):
 </p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td><a href=\"Modelica://Modelica.Blocks.Discrete\">Modelica.Blocks.Discrete</a></td>
       <td> Discrete input/output blocks with fixed sample period<br>
            (from ModelicaAdditions.Blocks.Discrete)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Blocks.Logical\">Modelica.Blocks.Logical</a></td>
       <td> Logical components with Boolean input and output signals<br>
            (from ModelicaAdditions.Blocks.Logical)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Blocks.Nonlinear\">Modelica.Blocks.Nonlinear</a></td>
       <td> Discontinuous or non-differentiable algebraic control blocks such as variable limiter,<br>
            fixed, variable and Pade delay etc. (from ModelicaAdditions.Blocks.Nonlinear)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Blocks.Routing\">Modelica.Blocks.Routing</a></td>
       <td> Blocks to combine and extract signals, such as multiplexer<br>
            (from ModelicaAdditions.Blocks.Multiplexer)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Blocks.Tables\">Modelica.Blocks.Tables</a></td>
       <td> One and two-dimensional interpolation in tables. CombiTimeTable is available<br>
            in Modelica.Blocks.Sources (from ModelicaAdditions.Tables)</td></tr>
   <tr><td><a href=\"Modelica://Modelica.Mechanics.MultiBody\">Modelica.Mechanics.MultiBody</a></td>
       <td> Components to model the movement of 3-dimensional mechanical systems. Contains <br>
            body, joint, force and sensor components, analytic handling of kinematic loops,<br>
            force elements with mass, series/parallel connection of 3D force elements etc.<br>
            (from MultiBody 1.0 where the new signal connectors are used;<br>
            makes the ModelicaAdditions.MultiBody library obsolet)</td></tr>
 </table>
 <p>
 As a result, the ModelicaAdditions library is obsolet, because all components
 are either included in the Modelica library or are replaced by much more
 powerful libraries (MultiBody, StateGraph).
 </p>
 <p>
 The following <b>new components</b> have been added to <b>existing</b> libraries.
 </p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td colspan=\"2\"><b>Modelica.Blocks.Logical.</b></td></tr>
   <tr><td>Pre</td>
       <td>y = pre(u): Breaks algebraic loops by an infinitesimal small <br>
           time delay (event iteration continues until u = pre(u))</td></tr>
   <tr><td>Edge</td>
       <td>y = edge(u): Output y is true, if the input u has a rising edge </td></tr>
   <tr><td>FallingEdge</td>
       <td>y = edge(not u): Output y is true, if the input u has a falling edge </td></tr>
   <tr><td>Change</td>
       <td>y = change(u): Output y is true, if the input u has a rising or falling edge </td></tr>
   <tr><td>GreaterEqual</td>
       <td>Output y is true, if input u1 is greater or equal as input u2 </td></tr>
   <tr><td>Less</td>
       <td>Output y is true, if input u1 is less as input u2 </td></tr>
   <tr><td>LessEqual</td>
       <td>Output y is true, if input u1 is less or equal as input u2 </td></tr>
   <tr><td>Timer</td>
       <td>Timer measuring the time from the time instant where the <br>
           Boolean input became true </td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
   <tr><td>BooleanToReal</td>
       <td>Convert Boolean to Real signal</td></tr>
   <tr><td>BooleanToInteger</td>
       <td>Convert Boolean to Integer signal</td></tr>
   <tr><td>RealToBoolean</td>
       <td>Convert Real to Boolean signal</td></tr>
   <tr><td>IntegerToBoolean</td>
       <td>Convert Integer to Boolean signal</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
   <tr><td>RealExpression</td>
       <td>Set output signal to a time varying Real expression</td></tr>
   <tr><td>IntegerExpression</td>
       <td>Set output signal to a time varying Integer expression</td></tr>
   <tr><td>BooleanExpression</td>
       <td>Set output signal to a time varying Boolean expression</td></tr>
   <tr><td>BooleanTable</td>
       <td>Generate a Boolean output signal based on a vector of time instants</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.</b></td></tr>
   <tr><td>Frames.from_T2</td>
       <td>Return orientation object R from transformation matrix T and its derivative der(T)</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
   <tr><td>LinearSpeedDependentTorque</td>
       <td>Linear dependency of torque versus speed (acts as load torque)</td></tr>
   <tr><td>QuadraticSpeedDependentTorque</td>
       <td>Quadratic dependency of torque versus speed (acts as load torque)</td></tr>
   <tr><td>ConstantTorque</td>
       <td>Constant torque, not dependent on speed (acts as load torque)</td></tr>
   <tr><td>ConstantSpeed</td>
       <td>Constant speed, not dependent on torque (acts as load torque)</td></tr>
   <tr><td>TorqueStep</td>
       <td>Constant torque, not dependent on speed (acts as load torque)</td></tr>
 </table>
 <p>
 The following <b>bugs</b> have been <b>corrected</b>:
 </p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td colspan=\"2\"><b>Modelica.Mechanics.MultiBody.Forces.</b></td></tr>
   <tr><td>LineForceWithMass<br>
           Spring</td>
       <td>If mass of the line force or spring component is not zero, the<br>
           mass was (implicitly) treated as \"mass*mass\" instead of as \"mass\"</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
   <tr><td>Speed</td>
       <td>If parameter exact=<b>false</b>, the filter was wrong<br>
           (position was filtered and not the speed input signal)</td></tr>
 </table> 
 <p>
 Other changes:
 </p>
 <ul>
 <li> All connectors are now smaller in the diagram layer. This gives
      a nicer layout when connectors and components are used together
      in a diagram</li>
 <li> Default instance names are defined for all connectors, according
      to a new annotation introduced in Modelica 2.1. For example,
      when dragging connector \"Flange_a\" from the Rotational library to
      the diagram layer, the default connector instance name is
      \"flange_a\" and not \"Flange_a1\".</li>
 <li> The Modelica.Mechanics.Rotational connectors are changed from
      a square to a circle</li>
 <li> The Modelica.Mechanics.Translational connectors are changed from a
      green to a dark green color in order that connection lines
      can be better seen, especially when printed.</li>
 <li> The Modelica.Blocks connectors for Real signals are changed from
      blue to dark blue in order to distinguish them from electrical signals.</li>
 </ul>
 </html>
 "));
      end Version_2_1;
      class Version_1_6 "Version 1.6"
              annotation(Documentation(info="<html>
 <h3><font color=\"#008000\">Version 1.6 (June 21, 2004)</font></h3>
 <p> Added 1 new library (Electrical.MultiPhase), 17 new components, 
     improved 3 existing components
     in the Modelica.Electrical library and improved 3 types
     in the Modelica.SIunits library. Furthermore,
     this Users Guide has been started. The improvements
     in more detail:
 </p>
 <p>
 <b>New components</b>
 </p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic.</b></td></tr>
   <tr><td>SaturatingInductor</td>
       <td>Simple model of an inductor with saturation</td></tr>
   <tr><td>VariableResistor</td>
       <td>Ideal linear electrical resistor with variable resistance</td></tr>
   <tr><td>VariableConductor</td>
       <td>Ideal linear electrical conductor with variable conductance</td></tr>
   <tr><td>VariableCapacitor</td>
       <td>Ideal linear electrical capacitor with variable capacitance</td></tr>
   <tr><td>VariableInductor</td>
       <td>Ideal linear electrical inductor with variable inductance</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Semiconductors.</b></td></tr>
   <tr><td>HeadingDiode</td>
       <td>Simple diode with heating port</td></tr>
   <tr><td>HeadingNMOS</td>
       <td>Simple MOS Transistor with heating port</td></tr>
   <tr><td>HeadingPMOS</td>
       <td>Simple PMOS Transistor with heating port</td></tr>
   <tr><td>HeadingNPN</td>
       <td>Simple NPN BJT according to Ebers-Moll with heating port</td></tr>
   <tr><td>HeadingPNP</td>
       <td>Simple PNP BJT according to Ebers-Moll with heating port</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Electrical.MultiPhase</b><br>
       A new library for multi-phase electrical circuits</td></tr>
 </table>
 <p>
 <b>New examples</b>
 </p>
 <p>
 The following new examples have been added to 
 Modelica.Electrical.Analog.Examples:
 </p>
 <p>
 CharacteristicThyristors, 
 CharacteristicIdealDiodes,
 HeatingNPN_OrGate,
 HeatingMOSInverter,
 HeatingRectifier,
 Rectifier,
 ShowSaturatingInductor
 ShowVariableResistor
 </p>
 <p>
 <b>Improved existing components</b>
 </p>
 <p>In the library Modelica.Electrical.Analog.Ideal,
    a knee voltage has been introduced for the components
    IdealThyristor, IdealGTOThyristor, IdealDiode in order
    that the approximation of these ideal elements is improved
    with not much computational effort.</p>
 <p> In the Modelica.SIunits library, the following changes
     have been made:</p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td>Inductance</td>
       <td>min=0 removed</td></tr>
   <tr><td>SelfInductance</td>
       <td>min=0 added</td></tr>
   <tr><td>ThermodynamicTemperature</td>
       <td>min=0 added</td></tr>
 </table>
 </html>
 "));
      end Version_1_6;
      class Version_1_5 "Version 1.5"
              annotation(Documentation(info="<html>
 <h3><font color=\"#008000\">Version 1.5 (December 16, 2002)</font></h3>
 <p> Added 55 new components. In particular, added new package
     <b>Thermal.HeatTransfer</b> for modeling of lumped
     heat transfer, added model <b>LossyGear</b> in Mechanics.Rotational
     to model gear efficiency and bearing friction according to a new
     theory in a robust way, added 10 new models in Electrical.Analog and 
     added several other new models and improved existing models. 
 </p>
 <p>
 <b>New components</b>
 </p>
 <table border=\"1\" cellspacing=0 cellpadding=2>
   <tr><td colspan=\"2\"><b>Modelica.Blocks.</b></td></tr>
   <tr><td>Continuous.Der</td><td>Derivative of input (= analytic differentations)</td></tr>
   <tr><td><b><i>Examples</i></b></td><td>Demonstration examples of the components of this package</td></tr>
   <tr><td>Nonlinear.VariableLimiter</td><td>Limit the range of a signal with variable limits</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Blocks.Interfaces.</b></td></tr>
   <tr><td>RealPort</td><td>Real port (both input/output possible)</td></tr>
   <tr><td>IntegerPort</td><td>Integer port (both input/output possible)</td></tr>
   <tr><td>BooleanPort</td><td>Boolean port (both input/output possible)</td></tr>
   <tr><td>SIMO</td><td>Single Input Multiple Output continuous control block</td></tr>
   <tr><td>IntegerBlockIcon</td><td>Basic graphical layout of Integer block</td></tr>
   <tr><td>IntegerMO</td><td>Multiple Integer Output continuous control block</td></tr>
   <tr><td>IntegerSignalSource</td><td>Base class for continuous Integer signal source</td></tr>
   <tr><td>IntegerMIBooleanMOs</td><td>Multiple Integer Input Multiple Boolean Output continuous control block with same number of inputs and outputs</td></tr>
   <tr><td>BooleanMIMOs</td><td>Multiple Input Multiple Output continuous control block with same number of inputs and outputs of boolean type</td></tr>
   <tr><td><b><i>BusAdaptors</i></b></td><td>Components to send signals to the bus or receive signals from the bus</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Blocks.Math.</b></td></tr>
   <tr><td>RealToInteger</td><td>Convert real to integer signals</td></tr>
   <tr><td>IntegerToReal</td><td>Convert integer to real signals</td></tr>
   <tr><td>Max</td><td>Pass through the largest signal</td></tr>
   <tr><td>Min</td><td>Pass through the smallest signal</td></tr>
   <tr><td>Edge</td><td>Indicates rising edge of boolean signal</td></tr>
   <tr><td>BooleanChange</td><td>Indicates boolean signal changing</td></tr>
   <tr><td>IntegerChange</td><td>Indicates integer signal changing</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Blocks.Sources.</b></td></tr>
   <tr><td>IntegerConstant</td><td>Generate constant signals of type Integer</td></tr>
   <tr><td>IntegerStep</td><td>Generate step signals of type Integer</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Basic.</b></td></tr>
   <tr><td>HeatingResistor</td><td>Temperature dependent electrical resistor</td></tr>
   <tr><td>OpAmp</td><td>Simple nonideal model of an OpAmp with limitation</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Ideal.</b></td></tr>
   <tr><td>IdealCommutingSwitch</td><td>Ideal commuting switch</td></tr>
   <tr><td>IdealIntermediateSwitch</td><td>Ideal intermediate switch</td></tr>
   <tr><td>ControlledIdealCommutingSwitch</td><td>Controlled ideal commuting switch</td></tr>
   <tr><td>ControlledIdealIntermediateSwitch</td><td>Controlled ideal intermediate switch</td></tr>
   <tr><td>IdealOpAmpLimited</td><td>Ideal operational amplifier with limitation</td></tr>
   <tr><td>IdealOpeningSwitch</td><td>Ideal opener</td></tr>
   <tr><td>IdealClosingSwitch</td><td>Ideal closer</td></tr>
   <tr><td>ControlledIdealOpeningSwitch</td><td>Controlled ideal opener</td></tr>
   <tr><td>ControlledIdealClosingSwitch</td><td>Controlled ideal closer</td></tr>
   
   <tr><td colspan=\"2\"><b>Modelica.Electrical.Analog.Lines.</b></td></tr>
   <tr><td>TLine1</td><td>Lossless transmission line (Z0, TD)</td></tr>
   <tr><td>TLine2</td><td>Lossless transmission line (Z0, F, NL)</td></tr>
   <tr><td>TLine2</td><td>Lossless transmission line (Z0, F)</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Icons.</b></td></tr>
   <tr><td>Function</td><td>Icon for a function</td></tr>
   <tr><td>Record</td><td>Icon for a record</td></tr>
   <tr><td>Enumeration</td><td>Icon for an enumeration</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Math.</b></td></tr>
   <tr><td>tempInterpol2</td><td>temporary routine for vectorized linear interpolation (will be removed)</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.Mechanics.Rotational.</b></td></tr>
   <tr><td>Examples.LossyGearDemo1</td><td>Example to show that gear efficiency may lead to stuck motion</td></tr>
   <tr><td>Examples.LossyGearDemo2</td><td>Example to show combination of LossyGear and BearingFriction</td></tr>
   <tr><td>LossyGear</td><td>Gear with mesh efficiency and bearing friction (stuck/rolling possible)</td></tr>
   <tr><td>Gear2</td><td>Realistic model of a gearbox (based on LossyGear)</td></tr>
   <tr><td colspan=\"2\"><b>Modelica.SIunits.</b></td></tr>
   <tr><td><b><i>Conversions</i></b></td><td>Conversion functions to/from non SI units and type definitions of non SI units</td></tr>
   <tr><td>EnergyFlowRate</td><td>Same definition as <i>Power</i></td></tr>
   <tr><td>EnthalpyFlowRate</td><td><tt>Real (final quantity=\"EnthalpyFlowRate\", final unit=\"W\")</tt></td></tr>
   <tr><td colspan=\"2\"><b>Modelica.</b></td></tr>
   <tr><td><b><i>Thermal.HeatTransfer</i></b></td><td>1-dimensional heat transfer with lumped elements</td></tr>
   <tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Discrete.</b></td></tr>
   <tr><td>TriggeredSampler</td><td>Triggered sampling of continuous signals</td></tr>
   <tr><td>TriggeredMax</td><td>Compute maximum, absolute value of continuous signal at trigger instants</td></tr>
   <tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Logical.Interfaces.</b></td></tr>
   <tr><td>BooleanMIRealMOs</td><td>Multiple Boolean Input Multiple Real Output continuous control block with same number of inputs and outputs</td></tr>
   <tr><td>RealMIBooleanMOs</td><td>Multiple Real Input Multiple Boolean Output continuous control block with same number of inputs and outputs</td></tr>
   <tr><td colspan=\"2\"><b>ModelicaAdditions.Blocks.Logical.</b></td></tr>
   <tr><td>TriggeredTrapezoid</td><td>Triggered trapezoid generator</td></tr>
   <tr><td>Hysteresis</td><td>Transform Real to Boolean with Hysteresis</td></tr>
   <tr><td>OnOffController</td><td>On-off controller</td></tr>
   <tr><td>Compare</td><td>True, if signal of inPort1 is larger than signal of inPort2</td></tr>
   <tr><td>ZeroCrossing</td><td>Trigger zero crossing of input signal</td></tr>
   <tr><td colspan=\"2\"><b>ModelicaAdditions.</b></td></tr>
   <tr><td>Blocks.Multiplexer.Extractor</td><td>Extract scalar signal out of signal vector dependent on IntegerRealInput index</td></tr>
   <tr><td>Tables.CombiTable1Ds</td><td>Table look-up in one dimension (matrix/file) with only single input</td></tr>
 </table>
 <p>
 <b>Package-specific Changes</b>
 </p>
 <ul>
   <li>All example models made <b>encapsulated</b></li>
   <li>Upper case constants changed to lower case (cf. Modelica.Constants)</li>
   <li>Introduced Modelica.SIunits.Wavelength due to typo \"Wavelenght\"</li>
   <li>Introduced ModelicaAdditions.Blocks.Logical.Interfaces.Comparison due to typo \"Comparision\"</li>
   <li>Changed these components of *.Blocks to <tt>block</tt> class, which have not been already of block type</li>
   <li>Changed *.Interfaces.RelativeSensor to <tt>partial</tt> models</li>
 </ul>
 <p>
 <b>Class-specific Changes</b>
 </p>
 <p>
 <i>Modelica.SIunits</i>
 </p>
 <p>Removed <tt>final</tt> from quantity attribute for <i>Mass</i> and <i>MassFlowRate</i>.</p>
 <p>
 <i>Modelica.Blocks.Math.Sum</i>
 </p>
 <p>Implemented avoiding algorithm section, which would lead to expensive function calls.</p>
 <p><i>Modelica.Blocks.Sources.Step</i></p>
 <pre>
   block Step \"Generate step signals of type Real\"
     parameter Real height[:]={1} \"Heights of steps\";
 <b> // parameter Real offset[:]={0} \"Offsets of output signals\";
  // parameter SIunits.Time startTime[:]={0} \"Output = offset for time < startTime\";
  // extends Interfaces.MO          (final nout=max([size(height, 1); size(offset, 1); size(startTime, 1)]));
     extends Interfaces.SignalSource(final nout=max([size(height, 1); size(offset, 1); size(startTime, 1)]));</b>
 </pre>
 <p><i>Modelica.Blocks.Sources.Exponentials</i></p>
 <p>Replaced usage of built-in function <tt>exp</tt> by Modelica.Math.exp.</p>
 <p><i>Modelica.Blocks.Sources.TimeTable</i></p>
 <p>Interface definition changed from</p>
 <pre>    parameter Real table[:, :]=[0, 0; 1, 1; 2, 4] \"Table matrix (time = first column)\";
 </pre>
 <p>to</p>
 <pre>    parameter Real table[:, <b>2</b>]=[0, 0; 1, 1; 2, 4] \"Table matrix (time = first column)\";
 </pre>
 <p>Did the same for subfunction <i>getInterpolationCoefficients</i>.</p>
 <p>Bug in <i>getInterpolationCoefficients</i> for startTime <> 0 fixed:</p>
 <pre>        ...
         end if;
       end if;
       <b>// Take into account startTime \"a*(time - startTime) + b\"
       b := b - a*startTime;</b>
     end getInterpolationCoefficients;
 </pre>
 <p><i>Modelica.Blocks.Sources.BooleanStep</i></p>
 <pre>
   block BooleanStep \"Generate step signals of type Boolean\"
     parameter SIunits.Time startTime[:]={0} \"Time instants of steps\";
     <b>parameter Boolean startValue[size(startTime, 1)]=fill(false, size(startTime, 1)) \"Output before startTime\";</b>
     extends Interfaces.BooleanSignalSource(final nout=size(startTime, 1));
   equation
     for i in 1:nout loop
  <b>//   outPort.signal[i] = time >= startTime[i];
       outPort.signal[i] = if time >= startTime[i] then not startValue[i] else startValue[i];</b>
     end for;
   end BooleanStep;
 </pre>
 <p>
 <i>Modelica.Electrical.Analog</i></p>
 <p>Corrected table of values and default for Beta by dividing them by 1000
 (consistent with the values used in the NAND-example model):
 </p>
 <ul>
 <li>Semiconductors.PMOS</li>
 <li>Semiconductors.NMOS</li>
 </ul>
 <p>Corrected parameter defaults, unit and description for TrapezoidCurrent.
 This makes the parameters consistent with their use in the model.
 Models specifying parameter values are not changed.
 Models not specifying parameter values did not generate trapezoids previously.
 </p>
 <p>Icon layer background changed from transparent to white:</p>
 <ul>
   <li>Basic.Gyrator</li>
   <li>Basic.EMF</li>
   <li>Ideal.Idle</li>
   <li>Ideal.Short</li>
 </ul>
 <p>Basic.Transformer: Replaced invalid escape characters '\\ ' and '\\[newline]' in documentation by '|'.</p>
 <p><i>Modelica.Mechanics.Rotational</i></p>
 <p>Removed arrows and names documentation from flanges in diagram layer</p>
 <p><i>Modelica.Mechanics.Rotational.Interfaces.FrictionBase</i></p>
 <p><i>Modelica.Mechanics.Rotational.Position</i></p>
 <p>Replaced <tt>reinit</tt> by <tt>initial equation</tt></p>
 <p><i>Modelica.Mechanics.Rotational.RelativeStates/i></p>
 <p>Bug corrected by using modifier <tt>stateSelect = StateSelect.prefer</tt> as implementation</p>
 <p><i>Modelica.Mechanics.Translational.Interfaces.flange_b</i></p>
 <p>Attribute <b>fillColor=7</b> added to Rectangle on Icon layer, i.e. it is now
 filled with white and not transparent any more.</p>
 <p><i>Modelica.Mechanics.Translational.Position</i></p>
 <p>Replaced <tt>reinit</tt> by <tt>initial equation</tt></p>
 <p><i>Modelica.Mechanics.Translational.RelativeStates</i></p>
 <p>Bug corrected by using modifier <tt>stateSelect = StateSelect.prefer</tt> as implementation</p>
 <p><i>Modelica.Mechanics.Translational.Stop</i></p>
 <p>Use <tt>stateSelect = StateSelect.prefer</tt>.</p>
 <p><i>Modelica.Mechanics.Translational.Examples.PreLoad</i></p>
 <p>Improved documentation and coordinate system used for example.</p>
 <p><i>ModelicaAdditions.Blocks.Nonlinear.PadeDelay</i></p>
 <p>Replaced <tt>reinit</tt> by <tt>initial equation</tt></p>
 <p><i>ModelicaAdditions.HeatFlow1D.Interfaces</i></p>
 <p>Definition of connectors <i>Surface_a</i> and <i>Surface_b</i>:<br>
 <tt>flow SIunits.HeatFlux q;</tt> changed to <tt>flow SIunits.HeatFlowRate q;</tt></p>
 <p><i>MultiBody.Parts.InertialSystem</i></p>
 <p>Icon corrected.</p>
 </html>
 "));
      end Version_1_5;
      class Version_1_4 "Version 1.4"
              annotation(Documentation(info="<html>
 <h3><font color=\"#008000\">Version 1.4.1 (June 28, 2001)</font></h3>
 <ul>
 <li>Several minor bugs fixed. </li>
 <li>New models:<br>
     Modelica.Blocks.Interfaces.IntegerRealInput/IntegerRealOutput,<br>
     Modelica.Blocks.Math.TwoInputs/TwoOutputs<br>
     Modelica.Electrical.Analog.Ideal.IdealOpAmp3Pin,<br>
     Modelica.Mechanics.Rotational.Move,<br>
     Modelica.Mechanics.Translational.Move.<br>
     </li>
 </ul>
 
 <hr>
 
 <h3><font color=\"#008000\">Version 1.4.1beta1 (February 12, 2001)</font></h3>
 <p> Adapted to Modelica 1.4</p>
 
 <hr>
 
 <h3><font color=\"#008000\">Version 1.3.2beta2 (June 20, 2000)</font></h3>
 <ul>
     <li>New subpackage Modelica.Mechanics.<b>Translational</b></li>
     <li>Changes to Modelica.Mechanics.<b>Rotational</b>:<br>
        New elements:
 <pre>
    IdealGearR2T    Ideal gear transforming rotational in translational motion.
    Position        Forced movement of a flange with a reference angle
                    given as input signal
    RelativeStates  Definition of relative state variables
 </pre>
 </li>
     <li>Changes to Modelica.<b>SIunits</b>:<br>
       Introduced new types:<br>
       type Temperature = ThermodynamicTemperature;<br>
       types DerDensityByEnthalpy, DerDensityByPressure,
       DerDensityByTemperature, DerEnthalpyByPressure,
       DerEnergyByDensity, DerEnergyByPressure<br>
       Attribute \"final\" removed from min and max values
       in order that these values can still be changed to narrow
       the allowed range of values.<br>
       Quantity=\"Stress\" removed from type \"Stress\", in order
       that a type \"Stress\" can be connected to a type \"Pressure\".</li>
     <li>Changes to Modelica.<b>Icons</b>:<br>
        New icons for motors and gearboxes.</li>
     <li>Changes to Modelica.<b>Blocks.Interfaces</b>:<br>
        Introduced a replaceable signal type into
        Blocks.Interfaces.RealInput/RealOutput:
 <pre>
    replaceable type SignalType = Real
 </pre>
        in order that the type of the signal of an input/output block
        can be changed to a physical type, for example:
 <pre>
    Sine sin1(outPort(redeclare type SignalType=Modelica.SIunits.Torque))
 </pre>
       </li></ul>
 </li>
 </ul>
 
 <hr>
 
 <h3><font color=\"#008000\">Version 1.3.1 (Dec. 13, 1999)</font></h3>
 <p>
 First official release of the library.
 </p>
 </html>
 "));
      end Version_1_4;
    end ReleaseNotes;
    class Contact "Contact"
          annotation(Documentation(info="<html>
 <h3><font color=\"#008000\" size=5>Contact</font></h3>
 <dl>
 <dt>The development of the Modelica package is organized by<br>&nbsp;</dt>
 <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
     Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
     Institut f&uuml;r Robotik und Mechatronik<br> 
     Abteilung f&uuml;r Entwurfsorientierte Regelungstechnik<br>
     Postfach 1116<br>
     D-82230 Wessling<br>
     Germany<br>
     email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br></dd>
 </dl>
 <p>
 This library is developed by several people from
 the Modelica Association, see
 <a href=\"http://www.Modelica.org\">http://www.Modelica.org</a>.
 In particular, the following people have directly contributed
 (many more people have contributed to the design):
 </p>
 <table border=1 cellspacing=0 cellpadding=2>
   <tr><td><b>Peter Beater</b> </td
       <td> University of Paderborn, Germany</td>
       <td> Modelica.Mechanics.Translational </td>
   </tr>
   <tr><td><b>Dag Br&uuml;ck</b> </td
       <td> Dynasim AB, Lund, Sweden</td>
       <td> Modelica.Utilities</td>
   </tr>
 
   <tr><td><b>Francesco Casella</b> </td
       <td> Politecnico di Milano, Milano, Italy</td>
       <td> Modelica.Media</td>
   </tr>
 
   <tr><td><b>Christoph Clauss</b> </td
       <td> Fraunhofer Institute for Integrated Circuits,<br> Dresden, Germany</td>
       <td> Modelica.Electrical.Analog<br> 
            Modelica.Electrical.Digital</td>
   </tr>
 
   <tr><td><b>Jonas Eborn</b> </td
       <td> Modelon AB, Lund, Sweden</td>
       <td> Modelica.Media</td>
   </tr>
 
   <tr><td><b>Hilding Elmqvist</b> </td
       <td> Dynasim AB, Lund, Sweden</td>
       <td> Modelica.Mechanics.MultiBody<br>
            Modelica.Media<br>
            Modelica.StateGraph<br>
            Modelica.Utilities<br>
            Conversion from 1.6 to 2.0</td>
   </tr>
 
   <tr><td><b>R&uuml;diger Franke</b> </td
       <td> ABB Corporate Research,<br>Ladenburg, German</td>
       <td> Modelica.Media</td>
   </tr>
 
   <tr><td><b>Anton Haumer</b> </td
       <td> Consultant, St.Andrae-Woerdern,<br>Austria</td>
       <td> Modelica.Electrical.Machines<br>
            Modelica.Electrical.Multiphase<br>
            Modelica.Mechanics.Rotational<br>
            Modelica.Thermal.FluidHeatFlow</td>
   </tr>
 
   <tr><td><b>Hans-Dieter Joos</b> </td
       <td> DLR, German Aerospace Center, <br>
            Oberpfaffenhofen, Germany</td>
       <td> Modelica.Math.Matrices</td>
   </tr>
 
   <tr><td><b>Christian Kral</b> </td
       <td> arsenal research, Vienna, Austria</td>
       <td> Modelica.Electrical.Machines<br>
            Modelica.Thermal.FluidHeatFlow</td>
   </tr>
 
   <tr><td><b>Sven Erik Mattsson</b> </td
       <td> Dynasim AB, Lund, Sweden</td>
       <td> Modelica.Mechanics.MultiBody</td>
   </tr>
   <tr><td><b>Hans Olsson</b> </td
       <td> Dynasim AB, Lund, Sweden</td>
       <td> Modelica.Blocks<br>
            Modelica.Math.Matrices<br>
            Modelica.Utilities<br>
            Conversion from 1.6 to 2.0</td>
   </tr>
   <tr><td><b>Martin Otter</b> </td
       <td> DLR, German Aerospace Center, <br>
            Oberpfaffenhofen, Germany</td>
       <td> Modelica.Blocks<br> 
            Modelica.Mechanics.MultiBody<br>
            Modelica.Mechanics.Rotational<br>
            Modelica.Math<br>
            Modelica.Media<br>
            Modelica.SIunits<br>
            Modelica.StateGraph<br>
            Modelica.Thermal<br>
            Modelica.Utilities<br>
            ModelicaReference<br>
            Conversion from 1.6 to 2.0</td>
   </tr>
 
   <tr><td><b>Katrin Pr&ouml;l&szlig;</b> </td
       <td> Technical University Hamburg-Harburg,<br>Germany</td>
       <td> Modelica.Media/td>
   </tr>
 
   <tr><td><b>Andr&eacute; Schneider</b> </td
       <td> Fraunhofer Institute for Integrated Circuits,<br> Dresden, Germany</td>
       <td> Modelica.Electrical.Analog<br> 
            Modelica.Electrical.Digital</td>
   </tr>
   <tr><td><b>Christian Schweiger</b> </td
       <td> DLR, German Aerospace Center,<br>Oberpfaffenhofen, Germany</td>
       <td> Modelica.Mechanics.Rotational<br>
            ModelicaReference<br>
            Conversion from 1.6 to 2.0</td>
   </tr>
   <tr><td><b>Michael Tiller</b> </td
       <td> Ford Motor Company, Dearborn, MI, U.S.A </td>
       <td> Modelica.Media<br>
            Modelica.Thermal</td>
   </tr>
   <tr><td><b>Hubertus Tummescheit</b> </td
       <td> Modelon AB, Lund, Sweden </td>
       <td> Modelica.Media<br>
            Modelica.Thermal</td>
   </tr>
   <tr><td><b>Nico Walter</b> </td
       <td> Master thesis at HTWK Leipzig<br>
            (Prof. R. M&uuml;ller) and<br>
            DLR Oberpfaffenhofen, Germany</td>
       <td> Modelica.Math.Matrices</td>
   </tr>
 </table>
 </html>
 "));
    end Contact;
    class ModelicaLicense "Modelica License"
          annotation(Documentation(info="<html>
 <h3><font color=\"#008000\" size=5>The Modelica License 
 (Version 1.1 of June 30, 2000) </font></h3>
 <p>Redistribution and use in source and binary forms, with or without
 modification are permitted, provided that the following conditions are met:
 <ol>
 <li>
 The author and copyright notices in the source files, these license conditions
 and the disclaimer below are (a) retained and (b) reproduced in the documentation
 provided with the distribution.</li>
 <li>
 Modifications of the original source files are allowed, provided that a
 prominent notice is inserted in each changed file and the accompanying
 documentation, stating how and when the file was modified, and provided
 that the conditions under (1) are met.</li>
 <li>
 It is not allowed to charge a fee for the original version or a modified
 version of the software, besides a reasonable fee for distribution and support.
 Distribution in aggregate with other (possibly commercial) programs
 as part of a larger (possibly commercial) software distribution is permitted,
 provided that it is not advertised as a product of your own.</li>
 </ol>
 <h4><font color=\"#008000\">Disclaimer</font></h4>
 <p>The software (sources, binaries, etc.) in their original or in a modified
 form are provided
 \"as is\" and the copyright holders assume no responsibility for its contents
 what so ever. Any express or implied warranties, including, but not
 limited to, the implied warranties of merchantability and fitness for a
 particular purpose are <b>disclaimed</b>. <b>In no event</b> shall the
 copyright holders, or any party who modify and/or redistribute the package,
 <b>be liable</b> for any direct, indirect, incidental, special, exemplary, or
 consequential damages, arising in any way out of the use of this software,
 even if advised of the possibility of such damage.
 </p>
 </html>
 "));
    end ModelicaLicense;
  end UsersGuide;
  package Math "Mathematical functions"
      import SI = Modelica.SIunits;
    extends Modelica.Icons.Library2;
    annotation(preferedView="info",Invisible=true,Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-59.0,-9.0},{42.0,-56.0}}, textString="f(x)", fillColor={0,0,0})}),Documentation(info="<HTML>
 <p>
 This package contains the following basic mathematical functions:
 </p>
 <pre>
    <b>Matrices</b>      Library with functions operating on matrices
    <b>sin</b>(u)        sine
    <b>cos</b>(u)        cosine
    <b>tan</b>(u)        tangent     (u shall not be -pi/2, pi/2, 3*pi/2, ...)
    <b>asin</b>(u)       inverse sine    (-1 &le; u &le; 1)
    <b>acos</b>(u)       inverse cosine  (-1 &le; u &le; 1)
    <b>atan</b>(u)       inverse tangent
    <b>atan2</b>(u1,u2)  four quadrant inverse tangent
    <b>sinh</b>(u)       hyperbolic sine
    <b>cosh</b>(u)       hyperbolic cosine
    <b>tanh</b>(u)       hyperbolic tangent
    <b>exp</b>(u)        exponential, base e
    <b>log</b>(u)        natural (base e) logarithm (u &gt; 0)
    <b>log10</b>(u)      base 10 logarithm (u &gt; 0)
 </pre>
 <p>
 These functions are used by calling them directly
 with a full name (e.g. y = Modelica.Math.asin(0.5)).
 </p>
 <dl>
 <dt><b>Main Author:</b>
 <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
     Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
     Institut f&uuml;r Robotik und Mechatronik<br>
     Postfach 1116<br>
     D-82230 Wessling<br>
     Germany<br>
     email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br>
 </dl>
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association and DLR.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Function tempInterpol2 added.</li>
 <li><i>Oct. 24, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Icons for icon and diagram level introduced.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 
 </html>"));
    package Matrices "Functions on matrices"
          extends Modelica.Icons.Library;
      annotation(preferedView="info",version="0.8.1",versionDate="2004-08-21",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Library content</font></h3>
 <p>
 This library provides functions operating on matrices:
 </p>
 <table border=1 cellspacing=0 cellpadding=2>
   <tr><th><i>Function</i></th>
       <th><i>Description</i></th>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.norm\">norm</a>(A)</td>
       <td>1-, 2- and infinity-norm of matrix A</td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.isEqual\">isEqual</a>(M1, M2)</td>
       <td>determines whether two matrices have the same size and elements</td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.solve\">solve</a>(A,b)</td>
       <td>Solve real system of linear equations A*x=b with a b vector</td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.leastSquares\">leastSquares</a>(A,b)</td>
       <td>Solve overdetermined or underdetermined real system of <br>
           linear equations A*x=b in a least squares sense</td>
   </tr>
   <tr><td>(LU,p,info) = <a href=\"Modelica:Modelica.Math.Matrices.LU\">LU</a>(A)</td>
       <td>LU decomposition of square or rectangular matrix</td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.LU_solve\">LU_solve</a>(LU,p,b)</td>
       <td>Solve real system of linear equations P*L*U*x=b with a<br>
           b vector and an LU decomposition from \"LU(..)\"</td>
   </tr>
   <tr><td>(Q,R,p) = <a href=\"Modelica:Modelica.Math.Matrices.QR\">QR</a>(A)</td>
       <td> QR decomposition with column pivoting of rectangular matrix (Q*R = A[:,p]) </td>
   </tr>
   <tr><td>eval = <a href=\"Modelica:Modelica.Math.Matrices.eigenValues\">eigenValues</a>(A)<br>
           (eval,evec) = <a href=\"Modelica:Modelica.Math.Matrices.eigenValues\">eigenValues</a>(A)</td>
       <td> compute eigenvalues and optionally eigenvectors<br>
            for a real, nonsymmetric matrix </td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.eigenValueMatrix\">eigenValueMatrix</a>(eigen)</td>
       <td> return real valued block diagonal matrix J of eigenvalues of 
             matrix A (A=V*J*Vinv) </td>
   </tr>
   <tr><td>sigma = <a href=\"Modelica:Modelica.Math.Matrices.singularValues\">singularValues</a>(A)<br>
       (sigma,U,VT) = <a href=\"Modelica:Modelica.Math.Matrices.singularValues\">singularValues</a>(A)</td>
       <td> compute singular values and optionally left and right singular vectors </td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.det\">det</a>(A)</td>
       <td> determinant of a matrix (do <b>not</b> use; use rank(..))</td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.inv\">inv</a>(A)</td>
       <td> inverse of a matrix </td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.rank\">rank</a>(A)</td>
       <td> rank of a matrix </td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.balance\">balance</a>(A)</td>
       <td>balance a square matrix to improve the condition</td>
   </tr>
   <tr><td><a href=\"Modelica:Modelica.Math.Matrices.exp\">exp</a>(A)</td>
       <td> compute the exponential of a matrix by adaptive Taylor series<br> 
            expansion with scaling and balancing</td>
   </tr>
   <tr><td>(P, G) = <a href=\"Modelica:Modelica.Math.Matrices.integralExp\">integralExp</a>(A,B)</td>
       <td> compute the exponential of a matrix and its integral</td>
   </tr>
   <tr><td>(P, G, GT) = <a href=\"Modelica:Modelica.Math.Matrices.integralExpT\">integralExpT</a>(A,B)</td>
       <td> compute the exponential of a matrix and two integrals</td>
   </tr>
 </table>
 
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 </HTML>
 "));
      function norm "Returns the norm of a matrix"
              extends Modelica.Icons.Function;
        input Real A[:,:] "Input matrix";
        input Real p(min=1)=2 "Type of p-norm (only allowed: 1, 2 or Modelica.Constants.inf)";
        output Real result=0.0 "p-norm of matrix A";
        annotation(preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 Matrices.<b>norm</b>(A);
 Matrices.<b>norm</b>(A, p=2);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 The function call \"<code>Matrices.norm(A)</code>\" returns the
 2-norm of matrix A, i.e., the largest singular value of A.<br>
 The function call \"<code>Matrices.norm(A, p)</code>\" returns the
 p-norm of matrix A. The only allowed values for p are</p>
 <ul>
 <li> \"p=1\": the largest column sum of A</li>
 <li> \"p=2\": the largest singular value of A</li> 
 <li> \"p=Modelica.Constants.inf\": the largest row sum of A</li>
 </ul>
 <p>
 Note, for any matrices A1, A2 the following inequality holds:
 </p>
 <blockquote><pre>
 Matrices.<b>norm</b>(A1+A2,p) &le; Matrices.<b>norm</b>(A1,p) + Matrices.<b>norm</b>(A2,p)
 </pre></blockquote>
 <p>
 Note, for any matrix A and vector v the following inequality holds:
 </p>
 <blockquote><pre>
 Vectors.<b>norm</b>(A*v,p) &le; Matrices.<b>norm</b>(A,p)*Vectors.<b>norm</b>(A,p)
 </pre></blockquote>
 </HTML>"));
      algorithm 
        if p == 1 then 
                for i in 1:size(A, 2) loop
                  result:=max(result, sum(abs(A[:,i])));

        end for;

        else         if p == 2 then 
                result:=max(singularValues(A));

        else         if p == Modelica.Constants.inf then 
                for i in 1:size(A, 1) loop
                  result:=max(result, sum(abs(A[i,:])));

        end for;

        else         assert(false, "Optional argument \"p\" of function \"norm\" must be 
 1, 2 or Modelica.Constants.inf");

        end if;

        end if;

        end if;
      end norm;
      function isEqual "Compare whether two Real matrices are identical"
              extends Modelica.Icons.Function;
        input Real M1[:,:] "First matrix";
        input Real M2[:,:] "Second matrix (may have different size as M1";
        input Real eps(min=0)=0 "Two elements e1 and e2 of the two matrices are identical if abs(e1-e2) <= eps";
        output Boolean result "= true, if matrices have the same size and the same elements";
        annotation(preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 Matrices.<b>isEqual</b>(M1, M2);
 Matrices.<b>isEqual</b>(M1, M2, eps=0);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 The function call \"<code>Matrices.isEqual(M1, M2)</code>\" returns <b>true</b>, 
 if the two Real matrices M1 and M2 have the same dimensions and 
 the same elements. Otherwise the function
 returns <b>false</b>. Two elements e1 and e2 of the two matrices
 are checked on equality by the test \"abs(e1-e2) &le; eps\", where \"eps\"
 can be provided as third argument of the function. Default is \"eps = 0\".
 </p>
 <h3><font color=\"#008000\">Example</font></h3>
 <blockquote><pre>
   Real A1[2,2] = [1,2; 3,4];
   Real A2[3,2] = [1,2; 3,4; 5,6];
   Real A3[2,2] = [1,2, 3,4.0001];
   Boolean result;
 <b>algorithm</b>
   result := Matrices.isEqual(M1,M2);     // = <b>false</b>
   result := Matrices.isEqual(M1,M3);     // = <b>false</b>
   result := Matrices.isEqual(M1,M1);     // = <b>true</b>
   result := Matrices.isEqual(M1,M3,0.1); // = <b>true</b>
 </pre></blockquote>
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Vectors.isEqual\">Vectors.isEqual</a>, 
 <a href=\"Modelica:Modelica.Strings.isEqual\">Strings.isEqual</a>
 </HTML>"));
      protected 
        Integer nrow=size(M1, 1) "Number of rows of matrix M1";
        Integer ncol=size(M1, 2) "Number of columns of matrix M1";
        Integer i=1;
        Integer j;
      algorithm 
        result:=false;
        if size(M2, 1) == nrow and size(M2, 2) == ncol then 
                result:=true;
        while (i <= nrow) loop
                  j:=1;
          while (j <= ncol) loop
                      if abs(M1[i,j] - M2[i,j]) > eps then 
                        result:=false;
            i:=nrow;
            j:=ncol;
            else 
            end if;
            j:=j + 1;
          end while;
          i:=i + 1;
        end while;
        else 
        end if;      end isEqual;
      function solve "Solve real system of linear equations A*x=b with a b vector (Gaussian elemination with partial pivoting)"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)] "Matrix A of A*x = b";
        input Real b[size(A, 1)] "Vector b of A*x = b";
        output Real x[size(b, 1)] "Vector x such that A*x = b";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 Matrices.<b>solve</b>(A,b);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 This function call returns the
 solution <b>x</b> of the linear system of equations
 </p>
 <blockquote>
 <p>
 <b>A</b>*<b>x</b> = <b>b</b>
 </p>
 </blockquote>
 <p>
 If a unique solution <b>x</b> does not exist (since <b>A</b> is singular),
 an exception is raised.
 </p>
 <p>
 Note, the solution is computed with the LAPACK function \"dgesv\",
 i.e., by Gaussian elemination with partial pivoting.
 </p>
 <h3><font color=\"#008000\">Example</font></h3>
 <blockquote><pre>
   Real A[3,3] = [1,2,3; 
                  3,4,5;
                  2,1,4];
   Real b[3] = {10,22,12};
   Real x[3];
 <b>algorithm</b>
   x := Matrices.solve(A,b);  // x = {3,2,1}
 </pre></blockquote>
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Math.Matrices.LU\">Matrices.LU</a>,
 <a href=\"Modelica:Modelica.Math.Matrices.LU_solve\">Matrices.LU_solve</a>
 </HTML>"));
      protected 
        Integer info;
      algorithm 
        (x,info) := LAPACK.dgesv_vec(A, b);
        assert(info == 0, "Solving a linear system of equations with function
 \"Matrices.solve\" is not possible, because the system has either 
 no or infinitely many solutions (A is singular).");      end solve;
      function leastSquares "Solve overdetermined or underdetermined real system of linear equations A*x=b in a least squares sense"
              extends Modelica.Icons.Function;
        input Real A[:,:] "Matrix A";
        input Real b[size(A, 1)] "Vector b";
        output Real x[size(A, 2)] "Vector x such that min|A*x-b|^2 if size(A,1) >= size(A,2) or min|x|^2 and A*x=b, if size(A,1) < size(A,2)";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 x = Matrices.<b>leastSquares</b>(A,b);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 A linear system of equations A*x = b has no solutions or infinitely
 many solutions if A is not square. Function \"leastSquares\" returns
 a solution in a least squarse sense:
 </p>
 <pre>
   size(A,1) &gt; size(A,2):  returns x such that |A*x - b|^2 is a minimum
   size(A,1) = size(A,2):  returns x such that A*x = b
   size(A,1) &lt; size(A,2):  returns x such that |x|^2 is a minimum for all 
                           vectors x that fulfill A*x = b
 </pre>
 <p>
 Note, the solution is computed with the LAPACK function \"dgesl\",
 i.e., QR or LQ factorization of A. It is required that
 A has full rank.
 </p>
 </HTML>"));
      protected 
        Integer info;
        Real xx[max(size(A, 1), size(A, 2))];
      algorithm 
        (xx,info) := LAPACK.dgels_vec(A, b);
        x:=xx[1:size(A, 2)];
        assert(info == 0, "Solving an overdetermined or underdetermined linear system of 
 equations with function \"Matrices.leastSquares\" failed.");      end leastSquares;
      function LU "LU decomposition of square or rectangular matrix"
              extends Modelica.Icons.Function;
        input Real A[:,:] "Square or rectangular matrix";
        output Real LU[size(A, 1),size(A, 2)]=A "L,U factors (used with LU_solve(..))";
        output Integer pivots[min(size(A, 1), size(A, 2))] "pivot indices (used with LU_solve(..))";
        output Integer info "Information";

        external "FORTRAN 77" dgetrf(size(A, 1),size(A, 2),LU,size(A, 1),pivots,info)         annotation(Library="Lapack");
        annotation(preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 (LU, pivots)       = Matrices.<b>LU</b>(A);
 (LU, pivots, info) = Matrices.<b>LU</b>(A);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 This function call returns the
 LU decomposition of a \"Real[m,n]\" matrix A, i.e.,
 </p>
 <blockquote>
 <p>
 <b>P</b>*<b>L</b>*<b>U</b> = <b>A</b>
 </p>
 </blockquote>
 <p>
 where <b>P</b> is a permutation matrix (implicitely
 defined by vector <code>pivots</code>),
 <b>L</b> is a lower triangular matrix with unit
 diagonal elements (lower trapezoidal if m &gt; n), and
 <b>U</b> is an upper triangular matrix (upper trapezoidal if m &lt; n).
 Matrices <b>L</b> and <b>U</b> are stored in the returned
 matrix <code>LU</code> (the diagonal of <b>L</b> is not stored).
 With the companion function 
 <a href=\"Modelica:Modelica.Math.Matrices.LU_solve\">Matrices.LU_solve</a>,
 this decomposition can be used to solve
 linear systems (<b>P</b>*<b>L</b>*<b>U</b>)*<b>x</b> = <b>b</b> with different right
 hand side vectors <b>b</b>. If a linear system of equations with
 just one right hand side vector <b>b</b> shall be solved, it is
 more convenient to just use the function
 <a href=\"Modelica:Modelica.Math.Matrices.solve\">Matrices.solve</a>.
 </p>
 <p>
 The optional third (Integer) output argument has the following meaning:
 <table border=0 cellspacing=0 cellpadding=2>
   <tr><td>info = 0:</td
       <td>successful exit</td></tr>
   <tr><td>info &gt; 0:</td>
       <td>if info = i, U[i,i] is exactly zero. The factorization
           has been completed, <br> 
           but the factor U is exactly
           singular, and division by zero will occur<br> if it is used
           to solve a system of equations.</td></tr>
 </table>
 </p>
 <p>
 The LU factorization is computed
 with the LAPACK function \"dgetrf\",
 i.e., by Gaussian elemination using partial pivoting
 with row interchanges. Vector \"pivots\" are the
 pivot indices, i.e., for 1 &le; i &le; min(m,n), row i of 
 matrix A was interchanged with row pivots[i].
 </p>
 <h3><font color=\"#008000\">Example</font></h3>
 <blockquote><pre>
   Real A[3,3] = [1,2,3; 
                  3,4,5;
                  2,1,4];
   Real b1[3] = {10,22,12};
   Real b2[3] = { 7,13,10};
   Real    LU[3,3];
   Integer pivots[3];
   Real    x1[3];
   Real    x2[3];
 <b>algorithm</b>
   (LU, pivots) := Matrices.LU(A);
   x1 := Matrices.LU_solve(LU, pivots, b1);  // x1 = {3,2,1}
   x2 := Matrices.LU_solve(LU, pivots, b2);  // x2 = {1,0,2}
 </pre></blockquote>
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Math.Matrices.LU_solve\">Matrices.LU_solve</a>, 
 <a href=\"Modelica:Modelica.Math.Matrices.solve\">Matrices.solve</a>,
 </HTML>"));
      end LU;
      function LU_solve "Solve real system of linear equations P*L*U*x=b with a b vector and an LU decomposition (from LU(..))"
              extends Modelica.Icons.Function;
        input Real LU[:,size(LU, 1)] "L,U factors of Matrices.LU(..) for a square matrix";
        input Integer pivots[size(LU, 1)] "Pivots indices of Matrices.LU(..)";
        input Real b[size(LU, 1)] "Right hand side vector of P*L*U*x=b";
        output Real x[size(b, 1)] "Solution vector such that P*L*U*x = b";
        annotation(preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 Matrices.<b>LU_solve</b>(LU, pivots, b);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 This function call returns the
 solution <b>x</b> of the linear systems of equations
 </p>
 <blockquote>
 <p>
 <b>P</b>*<b>L</b>*<b>U</b>*<b>x</b> = <b>b</b>;
 </p>
 </blockquote>
 <p>
 where <b>P</b> is a permutation matrix (implicitely
 defined by vector <code>pivots</code>),
 <b>L</b> is a lower triangular matrix with unit
 diagonal elements (lower trapezoidal if m &gt; n), and
 <b>U</b> is an upper triangular matrix (upper trapezoidal if m &lt; n).
 The matrices of this decomposition are computed with function
 <a href=\"Modelica:Modelica.Math.Matrices.LU\">Matrices.LU</a> that
 returns arguments <code>LU</code> and <code>pivots</code>
 used as input arguments of <code>Matrices.LU_solve</code>.
 With <code>Matrices.LU</code> and <code>Matrices.LU_solve</code>
 it is possible to efficiently solve linear systems
 with different right hand side vectors. If a linear system of equations with
 just one right hand side vector shall be solved, it is
 more convenient to just use the function
 <a href=\"Modelica:Modelica.Math.Matrices.solve\">Matrices.solve</a>.
 </p>
 <p>
 If a unique solution <b>x</b> does not exist (since the 
 LU decomposition is singular), an exception is raised.
 </p>
 <p>
 The LU factorization is computed
 with the LAPACK function \"dgetrf\",
 i.e., by Gaussian elemination using partial pivoting
 with row interchanges. Vector \"pivots\" are the
 pivot indices, i.e., for 1 &le; i &le; min(m,n), row i of 
 matrix A was interchanged with row pivots[i].
 </p>
 <h3><font color=\"#008000\">Example</font></h3>
 <blockquote><pre>
   Real A[3,3] = [1,2,3; 
                  3,4,5;
                  2,1,4];
   Real b1[3] = {10,22,12};
   Real b2[3] = { 7,13,10};
   Real    LU[3,3];
   Integer pivots[3];
   Real    x1[3];
   Real    x2[3];
 <b>algorithm</b>
   (LU, pivots) := Matrices.LU(A);
   x1 := Matrices.LU_solve(LU, pivots, b1);  // x1 = {3,2,1}
   x2 := Matrices.LU_solve(LU, pivots, b2);  // x2 = {1,0,2}
 </pre></blockquote>
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Math.Matrices.LU\">Matrices.LU</a>, 
 <a href=\"Modelica:Modelica.Math.Matrices.solve\">Matrices.solve</a>,
 </HTML>"));
      algorithm 
        for i in 1:size(LU, 1) loop
                  assert(LU[i,i] <> 0, "Solving a linear system of equations with function
 \"Matrices.LU_solve\" is not possible, since the LU decomposition
 is singular, i.e., no unique solution exists.");

        end for;
        x:=LAPACK.dgetrs_vec(LU, pivots, b);      end LU_solve;
      function QR "QR decomposition of a square matrix with column pivoting (A(:,p) = Q*R)"
              extends Modelica.Icons.Function;
        input Real A[:,:] "Rectangular matrix with size(A,1) >= size(A,2)";
        output Real Q[size(A, 1),size(A, 2)] "Rectangular matrix with orthonormal columns such that Q*R=A[:,p]";
        output Real R[size(A, 2),size(A, 2)] "Square upper triangular matrix";
        output Integer p[size(A, 2)] "Column permutation vector";
        annotation(preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 (Q,R,p) = Matrices.<b>QR</b>(A);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 This function returns the QR decomposition of
 a rectangular matrix <b>A</b> (the number of columns of <b>A</b>
 must be less than or equal to the number of rows):
 </p>
 <blockquote>
 <p>
 <b>Q</b>*<b>R</b> = <b>A</b>[:,<b>p</b>]
 </p>
 </blockquote>
 <p>
 where <b>Q</b> is a rectangular matrix that has orthonormal columns and
 has the same size as A (<b>Q</b><sup>T</sup><b>Q</b>=<b>I</b>),
 <b>R</b> is a square, upper triangular matrix and <b>p</b> is a permutation
 vector. Matrix <b>R</b> has the following important properties:
 </p>
 <ul>
 <li> The absolute value of a diagonal element of <b>R</b> is the largest
      value in this row, i.e.,
      abs(R[i,i]) &ge; abs(R[i,j]).</li>
 <li> The diagonal elements of <b>R</b> are sorted according to size, such that
      the largest absolute value is abs(R[1,1]) and
      abs(R[i,i]) &ge; abs(R[j,j]) with i &lt; j. </li>
 </ul>
 <p>
 This means that if abs(R[i,i]) &le; &epsilon; then abs(R[j,k]) &le; &epsilon;
 for j &ge; i, i.e., the i-th row up to the last row of <b>R</b> have
 small elements and can be treated as being zero. 
 This allows to, e.g., estimate the row-rank
 of <b>R</b> (which is the same row-rank as <b>A</b>). Furthermore,
 <b>R</b> can be partitioned in two parts
 </p>
 <blockquote>
 <pre>
    <b>A</b>[:,<b>p</b>] = <b>Q</b> * [<b>R</b><sub>1</sub>, <b>R</b><sub>2</sub>;
                  <b>0</b>,  <b>0</b>]
 </pre>
 </blockquote>
 <p>
 where <b>R</b><sub>1</sub> is a regular, upper triangular matrix. 
 </p>
 <p>
 Note, the solution is computed with the LAPACK functions \"dgeqpf\"
 and \"dorgqr\", i.e., by Housholder transformations with
 column pivoting. If <b>Q</b> is not needed, the function may be
 called as: <code>(,R,p) = QR(A)</code>.
 </p>
 <h3><font color=\"#008000\">Example</font></h3>
 <blockquote><pre>
   Real A[3,3] = [1,2,3; 
                  3,4,5;
                  2,1,4];
   Real R[3,3];
 <b>algorithm</b>
   (,R) := Matrices.QR(A);  // R = [-7.07.., -4.24.., -3.67..;
                                     0     , -1.73.., -0.23..;
                                     0     ,  0     ,  0.65..];
 </pre></blockquote>
 </HTML>"));
      protected 
        Integer nrow=size(A, 1);
        Integer ncol=size(A, 2);
        Real tau[ncol];
      algorithm 
        assert(nrow >= ncol, "\nInput matrix A[" + String(nrow) + "," + String(ncol) + "] has more columns as rows.
 This is not allowed when calling Modelica.Matrices.QR(A).");
        (Q,tau,p) := LAPACK.dgeqpf(A);
        R:=zeros(ncol, ncol);
        for i in 1:ncol loop
                  for j in i:ncol loop
                      R[i,j]:=Q[i,j];

          end for;

        end for;
        Q:=LAPACK.dorgqr(Q, tau);      end QR;
      function eigenValues "Compute eigenvalues and eigenvectors for a real, nonsymmetric matrix"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)] "Matrix";
        output Real eigenvalues[size(A, 1),2] "Eigenvalues of matrix A (Re: first column, Im: second column)";
        output Real eigenvectors[size(A, 1),size(A, 2)] "Real-valued eigenvector matrix";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
                 eigenvalues = Matrices.<b>eigenValues</b>(A);
 (eigenvalues, eigenvectors) = Matrices.<b>eigenValues</b>(A);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 This function call returns the eigenvalues and 
 optionally the (right) eigenvectors of a square matrix 
 <b>A</b>. The first column of \"eigenvalues\" contains the real and the
 second column contains the imaginary part of the eigenvalues.
 If the i-th eigenvalue has no imaginary part, then eigenvectors[:,i] is
 the corresponding real eigenvector. If the i-th eigenvalue
 has an imaginary part, then eigenvalues[i+1,:] is the conjugate complex
 eigenvalue and eigenvectors[:,i] is the real and eigenvectors[:,i+1] is the
 imaginary part of the eigenvector of the i-th eigenvalue.
 With function 
 <a href=\"Modelica:Modelica.Math.Matrices.eigenValueMatrix\">Matrices.eigenValueMatrix</a>,
 a real block diagonal matrix is constructed from the eigenvalues 
 such that 
 </p>
 <blockquote>
 <pre>
 A = eigenvectors * eigenValueMatrix(eigenvalues) * inv(eigenvectors)
 </pre>
 </blockquote>
 <p>
 provided the eigenvector matrix \"eigenvectors\" can be inverted
 (an inversion is possible, if all eigenvalues are different
 and no eigenvalue is zero).
 </p>
 <h3><font color=\"#008000\">Example</font></h3>
 <blockquote><pre>
   Real A[3,3] = [1,2,3; 
                  3,4,5;
                  2,1,4];
   Real eval;
 <b>algorithm</b>
   eval := Matrices.eigenValues(A);  // eval = [-0.618, 0; 
                                     //          8.0  , 0;
                                     //          1.618, 0];
 </pre>
 </blockquote>
 <p>
 i.e., matrix A has the 3 real eigenvalues -0.618, 8, 1.618.
 </p>
 </pre></blockquote>
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Math.Matrices.eigenValueMatrix\">Matrices.eigenValueMatrix</a>,
 <a href=\"Modelica:Modelica.Math.Matrices.singularValues\">Matrices.singularValues</a>
 </HTML>
 "));
      protected 
        Integer info;
        Boolean onlyEigenvalues=false;
      algorithm 
        if onlyEigenvalues then 
                (eigenvalues[:,1],eigenvalues[:,2],info) := LAPACK.dgeev_eigenValues(A);
        eigenvectors:=zeros(size(A, 1), size(A, 1));
        else         (eigenvalues[:,1],eigenvalues[:,2],eigenvectors,info) := LAPACK.dgeev(A);

        end if;
        assert(info == 0, "Calculating the eigen values with function
 \"Matrices.eigenvalues\" is not possible, since the
 numerical algorithm does not converge.");      end eigenValues;
      function eigenValueMatrix "Return real valued block diagonal matrix J of eigenvalues of matrix A (A=V*J*Vinv)"
              extends Modelica.Icons.Function;
        input Real eigenValues[:,2] "Eigen values from function eigenValues(..) (Re: first column, Im: second column)";
        output Real J[size(eigenValues, 1),size(eigenValues, 1)] "Real valued block diagonal matrix with eigen values (Re: 1x1 block, Im: 2x2 block)";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 Matrices.<b>eigenValueMatrix</b>(eigenvalues);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 The function call returns a block diagonal matrix <b>J</b>
 from the the two-column matrix <code>eigenvalues</code>
 (computed by function
 <a href=\"Modelica:Modelica.Math.Matrices.eigenValues\">Matrices.eigenValues</a>).
 Matrix <code>eigenvalues</code> must have the real part of the
 eigenvalues in the first column and the imaginary part in the
 second column. If an eigenvalue i has a vanishing imaginary
 part, then <b>J</b>[i,i] = eigenvalues[i,1], i.e., the diagonal
 element of <b>J</b> is the real eigenvalue. 
 Otherwise, eigenvalue i and conjugate complex eigenvalue i+1
 are used to construct a 2 by 2 diagonal block of <b>J</b>:
 </p>
 <blockquote>
 <pre>
   J[i  , i]   := eigenvalues[i,1];
   J[i  , i+1] := eigenvalues[i,2];
   J[i+1, i]   := eigenvalues[i+1,2];
   J[i+1, i+1] := eigenvalues[i+1,1];
 </pre>
 </blockquote>
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Math.Matrices.eigenValues\">Matrices.eigenValues</a>
 </HTML>"));
      protected 
        Integer n=size(eigenValues, 1);
        Integer i;
      algorithm 
        J:=zeros(n, n);
        i:=1;
        while (i <= n) loop
                  if eigenValues[i,2] == 0 then 
                    J[i,i]:=eigenValues[i,1];
          i:=i + 1;
          else           J[i,i]:=eigenValues[i,1];
          J[i,i + 1]:=eigenValues[i,2];
          J[i + 1,i]:=eigenValues[i + 1,2];
          J[i + 1,i + 1]:=eigenValues[i + 1,1];
          i:=i + 2;
          end if;

        end while;      end eigenValueMatrix;
      function singularValues "Compute singular values and left and right singular vectors"
              extends Modelica.Icons.Function;
        input Real A[:,:] "Matrix";
        output Real sigma[min(size(A, 1), size(A, 2))] "Singular values";
        output Real U[size(A, 1),size(A, 1)]=zeros(size(A, 1), size(A, 1)) "Left orthogonal matrix";
        output Real VT[size(A, 2),size(A, 2)]=zeros(size(A, 2), size(A, 2)) "Transposed right orthogonal matrix ";
        annotation(preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
          sigma = Matrices.<b>singularValues</b>(A);
 (sigma, U, VT) = Matrices.<b>singularValues</b>(A);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 This function computes the singular values and optionally the
 singular vectors of matrix A. Basically the singular
 value decomposition of A is computed, i.e.,
 </p>
 <blockquote><pre>
 <b>A</b> = <b>U</b> <b><font face=\"Symbol\">S</font></b> <b>V</b><sup>T</sup>
   = U*Sigma*VT
 </blockquote></pre>
 <p>
 where <b>U </b>and <b>V</b> are orthogonal matrices (<b>UU</b><sup>T</sup>=<b>I,
 </b><b>VV</b><sup>T</sup>=<b>I</b>). <b><font face=\"Symbol\">S
 </font></b> = diag(<font face=\"Symbol\">s</font><sub>i</sub>) 
 has the same size as matrix A with nonnegative diagonal elements 
 in decreasing order and with all other elements zero
 (<font face=\"Symbol\">s</font><sub>1</sub> is the largest element). The function
 returns the singular values <font face=\"Symbol\">s</font><sub>i</sub>
 in vector <tt>sigma</tt> and the orthogonal matrices in
 matrices <tt>U</tt> and <tt>V</tt>.
 </p>
 <h3><font color=\"#008000\">Example</font></h3>
 <blockquote><pre>
   A = [1, 2,  3,  4;
        3, 4,  5, -2;
       -1, 2, -3,  5];
   (sigma, U, VT) = singularValues(A);
   results in:
      sigma = {8.33, 6.94, 2.31}; 
   i.e.
      Sigma = [8.33,    0,    0, 0;
                  0, 6.94,    0, 0;
                  0,    0, 2.31, 0]
 </pre></blockquote>
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Math.Matrices.eigenValues\">Matrices.eigenValues</a>
 </HTML>"));
      protected 
        Integer info;
        Integer n=min(size(A, 1), size(A, 2)) "Number of singular values";
      algorithm 
        (sigma,U,VT,info) := Matrices.LAPACK.dgesvd(A);
        assert(info == 0, "The numerical algorithm to compute the
 singular value decomposition did not converge");      end singularValues;
      function det "Determinant of a matrix (computed by LU decomposition)"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)];
        output Real result "Determinant of matrix A";
      protected 
        Real LU[size(A, 1),size(A, 1)];
        Integer pivots[size(A, 1)];
        annotation(preferedView="info",Documentation(info="<HTML>
 <h3><font color=\"#008000\">Syntax</font></h3>
 <blockquote><pre>
 Matrices.<b>det</b>(A);
 </pre></blockquote>
 <h3><font color=\"#008000\">Description</font></h3>
 <p>
 This function call returns the determinant of matrix A
 computed by a LU decomposition.
 Usally, this function should never be used, because
 there are nearly always better numerical algorithms
 as by computing the determinant. E.g., use function
 <a href=\"Modelica:Modelica.Math.Matrices.rank\">Matrices.rank</a>
 to compute the rank of a matrix.
 <h3><font color=\"#008000\">See also</font></h3>
 <a href=\"Modelica:Modelica.Math.Matrices.rank\">Matrices.rank</a>,
 <a href=\"Modelica:Modelica.Math.Matrices.solve\">Matrices.solve</a>
 </HTML>"));
      algorithm 
        (LU,pivots) := Matrices.LU(A);
        result:=product(LU[i,i] for i in 1:size(A, 1))*product(if pivots[i] == i then 1 else -1 for i in 1:size(pivots, 1));      end det;
      function inv "Inverse of a matrix"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)];
        output Real invA[size(A, 1),size(A, 2)] "Inverse of matrix A";
      protected 
        Integer info;
        Integer pivots[size(A, 1)] "Pivot vector";
        Real LU[size(A, 1),size(A, 2)] "LU factors of A";
      algorithm 
        (LU,pivots,info) := LAPACK.dgetrf(A);
        assert(info == 0, "Calculating an inverse matrix with function
 \"Matrices.inv\" is not possible, since matrix A is singular.");
        invA:=LAPACK.dgetri(LU, pivots);      end inv;
      function rank "Rank of a matrix (computed with singular values)"
              extends Modelica.Icons.Function;
        input Real A[:,:] "Matrix";
        input Real eps=0 "If eps > 0, the singular values are checked against eps; otherwise eps=max(size(A))*norm(A)*Modelica.Constants.eps is used";
        output Integer result "Rank of matrix A";
      protected 
        Integer n=min(size(A, 1), size(A, 2));
        Integer i=n;
        Real sigma[n]=singularValues(A) "Singular values";
        Real eps2=if eps > 0 then eps else max(size(A))*sigma[1]*Modelica.Constants.eps;
      algorithm 
        result:=n;
        while (i > 0) loop
                  if sigma[i] > eps2 then 
                    result:=i;
          i:=0;
          else 
          end if;
          i:=i - 1;
        end while;      end rank;
      function balance "Balancing of matrix A to improve the condition of A"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)];
        output Real D[size(A, 1)] "diagonal(D)=T is transformation matrix, such that
           T*A*inv(T) has smaller condition as A";
        output Real B[size(A, 1),size(A, 1)] "Balanced matrix (= diagonal(D)*A*inv(diagonal(D)))";
      protected 
        Integer na=size(A, 1);
        Integer radix=2 "Radix of exponent representation must be 'radix'
           or a multiple of 'radix'";
        Integer radix2=radix*radix;
        Boolean noconv=true;
        Integer i=1;
        Integer j=1;
        Real CO;
        Real RO;
        Real G;
        Real F;
        Real S;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<HTML>
 <p>
 The function transformates the matrix A, so that the norm of the i-th column
 is nearby the i-th row. (D,B)=Matrices.balance(A) returns a vector D, such
 that B=inv(diagonal(D))*A*diagonal(D) has better condition. The elements of D 
 are multiples of 2. Balancing attempts to make the norm of each row equal to the
 norm of the belonging column. <br>
 Balancing is used to minimize roundoff errors inducted
 through large matrix calculations like Taylor-series approximation
 or computation of eigenvalues.
 </p>
 <b>Example:</b><br><br>
 <pre>       - A = [1, 10,  1000; .01,  0,  10; .005,  .01,  10]
        - Matrices.norm(A, 1);
          = 1020.0
        - (T,B)=Matrices.balance(A)
        - T
          = {256, 16, 0.5}
        - B
          =  [1,     0.625,   1.953125;
              0.16,  0,       0.3125;
              2.56,  0.32,   10.0]
        - Matrices.norm(B, 1);
          = 12.265625
 </pre>
 <p>
 The Algorithm is taken from
 <dl>
 <dt>H. D. Joos, G. Grbel:
 <dd><b>RASP'91 Regulator Analysis and Synthesis Programs</b><br>
     DLR - Control Systems Group 1991
 </dl>
 which based on the balanc function from EISPACK.
 </p>
 <p><b>Release Notes:</b></p>
 <li><i>July 5, 2002</i>
        by H. D. Joos and Nico Walther<br>
        Implemented.
 </li>
 </HTML>
 "));
      algorithm 
        D:=ones(na);
        B:=A;
        while (noconv) loop
                  noconv:=false;
          for i in 1:na loop
                      CO:=sum(abs(B[:,i])) - abs(B[i,i]);
            RO:=sum(abs(B[i,:])) - abs(B[i,i]);
            G:=RO/radix;
            F:=1;
            S:=CO + RO;
            while (not (CO >= G or CO == 0)) loop
                          F:=F*radix;
              CO:=CO*radix2;
            end while;
            G:=RO*radix;
            while (not (CO < G or RO == 0)) loop
                          F:=F/radix;
              CO:=CO/radix2;
            end while;
            if not (CO + RO)/F >= 0.95*S then 
                        G:=1/F;
            D[i]:=D[i]*F;
            B[i,:]:=B[i,:]*G;
            B[:,i]:=B[:,i]*F;
            noconv:=true;
            else 
            end if;
          end for;
        end while;      end balance;
      function exp "Compute the exponential of a matrix by adaptive Taylor series expansion with scaling and balancing"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)];
        input Real T=1;
        output Real phi[size(A, 1),size(A, 1)] "= exp(A*T)";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<HTML>
 <p>This function computes</p>
 <pre>                            (<b>A</b>T)^2   (<b>A</b>T)^3 
      <font size=4> <b>&Phi;</b></font> = e^(<b>A</b>T) = <b>I</b> + <b>A</b>T + ------ + ------ + ....
                               2!       3!
 </pre>
 <p>where e=2.71828..., <b>A</b> is an n x n matrix with real elements and T is a real number, 
 e.g., the sampling time.
 <b>A</b> may be singular. With the exponential of a matrix it is, e.g., possible
 to compute the solution of a linear system of differential equations</p>
 <pre>    der(<b>x</b>) = <b>A</b>*<b>x</b>   ->   <b>x</b>(t0 + T) = e^(<b>A</b>T)*x(t0) 
 </pre>
 <p>
 The function is called as
 <pre>     Phi = Matrices.exp(A,T);</pre>
 or 
 <pre>       M = Matrices.exp(A);
 </pre>
 what calculates M as the exponential of matrix A.
 </p>
 <p><b>Algorithmic details:</b></p>
 <p>The algorithm is taken from </p>
 <dl>
 <dt>H. D. Joos, G. Gruebel:
 <dd><b>RASP'91 Regulator Analysis and Synthesis Programs</b><br>
     DLR - Control Systems Group 1991
 </dl>
 <p>The following steps are performed to calculate the exponential of A:</p>
 <ol>
   <li>Matrix <b>A</b> is balanced <br>
   (= is transformed with a diagonal matrix <b>D</b>, such that inv(<b>D</b>)*<b>A</b>*<b>D</b> 
   has a smaller condition as <b>A</b>).</li>
   <li>The scalar T is divided by a multiple of 2 such that norm(
        inv(<b>D</b>)*<b>A</b>*<b>D</b>*T/2^k ) &lt; 0.5. Note, that (1) and (2) are implemented such that no round-off errors 
   are introduced.</li>
   <li>The matrix from (2) is approximated by explicitly performing the Taylor 
   series expansion with a variable number of terms. 
   Truncation occurs if a new term does no longer contribute to the value of <b>&Phi;</b>
   from the previous iteration.</li>
   <li>The resulting matrix is transformed back, by reverting the steps of (2) 
   and (1).</li>
 </ol>
 <p>In several sources it is not recommended to use Taylor series expansion to 
 calculate the exponential of a matrix, such as in 'C.B. Moler and C.F. Van Loan: 
 Nineteen dubious ways to compute the exponential of a matrix. SIAM Review 20, 
 pp. 801-836, 1979' or in the documentation of m-file expm2 in Matlab version 6 
 (http://www.MathWorks.com) where it is stated that 'As a practical numerical 
 method, this is often slow and inaccurate'. These statements are valid for a 
 direct implementation of the Taylor series expansion, but <i>not</i> for the 
 implementation variant used in this function. 
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 5, 2002</i>
        by H. D. Joos and Nico Walther<br>
        Implemented.
 </li>
 </ul>
 </HTML>
 "));
      protected 
        parameter Integer nmax=21;
        parameter Integer na=size(A, 1);
        Integer j=1;
        Integer k=0;
        Boolean breakme=false;
        Real Anorm;
        Real Tscaled=1;
        Real Atransf[na,na];
        Real D[na,na];
        Real M[na,na];
        Real Diag[na];
        encapsulated function columnNorm "Returns the column norm of a matrix"
                  input Real A[:,:] "Input matrix";
          output Real result=0.0 "1-norm of matrix A";
        algorithm 
          for i in 1:size(A, 2) loop
                      result:=max(result, sum(abs(A[:,i])));

          end for;
        end columnNorm;
      algorithm 
        (Diag,Atransf) := balance(A);
        Tscaled:=T;
        Anorm:=columnNorm(Atransf);
        Anorm:=Anorm*T;
        while (Anorm >= 0.5) loop
                  Anorm:=Anorm/2;
          Tscaled:=Tscaled/2;
          k:=k + 1;
        end while;
        M:=identity(na);
        D:=M;
        while (j < nmax and not breakme) loop
                  M:=(Atransf*M*Tscaled)/j;
          if columnNorm(D + M - D) == 0 then 
                    breakme:=true;

          else           D:=M + D;
          j:=j + 1;
          end if;
        end while;
        for i in 1:k loop
                  D:=D*D;

        end for;
        for j in 1:na loop
                  for k in 1:na loop
                      phi[j,k]:=(D[j,k]*Diag[j])/Diag[k];

          end for;

        end for;      end exp;
      function integralExp "Computation of the transition-matrix phi and its integral gamma"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)];
        input Real B[size(A, 1),:];
        input Real T=1;
        output Real phi[size(A, 1),size(A, 1)] "= exp(A*T)";
        output Real gamma[size(A, 1),size(B, 2)] "= integral(phi)*B";
      protected 
        parameter Integer nmax=21;
        parameter Integer na=size(A, 1);
        Integer j=2;
        Integer k=0;
        Boolean breakme=false;
        Real Anorm;
        Real Tscaled=1;
        Real Atransf[na,na];
        Real Psi[na,na];
        Real M[na,na];
        Real Diag[na];
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<HTML>
 <p>
 The function uses a Taylor series expansion with Balancing and
 scaling/squaring to approximate the integral <b>&Psi;</b> of the matrix
 exponential <b>&Phi;</b>=e^(AT):
 </p>
 <pre>                                 AT^2   A^2 * T^3          A^k * T^(k+1)
         <b>&Psi;</b> = int(e^(As))ds = IT + ---- + --------- + ... + --------------
                                   2!        3!                (k+1)!
 </pre>
 <p>
 <b>&Phi;</b> is calculated through <b>&Phi;</b> = I + A*<b>&Psi;</b>, so A may be singular. <b>&Gamma;</b> is
 simple <b>&Psi;</b>*B.
 </p>
 <p>The algorithm runs in the following steps: </p>
 <ol>
   <li>Balancing</li>
   <li>Scaling</li>
   <li>Taylor series expansion</li>
   <li>Re-scaling</li>
   <li>Re-Balancing</li>
 </ol>
 <p>Balancing put the bad condition of a square matrix <i>A</i> into a diagonal
 transformation matrix <i>D</i>. This reduce the effort of following calculations.
 Afterwards the result have to be re-balanced by transformation D*A<small>transf</small>
  *inv(D).<br>
 Scaling halfen T&nbsp; k-times, until the norm of A*T is less than 0.5. This
 garantees minumum rounding errors in the following series
 expansion. The re-scaling based on the equation&nbsp; exp(A*2T) = exp(AT)^2.
 The needed re-scaling formula for psi thus becomes:</p>
 <pre>         <b>&Phi;</b> = <b>&Phi;</b>'*<b>&Phi;</b>'
    I + A*<b>&Psi;</b> = I + 2A*<b>&Psi;</b>' + A^2*<b>&Psi;</b>'^2
          <b>&Psi;</b> = A*<b>&Psi;</b>'^2 + 2*<b>&Psi;</b>'
 </pre>
 <p>
 where psi' is the scaled result from the series expansion while psi is the
 re-scaled matrix.
 </p>
 <p>
 The function is normally used to discretize a state-space system as the
 zero-order-hold equivalent:
 </p>
 <pre>      x(k+1) = <b>&Phi;</b>*x(k) + <b>&Gamma;</b>*u(k)
         y(k) = C*x(k) + D*u(k)
 </pre>
 <p>
 The zero-order-hold sampling, also known as step-invariant method, gives
 exact values of the state variables, under the assumption that the control
 signal u is constant between the sampling instants. Zero-order-hold sampling
 is discribed in
 </p>
 <dl>
 <dt>K. J. Astroem, B. Wittenmark:
 <dd><b>Computer Controlled Systems - Theory and Design</b><br>
     Third Edition, p. 32
 </dl>
 <pre><b>Syntax:</b>
       (phi,gamma) = Matrices.expIntegral(A,B,T)
                        A,phi: [n,n] square matrices
                      B,gamma: [n,m] input matrix
                            T: scalar, e.g. sampling time
 </pre>
 <p>
 The Algorithm to calculate psi is taken from
 <dl>
 <dt>H. D. Joos, G. Gruebel:
 <dd><b>RASP'91 Regulator Analysis and Synthesis Programs</b><br>
     DLR - Control Systems Group 1991
 </dl>
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 5, 2002</i>
        by H. D. Joos and Nico Walther<br>
        Implemented.
 </li>
 </ul>
 </HTML>
 "));
      algorithm 
        (Diag,Atransf) := balance(A);
        Tscaled:=T;
        Anorm:=norm(Atransf, 1);
        Anorm:=Anorm*T;
        while (Anorm >= 0.5) loop
                  Anorm:=Anorm/2;
          Tscaled:=Tscaled/2;
          k:=k + 1;
        end while;
        M:=identity(na)*Tscaled;
        Psi:=M;
        while (j < nmax and not breakme) loop
                  M:=(Atransf*M*Tscaled)/j;
          if norm(Psi + M - Psi, 1) == 0 then 
                    breakme:=true;

          else           Psi:=M + Psi;
          j:=j + 1;
          end if;
        end while;
        for j in 1:k loop
                  Psi:=Atransf*Psi*Psi + 2*Psi;

        end for;
        for j in 1:na loop
                  for k in 1:na loop
                      Psi[j,k]:=(Psi[j,k]*Diag[j])/Diag[k];

          end for;

        end for;
        gamma:=Psi*B;
        phi:=A*Psi + identity(na);      end integralExp;
      function integralExpT "Computation of the transition-matrix phi and the integral gamma and gamma1"
              extends Modelica.Icons.Function;
        input Real A[:,size(A, 1)];
        input Real B[size(A, 1),:];
        input Real T=1;
        output Real phi[size(A, 1),size(A, 1)] "= exp(A*T)";
        output Real gamma[size(A, 1),size(B, 2)] "= integral(phi)*B";
        output Real gamma1[size(A, 1),size(B, 2)] "= integral((T-t)*exp(A*t))*B";
      protected 
        Integer nmax=200;
        parameter Integer na=size(A, 1);
        parameter Integer nb=size(B, 2);
        Integer j=1;
        Boolean breakme=false;
        Real F[na + 2*nb,na + 2*nb];
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<HTML>
 <p>
 The function calculates the matrices phi,gamma,gamma1 through the equation:
 </p>
 <pre>                                 [ A B 0 ]
 [phi gamma gamma1] = [I 0 0]*exp([ 0 0 I ]*T)
                                  [ 0 0 0 ]
 </pre>
 <pre>
 <b>Syntax:</b><br>
       (phi,gamma,gamma1) = Matrices.ExpIntegral2(A,B,T)
                      A,phi: [n,n] square matrices
             B,gamma,gamma1: [n,m] matrices
                          T: scalar, e.g. sampling time
 </pre>
 <p>
 The matrices define the discretized first-order-hold equivalent of
 a state-space system:
 <pre>      x(k+1) = phi*x(k) + gamma*u(k) + gamma1/T*(u(k+1) - u(k))
 </pre>
 The first-order-hold sampling, also known as ramp-invariant method, gives
 more smooth control signals as the ZOH equivalent. First-order-hold sampling
 is discribed in
 <dl>
 <dt>K. J. Astroem, B. Wittenmark:
 <dd><b>Computer Controlled Systems - Theory and Design</b><br>
     Third Edition, p. 256
 </dl>
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 31, 2002</i>
        by Nico Walther<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));
      algorithm 
        F:=[A,B,zeros(na, nb);zeros(2*nb, na),zeros(2*nb, nb),[identity(nb);zeros(nb, nb)]];
        F:=exp(F, T);
        phi:=F[1:na,1:na];
        gamma:=F[1:na,na + 1:na + nb];
        gamma1:=F[1:na,na + nb + 1:na + 2*nb];      end integralExpT;
    protected 
      package LAPACK "Interface to LAPACK library"
              extends Modelica.Icons.Library;
        function dgeev "Compute eigenvalues and (right) eigenvectors for real nonsymmetrix matrix A"
                  extends Modelica.Icons.Function;
          input Real A[:,size(A, 1)];
          output Real eigenReal[size(A, 1)] "Real part of eigen values";
          output Real eigenImag[size(A, 1)] "Imaginary part of eigen values";
          output Real eigenVectors[size(A, 1),size(A, 1)] "Right eigen vectors";
          output Integer info;
        protected 
          Integer n=size(A, 1);
          Integer lwork=12*n;
          Real Awork[n,n]=A;
          Real work[lwork];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation
     Purpose   
     =======   
     DGEEV computes for an N-by-N real nonsymmetric matrix A, the   
     eigenvalues and, optionally, the left and/or right eigenvectors.   
     The right eigenvector v(j) of A satisfies   
                      A * v(j) = lambda(j) * v(j)   
     where lambda(j) is its eigenvalue.   
     The left eigenvector u(j) of A satisfies   
                   u(j)**H * A = lambda(j) * u(j)**H   
     where u(j)**H denotes the conjugate transpose of u(j).   
     The computed eigenvectors are normalized to have Euclidean norm   
     equal to 1 and largest component real.   
     Arguments   
     =========   
     JOBVL   (input) CHARACTER*1   
             = 'N': left eigenvectors of A are not computed;   
             = 'V': left eigenvectors of A are computed.   
     JOBVR   (input) CHARACTER*1   
             = 'N': right eigenvectors of A are not computed;   
             = 'V': right eigenvectors of A are computed.   
     N       (input) INTEGER   
             The order of the matrix A. N >= 0.   
     A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)   
             On entry, the N-by-N matrix A.   
             On exit, A has been overwritten.   
     LDA     (input) INTEGER   
             The leading dimension of the array A.  LDA >= max(1,N).   
     WR      (output) DOUBLE PRECISION array, dimension (N)   
     WI      (output) DOUBLE PRECISION array, dimension (N)   
             WR and WI contain the real and imaginary parts,   
             respectively, of the computed eigenvalues.  Complex   
             conjugate pairs of eigenvalues appear consecutively   
             with the eigenvalue having the positive imaginary part   
             first.   
     VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)   
             If JOBVL = 'V', the left eigenvectors u(j) are stored one   
             after another in the columns of VL, in the same order   
             as their eigenvalues.   
             If JOBVL = 'N', VL is not referenced.   
             If the j-th eigenvalue is real, then u(j) = VL(:,j),   
             the j-th column of VL.   
             If the j-th and (j+1)-st eigenvalues form a complex   
             conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and   
             u(j+1) = VL(:,j) - i*VL(:,j+1).   
     LDVL    (input) INTEGER   
             The leading dimension of the array VL.  LDVL >= 1; if   
             JOBVL = 'V', LDVL >= N.   
     VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)   
             If JOBVR = 'V', the right eigenvectors v(j) are stored one   
             after another in the columns of VR, in the same order   
             as their eigenvalues.   
             If JOBVR = 'N', VR is not referenced.   
             If the j-th eigenvalue is real, then v(j) = VR(:,j),   
             the j-th column of VR.   
             If the j-th and (j+1)-st eigenvalues form a complex   
             conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and   
             v(j+1) = VR(:,j) - i*VR(:,j+1).   
     LDVR    (input) INTEGER   
             The leading dimension of the array VR.  LDVR >= 1; if   
             JOBVR = 'V', LDVR >= N.   
     WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK) 
   
             On exit, if INFO = 0, WORK(1) returns the optimal LWORK.   
     LWORK   (input) INTEGER   
             The dimension of the array WORK.  LWORK >= max(1,3*N), and   
             if JOBVL = 'V' or JOBVR = 'V', LWORK >= 4*N.  For good   
             performance, LWORK must generally be larger.   
     INFO    (output) INTEGER   
             = 0:  successful exit   
             < 0:  if INFO = -i, the i-th argument had an illegal value.   
             > 0:  if INFO = i, the QR algorithm failed to compute all the 
                   eigenvalues, and no eigenvectors have been computed;   
                   elements i+1:N of WR and WI contain eigenvalues which   
                   have converged.   
 "));

          external "Fortran 77" dgeev("N","V",n,Awork,n,eigenReal,eigenImag,eigenVectors,n,eigenVectors,n,work,size(work, 1),info)           annotation(Library="Lapack");

        end dgeev;
        function dgeev_eigenValues "Compute eigenvalues for real nonsymmetrix matrix A"
                  extends Modelica.Icons.Function;
          input Real A[:,size(A, 1)];
          output Real EigenReal[size(A, 1)];
          output Real EigenImag[size(A, 1)];
          output Integer info;
        protected 
          Integer lwork=8*size(A, 1);
          Real Awork[size(A, 1),size(A, 1)]=A;
          Real work[lwork];
          Real EigenvectorsL[size(A, 1),size(A, 1)]=zeros(size(A, 1), size(A, 1));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation
     Purpose   
     =======   
     DGEEV computes for an N-by-N real nonsymmetric matrix A, the   
     eigenvalues and, optionally, the left and/or right eigenvectors.   
     The right eigenvector v(j) of A satisfies   
                      A * v(j) = lambda(j) * v(j)   
     where lambda(j) is its eigenvalue.   
     The left eigenvector u(j) of A satisfies   
                   u(j)**H * A = lambda(j) * u(j)**H   
     where u(j)**H denotes the conjugate transpose of u(j).   
     The computed eigenvectors are normalized to have Euclidean norm   
     equal to 1 and largest component real.   
     Arguments   
     =========   
     JOBVL   (input) CHARACTER*1   
             = 'N': left eigenvectors of A are not computed;   
             = 'V': left eigenvectors of A are computed.   
     JOBVR   (input) CHARACTER*1   
             = 'N': right eigenvectors of A are not computed;   
             = 'V': right eigenvectors of A are computed.   
     N       (input) INTEGER   
             The order of the matrix A. N >= 0.   
     A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)   
             On entry, the N-by-N matrix A.   
             On exit, A has been overwritten.   
     LDA     (input) INTEGER   
             The leading dimension of the array A.  LDA >= max(1,N).   
     WR      (output) DOUBLE PRECISION array, dimension (N)   
     WI      (output) DOUBLE PRECISION array, dimension (N)   
             WR and WI contain the real and imaginary parts,   
             respectively, of the computed eigenvalues.  Complex   
             conjugate pairs of eigenvalues appear consecutively   
             with the eigenvalue having the positive imaginary part   
             first.   
     VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)   
             If JOBVL = 'V', the left eigenvectors u(j) are stored one   
             after another in the columns of VL, in the same order   
             as their eigenvalues.   
             If JOBVL = 'N', VL is not referenced.   
             If the j-th eigenvalue is real, then u(j) = VL(:,j),   
             the j-th column of VL.   
             If the j-th and (j+1)-st eigenvalues form a complex   
             conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and   
             u(j+1) = VL(:,j) - i*VL(:,j+1).   
     LDVL    (input) INTEGER   
             The leading dimension of the array VL.  LDVL >= 1; if   
             JOBVL = 'V', LDVL >= N.   
     VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)   
             If JOBVR = 'V', the right eigenvectors v(j) are stored one   
             after another in the columns of VR, in the same order   
             as their eigenvalues.   
             If JOBVR = 'N', VR is not referenced.   
             If the j-th eigenvalue is real, then v(j) = VR(:,j),   
             the j-th column of VR.   
             If the j-th and (j+1)-st eigenvalues form a complex   
             conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and   
             v(j+1) = VR(:,j) - i*VR(:,j+1).   
     LDVR    (input) INTEGER   
             The leading dimension of the array VR.  LDVR >= 1; if   
             JOBVR = 'V', LDVR >= N.   
     WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK) 
   
             On exit, if INFO = 0, WORK(1) returns the optimal LWORK.   
     LWORK   (input) INTEGER   
             The dimension of the array WORK.  LWORK >= max(1,3*N), and   
             if JOBVL = 'V' or JOBVR = 'V', LWORK >= 4*N.  For good   
             performance, LWORK must generally be larger.   
     INFO    (output) INTEGER   
             = 0:  successful exit   
             < 0:  if INFO = -i, the i-th argument had an illegal value.   
             > 0:  if INFO = i, the QR algorithm failed to compute all the 
                   eigenvalues, and no eigenvectors have been computed;   
                   elements i+1:N of WR and WI contain eigenvalues which   
                   have converged.   
 "));

          external "Fortran 77" dgeev("N","N",size(A, 1),Awork,size(A, 1),EigenReal,EigenImag,EigenvectorsL,size(EigenvectorsL, 1),EigenvectorsL,size(EigenvectorsL, 1),work,size(work, 1),info)           annotation(Library="Lapack");

        end dgeev_eigenValues;
        function dgels_vec "Solves overdetermined or underdetermined real linear equations A*x=b with a b vector"
                  extends Modelica.Icons.Function;
          input Real A[:,:];
          input Real b[size(A, 1)];
          output Real x[nx]=cat(1, b, zeros(nx - nrow)) "solution is in first size(A,2) rows";
          output Integer info;
        protected 
          Integer nrow=size(A, 1);
          Integer ncol=size(A, 2);
          Integer nx=max(nrow, ncol);
          Integer lwork=min(nrow, ncol) + nx;
          Real work[lwork];
          Real Awork[nrow,ncol]=A;

          external "FORTRAN 77" dgels("N",nrow,ncol,1,Awork,nrow,x,nx,work,lwork,info)           annotation(Library="Lapack");
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation
   Purpose                                                                 
   =======                                                                 
                                                                           
   DGELS solves overdetermined or underdetermined real linear systems      
   involving an M-by-N matrix A, or its transpose, using a QR or LQ        
   factorization of A.  It is assumed that A has full rank.                
                                                                           
   The following options are provided:                                     
                                                                           
   1. If TRANS = 'N' and m >= n:  find the least squares solution of       
      an overdetermined system, i.e., solve the least squares problem      
                   minimize || B - A*X ||.                                 
                                                                           
   2. If TRANS = 'N' and m < n:  find the minimum norm solution of         
      an underdetermined system A * X = B.                                 
                                                                           
   3. If TRANS = 'T' and m >= n:  find the minimum norm solution of        
      an undetermined system A**T * X = B.                                 
                                                                           
   4. If TRANS = 'T' and m < n:  find the least squares solution of        
      an overdetermined system, i.e., solve the least squares problem      
                   minimize || B - A**T * X ||.                            
                                                                           
   Several right hand side vectors b and solution vectors x can be         
   handled in a single call; they are stored as the columns of the         
   M-by-NRHS right hand side matrix B and the N-by-NRHS solution           
   matrix X.                                                               
                                                                           
   Arguments                                                               
   =========                                                               
                                                                           
   TRANS   (input) CHARACTER                                               
           = 'N': the linear system involves A;                            
           = 'T': the linear system involves A**T.                         
                                                                           
   M       (input) INTEGER                                                 
           The number of rows of the matrix A.  M >= 0.                    
                                                                           
   N       (input) INTEGER                                                 
           The number of columns of the matrix A.  N >= 0.                 
                                                                           
   NRHS    (input) INTEGER                                                 
           The number of right hand sides, i.e., the number of             
           columns of the matrices B and X. NRHS >=0.                      
                                                                           
   A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)        
           On entry, the M-by-N matrix A.                                  
           On exit,                                                        
             if M >= N, A is overwritten by details of its QR              
                        factorization as returned by DGEQRF;               
             if M <  N, A is overwritten by details of its LQ              
                        factorization as returned by DGELQF.               
                                                                           
   LDA     (input) INTEGER                                                 
           The leading dimension of the array A.  LDA >= max(1,M).         
                                                                           
   B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)     
           On entry, the matrix B of right hand side vectors, stored       
           columnwise; B is M-by-NRHS if TRANS = 'N', or N-by-NRHS         
           if TRANS = 'T'.                                                 
           On exit, B is overwritten by the solution vectors, stored       
           columnwise:  if TRANS = 'N' and m >= n, rows 1 to n of B        
           contain the least squares solution vectors; the residual        
           sum of squares for the solution in each column is given by      
           the sum of squares of elements N+1 to M in that column;         
           if TRANS = 'N' and m < n, rows 1 to N of B contain the          
           minimum norm solution vectors;                                  
           if TRANS = 'T' and m >= n, rows 1 to M of B contain the         
           minimum norm solution vectors;                                  
           if TRANS = 'T' and m < n, rows 1 to M of B contain the          
           least squares solution vectors; the residual sum of squares     
           for the solution in each column is given by the sum of          
           squares of elements M+1 to N in that column.                    
                                                                           
   LDB     (input) INTEGER                                                 
           The leading dimension of the array B. LDB >= MAX(1,M,N).        
                                                                           
   WORK    (workspace) DOUBLE PRECISION array, dimension (LWORK)           
           On exit, if INFO = 0, WORK(1) returns the optimal LWORK.        
                                                                           
   LWORK   (input) INTEGER                                                 
           The dimension of the array WORK.                                
           LWORK >= min(M,N) + MAX(1,M,N,NRHS).                            
           For optimal performance,                                        
           LWORK >= min(M,N) + MAX(1,M,N,NRHS) * NB                        
           where NB is the optimum block size.                             
                                                                           
   INFO    (output) INTEGER                                                
           = 0:  successful exit                                           
           < 0:  if INFO = -i, the i-th argument had an illegal value      
                                                                           "));
        end dgels_vec;
        function dgelsx_vec "Computes the minimum-norm solution to a real linear least squares problem with singular A (not yet tested)"
                  extends Modelica.Icons.Function;
          input Real A[:,:];
          input Real b[size(A, 1)];
          input Real rcond=0.0 "Reciprocal condition number to estimate rank";
          output Real x[nx]=cat(1, b, zeros(nx - nrow)) "solution is in first size(A,2) rows";
          output Integer info;
          output Real rank "Effective rank of A";
        protected 
          Integer nrow=size(A, 1);
          Integer ncol=size(A, 2);
          Integer nx=max(nrow, ncol);
          Integer lwork=max(min(nrow, ncol) + 3*ncol, 2*min(nrow, ncol) + 1);
          Real work[lwork];
          Real Awork[nrow,ncol]=A;
          Integer jpvt[ncol]=zeros(ncol);

          external "FORTRAN 77" dgelsx(nrow,ncol,1,Awork,nrow,x,nx,rcond,rank,work,lwork,info)           annotation(Library="Lapack");
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation
   Purpose                                                               
   =======                                                               
                                                                         
   DGELSX computes the minimum-norm solution to a real linear least      
   squares problem:                                                      
       minimize || A * X - B ||                                          
   using a complete orthogonal factorization of A.  A is an M-by-N       
   matrix which may be rank-deficient.                                   
                                                                         
   Several right hand side vectors b and solution vectors x can be       
   handled in a single call; they are stored as the columns of the       
   M-by-NRHS right hand side matrix B and the N-by-NRHS solution         
   matrix X.                                                             
                                                                         
   The routine first computes a QR factorization with column pivoting:   
       A * P = Q * [ R11 R12 ]                                           
                   [  0  R22 ]                                           
   with R11 defined as the largest leading submatrix whose estimated     
   condition number is less than 1/RCOND.  The order of R11, RANK,       
   is the effective rank of A.                                           
                                                                         
   Then, R22 is considered to be negligible, and R12 is annihilated      
   by orthogonal transformations from the right, arriving at the         
   complete orthogonal factorization:                                    
      A * P = Q * [ T11 0 ] * Z                                          
                  [  0  0 ]                                              
   The minimum-norm solution is then                                     
      X = P * Z' [ inv(T11)*Q1'*B ]                                      
                 [        0       ]                                      
   where Q1 consists of the first RANK columns of Q.                     
                                                                         
   Arguments                                                             
   =========                                                             
                                                                         
   M       (input) INTEGER                                               
           The number of rows of the matrix A.  M >= 0.                  
                                                                         
   N       (input) INTEGER                                               
           The number of columns of the matrix A.  N >= 0.               
                                                                         
   NRHS    (input) INTEGER                                               
           The number of right hand sides, i.e., the number of           
           columns of matrices B and X. NRHS >= 0.                       
                                                                         
   A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)      
           On entry, the M-by-N matrix A.                                
           On exit, A has been overwritten by details of its             
           complete orthogonal factorization.                            
                                                                         
   LDA     (input) INTEGER                                               
           The leading dimension of the array A.  LDA >= max(1,M).       
                                                                         
   B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)   
           On entry, the M-by-NRHS right hand side matrix B.             
           On exit, the N-by-NRHS solution matrix X.                     
           If m >= n and RANK = n, the residual sum-of-squares for       
           the solution in the i-th column is given by the sum of        
           squares of elements N+1:M in that column.                     
                                                                         
   LDB     (input) INTEGER                                               
           The leading dimension of the array B. LDB >= max(1,M,N).      
                                                                         
   JPVT    (input/output) INTEGER array, dimension (N)                   
           On entry, if JPVT(i) .ne. 0, the i-th column of A is an       
           initial column, otherwise it is a free column.  Before        
           the QR factorization of A, all initial columns are            
           permuted to the leading positions; only the remaining         
           free columns are moved as a result of column pivoting         
           during the factorization.                                     
           On exit, if JPVT(i) = k, then the i-th column of A*P          
           was the k-th column of A.                                     
                                                                         
   RCOND   (input) DOUBLE PRECISION                                      
           RCOND is used to determine the effective rank of A, which     
           is defined as the order of the largest leading triangular     
           submatrix R11 in the QR factorization with pivoting of A,     
           whose estimated condition number < 1/RCOND.                   
                                                                         
   RANK    (output) INTEGER                                              
           The effective rank of A, i.e., the order of the submatrix     
           R11.  This is the same as the order of the submatrix T11      
           in the complete orthogonal factorization of A.                
                                                                         
   WORK    (workspace) DOUBLE PRECISION array, dimension                 
                       (max( min(M,N)+3*N, 2*min(M,N)+NRHS )),           
                                                                         
   INFO    (output) INTEGER                                              
           = 0:  successful exit                                         
           < 0:  if INFO = -i, the i-th argument had an illegal value    "));
        end dgelsx_vec;
        function dgesv "Solve real system of linear equations A*X=B with a B matrix"
                  extends Modelica.Icons.Function;
          input Real A[:,size(A, 1)];
          input Real B[size(A, 1),:];
          output Real X[size(A, 1),size(B, 2)]=B;
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 1)]=A;
          Integer ipiv[size(A, 1)];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
     Purpose   
     =======   
     DGESV computes the solution to a real system of linear equations   
        A * X = B,   
     where A is an N-by-N matrix and X and B are N-by-NRHS matrices.   
     The LU decomposition with partial pivoting and row interchanges is   
     used to factor A as   
        A = P * L * U,   
     where P is a permutation matrix, L is unit lower triangular, and U is 
   
     upper triangular.  The factored form of A is then used to solve the   
     system of equations A * X = B.   
     Arguments   
     =========   
     N       (input) INTEGER   
             The number of linear equations, i.e., the order of the   
             matrix A.  N >= 0.   
     NRHS    (input) INTEGER   
             The number of right hand sides, i.e., the number of columns   
             of the matrix B.  NRHS >= 0.   
     A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)   
             On entry, the N-by-N coefficient matrix A.   
             On exit, the factors L and U from the factorization   
             A = P*L*U; the unit diagonal elements of L are not stored.   
     LDA     (input) INTEGER   
             The leading dimension of the array A.  LDA >= max(1,N).   
     IPIV    (output) INTEGER array, dimension (N)   
             The pivot indices that define the permutation matrix P;   
             row i of the matrix was interchanged with row IPIV(i).   
     B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)   
             On entry, the N-by-NRHS matrix of right hand side matrix B.   
             On exit, if INFO = 0, the N-by-NRHS solution matrix X.   
     LDB     (input) INTEGER   
             The leading dimension of the array B.  LDB >= max(1,N).   
     INFO    (output) INTEGER   
             = 0:  successful exit   
             < 0:  if INFO = -i, the i-th argument had an illegal value   
             > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization 
   
                   has been completed, but the factor U is exactly   
                   singular, so the solution could not be computed.   
 "));

          external "FORTRAN 77" dgesv(size(A, 1),size(B, 2),Awork,size(A, 1),ipiv,X,size(A, 1),info)           annotation(Library="Lapack");

        end dgesv;
        function dgesv_vec "Solve real system of linear equations A*x=b with a b vector"
                  extends Modelica.Icons.Function;
          input Real A[:,size(A, 1)];
          input Real b[size(A, 1)];
          output Real x[size(A, 1)]=b;
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 1)]=A;
          Integer ipiv[size(A, 1)];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 Same as function LAPACK.dgesv, but right hand side is a vector and not a matrix.
 For details of the arguments, see documentation of dgesv.
 "));

          external "FORTRAN 77" dgesv(size(A, 1),1,Awork,size(A, 1),ipiv,x,size(A, 1),info)           annotation(Library="Lapack");

        end dgesv_vec;
        function dgesvx "Solve real system of linear equations A*X=B with a B matrix, error bounds and condition estimate"
                  extends Modelica.Icons.Function;
          input Real A[:,size(A, 1)];
          input Real B[size(A, 1),:];
          output Real X[size(A, 1),size(B, 2)]=zeros(size(B, 1), size(B, 2));
          output Real RCond;
          output Real FErrBound;
          output Real BErrBound;
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 2)]=A;
          Real Bwork[size(B, 1),size(B, 2)]=B;
          Real AF[size(A, 1),size(A, 2)];
          Integer ipiv[size(A, 1)];
          String equed=StringAllocate(1);
          Real R[size(A, 1)];
          Real C[size(A, 1)];
          Real work[4*size(A, 1)];
          Integer iwork[size(A, 1)];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
     Purpose   
     =======   
     DGESVX uses the LU factorization to compute the solution to a real   
     system of linear equations   
        A * X = B,   
     where A is an N-by-N matrix and X and B are N-by-NRHS matrices.   
     Error bounds on the solution and a condition estimate are also   
     provided.   
     Description   
     ===========   
     The following steps are performed:   
     1. If FACT = 'E', real scaling factors are computed to equilibrate   
        the system:   
           TRANS = 'N':  diag(R)*A*diag(C)     *inv(diag(C))*X = diag(R)*B 
   
           TRANS = 'T': (diag(R)*A*diag(C))**T *inv(diag(R))*X = diag(C)*B 
   
           TRANS = 'C': (diag(R)*A*diag(C))**H *inv(diag(R))*X = diag(C)*B 
   
        Whether or not the system will be equilibrated depends on the   
        scaling of the matrix A, but if equilibration is used, A is   
        overwritten by diag(R)*A*diag(C) and B by diag(R)*B (if TRANS='N') 
   
        or diag(C)*B (if TRANS = 'T' or 'C').   
     2. If FACT = 'N' or 'E', the LU decomposition is used to factor the   
        matrix A (after equilibration if FACT = 'E') as   
           A = P * L * U,   
        where P is a permutation matrix, L is a unit lower triangular   
        matrix, and U is upper triangular.   
     3. The factored form of A is used to estimate the condition number   
        of the matrix A.  If the reciprocal of the condition number is   
        less than machine precision, steps 4-6 are skipped.   
     4. The system of equations is solved for X using the factored form   
        of A.   
     5. Iterative refinement is applied to improve the computed solution   
        matrix and calculate error bounds and backward error estimates   
        for it.   
     6. If equilibration was used, the matrix X is premultiplied by   
        diag(C) (if TRANS = 'N') or diag(R) (if TRANS = 'T' or 'C') so   
        that it solves the original system before equilibration.   
     Arguments   
     =========   
     FACT    (input) CHARACTER*1   
             Specifies whether or not the factored form of the matrix A is 
   
             supplied on entry, and if not, whether the matrix A should be 
   
             equilibrated before it is factored.   
             = 'F':  On entry, AF and IPIV contain the factored form of A. 
   
                     If EQUED is not 'N', the matrix A has been   
                     equilibrated with scaling factors given by R and C.   
                     A, AF, and IPIV are not modified.   
             = 'N':  The matrix A will be copied to AF and factored.   
             = 'E':  The matrix A will be equilibrated if necessary, then 
   
                     copied to AF and factored.   
     TRANS   (input) CHARACTER*1   
             Specifies the form of the system of equations:   
             = 'N':  A * X = B     (No transpose)   
             = 'T':  A**T * X = B  (Transpose)   
             = 'C':  A**H * X = B  (Transpose)   
     N       (input) INTEGER   
             The number of linear equations, i.e., the order of the   
             matrix A.  N >= 0.   
     NRHS    (input) INTEGER   
             The number of right hand sides, i.e., the number of columns   
             of the matrices B and X.  NRHS >= 0.   
     A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)   
             On entry, the N-by-N matrix A.  If FACT = 'F' and EQUED is   
             not 'N', then A must have been equilibrated by the scaling   
             factors in R and/or C.  A is not modified if FACT = 'F' or   
             'N', or if FACT = 'E' and EQUED = 'N' on exit.   
             On exit, if EQUED .ne. 'N', A is scaled as follows:   
             EQUED = 'R':  A := diag(R) * A   
             EQUED = 'C':  A := A * diag(C)   
             EQUED = 'B':  A := diag(R) * A * diag(C).   
     LDA     (input) INTEGER   
             The leading dimension of the array A.  LDA >= max(1,N).   
     AF      (input or output) DOUBLE PRECISION array, dimension (LDAF,N) 
   
             If FACT = 'F', then AF is an input argument and on entry   
             contains the factors L and U from the factorization   
             A = P*L*U as computed by DGETRF.  If EQUED .ne. 'N', then   
             AF is the factored form of the equilibrated matrix A.   
             If FACT = 'N', then AF is an output argument and on exit   
             returns the factors L and U from the factorization A = P*L*U 
   
             of the original matrix A.   
             If FACT = 'E', then AF is an output argument and on exit   
             returns the factors L and U from the factorization A = P*L*U 
   
             of the equilibrated matrix A (see the description of A for   
             the form of the equilibrated matrix).   
     LDAF    (input) INTEGER   
             The leading dimension of the array AF.  LDAF >= max(1,N).   
     IPIV    (input or output) INTEGER array, dimension (N)   
             If FACT = 'F', then IPIV is an input argument and on entry   
             contains the pivot indices from the factorization A = P*L*U   
             as computed by DGETRF; row i of the matrix was interchanged   
             with row IPIV(i).   
             If FACT = 'N', then IPIV is an output argument and on exit   
             contains the pivot indices from the factorization A = P*L*U   
             of the original matrix A.   
             If FACT = 'E', then IPIV is an output argument and on exit   
             contains the pivot indices from the factorization A = P*L*U   
             of the equilibrated matrix A.   
     EQUED   (input or output) CHARACTER*1   
             Specifies the form of equilibration that was done.   
             = 'N':  No equilibration (always true if FACT = 'N').   
             = 'R':  Row equilibration, i.e., A has been premultiplied by 
   
                     diag(R).   
             = 'C':  Column equilibration, i.e., A has been postmultiplied 
   
                     by diag(C).   
             = 'B':  Both row and column equilibration, i.e., A has been   
                     replaced by diag(R) * A * diag(C).   
             EQUED is an input argument if FACT = 'F'; otherwise, it is an 
   
             output argument.   
     R       (input or output) DOUBLE PRECISION array, dimension (N)   
             The row scale factors for A.  If EQUED = 'R' or 'B', A is   
             multiplied on the left by diag(R); if EQUED = 'N' or 'C', R   
             is not accessed.  R is an input argument if FACT = 'F';   
             otherwise, R is an output argument.  If FACT = 'F' and   
             EQUED = 'R' or 'B', each element of R must be positive.   
     C       (input or output) DOUBLE PRECISION array, dimension (N)   
             The column scale factors for A.  If EQUED = 'C' or 'B', A is 
   
             multiplied on the right by diag(C); if EQUED = 'N' or 'R', C 
   
             is not accessed.  C is an input argument if FACT = 'F';   
             otherwise, C is an output argument.  If FACT = 'F' and   
             EQUED = 'C' or 'B', each element of C must be positive.   
     B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)   
             On entry, the N-by-NRHS right hand side matrix B.   
             On exit,   
             if EQUED = 'N', B is not modified;   
             if TRANS = 'N' and EQUED = 'R' or 'B', B is overwritten by   
             diag(R)*B;   
             if TRANS = 'T' or 'C' and EQUED = 'C' or 'B', B is   
             overwritten by diag(C)*B.   
     LDB     (input) INTEGER   
             The leading dimension of the array B.  LDB >= max(1,N).   
     X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)   
             If INFO = 0, the N-by-NRHS solution matrix X to the original 
   
             system of equations.  Note that A and B are modified on exit 
   
             if EQUED .ne. 'N', and the solution to the equilibrated   
             system is inv(diag(C))*X if TRANS = 'N' and EQUED = 'C' or   
             'B', or inv(diag(R))*X if TRANS = 'T' or 'C' and EQUED = 'R' 
   
             or 'B'.   
     LDX     (input) INTEGER   
             The leading dimension of the array X.  LDX >= max(1,N).   
     RCOND   (output) DOUBLE PRECISION   
             The estimate of the reciprocal condition number of the matrix 
   
             A after equilibration (if done).  If RCOND is less than the   
             machine precision (in particular, if RCOND = 0), the matrix   
             is singular to working precision.  This condition is   
             indicated by a return code of INFO > 0, and the solution and 
   
             error bounds are not computed.   
     FERR    (output) DOUBLE PRECISION array, dimension (NRHS)   
             The estimated forward error bound for each solution vector   
             X(j) (the j-th column of the solution matrix X).   
             If XTRUE is the true solution corresponding to X(j), FERR(j) 
   
             is an estimated upper bound for the magnitude of the largest 
   
             element in (X(j) - XTRUE) divided by the magnitude of the   
             largest element in X(j).  The estimate is as reliable as   
             the estimate for RCOND, and is almost always a slight   
             overestimate of the true error.   
     BERR    (output) DOUBLE PRECISION array, dimension (NRHS)   
             The componentwise relative backward error of each solution   
             vector X(j) (i.e., the smallest relative change in   
             any element of A or B that makes X(j) an exact solution).   
     WORK    (workspace/output) DOUBLE PRECISION array, dimension (4*N)   
             On exit, WORK(1) contains the reciprocal pivot growth   
             factor norm(A)/norm(U). The \"max absolute element\" norm is   
             used. If WORK(1) is much less than 1, then the stability   
             of the LU factorization of the (equilibrated) matrix A   
             could be poor. This also means that the solution X, condition 
   
             estimator RCOND, and forward error bound FERR could be   
             unreliable. If factorization fails with 0<INFO<=N, then   
             WORK(1) contains the reciprocal pivot growth factor for the   
             leading INFO columns of A.   
     IWORK   (workspace) INTEGER array, dimension (N)   
     INFO    (output) INTEGER   
             = 0:  successful exit   
             < 0:  if INFO = -i, the i-th argument had an illegal value   
             > 0:  if INFO = i, and i is   
                   <= N:  U(i,i) is exactly zero.  The factorization has   
                          been completed, but the factor U is exactly   
                          singular, so the solution and error bounds   
                          could not be computed.   
                   = N+1: RCOND is less than machine precision.  The   
                          factorization has been completed, but the   
                          matrix is singular to working precision, and   
                          the solution and error bounds have not been   
                          computed.   
 "));

          external "FORTRAN 77" dgesvx("E","N",size(A, 1),size(B, 2),Awork,size(A, 1),AF,size(A, 1),ipiv,equed,R,C,Bwork,size(B, 1),X,size(X, 1),RCond,FErrBound,BErrBound,work,iwork,info)           annotation(Library="Lapack");

        end dgesvx;
        function dgesvx_vec "Solve real system of linear equations A*x=b with a b vector, error bounds and condition estimate"
                  extends Modelica.Icons.Function;
          input Real A[:,size(A, 1)];
          input Real b[size(A, 1)];
          output Real x[size(A, 1)]=zeros(size(A, 1));
          output Real RCond;
          output Real FErrBound;
          output Real BErrBound;
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 2)]=A;
          Real Bwork[size(A, 1)]=b;
          Real AF[size(A, 1),size(A, 2)];
          Integer ipiv[size(A, 1)];
          String equed=StringAllocate(1);
          Real R[size(A, 1)];
          Real C[size(A, 1)];
          Real work[4*size(A, 1)];
          Integer iwork[size(A, 1)];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 Same as function LAPACK.dgesvx, but right hand side is a vector and not a matrix.
 For details of the arguments, see documentation of dgesvx.
 "));

          external "FORTRAN 77" dgesvx("E","N",size(A, 1),1,Awork,size(A, 1),AF,size(A, 1),ipiv,equed,R,C,Bwork,size(b, 1),x,size(x, 1),RCond,FErrBound,BErrBound,work,iwork,info)           annotation(Library="Lapack");

        end dgesvx_vec;
        function dgtsv "Solve real system of linear equations A*X=B with B matrix and tridiagonal A"
                  extends Modelica.Icons.Function;
          input Real superdiag[:];
          input Real diag[size(superdiag, 1) + 1];
          input Real subdiag[size(superdiag, 1)];
          input Real B[size(diag, 1),:];
          output Real X[size(B, 1),size(B, 2)]=B;
          output Integer info;
        protected 
          Real superdiagwork[size(superdiag, 1)]=superdiag;
          Real diagwork[size(diag, 1)]=diag;
          Real subdiagwork[size(subdiag, 1)]=subdiag;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
     Purpose   
     =======   
     DGTSV  solves the equation   
        A*X = B,   
     where A is an N-by-N tridiagonal matrix, by Gaussian elimination with 
   
     partial pivoting.   
     Note that the equation  A'*X = B  may be solved by interchanging the 
   
     order of the arguments DU and DL.   
     Arguments   
     =========   
     N       (input) INTEGER   
             The order of the matrix A.  N >= 0.   
     NRHS    (input) INTEGER   
             The number of right hand sides, i.e., the number of columns   
             of the matrix B.  NRHS >= 0.   
     DL      (input/output) DOUBLE PRECISION array, dimension (N-1)   
             On entry, DL must contain the (n-1) subdiagonal elements of   
             A.   
             On exit, DL is overwritten by the (n-2) elements of the   
             second superdiagonal of the upper triangular matrix U from   
             the LU factorization of A, in DL(1), ..., DL(n-2).   
     D       (input/output) DOUBLE PRECISION array, dimension (N)   
             On entry, D must contain the diagonal elements of A.   
             On exit, D is overwritten by the n diagonal elements of U.   
     DU      (input/output) DOUBLE PRECISION array, dimension (N-1)   
             On entry, DU must contain the (n-1) superdiagonal elements   
             of A.   
             On exit, DU is overwritten by the (n-1) elements of the first 
   
             superdiagonal of U.   
     B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)   
             On entry, the N-by-NRHS right hand side matrix B.   
             On exit, if INFO = 0, the N-by-NRHS solution matrix X.   
     LDB     (input) INTEGER   
             The leading dimension of the array B.  LDB >= max(1,N).   
     INFO    (output) INTEGER   
             = 0:  successful exit   
             < 0:  if INFO = -i, the i-th argument had an illegal value   
             > 0:  if INFO = i, U(i,i) is exactly zero, and the solution   
                   has not been computed.  The factorization has not been 
   
                   completed unless i = N.   
 "));

          external "FORTRAN 77" dgtsv(size(diag, 1),size(B, 2),subdiagwork,diagwork,superdiagwork,X,size(B, 1),info)           annotation(Library="Lapack");

        end dgtsv;
        function dgtsv_vec "Solve real system of linear equations A*x=b with b vector and tridiagonal A"
                  extends Modelica.Icons.Function;
          input Real superdiag[:];
          input Real diag[size(superdiag, 1) + 1];
          input Real subdiag[size(superdiag, 1)];
          input Real b[size(diag, 1)];
          output Real x[size(b, 1)]=b;
          output Integer info;
        protected 
          Real superdiagwork[size(superdiag, 1)]=superdiag;
          Real diagwork[size(diag, 1)]=diag;
          Real subdiagwork[size(subdiag, 1)]=subdiag;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 Same as function LAPACK.dgtsv, but right hand side is a vector and not a matrix.
 For details of the arguments, see documentation of dgtsv.
 "));

          external "FORTRAN 77" dgtsv(size(diag, 1),1,subdiagwork,diagwork,superdiagwork,x,size(b, 1),info)           annotation(Library="Lapack");

        end dgtsv_vec;
        function dgbsv "Solve real system of linear equations A*X=B with a B matrix"
                  extends Modelica.Icons.Function;
          input Integer n "Number of equations";
          input Integer kLower "Number of lower bands";
          input Integer kUpper "Number of upper bands";
          input Real A[2*kLower + kUpper + 1,n];
          input Real B[n,:];
          output Real X[n,size(B, 2)]=B;
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 2)]=A;
          Integer ipiv[n];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:  
 Purpose
 =======
 DGBSV computes the solution to a real system of linear equations
 A * X = B, where A is a band matrix of order N with KL subdiagonals
 and KU superdiagonals, and X and B are N-by-NRHS matrices.
 The LU decomposition with partial pivoting and row interchanges is
 used to factor A as A = L * U, where L is a product of permutation
 and unit lower triangular matrices with KL subdiagonals, and U is
 upper triangular with KL+KU superdiagonals.  The factored form of A
 is then used to solve the system of equations A * X = B.
 Arguments
 =========
 N       (input) INTEGER
         The number of linear equations, i.e., the order of the
         matrix A.  N >= 0.
 KL      (input) INTEGER
         The number of subdiagonals within the band of A.  KL >= 0.
 KU      (input) INTEGER
         The number of superdiagonals within the band of A.  KU >= 0.
 NRHS    (input) INTEGER
         The number of right hand sides, i.e., the number of columns
         of the matrix B.  NRHS >= 0.
 AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
         On entry, the matrix A in band storage, in rows KL+1 to
         2*KL+KU+1; rows 1 to KL of the array need not be set.
         The j-th column of A is stored in the j-th column of the
         array AB as follows:
         AB(KL+KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+KL)
         On exit, details of the factorization: U is stored as an
         upper triangular band matrix with KL+KU superdiagonals in
         rows 1 to KL+KU+1, and the multipliers used during the
         factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
         See below for further details.
 LDAB    (input) INTEGER
         The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.
 IPIV    (output) INTEGER array, dimension (N)
         The pivot indices that define the permutation matrix P;
         row i of the matrix was interchanged with row IPIV(i).
 B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
         On entry, the N-by-NRHS right hand side matrix B.
         On exit, if INFO = 0, the N-by-NRHS solution matrix X.
 LDB     (input) INTEGER
         The leading dimension of the array B.  LDB >= max(1,N).
 INFO    (output) INTEGER
         = 0:  successful exit
         < 0:  if INFO = -i, the i-th argument had an illegal value
         > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization
               has been completed, but the factor U is exactly
               singular, and the solution has not been computed.
 Further Details
 ===============
 The band storage scheme is illustrated by the following example, when
 M = N = 6, KL = 2, KU = 1:
 On entry:                       On exit:
     *    *    *    +    +    +       *    *    *   u14  u25  u36
     *    *    +    +    +    +       *    *   u13  u24  u35  u46
     *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
    a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
    a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
    a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *
 Array elements marked * are not used by the routine; elements marked
 + need not be set on entry, but are required by the routine to store
 elements of U because of fill-in resulting from the row interchanges."));

          external "FORTRAN 77" dgbsv(n,kLower,kUpper,size(B, 2),Awork,size(Awork, 1),ipiv,X,n,info)           annotation(Library="Lapack");

        end dgbsv;
        function dgbsv_vec "Solve real system of linear equations A*x=b with a b vector"
                  extends Modelica.Icons.Function;
          input Integer n "Number of equations";
          input Integer kLower "Number of lower bands";
          input Integer kUpper "Number of upper bands";
          input Real A[2*kLower + kUpper + 1,n];
          input Real b[n];
          output Real x[n]=b;
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 2)]=A;
          Integer ipiv[n];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:  
 "));

          external "FORTRAN 77" dgbsv(n,kLower,kUpper,1,Awork,size(Awork, 1),ipiv,x,n,info)           annotation(Library="Lapack");

        end dgbsv_vec;
        function dgesvd "Determine singular value decomposition"
                  extends Modelica.Icons.Function;
          input Real A[:,:];
          output Real sigma[min(size(A, 1), size(A, 2))];
          output Real U[size(A, 1),size(A, 1)]=zeros(size(A, 1), size(A, 1));
          output Real VT[size(A, 2),size(A, 2)]=zeros(size(A, 2), size(A, 2));
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 2)]=A;
          Integer lwork=5*size(A, 1) + 5*size(A, 2);
          Real work[lwork];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
     Purpose   
     =======   
     DGESVD computes the singular value decomposition (SVD) of a real   
     M-by-N matrix A, optionally computing the left and/or right singular 
   
     vectors. The SVD is written   
          A = U * SIGMA * transpose(V)   
     where SIGMA is an M-by-N matrix which is zero except for its   
     min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and   
     V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA   
     are the singular values of A; they are real and non-negative, and   
     are returned in descending order.  The first min(m,n) columns of   
     U and V are the left and right singular vectors of A.   
     Note that the routine returns V**T, not V.   
     Arguments   
     =========   
     JOBU    (input) CHARACTER*1   
             Specifies options for computing all or part of the matrix U: 
   
             = 'A':  all M columns of U are returned in array U:   
             = 'S':  the first min(m,n) columns of U (the left singular   
                     vectors) are returned in the array U;   
             = 'O':  the first min(m,n) columns of U (the left singular   
                     vectors) are overwritten on the array A;   
             = 'N':  no columns of U (no left singular vectors) are   
                     computed.   
     JOBVT   (input) CHARACTER*1   
             Specifies options for computing all or part of the matrix   
             V**T:   
             = 'A':  all N rows of V**T are returned in the array VT;   
             = 'S':  the first min(m,n) rows of V**T (the right singular   
                     vectors) are returned in the array VT;   
             = 'O':  the first min(m,n) rows of V**T (the right singular   
                     vectors) are overwritten on the array A;   
             = 'N':  no rows of V**T (no right singular vectors) are   
                     computed.   
             JOBVT and JOBU cannot both be 'O'.   
     M       (input) INTEGER   
             The number of rows of the input matrix A.  M >= 0.   
     N       (input) INTEGER   
             The number of columns of the input matrix A.  N >= 0.   
     A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)   
             On entry, the M-by-N matrix A.   
             On exit,   
             if JOBU = 'O',  A is overwritten with the first min(m,n)   
                             columns of U (the left singular vectors,   
                             stored columnwise);   
             if JOBVT = 'O', A is overwritten with the first min(m,n)   
                             rows of V**T (the right singular vectors,   
                             stored rowwise);   
             if JOBU .ne. 'O' and JOBVT .ne. 'O', the contents of A   
                             are destroyed.   
     LDA     (input) INTEGER   
             The leading dimension of the array A.  LDA >= max(1,M).   
     S       (output) DOUBLE PRECISION array, dimension (min(M,N))   
             The singular values of A, sorted so that S(i) >= S(i+1).   
     U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)   
             (LDU,M) if JOBU = 'A' or (LDU,min(M,N)) if JOBU = 'S'.   
             If JOBU = 'A', U contains the M-by-M orthogonal matrix U;   
             if JOBU = 'S', U contains the first min(m,n) columns of U   
             (the left singular vectors, stored columnwise);   
             if JOBU = 'N' or 'O', U is not referenced.   
     LDU     (input) INTEGER   
             The leading dimension of the array U.  LDU >= 1; if   
             JOBU = 'S' or 'A', LDU >= M.   
     VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)   
             If JOBVT = 'A', VT contains the N-by-N orthogonal matrix   
             V**T;   
             if JOBVT = 'S', VT contains the first min(m,n) rows of   
             V**T (the right singular vectors, stored rowwise);   
             if JOBVT = 'N' or 'O', VT is not referenced.   
     LDVT    (input) INTEGER   
             The leading dimension of the array VT.  LDVT >= 1; if   
             JOBVT = 'A', LDVT >= N; if JOBVT = 'S', LDVT >= min(M,N).   
     WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK) 
   
             On exit, if INFO = 0, WORK(1) returns the optimal LWORK;   
             if INFO > 0, WORK(2:MIN(M,N)) contains the unconverged   
             superdiagonal elements of an upper bidiagonal matrix B   
             whose diagonal is in S (not necessarily sorted). B   
             satisfies A = U * B * VT, so it has the same singular values 
   
             as A, and singular vectors related by U and VT.   
     LWORK   (input) INTEGER   
             The dimension of the array WORK. LWORK >= 1.   
             LWORK >= MAX(3*MIN(M,N)+MAX(M,N),5*MIN(M,N)-4).   
             For good performance, LWORK should generally be larger.   
     INFO    (output) INTEGER   
             = 0:  successful exit.   
             < 0:  if INFO = -i, the i-th argument had an illegal value.   
             > 0:  if DBDSQR did not converge, INFO specifies how many   
                   superdiagonals of an intermediate bidiagonal form B   
                   did not converge to zero. See the description of WORK   
                   above for details.   
 "));

          external "Fortran 77" dgesvd("A","A",size(A, 1),size(A, 2),Awork,size(A, 1),sigma,U,size(A, 1),VT,size(A, 2),work,lwork,info)           annotation(Library="Lapack");

        end dgesvd;
        function dgesvd_sigma "Determine singular values"
                  extends Modelica.Icons.Function;
          input Real A[:,:];
          output Real sigma[min(size(A, 1), size(A, 2))];
          output Integer info;
        protected 
          Real Awork[size(A, 1),size(A, 2)]=A;
          Real U[size(A, 1),size(A, 1)];
          Real VT[size(A, 2),size(A, 2)];
          Integer lwork=5*size(A, 1) + 5*size(A, 2);
          Real work[lwork];
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
     Purpose   
     =======   
     DGESVD computes the singular value decomposition (SVD) of a real   
     M-by-N matrix A, optionally computing the left and/or right singular 
   
     vectors. The SVD is written   
          A = U * SIGMA * transpose(V)   
     where SIGMA is an M-by-N matrix which is zero except for its   
     min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and   
     V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA   
     are the singular values of A; they are real and non-negative, and   
     are returned in descending order.  The first min(m,n) columns of   
     U and V are the left and right singular vectors of A.   
     Note that the routine returns V**T, not V.   
     Arguments   
     =========   
     JOBU    (input) CHARACTER*1   
             Specifies options for computing all or part of the matrix U: 
   
             = 'A':  all M columns of U are returned in array U:   
             = 'S':  the first min(m,n) columns of U (the left singular   
                     vectors) are returned in the array U;   
             = 'O':  the first min(m,n) columns of U (the left singular   
                     vectors) are overwritten on the array A;   
             = 'N':  no columns of U (no left singular vectors) are   
                     computed.   
     JOBVT   (input) CHARACTER*1   
             Specifies options for computing all or part of the matrix   
             V**T:   
             = 'A':  all N rows of V**T are returned in the array VT;   
             = 'S':  the first min(m,n) rows of V**T (the right singular   
                     vectors) are returned in the array VT;   
             = 'O':  the first min(m,n) rows of V**T (the right singular   
                     vectors) are overwritten on the array A;   
             = 'N':  no rows of V**T (no right singular vectors) are   
                     computed.   
             JOBVT and JOBU cannot both be 'O'.   
     M       (input) INTEGER   
             The number of rows of the input matrix A.  M >= 0.   
     N       (input) INTEGER   
             The number of columns of the input matrix A.  N >= 0.   
     A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)   
             On entry, the M-by-N matrix A.   
             On exit,   
             if JOBU = 'O',  A is overwritten with the first min(m,n)   
                             columns of U (the left singular vectors,   
                             stored columnwise);   
             if JOBVT = 'O', A is overwritten with the first min(m,n)   
                             rows of V**T (the right singular vectors,   
                             stored rowwise);   
             if JOBU .ne. 'O' and JOBVT .ne. 'O', the contents of A   
                             are destroyed.   
     LDA     (input) INTEGER   
             The leading dimension of the array A.  LDA >= max(1,M).   
     S       (output) DOUBLE PRECISION array, dimension (min(M,N))   
             The singular values of A, sorted so that S(i) >= S(i+1).   
     U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)   
             (LDU,M) if JOBU = 'A' or (LDU,min(M,N)) if JOBU = 'S'.   
             If JOBU = 'A', U contains the M-by-M orthogonal matrix U;   
             if JOBU = 'S', U contains the first min(m,n) columns of U   
             (the left singular vectors, stored columnwise);   
             if JOBU = 'N' or 'O', U is not referenced.   
     LDU     (input) INTEGER   
             The leading dimension of the array U.  LDU >= 1; if   
             JOBU = 'S' or 'A', LDU >= M.   
     VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)   
             If JOBVT = 'A', VT contains the N-by-N orthogonal matrix   
             V**T;   
             if JOBVT = 'S', VT contains the first min(m,n) rows of   
             V**T (the right singular vectors, stored rowwise);   
             if JOBVT = 'N' or 'O', VT is not referenced.   
     LDVT    (input) INTEGER   
             The leading dimension of the array VT.  LDVT >= 1; if   
             JOBVT = 'A', LDVT >= N; if JOBVT = 'S', LDVT >= min(M,N).   
     WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK) 
   
             On exit, if INFO = 0, WORK(1) returns the optimal LWORK;   
             if INFO > 0, WORK(2:MIN(M,N)) contains the unconverged   
             superdiagonal elements of an upper bidiagonal matrix B   
             whose diagonal is in S (not necessarily sorted). B   
             satisfies A = U * B * VT, so it has the same singular values 
   
             as A, and singular vectors related by U and VT.   
     LWORK   (input) INTEGER   
             The dimension of the array WORK. LWORK >= 1.   
             LWORK >= MAX(3*MIN(M,N)+MAX(M,N),5*MIN(M,N)-4).   
             For good performance, LWORK should generally be larger.   
     INFO    (output) INTEGER   
             = 0:  successful exit.   
             < 0:  if INFO = -i, the i-th argument had an illegal value.   
             > 0:  if DBDSQR did not converge, INFO specifies how many   
                   superdiagonals of an intermediate bidiagonal form B   
                   did not converge to zero. See the description of WORK   
                   above for details.   
 "));

          external "Fortran 77" dgesvd("N","N",size(A, 1),size(A, 2),Awork,size(A, 1),sigma,U,size(A, 1),VT,size(A, 2),work,lwork,info)           annotation(Library="Lapack");

        end dgesvd_sigma;
        function StringAllocate "Utility function to provide storage for characters"
                  extends Modelica.Icons.Function;
          input Integer n;
          output String s;

          external "C"           annotation(doNotDeclare());

        end StringAllocate;
        function dgetrf "Compute LU factorization of square or rectangular matrix A (A = P*L*U)"
                  extends Modelica.Icons.Function;
          input Real A[:,:] "Square or rectangular matrix";
          output Real LU[size(A, 1),size(A, 2)]=A;
          output Integer pivots[min(size(A, 1), size(A, 2))] "Pivot vector";
          output Integer info "Information";
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
   SUBROUTINE DGETRF( M, N, A, LDA, IPIV, INFO )
 -- LAPACK routine (version 1.1) --
    Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
    Courant Institute, Argonne National Lab, and Rice University
    March 31, 1993
    .. Scalar Arguments ..
    INTEGER            INFO, LDA, M, N
    ..
    .. Array Arguments ..
    INTEGER            IPIV( * )
    DOUBLE PRECISION   A( LDA, * )
    ..
 Purpose
 =======
 DGETRF computes an LU factorization of a general M-by-N matrix A
 using partial pivoting with row interchanges.
 The factorization has the form
    A = P * L * U
 where P is a permutation matrix, L is lower triangular with unit
 diagonal elements (lower trapezoidal if m > n), and U is upper
 triangular (upper trapezoidal if m < n).
 This is the right-looking Level 3 BLAS version of the algorithm.
 Arguments
 =========
 M       (input) INTEGER
         The number of rows of the matrix A.  M >= 0.
 N       (input) INTEGER
         The number of columns of the matrix A.  N >= 0.
 A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
         On entry, the M-by-N matrix to be factored.
         On exit, the factors L and U from the factorization
         A = P*L*U; the unit diagonal elements of L are not stored.
 LDA     (input) INTEGER
         The leading dimension of the array A.  LDA >= max(1,M).
 IPIV    (output) INTEGER array, dimension (min(M,N))
         The pivot indices; for 1 <= i <= min(M,N), row i of the
         matrix was interchanged with row IPIV(i).
 INFO    (output) INTEGER
         = 0:  successful exit
         < 0:  if INFO = -i, the i-th argument had an illegal value
         > 0:  if INFO = i, U(i,i) is exactly zero. The factorization
               has been completed, but the factor U is exactly
               singular, and division by zero will occur if it is used
               to solve a system of equations.
 "));

          external "FORTRAN 77" dgetrf(size(A, 1),size(A, 2),LU,size(A, 1),pivots,info)           annotation(Library="Lapack");

        end dgetrf;
        function dgetrs_vec "Solves a system of linear equations with the LU decomposition from dgetrf(..)"
                  extends Modelica.Icons.Function;
          input Real LU[:,size(LU, 1)] "LU factorization of dgetrf of a square matrix";
          input Integer pivots[size(LU, 1)] "Pivot vector of dgetrf";
          input Real b[size(LU, 1)] "Right hand side vector b";
          output Real x[size(b, 1)]=b;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
   SUBROUTINE DGETRS( TRANS, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
 -- LAPACK routine (version 1.1) --
    Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
    Courant Institute, Argonne National Lab, and Rice University
    March 31, 1993
    .. Scalar Arguments ..
    CHARACTER          TRANS
    INTEGER            INFO, LDA, LDB, N, NRHS
    ..
    .. Array Arguments ..
    INTEGER            IPIV( * )
    DOUBLE PRECISION   A( LDA, * ), B( LDB, * )
    ..
 Purpose
 =======
 DGETRS solves a system of linear equations
    A * X = B  or  A' * X = B
 with a general N-by-N matrix A using the LU factorization computed
 by DGETRF.
 Arguments
 =========
 TRANS   (input) CHARACTER*1
         Specifies the form of the system of equations:
         = 'N':  A * X = B  (No transpose)
         = 'T':  A'* X = B  (Transpose)
         = 'C':  A'* X = B  (Conjugate transpose = Transpose)
 N       (input) INTEGER
         The order of the matrix A.  N >= 0.
 NRHS    (input) INTEGER
         The number of right hand sides, i.e., the number of columns
         of the matrix B.  NRHS >= 0.
 A       (input) DOUBLE PRECISION array, dimension (LDA,N)
         The factors L and U from the factorization A = P*L*U
         as computed by DGETRF.
 LDA     (input) INTEGER
         The leading dimension of the array A.  LDA >= max(1,N).
 IPIV    (input) INTEGER array, dimension (N)
         The pivot indices from DGETRF; for 1<=i<=N, row i of the
         matrix was interchanged with row IPIV(i).
 B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
         On entry, the right hand side matrix B.
         On exit, the solution matrix X.
 LDB     (input) INTEGER
         The leading dimension of the array B.  LDB >= max(1,N).
 INFO    (output) INTEGER
         = 0:  successful exit
         < 0:  if INFO = -i, the i-th argument had an illegal value
 "));
        protected 
          Real work[size(LU, 1),size(LU, 1)]=LU;
          Integer info;

          external "FORTRAN 77" dgetrs("N",size(LU, 1),1,work,size(LU, 1),pivots,x,size(b, 1),info)           annotation(Library="Lapack");

        end dgetrs_vec;
        function dgetri "Computes the inverse of a matrix using the LU factorization from dgetrf(..)"
                  extends Modelica.Icons.Function;
          input Real LU[:,size(LU, 1)] "LU factorization of dgetrf of a square matrix";
          input Integer pivots[size(LU, 1)] "Pivot vector of dgetrf";
          output Real inv[size(LU, 1),size(LU, 2)]=LU "Inverse of matrix P*L*U";
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
    SUBROUTINE DGETRI( N, A, LDA, IPIV, WORK, LWORK, INFO )
 -- LAPACK routine (version 1.1) --
    Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
    Courant Institute, Argonne National Lab, and Rice University
    March 31, 1993
    .. Scalar Arguments ..
    INTEGER            INFO, LDA, LWORK, N
    ..
    .. Array Arguments ..
    INTEGER            IPIV( * )
    DOUBLE PRECISION   A( LDA, * ), WORK( LWORK )
    ..
 Purpose
 =======
 DGETRI computes the inverse of a matrix using the LU factorization
 computed by DGETRF.
 This method inverts U and then computes inv(A) by solving the system
 inv(A)*L = inv(U) for inv(A).
 Arguments
 =========
 N       (input) INTEGER
         The order of the matrix A.  N >= 0.
 A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
         On entry, the factors L and U from the factorization
         A = P*L*U as computed by DGETRF.
         On exit, if INFO = 0, the inverse of the original matrix A.
 LDA     (input) INTEGER
         The leading dimension of the array A.  LDA >= max(1,N).
 IPIV    (input) INTEGER array, dimension (N)
         The pivot indices from DGETRF; for 1<=i<=N, row i of the
         matrix was interchanged with row IPIV(i).
 WORK    (workspace) DOUBLE PRECISION array, dimension (LWORK)
         On exit, if INFO=0, then WORK(1) returns the optimal LWORK.
 LWORK   (input) INTEGER
         The dimension of the array WORK.  LWORK >= max(1,N).
         For optimal performance LWORK >= N*NB, where NB is
         the optimal blocksize returned by ILAENV.
 INFO    (output) INTEGER
         = 0:  successful exit
         < 0:  if INFO = -i, the i-th argument had an illegal value
         > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is
               singular and its inverse could not be computed."));
        protected 
          Integer lwork=min(10, size(LU, 1))*size(LU, 1) "Length of work array";
          Real work[lwork];
          Integer info;

          external "FORTRAN 77" dgetri(size(LU, 1),inv,size(LU, 1),pivots,work,lwork,info)           annotation(Library="Lapack");

        end dgetri;
        function dgeqpf "Compute QR factorization of square or rectangular matrix A with column pivoting (A(:,p) = Q*R)"
                  extends Modelica.Icons.Function;
          input Real A[:,:] "Square or rectangular matrix";
          output Real QR[size(A, 1),size(A, 2)]=A "QR factorization in packed format";
          output Real tau[min(size(A, 1), size(A, 2))] "The scalar factors of the elementary reflectors of Q";
          output Integer p[size(A, 2)]=zeros(size(A, 2)) "Pivot vector";
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
    SUBROUTINE DGEQPF( M, N, A, LDA, JPVT, TAU, WORK, INFO )
 -- LAPACK test routine (version 1.1) --
    Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
    Courant Institute, Argonne National Lab, and Rice University
    March 31, 1993
    .. Scalar Arguments ..
    INTEGER            INFO, LDA, M, N
    ..
    .. Array Arguments ..
    INTEGER            JPVT( * )
    DOUBLE PRECISION   A( LDA, * ), TAU( * ), WORK( * )
    ..
 Purpose
 =======
 DGEQPF computes a QR factorization with column pivoting of a
 real M-by-N matrix A: A*P = Q*R.
 Arguments
 =========
 M       (input) INTEGER
         The number of rows of the matrix A. M >= 0.
 N       (input) INTEGER
         The number of columns of the matrix A. N >= 0
 A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
         On entry, the M-by-N matrix A.
         On exit, the upper triangle of the array contains the
         min(M,N)-by-N upper triangular matrix R; the elements
         below the diagonal, together with the array TAU,
         represent the orthogonal matrix Q as a product of
         min(m,n) elementary reflectors.
 LDA     (input) INTEGER
         The leading dimension of the array A. LDA >= max(1,M).
 JPVT    (input/output) INTEGER array, dimension (N)
         On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
         to the front of A*P (a leading column); if JPVT(i) = 0,
         the i-th column of A is a free column.
         On exit, if JPVT(i) = k, then the i-th column of A*P
         was the k-th column of A.
 TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
         The scalar factors of the elementary reflectors.
 WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)
 INFO    (output) INTEGER
         = 0:  successful exit
         < 0:  if INFO = -i, the i-th argument had an illegal value
 Further Details
 ===============
 The matrix Q is represented as a product of elementary reflectors
    Q = H(1) H(2) . . . H(n)
 Each H(i) has the form
    H = I - tau * v * v'
 where tau is a real scalar, and v is a real vector with
 v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i).
 The matrix P is represented in jpvt as follows: If
    jpvt(j) = i
 then the jth column of P is the ith canonical unit vector."));
        protected 
          Integer info;
          Integer ncol=size(A, 2) "Column dimension of A";
          Real work[3*ncol] "work array";

          external "FORTRAN 77" dgeqpf(size(A, 1),ncol,QR,size(A, 1),p,tau,work,info)           annotation(Library="Lapack");

        end dgeqpf;
        function dorgqr "Generates a Real orthogonal matrix Q which is defined as the product of elementary reflectors as returned from dgeqpf"
                  extends Modelica.Icons.Function;
          input Real QR[:,:] "QR from dgeqpf";
          input Real tau[min(size(QR, 1), size(QR, 2))] "The scalar factors of the elementary reflectors of Q";
          output Real Q[size(QR, 1),size(QR, 2)]=QR "Orthogonal matrix Q";
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="Lapack documentation:
    SUBROUTINE DORGQR( M, N, K, A, LDA, TAU, WORK, LWORK, INFO )
 -- LAPACK routine (version 1.1) --
    Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
    Courant Institute, Argonne National Lab, and Rice University
    March 31, 1993
    .. Scalar Arguments ..
    INTEGER            INFO, K, LDA, LWORK, M, N
    ..
    .. Array Arguments ..
    DOUBLE PRECISION   A( LDA, * ), TAU( * ), WORK( LWORK )
    ..
 Purpose
 =======
 DORGQR generates an M-by-N real matrix Q with orthonormal columns,
 which is defined as the first N columns of a product of K elementary
 reflectors of order M
       Q  =  H(1) H(2) . . . H(k)
 as returned by DGEQRF.
 Arguments
 =========
 M       (input) INTEGER
         The number of rows of the matrix Q. M >= 0.
 N       (input) INTEGER
         The number of columns of the matrix Q. M >= N >= 0.
 K       (input) INTEGER
         The number of elementary reflectors whose product defines the
         matrix Q. N >= K >= 0.
 A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
         On entry, the i-th column must contain the vector which
         defines the elementary reflector H(i), for i = 1,2,...,k, as
         returned by DGEQRF in the first k columns of its array
         argument A.
         On exit, the M-by-N matrix Q.
 LDA     (input) INTEGER
         The first dimension of the array A. LDA >= max(1,M).
 TAU     (input) DOUBLE PRECISION array, dimension (K)
         TAU(i) must contain the scalar factor of the elementary
         reflector H(i), as returned by DGEQRF.
 WORK    (workspace) DOUBLE PRECISION array, dimension (LWORK)
         On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
 LWORK   (input) INTEGER
         The dimension of the array WORK. LWORK >= max(1,N).
         For optimum performance LWORK >= N*NB, where NB is the
         optimal blocksize.
 INFO    (output) INTEGER
         = 0:  successful exit
         < 0:  if INFO = -i, the i-th argument has an illegal value
 "));
        protected 
          Integer info;
          Integer lwork=min(10, size(QR, 2))*size(QR, 2) "Length of work array";
          Real work[lwork];

          external "FORTRAN 77" dorgqr(size(QR, 1),size(QR, 2),size(tau, 1),Q,size(Q, 1),tau,work,lwork,info)           annotation(Library="Lapack");

        end dorgqr;
      end LAPACK;
    end Matrices;
    function sin "sine"
          extends baseIcon1;
      input SI.Angle u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,0.0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,-64.2},{29.3,-73.1},{35.0,-78.4},{40.6,-80.0},{46.2,-77.6},{51.9,-71.5},{57.5,-61.9},{63.9,-47.2},{72.0,-24.8},{80.0,0.0}}, color={0,0,0}),Text(extent={{12.0,84.0},{84.0,36.0}}, textString="sin", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,0.0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,-64.2},{29.3,-73.1},{35.0,-78.4},{40.6,-80.0},{46.2,-77.6},{51.9,-71.5},{57.5,-61.9},{63.9,-47.2},{72.0,-24.8},{80.0,0.0}}, color={0,0,0}),Text(extent={{-105.0,72.0},{-85.0,88.0}}, textString="1", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="2*pi", fillColor={0,0,255}),Text(extent={{-105.0,-72.0},{-85.0,-88.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=sin(u) ;

    end sin;
    function cos "cosine"
          extends baseIcon1;
      input SI.Angle u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-74.4,78.1},{-68.7,72.3},{-63.1,63.0},{-56.7,48.7},{-48.6,26.6},{-29.3,-32.5},{-22.1,-51.7},{-15.7,-65.3},{-10.1,-73.8},{-4.42,-78.8},{1.21,-79.9},{6.83,-77.1},{12.5,-70.6},{18.1,-60.6},{24.5,-45.7},{32.6,-23.0},{50.3,31.3},{57.5,50.7},{63.9,64.6},{69.5,73.4},{75.2,78.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-36.0,82.0},{36.0,34.0}}, textString="cos", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-105.0,72.0},{-85.0,88.0}}, textString="1", fillColor={0,0,255}),Text(extent={{-105.0,-72.0},{-85.0,-88.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="2*pi", fillColor={0,0,255}),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-74.4,78.1},{-68.7,72.3},{-63.1,63.0},{-56.7,48.7},{-48.6,26.6},{-29.3,-32.5},{-22.1,-51.7},{-15.7,-65.3},{-10.1,-73.8},{-4.42,-78.8},{1.21,-79.9},{6.83,-77.1},{12.5,-70.6},{18.1,-60.6},{24.5,-45.7},{32.6,-23.0},{50.3,31.3},{57.5,50.7},{63.9,64.6},{69.5,73.4},{75.2,78.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=cos(u) ;

    end cos;
    function tan "tangent (u shall not be -pi/2, pi/2, 3*pi/2, ...)"
          extends baseIcon2;
      input SI.Angle u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-78.4,-68.4},{-76.8,-59.7},{-74.4,-50.0},{-71.2,-40.9},{-67.1,-33.0},{-60.7,-24.8},{-51.1,-17.2},{-35.8,-9.98},{-4.42,-1.07},{33.4,9.12},{49.4,16.2},{59.1,23.2},{65.5,30.6},{70.4,39.1},{73.6,47.4},{76.0,56.1},{77.6,63.8},{80.0,80.0}}, color={0,0,0}),Text(extent={{-90.0,72.0},{-18.0,24.0}}, textString="tan", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-37.0,-72.0},{-17.0,-88.0}}, textString="-5.8", fillColor={0,0,255}),Text(extent={{-33.0,86.0},{-13.0,70.0}}, textString=" 5.8", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="1.4", fillColor={0,0,255}),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-78.4,-68.4},{-76.8,-59.7},{-74.4,-50.0},{-71.2,-40.9},{-67.1,-33.0},{-60.7,-24.8},{-51.1,-17.2},{-35.8,-9.98},{-4.42,-1.07},{33.4,9.12},{49.4,16.2},{59.1,23.2},{65.5,30.6},{70.4,39.1},{73.6,47.4},{76.0,56.1},{77.6,63.8},{80.0,80.0}}, color={0,0,0}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=tan(u) ;

    end tan;
    function asin "inverse sine (-1 <= u <= 1)"
          extends baseIcon2;
      input Real u;
      output SI.Angle y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-72.8},{-77.6,-67.5},{-73.6,-59.4},{-66.3,-49.8},{-53.5,-37.3},{-30.2,-19.7},{37.4,24.8},{57.5,40.8},{68.7,52.7},{75.2,62.2},{77.6,67.5},{80.0,80.0}}, color={0,0,0}),Text(extent={{-88.0,78.0},{-16.0,30.0}}, textString="asin", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-40.0,-72.0},{-15.0,-88.0}}, textString="-pi/2", fillColor={0,0,255}),Text(extent={{-38.0,88.0},{-13.0,72.0}}, textString=" pi/2", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="+1", fillColor={0,0,255}),Text(extent={{-90.0,21.0},{-70.0,1.0}}, textString="-1", fillColor={0,0,255}),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-72.8},{-77.6,-67.5},{-73.6,-59.4},{-66.3,-49.8},{-53.5,-37.3},{-30.2,-19.7},{37.4,24.8},{57.5,40.8},{68.7,52.7},{75.2,62.2},{77.6,67.5},{80.0,80.0}}, color={0,0,0}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=asin(u) ;

    end asin;
    function acos "inverse cosine (-1 <= u <= 1)"
          extends baseIcon2;
      input Real u;
      output SI.Angle y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,-80.0},{68.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-79.2,72.8},{-77.6,67.5},{-73.6,59.4},{-66.3,49.8},{-53.5,37.3},{-30.2,19.7},{37.4,-24.8},{57.5,-40.8},{68.7,-52.7},{75.2,-62.2},{77.6,-67.5},{80.0,-80.0}}, color={0,0,0}),Text(extent={{-86.0,-14.0},{-14.0,-62.0}}, textString="acos", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-80.0},{84.0,-80.0}}, color={192,192,192}),Polygon(points={{100.0,-80.0},{84.0,-74.0},{84.0,-86.0},{100.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-79.2,72.8},{-77.6,67.5},{-73.6,59.4},{-66.3,49.8},{-53.5,37.3},{-30.2,19.7},{37.4,-24.8},{57.5,-40.8},{68.7,-52.7},{75.2,-62.2},{77.6,-67.5},{80.0,-80.0}}, color={0,0,0}),Text(extent={{-30.0,88.0},{-5.0,72.0}}, textString=" pi", fillColor={0,0,255}),Text(extent={{-94.0,-57.0},{-74.0,-77.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{80.0,-45.0},{100.0,-65.0}}, textString="+1", fillColor={0,0,255}),Text(extent={{90.0,-82.0},{110.0,-102.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=acos(u) ;

    end acos;
    function atan "inverse tangent"
          extends baseIcon2;
      input Real u;
      output SI.Angle y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-52.7,-75.2},{-37.4,-69.7},{-26.9,-63.0},{-19.7,-55.2},{-14.1,-45.8},{-10.1,-36.4},{-6.03,-23.9},{-1.21,-5.06},{5.23,21.0},{9.25,34.1},{13.3,44.2},{18.1,52.9},{24.5,60.8},{33.4,67.6},{47.0,73.6},{69.5,78.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-86.0,68.0},{-14.0,20.0}}, textString="atan", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-52.7,-75.2},{-37.4,-69.7},{-26.9,-63.0},{-19.7,-55.2},{-14.1,-45.8},{-10.1,-36.4},{-6.03,-23.9},{-1.21,-5.06},{5.23,21.0},{9.25,34.1},{13.3,44.2},{18.1,52.9},{24.5,60.8},{33.4,67.6},{47.0,73.6},{69.5,78.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-32.0,91.0},{-12.0,71.0}}, textString="1.4", fillColor={0,0,255}),Text(extent={{-32.0,-71.0},{-12.0,-91.0}}, textString="-1.4", fillColor={0,0,255}),Text(extent={{73.0,26.0},{93.0,10.0}}, textString=" 5.8", fillColor={0,0,255}),Text(extent={{-103.0,20.0},{-83.0,4.0}}, textString="-5.8", fillColor={0,0,255}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=atan(u) ;

    end atan;
    function atan2 "four quadrant inverse tangent"
          extends baseIcon2;
      input Real u1;
      input Real u2;
      output SI.Angle y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{8.93,-67.2},{17.1,-59.3},{27.3,-53.6},{42.1,-49.4},{69.9,-45.8},{80.0,-45.1}}, color={0,0,0}),Line(points={{-80.0,-34.9},{-46.1,-31.4},{-29.4,-27.1},{-18.3,-21.5},{-10.3,-14.5},{-2.03,-3.17},{7.97,11.6},{15.5,19.4},{24.3,25.0},{39.0,30.0},{62.1,33.5},{80.0,34.9}}, color={0,0,0}),Line(points={{-80.0,45.1},{-45.9,48.7},{-29.1,52.9},{-18.1,58.6},{-10.2,65.8},{-1.82,77.2},{0.0,80.0}}, color={0,0,0}),Text(extent={{-90.0,-46.0},{-18.0,-94.0}}, textString="atan2", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{8.93,-67.2},{17.1,-59.3},{27.3,-53.6},{42.1,-49.4},{69.9,-45.8},{80.0,-45.1}}, color={0,0,0}),Line(points={{-80.0,-34.9},{-46.1,-31.4},{-29.4,-27.1},{-18.3,-21.5},{-10.3,-14.5},{-2.03,-3.17},{7.97,11.6},{15.5,19.4},{24.3,25.0},{39.0,30.0},{62.1,33.5},{80.0,34.9}}, color={0,0,0}),Line(points={{-80.0,45.1},{-45.9,48.7},{-29.1,52.9},{-18.1,58.6},{-10.2,65.8},{-1.82,77.2},{0.0,80.0}}, color={0,0,0}),Text(extent={{-30.0,89.0},{-10.0,70.0}}, textString="pi", fillColor={0,0,255}),Text(extent={{-30.0,-69.0},{-10.0,-88.0}}, textString="-pi", fillColor={0,0,255}),Text(extent={{-30.0,49.0},{-10.0,30.0}}, textString="pi/2", fillColor={0,0,255}),Line(points={{0.0,40.0},{-8.0,40.0}}, color={192,192,192}),Line(points={{0.0,-40.0},{-8.0,-40.0}}, color={192,192,192}),Text(extent={{-30.0,-31.0},{-10.0,-50.0}}, textString="-pi/2", fillColor={0,0,255}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="<HTML>
 y = atan2(u1,u2) computes y such that tan(y) = u1/u2 and
 y is in the range -pi < y < pi. u2 may be zero, provided
 u1 is not zero.
 </HTML>
 "));

      external "C" y=atan2(u1,u2) ;

    end atan2;
    function sinh "hyperbolic sine"
          extends baseIcon2;
      input Real u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-76.0,-65.4},{-71.2,-51.4},{-65.5,-38.8},{-59.1,-28.1},{-51.1,-18.7},{-41.4,-11.4},{-27.7,-5.5},{-4.42,-0.653},{24.5,4.57},{39.0,10.1},{49.4,17.2},{57.5,25.9},{63.9,35.8},{69.5,47.4},{74.4,60.4},{78.4,73.8},{80.0,80.0}}, color={0,0,0}),Text(extent={{-88.0,80.0},{-16.0,32.0}}, textString="sinh", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-76.0,-65.4},{-71.2,-51.4},{-65.5,-38.8},{-59.1,-28.1},{-51.1,-18.7},{-41.4,-11.4},{-27.7,-5.5},{-4.42,-0.653},{24.5,4.57},{39.0,10.1},{49.4,17.2},{57.5,25.9},{63.9,35.8},{69.5,47.4},{74.4,60.4},{78.4,73.8},{80.0,80.0}}, color={0,0,0}),Text(extent={{-31.0,72.0},{-11.0,88.0}}, textString="27", fillColor={0,0,255}),Text(extent={{-35.0,-88.0},{-15.0,-72.0}}, textString="-27", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="4", fillColor={0,0,255}),Text(extent={{-98.0,21.0},{-78.0,1.0}}, textString="-4", fillColor={0,0,255}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=sinh(u) ;

    end sinh;
    function cosh "hyperbolic cosine"
          extends baseIcon2;
      input Real u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,-86.083},{68.0,-86.083}}, color={192,192,192}),Polygon(points={{90.0,-86.083},{68.0,-78.083},{68.0,-94.083},{90.0,-86.083}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-77.6,61.1},{-74.4,39.3},{-71.2,20.7},{-67.1,1.29},{-63.1,-14.6},{-58.3,-29.8},{-52.7,-43.5},{-46.2,-55.1},{-39.0,-64.3},{-30.2,-71.7},{-18.9,-77.1},{-4.42,-79.9},{10.9,-79.1},{23.7,-75.2},{34.2,-68.7},{42.2,-60.6},{48.6,-51.2},{54.3,-40.0},{59.1,-27.5},{63.1,-14.6},{67.1,1.29},{71.2,20.7},{74.4,39.3},{77.6,61.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{4.0,66.0},{66.0,20.0}}, textString="cosh", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-86.083},{84.0,-86.083}}, color={192,192,192}),Polygon(points={{100.0,-86.083},{84.0,-80.083},{84.0,-92.083},{100.0,-86.083}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-77.6,61.1},{-74.4,39.3},{-71.2,20.7},{-67.1,1.29},{-63.1,-14.6},{-58.3,-29.8},{-52.7,-43.5},{-46.2,-55.1},{-39.0,-64.3},{-30.2,-71.7},{-18.9,-77.1},{-4.42,-79.9},{10.9,-79.1},{23.7,-75.2},{34.2,-68.7},{42.2,-60.6},{48.6,-51.2},{54.3,-40.0},{59.1,-27.5},{63.1,-14.6},{67.1,1.29},{71.2,20.7},{74.4,39.3},{77.6,61.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{-31.0,72.0},{-11.0,88.0}}, textString="27", fillColor={0,0,255}),Text(extent={{76.0,-61.0},{96.0,-81.0}}, textString="4", fillColor={0,0,255}),Text(extent={{-104.0,-63.0},{-84.0,-83.0}}, textString="-4", fillColor={0,0,255}),Text(extent={{90.0,-88.0},{110.0,-108.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=cosh(u) ;

    end cosh;
    function tanh "hyperbolic tangent"
          extends baseIcon2;
      input Real u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-47.8,-78.7},{-35.8,-75.7},{-27.7,-70.6},{-22.1,-64.2},{-17.3,-55.9},{-12.5,-44.3},{-7.64,-29.2},{-1.21,-4.82},{6.83,26.3},{11.7,42.0},{16.5,54.2},{21.3,63.1},{26.9,69.9},{34.2,75.0},{45.4,78.4},{72.0,79.9},{80.0,80.0}}, color={0,0,0}),Text(extent={{-88.0,72.0},{-16.0,24.0}}, textString="tanh", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-47.8,-78.7},{-35.8,-75.7},{-27.7,-70.6},{-22.1,-64.2},{-17.3,-55.9},{-12.5,-44.3},{-7.64,-29.2},{-1.21,-4.82},{6.83,26.3},{11.7,42.0},{16.5,54.2},{21.3,63.1},{26.9,69.9},{34.2,75.0},{45.4,78.4},{72.0,79.9},{80.0,80.0}}, color={0,0,0}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="4", fillColor={0,0,255}),Text(extent={{-106.0,21.0},{-86.0,1.0}}, textString="-4", fillColor={0,0,255}),Text(extent={{-29.0,72.0},{-9.0,88.0}}, textString="1", fillColor={0,0,255}),Text(extent={{3.0,-72.0},{23.0,-88.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=tanh(u) ;

    end tanh;
    function exp "exponential, base e"
          extends baseIcon2;
      input Real u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,-80.3976},{68.0,-80.3976}}, color={192,192,192}),Polygon(points={{90.0,-80.3976},{68.0,-72.3976},{68.0,-88.3976},{90.0,-80.3976}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-31.0,-77.9},{-6.03,-74.0},{10.9,-68.4},{23.7,-61.0},{34.2,-51.6},{43.0,-40.3},{50.3,-27.8},{56.7,-13.5},{62.3,2.23},{67.1,18.6},{72.0,38.2},{76.0,57.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-86.0,50.0},{-14.0,2.0}}, textString="exp", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-80.3976},{84.0,-80.3976}}, color={192,192,192}),Polygon(points={{100.0,-80.3976},{84.0,-74.3976},{84.0,-86.3976},{100.0,-80.3976}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-31.0,-77.9},{-6.03,-74.0},{10.9,-68.4},{23.7,-61.0},{34.2,-51.6},{43.0,-40.3},{50.3,-27.8},{56.7,-13.5},{62.3,2.23},{67.1,18.6},{72.0,38.2},{76.0,57.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-31.0,72.0},{-11.0,88.0}}, textString="20", fillColor={0,0,255}),Text(extent={{-92.0,-83.0},{-72.0,-103.0}}, textString="-3", fillColor={0,0,255}),Text(extent={{70.0,-83.0},{90.0,-103.0}}, textString="3", fillColor={0,0,255}),Text(extent={{-18.0,-53.0},{2.0,-73.0}}, textString="1", fillColor={0,0,255}),Text(extent={{96.0,-82.0},{116.0,-102.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=exp(u) ;

    end exp;
    function log "natural (base e) logarithm (u shall be > 0)"
          extends baseIcon1;
      input Real u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{-6.0,-24.0},{66.0,-72.0}}, textString="log", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{-105.0,72.0},{-85.0,88.0}}, textString="3", fillColor={0,0,255}),Text(extent={{-109.0,-88.0},{-89.0,-72.0}}, textString="-3", fillColor={0,0,255}),Text(extent={{70.0,-3.0},{90.0,-23.0}}, textString="20", fillColor={0,0,255}),Text(extent={{-78.0,-1.0},{-58.0,-21.0}}, textString="1", fillColor={0,0,255}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=log(u) ;

    end log;
    function log10 "base 10 logarithm (u shall be > 0)"
          extends baseIcon1;
      input Real u;
      output Real y;
      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-79.8,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{-30.0,-22.0},{60.0,-70.0}}, textString="log10", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-79.8,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{70.0,-3.0},{90.0,-23.0}}, textString="20", fillColor={0,0,255}),Text(extent={{-78.0,-1.0},{-58.0,-21.0}}, textString="1", fillColor={0,0,255}),Text(extent={{-109.0,72.0},{-89.0,88.0}}, textString=" 1.3", fillColor={0,0,255}),Text(extent={{-109.0,-88.0},{-89.0,-72.0}}, textString="-1.3", fillColor={0,0,255}),Text(extent={{92.0,-2.0},{112.0,-22.0}}, textString="u", fillColor={160,160,160})}));

      external "C" y=log10(u) ;

    end log10;
    partial function baseIcon1 "Basic icon for mathematical function with y-axis on left side"
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,100.0},{100.0,-100.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,68.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,80.0},{-88.0,80.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-88.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Text(extent={{-75.0,110.0},{-55.0,90.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}));
    end baseIcon1;
    partial function baseIcon2 "Basic icon for mathematical function with y-axis in middle"
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,100.0},{100.0,-100.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{5.0,110.0},{25.0,90.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}));
    end baseIcon2;
    function tempInterpol1 "temporary routine for linear interpolation (will be removed)"
          input Real u "input value (first column of table)";
      input Real table[:,:] "table to be interpolated";
      input Integer icol "column of table to be interpolated";
      output Real y "interpolated input value (icol column of table)";
    protected 
      Integer i;
      Integer n "number of rows of table";
      Real u1;
      Real u2;
      Real y1;
      Real y2;
    algorithm 
      n:=size(table, 1);
      if n <= 1 then 
            y:=table[1,icol];

      else       if u <= table[1,1] then 
            i:=1;

      else       i:=2;
      while (i < n and u >= table[i,1]) loop
              i:=i + 1;

      end while;
      i:=i - 1;
      end if;
      u1:=table[i,1];
      u2:=table[i + 1,1];
      y1:=table[i,icol];
      y2:=table[i + 1,icol];
      assert(u2 > u1, "Table index must be increasing");
      y:=y1 + ((y2 - y1)*(u - u1))/(u2 - u1);
      end if;    end tempInterpol1;
    function tempInterpol2 "temporary routine for vectorized linear interpolation (will be removed)"
          input Real u "input value (first column of table)";
      input Real table[:,:] "table to be interpolated";
      input Integer icol[:] "column(s) of table to be interpolated";
      output Real y[1,size(icol, 1)] "interpolated input value(s) (column(s) icol of table)";
    protected 
      Integer i;
      Integer n "number of rows of table";
      Real u1;
      Real u2;
      Real y1[1,size(icol, 1)];
      Real y2[1,size(icol, 1)];
    algorithm 
      n:=size(table, 1);
      if n <= 1 then 
            y:=transpose([table[1,icol]]);

      else       if u <= table[1,1] then 
            i:=1;

      else       i:=2;
      while (i < n and u >= table[i,1]) loop
              i:=i + 1;

      end while;
      i:=i - 1;
      end if;
      u1:=table[i,1];
      u2:=table[i + 1,1];
      y1:=transpose([table[i,icol]]);
      y2:=transpose([table[i + 1,icol]]);
      assert(u2 > u1, "Table index must be increasing");
      y:=y1 + ((y2 - y1)*(u - u1))/(u2 - u1);
      end if;    end tempInterpol2;
  end Math;
  package Mechanics "Library for mechanical systems"
      extends Modelica.Icons.Library2;
    annotation(preferedView="info",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-5.0,-40.0},{45.0,-70.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Ellipse(extent={{-90.0,-50.0},{-80.0,-60.0}}, lineColor={0,0,0}),Line(points={{-85.0,-55.0},{-60.0,-21.0}}, color={0,0,0}, thickness=0.5),Ellipse(extent={{-65.0,-16.0},{-55.0,-26.0}}, lineColor={0,0,0}),Line(points={{-60.0,-21.0},{9.0,-55.0}}, color={0,0,0}, thickness=0.5),Ellipse(extent={{4.0,-50.0},{14.0,-60.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-10.0,-34.0},{72.0,-34.0},{72.0,-76.0},{-10.0,-76.0}}, color={0,0,0})}),Documentation(info="<HTML>
 <p>
 This package contains components to model <b>mechanical systems</b>.
 Currently, the following subpackages are available:</p>
 <pre>
    <b>MultiBody</b>      3-dimensional mechanical components.
    <b>Rotational</b>     1-dimensional rotational mechanical components.
    <b>Translational</b>  1-dimensional translational mechanical components.
 </pre>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>June 23, 2004</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        included the Mechanics.MultiBody library 1.0 and adapted it to the new
        Blocks connectors.</li>
 <li><i>Oct. 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Bearing torque computation added to package <b>Rotational</b>.</li>
 <li><i>Oct. 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New components and examples in package <b>Rotational</b>.</li>
 <li><i>Oct. 24, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Changes according to the Twente meeting introduced. Especially,
        package Rotational1D renamed to Rotational and package
        Translational1D renamed to Translational. For the particular
        changes in these packages, see the corresponding package
        release notes.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized a first version for 1-dimensional rotational mechanical
        systems based on an existing Dymola library of Martin Otter and
        Hilding Elmqvist.</li>
 </ul>
 </html>"));
    package Rotational "1-dimensional rotational mechanical components"
          package Examples "Demonstration examples of the components of this package"
              extends Modelica.Icons.Library;
        annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package contains example models to demonstrate the usage of the
 Modelica.Mechanics.Rotational package. Open the models and
 simulate them according to the provided description in the models.
 The following demo models are present:
 </p>
 <pre>
    <b>First</b>            First example using simple, basic elements
    <b>Friction</b>         Example to demonstrate usage of a clutch and a brake
    <b>CoupledClutches</b>  Example to demonstrate usage of 3 dynamically
                     coupled clutches.
    <b>LossyGearDemo1</b>   Example to demonstrate that gear efficiency may lead to stuck motion
    <b>LossyGearDemo2</b>   Example to show combination of LossyGear and BearingFriction
    <b>ElasticBearing</b>   Demonstration of bearing flange usage
 </pre>
 <dl>
 <dt><b>Main Author:</b>
 <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
     Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
     Institut f&uuml;r Robotik und Mechatronik<br>
     Postfach 1116<br>
     D-82230 Wessling<br>
     Germany<br>
     email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br>
 </dl>
 <br>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New example <tt>ElasticBearing</tt>.</li>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        New examples concerning LossyGear added.</li>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Appropriate initial conditions provided as start values in the models.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized a first version based on an existing Dymola library
        of Martin Otter and Hilding Elmqvist.</li>
 </ul>
 <br>
 <p><b>Copyright &copy; 1999-2003, Modelica Association and DLR.</b></p>
 <p><i>
 The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".
 </i></p>
 </HTML>
 "));
        encapsulated model First "First example: simple drive train"
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Rotational;
          import SI = Modelica.SIunits;
          extends Icons.Example;
          parameter Real amplitude=10;
          parameter SI.Frequency freqHz=5;
          parameter SI.Inertia Jmotor=0.1;
          parameter SI.Inertia Jload=2;
          parameter Real ratio=10;
          parameter Real damping=10;
          annotation(Documentation(info="<html>
 <p>The drive train consists of a motor inertia which is driven by
 a sine-wave motor torque. Via a gearbox the rotational energy is
 transmitted to a load inertia. Elasticity in the gearbox is modeled
 by a spring element. A linear damper is used to model the
 damping in the gearbox bearing.</p>
 <p>Note, that a force component (like the damper of this example)
 which is acting between a shaft and the housing has to be fixed
 in the housing on one side via component Fixed.</p>
 <p>Simulate for 1 second and plot the following variables:<br>
    angular velocities of inertias inertia2 and 3: inertia2.w, inertia3.w</p>
 <p><b>Release Notes:</b></p>
 <ul><li><i>June 30, 1999</i>
     by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
     Realized.</li>
 </ul>
 </HTML>"));
          Rotational.Fixed fixed annotation(Placement(transformation(x=46.0,y=-52.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=46.0,y=-52.0,scale=0.08,aspectRatio=1.0)));
          Rotational.Torque torque annotation(Placement(transformation(x=-62.0,y=0.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=-62.0,y=0.0,scale=0.08,aspectRatio=1.0)));
          Rotational.Inertia inertia1(J=Jmotor) annotation(Placement(transformation(x=-32.0,y=0.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=-32.0,y=0.0,scale=0.08,aspectRatio=1.0)));
          Rotational.IdealGear idealGear(ratio=ratio) annotation(Placement(transformation(x=-2.0,y=0.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=-2.0,y=0.0,scale=0.08,aspectRatio=1.0)));
          Rotational.Inertia inertia2(J=2,phi(start=0),w(start=0)) annotation(Placement(transformation(x=28.0,y=0.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=28.0,y=0.0,scale=0.08,aspectRatio=1.0)));
          Rotational.Spring spring(c=10000.0) annotation(Placement(transformation(x=62.0,y=0.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=62.0,y=0.0,scale=0.08,aspectRatio=1.0)));
          Rotational.Inertia inertia3(J=Jload,phi(start=0),w(start=0)) annotation(Placement(transformation(x=92.0,y=0.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=92.0,y=0.0,scale=0.08,aspectRatio=1.0)));
          Rotational.Damper damper(d=damping) annotation(Placement(transformation(x=46.0,y=-28.0,scale=0.08,aspectRatio=1.0,rotation=-90),iconTransformation(x=46.0,y=-28.0,scale=0.08,aspectRatio=1.0,rotation=-90)));
          Sources.Sine sine(amplitude=amplitude,freqHz=freqHz) annotation(Placement(transformation(x=-92.0,y=0.0,scale=0.08,aspectRatio=1.0),iconTransformation(x=-92.0,y=0.0,scale=0.08,aspectRatio=1.0)));

        equation 
          connect(sine.y,torque.tau) annotation(Line(points={{-83.2,0.0},{-71.6,0.0}},color={0,0,255}));
          connect(torque.flange_b,inertia1.flange_a) annotation(Line(points={{-54.0,0.0},{-40.0,0.0}},color={0,0,0}));
          connect(inertia1.flange_b,idealGear.flange_a) annotation(Line(points={{-24.0,0.0},{-10.0,0.0}},color={0,0,0}));
          connect(idealGear.flange_b,inertia2.flange_a) annotation(Line(points={{6.0,0.0},{20.0,0.0}},color={0,0,0}));
          connect(inertia2.flange_b,spring.flange_a) annotation(Line(points={{36.0,0.0},{54.0,0.0}},color={0,0,0}));
          connect(spring.flange_b,inertia3.flange_a) annotation(Line(points={{70.0,0.0},{84.0,0.0}},color={0,0,0}));
          connect(damper.flange_a,inertia2.flange_b) annotation(Line(points={{46.0,-20.0},{46.0,0.0},{36.0,0.0}},color={0,0,0}));
          connect(damper.flange_b,fixed.flange_b) annotation(Line(points={{46.0,-36.0},{46.0,-52.0}},color={0,0,0}));
        end First;
        encapsulated model Friction "Drive train with clutch and brake"
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Blocks.Math;
          import Modelica.Mechanics.Rotational;
          import Modelica.Constants.pi;
          import SI = Modelica.SIunits;
          extends Icons.Example;
          parameter SI.Time startTime=0.5 "Start time of step";
          output SI.Torque tMotor "driving torque of inertia3";
          output SI.Torque tClutch "friction torque of clutch";
          output SI.Torque tBrake "friction torque of brake";
          output SI.Torque tSpring "spring torque";
          annotation(Documentation(info="<html>
 <p>This drive train contains a frictional <b>clutch</b> and a <b>brake</b>.
 Simulate the system for 1 second using the following initial
 values (defined already in the model):</p>
 <pre>   inertia1.w =  90 (or brake.w)
    inertia2.w =  90
    inertia3.w = 100
 </pre>
 <p>Plot the output signals</p>
 <pre>   tMotor      Torque of motor
    tClutch     Torque in clutch
    tBrake      Torque in brake
    tSpring     Torque in spring
 </pre>
 <p>as well as the absolute angular velocities of the three inertia components
 (inertia1.w, inertia2.w, inertia3.w).</p>
 <p><b>Release Notes:</b></p>
 <ul><li><i>June 30, 1999</i>
     by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
     Realized.</li>
 </ul>
 </HTML>"));
          Rotational.Torque torque annotation(Placement(transformation(x=-40.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-40.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Inertia inertia3(J=1,phi(start=0),w(start=100)) annotation(Placement(transformation(x=-20.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-20.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Clutch clutch(fn_max=160) annotation(Placement(transformation(x=0.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=0.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Inertia inertia2(J=0.05,phi(start=0),w(start=90)) annotation(Placement(transformation(x=20.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=20.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.SpringDamper spring(c=160,d=1) annotation(Placement(transformation(x=40.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=40.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Inertia inertia1(J=1,phi(start=0),w(start=90)) annotation(Placement(transformation(x=80.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=80.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Brake brake(fn_max=1600) annotation(Placement(transformation(x=60.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=60.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Sources.Constant const(k=1) annotation(Placement(transformation(x=0.0,y=25.0,scale=0.05,aspectRatio=1.0,rotation=-90),iconTransformation(x=0.0,y=25.0,scale=0.05,aspectRatio=1.0,rotation=-90)));
          Sources.Step step(startTime=startTime) annotation(Placement(transformation(x=60.0,y=25.0,scale=0.05,aspectRatio=1.0,rotation=-90),iconTransformation(x=60.0,y=25.0,scale=0.05,aspectRatio=1.0,rotation=-90)));
          Sources.Step step2(height=-1,offset=1,startTime=startTime) annotation(Placement(transformation(x=-80.0,y=-10.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-80.0,y=-10.0,scale=0.05,aspectRatio=1.0)));
          Sources.Sine sine(amplitude=200,freqHz=50/pi) annotation(Placement(transformation(x=-80.0,y=10.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-80.0,y=10.0,scale=0.05,aspectRatio=1.0)));
          Math.Product product annotation(Placement(transformation(x=-60.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-60.0,y=0.0,scale=0.05,aspectRatio=1.0)));

        equation 
          tMotor=torque.tau;
          tClutch=clutch.tau;
          tBrake=brake.tau;
          tSpring=spring.tau;
          connect(sine.y,product.u1) annotation(Line(points={{-74.5,10.0},{-70.0,10.0},{-70.0,3.0},{-66.0,3.0}},color={0,0,255}));
          connect(step2.y,product.u2) annotation(Line(points={{-74.5,-10.0},{-70.0,-10.0},{-70.0,-3.0},{-66.0,-3.0}},color={0,0,255}));
          connect(product.y,torque.tau) annotation(Line(points={{-54.5,0.0},{-46.0,0.0}},color={0,0,255}));
          connect(torque.flange_b,inertia3.flange_a) annotation(Line(points={{-35.0,0.0},{-25.0,0.0}},color={0,0,0}));
          connect(inertia3.flange_b,clutch.flange_a) annotation(Line(points={{-15.0,0.0},{-5.0,0.0}},color={0,0,0}));
          connect(clutch.flange_b,inertia2.flange_a) annotation(Line(points={{5.0,0.0},{15.0,0.0}},color={0,0,0}));
          connect(const.y,clutch.f_normalized) annotation(Line(points={{3.36767e-016,19.5},{3.36767e-016,12.25},{0.0,12.25},{0.0,5.5}},color={0,0,255}));
          connect(inertia2.flange_b,spring.flange_a) annotation(Line(points={{25.0,0.0},{35.0,0.0}},color={0,0,0}));
          connect(spring.flange_b,brake.flange_a) annotation(Line(points={{45.0,0.0},{55.0,0.0}},color={0,0,0}));
          connect(brake.flange_b,inertia1.flange_a) annotation(Line(points={{65.0,0.0},{75.0,0.0}},color={0,0,0}));
          connect(step.y,brake.f_normalized) annotation(Line(points={{60.0,19.5},{60.0,5.5}},color={0,0,255}));
        end Friction;
        encapsulated model CoupledClutches "Drive train with 3 dynamically coupled clutches"
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Rotational;
          import SI = Modelica.SIunits;
          extends Icons.Example;
          parameter SI.Frequency freqHz=0.2 "frequency of sine function to invoke clutch1";
          parameter SI.Time T2=0.4 "time when clutch2 is invoked";
          parameter SI.Time T3=0.9 "time when clutch3 is invoked";
          annotation(Documentation(info="<html>
 <p>This example demonstrates how variable structure
 drive trains are handeled. The drive train consists
 of 4 inertias and 3 clutches, where the clutches
 are controlled by input signals. The system has
 2^3=8 different configurations and 3^3 = 27
 different states (every clutch may be in forward
 sliding, backward sliding or locked mode when the
 relative angular velocity is zero). By invoking the
 clutches at different time instances, the switching
 of the configurations can be studied.</p>
 <p>Simulate the system for 1.2 seconds with the
 following initial values:<br>
 J1.w = 10.</p>
 <p>Plot the following variables:<br>
 angular velocities of inertias (J1.w, J2.w, J3.w,
 J4.w), frictional torques of clutches (clutchX.tau),
 frictional mode of clutches (clutchX.mode) where
 mode = -1/0/+1 means backward sliding,
 locked, forward sliding.</p>
 <p><b>Release Notes:</b></p>
 <ul><li><i>June 30, 1999</i>
         by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
         Realized.</li>
 </ul></HTML>"),Commands(file="CoupledClutches.mos" "Plot inertias"));
          Rotational.Inertia J1(J=1,phi(start=0),w(start=10)) annotation(Placement(transformation(x=-40.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-40.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Torque torque annotation(Placement(transformation(x=-60.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-60.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Clutch clutch1(peak=1.1,fn_max=20) annotation(Placement(transformation(x=-20.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-20.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Sources.Sine sin1(amplitude=10,freqHz=5) annotation(Placement(transformation(x=-80.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-80.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Sources.Step step1(startTime=T2) annotation(Placement(transformation(x=20.0,y=20.0,scale=0.05,aspectRatio=1.0,rotation=-90),iconTransformation(x=20.0,y=20.0,scale=0.05,aspectRatio=1.0,rotation=-90)));
          Rotational.Inertia J2(J=1) annotation(Placement(transformation(x=0.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=0.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Clutch clutch2(peak=1.1,fn_max=20) annotation(Placement(transformation(x=20.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=20.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Inertia J3(J=1) annotation(Placement(transformation(x=40.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=40.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Clutch clutch3(peak=1.1,fn_max=20) annotation(Placement(transformation(x=60.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=60.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Rotational.Inertia J4(J=1) annotation(Placement(transformation(x=80.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=80.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Sources.Sine sin2(amplitude=1,freqHz=freqHz,phase=1.57) annotation(Placement(transformation(x=-20.0,y=20.0,scale=0.05,aspectRatio=1.0,rotation=-90),iconTransformation(x=-20.0,y=20.0,scale=0.05,aspectRatio=1.0,rotation=-90)));
          Sources.Step step2(startTime=T3) annotation(Placement(transformation(x=60.0,y=20.0,scale=0.05,aspectRatio=1.0,rotation=-90),iconTransformation(x=60.0,y=20.0,scale=0.05,aspectRatio=1.0,rotation=-90)));

        equation 
          connect(sin1.y,torque.tau) annotation(Line(points={{-74.5,0.0},{-66.0,0.0}},color={0,0,255}));
          connect(torque.flange_b,J1.flange_a) annotation(Line(points={{-55.0,0.0},{-45.0,0.0}},color={0,0,0}));
          connect(J1.flange_b,clutch1.flange_a) annotation(Line(points={{-35.0,0.0},{-25.0,0.0}},color={0,0,0}));
          connect(clutch1.flange_b,J2.flange_a) annotation(Line(points={{-15.0,0.0},{-5.0,0.0}},color={0,0,0}));
          connect(J2.flange_b,clutch2.flange_a) annotation(Line(points={{5.0,0.0},{15.0,0.0}},color={0,0,0}));
          connect(clutch2.flange_b,J3.flange_a) annotation(Line(points={{25.0,0.0},{35.0,0.0}},color={0,0,0}));
          connect(J3.flange_b,clutch3.flange_a) annotation(Line(points={{45.0,0.0},{55.0,0.0}},color={0,0,0}));
          connect(clutch3.flange_b,J4.flange_a) annotation(Line(points={{65.0,0.0},{75.0,0.0}},color={0,0,0}));
          connect(step2.y,clutch3.f_normalized) annotation(Line(points={{60.0,14.5},{60.0,5.5}},color={0,0,255}));
          connect(step1.y,clutch2.f_normalized) annotation(Line(points={{20.0,14.5},{20.0,5.5}},color={0,0,255}));
          connect(sin2.y,clutch1.f_normalized) annotation(Line(points={{-20.0,14.5},{-20.0,5.5}},color={0,0,255}));
        end CoupledClutches;
        encapsulated model LossyGearDemo1 "Example to show that gear efficiency may lead to stuck motion"
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Rotational;
          import SI = Modelica.SIunits;
          extends Icons.Example;
          SI.Power PowerLoss "power lost in the gear";
          annotation(Documentation(info="<html>
 <p>
 This model contains two inertias which are connected by an ideal
 gear where the friction between the teeth of the gear is modeled in
 a physical meaningful way (friction may lead to stuck mode which
 locks the motion of the gear). The friction is defined by an
 efficiency factor (= 0.5) for forward and backward driving condition leading
 to a torque dependent friction loss. Simulate for about 0.5 seconds.
 The friction in the gear will take all modes
 (forward and backward rolling, as well as stuck).
 </p>
 <p>
 You may plot:
 </p>
 <pre>
 Inertia1.w,
 Inertia2.w : angular velocities of inertias
 powerLoss  : power lost in the gear
 gear.mode  :  1 = forward rolling
               0 = stuck (w=0)
              -1 = backward rolling
 </pre>
 </HTML>
 "));
          Rotational.LossyGear gear(i=2,lossTable={{0,0.5,0.5,0,0}}) annotation(Placement(transformation(x=0.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Rotational.Inertia Inertia1 annotation(Placement(transformation(x=-30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Rotational.Inertia Inertia2(J=1.5) annotation(Placement(transformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Rotational.Torque torque1 annotation(Placement(transformation(x=-60.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-60.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Rotational.Torque torque2 annotation(Placement(transformation(x=60.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=60.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Sources.Sine DriveSine(amplitude=10,freqHz=1) annotation(Placement(transformation(x=-90.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Sources.Ramp load(height=5,duration=2,offset=-10) annotation(Placement(transformation(x=90.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=90.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));

        equation 
          connect(Inertia1.flange_b,gear.flange_a) annotation(Line(points={{-20.0,10.0},{-10.0,10.0}},color={0,0,0}));
          connect(gear.flange_b,Inertia2.flange_a) annotation(Line(points={{10.0,10.0},{20.0,10.0}},color={0,0,0}));
          connect(torque1.flange_b,Inertia1.flange_a) annotation(Line(points={{-50.0,10.0},{-40.0,10.0}},color={0,0,0}));
          connect(torque2.flange_b,Inertia2.flange_b) annotation(Line(points={{50.0,10.0},{40.0,10.0}},color={0,0,0}));
          connect(DriveSine.y,torque1.tau) annotation(Line(points={{-79.0,10.0},{-72.0,10.0}},color={0,0,255}));
          connect(load.y,torque2.tau) annotation(Line(points={{79.0,10.0},{72.0,10.0}},color={0,0,255}));
          PowerLoss=gear.flange_a.tau*der(gear.flange_a.phi) + gear.flange_b.tau*der(gear.flange_b.phi);
        end LossyGearDemo1;
        encapsulated model LossyGearDemo2 "Example to show combination of LossyGear and BearingFriction"
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Rotational;
          import SI = Modelica.SIunits;
          extends Icons.Example;
          SI.Power PowerLoss "power lost in the gear";
          annotation(Documentation(info="<html>
 <p>
 This model contains bearing friction and gear friction (= efficiency).
 If both friction models are stuck, there is no unique solution.
 Still a reliable Modelica simulator, such as Dymola, should
 be able to handle this situation.
 </p>
 <p>
 Simulate for about 0.5 seconds. The friction elements are
 in all modes (forward and backward rolling, as well as stuck).
 </p>
 <p>
 You may plot:
 </p>
 <pre>
 Inertia1.w,
 Inertia2.w          : angular velocities of inertias
 powerLoss           : power lost in the gear
 bearingFriction.mode:  1 = forward rolling
                        0 = stuck (w=0)
                       -1 = backward rolling
 gear.mode           :  1 = forward rolling
                        0 = stuck (w=0)
                       -1 = backward rolling
 </pre>
 <p>Note: This combination of LossyGear and BearingFriction is not recommended to use,
 as component LossyGear includes the functionality of component BearingFriction
 (only <i>peak</i> not supported).</p>
 </HTML>
 "));
          Rotational.LossyGear gear(i=2,lossTable={{0,0.5,0.5,0,0}}) annotation(Placement(transformation(x=0.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Rotational.Inertia Inertia1 annotation(Placement(transformation(x=-30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Rotational.Inertia Inertia2(J=1.5) annotation(Placement(transformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Rotational.Torque torque1 annotation(Placement(transformation(x=-60.0,y=70.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-60.0,y=70.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Rotational.Torque torque2 annotation(Placement(transformation(x=60.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=60.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Sources.Sine DriveSine(amplitude=10,freqHz=1) annotation(Placement(transformation(x=-30.0,y=70.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-30.0,y=70.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Sources.Ramp load(height=5,duration=2,offset=-10) annotation(Placement(transformation(x=90.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=90.0,y=10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Rotational.BearingFriction bearingFriction(tau_pos={{0,0.5},{1,1}}) annotation(Placement(transformation(x=-60.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-60.0,y=10.0,scale=0.1,aspectRatio=1.0)));

        equation 
          PowerLoss=gear.flange_a.tau*der(gear.flange_a.phi) + gear.flange_b.tau*der(gear.flange_b.phi);
          connect(load.y,torque2.tau) annotation(Line(points={{79.0,10.0},{72.0,10.0}},color={0,0,255}));
          connect(torque2.flange_b,Inertia2.flange_b) annotation(Line(points={{50.0,10.0},{40.0,10.0}},color={0,0,0}));
          connect(Inertia2.flange_a,gear.flange_b) annotation(Line(points={{20.0,10.0},{10.0,10.0}},color={0,0,0}));
          connect(gear.flange_a,Inertia1.flange_b) annotation(Line(points={{-10.0,10.0},{-20.0,10.0}},color={0,0,0}));
          connect(Inertia1.flange_a,bearingFriction.flange_b) annotation(Line(points={{-40.0,10.0},{-50.0,10.0}},color={0,0,0}));
          connect(bearingFriction.flange_a,torque1.flange_b) annotation(Line(points={{-70.0,10.0},{-80.0,10.0},{-80.0,70.0},{-70.0,70.0}},color={0,0,0}));
          connect(DriveSine.y,torque1.tau) annotation(Line(points={{-41.0,70.0},{-48.0,70.0}},color={0,0,255}));
        end LossyGearDemo2;
        model ElasticBearing "Example to show possible usage of bearing flange"
                  extends Icons.Example;
          Modelica.Mechanics.Rotational.Inertia shaft annotation(Placement(transformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Mechanics.Rotational.Inertia load(J=50) annotation(Placement(transformation(x=80.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=80.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Mechanics.Rotational.Spring spring(c=1000) annotation(Placement(transformation(x=50.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=50.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Mechanics.Rotational.Fixed fixed annotation(Placement(transformation(x=20.0,y=-70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=20.0,y=-70.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Mechanics.Rotational.SpringDamper springDamper(c=100000,d=5) annotation(Placement(transformation(x=20.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=20.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Modelica.Mechanics.Rotational.Torque torque annotation(Placement(transformation(x=-40.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-40.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Sources.Ramp ramp(duration=5,height=100) annotation(Placement(transformation(x=-80.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-80.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 This model demonstrates the usage of the bearing flange.
 The gearbox is not connected rigidly to the ground, but by
 a spring-damper-system. This allows examination of the gearbox
 housing dynamics.</p>
 <p>
 Simulate for about 10 seconds and plot the angular velocities of the inertias <tt>housing.w</tt>,
 <tt>shaft.w</tt> and <tt>load.w</tt>.</p>
 </html>
 "));
          Modelica.Mechanics.Rotational.IdealGear idealGear(ratio=3) annotation(Placement(transformation(x=20.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=20.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Inertia housing(J=5) annotation(Placement(transformation(x=20.0,y=10.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=20.0,y=10.0,scale=0.1,aspectRatio=1.0,rotation=90)));

        equation 
          connect(ramp.y,torque.tau) annotation(Line(points={{-69.0,50.0},{-52.0,50.0}},color={0,0,255}));
          connect(torque.flange_b,shaft.flange_a) annotation(Line(points={{-30.0,50.0},{-20.0,50.0}},color={0,0,0}));
          connect(spring.flange_b,load.flange_a) annotation(Line(points={{60.0,50.0},{70.0,50.0}},color={0,0,0}));
          connect(springDamper.flange_a,fixed.flange_b) annotation(Line(points={{20.0,-40.0},{20.0,-70.0}},color={0,0,0}));
          connect(shaft.flange_b,idealGear.flange_a) annotation(Line(points={{0.0,50.0},{10.0,50.0}},color={0,0,0}));
          connect(idealGear.flange_b,spring.flange_a) annotation(Line(points={{30.0,50.0},{40.0,50.0}},color={0,0,0}));
          connect(idealGear.bearing,housing.flange_b) annotation(Line(points={{20.0,40.0},{20.0,20.0}},color={0,0,0}));
          connect(housing.flange_a,springDamper.flange_b) annotation(Line(points={{20.0,0.0},{20.0,-20.0}},color={0,0,0}));
        end ElasticBearing;
      end Examples;
      package Sensors "Sensors to measure variables in 1D rotational mechanical components"
              extends Modelica.Icons.Library2;
        model TorqueSensor "Ideal sensor to measure the torque between two flanges (= flange_a.tau)"
                  extends Modelica.Icons.RotationalSensor;
          Interfaces.Flange_a flange_a annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput tau(redeclare type SignalType= SI.Torque ) "Torque in flange flange_a and flange_b (= flange_a.tau = -flange_b.tau)" annotation(Placement(transformation(x=-80.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=-80.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <b>cut-torque between two flanges</b> in an ideal way
 and provides the result as output signal <b>tau</b>
 (to be further processed with blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-51.0,-78.0},{49.0,-119.0}}, textString="tau", fillColor={0,0,0}),Line(points={{-80.0,-100.0},{-80.0,0.0}}, color={0,0,255}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{14.0,85.0},{-6.0,90.0},{-6.0,80.0},{14.0,85.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-76.0,85.0},{-5.0,85.0}}, color={128,128,128}),Text(extent={{18.0,92.0},{86.0,79.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{96.0,0.0}}, color={0,0,0}),Line(points={{-80.0,-100.0},{-80.0,0.0}}, color={0,0,255})}));

        equation 
          flange_a.phi=flange_b.phi;
          flange_a.tau=tau;
          flange_b.tau=-tau;
        end TorqueSensor;
        model AngleSensor "Ideal sensor to measure the absolute flange angle"
                  extends Modelica.Icons.RotationalSensor;
          Interfaces.Flange_a flange_a "flange to be measured" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput phi(redeclare type SignalType= SI.Angle ) "Absolute angle of flange" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <b>absolute angle phi</b> of a flange in an ideal
 way and provides the result as output signal <b>phi</b>
 (to be further processed with blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{70.0,-30.0},{120.0,-80.0}}, textString="phi", fillColor={0,0,0}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255})}));

        equation 
          phi=flange_a.phi;
          0=flange_a.tau;
        end AngleSensor;
        model SpeedSensor "Ideal sensor to measure the absolute flange angular velocity"
                  extends Modelica.Icons.RotationalSensor;
          Interfaces.Flange_a flange_a "flange to be measured" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput w(redeclare type SignalType= SI.AngularVelocity ) "Absolute angular velocity of flange" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <b>absolute angular velocity w</b> of a flange in an ideal
 way and provides the result as output signal <b>w</b>
 (to be further processed with blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{70.0,-30.0},{120.0,-80.0}}, textString="w", fillColor={0,0,0}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255})}));

        equation 
          w=der(flange_a.phi);
          0=flange_a.tau;
        end SpeedSensor;
        model AccSensor "Ideal sensor to measure the absolute flange angular acceleration"
                  extends Modelica.Icons.RotationalSensor;
          Interfaces.Flange_a flange_a "flange to be measured" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          SI.AngularVelocity w "Absolute angular velocity of flange";
          Modelica.Blocks.Interfaces.RealOutput a(redeclare type SignalType= SI.AngularAcceleration ) "Absolute angular acceleration of flange" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <b>absolute angular acceleration a</b> of a flange in an ideal
 way and provides the result as output signal <b>a</b> (to be further processed with
 blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{70.0,-30.0},{120.0,-80.0}}, textString="a", fillColor={0,0,0}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255})}));

        equation 
          w=der(flange_a.phi);
          a=der(w);
          0=flange_a.tau;
        end AccSensor;
        model RelAngleSensor "Ideal sensor to measure the relative angle between two flanges"
                  extends Modelica.Icons.RotationalSensor;
          Interfaces.Flange_a flange_a "driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput phi_rel(redeclare type SignalType= SI.Angle ) "Relative angle between two flanges (= flange_b.phi - flange_a.phi)" annotation(Placement(transformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <b>relative angle phi_rel</b> between two flanges
 in an ideal way and provides the result as output signal <b>phi_rel</b>
 (to be further processed with blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{20.0,-70.0},{160.0,-100.0}}, textString="phi_rel", fillColor={0,0,0}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{13.0,93.0},{-7.0,98.0},{-7.0,88.0},{13.0,93.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-77.0,93.0},{-6.0,93.0}}, color={128,128,128}),Text(extent={{17.0,100.0},{85.0,87.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255})}));

        equation 
          phi_rel=flange_b.phi - flange_a.phi;
          0=flange_a.tau;
          0=flange_b.tau;
        end RelAngleSensor;
        model RelSpeedSensor "Ideal sensor to measure the relative angular velocity between two flanges"
                  extends Modelica.Icons.RotationalSensor;
          Interfaces.Flange_a flange_a "driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          SI.Angle phi_rel "Relative angle between two flanges (flange_b.phi - flange_a.phi)";
          Modelica.Blocks.Interfaces.RealOutput w_rel(redeclare type SignalType= SI.AngularVelocity ) "Relative angular velocity between two flanges (= der(flange_b.phi) - der(flange_a.phi))" annotation(Placement(transformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <b>relative angular velocity w_rel</b> between two flanges
 in an ideal way and provides the result as output signal <b>w_rel</b>
 (to be further processed with blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{20.0,-70.0},{160.0,-100.0}}, textString="w_rel", fillColor={0,0,0}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{13.0,93.0},{-7.0,98.0},{-7.0,88.0},{13.0,93.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-77.0,93.0},{-6.0,93.0}}, color={128,128,128}),Text(extent={{17.0,100.0},{85.0,87.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0})}));

        equation 
          phi_rel=flange_b.phi - flange_a.phi;
          w_rel=der(phi_rel);
          0=flange_a.tau;
          0=flange_b.tau;
        end RelSpeedSensor;
        model RelAccSensor "Ideal sensor to measure the relative angular acceleration between two flanges"
                  extends Modelica.Icons.RotationalSensor;
          Interfaces.Flange_a flange_a "driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          SI.Angle phi_rel "Relative angle between two flanges (flange_b.phi - flange_a.phi)";
          SI.AngularVelocity w_rel "Relative angular velocity between two flanges";
          Modelica.Blocks.Interfaces.RealOutput a_rel(redeclare type SignalType= SI.AngularAcceleration ) "Relative angular acceleration between two flanges" annotation(Placement(transformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <b>relative angular acceleration a_rel</b> between two flanges
 in an ideal way and provides the result as output signal <b>a_rel</b>
 (to be further processed with blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{20.0,-70.0},{160.0,-100.0}}, textString="a_rel", fillColor={0,0,0}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{13.0,93.0},{-7.0,98.0},{-7.0,88.0},{13.0,93.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-77.0,93.0},{-6.0,93.0}}, color={128,128,128}),Text(extent={{17.0,100.0},{85.0,87.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255})}));

        equation 
          phi_rel=flange_b.phi - flange_a.phi;
          w_rel=der(phi_rel);
          a_rel=der(w_rel);
          0=flange_a.tau;
          0=flange_b.tau;
        end RelAccSensor;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-56.0,-61.0},{-56.0,-81.0}}, color={0,0,0}),Line(points={{-36.0,-61.0},{-36.0,-81.0}}, color={0,0,0}),Line(points={{-16.0,-61.0},{-16.0,-81.0}}, color={0,0,0}),Rectangle(extent={{-76.0,-81.0},{64.0,-1.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{4.0,-61.0},{4.0,-81.0}}, color={0,0,0}),Line(points={{24.0,-61.0},{24.0,-81.0}}, color={0,0,0}),Line(points={{44.0,-61.0},{44.0,-81.0}}, color={0,0,0}),Polygon(points={{-6.0,-61.0},{-16.0,-37.0},{4.0,-37.0},{-6.0,-61.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-6.0,-21.0},{-6.0,-37.0}}, color={0,0,0}),Line(points={{-76.0,-21.0},{-6.0,-21.0}}, color={0,0,0}),Line(points={{-56.0,-61.0},{-56.0,-81.0}}, color={0,0,0}),Line(points={{-36.0,-61.0},{-36.0,-81.0}}, color={0,0,0}),Line(points={{-16.0,-61.0},{-16.0,-81.0}}, color={0,0,0})}));
      end Sensors;
      import SI = Modelica.SIunits;
      extends Modelica.Icons.Library2;
      annotation(preferedView="info",Documentation(info="<html>
 <h4>Content</h4>
 <ol>
   <li>Overview of library Modelica.Mechanics.Rotational</li>
   <li>Components of the library</li>
   <li>Flange connectors</li>
   <li>Sign conventions</li>
   <li>User-defined components</li>
   <li>Requirements for simulation tools</li>
   <li>Support torque</li>
 </ol>
 <h4>1. Overview of library Modelica.Mechanics.Rotational</h4>
 <p>
 This package contains components to model <b>1-dimensional rotational
 mechanical</b> systems, including different types of gearboxes,
 shafts with inertia, external torques, spring/damper elements,
 frictional elements, backlash, elements to measure angle, angular velocity,
 angular acceleration and the cut-torque of a flange. In sublibrary
 <b>Examples</b> several examples are present to demonstrate the usage of
 the elements. Just open the corresponding example model and simulate
 the model according to the provided description.
 </p>
 <p>
 A unique feature of this library is the <b>component-oriented</b>
 modeling of <b>Coulomb friction</b> elements, such as friction in bearings,
 clutches, brakes, and gear efficiency. Even (dynamically) coupled
 friction elements, e.g., as in automatic gearboxes, can be handeled
 <b>without</b> introducing stiffness which leads to fast simulations.
 The underlying theory is new and is based on the solution of mixed
 continuous/discrete systems of equations, i.e., equations where the
 <b>unknowns</b> are of type <b>Real</b>, <b>Integer</b> or <b>Boolean</b>.
 Provided appropriate numerical algorithms for the solution of such types of
 systems are available in the simulation tool, the simulation of
 (dynamically) coupled friction elements of this library is
 <b>efficient</b> and <b>reliable</b>.
 </p>
 <p><IMG SRC=\"../Images/drive1.png\" ALT=\"drive1\"></p>
 <p>
 A simple example of the usage of this library is given in the
 figure above. This drive consists of a shaft with inertia J1=0.2 which
 is connected via an ideal gearbox with gear ratio=5 to a second shaft
 with inertia J2=5. The left shaft is driven via an external,
 sinusoidal torque.
 The <b>filled</b> and <b>non-filled grey squares</b> at the left and
 right side of a component represent <b>mechanical flanges</b>.
 Drawing a line between such squares means that the corresponding
 flanges are <b>rigidly attached</b> to each other.
 By convention in this library, the connector characterized as a
 <b>filled</b> grey square is called <b>flange_a</b> and placed at the
 left side of the component in the \"design view\" and the connector
 characterized as a <b>non-filled</b> grey square is called <b>flange_b</b>
 and placed at the right side of the component in the \"design view\".
 The two connectors are completely <b>identical</b>, with the only
 exception that the graphical layout is a little bit different in order
 to distinguish them for easier access of the connector variables.
 For example, <tt>J1.flange_a.tau</tt> is the cut-torque in the connector
 <tt>flange_a</tt> of component <tt>J1</tt>.
 </p>
 <p>
 The components of this
 library can be <b>connected</b> together in an <b>arbitrary</b> way. E.g., it is
 possible to connect two springs or two shafts with inertia directly
 together, see figure below.
 </p>
 <p><IMG SRC=\"../Images/driveConnections.png\" ALT=\"driveConnections\"></p>
 <h4>2. Components of the library</h4>
 <p>
 This package contains the following model components:
 </p>
 <table BORDER=1 CELLSPACING=0 CELLPADDING=2>
 <tr><th>Name</th><th>Description</th></tr>
 <tr><td><tt><b>Examples</b></tt></td><td>Sublibrary containing example models.</td></tr>
 <tr><td><tt><b>Interfaces</b></tt></td><td>Sublibrary containing interface definitions.</td></tr>
 <tr><td><tt><b>Inertia</b></tt></td><td>Rotational component with inertia.</td></tr>
 <tr><td><tt><b>IdealGear</b></tt></td><td>Ideal gear transforming rotational in rotational motion.</td></tr>
 <tr><td><tt><b>IdealPlanetary</b></tt></td><td>Ideal standard planetary gear.</td></tr>
 <tr><td><tt><b>IdealGearR2T</b></tt></td><td>Ideal gear transforming rotational in translational motion.</td></tr>
 <tr><td><tt><b>Spring</b></tt></td><td>Linear spring.</td></tr>
 <tr><td><tt><b>Damper</b></tt></td><td>Linear damper.</td></tr>
 <tr><td><tt><b>SpringDamper</b></tt></td><td>Linear spring and linear damper in parallel connection.</td></tr>
 <tr><td><tt><b>ElastoBacklash</b></tt></td><td>Linear spring, linear damper and backlash in series connection (backlash is modeled with elasticity).</td></tr>
 <tr><td><tt><b>BearingFriction</b></tt></td><td>Coulomb friction in the bearings.</td></tr>
 <tr><td><tt><b>Clutch</b></tt></td><td>Frictional clutch where the clutch pressure force is an input signal (= Coulomb friction between two flanges).</td></tr>
 <tr><td><tt><b>OneWayClutch</b></tt></td><td>Parallel connection of free wheel and clutch</td></tr>
 <tr><td><tt><b>Brake</b></tt></td><td>Frictional brake where the brake pressure force is an input signal (= Coulomb friction between flange and housing).</td></tr>
 <tr><td><tt><b>LossyGear</b></tt></td><td>Gear with mesh efficiency and bearing friction (stuck/rolling possible)</td></tr>
 <tr><td><tt><b>GearEfficiency</b></tt></td><td>Efficiency of a gearbox.</td></tr>
 <tr><td><tt><b>Gear</b></tt></td><td>Realistic model of a gearbox (taking into account efficiency, bearing friction, elasticity, damping, backlash)</td></tr>
 <tr><td><tt><b>GearNew</b></tt></td><td>Realistic model of a gearbox (taking into account efficiency, bearing friction, elasticity, damping, backlash), based on new component LossyGear</td></tr>
 <tr><td><tt><b>Position</b></tt></td><td>Forced movement of a flange with a reference angle given as input signal (positive angle for positive input signal).</td></tr>
 <tr><td><tt><b>Accelerate</b></tt></td><td>Forced movement of a flange with an angular acceleration given as input signal (positive acceleration for positive input signal).</td></tr>
 <tr><td><tt><b>Move</b></tt></td><td>Forced movement of a flange according to an angle, speed and angular acceleration given as input signals.</td></tr>
 <tr><td><tt><b>Fixed</b></tt></td><td>Fixing flange in housing at a predefined angle.</td></tr>
 <tr><td><tt><b>Torque</b></tt></td><td>External torque defined as input signal which accelerates the connected flange for positive input signal.</td></tr>
 <tr><td><tt><b>RelativeStates</b></tt></td><td>Definition of relative state variables</td></tr>
 <tr><td><tt><b>Sensors</b></tt></td><td>Sublibrary containing ideal sensors to measure flange variables.</td></tr>
 </table>
 <h4>3. Flange connectors</h4>
 <p>
 A flange is described by the connector class
 Interfaces.<b>Flange_a</b>
 or Interfaces.<b>Flange_b</b>. As already noted, the two connector
 classes are completely identical. There is only a difference in the icons,
 in order to easier identify a flange variable in a diagram.
 Both connector classes contain the following variables:
 </p>
 <pre>
    SIunits.Angle       phi  \"absolute rotation angle of flange\";
    <b>flow</b> SIunits.Torque tau  \"cut-torque in the flange\";
 </pre>
 <p>
 If needed, the angular velocity <tt>w</tt> and the
 angular acceleration <tt>a</tt> of a flange connector can be
 determined by differentiation of the flange angle <tt>phi</tt>:
 </p>
 <pre>
      w = <b>der</b>(phi);    a = <b>der</b>(w);
 </pre>
 <h4>4. Sign conventions</h4>
 <p>
 The variables of a component of this library can be accessed in the
 usual way. However, since most of these variables are basically elements
 of <b>vectors</b>, i.e., have a direction, the question arises how the
 signs of variables shall be interpreted. The basic idea is explained
 at hand of the following figure:
 </p>
 <p><IMG SRC=\"../Images/drive2.png\" ALT=\"drive2\"></p>
 <p>
 In the figure, three identical drive trains are shown. The only
 difference is that the gear of the middle drive train and the
 gear as well as the right inertia of the lower drive train
 are horizontally flipped with regards to the upper drive train.
 The signs of variables are now interpreted in the following way:
 Due to the 1-dimensional nature of the model, all components are
 basically connected together along one line (more complicated
 cases are discussed below). First, one has to define
 a <b>positive</b> direction of this line, called <b>axis of rotation</b>.
 In the top part of the figure this is characterized by an arrow
 defined as <tt>axis of rotation</tt>. The simple rule is now:
 If a variable of a component is positive and can be interpreted as
 the element of a vector (e.g. torque or angular velocity vector), the
 corresponding vector is directed into the positive direction
 of the axis of rotation. In the following figure, the right-most
 inertias of the figure above are displayed with the positive
 vector direction displayed according to this rule:
 </p>
 <p><IMG SRC=\"../Images/drive3.png\" ALT=\"drive3\"></p>
 <p>
 The cut-torques <tt>J2.flange_a.tau, J4.flange_a.tau, J6.flange_b.tau</tt>
 of the right inertias are all identical and are directed into the
 direction of rotation if the values are positive. Similiarily,
 the angular velocities <tt>J2.w, J4.w, J6.w</tt> of the right inertias
 are all identical and are also directed into the
 direction of rotation if the values are positive. Some special
 cases are shown in the next figure:
 </p>
 <p><IMG SRC=\"../Images/drive4.png\" ALT=\"drive4\"></p>
 <p>
 In the upper part of the figure, two variants of the connection of an
 external torque and an inertia are shown. In both cases, a positive
 signal input into the torque component accelerates the inertias
 <tt>inertia1, inertia2</tt> into the positive axis of rotation,
 i.e., the angular accelerations <tt>inertia1.a, inertia2.a</tt>
 are positive and are directed along the \"axis of rotation\" arrow.
 In the lower part of the figure the connection of inertias with
 a planetary gear is shown. Note, that the three flanges of the
 planetary gearbox are located along the axis of rotation and that
 the axis direction determines the positive rotation along these
 flanges. As a result, the positive rotation for <tt>inertia4, inertia6</tt>
 is as indicated with the additional grey arrows.
 </p>
 <h4>5. User-defined components</h4>
 <p>
 In this section some hints are given to define your own
 1-dimensional rotational components which are compatible with the
 elements of this package.
 It is convenient to define a new
 component by inheritance from one of the following base classes,
 which are defined in sublibrary Interfaces:
 </p>
 <table BORDER=1 CELLSPACING=0 CELLPADDING=2>
 <tr><th>Name</th><th>Description</th></tr>
 <tr><td><tt><b>Rigid</b></tt></td><td>Rigid connection of two rotational 1D flanges (used for elements with inertia).</td></tr>
 <tr><td><tt><b>Compliant</b></tt></td><td>Compliant connection of two rotational 1D flanges (used for force laws such as a spring or a damper).</td></tr>
 <tr><td><tt><b>TwoFlanges</b></tt></td><td>General connection of two rotational 1D flanges (used for gearboxes).</td></tr>
 <tr><td><tt><b>AbsoluteSensor</b></tt></td><td>Measure absolute flange variables.</td></tr>
 <tr><td><tt><b>RelativeSensor</b></tt></td><td>Measure relative flange variables.</td></tr>
 </table>
 <p>
 The difference between these base classes are the auxiliary
 variables defined in the model and the relations between
 the flange variables already defined in the base class.
 For example, in model <b>Rigid</b> the flanges flange_a and
 flange_b are rigidly connected, i.e., flange_a.phi = flange_b.phi,
 whereas in model <b>Compliant</b> the cut-torques are the
 same, i.e., flange_a.tau + flange_b.tau = 0.
 </p>
 <p>
 The equations of a mechanical component are vector equations, i.e.,
 they need to be expressed in a common coordinate system.
 Therefore, for a component a <b>local axis of rotation</b> has to be
 defined. All vector quantities, such as cut-torques or angular
 velocities have to be expressed according to this definition.
 Examples for such a definition are given in the following figure
 for an inertia component and a planetary gearbox:
 </p>
 <p><IMG SRC=\"../Images/driveAxis.png\" ALT=\"driveAxis\"></p>
 <p>
 As can be seen, all vectors are directed into the direction
 of the rotation axis. The angles in the flanges are defined
 correspondingly. For example, the angle <tt>sun.phi</tt> in the
 flange of the sun wheel of the planetary gearbox is positive,
 if rotated in mathematical positive direction (= counter clock
 wise) along the axis of rotation.
 </p>
 <p>
 On first view, one may assume that the selected local
 coordinate system has an influence on the usage of the
 component. But this is not the case, as shown in the next figure:
 </p>
 <p><IMG SRC=\"../Images/inertias.png\" ALT=\"inertias\"></p>
 <p>
 In the figure the <b>local</b> axes of rotation of the components
 are shown. The connection of two inertias in the left and in the
 right part of the figure are completely equivalent, i.e., the right
 part is just a different drawing of the left part. This is due to the
 fact, that by a connection, the two local coordinate systems are
 made identical and the (automatically) generated connection equations
 (= angles are identical, cut-torques sum-up to zero) are also
 expressed in this common coordinate system. Therefore, even if in
 the left figure it seems to be that the angular velocity vector of
 <tt>J2</tt> goes from right to left, in reality it goes from
 left to right as shown in the right part of the figure, where the
 local coordinate systems are drawn such that they are aligned.
 Note, that the simple rule stated in section 4 (Sign conventions)
 also determines that
 the angular velocity of <tt>J2</tt> in the left part of the
 figure is directed from left to right.
 </p>
 <p>
 To summarize, the local coordinate system selected for a component
 is just necessary, in order that the equations of this component
 are expressed correctly. The selection of the coordinate system
 is arbitrary and has no influence on the usage of the component.
 Especially, the actual direction of, e.g., a cut-torque is most
 easily determined by the rule of section 4. A more strict determination
 by aligning coordinate systems and then using the vector direction
 of the local coordinate systems, often requires a re-drawing of the
 diagram and is therefore less convenient to use.
 </p>
 <h4>6. Requirements for simulation tools</h4>
 <p>
 This library is designed in a fully object oriented way in order that
 components can be connected together in every meaningful combination
 (e.g. direct connection of two springs or two inertias).
 As a consequence, most models lead to a system of
 differential-algebraic equations of <b>index 3</b> (= constraint
 equations have to be differentiated twice in order to arrive at
 a state space representation) and the Modelica translator or
 the simulator has to cope with this system representation.
 According to our present knowledge, this requires that the
 Modelica translator is able to symbolically differentiate equations
 (otherwise it is e.g. not possible to provide consistent initial
 conditions; even if consistent initial conditions are present, most
 numerical DAE integrators can cope at most with index 2 DAEs).
 </p>
 </p>
 The elements of this library can be connected together in an
 arbitrary way. However, difficulties may occur, if the elements which can <b>lock</b> the
 <b>relative motion</b> between two flanges are connected <b>rigidly</b>
 together such that essentially the <b>same relative motion</b> can be locked.
 The reason is
 that the cut-torque in the locked phase is not uniquely defined if the
 elements are locked at the same time instant (i.e., there does not exist a
 unique solution) and some simulation systems may not be
 able to handle this situation, since this leads to a singularity during
 simulation. Currently, this type of problem can occur with the
 Coulomb friction elements <b>BearingFriction, Clutch, Brake, LossyGear</b> when
 the elements become stuck:
 </p>
 <p><IMG SRC=\"../Images/driveConnections2.png\" ALT=\"driveConnections2\"></p>
 <p>
 In the figure above two typical situations are shown: In the upper part of
 the figure, the series connection of rigidly attached BearingFriction and
 Clutch components are shown. This does not hurt, because the BearingFriction
 element can lock the relative motion between the element and the housing,
 whereas the clutch element can lock the relative motion between the two
 connected flanges. Contrary, the drive train in the lower part of the figure
 may rise to simulation problems, because the BearingFriction element
 and the Brake element can lock the relative motion between a flange and
 the housing and these flanges are rigidly connected together, i.e.,
 essentially the same relative motion can be locked. These difficulties
 may be solved by either introducing a compliance between these flanges
 or by combining the BearingFriction and Brake element into
 one component and resolving the ambiguity of the frictional torque in the
 stuck mode. A tool may handle this situation also <b>automatically</b>,
 by picking one solution of the infinitely many, e.g., the one where
 the difference to the value of the previous time instant is as small
 as possible.
 </p>
 <h4>7. Support torques</h4>
 <p>The following figure shows examples of components equipped with
 a bearing flange (framed flange in the lower center), which can be used
 to fix components on the ground or on other rotating elements or to combine
 them with force elements. If the bearing flange is not connected, the
 components are assumed to be mounted on the ground. Otherwise, the bearing
 connector offers the possibility to consider, e.g., gearboxes mounted on
 the ground via spring-damper-systems (cf. example <tt>ElasticBearing</tt>). Independently, these components
 provide a variable <tt>tau_support</tt> stating the support torque exerted
 on the bearing.</p>
 <p><IMG SRC=\"../Images/bearing.png\" ALT=\"bearing\"></p>
 <p>In general, it is not necessary to connect the bearing flange
 with a fixation, i.e., the two implementations in the following figure give
 identical results.</p>
 <p><IMG SRC=\"../Images/bearing2.png\" ALT=\"bearing2\"></p>
 <dl>
 <dt><b>Main Author:</b></dt>
 <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
     Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
     Institut f&uuml;r Robotik und Mechatronik<br>
     Postfach 11 16<br>
     D-82230 Wessling<br>
     Germany<br>
     email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br></dd>
 </dl>
 
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association and DLR.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Bearing flanges added for mounted components and support torque computation implemented.<br>
        New component <tt>Torque2</tt> and new example <tt>ElasticBearing</tt>.
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New components <b>LossyGear</b> (with corresponding examples) and <b>Gear2</b>.<br>
        Interface <b>FrictionBase</b> adapted to new initialization.</li>
 <li><i>June 19, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        New elements:<br><!-- silly construction follows as Dymola not able to handle nested lists -->
        <tt>IdealGearR2T&nbsp;&nbsp;&nbsp;</tt> Ideal gear transforming rotational in translational motion<br>
        <tt>Position&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</tt> Forced movement of a flange with a reference angle given as input signal<br>
        <tt>RelativeStates&nbsp;</tt> Definition of relative state variables<br>
        Icon of Rotational.Torque changed.
        Elements Acceleration, Torque, Fixed, Sensors ordered according
        to the Translational library.</li>
 <li><i>Nov. 4, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Improved documentation and improved graphical layout of the diagram level.
        Changes according to the Twente meeting introduced. Especially:
        Alias names, instead of extends. Model Shaft renamed to Inertia.
        Torque1D renamed to Torque.
        AccMotion renamed to Accelerate. LockedL, LockedR replaced by Fixed.
        SpeedSensor splitted into AngleSensor and
        SpeedSensor. RelSpeedSensor splitted into RelAngleSensor and
        RelSpeedSensor. Initialization of friction elements improved.
        Flanges renamed to flange_a, flange_b. MoveAngle renamed to
        KinematicPTP, vectorized and moved to Blocks.Sources.<br>
        Advice given from P. Beater, H. Elmqvist, S.E. Mattsson, H. Olsson
        is appreciated.</li>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Documentation and icons improved. Appropriate initial conditions
        introduced as start values in the demo models. Bearing model
        replaced by FixedRight and FixedLeft models; sensor elements replaced by
        TorqueSensor, SpeedSensor, AccSensor; new sensor elements
        RelSpeedSensor, RelAccSensor to measure relative kinematic quantitites.
        New elements GearEfficiency and Gear.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized a first version based on an existing Dymola library
        of Martin Otter and Hilding Elmqvist.</li>
 </ul>
 </html>"),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-83.0,-66.0},{-63.0,-66.0}}, color={0,0,0}),Line(points={{36.0,-68.0},{56.0,-68.0}}, color={0,0,0}),Line(points={{-73.0,-66.0},{-73.0,-91.0}}, color={0,0,0}),Line(points={{46.0,-68.0},{46.0,-91.0}}, color={0,0,0}),Line(points={{-83.0,-29.0},{-63.0,-29.0}}, color={0,0,0}),Line(points={{36.0,-32.0},{56.0,-32.0}}, color={0,0,0}),Line(points={{-73.0,-9.0},{-73.0,-29.0}}, color={0,0,0}),Line(points={{46.0,-12.0},{46.0,-32.0}}, color={0,0,0}),Line(points={{-73.0,-91.0},{46.0,-91.0}}, color={0,0,0}),Rectangle(extent={{-47.0,-17.0},{27.0,-80.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-87.0,-41.0},{-47.0,-54.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{27.0,-42.0},{66.0,-56.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder)}));
      package Interfaces "Connectors and partial models for 1D rotational mechanical components"
              extends Modelica.Icons.Library;
        annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package contains connectors and partial models for 1D rotational mechanical
 components. In particular
 </p>
 <pre>
   <b>Flange_a</b>                 Left flange of a component.
   <b>Flange_b</b>                 Right flange of a component.
   <b>Rigid</b>                    Rigid connection of two rotational 1D flanges
                            (used for elements with inertia).
   <b>Compliant</b>                Compliant connection of two rotational 1D flanges
                            (used for force laws such as a spring or a damper).
   <b>TwoFlanges</b>               Component with two rotational 1D flanges
   <b>Bearing</b>                  Component with two rotational 1D flanges, one bearing flange
                            and cardinality dependent equations
   <b>TwoFlangesAndBearing</b>     Component inherited from Bearing for equation-based classes
   <b>TwoFlangesAndBearingH</b>    Component inherited from Bearing for hierarchical components
   <b>AbsoluteSensor</b>           Base class to measure absolute flange variables.
   <b>RelativeSensor</b>           Base class to measure relative flange variables.
 </pre>
 <dl>
 <dt><b>Main Author:</b>
 <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
     Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
     Institut f&uuml;r Robotik und Mechatronik<br>
     Postfach 1116<br>
     D-82230 Wessling<br>
     Germany<br>
     email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br>
 </dl>
 <br>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a> and
        <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New components: Bearing, TwoFlangesAndBearing and TwoFlangesAndBearingH.</li>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Component FrictionBase adapted to new initialization.</li>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        New components: TwoFlanges, AbsoluteSensor, RelativeSensor.</li>
 <li><i>June 28, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 <br>
 <p><b>Copyright &copy; 1999-2003, Modelica Association and DLR.</b></p>
 <p><i>
 The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".
 </i></p>
 </HTML>
 "));
        connector Flange_a "1D rotational flange (filled square icon)"
                  SI.Angle phi "Absolute rotation angle of flange";
          flow SI.Torque tau "Cut torque in the flange";
          annotation(defaultComponentName="flange_a",Documentation(info="<HTML>
 <p>
 This is a connector for 1D rotational mechanical systems and models
 a mechanical flange. The following variables are defined in this connector:
 </p>
 <pre>
    <b>phi</b>: Absolute rotation angle of the flange in [rad].
    <b>tau</b>: Cut-torque in the flange in [Nm].
 </pre>
 <p>
 There is a second connector for flanges: Flange_b. The connectors
 Flange_a and Flange_b are completely identical. There is only a difference
 in the icons, in order to easier identify a flange variable in a diagram.
 For a discussion on the actual direction of the cut-torque tau and
 of the rotation angle, see the information text of package Rotational
 (section 4. Sign conventions).
 </p>
 <p>
 If needed, the absolute angular velocity w and the
 absolute angular acceleration a of the flange can be determined by
 differentiation of the flange angle phi:
 </p>
 <pre>
      w = der(phi);    a = der(w)
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 2, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Improved documentation.</li>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-100.0,100.0},{100.0,-100.0}}, lineColor={0,0,0}, fillColor={128,128,128}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-160.0,110.0},{40.0,50.0}}, textString="%name", fillColor={0,0,0}),Ellipse(extent={{-40.0,40.0},{40.0,-40.0}}, lineColor={0,0,0}, fillColor={128,128,128}, fillPattern=FillPattern.Solid)}));
        end Flange_a;
        connector Flange_b "1D rotational flange (non-filled square icon)"
                  SI.Angle phi "Absolute rotation angle of flange";
          flow SI.Torque tau "Cut torque in the flange";
          annotation(defaultComponentName="flange_b",Documentation(info="<HTML>
 <p>
 This is a connector for 1D rotational mechanical systems and models
 a mechanical flange. The following variables are defined in this connector:
 </p>
 <pre>
    <b>phi</b>: Absolute rotation angle of the flange in [rad].
    <b>tau</b>: Cut-torque in the flange in [Nm].
 </pre>
 <p>
 There is a second connector for flanges: Flange_a. The connectors
 Flange_a and Flange_b are completely identical. There is only a difference
 in the icons, in order to easier identify a flange variable in a diagram.
 For a discussion on the actual direction of the cut-torque tau and
 of the rotation angle, see the information text of package Rotational
 (section 4. Sign conventions).
 </p>
 <p>
 If needed, the absolute angular velocity w and the
 absolute angular acceleration a of the flange can be determined by
 differentiation of the flange angle phi:
 </p>
 <pre>
      w = der(phi);    a = der(w)
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 2, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Improved documentation.</li>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-98.0,100.0},{102.0,-100.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-40.0,40.0},{40.0,-40.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,110.0},{160.0,50.0}}, textString="%name", fillColor={0,0,0})}));
        end Flange_b;
        partial model Rigid "Base class for the rigid connection of two rotational 1D flanges"
                  SI.Angle phi "Absolute rotation angle of component (= flange_a.phi = flange_b.phi)";
          Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 This is a 1D rotational component with two rigidly connected flanges,
 i.e., flange_a.phi = flange_b.phi. It is used e.g. to built up components
 with inertia.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

        equation 
          flange_a.phi=phi;
          flange_b.phi=phi;
        end Rigid;
        partial model Compliant "Base class for the compliant connection of two rotational 1D flanges"
                  SI.Angle phi_rel(start=0) "Relative rotation angle (= flange_b.phi - flange_a.phi)";
          SI.Torque tau "Torque between flanges (= flange_b.tau)";
          Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 This is a 1D rotational component with a compliant connection of two
 rotational 1D flanges where inertial effects between the two
 flanges are neglected. The basic assumption is that the cut-torques
 of the two flanges sum-up to zero, i.e., they have the same absolute value
 but opposite sign: flange_a.tau + flange_b.tau = 0. This base class
 is used to built up force elements such as springs, dampers, friction.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

        equation 
          phi_rel=flange_b.phi - flange_a.phi;
          flange_b.tau=tau;
          flange_a.tau=-tau;
        end Compliant;
        partial model TwoFlanges "Base class for a component with two rotational 1D flanges"
                  Flange_a flange_a annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 This is a 1D rotational component with two flanges.
 It is used e.g. to build up parts of a drive train consisting
 of several base components. There are specialized versions of this
 base class for rigidly connected flanges (Interfaces.Rigid) and
 for a compliant connection of flanges (Interfaces.Compliant).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
        end TwoFlanges;
        partial model Bearing "Base class for interface classes with bearing connector"
                  extends TwoFlanges;
          SI.Torque tau_support;
          Flange_a bearing annotation(Placement(transformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0)));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-20.0,-80.0},{20.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-20.0,-80.0},{20.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}),Documentation(info="<html>
 <p>
 This is a 1D rotational component with two flanges and an additional bearing flange.
 It is a superclass for the two components TwoFlangesAndBearing and TwoFlangesAndBearingH.</p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));
        end Bearing;
        partial model TwoFlangesAndBearing "Base class for a equation-based component with two rotational 1D flanges and one rotational 1D bearing flange"
                  extends Bearing;
          SI.Angle phi_a;
          SI.Angle phi_b;
          annotation(Documentation(info="<html>
 <p>
 This is a 1D rotational component with two flanges and an additional bearing flange.
 It is used e.g. to build up equation-based parts of a drive train.</p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

        equation 
          if cardinality(bearing) == 0 then
            bearing.phi=0;

          else
            bearing.tau=tau_support;

          end if;
          0=flange_a.tau + flange_b.tau + tau_support;
          phi_a=flange_a.phi - bearing.phi;
          phi_b=flange_b.phi - bearing.phi;
        end TwoFlangesAndBearing;
        partial model TwoFlangesAndBearingH "Base class for a hierarchically composed component with two rotational 1D flanges and one rotational bearing flange"
                  extends Bearing;
          Adapter adapter(bearingConnected=cardinality(bearing) > 1) annotation(Placement(transformation(x=0.0,y=-60.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=0.0,y=-60.0,scale=0.1,aspectRatio=1.0,rotation=90)));
        protected 
          encapsulated model Adapter
                      import Modelica.Mechanics.Rotational.Interfaces.TwoFlanges;
            extends TwoFlanges;
            parameter Boolean bearingConnected;
            annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-90.0,10.0},{90.0,-10.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{0.0,60.0},{0.0,20.0}}, textString="%name", fillColor={0,0,255})}));

          equation 
            flange_a.phi=flange_b.phi;
            if bearingConnected then
              0=flange_a.tau + flange_b.tau;

            else
              0=flange_a.phi;

            end if;
          end Adapter;

        equation 
          tau_support=-adapter.flange_b.tau;
          connect(adapter.flange_a,bearing) annotation(Line(points={{-6.12303e-016,-70.0},{0.0,-70.0},{0.0,-100.0}},color={0,0,0}));
          annotation(Documentation(info="<html>
 <p>
 This is a 1D rotational component with two flanges and an additional bearing flange.
 It is used e.g. to build up parts of a drive train consisting
 of several base components.</p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));
        end TwoFlangesAndBearingH;
        partial model FrictionBase "Base class of Coulomb friction elements"
                  parameter SI.AngularVelocity w_small=10e10 "Relative angular velocity near to zero if jumps due to a reinit(..) of the velocity can occur (set to low value only if such impulses can occur)" annotation(Dialog(tab="Advanced"));
          SI.AngularVelocity w_relfric "Relative angular velocity between frictional surfaces";
          SI.AngularAcceleration a_relfric "Relative angular acceleration between frictional surfaces";
          SI.Torque tau "Friction torque (positive, if directed in opposite direction of w_rel)";
          SI.Torque tau0 "Friction torque for w=0 and forward sliding";
          SI.Torque tau0_max "Maximum friction torque for w=0 and locked";
          Boolean free "true, if frictional element is not active";
          Real sa "Path parameter of friction characteristic tau = f(a_relfric)";
          Boolean startForward(start=false,fixed=true) "true, if w_rel=0 and start of forward sliding or w_rel > w_small";
          Boolean startBackward(start=false,fixed=true) "true, if w_rel=0 and start of backward sliding or w_rel < -w_small";
          Boolean locked "true, if w_rel=0 and not sliding";
          constant Integer Unknown=3 "Value of mode is not known";
          constant Integer Free=2 "Element is not active";
          constant Integer Forward=1 "w_rel > 0 (forward sliding)";
          constant Integer Stuck=0 "w_rel = 0 (forward sliding, locked or backward sliding)";
          constant Integer Backward=-1 "w_rel < 0 (backward sliding)";
          Integer mode(final min=Backward,final max=Unknown,start=Unknown,fixed=true);

        equation 
          startForward=pre(mode) == Stuck and sa > tau0_max or pre(startForward) and sa > tau0 or pre(mode) == Backward and w_relfric > w_small or initial() and w_relfric > 0;
          startBackward=pre(mode) == Stuck and sa < -tau0_max or pre(startBackward) and sa < -tau0 or pre(mode) == Forward and w_relfric < -w_small or initial() and w_relfric < 0;
          locked=not free and not (pre(mode) == Forward or startForward or pre(mode) == Backward or startBackward);
          a_relfric=if locked then 0 else if free then sa else if startForward then sa - tau0 else if startBackward then sa + tau0 else if pre(mode) == Forward then sa - tau0 else sa + tau0;
          mode=if free then Free else if (pre(mode) == Forward or pre(mode) == Free or startForward) and (w_relfric > 0) then Forward else if (pre(mode) == Backward or pre(mode) == Free or startBackward) and (w_relfric < 0) then Backward else Stuck;
        end FrictionBase;
        partial model AbsoluteSensor "Base class to measure a single absolute flange variable"
                  extends Modelica.Icons.RotationalSensor;
          Flange_a flange_a "(left) flange to be measured (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 This is the base class of a 1D rotational component with one flange and one
 output signal y in order to measure an absolute kinematic quantity in the flange
 and to provide the measured signal as output signal for further processing
 with the blocks of package Modelica.Blocks.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{150.0,80.0},{-150.0,120.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255})}));
        end AbsoluteSensor;
        partial model RelativeSensor "Base class to measure a single relative variable between two flanges"
                  extends Modelica.Icons.RotationalSensor;
          Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput y annotation(Placement(transformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true)));
          annotation(Documentation(info="<html>
 <p>
 This is a base class for 1D rotational components with two rigidly connected
 flanges and one output signal y in order to measure relative kinematic quantities
 between the two flanges or the cut-torque in the flange and
 to provide the measured signal as output signal for further processing
 with the blocks of package Modelica.Blocks.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255}),Text(extent={{0.0,70.0},{0.0,110.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-70.0}}, color={0,0,255})}));
        end RelativeSensor;
        partial model PartialSpeedDependentTorque "Partial model of a torque acting at the flange (accelerates the flange)"
                  Modelica.SIunits.AngularVelocity w=der(flange.phi) "Angular velocity at flange";
          Modelica.SIunits.Torque tau=flange.tau "accelerating torque acting at flange";
          Modelica.Mechanics.Rotational.Interfaces.Flange_b flange "Flange on which torque is acting" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_a bearing "Bearing at which the reaction torque (i.e., -flange.tau) is acting" annotation(Placement(transformation(x=0.0,y=-120.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-120.0,scale=0.1,aspectRatio=1.0)));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-96.0,96.0},{96.0,-96.0}}, lineColor={255,255,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-30.0,-70.0},{30.0,-70.0}}, color={0,0,0}),Line(points={{-30.0,-90.0},{-10.0,-70.0}}, color={0,0,0}),Line(points={{-10.0,-90.0},{10.0,-70.0}}, color={0,0,0}),Rectangle(extent={{-20.0,-100.0},{20.0,-140.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{10.0,-90.0},{30.0,-70.0}}, color={0,0,0}),Line(points={{0.0,-70.0},{0.0,-110.0}}, color={0,0,0}),Line(points={{-92.0,0.0},{-76.0,36.0},{-54.0,62.0},{-30.0,80.0},{-14.0,88.0},{10.0,92.0},{26.0,90.0},{46.0,80.0},{64.0,62.0}}, color={0,0,0}),Text(extent={{-162.0,162.0},{162.0,98.0}}, fillColor={0,0,255}, textString="%name"),Polygon(points={{94.0,16.0},{80.0,74.0},{50.0,52.0},{94.0,16.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}),Documentation(info="<HTML>
 <p>
 Partial model of torque dependent on speed that accelerates the flange.
 </p>
 </HTML>"));

        equation 
          if cardinality(bearing) == 0 then
            bearing.phi=0;

          else
            bearing.tau=-flange.tau;

          end if;
        end PartialSpeedDependentTorque;
      end Interfaces;
      model Inertia "1D-rotational component with inertia"
              parameter SI.Inertia J=1 "Moment of inertia";
        SI.AngularVelocity w "Absolute angular velocity of component";
        SI.AngularAcceleration a "Absolute angular acceleration of component";
        annotation(Documentation(info="<html>
 <p>
 Rotational component with <b>inertia</b> and two rigidly connected flanges.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,10.0},{-50.0,-10.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{50.0,10.0},{100.0,-10.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-80.0,-25.0},{-60.0,-25.0}}, color={0,0,0}),Line(points={{60.0,-25.0},{80.0,-25.0}}, color={0,0,0}),Line(points={{-70.0,-25.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{70.0,-25.0},{70.0,-70.0}}, color={0,0,0}),Line(points={{-80.0,25.0},{-60.0,25.0}}, color={0,0,0}),Line(points={{60.0,25.0},{80.0,25.0}}, color={0,0,0}),Line(points={{-70.0,45.0},{-70.0,25.0}}, color={0,0,0}),Line(points={{70.0,45.0},{70.0,25.0}}, color={0,0,0}),Line(points={{-70.0,-70.0},{70.0,-70.0}}, color={0,0,0}),Rectangle(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Text(extent={{0.0,120.0},{0.0,60.0}}, textString="%name", fillColor={0,0,255}),Text(extent={{0.0,-80.0},{0.0,-130.0}}, textString="J=%J", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-25.0},{-60.0,-25.0}}, color={0,0,0}),Line(points={{60.0,-25.0},{80.0,-25.0}}, color={0,0,0}),Line(points={{-70.0,-25.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{70.0,-25.0},{70.0,-70.0}}, color={0,0,0}),Line(points={{-80.0,25.0},{-60.0,25.0}}, color={0,0,0}),Line(points={{60.0,25.0},{80.0,25.0}}, color={0,0,0}),Line(points={{-70.0,45.0},{-70.0,25.0}}, color={0,0,0}),Line(points={{70.0,45.0},{70.0,25.0}}, color={0,0,0}),Line(points={{-70.0,-70.0},{70.0,-70.0}}, color={0,0,0}),Rectangle(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-96.0,10.0},{-50.0,-10.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{50.0,10.0},{96.0,-10.0}}, lineColor={0,0,0}, pattern=LinePattern.None, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{0.0,-90.0},{-20.0,-85.0},{-20.0,-95.0},{0.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-90.0},{-19.0,-90.0}}, color={128,128,128}),Text(extent={{4.0,-83.0},{72.0,-96.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{9.0,73.0},{19.0,70.0},{9.0,67.0},{9.0,73.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{9.0,70.0},{-21.0,70.0}}, color={0,0,0}),Text(extent={{25.0,77.0},{77.0,65.0}}, textString="w = der(phi) ", fillColor={0,0,255})}));
        extends Interfaces.Rigid;

      equation 
        w=der(phi);
        a=der(w);
        J*a=flange_a.tau + flange_b.tau;
      end Inertia;
      model IdealGear "Ideal gear without inertia"
              extends Interfaces.TwoFlangesAndBearing;
        parameter Real ratio=1 "Transmission ratio (flange_a.phi/flange_b.phi)";
        annotation(Documentation(info="<html>
 <p>
 This element characterices any type of gear box which is fixed in the
 ground and which has one driving shaft and one driven shaft.
 The gear is <b>ideal</b>, i.e., it does not have inertia, elasticity, damping
 or backlash. If these effects have to be considered, the gear has to be
 connected to other elements in an appropriate way.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-40.0,20.0},{-20.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-40.0,140.0},{-20.0,20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,100.0},{40.0,60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,60.0},{40.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{40.0,10.0},{100.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-20.0,90.0},{20.0,70.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-100.0,10.0},{-40.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Text(extent={{0.0,190.0},{0.0,130.0}}, textString="%name=%ratio", fillColor={0,0,255}),Line(points={{-80.0,20.0},{-60.0,20.0}}, color={0,0,0}),Line(points={{-80.0,-20.0},{-60.0,-20.0}}, color={0,0,0}),Line(points={{-70.0,-20.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{0.0,60.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{-10.0,60.0},{10.0,60.0}}, color={0,0,0}),Line(points={{-10.0,100.0},{10.0,100.0}}, color={0,0,0}),Line(points={{60.0,-20.0},{80.0,-20.0}}, color={0,0,0}),Line(points={{60.0,20.0},{80.0,20.0}}, color={0,0,0}),Line(points={{70.0,-20.0},{70.0,-70.0}}, color={0,0,0}),Line(points={{70.0,-70.0},{-70.0,-70.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-40.0,20.0},{-20.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-40.0,140.0},{-20.0,20.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,100.0},{40.0,60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,60.0},{40.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-96.0,10.0},{-40.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{40.0,10.0},{96.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-20.0,90.0},{20.0,70.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-90.0,-80.0},{-20.0,-80.0}}, color={128,128,128}),Polygon(points={{0.0,-80.0},{-20.0,-75.0},{-20.0,-85.0},{0.0,-80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{34.0,-72.0},{34.0,-86.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-80.0,20.0},{-60.0,20.0}}, color={0,0,0}),Line(points={{-80.0,-20.0},{-60.0,-20.0}}, color={0,0,0}),Line(points={{-70.0,-20.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{70.0,-70.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{0.0,60.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{-10.0,60.0},{10.0,60.0}}, color={0,0,0}),Line(points={{-10.0,100.0},{10.0,100.0}}, color={0,0,0}),Line(points={{60.0,20.0},{80.0,20.0}}, color={0,0,0}),Line(points={{60.0,-20.0},{80.0,-20.0}}, color={0,0,0}),Line(points={{70.0,-20.0},{70.0,-70.0}}, color={0,0,0})}));

      equation 
        phi_a=ratio*phi_b;
        0=ratio*flange_a.tau + flange_b.tau;
      end IdealGear;
      model IdealPlanetary "Ideal planetary gear box"
              parameter Real ratio=100/50 "number of ring_teeth/sun_teeth (e.g. ratio=100/50)";
        Interfaces.Flange_a sun "sun flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Interfaces.Flange_a carrier "carrier flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(x=-100.0,y=40.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=40.0,scale=0.1,aspectRatio=1.0)));
        Interfaces.Flange_b ring "ring flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 The IdealPlanetary gear box is an ideal gear without inertia,
 elasticity, damping or backlash consisting
 of an inner <b>sun</b> wheel, an outer <b>ring</b> wheel and a
 <b>planet</b> wheel located between sun and ring wheel. The bearing
 of the planet wheel shaft is fixed in the planet <b>carrier</b>.
 The component can be connected to other elements at the
 sun, ring and/or carrier flanges. It is not possible to connect
 to the planet wheel. If inertia shall not be neglected,
 the sun, ring and carrier inertias can be easily added by attaching
 inertias (= model Inertia) to the corresponding connectors.
 The inertias of the planet wheels are always neglected.
 </p>
 <p>
 The icon of the planetary gear signals that the sun and carrier
 flanges are on the left side and the ring flange is on the right side
 of the gear box. However, this component is generic and is valid
 independantly how the flanges are actually placed (e.g. sun wheel
 may be placed on the right side instead on the left side in reality).
 </p>
 <p>
 The ideal planetary gearbox is uniquely defined by the ratio
 of the number of ring teeth zr with respect to the number of
 sun teeth zs. For example, if there are 100 ring teeth and
 50 sun teeth then ratio = zr/zs = 2. The number of planet teeth
 zp has to fulfill the following relationship:
 </p>
 <pre>
    <b>zp := (zr - zs) / 2</b>
 </pre>
 <p>
 Therefore, in the above example zp = 25 is required.
 </p>
 <p>
 According to the overall convention, the positive direction of all
 vectors, especially the absolute angular velocities and cut-torques
 in the flanges, are along the axis vector displayed in the icon.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 5, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{50.0,100.0},{10.0,-100.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-10.0,45.0},{-50.0,85.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-10.0,30.0},{-50.0,-30.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-50.0,10.0},{-100.0,-10.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{100.0,10.0},{50.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{50.0,100.0},{-50.0,105.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Rectangle(extent={{50.0,-100.0},{-50.0,-105.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Rectangle(extent={{-80.0,70.0},{-50.0,60.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-90.0,40.0},{-70.0,40.0}}, color={0,0,0}),Line(points={{-80.0,50.0},{-60.0,50.0}}, color={0,0,0}),Line(points={{-70.0,50.0},{-70.0,40.0}}, color={0,0,0}),Line(points={{-80.0,80.0},{-59.0,80.0}}, color={0,0,0}),Line(points={{-70.0,100.0},{-70.0,80.0}}, color={0,0,0}),Text(extent={{0.0,168.0},{0.0,108.0}}, textString="%name", fillColor={0,0,255}),Text(extent={{0.0,-112.0},{0.0,-163.0}}, textString="ratio=%ratio", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{50.0,100.0},{10.0,-100.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-10.0,45.0},{-50.0,85.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-10.0,30.0},{-50.0,-30.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-50.0,10.0},{-100.0,-10.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{100.0,10.0},{50.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{50.0,100.0},{-50.0,105.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Rectangle(extent={{50.0,-100.0},{-50.0,-105.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Rectangle(extent={{-80.0,70.0},{-50.0,60.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-90.0,40.0},{-70.0,40.0}}, color={0,0,0}),Line(points={{-80.0,50.0},{-60.0,50.0}}, color={0,0,0}),Line(points={{-70.0,50.0},{-70.0,40.0}}, color={0,0,0}),Line(points={{-80.0,80.0},{-59.0,80.0}}, color={0,0,0}),Line(points={{-70.0,90.0},{-70.0,80.0}}, color={0,0,0}),Line(points={{-26.0,-42.0},{-32.0,-2.0}}, pattern=LinePattern.Dot, color={0,0,255}),Line(points={{36.0,-26.0},{64.0,-60.0}}, pattern=LinePattern.Dot, color={0,0,255}),Text(extent={{58.0,-66.0},{98.0,-78.0}}, textString="ring gear", fillColor={0,0,255}),Text(extent={{-112.0,111.0},{-56.0,87.0}}, textString="planet carrier ", fillColor={0,0,255}),Text(extent={{-47.0,-42.0},{-3.0,-56.0}}, textString="sun gear", fillColor={0,0,255}),Polygon(points={{58.0,130.0},{28.0,140.0},{28.0,120.0},{58.0,130.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-52.0,130.0},{28.0,130.0}}, color={0,0,0}),Line(points={{-92.0,93.0},{-70.0,80.0}}, pattern=LinePattern.Dot, color={0,0,255}),Polygon(points={{-7.0,-86.0},{-27.0,-81.0},{-27.0,-91.0},{-7.0,-86.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-97.0,-86.0},{-26.0,-86.0}}, color={128,128,128}),Text(extent={{-96.0,-71.0},{-28.0,-84.0}}, textString="rotation axis", fillColor={128,128,128})}));

      equation 
        (1 + ratio)*carrier.phi=sun.phi + ratio*ring.phi;
        ring.tau=ratio*sun.tau;
        carrier.tau=-(1 + ratio)*sun.tau;
      end IdealPlanetary;
      model IdealGearR2T "Gearbox transforming rotational into translational motion"
              parameter Real ratio(final unit="rad/m")=1 "transmission ratio (flange_a.phi/flange_b.s)";
        SI.Torque tau_support;
        SI.Force f_support;
        Interfaces.Flange_a flange_a annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Modelica.Mechanics.Translational.Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipVertical=true),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipVertical=true)));
        annotation(Documentation(info="<html>
 This is an ideal mass- and inertialess gearbox which transforms a
 1D-rotational into a 1D-translational motion. If elasticity, damping
 or backlash has to be considered, this ideal gearbox has to be
 connected with corresponding elements.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>May 16, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{40.0,-80.0},{80.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Ellipse(extent={{-70.0,40.0},{10.0,-40.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Ellipse(extent={{-40.0,10.0},{-20.0,-10.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Rectangle(extent={{-100.0,10.0},{-70.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Text(extent={{0.0,110.0},{0.0,50.0}}, textString="%name=%ratio", fillColor={0,0,255}),Polygon(points={{-74.0,-60.0},{-54.0,-40.0},{-34.0,-60.0},{-14.0,-40.0},{6.0,-60.0},{26.0,-40.0},{46.0,-60.0},{66.0,-40.0},{86.0,-60.0},{-74.0,-60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Rectangle(extent={{95.0,-10.0},{106.0,-60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Rectangle(extent={{-80.0,-80.0},{-40.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-74.0,-60.0},{106.0,-80.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-80.0,-80.0},{-40.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{40.0,-80.0},{80.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Ellipse(extent={{-70.0,40.0},{10.0,-40.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Ellipse(extent={{-40.0,10.0},{-20.0,-10.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Rectangle(extent={{-96.0,10.0},{-70.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-74.0,-60.0},{106.0,-80.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Rectangle(extent={{95.0,-10.0},{106.0,-60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,70.0},{100.0,40.0}}, textString="transform rotation into translation", fillColor={0,0,255}),Polygon(points={{-74.0,-60.0},{-54.0,-40.0},{-34.0,-60.0},{-14.0,-40.0},{6.0,-60.0},{26.0,-40.0},{46.0,-60.0},{66.0,-40.0},{86.0,-60.0},{-74.0,-60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Polygon(points={{16.0,80.0},{-4.0,85.0},{-4.0,75.0},{16.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-74.0,80.0},{-3.0,80.0}}, color={128,128,128}),Text(extent={{21.0,88.0},{89.0,75.0}}, textString="rotation axis", fillColor={128,128,128})}));
        Interfaces.Flange_a bearingR annotation(Placement(transformation(x=-60.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-60.0,y=-100.0,scale=0.1,aspectRatio=1.0)));
        Translational.Interfaces.Flange_a bearingT annotation(Placement(transformation(x=60.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=60.0,y=-100.0,scale=0.1,aspectRatio=1.0)));

      equation 
        flange_a.phi - bearingR.phi=ratio*(flange_b.s - bearingT.s);
        0=ratio*flange_a.tau + flange_b.f;
        0=flange_a.tau + tau_support;
        0=flange_b.f + f_support;
        if cardinality(bearingR) == 0 then
          bearingR.phi=0;

        else
          bearingR.tau=tau_support;

        end if;
        if cardinality(bearingT) == 0 then
          bearingT.s=0;

        else
          bearingT.f=f_support;

        end if;
      end IdealGearR2T;
      model Spring "Linear 1D rotational spring"
              extends Interfaces.Compliant;
        parameter Real c(final unit="N.m/rad",final min=0) "Spring constant";
        parameter SI.Angle phi_rel0=0 "Unstretched spring angle";
        annotation(Documentation(info="<html>
 <p>
 A <b>linear 1D rotational spring</b>. The component can be connected either
 between two inertias/gears to describe the shaft elasticity, or between
 a inertia/gear and the housing (component Fixed), to describe
 a coupling of the element with the housing via a spring.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255}),Text(extent={{10.0,-40.0},{10.0,-90.0}}, textString="c=%c", fillColor={0,0,0}),Line(points={{-100.0,0.0},{-58.0,0.0},{-43.0,-30.0},{-13.0,30.0},{17.0,-30.0},{47.0,30.0},{62.0,0.0},{100.0,0.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-68.0,0.0},{-68.0,65.0}}, color={128,128,128}),Line(points={{72.0,0.0},{72.0,65.0}}, color={128,128,128}),Line(points={{-68.0,60.0},{72.0,60.0}}, color={128,128,128}),Polygon(points={{62.0,63.0},{72.0,60.0},{62.0,57.0},{62.0,63.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{-22.0,62.0},{18.0,87.0}}, textString="phi_rel", fillColor={0,0,255}),Text(extent={{12.0,-61.0},{80.0,-74.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{8.0,-68.0},{-12.0,-63.0},{-12.0,-73.0},{8.0,-68.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-82.0,-68.0},{-11.0,-68.0}}, color={128,128,128}),Line(points={{-96.0,0.0},{-60.0,0.0},{-42.0,-32.0},{-12.0,30.0},{18.0,-30.0},{48.0,28.0},{62.0,0.0},{96.0,0.0}}, color={0,0,255})}));

      equation 
        tau=c*(phi_rel - phi_rel0);
      end Spring;
      model Damper "Linear 1D rotational damper"
              extends Interfaces.Compliant;
        parameter Real d(final unit="N.m.s/rad",final min=0)=0 "Damping constant";
        SI.AngularVelocity w_rel "Relative angular velocity between flange_b and flange_a";
        annotation(Documentation(info="<html>
 <p>
 <b>Linear, velocity dependent damper</b> element. It can be either connected
 between an inertia or gear and the housing (component Fixed), or
 between two inertia/gear elements.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{-60.0,0.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{-60.0,30.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{60.0,-30.0}}, color={0,0,0}),Line(points={{-60.0,30.0},{60.0,30.0}}, color={0,0,0}),Rectangle(extent={{-60.0,30.0},{30.0,-30.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{30.0,0.0},{90.0,0.0}}, color={0,0,0}),Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255}),Text(extent={{0.0,-50.0},{0.0,-100.0}}, textString="d=%d", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-96.0,0.0},{-60.0,0.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{-60.0,30.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{60.0,-30.0}}, color={0,0,0}),Line(points={{-60.0,30.0},{60.0,30.0}}, color={0,0,0}),Rectangle(extent={{-60.0,30.0},{30.0,-30.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{30.0,0.0},{96.0,0.0}}, color={0,0,0}),Line(points={{-68.0,0.0},{-68.0,65.0}}, color={128,128,128}),Text(extent={{-22.0,62.0},{18.0,87.0}}, textString="phi_rel", fillColor={0,0,255}),Line(points={{-68.0,60.0},{72.0,60.0}}, color={128,128,128}),Line(points={{72.0,0.0},{72.0,65.0}}, color={128,128,128}),Polygon(points={{62.0,63.0},{72.0,60.0},{62.0,57.0},{62.0,63.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Polygon(points={{10.0,-60.0},{-10.0,-55.0},{-10.0,-65.0},{10.0,-60.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-60.0},{-9.0,-60.0}}, color={128,128,128}),Text(extent={{14.0,-53.0},{82.0,-66.0}}, textString="rotation axis", fillColor={128,128,128})}));

      equation 
        w_rel=der(phi_rel);
        tau=d*w_rel;
      end Damper;
      model SpringDamper "Linear 1D rotational spring and damper in parallel"
              extends Interfaces.Compliant;
        parameter Real c(final unit="N.m/rad",final min=0) "Spring constant";
        parameter SI.Angle phi_rel0=0 "Unstretched spring angle";
        parameter Real d(final unit="N.m.s/rad",final min=0)=0 "Damping constant";
        SI.AngularVelocity w_rel "Relative angular velocity between flange_b and flange_a";
        annotation(Documentation(info="<html>
 <p>
 A <b>spring</b> and <b>damper</b> element <b>connected in parallel</b>.
 The component can be
 connected either between two inertias/gears to describe the shaft elasticity
 and damping, or between an inertia/gear and the housing (component Fixed),
 to describe a coupling of the element with the housing via a spring/damper.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,40.0},{-60.0,40.0},{-45.0,10.0},{-15.0,70.0},{15.0,10.0},{45.0,70.0},{60.0,40.0},{80.0,40.0}}, color={0,0,0}),Line(points={{-80.0,40.0},{-80.0,-70.0}}, color={0,0,0}),Line(points={{-80.0,-70.0},{-52.0,-70.0}}, color={0,0,0}),Rectangle(extent={{-52.0,-40.0},{38.0,-100.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-52.0,-40.0},{68.0,-40.0}}, color={0,0,0}),Line(points={{-52.0,-100.0},{68.0,-100.0}}, color={0,0,0}),Line(points={{38.0,-70.0},{80.0,-70.0}}, color={0,0,0}),Line(points={{80.0,40.0},{80.0,-70.0}}, color={0,0,0}),Line(points={{-90.0,0.0},{-80.0,0.0}}, color={0,0,0}),Line(points={{80.0,0.0},{90.0,0.0}}, color={0,0,0}),Text(extent={{-101.0,-147.0},{98.0,-107.0}}, textString="d=%d", fillColor={0,0,0}),Text(extent={{0.0,130.0},{0.0,70.0}}, textString="%name=%c", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,32.0},{-58.0,32.0},{-43.0,2.0},{-13.0,62.0},{17.0,2.0},{47.0,62.0},{62.0,32.0},{80.0,32.0}}, color={0,0,0}, thickness=0.5),Line(points={{-68.0,32.0},{-68.0,97.0}}, color={128,128,128}),Line(points={{72.0,32.0},{72.0,97.0}}, color={128,128,128}),Line(points={{-68.0,92.0},{72.0,92.0}}, color={128,128,128}),Polygon(points={{62.0,95.0},{72.0,92.0},{62.0,89.0},{62.0,95.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{-20.0,72.0},{20.0,97.0}}, textString="phi_rel", fillColor={0,0,255}),Rectangle(extent={{-52.0,-20.0},{38.0,-80.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-52.0,-80.0},{68.0,-80.0}}, color={0,0,0}),Line(points={{-52.0,-20.0},{68.0,-20.0}}, color={0,0,0}),Line(points={{38.0,-50.0},{80.0,-50.0}}, color={0,0,0}),Line(points={{-80.0,-50.0},{-52.0,-50.0}}, color={0,0,0}),Line(points={{-80.0,32.0},{-80.0,-50.0}}, color={0,0,0}),Line(points={{80.0,32.0},{80.0,-50.0}}, color={0,0,0}),Line(points={{-96.0,0.0},{-80.0,0.0}}, color={0,0,0}),Line(points={{96.0,0.0},{80.0,0.0}}, color={0,0,0}),Text(extent={{15.0,-87.0},{83.0,-100.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{11.0,-94.0},{-9.0,-89.0},{-9.0,-99.0},{11.0,-94.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-79.0,-94.0},{-8.0,-94.0}}, color={128,128,128})}));

      equation 
        w_rel=der(phi_rel);
        tau=c*(phi_rel - phi_rel0) + d*w_rel;
      end SpringDamper;
      model ElastoBacklash "Backlash connected in series to linear spring and damper (backlash is modeled with elasticity)"
              extends Interfaces.Compliant;
        parameter SI.Angle b(final min=0)=0 "Total backlash";
        parameter Real c(final unit="N.m/rad",final min=Modelica.Constants.small)=100000.0 "Spring constant (c > 0 required)";
        parameter SI.Angle phi_rel0=0 "Unstretched spring angle";
        parameter Real d(final unit="N.m.s/rad",final min=0)=0 "Damping constant";
        SI.AngularVelocity w_rel "Relative angular velocity between flange_b and flange_a";
      protected 
        SI.Angle b2=b/2;
        constant SI.Angle b_min=1e-10 "minimum backlash";
        annotation(Documentation(info="<html>
 <p>
 This element consists of a <b>backlash</b> element <b>connected in series</b>
 to a <b>spring</b> and <b>damper</b> element which are <b>connected in parallel</b>.
 The spring constant shall be non-zero, otherwise the component cannot be used.
 </p>
 <p>
 In combination with components IdealGear, the ElastoBacklash model
 can be used to model a gear box with backlash, elasticity and damping.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,32.0},{-58.0,32.0},{-48.0,0.0},{-34.0,61.0},{-20.0,0.0},{-8.0,60.0},{0.0,30.0},{20.0,30.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Rectangle(extent={{-60.0,-20.0},{-10.0,-80.0}}, lineColor={0,0,0}, pattern=LinePattern.Solid, lineThickness=0.25, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-52.0,-80.0},{0.0,-80.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-52.0,-20.0},{0.0,-20.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-10.0,-50.0},{20.0,-50.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-80.0,-50.0},{-60.0,-50.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-80.0,32.0},{-80.0,-50.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{20.0,30.0},{20.0,-50.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-90.0,0.0},{-80.0,0.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{90.0,0.0},{80.0,0.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{20.0,0.0},{60.0,0.0},{60.0,-30.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{40.0,-12.0},{40.0,-40.0},{80.0,-40.0},{80.0,0.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-99.0,-130.0},{100.0,-90.0}}, textString="b=%b", fillColor={0,0,0}),Text(extent={{0.0,120.0},{0.0,60.0}}, textString="%name=%c", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,32.0},{-58.0,32.0},{-48.0,0.0},{-34.0,60.0},{-20.0,0.0},{-8.0,60.0},{0.0,30.0},{20.0,30.0}}, color={0,0,0}, thickness=0.5),Line(points={{-68.0,32.0},{-68.0,97.0}}, color={128,128,128}),Line(points={{80.0,0.0},{80.0,96.0}}, color={128,128,128}),Line(points={{-68.0,92.0},{72.0,92.0}}, color={128,128,128}),Polygon(points={{70.0,95.0},{80.0,92.0},{70.0,89.0},{70.0,95.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{-10.0,70.0},{30.0,95.0}}, textString="phi_rel", fillColor={128,128,128}),Rectangle(extent={{-60.0,-20.0},{-10.0,-80.0}}, lineColor={0,0,0}, lineThickness=0.5, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-52.0,-80.0},{0.0,-80.0}}, color={0,0,0}, thickness=0.5),Line(points={{-52.0,-20.0},{0.0,-20.0}}, color={0,0,0}, thickness=0.5),Line(points={{-10.0,-50.0},{20.0,-50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-80.0,-50.0},{-60.0,-50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-80.0,32.0},{-80.0,-50.0}}, color={0,0,0}, thickness=0.5),Line(points={{20.0,30.0},{20.0,-50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-96.0,0.0},{-80.0,0.0}}, color={0,0,0}),Line(points={{96.0,0.0},{80.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{20.0,0.0},{60.0,0.0},{60.0,-30.0}}, color={0,0,0}, thickness=0.5),Line(points={{40.0,-12.0},{40.0,-40.0},{80.0,-40.0},{80.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{30.0,0.0},{30.0,64.0}}, color={128,128,128}),Line(points={{30.0,60.0},{80.0,60.0}}, color={128,128,128}),Polygon(points={{70.0,63.0},{80.0,60.0},{70.0,57.0},{70.0,63.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{39.0,60.0},{68.0,46.0}}, textString="b", fillColor={160,160,160}, fillPattern=FillPattern.Solid),Text(extent={{15.0,-89.0},{83.0,-102.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{11.0,-96.0},{-9.0,-91.0},{-9.0,-101.0},{11.0,-96.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-79.0,-96.0},{-8.0,-96.0}}, color={128,128,128})}));

      equation 
        w_rel=der(phi_rel);
        tau=if b2 > b_min then if phi_rel > b2 then c*(phi_rel - phi_rel0 - b2) + d*w_rel else if phi_rel < -b2 then c*(phi_rel - phi_rel0 + b2) + d*w_rel else 0 else c*(phi_rel - phi_rel0) + d*w_rel;
      end ElastoBacklash;
      model BearingFriction "Coulomb friction in bearings "
              extends Interfaces.TwoFlangesAndBearing;
        parameter Real tau_pos[:,:]={{0,1}} "[w,tau] Positive sliding friction characteristic (w>=0)";
        parameter Real peak(final min=1)=1 "peak*tau_pos[1,2] = Maximum friction torque for w==0";
        extends Interfaces.FrictionBase;
        SI.Angle phi;
        SI.AngularVelocity w "Absolute angular velocity of flange_a and flange_b";
        SI.AngularAcceleration a "Absolute angular acceleration of flange_a and flange_b";
        annotation(Documentation(info="<html>
 <p>
 This element describes <b>Coulomb friction</b> in <b>bearings</b>,
 i.e., a frictional torque acting between a flange and the housing.
 The positive sliding friction torque \"tau\" has to be defined
 by table \"tau_pos\" as function of the absolute angular velocity \"w\".
 E.g.
 <p>
 <pre>
        w | tau
       ---+-----
        0 |   0
        1 |   2
        2 |   5
        3 |   8
 </pre>
 <p>
 gives the following table:
 </p>
 <pre>
    tau_pos = [0, 0; 1, 2; 2, 5; 3, 8];
 </pre>
 <p>
 Currently, only linear interpolation in the table is supported.
 Outside of the table, extrapolation through the last
 two table entries is used. It is assumed that the negative
 sliding friction force has the same characteristic with negative
 values. Friction is modelled in the following way:
 </p>
 <p>
 When the absolute angular velocity \"w\" is not zero, the friction torque
 is a function of w and of a constant normal force. This dependency
 is defined via table tau_pos and can be determined by measurements,
 e.g. by driving the gear with constant velocity and measuring the
 needed motor torque (= friction torque).
 </p>
 <p>
 When the absolute angular velocity becomes zero, the elements
 connected by the friction element become stuck, i.e., the absolute
 angle remains constant. In this phase the friction torque is
 calculated from a torque balance due to the requirement, that
 the absolute acceleration shall be zero.  The elements begin
 to slide when the friction torque exceeds a threshold value,
 called the maximum static friction torque, computed via:
 </p>
 <pre>
    maximum_static_friction = <b>peak</b> * sliding_friction(w=0)  (<b>peak</b> >= 1)
 </pre>
 <p>
 This procedure is implemented in a \"clean\" way by state events and
 leads to continuous/discrete systems of equations if friction elements
 are dynamically coupled which have to be solved by appropriate
 numerical methods. The method is described in:
 </p>
 <dl>
 <dt>Otter M., Elmqvist H., and Mattsson S.E. (1999):
 <dd><b>Hybrid Modeling in Modelica based on the Synchronous
     Data Flow Principle</b>. CACSD'99, Aug. 22.-26, Hawaii.
 </dl>
 <p>
 More precise friction models take into account the elasticity of the
 material when the two elements are \"stuck\", as well as other effects,
 like hysteresis. This has the advantage that the friction element can
 be completely described by a differential equation without events. The
 drawback is that the system becomes stiff (about 10-20 times slower
 simulation) and that more material constants have to be supplied which
 requires more sophisticated identification. For more details, see the
 following references, especially (Armstrong and Canudas de Witt 1996):
 </p>
 <dl>
 <dt>Armstrong B. (1991):
 <dd><b>Control of Machines with Friction</b>. Kluwer Academic
     Press, Boston MA.<br><br>
 <dt>Armstrong B., and Canudas de Wit C. (1996):
 <dd><b>Friction Modeling and Compensation.</b>
     The Control Handbook, edited by W.S.Levine, CRC Press,
     pp. 1369-1382.<br><br>
 <dt>Canudas de Wit C., Olsson H., Astroem K.J., and Lischinsky P. (1995):
 <dd><b>A new model for control of systems with friction.</b>
     IEEE Transactions on Automatic Control, Vol. 40, No. 3, pp. 419-425.<br><br>
 </dl>
 <br>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,10.0},{100.0,-10.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-60.0,-10.0},{60.0,-60.0}}, lineColor={0,0,0}),Rectangle(extent={{-60.0,-10.0},{60.0,-25.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-60.0,-45.0},{60.0,-61.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-50.0,-18.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Polygon(points={{60.0,-60.0},{60.0,-70.0},{75.0,-70.0},{75.0,-80.0},{-75.0,-80.0},{-75.0,-70.0},{-60.0,-70.0},{-60.0,-60.0},{60.0,-60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Line(points={{-75.0,-10.0},{-75.0,-70.0}}, color={0,0,0}),Line(points={{75.0,-10.0},{75.0,-70.0}}, color={0,0,0}),Rectangle(extent={{-60.0,60.0},{60.0,10.0}}, lineColor={0,0,0}),Rectangle(extent={{-60.0,60.0},{60.0,45.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-60.0,25.0},{60.0,10.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-50.0,51.0},{50.0,19.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-75.0,70.0},{-75.0,10.0}}, color={0,0,0}),Polygon(points={{60.0,60.0},{60.0,70.0},{75.0,70.0},{75.0,80.0},{-75.0,80.0},{-75.0,70.0},{-60.0,70.0},{-60.0,60.0},{60.0,60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Line(points={{75.0,70.0},{75.0,10.0}}, color={0,0,0}),Text(extent={{0.0,150.0},{0.0,90.0}}, textString="%name", fillColor={0,0,255}),Line(points={{-10.0,-90.0},{0.0,-80.0}}, color={0,0,0}),Line(points={{-5.0,-90.0},{5.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-90.0},{10.0,-80.0}}, color={0,0,0}),Line(points={{5.0,-90.0},{10.0,-85.0}}, color={0,0,0}),Line(points={{-10.0,-85.0},{-5.0,-80.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-96.0,10.0},{96.0,-10.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-60.0,-10.0},{60.0,-60.0}}, lineColor={0,0,0}),Rectangle(extent={{-60.0,-10.0},{60.0,-25.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-60.0,-45.0},{60.0,-61.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-50.0,-18.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Polygon(points={{60.0,-60.0},{60.0,-70.0},{75.0,-70.0},{75.0,-80.0},{-75.0,-80.0},{-75.0,-70.0},{-60.0,-70.0},{-60.0,-60.0},{60.0,-60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Line(points={{-75.0,-10.0},{-75.0,-70.0}}, color={0,0,0}),Line(points={{75.0,-10.0},{75.0,-70.0}}, color={0,0,0}),Rectangle(extent={{-60.0,60.0},{60.0,10.0}}, lineColor={0,0,0}),Rectangle(extent={{-60.0,60.0},{60.0,45.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-60.0,25.0},{60.0,10.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-50.0,51.0},{50.0,19.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-75.0,70.0},{-75.0,10.0}}, color={0,0,0}),Polygon(points={{60.0,60.0},{60.0,70.0},{75.0,70.0},{75.0,80.0},{-75.0,80.0},{-75.0,70.0},{-60.0,70.0},{-60.0,60.0},{60.0,60.0}}, lineColor={0,0,0}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Line(points={{75.0,70.0},{75.0,10.0}}, color={0,0,0}),Line(points={{-20.0,-24.0},{38.0,-24.0}}, color={255,0,0}, thickness=1.0),Polygon(points={{-20.0,-19.0},{-20.0,-29.0},{-36.0,-24.0},{-20.0,-19.0}}, lineColor={255,0,0}, fillColor={255,0,0}, fillPattern=FillPattern.Solid),Text(extent={{-45.0,-23.0},{49.0,-51.0}}, textString="tau (friction torque)", fillColor={255,0,0}),Text(extent={{14.0,97.0},{82.0,84.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{10.0,90.0},{-10.0,95.0},{-10.0,85.0},{10.0,90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-80.0,90.0},{-9.0,90.0}}, color={128,128,128}),Line(points={{-10.0,-90.0},{0.0,-80.0}}, color={0,0,0}),Line(points={{-5.0,-90.0},{5.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-90.0},{10.0,-80.0}}, color={0,0,0}),Line(points={{5.0,-90.0},{10.0,-85.0}}, color={0,0,0}),Line(points={{-10.0,-85.0},{-5.0,-80.0}}, color={0,0,0})}));

      equation 
        tau0=Modelica.Math.tempInterpol1(0, tau_pos, 2);
        tau0_max=peak*tau0;
        free=false;
        phi=phi_a;
        phi=phi_b;
        w=der(phi);
        a=der(w);
        w_relfric=w;
        a_relfric=a;
        0=flange_a.tau + flange_b.tau - tau;
        tau=if locked then sa else if startForward then Modelica.Math.tempInterpol1(w, tau_pos, 2) else if startBackward then -Modelica.Math.tempInterpol1(-w, tau_pos, 2) else if pre(mode) == Forward then Modelica.Math.tempInterpol1(w, tau_pos, 2) else -Modelica.Math.tempInterpol1(-w, tau_pos, 2);
      end BearingFriction;
      model Clutch "Clutch based on Coulomb friction "
              extends Interfaces.Compliant;
        parameter Real mue_pos[:,:]={{0,0.5}} "[w,mue] positive sliding friction coefficient (w_rel>=0)";
        parameter Real peak(final min=1)=1 "peak*mue_pos[1,2] = maximum value of mue for w_rel==0";
        parameter Real cgeo(final min=0)=1 "Geometry constant containing friction distribution assumption";
        parameter SI.Force fn_max(final min=0)=1 "Maximum normal force";
        extends Interfaces.FrictionBase;
        SI.AngularVelocity w_rel "Relative angular velocity (flange_b.w - flange_a.w)";
        SI.AngularAcceleration a_rel "Relative angular acceleration (flange_b.a - flange_a.a)";
        Real mue0 "Friction coefficient for w=0 and forward sliding";
        SI.Force fn "Normal force (fn=fn_max*inPort.signal)";
        Modelica.Blocks.Interfaces.RealInput f_normalized "Normalized force signal 0..1 (normal force = fn_max*f_normalized; clutch is engaged if > 0)" annotation(Placement(transformation(x=0.0,y=110.0,scale=0.2,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=110.0,scale=0.2,aspectRatio=1.0,rotation=90,flipVertical=true)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-30.0,40.0},{-60.0,50.0},{-60.0,30.0},{-30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{0.0,90.0},{-90.0,70.0},{-90.0,40.0},{-30.0,40.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Line(points={{0.0,90.0},{90.0,70.0},{90.0,40.0},{30.0,40.0}}, color={0,0,255}),Polygon(points={{30.0,40.0},{60.0,50.0},{60.0,30.0},{30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Rectangle(extent={{10.0,60.0},{30.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-30.0,60.0},{-10.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{30.0,10.0},{100.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-100.0,10.0},{-30.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Text(extent={{0.0,-130.0},{0.0,-70.0}}, textString="%name", fillColor={0,0,255})}),Documentation(info="<html>
 <p>
 This component models a <b>clutch</b>, i.e., a component with
 two flanges where friction is present between the two flanges
 and these flanges are pressed together via a normal force.
 The normal force fn has to be provided as input signal f_normalized in a normalized form
 (0 &le; f_normalized &le; 1),
 fn = fn_max*f_normalized, where fn_max has to be provided as parameter. Friction in the
 clutch is modelled in the following way:
 </p>
 <p>
 When the relative angular velocity is not zero, the friction torque is a
 function of the velocity dependent friction coefficient  mue(w_rel) , of
 the normal force \"fn\", and of a geometry constant \"cgeo\" which takes into
 account the geometry of the device and the assumptions on the friction
 distributions:
 </p>
 <pre>
         frictional_torque = <b>cgeo</b> * <b>mue</b>(w_rel) * <b>fn</b>
 </pre>
 <p>
    Typical values of coefficients of friction:
 </p>
 <pre>
       dry operation   :  <b>mue</b> = 0.2 .. 0.4
       operating in oil:  <b>mue</b> = 0.05 .. 0.1
 </pre>
 <p>
    When plates are pressed together, where  <b>ri</b>  is the inner radius,
    <b>ro</b> is the outer radius and <b>N</b> is the number of friction interfaces,
    the geometry constant is calculated in the following way under the
    assumption of a uniform rate of wear at the interfaces:
 </p>
 <pre>
          <b>cgeo</b> = <b>N</b>*(<b>r0</b> + <b>ri</b>)/2
 </pre>
 <p>
     The positive part of the friction characteristic <b>mue</b>(w_rel),
     w_rel >= 0, is defined via table mue_pos (first column = w_rel,
     second column = mue). Currently, only linear interpolation in
     the table is supported.
 </p>
 <p>
    When the relative angular velocity becomes zero, the elements
    connected by the friction element become stuck, i.e., the relative
    angle remains constant. In this phase the friction torque is
    calculated from a torque balance due to the requirement, that
    the relative acceleration shall be zero.  The elements begin
    to slide when the friction torque exceeds a threshold value,
    called the  maximum static friction torque, computed via:
 </p>
 <pre>
        frictional_torque = <b>peak</b> * <b>cgeo</b> * <b>mue</b>(w_rel=0) * <b>fn</b>   (<b>peak</b> >= 1)
 </pre>
 <p>
 This procedure is implemented in a \"clean\" way by state events and
 leads to continuous/discrete systems of equations if friction elements
 are dynamically coupled. The method is described in:
 </p>
 <dl>
 <dt>Otter M., Elmqvist H., and Mattsson S.E. (1999):
 <dd><b>Hybrid Modeling in Modelica based on the Synchronous
     Data Flow Principle</b>. CACSD'99, Aug. 22.-26, Hawaii.
 </dl>
 <p>
 More precise friction models take into account the elasticity of the
 material when the two elements are \"stuck\", as well as other effects,
 like hysteresis. This has the advantage that the friction element can
 be completely described by a differential equation without events. The
 drawback is that the system becomes stiff (about 10-20 times slower
 simulation) and that more material constants have to be supplied which
 requires more sophisticated identification. For more details, see the
 following references, especially (Armstrong and Canudas de Witt 1996):
 </p>
 <dl>
 <dt>Armstrong B. (1991):
 <dd><b>Control of Machines with Friction</b>. Kluwer Academic
     Press, Boston MA.<br><br>
 <dt>Armstrong B., and Canudas de Wit C. (1996):
 <dd><b>Friction Modeling and Compensation.</b>
     The Control Handbook, edited by W.S.Levine, CRC Press,
     pp. 1369-1382.<br><br>
 <dt>Canudas de Wit C., Olsson H., Astroem K.J., and Lischinsky P. (1995):
 <dd><b>A new model for control of systems with friction.</b>
     IEEE Transactions on Automatic Control, Vol. 40, No. 3, pp. 419-425.<br><br>
 </dl>
 <br>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized first version.
 </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-30.0,40.0},{-60.0,50.0},{-60.0,30.0},{-30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{0.0,90.0},{-90.0,70.0},{-90.0,40.0},{-30.0,40.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Line(points={{0.0,90.0},{90.0,70.0},{90.0,40.0},{30.0,40.0}}, color={0,0,255}),Polygon(points={{30.0,40.0},{60.0,50.0},{60.0,30.0},{30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Rectangle(extent={{10.0,60.0},{30.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-30.0,60.0},{-10.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{30.0,10.0},{96.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-96.0,10.0},{-30.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Text(extent={{19.0,-90.0},{87.0,-103.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{15.0,-97.0},{-5.0,-92.0},{-5.0,-102.0},{15.0,-97.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-75.0,-97.0},{-4.0,-97.0}}, color={128,128,128})}));

      equation 
        mue0=Modelica.Math.tempInterpol1(0, mue_pos, 2);
        w_rel=der(phi_rel);
        a_rel=der(w_rel);
        w_relfric=w_rel;
        a_relfric=a_rel;
        fn=fn_max*f_normalized;
        free=fn <= 0;
        tau0=mue0*cgeo*fn;
        tau0_max=peak*tau0;
        tau=if locked then sa else if free then 0 else cgeo*fn*(if startForward then Modelica.Math.tempInterpol1(w_rel, mue_pos, 2) else if startBackward then -Modelica.Math.tempInterpol1(-w_rel, mue_pos, 2) else if pre(mode) == Forward then Modelica.Math.tempInterpol1(w_rel, mue_pos, 2) else -Modelica.Math.tempInterpol1(-w_rel, mue_pos, 2));
      end Clutch;
      model OneWayClutch "Series connection of freewheel and clutch"
              extends Interfaces.Compliant;
        parameter Real mue_pos[:,:]={{0,0.5}} "[w,mue] positive sliding friction coefficient (w_rel>=0)";
        parameter Real peak(final min=1)=1 "peak*mue_pos[1,2] = maximum value of mue for w_rel==0";
        parameter Real cgeo(final min=0)=1 "Geometry constant containing friction distribution assumption";
        parameter SI.Force fn_max(final min=0)=1 "Maximum normal force";
        parameter SI.AngularVelocity w_small(min=Modelica.Constants.eps)=1 "Relative angular velocity near to zero (see model info text)";
        SI.AngularVelocity w_rel "Relative angular velocity (flange_b.w - flange_a.w)";
        SI.AngularAcceleration a_rel "Relative angular acceleration (flange_b.a - flange_a.a)";
        Real u "normalized force input signal (0..1)";
        SI.Force fn "Normal force (fn=fn_max*inPort.signal)";
        Boolean startForward "true, if w_rel=0 and start of forward sliding or w_rel > w_small";
        Boolean locked "true, if w_rel=0 and not sliding";
        Boolean stuck(final start=false) "w_rel=0 (forward sliding or locked)";
      protected 
        SI.Torque tau0 "Friction torque for w=0 and sliding";
        SI.Torque tau0_max "Maximum friction torque for w=0 and locked";
        Real mue0 "Friction coefficient for w=0 and sliding";
        Boolean free "true, if frictional element is not active";
        Real sa "path parameter of tau = f(a_rel) Friction characteristic";
        constant Real eps0=0.0001 "Relative hysteresis epsilon";
        SI.Torque tau0_max_low "lowest value for tau0_max";
        parameter Real peak2=max([peak,1 + eps0]);
      public 
        Modelica.Blocks.Interfaces.RealInput f_normalized "Normalized force signal 0..1 (normal force = fn_max*f_normalized; clutch is engaged if > 0)" annotation(Placement(transformation(x=0.0,y=110.0,scale=0.2,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=110.0,scale=0.2,aspectRatio=1.0,rotation=90,flipVertical=true)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-30.0,40.0},{-60.0,50.0},{-60.0,30.0},{-30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{0.0,90.0},{-90.0,70.0},{-90.0,40.0},{-30.0,40.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Line(points={{0.0,90.0},{90.0,70.0},{90.0,40.0},{30.0,40.0}}, color={0,0,255}),Polygon(points={{30.0,40.0},{60.0,50.0},{60.0,30.0},{30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Rectangle(extent={{10.0,60.0},{30.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-30.0,60.0},{-10.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{30.0,10.0},{100.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-100.0,10.0},{-30.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Text(extent={{0.0,-130.0},{0.0,-70.0}}, textString="%name", fillColor={0,0,255}),Polygon(points={{-10.0,30.0},{50.0,0.0},{-10.0,-30.0},{-10.0,30.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}),Documentation(info="<html>
 <p>
 This component models a <b>one-way clutch</b>, i.e., a component with
 two flanges where friction is present between the two flanges
 and these flanges are pressed together via a normal force. These
 flanges maybe sliding with respect to each other
 Parallel connection of ClutchCombi and of FreeWheel.
                      The element is introduced to resolve the ambiguity
                      of the constraint torques of the elements.
 <p>
 A one-way-clutch is an element where a clutch is connected in parallel
 to a free wheel. This special element is provided, because such
 a parallel connection introduces an ambiguity into the model
 (the constraint torques are not uniquely defined when both
 elements are stuck) and this element resolves it by introducing
 <b>one</b> constraint torque and not two.
 </p>
 <p>
 Note, initial values have to be chosen for the model, such that the
 relative speed of the one-way-clutch >= 0. Otherwise, the configuration
 is physically not possible and an error occurs.
 </p>
 <p>
 The normal force fn has to be provided as input signal f_normalized in a normalized form
 (0 &le; f_normalized &le; 1),
 fn = fn_max*f_normalized, where fn_max has to be provided as parameter. Friction in the
 clutch is modelled in the following way:
 </p>
 <p>
 When the relative angular velocity is positive, the friction torque is a
 function of the velocity dependent friction coefficient  mue(w_rel) , of
 the normal force \"fn\", and of a geometry constant \"cgeo\" which takes into
 account the geometry of the device and the assumptions on the friction
 distributions:
 </p>
 <pre>
         frictional_torque = <b>cgeo</b> * <b>mue</b>(w_rel) * <b>fn</b>
 </pre>
 <p>
    Typical values of coefficients of friction:
 </p>
 <pre>
       dry operation   :  <b>mue</b> = 0.2 .. 0.4
       operating in oil:  <b>mue</b> = 0.05 .. 0.1
 </pre>
 <p>
    When plates are pressed together, where  <b>ri</b>  is the inner radius,
    <b>ro</b> is the outer radius and <b>N</b> is the number of friction interfaces,
    the geometry constant is calculated in the following way under the
    assumption of a uniform rate of wear at the interfaces:
 </p>
 <pre>
          <b>cgeo</b> = <b>N</b>*(<b>r0</b> + <b>ri</b>)/2
 </pre>
 <p>
     The positive part of the friction characteristic <b>mue</b>(w_rel),
     w_rel >= 0, is defined via table mue_pos (first column = w_rel,
     second column = mue). Currently, only linear interpolation in
     the table is supported.
 </p>
 <p>
    When the relative angular velocity becomes zero, the elements
    connected by the friction element become stuck, i.e., the relative
    angle remains constant. In this phase the friction torque is
    calculated from a torque balance due to the requirement, that
    the relative acceleration shall be zero.  The elements begin
    to slide when the friction torque exceeds a threshold value,
    called the  maximum static friction torque, computed via:
 </p>
 <pre>
        frictional_torque = <b>peak</b> * <b>cgeo</b> * <b>mue</b>(w_rel=0) * <b>fn</b>   (<b>peak</b> >= 1)
 </pre>
 <p>
 This procedure is implemented in a \"clean\" way by state events and
 leads to continuous/discrete systems of equations if friction elements
 are dynamically coupled. The method is described in:
 </p>
 <dl>
 <dt>Otter M., Elmqvist H., and Mattsson S.E. (1999):
 <dd><b>Hybrid Modeling in Modelica based on the Synchronous
     Data Flow Principle</b>. CACSD'99, Aug. 22.-26, Hawaii.
 </dl>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Version 0.9 (Nov. 26, 1999)</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 <p><b>Copyright &copy; 1999-2002, DLR.</b></p>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-30.0,40.0},{-60.0,50.0},{-60.0,30.0},{-30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{0.0,90.0},{-90.0,70.0},{-90.0,40.0},{-30.0,40.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Line(points={{0.0,90.0},{90.0,70.0},{90.0,40.0},{30.0,40.0}}, color={0,0,255}),Polygon(points={{30.0,40.0},{60.0,50.0},{60.0,30.0},{30.0,40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Rectangle(extent={{10.0,60.0},{30.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-30.0,60.0},{-10.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{30.0,10.0},{96.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-96.0,10.0},{-30.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-10.0,30.0},{50.0,0.0},{-10.0,-30.0},{-10.0,30.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}));

      equation 
        mue0=Modelica.Math.tempInterpol1(0, mue_pos, 2);
        tau0_max_low=eps0*mue0*cgeo*fn_max;
        w_rel=der(phi_rel);
        a_rel=der(w_rel);
        u=f_normalized;
        free=u <= 0;
        fn=if free then 0 else fn_max*u;
        tau0=mue0*cgeo*fn;
        tau0_max=if free then tau0_max_low else peak2*tau0;
        startForward=pre(stuck) and sa > tau0_max or pre(startForward) and sa > tau0 or w_rel > w_small or initial() and w_rel > 0;
        locked=pre(stuck) and not startForward;
        a_rel=if locked then 0 else sa - tau0;
        tau=if locked then sa else if free then 0 else cgeo*fn*Modelica.Math.tempInterpol1(w_rel, mue_pos, 2);
        stuck=locked or w_rel <= 0;
      end OneWayClutch;
      model Brake "Brake based on Coulomb friction "
              extends Interfaces.TwoFlangesAndBearing;
        parameter Real mue_pos[:,:]={{0,0.5}} "[w,mue] positive sliding friction coefficient (w_rel>=0)";
        parameter Real peak(final min=1)=1 "peak*mue_pos[1,2] = maximum value of mue for w_rel==0";
        parameter Real cgeo(final min=0)=1 "Geometry constant containing friction distribution assumption";
        parameter SI.Force fn_max(final min=0)=1 "Maximum normal force";
        extends Interfaces.FrictionBase;
        SI.Angle phi;
        SI.AngularVelocity w "Absolute angular velocity of flange_a and flange_b";
        SI.AngularAcceleration a "Absolute angular acceleration of flange_a and flange_b";
        Real mue0 "Friction coefficient for w=0 and forward sliding";
        SI.Force fn "Normal force (=fn_max*inPort.signal)";
        Modelica.Blocks.Interfaces.RealInput f_normalized "Normalized force signal 0..1 (normal force = fn_max*f_normalized; brake is active if > 0)" annotation(Placement(transformation(x=0.0,y=110.0,scale=0.2,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=110.0,scale=0.2,aspectRatio=1.0,rotation=90,flipVertical=true)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-37.0,-55.0},{-37.0,-90.0},{37.0,-90.0},{37.0,-55.0},{33.0,-55.0},{33.0,-86.0},{-33.0,-86.0},{-33.0,-55.0},{-37.0,-55.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-100.0,10.0},{-20.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-20.0,60.0},{20.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,10.0},{100.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{40.0,-40.0},{70.0,-30.0},{70.0,-50.0},{40.0,-40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Rectangle(extent={{30.0,-25.0},{40.0,-55.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Polygon(points={{-40.0,-40.0},{-70.0,-30.0},{-70.0,-50.0},{-40.0,-40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Rectangle(extent={{-40.0,-25.0},{-30.0,-55.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{0.0,90.0},{80.0,70.0},{80.0,-40.0},{70.0,-40.0}}, color={0,0,255}),Line(points={{0.0,90.0},{-80.0,70.0},{-80.0,-40.0},{-70.0,-40.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Text(extent={{0.0,-200.0},{0.0,-140.0}}, textString="%name", fillColor={0,0,255})}),Documentation(info="<html>
 <p>
 This component models a <b>brake</b>, i.e., a component where a frictional
 torque is acting between the housing and a flange and a controlled normal
 force presses the flange to the housing in order to increase friction.
 The normal force fn has to be provided as input signal f_normalized in a normalized form
 (0 &le; f_normalized &le; 1),
 fn = fn_max*f_normalized, where fn_max has to be provided as parameter.
 Friction in the brake is modelled in the following way:
 </p>
 <p>
 When the absolute angular velocity \"w\" is not zero, the friction torque
 is a function of the velocity dependent friction coefficient  mue(w) , of
 the normal force \"fn\", and of a geometry constant \"cgeo\" which takes into
 account the geometry of the device and the assumptions on the friction
 distributions:
 </p>
 <pre>
         frictional_torque = <b>cgeo</b> * <b>mue</b>(w) * <b>fn</b>
 </pre>
 <p>
    Typical values of coefficients of friction:
 </p>
 <pre>
       dry operation   :  <b>mue</b> = 0.2 .. 0.4
       operating in oil:  <b>mue</b> = 0.05 .. 0.1
 </pre>
 <p>
    When plates are pressed together, where  <b>ri</b>  is the inner radius,
    <b>ro</b> is the outer radius and <b>N</b> is the number of friction interfaces,
    the geometry constant is calculated in the following way under the
    assumption of a uniform rate of wear at the interfaces:
 </p>
 <pre>
          <b>cgeo</b> = <b>N</b>*(<b>r0</b> + <b>ri</b>)/2
 </pre>
 <p>
     The positive part of the friction characteristic <b>mue</b>(w),
     w >= 0, is defined via table mue_pos (first column = w,
     second column = mue). Currently, only linear interpolation in
     the table is supported.
 </p>
 <p>
    When the absolute angular velocity becomes zero, the elements
    connected by the friction element become stuck, i.e., the absolute
    angle remains constant. In this phase the friction torque is
    calculated from a torque balance due to the requirement, that
    the absolute acceleration shall be zero.  The elements begin
    to slide when the friction torque exceeds a threshold value,
    called the  maximum static friction torque, computed via:
 </p>
 <pre>
        frictional_torque = <b>peak</b> * <b>cgeo</b> * <b>mue</b>(w=0) * <b>fn</b>   (<b>peak</b> >= 1)
 </pre>
 <p>
 This procedure is implemented in a \"clean\" way by state events and
 leads to continuous/discrete systems of equations if friction elements
 are dynamically coupled. The method is described in:
 </p>
 <dl>
 <dt>Otter M., Elmqvist H., and Mattsson S.E. (1999):
 <dd><b>Hybrid Modeling in Modelica based on the Synchronous
     Data Flow Principle</b>. CACSD'99, Aug. 22.-26, Hawaii.
 </dl>
 <p>
 More precise friction models take into account the elasticity of the
 material when the two elements are \"stuck\", as well as other effects,
 like hysteresis. This has the advantage that the friction element can
 be completely described by a differential equation without events. The
 drawback is that the system becomes stiff (about 10-20 times slower
 simulation) and that more material constants have to be supplied which
 requires more sophisticated identification. For more details, see the
 following references, especially (Armstrong and Canudas de Witt 1996):
 </p>
 <dl>
 <dt>Armstrong B. (1991):
 <dd><b>Control of Machines with Friction</b>. Kluwer Academic
     Press, Boston MA.<br><br>
 <dt>Armstrong B., and Canudas de Wit C. (1996):
 <dd><b>Friction Modeling and Compensation.</b>
     The Control Handbook, edited by W.S.Levine, CRC Press,
     pp. 1369-1382.<br><br>
 <dt>Canudas de Wit C., Olsson H., Astroem K.J., and Lischinsky P. (1995):
 <dd><b>A new model for control of systems with friction.</b>
     IEEE Transactions on Automatic Control, Vol. 40, No. 3, pp. 419-425.<br><br>
 </dl>
 <br>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized first version.
 </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-37.0,-55.0},{-37.0,-90.0},{37.0,-90.0},{37.0,-55.0},{33.0,-55.0},{33.0,-86.0},{-33.0,-86.0},{-33.0,-55.0},{-37.0,-55.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{14.0,-63.0},{82.0,-76.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{0.0,-70.0},{-20.0,-65.0},{-20.0,-75.0},{0.0,-70.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{-19.0,-70.0}}, color={128,128,128}),Rectangle(extent={{-96.0,10.0},{-20.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,10.0},{96.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{0.0,90.0},{-80.0,70.0},{-80.0,-40.0},{-70.0,-40.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Rectangle(extent={{-20.0,60.0},{20.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{0.0,90.0},{80.0,70.0},{80.0,-40.0},{70.0,-40.0}}, color={0,0,255}),Polygon(points={{40.0,-40.0},{70.0,-30.0},{70.0,-50.0},{40.0,-40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Polygon(points={{-40.0,-40.0},{-70.0,-30.0},{-70.0,-50.0},{-40.0,-40.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Rectangle(extent={{-40.0,-25.0},{-30.0,-55.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Rectangle(extent={{30.0,-25.0},{40.0,-55.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}));

      equation 
        mue0=Modelica.Math.tempInterpol1(0, mue_pos, 2);
        phi=phi_a;
        phi=phi_b;
        w=der(phi);
        a=der(w);
        w_relfric=w;
        a_relfric=a;
        0=flange_a.tau + flange_b.tau - tau;
        fn=fn_max*f_normalized;
        tau0=mue0*cgeo*fn;
        tau0_max=peak*tau0;
        free=fn <= 0;
        tau=if locked then sa else if free then 0 else cgeo*fn*(if startForward then Modelica.Math.tempInterpol1(w, mue_pos, 2) else if startBackward then -Modelica.Math.tempInterpol1(-w, mue_pos, 2) else if pre(mode) == Forward then Modelica.Math.tempInterpol1(w, mue_pos, 2) else -Modelica.Math.tempInterpol1(-w, mue_pos, 2));
      end Brake;
      model LossyGear "Gear with mesh efficiency and bearing friction (stuck/rolling possible)"
              extends Interfaces.TwoFlangesAndBearing;
        parameter Real i=1 "Transmission ratio (flange_a.phi/flange_b.phi)";
        parameter Real lossTable[:,5]={{0,1,1,0,0}} "Array for mesh efficiencies and bearing friction depending on speed";
        Real sa "path parameter for acceleration and torque loss";
        SI.AngularVelocity w_a "angular velocity of flange_a";
        SI.AngularAcceleration a_a "angular acceleration of flange_a";
        Real interpolation_result[1,size(lossTable, 2) - 1];
        Real eta_mf1;
        Real eta_mf2;
        Real tau_bf1;
        Real tau_bf2;
        Real quadrant1;
        Real quadrant2;
        Real quadrant3;
        Real quadrant4;
        SI.Torque tauLoss "Torque loss due to friction in the gear teeth and in the bearings";
        SI.Torque tauLossMax "Torque loss for positive speed";
        SI.Torque tauLossMin "Torque loss for negative speed";
        Boolean tau_aPos "true, if torque of flange_a is not negative";
        Boolean startForward "true, if starting to roll forward";
        Boolean startBackward "true, if starting to roll backward";
        Boolean locked "true, if gear is locked";
        Boolean ideal "true, if losses are neglected";
        constant Integer Unknown=3 "Value of mode is not known";
        constant Integer Free=2 "Element is not active";
        constant Integer Forward=1 "w_a > 0 (forward rolling)";
        constant Integer Stuck=0 "w_a = 0 (forward rolling, locked or backward rolling)";
        constant Integer Backward=-1 "w_a < 0 (backward rolling)";
        Integer mode(final min=Backward,final max=Unknown,start=Free,fixed=true);
        annotation(Documentation(info="<HTML>
 <p>
 This component models the gear ratio and the <b>losses</b> of
 a standard gear box in a <b>reliable</b> way including the stuck phases
 that may occur at zero speed. The gear boxes that can
 be handeled are fixed in the ground, have one input and one
 output shaft, and are essentially described by the equations:
 </p>
 <pre>     flange_a.phi  = i*flange_b.phi
    (-flange_b.tau) = i*(eta_mf*flange_a.tau - tau_bf)
 </pre>
 <p>
 where
 </p>
 <ul>
 <li><b>i</b> is the constant <b>gear ratio</b>,</li>
 <li><b>eta_mf</b> = eta_mf(w) is the <b>mesh efficiency</b> due to the
    friction between the teeth of the gear wheels, </li>
 <li><b>tau_bf</b> = tau_bf(w) is the <b>bearing friction torque</b>, and</li>
 <li><b>w_a</b> = der(flange_a.phi) is the speed of flange_a</li>
 </ul>
 <p>The loss terms \"eta_mf\" and \"tau_bf\" are functions of the
 <i>absolute value</i> of the input shaft speed w_a and of the energy
 flow direction. They are defined by parameter <b>lossTable[:,5]
 </b> where the columns of this table have the following
 meaning:</p>
 <p><table BORDER=1 CELLSPACING=0 CELLPADDING=2>
   <tbody>
     <tr>
       <td>|w_a|</td>
       <td>eta_mf1</td>
       <td>eta_mf2</td>
       <td>|tau_bf1|</td>
       <td>|tau_bf2|</td>
     </tr>
     <tr>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
     </tr>
     <tr>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
       <td align=\"center\">...</td>
     </tr>
   </tbody>
 </table></p>
 <p>with</p>
 <p><table BORDER=1 CELLSPACING=0 CELLPADDING=2>
   <tbody>
     <tr>
       <td>|w_a|</td>
       <td>Absolute value of angular velocity of input shaft flange_a</td>
     </tr>
     <tr>
       <td>eta_mf1</td>
       <td>Mesh efficiency in case of input shaft driving</td>
     </tr>
     <tr>
       <td>eta_mf2</td>
       <td>Mesh efficiency in case of output shaft driving</td>
     </tr>
     <tr>
       <td>|tau_bf1|</td>
       <td>Absolute bearing friction torque in case of input shaft driving</td>
     </tr>
     <tr>
       <td>|tau_bf2|</td>
       <td>Absolute bearing friction torque in case of output shaft driving</td>
     </tr>
   </tbody>
 </table></p>
 <p>
 With these variables, the mesh efficiency and the bearing friction
 are formally defined as:
 </p>
 <pre>  <b>if</b> flange_a.tau*w_a > 0 <b>or</b> flange_a.tau==0 <b>and</b> w_a > 0 <b>then</b>
      eta_mf := eta_mf1
      tau_bf := tau_bf1
   <b>elseif</b> flange_a.tau*w_a &lt; 0 <b>or</b> flange_a.tau==0 <b>and</b> w_a &lt; 0 <b>then</b>
      eta_mf := 1/eta_mf2
      tau_bf := tau_bf2
   <b>else</b> // w_a == 0
      eta_mf and tau_bf are computed such that <b>der</b>(w_a) = 0
   <b>end if</b>;
 </pre>
 <p>Note, that the losses are modeled in a physically meaningful way taking
 into account that at zero speed the movement may be locked due
 to the friction in the gear teeth and/or in the bearings.
 Due to this important property, this component can be used in
 situations where the combination of the components
 Modelica.Mechanics.Rotational.IdealGear and
 Modelica.Mechanics.Rotational.GearEfficiency will fail because,
 e.g., chattering occurs when using the
 Modelica.Mechanics.Rotational.GearEfficiency model.
 </p>
 <p>
 <b>Acknowledgement:</b> The essential idea to model efficiency
 in this way is from Christoph Pelchen, ZF Friedrichshafen.
 </p>
 <p><b>For detailed information:</b></p>
 <p>Pelchen C.,
 <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Schweiger C.</a>,
 and <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Otter M.</a>:
 &quot;<a href=\"http://www.modelica.org/Conference2002/papers/p33_Pelchen.pdf\">Modeling
 and Simulating the Efficiency of Gearboxes and of Planetary Gearboxes</A>,&quot; in
 <I>Proceedings of the 2nd International Modelica Conference, Oberpfaffenhofen, Germany,</I>
 pp. 257-266, The Modelica Association and Institute of Robotics and Mechatronics,
 Deutsches Zentrum f&uuml;r Luft- und Raumfahrt e. V., March 18-19, 2002.</p>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-40.0,20.0},{-20.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-40.0,140.0},{-20.0,20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,100.0},{40.0,60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,60.0},{40.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{40.0,10.0},{100.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-20.0,90.0},{20.0,70.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-100.0,10.0},{-40.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-111.0,30.0},{-70.0,30.0},{-70.0,100.0},{-40.0,100.0},{-60.0,121.0},{-80.0,100.0},{-49.0,100.0},{-49.0,20.0},{-111.0,20.0},{-111.0,30.0}}, lineColor={255,0,0}, fillColor={255,0,0}, fillPattern=FillPattern.Solid),Line(points={{-80.0,20.0},{-60.0,20.0}}, color={0,0,0}),Line(points={{-80.0,-20.0},{-60.0,-20.0}}, color={0,0,0}),Line(points={{-70.0,-20.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{70.0,-70.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{0.0,60.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{-10.0,60.0},{10.0,60.0}}, color={0,0,0}),Line(points={{-10.0,100.0},{10.0,100.0}}, color={0,0,0}),Line(points={{60.0,20.0},{80.0,20.0}}, color={0,0,0}),Line(points={{60.0,-20.0},{80.0,-20.0}}, color={0,0,0}),Line(points={{70.0,-20.0},{70.0,-70.0}}, color={0,0,0}),Text(extent={{0.0,190.0},{0.0,130.0}}, textString="%name=%i", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-40.0,20.0},{-20.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-40.0,140.0},{-20.0,20.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,100.0},{40.0,60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{20.0,60.0},{40.0,-60.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-96.0,10.0},{-40.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{40.0,10.0},{96.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-20.0,90.0},{20.0,70.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-94.0,-76.0},{-23.0,-76.0}}, color={128,128,128}),Polygon(points={{-4.0,-76.0},{-24.0,-71.0},{-24.0,-81.0},{-4.0,-76.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{19.0,-70.0},{87.0,-83.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-80.0,20.0},{-60.0,20.0}}, color={0,0,0}),Line(points={{-80.0,-20.0},{-60.0,-20.0}}, color={0,0,0}),Line(points={{-70.0,-20.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{70.0,-70.0},{-70.0,-70.0}}, color={0,0,0}),Line(points={{0.0,60.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{-10.0,60.0},{10.0,60.0}}, color={0,0,0}),Line(points={{-10.0,100.0},{10.0,100.0}}, color={0,0,0}),Line(points={{60.0,20.0},{80.0,20.0}}, color={0,0,0}),Line(points={{60.0,-20.0},{80.0,-20.0}}, color={0,0,0}),Line(points={{70.0,-20.0},{70.0,-70.0}}, color={0,0,0})}));
      protected 
        function equal "Compare whether two Real matrices are identical"
                  extends Modelica.Icons.Function;
          input Real A[:,:];
          input Real B[:,:];
          input Real eps=Modelica.Constants.eps "two numbers r1, r2 are identical if abs(r1-r2) <= eps";
          output Boolean result;
        algorithm 
          result:=false;
          if size(A, 1) == size(B, 1) and size(A, 2) == size(B, 2) then 
                    result:=true;
          for i in 1:size(A, 1) loop
                      for j in 1:size(A, 2) loop
                          if abs(A[i,j] - B[i,j]) >= eps then 
                            result:=false;

              else 
              end if;

            end for;

          end for;
          else 
          end if;
          annotation(Documentation(info="<HTML>
 <p>
 The function call
 </p>
 <pre>     equal(A1, A2);
 </pre>
 <p>
 returns <b>true</b>, if the two Real matrices A1 and A2 have the
 same dimensions and the same elements. Otherwise the function
 returns <b>false</b>. Two elements r1 and r2 of A1 and A2 respectively
 are checked on equality by the test 'eps >= abs(r1-r2)', where 'eps'
 can be provided as third argument of the function (the default is
 Modelica.Constants.eps).
 </p>
 </HTML>"));        end equal;

      equation 
assert(abs(i) > 0, "Error in initialization of LossyGear: i may not be zero");
        ideal=equal(lossTable, {{0,1,1,0,0}});
        interpolation_result=if ideal then {{1,1,0,0}} else Modelica.Math.tempInterpol2(noEvent(abs(w_a)), lossTable, {2,3,4,5});
        eta_mf1=interpolation_result[1,1];
        eta_mf2=interpolation_result[1,2];
        tau_bf1=noEvent(abs(interpolation_result[1,3]));
        tau_bf2=noEvent(abs(interpolation_result[1,4]));
        phi_a=i*phi_b;
        0=flange_b.tau + i*(flange_a.tau - tauLoss);
        w_a=der(phi_a);
        a_a=der(w_a);
        quadrant1=(1 - eta_mf1)*flange_a.tau + tau_bf1;
        quadrant2=(1 - 1/eta_mf2)*flange_a.tau + tau_bf2;
        quadrant4=(1 - 1/eta_mf2)*flange_a.tau - tau_bf2;
        quadrant3=(1 - eta_mf1)*flange_a.tau - tau_bf1;
        tau_aPos=ideal or flange_a.tau >= 0;
        tauLossMax=if tau_aPos then quadrant1 else quadrant2;
        tauLossMin=if tau_aPos then quadrant4 else quadrant3;
        startForward=pre(mode) == Stuck and sa > tauLossMax or initial() and w_a > 0;
        startBackward=pre(mode) == Stuck and sa < tauLossMin or initial() and w_a < 0;
        locked=not (ideal or pre(mode) == Forward or startForward or pre(mode) == Backward or startBackward);
        tauLoss=if ideal then 0 else if locked then sa else if startForward or pre(mode) == Forward then tauLossMax else tauLossMin;
        a_a=if locked then 0 else sa - tauLoss;
        mode=if ideal then Free else if (pre(mode) == Forward or startForward) and (w_a > 0) then Forward else if (pre(mode) == Backward or startBackward) and (w_a < 0) then Backward else Stuck;
      end LossyGear;
      model GearEfficiency "Obsolete component (use model LossyGear instead)"
              extends Interfaces.TwoFlangesAndBearing;
        parameter Real eta(min=Modelica.Constants.small,max=1)=1 "Efficiency";
        SI.Angle phi;
        SI.Power power_a "Energy flowing into flange_a (= power)";
        Boolean driving_a "True, if energy is flowing INTO and not out of flange flange_a";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{0.0,130.0},{0.0,70.0}}, textString="%name", fillColor={0,0,255}),Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-40.0},{30.0,-40.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{0.0,-90.0}}, color={0,0,0}),Polygon(points={{-30.0,-20.0},{60.0,-20.0},{60.0,-80.0},{70.0,-80.0},{50.0,-100.0},{30.0,-80.0},{40.0,-80.0},{40.0,-30.0},{-30.0,-30.0},{-30.0,-20.0},{-30.0,-20.0}}, lineColor={255,0,0}, fillColor={255,0,0}, fillPattern=FillPattern.Solid),Text(extent={{0.0,70.0},{0.0,20.0}}, textString="eta=%eta", fillColor={0,0,0}),Line(points={{30.0,-50.0},{20.0,-60.0}}, color={0,0,0}),Line(points={{30.0,-40.0},{10.0,-60.0}}, color={0,0,0}),Line(points={{20.0,-40.0},{0.0,-60.0}}, color={0,0,0}),Line(points={{10.0,-40.0},{-10.0,-60.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{-20.0,-60.0}}, color={0,0,0}),Line(points={{-10.0,-40.0},{-30.0,-60.0}}, color={0,0,0}),Line(points={{-20.0,-40.0},{-30.0,-50.0}}, color={0,0,0})}),obsolete="This model can get stuck due when the torque direction varies, use LossyGear instead.",Documentation(info="<html>
 <p>
 THIS COMPONENT IS <b>OBSOLETE</b> and should <b>no longer be used</b>. It is only
 kept for <b>backward compatibility</b> purposes. Use model
 Modelica.Mechanics.Rotational.LossyGear instead which implements
 gear efficiency in a much more reliable way.
 </p>
 <p>
 This component consists of two rigidly connected flanges flange_a and flange_b without
 inertia where an <b>efficency</b> coefficient <b>eta</b> reduces the driven
 torque as function of the driving torque depending on the direction
 of the energy flow, i.e., energy is always lost. This can be seen as a
 simple model of the Coulomb friction acting between the teeth of a
 gearbox.
 </p>
 <p>
 Note, that most gearbox manufacturers provide tables of the
 efficiency of a gearbox as function of the angular velocity
 (efficiency becomes zero, if the angular velocity is zero).
 However, such a table is practically useless for simulation purposes,
 because in gearboxes always two types of friction is present:
 (1) Friction in the <b>bearings</b> and (2) friction between
 the teeth of the gear. (1) leads to a velocity dependent, additive
 loss-torque, whereas (2) leads to a torque-dependent reduction of the
 driving torque. The gearbox manufacturers measure both effects
 together and determine the gear efficiency from it, although for
 simulation purposes the two effects need to be separated.
 Assume for example that only constant bearing friction, i.e.,
 bearingTorque=const., is present, i.e.,
 </p>
 <pre>
    (1)  loadTorque = motorTorque - sign(w)*bearingTorque
 </pre>
 <p>
 Gearbox manufacturers use the loss-formula
 </p>
 <pre>
    (2)  loadTorque = eta*motorTorque
 </pre>
 <p>
 Comparing (1) and (2) gives a formulat for the efficiency eta:
 </p>
 <pre>
    eta = (1 - sign(w)*bearingTorque/motorTorque)
 </pre>
 <p>
 When the motorTorque becomes smaller as the bearingTorque,
 (2) is useless, because the efficiency is zero. To summarize,
 be careful to determine the gear <b>efficiency</b> of this element
 from tables of the gear manufacturers.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-96.0,20.0},{96.0,-21.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-40.0},{30.0,-40.0}}, color={0,0,0}),Line(points={{0.0,60.0},{0.0,40.0}}, color={0,0,0}),Line(points={{-30.0,40.0},{29.0,40.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{0.0,-90.0}}, color={0,0,0}),Polygon(points={{-30.0,-20.0},{60.0,-20.0},{60.0,-80.0},{70.0,-80.0},{50.0,-100.0},{30.0,-80.0},{40.0,-80.0},{40.0,-30.0},{-30.0,-30.0},{-30.0,-20.0},{-30.0,-20.0}}, lineColor={255,0,0}, fillColor={255,0,0}, fillPattern=FillPattern.Solid),Text(extent={{16.0,83.0},{84.0,70.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{12.0,76.0},{-8.0,81.0},{-8.0,71.0},{12.0,76.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-78.0,76.0},{-7.0,76.0}}, color={128,128,128}),Line(points={{30.0,-50.0},{20.0,-60.0}}, color={0,0,0}),Line(points={{30.0,-40.0},{10.0,-60.0}}, color={0,0,0}),Line(points={{20.0,-40.0},{0.0,-60.0}}, color={0,0,0}),Line(points={{10.0,-40.0},{-10.0,-60.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{-20.0,-60.0}}, color={0,0,0}),Line(points={{-10.0,-40.0},{-30.0,-60.0}}, color={0,0,0}),Line(points={{-20.0,-40.0},{-30.0,-50.0}}, color={0,0,0})}));

      equation 
        phi=phi_a;
        phi=phi_b;
        power_a=flange_a.tau*der(phi);
        driving_a=power_a >= 0;
        flange_b.tau=-(if driving_a then eta*flange_a.tau else flange_a.tau/eta);
      end GearEfficiency;
      model Gear "Realistic model of a gearbox"
              extends Interfaces.TwoFlangesAndBearingH;
        parameter Real ratio=1 "transmission ratio (flange_a.phi/flange_b.phi)";
        parameter Real eta(min=Modelica.Constants.small,max=1)=1 "Gear efficiency";
        parameter Real friction_pos[:,:]={{0,1}} "[w,tau] positive sliding friction characteristic (w>=0)";
        parameter Real peak(final min=1)=1 "peak*friction_pos[1,2] = maximum friction torque at zero velocity";
        parameter Real c(final unit="N.m/rad",final min=Modelica.Constants.small)=100000.0 "Gear elasticity (spring constant)";
        parameter Real d(final unit="N.m.s/rad",final min=0)=0 "(relative) gear damping";
        parameter SI.Angle b(final min=0)=0 "Total backlash";
        annotation(Documentation(info="<html>
 <p>
 This component models the essential effects of a gearbox, in particular
 gear <b>efficiency</b> due to friction between the teeth, <b>bearing friction</b>,
 gear <b>elasticity</b> and <b>damping</b>, <b>backlash</b>.
 The inertia of the gear wheels is not modeled. If necessary, inertia
 has to be taken into account by connecting components of model Inertia
 to the left and/or the right flange.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-40.0,60.0},{40.0,-60.0}}, lineColor={0,0,0}, pattern=LinePattern.None, lineThickness=0.25, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-60.0,-80.0},{-46.0,-80.0},{-20.0,-20.0},{20.0,-20.0},{46.0,-80.0},{60.0,-80.0},{60.0,-90.0},{-60.0,-90.0},{-60.0,-80.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Rectangle(extent={{-100.0,10.0},{-60.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{60.0,10.0},{100.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-60.0,10.0},{-60.0,20.0},{-40.0,40.0},{-40.0,-40.0},{-60.0,-20.0},{-60.0,10.0}}, lineColor={0,0,0}, fillColor={128,128,128}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{60.0,20.0},{40.0,40.0},{40.0,-40.0},{60.0,-20.0},{60.0,20.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{0.0,129.0},{0.0,70.0}}, textString="%name=%ratio", fillColor={0,0,255}),Text(extent={{-100.0,-152.0},{99.0,-112.0}}, textString="c=%c", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{2.0,29.0},{46.0,22.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{4.0,25.0},{-4.0,27.0},{-4.0,23.0},{4.0,25.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-36.0,25.0},{-3.0,25.0}}, color={128,128,128})}));
        IdealGear gearRatio(final ratio=ratio) annotation(Placement(transformation(x=-60.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-60.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        GearEfficiency gearEfficiency(final eta=eta) annotation(Placement(transformation(x=-20.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-20.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        ElastoBacklash elastoBacklash(final b=b,final c=c,final phi_rel0=0,final d=d) annotation(Placement(transformation(x=60.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=60.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        BearingFriction bearingFriction(final tau_pos=friction_pos,final peak=peak) annotation(Placement(transformation(x=20.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=20.0,y=0.0,scale=0.1,aspectRatio=1.0)));

      equation 
        connect(flange_a,gearRatio.flange_a) annotation(Line(points={{-100.0,0.0},{-70.0,0.0}},color={0,0,0}));
        connect(gearRatio.flange_b,gearEfficiency.flange_a) annotation(Line(points={{-50.0,0.0},{-30.0,0.0}},color={0,0,0}));
        connect(gearEfficiency.flange_b,bearingFriction.flange_a) annotation(Line(points={{-10.0,0.0},{10.0,0.0}},color={0,0,0}));
        connect(bearingFriction.flange_b,elastoBacklash.flange_a) annotation(Line(points={{30.0,0.0},{50.0,0.0}},color={0,0,0}));
        connect(elastoBacklash.flange_b,flange_b) annotation(Line(points={{70.0,0.0},{100.0,0.0}},color={0,0,0}));
        connect(gearRatio.bearing,adapter.flange_b) annotation(Line(points={{-60.0,-10.0},{-60.0,-40.0},{6.12303e-016,-40.0},{6.12303e-016,-50.0}},color={0,0,0}));
        connect(gearEfficiency.bearing,adapter.flange_b) annotation(Line(points={{-20.0,-10.0},{-20.0,-40.0},{6.12303e-016,-40.0},{6.12303e-016,-50.0}},color={0,0,0}));
        connect(bearingFriction.bearing,adapter.flange_b) annotation(Line(points={{20.0,-10.0},{20.0,-40.0},{6.12303e-016,-40.0},{6.12303e-016,-50.0}},color={0,0,0}));
      end Gear;
      model Gear2 "Realistic model of a gearbox (based on LossyGear)"
              extends Interfaces.TwoFlangesAndBearingH;
        parameter Real i=1 "transmission ratio (flange_a.phi/flange_b.phi)";
        parameter Real lossTable[:,5]={{0,1,1,0,0}} "Array for mesh efficiencies and bearing friction depending on speed (see docu of LossyGear)";
        parameter Real c(final unit="N.m/rad",final min=Modelica.Constants.small)=100000.0 "Gear elasticity (spring constant)";
        parameter Real d(final unit="N.m.s/rad",final min=0)=0 "(relative) gear damping";
        parameter SI.Angle b(final min=0)=0 "Total backlash";
        annotation(Documentation(info="<html>
 <p>This component models the essential effects of a gearbox, in
 particular</p>
 <ul>
   <li>in component <b>lossyGear</b></li>
     <ul>
       <li>gear <b>efficiency</b> due to friction between the teeth</li>
       <li><b>bearing friction</b></li>
     </ul>
   <li>in component <b>elastoBacklash</b></li>
     <ul>
       <li>gear <b>elasticity</b></li>
       <li><b>damping</b></li>
       <li><b>backlash</b></li>
     </ul>
 </ul>
 <p>The inertia of the gear wheels is not modeled. If necessary,
 inertia has to be taken into account by connecting components of
 model Inertia to the left and/or the right flange of component
 GearNew.</p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>September 12, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Realized based on Rotational.Gear by inventing Rotational.LossyGear.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,10.0},{-60.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{60.0,10.0},{100.0,-10.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-40.0,60.0},{40.0,-60.0}}, lineColor={0,0,0}, pattern=LinePattern.None, lineThickness=0.25, fillColor={192,192,192}, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-60.0,10.0},{-60.0,20.0},{-40.0,40.0},{-40.0,-40.0},{-60.0,-20.0},{-60.0,10.0}}, lineColor={0,0,0}, fillColor={128,128,128}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{60.0,20.0},{40.0,40.0},{40.0,-40.0},{60.0,-20.0},{60.0,20.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{0.0,129.0},{0.0,70.0}}, textString="%name=%i", fillColor={0,0,255}),Text(extent={{-100.0,-152.0},{99.0,-112.0}}, textString="c=%c", fillColor={0,0,0}),Polygon(points={{-60.0,-80.0},{-46.0,-80.0},{-20.0,-20.0},{20.0,-20.0},{46.0,-80.0},{60.0,-80.0},{60.0,-90.0},{-60.0,-90.0},{-60.0,-80.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{2.0,64.0},{46.0,57.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{4.0,60.0},{-4.0,62.0},{-4.0,58.0},{4.0,60.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-36.0,60.0},{-3.0,60.0}}, color={128,128,128})}));
        LossyGear lossyGear(final i=i,final lossTable=lossTable) annotation(Placement(transformation(x=-40.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-40.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        ElastoBacklash elastoBacklash(final b=b,final c=c,final phi_rel0=0,final d=d) annotation(Placement(transformation(x=40.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=40.0,y=0.0,scale=0.2,aspectRatio=1.0)));

      equation 
        connect(flange_a,lossyGear.flange_a) annotation(Line(points={{-100.0,0.0},{-60.0,0.0}},color={0,0,0}));
        connect(lossyGear.flange_b,elastoBacklash.flange_a) annotation(Line(points={{-20.0,0.0},{20.0,0.0}},color={0,0,0}));
        connect(elastoBacklash.flange_b,flange_b) annotation(Line(points={{60.0,0.0},{100.0,0.0}},color={0,0,0}));
        connect(lossyGear.bearing,adapter.flange_b) annotation(Line(points={{-40.0,-20.0},{-40.0,-40.0},{6.12303e-016,-40.0},{6.12303e-016,-50.0}},color={0,0,0}));
      end Gear2;
      model Position "Forced movement of a flange according to a reference angle signal"
              parameter Boolean exact=false "true/false exact treatment/filtering the input signal";
        parameter SI.Frequency f_crit=50 "if exact=false, critical frequency of filter to filter input signal";
        Modelica.Blocks.Interfaces.RealInput phi_ref(redeclare type SignalType= SI.Angle ) "reference angle of flange_b as input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        output SI.Angle phi "absolute rotation angle of flange flange_b";
        output SI.AngularVelocity w "absolute angular velocity of flange flange_b";
        output SI.AngularAcceleration a "absolute angular acceleration of flange flange_b";
        SI.Torque tau_support "Support torque";
      protected 
        parameter Real w_crit=2*Modelica.Constants.pi*f_crit "critical frequency in [1/s]";
        constant Real af=1.3617 "s coefficient of Bessel filter";
        constant Real bf=0.618 "s*s coefficient of Bessel filter";
      public 
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 The input signal <b>phi_ref</b> defines the <b>reference
 angle</b> in [rad]. Flange <b>flange_b</b> is <b>forced</b>
 to move according to this reference motion. According to parameter
 <b>exact</b> (default = <b>false</b>), this is done in the following way:
 <ol>
 <li><b>exact=true</b><br>
     The reference angle is treated <b>exactly</b>. This is only possible, if
     the input signal is defined by an analytical function which can be
     differentiated at least twice. If this prerequisite is fulfilled,
     the Modelica translator will differentiate the input signal twice
     in order to compute the reference acceleration of the flange.</li>
 <li><b>exact=false</b><br>
     The reference angle is <b>filtered</b> and the second derivative
     of the filtered curve is used to compute the reference acceleration
     of the flange. This second derivative is <b>not</b> computed by
     numerical differentiation but by an appropriate realization of the
     filter. For filtering, a second order Bessel filter is used.
     The critical frequency (also called cut-off frequency) of the
     filter is defined via parameter <b>f_crit</b> in [Hz]. This value
     should be selected in such a way that it is higher as the essential
     low frequencies in the signal.</li>
 </ol>
 <p>
 The input signal can be provided from one of the signal generator
 blocks of the block library Modelica.Blocks.Sources.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 19, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>.<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-20.0,-80.0},{20.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Text(extent={{-56.0,-56.0},{-172.0,-90.0}}, fillColor={0,0,0}, textString="phi_ref"),Text(extent={{150.0,60.0},{-150.0,100.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Line(points={{-80.0,80.0},{-10.0,80.0}}, color={128,128,128}),Polygon(points={{10.0,80.0},{-10.0,85.0},{-10.0,75.0},{10.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{50.0,87.0},{50.0,73.0}}, textString="rotation axis", fillColor={128,128,128})}));
        Interfaces.Flange_a bearing annotation(Placement(transformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0)));

      equation 
        0=flange_b.tau + tau_support;
        if cardinality(bearing) == 0 then
          bearing.phi=0;

        else
          bearing.tau=tau_support;

        end if;
        phi=flange_b.phi;
        w=der(phi);
        a=der(w);
        if exact then
          phi=phi_ref;

        else
          a=(((phi_ref - phi)*w_crit - af*w)*w_crit)/bf;

        end if;

      initial equation 
if not exact then
                  phi=phi_ref;
        end if;
      end Position;
      model Speed "Forced movement of a flange according to a reference angular velocity signal"
              parameter Boolean exact=false "true/false exact treatment/filtering the input signal";
        parameter SI.Frequency f_crit=50 "if exact=false, critical frequency of filter to filter input signal";
        SI.Angle phi_ref "reference angle defined by time integration of input signal";
        SI.Angle phi "absolute rotation angle of flange flange_b";
        SI.AngularVelocity w "absolute angular velocity of flange flange_b";
        SI.AngularAcceleration a "absolute angular acceleration of flange flange_b";
        SI.Torque tau_support "Support torque";
      protected 
        parameter Real w_crit=2*Constants.pi*f_crit "critical frequency in [1/s]";
      public 
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Interfaces.RealInput w_ref(redeclare type SignalType= SI.AngularVelocity ) "Reference angular velocity of flange_b as input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 The input signal <b>w_ref</b> defines the <b>reference
 angle</b> in [rad]. Flange <b>flange_b</b> is <b>forced</b>
 to move according to this reference motion. According to parameter
 <b>exact</b> (default = <b>false</b>), this is done in the following way:
 <ol>
 <li><b>exact=true</b><br>
     The reference angle is treated <b>exactly</b>. This is only possible, if
     the input signal is defined by an analytical function which can be
     differentiated at least twice. If this prerequisite is fulfilled,
     the Modelica translator will differentiate the input signal twice
     in order to compute the reference acceleration of the flange.</li>
 <li><b>exact=false</b><br>
     The reference angle is <b>filtered</b> and the second derivative
     of the filtered curve is used to compute the reference acceleration
     of the flange. This second derivative is <b>not</b> computed by
     numerical differentiation but by an appropriate realization of the
     filter. For filtering, a second order Bessel filter is used.
     The critical frequency (also called cut-off frequency) of the
     filter is defined via parameter <b>f_crit</b> in [Hz]. This value
     should be selected in such a way that it is higher as the essential
     low frequencies in the signal.</li>
 </ol>
 <p>
 The input signal can be provided from one of the signal generator
 blocks of the block library Modelica.Blocks.Sources.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>.<br>
        Realized based on component <tt>Position</tt> (implemented by
        <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>).</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-20.0,-80.0},{20.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Text(extent={{-54.0,-44.0},{-158.0,-78.0}}, fillColor={0,0,0}, textString="w_ref"),Text(extent={{0.0,120.0},{0.0,60.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Line(points={{-80.0,80.0},{-10.0,80.0}}, color={128,128,128}),Polygon(points={{10.0,80.0},{-10.0,85.0},{-10.0,75.0},{10.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{50.0,87.0},{50.0,73.0}}, textString="rotation axis", fillColor={128,128,128})}));
        Interfaces.Flange_a bearing annotation(Placement(transformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0)));

      equation 
        0=flange_b.tau + tau_support;
        if cardinality(bearing) == 0 then
          bearing.phi=0;

        else
          bearing.tau=tau_support;

        end if;
        der(phi_ref)=w_ref;
        phi=flange_b.phi;
        w=der(phi);
        a=der(w);
        if exact then
          w=w_ref;

        else
          a=(w_ref - w)*w_crit;

        end if;

      initial equation 
if not exact then
                  w=w_ref;
        end if;
      end Speed;
      model Accelerate "Forced movement of a flange according to an acceleration signal"
              parameter SI.Angle phi_start=0 "Start angle";
        parameter SI.AngularVelocity w_start=0 "Start angular velocity";
        SI.Angle phi(final start=phi_start,final fixed=true) "absolute rotation angle of flange flange_b";
        SI.AngularVelocity w(final start=w_start,final fixed=true) "absolute angular velocity of flange flange_b";
        SI.Torque tau_support "Support torque";
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Interfaces.RealInput a(redeclare type SignalType= SI.AngularAcceleration ) "absolute angular acceleration of flange_b as input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>
 The input signal <b>a</b> defines an <b>angular acceleration</b>
 in [rad/s2]. Flange <b>flange_b</b> is <b>forced</b> to move with
 this acceleration. The angular velocity <b>w</b> and the rotation angle
 <b>phi</b> of the flange are automatically determined by integration of
 the acceleration.
 </p>
 <p>
 The input signal can be provided from one of the signal generator
 blocks of the block library Modelica.Blocks.Sources.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        renamed (previous name: Move).</li>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-20.0,-80.0},{20.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Text(extent={{-84.0,-48.0},{-144.0,-86.0}}, fillColor={0,0,0}, textString="a"),Text(extent={{0.0,120.0},{0.0,60.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Line(points={{-80.0,80.0},{-10.0,80.0}}, color={128,128,128}),Polygon(points={{10.0,80.0},{-10.0,85.0},{-10.0,75.0},{10.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{50.0,87.0},{50.0,73.0}}, textString="rotation axis", fillColor={128,128,128})}));
        Interfaces.Flange_a bearing annotation(Placement(transformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0)));

      equation 
        0=flange_b.tau + tau_support;
        if cardinality(bearing) == 0 then
          bearing.phi=0;

        else
          bearing.tau=tau_support;

        end if;
        phi=flange_b.phi;
        w=der(phi);
        a=der(w);
      end Accelerate;
      model Move "Forced movement of a flange according to an angle, speed and angular acceleration signal"
              SI.Angle phi "absolute rotation angle of flange flange_b";
        SI.AngularVelocity w "absolute angular velocity of flange flange_b";
        SI.AngularAcceleration a "absolute angular acceleration of flange flange_b";
        SI.Torque tau_support "Support torque";
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealInput u[3] "angle, angular velocity and angular acceleration of flange_b as input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
      protected 
        Real constraintResidue;
        Real constraintResidue_d;
        Real constraintResidue_dd;
        annotation(Documentation(info="<html>
 <p>
 Flange <b>flange_b</b> is <b>forced</b> to move with a predefined motion
 according to the input signals:
 </p>
 <pre>
     u[1]: angle of flange
     u[2]: angular velocity of flange
     u[3]: angular acceleration of flange
 </pre>
 <p>
 The user has to guarantee that the input signals are consistent to each other,
 i.e., that u[2] is the derivative of u[1] and that
 u[3] is the derivative of u[2]. There are, however,
 also applications where by purpose these conditions do not hold. For example,
 if only the position dependent terms of a mechanical system shall be
 calculated, one may provide angle = angle(t) and set the angular velocity
 and the angular acceleration to zero.
 </p>
 <p>
 The input signals can be provided from one of the signal generator
 blocks of the block library Modelica.Blocks.Sources.
 </p>
 <p>
 Note, this model utilizes the non-standard function <b>constrain(..)</b>
 and assumes that this function is supported by the Modelica translator:
 </p>
 <pre>
    Real r[:], rd[:], rdd[:];
       ...
    r   = ..
    rd  = ...
    rdd = ...
    constrain(r,rd,rdd);
 </pre>
 <p>
 where r, rd and rdd are variables which need to be computed
 somewhere else. A simple implementation of constrain() is:
 </p>
 <pre>
    r = 0;
 </pre>
 <p>
 However, this implementation requires that r(t) is given as analytical,
 smooth function in order that it can be differentiated and it does
 not allow applications such as the one sketched above.
 Function constrain()
 is used to explicitly inform the Modelica translator that
 rd is the derivative of r and rdd is the derivative of rd
 and that all derivatives need to be identical to zero.
 The Modelica translator can utilize this information to use
 rd and rdd whenever the Pantelides algorithm requires to compute
 the derivatives of r (and takes rd and rdd instead of actually
 differentiating r).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 25, 2001</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.</li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Text(extent={{50.0,87.0},{50.0,73.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{10.0,80.0},{-10.0,85.0},{-10.0,75.0},{10.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-10.0,80.0}}, color={128,128,128}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Text(extent={{-100.0,80.0},{-100.0,40.0}}, textString="phi,w,a", fillColor={0,0,255})}),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-20.0,-80.0},{20.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-80.0,-60.0},{-80.0,-100.0}}, textString="phi,w,a", fillColor={0,0,0}),Rectangle(extent={{-100.0,20.0},{100.0,-20.0}}, fillColor={192,192,192}, lineColor={0,0,0}, pattern=LinePattern.None, fillPattern=FillPattern.HorizontalCylinder),Line(points={{-30.0,-32.0},{30.0,-32.0}}, color={0,0,0}),Line(points={{0.0,52.0},{0.0,32.0}}, color={0,0,0}),Line(points={{-29.0,32.0},{30.0,32.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{30.0,-42.0},{20.0,-52.0}}, color={0,0,0}),Line(points={{30.0,-32.0},{10.0,-52.0}}, color={0,0,0}),Line(points={{20.0,-32.0},{0.0,-52.0}}, color={0,0,0}),Line(points={{10.0,-32.0},{-10.0,-52.0}}, color={0,0,0}),Line(points={{0.0,-32.0},{-20.0,-52.0}}, color={0,0,0}),Line(points={{-10.0,-32.0},{-30.0,-52.0}}, color={0,0,0}),Line(points={{-20.0,-32.0},{-30.0,-42.0}}, color={0,0,0}),Text(extent={{0.0,120.0},{0.0,60.0}}, textString="%name", fillColor={0,0,255})}));
      public 
        Interfaces.Flange_a bearing annotation(Placement(transformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0)));

      equation 
        0=flange_b.tau + tau_support;
        if cardinality(bearing) == 0 then
          bearing.phi=0;

        else
          bearing.tau=tau_support;

        end if;
        phi=flange_b.phi;
        w=der(phi);
        a=der(w);
        constraintResidue=u[1] - phi;
        constraintResidue_d=u[2] - w;
        constraintResidue_dd=u[3] - a;
constrain(constraintResidue, constraintResidue_d, constraintResidue_dd);
      end Move;
      model Fixed "Flange fixed in housing at a given angle"
              parameter SI.Angle phi0=0 "Fixed offset angle of housing";
        Interfaces.Flange_b flange_b "(right) flange fixed in housing" annotation(Placement(transformation(x=0.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=0.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{0.0,-92.0},{0.0,-152.0}}, textString="%name=%phi0", fillColor={0,0,255}),Line(points={{-80.0,-40.0},{80.0,-40.0}}, color={0,0,0}),Line(points={{80.0,-40.0},{40.0,-80.0}}, color={0,0,0}),Line(points={{40.0,-40.0},{0.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{-40.0,-80.0}}, color={0,0,0}),Line(points={{-40.0,-40.0},{-80.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{0.0,-10.0}}, color={0,0,0})}),Documentation(info="<html>
 <p>
 The <b>flange</b> of a 1D rotational mechanical system is <b>fixed</b>
 at an angle phi0 in the <b>housing</b>. May be used:
 </p>
 <ul>
 <li> to connect a compliant element, such as a spring or a damper,
      between an inertia or gearbox component and the housing.
 <li> to fix a rigid element, such as an inertia, with a specific
      angle to the housing.
 </ul>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>July 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-40.0},{80.0,-40.0}}, color={0,0,0}),Line(points={{80.0,-40.0},{40.0,-80.0}}, color={0,0,0}),Line(points={{40.0,-40.0},{0.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{-40.0,-80.0}}, color={0,0,0}),Line(points={{-40.0,-40.0},{-80.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{0.0,-4.0}}, color={0,0,0}),Polygon(points={{8.0,46.0},{-12.0,51.0},{-12.0,41.0},{8.0,46.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-82.0,46.0},{-11.0,46.0}}, color={128,128,128}),Text(extent={{12.0,53.0},{80.0,40.0}}, textString="rotation axis", fillColor={128,128,128})}));

      equation 
        flange_b.phi=phi0;
      end Fixed;
      model Torque "Input signal acting as external torque on a flange"
              Modelica.Blocks.Interfaces.RealInput tau(redeclare type SignalType= SI.Torque ) "Torque driving the flange (a positive value accelerates the flange)" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Interfaces.Flange_b flange_b "(Right) flange" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 The input signal <b>tau</b> defines an external
 torque in [Nm] which acts (with negative sign) at
 a flange connector, i.e., the component connected to this
 flange is driven by torque <b>tau</b>.</p>
 <p>
 The input signal can be provided from one of the signal generator
 blocks of Modelica.Blocks.Sources.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{0.0,130.0},{0.0,70.0}}, textString="%name", fillColor={0,0,255}),Text(extent={{-62.0,-29.0},{-141.0,-70.0}}, textString="tau", fillColor={0,0,0}),Line(points={{-88.0,0.0},{-64.0,30.0},{-36.0,52.0},{-2.0,62.0},{28.0,56.0},{48.0,44.0},{64.0,28.0},{76.0,14.0},{86.0,0.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{86.0,0.0},{66.0,58.0},{37.0,27.0},{86.0,0.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Rectangle(extent={{-20.0,-80.0},{20.0,-120.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-30.0,-30.0},{30.0,-30.0}}, color={0,0,0}),Line(points={{0.0,-30.0},{0.0,-90.0}}, color={0,0,0}),Line(points={{-30.0,-50.0},{-10.0,-30.0}}, color={0,0,0}),Line(points={{-10.0,-50.0},{10.0,-30.0}}, color={0,0,0}),Line(points={{10.0,-50.0},{30.0,-30.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{14.0,86.0},{82.0,73.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{10.0,80.0},{-10.0,85.0},{-10.0,75.0},{10.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-9.0,80.0}}, color={128,128,128}),Line(points={{-88.0,0.0},{-64.0,30.0},{-36.0,52.0},{-2.0,62.0},{28.0,56.0},{48.0,44.0},{64.0,28.0},{76.0,14.0},{80.0,10.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{86.0,0.0},{66.0,58.0},{38.0,28.0},{86.0,0.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}));
        Interfaces.Flange_a bearing annotation(Placement(transformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-100.0,scale=0.1,aspectRatio=1.0)));

      equation 
        flange_b.tau=-tau;
        if cardinality(bearing) == 0 then
          bearing.phi=0;

        else
          bearing.tau=tau;

        end if;
      end Torque;
      model Torque2 "Input signal acting as torque on two flanges"
              extends Interfaces.TwoFlanges;
        Modelica.Blocks.Interfaces.RealInput tau(redeclare type SignalType= SI.Torque ) "Torque driving the two flanges (a positive value accelerates the flange)" annotation(Placement(transformation(x=0.0,y=40.0,scale=0.2,aspectRatio=1.0,rotation=270),iconTransformation(x=0.0,y=40.0,scale=0.2,aspectRatio=1.0,rotation=270)));
        annotation(Documentation(info="<HTML>
 <p>
 The input signal <b>tau</b> defines an external
 torque in [Nm] which acts at both flange connectors,
 i.e., the components connected to these flanges are driven by torque <b>tau</b>.</p>
 <p>The input signal can be provided from one of the signal generator
 blocks of Modelica.Blocks.Sources.</p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 27, 2003</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{0.0,-40.0},{0.0,-100.0}}, textString="%name", fillColor={0,0,255}),Polygon(points={{-78.0,24.0},{-69.0,17.0},{-89.0,0.0},{-78.0,24.0}}, lineColor={0,0,0}, lineThickness=0.5, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-74.0,20.0},{-70.0,23.0},{-65.0,26.0},{-60.0,28.0},{-56.0,29.0},{-50.0,30.0},{-41.0,30.0},{-35.0,29.0},{-31.0,28.0},{-26.0,26.0},{-21.0,23.0},{-17.0,20.0},{-13.0,15.0},{-10.0,9.0}}, color={0,0,0}, thickness=0.5),Line(points={{74.0,20.0},{70.0,23.0},{65.0,26.0},{60.0,28.0},{56.0,29.0},{50.0,30.0},{41.0,30.0},{35.0,29.0},{31.0,28.0},{26.0,26.0},{21.0,23.0},{17.0,20.0},{13.0,15.0},{10.0,9.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{89.0,0.0},{78.0,24.0},{69.0,17.0},{89.0,0.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{15.0,-71.0},{83.0,-84.0}}, textString="rotation axis", fillColor={128,128,128}),Polygon(points={{11.0,-77.0},{-9.0,-72.0},{-9.0,-82.0},{11.0,-77.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-79.0,-77.0},{-8.0,-77.0}}, color={128,128,128}),Line(points={{-75.0,20.0},{-71.0,23.0},{-66.0,26.0},{-61.0,28.0},{-57.0,29.0},{-51.0,30.0},{-42.0,30.0},{-36.0,29.0},{-32.0,28.0},{-27.0,26.0},{-22.0,23.0},{-18.0,20.0},{-14.0,15.0},{-11.0,9.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{-79.0,24.0},{-70.0,17.0},{-90.0,0.0},{-79.0,24.0}}, lineColor={0,0,0}, lineThickness=0.5, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{73.0,20.0},{69.0,23.0},{64.0,26.0},{59.0,28.0},{55.0,29.0},{49.0,30.0},{40.0,30.0},{34.0,29.0},{30.0,28.0},{25.0,26.0},{20.0,23.0},{16.0,20.0},{12.0,15.0},{9.0,9.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{88.0,0.0},{77.0,24.0},{68.0,17.0},{88.0,0.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}));

      equation 
        flange_a.tau=tau;
        flange_b.tau=-tau;
      end Torque2;
      model LinearSpeedDependentTorque "Linear dependency of torque versus speed"
              extends Modelica.Mechanics.Rotational.Interfaces.PartialSpeedDependentTorque;
        parameter Modelica.SIunits.Torque tau_nominal "nominal torque (if negative, torque is acting as load)";
        parameter Boolean TorqueDirection=true "same direction of torque in both directions of rotation";
        parameter Modelica.SIunits.AngularVelocity w_nominal(min=Modelica.Constants.eps) "nominal speed";
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-100.0},{100.0,100.0}}, color={0,0,255})}),Documentation(info="<HTML>
 <p>
 Model of torque, linearly dependent on angular velocity of flange.<br>
 Parameter TorqueDirection chooses whether direction of torque is the same in both directions of rotation or not.
 </p>
 </HTML>"));

      equation 
        if TorqueDirection then
          tau=-tau_nominal*abs(w/w_nominal);

        else
          tau=-(tau_nominal*w)/w_nominal;

        end if;
      end LinearSpeedDependentTorque;
      model QuadraticSpeedDependentTorque "Quadratic dependency of torque versus speed"
              extends Modelica.Mechanics.Rotational.Interfaces.PartialSpeedDependentTorque;
        parameter Modelica.SIunits.Torque tau_nominal "nominal torque (if negative, torque is acting as load)";
        parameter Boolean TorqueDirection=true "same direction of torque in both directions of rotation";
        parameter Modelica.SIunits.AngularVelocity w_nominal(min=Modelica.Constants.eps) "nominal speed";
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-100.0},{-80.0,-98.0},{-60.0,-92.0},{-40.0,-82.0},{-20.0,-68.0},{0.0,-50.0},{20.0,-28.0},{40.0,-2.0},{60.0,28.0},{80.0,62.0},{100.0,100.0}}, color={0,0,255})}),Documentation(info="<HTML>
 <p>
 Model of torque, quadratic dependent on angular velocity of flange.<br>
 Parameter TorqueDirection chooses whether direction of torque is the same in both directions of rotation or not.
 </p>
 </HTML>"));

      equation 
        if TorqueDirection then
          tau=-tau_nominal*(w/w_nominal)^2;

        else
          tau=-tau_nominal*smooth(1, if w >= 0 then (w/w_nominal)^2 else -(w/w_nominal)^2);

        end if;
      end QuadraticSpeedDependentTorque;
      model ConstantTorque "Constant torque, not dependent on speed"
              extends Modelica.Mechanics.Rotational.Interfaces.PartialSpeedDependentTorque;
        parameter Modelica.SIunits.Torque tau_constant "constant torque (if negative, torque is acting as load)";
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-98.0,0.0},{100.0,0.0}}, color={0,0,255})}),Documentation(info="<HTML>
 <p>
 Model of constant torque, not dependent on angular velocity of flange.<br>
 Positive torque acts accelerating.
 </p>
 </HTML>"));

      equation 
        tau=-tau_constant;
      end ConstantTorque;
      model ConstantSpeed "Constant speed, not dependent on torque"
              extends Modelica.Mechanics.Rotational.Interfaces.PartialSpeedDependentTorque;
        parameter Modelica.SIunits.AngularVelocity w_fixed "fixed speed (if negative, torque is acting as load)";
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,-100.0},{0.0,100.0}}, color={0,0,255})}),Documentation(info="<HTML>
 <p>
 Model of <b>fixed</b> angular verlocity of flange, not dependent on torque.
 </p>
 </HTML>"));

      equation 
        w=w_fixed;
      end ConstantSpeed;
      model TorqueStep "Constant torque, not dependent on speed"
              extends Modelica.Mechanics.Rotational.Interfaces.PartialSpeedDependentTorque;
        parameter Modelica.SIunits.Torque stepTorque=1 "height of torque step (if negative, torque is acting as load)";
        parameter Modelica.SIunits.Torque offsetTorque=0 "offset of torque";
        parameter Modelica.SIunits.Time startTime=0 "output = offset for time < startTime";
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-60.0},{0.0,-60.0},{0.0,60.0},{80.0,60.0}}, color={0,0,255}),Text(extent={{0.0,-40.0},{100.0,-60.0}}, fillColor={0,0,255}, textString="time")}),Documentation(info="<HTML>
 <p>
 Model of a torque step at time .<br>
 Positive torque acts accelerating.
 </p>
 </HTML>"));

      equation 
        tau=-offsetTorque - (if time < startTime then 0 else stepTorque);
      end TorqueStep;
      model RelativeStates "Definition of relative state variables"
              extends Interfaces.TwoFlanges;
        SI.Angle phi_rel(stateSelect=StateSelect.prefer) "relative rotation angle used as state variable";
        SI.AngularVelocity w_rel(stateSelect=StateSelect.prefer) "relative angular velocity used as state variable";
        SI.AngularAcceleration a_rel "relative angular acceleration";
        annotation(Documentation(info="<html>
 <p>
 Usually, the absolute angle and the absolute angular velocity of
 Modelica.Mechanics.Rotational.Inertia models are used as state variables.
 In some circumstances, relative quantities are better suited, e.g.,
 because it may be easier to supply initial values.
 In such cases, model <b>RelativeStates</b> allows the definition of state variables
 in the following way:
 </p>
 <ul>
 <li> Connect an instance of this model between two flange connectors.</li>
 <li> The <b>relative rotation angle</b> and the <b>relative angular velocity</b>
      between the two connectors are used as <b>state variables</b>.
 </ul>
 <p>
 An example is given in the next figure
 </p>
 <IMG SRC=\"../Images/relativeStates.png\" ALT=\"relativeStates\">
 <p>
 Here, the relative angle and the relative angular velocity between
 the two inertias are used as state variables. Additionally, the
 simulator selects either the absolute angle and absolute angular
 velocity of model inertia1 or of model inertia2 as state variables.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 19, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-40.0,40.0},{40.0,-40.0}}, lineColor={0,255,255}, fillColor={0,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,40.0},{40.0,-40.0}}, textString="S", fillColor={0,0,255}),Line(points={{-92.0,0.0},{-42.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dot),Line(points={{40.0,0.0},{90.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dot),Text(extent={{0.0,-40.0},{0.0,-100.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-40.0,40.0},{40.0,-40.0}}, lineColor={0,255,255}, fillColor={0,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,40.0},{40.0,-40.0}}, textString="S", fillColor={0,0,255}),Line(points={{40.0,0.0},{96.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dash),Line(points={{-100.0,-10.0},{-100.0,-80.0}}, color={160,160,160}),Line(points={{100.0,-10.0},{100.0,-80.0}}, color={160,160,160}),Polygon(points={{80.0,-65.0},{80.0,-55.0},{100.0,-60.0},{80.0,-65.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Line(points={{-100.0,-60.0},{80.0,-60.0}}, color={160,160,160}),Text(extent={{-30.0,-70.0},{30.0,-90.0}}, textString="w_rel", fillColor={0,0,255}),Line(points={{-76.0,80.0},{-5.0,80.0}}, color={128,128,128}),Polygon(points={{14.0,80.0},{-6.0,85.0},{-6.0,75.0},{14.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{18.0,87.0},{86.0,74.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-96.0,0.0},{-40.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dash)}));

      equation 
        phi_rel=flange_b.phi - flange_a.phi;
        w_rel=der(phi_rel);
        a_rel=der(w_rel);
        flange_a.tau=0;
        flange_b.tau=0;
      end RelativeStates;
    end Rotational;
    package Translational "1-dimensional translational mechanical components"
          package Examples "Demonstration examples of the components of this package"
              extends Modelica.Icons.Library;
        annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package contains example models to demonstrate the usage of the
 Translational package. Open the models and
 simulate them according to the provided description in the models.
 The following examples are present:
 </p>
 <pre>
    <i>SignConvention</i>    Examples for the used sign conventions using simple, basic elements
    <i>InitialConditions</i> Setting of initial conditions
    <i>Accelerate </i>       Use of model accelerate
    <i>Damper</i>            Use of damper elements
    <i>Oscillator</i>        Oscillator demonstrates the use of initial conditions
    <i>Sensors</i>           Sensors for translational systems
    <i>Friction</i>          Stribeck friction characteristics
    <i>PreLoad</i>           Positioning of a spool using ElastoGap models
 </pre>
 <ul>
 <li><i>First Version from December 7, 1999 by P. Beater</i> </li>
 </ul>
 </HTML>
 "));
        encapsulated model SignConvention "Examples for the used sign conventions."
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Documentation(info="<html>
 <p>
 If all arrows point in the same direction a positive force
 results in a positive acceleration a, velocity v and position s.
 </p>
 For a force of 1 N and a mass of 1 Kg this leads to
 <pre>
         a = 1 m/s2
         v = 1 m/s after 1 s (SlidingMass1.v)
         s = 0.5 m after 1 s (SlidingMass1.s)
 </pre>
 The acceleration is not available for plotting.
 <p>
 </p>
 System 1) and 2) are equivalent. It doesn't matter whether the
 force pushes at flange_a in system 1 or pulls at flange_b in system 2.
 </p><p>
 It is of course possible to ignore the arrows and connect the models
 in an arbitrary way. But then it is hard see in what direction the
 force acts.
 </p><p>
 In the third system the two arrows are opposed which means that the
 force acts in the opposite direction (in the same direction as in
 the two other examples).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from December 10, 1999 by P. Beater </i> </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,80.0},{-82.0,60.0}}, textString="1)", fillColor={0,0,255}),Text(extent={{-100.0,40.0},{-82.0,20.0}}, textString="2)", fillColor={0,0,255}),Text(extent={{-100.0,-20.0},{-82.0,-40.0}}, textString="3)", fillColor={0,0,255})}));
          Translational.SlidingMass SlidingMass1(L=1) annotation(Placement(transformation(x=46.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=46.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.Force Force1 annotation(Placement(transformation(x=6.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=6.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Sources.Constant Constant1 annotation(Placement(transformation(x=-34.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-34.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass2(L=1) annotation(Placement(transformation(x=46.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=46.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Force Force2 annotation(Placement(transformation(x=6.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=6.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Sources.Constant Constant2 annotation(Placement(transformation(x=-34.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-34.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass3(L=1) annotation(Placement(transformation(x=-30.0,y=-30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=-30.0,scale=0.1,aspectRatio=1.0)));
          Translational.Force Force3 annotation(Placement(transformation(x=10.0,y=-30.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=10.0,y=-30.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Sources.Constant Constant3 annotation(Placement(transformation(x=50.0,y=-30.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=50.0,y=-30.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));

        equation 
          connect(Constant1.y,Force1.f) annotation(Line(points={{-23.0,70.0},{-6.0,70.0}},color={0,0,255}));
          connect(Constant2.y,Force2.f) annotation(Line(points={{-23.0,30.0},{-6.0,30.0}},color={0,0,255}));
          connect(Force3.f,Constant3.y) annotation(Line(points={{22.0,-30.0},{39.0,-30.0}},color={0,0,255}));
          connect(Force1.flange_b,SlidingMass1.flange_a) annotation(Line(points={{16.0,70.0},{36.0,70.0}},color={0,191,0}));
          connect(Force2.flange_b,SlidingMass2.flange_b) annotation(Line(points={{16.0,30.0},{82.0,30.0},{82.0,10.0},{56.0,10.0}},color={0,191,0}));
          connect(SlidingMass3.flange_b,Force3.flange_b) annotation(Line(points={{-20.0,-30.0},{0.0,-30.0}},color={0,191,0}));
        end SignConvention;
        encapsulated model InitialConditions "Setting of initial conditions"
                  import Modelica.Icons;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="There are several ways to set initial conditions.
 In the first system the position of the sliding mass m3 was defined
 by using the modifier s(start=4.5), the position of m5 by s(start=12.5).
 These positions were chosen such that the system is a rest. To calculate
 these values start at the left (Fixed1) with a value of 1 m. The spring
 has an unstreched length of 2 m and m3 an length of 3 m, which leads to
         1   m (Fixed1)
       + 2   m (Spring S2)
       + 3/2 m (half of the length of SlidingMass m3)
       -------
         4,5 m = s(start = 4.5) for m3
       + 3/2 m (half of the length of SlidingMass m3)
       + 4   m (SpringDamper 4
       + 5/2 m (half of length of SlidingMass m5)
       -------
        12,5 m = s(start = 12.5) for m5
 This selection of initial conditions has the effect that Dymola selects
 those variables (m3.s and m5.s) as state variables.
 In the second example the length of the springs are given as start values
 but they cannot be used as state for pure springs (only for the spring/damper
 combination). In this case the system is not at rest.
 <html> <IMG SRC=../Images/Fig.translational.examples.InitialConditions.png>  </HTML>
 <html>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from December 10, 1999 by P. Beater </i> </li>
 <li><i>Parameters and documentation modified, July 17, 2001 by P. Beater </i> </li>
 </ul>
 </HTML>
 "));
          Translational.SlidingMass M3(L=3,s(start=4.5)) annotation(Placement(transformation(x=-10.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring S2(s_rel0=2,c=1000) annotation(Placement(transformation(x=-50.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed1(s0=1) annotation(Placement(transformation(x=-90.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.SpringDamper SD4(s_rel0=4,c=111) annotation(Placement(transformation(x=30.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass M5(L=5,s(start=12.5)) annotation(Placement(transformation(x=70.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass M1(L=1) annotation(Placement(transformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring S1(s_rel0=1,c=1000,s_rel(start=1)) annotation(Placement(transformation(x=-48.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-48.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed2(s0=-1) annotation(Placement(transformation(x=-90.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Translational.SpringDamper SD1(s_rel0=1,c=111,s_rel(start=1)) annotation(Placement(transformation(x=30.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass M2(L=2) annotation(Placement(transformation(x=70.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=-10.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(Fixed1.flange_b,S2.flange_a) annotation(Line(points={{-90.0,70.0},{-60.0,70.0}},color={127,255,0}));
          connect(S2.flange_b,M3.flange_a) annotation(Line(points={{-40.0,70.0},{-20.0,70.0}},color={127,255,0}));
          connect(M3.flange_b,SD4.flange_a) annotation(Line(points={{0.0,70.0},{20.0,70.0}},color={127,255,0}));
          connect(SD4.flange_b,M5.flange_a) annotation(Line(points={{40.0,70.0},{60.0,70.0}},color={127,255,0}));
          connect(Fixed2.flange_b,S1.flange_a) annotation(Line(points={{-90.0,-10.0},{-58.0,-10.0}},color={127,255,0}));
          connect(S1.flange_b,M1.flange_a) annotation(Line(points={{-38.0,-10.0},{-20.0,-10.0}},color={127,255,0}));
          connect(M1.flange_b,SD1.flange_a) annotation(Line(points={{0.0,-10.0},{20.0,-10.0}},color={127,255,0}));
          connect(SD1.flange_b,M2.flange_a) annotation(Line(points={{40.0,-10.0},{60.0,-10.0}},color={127,255,0}));
        end InitialConditions;
        encapsulated model WhyArrows "Use of arrows in Mechanics.Translational"
                  import Modelica.Icons;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="When using the models of the translational sublibrary
 it is recommended to make sure that all arrows point in
 the same direction because then all component have the
 same reference system.
 In the example the distance from flange_a of Rod1 to flange_b
 of Rod2 is 2 m. The distance from flange_a of Rad1 to flange_b
 of Rod3 is also 2 m though it is difficult to see that. Without
 the arrows it would be almost impossible to notice.
 That all arrows point in the same direction is a sufficient
 condition for an easy use of the library. There are cases
 where horizontally flipped models can be used without
 problems.
 <html>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from July 17, 2001 by P. Beater </i> </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-80.0,14.0},{90.0,0.0}}, textString="PositionSensor2.s = PositionSensor3.s", fillColor={0,0,255}),Text(extent={{-84.0,4.0},{88.0,-16.0}}, textString="PositionSensor3.s <> PositionSensor1.s", fillColor={0,0,255}),Text(extent={{-82.0,-80.0},{94.0,-92.0}}, textString="Both systems are equivalent", fillColor={0,0,255}),Line(points={{-90.0,-28.0},{90.0,-28.0}}, thickness=0.5, color={0,0,255})}));
          Translational.Fixed Fixed1 annotation(Placement(transformation(x=-10.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Rod1(L=1) annotation(Placement(transformation(x=-38.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-38.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Rod2(L=1) annotation(Placement(transformation(x=30.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Rod3(L=1) annotation(Placement(transformation(x=-40.0,y=68.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-40.0,y=68.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Translational.Sensors.PositionSensor PositionSensor2 annotation(Placement(transformation(x=70.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Translational.Sensors.PositionSensor PositionSensor1 annotation(Placement(transformation(x=-70.0,y=30.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-70.0,y=30.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Translational.Sensors.PositionSensor PositionSensor3 annotation(Placement(transformation(x=-70.0,y=68.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-70.0,y=68.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Translational.Fixed Fixed3(s0=-1.9) annotation(Placement(transformation(x=-90.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring Spring1(s_rel0=2,c=11) annotation(Placement(transformation(x=-64.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-64.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass1(L=2) annotation(Placement(transformation(x=-36.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-36.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed2(s0=-1.9) annotation(Placement(transformation(x=14.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=14.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring Spring2(s_rel0=2,c=11) annotation(Placement(transformation(x=40.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=40.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass2(L=2) annotation(Placement(transformation(x=68.0,y=-50.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=68.0,y=-50.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));

        equation 
          connect(Rod1.flange_b,Fixed1.flange_b) annotation(Line(points={{-28.0,30.0},{-10.0,30.0}},color={0,191,0}));
          connect(Fixed1.flange_b,Rod2.flange_a) annotation(Line(points={{-10.0,30.0},{20.0,30.0}},color={0,191,0}));
          connect(Rod3.flange_a,Fixed1.flange_b) annotation(Line(points={{-30.0,68.0},{-10.0,68.0},{-10.0,30.0}},color={0,191,0}));
          connect(Rod2.flange_b,PositionSensor2.flange_a) annotation(Line(points={{40.0,30.0},{60.0,30.0}},color={0,191,0}));
          connect(PositionSensor1.flange_a,Rod1.flange_a) annotation(Line(points={{-60.0,30.0},{-48.0,30.0}},color={0,191,0}));
          connect(PositionSensor3.flange_a,Rod3.flange_b) annotation(Line(points={{-60.0,68.0},{-50.0,68.0}},color={0,191,0}));
          connect(Fixed3.flange_b,Spring1.flange_a) annotation(Line(points={{-90.0,-50.0},{-74.0,-50.0}},color={0,191,0}));
          connect(Spring1.flange_b,SlidingMass1.flange_b) annotation(Line(points={{-54.0,-50.0},{-54.0,-72.0},{-26.0,-72.0},{-26.0,-50.0}},color={0,191,0}));
          connect(Fixed2.flange_b,Spring2.flange_a) annotation(Line(points={{14.0,-50.0},{30.0,-50.0}},color={0,191,0}));
          connect(Spring2.flange_b,SlidingMass2.flange_b) annotation(Line(points={{50.0,-50.0},{58.0,-50.0}},color={0,191,0}));
        end WhyArrows;
        encapsulated model Accelerate "Use of model accelerate."
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          Translational.Accelerate Accelerate1 annotation(Placement(transformation(x=-30.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass1(L=1) annotation(Placement(transformation(x=50.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=50.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Sources.Constant Constant1 annotation(Placement(transformation(x=-90.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=30.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(Constant1.y,Accelerate1.a) annotation(Line(points={{-79.0,30.0},{-42.0,30.0}},color={0,0,255}));
          connect(Accelerate1.flange_b,SlidingMass1.flange_a) annotation(Line(points={{-20.0,30.0},{40.0,30.0}},color={0,191,0}));
        end Accelerate;
        encapsulated model Damper "Use of damper models."
                  import Modelica.Icons;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Documentation(info="Release notes:
 --------------
 2001 - 7  - 14: Damping parameters increased (from 1 to 25)
 "));
          Translational.SlidingMass SlidingMass1(L=1,v(start=10),s(start=3)) annotation(Placement(transformation(x=-70.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.Damper Damper1(d=25) annotation(Placement(transformation(x=-10.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed1(s0=4.5) annotation(Placement(transformation(x=32.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=32.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass2(L=1,v(start=10),s(start=3)) annotation(Placement(transformation(x=-70.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Damper Damper2(d=25) annotation(Placement(transformation(x=-10.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed2(s0=4.5) annotation(Placement(transformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass3(L=1,v(start=10),s(start=3)) annotation(Placement(transformation(x=-70.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed3(s0=4.5) annotation(Placement(transformation(x=30.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring Spring1(s_rel0=1) annotation(Placement(transformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Translational.SpringDamper SpringDamper1(s_rel0=1,d=25) annotation(Placement(transformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(SlidingMass1.flange_b,Damper1.flange_a) annotation(Line(points={{-60.0,70.0},{-20.0,70.0}},color={0,191,0}));
          connect(Damper1.flange_b,Fixed1.flange_b) annotation(Line(points={{0.0,70.0},{32.0,70.0}},color={0,191,0}));
          connect(SlidingMass2.flange_b,Damper2.flange_a) annotation(Line(points={{-60.0,10.0},{-20.0,10.0}},color={0,191,0}));
          connect(Damper2.flange_b,Fixed2.flange_b) annotation(Line(points={{0.0,10.0},{30.0,10.0}},color={0,191,0}));
          connect(Damper2.flange_b,Spring1.flange_b) annotation(Line(points={{0.0,10.0},{0.0,-10.0}},color={0,191,0}));
          connect(Damper2.flange_a,Spring1.flange_a) annotation(Line(points={{-20.0,10.0},{-20.0,-10.0}},color={0,191,0}));
          connect(SlidingMass3.flange_b,SpringDamper1.flange_a) annotation(Line(points={{-60.0,-50.0},{-20.0,-50.0}},color={0,191,0}));
          connect(SpringDamper1.flange_b,Fixed3.flange_b) annotation(Line(points={{0.0,-50.0},{30.0,-50.0}},color={0,191,0}));
        end Damper;
        encapsulated model Oscillator "Oscillator demonstrates the use of initial conditions."
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="A spring - mass system is a mechanical oscillator. If no
 damping is included and the system is excited at resonance
 frequency infinite amplitudes will result.
 The resonant frequency is given by
 omega_res = sqrt(c / m)
 with: c spring stiffness
       m mass
 To make sure that the system is initially at rest the initial
 conditions s(start=0) and v(start=0) for the SlindingMass
 are set.
 If damping is added the amplitudes are bounded.
 <html>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from December 10, 1999 by P. Beater </i> </li>
 </ul>
 </HTML>
 "));
          Translational.SlidingMass SlidingMass1(L=1,s(start=-0.5),v(start=0.0)) annotation(Placement(transformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring Spring1(s_rel0=1,c=10000) annotation(Placement(transformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed1(s0=1.0) annotation(Placement(transformation(x=70.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Force Force1 annotation(Placement(transformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Sources.Sine Sine1(freqHz=15.9155) annotation(Placement(transformation(x=-90.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass2(L=1,s(start=-0.5),v(start=0.0)) annotation(Placement(transformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring Spring2(s_rel0=1,c=10000) annotation(Placement(transformation(x=30.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed2(s0=1.0) annotation(Placement(transformation(x=70.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Force Force2 annotation(Placement(transformation(x=-50.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Sources.Sine Sine2(freqHz=15.9155) annotation(Placement(transformation(x=-90.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Damper Damper1(d=10) annotation(Placement(transformation(x=30.0,y=-26.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-26.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(Sine1.y,Force1.f) annotation(Line(points={{-79.0,50.0},{-62.0,50.0}},color={0,0,255}));
          connect(Sine2.y,Force2.f) annotation(Line(points={{-79.0,-50.0},{-62.0,-50.0}},color={0,0,255}));
          connect(Force1.flange_b,SlidingMass1.flange_a) annotation(Line(points={{-40.0,50.0},{-20.0,50.0}},color={0,191,0}));
          connect(Spring1.flange_b,Fixed1.flange_b) annotation(Line(points={{40.0,50.0},{70.0,50.0}},color={0,191,0}));
          connect(SlidingMass1.flange_b,Spring1.flange_a) annotation(Line(points={{0.0,50.0},{20.0,50.0}},color={0,191,0}));
          connect(Force2.flange_b,SlidingMass2.flange_a) annotation(Line(points={{-40.0,-50.0},{-20.0,-50.0}},color={0,191,0}));
          connect(Spring2.flange_a,Damper1.flange_a) annotation(Line(points={{20.0,-50.0},{20.0,-26.0}},color={0,191,0}));
          connect(SlidingMass2.flange_b,Spring2.flange_a) annotation(Line(points={{0.0,-50.0},{20.0,-50.0}},color={0,191,0}));
          connect(Damper1.flange_b,Spring2.flange_b) annotation(Line(points={{40.0,-26.0},{40.0,-50.0}},color={0,191,0}));
          connect(Spring2.flange_b,Fixed2.flange_b) annotation(Line(points={{40.0,-50.0},{70.0,-50.0}},color={0,191,0}));
        end Oscillator;
        encapsulated model Sensors "Sensors for translational systems."
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="These sensors measure
    force f in N
    position s in m
    velocity v in m/s
    acceleration a in m/s2
 Dhe measured velocity and acceleration is independent on
 the flange the sensor is connected to. The position
 depends on the flange (flange_a or flange_b) and the
 length L of the component.
 Plot PositionSensor1.s, PositionSensor2.s and SlidingMass1.s
 to see the difference.
 <html>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from December 10, 1999 by P. Beater </i> </li>
 </ul>
 </HTML>
 "));
          Translational.Sensors.ForceSensor ForceSensor1 annotation(Placement(transformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Sensors.SpeedSensor SpeedSensor1 annotation(Placement(transformation(x=30.0,y=-30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-30.0,scale=0.1,aspectRatio=1.0)));
          Translational.Sensors.PositionSensor PositionSensor1 annotation(Placement(transformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Sensors.AccSensor AccSensor1 annotation(Placement(transformation(x=30.0,y=-70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-70.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SlidingMass1(L=1) annotation(Placement(transformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Force Force1 annotation(Placement(transformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Sources.Sine Sine1(amplitude=10,freqHz=4) annotation(Placement(transformation(x=-90.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Translational.Sensors.PositionSensor PositionSensor2 annotation(Placement(transformation(x=70.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=50.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(Sine1.y,Force1.f) annotation(Line(points={{-79.0,50.0},{-62.0,50.0}},color={0,0,255}));
          connect(ForceSensor1.flange_b,SlidingMass1.flange_a) annotation(Line(points={{0.0,50.0},{20.0,50.0}},color={0,191,0}));
          connect(SlidingMass1.flange_b,PositionSensor2.flange_a) annotation(Line(points={{40.0,50.0},{60.0,50.0}},color={0,191,0}));
          connect(Force1.flange_b,ForceSensor1.flange_a) annotation(Line(points={{-40.0,50.0},{-20.0,50.0}},color={0,191,0}));
          connect(SlidingMass1.flange_a,PositionSensor1.flange_a) annotation(Line(points={{20.0,50.0},{20.0,10.0}},color={0,191,0}));
          connect(PositionSensor1.flange_a,SpeedSensor1.flange_a) annotation(Line(points={{20.0,10.0},{20.0,-30.0}},color={0,191,0}));
          connect(SpeedSensor1.flange_a,AccSensor1.flange_a) annotation(Line(points={{20.0,-30.0},{20.0,-70.0}},color={0,191,0}));
        end Sensors;
        encapsulated model Friction "Use of model Stop"
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-56.0,-88.0},{62.0,-100.0}}, textString="simulate 5 s", fillColor={0,0,255}),Text(extent={{-100.0,80.0},{-80.0,60.0}}, textString="1)", fillColor={0,0,255}),Text(extent={{-100.0,20.0},{-80.0,0.0}}, textString="2)", fillColor={0,0,255})}),Documentation(info="1) Simulate and then plot Stop1.f as a function of Stop1.v
    This gives the Stribeck curve.
 2) This model gives an example for a hard stop. However there
    can arise some problems with the used modeling approach (use of
    Reinit, convergence problems). In this case use the ElastoGap
    to model a stop (see example Preload).
 <html>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from December 10, 1999 by P. Beater </i> </li>
 </ul>
 </HTML>
 "));
          Translational.Stop Stop1(L=1) annotation(Placement(transformation(x=70.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.Force Force1 annotation(Placement(transformation(x=28.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=28.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Sources.Sine Sine1(amplitude=25,freqHz=0.25) annotation(Placement(transformation(x=-10.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=70.0,scale=0.1,aspectRatio=1.0)));
          Translational.Stop Stop2(L=1,smax=0.9,smin=-0.9,F_Coulomb=3,F_Stribeck=5,s(start=0),v(start=-5)) annotation(Placement(transformation(x=70.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Spring Spring1(s_rel0=1,c=500) annotation(Placement(transformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Translational.Fixed Fixed1(s0=-1.75) annotation(Placement(transformation(x=-12.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-12.0,y=10.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(Sine1.y,Force1.f) annotation(Line(points={{1.0,70.0},{16.0,70.0}},color={0,0,255}));
          connect(Force1.flange_b,Stop1.flange_a) annotation(Line(points={{38.0,70.0},{60.0,70.0}},color={0,191,0}));
          connect(Fixed1.flange_b,Spring1.flange_a) annotation(Line(points={{-12.0,10.0},{20.0,10.0}},color={0,191,0}));
          connect(Spring1.flange_b,Stop2.flange_a) annotation(Line(points={{40.0,10.0},{60.0,10.0}},color={0,191,0}));
        end Friction;
        encapsulated model PreLoad "Preload of a spool using ElastoGap models."
                  import Modelica.Icons;
          import Modelica.Blocks.Sources;
          import Modelica.Mechanics.Translational;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-98.0,-68.0},{102.0,-94.0}}, textString="positive force => spool moves in positive direction ", fillColor={0,0,255}),Text(extent={{-32.0,-46.0},{38.0,-62.0}}, textString="Simulate for 100 s", fillColor={0,0,255}),Text(extent={{-100.0,-54.0},{100.0,-80.0}}, textString="plot Spool.s as a function of Force1.f", fillColor={0,0,255})}),Documentation(info="When designing hydraulic valves it is often necessary to hold the spool in
 a certain position as long as an external force is below a threshold value.
 If this force exceeds the treshold value a linear relation between force
 and position is desired.
 There are designs that need only one spring to accomplish this task. Using
 the ElastoGap elements this design can be modelled easily.
 Drawing of spool.
 <HTML> <IMG SRC=../Images/PreLoad.png> </HTML>
 <HTML> <IMG SRC=../Images/PreLoad3.png> </HTML>
 <HTML> <IMG SRC=../Images/PreLoad4.png> </HTML>
 Spool position s as a function of working force f.
 <HTML> <IMG SRC=../Images/PreLoad2.png> </HTML>
 <HTML>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from December 10, 1999 by P. Beater </i> </li>
 <li><i>July 17, 2001, parameters changed, by P. Beater </i> </li>
 <li><i>Ocotber 5, 2002, object diagram and parameters changed, by P. Beater </i> </li>
 </ul>
 </HTML>
 "));
          Translational.ElastoGap InnerContactA(s_rel0=1/1000,c=1000000,d=250) annotation(Placement(transformation(x=-58.0,y=30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-58.0,y=30.0,scale=0.1,aspectRatio=1.0)));
          Translational.ElastoGap InnerContactB(s_rel0=1/1000,c=1000000,d=250) annotation(Placement(transformation(x=64.0,y=30.0,scale=0.1,aspectRatio=1.0,style(color=58)),iconTransformation(x=64.0,y=30.0,scale=0.1,aspectRatio=1.0,style(color=58))));
          Translational.SlidingMass Spool(L=0.19,m=0.15,s(start=0.01475)) annotation(Placement(transformation(x=26.0,y=-22.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=26.0,y=-22.0,scale=0.2,aspectRatio=1.0)));
          Translational.Fixed FixedLe(s0=-0.0955) annotation(Placement(transformation(x=-88.0,y=68.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-88.0,y=68.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SpringPlateA(L=1/500,m=1/100,s(start=(-93)/1000)) annotation(Placement(transformation(x=-30.0,y=68.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=68.0,scale=0.1,aspectRatio=1.0)));
          Translational.SlidingMass SpringPlateB(L=1/500,m=1/100,s(start=-0.06925)) annotation(Placement(transformation(x=36.0,y=68.0,scale=0.1,aspectRatio=1.0,style(color=58)),iconTransformation(x=36.0,y=68.0,scale=0.1,aspectRatio=1.0,style(color=58))));
          Translational.Spring Spring(c=20000,s_rel0=1/40) annotation(Placement(transformation(x=2.0,y=68.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=2.0,y=68.0,scale=0.1,aspectRatio=1.0)));
          Translational.ElastoGap OuterContactA(s_rel0=0.0015,c=1000000,d=250) annotation(Placement(transformation(x=-64.0,y=68.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-64.0,y=68.0,scale=0.1,aspectRatio=1.0)));
          Translational.ElastoGap OuterContactB(c=1000000,d=250,s_rel0=0.0015) annotation(Placement(transformation(x=70.0,y=68.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=68.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Rod1(L=7/1000) annotation(Placement(transformation(x=-30.0,y=42.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=42.0,scale=0.1,aspectRatio=1.0)));
          Translational.Damper Friction(d=2500) annotation(Placement(transformation(x=-88.0,y=24.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-88.0,y=24.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Translational.Force Force1 annotation(Placement(transformation(x=-22.0,y=-22.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-22.0,y=-22.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Housing(L=0.0305) annotation(Placement(transformation(x=2.0,y=88.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=2.0,y=88.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Rod3(L=0.00575) annotation(Placement(transformation(x=-30.0,y=8.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=8.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Rod4(L=0.00575) annotation(Placement(transformation(x=36.0,y=8.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=36.0,y=8.0,scale=0.1,aspectRatio=1.0)));
          Translational.Rod Rod2(L=7/1000) annotation(Placement(transformation(x=36.0,y=42.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=36.0,y=42.0,scale=0.1,aspectRatio=1.0)));
          Sources.Sine Sine1(amplitude=150,freqHz=0.01) annotation(Placement(transformation(x=-66.0,y=-22.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-66.0,y=-22.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(OuterContactA.flange_b,SpringPlateA.flange_a) annotation(Line(points={{-54.0,68.0},{-40.0,68.0}},color={0,191,0}));
          connect(SpringPlateA.flange_b,Spring.flange_a) annotation(Line(points={{-20.0,68.0},{-8.0,68.0}},color={0,191,0}));
          connect(Spring.flange_b,SpringPlateB.flange_a) annotation(Line(points={{12.0,68.0},{26.0,68.0}},color={0,191,0}));
          connect(SpringPlateB.flange_b,OuterContactB.flange_a) annotation(Line(points={{46.0,68.0},{60.0,68.0}},color={0,191,0}));
          connect(FixedLe.flange_b,OuterContactA.flange_a) annotation(Line(points={{-88.0,68.0},{-74.0,68.0}},color={0,191,0}));
          connect(Friction.flange_a,FixedLe.flange_b) annotation(Line(points={{-88.0,34.0},{-88.0,68.0}},color={0,191,0}));
          connect(FixedLe.flange_b,Housing.flange_a) annotation(Line(points={{-88.0,68.0},{-88.0,88.0},{-8.0,88.0}},color={0,191,0}));
          connect(OuterContactB.flange_b,Housing.flange_b) annotation(Line(points={{80.0,68.0},{80.0,88.0},{12.0,88.0}},color={0,191,0}));
          connect(SpringPlateA.flange_b,Rod1.flange_a) annotation(Line(points={{-20.0,68.0},{-20.0,52.0},{-40.0,52.0},{-40.0,42.0}},color={0,191,0}));
          connect(InnerContactA.flange_a,Rod3.flange_a) annotation(Line(points={{-68.0,30.0},{-80.0,30.0},{-80.0,8.0},{-40.0,8.0}},color={0,191,0}));
          connect(InnerContactA.flange_b,Rod1.flange_b) annotation(Line(points={{-48.0,30.0},{-12.0,30.0},{-12.0,42.0},{-20.0,42.0}},color={0,191,0}));
          connect(Rod2.flange_a,InnerContactB.flange_a) annotation(Line(points={{26.0,42.0},{26.0,30.0},{54.0,30.0}},color={0,191,0}));
          connect(Rod4.flange_b,InnerContactB.flange_b) annotation(Line(points={{46.0,8.0},{80.0,8.0},{80.0,30.0},{74.0,30.0}},color={0,191,0}));
          connect(Friction.flange_b,Rod3.flange_a) annotation(Line(points={{-88.0,14.0},{-88.0,8.0},{-40.0,8.0}},color={0,191,0}));
          connect(Sine1.y,Force1.f) annotation(Line(points={{-55.0,-22.0},{-34.0,-22.0}},color={0,0,255}));
          connect(Force1.flange_b,Spool.flange_a) annotation(Line(points={{-12.0,-22.0},{6.0,-22.0}},color={0,191,0}));
          connect(Rod3.flange_b,Rod4.flange_a) annotation(Line(points={{-20.0,8.0},{26.0,8.0}},color={0,191,0}));
          connect(Rod2.flange_b,SpringPlateB.flange_a) annotation(Line(points={{46.0,42.0},{46.0,54.0},{26.0,54.0},{26.0,68.0}},color={0,191,0}));
          connect(Spool.flange_a,Rod4.flange_a) annotation(Line(points={{6.0,-22.0},{6.0,8.0},{26.0,8.0}},color={0,191,0}));
        end PreLoad;
      end Examples;
      package Sensors "Sensor for 1D translational mechanical quantities"
              extends Modelica.Icons.Library2;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-76.0,-81.0},{64.0,-1.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Polygon(points={{-6.0,-61.0},{-16.0,-37.0},{4.0,-37.0},{-6.0,-61.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-6.0,-21.0},{-6.0,-37.0}}, color={0,0,0}),Line(points={{-76.0,-21.0},{-6.0,-21.0}}, color={0,0,0}),Line(points={{-56.0,-61.0},{-56.0,-81.0}}, color={0,0,0}),Line(points={{-36.0,-61.0},{-36.0,-81.0}}, color={0,0,0}),Line(points={{-16.0,-61.0},{-16.0,-81.0}}, color={0,0,0}),Line(points={{4.0,-61.0},{4.0,-81.0}}, color={0,0,0}),Line(points={{24.0,-61.0},{24.0,-81.0}}, color={0,0,0}),Line(points={{44.0,-61.0},{44.0,-81.0}}, color={0,0,0})}));
        model ForceSensor "Ideal sensor to measure the force between two flanges"
                  extends Modelica.Icons.TranslationalSensor;
          Interfaces.Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput f(redeclare type SignalType= SI.Force ) "force in flange_a and flange_b (f = flange_a.f = -flange_b.f)" annotation(Placement(transformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <i>cut-force between two flanges</i> in an ideal way
 and provides the result as output signal (to be further processed
 with blocks of the Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{40.0,-70.0},{120.0,-120.0}}, textString="f", fillColor={0,0,0}),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-60.0}}, color={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-96.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{96.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-60.0}}, color={0,0,255})}));

        equation 
          flange_a.s=flange_b.s;
          flange_a.f=f;
          flange_b.f=-f;
        end ForceSensor;
        model PositionSensor "Ideal sensor to measure the absolute position"
                  extends Modelica.Icons.TranslationalSensor;
          Interfaces.Flange_a flange_a "flange to be measured (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput s(redeclare type SignalType= SI.Position ) "Absolute position of flange as output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <i>absolute position s</i> of a flange in an ideal way and provides the result as
 output signals (to be further processed with blocks of the
 Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.4,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{80.0,-28.0},{114.0,-62.0}}, textString="s", fillColor={0,0,0}),Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{100.0,0.0},{70.0,0.0}}, color={0,0,255}),Line(points={{-70.0,0.0},{-96.0,0.0}}, color={127,255,0})}));

        equation 
          s=flange_a.s;
          0=flange_a.f;
        end PositionSensor;
        model SpeedSensor "Ideal sensor to measure the absolute velocity"
                  extends Modelica.Icons.TranslationalSensor;
          Interfaces.Flange_a flange_a "flange to be measured (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          SI.Position s "Absolute position of flange";
          Modelica.Blocks.Interfaces.RealOutput v(redeclare type SignalType= SI.Velocity ) "Absolute velocity of flange as output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <i>absolute velocity v</i> of a flange in an ideal way and provides the result as
 output signals (to be further processed with blocks of the
 Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.4,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{80.0,-28.0},{111.0,-61.0}}, textString="v", fillColor={0,0,0}),Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-96.0,0.0}}, color={127,255,0}),Line(points={{100.0,0.0},{70.0,0.0}}, color={0,0,0})}));

        equation 
          s=flange_a.s;
          v=der(s);
          0=flange_a.f;
        end SpeedSensor;
        model AccSensor "Ideal sensor to measure the absolute acceleration"
                  extends Modelica.Icons.TranslationalSensor;
          Interfaces.Flange_a flange_a "flange to be measured (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          SI.Velocity v "Absolute velocity of flange";
          Modelica.Blocks.Interfaces.RealOutput a(redeclare type SignalType= SI.Acceleration ) "Absolute acceleration of flange as output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 Measures the <i>absolute acceleration a</i>
 of a flange in an ideal way and provides the result as
 output signals (to be further processed with blocks of the
 Modelica.Blocks library).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.4,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{80.0,-28.0},{115.0,-60.0}}, textString="a", fillColor={0,0,0}),Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-97.0,0.0}}, color={127,255,0}),Line(points={{100.0,0.0},{70.0,0.0}}, color={0,0,255})}));

        equation 
          v=der(flange_a.s);
          a=der(v);
          0=flange_a.f;
        end AccSensor;
      end Sensors;
      import SI = Modelica.SIunits;
      extends Modelica.Icons.Library2;
      annotation(preferedView="info",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-84.0,-73.0},{66.0,-73.0}}, color={0,0,0}),Rectangle(extent={{-81.0,-22.0},{-8.0,-65.0}}, lineColor={0,0,0}, fillColor={192,192,192}, pattern=LinePattern.None, fillPattern=FillPattern.Sphere),Line(points={{-8.0,-43.0},{-1.0,-43.0},{6.0,-64.0},{17.0,-23.0},{29.0,-65.0},{40.0,-23.0},{50.0,-44.0},{61.0,-44.0}}, color={0,0,0}),Line(points={{-59.0,-73.0},{-84.0,-93.0}}, color={0,0,0}),Line(points={{-11.0,-73.0},{-36.0,-93.0}}, color={0,0,0}),Line(points={{-34.0,-73.0},{-59.0,-93.0}}, color={0,0,0}),Line(points={{14.0,-73.0},{-11.0,-93.0}}, color={0,0,0}),Line(points={{39.0,-73.0},{14.0,-93.0}}, color={0,0,0}),Line(points={{63.0,-73.0},{38.0,-93.0}}, color={0,0,0})}),Documentation(info="<html>
 <p>
 This package contains components to model <i>1-dimensional translational
 mechanical</i> systems.
 </p>
 <p>
 The <i>filled</i> and <i>non-filled green squares</i> at the left and
 right side of a component represent <i>mechanical flanges</i>.
 Drawing a line between such squares means that the corresponding
 flanges are <i>rigidly attached</i> to each other. The components of this
 library can be usually connected together in an arbitrary way. E.g. it is
 possible to connect two springs or two sliding masses with inertia directly
 together.
 <p> The only <i>connection restriction</i> is that the Coulomb friction
 elements (Stop) should be only connected
 together provided a compliant element, such as a spring, is in between.
 The reason is that otherwise the frictional force is not uniquely
 defined if the elements are stuck at the same time instant (i.e., there
 does not exist a unique solution) and some simulation systems may not be
 able to handle this situation, since this leads to a singularity during
 simulation. It can only be resolved in a \"clean way\" by combining the
 two connected friction elements into
 one component and resolving the ambiguity of the frictional force in the
 stuck mode.
 </p>
 <p> Another restriction arises if the hard stops in model Stop are used, i. e.
 the movement of the mass is limited by a stop at smax or smin.
 <font color=\"#ff0000\"> <b>This requires the states Stop.s and Stop.v</b> </font>. If these states are eliminated during the index reduction
 the model will not work. To avoid this any inertias should be connected via springs
 to the Stop element, other sliding masses, dampers or hydraulic chambers must be avoided. </p>
 <p>
 In the <i>icon</i> of every component an <i>arrow</i> is displayed in grey
 color. This arrow characterizes the coordinate system in which the vectors
 of the component are resolved. It is directed into the positive
 translational direction (in the mathematical sense).
 In the flanges of a component, a coordinate system is rigidly attached
 to the flange. It is called <i>flange frame</i> and is directed in parallel
 to the component coordinate system. As a result, e.g., the positive
 cut-force of a \"left\" flange (flange_a) is directed into the flange, whereas
 the positive cut-force of a \"right\" flange (flange_b) is directed out of the
 flange. A flange is described by a Modelica connector containing
 the following variables:
 </p>
 <pre>
    SIunits.Position s  \"absolute position of flange\";
    <i>flow</i> Force f        \"cut-force in the flange\";
 </pre>
 <p>
 This package contains the following model components:
 </p>
 <pre>
    <i>Interfaces</i>       Sublibrary containing interface definitions.
    <i>Examples</i>         Examples of library usage.
    <i>SlidingMass</i>      Translational component with inertia.
    <i>Stop</i>             Sliding mass with Coulomb friction and hard stops.
    <i>Rod</i>              Massless rod.
    <i>Spring</i>           Linear spring.
    <i>Damper</i>           Linear damper.
    <i>SpringDamper</i>     Linear spring and linear damper in parallel connection.
    <i>ElastoGap</i>        Linear spring and linear damper that can lift off.
    <i>Position</i>         Drive a flange with a reference position given as input signal.
    <i>Accelerate</i>       Drive a flange with an acceleration given as input signal.
    <i>Move</i>             Drive a flange with a reference position, velocity and
                     acceleration given as input signal.
    <i>Fixed</i>            Fixed flange at a predefined position.
    <i>Force</i>            External force defined as input signal.
    <i>ForceSensor</i>      Ideal sensor to measure the force in a flange.
    <i>PositionSensor</i>   Ideal sensor to measure absolute position of a flange.
    <i>SpeedSensor</i>      Ideal sensor to measure absolute velocity of a flange.
    <i>AccSensor</i>        Ideal sensor to measure absolute acceleration of a flange.
 </pre>
 <p>
 This library is designed in a fully object oriented way in order that
 components can be connected together in every meaningful combination
 (e.g. direct connection of two springs or two shafts with inertia).
 As a consequence, most models lead to a system of
 differential-algebraic equations of <i>index 3</i> (= constraint
 equations have to be differentiated twice in order to arrive at
 a state space representation) and the Modelica translator or
 the simulator has to cope with this system representation.
 According to our present knowledge, this requires that the
 Modelica translator is able to symbolically differentiate equations
 (otherwise it is e.g. not possible to provide consistent initial
 conditions; even if consistent initial conditions are present, most
 numerical DAE integrators can cope at most with index 2 DAEs).
 </p>
 
 <dl>
 <dt><b>Main Author:</b></dt>
 <dd>Peter Beater <br>
     Universit&auml;t Paderborn, Abteilung Soest<br>
     Fachbereich Maschinenbau/Automatisierungstechnik<br>
     L&uuml;becker Ring 2 <br>
     D 59494 Soest <br>
     Germany <br>
     email: <A HREF=\"mailto:Beater@mailso.uni-paderborn.de\">Beater@mailso.uni-paderborn.de</A><br>
 </dd>
 </dl>
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association and Universit&auml;t Paderborn, FB 12.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>Version 1.0 (January 5, 2000)</i>
        by Peter Beater <br>
        Realized a first version based on Modelica library Mechanics.Rotational
        by Martin Otter and an existing Dymola library onedof.lib by Peter Beater.
        <br>
 <li><i>Version 1.01 (July 18, 2001)</i>
        by Peter Beater <br>
        Assert statement added to \"Stop\", small bug fixes in examples.
        <br><br>
 </li>
 </ul>
 </html>"));
      package Interfaces "Interfaces for 1D translational mechanical components"
              extends Modelica.Icons.Library;
        connector Flange_a "(left) 1D translational flange (flange axis directed INTO cut plane, e. g. from left to right)"
                  annotation(defaultComponentName="flange_a",Documentation(info="<html>
 This is a flange for 1D translational mechanical systems. In the cut plane of
 the flange a unit vector n, called flange axis, is defined which is directed
 INTO the cut plane, i. e. from left to right. All vectors in the cut plane are
 resolved with respect to
 this unit vector. E.g. force f characterizes a vector which is directed in
 the direction of n with value equal to f. When this flange is connected to
 other 1D translational flanges, this means that the axes vectors of the connected
 flanges are identical.
 </p>
 <p>
 The following variables are transported through this connector:
 <pre>
   s: Absolute position of the flange in [m]. A positive translation
      means that the flange is translated along the flange axis.
   f: Cut-force in direction of the flange axis in [N].
 </pre>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,191,0}, fillColor={0,191,0}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-40.0,-40.0},{40.0,40.0}}, lineColor={0,191,0}, fillColor={0,191,0}, fillPattern=FillPattern.Solid),Text(extent={{-160.0,110.0},{40.0,50.0}}, textString="%name", fillColor={0,191,0})}));
          SI.Position s "absolute position of flange";
          flow SI.Force f "cut force directed into flange";
        end Flange_a;
        connector Flange_b "right 1D translational flange (flange axis directed OUT OF cut plane)"
                  SI.Position s "absolute position of flange";
          flow SI.Force f "cut force directed into flange";
          annotation(defaultComponentName="flange_b",Documentation(info="<html>
 This is a flange for 1D translational mechanical systems. In the cut plane of
 the flange a unit vector n, called flange axis, is defined which is directed
 OUT OF the cut plane. All vectors in the cut plane are resolved with respect to
 this unit vector. E.g. force f characterizes a vector which is directed in
 the direction of n with value equal to f. When this flange is connected to
 other 1D translational flanges, this means that the axes vectors of the connected
 flanges are identical.
 </p>
 <p>
 The following variables are transported through this connector:
 <pre>
   s: Absolute position of the flange in [m]. A positive translation
      means that the flange is translated along the flange axis.
   f: Cut-force in direction of the flange axis in [N].
 </pre>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,191,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-40.0,-40.0},{40.0,40.0}}, lineColor={0,191,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,110.0},{160.0,50.0}}, textString="%name", fillColor={0,191,0})}));
        end Flange_b;
        partial model Rigid "Rigid connection of two translational 1D flanges "
                  SI.Position s "absolute position of center of component (s = flange_a.s + L/2 = flange_b.s - L/2)";
          parameter SI.Length L=0 "length of component from left flange to right flange (= flange_b.s - flange_a.s)";
          Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane, i. e. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane, i. e. from right to left)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 This is a 1D translational component with two <i>rigidly</i> connected flanges.
 The distance between the left and the right flange is always constant, i. e. L.
 The forces at the right and left flange can be different.
 It is used e.g. to built up sliding masses.
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater  (based on Rotational.Rigid)</i> </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

        equation 
          flange_a.s=s - L/2;
          flange_b.s=s + L/2;
        end Rigid;
        partial model Compliant "Compliant connection of two translational 1D flanges"
                  Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          SI.Distance s_rel "relative distance (= flange_b.s - flange_a.s)";
          SI.Force f "forcee between flanges (positive in direction of flange axis R)";
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 This is a 1D translational component with a <i>compliant </i>connection of two
 translational 1D flanges where inertial effects between the two
 flanges are not included. The absolute value of the force at the left and the right
 flange is the same. It is used to built up springs, dampers etc.
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.Compliant)</i> </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0})}));

        equation 
          s_rel=flange_b.s - flange_a.s;
          flange_b.f=f;
          flange_a.f=-f;
        end Compliant;
        partial model TwoFlanges "Component with two translational 1D flanges "
                  Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 This is a 1D translational component with two flanges.
 It is used e.g. to built up parts of a drive train consisting
 of several base components.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.TwoFlanges)</i> </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
        end TwoFlanges;
        partial model AbsoluteSensor "Device to measure a single absolute flange variable"
                  extends Modelica.Icons.TranslationalSensor;
          Interfaces.Flange_a flange_a "flange to be measured (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<html>
 <p>
 This is the superclass of a 1D translational component with one flange and one
 output signal in order to measure an absolute kinematic quantity in the flange
 and to provide the measured signal as output signal for further processing
 with the Modelica.Blocks blocks.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Version 1.0 (July 18, 1999)</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 <p><b>Copyright &copy; 1999-2002, Modelica Association and DLR.</b></p>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-90.0},{-20.0,-90.0}}, color={0,0,0}),Polygon(points={{10.0,-90.0},{-20.0,-80.0},{-20.0,-100.0},{10.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{-118.0,99.0},{118.0,40.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{100.0,0.0}}, color={0,0,255})}));
        end AbsoluteSensor;
        partial model RelativeSensor "Device to measure a single relative variable between two flanges"
                  extends Modelica.Icons.TranslationalSensor;
          Interfaces.Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane, e. g. from left to right)" annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Blocks.Interfaces.RealOutput y annotation(Placement(transformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true),iconTransformation(x=0.0,y=-110.0,scale=0.1,aspectRatio=1.0,rotation=90,flipVertical=true)));
          annotation(Documentation(info="<html>
 <p>
 This is a superclass for 1D translational components with two rigidly connected
 flanges and one output signal in order to measure relative kinematic quantities
 between the two flanges or the cut-force in the flange and
 to provide the measured signal as output signal for further processing
 with the Modelica.Blocks blocks.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Version 1.0 (July 18, 1999)</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 <p><b>Copyright &copy; 1999-2002, Modelica Association and DLR.</b></p>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-51.0,34.0},{29.0,34.0}}, color={0,0,0}),Polygon(points={{59.0,34.0},{29.0,44.0},{29.0,24.0},{59.0,34.0}}, lineColor={0,0,0}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-60.0}}, color={0,0,255}),Text(extent={{-117.0,116.0},{115.0,52.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-90.0,0.0}}, color={0,0,0}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-100.0},{0.0,-60.0}}, color={0,0,255})}));
        end RelativeSensor;
        partial model FrictionBase "Base class of Coulomb friction elements"
                  extends Rigid;
          parameter SI.Position smax=25 "right stop for (right end of) sliding mass";
          parameter SI.Position smin=-25 "left stop for (left end of) sliding mass";
          parameter SI.Velocity v_small=1/1000 "Relative velocity near to zero (see model info text)";
          SI.Velocity v_relfric "Relative velocity between frictional surfaces";
          SI.Acceleration a_relfric "Relative acceleration between frictional surfaces";
          SI.Force f "Friction force (positive, if directed in opposite direction of v_rel)";
          SI.Force f0 "Friction force for v=0 and forward sliding";
          SI.Force f0_max "Maximum friction force for v=0 and locked";
          Boolean free "true, if frictional element is not active";
          Real sa "Path parameter of friction characteristic f = f(a_relfric)";
          Boolean startForward "true, if v_rel=0 and start of forward sliding or v_rel > v_small";
          Boolean startBackward "true, if v_rel=0 and start of backward sliding or v_rel < -v_small";
          Boolean locked "true, if v_rel=0 and not sliding";
          constant Integer Unknown=3 "Value of mode is not known";
          constant Integer Free=2 "Element is not active";
          constant Integer Forward=1 "v_rel > 0 (forward sliding)";
          constant Integer Stuck=0 "v_rel = 0 (forward sliding, locked or backward sliding)";
          constant Integer Backward=-1 "v_rel < 0 (backward sliding)";
          Integer mode(final min=Backward,final max=Unknown,start=Unknown);
          annotation(Documentation(info="<html>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Version from January 5, 2000 by P. Beater
 (based on Translational.FrictionBase from Martin Otter)</i> </li>
 </ul>
 </HTML>
 "));

        equation 
          startForward=pre(mode) == Stuck and sa > f0_max and s < smax - L/2 or pre(startForward) and sa > f0 and s < smax - L/2 or pre(mode) == Backward and v_relfric > v_small or initial() and v_relfric > 0;
          startBackward=pre(mode) == Stuck and sa < -f0_max and s > smin + L/2 or pre(startBackward) and sa < -f0 and s > smin + L/2 or pre(mode) == Forward and v_relfric < -v_small or initial() and v_relfric < 0;
          locked=not free and not (pre(mode) == Forward or startForward or pre(mode) == Backward or startBackward);
          a_relfric=if locked then 0 else if free then sa else if startForward then sa - f0 else if startBackward then sa + f0 else if pre(mode) == Forward then sa - f0 else sa + f0;
          mode=if free then Free else if (pre(mode) == Forward or pre(mode) == Free or startForward) and (v_relfric > 0) and s < smax - L/2 then Forward else if (pre(mode) == Backward or pre(mode) == Free or startBackward) and (v_relfric < 0) and s > smin + L/2 then Backward else Stuck;
        end FrictionBase;
      end Interfaces;
      model SlidingMass "Sliding mass with inertia"
              extends Interfaces.Rigid;
        parameter SI.Mass m=1 "mass of the sliding mass";
        SI.Velocity v "absolute velocity of component";
        SI.Acceleration a "absolute acceleration of component";
        annotation(Documentation(info="<html>
 <p>
 Sliding mass with <i>inertia, without friction</i> and two rigidly connected flanges.
 </p>
 <p>
 The sliding mass has the length L, the position coordinate s is in the middle.
 Sign convention: A positive force at flange flange_a moves the sliding mass in the positive direction.
 A negative force at flange flange_a moves the sliding mass to the negative direction.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.Shaft)</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{-55.0,0.0}}, color={0,191,0}),Line(points={{55.0,0.0},{100.0,0.0}}, color={0,191,0}),Rectangle(extent={{-55.0,-30.0},{56.0,30.0}}, lineColor={0,0,0}, fillColor={255,255,255}, pattern=LinePattern.None, fillPattern=FillPattern.Sphere),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{-55.0,0.0}}, color={0,191,0}),Line(points={{55.0,0.0},{100.0,0.0}}, color={0,191,0}),Rectangle(extent={{-55.0,-30.0},{55.0,30.0}}, lineColor={0,0,0}, fillColor={255,255,255}, pattern=LinePattern.None, fillPattern=FillPattern.Sphere),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Line(points={{-100.0,-29.0},{-100.0,-61.0}}, color={0,0,0}),Line(points={{100.0,-61.0},{100.0,-28.0}}, color={0,0,0}),Line(points={{-98.0,-60.0},{98.0,-60.0}}, color={0,0,0}),Polygon(points={{-101.0,-60.0},{-96.0,-59.0},{-96.0,-61.0},{-101.0,-60.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Polygon(points={{100.0,-60.0},{95.0,-61.0},{95.0,-59.0},{100.0,-60.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Text(extent={{-44.0,-41.0},{51.0,-57.0}}, textString="Length L", fillColor={0,0,255}),Line(points={{0.0,30.0},{0.0,53.0}}, color={0,0,0}),Line(points={{-72.0,40.0},{1.0,40.0}}, color={0,0,0}),Polygon(points={{-7.0,42.0},{-7.0,38.0},{-1.0,40.0},{-7.0,42.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Text(extent={{-61.0,53.0},{-9.0,42.0}}, textString="Position s", fillColor={0,0,255})}));

      equation 
        v=der(s);
        a=der(v);
        m*a=flange_a.f + flange_b.f;
      end SlidingMass;
      model Stop "Sliding mass with hard stop and Stribeck friction"
              extends Modelica.Mechanics.Translational.Interfaces.FrictionBase(s(stateSelect=StateSelect.always));
        Modelica.SIunits.Velocity v(stateSelect=StateSelect.always) "Absolute velocity of flange_a and flange_b";
        Modelica.SIunits.Acceleration a "Absolute acceleration of flange_a and flange_b";
        parameter Modelica.SIunits.Mass m=1 "mass";
        parameter Real F_prop(final unit="N/ (m/s)",final min=0)=1 "velocity dependent friction";
        parameter Modelica.SIunits.Force F_Coulomb=5 "constant friction: Coulomb force";
        parameter Modelica.SIunits.Force F_Stribeck=10 "Stribeck effect";
        parameter Real fexp(final unit="1/ (m/s)",final min=0)=2 "exponential decay";
        annotation(Documentation(info="
 <HTML>
 <P>This element describes the <i>Stribeck friction characteristics</i> of a sliding mass,
 i. e. the frictional force acting between the sliding mass and the support. Included is a
 <i>hard stop</i> for the position. <BR>
 The surface is fixed and there is friction between sliding mass and surface.
 The frictional force f is given for positive velocity v by:</P>
 <i><uL>
 f = F_Coulomb + F_prop * v + F_Stribeck * exp (-fexp * v)</i> </ul><br>
 <IMG SRC=../Images/Stribeck.png>
 <br><br>
 The distance between the left and the right connector is given by parameter L.
 The position of the center of gravity, coordinate s, is in the middle between
 the two flanges. </p>
 <p>
 There are hard stops at smax and smin, i. e. if <i><uL>
 flange_a.s &gt;= smin
 <ul>    and </ul>
 flange_b.s &lt;= xmax </ul></i>
 the sliding mass can move freely.</p>
 <p>When the absolute velocity becomes zero, the sliding mass becomes stuck, i.e., the absolute position remains constant. In this phase the
 friction force is calculated from a force balance due to the requirement that the
 absolute acceleration shall be zero. The elements begin to slide when the friction
 force exceeds a threshold value, called the maximum static friction force, computed via: </P>
 <i><uL>
    maximum_static_friction =  F_Coulomb + F_Stribeck
 </i> </ul>
 <font color=\"#ff0000\"> <b>This requires the states Stop.s and Stop.v</b> </font>. If these states are eliminated during the index reduction
 the model will not work. To avoid this any inertias should be connected via springs
 to the Stop element, other sliding masses, dampers or hydraulic chambers must be avoided. </p>
 <p>For more details of the used friction model see the following reference: <br> <br>
 Beater P. (1999): <DD><a href=\"http://www.springer.de/cgi-bin/search_book.pl?isbn=3-540-65444-5\">
 Entwurf hydraulischer Maschinen</a>. Springer Verlag Berlin Heidelberg New York.</DL></P>
 <P>The friction model is implemented in a \"clean\" way by state events and leads to
 continuous/discrete systems of equations which have to be solved by appropriate
 numerical methods. The method is described in: </P>
 <DL>
 Otter M., Elmqvist H., and Mattsson S.E. (1999):
 <i><DD>Hybrid Modeling in Modelica based on the Synchronous Data Flow Principle</i>. CACSD'99, Aug. 22.-26, Hawaii. </DD>
 </DL>
 <P>More precise friction models take into account the elasticity of the material when
 the two elements are \"stuck\", as well as other effects, like hysteresis. This has
 the advantage that the friction element can be completely described by a differential
 equation without events. The drawback is that the system becomes stiff (about 10-20 times
 slower simulation) and that more material constants have to be supplied which requires more
 sophisticated identification. For more details, see the following references, especially
 (Armstrong and Canudas de Witt 1996): </P>
 <DL>
 Armstrong B. (1991):
 <i><DD>Control of Machines with Friction</i>. Kluwer Academic Press, Boston MA.<BR>
 </DD>
 <DT>Armstrong B., and Canudas de Wit C. (1996): </DT>
 <i><DD>Friction Modeling and Compensation.</i> The Control Handbook, edited by W.S.Levine, CRC Press, pp. 1369-1382.<BR>
 </DD>
 <DT>Canudas de Wit C., Olsson H., Astroem K.J., and Lischinsky P. (1995): </DT>
 <i><DD>A new model for control of systems with friction.</i> IEEE Transactions on Automatic Control, Vol. 40, No. 3, pp. 419-425.<BR>
 </DD>
 </DL>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from December 7, 1999 by P. Beater (based on Rotational.BearingFriction)</i> </li>
 <li><i>July 14, 2001 by P. Beater, assert on initialization added, diagram modified </i> </li>
 <li><i>October 11, 2001, by Hans Olsson, Dynasim, modified assert to handle start at stops,
 modified event logic such if you have friction parameters equal to zero you do not get events
 between the stops.</i> </li>
 <li><i>June 10, 2002 by P. Beater, StateSelect.always for variables s and v (instead of fixed=true). </i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Rectangle(extent={{-30.0,30.0},{35.0,-35.0}}, lineColor={0,0,0}, fillColor={255,255,255}, pattern=LinePattern.None, fillPattern=FillPattern.Sphere),Line(points={{-90.0,0.0},{-30.0,0.0}}, color={0,191,0}),Rectangle(extent={{-70.0,-45.0},{74.0,-60.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-63.0,-15.0},{-55.0,-45.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Rectangle(extent={{60.0,-16.0},{69.0,-45.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{35.0,0.0},{90.0,0.0}}, color={0,191,0}),Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Rectangle(extent={{-30.0,26.0},{35.0,-9.0}}, lineColor={0,0,0}, fillColor={255,255,255}, pattern=LinePattern.None, fillPattern=FillPattern.Sphere),Line(points={{-90.0,0.0},{-30.0,0.0}}, color={0,191,0}),Line(points={{35.0,0.0},{90.0,0.0}}, color={0,191,0}),Rectangle(extent={{-68.0,-14.0},{76.0,-29.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-119.0,43.0},{-111.0,17.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-111.0,43.0},{-111.0,50.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-151.0,49.0},{-113.0,49.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-149.0,51.0},{-126.0,60.0}}, textString="s min", fillColor={0,0,255}),Polygon(points={{-121.0,52.0},{-111.0,49.0},{-121.0,46.0},{-121.0,52.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Rectangle(extent={{124.0,42.0},{132.0,17.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{124.0,39.0},{124.0,87.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-19.0,78.0},{121.0,78.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-17.0,83.0},{6.0,92.0}}, textString="s max", fillColor={0,0,255}),Polygon(points={{114.0,81.0},{124.0,78.0},{114.0,75.0},{114.0,81.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{5.0,26.0},{5.0,63.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-77.0,58.0},{-1.0,58.0}}, color={0,0,0}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-75.0,60.0},{-38.0,71.0}}, textString="Position s", fillColor={0,0,255}),Polygon(points={{-5.0,61.0},{5.0,58.0},{-5.0,55.0},{-5.0,61.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-100.0,-10.0},{-100.0,-60.0}}, color={0,0,0}),Line(points={{100.0,-10.0},{100.0,-60.0}}, color={0,0,0}),Polygon(points={{90.0,-47.0},{100.0,-50.0},{90.0,-53.0},{90.0,-47.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Polygon(points={{-90.0,-47.0},{-90.0,-53.0},{-100.0,-50.0},{-90.0,-47.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-50.0},{92.0,-50.0}}, color={0,0,0}),Text(extent={{-11.0,-46.0},{26.0,-36.0}}, textString="Length L", fillColor={0,0,255})}));

      equation 
        f0=F_Coulomb + F_Stribeck;
        f0_max=f0*1.001;
        free=f0 <= 0 and F_prop <= 0 and s > smin + L/2 and s < smax - L/2;
        v=der(s);
        a=der(v);
        v_relfric=v;
        a_relfric=a;
        0=flange_a.f + flange_b.f - f - m*der(v);
        f=if locked then sa else if free then 0 else if startForward then F_prop*v + F_Coulomb + F_Stribeck else if startBackward then F_prop*v - F_Coulomb - F_Stribeck else if pre(mode) == Forward then F_prop*v + F_Coulomb + F_Stribeck*exp(-fexp*abs(v)) else F_prop*v - F_Coulomb - F_Stribeck*exp(-fexp*abs(v));
      algorithm 
        when initial() then
                  assert(s > smin + L/2 or s >= smin + L/2 and v >= 0, "Error in initialization of hard stop. (s - L/2) must be >= smin ");
          assert(s < smax - L/2 or s <= smax - L/2 and v <= 0, "Error in initialization of hard stop. (s + L/2) must be <= smax ");        
        end when;
        when not s < smax - L/2 then
                  reinit(s, smax - L/2);
          if not initial() or v > 0 then 
                    reinit(v, 0);

          else 
          end if;        
        end when;
        when not s > smin + L/2 then
                  reinit(s, smin + L/2);
          if not initial() or v < 0 then 
                    reinit(v, 0);

          else 
          end if;        
        end when;      end Stop;
      model Rod "Rod without inertia"
              extends Interfaces.Rigid;
        annotation(Documentation(info="<html>
 <p>
 Rod <i>without inertia</i> and two rigidly connected flanges.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{-55.0,0.0}}, color={0,191,0}),Line(points={{53.0,0.0},{99.0,0.0}}, color={0,191,0}),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Rectangle(extent={{-55.0,10.0},{53.0,-10.0}}, lineColor={160,160,160}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{0.0,100.0},{0.0,40.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{-55.0,0.0}}, color={0,191,0}),Line(points={{55.0,0.0},{100.0,0.0}}, color={0,191,0}),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Rectangle(extent={{-55.0,3.0},{53.0,-4.0}}, lineColor={160,160,160}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,-29.0},{-100.0,-61.0}}, color={0,0,0}),Line(points={{100.0,-61.0},{100.0,-28.0}}, color={0,0,0}),Line(points={{-98.0,-60.0},{98.0,-60.0}}, color={0,0,0}),Polygon(points={{-101.0,-60.0},{-96.0,-59.0},{-96.0,-61.0},{-101.0,-60.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Polygon(points={{100.0,-60.0},{95.0,-61.0},{95.0,-59.0},{100.0,-60.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Text(extent={{-44.0,-41.0},{51.0,-57.0}}, textString="Length L", fillColor={0,0,255})}));

      equation 
        0=flange_a.f + flange_b.f;
      end Rod;
      model Spring "Linear 1D translational spring"
              extends Interfaces.Compliant;
        parameter SI.Distance s_rel0=0 "unstretched spring length";
        parameter Real c(final unit="N/m",final min=0)=1 "spring constant ";
        annotation(Documentation(info="<html>
 <p>
 A <i>linear 1D translational spring</i>. The component can be connected either
 between two sliding masses, or between
 a sliding mass and the housing (model Fixed), to describe
 a coupling of the slidin mass with the housing via a spring.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.Spring)</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{0.0,110.0},{0.0,50.0}}, textString="%name", fillColor={0,0,255}),Line(points={{-86.0,0.0},{-60.0,0.0},{-44.0,-30.0},{-16.0,30.0},{14.0,-30.0},{44.0,30.0},{60.0,0.0},{84.0,0.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{-100.0,65.0}}, color={128,128,128}),Line(points={{100.0,0.0},{100.0,65.0}}, color={128,128,128}),Line(points={{-100.0,60.0},{100.0,60.0}}, color={128,128,128}),Polygon(points={{90.0,63.0},{100.0,60.0},{90.0,57.0},{90.0,63.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{-22.0,62.0},{18.0,87.0}}, textString="s_rel", fillColor={0,0,255}),Line(points={{-86.0,0.0},{-60.0,0.0},{-44.0,-30.0},{-16.0,30.0},{14.0,-30.0},{44.0,30.0},{60.0,0.0},{84.0,0.0}}, color={0,0,0})}));

      equation 
        f=c*(s_rel - s_rel0);
      end Spring;
      model Damper "Linear 1D translational damper"
              extends Interfaces.Compliant;
        parameter Real d(final unit="N/ (m/s)",final min=0)=0 "damping constant [N/ (m/s)]";
        SI.Velocity v_rel "relative velocity between flange_a and flange_b";
        annotation(Documentation(info="<html>
 <p>
 <i>Linear, velocity dependent damper</i> element. It can be either connected
 between a sliding mass and the housing (model Fixed), or
 between two sliding masses.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.Damper)</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{-60.0,0.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{-60.0,30.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{60.0,-30.0}}, color={0,0,0}),Line(points={{-60.0,30.0},{60.0,30.0}}, color={0,0,0}),Rectangle(extent={{-60.0,30.0},{30.0,-30.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{30.0,0.0},{90.0,0.0}}, color={0,0,0}),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Text(extent={{0.0,106.0},{0.0,46.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{-60.0,0.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{-60.0,30.0}}, color={0,0,0}),Line(points={{-60.0,-30.0},{60.0,-30.0}}, color={0,0,0}),Line(points={{-60.0,30.0},{60.0,30.0}}, color={0,0,0}),Rectangle(extent={{-60.0,30.0},{30.0,-30.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{30.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{-50.0,60.0},{50.0,60.0}}, color={128,128,128}),Polygon(points={{50.0,63.0},{60.0,60.0},{50.0,57.0},{50.0,63.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,68.0},{38.0,90.0}}, textString="der(s_rel)", fillColor={128,128,128})}));

      equation 
        v_rel=der(s_rel);
        f=d*v_rel;
      end Damper;
      model SpringDamper "Linear 1D translational spring and damper in parallel"
              extends Interfaces.Compliant;
        parameter SI.Position s_rel0=0 "unstretched spring length";
        parameter Real c(final unit="N/m",final min=0)=1 "spring constant";
        parameter Real d(final unit="N/(m/s)",final min=0)=1 "damping constant";
        SI.Velocity v_rel "relative velocity between flange_a and flange_b";
        annotation(Documentation(info="<html>
 <p>
 A <i>spring and damper element connected in parallel</i>.
 The component can be
 connected either between two sliding masses to describe the elasticity
 and damping, or between a sliding mass and the housing (model Fixed),
 to describe a coupling of the sliding mass with the housing via a spring/damper.
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.SpringDamper)</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,40.0},{-60.0,40.0},{-45.0,10.0},{-15.0,70.0},{15.0,10.0},{45.0,70.0},{60.0,40.0},{80.0,40.0}}, color={0,0,0}),Line(points={{-80.0,40.0},{-80.0,-70.0}}, color={0,0,0}),Line(points={{-80.0,-70.0},{-52.0,-70.0}}, color={0,0,0}),Rectangle(extent={{-52.0,-49.0},{38.0,-91.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-52.0,-49.0},{68.0,-49.0}}, color={0,0,0}),Line(points={{-51.0,-91.0},{69.0,-91.0}}, color={0,0,0}),Line(points={{38.0,-70.0},{80.0,-70.0}}, color={0,0,0}),Line(points={{80.0,40.0},{80.0,-70.0}}, color={0,0,0}),Line(points={{-90.0,0.0},{-80.0,0.0}}, color={0,0,0}),Line(points={{80.0,0.0},{90.0,0.0}}, color={0,0,0}),Polygon(points={{53.0,-18.0},{23.0,-8.0},{23.0,-28.0},{53.0,-18.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-57.0,-18.0},{23.0,-18.0}}, color={0,0,0}),Text(extent={{1.0,140.0},{1.0,80.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,32.0},{-58.0,32.0},{-43.0,2.0},{-13.0,62.0},{17.0,2.0},{47.0,62.0},{62.0,32.0},{80.0,32.0}}, color={0,0,0}, thickness=0.5),Line(points={{-100.0,31.0},{-100.0,96.0}}, color={128,128,128}),Line(points={{100.0,29.0},{100.0,94.0}}, color={128,128,128}),Line(points={{-98.0,82.0},{100.0,82.0}}, color={128,128,128}),Polygon(points={{90.0,85.0},{100.0,82.0},{90.0,79.0},{90.0,85.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{-21.0,61.0},{19.0,86.0}}, textString="s_rel", fillColor={0,0,255}),Rectangle(extent={{-52.0,-28.0},{38.0,-72.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-51.0,-72.0},{69.0,-72.0}}, color={0,0,0}),Line(points={{-52.0,-28.0},{68.0,-28.0}}, color={0,0,0}),Line(points={{38.0,-50.0},{80.0,-50.0}}, color={0,0,0}),Line(points={{-80.0,-50.0},{-52.0,-50.0}}, color={0,0,0}),Line(points={{-80.0,32.0},{-80.0,-50.0}}, color={0,0,0}),Line(points={{80.0,32.0},{80.0,-50.0}}, color={0,0,0}),Line(points={{-90.0,0.0},{-80.0,0.0}}, color={0,0,0}),Line(points={{90.0,0.0},{80.0,0.0}}, color={0,0,0})}));

      equation 
        v_rel=der(s_rel);
        f=c*(s_rel - s_rel0) + d*v_rel;
      end SpringDamper;
      model ElastoGap "1D translational spring damper combination with gap"
              extends Interfaces.Compliant;
        parameter SI.Position s_rel0=0 "unstretched spring length";
        parameter Real c(final unit="N/m",final min=0)=1 "spring constant";
        parameter Real d(final unit="N/ (m/s)",final min=0)=1 "damping constant";
        SI.Velocity v_rel "relative velocity between flange_a and flange_b";
        Boolean Contact "false, if s_rel > l ";
        annotation(Documentation(info="<html>
 <p>
 A <i>linear translational spring damper combination that can lift off</i>.
 The component can be connected
 between
 a sliding mass and the housing (model Fixed), to describe
 the contact of a sliding mass with the housing.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater</i> </li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{-50.0,0.0}}, color={0,191,0}),Line(points={{-48.0,34.0},{-48.0,-46.0}}, color={0,0,0}, thickness=1.0),Line(points={{8.0,40.0},{8.0,2.0}}, color={0,0,0}),Line(points={{-2.0,0.0},{38.0,0.0},{38.0,44.0},{-2.0,44.0}}, color={0,0,0}),Line(points={{38.0,22.0},{72.0,22.0}}, color={0,0,0}),Line(points={{-12.0,-38.0},{-12.0,20.0}}, color={0,0,0}, thickness=1.0),Line(points={{-12.0,22.0},{8.0,22.0}}, color={0,0,0}),Line(points={{-12.0,-38.0},{-2.0,-38.0}}, color={0,0,0}),Line(points={{72.0,0.0},{90.0,0.0}}, color={0,191,0}),Line(points={{72.0,22.0},{72.0,-42.0}}, color={0,0,0}),Line(points={{-2.0,-38.0},{10.0,-28.0},{22.0,-48.0},{38.0,-28.0},{50.0,-48.0},{64.0,-28.0},{72.0,-40.0}}, color={0,0,0}),Rectangle(extent={{8.0,44.0},{38.0,0.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-28.0,-80.0},{12.0,-55.0}}, textString="s_rel", fillColor={0,0,255}),Line(points={{-100.0,-29.0},{-100.0,-61.0}}, color={0,0,0}),Line(points={{100.0,-61.0},{100.0,-28.0}}, color={0,0,0}),Line(points={{-98.0,-60.0},{98.0,-60.0}}, color={0,0,0}),Polygon(points={{-101.0,-60.0},{-96.0,-59.0},{-96.0,-61.0},{-101.0,-60.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Polygon(points={{100.0,-60.0},{95.0,-61.0},{95.0,-59.0},{100.0,-60.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-98.0,0.0},{-48.0,0.0}}, color={0,191,0}),Line(points={{-48.0,34.0},{-48.0,-46.0}}, color={0,0,0}, thickness=1.0),Line(points={{8.0,40.0},{8.0,2.0}}, color={0,0,0}),Line(points={{-2.0,0.0},{38.0,0.0},{38.0,44.0},{-2.0,44.0}}, color={0,0,0}),Line(points={{38.0,22.0},{72.0,22.0}}, color={0,0,0}),Line(points={{-12.0,-38.0},{-12.0,20.0}}, color={0,0,0}, thickness=1.0),Line(points={{-12.0,22.0},{8.0,22.0}}, color={0,0,0}),Line(points={{-12.0,-38.0},{-2.0,-38.0}}, color={0,0,0}),Line(points={{72.0,0.0},{98.0,0.0}}, color={0,191,0}),Line(points={{72.0,22.0},{72.0,-42.0}}, color={0,0,0}),Line(points={{-2.0,-38.0},{10.0,-28.0},{22.0,-48.0},{38.0,-28.0},{50.0,-48.0},{64.0,-28.0},{72.0,-40.0}}, color={0,0,0}),Rectangle(extent={{8.0,44.0},{38.0,0.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{0.0,120.0},{0.0,60.0}}, textString="%name", fillColor={0,0,255})}));

      equation 
        v_rel=der(s_rel);
        Contact=s_rel < s_rel0;
        f=if Contact then c*(s_rel - s_rel0) + d*v_rel else 0;
      end ElastoGap;
      model Position "Forced movement of a flange according to a reference position"
              parameter Boolean exact=false "true/false exact treatment/filtering the input signal";
        parameter SI.Frequency f_crit=50 "if exact=false, critical frequency of filter to filter input signal";
        output SI.Position s "absolute position of flange_b";
        output SI.Velocity v "absolute velocity of flange_b";
        output SI.Acceleration a "absolute acceleration of flange_b";
      protected 
        parameter Real w_crit=2*Modelica.Constants.pi*f_crit "critical frequency in [1/s]";
        constant Real af=1.3617 "s coefficient of Bessel filter";
        constant Real bf=0.618 "s*s coefficient of Bessel filter";
      public 
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealInput s_ref(redeclare type SignalType= SI.Position ) "reference position of flange as input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 The input signal <b>s_ref</b> defines the <b>reference
 position</b> in [m]. Flange <b>flange_b</b> is <b>forced</b>
 to move according to this reference motion. According to parameter
 <b>exact</b> (default = <b>false</b>), this is done in the following way:
 <ol>
 <li><b>exact=true</b><br>
     The reference position is treated <b>exactly</b>. This is only possible, if
     the input signal is defined by an analytical function which can be
     differentiated at least twice. If this prerequisite is fulfilled,
     the Modelica translator will differentiate the input signal twice
     in order to compute the reference acceleration of the flange.</li>
 <li><b>exact=false</b><br>
     The reference position is <b>filtered</b> and the second derivative
     of the filtered curve is used to compute the reference acceleration
     of the flange. This second derivative is <b>not</b> computed by
     numerical differentiation but by an appropriate realization of the
     filter. For filtering, a second order Bessel filter is used.
     The critical frequency (also called cut-off frequency) of the
     filter is defined via parameter <b>f_crit</b> in [Hz]. This value
     should be selected in such a way that it is higher as the essential
     low frequencies in the signal.</li>
 </ol>
 <p>
 The input signal can be provided from one of the signal generator
 blocks of the block library Modelica.Blocks.Sources.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 19, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>.<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-40.0,-40.0},{-126.0,-78.0}}, fillColor={0,0,0}, textString="s_ref"),Line(points={{-95.0,0.0},{90.0,0.0}}, color={0,191,0}),Text(extent={{0.0,86.0},{0.0,26.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{46.0,-90.0},{26.0,-85.0},{26.0,-95.0},{46.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-44.0,-90.0},{27.0,-90.0}}, color={128,128,128})}));

      equation 
        s=flange_b.s;
        v=der(s);
        a=der(v);
        if exact then
          s=s_ref;

        else
          a=(((s_ref - s)*w_crit - af*v)*w_crit)/bf;

        end if;

      initial equation 
if not exact then
                  s=s_ref;
        end if;
      end Position;
      model Accelerate "Forced movement of a flange according to an acceleration signal"
              parameter SI.Position s_start=0 "Start position";
        parameter SI.Velocity v_start=0 "Start velocity";
        SI.Velocity v(final start=v_start,final fixed=true) "absolute velocity of flange_b";
        SI.Position s(final start=s_start,final fixed=true) "absolute position of flange_b";
        Modelica.Blocks.Interfaces.RealInput a(redeclare type SignalType= SI.Acceleration ) "absolute acceleration of flange as input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>
 The input signal <b>a</b> in [m/s2] moves the 1D translational flange
 connector flange_b with a predefined <i>acceleration</i>, i.e., the flange
 is <i>forced</i> to move with this acceleration. The velocity and the
 position of the flange are also predefined and are determined by
 integration of the acceleration.
 </p>
 <p>
 The acceleration \"a(t)\" can be provided from one of the signal generator
 blocks of the block library Modelica.Blocks.Source.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.AccMotion)</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-95.0,0.0},{90.0,0.0}}, color={0,191,0}),Text(extent={{-75.0,-18.0},{-124.0,-58.0}}, textString="a", fillColor={0,0,0}),Text(extent={{0.0,80.0},{0.0,20.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0})}));

      equation 
        s=flange_b.s;
        v=der(s);
        a=der(v);
      end Accelerate;
      model Move "Forced movement of a flange according to a position, velocity and acceleration signal"
              SI.Position s "absolute position of flange_b";
        SI.Velocity v "absolute velocity of flange_b";
        SI.Acceleration a "absolute acceleration of flange_b";
      protected 
        Real constraintResidue;
        Real constraintResidue_d;
        Real constraintResidue_dd;
      public 
        Modelica.Blocks.Interfaces.RealInput u[3] "position, velocity and acceleration of flange as input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>
 Flange <b>flange_b</b> is <b>forced</b> to move with a predefined motion
 according to the input signals:
 </p>
 <pre>
     u[1]: position of flange
     u[2]: velocity of flange
     u[3]: acceleration of flange
 </pre>
 <p>
 The user has to guarantee that the input signals are consistent to each other,
 i.e., that u[2] is the derivative of u[1] and that
 u[3] is the derivative of u. There are, however,
 also applications where by purpose these conditions do not hold. For example,
 if only the position dependent terms of a mechanical system shall be
 calculated, one may provide position = position(t) and set the velocity
 and the acceleration to zero.
 </p>
 <p>
 The input signals can be provided from one of the signal generator
 blocks of the block library Modelica.Blocks.Sources.
 </p>
 <p>
 Note, this model utilizes the non-standard function <b>constrain(..)</b>
 and assumes that this function is supported by the Modelica translator:
 </p>
 <pre>
    Real r[:], rd[:], rdd[:];
       ...
    r   = ..
    rd  = ...
    rdd = ...
    constrain(r,rd,rdd);
 </pre>
 <p>
 where r, rd and rdd are variables which need to be computed
 somewhere else. A simple implementation of constrain() is:
 </p>
 <pre>
    r = 0;
 </pre>
 <p>
 However, this implementation requires that r(t) is given as analytical,
 smooth function in order that it can be differentiated and it does
 not allow applications such as the one sketched above.
 Function constrain()
 is used to explicitly inform the Modelica translator that
 rd is the derivative of r and rdd is the derivative of rd
 and that all derivatives need to be identical to zero.
 The Modelica translator can utilize this information to use
 rd and rdd whenever the Pantelides algorithm requires to compute
 the derivatives of r (and takes rd and rdd instead of actually
 differentiating r).
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 25, 2001</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        realized.</li>
 </ul>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,-90.0},{-20.0,-85.0},{-20.0,-95.0},{0.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-90.0},{-19.0,-90.0}}, color={128,128,128})}),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-140.0,-62.0},{20.0,-100.0}}, textString="phi,w,a", fillColor={0,0,0}),Line(points={{-95.0,0.0},{90.0,0.0}}, color={0,191,0}),Text(extent={{0.0,80.0},{0.0,20.0}}, textString="%name", fillColor={0,0,255})}));

      equation 
        s=flange_b.s;
        v=der(s);
        a=der(v);
        constraintResidue=u[1] - s;
        constraintResidue_d=u[2] - v;
        constraintResidue_dd=u[3] - a;
constrain(constraintResidue, constraintResidue_d, constraintResidue_dd);
      end Move;
      model Fixed "Fixed flange"
              parameter SI.Position s0=0 "fixed offset position of housing";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-40.0},{80.0,-40.0}}, color={0,0,0}),Line(points={{80.0,-40.0},{40.0,-80.0}}, color={0,0,0}),Line(points={{40.0,-40.0},{0.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{-40.0,-80.0}}, color={0,0,0}),Line(points={{-40.0,-40.0},{-80.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{0.0,-10.0}}, color={0,0,0}),Text(extent={{0.0,-90.0},{0.0,-150.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-40.0},{80.0,-40.0}}, color={0,0,0}),Line(points={{80.0,-40.0},{40.0,-80.0}}, color={0,0,0}),Line(points={{40.0,-40.0},{0.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{-40.0,-80.0}}, color={0,0,0}),Line(points={{-40.0,-40.0},{-80.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-40.0},{0.0,-4.0}}, color={0,0,0}),Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0})}),Documentation(info="<html>
 <p>
 The <i>flange</i> of a 1D translational mechanical system <i>fixed</i>
 at an position s0 in the <i>housing</i>. May be used:
 </p>
 <ul>
 <li> to connect a compliant element, such as a spring or a damper,
      between a sliding mass and the housing.
 <li> to fix a rigid element, such as a sliding mass, at a specific
      position.
 </ul>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.LockedR)</i> </li>
 </ul>
 </HTML>
 "));
        Interfaces.Flange_b flange_b annotation(Placement(transformation(x=0.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=180,flipVertical=true),iconTransformation(x=0.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=180,flipVertical=true)));

      equation 
        flange_b.s=s0;
      end Fixed;
      model Force "External force acting on a drive train element as input signal"
              Interfaces.Flange_b flange_b annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealInput f(redeclare type SignalType= SI.Force ) "driving force as input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>
 The input signal \"s\" in [N] characterizes an <i>external
 force</i> which acts (with positive sign) at a flange,
 i.e., the component connected to the flange is driven by force f.
 </p>
 <p>
 Input signal s can be provided from one of the signal generator
 blocks of Modelica.Blocks.Source.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>First Version from August 26, 1999 by P. Beater (based on Rotational.Torque1D)</i> </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,10.0},{20.0,10.0},{20.0,41.0},{90.0,0.0},{20.0,-41.0},{20.0,-10.0},{-100.0,-10.0},{-100.0,10.0}}, lineColor={0,191,0}, fillColor={0,191,0}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,-40.0},{-47.0,-88.0}}, textString="f", fillColor={0,0,0}),Text(extent={{0.0,109.0},{0.0,49.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{50.0,-90.0},{20.0,-80.0},{20.0,-100.0},{50.0,-90.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Line(points={{-60.0,-90.0},{20.0,-90.0}}, color={0,0,0}),Polygon(points={{-100.0,10.0},{20.0,10.0},{20.0,41.0},{90.0,0.0},{20.0,-41.0},{20.0,-10.0},{-100.0,-10.0},{-100.0,10.0}}, lineColor={0,191,0}, fillColor={0,191,0}, fillPattern=FillPattern.Solid)}));

      equation 
        flange_b.f=-f;
      end Force;
      model RelativeStates "Definition of relative state variables"
              extends Interfaces.TwoFlanges;
        SI.Position s_rel(stateSelect=StateSelect.prefer) "relative position used as state variable";
        SI.Velocity v_rel(stateSelect=StateSelect.prefer) "relative velocity used as state variable";
        SI.Acceleration a_rel "relative angular acceleration";
        annotation(Documentation(info="<html>
 <p>
 Usually, the absolute position and the absolute velocity of
 Modelica.Mechanics.Translational.Inertia models are used as state variables.
 In some circumstances, relative quantities are better suited, e.g.,
 because it may be easier to supply initial values.
 In such cases, model <b>RelativeStates</b> allows the definition of state variables
 in the following way:
 </p>
 <ul>
 <li> Connect an instance of this model between two flange connectors.</li>
 <li> The <b>relative position</b> and the <b>relative velocity</b>
      between the two connectors are used as <b>state variables</b>.
 </ul>
 <p>
 An example is given in the next figure
 </p>
 <IMG SRC=\"../Images/relativeStates2.png\" ALT=\"relativeStates2\">
 <p>
 Here, the relative position and the relative velocity between
 the two masses are used as state variables. Additionally, the
 simulator selects either the absolute position and absolute
 velocity of model mass1 or of model mass2 as state variables.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 19, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-40.0,40.0},{40.0,-40.0}}, lineColor={0,255,255}, fillColor={0,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,40.0},{40.0,-40.0}}, textString="S", fillColor={0,0,255}),Line(points={{-92.0,0.0},{-42.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dot),Line(points={{40.0,0.0},{90.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dot),Text(extent={{0.0,110.0},{0.0,50.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-40.0,40.0},{40.0,-40.0}}, lineColor={0,255,255}, fillColor={0,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,40.0},{40.0,-40.0}}, textString="S", fillColor={0,0,255}),Line(points={{40.0,0.0},{90.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dash),Line(points={{-100.0,-10.0},{-100.0,-80.0}}, color={160,160,160}),Line(points={{100.0,-10.0},{100.0,-80.0}}, color={160,160,160}),Polygon(points={{80.0,-65.0},{80.0,-55.0},{100.0,-60.0},{80.0,-65.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Line(points={{-100.0,-60.0},{80.0,-60.0}}, color={160,160,160}),Text(extent={{-30.0,-70.0},{30.0,-90.0}}, textString="w_rel", fillColor={0,0,255}),Line(points={{-76.0,80.0},{-5.0,80.0}}, color={128,128,128}),Polygon(points={{14.0,80.0},{-6.0,85.0},{-6.0,75.0},{14.0,80.0}}, lineColor={128,128,128}, fillColor={128,128,128}, fillPattern=FillPattern.Solid),Text(extent={{18.0,87.0},{86.0,74.0}}, textString="rotation axis", fillColor={128,128,128}),Line(points={{-90.0,0.0},{-40.0,0.0}}, color={0,0,0}, pattern=LinePattern.Dash)}));

      equation 
        s_rel=flange_b.s - flange_a.s;
        v_rel=der(s_rel);
        a_rel=der(v_rel);
        flange_a.f=0;
        flange_b.f=0;
      end RelativeStates;
    end Translational;
  end Mechanics;
  package Blocks "Library for basic input/output control blocks"
      import SI = Modelica.SIunits;
    extends Modelica.Icons.Library2;
    annotation(preferedView="info",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-32.0,-6.0},{16.0,-35.0}}, lineColor={0,0,0}),Rectangle(extent={{-32.0,-56.0},{16.0,-85.0}}, lineColor={0,0,0}),Line(points={{16.0,-20.0},{49.0,-20.0},{49.0,-71.0},{16.0,-71.0}}, color={0,0,0}),Line(points={{-32.0,-72.0},{-64.0,-72.0},{-64.0,-21.0},{-32.0,-21.0}}, color={0,0,0}),Polygon(points={{16.0,-71.0},{29.0,-67.0},{29.0,-74.0},{16.0,-71.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Polygon(points={{-32.0,-21.0},{-46.0,-17.0},{-46.0,-25.0},{-32.0,-21.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}),Documentation(info="<html>
 <p>
 This library contains input/output blocks to build up block diagrams.
 The library is structured in the following sublibraries:
 </p>
 <pre>
   Interfaces    Connectors and partial models for block diagram components
   Examples      Demonstration examples
   Continuous    Basic continuous input/output blocks
   Discrete      Discrete control blocks
   Logical       Logical and relational operations on Boolean signals
   Nonlinear     Discontinuous or non-differentiable algebraic
                 control blocks
   Math          Mathematical functions as input/output blocks
   Sources       Sources such as signal generators
   Routing       Combine and extract signals
   Tables        One and two-dimensional interpolation in tables
   Types         Constants and types with choices, especially to build menus
 </pre>
 <dl>
 <dt><b>Main Author:</b>
 <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
     Deutsches Zentrum f&uuml;r Luft und Raumfahrt e. V. (DLR)<br>
     Oberpfaffenhofen<br>
     Postfach 1116<br>
     D-82230 Wessling<br>
     email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br>
 </dl>
 <br>
 <br>
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association and DLR.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>June 23, 2004</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Introduced new block connectors and adapated all blocks to the new connectors.
        Included subpackages Continuous, Discrete, Logical, Nonlinear from
        package ModelicaAdditions.Blocks.
        Included subpackage ModelicaAdditions.Table in Modelica.Blocks.Sources
        and in the new package Modelica.Blocks.Tables.
        Added new blocks to Blocks.Sources and Blocks.Logical.
        </li>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New subpackage Examples, additional components.
        </li>
 <li><i>June 20, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a> and
        Michael Tiller:<br>
        Introduced a replaceable signal type into
        Blocks.Interfaces.RealInput/RealOutput:
 <pre>
    replaceable type SignalType = Real
 </pre>
        in order that the type of the signal of an input/output block
        can be changed to a physical type, for example:
 <pre>
    Sine sin1(outPort(redeclare type SignalType=Modelica.SIunits.Torque))
 </pre>
       </li>
 <li><i>Sept. 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Renamed to Blocks. New subpackages Math, Nonlinear.
        Additional components in subpackages Interfaces, Continuous
        and Sources. </li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized a first version, based on an existing Dymola library
        of Dieter Moormann and Hilding Elmqvist.</li>
 </ul>
 </html>"));
    package Nonlinear "Discontinuous or non-differentiable algebraic control blocks"
          import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="
 <HTML>
 <p>
 This package contains <b>discontinuous</b> and
 <b>non-differentiable, algebraic</b> input/output blocks.
 In particular the following blocks are provided:
 </p>
 <pre>
    <b>Limiter</b>         Limit the range of a signal to fixed limits.
    <b>VariableLimiter</b> Limit the range of a signal to variable limits.
    <b>DeadZone</b>        Provide a region of zero output.
    <b>FixedDelay</b>      Delay block with fixed DelayTime
    <b>PadeDelay</b>       Pade approximation of delay block with fixed DelayTime 
    <b>VariableDelay</b>        Delay block with variable DelayTime 
 </pre>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New block VariableLimiter added.
 <li><i>August 22, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized, based on an existing Dymola library
        of Dieter Moormann and Hilding Elmqvist.
 </li>
 </ul>
 </html>
 "));
      block Limiter "Limit the range of a signal"
              parameter Real uMax=1 "Upper limits of input signals";
        parameter Real uMin(max=uMax)=-uMax "Lower limits of input signals";
        extends Interfaces.SISO;
        annotation(Documentation(info="
 <HTML>
 <p>
 The Limiter block passes its input signal as output signal
 as long as the input is within the specified upper and lower
 limits. If this is not the case, the corresponding limits are passed
 as output.
 </p>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,-90.0},{0.0,68.0}}, color={192,192,192}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,-8.0},{68.0,8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-70.0},{-50.0,-70.0},{50.0,70.0},{80.0,70.0}}, color={0,0,0}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="uMax=%uMax", fillColor={0,0,0}),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,-60.0},{0.0,50.0}}, color={192,192,192}),Polygon(points={{0.0,60.0},{-5.0,50.0},{5.0,50.0},{0.0,60.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-60.0,0.0},{50.0,0.0}}, color={192,192,192}),Polygon(points={{60.0,0.0},{50.0,-5.0},{50.0,5.0},{60.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-50.0,-40.0},{-30.0,-40.0},{30.0,40.0},{50.0,40.0}}, color={0,0,0}),Text(extent={{46.0,-6.0},{68.0,-18.0}}, textString="u", fillColor={128,128,128}),Text(extent={{-30.0,70.0},{-5.0,50.0}}, textString="y", fillColor={128,128,128}),Text(extent={{-58.0,-54.0},{-28.0,-42.0}}, textString="uMin", fillColor={128,128,128}),Text(extent={{26.0,40.0},{66.0,56.0}}, textString="uMax", fillColor={128,128,128})}));

      equation 
        y=if u > uMax then uMax else if u < uMin then uMin else u;
      end Limiter;
      block DeadZone "Provide a region of zero output"
              parameter Real uMax=1 "Upper limits of dead zones";
        parameter Real uMin(max=uMax)=-uMax "Lower limits of dead zones";
        extends Interfaces.SISO;
        annotation(Documentation(info=" 
 <HTML>
 <p>  
 The DeadZone block defines a region of zero output.
 </p>
 <p>
 If the input is within uMin ... uMax, the output
 is zero. Outside of this zone, the output is a linear
 function of the input with a slope of 1.
 </p>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,-90.0},{0.0,68.0}}, color={192,192,192}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,-8.0},{68.0,8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-60.0},{-20.0,0.0},{20.0,0.0},{80.0,60.0}}, color={0,0,0}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="uMax=%uMax", fillColor={160,160,160}),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,-60.0},{0.0,50.0}}, color={192,192,192}),Polygon(points={{0.0,60.0},{-5.0,50.0},{5.0,50.0},{0.0,60.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-76.0,0.0},{74.0,0.0}}, color={192,192,192}),Polygon(points={{84.0,0.0},{74.0,-5.0},{74.0,5.0},{84.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-81.0,-40.0},{-38.0,0.0},{40.0,0.0},{80.0,40.0}}, color={0,0,0}),Text(extent={{62.0,-7.0},{88.0,-25.0}}, textString="u", fillColor={128,128,128}),Text(extent={{-36.0,72.0},{-5.0,50.0}}, textString="y", fillColor={128,128,128}),Text(extent={{-51.0,1.0},{-28.0,19.0}}, textString="uMin", fillColor={128,128,128}),Text(extent={{27.0,21.0},{52.0,5.0}}, textString="uMax", fillColor={128,128,128})}));

      equation 
        y=if u > uMax then u - uMax else if u < uMin then u - uMin else 0;
      end DeadZone;
      block PadeDelay "Pade approximation of delay block with fixed DelayTime "
              extends Modelica.Blocks.Interfaces.SISO;
        parameter SI.Time delayTime=1 "Delay time of output with respect to input signal";
        parameter Integer n(min=1)=1 "Order of pade approximation";
        parameter Integer m(min=1,max=n)=n "Order of numerator";
      protected 
        Real x1dot "Derivative of first state of TransferFcn";
        Real xn "Highest order state of TransferFcn";
        Real a[n + 1];
        Real b[m + 1];
      public 
        final output Real x[n] "State of transfer function from controller canonical form";
        annotation(Documentation(info="<html>
 <p>
 The Input signal is delayed by a given time instant, or more precisely:
 </p>
 <pre>
    y = u(time - delayTime) for time &gt; time.start + delayTime
      = u(time.start)       for time &le; time.start + delayTime
 </pre>
 <p>
 The delay is approximated by a Pade approximation, i.e., by
 a transfer function
 </p>
 <pre>
            b[1]*s^m + b[2]*s^[m-1] + ... + b[m+1]
    y(s) = --------------------------------------------- * u(s)
            a[1]*s^n + a[2]*s^[n-1] + ... + a[n+1]
 </pre>
 <p>
 where the coefficients b[:] and a[:] are calculated such that the
 coefficients of the Taylor expansion of the delay exp(-T*s) around s=0
 are identical upto order n+m.
 </p>
 <p>
 The main advantage of this approach is that the delay is
 approximated by a linear differential equation system, which
 is continuous and continuously differentiable. For example, it
 is uncritical to linearize a system containing a Pade-approximated
 delay.
 </p>
 <p>
 The standard text book version uses order \"m=n\", which is
 also the default setting of this block. The setting
 \"m=n-1\" may yield a better approximation in certain cases.
 <p>
 <p>
 Literature:<br>
 Otto Foellinger: Regelungstechnik, 8. Auflage,
 chapter 11.9, page 412-414, Huethig Verlag Heidelberg, 1994
 </p>
 </html>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{8.0,-102.0},{8.0,-142.0}}, textString="delayTime=%delayTime", fillColor={0,0,0}),Line(points={{-94.0,0.0},{-82.7,34.2},{-75.5,53.1},{-69.1,66.4},{-63.4,74.6},{-57.8,79.1},{-52.2,79.8},{-46.6,76.6},{-40.9,69.7},{-35.3,59.4},{-28.9,44.1},{-20.83,21.2},{-3.9,-30.8},{3.3,-50.2},{9.7,-64.2},{15.3,-73.1},{21.0,-78.4},{26.6,-80.0},{32.2,-77.6},{37.9,-71.5},{43.5,-61.9},{49.9,-47.2},{58.0,-24.8},{66.0,0.0}}, color={0,0,255}),Line(points={{-72.0,0.0},{-60.7,34.2},{-53.5,53.1},{-47.1,66.4},{-41.4,74.6},{-35.8,79.1},{-30.2,79.8},{-24.6,76.6},{-18.9,69.7},{-13.3,59.4},{-6.9,44.1},{1.17,21.2},{18.1,-30.8},{25.3,-50.2},{31.7,-64.2},{37.3,-73.1},{43.0,-78.4},{48.6,-80.0},{54.2,-77.6},{59.9,-71.5},{65.5,-61.9},{71.9,-47.2},{80.0,-24.8},{88.0,0.0}}, color={160,160,160}),Text(extent={{-10.0,100.0},{100.0,38.0}}, textString="m=%m", fillColor={160,160,160}),Text(extent={{-98.0,-34.0},{6.0,-96.0}}, textString="n=%n", fillColor={160,160,160})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,80.0},{-88.0,80.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-88.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-88.0},{-80.0,86.0}}, color={192,192,192}),Text(extent={{-75.0,98.0},{-46.0,78.0}}, textString="outPort", fillColor={0,0,255}),Polygon(points={{-80.0,96.0},{-86.0,80.0},{-74.0,80.0},{-80.0,96.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,0.0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,-64.2},{29.3,-73.1},{35.0,-78.4},{40.6,-80.0},{46.2,-77.6},{51.9,-71.5},{57.5,-61.9},{63.9,-47.2},{72.0,-24.8},{80.0,0.0}}, color={0,0,255}),Text(extent={{-24.0,98.0},{-2.0,78.0}}, textString="inPort", fillColor={0,0,0}),Line(points={{-64.0,0.0},{-52.7,34.2},{-45.5,53.1},{-39.1,66.4},{-33.4,74.6},{-27.8,79.1},{-22.2,79.8},{-16.6,76.6},{-10.9,69.7},{-5.3,59.4},{1.1,44.1},{9.17,21.2},{26.1,-30.8},{33.3,-50.2},{39.7,-64.2},{45.3,-73.1},{51.0,-78.4},{56.6,-80.0},{62.2,-77.6},{67.9,-71.5},{73.5,-61.9},{79.9,-47.2},{88.0,-24.8},{96.0,0.0}}, color={0,0,0}),Text(extent={{67.0,22.0},{96.0,6.0}}, textString="time", fillColor={160,160,160}),Line(points={{-64.0,-30.0},{-64.0,0.0}}, color={192,192,192}),Text(extent={{-58.0,-42.0},{-58.0,-32.0}}, textString="delayTime", fillColor={0,0,255}),Line(points={{-94.0,-26.0},{-80.0,-26.0}}, color={192,192,192}),Line(points={{-64.0,-26.0},{-50.0,-26.0}}, color={192,192,192}),Polygon(points={{-80.0,-26.0},{-88.0,-24.0},{-88.0,-28.0},{-80.0,-26.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-56.0,-24.0},{-64.0,-26.0},{-56.0,-28.0},{-56.0,-24.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}));
      protected 
        function padeCoefficients
                  input Real T "delay time";
          input Integer n "order of denominator";
          input Integer m "order of numerator";
          output Real b[m + 1] "numerator coefficients of transfer function";
          output Real a[n + 1] "denominator coefficients of transfer function";
        protected 
          Real nm;
        algorithm 
          a[1]:=1;
          b[1]:=1;
          nm:=n + m;
          for i in 1:n loop
                      a[i + 1]:=(a[i]*(T*(n - i + 1))/(nm - i + 1))/i;
            if i <= m then 
                        b[i + 1]:=-(b[i]*(T*(m - i + 1))/(nm - i + 1))/i;

            else 
            end if;
          end for;
          b:=b[m + 1:-1:1];
          a:=a[n + 1:-1:1];        end padeCoefficients;

      equation 
        (b,a)=padeCoefficients(delayTime, n, m);
        [der(x);xn]=[x1dot;x];
        [u]=transpose([a])*[x1dot;x];
        [y]=transpose([zeros(n - m, 1);b])*[x1dot;x];

      initial equation 
        x[n]=u;
      end PadeDelay;
    end Nonlinear;
    package Interfaces "Connectors and partial models for input/output blocks"
          import Modelica.SIunits;
      extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="
 <HTML>
 <p>
 This package contains interface definitions for
 <b>continuous</b> input/output blocks. In particular it
 contains the following <b>connector</b> classes:
 </p>
 <pre>
   <b>RealInput</b>       Connector with input  signals of type Real.
   <b>RealOutput</b>      Connector with output signals of type Real.
   <b>BooleanInput</b>    Connector with input  signals of type Boolean.
   <b>BooleanOutput</b>   Connector with output signals of type Boolean.
   <b>IntegerInput</b>    Connector with input  signals of type Integer.
   <b>IntegerOutput</b>   Connector with output signals of type Integer.
   <b>RealSignal</b>      Connector with input/output signals of type Real.
   <b>BooleanSignal</b>   Connector with input/output signals of type Boolean.
   <b>IntegerSignal</b>   Connector with input/output signals of type Integer.
 </pre>
 <p>
 The following <b>partial</b> block classes are provided
 to model <b>continuous</b> control blocks:
 </p>
 <pre>
   <b>BlockIcon</b>     Basic graphical layout of continuous block
   <b>SO</b>            Single Output continuous control block
   <b>MO</b>            Multiple Output continuous control block
   <b>SISO</b>          Single Input Single Output continuous control block
   <b>SI2SO</b>         2 Single Input / 1 Single Output continuous control block
   <b>SIMO</b>          Single Input Multiple Output continuous control block
   <b>MISO</b>          Multiple Input Single Output continuous control block
   <b>MIMO</b>          Multiple Input Multiple Output continuous control block
   <b>MIMOs</b>         Multiple Input Multiple Output continuous control block
                 with same number of inputs and outputs
   <b>MI2MO</b>         2 Multiple Input / Multiple Output continuous
                 control block
   <b>SignalSource</b>  Base class for continuous signal sources
   <b>SVcontrol</b>     Single-Variable continuous controller
   <b>MVcontrol</b>     Multi-Variable continuous controller
 </pre>
 <p>
 The following <b>partial</b> block classes are provided
 to model <b>discrete</b> control blocks:
 </p>
 <pre>
   <b>DiscreteBlockIcon</b> Basic graphical layout of discrete block
   <b>DiscreteBlock</b>     Base class of discrete control blocks
   <b>DiscreteSISO</b>      Single Input Single Output discrete control block
   <b>DiscreteMIMO</b>      Multiple Input Multiple Output discrete control block
   <b>DiscreteMIMOs</b>     Multiple Input Multiple Output discrete control block
   <b>SVdiscrete</b>        Discrete Single-Variable controller
   <b>MVdiscrete</b>        Discrete Multi-Variable controllerk
 </pre>
 <p>
 The following <b>partial</b> block classes are provided
 to model <b>Boolean</b> control blocks:
 </p>
 <pre>
   <b>BooleanBlockIcon</b>     Basic graphical layout of Boolean block
   <b>BooleanSISO</b>          Single Input Single Output control block
                        with signals of type Boolean
   <b>BooleanMIMOs</b>         Multiple Input Multiple Output control block
                        with same number of inputs and outputs
   <b>MI2BooleanMOs</b>        2 Multiple Input / Boolean Multiple Output
                        block with same signal lengths
   <b>BooleanSignalSource</b>  Base class for Boolean signal sources
   <b>IntegerMIBooleanMOs</b>  Multiple Integer Input Multiple Boolean Output control block
                        with same number of inputs and outputs
 </pre>
 <p>
 The following <b>partial</b> block classes are provided
 to model <b>Integer</b> control blocks:
 </p>
 <pre>
   <b>IntegerBlockIcon</b>     Basic graphical layout of Integer block
   <b>IntegerMO</b>            Multiple Output control block
   <b>IntegerSignalSource</b>  Base class for Integer signal sources
 </pre>
 <p>In addition, a subpackage <b>BusAdaptors</b> is temporarily provided
 in order to make a signal bus concept available. It will be removed,
 when the package Block is revised exploiting new Modelica features.</p>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>Oct. 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Added several new interfaces. <a href=\"../Documentation/ChangeNotes1.5.html\">Detailed description</a> available.
 <li><i>Oct. 24, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        RealInputSignal renamed to RealInput. RealOutputSignal renamed to
        output RealOutput. GraphBlock renamed to BlockIcon. SISOreal renamed to
        SISO. SOreal renamed to SO. I2SOreal renamed to M2SO.
        SignalGenerator renamed to SignalSource. Introduced the following
        new models: MIMO, MIMOs, SVcontrol, MVcontrol, DiscreteBlockIcon,
        DiscreteBlock, DiscreteSISO, DiscreteMIMO, DiscreteMIMOs,
        BooleanBlockIcon, BooleanSISO, BooleanSignalSource, MI2BooleanMOs.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized a first version, based on an existing Dymola library
        of Dieter Moormann and Hilding Elmqvist.</li>
 </ul>
 </html>
 "));
      connector RealSignal "Real port (both input/output possible)"
              replaceable type SignalType= Real;
        extends SignalType;
      end RealSignal;
      connector BooleanSignal= Boolean "Boolean port (both input/output possible)";
      connector IntegerSignal= Integer "Integer port (both input/output possible)";
      connector RealInput= input RealSignal "'input Real' as connector" annotation(defaultComponentName="u",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0},{-100.0,100.0}}, lineColor={0,0,191}, fillColor={0,0,191}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,50.0},{100.0,0.0},{0.0,-50.0},{0.0,50.0}}, lineColor={0,0,191}, fillColor={0,0,191}, fillPattern=FillPattern.Solid),Text(extent={{-140.0,120.0},{100.0,60.0}}, textString="%name", fillColor={0,0,191})}));
      connector RealOutput= output RealSignal "'output Real' as connector" annotation(defaultComponentName="y",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0},{-100.0,100.0}}, lineColor={0,0,191}, fillColor={255,255,255}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,50.0},{0.0,0.0},{-100.0,-50.0},{-100.0,50.0}}, lineColor={0,0,191}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,120.0},{140.0,60.0}}, textString="%name", fillColor={0,0,191})}));
      connector BooleanInput= input BooleanSignal "'input Boolean' as connector" annotation(defaultComponentName="u",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0},{-100.0,100.0}}, lineColor={255,0,255}, fillColor={255,0,255}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,50.0},{100.0,0.0},{0.0,-50.0},{0.0,50.0}}, lineColor={255,0,255}, fillColor={255,0,255}, fillPattern=FillPattern.Solid),Text(extent={{-140.0,120.0},{100.0,60.0}}, textString="%name", fillColor={255,0,255})}));
      connector BooleanOutput= output BooleanSignal "'output Boolean' as connector" annotation(defaultComponentName="y",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0},{-100.0,100.0}}, lineColor={255,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,50.0},{0.0,0.0},{-100.0,-50.0},{-100.0,50.0}}, lineColor={255,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,120.0},{140.0,60.0}}, textString="%name", fillColor={255,0,255})}));
      connector IntegerInput= input IntegerSignal "'input Integer' as connector" annotation(defaultComponentName="u",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0},{-100.0,100.0}}, lineColor={255,127,0}, fillColor={255,127,0}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,50.0},{100.0,0.0},{0.0,-50.0},{0.0,50.0}}, lineColor={255,127,0}, fillColor={255,127,0}, fillPattern=FillPattern.Solid),Text(extent={{-140.0,120.0},{100.0,60.0}}, fillColor={255,127,0}, textString="%name")}));
      connector IntegerOutput= output IntegerSignal "'output Integer' as connector" annotation(defaultComponentName="y",Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,100.0},{100.0,0.0},{-100.0,-100.0},{-100.0,100.0}}, lineColor={255,127,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,50.0},{0.0,0.0},{-100.0,-50.0},{-100.0,50.0}}, lineColor={255,127,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,120.0},{140.0,60.0}}, fillColor={255,127,0}, textString="%name")}));
      partial block BlockIcon "Basic graphical layout of continuous block"
              annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,191}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}));
      end BlockIcon;
      partial block SO "Single Output continuous control block"
              extends BlockIcon;
        RealOutput y "Connector of Real output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end SO;
      partial block MO "Multiple Output continuous control block"
              extends BlockIcon;
        parameter Integer nout(min=1)=1 "Number of outputs";
        RealOutput y[nout] "Connector of Real output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 "));
      end MO;
      partial block SISO "Single Input Single Output continuous control block"
              extends BlockIcon;
        RealInput u "Connector of Real input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        RealOutput y "Connector of Real output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end SISO;
      partial block SI2SO "2 Single Input / 1 Single Output continuous control block"
              extends BlockIcon;
        RealInput u1 "Connector of Real input signal 1" annotation(Placement(transformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0)));
        RealInput u2 "Connector of Real input signal 2" annotation(Placement(transformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0)));
        RealOutput y "Connector of Real output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 Block has two input vectors u1 and u2 and one
 output vector y. All signals are scalar.
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end SI2SO;
      partial block SIMO "Single Input Multiple Output continuous control block"
              extends BlockIcon;
        parameter Integer nout=1 "Number of outputs";
        RealInput u "Connector of Real input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        RealOutput y[nout] "Connector of Real output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>Block has one continuous input signal and a vector of continuous output
 signals.</p>
 </HTML>
 "));
      end SIMO;
      partial block MISO "Multiple Input Single Output continuous control block"
              extends BlockIcon;
        parameter Integer nin=1 "Number of inputs";
        RealInput u[nin] "Connector of Real input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        RealOutput y "Connector of Real output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="
 <HTML>
 <p>
 Block has a vector of continuous input signals and
 one continuous output signal.
 </p>
 </HTML>
 "));
      end MISO;
      partial block MIMO "Multiple Input Multiple Output continuous control block"
              extends BlockIcon;
        parameter Integer nin=1 "Number of inputs";
        parameter Integer nout=1 "Number of outputs";
        RealInput u[nin] "Connector of Real input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        RealOutput y[nout] "Connector of Real output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="
 <HTML>
 <p>
 Block has a continuous input and a continuous output signal vector.
 The signal sizes of the input and output vector may be different.
 </p>
 </HTML>
 "));
      end MIMO;
      partial block MIMOs "Multiple Input Multiple Output continuous control block with same number of inputs and outputs"
              extends BlockIcon;
        parameter Integer n=1 "Number of inputs (= number of outputs)";
        RealInput u[n] "Connector of Real input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        RealOutput y[n] "Connector of Real output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 <HTML>
 <p>
 Block has a continuous input and a continuous output signal vector
 where the signal sizes of the input and output vector are identical.
 </p>
 </HTML>
 "));
      end MIMOs;
      partial block MI2MO "2 Multiple Input / Multiple Output continuous control block"
              extends BlockIcon;
        parameter Integer n=1 "Dimension of input and output vectors.";
        RealInput u1[n] "Connector 1 of Real input signals" annotation(Placement(transformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0)));
        RealInput u2[n] "Connector 2 of Real input signals" annotation(Placement(transformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0)));
        RealOutput y[n] "Connector of Real output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 Block has two Input vectors u1 and u2 and one
 output vector y. All vectors have the same number of elements.
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end MI2MO;
      partial block SignalSource "Base class for continuous signal source"
              extends SO;
        parameter Real offset=0 "offset of output signal";
        parameter SIunits.Time startTime=0 "output = offset for time < startTime";
      end SignalSource;
      partial block SVcontrol "Single-Variable continuous controller"
              extends BlockIcon;
        RealInput u_s "Connector of setpoint input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        RealInput u_m "Connector of measurement input signal" annotation(Placement(transformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true),iconTransformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true)));
        RealOutput y "Connector of actuator output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-102.0,34.0},{-142.0,24.0}}, textString="(setpoint)", fillColor={0,0,255}),Text(extent={{100.0,24.0},{140.0,14.0}}, textString="(actuator)", fillColor={0,0,255}),Text(extent={{-83.0,-112.0},{-33.0,-102.0}}, textString=" (measurement)", fillColor={0,0,255})}));
      end SVcontrol;
      partial block MVcontrol "Multi-Variable continuous controller"
              extends BlockIcon;
        parameter Integer nu_s=1 "Number of setpoint inputs";
        parameter Integer nu_m=1 "Number of measurement inputs";
        parameter Integer ny=1 "Number of actuator outputs";
        RealInput u_s[nu_s] "Connector of setpoint input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        RealInput u_m[nu_m] "Connector of measurement input signals" annotation(Placement(transformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true),iconTransformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true)));
        RealOutput y[ny] "Connector of actuator output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,36.0},{-140.0,26.0}}, textString="(setpoint)", fillColor={0,0,255}),Text(extent={{102.0,24.0},{142.0,14.0}}, textString="(actuator)", fillColor={0,0,255}),Text(extent={{-75.0,-108.0},{-25.0,-98.0}}, textString=" (measurement)", fillColor={0,0,255})}));
      end MVcontrol;
      partial block DiscreteBlockIcon "Graphical layout of discrete block component icon"
              annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={223,223,159}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}));
      end DiscreteBlockIcon;
      partial block DiscreteBlock "Base class of discrete control blocks"
              extends DiscreteBlockIcon;
        parameter SI.Time samplePeriod(min=100*Modelica.Constants.eps)=0.1 "Sample period of component";
        parameter SI.Time startTime=0 "First sample time instant";
      protected 
        output Boolean sampleTrigger "True, if sample time instant";
        output Boolean firstTrigger "Rising edge signals first sample instant";

      equation 
        sampleTrigger=sample(startTime, samplePeriod);
        when sampleTrigger then
                  firstTrigger=time <= startTime + samplePeriod/2;
        
        end when;
      end DiscreteBlock;
      partial block DiscreteSISO "Single Input Single Output discrete control block"
              extends DiscreteBlock;
        Modelica.Blocks.Interfaces.RealInput u "Continuous input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealOutput y "Continuous output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
      end DiscreteSISO;
      partial block DiscreteMIMO "Multiple Input Multiple Output discrete control block"
              extends DiscreteBlock;
        parameter Integer nin=1 "Number of inputs";
        parameter Integer nout=1 "Number of outputs";
        Modelica.Blocks.Interfaces.RealInput u[nin] "Continuous input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealOutput y[nout] "Continuous output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>
 Block has a continuous input and a continuous output signal vector
 which are sampled due to the defined <b>samplePeriod</b> parameter.
 </p>
 </HTML>
 "));
      end DiscreteMIMO;
      partial block DiscreteMIMOs "Multiple Input Multiple Output discrete control block"
              parameter Integer n=1 "Number of inputs (= number of outputs)";
        extends DiscreteBlock;
        Modelica.Blocks.Interfaces.RealInput u[n] "Continuous input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealOutput y[n] "Continuous output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>
 Block has a continuous input and a continuous output signal vector
 where the signal sizes of the input and output vector are identical.
 These signals are sampled due to the defined <b>samplePeriod</b> parameter.
 </p>
 </HTML>
 "));
      end DiscreteMIMOs;
      partial block SVdiscrete "Discrete Single-Variable controller"
              extends DiscreteBlock;
        Discrete.Sampler sampler_s(final samplePeriod=samplePeriod,final startTime=startTime) annotation(Placement(transformation(x=-90.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Discrete.Sampler sampler_m(final samplePeriod=samplePeriod,final startTime=startTime) annotation(Placement(transformation(x=0.0,y=-90.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=0.0,y=-90.0,scale=0.1,aspectRatio=1.0,rotation=90)));
        Modelica.Blocks.Interfaces.RealInput u_s "Continuous scalar setpoint input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealInput u_m "Continuous scalar measurement input signal" annotation(Placement(transformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true),iconTransformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true)));
        Modelica.Blocks.Interfaces.RealOutput y "Continuous scalar actuator output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,34.0},{-140.0,24.0}}, textString="(setpoint)", fillColor={0,0,0}),Text(extent={{100.0,22.0},{130.0,14.0}}, textString="(actuator)", fillColor={0,0,0}),Text(extent={{-70.0,-112.0},{-20.0,-102.0}}, textString=" (measurement)", fillColor={0,0,0})}));

      equation 
        connect(u_s,sampler_s.u) annotation(Line(points={{-120.0,0.0},{-102.0,0.0}},color={0,0,255}));
        connect(u_m,sampler_m.u) annotation(Line(points={{0.0,-120.0},{0.0,-111.0},{0.0,-102.0},{-7.34764e-016,-102.0}},color={0,0,255}));
      end SVdiscrete;
      partial block MVdiscrete "Discrete Multi-Variable controller"
              extends DiscreteBlock;
        parameter Integer nu_s=1 "Number of setpoint inputs";
        parameter Integer nu_m=1 "Number of measurement inputs";
        parameter Integer ny=1 "Number of actuator outputs";
        Discrete.Sampler sampler_s[nu_s](each final samplePeriod=samplePeriod,each final startTime=startTime) annotation(Placement(transformation(x=-80.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-80.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Discrete.Sampler sampler_m[nu_m](each final samplePeriod=samplePeriod,each final startTime=startTime) annotation(Placement(transformation(x=0.0,y=-80.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=0.0,y=-80.0,scale=0.1,aspectRatio=1.0,rotation=90)));
        Modelica.Blocks.Interfaces.RealInput u_s[nu_s] "Continuous setpoint input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealInput u_m[nu_m] "Continuous measurement input signals" annotation(Placement(transformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true),iconTransformation(x=0.0,y=-120.0,scale=0.2,aspectRatio=1.0,rotation=-90,flipHorizontal=true,flipVertical=true)));
        Modelica.Blocks.Interfaces.RealOutput y[ny] "Continuous actuator output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,-10.0},{-80.0,-30.0}}, textString="u_s", fillColor={0,0,255}),Text(extent={{-98.0,34.0},{-138.0,24.0}}, textString="(setpoint)", fillColor={0,0,0}),Text(extent={{98.0,24.0},{138.0,14.0}}, textString="(actuator)", fillColor={0,0,0}),Text(extent={{-62.0,-110.0},{-12.0,-100.0}}, textString=" (measurement)", fillColor={0,0,0})}));

      equation 
        connect(u_s,sampler_s.u) annotation(Line(points={{-120.0,0.0},{-92.0,0.0}},color={0,0,255}));
        connect(u_m,sampler_m.u) annotation(Line(points={{0.0,-120.0},{0.0,-106.0},{0.0,-92.0},{-7.34764e-016,-92.0}},color={0,0,255}));
      end MVdiscrete;
      partial block BooleanBlockIcon "Basic graphical layout of Boolean block"
              annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={255,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}));
      end BooleanBlockIcon;
      partial block BooleanSISO "Single Input Single Output control block with signals of type Boolean"
              extends BooleanBlockIcon;
      public 
        BooleanInput u "Connector of Boolean input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        BooleanOutput y "Connector of Boolean output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end BooleanSISO;
      partial block BooleanMIMOs "Multiple Input Multiple Output continuous control block with same number of inputs and outputs of boolean type"
              extends BooleanBlockIcon;
        parameter Integer n=1 "Number of inputs (= number of outputs)";
        BooleanInput u[n] "Connector of Boolean input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        BooleanOutput y[n] "Connector of Boolean output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 Block has a continuous input and a continuous output signal vector
 where the signal sizes of the input and output vector are identical
 and of type Boolean.
 </p>
 </HTML>
 "));
      end BooleanMIMOs;
      partial block MI2BooleanMOs "2 Multiple Input / Boolean Multiple Output block with same signal lengths"
              extends BooleanBlockIcon;
        parameter Integer n=1 "Dimension of input and output vectors.";
        RealInput u1[n] "Connector 1 of Boolean input signals" annotation(Placement(transformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0)));
        RealInput u2[n] "Connector 2 of Boolean input signals" annotation(Placement(transformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0)));
        BooleanOutput y[n] "Connector of Boolean output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>Block has two Boolean input vectors u1 and u2 and one Boolean output
 vector y. All vectors have the same number of elements.</p>
 </html>
 "));
      end MI2BooleanMOs;
      partial block SI2BooleanSO "2 Single Input / Boolean Single Output block"
              extends BooleanBlockIcon;
        input RealInput u1 "Connector 1 of Boolean input signals" annotation(Placement(transformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=60.0,scale=0.2,aspectRatio=1.0)));
        input RealInput u2 "Connector 2 of Boolean input signals" annotation(Placement(transformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-60.0,scale=0.2,aspectRatio=1.0)));
        output BooleanOutput y "Connector of Boolean output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="
 Block has two Boolean inputs u1 and u2 and one Boolean output y.
 "));
      end SI2BooleanSO;
      partial block BooleanSignalSource "Base class for Boolean signal sources"
              extends BooleanBlockIcon;
        BooleanOutput y "Connector of Boolean output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{68.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end BooleanSignalSource;
      partial block IntegerBlockIcon "Basic graphical layout of Integer block"
              annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={255,127,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}));
      end IntegerBlockIcon;
      partial block IntegerSO "Single Integer Output continuous control block"
              extends IntegerBlockIcon;
        IntegerOutput y "Connector of Integer output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
      end IntegerSO;
      partial block IntegerMO "Multiple Integer Output continuous control block"
              extends IntegerBlockIcon;
        parameter Integer nout(min=1)=1 "Number of outputs";
        IntegerOutput y[nout] "Connector of Integer output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
      end IntegerMO;
      partial block IntegerSignalSource "Base class for continuous Integer signal source"
              extends IntegerSO;
        parameter Integer offset=0 "offset of output signal";
        parameter SI.Time startTime=0 "y = offset for time < startTime";
      end IntegerSignalSource;
      partial block IntegerSIBooleanSO "Integer Input Boolean Output continuous control block"
              extends BooleanBlockIcon;
        IntegerInput u "Connector of Integer input signal" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        BooleanOutput y "Connector of Boolean output signal" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 Block has a continuous Integer input and a continuous Boolean output signal.
 </p>
 </HTML>
 "));
      end IntegerSIBooleanSO;
      partial block IntegerMIBooleanMOs "Multiple Integer Input Multiple Boolean Output continuous control block with same number of inputs and outputs"
              extends BooleanBlockIcon;
        parameter Integer n=1 "Number of inputs (= number of outputs)";
        IntegerInput u[n] "Connector of Integer input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        BooleanOutput y[n] "Connector of Boolean output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<HTML>
 <p>
 Block has a continuous integer input and a continuous boolean output signal vector
 where the signal sizes of the input and output vector are identical.
 </p>
 </HTML>
 "));
      end IntegerMIBooleanMOs;
      partial block partialBooleanBlockIcon "Basic graphical layout of logical block"
              annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,100.0},{100.0,-100.0}}, lineColor={0,0,0}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}));
      end partialBooleanBlockIcon;
      partial block partialBooleanSISO "partialSingle Input / Single Output Boolean block"
              extends partialBooleanBlockIcon;
        Blocks.Interfaces.BooleanInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-71.0,7.0},{-85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{71.0,7.0},{85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid)}));
      end partialBooleanSISO;
      partial block partialBooleanSI2SO "partial2 Single Input / 1 Single Output Boolean block"
              extends partialBooleanBlockIcon;
        Blocks.Interfaces.BooleanInput u1 annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanInput u2 annotation(Placement(transformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-71.0,7.0},{-85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{-71.0,-74.0},{-85.0,-88.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{71.0,7.0},{85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid)}));
      end partialBooleanSI2SO;
      partial block partialBooleanSI3SO "partial2 Single Input / 1 Single Output Boolean block"
              extends partialBooleanBlockIcon;
        Blocks.Interfaces.BooleanInput u1 annotation(Placement(transformation(x=-120.0,y=80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=80.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanInput u2 annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanInput u3 annotation(Placement(transformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-71.0,74.0},{-85.0,88.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{-71.0,7.0},{-85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{-71.0,-74.0},{-85.0,-88.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{71.0,7.0},{85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid)}));
      end partialBooleanSI3SO;
      partial block partialBooleanSI "partialSingle Input Boolean block"
              extends partialBooleanBlockIcon;
        Blocks.Interfaces.BooleanInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-71.0,7.0},{-85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid)}));
      end partialBooleanSI;
      partial block partialBooleanSO "partialSingle Output Boolean block"
              Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        extends partialBooleanBlockIcon;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{71.0,7.0},{85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid)}));
      end partialBooleanSO;
      partial block partialBooleanSource "partialBoolean source block"
              extends partialBooleanBlockIcon;
        Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,88.0},{-88.0,66.0},{-72.0,66.0},{-80.0,88.0}}, lineColor={255,0,255}, fillColor={255,0,255}, fillPattern=FillPattern.Solid),Line(points={{-80.0,66.0},{-80.0,-82.0}}, color={255,0,255}),Line(points={{-90.0,-70.0},{72.0,-70.0}}, color={255,0,255}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={255,0,255}, fillColor={255,0,255}, fillPattern=FillPattern.Solid),Ellipse(extent={{71.0,7.0},{85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,80.0},{-88.0,58.0},{-72.0,58.0},{-80.0,80.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,58.0},{-80.0,-90.0}}, color={0,0,0}),Line(points={{-90.0,-70.0},{68.0,-70.0}}, color={0,0,0}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{54.0,-84.0},{106.0,-96.0}}, textString="time", fillColor={0,0,0}),Text(extent={{-108.0,80.0},{-92.0,64.0}}, fillColor={0,0,0}, textString="y")}));
      end partialBooleanSource;
      partial block partialBooleanThresholdComparison "partialBoolean block to compare the Real input u with a threshold"
              parameter Real threshold=0 "Comparison with respect to threshold";
        Blocks.Interfaces.RealInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0,Hide=true),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0,Hide=true)));
        Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,100.0},{100.0,-100.0}}, lineColor={0,0,0}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,-140.0},{150.0,-110.0}}, fillColor={0,0,0}, textString="%threshold"),Ellipse(extent={{71.0,7.0},{85.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end partialBooleanThresholdComparison;
      partial block partialBooleanComparison "partialBoolean block to compare two Real inputs u1 and u2"
              Blocks.Interfaces.RealInput u1 annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0,Hide=true),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0,Hide=true)));
        Blocks.Interfaces.RealInput u2 annotation(Placement(transformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0,Hide=true),iconTransformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0,Hide=true)));
        Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true)));
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,100.0},{100.0,-100.0}}, lineColor={0,0,0}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{73.0,7.0},{87.0,-7.0}}, lineColor={235,235,235}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Ellipse(extent={{32.0,10.0},{52.0,-10.0}}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{-100.0,-80.0},{42.0,-80.0},{42.0,0.0}}, color={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
      end partialBooleanComparison;
      package Adaptors "Components to send signals to the bus or receive signals from the bus"
              extends Modelica.Icons.Library;
        block SendReal "Send Real signal to bus"
                  RealOutput toBus annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          RealInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-144.0,96.0},{144.0,46.0}}, textString="%name", fillColor={0,0,0}),Text(extent={{-100.0,30.0},{100.0,-30.0}}, textString="send", fillColor={0,0,255})}),Documentation(info="<HTML>
 </HTML>
 "));

        equation 
          toBus=u;
        end SendReal;
        block SendBoolean "Send Boolean signal to bus"
                  BooleanOutput toBus annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          BooleanInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={255,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-144.0,96.0},{144.0,46.0}}, textString="%name", fillColor={0,0,0}),Text(extent={{-100.0,30.0},{100.0,-30.0}}, textString="send", fillColor={255,0,255})}),Documentation(info="<HTML>
 </HTML>
 "));

        equation 
          toBus=u;
        end SendBoolean;
        block SendInteger "Send Integer signal to bus"
                  IntegerOutput toBus annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          IntegerInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={255,127,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-144.0,96.0},{144.0,46.0}}, textString="%name", fillColor={0,0,0}),Text(extent={{-100.0,30.0},{100.0,-30.0}}, textString="send", fillColor={255,127,0})}),Documentation(info="<HTML>
 </HTML>
 "));

        equation 
          toBus=u;
        end SendInteger;
        block ReceiveReal "Receive Real signal from bus"
                  RealInput fromBus annotation(Placement(transformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          RealOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,30.0},{100.0,-30.0}}, textString="receive", fillColor={0,0,255}),Text(extent={{-144.0,96.0},{144.0,46.0}}, textString="%name", fillColor={0,0,0})}),Documentation(info="<HTML>
 </HTML>
 "));

        equation 
          y=fromBus;
        end ReceiveReal;
        block ReceiveBoolean "Receive Boolean signal from bus"
                  BooleanInput fromBus annotation(Placement(transformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={255,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,30.0},{100.0,-30.0}}, textString="receive", fillColor={255,0,255}),Text(extent={{-144.0,96.0},{144.0,46.0}}, textString="%name", fillColor={0,0,0})}),Documentation(info="<HTML>
 </HTML>
 "));

        equation 
          y=fromBus;
        end ReceiveBoolean;
        block ReceiveInteger "Receive Integer signal from bus"
                  IntegerInput fromBus annotation(Placement(transformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          IntegerOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={255,127,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,30.0},{100.0,-30.0}}, textString="receive", fillColor={255,127,0}),Text(extent={{-144.0,96.0},{144.0,46.0}}, textString="%name", fillColor={0,0,0})}),Documentation(info="<HTML>
 </HTML>
 "));

        equation 
          y=fromBus;
        end ReceiveInteger;
        model AdaptorReal "Adaptor between 'old' and 'new' Real signal connectors"
                  RealSignal newReal annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true)));
          RealPort oldReal(final n=1) annotation(Placement(transformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(structurallyIncomplete(),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-144.0,96.0},{144.0,46.0}}, fillColor={0,0,0}, textString=""),Text(extent={{-88.0,22.0},{88.0,-24.0}}, fillColor={0,0,255}, textString="adaptor"),Text(extent={{-216.0,-58.0},{36.0,-80.0}}, fillColor={0,0,0}, fillPattern=FillPattern.Solid, textString="port.signal")}),Documentation(info=""));
        protected 
          connector RealPort "Connector with signals of type Real"
                      parameter Integer n=1 "Dimension of signal vector" annotation(Hide=true);
            replaceable type SignalType= Real "type of signal";
            SignalType signal[n] "Real signals" annotation(Hide=true);
          end RealPort;

        equation 
          newReal=oldReal.signal[1];
        end AdaptorReal;
        model AdaptorBoolean "Adaptor between 'old' and 'new' Boolean signal connectors"
                  BooleanSignal newBoolean annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true)));
          BooleanPort oldBoolean(final n=1) annotation(Placement(transformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(structurallyIncomplete(),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={255,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-144.0,96.0},{144.0,46.0}}, fillColor={0,0,0}, textString=""),Text(extent={{-88.0,22.0},{88.0,-24.0}}, fillColor={255,0,255}, textString="adaptor"),Text(extent={{-216.0,-58.0},{36.0,-80.0}}, fillColor={0,0,0}, fillPattern=FillPattern.Solid, textString="port.signal")}),Documentation(info=""));
        protected 
          connector BooleanPort "Connector with signals of type Boolean"
                      parameter Integer n=1 "Dimension of signal vector" annotation(Hide=true);
            replaceable type SignalType= Boolean "type of signal";
            SignalType signal[n] "Boolean signals" annotation(Hide=true);
          end BooleanPort;

        equation 
          newBoolean=oldBoolean.signal[1];
        end AdaptorBoolean;
        model AdaptorInteger "Adaptor between 'old' and 'new' Integer signal connectors"
                  IntegerSignal newInteger annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0,Hide=true)));
          IntegerPort oldInteger(final n=1) annotation(Placement(transformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          annotation(structurallyIncomplete(),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,40.0},{100.0,-40.0}}, lineColor={255,127,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-144.0,96.0},{144.0,46.0}}, fillColor={0,0,0}, textString=""),Text(extent={{-88.0,22.0},{88.0,-24.0}}, fillColor={255,127,0}, textString="adaptor"),Text(extent={{-216.0,-58.0},{36.0,-80.0}}, fillColor={0,0,0}, fillPattern=FillPattern.Solid, textString="port.signal")}),Documentation(info="
 "));
        protected 
          connector IntegerPort "Connector with signals of type Integer"
                      parameter Integer n=1 "Dimension of signal vector" annotation(Hide=true);
            replaceable type SignalType= Integer "type of signal";
            SignalType signal[n] "Integer signals" annotation(Hide=true);
          end IntegerPort;

        equation 
          newInteger=oldInteger.signal[1];
        end AdaptorInteger;
      end Adaptors;
    end Interfaces;
    package Types "Constants and types with choices, especially to build menus"
          extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="<HTML>
 <p>
 In this package <b>types</b> and <b>constants</b> are defined that are used
 in library Modelica.Blocks. The types have additional annotation choices
 definitions that define the menus to be built up in the graphical
 user interface when the type is used as parameter in a declaration.
 </p>
 </HTML>"));
      package Extrapolation "Type, constants and menu choices to define the extrapolation of time table interpolation"
              annotation(preferedView="text");
        extends Modelica.Icons.Library;
        constant Integer HoldLastPoint=0;
        constant Integer LastTwoPoints=1;
        constant Integer Periodic=2;
        type Temp "Temporary type of Extrapolation with choices for menus (until enumerations are available)"
                  extends Integer;
          annotation(choices(choice=Modelica.Blocks.Types.Extrapolation.HoldLastPoint "hold last point (constant extrapolation)",choice=Modelica.Blocks.Types.Extrapolation.LastTwoPoints "last two points (linear extrapolation)",choice=Modelica.Blocks.Types.Extrapolation.Periodic "periodic (repeat table)"));
        end Temp;
      end Extrapolation;
      package Smoothness "Type, constants and menu choices to define the smoothness of table interpolation"
              annotation(preferedView="text");
        extends Modelica.Icons.Library;
        constant Integer LinearSegments=0;
        constant Integer ContinuousDerivative=1;
        type Temp "Temporary type of Smoothness with choices for menus (until enumerations are available)"
                  extends Integer;
          annotation(choices(choice=Modelica.Blocks.Types.Smoothness.LinearSegments "linear segments",choice=Modelica.Blocks.Types.Smoothness.ContinuousDerivative "continuous derivative"));
        end Temp;
      end Smoothness;
    end Types;
    package Sources "Signal source blocks generating Real and Boolean signals"
          import Modelica.Blocks.Interfaces;
      import Modelica.SIunits;
      extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="<HTML>
 <p>
 This package contains <b>source</b> components, i.e., blocks which
 have only output signals. These blocks are used as signal generators.
 </p>
 <p>The following <b>sources</b> are provided to generate <b>Real</b> signals:</p>
 <pre>
   <b>Clock</b>             Generate actual time.
   <b>Constant</b>          Generate constant signals.
   <b>Step</b>              Generate step signals.
   <b>Ramp</b>              Generate ramp signals.
   <b>Sine</b>              Generate sine signals.
   <b>ExpSine</b>           Generate exponentially damped sine signals.
   <b>Exponentials</b>      Generate a rising and falling exponential signal.
   <b>Pulse</b>             Generate pulse signals.
   <b>SawTooth</b>          Generate sawtooth signals.
   <b>Trapezoid</b>         Generate trapezoidal signals.
   <b>KinematicPTP</b>      Generate an acceleration signal to move as fast as
                     possible along a distance within given kinematic constraints.
   <b>TimeTable</b>         Generate a (possibly discontinuous) signal by
                     linear interpolation in a table.
 </pre
 <p>
 The following <b>sources</b> are provided to generate <b>Boolean</b> signals:
 </p>
 <pre>
   <b>BooleanExpression</b> Generate signal by a Boolean expression
   <b>BooleanConstant</b>   Generate constant signals.
   <b>BooleanStep</b>       Generate step signals.
   <b>BooleanPulse</b>      Generate pulse signals.
   <b>SampleTrigger</b>     Generate sample triggers.
 </pre>
 <p>The following <b>sources</b> are provided to generate <b>Integer</b> signals:</p>
 <pre>
   <b>IntegerConstant</b>   Generate constant signals.
   <b>IntegerStep</b>       Generate step signals.
 </pre>
 <p>
 All Real source signals (with the exception of the Constant source)
 have at least the following two parameters:
 </p>
 <pre>
    <b>offset</b>       Value which is added to the signal.
    <b>startTime</b>    Start time of signal. For time &lt; startTime,
                 the output y is set to offset.
 </pre>
 <p>
 The <b>offset</b> parameter is especially useful in order to shift
 the corresponding source, such that at initial time the system
 is stationary. To determine the corresponding value of offset,
 usually requires a trimming calculation.
 </p>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Integer sources added. Step, TimeTable and BooleanStep slightly changed.</li>
 <li><i>Nov. 8, 1999</i>
        by <a href=\"mailto:clauss@eas.iis.fhg.de\">Christoph Clau&szlig;</a>,
        <A HREF=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</A>,
        <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        New sources: Exponentials, TimeTable. Trapezoid slightly enhanced
        (nperiod=-1 is an infinite number of periods).</li>
 <li><i>Oct. 31, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        <a href=\"mailto:clauss@eas.iis.fhg.de\">Christoph Clau&szlig;</a>,
        <A HREF=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</A>,
        All sources vectorized. New sources: ExpSine, Trapezoid,
        BooleanConstant, BooleanStep, BooleanPulse, SampleTrigger.
        Improved documentation, especially detailed description of
        signals in diagram layer.</li>
 <li><i>June 29, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized a first version, based on an existing Dymola library
        of Dieter Moormann and Hilding Elmqvist.</li>
 </ul>
 </html>"));
      block Clock "Generate actual time signal "
              parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-80.0,80.0},{80.0,-80.0}}, lineColor={160,160,160}),Line(points={{0.0,80.0},{0.0,60.0}}, color={160,160,160}),Line(points={{80.0,0.0},{60.0,0.0}}, color={160,160,160}),Line(points={{0.0,-80.0},{0.0,-60.0}}, color={160,160,160}),Line(points={{-80.0,0.0},{-60.0,0.0}}, color={160,160,160}),Line(points={{37.0,70.0},{26.0,50.0}}, color={160,160,160}),Line(points={{70.0,38.0},{49.0,26.0}}, color={160,160,160}),Line(points={{71.0,-37.0},{52.0,-27.0}}, color={160,160,160}),Line(points={{39.0,-70.0},{29.0,-51.0}}, color={160,160,160}),Line(points={{-39.0,-70.0},{-29.0,-52.0}}, color={160,160,160}),Line(points={{-71.0,-37.0},{-50.0,-26.0}}, color={160,160,160}),Line(points={{-71.0,37.0},{-54.0,28.0}}, color={160,160,160}),Line(points={{-38.0,70.0},{-28.0,51.0}}, color={160,160,160}),Line(points={{0.0,0.0},{-50.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{0.0,0.0},{40.0,0.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="startTime=%startTime", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,0.0},{-10.0,0.0},{60.0,70.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,0.0},{-37.0,-13.0},{-30.0,-13.0},{-34.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-34.0,-13.0},{-34.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-34.0,-69.0},{-37.0,-56.0},{-31.0,-56.0},{-34.0,-69.0},{-34.0,-69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-81.0,-25.0},{-35.0,-43.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-33.0,-71.0},{13.0,-89.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{-66.0,92.0},{-25.0,72.0}}, textString="y", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-10.0,0.0},{-10.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,0.0},{50.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{50.0,0.0},{50.0,60.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{35.0,33.0},{50.0,23.0}}, textString="1", fillColor={160,160,160}),Text(extent={{14.0,13.0},{32.0,1.0}}, textString="1", fillColor={160,160,160})}));

      equation 
        y=offset + (if time < startTime then 0 else time - startTime);
      end Clock;
      block Constant "Generate constant signal of type Real"
              parameter Real k=1 "Constant output value";
        extends Interfaces.SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,0.0},{80.0,0.0}}, color={0,0,0}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="k=%k", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,0.0},{80.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-75.0,94.0},{-22.0,76.0}}, textString="y", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-101.0,8.0},{-81.0,-12.0}}, textString="k", fillColor={160,160,160})}));

      equation 
        y=k;
      end Constant;
      block Step "Generate step signal of type Real"
              parameter Real height=1 "Height of step";
        extends Interfaces.SignalSource;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-70.0},{0.0,-70.0},{0.0,50.0},{80.0,50.0}}, color={0,0,0}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="startTime=%startTime", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-18.0},{0.0,-18.0},{0.0,50.0},{80.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-21.0,-72.0},{25.0,-90.0}}, textString="startTime", fillColor={160,160,160}),Line(points={{0.0,-17.0},{0.0,-71.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-68.0,-36.0},{-22.0,-54.0}}, textString="offset", fillColor={160,160,160}),Line(points={{-13.0,50.0},{-13.0,-17.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{2.0,50.0},{-19.0,50.0},{2.0,50.0}}, lineColor={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{-13.0,-17.0},{-16.0,-4.0},{-10.0,-4.0},{-13.0,-17.0},{-13.0,-17.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-13.0,50.0},{-16.0,37.0},{-9.0,37.0},{-13.0,50.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-68.0,26.0},{-22.0,8.0}}, textString="height", fillColor={160,160,160}),Polygon(points={{-13.0,-69.0},{-16.0,-56.0},{-10.0,-56.0},{-13.0,-69.0},{-13.0,-69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-13.0,-18.0},{-13.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-13.0,-18.0},{-16.0,-31.0},{-9.0,-31.0},{-13.0,-18.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-72.0,100.0},{-31.0,80.0}}, textString="y", fillColor={160,160,160})}));

      equation 
        y=offset + (if time < startTime then 0 else height);
      end Step;
      block Ramp "Generate ramp signal"
              parameter Real height=1 "Height of ramps";
        parameter Real duration(min=Modelica.Constants.small)=2 "Durations of ramp";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-70.0},{-40.0,-70.0},{31.0,38.0}}, color={0,0,0}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="duration=%duration", fillColor={0,0,0}),Line(points={{31.0,38.0},{86.0,38.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-20.0},{-20.0,-20.0},{50.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-40.0,-20.0},{-42.0,-30.0},{-37.0,-30.0},{-40.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-20.0},{-40.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-40.0,-70.0},{-43.0,-60.0},{-38.0,-60.0},{-40.0,-70.0},{-40.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-80.0,-33.0},{-41.0,-49.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-40.0,-70.0},{6.0,-88.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{-66.0,92.0},{-25.0,72.0}}, textString="y", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-20.0,-20.0},{-20.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-19.0,-20.0},{50.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{50.0,50.0},{101.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{50.0,50.0},{50.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{50.0,-20.0},{42.0,-18.0},{42.0,-22.0},{50.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-20.0,-20.0},{-11.0,-18.0},{-11.0,-22.0},{-20.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,50.0},{48.0,40.0},{53.0,40.0},{50.0,50.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,-20.0},{47.0,-10.0},{52.0,-10.0},{50.0,-20.0},{50.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{53.0,25.0},{82.0,7.0}}, textString="height", fillColor={160,160,160}),Text(extent={{0.0,-17.0},{35.0,-37.0}}, textString="duration", fillColor={160,160,160})}));

      equation 
        y=offset + (if time < startTime then 0 else if time < startTime + duration then ((time - startTime)*height)/duration else height);
      end Ramp;
      block Sine "Generate sine signal"
              parameter Real amplitude=1 "Amplitude of sine wave";
        parameter SIunits.Frequency freqHz=1 "Frequency of sine wave";
        parameter SIunits.Angle phase=0 "Phase of sine wave";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
      protected 
        constant Real pi=Modelica.Constants.pi;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,0.0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,-64.2},{29.3,-73.1},{35.0,-78.4},{40.6,-80.0},{46.2,-77.6},{51.9,-71.5},{57.5,-61.9},{63.9,-47.2},{72.0,-24.8},{80.0,0.0}}, color={0,0,0}),Text(extent={{-147.0,-152.0},{153.0,-112.0}}, textString="freqHz=%freqHz", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-99.0,-40.0},{85.0,-40.0}}, color={192,192,192}),Polygon(points={{101.0,-40.0},{85.0,-34.0},{85.0,-46.0},{101.0,-40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,0.0},{-31.6,34.2},{-26.1,53.1},{-21.3,66.4},{-17.1,74.6},{-12.9,79.1},{-8.64,79.8},{-4.42,76.6},{-0.201,69.7},{4.02,59.4},{8.84,44.1},{14.9,21.2},{27.5,-30.8},{33.0,-50.2},{37.8,-64.2},{42.0,-73.1},{46.2,-78.4},{50.5,-80.0},{54.7,-77.6},{58.9,-71.5},{63.1,-61.9},{67.9,-47.2},{74.0,-24.8},{80.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{-41.0,-2.0},{-80.0,-2.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-128.0,7.0},{-82.0,-11.0}}, textString="offset", fillColor={160,160,160}),Line(points={{-41.0,-2.0},{-41.0,-40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-60.0,-43.0},{-14.0,-61.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{84.0,-52.0},{108.0,-72.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-74.0,106.0},{-33.0,86.0}}, textString="y", fillColor={160,160,160}),Line(points={{-9.0,79.0},{43.0,79.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-42.0,-1.0},{50.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{33.0,80.0},{30.0,67.0},{37.0,67.0},{33.0,80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{37.0,57.0},{83.0,39.0}}, textString="amplitude", fillColor={160,160,160}),Polygon(points={{33.0,1.0},{30.0,14.0},{36.0,14.0},{33.0,1.0},{33.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{33.0,79.0},{33.0,0.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None})}));

      equation 
        y=offset + (if time < startTime then 0 else amplitude*Modelica.Math.sin(2*pi*freqHz*(time - startTime) + phase));
      end Sine;
      block ExpSine "Generate exponentially damped sine signal"
              parameter Real amplitude=1 "Amplitude of sine wave";
        parameter SIunits.Frequency freqHz=2 "Frequency of sine wave";
        parameter SIunits.Angle phase=0 "Phase of sine wave";
        parameter SIunits.Damping damping=1 "Damping coefficient of sine wave";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
      protected 
        constant Real pi=Modelica.Constants.pi;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,0.0},{-75.2,32.3},{-72.0,50.3},{-68.7,64.5},{-65.5,74.2},{-62.3,79.3},{-59.1,79.6},{-55.9,75.3},{-52.7,67.1},{-48.6,52.2},{-43.0,25.8},{-35.0,-13.9},{-30.2,-33.7},{-26.1,-45.9},{-22.1,-53.2},{-18.1,-55.3},{-14.1,-52.5},{-10.1,-45.3},{-5.23,-32.1},{8.44,13.7},{13.3,26.4},{18.1,34.8},{22.1,38.0},{26.9,37.2},{31.8,31.8},{38.2,19.4},{51.1,-10.5},{57.5,-21.2},{63.1,-25.9},{68.7,-25.9},{75.2,-20.5},{80.0,-13.8}}, color={0,0,0}),Text(extent={{-147.0,-152.0},{153.0,-112.0}}, textString="freqHz=%freqHz", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-99.0,-40.0},{85.0,-40.0}}, color={192,192,192}),Polygon(points={{101.0,-40.0},{85.0,-34.0},{85.0,-46.0},{101.0,-40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-50.0,0.0},{-46.1,28.2},{-43.5,44.0},{-40.9,56.4},{-38.2,64.9},{-35.6,69.4},{-33.0,69.6},{-30.4,65.9},{-27.8,58.7},{-24.5,45.7},{-19.9,22.5},{-13.4,-12.2},{-9.5,-29.5},{-6.23,-40.1},{-2.96,-46.5},{0.302,-48.4},{3.57,-45.9},{6.83,-39.6},{10.8,-28.1},{21.9,12.0},{25.8,23.1},{29.7,30.5},{33.0,33.3},{36.9,32.5},{40.8,27.8},{46.0,16.9},{56.5,-9.2},{61.7,-18.6},{66.3,-22.7},{70.9,-22.6},{76.1,-18.0},{80.0,-12.1}}, color={0,0,0}, thickness=0.5),Text(extent={{-106.0,10.0},{-83.0,-10.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-72.0,-36.0},{-26.0,-54.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{84.0,-52.0},{108.0,-72.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-79.0,104.0},{-39.0,87.0}}, textString="y", fillColor={160,160,160}),Line(points={{-50.0,0.0},{18.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-50.0,0.0},{-81.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{-50.0,77.0},{-50.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,-1.0},{18.0,76.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,73.0},{-50.0,73.0}}, color={192,192,192}),Text(extent={{-42.0,88.0},{9.0,74.0}}, textString="1/freqHz", fillColor={160,160,160}),Polygon(points={{-49.0,73.0},{-40.0,75.0},{-40.0,71.0},{-49.0,73.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{18.0,73.0},{10.0,75.0},{10.0,71.0},{18.0,73.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-50.0,-61.0},{-19.0,-61.0}}, color={192,192,192}),Polygon(points={{-18.0,-61.0},{-26.0,-59.0},{-26.0,-63.0},{-18.0,-61.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-51.0,-63.0},{-27.0,-75.0}}, textString="t", fillColor={160,160,160}),Text(extent={{-82.0,-67.0},{108.0,-96.0}}, textString="amplitude*exp(-damping*t)*sin(2*pi*freqHz*t+phase)", fillColor={160,160,160}),Line(points={{-50.0,0.0},{-50.0,-40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-50.0,-54.0},{-50.0,-72.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-15.0,-77.0},{-1.0,-48.0}}, color={192,192,192}, pattern=LinePattern.Dash)}));

      equation 
        y=offset + (if time < startTime then 0 else amplitude*Modelica.Math.exp(-(time - startTime)*damping)*Modelica.Math.sin(2*pi*freqHz*(time - startTime) + phase));
      end ExpSine;
      model Exponentials "Generate a rising and falling exponential signal"
              parameter Real outMax=1 "Height of output for infinite riseTime";
        parameter SIunits.Time riseTime(min=0)=0.5 "Rise time";
        parameter SIunits.Time riseTimeConst(min=Modelica.Constants.small)=0.1 "Rise time constant";
        parameter SIunits.Time fallTimeConst(min=Modelica.Constants.small)=riseTimeConst "Fall time constant";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
      protected 
        Real y_riseTime;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,-70.0},{68.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-70.0},{-77.2,-55.3},{-74.3,-42.1},{-70.8,-27.6},{-67.3,-15.0},{-63.7,-4.08},{-59.5,7.18},{-55.3,16.7},{-50.3,26.0},{-44.6,34.5},{-38.3,42.1},{-31.2,48.6},{-22.7,54.3},{-12.1,59.2},{-10.0,60.0},{-7.88,47.5},{-5.05,32.7},{-2.22,19.8},{0.606,8.45},{4.14,-3.7},{7.68,-14.0},{11.9,-24.2},{16.2,-32.6},{21.1,-40.5},{26.8,-47.4},{33.1,-53.3},{40.9,-58.5},{50.8,-62.8},{60.0,-65.4}}, color={0,0,0}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="riseTime=%riseTime", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-70.0},{84.0,-70.0}}, color={192,192,192}),Polygon(points={{100.0,-70.0},{84.0,-64.0},{84.0,-76.0},{100.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{-37.2,-15.3},{-34.3,-2.1},{-30.8,12.4},{-27.3,25.0},{-23.7,35.92},{-19.5,47.18},{-15.3,56.7},{-10.3,66.0},{-4.6,74.5},{1.7,82.1},{8.8,88.6},{17.3,94.3},{27.9,99.2},{30.0,100.0},{32.12,87.5},{34.95,72.7},{37.78,59.8},{40.606,48.45},{44.14,36.3},{47.68,26.0},{51.9,15.8},{56.2,7.4},{61.1,-0.5},{66.8,-7.4},{73.1,-13.3},{80.9,-18.5},{90.8,-22.8},{100.0,-25.4}}, color={0,0,0}, thickness=0.5),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Text(extent={{-70.0,91.0},{-29.0,71.0}}, textString="y", fillColor={160,160,160}),Text(extent={{-78.0,-43.0},{-46.0,-56.0}}, textString="offset", fillColor={160,160,160}),Polygon(points={{-40.0,-70.0},{-43.0,-60.0},{-38.0,-60.0},{-40.0,-70.0},{-40.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-29.0},{-40.0,-60.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-40.0,-30.0},{-42.0,-40.0},{-37.0,-40.0},{-40.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-39.0,-30.0},{-80.0,-30.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-59.0,-71.0},{-13.0,-89.0}}, textString="startTime", fillColor={160,160,160}),Polygon(points={{-41.0,-30.0},{-32.0,-28.0},{-32.0,-32.0},{-41.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{29.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{29.0,-30.0},{21.0,-28.0},{21.0,-32.0},{29.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-26.0,-12.0},{19.0,-28.0}}, textString="riseTime", fillColor={160,160,160}),Text(extent={{78.0,-76.0},{102.0,-96.0}}, textString="time", fillColor={160,160,160}),Line(points={{30.0,100.0},{30.0,-34.0}}, color={192,192,192}, pattern=LinePattern.Dash)}));

      equation 
        y_riseTime=outMax*(1 - Modelica.Math.exp(-riseTime/riseTimeConst));
        y=offset + (if time < startTime then 0 else if time < startTime + riseTime then outMax*(1 - Modelica.Math.exp(-(time - startTime)/riseTimeConst)) else y_riseTime*Modelica.Math.exp(-(time - startTime - riseTime)/fallTimeConst));
      end Exponentials;
      block Pulse "Generate pulse signal of type Real"
              parameter Real amplitude=1 "Amplitude of pulse";
        parameter Real width(final min=Modelica.Constants.small,final max=100)=50 "Width of pulse in % of periods";
        parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
        parameter Real offset=0 "Offset of output signals";
        parameter Modelica.SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Modelica.Blocks.Interfaces.SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-70.0},{-40.0,-70.0},{-40.0,44.0},{0.0,44.0},{0.0,-70.0},{40.0,-70.0},{40.0,44.0},{79.0,44.0}}, color={0,0,0}),Text(extent={{-147.0,-152.0},{153.0,-112.0}}, textString="period=%period", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,1.0},{-37.0,-12.0},{-30.0,-12.0},{-34.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-34.0,-1.0},{-34.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-33.0,-70.0},{-36.0,-57.0},{-30.0,-57.0},{-33.0,-70.0},{-33.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-78.0,-24.0},{-35.0,-36.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-31.0,-69.0},{15.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{-76.0,99.0},{-35.0,79.0}}, textString="y", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-10.0,0.0},{-10.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-80.0,0.0},{-10.0,0.0},{-10.0,50.0},{30.0,50.0},{30.0,0.0},{50.0,0.0},{50.0,50.0},{90.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-10.0,88.0},{-10.0,49.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{30.0,74.0},{30.0,50.0}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{50.0,88.0},{50.0,50.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,83.0},{51.0,83.0}}, color={192,192,192}),Line(points={{-10.0,69.0},{30.0,69.0}}, color={192,192,192}),Text(extent={{0.0,97.0},{46.0,85.0}}, textString="period", fillColor={160,160,160}),Text(extent={{-9.0,81.0},{30.0,69.0}}, textString="width", fillColor={160,160,160}),Line(points={{-43.0,50.0},{-10.0,50.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-34.0,50.0},{-34.0,1.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-78.0,34.0},{-37.0,20.0}}, textString="amplitude", fillColor={160,160,160}),Polygon(points={{-34.0,49.0},{-37.0,36.0},{-30.0,36.0},{-34.0,49.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,1.0},{-37.0,14.0},{-31.0,14.0},{-34.0,1.0},{-34.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{90.0,50.0},{90.0,0.0},{100.0,0.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{-10.0,69.0},{-1.0,71.0},{-1.0,67.0},{-10.0,69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{30.0,69.0},{22.0,71.0},{22.0,67.0},{30.0,69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-10.0,83.0},{-1.0,85.0},{-1.0,81.0},{-10.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,83.0},{42.0,85.0},{42.0,81.0},{50.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}));
      protected 
        Modelica.SIunits.Time T0(final start=startTime) "Start time of current period";
        Modelica.SIunits.Time T_width=(period*width)/100;

      equation 
        when sample(startTime, period) then
                  T0=time;
        
        end when;
        y=offset + (if time < startTime or time >= T0 + T_width then 0 else amplitude);
      end Pulse;
      block SawTooth "Generate saw tooth signal"
              parameter Real amplitude=1 "Amplitude of saw tooth";
        parameter SIunits.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
        parameter Real offset=0 "Offset of output signals";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
      protected 
        SIunits.Time T0(final start=startTime) "Start time of current period";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-70.0},{-60.0,-70.0},{0.0,40.0},{0.0,-70.0},{60.0,41.0},{60.0,-70.0}}, color={0,0,0}),Text(extent={{-147.0,-152.0},{153.0,-112.0}}, textString="period=%period", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,-19.0},{-37.0,-32.0},{-30.0,-32.0},{-34.0,-19.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-34.0,-20.0},{-34.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-34.0,-70.0},{-37.0,-57.0},{-31.0,-57.0},{-34.0,-70.0},{-34.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-78.0,-24.0},{-35.0,-36.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-31.0,-69.0},{15.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{-76.0,99.0},{-35.0,79.0}}, textString="y", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-10.0,-20.0},{-10.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,88.0},{-10.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{30.0,88.0},{30.0,59.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,83.0},{30.0,83.0}}, color={192,192,192}),Text(extent={{-12.0,97.0},{34.0,85.0}}, textString="period", fillColor={160,160,160}),Line(points={{-44.0,60.0},{30.0,60.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-34.0,47.0},{-34.0,-7.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-78.0,34.0},{-37.0,20.0}}, textString="amplitude", fillColor={160,160,160}),Polygon(points={{-34.0,60.0},{-37.0,47.0},{-30.0,47.0},{-34.0,60.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,-20.0},{-37.0,-7.0},{-31.0,-7.0},{-34.0,-20.0},{-34.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-10.0,83.0},{-1.0,85.0},{-1.0,81.0},{-10.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{30.0,83.0},{22.0,85.0},{22.0,81.0},{30.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-20.0},{-10.0,-20.0},{30.0,60.0},{30.0,-20.0},{72.0,60.0},{72.0,-20.0}}, color={0,0,0}, thickness=0.5)}));

      equation 
        when sample(startTime, period) then
                  T0=time;
        
        end when;
        y=offset + (if time < startTime then 0 else amplitude/period*(time - T0));
      end SawTooth;
      block Trapezoid "Generate trapezoidal signal of type Real"
              parameter Real amplitude=1 "Amplitude of trapezoid";
        parameter SIunits.Time rising(final min=0)=0 "Rising duration of trapezoid";
        parameter SIunits.Time width(final min=0)=0.5 "Width duration of trapezoid";
        parameter SIunits.Time falling(final min=0)=0 "Falling duration of trapezoid";
        parameter SIunits.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
        parameter Integer nperiod=-1 "Number of periods (< 0 means infinite number of periods)";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
      protected 
        parameter SIunits.Time T_rising=rising "End time of rising phase within one period";
        parameter SIunits.Time T_width=T_rising + width "End time of width phase within one period";
        parameter SIunits.Time T_falling=T_width + falling "End time of falling phase within one period";
        SIunits.Time T0(final start=startTime) "Start time of current period";
        Integer counter(start=nperiod) "Period counter";
        Integer counter2(start=nperiod);
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-147.0,-152.0},{153.0,-112.0}}, textString="period=%period", fillColor={0,0,0}),Line(points={{-81.0,-70.0},{-60.0,-70.0},{-30.0,40.0},{9.0,40.0},{39.0,-70.0},{61.0,-70.0},{90.0,40.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-45.0,-30.0},{-47.0,-41.0},{-43.0,-41.0},{-45.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-45.0,-31.0},{-45.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-45.0,-70.0},{-47.0,-60.0},{-43.0,-60.0},{-45.0,-70.0},{-45.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-86.0,-43.0},{-43.0,-55.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-47.0,-69.0},{-1.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{-76.0,99.0},{-35.0,79.0}}, textString="y", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-29.0,82.0},{-30.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,59.0},{-10.0,40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{20.0,59.0},{20.0,39.0}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{40.0,59.0},{40.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-20.0,76.0},{61.0,76.0}}, color={192,192,192}),Line(points={{-29.0,56.0},{40.0,56.0}}, color={192,192,192}),Text(extent={{-2.0,86.0},{25.0,77.0}}, textString="period", fillColor={160,160,160}),Text(extent={{-8.0,70.0},{21.0,60.0}}, textString="width", fillColor={160,160,160}),Line(points={{-42.0,40.0},{-10.0,40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-39.0,40.0},{-39.0,-19.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-77.0,14.0},{-40.0,0.0}}, textString="amplitude", fillColor={160,160,160}),Polygon(points={{-29.0,56.0},{-22.0,58.0},{-22.0,54.0},{-29.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-10.0,56.0},{-17.0,58.0},{-17.0,54.0},{-10.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-29.0,76.0},{-20.0,78.0},{-20.0,74.0},{-29.0,76.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{61.0,76.0},{53.0,78.0},{53.0,74.0},{61.0,76.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-30.0},{-30.0,-30.0},{-10.0,40.0},{20.0,40.0},{40.0,-30.0},{60.0,-30.0},{80.0,40.0},{100.0,40.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{-39.0,40.0},{-41.0,29.0},{-37.0,29.0},{-39.0,40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-39.0,-29.0},{-41.0,-19.0},{-37.0,-19.0},{-39.0,-29.0},{-39.0,-29.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{61.0,84.0},{60.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{39.0,56.0},{32.0,58.0},{32.0,54.0},{39.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20.0,56.0},{27.0,58.0},{27.0,54.0},{20.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20.0,56.0},{13.0,58.0},{13.0,54.0},{20.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-12.0,56.0},{-5.0,58.0},{-5.0,54.0},{-12.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-34.0,70.0},{-5.0,60.0}}, textString="rising", fillColor={160,160,160}),Text(extent={{16.0,70.0},{45.0,60.0}}, textString="falling", fillColor={160,160,160})}));

      equation 
        when pre(counter2) <> 0 and sample(startTime, period) then
                  T0=time;
          counter2=pre(counter);
          counter=pre(counter) - (if pre(counter) > 0 then 1 else 0);
        
        end when;
        y=offset + (if time < startTime or counter2 == 0 or time >= T0 + T_falling then 0 else if time < T0 + T_rising then ((time - T0)*amplitude)/T_rising else if time < T0 + T_width then amplitude else ((T0 + T_falling - time)*amplitude)/(T_falling - T_width));
      end Trapezoid;
      block TimeTable "Generate a (possibly discontinuous) signal by linear interpolation in a table"
              parameter Real table[:,2]={{0,0},{1,1},{2,4}} "Table matrix (time = first column)";
        parameter Real offset=0 "Offset of output signal";
        parameter SIunits.Time startTime=0 "Output = offset for time < startTime";
        extends Interfaces.SO;
      protected 
        Real a "Interpolation coefficients a of actual interval (y=a*x+b)";
        Real b "Interpolation coefficients b of actual interval (y=a*x+b)";
        Integer last(start=1) "Last used lower grid index";
        SIunits.Time nextEvent(start=0) "Next event instant";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-48.0,70.0},{2.0,-50.0}}, lineColor={255,255,255}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-48.0,-50.0},{-48.0,70.0},{52.0,70.0},{52.0,-50.0},{-48.0,-50.0},{-48.0,-20.0},{52.0,-20.0},{52.0,10.0},{-48.0,10.0},{-48.0,40.0},{52.0,40.0},{52.0,70.0},{2.0,70.0},{2.0,-51.0}}, color={0,0,0}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="offset=%offset", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-20.0,90.0},{30.0,-30.0}}, lineColor={255,255,255}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-20.0,-30.0},{-20.0,90.0},{80.0,90.0},{80.0,-30.0},{-20.0,-30.0},{-20.0,0.0},{80.0,0.0},{80.0,30.0},{-20.0,30.0},{-20.0,60.0},{80.0,60.0},{80.0,90.0},{30.0,90.0},{30.0,-31.0}}, color={0,0,0}),Text(extent={{-77.0,-42.0},{-38.0,-58.0}}, textString="offset", fillColor={160,160,160}),Polygon(points={{-31.0,-30.0},{-33.0,-40.0},{-28.0,-40.0},{-31.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-30.0,-70.0},{-33.0,-60.0},{-28.0,-60.0},{-30.0,-70.0},{-30.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-31.0,-31.0},{-31.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-20.0,-20.0},{-20.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-38.0,-70.0},{8.0,-88.0}}, textString="startTime", fillColor={160,160,160}),Line(points={{-20.0,-30.0},{-80.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-73.0,93.0},{-41.0,78.0}}, textString="y", fillColor={160,160,160}),Text(extent={{66.0,-81.0},{91.0,-93.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-15.0,83.0},{24.0,68.0}}, textString="time", fillColor={0,0,0}),Text(extent={{33.0,83.0},{76.0,67.0}}, textString="y", fillColor={0,0,0})}),Documentation(info="<HTML>
 <p>
 This block generates an output signal by <b>linear interpolation</b> in
 a table. The time points and function values are stored in a matrix
 <b>table[i,j]</b>, where the first column table[:,1] contains the
 time points and the second column contains the data to be interpolated.
 The table interpolation has the following proporties:
 </p>
 <ul>
 <li>The time points need to be <b>monotonically increasing</b>. </li>
 <li><b>Discontinuities</b> are allowed, by providing the same
     time point twice in the table. </li>
 <li>Values <b>outside</b> of the table range, are computed by
     <b>extrapolation</b> through the last or first two points of the
     table.</li>
 <li>If the table has only <b>one row</b>, no interpolation is performed and
     the function value is just returned independantly of the
     actual time instant.</li>
 <li>Via parameters <b>startTime</b> and <b>offset</b> the curve defined
     by the table can be shifted both in time and in the ordinate value.
 <li>The table is implemented in a numerically sound way by
     generating <b>time events</b> at interval boundaries,
     in order to not integrate over a discontinuous or not differentiable
     points.
 </li>
 </ul>
 <p>
 Example:
 </p>
 <pre>
    table = [0  0
             1  0
             1  1
             2  4
             3  9
             4 16]
 If, e.g., time = 1.0, the output y =  0.0 (before event), 1.0 (after event)
     e.g., time = 1.5, the output y =  2.5,
     e.g., time = 2.0, the output y =  4.0,
     e.g., time = 5.0, the output y = 23.0 (i.e. extrapolation).
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Oct. 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Corrected interface from
 <pre>
     parameter Real table[:, :]=[0, 0; 1, 1; 2, 4];
 </pre>
        to
 <pre>
     parameter Real table[:, <b>2</b>]=[0, 0; 1, 1; 2, 4];
 </pre>
        </li>
 <li><i>Nov. 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "));
        function getInterpolationCoefficients "Determine interpolation coefficients and next time event"
                  input Real table[:,2] "Table for interpolation";
          input Real offset "y-offset";
          input Real startTime "time-offset";
          input Real t "Actual time instant";
          input Integer last "Last used lower grid index";
          input Real TimeEps "Relative epsilon to check for identical time instants";
          output Real a "Interpolation coefficients a (y=a*x + b)";
          output Real b "Interpolation coefficients b (y=a*x + b)";
          output Real nextEvent "Next event instant";
          output Integer next "New lower grid index";
        protected 
          Integer columns=2 "Column to be interpolated";
          Integer ncol=2 "Number of columns to be interpolated";
          Integer nrow=size(table, 1) "Number of table rows";
          Integer next0;
          Real tp;
          Real dt;
        algorithm 
          next:=last;
          nextEvent:=t - TimeEps*abs(t);
          tp:=t + TimeEps*abs(t) - startTime;
          if tp < 0.0 then 
                    nextEvent:=startTime;
          a:=0;
          b:=offset;
          else           if nrow < 2 then 
                    a:=0;
          b:=offset + table[1,columns];
          else           while (next < nrow and tp >= table[next,1]) loop
                      next:=next + 1;

          end while;
          if next < nrow then 
                    nextEvent:=startTime + table[next,1];

          else 
          end if;
          next0:=next - 1;
          dt:=table[next,1] - table[next0,1];
          if dt <= TimeEps*abs(table[next,1]) then 
                    a:=0;
          b:=offset + table[next,columns];
          else           a:=(table[next,columns] - table[next0,columns])/dt;
          b:=offset + table[next0,columns] - a*table[next0,1];
          end if;
          end if;

          end if;
          b:=b - a*startTime;        end getInterpolationCoefficients;
      algorithm 
        when {time >= pre(nextEvent),initial()} then
                  (a,b,nextEvent,last) := getInterpolationCoefficients(table, offset, startTime, time, last, 100*Modelica.Constants.eps);
        
        end when;

      equation 
        y=a*time + b;
      end TimeTable;
      model CombiTimeTable "Table look-up with respect to time and linear/perodic extrapolation methods (data from matrix/file)"
              parameter Boolean tableOnFile=false "true, if table is defined on file or in function usertab" annotation(Dialog(group="table data definition"));
        parameter Real table[:,:]=fill(0.0, 0, 2) "table matrix (time = first column)" annotation(Dialog(group="table data definition",enable=not tableOnFile));
        parameter String tableName="NoName" "table name on file or in function usertab (see docu)" annotation(Dialog(group="table data definition",enable=tableOnFile));
        parameter String fileName="NoName" "file where matrix is stored" annotation(Dialog(group="table data definition",enable=tableOnFile));
        parameter Integer columns[:]=2:size(table, 2) "columns of table to be interpolated" annotation(Dialog(group="table data interpretation"));
        parameter Blocks.Types.Smoothness.Temp smoothness=Blocks.Types.Smoothness.LinearSegments "smoothness of table interpolation" annotation(Dialog(group="table data interpretation"));
        parameter Blocks.Types.Extrapolation.Temp extrapolation=Blocks.Types.Extrapolation.LastTwoPoints "extrapolation of data outside the definition range" annotation(Dialog(group="table data interpretation"));
        parameter Real offset[:]={0} "Offsets of output signals" annotation(Dialog(group="table data interpretation"));
        parameter SI.Time startTime=0 "Output = offset for time < startTime" annotation(Dialog(group="table data interpretation"));
        extends Modelica.Blocks.Interfaces.MO(final nout=max([size(columns, 1);size(offset, 1)]));
        final parameter Real t_min=tableTimeTmin(tableID);
        final parameter Real t_max=tableTimeTmax(tableID);
      protected 
        final parameter Real p_offset[nout]=if size(offset, 1) == 1 then ones(nout)*offset[1] else offset;
        final parameter Integer tableID=tableTimeInit(0.0, startTime, smoothness, extrapolation, if not tableOnFile then "NoName" else tableName, if not tableOnFile then "NoName" else fileName, table, 0);
        function tableTimeInit
                  input Real timeIn;
          input Real startTime;
          input Integer ipoType;
          input Integer expoType;
          input String tableName;
          input String fileName;
          input Real table[:,:];
          input Integer colWise;
          output Integer tableID;

          external "C" tableID=omcTableTimeIni(timeIn,startTime,ipoType,expoType,tableName,fileName,table,size(table, 1),size(table, 2),colWise) ;

        end tableTimeInit;
        function tableTimeIpo
                  input Integer tableID;
          input Integer icol;
          input Real timeIn;
          output Real value;

          external "C" value=dymTableTimeIpo2(tableID,icol,timeIn) ;

        end tableTimeIpo;
        function tableTimeTmin
                  input Integer tableID;
          output Real Tmin "minimum time value in table";

          external "C" Tmin=dymTableTimeTmin(tableID) ;

        end tableTimeTmin;
        function tableTimeTmax
                  input Integer tableID;
          output Real Tmax "maximum time value in table";

          external "C" Tmax=dymTableTimeTmax(tableID) ;

        end tableTimeTmax;
        annotation(Documentation(info="<HTML>
 <p>
 This block generates an output signal y[:] by <b>linear interpolation</b> in
 a table. The time points and function values are stored in a matrix
 <b>table[i,j]</b>, where the first column table[:,1] contains the
 time points and the other columns contain the data to be interpolated.
 Via parameter <b>columns</b> it can be defined which columns of the
 table are interpolated. If, e.g., columns={2,4}, it is assumed that
 2 output signals are present and that the first output is computed
 by interpolation of column 2 and the second output is computed
 by interpolation of column 4 of the table matrix.
 The table interpolation has the following properties:
 </p>
 <ul>
 <li>The time points need to be <b>monotonically increasing</b>. </li>
 <li><b>Discontinuities</b> are allowed, by providing the same
     time point twice in the table. </li>
 <li>Values <b>outside</b> of the table range, are computed by
     extrapolation according to the setting of parameter
     <b>extrapolation</b>:
 <pre>
   extrapolation = 0: hold the first or last value of the table,
                      if outside of the range.
                 = 1: extrapolate through the last or first two
                      points of the table.
                 = 2: periodically repeat the table data
                      (periodical function).
 </pre></li>
 <li>Via parameter <b>smoothness</b> it is defined how the data is interpolated:
 <pre>
   smoothness = 0: linear interpolation
              = 1: smooth interpolation with Akima Splines such
                   that der(y) is continuous.
 </pre></li>
 <li>If the table has only <b>one row</b>, no interpolation is performed and
     the table values of this row are just returned.</li>
 <li>Via parameters <b>startTime</b> and <b>offset</b> the curve defined
     by the table can be shifted both in time and in the ordinate value.
     The time instants stored in the table are therefore <b>relative</b>
     to <b>startTime</b>.
     If time &lt; startTime, no interpolation is performed and the offset
     is used as ordinate value for all outputs.
 <li>The table is implemented in a numerically sound way by
     generating <b>time events</b> at interval boundaries,
     in order to not integrate over a discontinuous or not differentiable
     points.
 <li>For special applications it is sometimes needed to know the minimum
     and maximum time instant defined in the table as a parameter. For this
     reason parameters <b>t_min</b> and <b>t_max</b> are provided and can be access from
     the outside of the table object.
 </li>
 </ul>
 <p>
 Example:
 </p>
 <pre>
    table = [0  0
             1  0
             1  1
             2  4
             3  9
             4 16]; extrapolation = 1 (default)
 If, e.g., time = 1.0, the output y =  0.0 (before event), 1.0 (after event)
     e.g., time = 1.5, the output y =  2.5,
     e.g., time = 2.0, the output y =  4.0,
     e.g., time = 5.0, the output y = 23.0 (i.e. extrapolation via last 2 points).
 </pre>
 <p>
 The table matrix can be defined in the following ways:
 </p>
 <ol>
 <li> Explicitly supplied as <b>parameter matrix</b> \"table\",
      and the other parameters have the following values:
 <pre>
    tableName is \"NoName\" or has only blanks,
    fileName  is \"NoName\" or has only blanks.
 </pre></li>
 <li> <b>Read</b> from a <b>file</b> \"fileName\" where the matrix is stored as
       \"tableName\". Both ASCII and binary file format is possible.
       (the ASCII format is described below).
       It is most convenient to generate the binary file from Matlab
       (Matlab 4 storage format), e.g., by command
 <pre>
    save tables.mat tab1 tab2 tab3 -V4
 </pre>
       when the three tables tab1, tab2, tab3 should be
       used from the model.</li>
 <li>  Statically stored in function \"usertab\" in file \"usertab.c\".
       The matrix is identified by \"tableName\". Parameter
       fileName = \"NoName\" or has only blanks.</li>
 </ol>
 <p>
 Table definition methods (1) and (3) do <b>not</b> allocate dynamic memory,
 and do not access files, whereas method (2) does. Therefore (1) and (3)
 are suited for hardware-in-the-loop simulation (e.g. with dSpace hardware).
 When the constant \"NO_FILE\" is defined in \"usertab.c\", all parts of the
 source code of method (2) are removed by the C-preprocessor, such that
 no dynamic memory allocation and no access to files takes place.
 </p>
 <p>
 If tables are read from an ASCII-file, the file need to have the
 following structure (\"-----\" is not part of the file content):
 </p>
 <pre>
 -----------------------------------------------------
 #1
 double tab1(6,2)   # comment line
   0   0
   1   0
   1   1
   2   4
   3   9
   4  16
 double tab2(6,2)   # another comment line
   0   0
   2   0
   2   2
   4   8
   6  18
   8  32
 -----------------------------------------------------
 </pre>
 <p>
 Note, that the first two characters in the file need to be
 \"#1\". Afterwards, the corresponding matrix has to be declared
 with type, name and actual dimensions. Finally, in successive
 rows of the file, the elements of the matrix have to be given.
 Several matrices may be defined one after another.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>March 31, 2001</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Used CombiTableTime as a basis and added the
        arguments <b>extrapolation, columns, startTime</b>.
        This allows periodic function definitions. </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-48.0,70.0},{2.0,-50.0}}, lineColor={255,255,255}, fillColor={255,255,0}, fillPattern=FillPattern.Solid),Line(points={{-48.0,-50.0},{-48.0,70.0},{52.0,70.0},{52.0,-50.0},{-48.0,-50.0},{-48.0,-20.0},{52.0,-20.0},{52.0,10.0},{-48.0,10.0},{-48.0,40.0},{52.0,40.0},{52.0,70.0},{2.0,70.0},{2.0,-51.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-20.0,90.0},{20.0,-30.0}}, lineColor={255,255,255}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-20.0,-30.0},{-20.0,90.0},{80.0,90.0},{80.0,-30.0},{-20.0,-30.0},{-20.0,0.0},{80.0,0.0},{80.0,30.0},{-20.0,30.0},{-20.0,60.0},{80.0,60.0},{80.0,90.0},{20.0,90.0},{20.0,-30.0}}, color={0,0,0}),Text(extent={{-77.0,-42.0},{-38.0,-58.0}}, textString="offset", fillColor={160,160,160}),Polygon(points={{-31.0,-30.0},{-33.0,-40.0},{-28.0,-40.0},{-31.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-30.0,-70.0},{-33.0,-60.0},{-28.0,-60.0},{-30.0,-70.0},{-30.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-31.0,-31.0},{-31.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-20.0,-30.0},{-20.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-38.0,-70.0},{8.0,-88.0}}, textString="startTime", fillColor={160,160,160}),Line(points={{-20.0,-30.0},{-80.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-73.0,93.0},{-41.0,78.0}}, fillColor={160,160,160}, textString="y"),Text(extent={{66.0,-81.0},{91.0,-93.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-19.0,83.0},{20.0,68.0}}, textString="time", fillColor={0,0,0}),Text(extent={{21.0,82.0},{50.0,68.0}}, fillColor={0,0,0}, textString="y[1]"),Line(points={{50.0,90.0},{50.0,-30.0}}, color={0,0,0}),Line(points={{80.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{34.0,-30.0},{71.0,-42.0}}, textString="columns", fillColor={0,0,255}),Text(extent={{51.0,82.0},{80.0,68.0}}, fillColor={0,0,0}, textString="y[2]")}));

      equation 
if tableOnFile then
        assert(tableName <> "NoName", "tableOnFile = true and no table name given");
        end if;
if not tableOnFile then
        assert(size(table, 1) > 0 and size(table, 2) > 0, "tableOnFile = false and parameter table is an empty matrix");
        end if;
        for i in 1:nout loop
        y[i]=p_offset[i] + tableTimeIpo(tableID, columns[i], time);

        end for;
      end CombiTimeTable;
      block BooleanConstant "Generate constant signal of type Boolean"
              parameter Boolean k=true "Constant output value";
        extends Interfaces.partialBooleanSource;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,0.0},{80.0,0.0}}, color={0,0,0}),Text(extent={{-150.0,-140.0},{150.0,-110.0}}, fillColor={0,0,0}, textString="%k")}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,0.0},{80.0,0.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-83.0,20.0},{-63.0,0.0}}, textString="k", fillColor={160,160,160}),Text(extent={{-100.0,6.0},{-80.0,-6.0}}, textString="true", fillColor={160,160,160}),Text(extent={{-104.0,-58.0},{-78.0,-70.0}}, textString="false", fillColor={160,160,160})}));

      equation 
        y=k;
      end BooleanConstant;
      block BooleanStep "Generate step signal of type Boolean"
              parameter Modelica.SIunits.Time startTime=0 "Time instant of step start";
        parameter Boolean startValue=false "Output before startTime";
        extends Interfaces.partialBooleanSource;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-70.0},{0.0,-70.0},{0.0,50.0},{80.0,50.0}}, color={0,0,0}),Text(extent={{-150.0,-140.0},{150.0,-110.0}}, fillColor={0,0,0}, textString="%startTime")}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-70.0},{0.0,-70.0},{0.0,50.0},{80.0,50.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-25.0,-76.0},{21.0,-94.0}}, textString="startTime", fillColor={0,0,0}),Polygon(points={{2.0,50.0},{-80.0,50.0},{2.0,50.0}}, lineColor={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-130.0,56.0},{-86.0,42.0}}, textString="not startValue", fillColor={0,0,0}),Text(extent={{-126.0,-64.0},{-94.0,-78.0}}, textString="startValue", fillColor={0,0,0})}));

      equation 
        y=if time >= startTime then not startValue else startValue;
      end BooleanStep;
      block BooleanPulse "Generate pulse signal of type Boolean"
              parameter Real width(final min=Modelica.Constants.small,final max=100)=50 "Width of pulse in % of period";
        parameter Modelica.SIunits.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
        parameter Modelica.SIunits.Time startTime=0 "Time instant of first pulse";
        extends Modelica.Blocks.Interfaces.partialBooleanSource;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-150.0,-140.0},{150.0,-110.0}}, fillColor={0,0,0}, textString="%period"),Line(points={{-80.0,-70.0},{-40.0,-70.0},{-40.0,44.0},{0.0,44.0},{0.0,-70.0},{40.0,-70.0},{40.0,44.0},{79.0,44.0}}, color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-60.0,-72.0},{-14.0,-90.0}}, textString="startTime", fillColor={0,0,0}),Line(points={{-78.0,-70.0},{-40.0,-70.0},{-40.0,20.0},{20.0,20.0},{20.0,-70.0},{50.0,-70.0},{50.0,20.0},{100.0,20.0}}, color={0,0,0}, thickness=0.5),Line(points={{-40.0,61.0},{-40.0,21.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{20.0,44.0},{20.0,20.0}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{50.0,58.0},{50.0,20.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-40.0,53.0},{50.0,53.0}}, color={192,192,192}),Line(points={{-40.0,35.0},{20.0,35.0}}, color={192,192,192}),Text(extent={{-30.0,67.0},{16.0,55.0}}, textString="period", fillColor={0,0,0}),Text(extent={{-35.0,49.0},{14.0,37.0}}, textString="width", fillColor={0,0,0}),Line(points={{-80.0,20.0},{-41.0,20.0}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{-40.0,35.0},{-31.0,37.0},{-31.0,33.0},{-40.0,35.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20.0,35.0},{12.0,37.0},{12.0,33.0},{20.0,35.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-40.0,53.0},{-31.0,55.0},{-31.0,51.0},{-40.0,53.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,53.0},{42.0,55.0},{42.0,51.0},{50.0,53.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-109.0,28.0},{-77.0,14.0}}, textString="true", fillColor={0,0,0}),Text(extent={{-101.0,-56.0},{-80.0,-71.0}}, textString="false", fillColor={0,0,0})}));
      protected 
        parameter Modelica.SIunits.Time Twidth=(period*width)/100 "width of one pulse" annotation(Hide=true);
        discrete Modelica.SIunits.Time pulsStart "Start time of pulse" annotation(Hide=true);

      initial equation 
        pulsStart=startTime;

      equation 
        when sample(startTime, period) then
                  pulsStart=time;
        
        end when;
        y=time >= pulsStart and time < pulsStart + Twidth;
      end BooleanPulse;
    end Sources;
    package Math "Mathematical functions as input/output blocks"
          import Modelica.SIunits;
      import Modelica.Blocks.Interfaces;
      extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="
 <HTML>
 <p>
 This package contains basic <b>mathematical operations</b>,
 such as summation and multiplication, and basic <b>mathematical
 functions</b>, such as <b>sqrt</b> and <b>sin</b>, as
 input/output blocks. All blocks of this library can be either
 connected with continuous blocks or with sampled-data blocks.
 In particular the following operations and functions are
 provided:
 </p>
 <pre>
    <b>TwoInputs</b>        Change causality of input signals.
    <b>TwoOutputs</b>       Change causality of output signals.
    <b>Gain</b>             Output the input multiplied by a scalar gain
    <b>MatrixGain</b>       Output the product of a gain matrix with the input
    <b>Sum</b>              Output the sum of the elements of the input vector
    <b>Feedback</b>         Output difference between commanded and feedback input
    <b>Add</b>              Output the sum of the two inputs
    <b>Add3</b>             Output the sum of the three inputs
    <b>Product</b>          Output product of the two inputs
    <b>Division</b>         Output first input divided by second input
    <b>Abs</b>              Output the absolute value of the input
    <b>Sign</b>             Output the sign of the input
    <b>Sqrt</b>             Output the square root of the input
    <b>Sin</b>              Output the sine of the input
    <b>Cos</b>              Output the cosine of the input
    <b>Tan</b>              Output the tangent of the input
    <b>Asin</b>             Output the arc sine of the input
    <b>Acos</b>             Output the arc cosine of the input
    <b>Atan</b>             Output the arc tangent of the input
    <b>Atan2</b>            Output atan(u1/u2) of the inputs u1 and u2
    <b>Sinh</b>             Output the hyperbolic sine of the input
    <b>Cosh</b>             Output the hyperbolic cosine of the input
    <b>Tanh</b>             Output the hyperbolic tangent of the input
    <b>Exp</b>              Output the exponential (base e) of the input
    <b>Log</b>              Output the natural (base e) logarithm of the input
    <b>Log10</b>            Output the base 10 logarithm of the input
    <b>RealToInteger</b>    Output the nearest Integer value to the input
    <b>IntegerToReal</b>    Output the input as Real value
    <b>RealToBoolean</b>    Convert Real to Boolean
    <b>BooleanToReal</b>    Convert Boolean to Real
    <b>IntegerToBoolean</b> Convert Integer to Boolean
    <b>BooleanToInteger</b> Convert Boolean to Integer
    <b>Min</b>              Output the minimum of the two inputs
    <b>Edge</b>             Set output to true at rising edge of the input
    <b>BooleanChange</b>    Set output to true when Boolean input changes
    <b>IntegerChange</b>    Set output to true when Integer input changes
 </pre>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        New blocks added: RealToInteger, IntegerToReal, Max, Min, Edge, BooleanChange, IntegerChange.
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized (partly based on an existing Dymola library
        of Dieter Moormann and Hilding Elmqvist).
 </li>
 </ul>
 </html"));
      block Gain "Output the product of a gain value with the input signal"
              parameter Real k=1 "Gain value multiplied with input signal";
      public 
        Interfaces.RealInput u "Input signal connector" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Interfaces.RealOutput y "Output signal connector" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="
 <HTML>
 <p>
 This block computes output <i>y</i> as
 <i>product</i> of gain <i>k</i> with the
 input <i>u</i>:
 </p>
 <pre>
     y = k * u;
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>October 20, 2004</i>
        by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Icon changed. Documentation corrected to scalar implementation.
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,-100.0},{-100.0,100.0},{100.0,0.0},{-100.0,-100.0}}, lineColor={0,0,191}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-150.0,-140.0},{150.0,-100.0}}, textString="k=%k", fillColor={0,0,0}),Text(extent={{-150.0,140.0},{150.0,100.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-100.0,-100.0},{-100.0,100.0},{100.0,0.0},{-100.0,-100.0}}, lineColor={0,0,191}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-76.0,38.0},{0.0,-34.0}}, textString="k", fillColor={0,0,255})}));

      equation 
        y=k*u;
      end Gain;
      block MatrixGain "Output the product of a gain matrix with the input signal vector"
              parameter Real K[:,:]={{1,0},{0,1}} "Gain matrix which is multiplied with the input";
        extends Interfaces.MIMO(final nin=size(K, 2),final nout=size(K, 1));
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes output vector <b>y</b> as <i>product</i> of the
 gain matrix <b>K</b> with the input signal vector <b>u</b>:
 </p>
 <pre>
     <b>y</b> = <b>K</b> * <b>u</b>;
 </pre>
 <p>
 Example:
 </p>
 <pre>
    parameter: <b>K</b> = [0.12 2; 3 1.5]
    results in the following equations:
      | y[1] |     | 0.12  2.00 |   | u[1] |
      |      |  =  |            | * |      |
      | y[2] |     | 3.00  1.50 |   | u[2] |
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,-60.0},{90.0,60.0}}, textString="*K", fillColor={160,160,160}),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-90.0,-60.0},{90.0,60.0}}, textString="*K", fillColor={160,160,160})}));

      equation 
        y=K*u;
      end MatrixGain;
      block Sum "Output the sum of the elements of the input vector"
              extends Interfaces.MISO;
        parameter Real k[nin]=ones(nin) "Optional: sum coefficients";
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes output <b>y</b> as
 <i>sum</i> of the elements of the input signal vector
 <b>u</b>:
 </p>
 <pre>
     <b>y</b> = <b>u</b>[1] + <b>u</b>[2] + ...;
 </pre>
 <p>
 Example:
 </p>
 <pre>
      parameter:   nin = 3;
   results in the following equations:
      y = u[1] + u[2] + u[3];
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Oct. 24, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{26.0,42.0},{-34.0,42.0},{6.0,2.0},{-34.0,-38.0},{26.0,-38.0}}, color={0,0,0}, thickness=0.25),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{26.0,42.0},{-34.0,42.0},{6.0,2.0},{-34.0,-38.0},{26.0,-38.0}}, color={0,0,0}, thickness=0.25)}));

      equation 
        y=k*u;
      end Sum;
      block Feedback "Output difference between commanded and feedback input"
              input Interfaces.RealInput u1 annotation(Placement(transformation(x=-80.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-80.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        input Interfaces.RealInput u2 annotation(Placement(transformation(x=0.0,y=-80.0,scale=0.2,aspectRatio=1.0,rotation=90),iconTransformation(x=0.0,y=-80.0,scale=0.2,aspectRatio=1.0,rotation=90)));
        output Interfaces.RealOutput y annotation(Placement(transformation(x=90.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=90.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes output <b>y</b> as <i>difference</i> of the
 commanded input <b>u1</b> and the feedback
 input <b>u2</b>:
 </p>
 <pre>
     <b>y</b> = <b>u1</b> - <b>u2</b>;
 </pre>
 <p>
 Example:
 </p>
 <pre>
      parameter:   n = 2
   results in the following equations:
      y = u1 - u2
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-20.0,20.0},{20.0,-20.0}}, lineColor={0,0,191}, fillColor={235,235,235}, fillPattern=FillPattern.Solid),Line(points={{-60.0,0.0},{-20.0,0.0}}, color={0,0,191}),Line(points={{20.0,0.0},{80.0,0.0}}, color={0,0,191}),Line(points={{0.0,-20.0},{0.0,-60.0}}, color={0,0,191}),Text(extent={{-14.0,0.0},{82.0,-94.0}}, textString="-", fillColor={0,0,0}),Text(extent={{-100.0,110.0},{100.0,60.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-20.0,20.0},{20.0,-20.0}}, pattern=LinePattern.Solid, lineThickness=0.25, fillColor={235,235,235}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{-60.0,0.0},{-20.0,0.0}}, color={0,0,255}),Line(points={{20.0,0.0},{80.0,0.0}}, color={0,0,255}),Line(points={{0.0,-20.0},{0.0,-60.0}}, color={0,0,255}),Text(extent={{-12.0,10.0},{84.0,-84.0}}, textString="-", fillColor={0,0,0})}));

      equation 
        y=u1 - u2;
      end Feedback;
      block Add "Output the sum of the two inputs"
              extends Interfaces.SI2SO;
        parameter Real k1=1 "Gain of upper input";
        parameter Real k2=1 "Gain of lower input";
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes output <b>y</b> as <i>sum</i> of the
 two input signals <b>u1</b> and <b>u2</b>:
 </p>
 <pre>
     <b>y</b> = k1*<b>u1</b> + k2*<b>u2</b>;
 </pre>
 <p>
 Example:
 </p>
 <pre>
      parameter:   k1= +2, k2= -3
   results in the following equations:
      y = 2 * u1 - 3 * u2
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-98.0,-52.0},{7.0,-92.0}}, textString="%k2", fillColor={0,0,0}),Text(extent={{-100.0,90.0},{5.0,50.0}}, textString="%k1", fillColor={0,0,0}),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255}),Line(points={{-100.0,60.0},{-40.0,60.0},{-30.0,40.0}}, color={0,0,255}),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,255}),Line(points={{-100.0,-60.0},{-40.0,-60.0},{-30.0,-40.0}}, color={0,0,255}),Line(points={{-15.0,-25.99},{15.0,25.99}}, color={0,0,0}),Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,191}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-100.0,60.0},{-74.0,24.0},{-44.0,24.0}}, color={0,0,191}),Line(points={{-100.0,-60.0},{-74.0,-28.0},{-42.0,-28.0}}, color={0,0,191}),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,191}),Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,191}),Text(extent={{-38.0,34.0},{38.0,-34.0}}, textString="+", fillColor={0,0,0}),Text(extent={{-100.0,52.0},{5.0,92.0}}, textString="%k1", fillColor={0,0,0}),Text(extent={{-100.0,-52.0},{5.0,-92.0}}, textString="%k2", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-98.0,-52.0},{7.0,-92.0}}, textString="%k2", fillColor={0,0,0}),Text(extent={{-100.0,90.0},{5.0,50.0}}, textString="%k1", fillColor={0,0,0}),Line(points={{-100.0,60.0},{-40.0,60.0},{-30.0,40.0}}, color={0,0,255}),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,255}),Line(points={{-100.0,-60.0},{-40.0,-60.0},{-30.0,-40.0}}, color={0,0,255}),Line(points={{-15.0,-25.99},{15.0,25.99}}, color={0,0,0}),Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,191}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-100.0,60.0},{-74.0,24.0},{-44.0,24.0}}, color={0,0,191}),Line(points={{-100.0,-60.0},{-74.0,-28.0},{-42.0,-28.0}}, color={0,0,191}),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,191}),Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,191}),Text(extent={{-38.0,34.0},{38.0,-34.0}}, textString="+", fillColor={0,0,0}),Text(extent={{-100.0,52.0},{5.0,92.0}}, textString="k1", fillColor={0,0,0}),Text(extent={{-100.0,-52.0},{5.0,-92.0}}, textString="k2", fillColor={0,0,0})}));

      equation 
        y=k1*u1 + k2*u2;
      end Add;
      block Add3 "Output the sum of the three inputs"
              extends Interfaces.BlockIcon;
        parameter Real k1=1 "Gain of upper input";
        parameter Real k2=1 "Gain of middle input";
        parameter Real k3=1 "Gain of lower input";
        input Interfaces.RealInput u1 "Connector 1 of Real input signals" annotation(Placement(transformation(x=-120.0,y=80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=80.0,scale=0.2,aspectRatio=1.0)));
        input Interfaces.RealInput u2 "Connector 2 of Real input signals" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        input Interfaces.RealInput u3 "Connector 3 of Real input signals" annotation(Placement(transformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0)));
        output Interfaces.RealOutput y "Connector of Real output signals" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes output <b>y</b> as <i>sum</i> of the
 three input signals <b>u1</b>, <b>u2</b> and <b>u3</b>:
 </p>
 <pre>
     <b>y</b> = k1*<b>u1</b> + k2*<b>u2</b> + k3*<b>u3</b>;
 </pre>
 <p>
 Example:
 </p>
 <pre>
      parameter:   k1= +2, k2= -3, k3=1;
   results in the following equations:
      y = 2 * u1 - 3 * u2 + u3;
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,50.0},{5.0,90.0}}, textString="%k1", fillColor={0,0,0}),Text(extent={{-100.0,-20.0},{5.0,20.0}}, textString="%k2", fillColor={0,0,0}),Text(extent={{-100.0,-50.0},{5.0,-90.0}}, textString="%k3", fillColor={0,0,0}),Text(extent={{2.0,36.0},{100.0,-44.0}}, textString="+", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,50.0},{5.0,90.0}}, textString="%k1", fillColor={0,0,0}),Text(extent={{-100.0,-20.0},{5.0,20.0}}, textString="%k2", fillColor={0,0,0}),Text(extent={{-100.0,-50.0},{5.0,-90.0}}, textString="%k3", fillColor={0,0,0}),Text(extent={{2.0,36.0},{100.0,-44.0}}, textString="+", fillColor={0,0,0}),Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Text(extent={{-100.0,50.0},{5.0,90.0}}, textString="k1", fillColor={0,0,0}),Text(extent={{-100.0,-20.0},{5.0,20.0}}, textString="k2", fillColor={0,0,0}),Text(extent={{-100.0,-50.0},{5.0,-90.0}}, textString="k3", fillColor={0,0,0}),Text(extent={{2.0,36.0},{100.0,-44.0}}, textString="+", fillColor={0,0,0})}));

      equation 
        y=k1*u1 + k2*u2 + k3*u3;
      end Add3;
      block Product "Output product of the two inputs"
              extends Interfaces.SI2SO;
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise)
 as <i>product</i> of the corresponding elements of
 the two inputs <b>u1</b> and <b>u2</b>:
 </p>
 <pre>
     y = u1 * u2;
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,60.0},{-40.0,60.0},{-30.0,40.0}}, color={0,0,191}),Line(points={{-100.0,-60.0},{-40.0,-60.0},{-30.0,-40.0}}, color={0,0,191}),Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,191}),Line(points={{-30.0,0.0},{30.0,0.0}}, color={0,0,0}),Line(points={{-15.0,25.99},{15.0,-25.99}}, color={0,0,0}),Line(points={{-15.0,-25.99},{15.0,25.99}}, color={0,0,0}),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,191})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-100.0,60.0},{-40.0,60.0},{-30.0,40.0}}, color={0,0,255}),Line(points={{-100.0,-60.0},{-40.0,-60.0},{-30.0,-40.0}}, color={0,0,255}),Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-30.0,0.0},{30.0,0.0}}, color={0,0,0}),Line(points={{-15.0,25.99},{15.0,-25.99}}, color={0,0,0}),Line(points={{-15.0,-25.99},{15.0,25.99}}, color={0,0,0}),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,255})}));

      equation 
        y=u1*u2;
      end Product;
      block Division "Output first input divided by second input"
              extends Interfaces.SI2SO;
        annotation(Documentation(info="
 <HTML>
 <p>
 This block computes the output <b>y</b> (element-wise)
 by <i>dividing</i> the corresponding elements of
 the two inputs <b>u1</b> and <b>u2</b>:
 </p>
 <pre>
     y = u1 / u2;
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,191}),Line(points={{-30.0,0.0},{30.0,0.0}}, color={0,0,0}),Ellipse(extent={{-5.0,20.0},{5.0,30.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Ellipse(extent={{-5.0,-20.0},{5.0,-30.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,191}),Text(extent={{-150.0,150.0},{150.0,110.0}}, textString="%name", fillColor={0,0,255}),Line(points={{-100.0,60.0},{-66.0,60.0},{-40.0,30.0}}, color={0,0,191}),Line(points={{-100.0,-60.0},{0.0,-60.0},{0.0,-50.0}}, color={0,0,191})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-100.0,-100.0},{100.0,100.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{50.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-30.0,0.0},{30.0,0.0}}, color={0,0,0}),Ellipse(extent={{-5.0,20.0},{5.0,30.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Ellipse(extent={{-5.0,-20.0},{5.0,-30.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,255}),Line(points={{-100.0,60.0},{-66.0,60.0},{-40.0,30.0}}, color={0,0,255}),Line(points={{-100.0,-60.0},{0.0,-60.0},{0.0,-50.0}}, color={0,0,255})}));

      equation 
        y=u1/u2;
      end Division;
      block Abs "Output the absolute value of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{92.0,0.0},{70.0,8.0},{70.0,-8.0},{92.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{0.0,0.0},{80.0,80.0}}, color={0,0,0}),Line(points={{0.0,-14.0},{0.0,68.0}}, color={192,192,192}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-34.0,-28.0},{38.0,-76.0}}, textString="abs", fillColor={192,192,192}),Line(points={{-88.0,0.0},{76.0,0.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,0.0},{76.0,0.0}}, color={192,192,192}),Polygon(points={{92.0,0.0},{76.0,6.0},{76.0,-6.0},{92.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{0.0,0.0},{80.0,80.0}}, color={0,0,0}),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{7.0,98.0},{34.0,78.0}}, textString="u", fillColor={160,160,160}),Text(extent={{74.0,-8.0},{96.0,-28.0}}, textString="y", fillColor={160,160,160}),Text(extent={{52.0,-3.0},{72.0,-23.0}}, textString="1", fillColor={0,0,255}),Text(extent={{-86.0,-1.0},{-66.0,-21.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{-28.0,79.0},{-8.0,59.0}}, textString="1", fillColor={0,0,255})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise)
 as <i>absolute value</i> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>abs</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=abs(u);
      end Abs;
      block Sign "Output the sign of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{0.0,-80.0}}, color={0,0,0}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Text(extent={{-90.0,72.0},{-18.0,24.0}}, textString="sign", fillColor={192,192,192}),Line(points={{0.0,80.0},{80.0,80.0}}, color={0,0,0}),Rectangle(extent={{-2.0,2.0},{2.0,-4.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{0.0,-80.0}}, color={0,0,0}),Line(points={{-0.01,0.0},{0.01,0.0}}, color={0,0,0}),Line(points={{0.0,80.0},{80.0,80.0}}, color={0,0,0}),Rectangle(extent={{-2.0,2.0},{2.0,-4.0}}, lineColor={0,0,0}, fillColor={0,0,0}, fillPattern=FillPattern.Solid),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{7.0,102.0},{32.0,82.0}}, textString="y", fillColor={160,160,160}),Text(extent={{70.0,-6.0},{94.0,-26.0}}, textString="u", fillColor={160,160,160}),Text(extent={{-25.0,86.0},{-5.0,70.0}}, textString="1", fillColor={0,0,255}),Text(extent={{5.0,-72.0},{25.0,-88.0}}, textString="-1", fillColor={0,0,255})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise)
 as <b>sign</b> of the input <b>u</b>:
 </p>
 <pre>
          1  <b>if</b> u > 0
     y =  0  <b>if</b> u == 0
         -1  <b>if</b> u < 0
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=sign(u);
      end Sign;
      block Sqrt "Output the square root of the input (input >= 0 required)"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,-80.0},{68.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-68.7},{-78.4,-64.0},{-76.8,-57.3},{-73.6,-47.9},{-67.9,-36.1},{-59.1,-22.2},{-46.2,-6.49},{-28.5,10.7},{-4.42,30.0},{27.7,51.3},{69.5,74.7},{80.0,80.0}}, color={0,0,0}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-88.0},{-80.0,68.0}}, color={192,192,192}),Text(extent={{-8.0,-4.0},{64.0,-52.0}}, textString="sqrt", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-92.0,-80.0},{84.0,-80.0}}, color={192,192,192}),Polygon(points={{100.0,-80.0},{84.0,-74.0},{84.0,-86.0},{100.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-68.7},{-78.4,-64.0},{-76.8,-57.3},{-73.6,-47.9},{-67.9,-36.1},{-59.1,-22.2},{-46.2,-6.49},{-28.5,10.7},{-4.42,30.0},{27.7,51.3},{69.5,74.7},{80.0,80.0}}, color={0,0,0}),Polygon(points={{-80.0,98.0},{-86.0,82.0},{-74.0,82.0},{-80.0,98.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Text(extent={{-71.0,98.0},{-44.0,78.0}}, textString="y", fillColor={160,160,160}),Text(extent={{60.0,-52.0},{84.0,-72.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise)
 as <i>square root</i> of the input <b>u</b>:
 </p>
 <pre>
     y = sqrt( u );
 </pre>
 <p>
 All elements of the input vector shall be zero or positive.
 Otherwise an error occurs.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=sqrt(u);
      end Sqrt;
      block Sin "Output the sine of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,68.0}}, color={192,192,192}),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Line(points={{-80.0,0.0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,-64.2},{29.3,-73.1},{35.0,-78.4},{40.6,-80.0},{46.2,-77.6},{51.9,-71.5},{57.5,-61.9},{63.9,-47.2},{72.0,-24.8},{80.0,0.0}}, color={0,0,0}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{12.0,84.0},{84.0,36.0}}, textString="sin", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,80.0},{-88.0,80.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-88.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Text(extent={{-75.0,98.0},{-46.0,78.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{-80.0,96.0},{-86.0,80.0},{-74.0,80.0},{-80.0,96.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,0.0},{-68.7,34.2},{-61.5,53.1},{-55.1,66.4},{-49.4,74.6},{-43.8,79.1},{-38.2,79.8},{-32.6,76.6},{-26.9,69.7},{-21.3,59.4},{-14.9,44.1},{-6.83,21.2},{10.1,-30.8},{17.3,-50.2},{23.7,-64.2},{29.3,-73.1},{35.0,-78.4},{40.6,-80.0},{46.2,-77.6},{51.9,-71.5},{57.5,-61.9},{63.9,-47.2},{72.0,-24.8},{80.0,0.0}}, color={0,0,0}),Text(extent={{-105.0,72.0},{-85.0,88.0}}, textString="1", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="2*pi", fillColor={0,0,255}),Text(extent={{-105.0,-72.0},{-85.0,-88.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{76.0,-10.0},{98.0,-30.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise)
 as <b>sine</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>sin</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.sin(u);
      end Sin;
      block Cos "Output the cosine of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,68.0}}, color={192,192,192}),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-74.4,78.1},{-68.7,72.3},{-63.1,63.0},{-56.7,48.7},{-48.6,26.6},{-29.3,-32.5},{-22.1,-51.7},{-15.7,-65.3},{-10.1,-73.8},{-4.42,-78.8},{1.21,-79.9},{6.83,-77.1},{12.5,-70.6},{18.1,-60.6},{24.5,-45.7},{32.6,-23.0},{50.3,31.3},{57.5,50.7},{63.9,64.6},{69.5,73.4},{75.2,78.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-36.0,82.0},{36.0,34.0}}, textString="cos", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,80.0},{-88.0,80.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-88.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Text(extent={{-75.0,102.0},{-48.0,82.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-103.0,72.0},{-83.0,88.0}}, textString="1", fillColor={0,0,255}),Text(extent={{-79.0,-72.0},{-59.0,-88.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="2*pi", fillColor={0,0,255}),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-74.4,78.1},{-68.7,72.3},{-63.1,63.0},{-56.7,48.7},{-48.6,26.6},{-29.3,-32.5},{-22.1,-51.7},{-15.7,-65.3},{-10.1,-73.8},{-4.42,-78.8},{1.21,-79.9},{6.83,-77.1},{12.5,-70.6},{18.1,-60.6},{24.5,-45.7},{32.6,-23.0},{50.3,31.3},{57.5,50.7},{63.9,64.6},{69.5,73.4},{75.2,78.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{74.0,-4.0},{98.0,-24.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise)
 as <b>cos</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>cos</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.cos(u);
      end Cos;
      block Tan "Output the tangent of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-78.4,-68.4},{-76.8,-59.7},{-74.4,-50.0},{-71.2,-40.9},{-67.1,-33.0},{-60.7,-24.8},{-51.1,-17.2},{-35.8,-9.98},{-4.42,-1.07},{33.4,9.12},{49.4,16.2},{59.1,23.2},{65.5,30.6},{70.4,39.1},{73.6,47.4},{76.0,56.1},{77.6,63.8},{80.0,80.0}}, color={0,0,0}),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-90.0,72.0},{-18.0,24.0}}, textString="tan", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-88.0},{0.0,86.0}}, color={192,192,192}),Text(extent={{11.0,100.0},{38.0,80.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,102.0},{-6.0,86.0},{6.0,86.0},{0.0,102.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-37.0,-72.0},{-17.0,-88.0}}, textString="-5.8", fillColor={0,0,255}),Text(extent={{-33.0,86.0},{-13.0,70.0}}, textString=" 5.8", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="1.4", fillColor={0,0,255}),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-78.4,-68.4},{-76.8,-59.7},{-74.4,-50.0},{-71.2,-40.9},{-67.1,-33.0},{-60.7,-24.8},{-51.1,-17.2},{-35.8,-9.98},{-4.42,-1.07},{33.4,9.12},{49.4,16.2},{59.1,23.2},{65.5,30.6},{70.4,39.1},{73.6,47.4},{76.0,56.1},{77.6,63.8},{80.0,80.0}}, color={0,0,0}),Text(extent={{70.0,-6.0},{94.0,-26.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise)
 as <b>tan</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>tan</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.tan(u);
      end Tan;
      block Asin "Output the arc sine of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-79.2,-72.8},{-77.6,-67.5},{-73.6,-59.4},{-66.3,-49.8},{-53.5,-37.3},{-30.2,-19.7},{37.4,24.8},{57.5,40.8},{68.7,52.7},{75.2,62.2},{77.6,67.5},{80.0,80.0}}, color={0,0,0}),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-88.0,78.0},{-16.0,30.0}}, textString="asin", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{9.0,102.0},{36.0,82.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-40.0,-72.0},{-15.0,-88.0}}, textString="-pi/2", fillColor={0,0,255}),Text(extent={{-38.0,88.0},{-13.0,72.0}}, textString=" pi/2", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="+1", fillColor={0,0,255}),Text(extent={{-90.0,21.0},{-70.0,1.0}}, textString="-1", fillColor={0,0,255}),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-72.8},{-77.6,-67.5},{-73.6,-59.4},{-66.3,-49.8},{-53.5,-37.3},{-30.2,-19.7},{37.4,24.8},{57.5,40.8},{68.7,52.7},{75.2,62.2},{77.6,67.5},{80.0,80.0}}, color={0,0,0}),Text(extent={{74.0,-4.0},{100.0,-26.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>sine-inverse</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>asin</b>( u );
 </pre>
 <p>
 The absolute values of the elements of the input <b>u</b> need to
 be less or equal to one (<b>abs</b>( u ) <= 1).
 Otherwise an error occurs.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.asin(u);
      end Asin;
      block Acos "Output the arc cosine of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-79.2,72.8},{-77.6,67.5},{-73.6,59.4},{-66.3,49.8},{-53.5,37.3},{-30.2,19.7},{37.4,-24.8},{57.5,-40.8},{68.7,-52.7},{75.2,-62.2},{77.6,-67.5},{80.0,-80.0}}, color={0,0,0}),Line(points={{0.0,-88.0},{0.0,68.0}}, color={192,192,192}),Line(points={{-90.0,-80.0},{68.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-86.0,-14.0},{-14.0,-62.0}}, textString="acos", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{13.0,100.0},{42.0,82.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,-80.0},{84.0,-80.0}}, color={192,192,192}),Polygon(points={{100.0,-80.0},{84.0,-74.0},{84.0,-86.0},{100.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-79.2,72.8},{-77.6,67.5},{-73.6,59.4},{-66.3,49.8},{-53.5,37.3},{-30.2,19.7},{37.4,-24.8},{57.5,-40.8},{68.7,-52.7},{75.2,-62.2},{77.6,-67.5},{80.0,-80.0}}, color={0,0,0}),Text(extent={{-30.0,88.0},{-5.0,72.0}}, textString=" pi", fillColor={0,0,255}),Text(extent={{-94.0,-57.0},{-74.0,-77.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{80.0,-45.0},{100.0,-65.0}}, textString="+1", fillColor={0,0,255}),Text(extent={{76.0,-84.0},{102.0,-102.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>cosine-inverse</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>acos</b>( u );
 </pre>
 <p>
 The absolute values of the elements of the input <b>u</b> need to
 be less or equal to one (<b>abs</b>( u ) <= 1).
 Otherwise an error occurs.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.acos(u);
      end Acos;
      block Atan "Output the arc tangent of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-52.7,-75.2},{-37.4,-69.7},{-26.9,-63.0},{-19.7,-55.2},{-14.1,-45.8},{-10.1,-36.4},{-6.03,-23.9},{-1.21,-5.06},{5.23,21.0},{9.25,34.1},{13.3,44.2},{18.1,52.9},{24.5,60.8},{33.4,67.6},{47.0,73.6},{69.5,78.6},{80.0,80.0}}, color={0,0,0}),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-86.0,68.0},{-14.0,20.0}}, textString="atan", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{13.0,102.0},{42.0,82.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-52.7,-75.2},{-37.4,-69.7},{-26.9,-63.0},{-19.7,-55.2},{-14.1,-45.8},{-10.1,-36.4},{-6.03,-23.9},{-1.21,-5.06},{5.23,21.0},{9.25,34.1},{13.3,44.2},{18.1,52.9},{24.5,60.8},{33.4,67.6},{47.0,73.6},{69.5,78.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-32.0,91.0},{-12.0,71.0}}, textString="1.4", fillColor={0,0,255}),Text(extent={{-32.0,-71.0},{-12.0,-91.0}}, textString="-1.4", fillColor={0,0,255}),Text(extent={{73.0,26.0},{93.0,10.0}}, textString=" 5.8", fillColor={0,0,255}),Text(extent={{-103.0,20.0},{-83.0,4.0}}, textString="-5.8", fillColor={0,0,255}),Text(extent={{66.0,-8.0},{94.0,-28.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>tangent-inverse</b> of the input <b>u</b>:
 </p>
 <pre>
     y= <b>atan</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.atan(u);
      end Atan;
      block Sinh "Output the hyperbolic sine of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-86.0,80.0},{-14.0,32.0}}, textString="sinh", fillColor={192,192,192}),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-76.0,-65.4},{-71.2,-51.4},{-65.5,-38.8},{-59.1,-28.1},{-51.1,-18.7},{-41.4,-11.4},{-27.7,-5.5},{-4.42,-0.653},{24.5,4.57},{39.0,10.1},{49.4,17.2},{57.5,25.9},{63.9,35.8},{69.5,47.4},{74.4,60.4},{78.4,73.8},{80.0,80.0}}, color={0,0,0}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{9.0,98.0},{34.0,78.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-76.0,-65.4},{-71.2,-51.4},{-65.5,-38.8},{-59.1,-28.1},{-51.1,-18.7},{-41.4,-11.4},{-27.7,-5.5},{-4.42,-0.653},{24.5,4.57},{39.0,10.1},{49.4,17.2},{57.5,25.9},{63.9,35.8},{69.5,47.4},{74.4,60.4},{78.4,73.8},{80.0,80.0}}, color={0,0,0}),Text(extent={{-31.0,72.0},{-11.0,88.0}}, textString="27", fillColor={0,0,255}),Text(extent={{-35.0,-88.0},{-15.0,-72.0}}, textString="-27", fillColor={0,0,255}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="4", fillColor={0,0,255}),Text(extent={{-98.0,21.0},{-78.0,1.0}}, textString="-4", fillColor={0,0,255}),Text(extent={{72.0,-6.0},{96.0,-26.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>hyperbolic sine</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>sinh</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.sinh(u);
      end Sinh;
      block Cosh "Output the hyperbolic cosine of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Text(extent={{4.0,66.0},{66.0,20.0}}, textString="cosh", fillColor={192,192,192}),Line(points={{-80.0,80.0},{-77.6,61.1},{-74.4,39.3},{-71.2,20.7},{-67.1,1.29},{-63.1,-14.6},{-58.3,-29.8},{-52.7,-43.5},{-46.2,-55.1},{-39.0,-64.3},{-30.2,-71.7},{-18.9,-77.1},{-4.42,-79.9},{10.9,-79.1},{23.7,-75.2},{34.2,-68.7},{42.2,-60.6},{48.6,-51.2},{54.3,-40.0},{59.1,-27.5},{63.1,-14.6},{67.1,1.29},{71.2,20.7},{74.4,39.3},{77.6,61.1},{80.0,80.0}}, color={0,0,0}),Line(points={{-90.0,-86.083},{68.0,-86.083}}, color={192,192,192}),Polygon(points={{90.0,-86.083},{68.0,-78.083},{68.0,-94.083},{90.0,-86.083}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{11.0,98.0},{38.0,78.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,-86.083},{84.0,-86.083}}, color={192,192,192}),Polygon(points={{100.0,-86.083},{84.0,-80.083},{84.0,-92.083},{100.0,-86.083}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,80.0},{-77.6,61.1},{-74.4,39.3},{-71.2,20.7},{-67.1,1.29},{-63.1,-14.6},{-58.3,-29.8},{-52.7,-43.5},{-46.2,-55.1},{-39.0,-64.3},{-30.2,-71.7},{-18.9,-77.1},{-4.42,-79.9},{10.9,-79.1},{23.7,-75.2},{34.2,-68.7},{42.2,-60.6},{48.6,-51.2},{54.3,-40.0},{59.1,-27.5},{63.1,-14.6},{67.1,1.29},{71.2,20.7},{74.4,39.3},{77.6,61.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{-31.0,72.0},{-11.0,88.0}}, textString="27", fillColor={0,0,255}),Text(extent={{62.0,-67.0},{82.0,-87.0}}, textString="4", fillColor={0,0,255}),Text(extent={{-104.0,-63.0},{-84.0,-83.0}}, textString="-4", fillColor={0,0,255}),Text(extent={{78.0,-54.0},{100.0,-74.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>hyperbolic cosine</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>cosh</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.cosh(u);
      end Cosh;
      block Tanh "Output the hyperbolic tangent of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-47.8,-78.7},{-35.8,-75.7},{-27.7,-70.6},{-22.1,-64.2},{-17.3,-55.9},{-12.5,-44.3},{-7.64,-29.2},{-1.21,-4.82},{6.83,26.3},{11.7,42.0},{16.5,54.2},{21.3,63.1},{26.9,69.9},{34.2,75.0},{45.4,78.4},{72.0,79.9},{80.0,80.0}}, color={0,0,0}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-88.0,72.0},{-16.0,24.0}}, textString="tanh", fillColor={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{9.0,98.0},{42.0,80.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-47.8,-78.7},{-35.8,-75.7},{-27.7,-70.6},{-22.1,-64.2},{-17.3,-55.9},{-12.5,-44.3},{-7.64,-29.2},{-1.21,-4.82},{6.83,26.3},{11.7,42.0},{16.5,54.2},{21.3,63.1},{26.9,69.9},{34.2,75.0},{45.4,78.4},{72.0,79.9},{80.0,80.0}}, color={0,0,0}),Text(extent={{70.0,25.0},{90.0,5.0}}, textString="4", fillColor={0,0,255}),Text(extent={{-106.0,21.0},{-86.0,1.0}}, textString="-4", fillColor={0,0,255}),Text(extent={{-29.0,72.0},{-9.0,88.0}}, textString="1", fillColor={0,0,255}),Text(extent={{3.0,-72.0},{23.0,-88.0}}, textString="-1", fillColor={0,0,255}),Text(extent={{72.0,-8.0},{98.0,-26.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>hyperbolic tangent</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>tanh</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.tanh(u);
      end Tanh;
      block Exp "Output the exponential (base e) of the input"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,-80.0},{0.0,68.0}}, color={192,192,192}),Polygon(points={{0.0,90.0},{-8.0,68.0},{8.0,68.0},{0.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-86.0,50.0},{-14.0,2.0}}, textString="exp", fillColor={192,192,192}),Line(points={{-80.0,-80.0},{-31.0,-77.9},{-6.03,-74.0},{10.9,-68.4},{23.7,-61.0},{34.2,-51.6},{43.0,-40.3},{50.3,-27.8},{56.7,-13.5},{62.3,2.23},{67.1,18.6},{72.0,38.2},{76.0,57.6},{80.0,80.0}}, color={0,0,0}),Line(points={{-90.0,-80.3976},{68.0,-80.3976}}, color={192,192,192}),Polygon(points={{90.0,-80.3976},{68.0,-72.3976},{68.0,-88.3976},{90.0,-80.3976}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{0.0,80.0},{-8.0,80.0}}, color={192,192,192}),Line(points={{0.0,-80.0},{-8.0,-80.0}}, color={192,192,192}),Line(points={{0.0,-90.0},{0.0,84.0}}, color={192,192,192}),Text(extent={{9.0,100.0},{40.0,80.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{0.0,100.0},{-6.0,84.0},{6.0,84.0},{0.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,-80.3976},{84.0,-80.3976}}, color={192,192,192}),Polygon(points={{100.0,-80.3976},{84.0,-74.3976},{84.0,-86.3976},{100.0,-80.3976}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-31.0,-77.9},{-6.03,-74.0},{10.9,-68.4},{23.7,-61.0},{34.2,-51.6},{43.0,-40.3},{50.3,-27.8},{56.7,-13.5},{62.3,2.23},{67.1,18.6},{72.0,38.2},{76.0,57.6},{80.0,80.0}}, color={0,0,0}),Text(extent={{-31.0,72.0},{-11.0,88.0}}, textString="20", fillColor={0,0,255}),Text(extent={{-92.0,-83.0},{-72.0,-103.0}}, textString="-3", fillColor={0,0,255}),Text(extent={{70.0,-83.0},{90.0,-103.0}}, textString="3", fillColor={0,0,255}),Text(extent={{-18.0,-53.0},{2.0,-73.0}}, textString="1", fillColor={0,0,255}),Text(extent={{66.0,-52.0},{96.0,-72.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>exponential</b> (of base e) of the input <b>u</b>:
 </p>
 <pre>
     y = <b>exp</b>( u );
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.exp(u);
      end Exp;
      block Log "Output the natural (base e) logarithm of the input (input > 0 required)"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-80.0},{-80.0,68.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-6.0,-24.0},{66.0,-72.0}}, textString="log", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,80.0},{-88.0,80.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-88.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Text(extent={{-67.0,98.0},{-40.0,80.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{-105.0,72.0},{-85.0,88.0}}, textString="3", fillColor={0,0,255}),Text(extent={{-109.0,-88.0},{-89.0,-72.0}}, textString="-3", fillColor={0,0,255}),Text(extent={{70.0,-3.0},{90.0,-23.0}}, textString="20", fillColor={0,0,255}),Text(extent={{-78.0,-1.0},{-58.0,-21.0}}, textString="1", fillColor={0,0,255}),Text(extent={{68.0,28.0},{94.0,8.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>natural (base e) logarithm</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>log</b>( u );
 </pre>
 <p>
 An error occurs if the elements of the input <b>u</b> are
 zero or negative.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.log(u);
      end Log;
      block Log10 "Output the base 10 logarithm of the input (input > 0 required)"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{90.0,0.0},{68.0,8.0},{68.0,-8.0},{90.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{68.0,0.0}}, color={192,192,192}),Line(points={{-79.8,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,68.0}}, color={192,192,192}),Text(extent={{-30.0,-22.0},{60.0,-70.0}}, textString="log10", fillColor={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,80.0},{-88.0,80.0}}, color={192,192,192}),Line(points={{-80.0,-80.0},{-88.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Text(extent={{-65.0,96.0},{-38.0,78.0}}, textString="y", fillColor={160,160,160}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{84.0,0.0}}, color={192,192,192}),Polygon(points={{100.0,0.0},{84.0,6.0},{84.0,-6.0},{100.0,0.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-79.8,-80.0},{-79.2,-50.6},{-78.4,-37.0},{-77.6,-28.0},{-76.8,-21.3},{-75.2,-11.4},{-72.8,-1.31},{-69.5,8.08},{-64.7,17.9},{-57.5,28.0},{-47.0,38.1},{-31.8,48.1},{-10.1,58.0},{22.1,68.0},{68.7,78.1},{80.0,80.0}}, color={0,0,0}),Text(extent={{70.0,-3.0},{90.0,-23.0}}, textString="20", fillColor={0,0,255}),Text(extent={{-78.0,-1.0},{-58.0,-21.0}}, textString="1", fillColor={0,0,255}),Text(extent={{-109.0,72.0},{-89.0,88.0}}, textString=" 1.3", fillColor={0,0,255}),Text(extent={{-109.0,-88.0},{-89.0,-72.0}}, textString="-1.3", fillColor={0,0,255}),Text(extent={{62.0,30.0},{90.0,10.0}}, textString="u", fillColor={160,160,160})}),Documentation(info="
 <HTML>
 <p>
 This blocks computes the output <b>y</b> (element-wise) as the
 <i>base 10 logarithm</b> of the input <b>u</b>:
 </p>
 <pre>
     y = <b>log10</b>( u );
 </pre>
 <p>
 An error occurs if the elements of the input <b>u</b> are
 zero or negative.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 </HTML>
 "));

      equation 
        y=Modelica.Math.log10(u);
      end Log10;
      block BooleanToReal "Convert Boolean to Real signal"
              extends Interfaces.partialBooleanSI;
        parameter Real realTrue=1.0 "Output signal for true Boolean input";
        parameter Real realFalse=0.0 "Output signal for false Boolean input";
        Blocks.Interfaces.RealOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info=""),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-86.0,92.0},{-6.0,10.0}}, textString="B", fillColor={255,0,255}),Polygon(points={{-12.0,-46.0},{-32.0,-26.0},{-32.0,-36.0},{-64.0,-36.0},{-64.0,-56.0},{-32.0,-56.0},{-32.0,-66.0},{-12.0,-46.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Text(extent={{8.0,-4.0},{92.0,-94.0}}, textString="R", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=if u then realTrue else realFalse;
      end BooleanToReal;
      block RealToBoolean "Convert Real to Boolean signal"
              extends Interfaces.partialBooleanSO;
        parameter Real threshold=0.5 "Output signal y is true, if input u >= threshold";
        Blocks.Interfaces.RealInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        annotation(Documentation(info=""),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-86.0,92.0},{-6.0,10.0}}, textString="R", fillColor={0,0,255}),Polygon(points={{-12.0,-46.0},{-32.0,-26.0},{-32.0,-36.0},{-64.0,-36.0},{-64.0,-56.0},{-32.0,-56.0},{-32.0,-66.0},{-12.0,-46.0}}, lineColor={255,0,255}, fillColor={255,0,255}, fillPattern=FillPattern.Solid),Text(extent={{8.0,-4.0},{92.0,-94.0}}, textString="B", fillColor={255,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=u >= threshold;
      end RealToBoolean;
      block Max "Pass through the largest signal"
              extends Interfaces.SI2SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,36.0},{90.0,-36.0}}, fillColor={160,160,160}, textString="max()")}),Documentation(info="<html>
 <p>
 This block computes the output <b>y</b> as <i>maximum</i>
 of the two inputs <b>u1</b> and <b>u2</b>:
 </p>
 <pre>    y = <b>max</b> ( u1 , u2 );
 </pre>
 </html>
 "));

      equation 
        y=max(u1, u2);
      end Max;
      block Min "Pass through the smallest signal"
              extends Interfaces.SI2SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,36.0},{90.0,-36.0}}, fillColor={160,160,160}, textString="min()")}),Documentation(info="<html>
 <p>
 This block computes the output <b>y</b> as <i>minimum</i> of
 the two inputs <b>u1</b> and <b>u2</b>:
 </p>
 <pre>    y = <b>min</b> ( u1 , u2 );
 </pre>
 </html>
 "));

      equation 
        y=min(u1, u2);
      end Min;
      block Edge "Indicates rising edge of boolean signal"
              extends Interfaces.BooleanSISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,36.0},{90.0,-36.0}}, fillColor={160,160,160}, textString="edge()")}),Documentation(info="<html>
 <p>
 This block sets the Boolean output <b>y</b> to true,
 when the Boolean input <b>u</b> shows a <i>rising edge</i>:
 </p>
 <pre>    y = <b>edge</b>( u );
 </pre>
 </html>
 "));

      equation 
        y=edge(u);
      end Edge;
      block BooleanChange "Indicates boolean signal changing"
              extends Interfaces.BooleanSISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,36.0},{90.0,-36.0}}, fillColor={160,160,160}, textString="change()")}),Documentation(info="<html>
 <p>
 This block sets the Boolean output <b>y</b> to true, when the
 Boolean input <b>u</b> shows a <i>rising or falling edge</i>,
 i.e., when the signal changes:
 </p>
 <pre>    y = <b>change</b>( u );
 </pre>
 </html>
 "));

      equation 
        y=change(u);
      end BooleanChange;
    end Math;
    package Discrete "Discrete input/output blocks with fixed sample period"
          extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package contains <b>discrete control blocks</b>
 with <b>fixed sample period</b>.
 Every component of this package is structured in the following way:
 </p>
 <ol>
 <li> A component has <b>continuous real</b> input and output signals.</li>
 <li> The <b>input</b> signals are <b>sampled</b> by the given sample period
      defined via parameter <b>samplePeriod</b>.
      The first sample instant is defined by parameter <b>startTime</b>.
 <li> The <b>output</b> signals are computed from the sampled input signals.
 </ol>
 <p>
 A <b>sampled data system</b> may consist of components of package <b>Discrete</b>
 and of every other purely <b>algebraic</b> input/output block, such
 as the components of packages <b>Modelica.Blocks.Math</b>,
 <b>Modelica.Blocks.Nonlinear</b> or <b>Modelica.Blocks.Sources</b>.
 </p>
 <p>
 This package contains the following components:
 </p>
 <pre>
    <b>Sampler</b>           Ideal sampling of continuous signals
    <b>ZeroOrderHold</b>     Zero order hold of a sampled-data system
    <b>FirstOrder</b>        Discrete-time approximation of first order system
    <b>UnitDelay</b>         Delay input signal by one sampling period
    <b>TransferFunction</b>  Discrete-time approximation of transfer function
    <b>StateSpace</b>        Discrete-time approximation of state space system
    <b>TriggeredSampler</b>  Triggered sampling of continuous signals
    <b>TriggeredMax</b>      Compute maximum, absolute value of continuous signal
                      at trigger instants
 </pre>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        New components TriggeredSampler and TriggeredMax added.</li>
 <li><i>June 18, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized based on a corresponding library of Dieter Moormann and
        Hilding Elmqvist.</li>
 </ul>
 </html>"));
      block Sampler "Ideal sampling of continuous signals"
              extends Interfaces.DiscreteSISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-25.0,-10.0},{-45.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Ellipse(extent={{45.0,-10.0},{25.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{-45.0,0.0}}, color={0,0,255}),Line(points={{45.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-35.0,0.0},{30.0,35.0}}, color={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-25.0,-10.0},{-45.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Ellipse(extent={{45.0,-10.0},{25.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{-45.0,0.0}}, color={0,0,255}),Line(points={{45.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-35.0,0.0},{30.0,35.0}}, color={0,0,255})}),Documentation(info="<HTML>
 <p>
 Samples the continues input signal with a sampling rate defined
 via parameter <b>samplePeriod</b>.
 </p>
 </HTML>
 "));

      equation 
        when {sampleTrigger,initial()} then
                  y=u;
        
        end when;
      end Sampler;
      block ZeroOrderHold "Zero order hold of a sampled-data system"
              extends Interfaces.DiscreteSISO;
      protected 
        Real ySample;
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-78.0,-42.0},{-52.0,-42.0},{-52.0,0.0},{-26.0,0.0},{-26.0,24.0},{-6.0,24.0},{-6.0,64.0},{18.0,64.0},{18.0,20.0},{38.0,20.0},{38.0,0.0},{44.0,0.0},{44.0,0.0},{62.0,0.0}}, color={0,0,255})}),Documentation(info="<HTML>
 <p>
 The output is identical to the sampled input signal at sample
 time instants and holds the output at the value of the last
 sample instant during the sample points.
 </p>
 </HTML>
 "));

      equation 
        when {sampleTrigger,initial()} then
                  ySample=u;
        
        end when;
        y=pre(ySample);
      end ZeroOrderHold;
      block FirstOrderHold "First order hold of a sampled-data system"
              extends Interfaces.DiscreteSISO;
      protected 
        Real ySample;
        Real tSample;
        Real c;
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-79.0,-41.0},{-59.0,-33.0},{-40.0,1.0},{-20.0,9.0},{0.0,63.0},{21.0,20.0},{41.0,10.0},{60.0,20.0}}, color={0,0,255}),Line(points={{60.0,19.0},{81.0,10.0}}, color={0,0,255})}),Documentation(info="<HTML>
 <p>
 The output signal is the extrapolation through the
 values of the last two sampled input signals.
 </p>
 </HTML>
 "));

      equation 
        when sampleTrigger then
                  ySample=u;
          tSample=time;
          c=if firstTrigger then 0 else (ySample - pre(ySample))/samplePeriod;
        
        end when;
        y=pre(ySample) + pre(c)*(time - tSample);
      end FirstOrderHold;
      block UnitDelay "Unit Delay Block"
              parameter Real y_start=0 "Initial value of output signal";
        extends Interfaces.DiscreteSISO;
        annotation(Documentation(info="<html>
 <p>
 This block describes a unit delay:
 </p>
 <pre>
           1
      y = --- * u
           z
 </pre>
 <p>
 that is, the output signal y is the input signal u of the
 previous sample instant. Before the second sample instant,
 the output y is identical to parameter yStart.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>June 13, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized, based on a model of Dieter Moormann.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-30.0,0.0},{30.0,0.0}}, color={0,0,255}),Text(extent={{-90.0,10.0},{90.0,90.0}}, textString="1", fillColor={0,0,255}),Text(extent={{-90.0,-10.0},{90.0,-90.0}}, textString="z", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Text(extent={{-160.0,10.0},{-140.0,-10.0}}, textString="u", fillColor={0,0,255}),Text(extent={{115.0,10.0},{135.0,-10.0}}, textString="y", fillColor={0,0,255}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{40.0,0.0},{-40.0,0.0}}, color={0,0,0}),Text(extent={{-55.0,55.0},{55.0,5.0}}, textString="1", fillColor={0,0,0}),Text(extent={{-55.0,-5.0},{55.0,-55.0}}, textString="z", fillColor={0,0,0})}));

      equation 
        when sampleTrigger then
                  y=pre(u);
        
        end when;

      initial equation 
        y=y_start;
      end UnitDelay;
      block TransferFunction "Discrete Transfer Function block"
              parameter Real b[:]={1} "Numerator coefficients of transfer function.";
        parameter Real a[:]={1,1} "Denominator coefficients of transfer function.";
        extends Interfaces.DiscreteSISO;
        output Real x[size(a, 1) - 1] "State of transfer function from controller canonical form";
      protected 
        parameter Integer nb=size(b, 1) "Size of Numerator of transfer function";
        parameter Integer na=size(a, 1) "Size of Denominator of transfer function";
        Real x1;
        Real xext[size(a, 1)];
        annotation(Documentation(info="<html>
 <p>The <b>discrete transfer function</b> block defines the
 transfer function between the input signal u and the output
 signal y. The numerator has the order nb-1, the denominator
 has the order na-1.</p>
 <pre>          b(1)*z^(nb-1) + b(2)*z^(nb-2) + ... + b(nb)
    y(z) = -------------------------------------------- * u(z)
           a(1)*z^(na-1) + a(2)*z^(na-2) + ... + a(na)
 </pre>
 <p>State variables <b>x</b> are defined according to
 <b>controller canonical</b> form. Initial values of the
 states can be set as start values of <b>x</b>.<p>
 <p>Example:</p>
 <pre>     Blocks.Discrete.TransferFunction g(b = {2,4}, a = {1,3});
 </pre>
 <p>results in the following transfer function:</p>
 <pre>        2*z + 4
    y = --------- * u
          z + 3
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>November 15, 2000</i>
     by <a href=\"http://www.dynasim.se\">Hans Olsson</a>:<br>
     Converted to when-semantics of Modelica 1.4 with special
     care to avoid unnecessary algebraic loops.</li>
 <li><i>June 18, 2000</i>
     by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
     Realized based on a corresponding model of Dieter Moormann
     and Hilding Elmqvist.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{82.0,0.0},{-84.0,0.0}}, color={0,0,255}),Text(extent={{-92.0,92.0},{86.0,12.0}}, textString="b(z)", fillColor={0,0,255}),Text(extent={{-90.0,-12.0},{90.0,-90.0}}, textString="a(z)", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, fillPattern=FillPattern.None, lineColor={0,0,255}),Line(points={{40.0,0.0},{-44.0,0.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-54.0,54.0},{54.0,4.0}}, textString="b(z)", fillColor={0,0,0}),Text(extent={{-54.0,-6.0},{56.0,-56.0}}, textString="a(z)", fillColor={0,0,0}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255})}));

      equation 
        when sampleTrigger then
                  x1=(u - a[2:size(a, 1)]*pre(x))/a[1];
          xext=vector([x1;pre(x)]);
          x=xext[1:size(x, 1)];
          y=vector([zeros(na - nb, 1);b])*xext;
        
        end when;
      end TransferFunction;
      block StateSpace "Discrete State Space block"
              parameter Real A[:,size(A, 1)]={{1,0},{0,1}} "Matrix A of state space model";
        parameter Real B[size(A, 1),:]={{1},{1}} "Matrix B of state space model";
        parameter Real C[:,size(A, 1)]={{1,1}} "Matrix C of state space model";
        parameter Real D[size(C, 1),size(B, 2)]=zeros(size(C, 1), size(B, 2)) "Matrix D of state space model";
        extends Interfaces.DiscreteMIMO(final nin=size(B, 2),final nout=size(C, 1));
        output Real x[size(A, 1)] "State vector";
        annotation(Documentation(info="<html>
 <p>
 The <b>discrete state space</b> block defines the relation
 between the input u=inPort.signal and the output
 y=outPort.signal in state space form:
 </p>
 <pre>
     x = A * pre(x) + B * u
     y = C * pre(x) + D * u
 </pre>
 <p>
 where pre(x) is the value of the discrete state x at
 the previous sample time instant.
 The input is a vector of length nu, the output is a vector
 of length ny and nx is the number of states. Accordingly
 </p>
 <pre>
         A has the dimension: A(nx,nx),
         B has the dimension: B(nx,nu),
         C has the dimension: C(ny,nx),
         D has the dimension: D(ny,nu)
 </pre>
 <p>
 Example:
 </p>
 <pre>
      parameter: A = [0.12, 2;3, 1.5]
      parameter: B = [2, 7;3, 1]
      parameter: C = [0.1, 2]
      parameter: D = zeros(ny,nu)
 results in the following equations:
   [x[1]]   [0.12  2.00] [pre(x[1])]   [2.0  7.0] [u[1]]
   [    ] = [          ]*[         ] + [        ]*[    ]
   [x[2]]   [3.00  1.50] [pre(x[2])]   [0.1  2.0] [u[2]]
                              [pre(x[1])]            [u[1]]
        y[1]   = [0.1  2.0] * [         ] + [0  0] * [    ]
                              [pre(x[2])]            [u[2]]
 </pre>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,15.0},{-15.0,90.0}}, textString="A", fillColor={0,0,255}),Text(extent={{15.0,15.0},{90.0,90.0}}, textString="B", fillColor={0,0,255}),Text(extent={{-52.0,28.0},{54.0,-20.0}}, textString="z", fillColor={0,0,255}),Text(extent={{-90.0,-15.0},{-15.0,-90.0}}, textString="C", fillColor={0,0,255}),Text(extent={{15.0,-15.0},{90.0,-90.0}}, textString="D", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, fillPattern=FillPattern.None, lineColor={0,0,255}),Text(extent={{-54.0,50.0},{52.0,-10.0}}, textString="zx=Ax+Bu", fillColor={0,0,0}, fillPattern=FillPattern.None),Text(extent={{-56.0,14.0},{54.0,-50.0}}, textString="  y=Cx+Du", fillColor={0,0,0}, fillPattern=FillPattern.Solid),Line(points={{-102.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255})}));

      equation 
        when sampleTrigger then
                  x=A*pre(x) + B*u;
          y=C*pre(x) + D*u;
        
        end when;
      end StateSpace;
      block TriggeredSampler "Triggered sampling of continuous signals"
              extends Interfaces.DiscreteBlockIcon;
        replaceable type SignalType= Real "type of input and output signal";
        parameter SignalType y_start=0 "initial value of output signal";
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-25.0,-10.0},{-45.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Ellipse(extent={{45.0,-10.0},{25.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{-45.0,0.0}}, color={0,0,255}),Line(points={{45.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{0.0,-100.0},{0.0,-26.0}}, color={255,0,255}),Line(points={{-35.0,0.0},{28.0,-48.0}}, color={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-25.0,-10.0},{-45.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Ellipse(extent={{45.0,-10.0},{25.0,10.0}}, lineColor={0,0,255}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-100.0,0.0},{-45.0,0.0}}, color={0,0,255}),Line(points={{45.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-35.0,0.0},{28.0,-48.0}}, color={0,0,255}),Line(points={{0.0,-100.0},{0.0,-26.0}}, color={255,0,255})}),Documentation(info="<HTML>
 <p>
 Samples the continuous input signal whenever the trigger input
 signal is rising (i.e., trigger changes from <b>false</b> to
 <b>true</b>) and provides the sampled input signal as output.
 Before the first sampling, the output signal is equal to
 the initial value defined via parameter <b>y0</b>.
 </p>
 </HTML>
 "));
        Modelica.Blocks.Interfaces.RealInput u(redeclare type SignalType= SignalType ) "Connector with an input signal of type SignalType" annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.RealOutput y(redeclare type SignalType= SignalType ) "Connector with an output signal of type SignalType" annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Modelica.Blocks.Interfaces.BooleanInput trigger annotation(Placement(transformation(x=0.0,y=-118.0,scale=0.2,aspectRatio=1.0,rotation=90),iconTransformation(x=0.0,y=-118.0,scale=0.2,aspectRatio=1.0,rotation=90)));

      equation 
        when trigger then
                  y=u;
        
        end when;

      initial equation 
        y=y_start;
      end TriggeredSampler;
    end Discrete;
    package Logical "Components with Boolean input and output signals"
          extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package provides blocks with Boolean input and output signals
 to describe logical networks. A typical example for a logical
 network built with package Logical is shown in the next figure:
 </p>
 <p align=\"center\">
 <img src=\"../Images/LogicalNetwork1.png\">
 </p>
 </html>"));
      model And "Logical 'and': y = u1 and u2"
              extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,40.0},{90.0,-40.0}}, textString="and", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=u1 and u2;
      end And;
      model Or "Logical 'or': y = u1 or u2"
              extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,40.0},{90.0,-40.0}}, textString="or", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=u1 or u2;
      end Or;
      model Xor "Logical 'xor': y = u1 xor u2"
              extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,40.0},{90.0,-40.0}}, textString="xor", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=not (u1 and u2 or not u1 and not u2);
      end Xor;
      model Nor "Logical 'nor': y = not (u1 or u2)"
              extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,40.0},{90.0,-40.0}}, textString="nor", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=not (u1 or u2);
      end Nor;
      model Nand "Logical 'nand': y = not (u1 and u2)"
              extends Blocks.Interfaces.partialBooleanSI2SO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,40.0},{90.0,-40.0}}, textString="nand", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=not (u1 and u2);
      end Nand;
      model Not "Logical 'not': y = not u"
              extends Blocks.Interfaces.partialBooleanSISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,40.0},{90.0,-40.0}}, textString="not", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=not u;
      end Not;
      block GreaterThreshold "Output y is true, if input u is greater than threshold"
              extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,-40.0},{60.0,40.0}}, fillColor={0,0,0}, textString=">")}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=u > threshold;
      end GreaterThreshold;
      block GreaterEqualThreshold "Output y is true, if input u is greater or equal than threshold"
              extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,-40.0},{60.0,40.0}}, fillColor={0,0,0}, textString=">=")}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=u >= threshold;
      end GreaterEqualThreshold;
      block LessThreshold "Output y is true, if input u is less than threshold"
              extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,-40.0},{60.0,40.0}}, fillColor={0,0,0}, textString="<")}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=u < threshold;
      end LessThreshold;
      block LessEqualThreshold "Output y is true, if input u is less or equal than threshold"
              extends Blocks.Interfaces.partialBooleanThresholdComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,-40.0},{60.0,40.0}}, fillColor={0,0,0}, textString="<=")}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=u <= threshold;
      end LessEqualThreshold;
      block Greater "Output y is true, if input u1 is greater as input u2"
              extends Blocks.Interfaces.partialBooleanComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{32.0,10.0},{52.0,-10.0}}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{-100.0,-80.0},{42.0,-80.0},{42.0,0.0}}, color={0,0,255}),Text(extent={{-80.0,-60.0},{20.0,60.0}}, fillColor={0,0,0}, textString=">")}),Documentation(info=""));

      equation 
        y=u1 > u2;
      end Greater;
      block GreaterEqual "Output y is true, if input u1 is greater or equal as input u2"
              extends Blocks.Interfaces.partialBooleanComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{32.0,10.0},{52.0,-10.0}}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{-100.0,-80.0},{42.0,-80.0},{42.0,0.0}}, color={0,0,255}),Text(extent={{-80.0,-60.0},{20.0,60.0}}, fillColor={0,0,0}, textString=">=")}),Documentation(info=""));

      equation 
        y=u1 >= u2;
      end GreaterEqual;
      block Less "Output y is true, if input u1 is less as input u2"
              extends Blocks.Interfaces.partialBooleanComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{32.0,10.0},{52.0,-10.0}}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{-100.0,-80.0},{42.0,-80.0},{42.0,0.0}}, color={0,0,255}),Text(extent={{-80.0,-60.0},{20.0,60.0}}, fillColor={0,0,0}, textString="<")}),Documentation(info=""));

      equation 
        y=u1 < u2;
      end Less;
      block LessEqual "Output y is true, if input u1 is less or equal as input u2"
              extends Blocks.Interfaces.partialBooleanComparison;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{32.0,10.0},{52.0,-10.0}}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Line(points={{-100.0,-80.0},{42.0,-80.0},{42.0,0.0}}, color={0,0,255}),Text(extent={{-80.0,-60.0},{20.0,60.0}}, fillColor={0,0,0}, textString="<=")}),Documentation(info=""));

      equation 
        y=u1 <= u2;
      end LessEqual;
      block LogicalSwitch "Logical Switch"
              extends Blocks.Interfaces.partialBooleanSI3SO;
        annotation(Documentation(info="<html>
 <p>The LogicalSwitch switches, depending on the
 Boolean u2 connector (the middle connector),
 between the two possible input signals
 u1 (upper connector) and u3 (lower connector).</p>
 <p>If u2 is true, connector y is set equal to
 u1, else it is set equal to u2.</p>
 </html>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{12.0,0.0},{100.0,0.0}}, color={255,0,255}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-100.0,0.0},{-40.0,0.0}}, color={255,0,255}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-100.0,-80.0},{-40.0,-80.0},{-40.0,-80.0}}, color={255,0,255}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-40.0,12.0},{-40.0,-10.0}}, color={255,0,255}),Line(points={{-100.0,80.0},{-40.0,80.0}}, color={255,0,255}),Line(points={{-40.0,80.0},{8.0,2.0}}, color={255,0,127}, thickness=1.0),Ellipse(extent={{2.0,8.0},{18.0,-6.0}}, fillColor={0,0,0}, fillPattern=FillPattern.Solid, lineColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=if u2 then u1 else u3;
      end LogicalSwitch;
      block Switch "Switch between two Real signals"
              extends Blocks.Interfaces.partialBooleanBlockIcon;
        Blocks.Interfaces.RealInput u1 annotation(Placement(transformation(x=-120.0,y=80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=80.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanInput u2 annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.RealInput u3 annotation(Placement(transformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=-80.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.RealOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Documentation(info="<html>
 <p>The Logical.Switch switches, depending on the
 logical connector u2 (the middle connector)
 between the two possible input signals
 u1 (upper connector) and u3 (lower connector).</p>
 <p>If u2 is <b>true</b>, the output signal y is set equal to
 u1, else it is set equal to u3.</p>
 </html>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{12.0,0.0},{100.0,0.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Line(points={{-100.0,0.0},{-40.0,0.0}}, color={255,0,127}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-100.0,-80.0},{-40.0,-80.0},{-40.0,-80.0}}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}, color={0,0,255}),Line(points={{-40.0,12.0},{-40.0,-12.0}}, color={255,0,127}),Line(points={{-100.0,80.0},{-38.0,80.0}}, color={0,0,255}),Line(points={{-38.0,80.0},{6.0,2.0}}, thickness=1.0, color={0,0,255}),Ellipse(extent={{2.0,8.0},{18.0,-6.0}}, fillColor={0,0,0}, fillPattern=FillPattern.Solid, lineColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));

      equation 
        y=if u2 then u1 else u3;
      end Switch;
      block Hysteresis "Transform Real to Boolean signal with Hysteresis"
              extends Blocks.Interfaces.partialBooleanBlockIcon;
        parameter Real uLow=0 "if y=true and u<=uLow, switch to y=false";
        parameter Real uHigh=1 "if y=false and u>=uHigh, switch to y=true";
        parameter Boolean pre_y_start=false "Value of pre(y) at initial time";
        Blocks.Interfaces.RealInput u annotation(Placement(transformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-120.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Interfaces.BooleanOutput y annotation(Placement(transformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=110.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-65.0,89.0},{-73.0,67.0},{-57.0,67.0},{-65.0,89.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-65.0,67.0},{-65.0,-81.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-65.0,93.0},{-12.0,75.0}}, fillColor={160,160,160}, textString="y"),Line(points={{-80.0,-70.0},{30.0,-70.0}}, color={0,0,0}, thickness=0.5),Line(points={{-50.0,10.0},{80.0,10.0}}, color={0,0,0}, thickness=0.5),Line(points={{-50.0,10.0},{-50.0,-70.0}}, color={0,0,0}, thickness=0.5),Line(points={{30.0,10.0},{30.0,-70.0}}, color={0,0,0}, thickness=0.5),Line(points={{-10.0,-65.0},{0.0,-70.0},{-10.0,-75.0}}, color={0,0,0}, thickness=0.5),Line(points={{-10.0,15.0},{-20.0,10.0},{-10.0,5.0}}, color={0,0,0}, thickness=0.5),Line(points={{-55.0,-20.0},{-50.0,-30.0},{-44.0,-20.0}}, color={0,0,0}, thickness=0.5),Line(points={{25.0,-30.0},{30.0,-19.0},{35.0,-30.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-99.0,2.0},{-70.0,18.0}}, textString="true", fillColor={160,160,160}),Text(extent={{-98.0,-87.0},{-66.0,-73.0}}, textString="false", fillColor={160,160,160}),Text(extent={{19.0,-87.0},{44.0,-70.0}}, textString="uHigh", fillColor={0,0,0}),Text(extent={{-63.0,-88.0},{-38.0,-71.0}}, textString="uLow", fillColor={0,0,0}),Line(points={{-69.0,10.0},{-60.0,10.0}}, color={160,160,160})}),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-29.0}}, color={192,192,192}),Polygon(points={{92.0,-29.0},{70.0,-21.0},{70.0,-37.0},{92.0,-29.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-79.0,-29.0},{84.0,-29.0}}, color={192,192,192}),Line(points={{-79.0,-29.0},{41.0,-29.0}}, color={0,0,0}),Line(points={{-15.0,-21.0},{1.0,-29.0},{-15.0,-36.0}}, color={0,0,0}),Line(points={{41.0,51.0},{41.0,-29.0}}, color={0,0,0}),Line(points={{33.0,3.0},{41.0,22.0},{50.0,3.0}}, color={0,0,0}),Line(points={{-49.0,51.0},{81.0,51.0}}, color={0,0,0}),Line(points={{-4.0,59.0},{-19.0,51.0},{-4.0,43.0}}, color={0,0,0}),Line(points={{-59.0,29.0},{-49.0,11.0},{-39.0,29.0}}, color={0,0,0}),Line(points={{-49.0,51.0},{-49.0,-29.0}}, color={0,0,0}),Text(extent={{-92.0,-49.0},{-9.0,-92.0}}, textString="%uLow", fillColor={192,192,192}),Text(extent={{2.0,-49.0},{91.0,-92.0}}, textString="%uHigh", fillColor={192,192,192}),Rectangle(extent={{-91.0,-49.0},{-8.0,-92.0}}, lineColor={192,192,192}),Line(points={{-49.0,-29.0},{-49.0,-49.0}}, color={192,192,192}),Rectangle(extent={{2.0,-49.0},{91.0,-92.0}}, lineColor={192,192,192}),Line(points={{41.0,-29.0},{41.0,-49.0}}, color={192,192,192})}),Documentation(info="<HTML>
 <p>
 This block transforms a <b>Real</b> input signal into a <b>Boolean</b>
 output signal:
 </p>
 <ul>
 <li> When the output was <b>false</b> and the input becomes
      <b>greater</b> than parameter <b>uHigh</b>, the output
      switches to <b>true</b>.</li>
 <li> When the output was <b>true</b> and the input becomes
      <b>less</b> than parameter <b>uLow</b>, the output
      switches to <b>false</b>.</li>
 </ul>
 <p>
 The start value of the output is defined via parameter
 <b>pre_y_start</b> (= value of pre(y) at initial time).
 The default value of this parameter is <b>false</b>.
 </p>
 </HTML>
 "));

      initial equation 
        pre(y)=pre_y_start;

      equation 
        y=u > uHigh or pre(y) and u >= uLow;
      end Hysteresis;
    end Logical;
    package Continuous "Continuous control blocks with internal states"
          import Modelica.Blocks.Interfaces;
      import Modelica.SIunits;
      extends Modelica.Icons.Library;
      annotation(preferedView="info",Documentation(info="
 <HTML>
 <p>
 This package contains basic <b>continuous</b> input/output blocks
 described by differential equations.
 </p>
 </HTML>
 "));
      block Integrator "Output the integral of the input signals"
              parameter Real k=1 "Integrator gains";
        parameter Real y_start=0 "Start values of integrators";
        extends Interfaces.SISO(y(start=y_start,fixed=true));
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes output <b>y</b> (element-wise) as
 <i>integral</i> of the input <b>u</b> multiplied with
 the gain <i>k</i>:
 </p>
 <pre>
          k
      y = - u
          s
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 4, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Vectorized.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{0.0,-10.0},{60.0,-70.0}}, textString="I", fillColor={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="k=%k", fillColor={0,0,0}),Line(points={{-80.0,-80.0},{80.0,80.0}}, color={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{-36.0,60.0},{32.0,2.0}}, textString="k", fillColor={0,0,0}),Text(extent={{-32.0,0.0},{36.0,-58.0}}, textString="s", fillColor={0,0,0}),Line(points={{-46.0,0.0},{46.0,0.0}}, color={0,0,0})}));

      equation 
        der(y)=k*u;
      end Integrator;
      block LimIntegrator "Integrator with limited values of the outputs"
              parameter Real k=1 "Integrator gains";
        parameter Real outMax=1 "Upper limits of outputs";
        parameter Real outMin=-outMax "Lower limits of outputs";
        parameter Real y_start=0 "Start values of integrators";
        extends Interfaces.SISO(y(start=y_start,fixed=true));
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks computes <b>y</b> (element-wise) as <i>integral</i>
 of the input <b>u</b> multiplied with the gain <i>k</i>. If the
 integral reaches a given upper or lower <i>limit</i> and the
 input will drive the integral outside of this bound, the
 integration is halted and only restarted if the input drives
 the integral away from the bounds.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 4, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Vectorized.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.
 </li>
 </ul>
 <p><b>Copyright (C) 1999-2000, Modelica Association and DLR.</b></p>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{20.0,20.0},{80.0,20.0}}, color={0,0,255}),Text(extent={{0.0,-10.0},{60.0,-70.0}}, textString="I", fillColor={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="k=%k", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Text(extent={{-54.0,46.0},{-4.0,-48.0}}, textString="lim", fillColor={0,0,0}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255}),Text(extent={{-8.0,60.0},{60.0,2.0}}, textString="k", fillColor={0,0,0}),Text(extent={{-8.0,-2.0},{60.0,-60.0}}, textString="s", fillColor={0,0,0}),Line(points={{4.0,0.0},{46.0,0.0}}, color={0,0,0})}));

      equation 
        der(y)=if y < outMin and u < 0 or y > outMax and u > 0 then 0 else k*u;
      end LimIntegrator;
      block Derivative "Approximated derivative block"
              parameter Real k=1 "Gains";
        parameter SIunits.Time T(min=Modelica.Constants.small)=0.01 "Time constants (T>0 required; T=0 is ideal derivative block)";
        extends Interfaces.SISO;
        output Real x "State of block";
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks defines the transfer function between the
 input u and the output y
 (element-wise) as <i>approximated derivative</i>:
 </p>
 <pre>
              k * s
      y = ------------ * u
             T * s + 1
 </pre>
 <p>
 If you would like to be able to change easily between different
 transfer functions (FirstOrder, SecondOrder, ... ) by changing
 parameters, use the general block <b>TransferFunction</b> instead
 and model a derivative block with parameters<br>
 b = {k,0}, a = {T, 1}.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 15, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Special handling, if k is zero. Introduced, in order that
        the D-part of the PID controllers can be set to zero without
        introducing numerical problems.</li>
 <li><i>Nov. 4, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Vectorized.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,60.0},{-70.0,17.95},{-60.0,-11.46},{-50.0,-32.05},{-40.0,-46.45},{-30.0,-56.53},{-20.0,-63.58},{-10.0,-68.51},{0.0,-71.96},{10.0,-74.37},{20.0,-76.06},{30.0,-77.25},{40.0,-78.07},{50.0,-78.65},{60.0,-79.06}}, color={0,0,255}),Text(extent={{0.0,0.0},{60.0,60.0}}, textString="DT1", fillColor={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="k=%k", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-54.0,52.0},{50.0,10.0}}, textString="k s", fillColor={0,0,0}),Text(extent={{-54.0,-6.0},{52.0,-52.0}}, textString="T s + 1", fillColor={0,0,0}),Line(points={{-50.0,0.0},{50.0,0.0}}, color={0,0,0}),Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255})}));

      equation 
        der(x)=if noEvent(abs(k) >= Modelica.Constants.eps) then (u - x)/T else 0;
        y=if noEvent(abs(k) >= Modelica.Constants.eps) then k/T*(u - x) else 0;
      end Derivative;
      block FirstOrder "First order transfer function block (= 1 pole)"
              parameter Real k=1 "Gain";
        parameter SIunits.Time T=1 "Time Constant";
        extends Interfaces.SISO;
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks defines the transfer function between the input u
 and the output y (element-wise) as <i>first order</i> system:
 </p>
 <pre>
                k
      y = ------------ * u
             T * s + 1
 </pre>
 <p>
 If you would like to be able to change easily between different
 transfer functions (FirstOrder, SecondOrder, ... ) by changing
 parameters, use the general block <b>TransferFunction</b> instead
 and model a first order SISO system with parameters<br>
 b = {k}, a = {T, 1}.
 </p>
 <pre>
 Example:
    parameter: k = 0.3, T = 0.4
    results in:
              0.3
       y = ----------- * u
           0.4 s + 1.0
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 4, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Vectorized.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,88.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-70.0,-45.11},{-60.0,-19.58},{-50.0,-0.9087},{-40.0,12.75},{-30.0,22.75},{-20.0,30.06},{-10.0,35.41},{0.0,39.33},{10.0,42.19},{20.0,44.29},{30.0,45.82},{40.0,46.94},{50.0,47.76},{60.0,48.36},{70.0,48.8},{80.0,49.12}}, color={0,0,255}),Text(extent={{0.0,0.0},{60.0,-60.0}}, textString="PT1", fillColor={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="T=%T", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-48.0,52.0},{50.0,8.0}}, textString="k", fillColor={0,0,0}),Text(extent={{-54.0,-6.0},{56.0,-56.0}}, textString="T s + 1", fillColor={0,0,0}),Line(points={{-50.0,0.0},{50.0,0.0}}, color={0,0,0}),Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255})}));

      equation 
        der(y)=(k*u - y)/T;
      end FirstOrder;
      block SecondOrder "Second order transfer function block (= 2 poles)"
              parameter Real k=1 "Gain";
        parameter Real w=1 "Angular frequency";
        parameter Real D=1 "Damping";
        extends Interfaces.SISO;
        output Real yd "Derivative of y";
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks defines the transfer function between the input u and
 the output y (element-wise) as <i>second order</i> system:
 </p>
 <pre>
                              k
      y = ---------------------------------------- * u
             ( s / w )^2 + 2*D*( s / w ) + 1
 </pre>
 <p>
 If you would like to be able to change easily between different
 transfer functions (FirstOrder, SecondOrder, ... ) by changing
 parameters, use the general model class <b>TransferFunction</b>
 instead and model a second order SISO system with parameters<br>
 b = {k}, a = {1/w^2, 2*D/w, 1}.
 </p>
 <pre>
 Example:
 
    parameter: k =  0.3,  w = 0.5,  D = 0.4
    results in:
                   0.3
       y = ------------------- * u
           4.0 s^2 + 1.6 s + 1
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 4, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Vectorized and state space representation changed, such
        that the output and its derivative are used as state.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,88.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-72.0,-68.53},{-64.0,-39.5},{-56.0,-2.522},{-48.0,32.75},{-40.0,58.8},{-32.0,71.51},{-24.0,70.49},{-16.0,58.45},{-8.0,40.06},{0.0,20.55},{8.0,4.459},{16.0,-5.271},{24.0,-7.629},{32.0,-3.428},{40.0,5.21},{48.0,15.56},{56.0,25.03},{64.0,31.66},{72.0,34.5},{80.0,33.61}}, color={0,0,255}),Text(extent={{0.0,-10.0},{60.0,-70.0}}, textString="PT2", fillColor={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="w=%w", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Text(extent={{-60.0,60.0},{60.0,14.0}}, textString="k", fillColor={0,0,0}),Text(extent={{-60.0,8.0},{-32.0,-20.0}}, textString="s", fillColor={0,0,0}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{-50.0,14.0},{50.0,14.0}}, color={0,0,0}),Line(points={{-54.0,-20.0},{-38.0,-20.0}}, color={0,0,0}),Text(extent={{-52.0,-26.0},{-36.0,-48.0}}, textString="w", fillColor={0,0,0}),Line(points={{-50.0,2.0},{-56.0,-8.0},{-56.0,-28.0},{-52.0,-46.0}}, color={0,0,0}),Line(points={{-40.0,2.0},{-34.0,-10.0},{-34.0,-30.0},{-38.0,-46.0}}, color={0,0,0}),Text(extent={{-34.0,8.0},{-22.0,-10.0}}, textString="2", fillColor={0,0,0}),Text(extent={{-34.0,-6.0},{6.0,-36.0}}, textString="+2D", fillColor={0,0,0}),Text(extent={{2.0,8.0},{30.0,-20.0}}, textString="s", fillColor={0,0,0}),Line(points={{8.0,-20.0},{24.0,-20.0}}, color={0,0,0}),Text(extent={{10.0,-26.0},{26.0,-48.0}}, textString="w", fillColor={0,0,0}),Line(points={{12.0,2.0},{6.0,-8.0},{6.0,-28.0},{10.0,-46.0}}, color={0,0,0}),Line(points={{22.0,2.0},{28.0,-10.0},{28.0,-30.0},{24.0,-46.0}}, color={0,0,0}),Text(extent={{30.0,2.0},{58.0,-42.0}}, textString="+1", fillColor={0,0,0})}));

      equation 
        der(y)=yd;
        der(yd)=w*(w*(k*u - y) - 2*D*yd);
      end SecondOrder;
      block PI "Proportional-Integral controller"
              parameter Real k=1 "Gain";
        parameter SIunits.Time T=1 "Time Constant (T>0 required)";
        extends Interfaces.SISO;
        output Real x "State of block";
        annotation(Documentation(info="
 <HTML>
 <p>
 This blocks defines the transfer function between the input u and
 the output y (element-wise) as <i>PI</i> system:
 </p>
 <pre>
                  1
    y = k * (1 + ---) * u
                 T*s
            T*s + 1
      = k * ------- * u
              T*s
 </pre>
 <p>
 If you would like to be able to change easily between different
 transfer functions (FirstOrder, SecondOrder, ... ) by changing
 parameters, use the general model class <b>TransferFunction</b>
 instead and model a PI SISO system with parameters<br>
 b = {k*T, k}, a = {T, 0}.
 </p>
 <pre>
 Example:
 
    parameter: k = 0.3,  T = 0.4
 
    results in:
                0.4 s + 1
       y = 0.3 ----------- * u
                  0.4 s
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Nov. 4, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Vectorized.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,88.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,-20.0},{60.0,80.0}}, thickness=0.25, color={0,0,255}),Text(extent={{0.0,6.0},{60.0,-56.0}}, textString="PI", fillColor={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="T=%T", fillColor={0,0,0})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Text(extent={{-68.0,24.0},{-24.0,-18.0}}, textString="k", fillColor={0,0,0}),Text(extent={{-32.0,48.0},{60.0,0.0}}, textString="T s + 1", fillColor={0,0,0}),Text(extent={{-30.0,-8.0},{52.0,-40.0}}, textString="T s", fillColor={0,0,0}),Line(points={{-24.0,0.0},{54.0,0.0}}, color={0,0,0}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{62.0,0.0},{100.0,0.0}}, color={0,0,255})}));

      equation 
        der(x)=u/T;
        y=k*(x + u);
      end PI;
      block PID "PID-controller in additive description form"
              extends Interfaces.SISO;
        parameter Real k=1 "Gain";
        parameter SIunits.Time Ti(min=Modelica.Constants.small)=0.5 "Time Constant of Integrator";
        parameter SIunits.Time Td(min=0)=0.1 "Time Constant of Derivative block";
        parameter Real Nd(min=Modelica.Constants.small)=10 "The higher Nd, the more ideal the derivative block";
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,50.0},{-80.0,-20.0},{60.0,80.0}}, color={0,0,255}),Text(extent={{-20.0,-20.0},{80.0,-60.0}}, textString="PID", fillColor={192,192,192}),Text(extent={{-150.0,-150.0},{150.0,-110.0}}, textString="Ti=%Ti", fillColor={0,0,0})}),Documentation(info="<HTML>
 <p>
 This is the text-book version of a PID-controller.
 For a more practically useful PID-controller, use
 block LimPID.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Aug. 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "));
        Blocks.Math.Gain P "Proportional part of PID controller" annotation(Placement(transformation(x=-40.0,y=80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-40.0,y=80.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Continuous.Integrator I(k=1/Ti) "Integral part of PID controller" annotation(Placement(transformation(x=-40.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-40.0,y=0.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Continuous.Derivative D(k=Td,T=max([Td/Nd,100*Modelica.Constants.eps])) "Derivative part of PID controller" annotation(Placement(transformation(x=-40.0,y=-80.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=-40.0,y=-80.0,scale=0.2,aspectRatio=1.0)));
        Blocks.Math.Gain Gain(k=k) "Gain of PID controller" annotation(Placement(transformation(x=70.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Math.Add3 Add annotation(Placement(transformation(x=30.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=0.0,scale=0.1,aspectRatio=1.0)));

      equation 
        connect(P.y,Add.u1) annotation(Line(points={{-20.0,80.0},{0.0,80.0},{0.0,8.0},{20.0,8.0}},color={0,0,255}));
        connect(I.y,Add.u2) annotation(Line(points={{-20.0,0.0},{20.0,0.0}},color={0,0,255}));
        connect(D.y,Add.u3) annotation(Line(points={{-20.0,-80.0},{0.0,-80.0},{0.0,-8.0},{20.0,-8.0}},color={0,0,255}));
        connect(Add.y,Gain.u) annotation(Line(points={{40.0,0.0},{60.0,0.0}},color={0,0,255}));
        connect(y,Gain.y) annotation(Line(points={{100.0,0.0},{80.0,0.0}},color={0,0,255}));
        connect(u,I.u) annotation(Line(points={{-100.0,0.0},{-60.0,0.0}},color={0,0,255}));
        connect(u,P.u) annotation(Line(points={{-100.0,0.0},{-80.0,0.0},{-80.0,80.0},{-60.0,80.0}},color={0,0,255}));
        connect(u,D.u) annotation(Line(points={{-100.0,0.0},{-80.0,0.0},{-80.0,-80.0},{-60.0,-80.0}},color={0,0,255}));
      end PID;
      block LimPID "PID controller with limited output, anti-windup compensation and setpoint weighting"
              extends Interfaces.SVcontrol;
        parameter Real k(min=0)=1 "Gain of PID block";
        parameter SIunits.Time Ti(min=Modelica.Constants.small)=0.5 "Time constant of Integrator block";
        parameter SIunits.Time Td(min=0)=0.1 "Time constant of Derivative block";
        parameter Real yMax=1 "Upper limit of output";
        parameter Real yMin=-yMax "Lower limit of output";
        parameter Real wp(min=0)=1 "Set-point weight for Proportional block (0..1)";
        parameter Real wd(min=0)=0 "Set-point weight for Derivative block (0..1)";
        parameter Real Ni(min=100*Modelica.Constants.eps)=0.9 "Ni*Ti is time constant of anti-windup compensation";
        parameter Real Nd(min=100*Modelica.Constants.eps)=10 "The higher Nd, the more ideal the derivative block";
        Blocks.Nonlinear.Limiter limiter(uMax=yMax,uMin=yMin) annotation(Placement(transformation(x=80.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=80.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,78.0},{-80.0,-90.0}}, color={192,192,192}),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-90.0,-80.0},{82.0,-80.0}}, color={192,192,192}),Polygon(points={{90.0,-80.0},{68.0,-72.0},{68.0,-88.0},{90.0,-80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-80.0},{-80.0,50.0},{-80.0,-20.0},{30.0,60.0},{80.0,60.0}}, color={0,0,255}),Text(extent={{-20.0,-20.0},{80.0,-60.0}}, textString="PID", fillColor={192,192,192})}),Documentation(info="<HTML>
 <p>
 This is a PID controller incorporating several practical aspects.
 It is designed according to chapter 3 of the book
 </p>
 <pre>
    K. Astroem, T. Haegglund: PID Controllers: Theory, Design, and Tuning.
                              2nd edition, 1995.
 </pre>
 <p>
 Besides the additive <b>proportional, integral</b> and <b>derivative</b>
 part of this controller, the following practical aspects are included:
 </p>
 <ul>
 <li> The output of this controller is limited. If the controller is
      in its limits, anti-windup compensation is activated to drive
      the integrator state to zero. </li>
 <li> The high-frequency gain of the derivative part is limited
      to avoid excessive amplification of measurement noise.</li>
 <li> Setpoint weighting is present, which allows to weight
      the setpoint in the proportional and the derivative part
      independantly from the measurement. The controller will respond
      to load disturbances and measurement noise independantly of this setting
      (parameters wp, wd). However, setpoint changes will depend on this
      setting. For example, it is useful to set the setpoint weight wd
      for the derivative part to zero, if steps may occur in the
      setpoint signal.</li>
 </ul>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Aug. 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized.</li>
 </ul>
 </HTML>
 "));
        Blocks.Math.Add addP(k1=wp,k2=-1) annotation(Placement(transformation(x=-70.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=50.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Math.Add addD(k1=wd,k2=-1) annotation(Placement(transformation(x=-70.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Math.Gain P annotation(Placement(transformation(x=-30.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=50.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Continuous.Integrator I(k=1/Ti) annotation(Placement(transformation(x=-30.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Continuous.Derivative D(k=Td,T=max([Td/Nd,1e-14])) annotation(Placement(transformation(x=-30.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Math.Gain gainPID(k=k) annotation(Placement(transformation(x=40.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=40.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Math.Add3 addPID annotation(Placement(transformation(x=10.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=10.0,y=0.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Math.Add3 addI(k2=-1) annotation(Placement(transformation(x=-70.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
        Blocks.Math.Add addSat(k2=-1) annotation(Placement(transformation(x=80.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=80.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
        Blocks.Math.Gain gainTrack(k=1/(k*Ni)) annotation(Placement(transformation(x=30.0,y=-70.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=30.0,y=-70.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));

      equation 
assert(yMax >= yMin, "PID: Limits must be consistent");
        connect(u_s,addP.u1) annotation(Line(points={{-102.0,0.0},{-96.0,0.0},{-96.0,56.0},{-80.0,56.0}},color={0,0,255}));
        connect(u_m,addP.u2) annotation(Line(points={{0.0,-100.0},{0.0,-92.0},{-92.0,-92.0},{-92.0,44.0},{-80.0,44.0}},thickness=0.5,color={0,0,255}));
        connect(u_s,addD.u1) annotation(Line(points={{-102.0,0.0},{-96.0,0.0},{-96.0,6.0},{-82.0,6.0}},color={0,0,255}));
        connect(u_m,addD.u2) annotation(Line(points={{0.0,-100.0},{0.0,-92.0},{-92.0,-92.0},{-92.0,-6.0},{-82.0,-6.0},{-82.0,-6.0}},thickness=0.5,color={0,0,255}));
        connect(u_s,addI.u1) annotation(Line(points={{-100.0,0.0},{-96.0,0.0},{-96.0,-42.0},{-82.0,-42.0}},color={0,0,255}));
        connect(u_m,addI.u2) annotation(Line(points={{0.0,-104.0},{0.0,-92.0},{-92.0,-92.0},{-92.0,-50.0},{-80.0,-50.0}},thickness=0.5,color={0,0,255}));
        connect(gainTrack.y,addI.u3) annotation(Line(points={{20.0,-70.0},{-88.0,-70.0},{-88.0,-58.0},{-80.0,-58.0}},color={0,0,255}));
        connect(addP.y,P.u) annotation(Line(points={{-60.0,50.0},{-40.0,50.0},{-40.0,50.0}},color={0,0,255}));
        connect(addD.y,D.u) annotation(Line(points={{-60.0,0.0},{-42.0,0.0}},color={0,0,255}));
        connect(addI.y,I.u) annotation(Line(points={{-58.0,-50.0},{-40.0,-50.0}},color={0,0,255}));
        connect(P.y,addPID.u1) annotation(Line(points={{-18.0,50.0},{-10.0,50.0},{-10.0,8.0},{0.0,8.0}},color={0,0,255}));
        connect(D.y,addPID.u2) annotation(Line(points={{-20.0,0.0},{-2.0,0.0},{-2.0,0.0}},color={0,0,255}));
        connect(I.y,addPID.u3) annotation(Line(points={{-18.0,-50.0},{-10.0,-50.0},{-10.0,-8.0},{-2.0,-8.0},{-2.0,-8.0}},color={0,0,255}));
        connect(addPID.y,gainPID.u) annotation(Line(points={{21.0,0.0},{28.0,0.0}},color={0,0,255}));
        connect(gainPID.y,addSat.u2) annotation(Line(points={{50.0,0.0},{60.0,0.0},{60.0,-30.0},{74.0,-30.0},{74.0,-40.0}},color={0,0,255}));
        connect(addSat.y,gainTrack.u) annotation(Line(points={{80.0,-62.0},{80.0,-70.0},{42.0,-70.0}},color={0,0,255}));
        connect(gainPID.y,limiter.u) annotation(Line(points={{50.0,0.0},{70.0,0.0}},color={0,0,255}));
        connect(limiter.y,y) annotation(Line(points={{90.0,0.0},{100.0,0.0}},color={0,0,255}));
        connect(limiter.y,addSat.u1) annotation(Line(points={{90.0,0.0},{94.0,0.0},{94.0,-20.0},{86.0,-20.0},{86.0,-40.0}},color={0,0,255}));
      end LimPID;
      block TransferFunction "Linear transfer function"
              extends Interfaces.SISO;
        parameter Real b[:]={1} "Numerator coefficients of transfer function.";
        parameter Real a[:]={1,1} "Denominator coefficients of transfer function.";
        output Real x[size(a, 1) - 1] "State of transfer function from controller canonical form";
      protected 
        parameter Integer na=size(a, 1) "Size of Denominator of transfer function.";
        parameter Integer nb(max=na)=size(b, 1) "Size of Numerator of transfer function.";
        parameter Integer nx=size(a, 1) - 1;
        Real x1dot "Derivative of first state of TransferFcn";
        Real xn "Highest order state of TransferFcn";
        annotation(Documentation(info="
 <HTML>
 <p>
 This block defines the transfer function between the input
 u and the output y
 as (nb = dimension of b, na = dimension of a):
 </p>
 <pre>
            b[1]*s^[nb-1] + b[2]*s^[nb-2] + ... + b[nb]
    y(s) = --------------------------------------------- * u(s)
            a[1]*s^[na-1] + a[2]*s^[na-2] + ... + a[na]
 </pre>
 <p>
 State variables <b>x</b> are defined according to <b>controller canonical</b>
 form. Initial values of the states can be set as start values of <b>x</b>.
 <p>
 <p>
 Example:
 </p>
 <pre>
      TransferFunction g(b = {2,4}, a = {1,3});
 </pre>
 <p>
 results in the following transfer function:
 </p>
 <pre>
         2*s + 4
    y = --------- * u
          s + 3
 </pre>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>August 7, 1999</i>
        by <a href=\"http://www.op.dlr.de/~otter/\">Martin Otter</a>:<br>
        Realized based on a realization of the corresponding
        Dymola library of Hilding Elmqvist.
 </li>
 </ul>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,0.0},{80.0,0.0}}, color={0,0,255}),Text(extent={{-90.0,10.0},{90.0,90.0}}, textString="b(s)", fillColor={0,0,255}),Text(extent={{-90.0,-10.0},{90.0,-90.0}}, textString="a(s)", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{40.0,0.0},{-40.0,0.0}}, color={0,0,0}),Text(extent={{-55.0,55.0},{55.0,5.0}}, textString="b(s)", fillColor={0,0,0}),Text(extent={{-55.0,-5.0},{55.0,-55.0}}, textString="a(s)", fillColor={0,0,0}),Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255})}));

      equation 
        [der(x);xn]=[x1dot;x];
        [u]=transpose([a])*[x1dot;x];
        [y]=transpose([zeros(na - nb, 1);b])*[x1dot;x];
      end TransferFunction;
      block StateSpace "Linear state space system"
              parameter Real A[:,size(A, 1)]={{1,0},{0,1}} "Matrix A of state space model";
        parameter Real B[size(A, 1),:]={{1},{1}} "Matrix B of state space model";
        parameter Real C[:,size(A, 1)]={{1,1}} "Matrix C of state space model";
        parameter Real D[size(C, 1),size(B, 2)]=zeros(size(C, 1), size(B, 2)) "Matrix D of state space model";
        extends Interfaces.MIMO(final nin=size(B, 2),final nout=size(C, 1));
        output Real x[size(A, 1)] "State vector";
        annotation(Documentation(info="
 <HTML>
 <p>
 The State Space block defines the relation
 between the input u and the output
 y in state space form:
 </p>
 <pre>
 
     der(x) = A * x + B * u
         y  = C * x + D * u
 </pre>
 <p>
 The input is a vector of length nu, the output is a vector
 of length ny and nx is the number of states. Accordingly
 </p>
 <pre>
         A has the dimension: A(nx,nx),
         B has the dimension: B(nx,nu),
         C has the dimension: C(ny,nx),
         D has the dimension: D(ny,nu)
 </pre>
 <p>
 Example:
 </p>
 <pre>
      parameter: A = [0.12, 2;3, 1.5]
      parameter: B = [2, 7;3, 1]
      parameter: C = [0.1, 2]
      parameter: D = zeros(ny,nu)
 results in the following equations:
   [der(x[1])]   [0.12  2.00] [x[1]]   [2.0  7.0] [u[1]]
   [         ] = [          ]*[    ] + [        ]*[    ]
   [der(x[2])]   [3.00  1.50] [x[2]]   [0.1  2.0] [u[2]]
                              [x[1]]            [u[1]]
        y[1]   = [0.1  2.0] * [    ] + [0  0] * [    ]
                              [x[2]]            [u[2]]
 </pre>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-90.0,10.0},{-10.0,90.0}}, textString="A", fillColor={0,0,255}),Text(extent={{10.0,10.0},{90.0,90.0}}, textString="B", fillColor={0,0,255}),Text(extent={{-90.0,-10.0},{-10.0,-90.0}}, textString="C", fillColor={0,0,255}),Text(extent={{10.0,-10.0},{90.0,-90.0}}, textString="D", fillColor={0,0,255}),Line(points={{0.0,-90.0},{0.0,90.0}}, color={192,192,192}),Line(points={{-90.0,0.0},{90.0,0.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-60.0,60.0},{60.0,-60.0}}, lineColor={0,0,255}),Text(extent={{-60.0,40.0},{60.0,0.0}}, textString="sx=Ax+Bu", fillColor={0,0,0}),Text(extent={{-60.0,0.0},{60.0,-40.0}}, textString=" y=Cx+Du", fillColor={0,0,0}),Line(points={{-100.0,0.0},{-60.0,0.0}}, color={0,0,255}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255})}));

      equation 
        der(x)=A*x + B*u;
        y=C*x + D*u;
      end StateSpace;
      block Der "Derivative of input (= analytic differentations)"
              extends Interfaces.SISO;
        annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-80.0,76.0},{80.0,-82.0}}, textString="der()", fillColor={0,0,255})}),Documentation(info="<HTML>
 <p>
 Defines that the output y is the <i>derivative</i>
 of the input u. Note, that Modelica.Blocks.Continuous.Derivative
 computes the derivative in an approximate sense, where as this block computes
 the derivative exactly. This requires that the input u is differentiated
 by the Modelica translator, if this derivative is not yet present in
 the model.
 </p>
 </HTML>"));

      equation 
        y=der(u);
      end Der;
    end Continuous;
  end Blocks;
  package Electrical "Library for electrical models"
      extends Modelica.Icons.Library2;
    annotation(preferedView="info",Documentation(info="<html>
 <p>
 This library contains electrical components to build up analog and digital circuits.
 The library is currently structured in the following sublibraries:
 </p>
 <ul>
 <li>Package <b>Analog</b> for basic analog electrical components.</li>
 <li>Package <b>Digital</b> for 2-, 3-, 4-, and 9-value logic of digital circuits.</li>
 <li>Package <b>MultiPhase</b> for electrical
     components with 2, 3 or more phases.</li>
 <li>Package <b>Machines</b> to model electrical motors and generators,
     especially three phase induction machines such as an
     asynchronous motor.</li>
 </ul>
 <p>
 </HTML>
 "),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-29.0,-13.0},{3.0,-27.0}}, lineColor={0,0,0}),Line(points={{37.0,-58.0},{62.0,-58.0}}, color={0,0,0}),Line(points={{36.0,-49.0},{61.0,-49.0}}, color={0,0,0}),Line(points={{-78.0,-50.0},{-43.0,-50.0}}, color={0,0,0}),Line(points={{-67.0,-55.0},{-55.0,-55.0}}, color={0,0,0}),Line(points={{-61.0,-50.0},{-61.0,-20.0},{-29.0,-20.0}}, color={0,0,0}),Line(points={{3.0,-20.0},{48.0,-20.0},{48.0,-49.0}}, color={0,0,0}),Line(points={{48.0,-58.0},{48.0,-78.0},{-61.0,-78.0},{-61.0,-55.0}}, color={0,0,0})}));
    package Analog "Library for analog electrical models"
          import SI = Modelica.SIunits;
      extends Modelica.Icons.Library2;
      annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package contains packages for analog electrical components:
 <ul>
 <li>Basic: basic components (resistor, capacitor, conductor, inductor, transformer, gyrator)</li>
 <li>Semiconductors: semiconductor devices (diode, bipolar and MOS transistors)</li>
 <li>Lines: transmission lines (lossy and lossless)</li>
 <li>Ideal: ideal elements (switches, diode, transformer, idle, short, ...)</li>
 <li>Sources: time-dependend and controlled voltage and current sources</li>
 <li>Sensors: sensors to measure potential, voltage, and current</li>
 </ul>
 </p>
 <dl>
 <dt>
 <b>Main Authors:</b></dt>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden</dd>
 </dl>
 
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association and Fraunhofer-Gesellschaft.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 </HTML>
 "));
      package Examples "Examples for analog electrical packages"
              extends Modelica.Icons.Library2;
        annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package contains examples for the analog electrical package.
 </p>
 <dl>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
        package Utilities "Utilities for examples"
                  extends Modelica.Icons.Library2;
          annotation(Documentation(info="<html>
 <p>
 This package contains utilities ...
 </p>
 <dl>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
          model RealSwitch
                      Ideal.ControlledIdealCommutingSwitch S(level=2.5) annotation(Placement(transformation(x=34.66665,y=41.33335,scale=0.2333335,aspectRatio=1.0),iconTransformation(x=34.66665,y=41.33335,scale=0.2333335,aspectRatio=1.0)));
            Basic.Resistor R(R=0.01) annotation(Placement(transformation(x=-42.66665,y=39.33335,scale=0.2333335,aspectRatio=1.0),iconTransformation(x=-42.66665,y=39.33335,scale=0.2333335,aspectRatio=1.0)));
            Interfaces.Pin p annotation(Placement(transformation(x=-100.0,y=40.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=40.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin n1 annotation(Placement(transformation(x=100.0,y=60.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=60.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin n2 annotation(Placement(transformation(x=100.0,y=14.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=14.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin control annotation(Placement(transformation(x=34.0,y=100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=34.0,y=100.0,scale=0.1,aspectRatio=1.0)));

          equation 
            connect(p,R.p) annotation(Line(points={{-100.0,40.0},{-66.0,39.3333}},color={0,0,255}));
            connect(R.n,S.p) annotation(Line(points={{-19.3333,39.3333},{11.3333,41.3333}},color={0,0,255}));
            connect(n1,S.n1) annotation(Line(points={{100.0,60.0},{58.0,53.0}},color={0,0,255}));
            connect(n2,S.n2) annotation(Line(points={{100.0,14.0},{58.0,41.3333}},color={0,0,255}));
            connect(control,S.control) annotation(Line(points={{34.0,100.0},{34.6667,64.6667}},color={0,0,255}));
            annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
          end RealSwitch;
          model Transistor
                      annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-80.0,80.0},{80.0,-80.0}}, lineColor={0,0,255}),Line(points={{80.0,60.0},{100.0,60.0}}, color={0,0,255}),Line(points={{80.0,-60.0},{100.0,-60.0}}, color={0,0,255}),Line(points={{-100.0,0.0},{-80.0,0.0}}, color={0,0,255}),Line(points={{-60.0,0.0},{-10.0,0.0}}, color={0,0,255}),Line(points={{-10.0,40.0},{-10.0,-40.0}}, color={0,0,255}),Line(points={{60.0,60.0},{40.0,60.0},{-10.0,10.0}}, color={0,0,255}),Line(points={{-10.0,-10.0},{40.0,-60.0},{60.0,-60.0}}, color={0,0,255})}));
            Basic.Resistor rtb(R=0.05) annotation(Placement(transformation(x=-70.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=0.0,scale=0.1,aspectRatio=1.0)));
            Basic.Resistor rtc(R=0.1) annotation(Placement(transformation(x=50.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=50.0,y=10.0,scale=0.1,aspectRatio=1.0)));
            Basic.Capacitor ct(C=1e-10) annotation(Placement(transformation(x=-40.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-40.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
            Semiconductors.NPN Tr(Bf=50,Br=0.1,Is=1e-16,Vak=0.02,Tauf=1.2e-010,Taur=5e-09,Ccs=1e-12,Cje=4e-13,Cjc=5e-13,Phie=0.8,Me=0.4,Phic=0.8,Mc=0.333,Gbc=1e-15,Gbe=1e-15,Vt=0.02585) annotation(Placement(transformation(x=0.0,y=0.0,scale=0.2,aspectRatio=1.0),iconTransformation(x=0.0,y=0.0,scale=0.2,aspectRatio=1.0)));
            Basic.Ground Ground1 annotation(Placement(transformation(x=-40.0,y=-70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-40.0,y=-70.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin c annotation(Placement(transformation(x=100.0,y=60.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=60.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin b annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin e annotation(Placement(transformation(x=100.0,y=-60.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=-60.0,scale=0.1,aspectRatio=1.0)));

          equation 
            connect(rtb.n,Tr.B) annotation(Line(points={{-60.0,0.0},{-20.0,0.0}},color={0,0,255}));
            connect(rtb.n,ct.p) annotation(Line(points={{-60.0,0.0},{-40.0,0.0},{-40.0,-20.0}},color={0,0,255}));
            connect(ct.n,Ground1.p) annotation(Line(points={{-40.0,-40.0},{-40.0,-60.0}},color={0,0,255}));
            connect(Tr.C,rtc.p) annotation(Line(points={{20.0,10.0},{40.0,10.0}},color={0,0,255}));
            connect(rtc.n,c) annotation(Line(points={{60.0,10.0},{80.0,10.0},{80.0,60.0},{100.0,60.0}},color={0,0,255}));
            connect(b,rtb.p) annotation(Line(points={{-100.0,0.0},{-80.0,0.0}},color={0,0,255}));
            connect(Tr.E,e) annotation(Line(points={{20.0,-10.0},{80.0,-10.0},{80.0,-60.0},{100.0,-60.0}},color={0,0,255}));
          end Transistor;
          model NonlinearResistor "Chua's resistor"
                      extends Interfaces.OnePort;
            annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-70.0,30.0},{70.0,-30.0}}, lineColor={0,0,255}),Line(points={{-90.0,0.0},{-70.0,0.0}}, color={0,0,255}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,255}),Line(points={{-50.0,-60.0},{50.0,60.0}}, color={0,0,255}),Polygon(points={{50.0,60.0},{38.0,52.0},{44.0,46.0},{50.0,60.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-70.0,30.0},{70.0,-30.0}}, lineColor={0,0,255}),Line(points={{-90.0,0.0},{-70.0,0.0}}, color={0,0,255}),Line(points={{70.0,0.0},{90.0,0.0}}, color={0,0,255}),Line(points={{-50.0,-60.0},{50.0,60.0}}, color={0,0,255}),Polygon(points={{50.0,60.0},{38.0,52.0},{44.0,46.0},{50.0,60.0}}, fillColor={0,0,255}, fillPattern=FillPattern.Solid, lineColor={0,0,255}),Text(extent={{-100.0,100.0},{100.0,70.0}}, textString="%name", fillColor={0,0,255})}));
            parameter SI.Conductance Ga;
            parameter SI.Conductance Gb;
            parameter SI.Voltage Ve;

          equation 
            i=if v < -Ve then Gb*(v + Ve) - Ga*Ve else if v > Ve then Gb*(v - Ve) + Ga*Ve else Ga*v;
          end NonlinearResistor;
          model Nand "CMOS NAND Gate (see Tietze/Schenk, page 157)"
                      annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Rectangle(extent={{-50.0,70.0},{50.0,-70.0}}, lineColor={0,0,0}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Ellipse(extent={{50.0,5.0},{60.0,-5.0}}, lineColor={0,0,0}, pattern=LinePattern.None),Text(extent={{-16.0,50.0},{14.0,20.0}}, textString="&", fillColor={0,0,0}),Line(points={{60.0,0.0},{100.0,0.0}}, color={0,0,255}),Line(points={{0.0,70.0},{0.0,100.0}}, color={0,0,255}),Line(points={{-50.0,50.0},{-100.0,50.0}}, color={0,0,255}),Line(points={{-50.0,-50.0},{-100.0,-50.0}}, color={0,0,255}),Ellipse(extent={{50.0,5.0},{60.0,-5.0}}, lineColor={0,0,0}),Text(extent={{-100.0,34.0},{-90.0,24.0}}, textString="x1", fillColor={0,0,255}),Text(extent={{-100.0,-65.0},{-90.0,-75.0}}, textString="x2", fillColor={0,0,255}),Text(extent={{90.0,-15.0},{100.0,-25.0}}, textString="y", fillColor={0,0,255})}),Documentation(info="<html>
 <p>
 The nand gate is a basic CMOS building block. It consists of four CMOS transistors.
 <p>
 <dl>
 <dt>
 <b>Reference:</b>
 <dd>
 Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 157
 <p>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
            Semiconductors.PMOS TP1(W=6.5e-006,L=3.1e-006,Beta=1.05e-005,Vt=-1,K2=0.41,K5=0.8385,dW=-2.5e-006,dL=-2.1e-006) annotation(Placement(transformation(x=20.0,y=70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=20.0,y=70.0,scale=0.1,aspectRatio=1.0)));
            Semiconductors.PMOS TP2(W=6.5e-006,L=3.1e-006,Beta=1.05e-005,Vt=-1,K2=0.41,K5=0.8385,dW=-2.5e-006,dL=-2.1e-006) annotation(Placement(transformation(x=-30.0,y=55.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=55.0,scale=0.1,aspectRatio=1.0)));
            Semiconductors.NMOS TN1(W=6.5e-006,L=3.1e-006,Beta=4.1e-005,Vt=0.8,K2=1.144,K5=0.7311,dW=-2.5e-006,dL=-1.5e-006) annotation(Placement(transformation(x=20.0,y=25.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=20.0,y=25.0,scale=0.1,aspectRatio=1.0)));
            Semiconductors.NMOS TN2(W=6.5e-006,L=3.1e-006,Beta=4.1e-005,Vt=0.8,K2=1.144,K5=0.7311,dW=-2.5e-006,dL=-1.5e-006) annotation(Placement(transformation(x=20.0,y=-15.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=20.0,y=-15.0,scale=0.1,aspectRatio=1.0)));
            Basic.Capacitor C4(C=4e-14) annotation(Placement(transformation(x=60.0,y=30.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=60.0,y=30.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
            Basic.Capacitor C7(C=4e-14) annotation(Placement(transformation(x=55.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=55.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
            Basic.Ground Gnd annotation(Placement(transformation(x=45.0,y=-20.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=45.0,y=-20.0,scale=0.05,aspectRatio=1.0)));
            Basic.Ground Gnd2 annotation(Placement(transformation(x=60.0,y=5.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=60.0,y=5.0,scale=0.05,aspectRatio=1.0)));
            Basic.Ground Gnd3 annotation(Placement(transformation(x=55.0,y=-75.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=55.0,y=-75.0,scale=0.05,aspectRatio=1.0)));
            Basic.Ground Gnd6 annotation(Placement(transformation(x=-10.0,y=35.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-10.0,y=35.0,scale=0.05,aspectRatio=1.0)));
            Basic.Ground Gnd7 annotation(Placement(transformation(x=45.0,y=20.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=45.0,y=20.0,scale=0.05,aspectRatio=1.0)));
            Basic.Ground Gnd8 annotation(Placement(transformation(x=45.0,y=65.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=45.0,y=65.0,scale=0.05,aspectRatio=1.0)));
            Interfaces.Pin x1 annotation(Placement(transformation(x=-100.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=50.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin x2 annotation(Placement(transformation(x=-100.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin Vdd annotation(Placement(transformation(x=0.0,y=100.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=100.0,scale=0.1,aspectRatio=1.0)));
            Interfaces.Pin y annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0)));

          equation 
            connect(TN1.S,TN2.D) annotation(Line(points={{30.0,20.0},{30.0,-10.0}},color={0,0,255}));
            connect(TN2.B,Gnd.p) annotation(Line(points={{30.0,-15.0},{38.0,-15.0},{38.0,-15.0},{45.0,-15.0}},color={0,0,255}));
            connect(TN2.D,C7.p) annotation(Line(points={{30.0,-10.0},{55.0,-10.0},{55.0,-40.0}},color={0,0,255}));
            connect(TN2.S,Gnd.p) annotation(Line(points={{30.0,-20.0},{38.0,-20.0},{38.0,-15.0},{45.0,-15.0}},color={0,0,255}));
            connect(TP1.S,TN1.D) annotation(Line(points={{30.0,65.0},{30.0,30.0}},color={0,0,255}));
            connect(TP1.G,TN1.G) annotation(Line(points={{10.0,65.0},{10.0,20.0}},color={0,0,255}));
            connect(C4.n,Gnd2.p) annotation(Line(points={{60.0,20.0},{60.0,10.0}},color={0,0,255}));
            connect(C7.n,Gnd3.p) annotation(Line(points={{55.0,-60.0},{55.0,-70.0}},color={0,0,255}));
            connect(TP2.B,Gnd6.p) annotation(Line(points={{-20.0,55.0},{-10.0,55.0},{-10.0,40.0}},color={0,0,255}));
            connect(TN1.B,Gnd7.p) annotation(Line(points={{30.0,25.0},{45.0,25.0}},color={0,0,255}));
            connect(TP1.B,Gnd8.p) annotation(Line(points={{30.0,70.0},{45.0,70.0}},color={0,0,255}));
            connect(TP2.G,x1) annotation(Line(points={{-40.0,50.0},{-100.0,50.0}},color={0,0,255}));
            connect(TP2.G,TN2.G) annotation(Line(points={{-40.0,50.0},{-40.0,-20.0},{10.0,-20.0}},color={0,0,255}));
            connect(TN1.G,x2) annotation(Line(points={{10.0,20.0},{-70.0,20.0},{-70.0,-50.0},{-100.0,-50.0}},color={0,0,255}));
            connect(TP2.S,TN1.D) annotation(Line(points={{-20.0,50.0},{30.0,50.0},{30.0,30.0}},color={0,0,255}));
            connect(TN1.D,C4.p) annotation(Line(points={{30.0,30.0},{30.0,50.0},{60.0,50.0},{60.0,40.0}},color={0,0,255}));
            connect(Vdd,TP1.D) annotation(Line(points={{0.0,100.0},{0.0,80.0},{30.0,80.0},{30.0,75.0}},color={0,0,255}));
            connect(TP2.D,Vdd) annotation(Line(points={{-20.0,60.0},{-20.0,80.0},{0.0,80.0},{0.0,100.0}},color={0,0,255}));
            connect(C4.p,y) annotation(Line(points={{60.0,40.0},{60.0,50.0},{80.0,50.0},{80.0,0.0},{100.0,0.0}},color={0,0,255}));
          end Nand;
        end Utilities;
        model HeatingNPN_OrGate "Heating NPN Or Gate"
                  extends Modelica.Icons.Example;
          constant Real CapVal=0;
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,100.0},{-6.0,72.0}}, textString="Heating NPN Nand Gate", fillColor={0,0,255})}));
          Modelica.Thermal.HeatTransfer.HeatCapacitor HeatCapacitor1(C=0.1) annotation(Placement(transformation(x=76.0,y=-84.0,scale=0.1,aspectRatio=1.0,rotation=180),iconTransformation(x=76.0,y=-84.0,scale=0.1,aspectRatio=1.0,rotation=180)));
          Modelica.Thermal.HeatTransfer.ThermalConductor TC1(G=0.01) annotation(Placement(transformation(x=90.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=90.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Thermal.HeatTransfer.ThermalConductor TC2(G=0.01) annotation(Placement(transformation(x=60.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=60.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          annotation(Documentation(info="<HTML>
 <P>
 The heating NPN nand gate shows a heat flow always if a transistor is leading.
 </P>
 <P>
 Simulate until T=200 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 V1.v and V2.v and C2.v <br>
 HeatCapacitor1.port.T and T1.heatPort.T and T2.heatPort.T<br>
 T1.heatPort.Q_flow and T2.heatPort.Q_flow<br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 6, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=200));
          Modelica.Electrical.Analog.Sources.RampVoltage V(V=6,duration=5) annotation(Placement(transformation(x=90.0,y=38.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=90.0,y=38.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Sources.TrapezoidVoltage V1(V=6,startTime=55,rising=5,width=15,falling=5,period=50,nperiod=10) annotation(Placement(transformation(x=-90.0,y=18.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-90.0,y=18.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Sources.TrapezoidVoltage V2(V=6,startTime=65,rising=5,width=15,falling=5,period=50,nperiod=10) annotation(Placement(transformation(x=-50.0,y=-42.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-50.0,y=-42.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Basic.Resistor R1(R=1800) annotation(Placement(transformation(x=-80.0,y=58.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-80.0,y=58.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R2(R=1800) annotation(Placement(transformation(x=-26.0,y=-12.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-26.0,y=-12.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor RI(R=40) annotation(Placement(transformation(x=70.0,y=68.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=68.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd annotation(Placement(transformation(x=90.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=90.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd1 annotation(Placement(transformation(x=-90.0,y=-12.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=-12.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd2 annotation(Placement(transformation(x=-50.0,y=-72.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=-72.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd3 annotation(Placement(transformation(x=0.0,y=26.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=26.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd4 annotation(Placement(transformation(x=40.0,y=-42.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=40.0,y=-42.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Capacitor C1(C=CapVal) annotation(Placement(transformation(x=-70.0,y=38.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-70.0,y=38.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Basic.Capacitor C2(C=CapVal) annotation(Placement(transformation(x=60.0,y=42.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=60.0,y=42.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Basic.Capacitor C3(C=CapVal) annotation(Placement(transformation(x=-16.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-16.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Gnd5 annotation(Placement(transformation(x=-16.0,y=-66.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-16.0,y=-66.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd6 annotation(Placement(transformation(x=60.0,y=16.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=60.0,y=16.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Gnd7 annotation(Placement(transformation(x=-70.0,y=12.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=12.0,scale=0.1,aspectRatio=1.0)));
          Semiconductors.HeatingNPN T1(Bf=100,Br=1,Is=1e-14,Vak=0,Tauf=0,Taur=0,Ccs=CapVal,Cje=CapVal,Cjc=CapVal,Phie=1,Me=0.5,Phic=1,Mc=0.5,Gbc=1e-12,Gbe=1e-12,EMax=40) annotation(Placement(transformation(x=-10.0,y=58.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=58.0,scale=0.1,aspectRatio=1.0)));
          Semiconductors.HeatingNPN T2(Bf=100,Br=1,Is=1e-14,Vak=0,Tauf=0,Taur=0,Ccs=CapVal,Cje=CapVal,Cjc=CapVal,Phie=1,Me=0.5,Phic=1,Mc=0.5,Gbc=1e-12,Gbe=1e-12,EMax=40) annotation(Placement(transformation(x=30.0,y=-12.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-12.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(Gnd1.p,V1.n) annotation(Line(points={{-90.0,-2.0},{-90.0,8.0}},color={0,0,255}));
          connect(V1.p,R1.p) annotation(Line(points={{-90.0,28.0},{-90.0,58.0}},color={0,0,255}));
          connect(RI.n,V.p) annotation(Line(points={{80.0,68.0},{90.0,68.0},{90.0,48.0}},color={0,0,255}));
          connect(Gnd.p,V.n) annotation(Line(points={{90.0,20.0},{90.0,28.0}},color={0,0,255}));
          connect(V2.p,R2.p) annotation(Line(points={{-50.0,-32.0},{-50.0,-12.0},{-36.0,-12.0}},color={0,0,255}));
          connect(Gnd2.p,V2.n) annotation(Line(points={{-50.0,-62.0},{-50.0,-52.0}},color={0,0,255}));
          connect(Gnd7.p,C1.n) annotation(Line(points={{-70.0,22.0},{-70.0,28.0}},color={0,0,255}));
          connect(C2.p,RI.p) annotation(Line(points={{60.0,52.0},{60.0,68.0}},color={0,0,255}));
          connect(Gnd6.p,C2.n) annotation(Line(points={{60.0,26.0},{60.0,32.0}},color={0,0,255}));
          connect(C3.p,R2.n) annotation(Line(points={{-16.0,-30.0},{-16.0,-21.0},{-16.0,-21.0},{-16.0,-12.0}},color={0,0,255}));
          connect(C1.p,R1.n) annotation(Line(points={{-70.0,48.0},{-70.0,58.0}},color={0,0,255}));
          connect(Gnd5.p,C3.n) annotation(Line(points={{-16.0,-56.0},{-16.0,-53.0},{-16.0,-50.0},{-16.0,-50.0}},color={0,0,255}));
          connect(T1.B,R1.n) annotation(Line(points={{-20.0,58.0},{-70.0,58.0}},color={0,0,255}));
          connect(T1.E,Gnd3.p) annotation(Line(points={{0.0,53.0},{0.0,36.0}},color={0,0,255}));
          connect(RI.p,T1.C) annotation(Line(points={{60.0,68.0},{30.0,68.0},{30.0,63.0},{0.0,63.0}},color={0,0,255}));
          connect(T2.B,R2.n) annotation(Line(points={{20.0,-12.0},{-16.0,-12.0}},color={0,0,255}));
          connect(T2.E,Gnd4.p) annotation(Line(points={{40.0,-17.0},{40.0,-32.0}},color={0,0,255}));
          connect(T2.C,RI.p) annotation(Line(points={{40.0,-7.0},{40.0,68.0},{60.0,68.0}},color={0,0,255}));
          connect(TC1.port_b,HeatCapacitor1.port) annotation(Line(points={{90.0,-61.0},{84.0,-61.0},{84.0,-74.0},{76.0,-74.0}},color={191,0,0}));
          connect(TC2.port_b,HeatCapacitor1.port) annotation(Line(points={{60.0,-61.0},{68.0,-61.0},{68.0,-74.0},{76.0,-74.0}},color={191,0,0}));
          connect(TC2.port_a,T2.heatPort) annotation(Line(points={{60.0,-39.0},{60.0,-22.0},{30.0,-22.0}},color={191,0,0}));
          connect(TC1.port_a,T1.heatPort) annotation(Line(points={{90.0,-39.0},{90.0,2.0},{-10.0,2.0},{-10.0,48.0}},color={191,0,0}));
        end HeatingNPN_OrGate;
        model CharacteristicIdealDiodes "Characteristic of ideal diodes"
                  extends Modelica.Icons.Example;
          Modelica.Electrical.Analog.Ideal.IdealDiode Ideal(Ron=0,Goff=0) annotation(Placement(transformation(x=10.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=10.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Ideal.IdealDiode With_Ron_Goff(Ron=0.1,Goff=0.1) annotation(Placement(transformation(x=10.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=10.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Ideal.IdealDiode With_Ron_Goff_Vknee(Ron=0.2,Goff=0.2,Vknee=5) annotation(Placement(transformation(x=10.0,y=-30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=10.0,y=-30.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(V=10,offset=-9) annotation(Placement(transformation(x=-40.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-40.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 annotation(Placement(transformation(x=-40.0,y=-70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-40.0,y=-70.0,scale=0.1,aspectRatio=1.0)));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-88.0,102.0},{92.0,48.0}}, textString="Characteristic Ideal Diodes", fillColor={0,0,255})}));
          Modelica.Electrical.Analog.Basic.Resistor R1(R=0.001) annotation(Placement(transformation(x=70.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R2(R=0.001) annotation(Placement(transformation(x=70.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R3(R=0.001) annotation(Placement(transformation(x=70.0,y=-30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=-30.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage2(V=10,offset=0) annotation(Placement(transformation(x=-60.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-60.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage3(V=10,offset=0) annotation(Placement(transformation(x=-20.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-20.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          annotation(Documentation(info="<HTML>
 <P>
 Three examples of ideal diodes are shown:<br><br>
 the <b>totally ideal diode</b> (Ideal) with all parameters to be zero <br>
 the <b>nearly ideal diode</b> with <i>Ron=0.1</i> and <i>Goff=0.1</i> <br>
 the nearly ideal but <b>displaced diode</b> with <i>Vknee=5</i> and <i>Ron=0.1</i> and 
 <i>Goff=0.1</i> <br><br>
 The resistance and conductance are chosen untypically high since the slopes should
 be seen in the graphics.
 </P>
 <P>
 Simulate until T=1 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 Ideal.i versus Ideal.v <br>
 With_Ron_Goff.i versus With_Ron_Goff.v<br>
 With_Ron_Goff_Vknee.i versus With_Ron_Goff_Vknee.v<br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 7, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=1));

        equation 
          connect(Ground1.p,SineVoltage1.n) annotation(Line(points={{-40.0,-60.0},{-40.0,-10.0}},color={0,0,255}));
          connect(Ideal.n,R1.p) annotation(Line(points={{20.0,50.0},{60.0,50.0}},color={0,0,255}));
          connect(With_Ron_Goff.n,R2.p) annotation(Line(points={{20.0,10.0},{60.0,10.0}},color={0,0,255}));
          connect(With_Ron_Goff_Vknee.n,R3.p) annotation(Line(points={{20.0,-30.0},{60.0,-30.0}},color={0,0,255}));
          connect(R1.n,R2.n) annotation(Line(points={{80.0,50.0},{80.0,10.0}},color={0,0,255}));
          connect(R2.n,R3.n) annotation(Line(points={{80.0,10.0},{80.0,-30.0}},color={0,0,255}));
          connect(R3.n,Ground1.p) annotation(Line(points={{80.0,-30.0},{80.0,-60.0},{-40.0,-60.0}},color={0,0,255}));
          connect(SineVoltage2.p,Ideal.p) annotation(Line(points={{-60.0,50.0},{0.0,50.0}},color={0,0,255}));
          connect(SineVoltage2.n,Ground1.p) annotation(Line(points={{-60.0,30.0},{-60.0,-60.0},{-40.0,-60.0}},color={0,0,255}));
          connect(SineVoltage1.p,With_Ron_Goff.p) annotation(Line(points={{-40.0,10.0},{0.0,10.0}},color={0,0,255}));
          connect(With_Ron_Goff_Vknee.p,SineVoltage3.p) annotation(Line(points={{0.0,-30.0},{-20.0,-30.0}},color={0,0,255}));
          connect(SineVoltage3.n,Ground1.p) annotation(Line(points={{-20.0,-50.0},{-20.0,-60.0},{-40.0,-60.0}},color={0,0,255}));
        end CharacteristicIdealDiodes;
        model ShowSaturatingInductor "Simple demo to show behaviour of SaturatingInductor component"
                  extends Modelica.Icons.Example;
          parameter Modelica.SIunits.Inductance Lzer=2;
          parameter Modelica.SIunits.Inductance Lnom=1;
          parameter Modelica.SIunits.Current Inom=1;
          parameter Modelica.SIunits.Inductance Linf=0.5;
          parameter Modelica.SIunits.Voltage U=1.25;
          parameter Modelica.SIunits.Frequency f=1/(2*Modelica.Constants.pi);
          parameter Modelica.SIunits.Angle phase=Modelica.Constants.pi/2;
          output Modelica.SIunits.Voltage v;
          output Modelica.SIunits.Current i;
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),experiment(StopTime=6.2832,Interval=0.01),experimentSetupOutput(doublePrecision=true));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(V=U,phase=phase,freqHz=f) annotation(Placement(transformation(x=-20.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-20.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 annotation(Placement(transformation(x=-20.0,y=-20.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-20.0,y=-20.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.SaturatingInductor SaturatingInductance1(Lzer=Lzer,Lnom=Lnom,Inom=Inom,Linf=Linf) annotation(Placement(transformation(x=22.0,y=6.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=22.0,y=6.0,scale=0.1,aspectRatio=1.0,rotation=-90)));

        equation 
          v=SaturatingInductance1.v;
          i=SaturatingInductance1.i;
          connect(SineVoltage1.n,Ground1.p) annotation(Line(points={{-20.0,-10.0},{-20.0,-10.0}},color={0,0,255}));
          connect(SineVoltage1.n,SaturatingInductance1.n) annotation(Line(points={{-20.0,-10.0},{22.0,-10.0},{22.0,-4.0}},color={0,0,255}));
          connect(SaturatingInductance1.p,SineVoltage1.p) annotation(Line(points={{22.0,16.0},{22.0,26.0},{-20.0,26.0},{-20.0,10.0}},color={0,0,255}));
        end ShowSaturatingInductor;
        encapsulated model CauerFilter "CAUER Switched Capacitor Filter"
                  import Modelica.Electrical.Analog.Basic;
          import Modelica.Electrical.Analog.Sources;
          import Modelica.Electrical.Analog.Examples.Utilities;
          import Modelica.Icons;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 The example Cauer Filter is a low-pass-filter of the fifth order. It is realized
 using a switched-capacitor network. The voltage source V is the input voltage,
 and the Op5.p2.v is the filter output voltage. The pulse response is calculated.
 <p>
 The simulation end time should be 2e5. Please plot the output voltage Op5.p2.v.
 <p>
 <dl>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
          Sources.TrapezoidVoltage V(V=1,startTime=499,rising=1,width=1500,falling=1,period=50000,nperiod=1) annotation(Placement(transformation(x=-85.7143,y=85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=-85.7143,y=85.7143,scale=0.1,aspectRatio=1.0)));
          Sources.TrapezoidVoltage Clk(V=5,rising=5,width=500,falling=5,period=1000) annotation(Placement(transformation(x=-57.1429,y=85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=-57.1429,y=85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C1(C=1) annotation(Placement(transformation(x=-28.5714,y=85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=-28.5714,y=85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C2(C=1.55) annotation(Placement(transformation(x=0.0,y=85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C3(C=1.527) annotation(Placement(transformation(x=28.5714,y=85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=28.5714,y=85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C4(C=1) annotation(Placement(transformation(x=57.1429,y=85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=57.1429,y=85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C5(C=1) annotation(Placement(transformation(x=85.7143,y=85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=85.7143,y=85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C6(C=1.018) annotation(Placement(transformation(x=-85.7143,y=57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=-85.7143,y=57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C7(C=1) annotation(Placement(transformation(x=-57.1429,y=57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=-57.1429,y=57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C8(C=1.644) annotation(Placement(transformation(x=-28.5714,y=57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=-28.5714,y=57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C9(C=2) annotation(Placement(transformation(x=0.0,y=57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C10(C=1) annotation(Placement(transformation(x=28.5714,y=57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=28.5714,y=57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C11(C=2) annotation(Placement(transformation(x=57.1429,y=57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=57.1429,y=57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C12(C=1) annotation(Placement(transformation(x=85.7143,y=57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=85.7143,y=57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C13(C=9.862) annotation(Placement(transformation(x=-85.7143,y=28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=-85.7143,y=28.5714,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C14(C=7.23) annotation(Placement(transformation(x=-57.1429,y=28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=-57.1429,y=28.5714,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C15(C=10.06) annotation(Placement(transformation(x=-28.5714,y=28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=-28.5714,y=28.5714,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C16(C=10.23) annotation(Placement(transformation(x=0.0,y=28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=28.5714,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C17(C=12.76) annotation(Placement(transformation(x=28.5714,y=28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=28.5714,y=28.5714,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C18(C=8.676) annotation(Placement(transformation(x=57.1429,y=28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=57.1429,y=28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S1 annotation(Placement(transformation(x=85.7143,y=28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=85.7143,y=28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S2 annotation(Placement(transformation(x=-85.7143,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-85.7143,y=0.0,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S3 annotation(Placement(transformation(x=-57.1429,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-57.1429,y=0.0,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S4 annotation(Placement(transformation(x=-28.5714,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-28.5714,y=0.0,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S5 annotation(Placement(transformation(x=0.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S6 annotation(Placement(transformation(x=28.5714,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=28.5714,y=0.0,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S7 annotation(Placement(transformation(x=57.1429,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=57.1429,y=0.0,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S8 annotation(Placement(transformation(x=85.7143,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=85.7143,y=0.0,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S9 annotation(Placement(transformation(x=-85.7143,y=-28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=-85.7143,y=-28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S10 annotation(Placement(transformation(x=-57.1429,y=-28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=-57.1429,y=-28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S11 annotation(Placement(transformation(x=-28.5714,y=-28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=-28.5714,y=-28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S12 annotation(Placement(transformation(x=0.0,y=-28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S13 annotation(Placement(transformation(x=28.5714,y=-28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=28.5714,y=-28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S14 annotation(Placement(transformation(x=57.1429,y=-28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=57.1429,y=-28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S15 annotation(Placement(transformation(x=85.7143,y=-28.5714,scale=0.1,aspectRatio=1.0),iconTransformation(x=85.7143,y=-28.5714,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S16 annotation(Placement(transformation(x=-85.7143,y=-57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=-85.7143,y=-57.1429,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S17 annotation(Placement(transformation(x=-57.1429,y=-57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=-57.1429,y=-57.1429,scale=0.1,aspectRatio=1.0)));
          Utilities.RealSwitch S18 annotation(Placement(transformation(x=-28.5714,y=-57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=-28.5714,y=-57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.VCV Op1(gain=30000) annotation(Placement(transformation(x=0.0,y=-57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=0.0,y=-57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.VCV Op2(gain=30000) annotation(Placement(transformation(x=28.5714,y=-57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=28.5714,y=-57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.VCV Op3(gain=30000) annotation(Placement(transformation(x=57.1429,y=-57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=57.1429,y=-57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.VCV Op4(gain=30000) annotation(Placement(transformation(x=85.7143,y=-57.1429,scale=0.1,aspectRatio=1.0),iconTransformation(x=85.7143,y=-57.1429,scale=0.1,aspectRatio=1.0)));
          Basic.VCV Op5(gain=30000) annotation(Placement(transformation(x=-85.7143,y=-85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=-85.7143,y=-85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Ground G annotation(Placement(transformation(x=-57.1429,y=-85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=-57.1429,y=-85.7143,scale=0.1,aspectRatio=1.0)));
          Basic.Ground M annotation(Placement(transformation(x=-28.5714,y=-85.7143,scale=0.1,aspectRatio=1.0),iconTransformation(x=-28.5714,y=-85.7143,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(S1.n1,V.p) annotation(Line(points={{95.7143,34.5714},{-95.7143,85.7143}},color={0,0,255}));
          connect(C8.p,C18.n) annotation(Line(points={{-38.5714,57.1429},{67.1429,28.5714}},color={0,0,255}));
          connect(C8.p,S11.n1) annotation(Line(points={{-38.5714,57.1429},{-18.5714,-22.5714}},color={0,0,255}));
          connect(C8.p,S17.n1) annotation(Line(points={{-38.5714,57.1429},{-47.1429,-51.1429}},color={0,0,255}));
          connect(C8.p,Op5.p2) annotation(Line(points={{-38.5714,57.1429},{-75.7143,-80.7143}},color={0,0,255}));
          connect(C2.p,C13.p) annotation(Line(points={{-10.0,85.7143},{-95.7143,28.5714}},color={0,0,255}));
          connect(C2.p,C16.n) annotation(Line(points={{-10.0,85.7143},{10.0,28.5714}},color={0,0,255}));
          connect(C2.p,S7.n1) annotation(Line(points={{-10.0,85.7143},{67.1429,6.0}},color={0,0,255}));
          connect(C2.p,S13.n1) annotation(Line(points={{-10.0,85.7143},{38.5714,-22.5714}},color={0,0,255}));
          connect(C2.p,Op3.p2) annotation(Line(points={{-10.0,85.7143},{67.1429,-52.1429}},color={0,0,255}));
          connect(C6.p,C14.n) annotation(Line(points={{-95.7143,57.1429},{-47.1429,28.5714}},color={0,0,255}));
          connect(C6.p,S1.n2) annotation(Line(points={{-95.7143,57.1429},{95.7143,29.9714}},color={0,0,255}));
          connect(C6.p,S5.n1) annotation(Line(points={{-95.7143,57.1429},{10.0,6.0}},color={0,0,255}));
          connect(C6.p,Op1.p2) annotation(Line(points={{-95.7143,57.1429},{10.0,-52.1429}},color={0,0,255}));
          connect(C15.n,S9.n2) annotation(Line(points={{-18.5714,28.5714},{-75.7143,-27.1714}},color={0,0,255}));
          connect(C15.n,S3.n1) annotation(Line(points={{-18.5714,28.5714},{-47.1429,6.0}},color={0,0,255}));
          connect(C15.n,Op2.p2) annotation(Line(points={{-18.5714,28.5714},{38.5714,-52.1429}},color={0,0,255}));
          connect(C14.p,C2.n) annotation(Line(points={{-67.1429,28.5714},{10.0,85.7143}},color={0,0,255}));
          connect(C14.p,S2.n2) annotation(Line(points={{-67.1429,28.5714},{-75.7143,1.4}},color={0,0,255}));
          connect(C14.p,S4.n1) annotation(Line(points={{-67.1429,28.5714},{-18.5714,6.0}},color={0,0,255}));
          connect(C14.p,Op1.n1) annotation(Line(points={{-67.1429,28.5714},{-10.0,-62.1429}},color={0,0,255}));
          connect(C15.p,S6.n2) annotation(Line(points={{-38.5714,28.5714},{38.5714,1.4}},color={0,0,255}));
          connect(C15.p,S8.n2) annotation(Line(points={{-38.5714,28.5714},{95.7143,1.4}},color={0,0,255}));
          connect(C15.p,Op2.n1) annotation(Line(points={{-38.5714,28.5714},{18.5714,-62.1429}},color={0,0,255}));
          connect(C16.p,C6.n) annotation(Line(points={{-10.0,28.5714},{-75.7143,57.1429}},color={0,0,255}));
          connect(C16.p,C8.n) annotation(Line(points={{-10.0,28.5714},{-18.5714,57.1429}},color={0,0,255}));
          connect(C16.p,S10.n2) annotation(Line(points={{-10.0,28.5714},{-47.1429,-27.1714}},color={0,0,255}));
          connect(C16.p,Op3.n1) annotation(Line(points={{-10.0,28.5714},{47.1429,-62.1429}},color={0,0,255}));
          connect(C17.p,S12.n1) annotation(Line(points={{18.5714,28.5714},{10.0,-22.5714}},color={0,0,255}));
          connect(C17.p,S14.n1) annotation(Line(points={{18.5714,28.5714},{67.1429,-22.5714}},color={0,0,255}));
          connect(C17.p,Op4.n1) annotation(Line(points={{18.5714,28.5714},{75.7143,-62.1429}},color={0,0,255}));
          connect(C18.p,C13.n) annotation(Line(points={{47.1429,28.5714},{16.4286,28.5714},{16.4286,28.5714},{-14.2857,28.5714},{-14.2857,28.5714},{-75.7143,28.5714}},color={0,0,255}));
          connect(C18.p,S16.n1) annotation(Line(points={{47.1429,28.5714},{-75.7143,-51.1429}},color={0,0,255}));
          connect(C18.p,S18.n1) annotation(Line(points={{47.1429,28.5714},{-18.5714,-51.1429}},color={0,0,255}));
          connect(C18.p,Op5.n1) annotation(Line(points={{47.1429,28.5714},{-95.7143,-90.7143}},color={0,0,255}));
          connect(C17.n,S15.n2) annotation(Line(points={{38.5714,28.5714},{95.7143,-27.1714}},color={0,0,255}));
          connect(C17.n,S17.n2) annotation(Line(points={{38.5714,28.5714},{-47.1429,-55.7429}},color={0,0,255}));
          connect(C17.n,S9.n1) annotation(Line(points={{38.5714,28.5714},{-75.7143,-22.5714}},color={0,0,255}));
          connect(C17.n,Op4.p2) annotation(Line(points={{38.5714,28.5714},{95.7143,-52.1429}},color={0,0,255}));
          connect(C1.n,S2.p) annotation(Line(points={{-18.5714,85.7143},{-95.7143,4.0}},color={0,0,255}));
          connect(C3.p,S3.p) annotation(Line(points={{18.5714,85.7143},{-67.1429,4.0}},color={0,0,255}));
          connect(C3.n,S4.p) annotation(Line(points={{38.5714,85.7143},{-38.5714,4.0}},color={0,0,255}));
          connect(C4.p,S5.p) annotation(Line(points={{47.1429,85.7143},{-10.0,4.0}},color={0,0,255}));
          connect(C4.n,S6.p) annotation(Line(points={{67.1429,85.7143},{18.5714,4.0}},color={0,0,255}));
          connect(C5.p,S7.p) annotation(Line(points={{75.7143,85.7143},{47.1429,4.0}},color={0,0,255}));
          connect(C5.n,S8.p) annotation(Line(points={{95.7143,85.7143},{75.7143,4.0}},color={0,0,255}));
          connect(C7.p,S9.p) annotation(Line(points={{-67.1429,57.1429},{-95.7143,-24.5714}},color={0,0,255}));
          connect(C7.n,S10.p) annotation(Line(points={{-47.1429,57.1429},{-67.1429,-24.5714}},color={0,0,255}));
          connect(C9.p,S11.p) annotation(Line(points={{-10.0,57.1429},{-38.5714,-24.5714}},color={0,0,255}));
          connect(C9.n,S12.p) annotation(Line(points={{10.0,57.1429},{-10.0,-24.5714}},color={0,0,255}));
          connect(C10.p,S13.p) annotation(Line(points={{18.5714,57.1429},{18.5714,36.7143},{18.5714,36.7143},{18.5714,16.2858},{18.5714,-24.5714},{18.5714,-24.5714}},color={0,0,255}));
          connect(C10.n,S14.p) annotation(Line(points={{38.5714,57.1429},{47.1429,-24.5714}},color={0,0,255}));
          connect(C11.p,S15.p) annotation(Line(points={{47.1429,57.1429},{75.7143,-24.5714}},color={0,0,255}));
          connect(C11.n,S16.p) annotation(Line(points={{67.1429,57.1429},{-95.7143,-53.1429}},color={0,0,255}));
          connect(C12.p,S17.p) annotation(Line(points={{75.7143,57.1429},{-67.1429,-53.1429}},color={0,0,255}));
          connect(C12.n,S18.p) annotation(Line(points={{95.7143,57.1429},{-38.5714,-53.1429}},color={0,0,255}));
          connect(C1.p,S1.p) annotation(Line(points={{-38.5714,85.7143},{75.7143,32.5714}},color={0,0,255}));
          connect(S1.control,Clk.p) annotation(Line(points={{89.1143,38.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S2.control,Clk.p) annotation(Line(points={{-82.3143,10.0},{-67.1429,85.7143}},color={0,0,255}));
          connect(S3.control,Clk.p) annotation(Line(points={{-53.7429,10.0},{-67.1429,85.7143}},color={0,0,255}));
          connect(S4.control,Clk.p) annotation(Line(points={{-25.1714,10.0},{-67.1429,85.7143}},color={0,0,255}));
          connect(S5.control,Clk.p) annotation(Line(points={{3.4,10.0},{-67.1429,85.7143}},color={0,0,255}));
          connect(S6.control,Clk.p) annotation(Line(points={{31.9714,10.0},{-67.1429,85.7143}},color={0,0,255}));
          connect(S7.control,Clk.p) annotation(Line(points={{60.5429,10.0},{-67.1429,85.7143}},color={0,0,255}));
          connect(S8.control,Clk.p) annotation(Line(points={{89.1143,10.0},{-67.1429,85.7143}},color={0,0,255}));
          connect(S9.control,Clk.p) annotation(Line(points={{-82.3143,-18.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S10.control,Clk.p) annotation(Line(points={{-53.7429,-18.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S11.control,Clk.p) annotation(Line(points={{-25.1714,-18.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S12.control,Clk.p) annotation(Line(points={{3.4,-18.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S13.control,Clk.p) annotation(Line(points={{31.9714,-18.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S14.control,Clk.p) annotation(Line(points={{60.5429,-18.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S15.control,Clk.p) annotation(Line(points={{89.1143,-18.5714},{-67.1429,85.7143}},color={0,0,255}));
          connect(S16.control,Clk.p) annotation(Line(points={{-82.3143,-47.1429},{-67.1429,85.7143}},color={0,0,255}));
          connect(S17.control,Clk.p) annotation(Line(points={{-53.7429,-47.1429},{-67.1429,85.7143}},color={0,0,255}));
          connect(S18.control,Clk.p) annotation(Line(points={{-25.1714,-47.1429},{-67.1429,85.7143}},color={0,0,255}));
          connect(G.p,V.n) annotation(Line(points={{-57.1429,-75.7143},{-75.7143,85.7143}},color={0,0,255}));
          connect(G.p,S3.n2) annotation(Line(points={{-57.1429,-75.7143},{-47.1429,1.4}},color={0,0,255}));
          connect(G.p,S4.n2) annotation(Line(points={{-57.1429,-75.7143},{-18.5714,1.4}},color={0,0,255}));
          connect(G.p,S5.n2) annotation(Line(points={{-57.1429,-75.7143},{10.0,1.4}},color={0,0,255}));
          connect(G.p,S7.n2) annotation(Line(points={{-57.1429,-75.7143},{67.1429,1.4}},color={0,0,255}));
          connect(G.p,S11.n2) annotation(Line(points={{-57.1429,-75.7143},{-18.5714,-27.1714}},color={0,0,255}));
          connect(G.p,S12.n2) annotation(Line(points={{-57.1429,-75.7143},{10.0,-27.1714}},color={0,0,255}));
          connect(G.p,S13.n2) annotation(Line(points={{-57.1429,-75.7143},{38.5714,-27.1714}},color={0,0,255}));
          connect(G.p,S14.n2) annotation(Line(points={{-57.1429,-75.7143},{67.1429,-27.1714}},color={0,0,255}));
          connect(G.p,S16.n2) annotation(Line(points={{-57.1429,-75.7143},{-75.7143,-55.7429}},color={0,0,255}));
          connect(G.p,S18.n2) annotation(Line(points={{-57.1429,-75.7143},{-18.5714,-55.7429}},color={0,0,255}));
          connect(G.p,S2.n1) annotation(Line(points={{-57.1429,-75.7143},{-75.7143,6.0}},color={0,0,255}));
          connect(G.p,S6.n1) annotation(Line(points={{-57.1429,-75.7143},{38.5714,6.0}},color={0,0,255}));
          connect(G.p,S8.n1) annotation(Line(points={{-57.1429,-75.7143},{95.7143,6.0}},color={0,0,255}));
          connect(G.p,S10.n1) annotation(Line(points={{-57.1429,-75.7143},{-47.1429,-22.5714}},color={0,0,255}));
          connect(G.p,S15.n1) annotation(Line(points={{-57.1429,-75.7143},{95.7143,-22.5714}},color={0,0,255}));
          connect(M.p,Op1.p1) annotation(Line(points={{-28.5714,-75.7143},{-10.0,-52.1429}},color={0,0,255}));
          connect(M.p,Op2.p1) annotation(Line(points={{-28.5714,-75.7143},{18.5714,-52.1429}},color={0,0,255}));
          connect(M.p,Op3.p1) annotation(Line(points={{-28.5714,-75.7143},{47.1429,-52.1429}},color={0,0,255}));
          connect(M.p,Op4.p1) annotation(Line(points={{-28.5714,-75.7143},{75.7143,-52.1429}},color={0,0,255}));
          connect(M.p,Op5.p1) annotation(Line(points={{-28.5714,-75.7143},{-95.7143,-80.7143}},color={0,0,255}));
          connect(M.p,Op1.n2) annotation(Line(points={{-28.5714,-75.7143},{10.0,-62.1429}},color={0,0,255}));
          connect(M.p,Op2.n2) annotation(Line(points={{-28.5714,-75.7143},{38.5714,-62.1429}},color={0,0,255}));
          connect(M.p,Op3.n2) annotation(Line(points={{-28.5714,-75.7143},{67.1429,-62.1429}},color={0,0,255}));
          connect(M.p,Op4.n2) annotation(Line(points={{-28.5714,-75.7143},{95.7143,-62.1429}},color={0,0,255}));
          connect(M.p,Op5.n2) annotation(Line(points={{-28.5714,-75.7143},{-75.7143,-90.7143}},color={0,0,255}));
          connect(M.p,Clk.n) annotation(Line(points={{-28.5714,-75.7143},{-47.1429,85.7143}},color={0,0,255}));
        end CauerFilter;
        encapsulated model DifferenceAmplifier
                  import Modelica.Electrical.Analog.Basic;
          import Modelica.Electrical.Analog.Sources;
          import Modelica.Electrical.Analog.Examples.Utilities;
          import Modelica.Icons;
          extends Icons.Example;
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 It is a simple NPN transistor amplifier circuit. The voltage difference between R1.p and R3.n is amplified. The output signal is the voltage between R2.n and R4.n. In this example the voltage at V1 is amplified because R3.n is grounded.
 <p>
 The simulation end time should be set to 1e- 8. Please plot the input voltage V1.v, and the output voltages R2.n.v, and R4.n.v.
 <p>
 <dl>
 <dt>
 <b>Reference:</b>
 <dd>
 Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 59
 <p>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
          Sources.ExpSineVoltage V1(V=0.2,freqHz=200000000.0,damping=10000000.0) annotation(Placement(transformation(x=-90.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-90.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Sources.RampVoltage V2(V=15,duration=1e-09) annotation(Placement(transformation(x=80.0,y=50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=80.0,y=50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Sources.RampCurrent I1(I=0.16,duration=1e-09) annotation(Placement(transformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Basic.Resistor R1(R=0.0001) annotation(Placement(transformation(x=-80.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-80.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Basic.Resistor R2(R=100) annotation(Placement(transformation(x=-40.0,y=30.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-40.0,y=30.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Basic.Resistor R3(R=0.0001) annotation(Placement(transformation(x=80.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=80.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Basic.Resistor R4(R=100) annotation(Placement(transformation(x=40.0,y=30.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=40.0,y=30.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Basic.Capacitor C1(C=1e-10) annotation(Placement(transformation(x=-60.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-60.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Basic.Capacitor C4(C=1e-10) annotation(Placement(transformation(x=20.0,y=-4.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=20.0,y=-4.0,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C5(C=1e-10) annotation(Placement(transformation(x=10.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=10.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Basic.Capacitor C2(C=1e-10) annotation(Placement(transformation(x=-20.0,y=-4.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-20.0,y=-4.0,scale=0.1,aspectRatio=1.0)));
          Basic.Capacitor C3(C=1e-10) annotation(Placement(transformation(x=60.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=60.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Basic.Ground Gnd1 annotation(Placement(transformation(x=-90.0,y=-75.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-90.0,y=-75.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd9 annotation(Placement(transformation(x=80.0,y=25.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=80.0,y=25.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd3 annotation(Placement(transformation(x=-10.0,y=-15.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-10.0,y=-15.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd2 annotation(Placement(transformation(x=-60.0,y=-75.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-60.0,y=-75.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd6 annotation(Placement(transformation(x=10.0,y=-15.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=10.0,y=-15.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd7 annotation(Placement(transformation(x=-10.0,y=-75.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-10.0,y=-75.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd8 annotation(Placement(transformation(x=10.0,y=-75.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=10.0,y=-75.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd5 annotation(Placement(transformation(x=60.0,y=-75.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=60.0,y=-75.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd4 annotation(Placement(transformation(x=90.0,y=-45.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=90.0,y=-45.0,scale=0.05,aspectRatio=1.0)));
          Utilities.Transistor Transistor1 annotation(Placement(transformation(x=-50.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Utilities.Transistor Transistor2 annotation(Placement(transformation(x=50.0,y=-10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=50.0,y=-10.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));

        equation 
          connect(V1.n,Gnd1.p) annotation(Line(points={{-90.0,-60.0},{-90.0,-70.0}},color={0,0,255}));
          connect(C1.n,Gnd2.p) annotation(Line(points={{-60.0,-60.0},{-60.0,-70.0}},color={0,0,255}));
          connect(I1.n,Gnd7.p) annotation(Line(points={{-10.0,-60.0},{-10.0,-70.0}},color={0,0,255}));
          connect(C5.n,Gnd8.p) annotation(Line(points={{10.0,-60.0},{10.0,-70.0}},color={0,0,255}));
          connect(C3.n,Gnd5.p) annotation(Line(points={{60.0,-60.0},{60.0,-70.0}},color={0,0,255}));
          connect(R3.n,Gnd4.p) annotation(Line(points={{90.0,-10.0},{90.0,-40.0}},color={0,0,255}));
          connect(C2.n,Gnd3.p) annotation(Line(points={{-10.0,-4.0},{-10.0,-10.0}},color={0,0,255}));
          connect(C4.p,Gnd6.p) annotation(Line(points={{10.0,-4.0},{10.0,-10.0}},color={0,0,255}));
          connect(I1.p,C5.p) annotation(Line(points={{-10.0,-40.0},{10.0,-40.0}},color={0,0,255}));
          connect(R1.p,V1.p) annotation(Line(points={{-90.0,-10.0},{-90.0,-40.0}},color={0,0,255}));
          connect(R2.p,V2.p) annotation(Line(points={{-40.0,40.0},{-40.0,70.0},{80.0,70.0},{80.0,60.0}},color={0,0,255}));
          connect(R4.p,V2.p) annotation(Line(points={{40.0,40.0},{40.0,70.0},{80.0,70.0},{80.0,60.0}},color={0,0,255}));
          connect(V2.n,Gnd9.p) annotation(Line(points={{80.0,40.0},{80.0,30.0}},color={0,0,255}));
          connect(R1.n,Transistor1.b) annotation(Line(points={{-70.0,-10.0},{-60.0,-10.0}},color={0,0,255}));
          connect(Transistor1.b,C1.p) annotation(Line(points={{-60.0,-10.0},{-60.0,-40.0}},color={0,0,255}));
          connect(Transistor1.c,C2.p) annotation(Line(points={{-40.0,-4.0},{-30.0,-4.0}},color={0,0,255}));
          connect(R2.n,Transistor1.c) annotation(Line(points={{-40.0,20.0},{-40.0,-4.0}},color={0,0,255}));
          connect(Transistor1.e,I1.p) annotation(Line(points={{-40.0,-16.0},{-30.0,-16.0},{-30.0,-40.0},{-10.0,-40.0}},color={0,0,255}));
          connect(Transistor2.b,R3.p) annotation(Line(points={{60.0,-10.0},{70.0,-10.0}},color={0,0,255}));
          connect(Transistor2.b,C3.p) annotation(Line(points={{60.0,-10.0},{60.0,-40.0}},color={0,0,255}));
          connect(C4.n,Transistor2.c) annotation(Line(points={{30.0,-4.0},{40.0,-4.0}},color={0,0,255}));
          connect(R4.n,Transistor2.c) annotation(Line(points={{40.0,20.0},{40.0,-4.0}},color={0,0,255}));
          connect(C5.p,Transistor2.e) annotation(Line(points={{10.0,-40.0},{30.0,-40.0},{30.0,-16.0},{40.0,-16.0}},color={0,0,255}));
        end DifferenceAmplifier;
        encapsulated model NandGate "CMOS NAND Gate (see Tietze/Schenk, page 157)"
                  import Modelica.Electrical.Analog.Basic;
          import Modelica.Electrical.Analog.Sources;
          import Modelica.Electrical.Analog.Examples.Utilities;
          import Modelica.Icons;
          extends Icons.Example;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
 The nand gate is a basic CMOS building block. It consists of four CMOS transistors.
 The output voltage Nand.y.v is low if and only if the two input voltages at Nand.x1.v and Nand.x2.v
 are both high. In this way the nand functionality is realized.
 <p>
 The simulation end time should be set to 1e-7. Please plot the input voltages Nand.x1.v,
 d Nand.x2.v, and the output voltage Nand.y.v.
 <p>
 <dl>
 <dt>
 <b>Reference:</b>
 <dd>
 Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 157
 <p>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
          Sources.TrapezoidVoltage VIN1(V=3.5,startTime=2e-08,rising=1e-09,width=1.9e-008,falling=1e-09,period=4e-08) annotation(Placement(transformation(x=-70.0,y=20.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-70.0,y=20.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Sources.TrapezoidVoltage VIN2(V=3.5,startTime=1e-08,rising=1e-09,width=1.9e-008,falling=1e-09,period=4e-08) annotation(Placement(transformation(x=-70.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=-70.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Sources.RampVoltage VDD(V=5,duration=1e-09) annotation(Placement(transformation(x=50.0,y=70.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=50.0,y=70.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Basic.Ground Gnd1 annotation(Placement(transformation(x=50.0,y=48.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=50.0,y=48.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd4 annotation(Placement(transformation(x=-70.0,y=0.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-70.0,y=0.0,scale=0.05,aspectRatio=1.0)));
          Basic.Ground Gnd5 annotation(Placement(transformation(x=-70.0,y=-50.0,scale=0.05,aspectRatio=1.0),iconTransformation(x=-70.0,y=-50.0,scale=0.05,aspectRatio=1.0)));
          Utilities.Nand Nand annotation(Placement(transformation(x=0.0,y=5.0,scale=0.4,aspectRatio=1.25),iconTransformation(x=0.0,y=5.0,scale=0.4,aspectRatio=1.25)));

        equation 
          connect(VDD.n,Gnd1.p) annotation(Line(points={{50.0,60.0},{50.0,53.0}},color={0,0,255}));
          connect(VIN1.n,Gnd4.p) annotation(Line(points={{-70.0,10.0},{-70.0,5.0}},color={0,0,255}));
          connect(VIN2.n,Gnd5.p) annotation(Line(points={{-70.0,-40.0},{-70.0,-45.0}},color={0,0,255}));
          connect(Nand.Vdd,VDD.p) annotation(Line(points={{0.0,55.0},{0.0,90.0},{50.0,90.0},{50.0,80.0}},color={0,0,255}));
          connect(VIN1.p,Nand.x1) annotation(Line(points={{-70.0,30.0},{-40.0,30.0}},color={0,0,255}));
          connect(VIN2.p,Nand.x2) annotation(Line(points={{-70.0,-20.0},{-40.0,-20.0}},color={0,0,255}));
        end NandGate;
        model HeatingMOSInverter "Heating MOS Inverter"
                  extends Modelica.Icons.Example;
          Modelica.Electrical.Analog.Basic.Ground G annotation(Placement(transformation(x=-70.0,y=-30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=-30.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Sources.SineVoltage Sin(V=5) annotation(Placement(transformation(x=-70.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-70.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,100.0},{-6.0,72.0}}, textString="Heating MOS Inverter", fillColor={0,0,255})}));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1(C=1e-05) annotation(Placement(transformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=30.0,y=10.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Thermal.HeatTransfer.HeatCapacitor HeatCapacitor1(C=0.01) annotation(Placement(transformation(x=70.0,y=-60.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=70.0,y=-60.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Thermal.HeatTransfer.ThermalConductor TC1(G=0.01) annotation(Placement(transformation(x=10.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=0),iconTransformation(x=10.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=0)));
          Semiconductors.HeatingPMOS H_PMOS annotation(Placement(transformation(x=-30.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Semiconductors.HeatingNMOS H_NMOS annotation(Placement(transformation(x=-30.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-30.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Sources.RampVoltage V(V=5,duration=0.01) annotation(Placement(transformation(x=50.0,y=50.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=50.0,y=50.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Thermal.HeatTransfer.ThermalConductor TC2(G=0.01) annotation(Placement(transformation(x=10.0,y=-80.0,scale=0.1,aspectRatio=1.0,rotation=0),iconTransformation(x=10.0,y=-80.0,scale=0.1,aspectRatio=1.0,rotation=0)));
          Modelica.Thermal.HeatTransfer.FixedTemperature FixedTemperature1(T=300) annotation(Placement(transformation(x=88.0,y=-28.0,scale=0.1,aspectRatio=1.0,rotation=180),iconTransformation(x=88.0,y=-28.0,scale=0.1,aspectRatio=1.0,rotation=180)));
          Modelica.Thermal.HeatTransfer.ThermalConductor TC3(G=0.01) annotation(Placement(transformation(x=56.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=0),iconTransformation(x=56.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=0)));

        equation 
          connect(Sin.n,G.p) annotation(Line(points={{-70.0,-10.0},{-70.0,-20.0}},color={0,0,255}));
          connect(Capacitor1.n,G.p) annotation(Line(points={{30.0,0.0},{30.0,-20.0},{-70.0,-20.0}},color={0,0,255}));
          annotation(Documentation(info="<HTML>
 <P>
 The heating MOS inverter shows a heat flow always if a transistor is leading.
 </P>
 <P>
 Simulate until T=5 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 Sin.p.v  and  Capacitor1.p.v <br>
 HeatCapacitor1.port.T and H_PMOS.heatPort.T and H_NMOS.heatPort.T<br>
 H_PMOS.heatPort.Q_flow and H_NMOS.heatPort.Q_flow<br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 6, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=5));
          connect(H_NMOS.G,H_PMOS.G) annotation(Line(points={{-40.0,5.0},{-40.0,45.0}},color={0,0,255}));
          connect(H_NMOS.G,Sin.p) annotation(Line(points={{-40.0,5.0},{-40.0,10.0},{-70.0,10.0}},color={0,0,255}));
          connect(H_PMOS.S,H_NMOS.D) annotation(Line(points={{-20.0,45.0},{-20.0,15.0}},color={0,0,255}));
          connect(H_NMOS.D,Capacitor1.p) annotation(Line(points={{-20.0,15.0},{-20.0,20.0},{30.0,20.0}},color={0,0,255}));
          connect(H_NMOS.B,H_NMOS.S) annotation(Line(points={{-20.0,10.0},{-20.0,5.0}},color={0,0,255}));
          connect(H_NMOS.S,G.p) annotation(Line(points={{-20.0,5.0},{-20.0,-20.0},{-70.0,-20.0}},color={0,0,255}));
          connect(H_PMOS.B,H_PMOS.D) annotation(Line(points={{-20.0,50.0},{-20.0,55.0}},color={0,0,255}));
          connect(V.p,H_PMOS.D) annotation(Line(points={{50.0,60.0},{-20.0,60.0},{-20.0,55.0}},color={0,0,255}));
          connect(V.n,G.p) annotation(Line(points={{50.0,40.0},{50.0,-20.0},{-70.0,-20.0}},color={0,0,255}));
          connect(TC1.port_b,HeatCapacitor1.port) annotation(Line(points={{21.0,-40.0},{40.0,-40.0},{40.0,-60.0},{60.0,-60.0}},color={191,0,0}));
          connect(TC2.port_b,HeatCapacitor1.port) annotation(Line(points={{21.0,-80.0},{40.0,-80.0},{40.0,-60.0},{60.0,-60.0}},color={191,0,0}));
          connect(TC1.port_a,H_PMOS.heatPort) annotation(Line(points={{-1.0,-40.0},{-10.0,-40.0},{-10.0,40.0},{-30.0,40.0}},color={191,0,0}));
          connect(TC2.port_a,H_NMOS.heatPort) annotation(Line(points={{-1.0,-80.0},{-30.0,-80.0},{-30.0,0.0}},color={191,0,0}));
          connect(TC3.port_b,FixedTemperature1.port) annotation(Line(points={{67.0,-30.0},{70.0,-30.0},{70.0,-28.0},{77.0,-28.0}},color={191,0,0}));
          connect(TC3.port_a,HeatCapacitor1.port) annotation(Line(points={{45.0,-30.0},{52.0,-30.0},{52.0,-60.0},{60.0,-60.0}},color={191,0,0}));
        end HeatingMOSInverter;
        encapsulated model ChuaCircuit "Chua's circuit, ns, V, A"
                  import Modelica.Electrical.Analog.Basic;
          import Modelica.Electrical.Analog.Examples.Utilities;
          import Modelica.Icons;
          extends Icons.Example;
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})),Documentation(info="<html>
 <p>
  Chua's circuit is the most simple nonlinear circuit which shows chaotic behaviour. The circuit consists of linear basic elements (capacitors, resistor, conductor, inductor), and one nonlinear element, which is called Chua's diode. The chaotic behaviour is simulated.
 <p>
 The simulation end time should be set to 5e4. To get the chaotic behaviour please plot C1.v. Choose C2.v as the independent variable.
 <p>
 <dl>
 <dt>
 <b>Reference:</b>
 <dd>
 Kennedy, M.P.: Three Steps to Chaos - Part I: Evolution. IEEE Transactions on CAS I 40 (1993)10, 640-656
 <p>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
          Basic.Inductor L(L=18) annotation(Placement(transformation(x=-75.0,y=50.0,scale=0.25,aspectRatio=1.0,rotation=-90),iconTransformation(x=-75.0,y=50.0,scale=0.25,aspectRatio=1.0,rotation=-90)));
          Basic.Resistor Ro(R=0.0125) annotation(Placement(transformation(x=-75.0,y=-5.0,scale=0.25,aspectRatio=1.0,rotation=-90),iconTransformation(x=-75.0,y=-5.0,scale=0.25,aspectRatio=1.0,rotation=-90)));
          Basic.Conductor G(G=0.565) annotation(Placement(transformation(x=0.0,y=75.0,scale=0.25,aspectRatio=1.0),iconTransformation(x=0.0,y=75.0,scale=0.25,aspectRatio=1.0)));
          Basic.Capacitor C1(C=10,v(start=4)) annotation(Placement(transformation(x=25.0,y=15.0,scale=0.25,aspectRatio=1.0,rotation=-90),iconTransformation(x=25.0,y=15.0,scale=0.25,aspectRatio=1.0,rotation=-90)));
          Basic.Capacitor C2(C=100) annotation(Placement(transformation(x=-25.0,y=15.0,scale=0.25,aspectRatio=1.0,rotation=-90),iconTransformation(x=-25.0,y=15.0,scale=0.25,aspectRatio=1.0,rotation=-90)));
          Utilities.NonlinearResistor Nr(Ga(min=-1)=-0.757576,Gb(min=-1)=-0.409091,Ve=1) annotation(Placement(transformation(x=75.0,y=15.0,scale=0.25,aspectRatio=1.0,rotation=-90),iconTransformation(x=75.0,y=15.0,scale=0.25,aspectRatio=1.0,rotation=-90)));
          Basic.Ground Gnd annotation(Placement(transformation(x=0.0,y=-75.0,scale=0.25,aspectRatio=1.0),iconTransformation(x=0.0,y=-75.0,scale=0.25,aspectRatio=1.0)));

        equation 
          connect(L.p,G.p) annotation(Line(points={{-75.0,75.0},{-25.0,75.0}},color={0,0,255}));
          connect(G.n,Nr.p) annotation(Line(points={{25.0,75.0},{75.0,75.0},{75.0,40.0}},color={0,0,255}));
          connect(Nr.n,Gnd.p) annotation(Line(points={{75.0,-10.0},{75.0,-50.0},{0.0,-50.0}},color={0,0,255}));
          connect(C1.p,G.n) annotation(Line(points={{25.0,40.0},{25.0,75.0}},color={0,0,255}));
          connect(L.n,Ro.p) annotation(Line(points={{-75.0,25.0},{-75.0,20.0}},color={0,0,255}));
          connect(G.p,C2.p) annotation(Line(points={{-25.0,75.0},{-25.0,40.0}},color={0,0,255}));
          connect(C1.n,Gnd.p) annotation(Line(points={{25.0,-10.0},{25.0,-50.0},{0.0,-50.0}},color={0,0,255}));
          connect(C2.n,Gnd.p) annotation(Line(points={{-25.0,-10.0},{-25.0,-50.0},{0.0,-50.0}},color={0,0,255}));
          connect(Ro.n,Gnd.p) annotation(Line(points={{-75.0,-30.0},{-75.0,-50.0},{0.0,-50.0}},color={0,0,255}));
        end ChuaCircuit;
        model ShowVariableResistor "Simple demo of a VariableResistor model"
                  extends Modelica.Icons.Example;
          Modelica.Electrical.Analog.Basic.VariableResistor VariableResistor annotation(Placement(transformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0,rotation=0),iconTransformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0,rotation=0)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 annotation(Placement(transformation(x=-90.0,y=-70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-90.0,y=-70.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground Ground2 annotation(Placement(transformation(x=70.0,y=-30.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=70.0,y=-30.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R1 annotation(Placement(transformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R2 annotation(Placement(transformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R3 annotation(Placement(transformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R4 annotation(Placement(transformation(x=-50.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R5 annotation(Placement(transformation(x=30.0,y=-10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=-10.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<HTML>
 <P>
 It is a simple test circuit for the VariableResistor. The VariableResistor
 sould be compared with R2.
 </P>
 <P>
 Simulate until T=1 s.
 </P>
 <P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 6, 2004   </i>
        by Teresa Schlegel<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=1),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-100.0,112.0},{80.0,40.0}}, fillColor={0,0,255}, textString="Example VariableResistor")}));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}})));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1 annotation(Placement(transformation(x=-90.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=-90.0,y=-30.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Modelica.Blocks.Sources.Ramp Ramp1(height=5,offset=2) annotation(Placement(transformation(x=-10.0,y=20.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-10.0,y=20.0,scale=0.1,aspectRatio=1.0,rotation=270)));

        equation 
          connect(R1.n,R2.p) annotation(Line(points={{-40.0,50.0},{-20.0,50.0}},color={0,0,255}));
          connect(R2.n,R3.p) annotation(Line(points={{0.0,50.0},{20.0,50.0}},color={0,0,255}));
          connect(R4.n,VariableResistor.p) annotation(Line(points={{-40.0,-10.0},{-20.0,-10.0}},color={0,0,255}));
          connect(VariableResistor.n,R5.p) annotation(Line(points={{0.0,-10.0},{20.0,-10.0}},color={0,0,255}));
          connect(R3.n,Ground2.p) annotation(Line(points={{40.0,50.0},{70.0,50.0},{70.0,-20.0}},color={0,0,255}));
          connect(Ground2.p,R5.n) annotation(Line(points={{70.0,-20.0},{70.0,-10.0},{40.0,-10.0}},color={0,0,255}));
          connect(SineVoltage1.p,Ground1.p) annotation(Line(points={{-90.0,-40.0},{-90.0,-60.0}},color={0,0,255}));
          connect(SineVoltage1.n,R1.p) annotation(Line(points={{-90.0,-20.0},{-90.0,50.0},{-60.0,50.0}},color={0,0,255}));
          connect(SineVoltage1.n,R4.p) annotation(Line(points={{-90.0,-20.0},{-90.0,-10.0},{-60.0,-10.0}},color={0,0,255}));
          connect(Ramp1.y,VariableResistor.R) annotation(Line(points={{-10.0,9.0},{-10.0,4.5},{-10.0,4.5},{-10.0,0.0}},color={0,0,255}));
        end ShowVariableResistor;
        model HeatingRectifier "Heating rectifier"
                  extends Modelica.Icons.Example;
          Modelica.Electrical.Analog.Semiconductors.HeatingDiode HeatingDiode1 annotation(Placement(transformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Ground G annotation(Placement(transformation(x=-70.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-70.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1 annotation(Placement(transformation(x=-70.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-70.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-94.0,102.0},{0.0,74.0}}, textString="HeatingRectifier", fillColor={0,0,255})}));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1 annotation(Placement(transformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Thermal.HeatTransfer.HeatCapacitor HeatCapacitor1(C=1) annotation(Placement(transformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=180),iconTransformation(x=-10.0,y=-50.0,scale=0.1,aspectRatio=1.0,rotation=180)));
          Modelica.Thermal.HeatTransfer.ThermalConductor ThermalConductor1(G=10) annotation(Placement(transformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-10.0,y=-10.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Basic.Resistor R(R=1) annotation(Placement(transformation(x=30.0,y=80.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=30.0,y=80.0,scale=0.1,aspectRatio=1.0)));

        equation 
          connect(SineVoltage1.p,HeatingDiode1.p) annotation(Line(points={{-70.0,50.0},{-20.0,50.0}},color={0,0,255}));
          connect(SineVoltage1.n,G.p) annotation(Line(points={{-70.0,30.0},{-70.0,20.0}},color={0,0,255}));
          connect(Capacitor1.n,G.p) annotation(Line(points={{40.0,50.0},{40.0,20.0},{-70.0,20.0}},color={0,0,255}));
          connect(HeatingDiode1.n,Capacitor1.p) annotation(Line(points={{0.0,50.0},{20.0,50.0}},color={0,0,255}));
          connect(HeatingDiode1.heatPort,ThermalConductor1.port_a) annotation(Line(points={{-10.0,40.0},{-10.0,20.5},{-10.0,1.0},{-10.0,1.0}},color={191,0,0}));
          connect(ThermalConductor1.port_b,HeatCapacitor1.port) annotation(Line(points={{-10.0,-21.0},{-10.0,-25.75},{-10.0,-25.75},{-10.0,-30.5},{-10.0,-40.0},{-10.0,-40.0}},color={191,0,0}));
          connect(R.p,Capacitor1.p) annotation(Line(points={{20.0,80.0},{20.0,50.0}},color={0,0,255}));
          connect(R.n,Capacitor1.n) annotation(Line(points={{40.0,80.0},{40.0,50.0}},color={0,0,255}));
          annotation(Documentation(info="<HTML>
 <P>
 The heating rectifier shows a heat flow always if the electrical capacitor is loaded.
 </P>
 <P>
 Simulate until T=5 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 SineVoltage1.v  and  Capacitor1.p.v <br>
 HeatCapacitor1.port.T and HeatingDiode1.heatPort.T<br>
 HeatingDiode1.heatPort.Q_flow<br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 6, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=5));
        end HeatingRectifier;
        model CharacteristicThyristors "Characteristic of ideal thyristors"
                  extends Modelica.Icons.Example;
          Modelica.Electrical.Analog.Ideal.IdealThyristor IdealThyristor1(Vknee=5) annotation(Placement(transformation(x=-10.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(V=10,offset=0) annotation(Placement(transformation(x=-40.0,y=-10.0,scale=0.1,aspectRatio=1.0,rotation=270),iconTransformation(x=-40.0,y=-10.0,scale=0.1,aspectRatio=1.0,rotation=270)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 annotation(Placement(transformation(x=-40.0,y=-50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-40.0,y=-50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R3(R=0.001) annotation(Placement(transformation(x=50.0,y=10.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=50.0,y=10.0,scale=0.1,aspectRatio=1.0)));
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-96.0,100.0},{98.0,60.0}}, textString="Characteristic Thyristors", fillColor={0,0,255})}));
          Modelica.Blocks.Sources.BooleanStep BooleanStep1(startValue=false,startTime=1.25) annotation(Placement(transformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=50.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Ideal.IdealGTOThyristor IdealGTOThyristor1(Vknee=0) annotation(Placement(transformation(x=-10.0,y=-20.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-10.0,y=-20.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Resistor R1(R=0.001) annotation(Placement(transformation(x=50.0,y=-20.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=50.0,y=-20.0,scale=0.1,aspectRatio=1.0)));
          annotation(Documentation(info="<HTML>
 <P>
 Two examples of thyristors are shown:<br><br>
 the <b>ideal thyristor</b>  <br>
 and the <b>ideal GTO thyristor</b>  with <i>Vknee=5</i>  <br><br>
 </P>
 <P>
 Simulate until T=2 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 IdealThyristor1.i and IdealGTOThyristor1.i <br>
 IdealThyristor1.v and IdealGTOThyristor1.v <br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 7, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=2));

        equation 
          connect(IdealThyristor1.n,R3.p) annotation(Line(points={{0.0,10.0},{40.0,10.0}},color={0,0,255}));
          connect(Ground1.p,SineVoltage1.n) annotation(Line(points={{-40.0,-40.0},{-40.0,-20.0}},color={0,0,255}));
          connect(SineVoltage1.p,IdealThyristor1.p) annotation(Line(points={{-40.0,0.0},{-40.0,10.0},{-20.0,10.0}},color={0,0,255}));
          connect(BooleanStep1.y,IdealThyristor1.fire) annotation(Line(points={{-39.0,50.0},{-3.0,50.0},{-3.0,20.0}},color={255,0,255}));
          connect(IdealGTOThyristor1.n,R1.p) annotation(Line(points={{0.0,-20.0},{40.0,-20.0}},color={0,0,255}));
          connect(R3.n,R1.n) annotation(Line(points={{60.0,10.0},{60.0,-20.0}},color={0,0,255}));
          connect(R1.n,Ground1.p) annotation(Line(points={{60.0,-20.0},{60.0,-40.0},{-40.0,-40.0}},color={0,0,255}));
          connect(IdealGTOThyristor1.p,IdealThyristor1.p) annotation(Line(points={{-20.0,-20.0},{-20.0,10.0}},color={0,0,255}));
          connect(IdealGTOThyristor1.fire,IdealThyristor1.fire) annotation(Line(points={{-3.0,-10.0},{-3.0,-2.5},{-2.0,-2.5},{-2.0,5.0},{-3.0,5.0},{-3.0,20.0}},color={255,0,255}));
        end CharacteristicThyristors;
        model Rectifier "B6 diode bridge"
                  extends Modelica.Icons.Example;
          import Modelica.Electrical.Analog.Ideal;
          parameter Modelica.SIunits.Voltage VAC=400 "RMS line-to-line";
          parameter Modelica.SIunits.Frequency f=50 "line frequency";
          parameter Modelica.SIunits.Inductance LAC=3/50000 "line inductor";
          parameter Modelica.SIunits.Resistance Ron=1/1000 "diode forward resistance";
          parameter Modelica.SIunits.Conductance Goff=1/1000 "diode backward conductance";
          parameter Modelica.SIunits.Voltage Vknee=2 "diode threshold voltage";
          parameter Modelica.SIunits.Capacitance CDC=3/200 "DC capacitance";
          parameter Modelica.SIunits.Current IDC=500 "load current";
          output Modelica.SIunits.Voltage uDC;
          output Modelica.SIunits.Current iAC[3];
          output Modelica.SIunits.Voltage uAC[3];
          output Modelica.SIunits.Power Losses;
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Text(extent={{-80.0,90.0},{80.0,70.0}}, textString="Rectifier", fillColor={0,0,0}),Line(points={{-16.0,18.0},{-16.0,2.0},{-18.0,6.0},{-14.0,6.0},{-16.0,2.0}}, color={0,0,0}),Line(points={{-30.0,22.0},{-26.0,20.0},{-30.0,18.0},{-30.0,22.0}}, color={0,0,0}),Line(points={{32.0,30.0},{32.0,-30.0},{30.0,-26.0},{34.0,-26.0},{32.0,-30.0}}, color={0,0,0}),Text(extent={{-38.0,16.0},{-22.0,8.0}}, textString="iAC", fillColor={0,0,0}),Text(extent={{-14.0,8.0},{2.0,0.0}}, textString="uAC", fillColor={0,0,0}),Text(extent={{22.0,-16.0},{38.0,-24.0}}, textString="uDC", fillColor={0,0,0})}),experiment(StopTime=0.1,Interval=1/100000),experimentSetupOutput(doublePrecision=true,states=false,derivatives=false,inputs=false,auxiliaries=false),Documentation(info="<HTML>
 <P>
 The rectifier example shows a B6 diode bridge fed by a three phase sinusoidal voltage, loaded by a DC current.<br>
 DC capacitors start at ideal no-load voltage, thus making easier initial transient.
 </P>
 <P>
 Simulate until T=0.1 s.<br><br>
 Plot in separate windows:<br><br>
 uDC ... DC-voltage<br>
 iAC ... AC-currents 1..3<br>
 uAC ... AC-voltages 1..3 (distorted)<br>
 Try different load currents iDC = 0..approximately 500 A.
 </P>
 <p>
 You may watch Losses (of the whole diode bridge) trying different diode parameters.
 </p>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 7, 2004   </i>
        by Anton Haumer<br> realized<br>
        </li>
 </ul>
 </HTML>
 "));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage1(freqHz=f,V=VAC*sqrt(2/3)) annotation(Placement(transformation(x=-80.0,y=20.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-80.0,y=20.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage2(freqHz=f,phase=-2/3*Modelica.Constants.pi,V=VAC*sqrt(2/3)) annotation(Placement(transformation(x=-80.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-80.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Modelica.Electrical.Analog.Sources.SineVoltage SineVoltage3(freqHz=f,phase=-4/3*Modelica.Constants.pi,V=VAC*sqrt(2/3)) annotation(Placement(transformation(x=-80.0,y=-20.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=-80.0,y=-20.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Modelica.Electrical.Analog.Basic.Inductor Inductor1(L=LAC) annotation(Placement(transformation(x=-50.0,y=20.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=20.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Inductor Inductor2(L=LAC) annotation(Placement(transformation(x=-50.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Basic.Inductor Inductor3(L=LAC) annotation(Placement(transformation(x=-50.0,y=-20.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-50.0,y=-20.0,scale=0.1,aspectRatio=1.0)));
          Ideal.IdealDiode IdealDiode1(Ron=Ron,Goff=Goff,Vknee=Vknee) annotation(Placement(transformation(x=-20.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=-20.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Ideal.IdealDiode IdealDiode2(Ron=Ron,Goff=Goff,Vknee=Vknee) annotation(Placement(transformation(x=0.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=0.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Ideal.IdealDiode IdealDiode3(Ron=Ron,Goff=Goff,Vknee=Vknee) annotation(Placement(transformation(x=20.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=20.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Ideal.IdealDiode IdealDiode4(Ron=Ron,Goff=Goff,Vknee=Vknee) annotation(Placement(transformation(x=-20.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=-20.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Ideal.IdealDiode IdealDiode5(Ron=Ron,Goff=Goff,Vknee=Vknee) annotation(Placement(transformation(x=0.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=0.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Ideal.IdealDiode IdealDiode6(Ron=Ron,Goff=Goff,Vknee=Vknee) annotation(Placement(transformation(x=20.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=90),iconTransformation(x=20.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=90)));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor1(C=2*CDC) annotation(Placement(transformation(x=40.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=40.0,y=40.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Modelica.Electrical.Analog.Basic.Capacitor Capacitor2(C=2*CDC) annotation(Placement(transformation(x=40.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=40.0,y=-40.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Modelica.Electrical.Analog.Basic.Ground Ground1 annotation(Placement(transformation(x=50.0,y=-70.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=50.0,y=-70.0,scale=0.1,aspectRatio=1.0)));
          Modelica.Electrical.Analog.Sources.SignalCurrent SignalCurrent1 annotation(Placement(transformation(x=60.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=-90),iconTransformation(x=60.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=-90)));
          Modelica.Blocks.Sources.Constant Constant1(k=IDC) annotation(Placement(transformation(x=90.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=0,flipHorizontal=true),iconTransformation(x=90.0,y=0.0,scale=0.1,aspectRatio=1.0,rotation=0,flipHorizontal=true)));

        initial equation 
          Capacitor1.v=(VAC*sqrt(2))/2;
          Capacitor2.v=(VAC*sqrt(2))/2;

        equation 
          uDC=Capacitor1.v + Capacitor2.v;
          iAC={Inductor1.i,Inductor2.i,Inductor3.i};
          uAC[1]=Inductor1.n.v - Inductor2.n.v;
          uAC[2]=Inductor2.n.v - Inductor3.n.v;
          uAC[3]=Inductor3.n.v - Inductor1.n.v;
          Losses=IdealDiode1.v*IdealDiode1.i + IdealDiode2.v*IdealDiode2.i + IdealDiode3.v*IdealDiode3.i + IdealDiode4.v*IdealDiode4.i + IdealDiode5.v*IdealDiode5.i + IdealDiode6.v*IdealDiode6.i;
          connect(SineVoltage1.n,SineVoltage2.n) annotation(Line(points={{-90.0,20.0},{-90.0,0.0}},color={0,0,255}));
          connect(SineVoltage2.n,SineVoltage3.n) annotation(Line(points={{-90.0,0.0},{-90.0,-20.0}},color={0,0,255}));
          connect(SineVoltage1.p,Inductor1.p) annotation(Line(points={{-70.0,20.0},{-60.0,20.0}},color={0,0,255}));
          connect(SineVoltage2.p,Inductor2.p) annotation(Line(points={{-70.0,0.0},{-60.0,0.0}},color={0,0,255}));
          connect(SineVoltage3.p,Inductor3.p) annotation(Line(points={{-70.0,-20.0},{-60.0,-20.0}},color={0,0,255}));
          connect(IdealDiode1.p,IdealDiode4.n) annotation(Line(points={{-20.0,30.0},{-20.0,-30.0}},color={0,0,255}));
          connect(IdealDiode2.p,IdealDiode5.n) annotation(Line(points={{-6.12303e-016,30.0},{-6.12303e-016,16.0},{0.0,0.0},{0.0,-30.0},{6.12303e-016,-30.0}},color={0,0,255}));
          connect(IdealDiode3.p,IdealDiode6.n) annotation(Line(points={{20.0,30.0},{20.0,-30.0}},color={0,0,255}));
          connect(IdealDiode1.n,IdealDiode2.n) annotation(Line(points={{-20.0,50.0},{6.12303e-016,50.0}},color={0,0,255}));
          connect(IdealDiode2.n,IdealDiode3.n) annotation(Line(points={{6.12303e-016,50.0},{20.0,50.0}},color={0,0,255}));
          connect(IdealDiode4.p,IdealDiode5.p) annotation(Line(points={{-20.0,-50.0},{-6.12303e-016,-50.0}},color={0,0,255}));
          connect(IdealDiode5.p,IdealDiode6.p) annotation(Line(points={{-6.12303e-016,-50.0},{20.0,-50.0}},color={0,0,255}));
          connect(Capacitor2.n,IdealDiode6.p) annotation(Line(points={{40.0,-50.0},{20.0,-50.0}},color={0,0,255}));
          connect(IdealDiode3.n,Capacitor1.p) annotation(Line(points={{20.0,50.0},{40.0,50.0}},color={0,0,255}));
          connect(Capacitor1.n,Capacitor2.p) annotation(Line(points={{40.0,30.0},{40.0,-30.0}},color={0,0,255}));
          connect(Capacitor2.p,Ground1.p) annotation(Line(points={{40.0,-30.0},{40.0,0.0},{50.0,0.0},{50.0,-60.0}},color={0,0,255}));
          connect(Capacitor1.p,SignalCurrent1.p) annotation(Line(points={{40.0,50.0},{60.0,50.0},{60.0,10.0}},color={0,0,255}));
          connect(SignalCurrent1.n,Capacitor2.n) annotation(Line(points={{60.0,-10.0},{60.0,-50.0},{40.0,-50.0}},color={0,0,255}));
          connect(Constant1.y,SignalCurrent1.i) annotation(Line(points={{79.0,0.0},{79.0,4.28612e-016},{67.0,4.28612e-016}},color={0,0,255}));
          connect(Inductor1.n,IdealDiode1.p) annotation(Line(points={{-40.0,20.0},{-20.0,20.0},{-20.0,30.0}},color={0,0,255}));
          connect(Inductor2.n,IdealDiode2.p) annotation(Line(points={{-40.0,0.0},{-6.12303e-016,0.0},{-6.12303e-016,30.0}},color={0,0,255}));
          connect(Inductor3.n,IdealDiode3.p) annotation(Line(points={{-40.0,-20.0},{20.0,-20.0},{20.0,30.0}},color={0,0,255}));
        end Rectifier;
      end Examples;
      package Sources
              extends Modelica.Icons.Library;
        annotation(preferedView="info",Documentation(info="<html>
 <p>
 This package contains time-dependend and controlled voltage and current sources.
 </p>
 <dl>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
        model SignalVoltage "Generic voltage source using the input signal as source voltage"
                  Interfaces.PositivePin p annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.NegativePin n annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          Modelica.Blocks.Interfaces.RealInput v(redeclare type SignalType= SI.Voltage ) "Voltage between pin p and n (= p.v - n.v) as input signal" annotation(Placement(transformation(x=0.0,y=70.0,scale=0.2,aspectRatio=1.0,rotation=-90),iconTransformation(x=0.0,y=70.0,scale=0.2,aspectRatio=1.0,rotation=-90)));
          SI.Current i "Current flowing from pin p to pin n";
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{-50.0,0.0}}, color={0,0,0}),Line(points={{50.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{-50.0,0.0},{50.0,0.0}}, color={0,0,0}),Text(extent={{-100.0,-120.0},{100.0,-80.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-96.0,0.0},{-50.0,0.0}}, color={0,0,0}),Line(points={{50.0,0.0},{96.0,0.0}}, color={0,0,0}),Line(points={{-50.0,0.0},{50.0,0.0}}, color={0,0,0}),Line(points={{-109.0,20.0},{-84.0,20.0}}, color={160,160,160}),Polygon(points={{-94.0,23.0},{-84.0,20.0},{-94.0,17.0},{-94.0,23.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Line(points={{91.0,20.0},{116.0,20.0}}, color={160,160,160}),Text(extent={{-109.0,25.0},{-89.0,45.0}}, textString="i", fillColor={160,160,160}),Polygon(points={{106.0,23.0},{116.0,20.0},{106.0,17.0},{106.0,23.0}}, lineColor={160,160,160}, fillColor={160,160,160}, fillPattern=FillPattern.Solid),Text(extent={{91.0,45.0},{111.0,25.0}}, textString="i", fillColor={160,160,160}),Line(points={{-119.0,-5.0},{-119.0,5.0}}, color={160,160,160}),Line(points={{-124.0,0.0},{-114.0,0.0}}, color={160,160,160}),Line(points={{116.0,0.0},{126.0,0.0}}, color={160,160,160})}));

        equation 
          v=p.v - n.v;
          0=p.i + n.i;
          i=p.i;
        end SignalVoltage;
        model ConstantVoltage "Source for constant voltage"
                  parameter SI.Voltage V=1 "Value of constant voltage";
          extends Interfaces.OnePort;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{-10.0,0.0}}, color={0,0,0}),Line(points={{-10.0,60.0},{-10.0,-60.0}}, color={0,0,0}),Line(points={{0.0,30.0},{0.0,-30.0}}, color={0,0,0}),Line(points={{0.0,0.0},{90.0,0.0}}, color={0,0,0}),Text(extent={{-100.0,-120.0},{100.0,-80.0}}, textString="%name=%V", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-90.0,0.0},{-10.0,0.0}}, color={0,0,0}),Line(points={{-10.0,60.0},{-10.0,-60.0}}, color={0,0,0}),Line(points={{0.0,30.0},{0.0,-30.0}}, color={0,0,0}),Line(points={{0.0,0.0},{90.0,0.0}}, color={0,0,0})}));

        equation 
          v=V;
        end ConstantVoltage;
        model StepVoltage "Step voltage source"
                  parameter SI.Voltage V=1 "Height of step";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.Step signalSource(height=V) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,-70.0},{0.0,-70.0},{0.0,70.0},{69.0,70.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-18.0},{0.0,-18.0},{0.0,50.0},{80.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-21.0,-72.0},{25.0,-90.0}}, textString="startTime", fillColor={160,160,160}),Line(points={{0.0,-17.0},{0.0,-71.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-68.0,-36.0},{-22.0,-54.0}}, textString="offset", fillColor={160,160,160}),Line(points={{-13.0,50.0},{-13.0,-17.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{2.0,50.0},{-19.0,50.0},{2.0,50.0}}, lineColor={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{-13.0,-17.0},{-16.0,-4.0},{-10.0,-4.0},{-13.0,-17.0},{-13.0,-17.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-13.0,50.0},{-16.0,37.0},{-9.0,37.0},{-13.0,50.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-68.0,26.0},{-22.0,8.0}}, textString="V", fillColor={160,160,160}),Polygon(points={{-13.0,-69.0},{-16.0,-56.0},{-10.0,-56.0},{-13.0,-69.0},{-13.0,-69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-13.0,-18.0},{-13.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-13.0,-18.0},{-16.0,-31.0},{-9.0,-31.0},{-13.0,-18.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-67.0,93.0},{-2.0,67.0}}, textString="v = p.v - n.v", fillColor={160,160,160})}));
        end StepVoltage;
        model RampVoltage "Ramp voltage source"
                  parameter SI.Voltage V=1 "Height of ramp";
          parameter SI.Time duration(min=Modelica.Constants.small)=2 "Duration of ramp";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.Ramp signalSource(final height=V,final duration=duration) );
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-20.0},{-20.0,-20.0},{50.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-40.0,-20.0},{-42.0,-30.0},{-37.0,-30.0},{-40.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-20.0},{-40.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-40.0,-70.0},{-43.0,-60.0},{-38.0,-60.0},{-40.0,-70.0},{-40.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-80.0,-33.0},{-41.0,-49.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-40.0,-70.0},{6.0,-88.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{-67.0,93.0},{-2.0,67.0}}, textString="v = p.v - n.v", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-20.0,-20.0},{-20.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-19.0,-20.0},{50.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{50.0,50.0},{101.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{50.0,50.0},{50.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{50.0,-20.0},{42.0,-18.0},{42.0,-22.0},{50.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-20.0,-20.0},{-11.0,-18.0},{-11.0,-22.0},{-20.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,50.0},{48.0,40.0},{53.0,40.0},{50.0,50.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,-20.0},{47.0,-10.0},{52.0,-10.0},{50.0,-20.0},{50.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{53.0,25.0},{82.0,7.0}}, textString="V", fillColor={160,160,160}),Text(extent={{0.0,-17.0},{35.0,-37.0}}, textString="duration", fillColor={160,160,160})}),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-60.0},{-50.0,-60.0},{50.0,60.0},{80.0,60.0}}, color={192,192,192})}));
        end RampVoltage;
        model SineVoltage "Sine voltage source"
                  parameter SI.Voltage V=1 "Amplitude of sine wave";
          parameter SI.Angle phase=0 "Phase of sine wave";
          parameter SI.Frequency freqHz=1 "Frequency of sine wave";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.Sine signalSource(amplitude=V,freqHz=freqHz,phase=phase) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-60.2,29.9},{-53.8,46.5},{-48.2,58.1},{-43.3,65.2},{-38.3,69.2},{-33.4,69.8},{-28.5,67.0},{-23.6,61.0},{-18.6,52.0},{-13.0,38.6},{-5.98,18.6},{8.79,-26.9},{15.1,-44.0},{20.8,-56.2},{25.7,-64.0},{30.6,-68.6},{35.5,-70.0},{40.5,-67.9},{45.4,-62.5},{50.3,-54.1},{55.9,-41.3},{63.0,-21.7},{70.0,0.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-99.0,-40.0},{85.0,-40.0}}, color={192,192,192}),Polygon(points={{101.0,-40.0},{85.0,-34.0},{85.0,-46.0},{101.0,-40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,0.0},{-31.6,34.2},{-26.1,53.1},{-21.3,66.4},{-17.1,74.6},{-12.9,79.1},{-8.64,79.8},{-4.42,76.6},{-0.201,69.7},{4.02,59.4},{8.84,44.1},{14.9,21.2},{27.5,-30.8},{33.0,-50.2},{37.8,-64.2},{42.0,-73.1},{46.2,-78.4},{50.5,-80.0},{54.7,-77.6},{58.9,-71.5},{63.1,-61.9},{67.9,-47.2},{74.0,-24.8},{80.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{-41.0,-2.0},{-80.0,-2.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-106.0,-11.0},{-60.0,-29.0}}, textString="offset", fillColor={160,160,160}),Line(points={{-41.0,-2.0},{-41.0,-40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-60.0,-43.0},{-14.0,-61.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{84.0,-52.0},{108.0,-72.0}}, textString="time", fillColor={160,160,160}),Line(points={{-9.0,79.0},{43.0,79.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-42.0,-1.0},{50.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{33.0,80.0},{30.0,67.0},{37.0,67.0},{33.0,80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{37.0,57.0},{83.0,39.0}}, textString="V", fillColor={160,160,160}),Polygon(points={{33.0,1.0},{30.0,14.0},{36.0,14.0},{33.0,1.0},{33.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{33.0,79.0},{33.0,0.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-69.0,109.0},{-4.0,83.0}}, textString="v = p.v - n.v", fillColor={160,160,160})}));
        end SineVoltage;
        model ExpSineVoltage "Exponentially damped sine voltage source"
                  parameter SI.Voltage V=1 "Amplitude of sine wave";
          parameter SI.Frequency freqHz=2 "Frequency of sine wave";
          parameter SI.Angle phase=0 "Phase of sine wave";
          parameter SI.Damping damping=1 "Damping coefficient of sine wave";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.ExpSine signalSource(amplitude=V,freqHz=freqHz,phase=phase,damping=damping) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-14.0},{-75.2,18.3},{-72.0,36.3},{-68.7,50.5},{-65.5,60.2},{-62.3,65.3},{-59.1,65.6},{-55.9,61.3},{-52.7,53.1},{-48.6,38.2},{-43.0,11.8},{-35.0,-27.9},{-30.2,-47.7},{-26.1,-59.9},{-22.1,-67.2},{-18.1,-69.3},{-14.1,-66.5},{-10.1,-59.3},{-5.23,-46.1},{8.44,-0.3},{13.3,12.4},{18.1,20.8},{22.1,24.0},{26.9,23.2},{31.8,17.8},{38.2,5.4},{51.1,-24.5},{57.5,-35.2},{63.1,-39.9},{68.7,-39.9},{75.2,-34.5},{80.0,-27.8}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-99.0,-40.0},{85.0,-40.0}}, color={192,192,192}),Polygon(points={{101.0,-40.0},{85.0,-34.0},{85.0,-46.0},{101.0,-40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-50.0,0.0},{-46.1,28.2},{-43.5,44.0},{-40.9,56.4},{-38.2,64.9},{-35.6,69.4},{-33.0,69.6},{-30.4,65.9},{-27.8,58.7},{-24.5,45.7},{-19.9,22.5},{-13.4,-12.2},{-9.5,-29.5},{-6.23,-40.1},{-2.96,-46.5},{0.302,-48.4},{3.57,-45.9},{6.83,-39.6},{10.8,-28.1},{21.9,12.0},{25.8,23.1},{29.7,30.5},{33.0,33.3},{36.9,32.5},{40.8,27.8},{46.0,16.9},{56.5,-9.2},{61.7,-18.6},{66.3,-22.7},{70.9,-22.6},{76.1,-18.0},{80.0,-12.1}}, color={0,0,0}, thickness=0.5),Text(extent={{-78.0,1.0},{-55.0,-19.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-72.0,-36.0},{-26.0,-54.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{84.0,-52.0},{108.0,-72.0}}, textString="time", fillColor={160,160,160}),Line(points={{-50.0,0.0},{18.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-50.0,0.0},{-81.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{-50.0,77.0},{-50.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,-1.0},{18.0,76.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,73.0},{-50.0,73.0}}, color={192,192,192}),Text(extent={{-42.0,88.0},{9.0,74.0}}, textString="1/freqHz", fillColor={160,160,160}),Polygon(points={{-49.0,73.0},{-40.0,75.0},{-40.0,71.0},{-49.0,73.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{18.0,73.0},{10.0,75.0},{10.0,71.0},{18.0,73.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-50.0,-61.0},{-19.0,-61.0}}, color={192,192,192}),Polygon(points={{-18.0,-61.0},{-26.0,-59.0},{-26.0,-63.0},{-18.0,-61.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-51.0,-63.0},{-27.0,-75.0}}, textString="t", fillColor={160,160,160}),Text(extent={{-82.0,-67.0},{108.0,-96.0}}, textString="V*exp(-damping*t)*sin(2*pi*freqHz*t+phase)", fillColor={160,160,160}),Line(points={{-50.0,0.0},{-50.0,-40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-50.0,-54.0},{-50.0,-72.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,-76.0},{-1.0,-48.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-77.0,105.0},{-38.0,92.0}}, textString="v = p.v - n.v", fillColor={160,160,160})}));
        end ExpSineVoltage;
        model ExponentialsVoltage " Rising and falling exponential voltage source"
                  parameter Real vMax=1 "Upper bound for rising edge";
          parameter SI.Time riseTime(min=0)=0.5 "Rise time";
          parameter SI.Time riseTimeConst(min=Modelica.Constants.small)=0.1 "Rise time constant";
          parameter SI.Time fallTimeConst(min=Modelica.Constants.small)=riseTimeConst "Fall time constant";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.Exponentials signalSource(outMax=vMax,riseTime=riseTime,riseTimeConst=riseTimeConst,fallTimeConst=fallTimeConst) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-76.0,-59.0},{-73.2,-44.3},{-70.3,-31.1},{-66.8,-16.6},{-63.3,-4.0},{-59.7,6.92},{-55.5,18.18},{-51.3,27.7},{-46.3,37.0},{-40.6,45.5},{-34.3,53.1},{-27.2,59.6},{-18.7,65.3},{-8.1,70.2},{-6.0,71.0},{-3.88,58.5},{-1.05,43.7},{1.78,30.8},{4.606,19.45},{8.14,7.3},{11.68,-3.0},{15.9,-13.2},{20.2,-21.6},{25.1,-29.5},{30.8,-36.4},{37.1,-42.3},{44.9,-47.5},{54.8,-51.8},{64.0,-54.4}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-70.0},{84.0,-70.0}}, color={192,192,192}),Polygon(points={{100.0,-70.0},{84.0,-64.0},{84.0,-76.0},{100.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{-37.2,-15.3},{-34.3,-2.1},{-30.8,12.4},{-27.3,25.0},{-23.7,35.92},{-19.5,47.18},{-15.3,56.7},{-10.3,66.0},{-4.6,74.5},{1.7,82.1},{8.8,88.6},{17.3,94.3},{27.9,99.2},{30.0,100.0},{32.12,87.5},{34.95,72.7},{37.78,59.8},{40.606,48.45},{44.14,36.3},{47.68,26.0},{51.9,15.8},{56.2,7.4},{61.1,-0.5},{66.8,-7.4},{73.1,-13.3},{80.9,-18.5},{90.8,-22.8},{100.0,-25.4}}, color={0,0,0}, thickness=0.5),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Text(extent={{-70.0,91.0},{-29.0,71.0}}, textString="outPort", fillColor={160,160,160}),Text(extent={{-78.0,-43.0},{-46.0,-56.0}}, textString="offset", fillColor={160,160,160}),Polygon(points={{-40.0,-70.0},{-43.0,-60.0},{-38.0,-60.0},{-40.0,-70.0},{-40.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-29.0},{-40.0,-60.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-40.0,-30.0},{-42.0,-40.0},{-37.0,-40.0},{-40.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-39.0,-30.0},{-80.0,-30.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-59.0,-71.0},{-13.0,-89.0}}, textString="startTime", fillColor={160,160,160}),Polygon(points={{-41.0,-30.0},{-32.0,-28.0},{-32.0,-32.0},{-41.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{29.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{29.0,-30.0},{21.0,-28.0},{21.0,-32.0},{29.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-26.0,-12.0},{19.0,-28.0}}, textString="riseTime", fillColor={160,160,160}),Text(extent={{78.0,-76.0},{102.0,-96.0}}, textString="time", fillColor={160,160,160}),Line(points={{-100.0,-70.0},{84.0,-70.0}}, color={192,192,192}),Polygon(points={{100.0,-70.0},{84.0,-64.0},{84.0,-76.0},{100.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{-37.2,-15.3},{-34.3,-2.1},{-30.8,12.4},{-27.3,25.0},{-23.7,35.92},{-19.5,47.18},{-15.3,56.7},{-10.3,66.0},{-4.6,74.5},{1.7,82.1},{8.8,88.6},{17.3,94.3},{27.9,99.2},{30.0,100.0},{32.12,87.5},{34.95,72.7},{37.78,59.8},{40.606,48.45},{44.14,36.3},{47.68,26.0},{51.9,15.8},{56.2,7.4},{61.1,-0.5},{66.8,-7.4},{73.1,-13.3},{80.9,-18.5},{90.8,-22.8},{100.0,-25.4}}, color={0,0,0}, thickness=0.5),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Text(extent={{-70.0,91.0},{-29.0,71.0}}, textString="outPort", fillColor={160,160,160}),Text(extent={{-78.0,-43.0},{-46.0,-56.0}}, textString="offset", fillColor={160,160,160}),Polygon(points={{-40.0,-70.0},{-43.0,-60.0},{-38.0,-60.0},{-40.0,-70.0},{-40.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-29.0},{-40.0,-60.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-40.0,-30.0},{-42.0,-40.0},{-37.0,-40.0},{-40.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-39.0,-30.0},{-80.0,-30.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-59.0,-71.0},{-13.0,-89.0}}, textString="startTime", fillColor={160,160,160}),Polygon(points={{-41.0,-30.0},{-32.0,-28.0},{-32.0,-32.0},{-41.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{29.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{29.0,-30.0},{21.0,-28.0},{21.0,-32.0},{29.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-26.0,-12.0},{19.0,-28.0}}, textString="riseTime", fillColor={160,160,160}),Text(extent={{78.0,-76.0},{102.0,-96.0}}, textString="time", fillColor={160,160,160}),Line(points={{30.0,100.0},{30.0,-34.0}}, color={192,192,192}, pattern=LinePattern.Dash)}));
        end ExponentialsVoltage;
        model PulseVoltage "Pulse voltage source"
                  parameter SI.Voltage V=1 "Amplitude of pulse";
          parameter Real width(final min=Modelica.Constants.small,final max=100)=50 "Width of pulse in % of period";
          parameter SI.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.Pulse signalSource(amplitude=V,width=width,period=period) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,-70.0},{-40.0,-70.0},{-40.0,70.0},{0.0,70.0},{0.0,-70.0},{40.0,-70.0},{41.0,70.0},{80.0,70.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,1.0},{-37.0,-12.0},{-30.0,-12.0},{-34.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-34.0,-1.0},{-34.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-33.0,-70.0},{-36.0,-57.0},{-30.0,-57.0},{-33.0,-70.0},{-33.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-78.0,-24.0},{-35.0,-36.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-31.0,-69.0},{15.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-10.0,0.0},{-10.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-80.0,0.0},{-20.0,0.0},{-21.0,50.0},{21.0,50.0},{20.0,-1.0},{41.0,0.0},{40.0,50.0},{80.0,51.0}}, color={0,0,0}, thickness=0.5),Line(points={{-19.0,88.0},{-19.0,49.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{21.0,74.0},{21.0,50.0}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{41.0,88.0},{41.0,50.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-19.0,83.0},{42.0,83.0}}, color={192,192,192}),Line(points={{-19.0,69.0},{21.0,69.0}}, color={192,192,192}),Text(extent={{-9.0,97.0},{37.0,85.0}}, textString="period", fillColor={160,160,160}),Text(extent={{-18.0,81.0},{21.0,69.0}}, textString="width", fillColor={160,160,160}),Line(points={{-52.0,50.0},{-19.0,50.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-34.0,50.0},{-34.0,1.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-78.0,34.0},{-37.0,20.0}}, textString="V", fillColor={160,160,160}),Polygon(points={{-34.0,49.0},{-37.0,36.0},{-30.0,36.0},{-34.0,49.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,1.0},{-37.0,14.0},{-31.0,14.0},{-34.0,1.0},{-34.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{80.0,51.0},{80.0,0.0},{90.0,-1.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{-19.0,69.0},{-10.0,71.0},{-10.0,67.0},{-19.0,69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{21.0,69.0},{13.0,71.0},{13.0,67.0},{21.0,69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-19.0,83.0},{-10.0,85.0},{-10.0,81.0},{-19.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{41.0,83.0},{33.0,85.0},{33.0,81.0},{41.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-78.0,103.0},{-24.0,89.0}}, textString="v = p.v - n.v", fillColor={160,160,160})}));
        end PulseVoltage;
        model SawToothVoltage "Saw tooth voltage source"
                  parameter SI.Voltage V=1 "Amplitude of saw tooth";
          parameter SI.Time period=1 "Time for one period";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.SawTooth signalSource(amplitude=V,period=period) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,-71.0},{-50.0,-71.0},{10.0,70.0},{10.0,-71.0},{70.0,70.0},{70.0,-71.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,-19.0},{-37.0,-32.0},{-30.0,-32.0},{-34.0,-19.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-34.0,-20.0},{-34.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-34.0,-70.0},{-37.0,-57.0},{-31.0,-57.0},{-34.0,-70.0},{-34.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-78.0,-24.0},{-35.0,-36.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-31.0,-69.0},{15.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-10.0,-20.0},{-10.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,88.0},{-10.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{30.0,88.0},{30.0,59.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,83.0},{30.0,83.0}}, color={192,192,192}),Text(extent={{-12.0,97.0},{34.0,85.0}}, textString="period", fillColor={160,160,160}),Line(points={{-44.0,60.0},{30.0,60.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-34.0,47.0},{-34.0,-7.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-78.0,34.0},{-37.0,20.0}}, textString="V", fillColor={160,160,160}),Polygon(points={{-34.0,60.0},{-37.0,47.0},{-30.0,47.0},{-34.0,60.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,-20.0},{-37.0,-7.0},{-31.0,-7.0},{-34.0,-20.0},{-34.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-10.0,83.0},{-1.0,85.0},{-1.0,81.0},{-10.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{30.0,83.0},{22.0,85.0},{22.0,81.0},{30.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-20.0},{-10.0,-20.0},{30.0,60.0},{30.0,-20.0},{72.0,60.0},{72.0,-20.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-77.0,100.0},{-27.0,88.0}}, textString="v = p.v - n.v", fillColor={160,160,160})}));
        end SawToothVoltage;
        model TrapezoidVoltage "Trapezoidal voltage source"
                  parameter SI.Voltage V=1 "Amplitude of trapezoid";
          parameter SI.Time rising(final min=0)=0 "Rising duration of trapezoid";
          parameter SI.Time width(final min=0)=0.5 "Width duration of trapezoid";
          parameter SI.Time falling(final min=0)=0 "Falling duration of trapezoid";
          parameter SI.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
          parameter Integer nperiod=-1 "Number of periods (< 0 means infinite number of periods)";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.Trapezoid signalSource(amplitude=V,rising=rising,width=width,falling=falling,period=period,nperiod=nperiod) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-81.0,-70.0},{-60.0,-70.0},{-30.0,70.0},{1.0,70.0},{30.0,-70.0},{51.0,-70.0},{80.0,70.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-45.0,-30.0},{-47.0,-41.0},{-43.0,-41.0},{-45.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-45.0,-31.0},{-45.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-45.0,-70.0},{-47.0,-60.0},{-43.0,-60.0},{-45.0,-70.0},{-45.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-86.0,-43.0},{-43.0,-55.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-47.0,-69.0},{-1.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-30.0,81.0},{-30.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,59.0},{-10.0,40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{20.0,59.0},{20.0,39.0}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{40.0,59.0},{40.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-29.0,56.0},{40.0,56.0}}, color={192,192,192}),Text(extent={{-8.0,70.0},{21.0,60.0}}, textString="width", fillColor={160,160,160}),Line(points={{-42.0,40.0},{-10.0,40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-39.0,40.0},{-39.0,-19.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-77.0,14.0},{-40.0,0.0}}, textString="V", fillColor={160,160,160}),Polygon(points={{-29.0,56.0},{-22.0,58.0},{-22.0,54.0},{-29.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-10.0,56.0},{-17.0,58.0},{-17.0,54.0},{-10.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-30.0},{-30.0,-30.0},{-9.0,46.0},{21.0,46.0},{40.0,-30.0},{60.0,-30.0},{80.0,46.0},{100.0,46.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{-39.0,40.0},{-41.0,29.0},{-37.0,29.0},{-39.0,40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-39.0,-29.0},{-41.0,-19.0},{-37.0,-19.0},{-39.0,-29.0},{-39.0,-29.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{60.0,81.0},{60.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{39.0,56.0},{32.0,58.0},{32.0,54.0},{39.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20.0,56.0},{27.0,58.0},{27.0,54.0},{20.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20.0,56.0},{13.0,58.0},{13.0,54.0},{20.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-12.0,56.0},{-5.0,58.0},{-5.0,54.0},{-12.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-34.0,70.0},{-5.0,60.0}}, textString="rising", fillColor={160,160,160}),Text(extent={{16.0,70.0},{45.0,60.0}}, textString="falling", fillColor={160,160,160}),Text(extent={{-77.0,103.0},{-23.0,91.0}}, textString="v = p.v - n.v", fillColor={160,160,160}),Line(points={{-20.0,76.0},{61.0,76.0}}, color={192,192,192}),Polygon(points={{-29.0,76.0},{-20.0,78.0},{-20.0,74.0},{-29.0,76.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{61.0,76.0},{53.0,78.0},{53.0,74.0},{61.0,76.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-2.0,86.0},{25.0,77.0}}, textString="period", fillColor={160,160,160})}));
        end TrapezoidVoltage;
        model TableVoltage "Voltage source by linear interpolation in a table"
                  parameter Real table[:,:]={{0,0},{1,1},{2,4}} "Table matrix (time = first column, voltage = second column)";
          extends Interfaces.VoltageSource(redeclare Modelica.Blocks.Sources.TimeTable signalSource(table=table) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-66.0,-36.0},{-66.0,84.0},{34.0,84.0},{34.0,-36.0},{-66.0,-36.0},{-66.0,-6.0},{34.0,-6.0},{34.0,24.0},{-66.0,24.0},{-66.0,54.0},{34.0,54.0},{34.0,84.0},{-16.0,84.0},{-16.0,-37.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Rectangle(extent={{-20.0,90.0},{30.0,-30.0}}, lineColor={255,255,255}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-20.0,-30.0},{-20.0,90.0},{80.0,90.0},{80.0,-30.0},{-20.0,-30.0},{-20.0,0.0},{80.0,0.0},{80.0,30.0},{-20.0,30.0},{-20.0,60.0},{80.0,60.0},{80.0,90.0},{30.0,90.0},{30.0,-31.0}}, color={0,0,0}),Text(extent={{-77.0,-42.0},{-38.0,-58.0}}, textString="offset", fillColor={160,160,160}),Polygon(points={{-31.0,-30.0},{-33.0,-40.0},{-28.0,-40.0},{-31.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-30.0,-70.0},{-33.0,-60.0},{-28.0,-60.0},{-30.0,-70.0},{-30.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-31.0,-31.0},{-31.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{-20.0,-20.0},{-20.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-38.0,-70.0},{8.0,-88.0}}, textString="startTime", fillColor={160,160,160}),Line(points={{-20.0,-30.0},{-80.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{66.0,-81.0},{91.0,-93.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-15.0,83.0},{24.0,68.0}}, textString="time", fillColor={0,0,0}),Text(extent={{33.0,83.0},{76.0,67.0}}, textString="v", fillColor={0,0,0}),Text(extent={{-81.0,98.0},{-31.0,85.0}}, textString="v = p.v - n.v", fillColor={160,160,160})}),Documentation(info="<HTML>
 <p>
 This block generates a voltage source by <b>linear interpolation</b> in
 a table. The time points and voltage values are stored in a matrix
 <b>table[i,j]</b>, where the first column table[:,1] contains the
 time points and the second column contains the voltage to be interpolated.
 The table interpolation has the following proporties:
 </p>
 <ul>
 <li>The time points need to be <b>monotonically increasing</b>. </li>
 <li><b>Discontinuities</b> are allowed, by providing the same
     time point twice in the table. </li>
 <li>Values <b>outside</b> of the table range, are computed by
     <b>extrapolation</b> through the last or first two points of the
     table.</li>
 <li>If the table has only <b>one row</b>, no interpolation is performed and
     the voltage value is just returned independantly of the
     actual time instant, i.e., this is a constant voltage source.</li>
 <li>Via parameters <b>startTime</b> and <b>offset</b> the curve defined
     by the table can be shifted both in time and in the voltage.
 <li>The table is implemented in a numerically sound way by
     generating <b>time events</b> at interval boundaries,
     in order to not integrate over a discontinuous or not differentiable
     points.
 </li>
 </ul>
 <p>
 Example:
 </p>
 <pre>
    table = [0  0
             1  0
             1  1
             2  4
             3  9
             4 16]
 If, e.g., time = 1.0, the voltage v =  0.0 (before event), 1.0 (after event)
     e.g., time = 1.5, the voltage v =  2.5,
     e.g., time = 2.0, the voltage v =  4.0,
     e.g., time = 5.0, the voltage v = 23.0 (i.e. extrapolation).
 </pre>
 </HTML>
 "));
        end TableVoltage;
        model SignalCurrent "Generic current source using the input signal as source current"
                  Interfaces.PositivePin p annotation(Placement(transformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0),iconTransformation(x=-100.0,y=0.0,scale=0.1,aspectRatio=1.0)));
          Interfaces.NegativePin n annotation(Placement(transformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true),iconTransformation(x=100.0,y=0.0,scale=0.1,aspectRatio=1.0,flipHorizontal=true)));
          SI.Voltage v "Voltage drop between the two pins (= p.v - n.v)";
          Modelica.Blocks.Interfaces.RealInput i(redeclare type SignalType= SI.Current ) "Current flowing from pin p to pin n as input signal" annotation(Placement(transformation(x=0.0,y=70.0,scale=0.2,aspectRatio=1.0,rotation=-90),iconTransformation(x=0.0,y=70.0,scale=0.2,aspectRatio=1.0,rotation=-90)));
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{-50.0,0.0}}, color={0,0,0}),Line(points={{50.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-50.0},{0.0,50.0}}, color={0,0,0}),Text(extent={{-100.0,-120.0},{100.0,-80.0}}, textString="%name", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-96.0,0.0},{-50.0,0.0}}, color={0,0,0}),Line(points={{50.0,0.0},{96.0,0.0}}, color={0,0,0}),Line(points={{0.0,-50.0},{0.0,50.0}}, color={0,0,0})}));

        equation 
          v=p.v - n.v;
          0=p.i + n.i;
          i=p.i;
        end SignalCurrent;
        model ConstantCurrent "Source for constant current"
                  parameter SI.Current I=1 "Value of constant current";
          extends Interfaces.OnePort;
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-90.0,0.0},{-50.0,0.0}}, color={0,0,0}),Line(points={{50.0,0.0},{90.0,0.0}}, color={0,0,0}),Line(points={{0.0,-50.0},{0.0,50.0}}, color={0,0,0}),Text(extent={{-100.0,-120.0},{100.0,-80.0}}, textString="%name=%I", fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Ellipse(extent={{-50.0,50.0},{50.0,-50.0}}, lineColor={0,0,0}, fillColor={255,255,255}, fillPattern=FillPattern.Solid),Line(points={{-96.0,0.0},{-50.0,0.0}}, color={0,0,0}),Line(points={{50.0,0.0},{96.0,0.0}}, color={0,0,0}),Line(points={{0.0,-50.0},{0.0,50.0}}, color={0,0,0})}));

        equation 
          i=I;
        end ConstantCurrent;
        model StepCurrent "Step current source"
                  parameter SI.Current I=1 "Height of step";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.Step signalSource(height=I) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-86.0,-70.0},{-13.0,-70.0},{-14.0,70.0},{57.0,70.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-18.0},{0.0,-18.0},{0.0,50.0},{80.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Text(extent={{-21.0,-72.0},{25.0,-90.0}}, textString="startTime", fillColor={160,160,160}),Line(points={{0.0,-17.0},{0.0,-71.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-68.0,-36.0},{-22.0,-54.0}}, textString="offset", fillColor={160,160,160}),Line(points={{-13.0,50.0},{-13.0,-17.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{2.0,50.0},{-19.0,50.0},{2.0,50.0}}, lineColor={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{-13.0,-17.0},{-16.0,-4.0},{-10.0,-4.0},{-13.0,-17.0},{-13.0,-17.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-13.0,50.0},{-16.0,37.0},{-9.0,37.0},{-13.0,50.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-68.0,26.0},{-22.0,8.0}}, textString="I", fillColor={160,160,160}),Polygon(points={{-13.0,-69.0},{-16.0,-56.0},{-10.0,-56.0},{-13.0,-69.0},{-13.0,-69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-13.0,-18.0},{-13.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-13.0,-18.0},{-16.0,-31.0},{-9.0,-31.0},{-13.0,-18.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-73.0,75.0},{-53.0,95.0}}, textString="i", fillColor={192,192,192})}));
        end StepCurrent;
        model RampCurrent "Ramp current source"
                  parameter SI.Current I=1 "Height of ramp";
          parameter SI.Time duration(min=Modelica.Constants.small)=2 "Duration of ramp";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.Ramp signalSource(final height=I,final duration=duration) );
          annotation(Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-80.0,-20.0},{-20.0,-20.0},{50.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-40.0,-20.0},{-42.0,-30.0},{-37.0,-30.0},{-40.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-20.0},{-40.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-40.0,-70.0},{-43.0,-60.0},{-38.0,-60.0},{-40.0,-70.0},{-40.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-80.0,-33.0},{-41.0,-49.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-40.0,-70.0},{6.0,-88.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-20.0,-20.0},{-20.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-19.0,-20.0},{50.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Line(points={{50.0,50.0},{101.0,50.0}}, color={0,0,0}, thickness=0.5),Line(points={{50.0,50.0},{50.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{50.0,-20.0},{42.0,-18.0},{42.0,-22.0},{50.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-20.0,-20.0},{-11.0,-18.0},{-11.0,-22.0},{-20.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,50.0},{48.0,40.0},{53.0,40.0},{50.0,50.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{50.0,-20.0},{47.0,-10.0},{52.0,-10.0},{50.0,-20.0},{50.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{53.0,25.0},{82.0,7.0}}, textString="I", fillColor={160,160,160}),Text(extent={{0.0,-17.0},{35.0,-37.0}}, textString="duration", fillColor={160,160,160}),Text(extent={{-73.0,75.0},{-53.0,95.0}}, textString="i", fillColor={192,192,192})}),Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-60.0},{-50.0,-60.0},{50.0,60.0},{80.0,60.0}}, color={192,192,192})}));
        end RampCurrent;
        model SineCurrent "Sine current source"
                  parameter SI.Current I=1 "Amplitude of sine wave";
          parameter SI.Angle phase=0 "Phase of sine wave";
          parameter SI.Frequency freqHz=1 "Frequency of sine wave";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.Sine signalSource(amplitude=I,freqHz=freqHz,phase=phase) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,0.0},{-60.2,29.9},{-53.8,46.5},{-48.2,58.1},{-43.3,65.2},{-38.3,69.2},{-33.4,69.8},{-28.5,67.0},{-23.6,61.0},{-18.6,52.0},{-13.0,38.6},{-5.98,18.6},{8.79,-26.9},{15.1,-44.0},{20.8,-56.2},{25.7,-64.0},{30.6,-68.6},{35.5,-70.0},{40.5,-67.9},{45.4,-62.5},{50.3,-54.1},{55.9,-41.3},{63.0,-21.7},{70.0,0.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-99.0,-40.0},{85.0,-40.0}}, color={192,192,192}),Polygon(points={{101.0,-40.0},{85.0,-34.0},{85.0,-46.0},{101.0,-40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,0.0},{-31.6,34.2},{-26.1,53.1},{-21.3,66.4},{-17.1,74.6},{-12.9,79.1},{-8.64,79.8},{-4.42,76.6},{-0.201,69.7},{4.02,59.4},{8.84,44.1},{14.9,21.2},{27.5,-30.8},{33.0,-50.2},{37.8,-64.2},{42.0,-73.1},{46.2,-78.4},{50.5,-80.0},{54.7,-77.6},{58.9,-71.5},{63.1,-61.9},{67.9,-47.2},{74.0,-24.8},{80.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{-41.0,-2.0},{-80.0,-2.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-106.0,-11.0},{-60.0,-29.0}}, textString="offset", fillColor={160,160,160}),Line(points={{-41.0,-2.0},{-41.0,-40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-60.0,-43.0},{-14.0,-61.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{84.0,-52.0},{108.0,-72.0}}, textString="time", fillColor={160,160,160}),Line(points={{-9.0,79.0},{43.0,79.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-42.0,-1.0},{50.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{33.0,80.0},{30.0,67.0},{37.0,67.0},{33.0,80.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{37.0,57.0},{83.0,39.0}}, textString="I", fillColor={160,160,160}),Polygon(points={{33.0,1.0},{30.0,14.0},{36.0,14.0},{33.0,1.0},{33.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{33.0,79.0},{33.0,0.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-73.0,82.0},{-53.0,102.0}}, textString="i", fillColor={192,192,192})}));
        end SineCurrent;
        model ExpSineCurrent "Exponentially damped sine current source"
                  parameter Real I=1 "Amplitude of sine wave";
          parameter SI.Frequency freqHz=2 "Frequency of sine wave";
          parameter SI.Angle phase=0 "Phase of sine wave";
          parameter SI.Damping damping=1 "Damping coefficient of sine wave";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.ExpSine signalSource(amplitude=I,freqHz=freqHz,phase=phase,damping=damping) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-14.0},{-75.2,18.3},{-72.0,36.3},{-68.7,50.5},{-65.5,60.2},{-62.3,65.3},{-59.1,65.6},{-55.9,61.3},{-52.7,53.1},{-48.6,38.2},{-43.0,11.8},{-35.0,-27.9},{-30.2,-47.7},{-26.1,-59.9},{-22.1,-67.2},{-18.1,-69.3},{-14.1,-66.5},{-10.1,-59.3},{-5.23,-46.1},{8.44,-0.3},{13.3,12.4},{18.1,20.8},{22.1,24.0},{26.9,23.2},{31.8,17.8},{38.2,5.4},{51.1,-24.5},{57.5,-35.2},{63.1,-39.9},{68.7,-39.9},{75.2,-34.5},{80.0,-27.8}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-80.0,-90.0},{-80.0,84.0}}, color={192,192,192}),Polygon(points={{-80.0,100.0},{-86.0,84.0},{-74.0,84.0},{-80.0,100.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-99.0,-40.0},{85.0,-40.0}}, color={192,192,192}),Polygon(points={{101.0,-40.0},{85.0,-34.0},{85.0,-46.0},{101.0,-40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-50.0,0.0},{-46.1,28.2},{-43.5,44.0},{-40.9,56.4},{-38.2,64.9},{-35.6,69.4},{-33.0,69.6},{-30.4,65.9},{-27.8,58.7},{-24.5,45.7},{-19.9,22.5},{-13.4,-12.2},{-9.5,-29.5},{-6.23,-40.1},{-2.96,-46.5},{0.302,-48.4},{3.57,-45.9},{6.83,-39.6},{10.8,-28.1},{21.9,12.0},{25.8,23.1},{29.7,30.5},{33.0,33.3},{36.9,32.5},{40.8,27.8},{46.0,16.9},{56.5,-9.2},{61.7,-18.6},{66.3,-22.7},{70.9,-22.6},{76.1,-18.0},{80.0,-12.1}}, color={0,0,0}, thickness=0.5),Text(extent={{-78.0,1.0},{-55.0,-19.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-72.0,-36.0},{-26.0,-54.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{84.0,-52.0},{108.0,-72.0}}, textString="time", fillColor={160,160,160}),Line(points={{-50.0,0.0},{18.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-50.0,0.0},{-81.0,0.0}}, color={0,0,0}, thickness=0.5),Line(points={{-50.0,77.0},{-50.0,0.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,-1.0},{18.0,76.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,73.0},{-50.0,73.0}}, color={192,192,192}),Text(extent={{-42.0,88.0},{9.0,74.0}}, textString="1/freqHz", fillColor={160,160,160}),Polygon(points={{-49.0,73.0},{-40.0,75.0},{-40.0,71.0},{-49.0,73.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{18.0,73.0},{10.0,75.0},{10.0,71.0},{18.0,73.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-50.0,-61.0},{-19.0,-61.0}}, color={192,192,192}),Polygon(points={{-18.0,-61.0},{-26.0,-59.0},{-26.0,-63.0},{-18.0,-61.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-51.0,-63.0},{-27.0,-75.0}}, textString="t", fillColor={160,160,160}),Text(extent={{-82.0,-67.0},{108.0,-96.0}}, textString="I*exp(-damping*t)*sin(2*pi*freqHz*t+phase)", fillColor={160,160,160}),Line(points={{-50.0,0.0},{-50.0,-40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-50.0,-54.0},{-50.0,-72.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{18.0,-76.0},{-1.0,-48.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-74.0,83.0},{-54.0,103.0}}, textString="i", fillColor={192,192,192})}));
        end ExpSineCurrent;
        model ExponentialsCurrent " Rising and falling exponential current source"
                  parameter Real iMax=1 "Upper bound for rising edge";
          parameter SI.Time riseTime(min=0)=0.5 "Rise time";
          parameter SI.Time riseTimeConst(min=Modelica.Constants.small)=0.1 "Rise time constant";
          parameter SI.Time fallTimeConst(min=Modelica.Constants.small)=riseTimeConst "Fall time constant";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.Exponentials signalSource(outMax=iMax,riseTime=riseTime,riseTimeConst=riseTimeConst,fallTimeConst=fallTimeConst) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-76.0,-59.0},{-73.2,-44.3},{-70.3,-31.1},{-66.8,-16.6},{-63.3,-4.0},{-59.7,6.92},{-55.5,18.18},{-51.3,27.7},{-46.3,37.0},{-40.6,45.5},{-34.3,53.1},{-27.2,59.6},{-18.7,65.3},{-8.1,70.2},{-6.0,71.0},{-3.88,58.5},{-1.05,43.7},{1.78,30.8},{4.606,19.45},{8.14,7.3},{11.68,-3.0},{15.9,-13.2},{20.2,-21.6},{25.1,-29.5},{30.8,-36.4},{37.1,-42.3},{44.9,-47.5},{54.8,-51.8},{64.0,-54.4}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-100.0,-70.0},{84.0,-70.0}}, color={192,192,192}),Polygon(points={{100.0,-70.0},{84.0,-64.0},{84.0,-76.0},{100.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{-37.2,-15.3},{-34.3,-2.1},{-30.8,12.4},{-27.3,25.0},{-23.7,35.92},{-19.5,47.18},{-15.3,56.7},{-10.3,66.0},{-4.6,74.5},{1.7,82.1},{8.8,88.6},{17.3,94.3},{27.9,99.2},{30.0,100.0},{32.12,87.5},{34.95,72.7},{37.78,59.8},{40.606,48.45},{44.14,36.3},{47.68,26.0},{51.9,15.8},{56.2,7.4},{61.1,-0.5},{66.8,-7.4},{73.1,-13.3},{80.9,-18.5},{90.8,-22.8},{100.0,-25.4}}, color={0,0,0}, thickness=0.5),Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Polygon(points={{-40.0,-70.0},{-43.0,-60.0},{-38.0,-60.0},{-40.0,-70.0},{-40.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-29.0},{-40.0,-60.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-40.0,-30.0},{-42.0,-40.0},{-37.0,-40.0},{-40.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-39.0,-30.0},{-80.0,-30.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-59.0,-71.0},{-13.0,-89.0}}, textString="startTime", fillColor={160,160,160}),Polygon(points={{-41.0,-30.0},{-32.0,-28.0},{-32.0,-32.0},{-41.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-40.0,-30.0},{29.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{29.0,-30.0},{21.0,-28.0},{21.0,-32.0},{29.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-26.0,-12.0},{19.0,-28.0}}, textString="riseTime", fillColor={160,160,160}),Line(points={{-39.0,-30.0},{-80.0,-30.0}}, color={0,0,0}, thickness=0.5),Line(points={{30.0,100.0},{30.0,-34.0}}, color={192,192,192}, pattern=LinePattern.Dash),Text(extent={{-73.0,75.0},{-53.0,95.0}}, textString="i", fillColor={192,192,192})}));
        end ExponentialsCurrent;
        model PulseCurrent "Pulse current source"
                  parameter SI.Current I=1 "Amplitude of pulse";
          parameter Real width(final min=Modelica.Constants.small,final max=100)=50 "Width of pulse in % of period";
          parameter SI.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.Pulse signalSource(amplitude=I,width=width,period=period) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,-70.0},{-40.0,-70.0},{-40.0,70.0},{0.0,70.0},{0.0,-70.0},{40.0,-70.0},{41.0,70.0},{80.0,70.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,1.0},{-37.0,-12.0},{-30.0,-12.0},{-34.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-34.0,-1.0},{-34.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-33.0,-70.0},{-36.0,-57.0},{-30.0,-57.0},{-33.0,-70.0},{-33.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-78.0,-24.0},{-35.0,-36.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-31.0,-69.0},{15.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-10.0,0.0},{-10.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-80.0,0.0},{-20.0,0.0},{-21.0,50.0},{21.0,50.0},{20.0,-1.0},{41.0,0.0},{40.0,50.0},{80.0,51.0}}, color={0,0,0}, thickness=0.5),Line(points={{-19.0,88.0},{-19.0,49.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{21.0,74.0},{21.0,50.0}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{41.0,88.0},{41.0,50.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-19.0,83.0},{42.0,83.0}}, color={192,192,192}),Line(points={{-19.0,69.0},{21.0,69.0}}, color={192,192,192}),Text(extent={{-9.0,97.0},{37.0,85.0}}, textString="period", fillColor={160,160,160}),Text(extent={{-18.0,81.0},{21.0,69.0}}, textString="width", fillColor={160,160,160}),Line(points={{-52.0,50.0},{-19.0,50.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-34.0,50.0},{-34.0,1.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-78.0,34.0},{-37.0,20.0}}, textString="I", fillColor={160,160,160}),Polygon(points={{-34.0,49.0},{-37.0,36.0},{-30.0,36.0},{-34.0,49.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,1.0},{-37.0,14.0},{-31.0,14.0},{-34.0,1.0},{-34.0,1.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{80.0,51.0},{80.0,0.0},{90.0,-1.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{-19.0,69.0},{-10.0,71.0},{-10.0,67.0},{-19.0,69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{21.0,69.0},{13.0,71.0},{13.0,67.0},{21.0,69.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-19.0,83.0},{-10.0,85.0},{-10.0,81.0},{-19.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{41.0,83.0},{33.0,85.0},{33.0,81.0},{41.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-73.0,75.0},{-53.0,95.0}}, textString="i", fillColor={192,192,192})}));
        end PulseCurrent;
        model SawToothCurrent "Saw tooth current source"
                  parameter SI.Current I=1 "Amplitude of saw tooth";
          parameter SI.Time period=1 "Time for one period";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.SawTooth signalSource(amplitude=I,period=period) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-70.0,-71.0},{-50.0,-71.0},{10.0,70.0},{10.0,-71.0},{70.0,70.0},{70.0,-71.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,-19.0},{-37.0,-32.0},{-30.0,-32.0},{-34.0,-19.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-34.0,-20.0},{-34.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-34.0,-70.0},{-37.0,-57.0},{-31.0,-57.0},{-34.0,-70.0},{-34.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-78.0,-24.0},{-35.0,-36.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-31.0,-69.0},{15.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-10.0,-20.0},{-10.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,88.0},{-10.0,-20.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{30.0,88.0},{30.0,59.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,83.0},{30.0,83.0}}, color={192,192,192}),Text(extent={{-12.0,97.0},{34.0,85.0}}, textString="period", fillColor={160,160,160}),Line(points={{-44.0,60.0},{30.0,60.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-34.0,47.0},{-34.0,-7.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-78.0,34.0},{-37.0,20.0}}, textString="I", fillColor={160,160,160}),Polygon(points={{-34.0,60.0},{-37.0,47.0},{-30.0,47.0},{-34.0,60.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-34.0,-20.0},{-37.0,-7.0},{-31.0,-7.0},{-34.0,-20.0},{-34.0,-20.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-10.0,83.0},{-1.0,85.0},{-1.0,81.0},{-10.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{30.0,83.0},{22.0,85.0},{22.0,81.0},{30.0,83.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-20.0},{-10.0,-20.0},{30.0,60.0},{30.0,-20.0},{72.0,60.0},{72.0,-20.0}}, color={0,0,0}, thickness=0.5),Text(extent={{-73.0,75.0},{-53.0,95.0}}, textString="i", fillColor={192,192,192})}));
        end SawToothCurrent;
        model TrapezoidCurrent "Trapezoidal current source"
                  parameter SI.Current I=1 "Amplitude of trapezoid";
          parameter SI.Time rising(final min=0)=0 "Rising duration of trapezoid";
          parameter SI.Time width(final min=0)=0.5 "Width duration of trapezoid";
          parameter SI.Time falling(final min=0)=0 "Falling duration of trapezoid";
          parameter SI.Time period(final min=Modelica.Constants.small)=1 "Time for one period";
          parameter Integer nperiod=-1 "Number of periods (< 0 means infinite number of periods)";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.Trapezoid signalSource(amplitude=I,rising=rising,width=width,falling=falling,period=period,nperiod=nperiod) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-81.0,-70.0},{-60.0,-70.0},{-30.0,70.0},{1.0,70.0},{30.0,-70.0},{51.0,-70.0},{80.0,70.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,68.0},{-80.0,-80.0}}, color={192,192,192}),Line(points={{-90.0,-70.0},{82.0,-70.0}}, color={192,192,192}),Polygon(points={{90.0,-70.0},{68.0,-62.0},{68.0,-78.0},{90.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-45.0,-30.0},{-47.0,-41.0},{-43.0,-41.0},{-45.0,-30.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-45.0,-31.0},{-45.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Polygon(points={{-45.0,-70.0},{-47.0,-60.0},{-43.0,-60.0},{-45.0,-70.0},{-45.0,-70.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-86.0,-43.0},{-43.0,-55.0}}, textString="offset", fillColor={160,160,160}),Text(extent={{-47.0,-69.0},{-1.0,-87.0}}, textString="startTime", fillColor={160,160,160}),Text(extent={{70.0,-80.0},{94.0,-100.0}}, textString="time", fillColor={160,160,160}),Line(points={{-29.0,79.0},{-30.0,-70.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-10.0,59.0},{-10.0,40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{20.0,59.0},{20.0,39.0}}, color={160,160,160}, pattern=LinePattern.Dash),Line(points={{40.0,59.0},{40.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-20.0,75.0},{60.0,75.0}}, color={192,192,192}),Line(points={{-29.0,56.0},{40.0,56.0}}, color={192,192,192}),Text(extent={{-9.0,88.0},{37.0,76.0}}, textString="period", fillColor={160,160,160}),Text(extent={{-8.0,70.0},{21.0,60.0}}, textString="width", fillColor={160,160,160}),Line(points={{-42.0,40.0},{-10.0,40.0}}, color={192,192,192}, pattern=LinePattern.Dash),Line(points={{-39.0,40.0},{-39.0,-19.0}}, color={192,192,192}, pattern=LinePattern.Solid, thickness=0.25, arrow={Arrow.None,Arrow.None}),Text(extent={{-77.0,14.0},{-40.0,0.0}}, textString="I", fillColor={160,160,160}),Polygon(points={{-29.0,56.0},{-22.0,58.0},{-22.0,54.0},{-29.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-10.0,56.0},{-17.0,58.0},{-17.0,54.0},{-10.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-29.0,75.0},{-20.0,77.0},{-20.0,73.0},{-29.0,75.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{60.0,75.0},{52.0,77.0},{52.0,73.0},{60.0,75.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{-80.0,-30.0},{-30.0,-30.0},{-9.0,46.0},{21.0,46.0},{40.0,-30.0},{60.0,-30.0},{80.0,46.0},{100.0,46.0}}, color={0,0,0}, thickness=0.5),Polygon(points={{-39.0,40.0},{-41.0,29.0},{-37.0,29.0},{-39.0,40.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-39.0,-29.0},{-41.0,-19.0},{-37.0,-19.0},{-39.0,-29.0},{-39.0,-29.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Line(points={{60.0,80.0},{60.0,-30.0}}, color={192,192,192}, pattern=LinePattern.Dash),Polygon(points={{39.0,56.0},{32.0,58.0},{32.0,54.0},{39.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20.0,56.0},{27.0,58.0},{27.0,54.0},{20.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{20.0,56.0},{13.0,58.0},{13.0,54.0},{20.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Polygon(points={{-12.0,56.0},{-5.0,58.0},{-5.0,54.0},{-12.0,56.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPattern=FillPattern.Solid),Text(extent={{-34.0,70.0},{-5.0,60.0}}, textString="rising", fillColor={160,160,160}),Text(extent={{16.0,70.0},{45.0,60.0}}, textString="falling", fillColor={160,160,160}),Text(extent={{-73.0,75.0},{-53.0,95.0}}, textString="i", fillColor={192,192,192})}));
        end TrapezoidCurrent;
        model TableCurrent "Current source by linear interpolation in a table"
                  parameter Real table[:,:]={{0,0},{1,1},{2,4}} "Table matrix (time = first column, current = second column)";
          extends Interfaces.CurrentSource(redeclare Modelica.Blocks.Sources.TimeTable signalSource(table=table) );
          annotation(Icon(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Line(points={{-66.0,-36.0},{-66.0,84.0},{34.0,84.0},{34.0,-36.0},{-66.0,-36.0},{-66.0,-6.0},{34.0,-6.0},{34.0,24.0},{-66.0,24.0},{-66.0,54.0},{34.0,54.0},{34.0,84.0},{-16.0,84.0},{-16.0,-37.0}}, color={192,192,192})}),Diagram(coordinateSystem(extent={{-100.0,-100.0},{100.0,100.0}}),graphics={Polygon(points={{-80.0,90.0},{-88.0,68.0},{-72.0,68.0},{-80.0,90.0}}, lineColor={192,192,192}, fillColor={192,192,192}, fillPatte