#!/bin/bash

# modify variables to point to the actual location of your files
# OPENMODELICAROOT=/home/william/openModelica/om-trunk/trunk
OPENMODELICAROOT=/home/william/openModelica/OPENMODELICA_1_4_2
MICOHOME=/home/william/openModelica/mico-2.3.12
MICOVER=2.3.12

# modify to create different releases of the package
PACKAGENAME=openmodelica-1.4
VERSION=1.4.3
RELEASE=1
MYARCH=i386

# set to 1 to create a nightly build
nightlyBuild=0

# set names
if [ $nightlyBuild == 1 ]; then
  PACKAGENAME=${PACKAGENAME}-dev
  DEVSUFFIX=-dev
else
  DEVSUFFIX=''
fi

# cleanup old stuff
rm -rf temp
mkdir temp

# create the temp directory for the package
MYDEBROOT=${PACKAGENAME}_${VERSION}-${RELEASE}_${MYARCH}
mkdir -p temp/$MYDEBROOT

# DEBIAN directory
mkdir -p temp/${MYDEBROOT}/DEBIAN
cp resources/DEBIAN/control temp/${MYDEBROOT}/DEBIAN/control
sed -i -e s/_PACKAGENAME_/"${PACKAGENAME}"/ temp/${MYDEBROOT}/DEBIAN/control
sed -i -e s/_VERSION_/"${VERSION}"/ temp/${MYDEBROOT}/DEBIAN/control
sed -i -e s/_RELEASE_/"${RELEASE}"/ temp/${MYDEBROOT}/DEBIAN/control

# /usr/bin directory
mkdir -p temp/${MYDEBROOT}/usr/bin
cp resources/script/* temp/${MYDEBROOT}/usr/bin
for fileName in "temp/${MYDEBROOT}/usr/bin/"* ; do
  sed -i -e s/_PACKAGENAME_/"${PACKAGENAME}"/ ${fileName}
  sed -i -e s/_VERSION_/"${VERSION}"/ ${fileName}
  sed -i -e s/_RELEASE_/"${RELEASE}"/ ${fileName}
  if [ ! -f "${fileName}${DEVSUFFIX}" ]; then
    mv ${fileName} "${fileName}${DEVSUFFIX}"
  fi ;
done

# /usr/lib directory
mkdir -p temp/${MYDEBROOT}/usr/lib/mico-${PACKAGENAME}
cp -P ${MICOHOME}/lib/libmico*.so temp/${MYDEBROOT}/usr/lib/mico-${PACKAGENAME}
chmod 644 temp/${MYDEBROOT}/usr/lib/mico-${PACKAGENAME}/libmico*.so
strip temp/${MYDEBROOT}/usr/lib/mico-${PACKAGENAME}/libmico*.so
cd temp/${MYDEBROOT}/usr/lib/mico-${PACKAGENAME}
ln -sf libmico${MICOVER}.so libmico.so
cd $OLDPWD

# /usr/share/applications
mkdir -p temp/${MYDEBROOT}/usr/share/applications
cp resources/menuitem/*.desktop temp/${MYDEBROOT}/usr/share/applications
for fileName in "temp/${MYDEBROOT}/usr/share/applications/"* ; do
  sed -i -e s/_VERSION_/"${VERSION}"/ ${fileName}
  sed -i -e s/_DEVSUFFIX_/"${DEVSUFFIX}"/ ${fileName}
done
if [ ! -z ${DEVSUFFIX} ]; then
  mv temp/${MYDEBROOT}/usr/share/applications/omnotebook.desktop \
    temp/${MYDEBROOT}/usr/share/applications/omnotebook${DEVSUFFIX}.desktop
  mv temp/${MYDEBROOT}/usr/share/applications/omshell.desktop \
    temp/${MYDEBROOT}/usr/share/applications/omshell${DEVSUFFIX}.desktop
fi


# /usr/share/doc
mkdir -p temp/${MYDEBROOT}/usr/share/doc/${PACKAGENAME}
cp resources/doc/* temp/${MYDEBROOT}/usr/share/doc/${PACKAGENAME}
for fileName in "temp/${MYDEBROOT}/usr/share/doc/${PACKAGENAME}/"* ; do
  sed -i -e s/_PACKAGENAME_/"${PACKAGENAME}"/ ${fileName}
  sed -i -e s/_VERSION_/"${VERSION}"/ ${fileName}
  sed -i -e s/_RELEASE_/"${RELEASE}"/ ${fileName}
done
gzip --best temp/${MYDEBROOT}/usr/share/doc/${PACKAGENAME}/changelog.Debian
cp temp/${MYDEBROOT}/usr/share/doc/${PACKAGENAME}/changelog.Debian.gz \
  temp/${MYDEBROOT}/usr/share/doc/${PACKAGENAME}/changelog.gz

# /usr/share/icons
mkdir -p temp/${MYDEBROOT}/usr/share/icons
cp resources/menuitem/*.xpm temp/${MYDEBROOT}/usr/share/icons
if [ ! -z ${DEVSUFFIX} ]; then
  mv temp/${MYDEBROOT}/usr/share/icons/OMNotebook_icon.xpm \
    temp/${MYDEBROOT}/usr/share/icons/OMNotebook${DEVSUFFIX}_icon.xpm
  mv temp/${MYDEBROOT}/usr/share/icons/OMShell_icon.xpm \
    temp/${MYDEBROOT}/usr/share/icons/OMShell${DEVSUFFIX}_icon.xpm
fi

# /usr/share/man
mkdir -p temp/${MYDEBROOT}/usr/share/man/man1
cp resources/man/* temp/${MYDEBROOT}/usr/share/man/man1
for fileName in "temp/${MYDEBROOT}/usr/bin/"* ; do
  sed -i -e s/_DEVSUFFIX_/"${DEVSUFFIX}"/ ${fileName} ;
done
if [ ! -z ${DEVSUFFIX} ]; then
  mv temp/${MYDEBROOT}/usr/share/man/man1/omc.1 \
    temp/${MYDEBROOT}/usr/share/man/man1/omc${DEVSUFFIX}.1
  mv temp/${MYDEBROOT}/usr/share/man/man1/OMShell.1 \
    temp/${MYDEBROOT}/usr/share/man/man1/OMShell${DEVSUFFIX}.1
  mv temp/${MYDEBROOT}/usr/share/man/man1/OMNotebook.1 \
    temp/${MYDEBROOT}/usr/share/man/man1/OMNotebook${DEVSUFFIX}.1
fi
gzip --best temp/${MYDEBROOT}/usr/share/man/man1/*

# /usr/share/openmodelica
mkdir -p temp/${MYDEBROOT}/usr/share/${PACKAGENAME}
# omc
cp -r ${OPENMODELICAROOT}/build/* temp/${MYDEBROOT}/usr/share/${PACKAGENAME}
rm -f temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin/*.bat
chmod 755 temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin/doPlot
strip temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin/omc
cp ${OPENMODELICAROOT}/OMNotebook/OMNotebookQT4/*.xml \
  temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin

# OMShell
cp ${OPENMODELICAROOT}/OMShell/OMShell \
  temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin
strip temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin/OMShell

# OMNotebook
cp ${OPENMODELICAROOT}/OMNotebook/OMNotebookQT4/OMNotebook \
  temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin
strip temp/${MYDEBROOT}/usr/share/${PACKAGENAME}/bin/OMNotebook

# remove .svn stuff
find temp/${MYDEBROOT}/usr/share/ -name '.svn' -type d -print | xargs rm -rf

# Modelica library
cp -r resources/modelica-2.2 temp/${MYDEBROOT}/usr/share/${PACKAGENAME}
cp -r resources/drmodelica temp/${MYDEBROOT}/usr/share/${PACKAGENAME}

# build the package and check it
fakeroot dpkg-deb --build temp/${PACKAGENAME}_${VERSION}-${RELEASE}_${MYARCH}
mkdir -p packages
mv temp/${PACKAGENAME}_${VERSION}-${RELEASE}_${MYARCH}.deb packages
lintian packages/${PACKAGENAME}_${VERSION}-${RELEASE}_${MYARCH}.deb