#include "SimCode_translateFunctions.h"
#include <algorithm>
#define MODELICA_ASSERT(msg) { fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {
void _SimCode_translateFunctions(modelica_string _name, modelica_metatype _daeMainFunction, modelica_metatype _daeElements, modelica_metatype _metarecordTypes)
{
  modelica_complex tmp1;


  { /* matchcontinue expression */
    modelica_string tmp2_in0;
    modelica_metatype tmp2_in1;
    modelica_metatype tmp2_in2;
    modelica_metatype tmp2_in3;
    tmp2_in0 = _name;
    tmp2_in1 = _daeMainFunction;
    tmp2_in2 = _daeElements;
    tmp2_in3 = _metarecordTypes;
    {
      modelica_metatype _mainFunction;
      modelica_metatype _fns;
      modelica_metatype _libs;
      modelica_metatype _includes;
      modelica_metatype _makefileParams;
      modelica_metatype _fnCode;
      modelica_metatype _extraRecordDecls;
      int tmp3;
      int tmp4;
      for (tmp3 = 0, tmp4 = 0; tmp3 < 1 && !tmp4; tmp3++) {
        MMC_TRY()
        switch (tmp3) {
        case 0: {
          modelica_metatype tmp5;
          SimCode_elaborateFunctions_rettype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          SimCode_createMakefileParams_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_tplString_rettype tmp11;
          
          /* Pattern matching succeeded */
          _name = tmp2_in0;
          _daeMainFunction = tmp2_in1;
          _daeElements = tmp2_in2;
          _metarecordTypes = tmp2_in3;
          tmp5 = mmc_mk_cons(_daeMainFunction, _daeElements);
          tmp6 = _SimCode_elaborateFunctions(tmp5, _metarecordTypes);
          if (listEmpty(tmp6.targ1)) MMC_THROW();
          tmp7 = MMC_CAR(tmp6.targ1);
          tmp8 = MMC_CDR(tmp6.targ1);
          _mainFunction = tmp7;
          _fns = tmp8;
          _extraRecordDecls = tmp6.targ2;
          _includes = tmp6.targ3;
          _libs = tmp6.targ4;

          _SimCode_checkValidMainFunction(_name, _mainFunction);
          /* NORETCALL */;
          tmp9 = _SimCode_createMakefileParams(_libs);
          _makefileParams = tmp9.SimCode_createMakefileParams_rettype_1;
          tmp10 = mmc_mk_box7(3, &SimCode_FunctionCode_FUNCTIONCODE__desc, mmc_mk_string(_name), _mainFunction, _fns, _includes, _makefileParams, _extraRecordDecls);
          _fnCode = tmp10;
          tmp11 = _Tpl_tplString(((modelica_fnptr)boxptr_SimCodeC_translateFunctions), _fnCode);
          tmp4 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp4) MMC_THROW();
    }
  }
  
  _return:
  return;
}

int in_SimCode_translateFunctions(type_description * inArgs, type_description * outVar)
{
  modelica_string _name;
  modelica_metatype _daeMainFunction;
  modelica_metatype _daeElements;
  modelica_metatype _metarecordTypes;
  if (read_modelica_string(&inArgs, (char**) &_name)) return 1;
  if (read_modelica_metatype(&inArgs, &_daeMainFunction)) return 1;
  if (read_modelica_metatype(&inArgs, &_daeElements)) return 1;
  if (read_modelica_metatype(&inArgs, &_metarecordTypes)) return 1;
  MMC_TRY_TOP()
  _SimCode_translateFunctions(_name, _daeMainFunction, _daeElements, _metarecordTypes);
  MMC_CATCH_TOP(return 1)
  write_noretcall(outVar);
  return 0;
}

void boxptr_SimCode_translateFunctions(modelica_metatype _name, modelica_metatype _daeMainFunction, modelica_metatype _daeElements, modelica_metatype _metarecordTypes)
{
  modelica_string tmp1;
  tmp1 = mmc_unbox_string(_name);
  _SimCode_translateFunctions(tmp1, _daeMainFunction, _daeElements, _metarecordTypes);
  return ;
}
Tpl_tplString_rettype _Tpl_tplString(modelica_fnptr inFun, modelica_metatype _inArg)
{
  #define inFun_rettype_1 targ1
  typedef struct inFun_rettype_s
  {
    modelica_metatype targ1;
  } inFun_rettype;
  inFun_rettype(*_inFun)(modelica_metatype, modelica_metatype);
  Tpl_tplString_rettype tmp1;
  modelica_string _outString;
  modelica_metatype _txt;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  inFun_rettype tmp5;
  Tpl_textString_rettype tmp6;

  _inFun = (inFun_rettype(*)(modelica_metatype, modelica_metatype)) inFun;

  tmp2 = mmc_mk_nil();
  tmp3 = mmc_mk_nil();
  tmp4 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp2, tmp3);
  tmp5 = _inFun(tmp4, _inArg);
  _txt = tmp5.inFun_rettype_1;
  tmp6 = _Tpl_textString(_txt);
  _outString = tmp6.Tpl_textString_rettype_1;
  
  _return:
  tmp1.targ1 = _outString;
  return tmp1;
}


Tpl_tplString_rettypeboxed boxptr_Tpl_tplString(modelica_fnptr inFun, modelica_metatype _inArg)
{
  Tpl_tplString_rettypeboxed tmp1;
  Tpl_tplString_rettype tmp2;
  modelica_metatype tmp3;
  tmp2 = _Tpl_tplString(inFun, _inArg);
  tmp3 = mmc_mk_scon(tmp2.Tpl_tplString_rettype_1);
  tmp1.Tpl_tplString_rettypeboxed_1 = tmp3;
  return tmp1;
}
SimCodeC_translateFunctions_rettype _SimCodeC_translateFunctions(modelica_metatype _in_txt, modelica_metatype _in_a_functionCode)
{
  SimCodeC_translateFunctions_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_functionCode;
    {
      modelica_metatype _txt;
      modelica_metatype _i_functionCode;
      modelica_metatype _i_externalFunctionIncludes;
      modelica_metatype _i_extraRecordDecls;
      modelica_metatype _i_functions;
      modelica_metatype _i_mainFunction;
      modelica_string _i_name;
      modelica_metatype _txt_8;
      modelica_metatype _txt_7;
      modelica_metatype _txt_6;
      modelica_metatype _txt_5;
      modelica_metatype _txt_4;
      modelica_metatype _txt_3;
      modelica_metatype _txt_2;
      modelica_metatype _txt_1;
      modelica_metatype _l_filePrefix;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_string tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          Tpl_writeStr_rettype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          Tpl_textString_rettype tmp20;
          SimCodeC_functionsHeaderFile_rettype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          Tpl_writeText_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          Tpl_textString_rettype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          Tpl_textString_rettype tmp32;
          SimCodeC_functionsFile_rettype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          Tpl_writeText_rettype tmp37;
          modelica_metatype tmp38;
          Tpl_writeTok_rettype tmp39;
          Tpl_textString_rettype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          Tpl_textString_rettype tmp44;
          SimCodeC_recordsFile_rettype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          Tpl_writeText_rettype tmp49;
          modelica_metatype tmp50;
          Tpl_writeTok_rettype tmp51;
          Tpl_textString_rettype tmp52;
          modelica_metatype tmp53;
          modelica_metatype tmp54;
          modelica_metatype tmp55;
          SimCodeC_functionsMakefile_rettype tmp56;
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          modelica_metatype tmp59;
          Tpl_writeText_rettype tmp60;
          modelica_metatype tmp61;
          Tpl_writeTok_rettype tmp62;
          Tpl_textString_rettype tmp63;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,6) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = mmc_unbox_string(tmp6);
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_functionCode = tmp3_in1;
          _i_name = tmp7;
          _i_mainFunction = tmp8;
          _i_functions = tmp9;
          _i_externalFunctionIncludes = tmp10;
          _i_extraRecordDecls = tmp12;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = _Tpl_writeStr(tmp15, _i_name);
          _l_filePrefix = tmp16.Tpl_writeStr_rettype_1;
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_nil();
          tmp19 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp17, tmp18);
          tmp20 = _Tpl_textString(_l_filePrefix);
          tmp21 = _SimCodeC_functionsHeaderFile(tmp19, tmp20.Tpl_textString_rettype_1, _i_mainFunction, _i_functions, _i_extraRecordDecls, _i_externalFunctionIncludes);
          _txt_1 = tmp21.SimCodeC_functionsHeaderFile_rettype_1;
          tmp22 = mmc_mk_nil();
          tmp23 = mmc_mk_nil();
          tmp24 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp22, tmp23);
          tmp25 = _Tpl_writeText(tmp24, _l_filePrefix);
          _txt_2 = tmp25.Tpl_writeText_rettype_1;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".h"));
          tmp27 = _Tpl_writeTok(_txt_2, tmp26);
          _txt_2 = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = _Tpl_textString(_txt_2);
          _Tpl_textFile(_txt_1, tmp28.Tpl_textString_rettype_1);
          /* NORETCALL */;
          tmp29 = mmc_mk_nil();
          tmp30 = mmc_mk_nil();
          tmp31 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp29, tmp30);
          tmp32 = _Tpl_textString(_l_filePrefix);
          tmp33 = _SimCodeC_functionsFile(tmp31, tmp32.Tpl_textString_rettype_1, _i_mainFunction, _i_functions);
          _txt_3 = tmp33.SimCodeC_functionsFile_rettype_1;
          tmp34 = mmc_mk_nil();
          tmp35 = mmc_mk_nil();
          tmp36 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp34, tmp35);
          tmp37 = _Tpl_writeText(tmp36, _l_filePrefix);
          _txt_4 = tmp37.Tpl_writeText_rettype_1;
          tmp38 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".c"));
          tmp39 = _Tpl_writeTok(_txt_4, tmp38);
          _txt_4 = tmp39.Tpl_writeTok_rettype_1;
          tmp40 = _Tpl_textString(_txt_4);
          _Tpl_textFile(_txt_3, tmp40.Tpl_textString_rettype_1);
          /* NORETCALL */;
          tmp41 = mmc_mk_nil();
          tmp42 = mmc_mk_nil();
          tmp43 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp41, tmp42);
          tmp44 = _Tpl_textString(_l_filePrefix);
          tmp45 = _SimCodeC_recordsFile(tmp43, tmp44.Tpl_textString_rettype_1, _i_extraRecordDecls);
          _txt_5 = tmp45.SimCodeC_recordsFile_rettype_1;
          tmp46 = mmc_mk_nil();
          tmp47 = mmc_mk_nil();
          tmp48 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp46, tmp47);
          tmp49 = _Tpl_writeText(tmp48, _l_filePrefix);
          _txt_6 = tmp49.Tpl_writeText_rettype_1;
          tmp50 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_records.c"));
          tmp51 = _Tpl_writeTok(_txt_6, tmp50);
          _txt_6 = tmp51.Tpl_writeTok_rettype_1;
          tmp52 = _Tpl_textString(_txt_6);
          _Tpl_textFile(_txt_5, tmp52.Tpl_textString_rettype_1);
          /* NORETCALL */;
          tmp53 = mmc_mk_nil();
          tmp54 = mmc_mk_nil();
          tmp55 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp53, tmp54);
          tmp56 = _SimCodeC_functionsMakefile(tmp55, _i_functionCode);
          _txt_7 = tmp56.SimCodeC_functionsMakefile_rettype_1;
          tmp57 = mmc_mk_nil();
          tmp58 = mmc_mk_nil();
          tmp59 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp57, tmp58);
          tmp60 = _Tpl_writeText(tmp59, _l_filePrefix);
          _txt_8 = tmp60.Tpl_writeText_rettype_1;
          tmp61 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".makefile"));
          tmp62 = _Tpl_writeTok(_txt_8, tmp61);
          _txt_8 = tmp62.Tpl_writeTok_rettype_1;
          tmp63 = _Tpl_textString(_txt_8);
          _Tpl_textFile(_txt_7, tmp63.Tpl_textString_rettype_1);
          /* NORETCALL */;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_translateFunctions_rettypeboxed boxptr_SimCodeC_translateFunctions(modelica_metatype _in_txt, modelica_metatype _in_a_functionCode)
{
  SimCodeC_translateFunctions_rettypeboxed tmp1;
  SimCodeC_translateFunctions_rettype tmp2;
  tmp2 = _SimCodeC_translateFunctions(_in_txt, _in_a_functionCode);
  tmp1.SimCodeC_translateFunctions_rettypeboxed_1 = tmp2.SimCodeC_translateFunctions_rettype_1;
  return tmp1;
}
void _Tpl_textFile(modelica_metatype _inText, modelica_string _inFileName)
{
  modelica_complex tmp1;


  { /* matchcontinue expression */
    modelica_metatype tmp2_in0;
    modelica_string tmp2_in1;
    tmp2_in0 = _inText;
    tmp2_in1 = _inFileName;
    {
      modelica_metatype _txt;
      modelica_string _file;
      modelica_string _str;
      modelica_real _rtTickTxt;
      modelica_real _rtTickW;
      int tmp3;
      int tmp4;
      for (tmp3 = 0, tmp4 = 0; tmp3 < 2 && !tmp4; tmp3++) {
        MMC_TRY()
        switch (tmp3) {
        case 0: {
          System_realtimeTock_rettype tmp5;
          System_realtimeTock_rettype tmp6;
          modelica_string tmp7;
          modelica_string tmp8;
          realString_rettype tmp9;
          modelica_string tmp10;
          modelica_string tmp11;
          System_realtimeTock_rettype tmp12;
          realString_rettype tmp13;
          modelica_string tmp14;
          
          /* Pattern matching succeeded */
          _txt = tmp2_in0;
          _file = tmp2_in1;
          tmp5 = _System_realtimeTock(10);
          _rtTickTxt = tmp5.System_realtimeTock_rettype_1;
          _Print_clearBuf();
          /* NORETCALL */;
          _Tpl_textStringBuf(_txt);
          /* NORETCALL */;
          tmp6 = _System_realtimeTock(10);
          _rtTickW = tmp6.System_realtimeTock_rettype_1;
          _Print_writeBuf(_file);
          /* NORETCALL */;
          _Print_clearBuf();
          /* NORETCALL */;
          tmp7 = stringAppend("textFile ",_file);
          tmp8 = stringAppend(tmp7,"\n    text:");
          tmp9 = realString((_rtTickW - _rtTickTxt));
          tmp10 = stringAppend(tmp8,tmp9);
          tmp11 = stringAppend(tmp10,"\n   write:");
          tmp12 = _System_realtimeTock(10);
          tmp13 = realString((tmp12.System_realtimeTock_rettype_1 - _rtTickW));
          tmp14 = stringAppend(tmp11,tmp13);
          _Debug_fprintln("perfTimes", tmp14);
          /* NORETCALL */;
          tmp4 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _Debug_fprint("failtrace", "-!!!Tpl.textFile failed - a system error ?\n");
          /* NORETCALL */;
          tmp4 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp4) MMC_THROW();
    }
  }
  
  _return:
  return;
}


void boxptr_Tpl_textFile(modelica_metatype _inText, modelica_metatype _inFileName)
{
  modelica_string tmp1;
  tmp1 = mmc_unbox_string(_inFileName);
  _Tpl_textFile(_inText, tmp1);
  return ;
}
System_realtimeTock_rettype _System_realtimeTock(modelica_integer _clockIndex)
{
  System_realtimeTock_rettype out;
  int _clockIndex_ext;
  double _outTime_ext;
  _clockIndex_ext = (int)_clockIndex;
  _outTime_ext = System_realtimeTock(_clockIndex_ext);
  out.targ1 = (modelica_real)_outTime_ext;
  return out;
}


System_realtimeTock_rettypeboxed boxptr_System_realtimeTock(modelica_metatype _clockIndex)
{
  System_realtimeTock_rettypeboxed tmp1;
  System_realtimeTock_rettype tmp2;
  modelica_integer tmp3;
  modelica_metatype tmp4;
  tmp3 = mmc_unbox_integer(_clockIndex);
  tmp2 = _System_realtimeTock(tmp3);
  tmp4 = mmc_mk_rcon(tmp2.System_realtimeTock_rettype_1);
  tmp1.System_realtimeTock_rettypeboxed_1 = tmp4;
  return tmp1;
}
void _Print_writeBuf(modelica_string _inString)
{
  Print_writeBuf(_inString);
  return ;
}


void boxptr_Print_writeBuf(modelica_metatype _inString)
{
  modelica_string tmp1;
  tmp1 = mmc_unbox_string(_inString);
  _Print_writeBuf(tmp1);
  return ;
}
SimCodeC_functionsMakefile_rettype _SimCodeC_functionsMakefile(modelica_metatype _in_txt, modelica_metatype _in_a_fnCode)
{
  SimCodeC_functionsMakefile_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fnCode;
    {
      modelica_metatype _txt;
      modelica_string _i_name;
      modelica_string _i_makefileParams_senddatalibs;
      modelica_string _i_makefileParams_ldflags;
      modelica_string _i_makefileParams_cflags;
      modelica_string _i_makefileParams_omhome;
      modelica_string _i_makefileParams_dllext;
      modelica_string _i_makefileParams_exeext;
      modelica_string _i_makefileParams_linker;
      modelica_string _i_makefileParams_cxxcompiler;
      modelica_string _i_makefileParams_ccompiler;
      modelica_metatype _i_makefileParams_libs;
      modelica_metatype _l_libsStr;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_string tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_string tmp13;
          modelica_metatype tmp14;
          modelica_string tmp15;
          modelica_metatype tmp16;
          modelica_string tmp17;
          modelica_metatype tmp18;
          modelica_string tmp19;
          modelica_metatype tmp20;
          modelica_string tmp21;
          modelica_metatype tmp22;
          modelica_string tmp23;
          modelica_metatype tmp24;
          modelica_string tmp25;
          modelica_metatype tmp26;
          modelica_string tmp27;
          modelica_metatype tmp28;
          modelica_string tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          Tpl_pushIter_rettype tmp39;
          SimCodeC_lm__257_rettype tmp40;
          Tpl_popIter_rettype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          Tpl_writeTok_rettype tmp44;
          Tpl_writeStr_rettype tmp45;
          Tpl_softNewLine_rettype tmp46;
          modelica_metatype tmp47;
          Tpl_writeTok_rettype tmp48;
          Tpl_writeStr_rettype tmp49;
          Tpl_softNewLine_rettype tmp50;
          modelica_metatype tmp51;
          Tpl_writeTok_rettype tmp52;
          Tpl_writeStr_rettype tmp53;
          Tpl_softNewLine_rettype tmp54;
          modelica_metatype tmp55;
          Tpl_writeTok_rettype tmp56;
          Tpl_writeStr_rettype tmp57;
          Tpl_softNewLine_rettype tmp58;
          modelica_metatype tmp59;
          Tpl_writeTok_rettype tmp60;
          Tpl_writeStr_rettype tmp61;
          Tpl_softNewLine_rettype tmp62;
          modelica_metatype tmp63;
          Tpl_writeTok_rettype tmp64;
          Tpl_writeStr_rettype tmp65;
          modelica_metatype tmp66;
          Tpl_writeTok_rettype tmp67;
          Tpl_writeStr_rettype tmp68;
          Tpl_softNewLine_rettype tmp69;
          modelica_metatype tmp70;
          Tpl_writeTok_rettype tmp71;
          Tpl_writeStr_rettype tmp72;
          modelica_metatype tmp73;
          Tpl_writeTok_rettype tmp74;
          Tpl_writeStr_rettype tmp75;
          Tpl_softNewLine_rettype tmp76;
          modelica_metatype tmp77;
          Tpl_writeTok_rettype tmp78;
          Tpl_writeStr_rettype tmp79;
          Tpl_softNewLine_rettype tmp80;
          modelica_metatype tmp81;
          modelica_metatype tmp82;
          Tpl_writeTok_rettype tmp83;
          Tpl_writeStr_rettype tmp84;
          Tpl_softNewLine_rettype tmp85;
          Tpl_writeStr_rettype tmp86;
          modelica_metatype tmp87;
          Tpl_writeTok_rettype tmp88;
          Tpl_writeStr_rettype tmp89;
          modelica_metatype tmp90;
          Tpl_writeTok_rettype tmp91;
          Tpl_writeStr_rettype tmp92;
          modelica_metatype tmp93;
          Tpl_writeTok_rettype tmp94;
          Tpl_writeStr_rettype tmp95;
          modelica_metatype tmp96;
          Tpl_writeTok_rettype tmp97;
          modelica_metatype tmp98;
          Tpl_writeTok_rettype tmp99;
          modelica_metatype tmp100;
          Tpl_writeTok_rettype tmp101;
          Tpl_writeStr_rettype tmp102;
          modelica_metatype tmp103;
          Tpl_writeTok_rettype tmp104;
          Tpl_writeStr_rettype tmp105;
          modelica_metatype tmp106;
          Tpl_writeTok_rettype tmp107;
          Tpl_writeText_rettype tmp108;
          modelica_metatype tmp109;
          Tpl_writeTok_rettype tmp110;
          Tpl_writeStr_rettype tmp111;
          modelica_metatype tmp112;
          Tpl_writeTok_rettype tmp113;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,6) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = mmc_unbox_string(tmp6);
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          if (mmc__uniontype__metarecord__typedef__equal(tmp11,0,10) == 0) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 2));
          tmp13 = mmc_unbox_string(tmp12);
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 3));
          tmp15 = mmc_unbox_string(tmp14);
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 4));
          tmp17 = mmc_unbox_string(tmp16);
          tmp18 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 5));
          tmp19 = mmc_unbox_string(tmp18);
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 6));
          tmp21 = mmc_unbox_string(tmp20);
          tmp22 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 7));
          tmp23 = mmc_unbox_string(tmp22);
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 8));
          tmp25 = mmc_unbox_string(tmp24);
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 9));
          tmp27 = mmc_unbox_string(tmp26);
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 10));
          tmp29 = mmc_unbox_string(tmp28);
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp11), 11));
          tmp31 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp7;
          _i_makefileParams_ccompiler = tmp13;
          _i_makefileParams_cxxcompiler = tmp15;
          _i_makefileParams_linker = tmp17;
          _i_makefileParams_exeext = tmp19;
          _i_makefileParams_dllext = tmp21;
          _i_makefileParams_omhome = tmp23;
          _i_makefileParams_cflags = tmp25;
          _i_makefileParams_ldflags = tmp27;
          _i_makefileParams_senddatalibs = tmp29;
          _i_makefileParams_libs = tmp30;
          tmp32 = mmc_mk_nil();
          tmp33 = mmc_mk_nil();
          tmp34 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp32, tmp33);
          tmp35 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp36 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp37 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp38 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp35), mmc_mk_integer(0), mmc_mk_integer(0), tmp36, mmc_mk_integer(0), tmp37);
          tmp39 = _Tpl_pushIter(tmp34, tmp38);
          _l_libsStr = tmp39.Tpl_pushIter_rettype_1;
          tmp40 = _SimCodeC_lm__257(_l_libsStr, _i_makefileParams_libs);
          _l_libsStr = tmp40.SimCodeC_lm__257_rettype_1;
          tmp41 = _Tpl_popIter(_l_libsStr);
          _l_libsStr = tmp41.Tpl_popIter_rettype_1;
          tmp42 = mmc_mk_cons(mmc_mk_scon("# Makefile generated by OpenModelica\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_cons(mmc_mk_scon("CC="), mmc_mk_nil())));
          tmp43 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp42, mmc_mk_boolean((0)));
          tmp44 = _Tpl_writeTok(_txt, tmp43);
          _txt = tmp44.Tpl_writeTok_rettype_1;
          tmp45 = _Tpl_writeStr(_txt, _i_makefileParams_ccompiler);
          _txt = tmp45.Tpl_writeStr_rettype_1;
          tmp46 = _Tpl_softNewLine(_txt);
          _txt = tmp46.Tpl_softNewLine_rettype_1;
          tmp47 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("CXX="));
          tmp48 = _Tpl_writeTok(_txt, tmp47);
          _txt = tmp48.Tpl_writeTok_rettype_1;
          tmp49 = _Tpl_writeStr(_txt, _i_makefileParams_cxxcompiler);
          _txt = tmp49.Tpl_writeStr_rettype_1;
          tmp50 = _Tpl_softNewLine(_txt);
          _txt = tmp50.Tpl_softNewLine_rettype_1;
          tmp51 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("LINK="));
          tmp52 = _Tpl_writeTok(_txt, tmp51);
          _txt = tmp52.Tpl_writeTok_rettype_1;
          tmp53 = _Tpl_writeStr(_txt, _i_makefileParams_linker);
          _txt = tmp53.Tpl_writeStr_rettype_1;
          tmp54 = _Tpl_softNewLine(_txt);
          _txt = tmp54.Tpl_softNewLine_rettype_1;
          tmp55 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("EXEEXT="));
          tmp56 = _Tpl_writeTok(_txt, tmp55);
          _txt = tmp56.Tpl_writeTok_rettype_1;
          tmp57 = _Tpl_writeStr(_txt, _i_makefileParams_exeext);
          _txt = tmp57.Tpl_writeStr_rettype_1;
          tmp58 = _Tpl_softNewLine(_txt);
          _txt = tmp58.Tpl_softNewLine_rettype_1;
          tmp59 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("DLLEXT="));
          tmp60 = _Tpl_writeTok(_txt, tmp59);
          _txt = tmp60.Tpl_writeTok_rettype_1;
          tmp61 = _Tpl_writeStr(_txt, _i_makefileParams_dllext);
          _txt = tmp61.Tpl_writeStr_rettype_1;
          tmp62 = _Tpl_softNewLine(_txt);
          _txt = tmp62.Tpl_softNewLine_rettype_1;
          tmp63 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("CFLAGS= -I\""));
          tmp64 = _Tpl_writeTok(_txt, tmp63);
          _txt = tmp64.Tpl_writeTok_rettype_1;
          tmp65 = _Tpl_writeStr(_txt, _i_makefileParams_omhome);
          _txt = tmp65.Tpl_writeStr_rettype_1;
          tmp66 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("/include/omc\" "));
          tmp67 = _Tpl_writeTok(_txt, tmp66);
          _txt = tmp67.Tpl_writeTok_rettype_1;
          tmp68 = _Tpl_writeStr(_txt, _i_makefileParams_cflags);
          _txt = tmp68.Tpl_writeStr_rettype_1;
          tmp69 = _Tpl_softNewLine(_txt);
          _txt = tmp69.Tpl_softNewLine_rettype_1;
          tmp70 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("LDFLAGS= -L\""));
          tmp71 = _Tpl_writeTok(_txt, tmp70);
          _txt = tmp71.Tpl_writeTok_rettype_1;
          tmp72 = _Tpl_writeStr(_txt, _i_makefileParams_omhome);
          _txt = tmp72.Tpl_writeStr_rettype_1;
          tmp73 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("/lib/omc\" "));
          tmp74 = _Tpl_writeTok(_txt, tmp73);
          _txt = tmp74.Tpl_writeTok_rettype_1;
          tmp75 = _Tpl_writeStr(_txt, _i_makefileParams_ldflags);
          _txt = tmp75.Tpl_writeStr_rettype_1;
          tmp76 = _Tpl_softNewLine(_txt);
          _txt = tmp76.Tpl_softNewLine_rettype_1;
          tmp77 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("SENDDATALIBS="));
          tmp78 = _Tpl_writeTok(_txt, tmp77);
          _txt = tmp78.Tpl_writeTok_rettype_1;
          tmp79 = _Tpl_writeStr(_txt, _i_makefileParams_senddatalibs);
          _txt = tmp79.Tpl_writeStr_rettype_1;
          tmp80 = _Tpl_softNewLine(_txt);
          _txt = tmp80.Tpl_softNewLine_rettype_1;
          tmp81 = mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_cons(mmc_mk_scon(".PHONY: "), mmc_mk_nil()));
          tmp82 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp81, mmc_mk_boolean((0)));
          tmp83 = _Tpl_writeTok(_txt, tmp82);
          _txt = tmp83.Tpl_writeTok_rettype_1;
          tmp84 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp84.Tpl_writeStr_rettype_1;
          tmp85 = _Tpl_softNewLine(_txt);
          _txt = tmp85.Tpl_softNewLine_rettype_1;
          tmp86 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp86.Tpl_writeStr_rettype_1;
          tmp87 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(": "));
          tmp88 = _Tpl_writeTok(_txt, tmp87);
          _txt = tmp88.Tpl_writeTok_rettype_1;
          tmp89 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp89.Tpl_writeStr_rettype_1;
          tmp90 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".c "));
          tmp91 = _Tpl_writeTok(_txt, tmp90);
          _txt = tmp91.Tpl_writeTok_rettype_1;
          tmp92 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp92.Tpl_writeStr_rettype_1;
          tmp93 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".h "));
          tmp94 = _Tpl_writeTok(_txt, tmp93);
          _txt = tmp94.Tpl_writeTok_rettype_1;
          tmp95 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp95.Tpl_writeStr_rettype_1;
          tmp96 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("_records.c\n"));
          tmp97 = _Tpl_writeTok(_txt, tmp96);
          _txt = tmp97.Tpl_writeTok_rettype_1;
          tmp98 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\t"));
          tmp99 = _Tpl_writeTok(_txt, tmp98);
          _txt = tmp99.Tpl_writeTok_rettype_1;
          tmp100 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" $(LINK) -o "));
          tmp101 = _Tpl_writeTok(_txt, tmp100);
          _txt = tmp101.Tpl_writeTok_rettype_1;
          tmp102 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp102.Tpl_writeStr_rettype_1;
          tmp103 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("$(DLLEXT) "));
          tmp104 = _Tpl_writeTok(_txt, tmp103);
          _txt = tmp104.Tpl_writeTok_rettype_1;
          tmp105 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp105.Tpl_writeStr_rettype_1;
          tmp106 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".c "));
          tmp107 = _Tpl_writeTok(_txt, tmp106);
          _txt = tmp107.Tpl_writeTok_rettype_1;
          tmp108 = _Tpl_writeText(_txt, _l_libsStr);
          _txt = tmp108.Tpl_writeText_rettype_1;
          tmp109 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" $(CFLAGS) $(LDFLAGS) $(SENDDATALIBS) -lm "));
          tmp110 = _Tpl_writeTok(_txt, tmp109);
          _txt = tmp110.Tpl_writeTok_rettype_1;
          tmp111 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp111.Tpl_writeStr_rettype_1;
          tmp112 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_records.c"));
          tmp113 = _Tpl_writeTok(_txt, tmp112);
          _txt = tmp113.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionsMakefile_rettypeboxed boxptr_SimCodeC_functionsMakefile(modelica_metatype _in_txt, modelica_metatype _in_a_fnCode)
{
  SimCodeC_functionsMakefile_rettypeboxed tmp1;
  SimCodeC_functionsMakefile_rettype tmp2;
  tmp2 = _SimCodeC_functionsMakefile(_in_txt, _in_a_fnCode);
  tmp1.SimCodeC_functionsMakefile_rettypeboxed_1 = tmp2.SimCodeC_functionsMakefile_rettype_1;
  return tmp1;
}
SimCodeC_lm__257_rettype _SimCodeC_lm__257(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__257_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_string _i_it;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_string tmp8;
          Tpl_writeStr_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__257_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          tmp8 = mmc_unbox_string(tmp6);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_it = tmp8;
          _rest = tmp7;
          tmp9 = _Tpl_writeStr(_txt, _i_it);
          _txt = tmp9.Tpl_writeStr_rettype_1;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__257(_txt, _rest);
          _txt = tmp11.SimCodeC_lm__257_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__257_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          tmp14 = _SimCodeC_lm__257(_txt, _rest);
          _txt = tmp14.SimCodeC_lm__257_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__257_rettypeboxed boxptr_SimCodeC_lm__257(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__257_rettypeboxed tmp1;
  SimCodeC_lm__257_rettype tmp2;
  tmp2 = _SimCodeC_lm__257(_in_txt, _in_items);
  tmp1.SimCodeC_lm__257_rettypeboxed_1 = tmp2.SimCodeC_lm__257_rettype_1;
  return tmp1;
}
SimCodeC_recordsFile_rettype _SimCodeC_recordsFile(modelica_metatype _txt, modelica_string _a_filePrefix, modelica_metatype _a_recordDecls)
{
  SimCodeC_recordsFile_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_string _ret_0;
  modelica_metatype tmp2;
  Tpl_writeTok_rettype tmp3;
  Tpl_writeStr_rettype tmp4;
  modelica_metatype tmp5;
  Tpl_writeTok_rettype tmp6;
  Settings_getVersionNr_rettype tmp7;
  Tpl_writeStr_rettype tmp8;
  modelica_metatype tmp9;
  modelica_metatype tmp10;
  Tpl_writeTok_rettype tmp11;
  modelica_metatype tmp12;
  modelica_metatype tmp13;
  modelica_metatype tmp14;
  modelica_metatype tmp15;
  Tpl_pushIter_rettype tmp16;
  SimCodeC_lm__238_rettype tmp17;
  Tpl_popIter_rettype tmp18;
  Tpl_softNewLine_rettype tmp19;
  modelica_metatype tmp20;
  Tpl_writeTok_rettype tmp21;


  tmp2 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("/* Additional record code for "));
  tmp3 = _Tpl_writeTok(_txt, tmp2);
  _out_txt = tmp3.Tpl_writeTok_rettype_1;
  tmp4 = _Tpl_writeStr(_out_txt, _a_filePrefix);
  _out_txt = tmp4.Tpl_writeStr_rettype_1;
  tmp5 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" generated by the OpenModelica Compiler "));
  tmp6 = _Tpl_writeTok(_out_txt, tmp5);
  _out_txt = tmp6.Tpl_writeTok_rettype_1;
  tmp7 = _Settings_getVersionNr();
  _ret_0 = tmp7.Settings_getVersionNr_rettype_1;
  tmp8 = _Tpl_writeStr(_out_txt, _ret_0);
  _out_txt = tmp8.Tpl_writeStr_rettype_1;
  tmp9 = mmc_mk_cons(mmc_mk_scon(". */\n"), mmc_mk_cons(mmc_mk_scon("#include \"meta_modelica.h\"\n"), mmc_mk_nil()));
  tmp10 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp9, mmc_mk_boolean((1)));
  tmp11 = _Tpl_writeTok(_out_txt, tmp10);
  _out_txt = tmp11.Tpl_writeTok_rettype_1;
  tmp12 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp13 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp14 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp15 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp12), mmc_mk_integer(0), mmc_mk_integer(0), tmp13, mmc_mk_integer(0), tmp14);
  tmp16 = _Tpl_pushIter(_out_txt, tmp15);
  _out_txt = tmp16.Tpl_pushIter_rettype_1;
  tmp17 = _SimCodeC_lm__238(_out_txt, _a_recordDecls);
  _out_txt = tmp17.SimCodeC_lm__238_rettype_1;
  tmp18 = _Tpl_popIter(_out_txt);
  _out_txt = tmp18.Tpl_popIter_rettype_1;
  tmp19 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp19.Tpl_softNewLine_rettype_1;
  tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp21 = _Tpl_writeTok(_out_txt, tmp20);
  _out_txt = tmp21.Tpl_writeTok_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_recordsFile_rettypeboxed boxptr_SimCodeC_recordsFile(modelica_metatype _txt, modelica_metatype _a_filePrefix, modelica_metatype _a_recordDecls)
{
  SimCodeC_recordsFile_rettypeboxed tmp1;
  SimCodeC_recordsFile_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_a_filePrefix);
  tmp2 = _SimCodeC_recordsFile(_txt, tmp3, _a_recordDecls);
  tmp1.SimCodeC_recordsFile_rettypeboxed_1 = tmp2.SimCodeC_recordsFile_rettype_1;
  return tmp1;
}
SimCodeC_lm__238_rettype _SimCodeC_lm__238(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__238_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_rd;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_recordDeclaration_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__238_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_rd = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_recordDeclaration(_txt, _i_rd);
          _txt = tmp8.SimCodeC_recordDeclaration_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__238(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__238_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__238_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__238(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__238_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__238_rettypeboxed boxptr_SimCodeC_lm__238(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__238_rettypeboxed tmp1;
  SimCodeC_lm__238_rettype tmp2;
  tmp2 = _SimCodeC_lm__238(_in_txt, _in_items);
  tmp1.SimCodeC_lm__238_rettypeboxed_1 = tmp2.SimCodeC_lm__238_rettype_1;
  return tmp1;
}
SimCodeC_recordDeclaration_rettype _SimCodeC_recordDeclaration(modelica_metatype _in_txt, modelica_metatype _in_a_recDecl)
{
  SimCodeC_recordDeclaration_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_recDecl;
    {
      modelica_metatype _txt;
      modelica_metatype _i_fieldNames;
      modelica_metatype _i_path;
      modelica_metatype _i_variables;
      modelica_metatype _i_defPath;
      modelica_integer _ret_7;
      modelica_metatype _txt_6;
      modelica_metatype _txt_5;
      modelica_metatype _txt_4;
      modelica_integer _ret_3;
      modelica_metatype _txt_2;
      modelica_metatype _txt_1;
      modelica_metatype _txt_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_dotPath_rettype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          SimCodeC_underscorePath_rettype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          Tpl_pushIter_rettype tmp24;
          SimCodeC_lm__299_rettype tmp25;
          Tpl_popIter_rettype tmp26;
          listLength_rettype tmp27;
          Tpl_textString_rettype tmp28;
          Tpl_textString_rettype tmp29;
          Tpl_textString_rettype tmp30;
          SimCodeC_recordDefinition_rettype tmp31;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,3) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_defPath = tmp7;
          _i_variables = tmp8;
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp9, tmp10);
          tmp12 = _SimCodeC_dotPath(tmp11, _i_defPath);
          _txt_0 = tmp12.SimCodeC_dotPath_rettype_1;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = _SimCodeC_underscorePath(tmp15, _i_defPath);
          _txt_1 = tmp16.SimCodeC_underscorePath_rettype_1;
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_nil();
          tmp19 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp17, tmp18);
          tmp20 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(","));
          tmp21 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp22 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp23 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp20), mmc_mk_integer(0), mmc_mk_integer(0), tmp21, mmc_mk_integer(0), tmp22);
          tmp24 = _Tpl_pushIter(tmp19, tmp23);
          _txt_2 = tmp24.Tpl_pushIter_rettype_1;
          tmp25 = _SimCodeC_lm__299(_txt_2, _i_variables);
          _txt_2 = tmp25.SimCodeC_lm__299_rettype_1;
          tmp26 = _Tpl_popIter(_txt_2);
          _txt_2 = tmp26.Tpl_popIter_rettype_1;
          tmp27 = listLength(_i_variables);
          _ret_3 = tmp27;
          tmp28 = _Tpl_textString(_txt_0);
          tmp29 = _Tpl_textString(_txt_1);
          tmp30 = _Tpl_textString(_txt_2);
          tmp31 = _SimCodeC_recordDefinition(_txt, tmp28.Tpl_textString_rettype_1, tmp29.Tpl_textString_rettype_1, tmp30.Tpl_textString_rettype_1, (modelica_integer)_ret_3);
          _txt = tmp31.SimCodeC_recordDefinition_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          SimCodeC_dotPath_rettype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          SimCodeC_underscorePath_rettype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          Tpl_pushIter_rettype tmp49;
          SimCodeC_lm__300_rettype tmp50;
          Tpl_popIter_rettype tmp51;
          listLength_rettype tmp52;
          Tpl_textString_rettype tmp53;
          Tpl_textString_rettype tmp54;
          Tpl_textString_rettype tmp55;
          SimCodeC_recordDefinition_rettype tmp56;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,2) == 0) MMC_THROW();
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_path = tmp32;
          _i_fieldNames = tmp33;
          tmp34 = mmc_mk_nil();
          tmp35 = mmc_mk_nil();
          tmp36 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp34, tmp35);
          tmp37 = _SimCodeC_dotPath(tmp36, _i_path);
          _txt_4 = tmp37.SimCodeC_dotPath_rettype_1;
          tmp38 = mmc_mk_nil();
          tmp39 = mmc_mk_nil();
          tmp40 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp38, tmp39);
          tmp41 = _SimCodeC_underscorePath(tmp40, _i_path);
          _txt_5 = tmp41.SimCodeC_underscorePath_rettype_1;
          tmp42 = mmc_mk_nil();
          tmp43 = mmc_mk_nil();
          tmp44 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp42, tmp43);
          tmp45 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(","));
          tmp46 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp47 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp48 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp45), mmc_mk_integer(0), mmc_mk_integer(0), tmp46, mmc_mk_integer(0), tmp47);
          tmp49 = _Tpl_pushIter(tmp44, tmp48);
          _txt_6 = tmp49.Tpl_pushIter_rettype_1;
          tmp50 = _SimCodeC_lm__300(_txt_6, _i_fieldNames);
          _txt_6 = tmp50.SimCodeC_lm__300_rettype_1;
          tmp51 = _Tpl_popIter(_txt_6);
          _txt_6 = tmp51.Tpl_popIter_rettype_1;
          tmp52 = listLength(_i_fieldNames);
          _ret_7 = tmp52;
          tmp53 = _Tpl_textString(_txt_4);
          tmp54 = _Tpl_textString(_txt_5);
          tmp55 = _Tpl_textString(_txt_6);
          tmp56 = _SimCodeC_recordDefinition(_txt, tmp53.Tpl_textString_rettype_1, tmp54.Tpl_textString_rettype_1, tmp55.Tpl_textString_rettype_1, (modelica_integer)_ret_7);
          _txt = tmp56.SimCodeC_recordDefinition_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_recordDeclaration_rettypeboxed boxptr_SimCodeC_recordDeclaration(modelica_metatype _in_txt, modelica_metatype _in_a_recDecl)
{
  SimCodeC_recordDeclaration_rettypeboxed tmp1;
  SimCodeC_recordDeclaration_rettype tmp2;
  tmp2 = _SimCodeC_recordDeclaration(_in_txt, _in_a_recDecl);
  tmp1.SimCodeC_recordDeclaration_rettypeboxed_1 = tmp2.SimCodeC_recordDeclaration_rettype_1;
  return tmp1;
}
SimCodeC_recordDefinition_rettype _SimCodeC_recordDefinition(modelica_metatype _txt, modelica_string _a_origName, modelica_string _a_encName, modelica_string _a_fieldNames, modelica_integer _a_numFields)
{
  SimCodeC_recordDefinition_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;
  Tpl_writeTok_rettype tmp3;
  Tpl_writeStr_rettype tmp4;
  modelica_metatype tmp5;
  modelica_metatype tmp6;
  Tpl_writeTok_rettype tmp7;
  Tpl_writeStr_rettype tmp8;
  modelica_metatype tmp9;
  Tpl_writeTok_rettype tmp10;
  intString_rettype tmp11;
  Tpl_writeStr_rettype tmp12;
  modelica_metatype tmp13;
  Tpl_writeTok_rettype tmp14;
  Tpl_writeStr_rettype tmp15;
  modelica_metatype tmp16;
  modelica_metatype tmp17;
  Tpl_writeTok_rettype tmp18;
  Tpl_writeStr_rettype tmp19;
  modelica_metatype tmp20;
  Tpl_writeTok_rettype tmp21;
  modelica_metatype tmp22;
  Tpl_pushBlock_rettype tmp23;
  modelica_metatype tmp24;
  Tpl_writeTok_rettype tmp25;
  Tpl_writeStr_rettype tmp26;
  modelica_metatype tmp27;
  modelica_metatype tmp28;
  Tpl_writeTok_rettype tmp29;
  Tpl_writeStr_rettype tmp30;
  modelica_metatype tmp31;
  Tpl_writeTok_rettype tmp32;
  Tpl_writeStr_rettype tmp33;
  modelica_metatype tmp34;
  Tpl_writeTok_rettype tmp35;
  Tpl_popBlock_rettype tmp36;
  modelica_metatype tmp37;
  Tpl_writeTok_rettype tmp38;


  tmp2 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#define "));
  tmp3 = _Tpl_writeTok(_txt, tmp2);
  _out_txt = tmp3.Tpl_writeTok_rettype_1;
  tmp4 = _Tpl_writeStr(_out_txt, _a_encName);
  _out_txt = tmp4.Tpl_writeStr_rettype_1;
  tmp5 = mmc_mk_cons(mmc_mk_scon("__desc_added 1\n"), mmc_mk_cons(mmc_mk_scon("const char* "), mmc_mk_nil()));
  tmp6 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp5, mmc_mk_boolean((0)));
  tmp7 = _Tpl_writeTok(_out_txt, tmp6);
  _out_txt = tmp7.Tpl_writeTok_rettype_1;
  tmp8 = _Tpl_writeStr(_out_txt, _a_encName);
  _out_txt = tmp8.Tpl_writeStr_rettype_1;
  tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("__desc__fields["));
  tmp10 = _Tpl_writeTok(_out_txt, tmp9);
  _out_txt = tmp10.Tpl_writeTok_rettype_1;
  tmp11 = intString((modelica_integer)_a_numFields);
  tmp12 = _Tpl_writeStr(_out_txt, tmp11);
  _out_txt = tmp12.Tpl_writeStr_rettype_1;
  tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("] = {"));
  tmp14 = _Tpl_writeTok(_out_txt, tmp13);
  _out_txt = tmp14.Tpl_writeTok_rettype_1;
  tmp15 = _Tpl_writeStr(_out_txt, _a_fieldNames);
  _out_txt = tmp15.Tpl_writeStr_rettype_1;
  tmp16 = mmc_mk_cons(mmc_mk_scon("};\n"), mmc_mk_cons(mmc_mk_scon("struct record_description "), mmc_mk_nil()));
  tmp17 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp16, mmc_mk_boolean((0)));
  tmp18 = _Tpl_writeTok(_out_txt, tmp17);
  _out_txt = tmp18.Tpl_writeTok_rettype_1;
  tmp19 = _Tpl_writeStr(_out_txt, _a_encName);
  _out_txt = tmp19.Tpl_writeStr_rettype_1;
  tmp20 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("__desc = {\n"));
  tmp21 = _Tpl_writeTok(_out_txt, tmp20);
  _out_txt = tmp21.Tpl_writeTok_rettype_1;
  tmp22 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
  tmp23 = _Tpl_pushBlock(_out_txt, tmp22);
  _out_txt = tmp23.Tpl_pushBlock_rettype_1;
  tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
  tmp25 = _Tpl_writeTok(_out_txt, tmp24);
  _out_txt = tmp25.Tpl_writeTok_rettype_1;
  tmp26 = _Tpl_writeStr(_out_txt, _a_encName);
  _out_txt = tmp26.Tpl_writeStr_rettype_1;
  tmp27 = mmc_mk_cons(mmc_mk_scon("\", /* package_record__X */\n"), mmc_mk_cons(mmc_mk_scon("\""), mmc_mk_nil()));
  tmp28 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp27, mmc_mk_boolean((0)));
  tmp29 = _Tpl_writeTok(_out_txt, tmp28);
  _out_txt = tmp29.Tpl_writeTok_rettype_1;
  tmp30 = _Tpl_writeStr(_out_txt, _a_origName);
  _out_txt = tmp30.Tpl_writeStr_rettype_1;
  tmp31 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("\", /* package.record_X */\n"));
  tmp32 = _Tpl_writeTok(_out_txt, tmp31);
  _out_txt = tmp32.Tpl_writeTok_rettype_1;
  tmp33 = _Tpl_writeStr(_out_txt, _a_encName);
  _out_txt = tmp33.Tpl_writeStr_rettype_1;
  tmp34 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("__desc__fields\n"));
  tmp35 = _Tpl_writeTok(_out_txt, tmp34);
  _out_txt = tmp35.Tpl_writeTok_rettype_1;
  tmp36 = _Tpl_popBlock(_out_txt);
  _out_txt = tmp36.Tpl_popBlock_rettype_1;
  tmp37 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("};"));
  tmp38 = _Tpl_writeTok(_out_txt, tmp37);
  _out_txt = tmp38.Tpl_writeTok_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_recordDefinition_rettypeboxed boxptr_SimCodeC_recordDefinition(modelica_metatype _txt, modelica_metatype _a_origName, modelica_metatype _a_encName, modelica_metatype _a_fieldNames, modelica_metatype _a_numFields)
{
  SimCodeC_recordDefinition_rettypeboxed tmp1;
  SimCodeC_recordDefinition_rettype tmp2;
  modelica_string tmp3;
  modelica_string tmp4;
  modelica_string tmp5;
  modelica_integer tmp6;
  tmp3 = mmc_unbox_string(_a_origName);
  tmp4 = mmc_unbox_string(_a_encName);
  tmp5 = mmc_unbox_string(_a_fieldNames);
  tmp6 = mmc_unbox_integer(_a_numFields);
  tmp2 = _SimCodeC_recordDefinition(_txt, tmp3, tmp4, tmp5, tmp6);
  tmp1.SimCodeC_recordDefinition_rettypeboxed_1 = tmp2.SimCodeC_recordDefinition_rettype_1;
  return tmp1;
}
SimCodeC_lm__300_rettype _SimCodeC_lm__300(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__300_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_string _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_string tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          Tpl_writeStr_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          Tpl_nextIter_rettype tmp14;
          SimCodeC_lm__300_rettype tmp15;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          tmp8 = mmc_unbox_string(tmp6);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _rest = tmp7;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp11 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp11.Tpl_writeStr_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp14 = _Tpl_nextIter(_txt);
          _txt = tmp14.Tpl_nextIter_rettype_1;
          tmp15 = _SimCodeC_lm__300(_txt, _rest);
          _txt = tmp15.SimCodeC_lm__300_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          SimCodeC_lm__300_rettype tmp18;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp16 = MMC_CAR(tmp3_in1);
          tmp17 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp17;
          tmp18 = _SimCodeC_lm__300(_txt, _rest);
          _txt = tmp18.SimCodeC_lm__300_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__300_rettypeboxed boxptr_SimCodeC_lm__300(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__300_rettypeboxed tmp1;
  SimCodeC_lm__300_rettype tmp2;
  tmp2 = _SimCodeC_lm__300(_in_txt, _in_items);
  tmp1.SimCodeC_lm__300_rettypeboxed_1 = tmp2.SimCodeC_lm__300_rettype_1;
  return tmp1;
}
SimCodeC_lm__299_rettype _SimCodeC_lm__299(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__299_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          SimCodeC_crefStr_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          Tpl_nextIter_rettype tmp17;
          SimCodeC_lm__299_rettype tmp18;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _rest = tmp7;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp14 = _SimCodeC_crefStr(_txt, _i_name);
          _txt = tmp14.SimCodeC_crefStr_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
          tmp16 = _Tpl_writeTok(_txt, tmp15);
          _txt = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = _Tpl_nextIter(_txt);
          _txt = tmp17.Tpl_nextIter_rettype_1;
          tmp18 = _SimCodeC_lm__299(_txt, _rest);
          _txt = tmp18.SimCodeC_lm__299_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          SimCodeC_lm__299_rettype tmp21;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp19 = MMC_CAR(tmp3_in1);
          tmp20 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp20;
          tmp21 = _SimCodeC_lm__299(_txt, _rest);
          _txt = tmp21.SimCodeC_lm__299_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__299_rettypeboxed boxptr_SimCodeC_lm__299(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__299_rettypeboxed tmp1;
  SimCodeC_lm__299_rettype tmp2;
  tmp2 = _SimCodeC_lm__299(_in_txt, _in_items);
  tmp1.SimCodeC_lm__299_rettypeboxed_1 = tmp2.SimCodeC_lm__299_rettype_1;
  return tmp1;
}
Settings_getVersionNr_rettype _Settings_getVersionNr()
{
  Settings_getVersionNr_rettype out;
  const char* _outString_ext;
  _outString_ext = Settings_getVersionNr();
  out.targ1 = (modelica_string)_outString_ext;
  return out;
}


Settings_getVersionNr_rettypeboxed boxptr_Settings_getVersionNr()
{
  Settings_getVersionNr_rettypeboxed tmp1;
  Settings_getVersionNr_rettype tmp2;
  modelica_metatype tmp3;
  tmp2 = _Settings_getVersionNr();
  tmp3 = mmc_mk_scon(tmp2.Settings_getVersionNr_rettype_1);
  tmp1.Settings_getVersionNr_rettypeboxed_1 = tmp3;
  return tmp1;
}
SimCodeC_functionsFile_rettype _SimCodeC_functionsFile(modelica_metatype _txt, modelica_string _a_filePrefix, modelica_metatype _a_mainFunction, modelica_metatype _a_functions)
{
  SimCodeC_functionsFile_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;
  Tpl_writeTok_rettype tmp3;
  Tpl_writeStr_rettype tmp4;
  modelica_metatype tmp5;
  modelica_metatype tmp6;
  Tpl_writeTok_rettype tmp7;
  SimCodeC_functionBody_rettype tmp8;
  Tpl_softNewLine_rettype tmp9;
  SimCodeC_functionBodies_rettype tmp10;
  Tpl_softNewLine_rettype tmp11;
  modelica_metatype tmp12;
  modelica_metatype tmp13;
  Tpl_writeTok_rettype tmp14;


  tmp2 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#include \""));
  tmp3 = _Tpl_writeTok(_txt, tmp2);
  _out_txt = tmp3.Tpl_writeTok_rettype_1;
  tmp4 = _Tpl_writeStr(_out_txt, _a_filePrefix);
  _out_txt = tmp4.Tpl_writeStr_rettype_1;
  tmp5 = mmc_mk_cons(mmc_mk_scon(".h\"\n"), mmc_mk_cons(mmc_mk_scon("#include <algorithm>\n"), mmc_mk_cons(mmc_mk_scon("#define MODELICA_ASSERT(msg) { fprintf(stderr,\"Modelica Assert: %s!\\n\", msg); }\n"), mmc_mk_cons(mmc_mk_scon("#define MODELICA_TERMINATE(msg) { fprintf(stderr,\"Modelica Terminate: %s!\\n\", msg); fflush(stderr); }\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_cons(mmc_mk_scon("extern \"C\" {\n"), mmc_mk_nil()))))));
  tmp6 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp5, mmc_mk_boolean((1)));
  tmp7 = _Tpl_writeTok(_out_txt, tmp6);
  _out_txt = tmp7.Tpl_writeTok_rettype_1;
  tmp8 = _SimCodeC_functionBody(_out_txt, _a_mainFunction, (1));
  _out_txt = tmp8.SimCodeC_functionBody_rettype_1;
  tmp9 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp9.Tpl_softNewLine_rettype_1;
  tmp10 = _SimCodeC_functionBodies(_out_txt, _a_functions);
  _out_txt = tmp10.SimCodeC_functionBodies_rettype_1;
  tmp11 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp11.Tpl_softNewLine_rettype_1;
  tmp12 = mmc_mk_cons(mmc_mk_scon("}\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()));
  tmp13 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp12, mmc_mk_boolean((1)));
  tmp14 = _Tpl_writeTok(_out_txt, tmp13);
  _out_txt = tmp14.Tpl_writeTok_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionsFile_rettypeboxed boxptr_SimCodeC_functionsFile(modelica_metatype _txt, modelica_metatype _a_filePrefix, modelica_metatype _a_mainFunction, modelica_metatype _a_functions)
{
  SimCodeC_functionsFile_rettypeboxed tmp1;
  SimCodeC_functionsFile_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_a_filePrefix);
  tmp2 = _SimCodeC_functionsFile(_txt, tmp3, _a_mainFunction, _a_functions);
  tmp1.SimCodeC_functionsFile_rettypeboxed_1 = tmp2.SimCodeC_functionsFile_rettype_1;
  return tmp1;
}
SimCodeC_functionBodies_rettype _SimCodeC_functionBodies(modelica_metatype _txt, modelica_metatype _a_functions)
{
  SimCodeC_functionBodies_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  modelica_metatype tmp5;
  Tpl_pushIter_rettype tmp6;
  SimCodeC_lm__342_rettype tmp7;
  Tpl_popIter_rettype tmp8;


  tmp2 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp3 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp4 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp5 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp2), mmc_mk_integer(0), mmc_mk_integer(0), tmp3, mmc_mk_integer(0), tmp4);
  tmp6 = _Tpl_pushIter(_txt, tmp5);
  _out_txt = tmp6.Tpl_pushIter_rettype_1;
  tmp7 = _SimCodeC_lm__342(_out_txt, _a_functions);
  _out_txt = tmp7.SimCodeC_lm__342_rettype_1;
  tmp8 = _Tpl_popIter(_out_txt);
  _out_txt = tmp8.Tpl_popIter_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionBodies_rettypeboxed boxptr_SimCodeC_functionBodies(modelica_metatype _txt, modelica_metatype _a_functions)
{
  SimCodeC_functionBodies_rettypeboxed tmp1;
  SimCodeC_functionBodies_rettype tmp2;
  tmp2 = _SimCodeC_functionBodies(_txt, _a_functions);
  tmp1.SimCodeC_functionBodies_rettypeboxed_1 = tmp2.SimCodeC_functionBodies_rettype_1;
  return tmp1;
}
SimCodeC_lm__342_rettype _SimCodeC_lm__342(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__342_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_fn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_functionBody_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__342_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_functionBody(_txt, _i_fn, (0));
          _txt = tmp8.SimCodeC_functionBody_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__342(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__342_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__342_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__342(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__342_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__342_rettypeboxed boxptr_SimCodeC_lm__342(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__342_rettypeboxed tmp1;
  SimCodeC_lm__342_rettype tmp2;
  tmp2 = _SimCodeC_lm__342(_in_txt, _in_items);
  tmp1.SimCodeC_lm__342_rettypeboxed_1 = tmp2.SimCodeC_lm__342_rettype_1;
  return tmp1;
}
SimCodeC_functionBody_rettype _SimCodeC_functionBody(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_boolean _in_a_inFunc)
{
  SimCodeC_functionBody_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_boolean tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    tmp3_in2 = _in_a_inFunc;
    {
      modelica_metatype _txt;
      modelica_boolean _a_inFunc;
      modelica_metatype _i_fn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_functionBodyRegularFunction_rettype tmp12;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,6) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp3_in1;
          _a_inFunc = tmp3_in2;
          tmp12 = _SimCodeC_functionBodyRegularFunction(_txt, _i_fn, _a_inFunc);
          _txt = tmp12.SimCodeC_functionBodyRegularFunction_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          SimCodeC_functionBodyExternalFunction_rettype tmp22;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp17 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp18 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp21 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp3_in1;
          _a_inFunc = tmp3_in2;
          tmp22 = _SimCodeC_functionBodyExternalFunction(_txt, _i_fn, _a_inFunc);
          _txt = tmp22.SimCodeC_functionBodyExternalFunction_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          SimCodeC_functionBodyRecordConstructor_rettype tmp25;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,2) == 0) MMC_THROW();
          tmp23 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp3_in1;
          tmp25 = _SimCodeC_functionBodyRecordConstructor(_txt, _i_fn);
          _txt = tmp25.SimCodeC_functionBodyRecordConstructor_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionBody_rettypeboxed boxptr_SimCodeC_functionBody(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_metatype _in_a_inFunc)
{
  SimCodeC_functionBody_rettypeboxed tmp1;
  SimCodeC_functionBody_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_inFunc);
  tmp2 = _SimCodeC_functionBody(_in_txt, _in_a_fn, tmp3);
  tmp1.SimCodeC_functionBody_rettypeboxed_1 = tmp2.SimCodeC_functionBody_rettype_1;
  return tmp1;
}
SimCodeC_functionBodyRecordConstructor_rettype _SimCodeC_functionBodyRecordConstructor(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_functionBodyRecordConstructor_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_funArgs;
      modelica_metatype _i_fn;
      modelica_metatype _i_name;
      modelica_boolean _ret_7;
      modelica_metatype _l_boxedFn;
      modelica_metatype _l_structVar;
      modelica_metatype _l_structType;
      modelica_metatype _l_retVar;
      modelica_metatype _l_retType;
      modelica_metatype _l_fname;
      modelica_metatype _l_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_underscorePath_rettype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          Tpl_writeText_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          Tpl_textString_rettype tmp24;
          SimCodeC_tempDecl_rettype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          Tpl_writeText_rettype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          Tpl_textString_rettype tmp35;
          SimCodeC_tempDecl_rettype tmp36;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          SimCodeC_fun__381_rettype tmp41;
          Tpl_writeText_rettype tmp42;
          modelica_metatype tmp43;
          Tpl_writeTok_rettype tmp44;
          Tpl_writeText_rettype tmp45;
          modelica_metatype tmp46;
          Tpl_writeTok_rettype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          modelica_metatype tmp50;
          modelica_metatype tmp51;
          Tpl_pushIter_rettype tmp52;
          SimCodeC_lm__382_rettype tmp53;
          Tpl_popIter_rettype tmp54;
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          Tpl_writeTok_rettype tmp57;
          modelica_metatype tmp58;
          Tpl_pushBlock_rettype tmp59;
          Tpl_writeText_rettype tmp60;
          Tpl_softNewLine_rettype tmp61;
          modelica_metatype tmp62;
          modelica_metatype tmp63;
          modelica_metatype tmp64;
          modelica_metatype tmp65;
          Tpl_pushIter_rettype tmp66;
          SimCodeC_lm__383_rettype tmp67;
          Tpl_popIter_rettype tmp68;
          Tpl_softNewLine_rettype tmp69;
          Tpl_writeText_rettype tmp70;
          modelica_metatype tmp71;
          Tpl_writeTok_rettype tmp72;
          Tpl_writeText_rettype tmp73;
          modelica_metatype tmp74;
          modelica_metatype tmp75;
          Tpl_writeTok_rettype tmp76;
          Tpl_writeText_rettype tmp77;
          modelica_metatype tmp78;
          Tpl_writeTok_rettype tmp79;
          Tpl_popBlock_rettype tmp80;
          modelica_metatype tmp81;
          modelica_metatype tmp82;
          Tpl_writeTok_rettype tmp83;
          Tpl_writeText_rettype tmp84;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp3_in1;
          _i_name = tmp6;
          _i_funArgs = tmp7;
          _System_tmpTickReset(1);
          /* NORETCALL */;
          tmp8 = mmc_mk_nil();
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp8, tmp9);
          _l_varDecls = tmp10;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          tmp14 = _SimCodeC_underscorePath(tmp13, _i_name);
          _l_fname = tmp14.SimCodeC_underscorePath_rettype_1;
          tmp15 = mmc_mk_nil();
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp15, tmp16);
          tmp18 = _Tpl_writeText(tmp17, _l_fname);
          _l_retType = tmp18.Tpl_writeText_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp20 = _Tpl_writeTok(_l_retType, tmp19);
          _l_retType = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = mmc_mk_nil();
          tmp22 = mmc_mk_nil();
          tmp23 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp21, tmp22);
          tmp24 = _Tpl_textString(_l_retType);
          tmp25 = _SimCodeC_tempDecl(tmp23, tmp24.Tpl_textString_rettype_1, _l_varDecls);
          _l_retVar = tmp25.targ1;
          _l_varDecls = tmp25.targ2;
          tmp26 = mmc_mk_nil();
          tmp27 = mmc_mk_nil();
          tmp28 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp26, tmp27);
          tmp29 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("struct "));
          tmp30 = _Tpl_writeTok(tmp28, tmp29);
          _l_structType = tmp30.Tpl_writeTok_rettype_1;
          tmp31 = _Tpl_writeText(_l_structType, _l_fname);
          _l_structType = tmp31.Tpl_writeText_rettype_1;
          tmp32 = mmc_mk_nil();
          tmp33 = mmc_mk_nil();
          tmp34 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp32, tmp33);
          tmp35 = _Tpl_textString(_l_structType);
          tmp36 = _SimCodeC_tempDecl(tmp34, tmp35.Tpl_textString_rettype_1, _l_varDecls);
          _l_structVar = tmp36.targ1;
          _l_varDecls = tmp36.targ2;
          tmp37 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_7 = tmp37.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp38 = mmc_mk_nil();
          tmp39 = mmc_mk_nil();
          tmp40 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp38, tmp39);
          tmp41 = _SimCodeC_fun__381(tmp40, _ret_7, _i_fn);
          _l_boxedFn = tmp41.SimCodeC_fun__381_rettype_1;
          tmp42 = _Tpl_writeText(_txt, _l_retType);
          _txt = tmp42.Tpl_writeText_rettype_1;
          tmp43 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" _"));
          tmp44 = _Tpl_writeTok(_txt, tmp43);
          _txt = tmp44.Tpl_writeTok_rettype_1;
          tmp45 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp45.Tpl_writeText_rettype_1;
          tmp46 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp47 = _Tpl_writeTok(_txt, tmp46);
          _txt = tmp47.Tpl_writeTok_rettype_1;
          tmp48 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp49 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp50 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp51 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp48), mmc_mk_integer(0), mmc_mk_integer(0), tmp49, mmc_mk_integer(0), tmp50);
          tmp52 = _Tpl_pushIter(_txt, tmp51);
          _txt = tmp52.Tpl_pushIter_rettype_1;
          tmp53 = _SimCodeC_lm__382(_txt, _i_funArgs);
          _txt = tmp53.SimCodeC_lm__382_rettype_1;
          tmp54 = _Tpl_popIter(_txt);
          _txt = tmp54.Tpl_popIter_rettype_1;
          tmp55 = mmc_mk_cons(mmc_mk_scon(")\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
          tmp56 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp55, mmc_mk_boolean((1)));
          tmp57 = _Tpl_writeTok(_txt, tmp56);
          _txt = tmp57.Tpl_writeTok_rettype_1;
          tmp58 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp59 = _Tpl_pushBlock(_txt, tmp58);
          _txt = tmp59.Tpl_pushBlock_rettype_1;
          tmp60 = _Tpl_writeText(_txt, _l_varDecls);
          _txt = tmp60.Tpl_writeText_rettype_1;
          tmp61 = _Tpl_softNewLine(_txt);
          _txt = tmp61.Tpl_softNewLine_rettype_1;
          tmp62 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp63 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp64 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp65 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp62), mmc_mk_integer(0), mmc_mk_integer(0), tmp63, mmc_mk_integer(0), tmp64);
          tmp66 = _Tpl_pushIter(_txt, tmp65);
          _txt = tmp66.Tpl_pushIter_rettype_1;
          tmp67 = _SimCodeC_lm__383(_txt, _i_funArgs, _l_structVar);
          _txt = tmp67.SimCodeC_lm__383_rettype_1;
          tmp68 = _Tpl_popIter(_txt);
          _txt = tmp68.Tpl_popIter_rettype_1;
          tmp69 = _Tpl_softNewLine(_txt);
          _txt = tmp69.Tpl_softNewLine_rettype_1;
          tmp70 = _Tpl_writeText(_txt, _l_retVar);
          _txt = tmp70.Tpl_writeText_rettype_1;
          tmp71 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".targ1 = "));
          tmp72 = _Tpl_writeTok(_txt, tmp71);
          _txt = tmp72.Tpl_writeTok_rettype_1;
          tmp73 = _Tpl_writeText(_txt, _l_structVar);
          _txt = tmp73.Tpl_writeText_rettype_1;
          tmp74 = mmc_mk_cons(mmc_mk_scon(";\n"), mmc_mk_cons(mmc_mk_scon("return "), mmc_mk_nil()));
          tmp75 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp74, mmc_mk_boolean((0)));
          tmp76 = _Tpl_writeTok(_txt, tmp75);
          _txt = tmp76.Tpl_writeTok_rettype_1;
          tmp77 = _Tpl_writeText(_txt, _l_retVar);
          _txt = tmp77.Tpl_writeText_rettype_1;
          tmp78 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(";\n"));
          tmp79 = _Tpl_writeTok(_txt, tmp78);
          _txt = tmp79.Tpl_writeTok_rettype_1;
          tmp80 = _Tpl_popBlock(_txt);
          _txt = tmp80.Tpl_popBlock_rettype_1;
          tmp81 = mmc_mk_cons(mmc_mk_scon("}\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()));
          tmp82 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp81, mmc_mk_boolean((1)));
          tmp83 = _Tpl_writeTok(_txt, tmp82);
          _txt = tmp83.Tpl_writeTok_rettype_1;
          tmp84 = _Tpl_writeText(_txt, _l_boxedFn);
          _txt = tmp84.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionBodyRecordConstructor_rettypeboxed boxptr_SimCodeC_functionBodyRecordConstructor(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_functionBodyRecordConstructor_rettypeboxed tmp1;
  SimCodeC_functionBodyRecordConstructor_rettype tmp2;
  tmp2 = _SimCodeC_functionBodyRecordConstructor(_in_txt, _in_a_fn);
  tmp1.SimCodeC_functionBodyRecordConstructor_rettypeboxed_1 = tmp2.SimCodeC_functionBodyRecordConstructor_rettype_1;
  return tmp1;
}
SimCodeC_lm__383_rettype _SimCodeC_lm__383(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_structVar)
{
  SimCodeC_lm__383_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_structVar;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_structVar;
      modelica_metatype _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_writeText_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          SimCodeC_crefStr_rettype tmp15;
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          SimCodeC_crefStr_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          Tpl_nextIter_rettype tmp21;
          SimCodeC_lm__383_rettype tmp22;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _rest = tmp7;
          _a_structVar = tmp3_in2;
          tmp12 = _Tpl_writeText(_txt, _a_structVar);
          _txt = tmp12.Tpl_writeText_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = _SimCodeC_crefStr(_txt, _i_name);
          _txt = tmp15.SimCodeC_crefStr_rettype_1;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp17 = _Tpl_writeTok(_txt, tmp16);
          _txt = tmp17.Tpl_writeTok_rettype_1;
          tmp18 = _SimCodeC_crefStr(_txt, _i_name);
          _txt = tmp18.SimCodeC_crefStr_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp20 = _Tpl_writeTok(_txt, tmp19);
          _txt = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = _Tpl_nextIter(_txt);
          _txt = tmp21.Tpl_nextIter_rettype_1;
          tmp22 = _SimCodeC_lm__383(_txt, _rest, _a_structVar);
          _txt = tmp22.SimCodeC_lm__383_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          SimCodeC_lm__383_rettype tmp25;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp23 = MMC_CAR(tmp3_in1);
          tmp24 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp24;
          _a_structVar = tmp3_in2;
          tmp25 = _SimCodeC_lm__383(_txt, _rest, _a_structVar);
          _txt = tmp25.SimCodeC_lm__383_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__383_rettypeboxed boxptr_SimCodeC_lm__383(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_structVar)
{
  SimCodeC_lm__383_rettypeboxed tmp1;
  SimCodeC_lm__383_rettype tmp2;
  tmp2 = _SimCodeC_lm__383(_in_txt, _in_items, _in_a_structVar);
  tmp1.SimCodeC_lm__383_rettypeboxed_1 = tmp2.SimCodeC_lm__383_rettype_1;
  return tmp1;
}
SimCodeC_lm__382_rettype _SimCodeC_lm__382(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__382_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_name;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_expTypeArrayIf_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          SimCodeC_crefStr_rettype tmp15;
          Tpl_nextIter_rettype tmp16;
          SimCodeC_lm__382_rettype tmp17;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _i_ty = tmp9;
          _rest = tmp7;
          tmp12 = _SimCodeC_expTypeArrayIf(_txt, _i_ty);
          _txt = tmp12.SimCodeC_expTypeArrayIf_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = _SimCodeC_crefStr(_txt, _i_name);
          _txt = tmp15.SimCodeC_crefStr_rettype_1;
          tmp16 = _Tpl_nextIter(_txt);
          _txt = tmp16.Tpl_nextIter_rettype_1;
          tmp17 = _SimCodeC_lm__382(_txt, _rest);
          _txt = tmp17.SimCodeC_lm__382_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          SimCodeC_lm__382_rettype tmp20;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp18 = MMC_CAR(tmp3_in1);
          tmp19 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp19;
          tmp20 = _SimCodeC_lm__382(_txt, _rest);
          _txt = tmp20.SimCodeC_lm__382_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__382_rettypeboxed boxptr_SimCodeC_lm__382(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__382_rettypeboxed tmp1;
  SimCodeC_lm__382_rettype tmp2;
  tmp2 = _SimCodeC_lm__382(_in_txt, _in_items);
  tmp1.SimCodeC_lm__382_rettypeboxed_1 = tmp2.SimCodeC_lm__382_rettype_1;
  return tmp1;
}
SimCodeC_fun__381_rettype _SimCodeC_fun__381(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_fn)
{
  SimCodeC_fun__381_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_fn;
    {
      modelica_metatype _txt;
      modelica_metatype _a_fn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_functionBodyBoxed_rettype tmp6;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fn = tmp3_in2;
          tmp6 = _SimCodeC_functionBodyBoxed(_txt, _a_fn);
          _txt = tmp6.SimCodeC_functionBodyBoxed_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__381_rettypeboxed boxptr_SimCodeC_fun__381(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_fn)
{
  SimCodeC_fun__381_rettypeboxed tmp1;
  SimCodeC_fun__381_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__381(_in_txt, tmp3, _in_a_fn);
  tmp1.SimCodeC_fun__381_rettypeboxed_1 = tmp2.SimCodeC_fun__381_rettype_1;
  return tmp1;
}
SimCodeC_functionBodyExternalFunction_rettype _SimCodeC_functionBodyExternalFunction(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_boolean _in_a_inFunc)
{
  SimCodeC_functionBodyExternalFunction_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_boolean tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    tmp3_in2 = _in_a_inFunc;
    {
      modelica_metatype _txt;
      modelica_boolean _a_inFunc;
      modelica_metatype _i_funArgs;
      modelica_metatype _i_efn;
      modelica_metatype _i_outVars;
      modelica_metatype _i_name;
      modelica_boolean _ret_14;
      modelica_boolean _ret_13;
      modelica_metatype _l_fnBody;
      modelica_boolean _ret_11;
      modelica_metatype _l_boxedFn;
      modelica_metatype _l_0__;
      modelica_metatype _l_callPart;
      modelica_boolean _ret_7;
      modelica_metatype _l_stateVar;
      modelica_metatype _l_outputAlloc;
      modelica_metatype _l_retVar;
      modelica_metatype _l_varDecls;
      modelica_metatype _l_preExp;
      modelica_metatype _l_retType;
      modelica_metatype _l_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          SimCodeC_underscorePath_rettype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          SimCodeC_fun__366_rettype tmp22;
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          SimCodeC_fun__367_rettype tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          SimCodeC_fun__368_rettype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          SimCodeC_extFunCall_rettype tmp44;
          modelica_metatype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          modelica_metatype tmp50;
          Tpl_pushIter_rettype tmp51;
          SimCodeC_lm__369_rettype tmp52;
          Tpl_popIter_rettype tmp53;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp54;
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          modelica_metatype tmp57;
          SimCodeC_fun__370_rettype tmp58;
          modelica_metatype tmp59;
          modelica_metatype tmp60;
          modelica_metatype tmp61;
          Tpl_writeText_rettype tmp62;
          modelica_metatype tmp63;
          Tpl_writeTok_rettype tmp64;
          Tpl_writeText_rettype tmp65;
          modelica_metatype tmp66;
          Tpl_writeTok_rettype tmp67;
          modelica_metatype tmp68;
          modelica_metatype tmp69;
          modelica_metatype tmp70;
          modelica_metatype tmp71;
          Tpl_pushIter_rettype tmp72;
          SimCodeC_lm__371_rettype tmp73;
          Tpl_popIter_rettype tmp74;
          modelica_metatype tmp75;
          modelica_metatype tmp76;
          Tpl_writeTok_rettype tmp77;
          modelica_metatype tmp78;
          Tpl_pushBlock_rettype tmp79;
          Tpl_writeText_rettype tmp80;
          Tpl_softNewLine_rettype tmp81;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp82;
          SimCodeC_fun__372_rettype tmp83;
          Tpl_softNewLine_rettype tmp84;
          Tpl_writeText_rettype tmp85;
          Tpl_softNewLine_rettype tmp86;
          Tpl_writeText_rettype tmp87;
          Tpl_softNewLine_rettype tmp88;
          Tpl_writeText_rettype tmp89;
          Tpl_softNewLine_rettype tmp90;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp91;
          SimCodeC_fun__373_rettype tmp92;
          Tpl_softNewLine_rettype tmp93;
          modelica_metatype tmp94;
          Tpl_writeTok_rettype tmp95;
          SimCodeC_fun__374_rettype tmp96;
          modelica_metatype tmp97;
          Tpl_writeTok_rettype tmp98;
          Tpl_popBlock_rettype tmp99;
          modelica_metatype tmp100;
          Tpl_writeTok_rettype tmp101;
          Tpl_writeText_rettype tmp102;
          Tpl_softNewLine_rettype tmp103;
          modelica_metatype tmp104;
          Tpl_writeTok_rettype tmp105;
          SimCodeC_fun__379_rettype tmp106;
          Tpl_softNewLine_rettype tmp107;
          modelica_metatype tmp108;
          Tpl_writeTok_rettype tmp109;
          Tpl_writeText_rettype tmp110;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_efn = tmp3_in1;
          _i_name = tmp6;
          _i_funArgs = tmp8;
          _i_outVars = tmp12;
          _a_inFunc = tmp3_in2;
          _System_tmpTickReset(1);
          /* NORETCALL */;
          tmp15 = mmc_mk_nil();
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp15, tmp16);
          tmp18 = _SimCodeC_underscorePath(tmp17, _i_name);
          _l_fname = tmp18.SimCodeC_underscorePath_rettype_1;
          tmp19 = mmc_mk_nil();
          tmp20 = mmc_mk_nil();
          tmp21 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp19, tmp20);
          tmp22 = _SimCodeC_fun__366(tmp21, _i_outVars, _l_fname);
          _l_retType = tmp22.SimCodeC_fun__366_rettype_1;
          tmp23 = mmc_mk_nil();
          tmp24 = mmc_mk_nil();
          tmp25 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp23, tmp24);
          _l_preExp = tmp25;
          tmp26 = mmc_mk_nil();
          tmp27 = mmc_mk_nil();
          tmp28 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp26, tmp27);
          _l_varDecls = tmp28;
          tmp29 = mmc_mk_nil();
          tmp30 = mmc_mk_nil();
          tmp31 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp29, tmp30);
          tmp32 = _SimCodeC_fun__367(tmp31, _i_outVars, _l_varDecls, _l_retType);
          _l_retVar = tmp32.targ1;
          _l_varDecls = tmp32.targ2;
          tmp33 = mmc_mk_nil();
          tmp34 = mmc_mk_nil();
          tmp35 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp33, tmp34);
          _l_outputAlloc = tmp35;
          tmp36 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_7 = tmp36.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp37 = mmc_mk_nil();
          tmp38 = mmc_mk_nil();
          tmp39 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp37, tmp38);
          tmp40 = _SimCodeC_fun__368(tmp39, _ret_7, _l_varDecls);
          _l_stateVar = tmp40.targ1;
          _l_varDecls = tmp40.targ2;
          tmp41 = mmc_mk_nil();
          tmp42 = mmc_mk_nil();
          tmp43 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp41, tmp42);
          tmp44 = _SimCodeC_extFunCall(tmp43, _i_efn, _l_preExp, _l_varDecls);
          _l_callPart = tmp44.targ1;
          _l_preExp = tmp44.targ2;
          _l_varDecls = tmp44.targ3;
          tmp45 = mmc_mk_nil();
          tmp46 = mmc_mk_nil();
          tmp47 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp45, tmp46);
          tmp48 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp49 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp50 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_none(), mmc_mk_none(), mmc_mk_integer(0), mmc_mk_integer(0), tmp48, mmc_mk_integer(0), tmp49);
          tmp51 = _Tpl_pushIter(tmp47, tmp50);
          _l_0__ = tmp51.Tpl_pushIter_rettype_1;
          tmp52 = _SimCodeC_lm__369(_l_0__, _i_outVars, _l_outputAlloc, _l_varDecls, _l_retVar);
          _l_0__ = tmp52.targ1;
          _l_outputAlloc = tmp52.targ2;
          _l_varDecls = tmp52.targ3;
          tmp53 = _Tpl_popIter(_l_0__);
          _l_0__ = tmp53.Tpl_popIter_rettype_1;
          tmp54 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_11 = tmp54.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp55 = mmc_mk_nil();
          tmp56 = mmc_mk_nil();
          tmp57 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp55, tmp56);
          tmp58 = _SimCodeC_fun__370(tmp57, _ret_11, _i_efn);
          _l_boxedFn = tmp58.SimCodeC_fun__370_rettype_1;
          tmp59 = mmc_mk_nil();
          tmp60 = mmc_mk_nil();
          tmp61 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp59, tmp60);
          tmp62 = _Tpl_writeText(tmp61, _l_retType);
          _l_fnBody = tmp62.Tpl_writeText_rettype_1;
          tmp63 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" _"));
          tmp64 = _Tpl_writeTok(_l_fnBody, tmp63);
          _l_fnBody = tmp64.Tpl_writeTok_rettype_1;
          tmp65 = _Tpl_writeText(_l_fnBody, _l_fname);
          _l_fnBody = tmp65.Tpl_writeText_rettype_1;
          tmp66 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp67 = _Tpl_writeTok(_l_fnBody, tmp66);
          _l_fnBody = tmp67.Tpl_writeTok_rettype_1;
          tmp68 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp69 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp70 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp71 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp68), mmc_mk_integer(0), mmc_mk_integer(0), tmp69, mmc_mk_integer(0), tmp70);
          tmp72 = _Tpl_pushIter(_l_fnBody, tmp71);
          _l_fnBody = tmp72.Tpl_pushIter_rettype_1;
          tmp73 = _SimCodeC_lm__371(_l_fnBody, _i_funArgs);
          _l_fnBody = tmp73.SimCodeC_lm__371_rettype_1;
          tmp74 = _Tpl_popIter(_l_fnBody);
          _l_fnBody = tmp74.Tpl_popIter_rettype_1;
          tmp75 = mmc_mk_cons(mmc_mk_scon(")\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
          tmp76 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp75, mmc_mk_boolean((1)));
          tmp77 = _Tpl_writeTok(_l_fnBody, tmp76);
          _l_fnBody = tmp77.Tpl_writeTok_rettype_1;
          tmp78 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp79 = _Tpl_pushBlock(_l_fnBody, tmp78);
          _l_fnBody = tmp79.Tpl_pushBlock_rettype_1;
          tmp80 = _Tpl_writeText(_l_fnBody, _l_varDecls);
          _l_fnBody = tmp80.Tpl_writeText_rettype_1;
          tmp81 = _Tpl_softNewLine(_l_fnBody);
          _l_fnBody = tmp81.Tpl_softNewLine_rettype_1;
          tmp82 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_13 = tmp82.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp83 = _SimCodeC_fun__372(_l_fnBody, _ret_13, _l_stateVar);
          _l_fnBody = tmp83.SimCodeC_fun__372_rettype_1;
          tmp84 = _Tpl_softNewLine(_l_fnBody);
          _l_fnBody = tmp84.Tpl_softNewLine_rettype_1;
          tmp85 = _Tpl_writeText(_l_fnBody, _l_outputAlloc);
          _l_fnBody = tmp85.Tpl_writeText_rettype_1;
          tmp86 = _Tpl_softNewLine(_l_fnBody);
          _l_fnBody = tmp86.Tpl_softNewLine_rettype_1;
          tmp87 = _Tpl_writeText(_l_fnBody, _l_preExp);
          _l_fnBody = tmp87.Tpl_writeText_rettype_1;
          tmp88 = _Tpl_softNewLine(_l_fnBody);
          _l_fnBody = tmp88.Tpl_softNewLine_rettype_1;
          tmp89 = _Tpl_writeText(_l_fnBody, _l_callPart);
          _l_fnBody = tmp89.Tpl_writeText_rettype_1;
          tmp90 = _Tpl_softNewLine(_l_fnBody);
          _l_fnBody = tmp90.Tpl_softNewLine_rettype_1;
          tmp91 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_14 = tmp91.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp92 = _SimCodeC_fun__373(_l_fnBody, _ret_14, _l_stateVar);
          _l_fnBody = tmp92.SimCodeC_fun__373_rettype_1;
          tmp93 = _Tpl_softNewLine(_l_fnBody);
          _l_fnBody = tmp93.Tpl_softNewLine_rettype_1;
          tmp94 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("return "));
          tmp95 = _Tpl_writeTok(_l_fnBody, tmp94);
          _l_fnBody = tmp95.Tpl_writeTok_rettype_1;
          tmp96 = _SimCodeC_fun__374(_l_fnBody, _i_outVars, _l_retVar);
          _l_fnBody = tmp96.SimCodeC_fun__374_rettype_1;
          tmp97 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(";\n"));
          tmp98 = _Tpl_writeTok(_l_fnBody, tmp97);
          _l_fnBody = tmp98.Tpl_writeTok_rettype_1;
          tmp99 = _Tpl_popBlock(_l_fnBody);
          _l_fnBody = tmp99.Tpl_popBlock_rettype_1;
          tmp100 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("}"));
          tmp101 = _Tpl_writeTok(_l_fnBody, tmp100);
          _l_fnBody = tmp101.Tpl_writeTok_rettype_1;
          tmp102 = _Tpl_writeText(_txt, _l_fnBody);
          _txt = tmp102.Tpl_writeText_rettype_1;
          tmp103 = _Tpl_softNewLine(_txt);
          _txt = tmp103.Tpl_softNewLine_rettype_1;
          tmp104 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp105 = _Tpl_writeTok(_txt, tmp104);
          _txt = tmp105.Tpl_writeTok_rettype_1;
          tmp106 = _SimCodeC_fun__379(_txt, _a_inFunc, _i_outVars, _l_retType, _i_funArgs, _l_fname);
          _txt = tmp106.SimCodeC_fun__379_rettype_1;
          tmp107 = _Tpl_softNewLine(_txt);
          _txt = tmp107.Tpl_softNewLine_rettype_1;
          tmp108 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp109 = _Tpl_writeTok(_txt, tmp108);
          _txt = tmp109.Tpl_writeTok_rettype_1;
          tmp110 = _Tpl_writeText(_txt, _l_boxedFn);
          _txt = tmp110.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionBodyExternalFunction_rettypeboxed boxptr_SimCodeC_functionBodyExternalFunction(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_metatype _in_a_inFunc)
{
  SimCodeC_functionBodyExternalFunction_rettypeboxed tmp1;
  SimCodeC_functionBodyExternalFunction_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_inFunc);
  tmp2 = _SimCodeC_functionBodyExternalFunction(_in_txt, _in_a_fn, tmp3);
  tmp1.SimCodeC_functionBodyExternalFunction_rettypeboxed_1 = tmp2.SimCodeC_functionBodyExternalFunction_rettype_1;
  return tmp1;
}
SimCodeC_fun__379_rettype _SimCodeC_fun__379(modelica_metatype _in_txt, modelica_boolean _in_a_inFunc, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retType, modelica_metatype _in_a_funArgs, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__379_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_inFunc;
    tmp3_in2 = _in_a_outVars;
    tmp3_in3 = _in_a_retType;
    tmp3_in4 = _in_a_funArgs;
    tmp3_in5 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_metatype _a_outVars;
      modelica_metatype _a_retType;
      modelica_metatype _a_funArgs;
      modelica_metatype _a_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_pushBlock_rettype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          Tpl_pushIter_rettype tmp18;
          SimCodeC_lm__375_rettype tmp19;
          Tpl_popIter_rettype tmp20;
          Tpl_softNewLine_rettype tmp21;
          Tpl_writeText_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          Tpl_pushIter_rettype tmp29;
          SimCodeC_lm__376_rettype tmp30;
          Tpl_popIter_rettype tmp31;
          Tpl_softNewLine_rettype tmp32;
          modelica_metatype tmp33;
          Tpl_writeTok_rettype tmp34;
          Tpl_writeText_rettype tmp35;
          modelica_metatype tmp36;
          Tpl_writeTok_rettype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          Tpl_pushIter_rettype tmp42;
          SimCodeC_lm__377_rettype tmp43;
          Tpl_popIter_rettype tmp44;
          modelica_metatype tmp45;
          Tpl_writeTok_rettype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          modelica_metatype tmp50;
          Tpl_pushIter_rettype tmp51;
          SimCodeC_lm__378_rettype tmp52;
          Tpl_popIter_rettype tmp53;
          Tpl_softNewLine_rettype tmp54;
          modelica_metatype tmp55;
          Tpl_writeTok_rettype tmp56;
          Tpl_popBlock_rettype tmp57;
          modelica_metatype tmp58;
          Tpl_writeTok_rettype tmp59;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_outVars = tmp3_in2;
          _a_retType = tmp3_in3;
          _a_funArgs = tmp3_in4;
          _a_fname = tmp3_in5;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("int in_"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_cons(mmc_mk_scon("(type_description * inArgs, type_description * outVar)\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
          tmp10 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp9, mmc_mk_boolean((1)));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp13 = _Tpl_pushBlock(_txt, tmp12);
          _txt = tmp13.Tpl_pushBlock_rettype_1;
          tmp14 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp15 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp16 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp17 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp14), mmc_mk_integer(0), mmc_mk_integer(0), tmp15, mmc_mk_integer(0), tmp16);
          tmp18 = _Tpl_pushIter(_txt, tmp17);
          _txt = tmp18.Tpl_pushIter_rettype_1;
          tmp19 = _SimCodeC_lm__375(_txt, _a_funArgs);
          _txt = tmp19.SimCodeC_lm__375_rettype_1;
          tmp20 = _Tpl_popIter(_txt);
          _txt = tmp20.Tpl_popIter_rettype_1;
          tmp21 = _Tpl_softNewLine(_txt);
          _txt = tmp21.Tpl_softNewLine_rettype_1;
          tmp22 = _Tpl_writeText(_txt, _a_retType);
          _txt = tmp22.Tpl_writeText_rettype_1;
          tmp23 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(" out;\n"));
          tmp24 = _Tpl_writeTok(_txt, tmp23);
          _txt = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp26 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp27 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp28 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp25), mmc_mk_integer(0), mmc_mk_integer(0), tmp26, mmc_mk_integer(0), tmp27);
          tmp29 = _Tpl_pushIter(_txt, tmp28);
          _txt = tmp29.Tpl_pushIter_rettype_1;
          tmp30 = _SimCodeC_lm__376(_txt, _a_funArgs);
          _txt = tmp30.SimCodeC_lm__376_rettype_1;
          tmp31 = _Tpl_popIter(_txt);
          _txt = tmp31.Tpl_popIter_rettype_1;
          tmp32 = _Tpl_softNewLine(_txt);
          _txt = tmp32.Tpl_softNewLine_rettype_1;
          tmp33 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("out = _"));
          tmp34 = _Tpl_writeTok(_txt, tmp33);
          _txt = tmp34.Tpl_writeTok_rettype_1;
          tmp35 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp35.Tpl_writeText_rettype_1;
          tmp36 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp37 = _Tpl_writeTok(_txt, tmp36);
          _txt = tmp37.Tpl_writeTok_rettype_1;
          tmp38 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp39 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp40 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp41 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp38), mmc_mk_integer(0), mmc_mk_integer(0), tmp39, mmc_mk_integer(0), tmp40);
          tmp42 = _Tpl_pushIter(_txt, tmp41);
          _txt = tmp42.Tpl_pushIter_rettype_1;
          tmp43 = _SimCodeC_lm__377(_txt, _a_funArgs);
          _txt = tmp43.SimCodeC_lm__377_rettype_1;
          tmp44 = _Tpl_popIter(_txt);
          _txt = tmp44.Tpl_popIter_rettype_1;
          tmp45 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(");\n"));
          tmp46 = _Tpl_writeTok(_txt, tmp45);
          _txt = tmp46.Tpl_writeTok_rettype_1;
          tmp47 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp48 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp49 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp50 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_none(), mmc_mk_some(tmp47), mmc_mk_integer(0), mmc_mk_integer(0), tmp48, mmc_mk_integer(0), tmp49);
          tmp51 = _Tpl_pushIter(_txt, tmp50);
          _txt = tmp51.Tpl_pushIter_rettype_1;
          tmp52 = _SimCodeC_lm__378(_txt, _a_outVars);
          _txt = tmp52.SimCodeC_lm__378_rettype_1;
          tmp53 = _Tpl_popIter(_txt);
          _txt = tmp53.Tpl_popIter_rettype_1;
          tmp54 = _Tpl_softNewLine(_txt);
          _txt = tmp54.Tpl_softNewLine_rettype_1;
          tmp55 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("return 0;\n"));
          tmp56 = _Tpl_writeTok(_txt, tmp55);
          _txt = tmp56.Tpl_writeTok_rettype_1;
          tmp57 = _Tpl_popBlock(_txt);
          _txt = tmp57.Tpl_popBlock_rettype_1;
          tmp58 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("}"));
          tmp59 = _Tpl_writeTok(_txt, tmp58);
          _txt = tmp59.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__379_rettypeboxed boxptr_SimCodeC_fun__379(modelica_metatype _in_txt, modelica_metatype _in_a_inFunc, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retType, modelica_metatype _in_a_funArgs, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__379_rettypeboxed tmp1;
  SimCodeC_fun__379_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_inFunc);
  tmp2 = _SimCodeC_fun__379(_in_txt, tmp3, _in_a_outVars, _in_a_retType, _in_a_funArgs, _in_a_fname);
  tmp1.SimCodeC_fun__379_rettypeboxed_1 = tmp2.SimCodeC_fun__379_rettype_1;
  return tmp1;
}
SimCodeC_lm__378_rettype _SimCodeC_lm__378(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__378_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_integer _x_i1;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_getIteri__i0_rettype tmp12;
          SimCodeC_writeOutVar_rettype tmp13;
          Tpl_nextIter_rettype tmp14;
          SimCodeC_lm__378_rettype tmp15;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp12 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp12.Tpl_getIteri__i0_rettype_1;
          tmp13 = _SimCodeC_writeOutVar(_txt, _i_var, (modelica_integer)_x_i1);
          _txt = tmp13.SimCodeC_writeOutVar_rettype_1;
          tmp14 = _Tpl_nextIter(_txt);
          _txt = tmp14.Tpl_nextIter_rettype_1;
          tmp15 = _SimCodeC_lm__378(_txt, _rest);
          _txt = tmp15.SimCodeC_lm__378_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          SimCodeC_lm__378_rettype tmp18;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp16 = MMC_CAR(tmp3_in1);
          tmp17 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp17;
          tmp18 = _SimCodeC_lm__378(_txt, _rest);
          _txt = tmp18.SimCodeC_lm__378_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__378_rettypeboxed boxptr_SimCodeC_lm__378(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__378_rettypeboxed tmp1;
  SimCodeC_lm__378_rettype tmp2;
  tmp2 = _SimCodeC_lm__378(_in_txt, _in_items);
  tmp1.SimCodeC_lm__378_rettypeboxed_1 = tmp2.SimCodeC_lm__378_rettype_1;
  return tmp1;
}
SimCodeC_lm__377_rettype _SimCodeC_lm__377(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__377_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_contextCref_rettype tmp13;
          Tpl_nextIter_rettype tmp14;
          SimCodeC_lm__377_rettype tmp15;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _rest = tmp7;
          tmp12 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp13 = _SimCodeC_contextCref(_txt, _i_name, tmp12);
          _txt = tmp13.SimCodeC_contextCref_rettype_1;
          tmp14 = _Tpl_nextIter(_txt);
          _txt = tmp14.Tpl_nextIter_rettype_1;
          tmp15 = _SimCodeC_lm__377(_txt, _rest);
          _txt = tmp15.SimCodeC_lm__377_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          SimCodeC_lm__377_rettype tmp18;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp16 = MMC_CAR(tmp3_in1);
          tmp17 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp17;
          tmp18 = _SimCodeC_lm__377(_txt, _rest);
          _txt = tmp18.SimCodeC_lm__377_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__377_rettypeboxed boxptr_SimCodeC_lm__377(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__377_rettypeboxed tmp1;
  SimCodeC_lm__377_rettype tmp2;
  tmp2 = _SimCodeC_lm__377(_in_txt, _in_items);
  tmp1.SimCodeC_lm__377_rettypeboxed_1 = tmp2.SimCodeC_lm__377_rettype_1;
  return tmp1;
}
SimCodeC_lm__376_rettype _SimCodeC_lm__376(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__376_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_readInVar_rettype tmp12;
          Tpl_nextIter_rettype tmp13;
          SimCodeC_lm__376_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          tmp12 = _SimCodeC_readInVar(_txt, _i_arg);
          _txt = tmp12.SimCodeC_readInVar_rettype_1;
          tmp13 = _Tpl_nextIter(_txt);
          _txt = tmp13.Tpl_nextIter_rettype_1;
          tmp14 = _SimCodeC_lm__376(_txt, _rest);
          _txt = tmp14.SimCodeC_lm__376_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          SimCodeC_lm__376_rettype tmp17;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp15 = MMC_CAR(tmp3_in1);
          tmp16 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp16;
          tmp17 = _SimCodeC_lm__376(_txt, _rest);
          _txt = tmp17.SimCodeC_lm__376_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__376_rettypeboxed boxptr_SimCodeC_lm__376(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__376_rettypeboxed tmp1;
  SimCodeC_lm__376_rettype tmp2;
  tmp2 = _SimCodeC_lm__376(_in_txt, _in_items);
  tmp1.SimCodeC_lm__376_rettypeboxed_1 = tmp2.SimCodeC_lm__376_rettype_1;
  return tmp1;
}
SimCodeC_lm__375_rettype _SimCodeC_lm__375(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__375_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_name;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_expTypeArrayIf_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          modelica_metatype tmp15;
          SimCodeC_contextCref_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          Tpl_nextIter_rettype tmp19;
          SimCodeC_lm__375_rettype tmp20;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _i_ty = tmp9;
          _rest = tmp7;
          tmp12 = _SimCodeC_expTypeArrayIf(_txt, _i_ty);
          _txt = tmp12.SimCodeC_expTypeArrayIf_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp16 = _SimCodeC_contextCref(_txt, _i_name, tmp15);
          _txt = tmp16.SimCodeC_contextCref_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp19 = _Tpl_nextIter(_txt);
          _txt = tmp19.Tpl_nextIter_rettype_1;
          tmp20 = _SimCodeC_lm__375(_txt, _rest);
          _txt = tmp20.SimCodeC_lm__375_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          SimCodeC_lm__375_rettype tmp23;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp21 = MMC_CAR(tmp3_in1);
          tmp22 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp22;
          tmp23 = _SimCodeC_lm__375(_txt, _rest);
          _txt = tmp23.SimCodeC_lm__375_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__375_rettypeboxed boxptr_SimCodeC_lm__375(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__375_rettypeboxed tmp1;
  SimCodeC_lm__375_rettype tmp2;
  tmp2 = _SimCodeC_lm__375(_in_txt, _in_items);
  tmp1.SimCodeC_lm__375_rettypeboxed_1 = tmp2.SimCodeC_lm__375_rettype_1;
  return tmp1;
}
SimCodeC_fun__374_rettype _SimCodeC_fun__374(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retVar)
{
  SimCodeC_fun__374_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_retVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_retVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp6;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_retVar = tmp3_in2;
          tmp6 = _Tpl_writeText(_txt, _a_retVar);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__374_rettypeboxed boxptr_SimCodeC_fun__374(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retVar)
{
  SimCodeC_fun__374_rettypeboxed tmp1;
  SimCodeC_fun__374_rettype tmp2;
  tmp2 = _SimCodeC_fun__374(_in_txt, _in_a_outVars, _in_a_retVar);
  tmp1.SimCodeC_fun__374_rettypeboxed_1 = tmp2.SimCodeC_fun__374_rettype_1;
  return tmp1;
}
SimCodeC_fun__373_rettype _SimCodeC_fun__373(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__373_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("restore_memory_state("));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__373_rettypeboxed boxptr_SimCodeC_fun__373(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__373_rettypeboxed tmp1;
  SimCodeC_fun__373_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__373(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__373_rettypeboxed_1 = tmp2.SimCodeC_fun__373_rettype_1;
  return tmp1;
}
SimCodeC_fun__372_rettype _SimCodeC_fun__372(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__372_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          Tpl_writeText_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = get_memory_state();"));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__372_rettypeboxed boxptr_SimCodeC_fun__372(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__372_rettypeboxed tmp1;
  SimCodeC_fun__372_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__372(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__372_rettypeboxed_1 = tmp2.SimCodeC_fun__372_rettype_1;
  return tmp1;
}
SimCodeC_lm__371_rettype _SimCodeC_lm__371(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__371_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_name;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_expTypeArrayIf_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          modelica_metatype tmp15;
          SimCodeC_contextCref_rettype tmp16;
          Tpl_nextIter_rettype tmp17;
          SimCodeC_lm__371_rettype tmp18;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _i_ty = tmp9;
          _rest = tmp7;
          tmp12 = _SimCodeC_expTypeArrayIf(_txt, _i_ty);
          _txt = tmp12.SimCodeC_expTypeArrayIf_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp16 = _SimCodeC_contextCref(_txt, _i_name, tmp15);
          _txt = tmp16.SimCodeC_contextCref_rettype_1;
          tmp17 = _Tpl_nextIter(_txt);
          _txt = tmp17.Tpl_nextIter_rettype_1;
          tmp18 = _SimCodeC_lm__371(_txt, _rest);
          _txt = tmp18.SimCodeC_lm__371_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          SimCodeC_lm__371_rettype tmp21;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp19 = MMC_CAR(tmp3_in1);
          tmp20 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp20;
          tmp21 = _SimCodeC_lm__371(_txt, _rest);
          _txt = tmp21.SimCodeC_lm__371_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__371_rettypeboxed boxptr_SimCodeC_lm__371(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__371_rettypeboxed tmp1;
  SimCodeC_lm__371_rettype tmp2;
  tmp2 = _SimCodeC_lm__371(_in_txt, _in_items);
  tmp1.SimCodeC_lm__371_rettypeboxed_1 = tmp2.SimCodeC_lm__371_rettype_1;
  return tmp1;
}
SimCodeC_fun__370_rettype _SimCodeC_fun__370(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_fn)
{
  SimCodeC_fun__370_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_fn;
    {
      modelica_metatype _txt;
      modelica_metatype _a_fn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_functionBodyBoxed_rettype tmp6;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fn = tmp3_in2;
          tmp6 = _SimCodeC_functionBodyBoxed(_txt, _a_fn);
          _txt = tmp6.SimCodeC_functionBodyBoxed_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__370_rettypeboxed boxptr_SimCodeC_fun__370(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_fn)
{
  SimCodeC_fun__370_rettypeboxed tmp1;
  SimCodeC_fun__370_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__370(_in_txt, tmp3, _in_a_fn);
  tmp1.SimCodeC_fun__370_rettypeboxed_1 = tmp2.SimCodeC_fun__370_rettype_1;
  return tmp1;
}
SimCodeC_lm__369_rettype _SimCodeC_lm__369(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_outputAlloc, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retVar)
{
  SimCodeC_lm__369_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_outputAlloc;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_outputAlloc;
    tmp3_in3 = _in_a_varDecls;
    tmp3_in4 = _in_a_retVar;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_outputAlloc;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_retVar;
      modelica_integer _x_i1;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_outputAlloc = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_outputAlloc;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_getIteri__i0_rettype tmp8;
          Tpl_textString_rettype tmp9;
          SimCodeC_varInit_rettype tmp10;
          Tpl_nextIter_rettype tmp11;
          SimCodeC_lm__369_rettype tmp12;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          _a_outputAlloc = tmp3_in2;
          _a_varDecls = tmp3_in3;
          _a_retVar = tmp3_in4;
          tmp8 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp8.Tpl_getIteri__i0_rettype_1;
          tmp9 = _Tpl_textString(_a_retVar);
          tmp10 = _SimCodeC_varInit(_txt, _i_var, tmp9.Tpl_textString_rettype_1, (modelica_integer)_x_i1, _a_varDecls, _a_outputAlloc);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          _a_outputAlloc = tmp10.targ3;
          tmp11 = _Tpl_nextIter(_txt);
          _txt = tmp11.Tpl_nextIter_rettype_1;
          tmp12 = _SimCodeC_lm__369(_txt, _rest, _a_outputAlloc, _a_varDecls, _a_retVar);
          _txt = tmp12.targ1;
          _a_outputAlloc = tmp12.targ2;
          _a_varDecls = tmp12.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_outputAlloc;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          SimCodeC_lm__369_rettype tmp15;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp13 = MMC_CAR(tmp3_in1);
          tmp14 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp14;
          _a_outputAlloc = tmp3_in2;
          _a_varDecls = tmp3_in3;
          _a_retVar = tmp3_in4;
          tmp15 = _SimCodeC_lm__369(_txt, _rest, _a_outputAlloc, _a_varDecls, _a_retVar);
          _txt = tmp15.targ1;
          _a_outputAlloc = tmp15.targ2;
          _a_varDecls = tmp15.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_outputAlloc;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_outputAlloc = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_outputAlloc;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__369_rettypeboxed boxptr_SimCodeC_lm__369(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_outputAlloc, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retVar)
{
  SimCodeC_lm__369_rettypeboxed tmp1;
  SimCodeC_lm__369_rettype tmp2;
  tmp2 = _SimCodeC_lm__369(_in_txt, _in_items, _in_a_outputAlloc, _in_a_varDecls, _in_a_retVar);
  tmp1.SimCodeC_lm__369_rettypeboxed_1 = tmp2.SimCodeC_lm__369_rettype_1;
  tmp1.SimCodeC_lm__369_rettypeboxed_2 = tmp2.SimCodeC_lm__369_rettype_2;
  tmp1.SimCodeC_lm__369_rettypeboxed_3 = tmp2.SimCodeC_lm__369_rettype_3;
  return tmp1;
}
SimCodeC_extFunCall_rettype _SimCodeC_extFunCall(modelica_metatype _in_txt, modelica_metatype _in_a_fun, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCall_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fun;
    tmp3_in2 = _in_a_preExp;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_fun;
      modelica_string _i_language;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_string tmp15;
          SimCodeC_fun__447_rettype tmp16;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          tmp15 = mmc_unbox_string(tmp14);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fun = tmp3_in1;
          _i_language = tmp15;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp16 = _SimCodeC_fun__447(_txt, _i_language, _a_varDecls, _a_preExp, _i_fun);
          _txt = tmp16.targ1;
          _a_varDecls = tmp16.targ2;
          _a_preExp = tmp16.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extFunCall_rettypeboxed boxptr_SimCodeC_extFunCall(modelica_metatype _in_txt, modelica_metatype _in_a_fun, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCall_rettypeboxed tmp1;
  SimCodeC_extFunCall_rettype tmp2;
  tmp2 = _SimCodeC_extFunCall(_in_txt, _in_a_fun, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_extFunCall_rettypeboxed_1 = tmp2.SimCodeC_extFunCall_rettype_1;
  tmp1.SimCodeC_extFunCall_rettypeboxed_2 = tmp2.SimCodeC_extFunCall_rettype_2;
  tmp1.SimCodeC_extFunCall_rettypeboxed_3 = tmp2.SimCodeC_extFunCall_rettype_3;
  return tmp1;
}
SimCodeC_fun__447_rettype _SimCodeC_fun__447(modelica_metatype _in_txt, modelica_string _in_a_language, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_fun)
{
  SimCodeC_fun__447_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_string tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_language;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_fun;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _a_fun;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_extFunCallC_rettype tmp6;
          if (strcmp("C", tmp3_in1) != 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_fun = tmp3_in4;
          tmp6 = _SimCodeC_extFunCallC(_txt, _a_fun, _a_preExp, _a_varDecls);
          _txt = tmp6.targ1;
          _a_preExp = tmp6.targ2;
          _a_varDecls = tmp6.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_extFunCallF77_rettype tmp7;
          if (strcmp("FORTRAN 77", tmp3_in1) != 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_fun = tmp3_in4;
          tmp7 = _SimCodeC_extFunCallF77(_txt, _a_fun, _a_preExp, _a_varDecls);
          _txt = tmp7.targ1;
          _a_preExp = tmp7.targ2;
          _a_varDecls = tmp7.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_fun__447_rettypeboxed boxptr_SimCodeC_fun__447(modelica_metatype _in_txt, modelica_metatype _in_a_language, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_fun)
{
  SimCodeC_fun__447_rettypeboxed tmp1;
  SimCodeC_fun__447_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_language);
  tmp2 = _SimCodeC_fun__447(_in_txt, tmp3, _in_a_varDecls, _in_a_preExp, _in_a_fun);
  tmp1.SimCodeC_fun__447_rettypeboxed_1 = tmp2.SimCodeC_fun__447_rettype_1;
  tmp1.SimCodeC_fun__447_rettypeboxed_2 = tmp2.SimCodeC_fun__447_rettype_2;
  tmp1.SimCodeC_fun__447_rettypeboxed_3 = tmp2.SimCodeC_fun__447_rettype_3;
  return tmp1;
}
SimCodeC_extFunCallF77_rettype _SimCodeC_extFunCallF77(modelica_metatype _in_txt, modelica_metatype _in_a_fun, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallF77_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fun;
    tmp3_in2 = _in_a_preExp;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_string _i_extName;
      modelica_metatype _i_biVars;
      modelica_metatype _i_extReturn;
      modelica_metatype _i_extArgs;
      modelica_metatype _l_returnAssign;
      modelica_metatype _l_args;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_string tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          Tpl_pushIter_rettype tmp23;
          SimCodeC_lm__456_rettype tmp24;
          Tpl_popIter_rettype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          SimCodeC_fun__457_rettype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          Tpl_pushIter_rettype tmp34;
          SimCodeC_lm__458_rettype tmp35;
          Tpl_popIter_rettype tmp36;
          Tpl_softNewLine_rettype tmp37;
          SimCodeC_fun__459_rettype tmp38;
          Tpl_softNewLine_rettype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          Tpl_pushIter_rettype tmp44;
          SimCodeC_lm__460_rettype tmp45;
          Tpl_popIter_rettype tmp46;
          Tpl_softNewLine_rettype tmp47;
          Tpl_writeText_rettype tmp48;
          Tpl_writeStr_rettype tmp49;
          modelica_metatype tmp50;
          Tpl_writeTok_rettype tmp51;
          Tpl_writeText_rettype tmp52;
          modelica_metatype tmp53;
          Tpl_writeTok_rettype tmp54;
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          Tpl_pushIter_rettype tmp59;
          SimCodeC_lm__461_rettype tmp60;
          Tpl_popIter_rettype tmp61;
          Tpl_softNewLine_rettype tmp62;
          SimCodeC_fun__462_rettype tmp63;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = mmc_unbox_string(tmp7);
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extName = tmp8;
          _i_extArgs = tmp10;
          _i_extReturn = tmp11;
          _i_biVars = tmp14;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp16, tmp17);
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp22 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp19), mmc_mk_integer(0), mmc_mk_integer(0), tmp20, mmc_mk_integer(0), tmp21);
          tmp23 = _Tpl_pushIter(tmp18, tmp22);
          _l_args = tmp23.Tpl_pushIter_rettype_1;
          tmp24 = _SimCodeC_lm__456(_l_args, _i_extArgs, _a_varDecls, _a_preExp);
          _l_args = tmp24.targ1;
          _a_varDecls = tmp24.targ2;
          _a_preExp = tmp24.targ3;
          tmp25 = _Tpl_popIter(_l_args);
          _l_args = tmp25.Tpl_popIter_rettype_1;
          tmp26 = mmc_mk_nil();
          tmp27 = mmc_mk_nil();
          tmp28 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp26, tmp27);
          tmp29 = _SimCodeC_fun__457(tmp28, _i_extReturn);
          _l_returnAssign = tmp29.SimCodeC_fun__457_rettype_1;
          tmp30 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp31 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp32 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp33 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp30), mmc_mk_integer(0), mmc_mk_integer(0), tmp31, mmc_mk_integer(0), tmp32);
          tmp34 = _Tpl_pushIter(_txt, tmp33);
          _txt = tmp34.Tpl_pushIter_rettype_1;
          tmp35 = _SimCodeC_lm__458(_txt, _i_extArgs, _a_varDecls);
          _txt = tmp35.targ1;
          _a_varDecls = tmp35.targ2;
          tmp36 = _Tpl_popIter(_txt);
          _txt = tmp36.Tpl_popIter_rettype_1;
          tmp37 = _Tpl_softNewLine(_txt);
          _txt = tmp37.Tpl_softNewLine_rettype_1;
          tmp38 = _SimCodeC_fun__459(_txt, _i_extReturn, _a_varDecls);
          _txt = tmp38.targ1;
          _a_varDecls = tmp38.targ2;
          tmp39 = _Tpl_softNewLine(_txt);
          _txt = tmp39.Tpl_softNewLine_rettype_1;
          tmp40 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp41 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp42 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp43 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp40), mmc_mk_integer(0), mmc_mk_integer(0), tmp41, mmc_mk_integer(0), tmp42);
          tmp44 = _Tpl_pushIter(_txt, tmp43);
          _txt = tmp44.Tpl_pushIter_rettype_1;
          tmp45 = _SimCodeC_lm__460(_txt, _i_biVars, _a_varDecls, _a_preExp);
          _txt = tmp45.targ1;
          _a_varDecls = tmp45.targ2;
          _a_preExp = tmp45.targ3;
          tmp46 = _Tpl_popIter(_txt);
          _txt = tmp46.Tpl_popIter_rettype_1;
          tmp47 = _Tpl_softNewLine(_txt);
          _txt = tmp47.Tpl_softNewLine_rettype_1;
          tmp48 = _Tpl_writeText(_txt, _l_returnAssign);
          _txt = tmp48.Tpl_writeText_rettype_1;
          tmp49 = _Tpl_writeStr(_txt, _i_extName);
          _txt = tmp49.Tpl_writeStr_rettype_1;
          tmp50 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_("));
          tmp51 = _Tpl_writeTok(_txt, tmp50);
          _txt = tmp51.Tpl_writeTok_rettype_1;
          tmp52 = _Tpl_writeText(_txt, _l_args);
          _txt = tmp52.Tpl_writeText_rettype_1;
          tmp53 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(");\n"));
          tmp54 = _Tpl_writeTok(_txt, tmp53);
          _txt = tmp54.Tpl_writeTok_rettype_1;
          tmp55 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp56 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp57 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp58 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp55), mmc_mk_integer(0), mmc_mk_integer(0), tmp56, mmc_mk_integer(0), tmp57);
          tmp59 = _Tpl_pushIter(_txt, tmp58);
          _txt = tmp59.Tpl_pushIter_rettype_1;
          tmp60 = _SimCodeC_lm__461(_txt, _i_extArgs);
          _txt = tmp60.SimCodeC_lm__461_rettype_1;
          tmp61 = _Tpl_popIter(_txt);
          _txt = tmp61.Tpl_popIter_rettype_1;
          tmp62 = _Tpl_softNewLine(_txt);
          _txt = tmp62.Tpl_softNewLine_rettype_1;
          tmp63 = _SimCodeC_fun__462(_txt, _i_extReturn);
          _txt = tmp63.SimCodeC_fun__462_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extFunCallF77_rettypeboxed boxptr_SimCodeC_extFunCallF77(modelica_metatype _in_txt, modelica_metatype _in_a_fun, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallF77_rettypeboxed tmp1;
  SimCodeC_extFunCallF77_rettype tmp2;
  tmp2 = _SimCodeC_extFunCallF77(_in_txt, _in_a_fun, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_extFunCallF77_rettypeboxed_1 = tmp2.SimCodeC_extFunCallF77_rettype_1;
  tmp1.SimCodeC_extFunCallF77_rettypeboxed_2 = tmp2.SimCodeC_extFunCallF77_rettype_2;
  tmp1.SimCodeC_extFunCallF77_rettypeboxed_3 = tmp2.SimCodeC_extFunCallF77_rettype_3;
  return tmp1;
}
SimCodeC_fun__462_rettype _SimCodeC_fun__462(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__462_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extReturn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_extReturn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_extFunCallVarcopyF77_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extReturn = tmp3_in1;
          tmp11 = _SimCodeC_extFunCallVarcopyF77(_txt, _i_extReturn);
          _txt = tmp11.SimCodeC_extFunCallVarcopyF77_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__462_rettypeboxed boxptr_SimCodeC_fun__462(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__462_rettypeboxed tmp1;
  SimCodeC_fun__462_rettype tmp2;
  tmp2 = _SimCodeC_fun__462(_in_txt, _in_a_extReturn);
  tmp1.SimCodeC_fun__462_rettypeboxed_1 = tmp2.SimCodeC_fun__462_rettype_1;
  return tmp1;
}
SimCodeC_extFunCallVarcopyF77_rettype _SimCodeC_extFunCallVarcopyF77(modelica_metatype _in_txt, modelica_metatype _in_a_arg)
{
  SimCodeC_extFunCallVarcopyF77_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_arg;
    {
      modelica_metatype _txt;
      modelica_metatype _i_ty;
      modelica_boolean _i_ai;
      modelica_metatype _i_c;
      modelica_integer _i_oi;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_integer tmp9;
          modelica_metatype tmp10;
          modelica_integer tmp11;
          modelica_metatype tmp12;
          SimCodeC_fun__477_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = mmc_unbox_integer(tmp8);
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = mmc_unbox_integer(tmp10);
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_oi = tmp9;
          _i_ai = tmp11;
          _i_ty = tmp12;
          tmp13 = _SimCodeC_fun__477(_txt, (modelica_integer)_i_oi, _i_ty, _i_ai, _i_c);
          _txt = tmp13.SimCodeC_fun__477_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extFunCallVarcopyF77_rettypeboxed boxptr_SimCodeC_extFunCallVarcopyF77(modelica_metatype _in_txt, modelica_metatype _in_a_arg)
{
  SimCodeC_extFunCallVarcopyF77_rettypeboxed tmp1;
  SimCodeC_extFunCallVarcopyF77_rettype tmp2;
  tmp2 = _SimCodeC_extFunCallVarcopyF77(_in_txt, _in_a_arg);
  tmp1.SimCodeC_extFunCallVarcopyF77_rettypeboxed_1 = tmp2.SimCodeC_extFunCallVarcopyF77_rettype_1;
  return tmp1;
}
SimCodeC_fun__477_rettype _SimCodeC_fun__477(modelica_metatype _in_txt, modelica_integer _in_a_oi, modelica_metatype _in_a_ty, modelica_boolean _in_a_ai, modelica_metatype _in_a_c)
{
  SimCodeC_fun__477_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_boolean tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    tmp3_in2 = _in_a_ty;
    tmp3_in3 = _in_a_ai;
    tmp3_in4 = _in_a_c;
    {
      modelica_metatype _txt;
      modelica_metatype _a_ty;
      modelica_boolean _a_ai;
      modelica_metatype _a_c;
      modelica_integer _i_oi;
      modelica_metatype _l_ext__name;
      modelica_metatype _l_outarg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (0 != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          intString_rettype tmp11;
          Tpl_writeStr_rettype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          SimCodeC_contextCref_rettype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          SimCodeC_fun__476_rettype tmp20;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_oi = tmp3_in1;
          _a_ty = tmp3_in2;
          _a_ai = tmp3_in3;
          _a_c = tmp3_in4;
          tmp6 = mmc_mk_nil();
          tmp7 = mmc_mk_nil();
          tmp8 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp6, tmp7);
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("out.targ"));
          tmp10 = _Tpl_writeTok(tmp8, tmp9);
          _l_outarg = tmp10.Tpl_writeTok_rettype_1;
          tmp11 = intString((modelica_integer)_i_oi);
          tmp12 = _Tpl_writeStr(_l_outarg, tmp11);
          _l_outarg = tmp12.Tpl_writeStr_rettype_1;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp17 = _SimCodeC_contextCref(tmp15, _a_c, tmp16);
          _l_ext__name = tmp17.SimCodeC_contextCref_rettype_1;
          tmp18 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext"));
          tmp19 = _Tpl_writeTok(_l_ext__name, tmp18);
          _l_ext__name = tmp19.Tpl_writeTok_rettype_1;
          tmp20 = _SimCodeC_fun__476(_txt, _a_ai, _l_ext__name, _a_ty, _l_outarg);
          _txt = tmp20.SimCodeC_fun__476_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__477_rettypeboxed boxptr_SimCodeC_fun__477(modelica_metatype _in_txt, modelica_metatype _in_a_oi, modelica_metatype _in_a_ty, modelica_metatype _in_a_ai, modelica_metatype _in_a_c)
{
  SimCodeC_fun__477_rettypeboxed tmp1;
  SimCodeC_fun__477_rettype tmp2;
  modelica_integer tmp3;
  modelica_integer tmp4;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp4 = mmc_unbox_integer(_in_a_ai);
  tmp2 = _SimCodeC_fun__477(_in_txt, tmp3, _in_a_ty, tmp4, _in_a_c);
  tmp1.SimCodeC_fun__477_rettypeboxed_1 = tmp2.SimCodeC_fun__477_rettype_1;
  return tmp1;
}
SimCodeC_fun__476_rettype _SimCodeC_fun__476(modelica_metatype _in_txt, modelica_boolean _in_a_ai, modelica_metatype _in_a_ext__name, modelica_metatype _in_a_ty, modelica_metatype _in_a_outarg)
{
  SimCodeC_fun__476_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_ai;
    tmp3_in2 = _in_a_ext__name;
    tmp3_in3 = _in_a_ty;
    tmp3_in4 = _in_a_outarg;
    {
      modelica_metatype _txt;
      modelica_metatype _a_ext__name;
      modelica_metatype _a_ty;
      modelica_metatype _a_outarg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          Tpl_writeText_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          SimCodeC_expTypeModelica_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          Tpl_writeText_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_ext__name = tmp3_in2;
          _a_ty = tmp3_in3;
          _a_outarg = tmp3_in4;
          tmp6 = _Tpl_writeText(_txt, _a_outarg);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = ("));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp9 = _SimCodeC_expTypeModelica(_txt, _a_ty);
          _txt = tmp9.SimCodeC_expTypeModelica_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = _Tpl_writeText(_txt, _a_ext__name);
          _txt = tmp12.Tpl_writeText_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp16 = _Tpl_writeTok(_txt, tmp15);
          _txt = tmp16.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          SimCodeC_expTypeArray_rettype tmp19;
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          Tpl_writeText_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          Tpl_writeText_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          if (true != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_ext__name = tmp3_in2;
          _a_ty = tmp3_in3;
          _a_outarg = tmp3_in4;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("convert_alloc_"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp19 = _SimCodeC_expTypeArray(_txt, _a_ty);
          _txt = tmp19.SimCodeC_expTypeArray_rettype_1;
          tmp20 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_from_f77(&"));
          tmp21 = _Tpl_writeTok(_txt, tmp20);
          _txt = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = _Tpl_writeText(_txt, _a_ext__name);
          _txt = tmp22.Tpl_writeText_rettype_1;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", &"));
          tmp24 = _Tpl_writeTok(_txt, tmp23);
          _txt = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = _Tpl_writeText(_txt, _a_outarg);
          _txt = tmp25.Tpl_writeText_rettype_1;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__476_rettypeboxed boxptr_SimCodeC_fun__476(modelica_metatype _in_txt, modelica_metatype _in_a_ai, modelica_metatype _in_a_ext__name, modelica_metatype _in_a_ty, modelica_metatype _in_a_outarg)
{
  SimCodeC_fun__476_rettypeboxed tmp1;
  SimCodeC_fun__476_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_ai);
  tmp2 = _SimCodeC_fun__476(_in_txt, tmp3, _in_a_ext__name, _in_a_ty, _in_a_outarg);
  tmp1.SimCodeC_fun__476_rettypeboxed_1 = tmp2.SimCodeC_fun__476_rettype_1;
  return tmp1;
}
SimCodeC_lm__461_rettype _SimCodeC_lm__461(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__461_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extFunCallVarcopyF77_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__461_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_extFunCallVarcopyF77(_txt, _i_arg);
          _txt = tmp8.SimCodeC_extFunCallVarcopyF77_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__461(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__461_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__461_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__461(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__461_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__461_rettypeboxed boxptr_SimCodeC_lm__461(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__461_rettypeboxed tmp1;
  SimCodeC_lm__461_rettype tmp2;
  tmp2 = _SimCodeC_lm__461(_in_txt, _in_items);
  tmp1.SimCodeC_lm__461_rettypeboxed_1 = tmp2.SimCodeC_lm__461_rettype_1;
  return tmp1;
}
SimCodeC_lm__460_rettype _SimCodeC_lm__460(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__460_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extFunCallBiVarF77_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__460_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp8 = _SimCodeC_extFunCallBiVarF77(_txt, _i_arg, _a_preExp, _a_varDecls);
          _txt = tmp8.targ1;
          _a_preExp = tmp8.targ2;
          _a_varDecls = tmp8.targ3;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__460(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          _a_preExp = tmp10.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__460_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp13 = _SimCodeC_lm__460(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          _a_preExp = tmp13.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_lm__460_rettypeboxed boxptr_SimCodeC_lm__460(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__460_rettypeboxed tmp1;
  SimCodeC_lm__460_rettype tmp2;
  tmp2 = _SimCodeC_lm__460(_in_txt, _in_items, _in_a_varDecls, _in_a_preExp);
  tmp1.SimCodeC_lm__460_rettypeboxed_1 = tmp2.SimCodeC_lm__460_rettype_1;
  tmp1.SimCodeC_lm__460_rettypeboxed_2 = tmp2.SimCodeC_lm__460_rettype_2;
  tmp1.SimCodeC_lm__460_rettypeboxed_3 = tmp2.SimCodeC_lm__460_rettype_3;
  return tmp1;
}
SimCodeC_extFunCallBiVarF77_rettype _SimCodeC_extFunCallBiVarF77(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallBiVarF77_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    tmp3_in2 = _in_a_preExp;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_var_ty;
      modelica_metatype _i_instDims;
      modelica_metatype _i_value;
      modelica_metatype _i_var;
      modelica_metatype _i_name;
      modelica_metatype _l_instDimsInit;
      modelica_metatype _l_defaultValue;
      modelica_metatype _l_var__name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_contextCref_rettype tmp14;
          SimCodeC_varType_rettype tmp15;
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          Tpl_writeText_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          SimCodeC_varType_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          SimCodeC_extVarName_rettype tmp26;
          modelica_metatype tmp27;
          Tpl_writeTok_rettype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          SimCodeC_fun__470_rettype tmp34;
          Tpl_writeText_rettype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          Tpl_pushIter_rettype tmp43;
          SimCodeC_lm__471_rettype tmp44;
          Tpl_popIter_rettype tmp45;
          SimCodeC_fun__472_rettype tmp46;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp3_in1;
          _i_name = tmp6;
          _i_var_ty = tmp7;
          _i_value = tmp8;
          _i_instDims = tmp9;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp10, tmp11);
          tmp13 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp14 = _SimCodeC_contextCref(tmp12, _i_name, tmp13);
          _l_var__name = tmp14.SimCodeC_contextCref_rettype_1;
          tmp15 = _SimCodeC_varType(_a_varDecls, _i_var);
          _a_varDecls = tmp15.SimCodeC_varType_rettype_1;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp17 = _Tpl_writeTok(_a_varDecls, tmp16);
          _a_varDecls = tmp17.Tpl_writeTok_rettype_1;
          tmp18 = _Tpl_writeText(_a_varDecls, _l_var__name);
          _a_varDecls = tmp18.Tpl_writeText_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp20 = _Tpl_writeTok(_a_varDecls, tmp19);
          _a_varDecls = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp22 = _Tpl_writeTok(_a_varDecls, tmp21);
          _a_varDecls = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _SimCodeC_varType(_a_varDecls, _i_var);
          _a_varDecls = tmp23.SimCodeC_varType_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp25 = _Tpl_writeTok(_a_varDecls, tmp24);
          _a_varDecls = tmp25.Tpl_writeTok_rettype_1;
          tmp26 = _SimCodeC_extVarName(_a_varDecls, _i_name);
          _a_varDecls = tmp26.SimCodeC_extVarName_rettype_1;
          tmp27 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp28 = _Tpl_writeTok(_a_varDecls, tmp27);
          _a_varDecls = tmp28.Tpl_writeTok_rettype_1;
          tmp29 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp30 = _Tpl_writeTok(_a_varDecls, tmp29);
          _a_varDecls = tmp30.Tpl_writeTok_rettype_1;
          tmp31 = mmc_mk_nil();
          tmp32 = mmc_mk_nil();
          tmp33 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp31, tmp32);
          tmp34 = _SimCodeC_fun__470(tmp33, _i_value, _a_varDecls, _a_preExp, _l_var__name);
          _l_defaultValue = tmp34.targ1;
          _a_varDecls = tmp34.targ2;
          _a_preExp = tmp34.targ3;
          tmp35 = _Tpl_writeText(_a_preExp, _l_defaultValue);
          _a_preExp = tmp35.Tpl_writeText_rettype_1;
          tmp36 = mmc_mk_nil();
          tmp37 = mmc_mk_nil();
          tmp38 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp36, tmp37);
          tmp39 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp40 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp41 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp42 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp39), mmc_mk_integer(0), mmc_mk_integer(0), tmp40, mmc_mk_integer(0), tmp41);
          tmp43 = _Tpl_pushIter(tmp38, tmp42);
          _l_instDimsInit = tmp43.Tpl_pushIter_rettype_1;
          tmp44 = _SimCodeC_lm__471(_l_instDimsInit, _i_instDims, _a_varDecls, _a_preExp);
          _l_instDimsInit = tmp44.targ1;
          _a_varDecls = tmp44.targ2;
          _a_preExp = tmp44.targ3;
          tmp45 = _Tpl_popIter(_l_instDimsInit);
          _l_instDimsInit = tmp45.Tpl_popIter_rettype_1;
          tmp46 = _SimCodeC_fun__472(_txt, _i_instDims, _i_name, _l_instDimsInit, _l_var__name, _a_preExp, _i_var_ty);
          _txt = tmp46.targ1;
          _a_preExp = tmp46.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extFunCallBiVarF77_rettypeboxed boxptr_SimCodeC_extFunCallBiVarF77(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallBiVarF77_rettypeboxed tmp1;
  SimCodeC_extFunCallBiVarF77_rettype tmp2;
  tmp2 = _SimCodeC_extFunCallBiVarF77(_in_txt, _in_a_var, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_extFunCallBiVarF77_rettypeboxed_1 = tmp2.SimCodeC_extFunCallBiVarF77_rettype_1;
  tmp1.SimCodeC_extFunCallBiVarF77_rettypeboxed_2 = tmp2.SimCodeC_extFunCallBiVarF77_rettype_2;
  tmp1.SimCodeC_extFunCallBiVarF77_rettypeboxed_3 = tmp2.SimCodeC_extFunCallBiVarF77_rettype_3;
  return tmp1;
}
SimCodeC_fun__472_rettype _SimCodeC_fun__472(modelica_metatype _in_txt, modelica_metatype _in_a_instDims, modelica_metatype _in_a_name, modelica_metatype _in_a_instDimsInit, modelica_metatype _in_a_var__name, modelica_metatype _in_a_preExp, modelica_metatype _in_a_var_ty)
{
  SimCodeC_fun__472_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    modelica_metatype tmp3_in6;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_instDims;
    tmp3_in2 = _in_a_name;
    tmp3_in3 = _in_a_instDimsInit;
    tmp3_in4 = _in_a_var__name;
    tmp3_in5 = _in_a_preExp;
    tmp3_in6 = _in_a_var_ty;
    {
      modelica_metatype _txt;
      modelica_metatype _a_name;
      modelica_metatype _a_instDimsInit;
      modelica_metatype _a_var__name;
      modelica_metatype _a_preExp;
      modelica_metatype _a_var_ty;
      modelica_metatype _i_instDims;
      modelica_integer _ret_1;
      modelica_metatype _l_type;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in5;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          SimCodeC_expTypeArray_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          Tpl_writeText_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          Tpl_writeText_rettype tmp15;
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          listLength_rettype tmp18;
          intString_rettype tmp19;
          Tpl_writeStr_rettype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          Tpl_writeText_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          modelica_metatype tmp28;
          Tpl_writeTok_rettype tmp29;
          Tpl_writeText_rettype tmp30;
          modelica_metatype tmp31;
          Tpl_writeTok_rettype tmp32;
          Tpl_writeText_rettype tmp33;
          modelica_metatype tmp34;
          Tpl_writeTok_rettype tmp35;
          SimCodeC_extVarName_rettype tmp36;
          modelica_metatype tmp37;
          Tpl_writeTok_rettype tmp38;
          modelica_metatype tmp39;
          Tpl_writeTok_rettype tmp40;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_instDims = tmp3_in1;
          _a_name = tmp3_in2;
          _a_instDimsInit = tmp3_in3;
          _a_var__name = tmp3_in4;
          _a_preExp = tmp3_in5;
          _a_var_ty = tmp3_in6;
          tmp6 = mmc_mk_nil();
          tmp7 = mmc_mk_nil();
          tmp8 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp6, tmp7);
          tmp9 = _SimCodeC_expTypeArray(tmp8, _a_var_ty);
          _l_type = tmp9.SimCodeC_expTypeArray_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("alloc_"));
          tmp11 = _Tpl_writeTok(_a_preExp, tmp10);
          _a_preExp = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = _Tpl_writeText(_a_preExp, _l_type);
          _a_preExp = tmp12.Tpl_writeText_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(&"));
          tmp14 = _Tpl_writeTok(_a_preExp, tmp13);
          _a_preExp = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = _Tpl_writeText(_a_preExp, _a_var__name);
          _a_preExp = tmp15.Tpl_writeText_rettype_1;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp17 = _Tpl_writeTok(_a_preExp, tmp16);
          _a_preExp = tmp17.Tpl_writeTok_rettype_1;
          tmp18 = listLength(_i_instDims);
          _ret_1 = tmp18;
          tmp19 = intString((modelica_integer)_ret_1);
          tmp20 = _Tpl_writeStr(_a_preExp, tmp19);
          _a_preExp = tmp20.Tpl_writeStr_rettype_1;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp22 = _Tpl_writeTok(_a_preExp, tmp21);
          _a_preExp = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _Tpl_writeText(_a_preExp, _a_instDimsInit);
          _a_preExp = tmp23.Tpl_writeText_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp25 = _Tpl_writeTok(_a_preExp, tmp24);
          _a_preExp = tmp25.Tpl_writeTok_rettype_1;
          tmp26 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp27 = _Tpl_writeTok(_a_preExp, tmp26);
          _a_preExp = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("convert_alloc_"));
          tmp29 = _Tpl_writeTok(_a_preExp, tmp28);
          _a_preExp = tmp29.Tpl_writeTok_rettype_1;
          tmp30 = _Tpl_writeText(_a_preExp, _l_type);
          _a_preExp = tmp30.Tpl_writeText_rettype_1;
          tmp31 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_to_f77(&"));
          tmp32 = _Tpl_writeTok(_a_preExp, tmp31);
          _a_preExp = tmp32.Tpl_writeTok_rettype_1;
          tmp33 = _Tpl_writeText(_a_preExp, _a_var__name);
          _a_preExp = tmp33.Tpl_writeText_rettype_1;
          tmp34 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", &"));
          tmp35 = _Tpl_writeTok(_a_preExp, tmp34);
          _a_preExp = tmp35.Tpl_writeTok_rettype_1;
          tmp36 = _SimCodeC_extVarName(_a_preExp, _a_name);
          _a_preExp = tmp36.SimCodeC_extVarName_rettype_1;
          tmp37 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp38 = _Tpl_writeTok(_a_preExp, tmp37);
          _a_preExp = tmp38.Tpl_writeTok_rettype_1;
          tmp39 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp40 = _Tpl_writeTok(_a_preExp, tmp39);
          _a_preExp = tmp40.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  return tmp1;
}


SimCodeC_fun__472_rettypeboxed boxptr_SimCodeC_fun__472(modelica_metatype _in_txt, modelica_metatype _in_a_instDims, modelica_metatype _in_a_name, modelica_metatype _in_a_instDimsInit, modelica_metatype _in_a_var__name, modelica_metatype _in_a_preExp, modelica_metatype _in_a_var_ty)
{
  SimCodeC_fun__472_rettypeboxed tmp1;
  SimCodeC_fun__472_rettype tmp2;
  tmp2 = _SimCodeC_fun__472(_in_txt, _in_a_instDims, _in_a_name, _in_a_instDimsInit, _in_a_var__name, _in_a_preExp, _in_a_var_ty);
  tmp1.SimCodeC_fun__472_rettypeboxed_1 = tmp2.SimCodeC_fun__472_rettype_1;
  tmp1.SimCodeC_fun__472_rettypeboxed_2 = tmp2.SimCodeC_fun__472_rettype_2;
  return tmp1;
}
SimCodeC_lm__471_rettype _SimCodeC_lm__471(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__471_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _i_exp;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          SimCodeC_daeExp_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__471_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp8 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp9 = _SimCodeC_daeExp(_txt, _i_exp, tmp8, _a_preExp, _a_varDecls);
          _txt = tmp9.targ1;
          _a_preExp = tmp9.targ2;
          _a_varDecls = tmp9.targ3;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__471(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp11.targ1;
          _a_varDecls = tmp11.targ2;
          _a_preExp = tmp11.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__471_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp14 = _SimCodeC_lm__471(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp14.targ1;
          _a_varDecls = tmp14.targ2;
          _a_preExp = tmp14.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_lm__471_rettypeboxed boxptr_SimCodeC_lm__471(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__471_rettypeboxed tmp1;
  SimCodeC_lm__471_rettype tmp2;
  tmp2 = _SimCodeC_lm__471(_in_txt, _in_items, _in_a_varDecls, _in_a_preExp);
  tmp1.SimCodeC_lm__471_rettypeboxed_1 = tmp2.SimCodeC_lm__471_rettype_1;
  tmp1.SimCodeC_lm__471_rettypeboxed_2 = tmp2.SimCodeC_lm__471_rettype_2;
  tmp1.SimCodeC_lm__471_rettypeboxed_3 = tmp2.SimCodeC_lm__471_rettype_3;
  return tmp1;
}
SimCodeC_fun__470_rettype _SimCodeC_fun__470(modelica_metatype _in_txt, modelica_metatype _in_a_value, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_var__name)
{
  SimCodeC_fun__470_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_value;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_var__name;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _a_var__name;
      modelica_metatype _i_v;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeText_rettype tmp7;
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          modelica_metatype tmp10;
          SimCodeC_daeExp_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          if (optionNone(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 1));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_v = tmp6;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_var__name = tmp3_in4;
          tmp7 = _Tpl_writeText(_txt, _a_var__name);
          _txt = tmp7.Tpl_writeText_rettype_1;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp10 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp11 = _SimCodeC_daeExp(_txt, _i_v, tmp10, _a_preExp, _a_varDecls);
          _txt = tmp11.targ1;
          _a_preExp = tmp11.targ2;
          _a_varDecls = tmp11.targ3;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp14 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_fun__470_rettypeboxed boxptr_SimCodeC_fun__470(modelica_metatype _in_txt, modelica_metatype _in_a_value, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_var__name)
{
  SimCodeC_fun__470_rettypeboxed tmp1;
  SimCodeC_fun__470_rettype tmp2;
  tmp2 = _SimCodeC_fun__470(_in_txt, _in_a_value, _in_a_varDecls, _in_a_preExp, _in_a_var__name);
  tmp1.SimCodeC_fun__470_rettypeboxed_1 = tmp2.SimCodeC_fun__470_rettype_1;
  tmp1.SimCodeC_fun__470_rettypeboxed_2 = tmp2.SimCodeC_fun__470_rettype_2;
  tmp1.SimCodeC_fun__470_rettypeboxed_3 = tmp2.SimCodeC_fun__470_rettype_3;
  return tmp1;
}
SimCodeC_fun__459_rettype _SimCodeC_fun__459(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__459_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extReturn;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_extReturn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_extFunCallVardeclF77_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extReturn = tmp3_in1;
          _a_varDecls = tmp3_in2;
          tmp11 = _SimCodeC_extFunCallVardeclF77(_txt, _i_extReturn, _a_varDecls);
          _txt = tmp11.targ1;
          _a_varDecls = tmp11.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__459_rettypeboxed boxptr_SimCodeC_fun__459(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__459_rettypeboxed tmp1;
  SimCodeC_fun__459_rettype tmp2;
  tmp2 = _SimCodeC_fun__459(_in_txt, _in_a_extReturn, _in_a_varDecls);
  tmp1.SimCodeC_fun__459_rettypeboxed_1 = tmp2.SimCodeC_fun__459_rettype_1;
  tmp1.SimCodeC_fun__459_rettypeboxed_2 = tmp2.SimCodeC_fun__459_rettype_2;
  return tmp1;
}
SimCodeC_extFunCallVardeclF77_rettype _SimCodeC_extFunCallVardeclF77(modelica_metatype _in_txt, modelica_metatype _in_a_arg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallVardeclF77_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_arg;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_boolean _i_ia;
      modelica_integer _i_oi;
      modelica_metatype _i_c;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_integer tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_integer tmp11;
          modelica_metatype tmp12;
          SimCodeC_expTypeArrayIf_rettype tmp13;
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          SimCodeC_extVarName_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          SimCodeC_expTypeArray_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          modelica_metatype tmp26;
          SimCodeC_contextCref_rettype tmp27;
          modelica_metatype tmp28;
          Tpl_writeTok_rettype tmp29;
          SimCodeC_extVarName_rettype tmp30;
          modelica_metatype tmp31;
          Tpl_writeTok_rettype tmp32;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = mmc_unbox_integer(tmp7);
          if (true != tmp8) MMC_THROW();
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = mmc_unbox_integer(tmp10);
          if (true != tmp11) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_ty = tmp12;
          _a_varDecls = tmp3_in2;
          tmp13 = _SimCodeC_expTypeArrayIf(_a_varDecls, _i_ty);
          _a_varDecls = tmp13.SimCodeC_expTypeArrayIf_rettype_1;
          tmp14 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp15 = _Tpl_writeTok(_a_varDecls, tmp14);
          _a_varDecls = tmp15.Tpl_writeTok_rettype_1;
          tmp16 = _SimCodeC_extVarName(_a_varDecls, _i_c);
          _a_varDecls = tmp16.SimCodeC_extVarName_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp18 = _Tpl_writeTok(_a_varDecls, tmp17);
          _a_varDecls = tmp18.Tpl_writeTok_rettype_1;
          tmp19 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp20 = _Tpl_writeTok(_a_varDecls, tmp19);
          _a_varDecls = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("convert_alloc_"));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _SimCodeC_expTypeArray(_txt, _i_ty);
          _txt = tmp23.SimCodeC_expTypeArray_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_to_f77(&"));
          tmp25 = _Tpl_writeTok(_txt, tmp24);
          _txt = tmp25.Tpl_writeTok_rettype_1;
          tmp26 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp27 = _SimCodeC_contextCref(_txt, _i_c, tmp26);
          _txt = tmp27.SimCodeC_contextCref_rettype_1;
          tmp28 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", &"));
          tmp29 = _Tpl_writeTok(_txt, tmp28);
          _txt = tmp29.Tpl_writeTok_rettype_1;
          tmp30 = _SimCodeC_extVarName(_txt, _i_c);
          _txt = tmp30.SimCodeC_extVarName_rettype_1;
          tmp31 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp32 = _Tpl_writeTok(_txt, tmp31);
          _txt = tmp32.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_integer tmp36;
          modelica_metatype tmp37;
          modelica_integer tmp38;
          modelica_metatype tmp39;
          SimCodeC_fun__468_rettype tmp40;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp34 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp36 = mmc_unbox_integer(tmp35);
          tmp37 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp38 = mmc_unbox_integer(tmp37);
          tmp39 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp33;
          _i_oi = tmp36;
          _i_ia = tmp38;
          _i_ty = tmp39;
          _a_varDecls = tmp3_in2;
          tmp40 = _SimCodeC_fun__468(_txt, (modelica_integer)_i_oi, _i_c, _i_ty, _a_varDecls, _i_ia);
          _txt = tmp40.targ1;
          _a_varDecls = tmp40.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          SimCodeC_extType_rettype tmp46;
          modelica_metatype tmp47;
          Tpl_writeTok_rettype tmp48;
          SimCodeC_extVarName_rettype tmp49;
          modelica_metatype tmp50;
          Tpl_writeTok_rettype tmp51;
          modelica_metatype tmp52;
          Tpl_writeTok_rettype tmp53;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp41 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp42 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp43 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp44 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp45 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp41;
          _i_ty = tmp45;
          _a_varDecls = tmp3_in2;
          tmp46 = _SimCodeC_extType(_a_varDecls, _i_ty);
          _a_varDecls = tmp46.SimCodeC_extType_rettype_1;
          tmp47 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp48 = _Tpl_writeTok(_a_varDecls, tmp47);
          _a_varDecls = tmp48.Tpl_writeTok_rettype_1;
          tmp49 = _SimCodeC_extVarName(_a_varDecls, _i_c);
          _a_varDecls = tmp49.SimCodeC_extVarName_rettype_1;
          tmp50 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp51 = _Tpl_writeTok(_a_varDecls, tmp50);
          _a_varDecls = tmp51.Tpl_writeTok_rettype_1;
          tmp52 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp53 = _Tpl_writeTok(_a_varDecls, tmp52);
          _a_varDecls = tmp53.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extFunCallVardeclF77_rettypeboxed boxptr_SimCodeC_extFunCallVardeclF77(modelica_metatype _in_txt, modelica_metatype _in_a_arg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallVardeclF77_rettypeboxed tmp1;
  SimCodeC_extFunCallVardeclF77_rettype tmp2;
  tmp2 = _SimCodeC_extFunCallVardeclF77(_in_txt, _in_a_arg, _in_a_varDecls);
  tmp1.SimCodeC_extFunCallVardeclF77_rettypeboxed_1 = tmp2.SimCodeC_extFunCallVardeclF77_rettype_1;
  tmp1.SimCodeC_extFunCallVardeclF77_rettypeboxed_2 = tmp2.SimCodeC_extFunCallVardeclF77_rettype_2;
  return tmp1;
}
SimCodeC_fun__468_rettype _SimCodeC_fun__468(modelica_metatype _in_txt, modelica_integer _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty, modelica_metatype _in_a_varDecls, modelica_boolean _in_a_ia)
{
  SimCodeC_fun__468_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_boolean tmp3_in5;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    tmp3_in2 = _in_a_c;
    tmp3_in3 = _in_a_ty;
    tmp3_in4 = _in_a_varDecls;
    tmp3_in5 = _in_a_ia;
    {
      modelica_metatype _txt;
      modelica_metatype _a_c;
      modelica_metatype _a_ty;
      modelica_metatype _a_varDecls;
      modelica_boolean _a_ia;
      modelica_integer _i_oi;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (0 != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_fun__467_rettype tmp6;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_oi = tmp3_in1;
          _a_c = tmp3_in2;
          _a_ty = tmp3_in3;
          _a_varDecls = tmp3_in4;
          _a_ia = tmp3_in5;
          tmp6 = _SimCodeC_fun__467(_txt, _a_ia, (modelica_integer)_i_oi, _a_c, _a_ty, _a_varDecls);
          _txt = tmp6.targ1;
          _a_varDecls = tmp6.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__468_rettypeboxed boxptr_SimCodeC_fun__468(modelica_metatype _in_txt, modelica_metatype _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_ia)
{
  SimCodeC_fun__468_rettypeboxed tmp1;
  SimCodeC_fun__468_rettype tmp2;
  modelica_integer tmp3;
  modelica_integer tmp4;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp4 = mmc_unbox_integer(_in_a_ia);
  tmp2 = _SimCodeC_fun__468(_in_txt, tmp3, _in_a_c, _in_a_ty, _in_a_varDecls, tmp4);
  tmp1.SimCodeC_fun__468_rettypeboxed_1 = tmp2.SimCodeC_fun__468_rettype_1;
  tmp1.SimCodeC_fun__468_rettypeboxed_2 = tmp2.SimCodeC_fun__468_rettype_2;
  return tmp1;
}
SimCodeC_fun__467_rettype _SimCodeC_fun__467(modelica_metatype _in_txt, modelica_boolean _in_a_ia, modelica_integer _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__467_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_integer tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_ia;
    tmp3_in2 = (modelica_integer)_in_a_oi;
    tmp3_in3 = _in_a_c;
    tmp3_in4 = _in_a_ty;
    tmp3_in5 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_integer _a_oi;
      modelica_metatype _a_c;
      modelica_metatype _a_ty;
      modelica_metatype _a_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_extType_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          SimCodeC_extVarName_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_c = tmp3_in3;
          _a_ty = tmp3_in4;
          _a_varDecls = tmp3_in5;
          tmp6 = _SimCodeC_extType(_a_varDecls, _a_ty);
          _a_varDecls = tmp6.SimCodeC_extType_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp8 = _Tpl_writeTok(_a_varDecls, tmp7);
          _a_varDecls = tmp8.Tpl_writeTok_rettype_1;
          tmp9 = _SimCodeC_extVarName(_a_varDecls, _a_c);
          _a_varDecls = tmp9.SimCodeC_extVarName_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp11 = _Tpl_writeTok(_a_varDecls, tmp10);
          _a_varDecls = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp13 = _Tpl_writeTok(_a_varDecls, tmp12);
          _a_varDecls = tmp13.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_expTypeArrayIf_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          SimCodeC_extVarName_rettype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          modelica_metatype tmp22;
          Tpl_writeTok_rettype tmp23;
          SimCodeC_expTypeArray_rettype tmp24;
          modelica_metatype tmp25;
          Tpl_writeTok_rettype tmp26;
          intString_rettype tmp27;
          Tpl_writeStr_rettype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          SimCodeC_extVarName_rettype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_oi = tmp3_in2;
          _a_c = tmp3_in3;
          _a_ty = tmp3_in4;
          _a_varDecls = tmp3_in5;
          tmp14 = _SimCodeC_expTypeArrayIf(_a_varDecls, _a_ty);
          _a_varDecls = tmp14.SimCodeC_expTypeArrayIf_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp16 = _Tpl_writeTok(_a_varDecls, tmp15);
          _a_varDecls = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = _SimCodeC_extVarName(_a_varDecls, _a_c);
          _a_varDecls = tmp17.SimCodeC_extVarName_rettype_1;
          tmp18 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp19 = _Tpl_writeTok(_a_varDecls, tmp18);
          _a_varDecls = tmp19.Tpl_writeTok_rettype_1;
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = _Tpl_writeTok(_a_varDecls, tmp20);
          _a_varDecls = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("convert_alloc_"));
          tmp23 = _Tpl_writeTok(_txt, tmp22);
          _txt = tmp23.Tpl_writeTok_rettype_1;
          tmp24 = _SimCodeC_expTypeArray(_txt, _a_ty);
          _txt = tmp24.SimCodeC_expTypeArray_rettype_1;
          tmp25 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_to_f77(&out.targ"));
          tmp26 = _Tpl_writeTok(_txt, tmp25);
          _txt = tmp26.Tpl_writeTok_rettype_1;
          tmp27 = intString((modelica_integer)_a_oi);
          tmp28 = _Tpl_writeStr(_txt, tmp27);
          _txt = tmp28.Tpl_writeStr_rettype_1;
          tmp29 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", &"));
          tmp30 = _Tpl_writeTok(_txt, tmp29);
          _txt = tmp30.Tpl_writeTok_rettype_1;
          tmp31 = _SimCodeC_extVarName(_txt, _a_c);
          _txt = tmp31.SimCodeC_extVarName_rettype_1;
          tmp32 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp33 = _Tpl_writeTok(_txt, tmp32);
          _txt = tmp33.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__467_rettypeboxed boxptr_SimCodeC_fun__467(modelica_metatype _in_txt, modelica_metatype _in_a_ia, modelica_metatype _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__467_rettypeboxed tmp1;
  SimCodeC_fun__467_rettype tmp2;
  modelica_integer tmp3;
  modelica_integer tmp4;
  tmp3 = mmc_unbox_integer(_in_a_ia);
  tmp4 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__467(_in_txt, tmp3, tmp4, _in_a_c, _in_a_ty, _in_a_varDecls);
  tmp1.SimCodeC_fun__467_rettypeboxed_1 = tmp2.SimCodeC_fun__467_rettype_1;
  tmp1.SimCodeC_fun__467_rettypeboxed_2 = tmp2.SimCodeC_fun__467_rettype_2;
  return tmp1;
}
SimCodeC_lm__458_rettype _SimCodeC_lm__458(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__458_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extFunCallVardeclF77_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__458_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          tmp8 = _SimCodeC_extFunCallVardeclF77(_txt, _i_arg, _a_varDecls);
          _txt = tmp8.targ1;
          _a_varDecls = tmp8.targ2;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__458(_txt, _rest, _a_varDecls);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__458_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varDecls = tmp3_in2;
          tmp13 = _SimCodeC_lm__458(_txt, _rest, _a_varDecls);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__458_rettypeboxed boxptr_SimCodeC_lm__458(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__458_rettypeboxed tmp1;
  SimCodeC_lm__458_rettype tmp2;
  tmp2 = _SimCodeC_lm__458(_in_txt, _in_items, _in_a_varDecls);
  tmp1.SimCodeC_lm__458_rettypeboxed_1 = tmp2.SimCodeC_lm__458_rettype_1;
  tmp1.SimCodeC_lm__458_rettypeboxed_2 = tmp2.SimCodeC_lm__458_rettype_2;
  return tmp1;
}
SimCodeC_fun__457_rettype _SimCodeC_fun__457(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__457_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extReturn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_c;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_extVarName_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          tmp11 = _SimCodeC_extVarName(_txt, _i_c);
          _txt = tmp11.SimCodeC_extVarName_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__457_rettypeboxed boxptr_SimCodeC_fun__457(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__457_rettypeboxed tmp1;
  SimCodeC_fun__457_rettype tmp2;
  tmp2 = _SimCodeC_fun__457(_in_txt, _in_a_extReturn);
  tmp1.SimCodeC_fun__457_rettypeboxed_1 = tmp2.SimCodeC_fun__457_rettype_1;
  return tmp1;
}
SimCodeC_lm__456_rettype _SimCodeC_lm__456(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__456_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extArgF77_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__456_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp8 = _SimCodeC_extArgF77(_txt, _i_arg, _a_preExp, _a_varDecls);
          _txt = tmp8.targ1;
          _a_preExp = tmp8.targ2;
          _a_varDecls = tmp8.targ3;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__456(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          _a_preExp = tmp10.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__456_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp13 = _SimCodeC_lm__456(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          _a_preExp = tmp13.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_lm__456_rettypeboxed boxptr_SimCodeC_lm__456(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__456_rettypeboxed tmp1;
  SimCodeC_lm__456_rettype tmp2;
  tmp2 = _SimCodeC_lm__456(_in_txt, _in_items, _in_a_varDecls, _in_a_preExp);
  tmp1.SimCodeC_lm__456_rettypeboxed_1 = tmp2.SimCodeC_lm__456_rettype_1;
  tmp1.SimCodeC_lm__456_rettypeboxed_2 = tmp2.SimCodeC_lm__456_rettype_2;
  tmp1.SimCodeC_lm__456_rettypeboxed_3 = tmp2.SimCodeC_lm__456_rettype_3;
  return tmp1;
}
SimCodeC_extArgF77_rettype _SimCodeC_extArgF77(modelica_metatype _in_txt, modelica_metatype _in_a_extArg, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extArgF77_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extArg;
    tmp3_in2 = _in_a_preExp;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_type__;
      modelica_metatype _i_exp;
      modelica_integer _i_oi;
      modelica_metatype _i_c;
      modelica_metatype _i_t;
      modelica_metatype _l_size__call;
      modelica_metatype _l_dim;
      modelica_metatype _l_sizeVar;
      modelica_metatype _l_sizeVarName;
      modelica_metatype _txt_3;
      modelica_metatype _l_tvar;
      modelica_metatype _l_texp;
      modelica_metatype _l_suffix;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 6 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_integer tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          SimCodeC_expTypeShort_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          SimCodeC_extVarName_rettype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = mmc_unbox_integer(tmp9);
          if (true != tmp10) MMC_THROW();
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_t = tmp11;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("data_of_"));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp14 = _SimCodeC_expTypeShort(_txt, _i_t);
          _txt = tmp14.SimCodeC_expTypeShort_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_array(&("));
          tmp16 = _Tpl_writeTok(_txt, tmp15);
          _txt = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = _SimCodeC_extVarName(_txt, _i_c);
          _txt = tmp17.SimCodeC_extVarName_rettype_1;
          tmp18 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("))"));
          tmp19 = _Tpl_writeTok(_txt, tmp18);
          _txt = tmp19.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_integer tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          SimCodeC_fun__485_rettype tmp29;
          modelica_metatype tmp30;
          Tpl_writeTok_rettype tmp31;
          modelica_metatype tmp32;
          SimCodeC_contextCref_rettype tmp33;
          Tpl_writeText_rettype tmp34;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp21 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp22 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp23 = mmc_unbox_integer(tmp22);
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          if (mmc__uniontype__metarecord__typedef__equal(tmp25,0,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp20;
          _i_oi = tmp23;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp26 = mmc_mk_nil();
          tmp27 = mmc_mk_nil();
          tmp28 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp26, tmp27);
          tmp29 = _SimCodeC_fun__485(tmp28, (modelica_integer)_i_oi);
          _l_suffix = tmp29.SimCodeC_fun__485_rettype_1;
          tmp30 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(int*) &"));
          tmp31 = _Tpl_writeTok(_txt, tmp30);
          _txt = tmp31.Tpl_writeTok_rettype_1;
          tmp32 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp33 = _SimCodeC_contextCref(_txt, _i_c, tmp32);
          _txt = tmp33.SimCodeC_contextCref_rettype_1;
          tmp34 = _Tpl_writeText(_txt, _l_suffix);
          _txt = tmp34.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          modelica_integer tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          SimCodeC_fun__486_rettype tmp44;
          modelica_metatype tmp45;
          Tpl_writeTok_rettype tmp46;
          modelica_metatype tmp47;
          SimCodeC_contextCref_rettype tmp48;
          Tpl_writeText_rettype tmp49;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp36 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp37 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp38 = mmc_unbox_integer(tmp37);
          tmp39 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp40 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp35;
          _i_oi = tmp38;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp41 = mmc_mk_nil();
          tmp42 = mmc_mk_nil();
          tmp43 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp41, tmp42);
          tmp44 = _SimCodeC_fun__486(tmp43, (modelica_integer)_i_oi);
          _l_suffix = tmp44.SimCodeC_fun__486_rettype_1;
          tmp45 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("&"));
          tmp46 = _Tpl_writeTok(_txt, tmp45);
          _txt = tmp46.Tpl_writeTok_rettype_1;
          tmp47 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp48 = _SimCodeC_contextCref(_txt, _i_c, tmp47);
          _txt = tmp48.SimCodeC_contextCref_rettype_1;
          tmp49 = _Tpl_writeText(_txt, _l_suffix);
          _txt = tmp49.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp50;
          modelica_metatype tmp51;
          modelica_metatype tmp52;
          modelica_metatype tmp53;
          modelica_metatype tmp54;
          modelica_metatype tmp55;
          SimCodeC_daeExp_rettype tmp56;
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          modelica_metatype tmp59;
          SimCodeC_expTypeFromExpFlag_rettype tmp60;
          modelica_metatype tmp61;
          modelica_metatype tmp62;
          modelica_metatype tmp63;
          Tpl_textString_rettype tmp64;
          SimCodeC_tempDecl_rettype tmp65;
          Tpl_writeText_rettype tmp66;
          modelica_metatype tmp67;
          Tpl_writeTok_rettype tmp68;
          Tpl_writeText_rettype tmp69;
          modelica_metatype tmp70;
          Tpl_writeTok_rettype tmp71;
          modelica_metatype tmp72;
          Tpl_writeTok_rettype tmp73;
          modelica_metatype tmp74;
          Tpl_writeTok_rettype tmp75;
          Tpl_writeText_rettype tmp76;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,2) == 0) MMC_THROW();
          tmp50 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp51 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp = tmp50;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp52 = mmc_mk_nil();
          tmp53 = mmc_mk_nil();
          tmp54 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp52, tmp53);
          tmp55 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp56 = _SimCodeC_daeExp(tmp54, _i_exp, tmp55, _a_preExp, _a_varDecls);
          _l_texp = tmp56.targ1;
          _a_preExp = tmp56.targ2;
          _a_varDecls = tmp56.targ3;
          tmp57 = mmc_mk_nil();
          tmp58 = mmc_mk_nil();
          tmp59 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp57, tmp58);
          tmp60 = _SimCodeC_expTypeFromExpFlag(tmp59, _i_exp, 8);
          _txt_3 = tmp60.SimCodeC_expTypeFromExpFlag_rettype_1;
          tmp61 = mmc_mk_nil();
          tmp62 = mmc_mk_nil();
          tmp63 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp61, tmp62);
          tmp64 = _Tpl_textString(_txt_3);
          tmp65 = _SimCodeC_tempDecl(tmp63, tmp64.Tpl_textString_rettype_1, _a_varDecls);
          _l_tvar = tmp65.targ1;
          _a_varDecls = tmp65.targ2;
          tmp66 = _Tpl_writeText(_a_preExp, _l_tvar);
          _a_preExp = tmp66.Tpl_writeText_rettype_1;
          tmp67 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp68 = _Tpl_writeTok(_a_preExp, tmp67);
          _a_preExp = tmp68.Tpl_writeTok_rettype_1;
          tmp69 = _Tpl_writeText(_a_preExp, _l_texp);
          _a_preExp = tmp69.Tpl_writeText_rettype_1;
          tmp70 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp71 = _Tpl_writeTok(_a_preExp, tmp70);
          _a_preExp = tmp71.Tpl_writeTok_rettype_1;
          tmp72 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp73 = _Tpl_writeTok(_a_preExp, tmp72);
          _a_preExp = tmp73.Tpl_writeTok_rettype_1;
          tmp74 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("&"));
          tmp75 = _Tpl_writeTok(_txt, tmp74);
          _txt = tmp75.Tpl_writeTok_rettype_1;
          tmp76 = _Tpl_writeText(_txt, _l_tvar);
          _txt = tmp76.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp77;
          modelica_metatype tmp78;
          modelica_metatype tmp79;
          modelica_metatype tmp80;
          modelica_metatype tmp81;
          modelica_metatype tmp82;
          modelica_metatype tmp83;
          modelica_metatype tmp84;
          SimCodeC_tempSizeVarName_rettype tmp85;
          modelica_metatype tmp86;
          modelica_metatype tmp87;
          modelica_metatype tmp88;
          SimCodeC_tempDecl_rettype tmp89;
          modelica_metatype tmp90;
          modelica_metatype tmp91;
          modelica_metatype tmp92;
          modelica_metatype tmp93;
          SimCodeC_daeExp_rettype tmp94;
          modelica_metatype tmp95;
          modelica_metatype tmp96;
          modelica_metatype tmp97;
          modelica_metatype tmp98;
          Tpl_writeTok_rettype tmp99;
          SimCodeC_expTypeShort_rettype tmp100;
          modelica_metatype tmp101;
          Tpl_writeTok_rettype tmp102;
          Tpl_writeText_rettype tmp103;
          modelica_metatype tmp104;
          Tpl_writeTok_rettype tmp105;
          Tpl_writeText_rettype tmp106;
          modelica_metatype tmp107;
          Tpl_writeTok_rettype tmp108;
          modelica_metatype tmp109;
          SimCodeC_contextCref_rettype tmp110;
          modelica_metatype tmp111;
          Tpl_writeTok_rettype tmp112;
          Tpl_writeText_rettype tmp113;
          modelica_metatype tmp114;
          Tpl_writeTok_rettype tmp115;
          modelica_metatype tmp116;
          Tpl_writeTok_rettype tmp117;
          modelica_metatype tmp118;
          Tpl_writeTok_rettype tmp119;
          Tpl_writeText_rettype tmp120;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,5) == 0) MMC_THROW();
          tmp77 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp78 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp79 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp80 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp81 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp77;
          _i_type__ = tmp80;
          _i_exp = tmp81;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp82 = mmc_mk_nil();
          tmp83 = mmc_mk_nil();
          tmp84 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp82, tmp83);
          tmp85 = _SimCodeC_tempSizeVarName(tmp84, _i_c, _i_exp);
          _l_sizeVarName = tmp85.SimCodeC_tempSizeVarName_rettype_1;
          tmp86 = mmc_mk_nil();
          tmp87 = mmc_mk_nil();
          tmp88 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp86, tmp87);
          tmp89 = _SimCodeC_tempDecl(tmp88, "int", _a_varDecls);
          _l_sizeVar = tmp89.targ1;
          _a_varDecls = tmp89.targ2;
          tmp90 = mmc_mk_nil();
          tmp91 = mmc_mk_nil();
          tmp92 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp90, tmp91);
          tmp93 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp94 = _SimCodeC_daeExp(tmp92, _i_exp, tmp93, _a_preExp, _a_varDecls);
          _l_dim = tmp94.targ1;
          _a_preExp = tmp94.targ2;
          _a_varDecls = tmp94.targ3;
          tmp95 = mmc_mk_nil();
          tmp96 = mmc_mk_nil();
          tmp97 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp95, tmp96);
          tmp98 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("size_of_dimension_"));
          tmp99 = _Tpl_writeTok(tmp97, tmp98);
          _l_size__call = tmp99.Tpl_writeTok_rettype_1;
          tmp100 = _SimCodeC_expTypeShort(_l_size__call, _i_type__);
          _l_size__call = tmp100.SimCodeC_expTypeShort_rettype_1;
          tmp101 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_array"));
          tmp102 = _Tpl_writeTok(_l_size__call, tmp101);
          _l_size__call = tmp102.Tpl_writeTok_rettype_1;
          tmp103 = _Tpl_writeText(_a_preExp, _l_sizeVar);
          _a_preExp = tmp103.Tpl_writeText_rettype_1;
          tmp104 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp105 = _Tpl_writeTok(_a_preExp, tmp104);
          _a_preExp = tmp105.Tpl_writeTok_rettype_1;
          tmp106 = _Tpl_writeText(_a_preExp, _l_size__call);
          _a_preExp = tmp106.Tpl_writeText_rettype_1;
          tmp107 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp108 = _Tpl_writeTok(_a_preExp, tmp107);
          _a_preExp = tmp108.Tpl_writeTok_rettype_1;
          tmp109 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp110 = _SimCodeC_contextCref(_a_preExp, _i_c, tmp109);
          _a_preExp = tmp110.SimCodeC_contextCref_rettype_1;
          tmp111 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp112 = _Tpl_writeTok(_a_preExp, tmp111);
          _a_preExp = tmp112.Tpl_writeTok_rettype_1;
          tmp113 = _Tpl_writeText(_a_preExp, _l_dim);
          _a_preExp = tmp113.Tpl_writeText_rettype_1;
          tmp114 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp115 = _Tpl_writeTok(_a_preExp, tmp114);
          _a_preExp = tmp115.Tpl_writeTok_rettype_1;
          tmp116 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp117 = _Tpl_writeTok(_a_preExp, tmp116);
          _a_preExp = tmp117.Tpl_writeTok_rettype_1;
          tmp118 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("&"));
          tmp119 = _Tpl_writeTok(_txt, tmp118);
          _txt = tmp119.Tpl_writeTok_rettype_1;
          tmp120 = _Tpl_writeText(_txt, _l_sizeVar);
          _txt = tmp120.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 5: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extArgF77_rettypeboxed boxptr_SimCodeC_extArgF77(modelica_metatype _in_txt, modelica_metatype _in_a_extArg, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extArgF77_rettypeboxed tmp1;
  SimCodeC_extArgF77_rettype tmp2;
  tmp2 = _SimCodeC_extArgF77(_in_txt, _in_a_extArg, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_extArgF77_rettypeboxed_1 = tmp2.SimCodeC_extArgF77_rettype_1;
  tmp1.SimCodeC_extArgF77_rettypeboxed_2 = tmp2.SimCodeC_extArgF77_rettype_2;
  tmp1.SimCodeC_extArgF77_rettypeboxed_3 = tmp2.SimCodeC_extArgF77_rettype_3;
  return tmp1;
}
SimCodeC_tempSizeVarName_rettype _SimCodeC_tempSizeVarName(modelica_metatype _txt, modelica_metatype _a_c, modelica_metatype _a_indices)
{
  SimCodeC_tempSizeVarName_rettype tmp1;
  modelica_metatype _out_txt;
  SimCodeC_fun__488_rettype tmp2;


  tmp2 = _SimCodeC_fun__488(_txt, _a_indices, _a_c);
  _out_txt = tmp2.SimCodeC_fun__488_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_tempSizeVarName_rettypeboxed boxptr_SimCodeC_tempSizeVarName(modelica_metatype _txt, modelica_metatype _a_c, modelica_metatype _a_indices)
{
  SimCodeC_tempSizeVarName_rettypeboxed tmp1;
  SimCodeC_tempSizeVarName_rettype tmp2;
  tmp2 = _SimCodeC_tempSizeVarName(_txt, _a_c, _a_indices);
  tmp1.SimCodeC_tempSizeVarName_rettypeboxed_1 = tmp2.SimCodeC_tempSizeVarName_rettype_1;
  return tmp1;
}
SimCodeC_fun__488_rettype _SimCodeC_fun__488(modelica_metatype _in_txt, modelica_metatype _in_a_indices, modelica_metatype _in_a_c)
{
  SimCodeC_fun__488_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_indices;
    tmp3_in2 = _in_a_c;
    {
      modelica_metatype _txt;
      modelica_metatype _a_c;
      modelica_integer _i_integer;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_integer tmp7;
          modelica_metatype tmp8;
          SimCodeC_contextCref_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          intString_rettype tmp12;
          Tpl_writeStr_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,1) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = mmc_unbox_integer(tmp6);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_integer = tmp7;
          _a_c = tmp3_in2;
          tmp8 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp9 = _SimCodeC_contextCref(_txt, _a_c, tmp8);
          _txt = tmp9.SimCodeC_contextCref_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_size_"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = intString((modelica_integer)_i_integer);
          tmp13 = _Tpl_writeStr(_txt, tmp12);
          _txt = tmp13.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp14 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("tempSizeVarName:UNHANDLED_EXPRESSION"));
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__488_rettypeboxed boxptr_SimCodeC_fun__488(modelica_metatype _in_txt, modelica_metatype _in_a_indices, modelica_metatype _in_a_c)
{
  SimCodeC_fun__488_rettypeboxed tmp1;
  SimCodeC_fun__488_rettype tmp2;
  tmp2 = _SimCodeC_fun__488(_in_txt, _in_a_indices, _in_a_c);
  tmp1.SimCodeC_fun__488_rettypeboxed_1 = tmp2.SimCodeC_fun__488_rettype_1;
  return tmp1;
}
SimCodeC_fun__486_rettype _SimCodeC_fun__486(modelica_metatype _in_txt, modelica_integer _in_a_oi)
{
  SimCodeC_fun__486_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (0 != tmp3_in1) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__486_rettypeboxed boxptr_SimCodeC_fun__486(modelica_metatype _in_txt, modelica_metatype _in_a_oi)
{
  SimCodeC_fun__486_rettypeboxed tmp1;
  SimCodeC_fun__486_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__486(_in_txt, tmp3);
  tmp1.SimCodeC_fun__486_rettypeboxed_1 = tmp2.SimCodeC_fun__486_rettype_1;
  return tmp1;
}
SimCodeC_fun__485_rettype _SimCodeC_fun__485(modelica_metatype _in_txt, modelica_integer _in_a_oi)
{
  SimCodeC_fun__485_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (0 != tmp3_in1) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__485_rettypeboxed boxptr_SimCodeC_fun__485(modelica_metatype _in_txt, modelica_metatype _in_a_oi)
{
  SimCodeC_fun__485_rettypeboxed tmp1;
  SimCodeC_fun__485_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__485(_in_txt, tmp3);
  tmp1.SimCodeC_fun__485_rettypeboxed_1 = tmp2.SimCodeC_fun__485_rettype_1;
  return tmp1;
}
SimCodeC_extFunCallC_rettype _SimCodeC_extFunCallC(modelica_metatype _in_txt, modelica_metatype _in_a_fun, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallC_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fun;
    tmp3_in2 = _in_a_preExp;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_string _i_extName;
      modelica_metatype _i_extReturn;
      modelica_metatype _i_extArgs;
      modelica_metatype _l_returnAssign;
      modelica_metatype _l_args;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_string tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          Tpl_pushIter_rettype tmp23;
          SimCodeC_lm__449_rettype tmp24;
          Tpl_popIter_rettype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          SimCodeC_fun__450_rettype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          Tpl_pushIter_rettype tmp34;
          SimCodeC_lm__451_rettype tmp35;
          Tpl_popIter_rettype tmp36;
          Tpl_softNewLine_rettype tmp37;
          SimCodeC_fun__452_rettype tmp38;
          Tpl_softNewLine_rettype tmp39;
          Tpl_writeText_rettype tmp40;
          Tpl_writeStr_rettype tmp41;
          modelica_metatype tmp42;
          Tpl_writeTok_rettype tmp43;
          Tpl_writeText_rettype tmp44;
          modelica_metatype tmp45;
          Tpl_writeTok_rettype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          modelica_metatype tmp50;
          Tpl_pushIter_rettype tmp51;
          SimCodeC_lm__453_rettype tmp52;
          Tpl_popIter_rettype tmp53;
          Tpl_softNewLine_rettype tmp54;
          SimCodeC_fun__454_rettype tmp55;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = mmc_unbox_string(tmp7);
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extName = tmp8;
          _i_extArgs = tmp10;
          _i_extReturn = tmp11;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp16, tmp17);
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp22 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp19), mmc_mk_integer(0), mmc_mk_integer(0), tmp20, mmc_mk_integer(0), tmp21);
          tmp23 = _Tpl_pushIter(tmp18, tmp22);
          _l_args = tmp23.Tpl_pushIter_rettype_1;
          tmp24 = _SimCodeC_lm__449(_l_args, _i_extArgs, _a_varDecls, _a_preExp);
          _l_args = tmp24.targ1;
          _a_varDecls = tmp24.targ2;
          _a_preExp = tmp24.targ3;
          tmp25 = _Tpl_popIter(_l_args);
          _l_args = tmp25.Tpl_popIter_rettype_1;
          tmp26 = mmc_mk_nil();
          tmp27 = mmc_mk_nil();
          tmp28 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp26, tmp27);
          tmp29 = _SimCodeC_fun__450(tmp28, _i_extReturn);
          _l_returnAssign = tmp29.SimCodeC_fun__450_rettype_1;
          tmp30 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp31 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp32 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp33 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp30), mmc_mk_integer(0), mmc_mk_integer(0), tmp31, mmc_mk_integer(0), tmp32);
          tmp34 = _Tpl_pushIter(_txt, tmp33);
          _txt = tmp34.Tpl_pushIter_rettype_1;
          tmp35 = _SimCodeC_lm__451(_txt, _i_extArgs, _a_varDecls);
          _txt = tmp35.targ1;
          _a_varDecls = tmp35.targ2;
          tmp36 = _Tpl_popIter(_txt);
          _txt = tmp36.Tpl_popIter_rettype_1;
          tmp37 = _Tpl_softNewLine(_txt);
          _txt = tmp37.Tpl_softNewLine_rettype_1;
          tmp38 = _SimCodeC_fun__452(_txt, _i_extReturn, _a_varDecls);
          _txt = tmp38.targ1;
          _a_varDecls = tmp38.targ2;
          tmp39 = _Tpl_softNewLine(_txt);
          _txt = tmp39.Tpl_softNewLine_rettype_1;
          tmp40 = _Tpl_writeText(_txt, _l_returnAssign);
          _txt = tmp40.Tpl_writeText_rettype_1;
          tmp41 = _Tpl_writeStr(_txt, _i_extName);
          _txt = tmp41.Tpl_writeStr_rettype_1;
          tmp42 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp43 = _Tpl_writeTok(_txt, tmp42);
          _txt = tmp43.Tpl_writeTok_rettype_1;
          tmp44 = _Tpl_writeText(_txt, _l_args);
          _txt = tmp44.Tpl_writeText_rettype_1;
          tmp45 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(");\n"));
          tmp46 = _Tpl_writeTok(_txt, tmp45);
          _txt = tmp46.Tpl_writeTok_rettype_1;
          tmp47 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp48 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp49 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp50 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp47), mmc_mk_integer(0), mmc_mk_integer(0), tmp48, mmc_mk_integer(0), tmp49);
          tmp51 = _Tpl_pushIter(_txt, tmp50);
          _txt = tmp51.Tpl_pushIter_rettype_1;
          tmp52 = _SimCodeC_lm__453(_txt, _i_extArgs);
          _txt = tmp52.SimCodeC_lm__453_rettype_1;
          tmp53 = _Tpl_popIter(_txt);
          _txt = tmp53.Tpl_popIter_rettype_1;
          tmp54 = _Tpl_softNewLine(_txt);
          _txt = tmp54.Tpl_softNewLine_rettype_1;
          tmp55 = _SimCodeC_fun__454(_txt, _i_extReturn);
          _txt = tmp55.SimCodeC_fun__454_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extFunCallC_rettypeboxed boxptr_SimCodeC_extFunCallC(modelica_metatype _in_txt, modelica_metatype _in_a_fun, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallC_rettypeboxed tmp1;
  SimCodeC_extFunCallC_rettype tmp2;
  tmp2 = _SimCodeC_extFunCallC(_in_txt, _in_a_fun, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_extFunCallC_rettypeboxed_1 = tmp2.SimCodeC_extFunCallC_rettype_1;
  tmp1.SimCodeC_extFunCallC_rettypeboxed_2 = tmp2.SimCodeC_extFunCallC_rettype_2;
  tmp1.SimCodeC_extFunCallC_rettypeboxed_3 = tmp2.SimCodeC_extFunCallC_rettype_3;
  return tmp1;
}
SimCodeC_fun__454_rettype _SimCodeC_fun__454(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__454_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extReturn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_extReturn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_extFunCallVarcopy_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extReturn = tmp3_in1;
          tmp11 = _SimCodeC_extFunCallVarcopy(_txt, _i_extReturn);
          _txt = tmp11.SimCodeC_extFunCallVarcopy_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__454_rettypeboxed boxptr_SimCodeC_fun__454(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__454_rettypeboxed tmp1;
  SimCodeC_fun__454_rettype tmp2;
  tmp2 = _SimCodeC_fun__454(_in_txt, _in_a_extReturn);
  tmp1.SimCodeC_fun__454_rettypeboxed_1 = tmp2.SimCodeC_fun__454_rettype_1;
  return tmp1;
}
SimCodeC_extFunCallVarcopy_rettype _SimCodeC_extFunCallVarcopy(modelica_metatype _in_txt, modelica_metatype _in_a_arg)
{
  SimCodeC_extFunCallVarcopy_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_arg;
    {
      modelica_metatype _txt;
      modelica_metatype _i_c;
      modelica_metatype _i_ty;
      modelica_integer _i_oi;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_integer tmp9;
          modelica_metatype tmp10;
          modelica_integer tmp11;
          modelica_metatype tmp12;
          SimCodeC_fun__474_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = mmc_unbox_integer(tmp8);
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = mmc_unbox_integer(tmp10);
          if (false != tmp11) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_oi = tmp9;
          _i_ty = tmp12;
          tmp13 = _SimCodeC_fun__474(_txt, (modelica_integer)_i_oi, _i_c, _i_ty);
          _txt = tmp13.SimCodeC_fun__474_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extFunCallVarcopy_rettypeboxed boxptr_SimCodeC_extFunCallVarcopy(modelica_metatype _in_txt, modelica_metatype _in_a_arg)
{
  SimCodeC_extFunCallVarcopy_rettypeboxed tmp1;
  SimCodeC_extFunCallVarcopy_rettype tmp2;
  tmp2 = _SimCodeC_extFunCallVarcopy(_in_txt, _in_a_arg);
  tmp1.SimCodeC_extFunCallVarcopy_rettypeboxed_1 = tmp2.SimCodeC_extFunCallVarcopy_rettype_1;
  return tmp1;
}
SimCodeC_fun__474_rettype _SimCodeC_fun__474(modelica_metatype _in_txt, modelica_integer _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty)
{
  SimCodeC_fun__474_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    tmp3_in2 = _in_a_c;
    tmp3_in3 = _in_a_ty;
    {
      modelica_metatype _txt;
      modelica_metatype _a_c;
      modelica_metatype _a_ty;
      modelica_integer _i_oi;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (0 != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          intString_rettype tmp8;
          Tpl_writeStr_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          SimCodeC_expTypeModelica_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          modelica_metatype tmp15;
          SimCodeC_contextCref_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_oi = tmp3_in1;
          _a_c = tmp3_in2;
          _a_ty = tmp3_in3;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("out.targ"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = intString((modelica_integer)_i_oi);
          tmp9 = _Tpl_writeStr(_txt, tmp8);
          _txt = tmp9.Tpl_writeStr_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = ("));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = _SimCodeC_expTypeModelica(_txt, _a_ty);
          _txt = tmp12.SimCodeC_expTypeModelica_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp16 = _SimCodeC_contextCref(_txt, _a_c, tmp15);
          _txt = tmp16.SimCodeC_contextCref_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext;"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__474_rettypeboxed boxptr_SimCodeC_fun__474(modelica_metatype _in_txt, modelica_metatype _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty)
{
  SimCodeC_fun__474_rettypeboxed tmp1;
  SimCodeC_fun__474_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__474(_in_txt, tmp3, _in_a_c, _in_a_ty);
  tmp1.SimCodeC_fun__474_rettypeboxed_1 = tmp2.SimCodeC_fun__474_rettype_1;
  return tmp1;
}
SimCodeC_lm__453_rettype _SimCodeC_lm__453(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__453_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extFunCallVarcopy_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__453_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_extFunCallVarcopy(_txt, _i_arg);
          _txt = tmp8.SimCodeC_extFunCallVarcopy_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__453(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__453_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__453_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__453(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__453_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__453_rettypeboxed boxptr_SimCodeC_lm__453(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__453_rettypeboxed tmp1;
  SimCodeC_lm__453_rettype tmp2;
  tmp2 = _SimCodeC_lm__453(_in_txt, _in_items);
  tmp1.SimCodeC_lm__453_rettypeboxed_1 = tmp2.SimCodeC_lm__453_rettype_1;
  return tmp1;
}
SimCodeC_fun__452_rettype _SimCodeC_fun__452(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__452_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extReturn;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_extReturn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_extFunCallVardecl_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extReturn = tmp3_in1;
          _a_varDecls = tmp3_in2;
          tmp11 = _SimCodeC_extFunCallVardecl(_txt, _i_extReturn, _a_varDecls);
          _txt = tmp11.targ1;
          _a_varDecls = tmp11.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__452_rettypeboxed boxptr_SimCodeC_fun__452(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__452_rettypeboxed tmp1;
  SimCodeC_fun__452_rettype tmp2;
  tmp2 = _SimCodeC_fun__452(_in_txt, _in_a_extReturn, _in_a_varDecls);
  tmp1.SimCodeC_fun__452_rettypeboxed_1 = tmp2.SimCodeC_fun__452_rettype_1;
  tmp1.SimCodeC_fun__452_rettypeboxed_2 = tmp2.SimCodeC_fun__452_rettype_2;
  return tmp1;
}
SimCodeC_extFunCallVardecl_rettype _SimCodeC_extFunCallVardecl(modelica_metatype _in_txt, modelica_metatype _in_a_arg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallVardecl_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_arg;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_integer _i_oi;
      modelica_metatype _i_c;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_integer tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_integer tmp11;
          modelica_metatype tmp12;
          SimCodeC_fun__464_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = mmc_unbox_integer(tmp7);
          if (true != tmp8) MMC_THROW();
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = mmc_unbox_integer(tmp10);
          if (false != tmp11) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_ty = tmp12;
          _a_varDecls = tmp3_in2;
          tmp13 = _SimCodeC_fun__464(_txt, _i_ty, _i_c, _a_varDecls);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_integer tmp17;
          modelica_metatype tmp18;
          modelica_integer tmp19;
          modelica_metatype tmp20;
          SimCodeC_fun__465_rettype tmp21;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp17 = mmc_unbox_integer(tmp16);
          tmp18 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp19 = mmc_unbox_integer(tmp18);
          if (false != tmp19) MMC_THROW();
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp14;
          _i_oi = tmp17;
          _i_ty = tmp20;
          _a_varDecls = tmp3_in2;
          tmp21 = _SimCodeC_fun__465(_txt, (modelica_integer)_i_oi, _i_c, _i_ty, _a_varDecls);
          _txt = tmp21.targ1;
          _a_varDecls = tmp21.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extFunCallVardecl_rettypeboxed boxptr_SimCodeC_extFunCallVardecl(modelica_metatype _in_txt, modelica_metatype _in_a_arg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extFunCallVardecl_rettypeboxed tmp1;
  SimCodeC_extFunCallVardecl_rettype tmp2;
  tmp2 = _SimCodeC_extFunCallVardecl(_in_txt, _in_a_arg, _in_a_varDecls);
  tmp1.SimCodeC_extFunCallVardecl_rettypeboxed_1 = tmp2.SimCodeC_extFunCallVardecl_rettype_1;
  tmp1.SimCodeC_extFunCallVardecl_rettypeboxed_2 = tmp2.SimCodeC_extFunCallVardecl_rettype_2;
  return tmp1;
}
SimCodeC_fun__465_rettype _SimCodeC_fun__465(modelica_metatype _in_txt, modelica_integer _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__465_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    tmp3_in2 = _in_a_c;
    tmp3_in3 = _in_a_ty;
    tmp3_in4 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_c;
      modelica_metatype _a_ty;
      modelica_metatype _a_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (0 != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_extType_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          SimCodeC_extVarName_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_c = tmp3_in2;
          _a_ty = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp6 = _SimCodeC_extType(_a_varDecls, _a_ty);
          _a_varDecls = tmp6.SimCodeC_extType_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp8 = _Tpl_writeTok(_a_varDecls, tmp7);
          _a_varDecls = tmp8.Tpl_writeTok_rettype_1;
          tmp9 = _SimCodeC_extVarName(_a_varDecls, _a_c);
          _a_varDecls = tmp9.SimCodeC_extVarName_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp11 = _Tpl_writeTok(_a_varDecls, tmp10);
          _a_varDecls = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp13 = _Tpl_writeTok(_a_varDecls, tmp12);
          _a_varDecls = tmp13.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__465_rettypeboxed boxptr_SimCodeC_fun__465(modelica_metatype _in_txt, modelica_metatype _in_a_oi, modelica_metatype _in_a_c, modelica_metatype _in_a_ty, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__465_rettypeboxed tmp1;
  SimCodeC_fun__465_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__465(_in_txt, tmp3, _in_a_c, _in_a_ty, _in_a_varDecls);
  tmp1.SimCodeC_fun__465_rettypeboxed_1 = tmp2.SimCodeC_fun__465_rettype_1;
  tmp1.SimCodeC_fun__465_rettypeboxed_2 = tmp2.SimCodeC_fun__465_rettype_2;
  return tmp1;
}
SimCodeC_fun__464_rettype _SimCodeC_fun__464(modelica_metatype _in_txt, modelica_metatype _in_a_ty, modelica_metatype _in_a_c, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__464_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_ty;
    tmp3_in2 = _in_a_c;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_c;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_extType_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          modelica_metatype tmp9;
          SimCodeC_contextCref_rettype tmp10;
          modelica_metatype tmp11;
          Tpl_writeTok_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          modelica_metatype tmp15;
          SimCodeC_contextCref_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          SimCodeC_extType_rettype tmp19;
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          modelica_metatype tmp22;
          SimCodeC_contextCref_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_ty = tmp3_in1;
          _a_c = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp6 = _SimCodeC_extType(_a_varDecls, _i_ty);
          _a_varDecls = tmp6.SimCodeC_extType_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp8 = _Tpl_writeTok(_a_varDecls, tmp7);
          _a_varDecls = tmp8.Tpl_writeTok_rettype_1;
          tmp9 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp10 = _SimCodeC_contextCref(_a_varDecls, _a_c, tmp9);
          _a_varDecls = tmp10.SimCodeC_contextCref_rettype_1;
          tmp11 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext;"));
          tmp12 = _Tpl_writeTok(_a_varDecls, tmp11);
          _a_varDecls = tmp12.Tpl_writeTok_rettype_1;
          tmp13 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp14 = _Tpl_writeTok(_a_varDecls, tmp13);
          _a_varDecls = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp16 = _SimCodeC_contextCref(_txt, _a_c, tmp15);
          _txt = tmp16.SimCodeC_contextCref_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext = ("));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp19 = _SimCodeC_extType(_txt, _i_ty);
          _txt = tmp19.SimCodeC_extType_rettype_1;
          tmp20 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp21 = _Tpl_writeTok(_txt, tmp20);
          _txt = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp23 = _SimCodeC_contextCref(_txt, _a_c, tmp22);
          _txt = tmp23.SimCodeC_contextCref_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp25 = _Tpl_writeTok(_txt, tmp24);
          _txt = tmp25.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__464_rettypeboxed boxptr_SimCodeC_fun__464(modelica_metatype _in_txt, modelica_metatype _in_a_ty, modelica_metatype _in_a_c, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__464_rettypeboxed tmp1;
  SimCodeC_fun__464_rettype tmp2;
  tmp2 = _SimCodeC_fun__464(_in_txt, _in_a_ty, _in_a_c, _in_a_varDecls);
  tmp1.SimCodeC_fun__464_rettypeboxed_1 = tmp2.SimCodeC_fun__464_rettype_1;
  tmp1.SimCodeC_fun__464_rettypeboxed_2 = tmp2.SimCodeC_fun__464_rettype_2;
  return tmp1;
}
SimCodeC_lm__451_rettype _SimCodeC_lm__451(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__451_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extFunCallVardecl_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__451_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          tmp8 = _SimCodeC_extFunCallVardecl(_txt, _i_arg, _a_varDecls);
          _txt = tmp8.targ1;
          _a_varDecls = tmp8.targ2;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__451(_txt, _rest, _a_varDecls);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__451_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varDecls = tmp3_in2;
          tmp13 = _SimCodeC_lm__451(_txt, _rest, _a_varDecls);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__451_rettypeboxed boxptr_SimCodeC_lm__451(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__451_rettypeboxed tmp1;
  SimCodeC_lm__451_rettype tmp2;
  tmp2 = _SimCodeC_lm__451(_in_txt, _in_items, _in_a_varDecls);
  tmp1.SimCodeC_lm__451_rettypeboxed_1 = tmp2.SimCodeC_lm__451_rettype_1;
  tmp1.SimCodeC_lm__451_rettypeboxed_2 = tmp2.SimCodeC_lm__451_rettype_2;
  return tmp1;
}
SimCodeC_extVarName_rettype _SimCodeC_extVarName(modelica_metatype _txt, modelica_metatype _a_cr)
{
  SimCodeC_extVarName_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;
  SimCodeC_contextCref_rettype tmp3;
  modelica_metatype tmp4;
  Tpl_writeTok_rettype tmp5;


  tmp2 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
  tmp3 = _SimCodeC_contextCref(_txt, _a_cr, tmp2);
  _out_txt = tmp3.SimCodeC_contextCref_rettype_1;
  tmp4 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext"));
  tmp5 = _Tpl_writeTok(_out_txt, tmp4);
  _out_txt = tmp5.Tpl_writeTok_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extVarName_rettypeboxed boxptr_SimCodeC_extVarName(modelica_metatype _txt, modelica_metatype _a_cr)
{
  SimCodeC_extVarName_rettypeboxed tmp1;
  SimCodeC_extVarName_rettype tmp2;
  tmp2 = _SimCodeC_extVarName(_txt, _a_cr);
  tmp1.SimCodeC_extVarName_rettypeboxed_1 = tmp2.SimCodeC_extVarName_rettype_1;
  return tmp1;
}
SimCodeC_fun__450_rettype _SimCodeC_fun__450(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__450_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extReturn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_c;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_extVarName_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          tmp11 = _SimCodeC_extVarName(_txt, _i_c);
          _txt = tmp11.SimCodeC_extVarName_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__450_rettypeboxed boxptr_SimCodeC_fun__450(modelica_metatype _in_txt, modelica_metatype _in_a_extReturn)
{
  SimCodeC_fun__450_rettypeboxed tmp1;
  SimCodeC_fun__450_rettype tmp2;
  tmp2 = _SimCodeC_fun__450(_in_txt, _in_a_extReturn);
  tmp1.SimCodeC_fun__450_rettypeboxed_1 = tmp2.SimCodeC_fun__450_rettype_1;
  return tmp1;
}
SimCodeC_lm__449_rettype _SimCodeC_lm__449(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__449_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extArg_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__449_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp8 = _SimCodeC_extArg(_txt, _i_arg, _a_preExp, _a_varDecls);
          _txt = tmp8.targ1;
          _a_preExp = tmp8.targ2;
          _a_varDecls = tmp8.targ3;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__449(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          _a_preExp = tmp10.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__449_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp13 = _SimCodeC_lm__449(_txt, _rest, _a_varDecls, _a_preExp);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          _a_preExp = tmp13.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_lm__449_rettypeboxed boxptr_SimCodeC_lm__449(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp)
{
  SimCodeC_lm__449_rettypeboxed tmp1;
  SimCodeC_lm__449_rettype tmp2;
  tmp2 = _SimCodeC_lm__449(_in_txt, _in_items, _in_a_varDecls, _in_a_preExp);
  tmp1.SimCodeC_lm__449_rettypeboxed_1 = tmp2.SimCodeC_lm__449_rettype_1;
  tmp1.SimCodeC_lm__449_rettypeboxed_2 = tmp2.SimCodeC_lm__449_rettype_2;
  tmp1.SimCodeC_lm__449_rettypeboxed_3 = tmp2.SimCodeC_lm__449_rettype_3;
  return tmp1;
}
SimCodeC_extArg_rettype _SimCodeC_extArg(modelica_metatype _in_txt, modelica_metatype _in_a_extArg, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extArg_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extArg;
    tmp3_in2 = _in_a_preExp;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_integer _i_outputIndex;
      modelica_metatype _i_type__;
      modelica_metatype _i_exp;
      modelica_metatype _i_t;
      modelica_metatype _i_c;
      modelica_integer _i_oi;
      modelica_metatype _l_dim;
      modelica_metatype _l_typeStr;
      modelica_metatype _l_suffix;
      modelica_metatype _l_prefix;
      modelica_metatype _l_shortTypeStr;
      modelica_metatype _l_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 5 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_integer tmp9;
          modelica_metatype tmp10;
          modelica_integer tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          SimCodeC_fun__479_rettype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          SimCodeC_expTypeShort_rettype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          Tpl_writeText_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          Tpl_writeText_rettype tmp26;
          modelica_metatype tmp27;
          Tpl_writeTok_rettype tmp28;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = mmc_unbox_integer(tmp8);
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = mmc_unbox_integer(tmp10);
          if (true != tmp11) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_oi = tmp9;
          _i_t = tmp12;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = _SimCodeC_fun__479(tmp15, (modelica_integer)_i_oi, _i_c);
          _l_name = tmp16.SimCodeC_fun__479_rettype_1;
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_nil();
          tmp19 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp17, tmp18);
          tmp20 = _SimCodeC_expTypeShort(tmp19, _i_t);
          _l_shortTypeStr = tmp20.SimCodeC_expTypeShort_rettype_1;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("data_of_"));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _Tpl_writeText(_txt, _l_shortTypeStr);
          _txt = tmp23.Tpl_writeText_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_array(&("));
          tmp25 = _Tpl_writeTok(_txt, tmp24);
          _txt = tmp25.Tpl_writeTok_rettype_1;
          tmp26 = _Tpl_writeText(_txt, _l_name);
          _txt = tmp26.Tpl_writeText_rettype_1;
          tmp27 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("))"));
          tmp28 = _Tpl_writeTok(_txt, tmp27);
          _txt = tmp28.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          modelica_integer tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          SimCodeC_fun__480_rettype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          SimCodeC_fun__482_rettype tmp42;
          Tpl_writeText_rettype tmp43;
          modelica_metatype tmp44;
          SimCodeC_contextCref_rettype tmp45;
          Tpl_writeText_rettype tmp46;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp31 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp32 = mmc_unbox_integer(tmp31);
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp34 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp29;
          _i_oi = tmp32;
          _i_t = tmp34;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp35 = mmc_mk_nil();
          tmp36 = mmc_mk_nil();
          tmp37 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp35, tmp36);
          tmp38 = _SimCodeC_fun__480(tmp37, (modelica_integer)_i_oi);
          _l_prefix = tmp38.SimCodeC_fun__480_rettype_1;
          tmp39 = mmc_mk_nil();
          tmp40 = mmc_mk_nil();
          tmp41 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp39, tmp40);
          tmp42 = _SimCodeC_fun__482(tmp41, (modelica_integer)_i_oi, _i_t);
          _l_suffix = tmp42.SimCodeC_fun__482_rettype_1;
          tmp43 = _Tpl_writeText(_txt, _l_prefix);
          _txt = tmp43.Tpl_writeText_rettype_1;
          tmp44 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp45 = _SimCodeC_contextCref(_txt, _i_c, tmp44);
          _txt = tmp45.SimCodeC_contextCref_rettype_1;
          tmp46 = _Tpl_writeText(_txt, _l_suffix);
          _txt = tmp46.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          SimCodeC_daeExp_rettype tmp50;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,2) == 0) MMC_THROW();
          tmp47 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp48 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp = tmp47;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp49 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp50 = _SimCodeC_daeExp(_txt, _i_exp, tmp49, _a_preExp, _a_varDecls);
          _txt = tmp50.targ1;
          _a_preExp = tmp50.targ2;
          _a_varDecls = tmp50.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp51;
          modelica_metatype tmp52;
          modelica_metatype tmp53;
          modelica_integer tmp54;
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          modelica_metatype tmp59;
          SimCodeC_expTypeShort_rettype tmp60;
          modelica_metatype tmp61;
          modelica_metatype tmp62;
          modelica_metatype tmp63;
          SimCodeC_fun__483_rettype tmp64;
          modelica_metatype tmp65;
          modelica_metatype tmp66;
          modelica_metatype tmp67;
          modelica_metatype tmp68;
          SimCodeC_daeExp_rettype tmp69;
          modelica_metatype tmp70;
          Tpl_writeTok_rettype tmp71;
          Tpl_writeText_rettype tmp72;
          modelica_metatype tmp73;
          Tpl_writeTok_rettype tmp74;
          Tpl_writeText_rettype tmp75;
          modelica_metatype tmp76;
          Tpl_writeTok_rettype tmp77;
          Tpl_writeText_rettype tmp78;
          modelica_metatype tmp79;
          Tpl_writeTok_rettype tmp80;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,5) == 0) MMC_THROW();
          tmp51 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp52 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp53 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp54 = mmc_unbox_integer(tmp53);
          tmp55 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp56 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp51;
          _i_outputIndex = tmp54;
          _i_type__ = tmp55;
          _i_exp = tmp56;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp57 = mmc_mk_nil();
          tmp58 = mmc_mk_nil();
          tmp59 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp57, tmp58);
          tmp60 = _SimCodeC_expTypeShort(tmp59, _i_type__);
          _l_typeStr = tmp60.SimCodeC_expTypeShort_rettype_1;
          tmp61 = mmc_mk_nil();
          tmp62 = mmc_mk_nil();
          tmp63 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp61, tmp62);
          tmp64 = _SimCodeC_fun__483(tmp63, (modelica_integer)_i_outputIndex, _i_c);
          _l_name = tmp64.SimCodeC_fun__483_rettype_1;
          tmp65 = mmc_mk_nil();
          tmp66 = mmc_mk_nil();
          tmp67 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp65, tmp66);
          tmp68 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp69 = _SimCodeC_daeExp(tmp67, _i_exp, tmp68, _a_preExp, _a_varDecls);
          _l_dim = tmp69.targ1;
          _a_preExp = tmp69.targ2;
          _a_varDecls = tmp69.targ3;
          tmp70 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("size_of_dimension_"));
          tmp71 = _Tpl_writeTok(_txt, tmp70);
          _txt = tmp71.Tpl_writeTok_rettype_1;
          tmp72 = _Tpl_writeText(_txt, _l_typeStr);
          _txt = tmp72.Tpl_writeText_rettype_1;
          tmp73 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_array("));
          tmp74 = _Tpl_writeTok(_txt, tmp73);
          _txt = tmp74.Tpl_writeTok_rettype_1;
          tmp75 = _Tpl_writeText(_txt, _l_name);
          _txt = tmp75.Tpl_writeText_rettype_1;
          tmp76 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp77 = _Tpl_writeTok(_txt, tmp76);
          _txt = tmp77.Tpl_writeTok_rettype_1;
          tmp78 = _Tpl_writeText(_txt, _l_dim);
          _txt = tmp78.Tpl_writeText_rettype_1;
          tmp79 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp80 = _Tpl_writeTok(_txt, tmp79);
          _txt = tmp80.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 4: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_extArg_rettypeboxed boxptr_SimCodeC_extArg(modelica_metatype _in_txt, modelica_metatype _in_a_extArg, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_extArg_rettypeboxed tmp1;
  SimCodeC_extArg_rettype tmp2;
  tmp2 = _SimCodeC_extArg(_in_txt, _in_a_extArg, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_extArg_rettypeboxed_1 = tmp2.SimCodeC_extArg_rettype_1;
  tmp1.SimCodeC_extArg_rettypeboxed_2 = tmp2.SimCodeC_extArg_rettype_2;
  tmp1.SimCodeC_extArg_rettypeboxed_3 = tmp2.SimCodeC_extArg_rettype_3;
  return tmp1;
}
SimCodeC_fun__483_rettype _SimCodeC_fun__483(modelica_metatype _in_txt, modelica_integer _in_a_outputIndex, modelica_metatype _in_a_c)
{
  SimCodeC_fun__483_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_outputIndex;
    tmp3_in2 = _in_a_c;
    {
      modelica_metatype _txt;
      modelica_metatype _a_c;
      modelica_integer _i_outputIndex;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          SimCodeC_contextCref_rettype tmp7;
          if (0 != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_c = tmp3_in2;
          tmp6 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp7 = _SimCodeC_contextCref(_txt, _a_c, tmp6);
          _txt = tmp7.SimCodeC_contextCref_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          intString_rettype tmp10;
          Tpl_writeStr_rettype tmp11;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_outputIndex = tmp3_in1;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("out.targ"));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp10 = intString((modelica_integer)_i_outputIndex);
          tmp11 = _Tpl_writeStr(_txt, tmp10);
          _txt = tmp11.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__483_rettypeboxed boxptr_SimCodeC_fun__483(modelica_metatype _in_txt, modelica_metatype _in_a_outputIndex, modelica_metatype _in_a_c)
{
  SimCodeC_fun__483_rettypeboxed tmp1;
  SimCodeC_fun__483_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_outputIndex);
  tmp2 = _SimCodeC_fun__483(_in_txt, tmp3, _in_a_c);
  tmp1.SimCodeC_fun__483_rettypeboxed_1 = tmp2.SimCodeC_fun__483_rettype_1;
  return tmp1;
}
SimCodeC_fun__482_rettype _SimCodeC_fun__482(modelica_metatype _in_txt, modelica_integer _in_a_oi, modelica_metatype _in_a_t)
{
  SimCodeC_fun__482_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    tmp3_in2 = _in_a_t;
    {
      modelica_metatype _txt;
      modelica_metatype _a_t;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_fun__481_rettype tmp6;
          if (0 != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_t = tmp3_in2;
          tmp6 = _SimCodeC_fun__481(_txt, _a_t);
          _txt = tmp6.SimCodeC_fun__481_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext"));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__482_rettypeboxed boxptr_SimCodeC_fun__482(modelica_metatype _in_txt, modelica_metatype _in_a_oi, modelica_metatype _in_a_t)
{
  SimCodeC_fun__482_rettypeboxed tmp1;
  SimCodeC_fun__482_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__482(_in_txt, tmp3, _in_a_t);
  tmp1.SimCodeC_fun__482_rettypeboxed_1 = tmp2.SimCodeC_fun__482_rettype_1;
  return tmp1;
}
SimCodeC_fun__481_rettype _SimCodeC_fun__481(modelica_metatype _in_txt, modelica_metatype _in_a_t)
{
  SimCodeC_fun__481_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_t;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ext"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__481_rettypeboxed boxptr_SimCodeC_fun__481(modelica_metatype _in_txt, modelica_metatype _in_a_t)
{
  SimCodeC_fun__481_rettypeboxed tmp1;
  SimCodeC_fun__481_rettype tmp2;
  tmp2 = _SimCodeC_fun__481(_in_txt, _in_a_t);
  tmp1.SimCodeC_fun__481_rettypeboxed_1 = tmp2.SimCodeC_fun__481_rettype_1;
  return tmp1;
}
SimCodeC_fun__480_rettype _SimCodeC_fun__480(modelica_metatype _in_txt, modelica_integer _in_a_oi)
{
  SimCodeC_fun__480_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (0 != tmp3_in1) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("&"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__480_rettypeboxed boxptr_SimCodeC_fun__480(modelica_metatype _in_txt, modelica_metatype _in_a_oi)
{
  SimCodeC_fun__480_rettypeboxed tmp1;
  SimCodeC_fun__480_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__480(_in_txt, tmp3);
  tmp1.SimCodeC_fun__480_rettypeboxed_1 = tmp2.SimCodeC_fun__480_rettype_1;
  return tmp1;
}
SimCodeC_fun__479_rettype _SimCodeC_fun__479(modelica_metatype _in_txt, modelica_integer _in_a_oi, modelica_metatype _in_a_c)
{
  SimCodeC_fun__479_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_integer tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = (modelica_integer)_in_a_oi;
    tmp3_in2 = _in_a_c;
    {
      modelica_metatype _txt;
      modelica_metatype _a_c;
      modelica_integer _i_oi;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          SimCodeC_contextCref_rettype tmp7;
          if (0 != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_c = tmp3_in2;
          tmp6 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp7 = _SimCodeC_contextCref(_txt, _a_c, tmp6);
          _txt = tmp7.SimCodeC_contextCref_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          intString_rettype tmp10;
          Tpl_writeStr_rettype tmp11;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_oi = tmp3_in1;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("out.targ"));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp10 = intString((modelica_integer)_i_oi);
          tmp11 = _Tpl_writeStr(_txt, tmp10);
          _txt = tmp11.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__479_rettypeboxed boxptr_SimCodeC_fun__479(modelica_metatype _in_txt, modelica_metatype _in_a_oi, modelica_metatype _in_a_c)
{
  SimCodeC_fun__479_rettypeboxed tmp1;
  SimCodeC_fun__479_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_oi);
  tmp2 = _SimCodeC_fun__479(_in_txt, tmp3, _in_a_c);
  tmp1.SimCodeC_fun__479_rettypeboxed_1 = tmp2.SimCodeC_fun__479_rettype_1;
  return tmp1;
}
SimCodeC_fun__368_rettype _SimCodeC_fun__368(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__368_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_tempDecl_rettype tmp6;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp6 = _SimCodeC_tempDecl(_txt, "state", _a_varDecls);
          _txt = tmp6.targ1;
          _a_varDecls = tmp6.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__368_rettypeboxed boxptr_SimCodeC_fun__368(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__368_rettypeboxed tmp1;
  SimCodeC_fun__368_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__368(_in_txt, tmp3, _in_a_varDecls);
  tmp1.SimCodeC_fun__368_rettypeboxed_1 = tmp2.SimCodeC_fun__368_rettype_1;
  tmp1.SimCodeC_fun__368_rettypeboxed_2 = tmp2.SimCodeC_fun__368_rettype_2;
  return tmp1;
}
SimCodeC_fun__367_rettype _SimCodeC_fun__367(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__367_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_retType;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_retType;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_textString_rettype tmp6;
          SimCodeC_outDecl_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_retType = tmp3_in3;
          tmp6 = _Tpl_textString(_a_retType);
          tmp7 = _SimCodeC_outDecl(_txt, tmp6.Tpl_textString_rettype_1, _a_varDecls);
          _txt = tmp7.targ1;
          _a_varDecls = tmp7.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__367_rettypeboxed boxptr_SimCodeC_fun__367(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__367_rettypeboxed tmp1;
  SimCodeC_fun__367_rettype tmp2;
  tmp2 = _SimCodeC_fun__367(_in_txt, _in_a_outVars, _in_a_varDecls, _in_a_retType);
  tmp1.SimCodeC_fun__367_rettypeboxed_1 = tmp2.SimCodeC_fun__367_rettype_1;
  tmp1.SimCodeC_fun__367_rettypeboxed_2 = tmp2.SimCodeC_fun__367_rettype_2;
  return tmp1;
}
SimCodeC_outDecl_rettype _SimCodeC_outDecl(modelica_metatype _txt, modelica_string _a_ty, modelica_metatype _a_varDecls)
{
  SimCodeC_outDecl_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _l_newVar;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  modelica_metatype tmp5;
  Tpl_writeTok_rettype tmp6;
  Tpl_writeStr_rettype tmp7;
  modelica_metatype tmp8;
  Tpl_writeTok_rettype tmp9;
  Tpl_writeText_rettype tmp10;
  modelica_metatype tmp11;
  Tpl_writeTok_rettype tmp12;
  modelica_metatype tmp13;
  Tpl_writeTok_rettype tmp14;
  Tpl_writeText_rettype tmp15;


  tmp2 = mmc_mk_nil();
  tmp3 = mmc_mk_nil();
  tmp4 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp2, tmp3);
  tmp5 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("out"));
  tmp6 = _Tpl_writeTok(tmp4, tmp5);
  _l_newVar = tmp6.Tpl_writeTok_rettype_1;
  tmp7 = _Tpl_writeStr(_a_varDecls, _a_ty);
  _out_a_varDecls = tmp7.Tpl_writeStr_rettype_1;
  tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
  tmp9 = _Tpl_writeTok(_out_a_varDecls, tmp8);
  _out_a_varDecls = tmp9.Tpl_writeTok_rettype_1;
  tmp10 = _Tpl_writeText(_out_a_varDecls, _l_newVar);
  _out_a_varDecls = tmp10.Tpl_writeText_rettype_1;
  tmp11 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
  tmp12 = _Tpl_writeTok(_out_a_varDecls, tmp11);
  _out_a_varDecls = tmp12.Tpl_writeTok_rettype_1;
  tmp13 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp14 = _Tpl_writeTok(_out_a_varDecls, tmp13);
  _out_a_varDecls = tmp14.Tpl_writeTok_rettype_1;
  tmp15 = _Tpl_writeText(_txt, _l_newVar);
  _out_txt = tmp15.Tpl_writeText_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_outDecl_rettypeboxed boxptr_SimCodeC_outDecl(modelica_metatype _txt, modelica_metatype _a_ty, modelica_metatype _a_varDecls)
{
  SimCodeC_outDecl_rettypeboxed tmp1;
  SimCodeC_outDecl_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_a_ty);
  tmp2 = _SimCodeC_outDecl(_txt, tmp3, _a_varDecls);
  tmp1.SimCodeC_outDecl_rettypeboxed_1 = tmp2.SimCodeC_outDecl_rettype_1;
  tmp1.SimCodeC_outDecl_rettypeboxed_2 = tmp2.SimCodeC_outDecl_rettype_2;
  return tmp1;
}
SimCodeC_fun__366_rettype _SimCodeC_fun__366(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__366_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_metatype _a_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fname = tmp3_in2;
          tmp8 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__366_rettypeboxed boxptr_SimCodeC_fun__366(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__366_rettypeboxed tmp1;
  SimCodeC_fun__366_rettype tmp2;
  tmp2 = _SimCodeC_fun__366(_in_txt, _in_a_outVars, _in_a_fname);
  tmp1.SimCodeC_fun__366_rettypeboxed_1 = tmp2.SimCodeC_fun__366_rettype_1;
  return tmp1;
}
SimCodeC_functionBodyRegularFunction_rettype _SimCodeC_functionBodyRegularFunction(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_boolean _in_a_inFunc)
{
  SimCodeC_functionBodyRegularFunction_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_boolean tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    tmp3_in2 = _in_a_inFunc;
    {
      modelica_metatype _txt;
      modelica_boolean _a_inFunc;
      modelica_metatype _i_fn;
      modelica_metatype _i_body;
      modelica_metatype _i_functionArguments;
      modelica_metatype _i_variableDeclarations;
      modelica_metatype _i_outVars;
      modelica_metatype _i_name;
      modelica_boolean _ret_17;
      modelica_boolean _ret_16;
      modelica_boolean _ret_15;
      modelica_metatype _l_boxedFn;
      modelica_metatype _l_0__1;
      modelica_metatype _l_outVarAssign;
      modelica_metatype _l_outVarCopy;
      modelica_metatype _l_outVarInits;
      modelica_metatype _l_bodyPart;
      modelica_metatype _l_funArgs;
      modelica_metatype _l_0__;
      modelica_boolean _ret_6;
      modelica_metatype _l_stateVar;
      modelica_metatype _l_retVar;
      modelica_metatype _l_varInits;
      modelica_metatype _l_varDecls;
      modelica_metatype _l_retType;
      modelica_metatype _l_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          SimCodeC_underscorePath_rettype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          SimCodeC_fun__345_rettype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          SimCodeC_fun__346_rettype tmp29;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          SimCodeC_fun__347_rettype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          Tpl_pushIter_rettype tmp41;
          SimCodeC_lm__348_rettype tmp42;
          Tpl_popIter_rettype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          modelica_metatype tmp50;
          Tpl_pushIter_rettype tmp51;
          SimCodeC_lm__349_rettype tmp52;
          Tpl_popIter_rettype tmp53;
          modelica_metatype tmp54;
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          modelica_metatype tmp59;
          modelica_metatype tmp60;
          Tpl_pushIter_rettype tmp61;
          SimCodeC_lm__350_rettype tmp62;
          Tpl_popIter_rettype tmp63;
          modelica_metatype tmp64;
          modelica_metatype tmp65;
          modelica_metatype tmp66;
          modelica_metatype tmp67;
          modelica_metatype tmp68;
          modelica_metatype tmp69;
          modelica_metatype tmp70;
          modelica_metatype tmp71;
          modelica_metatype tmp72;
          modelica_metatype tmp73;
          modelica_metatype tmp74;
          modelica_metatype tmp75;
          modelica_metatype tmp76;
          modelica_metatype tmp77;
          modelica_metatype tmp78;
          modelica_metatype tmp79;
          modelica_metatype tmp80;
          Tpl_pushIter_rettype tmp81;
          SimCodeC_lm__351_rettype tmp82;
          Tpl_popIter_rettype tmp83;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp84;
          modelica_metatype tmp85;
          modelica_metatype tmp86;
          modelica_metatype tmp87;
          SimCodeC_fun__352_rettype tmp88;
          Tpl_writeText_rettype tmp89;
          modelica_metatype tmp90;
          Tpl_writeTok_rettype tmp91;
          Tpl_writeText_rettype tmp92;
          modelica_metatype tmp93;
          Tpl_writeTok_rettype tmp94;
          modelica_metatype tmp95;
          modelica_metatype tmp96;
          modelica_metatype tmp97;
          modelica_metatype tmp98;
          Tpl_pushIter_rettype tmp99;
          SimCodeC_lm__353_rettype tmp100;
          Tpl_popIter_rettype tmp101;
          modelica_metatype tmp102;
          modelica_metatype tmp103;
          Tpl_writeTok_rettype tmp104;
          modelica_metatype tmp105;
          Tpl_pushBlock_rettype tmp106;
          Tpl_writeText_rettype tmp107;
          Tpl_softNewLine_rettype tmp108;
          Tpl_writeText_rettype tmp109;
          Tpl_softNewLine_rettype tmp110;
          Tpl_writeText_rettype tmp111;
          Tpl_softNewLine_rettype tmp112;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp113;
          SimCodeC_fun__354_rettype tmp114;
          Tpl_softNewLine_rettype tmp115;
          modelica_metatype tmp116;
          Tpl_writeTok_rettype tmp117;
          Tpl_writeText_rettype tmp118;
          Tpl_softNewLine_rettype tmp119;
          modelica_metatype tmp120;
          Tpl_writeTok_rettype tmp121;
          Tpl_writeText_rettype tmp122;
          Tpl_softNewLine_rettype tmp123;
          modelica_metatype tmp124;
          modelica_metatype tmp125;
          Tpl_writeTok_rettype tmp126;
          Tpl_writeText_rettype tmp127;
          Tpl_softNewLine_rettype tmp128;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp129;
          SimCodeC_fun__355_rettype tmp130;
          Tpl_softNewLine_rettype tmp131;
          Tpl_writeText_rettype tmp132;
          Tpl_softNewLine_rettype tmp133;
          modelica_metatype tmp134;
          Tpl_writeTok_rettype tmp135;
          SimCodeC_fun__356_rettype tmp136;
          modelica_metatype tmp137;
          Tpl_writeTok_rettype tmp138;
          Tpl_popBlock_rettype tmp139;
          modelica_metatype tmp140;
          modelica_metatype tmp141;
          Tpl_writeTok_rettype tmp142;
          SimCodeC_fun__364_rettype tmp143;
          Tpl_softNewLine_rettype tmp144;
          modelica_metatype tmp145;
          Tpl_writeTok_rettype tmp146;
          Tpl_writeText_rettype tmp147;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,6) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp3_in1;
          _i_name = tmp6;
          _i_outVars = tmp8;
          _i_functionArguments = tmp9;
          _i_variableDeclarations = tmp10;
          _i_body = tmp11;
          _a_inFunc = tmp3_in2;
          _System_tmpTickReset(1);
          /* NORETCALL */;
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp12, tmp13);
          tmp15 = _SimCodeC_underscorePath(tmp14, _i_name);
          _l_fname = tmp15.SimCodeC_underscorePath_rettype_1;
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp16, tmp17);
          tmp19 = _SimCodeC_fun__345(tmp18, _i_outVars, _l_fname);
          _l_retType = tmp19.SimCodeC_fun__345_rettype_1;
          tmp20 = mmc_mk_nil();
          tmp21 = mmc_mk_nil();
          tmp22 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp20, tmp21);
          _l_varDecls = tmp22;
          tmp23 = mmc_mk_nil();
          tmp24 = mmc_mk_nil();
          tmp25 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp23, tmp24);
          _l_varInits = tmp25;
          tmp26 = mmc_mk_nil();
          tmp27 = mmc_mk_nil();
          tmp28 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp26, tmp27);
          tmp29 = _SimCodeC_fun__346(tmp28, _i_outVars, _l_varDecls, _l_retType);
          _l_retVar = tmp29.targ1;
          _l_varDecls = tmp29.targ2;
          tmp30 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_6 = tmp30.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp31 = mmc_mk_nil();
          tmp32 = mmc_mk_nil();
          tmp33 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp31, tmp32);
          tmp34 = _SimCodeC_fun__347(tmp33, _ret_6, _l_varDecls);
          _l_stateVar = tmp34.targ1;
          _l_varDecls = tmp34.targ2;
          tmp35 = mmc_mk_nil();
          tmp36 = mmc_mk_nil();
          tmp37 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp35, tmp36);
          tmp38 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp39 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp40 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_none(), mmc_mk_none(), mmc_mk_integer(0), mmc_mk_integer(0), tmp38, mmc_mk_integer(0), tmp39);
          tmp41 = _Tpl_pushIter(tmp37, tmp40);
          _l_0__ = tmp41.Tpl_pushIter_rettype_1;
          tmp42 = _SimCodeC_lm__348(_l_0__, _i_variableDeclarations, _l_varInits, _l_varDecls);
          _l_0__ = tmp42.targ1;
          _l_varInits = tmp42.targ2;
          _l_varDecls = tmp42.targ3;
          tmp43 = _Tpl_popIter(_l_0__);
          _l_0__ = tmp43.Tpl_popIter_rettype_1;
          tmp44 = mmc_mk_nil();
          tmp45 = mmc_mk_nil();
          tmp46 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp44, tmp45);
          tmp47 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp48 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp49 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp50 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp47), mmc_mk_integer(0), mmc_mk_integer(0), tmp48, mmc_mk_integer(0), tmp49);
          tmp51 = _Tpl_pushIter(tmp46, tmp50);
          _l_funArgs = tmp51.Tpl_pushIter_rettype_1;
          tmp52 = _SimCodeC_lm__349(_l_funArgs, _i_functionArguments, _l_varInits);
          _l_funArgs = tmp52.targ1;
          _l_varInits = tmp52.targ2;
          tmp53 = _Tpl_popIter(_l_funArgs);
          _l_funArgs = tmp53.Tpl_popIter_rettype_1;
          tmp54 = mmc_mk_nil();
          tmp55 = mmc_mk_nil();
          tmp56 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp54, tmp55);
          tmp57 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp58 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp59 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp60 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp57), mmc_mk_integer(0), mmc_mk_integer(0), tmp58, mmc_mk_integer(0), tmp59);
          tmp61 = _Tpl_pushIter(tmp56, tmp60);
          _l_bodyPart = tmp61.Tpl_pushIter_rettype_1;
          tmp62 = _SimCodeC_lm__350(_l_bodyPart, _i_body, _l_varDecls);
          _l_bodyPart = tmp62.targ1;
          _l_varDecls = tmp62.targ2;
          tmp63 = _Tpl_popIter(_l_bodyPart);
          _l_bodyPart = tmp63.Tpl_popIter_rettype_1;
          tmp64 = mmc_mk_nil();
          tmp65 = mmc_mk_nil();
          tmp66 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp64, tmp65);
          _l_outVarInits = tmp66;
          tmp67 = mmc_mk_nil();
          tmp68 = mmc_mk_nil();
          tmp69 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp67, tmp68);
          _l_outVarCopy = tmp69;
          tmp70 = mmc_mk_nil();
          tmp71 = mmc_mk_nil();
          tmp72 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp70, tmp71);
          _l_outVarAssign = tmp72;
          tmp73 = mmc_mk_nil();
          tmp74 = mmc_mk_nil();
          tmp75 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp73, tmp74);
          tmp76 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(""));
          tmp77 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp78 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp79 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp80 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_some(tmp76), mmc_mk_some(tmp77), mmc_mk_integer(0), mmc_mk_integer(0), tmp78, mmc_mk_integer(0), tmp79);
          tmp81 = _Tpl_pushIter(tmp75, tmp80);
          _l_0__1 = tmp81.Tpl_pushIter_rettype_1;
          tmp82 = _SimCodeC_lm__351(_l_0__1, _i_outVars, _l_outVarAssign, _l_outVarCopy, _l_outVarInits, _l_varDecls, _l_retVar);
          _l_0__1 = tmp82.targ1;
          _l_outVarAssign = tmp82.targ2;
          _l_outVarCopy = tmp82.targ3;
          _l_outVarInits = tmp82.targ4;
          _l_varDecls = tmp82.targ5;
          tmp83 = _Tpl_popIter(_l_0__1);
          _l_0__1 = tmp83.Tpl_popIter_rettype_1;
          tmp84 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_15 = tmp84.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp85 = mmc_mk_nil();
          tmp86 = mmc_mk_nil();
          tmp87 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp85, tmp86);
          tmp88 = _SimCodeC_fun__352(tmp87, _ret_15, _i_fn);
          _l_boxedFn = tmp88.SimCodeC_fun__352_rettype_1;
          tmp89 = _Tpl_writeText(_txt, _l_retType);
          _txt = tmp89.Tpl_writeText_rettype_1;
          tmp90 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" _"));
          tmp91 = _Tpl_writeTok(_txt, tmp90);
          _txt = tmp91.Tpl_writeTok_rettype_1;
          tmp92 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp92.Tpl_writeText_rettype_1;
          tmp93 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp94 = _Tpl_writeTok(_txt, tmp93);
          _txt = tmp94.Tpl_writeTok_rettype_1;
          tmp95 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp96 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp97 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp98 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp95), mmc_mk_integer(0), mmc_mk_integer(0), tmp96, mmc_mk_integer(0), tmp97);
          tmp99 = _Tpl_pushIter(_txt, tmp98);
          _txt = tmp99.Tpl_pushIter_rettype_1;
          tmp100 = _SimCodeC_lm__353(_txt, _i_functionArguments);
          _txt = tmp100.SimCodeC_lm__353_rettype_1;
          tmp101 = _Tpl_popIter(_txt);
          _txt = tmp101.Tpl_popIter_rettype_1;
          tmp102 = mmc_mk_cons(mmc_mk_scon(")\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
          tmp103 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp102, mmc_mk_boolean((1)));
          tmp104 = _Tpl_writeTok(_txt, tmp103);
          _txt = tmp104.Tpl_writeTok_rettype_1;
          tmp105 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp106 = _Tpl_pushBlock(_txt, tmp105);
          _txt = tmp106.Tpl_pushBlock_rettype_1;
          tmp107 = _Tpl_writeText(_txt, _l_funArgs);
          _txt = tmp107.Tpl_writeText_rettype_1;
          tmp108 = _Tpl_softNewLine(_txt);
          _txt = tmp108.Tpl_softNewLine_rettype_1;
          tmp109 = _Tpl_writeText(_txt, _l_varDecls);
          _txt = tmp109.Tpl_writeText_rettype_1;
          tmp110 = _Tpl_softNewLine(_txt);
          _txt = tmp110.Tpl_softNewLine_rettype_1;
          tmp111 = _Tpl_writeText(_txt, _l_outVarInits);
          _txt = tmp111.Tpl_writeText_rettype_1;
          tmp112 = _Tpl_softNewLine(_txt);
          _txt = tmp112.Tpl_softNewLine_rettype_1;
          tmp113 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_16 = tmp113.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp114 = _SimCodeC_fun__354(_txt, _ret_16, _l_stateVar);
          _txt = tmp114.SimCodeC_fun__354_rettype_1;
          tmp115 = _Tpl_softNewLine(_txt);
          _txt = tmp115.Tpl_softNewLine_rettype_1;
          tmp116 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp117 = _Tpl_writeTok(_txt, tmp116);
          _txt = tmp117.Tpl_writeTok_rettype_1;
          tmp118 = _Tpl_writeText(_txt, _l_varInits);
          _txt = tmp118.Tpl_writeText_rettype_1;
          tmp119 = _Tpl_softNewLine(_txt);
          _txt = tmp119.Tpl_softNewLine_rettype_1;
          tmp120 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp121 = _Tpl_writeTok(_txt, tmp120);
          _txt = tmp121.Tpl_writeTok_rettype_1;
          tmp122 = _Tpl_writeText(_txt, _l_bodyPart);
          _txt = tmp122.Tpl_writeText_rettype_1;
          tmp123 = _Tpl_softNewLine(_txt);
          _txt = tmp123.Tpl_softNewLine_rettype_1;
          tmp124 = mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_cons(mmc_mk_scon("_return:\n"), mmc_mk_nil()));
          tmp125 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp124, mmc_mk_boolean((1)));
          tmp126 = _Tpl_writeTok(_txt, tmp125);
          _txt = tmp126.Tpl_writeTok_rettype_1;
          tmp127 = _Tpl_writeText(_txt, _l_outVarCopy);
          _txt = tmp127.Tpl_writeText_rettype_1;
          tmp128 = _Tpl_softNewLine(_txt);
          _txt = tmp128.Tpl_softNewLine_rettype_1;
          tmp129 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_17 = tmp129.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp130 = _SimCodeC_fun__355(_txt, _ret_17, _l_stateVar);
          _txt = tmp130.SimCodeC_fun__355_rettype_1;
          tmp131 = _Tpl_softNewLine(_txt);
          _txt = tmp131.Tpl_softNewLine_rettype_1;
          tmp132 = _Tpl_writeText(_txt, _l_outVarAssign);
          _txt = tmp132.Tpl_writeText_rettype_1;
          tmp133 = _Tpl_softNewLine(_txt);
          _txt = tmp133.Tpl_softNewLine_rettype_1;
          tmp134 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("return"));
          tmp135 = _Tpl_writeTok(_txt, tmp134);
          _txt = tmp135.Tpl_writeTok_rettype_1;
          tmp136 = _SimCodeC_fun__356(_txt, _i_outVars, _l_retVar);
          _txt = tmp136.SimCodeC_fun__356_rettype_1;
          tmp137 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(";\n"));
          tmp138 = _Tpl_writeTok(_txt, tmp137);
          _txt = tmp138.Tpl_writeTok_rettype_1;
          tmp139 = _Tpl_popBlock(_txt);
          _txt = tmp139.Tpl_popBlock_rettype_1;
          tmp140 = mmc_mk_cons(mmc_mk_scon("}\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()));
          tmp141 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp140, mmc_mk_boolean((1)));
          tmp142 = _Tpl_writeTok(_txt, tmp141);
          _txt = tmp142.Tpl_writeTok_rettype_1;
          tmp143 = _SimCodeC_fun__364(_txt, _a_inFunc, _l_retType, _i_outVars, _i_functionArguments, _l_fname);
          _txt = tmp143.SimCodeC_fun__364_rettype_1;
          tmp144 = _Tpl_softNewLine(_txt);
          _txt = tmp144.Tpl_softNewLine_rettype_1;
          tmp145 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp146 = _Tpl_writeTok(_txt, tmp145);
          _txt = tmp146.Tpl_writeTok_rettype_1;
          tmp147 = _Tpl_writeText(_txt, _l_boxedFn);
          _txt = tmp147.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionBodyRegularFunction_rettypeboxed boxptr_SimCodeC_functionBodyRegularFunction(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_metatype _in_a_inFunc)
{
  SimCodeC_functionBodyRegularFunction_rettypeboxed tmp1;
  SimCodeC_functionBodyRegularFunction_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_inFunc);
  tmp2 = _SimCodeC_functionBodyRegularFunction(_in_txt, _in_a_fn, tmp3);
  tmp1.SimCodeC_functionBodyRegularFunction_rettypeboxed_1 = tmp2.SimCodeC_functionBodyRegularFunction_rettype_1;
  return tmp1;
}
SimCodeC_fun__364_rettype _SimCodeC_fun__364(modelica_metatype _in_txt, modelica_boolean _in_a_inFunc, modelica_metatype _in_a_retType, modelica_metatype _in_a_outVars, modelica_metatype _in_a_functionArguments, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__364_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_inFunc;
    tmp3_in2 = _in_a_retType;
    tmp3_in3 = _in_a_outVars;
    tmp3_in4 = _in_a_functionArguments;
    tmp3_in5 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_metatype _a_retType;
      modelica_metatype _a_outVars;
      modelica_metatype _a_functionArguments;
      modelica_metatype _a_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_pushBlock_rettype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          Tpl_pushIter_rettype tmp18;
          SimCodeC_lm__357_rettype tmp19;
          Tpl_popIter_rettype tmp20;
          Tpl_softNewLine_rettype tmp21;
          SimCodeC_fun__358_rettype tmp22;
          Tpl_softNewLine_rettype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          Tpl_pushIter_rettype tmp28;
          SimCodeC_lm__359_rettype tmp29;
          Tpl_popIter_rettype tmp30;
          Tpl_softNewLine_rettype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          SimCodeC_fun__360_rettype tmp34;
          modelica_metatype tmp35;
          Tpl_writeTok_rettype tmp36;
          Tpl_writeText_rettype tmp37;
          modelica_metatype tmp38;
          Tpl_writeTok_rettype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          Tpl_pushIter_rettype tmp44;
          SimCodeC_lm__361_rettype tmp45;
          Tpl_popIter_rettype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          Tpl_writeTok_rettype tmp49;
          SimCodeC_fun__363_rettype tmp50;
          Tpl_softNewLine_rettype tmp51;
          modelica_metatype tmp52;
          Tpl_writeTok_rettype tmp53;
          Tpl_popBlock_rettype tmp54;
          modelica_metatype tmp55;
          Tpl_writeTok_rettype tmp56;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_retType = tmp3_in2;
          _a_outVars = tmp3_in3;
          _a_functionArguments = tmp3_in4;
          _a_fname = tmp3_in5;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("int in_"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_cons(mmc_mk_scon("(type_description * inArgs, type_description * outVar)\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
          tmp10 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp9, mmc_mk_boolean((1)));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp13 = _Tpl_pushBlock(_txt, tmp12);
          _txt = tmp13.Tpl_pushBlock_rettype_1;
          tmp14 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp15 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp16 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp17 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp14), mmc_mk_integer(0), mmc_mk_integer(0), tmp15, mmc_mk_integer(0), tmp16);
          tmp18 = _Tpl_pushIter(_txt, tmp17);
          _txt = tmp18.Tpl_pushIter_rettype_1;
          tmp19 = _SimCodeC_lm__357(_txt, _a_functionArguments);
          _txt = tmp19.SimCodeC_lm__357_rettype_1;
          tmp20 = _Tpl_popIter(_txt);
          _txt = tmp20.Tpl_popIter_rettype_1;
          tmp21 = _Tpl_softNewLine(_txt);
          _txt = tmp21.Tpl_softNewLine_rettype_1;
          tmp22 = _SimCodeC_fun__358(_txt, _a_outVars, _a_retType);
          _txt = tmp22.SimCodeC_fun__358_rettype_1;
          tmp23 = _Tpl_softNewLine(_txt);
          _txt = tmp23.Tpl_softNewLine_rettype_1;
          tmp24 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp25 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp26 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp27 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp24), mmc_mk_integer(0), mmc_mk_integer(0), tmp25, mmc_mk_integer(0), tmp26);
          tmp28 = _Tpl_pushIter(_txt, tmp27);
          _txt = tmp28.Tpl_pushIter_rettype_1;
          tmp29 = _SimCodeC_lm__359(_txt, _a_functionArguments);
          _txt = tmp29.SimCodeC_lm__359_rettype_1;
          tmp30 = _Tpl_popIter(_txt);
          _txt = tmp30.Tpl_popIter_rettype_1;
          tmp31 = _Tpl_softNewLine(_txt);
          _txt = tmp31.Tpl_softNewLine_rettype_1;
          tmp32 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("MMC_TRY_TOP()\n"));
          tmp33 = _Tpl_writeTok(_txt, tmp32);
          _txt = tmp33.Tpl_writeTok_rettype_1;
          tmp34 = _SimCodeC_fun__360(_txt, _a_outVars);
          _txt = tmp34.SimCodeC_fun__360_rettype_1;
          tmp35 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp36 = _Tpl_writeTok(_txt, tmp35);
          _txt = tmp36.Tpl_writeTok_rettype_1;
          tmp37 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp37.Tpl_writeText_rettype_1;
          tmp38 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp39 = _Tpl_writeTok(_txt, tmp38);
          _txt = tmp39.Tpl_writeTok_rettype_1;
          tmp40 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp41 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp42 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp43 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp40), mmc_mk_integer(0), mmc_mk_integer(0), tmp41, mmc_mk_integer(0), tmp42);
          tmp44 = _Tpl_pushIter(_txt, tmp43);
          _txt = tmp44.Tpl_pushIter_rettype_1;
          tmp45 = _SimCodeC_lm__361(_txt, _a_functionArguments);
          _txt = tmp45.SimCodeC_lm__361_rettype_1;
          tmp46 = _Tpl_popIter(_txt);
          _txt = tmp46.Tpl_popIter_rettype_1;
          tmp47 = mmc_mk_cons(mmc_mk_scon(");\n"), mmc_mk_cons(mmc_mk_scon("MMC_CATCH_TOP(return 1)\n"), mmc_mk_nil()));
          tmp48 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp47, mmc_mk_boolean((1)));
          tmp49 = _Tpl_writeTok(_txt, tmp48);
          _txt = tmp49.Tpl_writeTok_rettype_1;
          tmp50 = _SimCodeC_fun__363(_txt, _a_outVars);
          _txt = tmp50.SimCodeC_fun__363_rettype_1;
          tmp51 = _Tpl_softNewLine(_txt);
          _txt = tmp51.Tpl_softNewLine_rettype_1;
          tmp52 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("return 0;\n"));
          tmp53 = _Tpl_writeTok(_txt, tmp52);
          _txt = tmp53.Tpl_writeTok_rettype_1;
          tmp54 = _Tpl_popBlock(_txt);
          _txt = tmp54.Tpl_popBlock_rettype_1;
          tmp55 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("}"));
          tmp56 = _Tpl_writeTok(_txt, tmp55);
          _txt = tmp56.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__364_rettypeboxed boxptr_SimCodeC_fun__364(modelica_metatype _in_txt, modelica_metatype _in_a_inFunc, modelica_metatype _in_a_retType, modelica_metatype _in_a_outVars, modelica_metatype _in_a_functionArguments, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__364_rettypeboxed tmp1;
  SimCodeC_fun__364_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_inFunc);
  tmp2 = _SimCodeC_fun__364(_in_txt, tmp3, _in_a_retType, _in_a_outVars, _in_a_functionArguments, _in_a_fname);
  tmp1.SimCodeC_fun__364_rettypeboxed_1 = tmp2.SimCodeC_fun__364_rettype_1;
  return tmp1;
}
SimCodeC_fun__363_rettype _SimCodeC_fun__363(modelica_metatype _in_txt, modelica_metatype _in_a_outVars)
{
  SimCodeC_fun__363_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    {
      modelica_metatype _txt;
      modelica_metatype _i_outVars;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("write_noretcall(outVar);"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_pushIter_rettype tmp12;
          SimCodeC_lm__362_rettype tmp13;
          Tpl_popIter_rettype tmp14;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_outVars = tmp3_in1;
          tmp8 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp9 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp10 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp11 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_none(), mmc_mk_some(tmp8), mmc_mk_integer(0), mmc_mk_integer(0), tmp9, mmc_mk_integer(0), tmp10);
          tmp12 = _Tpl_pushIter(_txt, tmp11);
          _txt = tmp12.Tpl_pushIter_rettype_1;
          tmp13 = _SimCodeC_lm__362(_txt, _i_outVars);
          _txt = tmp13.SimCodeC_lm__362_rettype_1;
          tmp14 = _Tpl_popIter(_txt);
          _txt = tmp14.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__363_rettypeboxed boxptr_SimCodeC_fun__363(modelica_metatype _in_txt, modelica_metatype _in_a_outVars)
{
  SimCodeC_fun__363_rettypeboxed tmp1;
  SimCodeC_fun__363_rettype tmp2;
  tmp2 = _SimCodeC_fun__363(_in_txt, _in_a_outVars);
  tmp1.SimCodeC_fun__363_rettypeboxed_1 = tmp2.SimCodeC_fun__363_rettype_1;
  return tmp1;
}
SimCodeC_writeOutVar_rettype _SimCodeC_writeOutVar(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_integer _in_a_index)
{
  SimCodeC_writeOutVar_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_integer tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    tmp3_in2 = (modelica_integer)_in_a_index;
    {
      modelica_metatype _txt;
      modelica_integer _a_index;
      modelica_metatype _i_var;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          SimCodeC_writeOutVarRecordMembers_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          if (mmc__uniontype__metarecord__typedef__equal(tmp7,5,3) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 4));
          if (mmc__uniontype__metarecord__typedef__equal(tmp10,3,1) == 0) MMC_THROW();
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp10), 2));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_ty = tmp7;
          _a_index = tmp3_in2;
          tmp14 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("write_modelica_record(outVar, "));
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp16 = _SimCodeC_writeOutVarRecordMembers(_txt, _i_ty, (modelica_integer)_a_index, "");
          _txt = tmp16.SimCodeC_writeOutVarRecordMembers_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          SimCodeC_varType_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          intString_rettype tmp28;
          Tpl_writeStr_rettype tmp29;
          modelica_metatype tmp30;
          Tpl_writeTok_rettype tmp31;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp21 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp22 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp3_in1;
          _a_index = tmp3_in2;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("write_"));
          tmp24 = _Tpl_writeTok(_txt, tmp23);
          _txt = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = _SimCodeC_varType(_txt, _i_var);
          _txt = tmp25.SimCodeC_varType_rettype_1;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(outVar, &out.targ"));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = intString((modelica_integer)_a_index);
          tmp29 = _Tpl_writeStr(_txt, tmp28);
          _txt = tmp29.Tpl_writeStr_rettype_1;
          tmp30 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp31 = _Tpl_writeTok(_txt, tmp30);
          _txt = tmp31.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_writeOutVar_rettypeboxed boxptr_SimCodeC_writeOutVar(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_metatype _in_a_index)
{
  SimCodeC_writeOutVar_rettypeboxed tmp1;
  SimCodeC_writeOutVar_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_index);
  tmp2 = _SimCodeC_writeOutVar(_in_txt, _in_a_var, tmp3);
  tmp1.SimCodeC_writeOutVar_rettypeboxed_1 = tmp2.SimCodeC_writeOutVar_rettype_1;
  return tmp1;
}
SimCodeC_writeOutVarRecordMembers_rettype _SimCodeC_writeOutVarRecordMembers(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_integer _in_a_index, modelica_string _in_a_prefix)
{
  SimCodeC_writeOutVarRecordMembers_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_integer tmp3_in2;
    modelica_string tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_type;
    tmp3_in2 = (modelica_integer)_in_a_index;
    tmp3_in3 = _in_a_prefix;
    {
      modelica_metatype _txt;
      modelica_integer _a_index;
      modelica_string _a_prefix;
      modelica_metatype _i_vl;
      modelica_metatype _i_n;
      modelica_metatype _l_args;
      modelica_metatype _l_basename;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_underscorePath_rettype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          Tpl_pushIter_rettype tmp20;
          SimCodeC_lm__421_rettype tmp21;
          Tpl_popIter_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          Tpl_writeText_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          SimCodeC_fun__422_rettype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_n = tmp6;
          _i_vl = tmp7;
          _a_index = tmp3_in2;
          _a_prefix = tmp3_in3;
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp9, tmp10);
          tmp12 = _SimCodeC_underscorePath(tmp11, _i_n);
          _l_basename = tmp12.SimCodeC_underscorePath_rettype_1;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp17 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp18 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp19 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp16), mmc_mk_integer(0), mmc_mk_integer(0), tmp17, mmc_mk_integer(0), tmp18);
          tmp20 = _Tpl_pushIter(tmp15, tmp19);
          _l_args = tmp20.Tpl_pushIter_rettype_1;
          tmp21 = _SimCodeC_lm__421(_l_args, _i_vl, (modelica_integer)_a_index, _a_prefix);
          _l_args = tmp21.SimCodeC_lm__421_rettype_1;
          tmp22 = _Tpl_popIter(_l_args);
          _l_args = tmp22.Tpl_popIter_rettype_1;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("&"));
          tmp24 = _Tpl_writeTok(_txt, tmp23);
          _txt = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = _Tpl_writeText(_txt, _l_basename);
          _txt = tmp25.Tpl_writeText_rettype_1;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("__desc"));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = _SimCodeC_fun__422(_txt, _l_args);
          _txt = tmp28.SimCodeC_fun__422_rettype_1;
          tmp29 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", TYPE_DESC_NONE"));
          tmp30 = _Tpl_writeTok(_txt, tmp29);
          _txt = tmp30.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_writeOutVarRecordMembers_rettypeboxed boxptr_SimCodeC_writeOutVarRecordMembers(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_metatype _in_a_index, modelica_metatype _in_a_prefix)
{
  SimCodeC_writeOutVarRecordMembers_rettypeboxed tmp1;
  SimCodeC_writeOutVarRecordMembers_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_integer(_in_a_index);
  tmp4 = mmc_unbox_string(_in_a_prefix);
  tmp2 = _SimCodeC_writeOutVarRecordMembers(_in_txt, _in_a_type, tmp3, tmp4);
  tmp1.SimCodeC_writeOutVarRecordMembers_rettypeboxed_1 = tmp2.SimCodeC_writeOutVarRecordMembers_rettype_1;
  return tmp1;
}
SimCodeC_fun__422_rettype _SimCodeC_fun__422(modelica_metatype _in_txt, modelica_metatype _in_a_args)
{
  SimCodeC_fun__422_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_args;
    {
      modelica_metatype _txt;
      modelica_metatype _i_args;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          if (!listEmpty(tmp6)) MMC_THROW();
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          Tpl_writeText_rettype tmp10;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_args = tmp3_in1;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp10 = _Tpl_writeText(_txt, _i_args);
          _txt = tmp10.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__422_rettypeboxed boxptr_SimCodeC_fun__422(modelica_metatype _in_txt, modelica_metatype _in_a_args)
{
  SimCodeC_fun__422_rettypeboxed tmp1;
  SimCodeC_fun__422_rettype tmp2;
  tmp2 = _SimCodeC_fun__422(_in_txt, _in_a_args);
  tmp1.SimCodeC_fun__422_rettypeboxed_1 = tmp2.SimCodeC_fun__422_rettype_1;
  return tmp1;
}
SimCodeC_lm__421_rettype _SimCodeC_lm__421(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_integer _in_a_index, modelica_string _in_a_prefix)
{
  SimCodeC_lm__421_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_integer tmp3_in2;
    modelica_string tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = (modelica_integer)_in_a_index;
    tmp3_in3 = _in_a_prefix;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_integer _a_index;
      modelica_string _a_prefix;
      modelica_string _i_subvar_name;
      modelica_metatype _i_tp;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_string tmp9;
          modelica_metatype tmp10;
          SimCodeC_fun__420_rettype tmp11;
          Tpl_nextIter_rettype tmp12;
          SimCodeC_lm__421_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,2) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = mmc_unbox_string(tmp8);
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_subvar_name = tmp9;
          _i_tp = tmp10;
          _rest = tmp7;
          _a_index = tmp3_in2;
          _a_prefix = tmp3_in3;
          tmp11 = _SimCodeC_fun__420(_txt, _i_tp, (modelica_integer)_a_index, _i_subvar_name, _a_prefix);
          _txt = tmp11.SimCodeC_fun__420_rettype_1;
          tmp12 = _Tpl_nextIter(_txt);
          _txt = tmp12.Tpl_nextIter_rettype_1;
          tmp13 = _SimCodeC_lm__421(_txt, _rest, (modelica_integer)_a_index, _a_prefix);
          _txt = tmp13.SimCodeC_lm__421_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          SimCodeC_lm__421_rettype tmp16;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp14 = MMC_CAR(tmp3_in1);
          tmp15 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp15;
          _a_index = tmp3_in2;
          _a_prefix = tmp3_in3;
          tmp16 = _SimCodeC_lm__421(_txt, _rest, (modelica_integer)_a_index, _a_prefix);
          _txt = tmp16.SimCodeC_lm__421_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__421_rettypeboxed boxptr_SimCodeC_lm__421(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_index, modelica_metatype _in_a_prefix)
{
  SimCodeC_lm__421_rettypeboxed tmp1;
  SimCodeC_lm__421_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_integer(_in_a_index);
  tmp4 = mmc_unbox_string(_in_a_prefix);
  tmp2 = _SimCodeC_lm__421(_in_txt, _in_items, tmp3, tmp4);
  tmp1.SimCodeC_lm__421_rettypeboxed_1 = tmp2.SimCodeC_lm__421_rettype_1;
  return tmp1;
}
SimCodeC_fun__420_rettype _SimCodeC_fun__420(modelica_metatype _in_txt, modelica_metatype _in_a_tp, modelica_integer _in_a_index, modelica_string _in_a_subvar_name, modelica_string _in_a_prefix)
{
  SimCodeC_fun__420_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_integer tmp3_in2;
    modelica_string tmp3_in3;
    modelica_string tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_tp;
    tmp3_in2 = (modelica_integer)_in_a_index;
    tmp3_in3 = _in_a_subvar_name;
    tmp3_in4 = _in_a_prefix;
    {
      modelica_metatype _txt;
      modelica_integer _a_index;
      modelica_string _a_subvar_name;
      modelica_string _a_prefix;
      modelica_metatype _i_tp;
      modelica_metatype _l_newPrefix;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_writeStr_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          Tpl_writeStr_rettype tmp15;
          SimCodeC_expTypeRW_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          Tpl_textString_rettype tmp19;
          SimCodeC_writeOutVarRecordMembers_rettype tmp20;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_tp = tmp3_in1;
          _a_index = tmp3_in2;
          _a_subvar_name = tmp3_in3;
          _a_prefix = tmp3_in4;
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp9, tmp10);
          tmp12 = _Tpl_writeStr(tmp11, _a_prefix);
          _l_newPrefix = tmp12.Tpl_writeStr_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp14 = _Tpl_writeTok(_l_newPrefix, tmp13);
          _l_newPrefix = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = _Tpl_writeStr(_l_newPrefix, _a_subvar_name);
          _l_newPrefix = tmp15.Tpl_writeStr_rettype_1;
          tmp16 = _SimCodeC_expTypeRW(_txt, _i_tp);
          _txt = tmp16.SimCodeC_expTypeRW_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp19 = _Tpl_textString(_l_newPrefix);
          tmp20 = _SimCodeC_writeOutVarRecordMembers(_txt, _i_tp, (modelica_integer)_a_index, tmp19.Tpl_textString_rettype_1);
          _txt = tmp20.SimCodeC_writeOutVarRecordMembers_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_expTypeRW_rettype tmp21;
          modelica_metatype tmp22;
          Tpl_writeTok_rettype tmp23;
          intString_rettype tmp24;
          Tpl_writeStr_rettype tmp25;
          Tpl_writeStr_rettype tmp26;
          modelica_metatype tmp27;
          Tpl_writeTok_rettype tmp28;
          Tpl_writeStr_rettype tmp29;
          modelica_metatype tmp30;
          Tpl_writeTok_rettype tmp31;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_tp = tmp3_in1;
          _a_index = tmp3_in2;
          _a_subvar_name = tmp3_in3;
          _a_prefix = tmp3_in4;
          tmp21 = _SimCodeC_expTypeRW(_txt, _i_tp);
          _txt = tmp21.SimCodeC_expTypeRW_rettype_1;
          tmp22 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", &(out.targ"));
          tmp23 = _Tpl_writeTok(_txt, tmp22);
          _txt = tmp23.Tpl_writeTok_rettype_1;
          tmp24 = intString((modelica_integer)_a_index);
          tmp25 = _Tpl_writeStr(_txt, tmp24);
          _txt = tmp25.Tpl_writeStr_rettype_1;
          tmp26 = _Tpl_writeStr(_txt, _a_prefix);
          _txt = tmp26.Tpl_writeStr_rettype_1;
          tmp27 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp28 = _Tpl_writeTok(_txt, tmp27);
          _txt = tmp28.Tpl_writeTok_rettype_1;
          tmp29 = _Tpl_writeStr(_txt, _a_subvar_name);
          _txt = tmp29.Tpl_writeStr_rettype_1;
          tmp30 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp31 = _Tpl_writeTok(_txt, tmp30);
          _txt = tmp31.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__420_rettypeboxed boxptr_SimCodeC_fun__420(modelica_metatype _in_txt, modelica_metatype _in_a_tp, modelica_metatype _in_a_index, modelica_metatype _in_a_subvar_name, modelica_metatype _in_a_prefix)
{
  SimCodeC_fun__420_rettypeboxed tmp1;
  SimCodeC_fun__420_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  modelica_string tmp5;
  tmp3 = mmc_unbox_integer(_in_a_index);
  tmp4 = mmc_unbox_string(_in_a_subvar_name);
  tmp5 = mmc_unbox_string(_in_a_prefix);
  tmp2 = _SimCodeC_fun__420(_in_txt, _in_a_tp, tmp3, tmp4, tmp5);
  tmp1.SimCodeC_fun__420_rettypeboxed_1 = tmp2.SimCodeC_fun__420_rettype_1;
  return tmp1;
}
SimCodeC_expTypeRW_rettype _SimCodeC_expTypeRW(modelica_metatype _in_txt, modelica_metatype _in_a_type)
{
  SimCodeC_expTypeRW_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_type;
    {
      modelica_metatype _txt;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 10 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_INT"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_REAL"));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_STRING"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_BOOL"));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,4,3) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_INT"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          SimCodeC_expTypeRW_rettype tmp21;
          modelica_metatype tmp22;
          Tpl_writeTok_rettype tmp23;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,7,2) == 0) MMC_THROW();
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_ty = tmp19;
          tmp21 = _SimCodeC_expTypeRW(_txt, _i_ty);
          _txt = tmp21.SimCodeC_expTypeRW_rettype_1;
          tmp22 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_ARRAY"));
          tmp23 = _Tpl_writeTok(_txt, tmp22);
          _txt = tmp23.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 6: {
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          Tpl_writeTok_rettype tmp29;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          if (mmc__uniontype__metarecord__typedef__equal(tmp26,3,1) == 0) MMC_THROW();
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp26), 2));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp28 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_RECORD"));
          tmp29 = _Tpl_writeTok(_txt, tmp28);
          _txt = tmp29.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 7: {
          modelica_metatype tmp30;
          Tpl_writeTok_rettype tmp31;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,13,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp30 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_MMC"));
          tmp31 = _Tpl_writeTok(_txt, tmp30);
          _txt = tmp31.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 8: {
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          Tpl_writeTok_rettype tmp34;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,14,1) == 0) MMC_THROW();
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp33 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("TYPE_DESC_MMC"));
          tmp34 = _Tpl_writeTok(_txt, tmp33);
          _txt = tmp34.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 9: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_expTypeRW_rettypeboxed boxptr_SimCodeC_expTypeRW(modelica_metatype _in_txt, modelica_metatype _in_a_type)
{
  SimCodeC_expTypeRW_rettypeboxed tmp1;
  SimCodeC_expTypeRW_rettype tmp2;
  tmp2 = _SimCodeC_expTypeRW(_in_txt, _in_a_type);
  tmp1.SimCodeC_expTypeRW_rettypeboxed_1 = tmp2.SimCodeC_expTypeRW_rettype_1;
  return tmp1;
}
SimCodeC_lm__362_rettype _SimCodeC_lm__362(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__362_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_integer _x_i1;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_getIteri__i0_rettype tmp8;
          SimCodeC_writeOutVar_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__362_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp8.Tpl_getIteri__i0_rettype_1;
          tmp9 = _SimCodeC_writeOutVar(_txt, _i_var, (modelica_integer)_x_i1);
          _txt = tmp9.SimCodeC_writeOutVar_rettype_1;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__362(_txt, _rest);
          _txt = tmp11.SimCodeC_lm__362_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__362_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          tmp14 = _SimCodeC_lm__362(_txt, _rest);
          _txt = tmp14.SimCodeC_lm__362_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__362_rettypeboxed boxptr_SimCodeC_lm__362(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__362_rettypeboxed tmp1;
  SimCodeC_lm__362_rettype tmp2;
  tmp2 = _SimCodeC_lm__362(_in_txt, _in_items);
  tmp1.SimCodeC_lm__362_rettypeboxed_1 = tmp2.SimCodeC_lm__362_rettype_1;
  return tmp1;
}
SimCodeC_lm__361_rettype _SimCodeC_lm__361(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__361_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgName_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__361_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgName(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgName_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__361(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__361_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__361_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__361(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__361_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__361_rettypeboxed boxptr_SimCodeC_lm__361(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__361_rettypeboxed tmp1;
  SimCodeC_lm__361_rettype tmp2;
  tmp2 = _SimCodeC_lm__361(_in_txt, _in_items);
  tmp1.SimCodeC_lm__361_rettypeboxed_1 = tmp2.SimCodeC_lm__361_rettype_1;
  return tmp1;
}
SimCodeC_funArgName_rettype _SimCodeC_funArgName(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_funArgName_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    {
      modelica_metatype _txt;
      modelica_string _i_name_1;
      modelica_metatype _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_contextCref_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp6;
          tmp10 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp11 = _SimCodeC_contextCref(_txt, _i_name, tmp10);
          _txt = tmp11.SimCodeC_contextCref_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp12;
          modelica_string tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          Tpl_writeStr_rettype tmp16;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,3) == 0) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp13 = mmc_unbox_string(tmp12);
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name_1 = tmp13;
          tmp16 = _Tpl_writeStr(_txt, _i_name_1);
          _txt = tmp16.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_funArgName_rettypeboxed boxptr_SimCodeC_funArgName(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_funArgName_rettypeboxed tmp1;
  SimCodeC_funArgName_rettype tmp2;
  tmp2 = _SimCodeC_funArgName(_in_txt, _in_a_var);
  tmp1.SimCodeC_funArgName_rettypeboxed_1 = tmp2.SimCodeC_funArgName_rettype_1;
  return tmp1;
}
SimCodeC_fun__360_rettype _SimCodeC_fun__360(modelica_metatype _in_txt, modelica_metatype _in_a_outVars)
{
  SimCodeC_fun__360_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("out = "));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__360_rettypeboxed boxptr_SimCodeC_fun__360(modelica_metatype _in_txt, modelica_metatype _in_a_outVars)
{
  SimCodeC_fun__360_rettypeboxed tmp1;
  SimCodeC_fun__360_rettype tmp2;
  tmp2 = _SimCodeC_fun__360(_in_txt, _in_a_outVars);
  tmp1.SimCodeC_fun__360_rettypeboxed_1 = tmp2.SimCodeC_fun__360_rettype_1;
  return tmp1;
}
SimCodeC_readInVar_rettype _SimCodeC_readInVar(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_readInVar_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    {
      modelica_metatype _txt;
      modelica_metatype _i_name;
      modelica_metatype _i_cr;
      modelica_metatype _i_ty;
      modelica_metatype _txt_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          SimCodeC_contextCref_rettype tmp20;
          Tpl_textString_rettype tmp21;
          SimCodeC_readInVarRecordMembers_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          if (mmc__uniontype__metarecord__typedef__equal(tmp7,5,3) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 4));
          if (mmc__uniontype__metarecord__typedef__equal(tmp10,3,1) == 0) MMC_THROW();
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp10), 2));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_cr = tmp6;
          _i_ty = tmp7;
          tmp14 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("if (read_modelica_record(&inArgs, "));
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp16, tmp17);
          tmp19 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp20 = _SimCodeC_contextCref(tmp18, _i_cr, tmp19);
          _txt_0 = tmp20.SimCodeC_contextCref_rettype_1;
          tmp21 = _Tpl_textString(_txt_0);
          tmp22 = _SimCodeC_readInVarRecordMembers(_txt, _i_ty, tmp21.Tpl_textString_rettype_1);
          _txt = tmp22.SimCodeC_readInVarRecordMembers_rettype_1;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")) return 1;"));
          tmp24 = _Tpl_writeTok(_txt, tmp23);
          _txt = tmp24.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          SimCodeC_expTypeArrayIf_rettype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          modelica_metatype tmp34;
          SimCodeC_contextCref_rettype tmp35;
          modelica_metatype tmp36;
          Tpl_writeTok_rettype tmp37;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          if (mmc__uniontype__metarecord__typedef__equal(tmp26,3,0) == 0) MMC_THROW();
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp25;
          _i_ty = tmp26;
          tmp29 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("if (read_"));
          tmp30 = _Tpl_writeTok(_txt, tmp29);
          _txt = tmp30.Tpl_writeTok_rettype_1;
          tmp31 = _SimCodeC_expTypeArrayIf(_txt, _i_ty);
          _txt = tmp31.SimCodeC_expTypeArrayIf_rettype_1;
          tmp32 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(&inArgs, (char**) &"));
          tmp33 = _Tpl_writeTok(_txt, tmp32);
          _txt = tmp33.Tpl_writeTok_rettype_1;
          tmp34 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp35 = _SimCodeC_contextCref(_txt, _i_name, tmp34);
          _txt = tmp35.SimCodeC_contextCref_rettype_1;
          tmp36 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")) return 1;"));
          tmp37 = _Tpl_writeTok(_txt, tmp36);
          _txt = tmp37.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          Tpl_writeTok_rettype tmp43;
          SimCodeC_expTypeArrayIf_rettype tmp44;
          modelica_metatype tmp45;
          Tpl_writeTok_rettype tmp46;
          modelica_metatype tmp47;
          SimCodeC_contextCref_rettype tmp48;
          modelica_metatype tmp49;
          Tpl_writeTok_rettype tmp50;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp38 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp39 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp40 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp41 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp38;
          _i_ty = tmp39;
          tmp42 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("if (read_"));
          tmp43 = _Tpl_writeTok(_txt, tmp42);
          _txt = tmp43.Tpl_writeTok_rettype_1;
          tmp44 = _SimCodeC_expTypeArrayIf(_txt, _i_ty);
          _txt = tmp44.SimCodeC_expTypeArrayIf_rettype_1;
          tmp45 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(&inArgs, &"));
          tmp46 = _Tpl_writeTok(_txt, tmp45);
          _txt = tmp46.Tpl_writeTok_rettype_1;
          tmp47 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp48 = _SimCodeC_contextCref(_txt, _i_name, tmp47);
          _txt = tmp48.SimCodeC_contextCref_rettype_1;
          tmp49 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")) return 1;"));
          tmp50 = _Tpl_writeTok(_txt, tmp49);
          _txt = tmp50.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_readInVar_rettypeboxed boxptr_SimCodeC_readInVar(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_readInVar_rettypeboxed tmp1;
  SimCodeC_readInVar_rettype tmp2;
  tmp2 = _SimCodeC_readInVar(_in_txt, _in_a_var);
  tmp1.SimCodeC_readInVar_rettypeboxed_1 = tmp2.SimCodeC_readInVar_rettype_1;
  return tmp1;
}
SimCodeC_readInVarRecordMembers_rettype _SimCodeC_readInVarRecordMembers(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_string _in_a_prefix)
{
  SimCodeC_readInVarRecordMembers_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_string tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_type;
    tmp3_in2 = _in_a_prefix;
    {
      modelica_metatype _txt;
      modelica_string _a_prefix;
      modelica_metatype _i_vl;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          Tpl_pushIter_rettype tmp13;
          SimCodeC_lm__417_rettype tmp14;
          Tpl_popIter_rettype tmp15;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_vl = tmp7;
          _a_prefix = tmp3_in2;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp10 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp11 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp12 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp9), mmc_mk_integer(0), mmc_mk_integer(0), tmp10, mmc_mk_integer(0), tmp11);
          tmp13 = _Tpl_pushIter(_txt, tmp12);
          _txt = tmp13.Tpl_pushIter_rettype_1;
          tmp14 = _SimCodeC_lm__417(_txt, _i_vl, _a_prefix);
          _txt = tmp14.SimCodeC_lm__417_rettype_1;
          tmp15 = _Tpl_popIter(_txt);
          _txt = tmp15.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_readInVarRecordMembers_rettypeboxed boxptr_SimCodeC_readInVarRecordMembers(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_metatype _in_a_prefix)
{
  SimCodeC_readInVarRecordMembers_rettypeboxed tmp1;
  SimCodeC_readInVarRecordMembers_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_prefix);
  tmp2 = _SimCodeC_readInVarRecordMembers(_in_txt, _in_a_type, tmp3);
  tmp1.SimCodeC_readInVarRecordMembers_rettypeboxed_1 = tmp2.SimCodeC_readInVarRecordMembers_rettype_1;
  return tmp1;
}
SimCodeC_lm__417_rettype _SimCodeC_lm__417(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_string _in_a_prefix)
{
  SimCodeC_lm__417_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_string tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_prefix;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_string _a_prefix;
      modelica_string _i_subvar_name;
      modelica_metatype _i_tp;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_string tmp9;
          modelica_metatype tmp10;
          SimCodeC_fun__416_rettype tmp11;
          Tpl_nextIter_rettype tmp12;
          SimCodeC_lm__417_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,2) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = mmc_unbox_string(tmp8);
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_subvar_name = tmp9;
          _i_tp = tmp10;
          _rest = tmp7;
          _a_prefix = tmp3_in2;
          tmp11 = _SimCodeC_fun__416(_txt, _i_tp, _i_subvar_name, _a_prefix);
          _txt = tmp11.SimCodeC_fun__416_rettype_1;
          tmp12 = _Tpl_nextIter(_txt);
          _txt = tmp12.Tpl_nextIter_rettype_1;
          tmp13 = _SimCodeC_lm__417(_txt, _rest, _a_prefix);
          _txt = tmp13.SimCodeC_lm__417_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          SimCodeC_lm__417_rettype tmp16;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp14 = MMC_CAR(tmp3_in1);
          tmp15 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp15;
          _a_prefix = tmp3_in2;
          tmp16 = _SimCodeC_lm__417(_txt, _rest, _a_prefix);
          _txt = tmp16.SimCodeC_lm__417_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__417_rettypeboxed boxptr_SimCodeC_lm__417(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_prefix)
{
  SimCodeC_lm__417_rettypeboxed tmp1;
  SimCodeC_lm__417_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_prefix);
  tmp2 = _SimCodeC_lm__417(_in_txt, _in_items, tmp3);
  tmp1.SimCodeC_lm__417_rettypeboxed_1 = tmp2.SimCodeC_lm__417_rettype_1;
  return tmp1;
}
SimCodeC_fun__416_rettype _SimCodeC_fun__416(modelica_metatype _in_txt, modelica_metatype _in_a_tp, modelica_string _in_a_subvar_name, modelica_string _in_a_prefix)
{
  SimCodeC_fun__416_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_string tmp3_in2;
    modelica_string tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_tp;
    tmp3_in2 = _in_a_subvar_name;
    tmp3_in3 = _in_a_prefix;
    {
      modelica_metatype _txt;
      modelica_string _a_subvar_name;
      modelica_string _a_prefix;
      modelica_metatype _i_tp;
      modelica_metatype _l_newPrefix;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_writeStr_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          Tpl_writeStr_rettype tmp15;
          Tpl_textString_rettype tmp16;
          SimCodeC_readInVarRecordMembers_rettype tmp17;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_tp = tmp3_in1;
          _a_subvar_name = tmp3_in2;
          _a_prefix = tmp3_in3;
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp9, tmp10);
          tmp12 = _Tpl_writeStr(tmp11, _a_prefix);
          _l_newPrefix = tmp12.Tpl_writeStr_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp14 = _Tpl_writeTok(_l_newPrefix, tmp13);
          _l_newPrefix = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = _Tpl_writeStr(_l_newPrefix, _a_subvar_name);
          _l_newPrefix = tmp15.Tpl_writeStr_rettype_1;
          tmp16 = _Tpl_textString(_l_newPrefix);
          tmp17 = _SimCodeC_readInVarRecordMembers(_txt, _i_tp, tmp16.Tpl_textString_rettype_1);
          _txt = tmp17.SimCodeC_readInVarRecordMembers_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          Tpl_writeStr_rettype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          Tpl_writeStr_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_subvar_name = tmp3_in2;
          _a_prefix = tmp3_in3;
          tmp18 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("&("));
          tmp19 = _Tpl_writeTok(_txt, tmp18);
          _txt = tmp19.Tpl_writeTok_rettype_1;
          tmp20 = _Tpl_writeStr(_txt, _a_prefix);
          _txt = tmp20.Tpl_writeStr_rettype_1;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _Tpl_writeStr(_txt, _a_subvar_name);
          _txt = tmp23.Tpl_writeStr_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp25 = _Tpl_writeTok(_txt, tmp24);
          _txt = tmp25.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__416_rettypeboxed boxptr_SimCodeC_fun__416(modelica_metatype _in_txt, modelica_metatype _in_a_tp, modelica_metatype _in_a_subvar_name, modelica_metatype _in_a_prefix)
{
  SimCodeC_fun__416_rettypeboxed tmp1;
  SimCodeC_fun__416_rettype tmp2;
  modelica_string tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_string(_in_a_subvar_name);
  tmp4 = mmc_unbox_string(_in_a_prefix);
  tmp2 = _SimCodeC_fun__416(_in_txt, _in_a_tp, tmp3, tmp4);
  tmp1.SimCodeC_fun__416_rettypeboxed_1 = tmp2.SimCodeC_fun__416_rettype_1;
  return tmp1;
}
SimCodeC_lm__359_rettype _SimCodeC_lm__359(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__359_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_readInVar_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__359_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_readInVar(_txt, _i_arg);
          _txt = tmp8.SimCodeC_readInVar_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__359(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__359_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__359_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__359(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__359_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__359_rettypeboxed boxptr_SimCodeC_lm__359(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__359_rettypeboxed tmp1;
  SimCodeC_lm__359_rettype tmp2;
  tmp2 = _SimCodeC_lm__359(_in_txt, _in_items);
  tmp1.SimCodeC_lm__359_rettypeboxed_1 = tmp2.SimCodeC_lm__359_rettype_1;
  return tmp1;
}
SimCodeC_fun__358_rettype _SimCodeC_fun__358(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__358_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_retType;
    {
      modelica_metatype _txt;
      modelica_metatype _a_retType;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_retType = tmp3_in2;
          tmp6 = _Tpl_writeText(_txt, _a_retType);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" out;"));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__358_rettypeboxed boxptr_SimCodeC_fun__358(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__358_rettypeboxed tmp1;
  SimCodeC_fun__358_rettype tmp2;
  tmp2 = _SimCodeC_fun__358(_in_txt, _in_a_outVars, _in_a_retType);
  tmp1.SimCodeC_fun__358_rettypeboxed_1 = tmp2.SimCodeC_fun__358_rettype_1;
  return tmp1;
}
SimCodeC_lm__357_rettype _SimCodeC_lm__357(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__357_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgDefinition_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          Tpl_nextIter_rettype tmp11;
          SimCodeC_lm__357_rettype tmp12;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgDefinition(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgDefinition_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp11 = _Tpl_nextIter(_txt);
          _txt = tmp11.Tpl_nextIter_rettype_1;
          tmp12 = _SimCodeC_lm__357(_txt, _rest);
          _txt = tmp12.SimCodeC_lm__357_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          SimCodeC_lm__357_rettype tmp15;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp13 = MMC_CAR(tmp3_in1);
          tmp14 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp14;
          tmp15 = _SimCodeC_lm__357(_txt, _rest);
          _txt = tmp15.SimCodeC_lm__357_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__357_rettypeboxed boxptr_SimCodeC_lm__357(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__357_rettypeboxed tmp1;
  SimCodeC_lm__357_rettype tmp2;
  tmp2 = _SimCodeC_lm__357(_in_txt, _in_items);
  tmp1.SimCodeC_lm__357_rettypeboxed_1 = tmp2.SimCodeC_lm__357_rettype_1;
  return tmp1;
}
SimCodeC_fun__356_rettype _SimCodeC_fun__356(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retVar)
{
  SimCodeC_fun__356_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_retVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_retVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_pushBlock_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          Tpl_popBlock_rettype tmp9;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_retVar = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(1));
          tmp7 = _Tpl_pushBlock(_txt, tmp6);
          _txt = tmp7.Tpl_pushBlock_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_retVar);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = _Tpl_popBlock(_txt);
          _txt = tmp9.Tpl_popBlock_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__356_rettypeboxed boxptr_SimCodeC_fun__356(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_retVar)
{
  SimCodeC_fun__356_rettypeboxed tmp1;
  SimCodeC_fun__356_rettype tmp2;
  tmp2 = _SimCodeC_fun__356(_in_txt, _in_a_outVars, _in_a_retVar);
  tmp1.SimCodeC_fun__356_rettypeboxed_1 = tmp2.SimCodeC_fun__356_rettype_1;
  return tmp1;
}
SimCodeC_fun__355_rettype _SimCodeC_fun__355(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__355_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("restore_memory_state("));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__355_rettypeboxed boxptr_SimCodeC_fun__355(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__355_rettypeboxed tmp1;
  SimCodeC_fun__355_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__355(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__355_rettypeboxed_1 = tmp2.SimCodeC_fun__355_rettype_1;
  return tmp1;
}
SimCodeC_fun__354_rettype _SimCodeC_fun__354(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__354_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          Tpl_writeText_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = get_memory_state();"));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__354_rettypeboxed boxptr_SimCodeC_fun__354(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__354_rettypeboxed tmp1;
  SimCodeC_fun__354_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__354(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__354_rettypeboxed_1 = tmp2.SimCodeC_fun__354_rettype_1;
  return tmp1;
}
SimCodeC_lm__353_rettype _SimCodeC_lm__353(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__353_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgDefinition_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__353_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgDefinition(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgDefinition_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__353(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__353_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__353_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__353(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__353_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__353_rettypeboxed boxptr_SimCodeC_lm__353(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__353_rettypeboxed tmp1;
  SimCodeC_lm__353_rettype tmp2;
  tmp2 = _SimCodeC_lm__353(_in_txt, _in_items);
  tmp1.SimCodeC_lm__353_rettypeboxed_1 = tmp2.SimCodeC_lm__353_rettype_1;
  return tmp1;
}
SimCodeC_functionBodyBoxed_rettype _SimCodeC_functionBodyBoxed(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_functionBodyBoxed_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_fn;
      modelica_metatype _i_funArgs;
      modelica_metatype _i_outVars;
      modelica_metatype _i_functionArguments;
      modelica_metatype _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_functionBodyBoxedImpl_rettype tmp12;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,6) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp6;
          _i_outVars = tmp8;
          _i_functionArguments = tmp9;
          tmp12 = _SimCodeC_functionBodyBoxedImpl(_txt, _i_name, _i_functionArguments, _i_outVars);
          _txt = tmp12.SimCodeC_functionBodyBoxedImpl_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          SimCodeC_functionBodyBoxedImpl_rettype tmp22;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp17 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp18 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp21 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp13;
          _i_funArgs = tmp15;
          _i_outVars = tmp19;
          tmp22 = _SimCodeC_functionBodyBoxedImpl(_txt, _i_name, _i_funArgs, _i_outVars);
          _txt = tmp22.SimCodeC_functionBodyBoxedImpl_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          SimCodeC_boxRecordConstructor_rettype tmp25;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,2) == 0) MMC_THROW();
          tmp23 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp3_in1;
          tmp25 = _SimCodeC_boxRecordConstructor(_txt, _i_fn);
          _txt = tmp25.SimCodeC_boxRecordConstructor_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionBodyBoxed_rettypeboxed boxptr_SimCodeC_functionBodyBoxed(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_functionBodyBoxed_rettypeboxed tmp1;
  SimCodeC_functionBodyBoxed_rettype tmp2;
  tmp2 = _SimCodeC_functionBodyBoxed(_in_txt, _in_a_fn);
  tmp1.SimCodeC_functionBodyBoxed_rettypeboxed_1 = tmp2.SimCodeC_functionBodyBoxed_rettype_1;
  return tmp1;
}
SimCodeC_boxRecordConstructor_rettype _SimCodeC_boxRecordConstructor(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_boxRecordConstructor_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_funArgs;
      modelica_metatype _i_name;
      modelica_boolean _ret_13;
      modelica_boolean _ret_12;
      modelica_integer _ret_11;
      modelica_integer _ret_10;
      modelica_metatype _l_funArgCount;
      modelica_metatype _l_boxRetVar;
      modelica_metatype _l_funArgsStr;
      modelica_metatype _l_retVar;
      modelica_metatype _l_retType;
      modelica_metatype _l_fname;
      modelica_boolean _ret_3;
      modelica_metatype _l_stateVar;
      modelica_metatype _l_preExp;
      modelica_metatype _l_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          SimCodeC_fun__398_rettype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          SimCodeC_underscorePath_rettype tmp22;
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          Tpl_writeText_rettype tmp26;
          modelica_metatype tmp27;
          Tpl_writeTok_rettype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          Tpl_textString_rettype tmp32;
          SimCodeC_tempDecl_rettype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          Tpl_pushIter_rettype tmp41;
          SimCodeC_lm__399_rettype tmp42;
          Tpl_popIter_rettype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          modelica_metatype tmp46;
          SimCodeC_tempDecl_rettype tmp47;
          listLength_rettype tmp48;
          SimCode_incrementInt_rettype tmp49;
          modelica_metatype tmp50;
          modelica_metatype tmp51;
          modelica_metatype tmp52;
          intString_rettype tmp53;
          Tpl_writeStr_rettype tmp54;
          Tpl_writeText_rettype tmp55;
          modelica_metatype tmp56;
          Tpl_writeTok_rettype tmp57;
          Tpl_writeText_rettype tmp58;
          modelica_metatype tmp59;
          Tpl_writeTok_rettype tmp60;
          modelica_metatype tmp61;
          modelica_metatype tmp62;
          modelica_metatype tmp63;
          modelica_metatype tmp64;
          Tpl_pushIter_rettype tmp65;
          SimCodeC_lm__400_rettype tmp66;
          Tpl_popIter_rettype tmp67;
          modelica_metatype tmp68;
          modelica_metatype tmp69;
          Tpl_writeTok_rettype tmp70;
          modelica_metatype tmp71;
          Tpl_pushBlock_rettype tmp72;
          Tpl_writeText_rettype tmp73;
          Tpl_softNewLine_rettype tmp74;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp75;
          SimCodeC_fun__401_rettype tmp76;
          Tpl_softNewLine_rettype tmp77;
          modelica_metatype tmp78;
          Tpl_writeTok_rettype tmp79;
          Tpl_writeText_rettype tmp80;
          Tpl_softNewLine_rettype tmp81;
          Tpl_writeText_rettype tmp82;
          modelica_metatype tmp83;
          Tpl_writeTok_rettype tmp84;
          Tpl_writeText_rettype tmp85;
          modelica_metatype tmp86;
          Tpl_writeTok_rettype tmp87;
          Tpl_writeText_rettype tmp88;
          modelica_metatype tmp89;
          Tpl_writeTok_rettype tmp90;
          Tpl_writeText_rettype tmp91;
          modelica_metatype tmp92;
          Tpl_writeTok_rettype tmp93;
          Tpl_writeText_rettype tmp94;
          modelica_metatype tmp95;
          Tpl_writeTok_rettype tmp96;
          Tpl_writeText_rettype tmp97;
          modelica_metatype tmp98;
          Tpl_writeTok_rettype tmp99;
          Tpl_writeText_rettype tmp100;
          modelica_metatype tmp101;
          modelica_metatype tmp102;
          Tpl_writeTok_rettype tmp103;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp104;
          SimCodeC_fun__402_rettype tmp105;
          Tpl_softNewLine_rettype tmp106;
          modelica_metatype tmp107;
          Tpl_writeTok_rettype tmp108;
          Tpl_writeText_rettype tmp109;
          modelica_metatype tmp110;
          Tpl_writeTok_rettype tmp111;
          Tpl_popBlock_rettype tmp112;
          modelica_metatype tmp113;
          Tpl_writeTok_rettype tmp114;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp6;
          _i_funArgs = tmp7;
          _System_tmpTickReset(1);
          /* NORETCALL */;
          tmp8 = mmc_mk_nil();
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp8, tmp9);
          _l_varDecls = tmp10;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          _l_preExp = tmp13;
          tmp14 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_3 = tmp14.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp15 = mmc_mk_nil();
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp15, tmp16);
          tmp18 = _SimCodeC_fun__398(tmp17, _ret_3, _l_varDecls);
          _l_stateVar = tmp18.targ1;
          _l_varDecls = tmp18.targ2;
          tmp19 = mmc_mk_nil();
          tmp20 = mmc_mk_nil();
          tmp21 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp19, tmp20);
          tmp22 = _SimCodeC_underscorePath(tmp21, _i_name);
          _l_fname = tmp22.SimCodeC_underscorePath_rettype_1;
          tmp23 = mmc_mk_nil();
          tmp24 = mmc_mk_nil();
          tmp25 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp23, tmp24);
          tmp26 = _Tpl_writeText(tmp25, _l_fname);
          _l_retType = tmp26.Tpl_writeText_rettype_1;
          tmp27 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettypeboxed"));
          tmp28 = _Tpl_writeTok(_l_retType, tmp27);
          _l_retType = tmp28.Tpl_writeTok_rettype_1;
          tmp29 = mmc_mk_nil();
          tmp30 = mmc_mk_nil();
          tmp31 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp29, tmp30);
          tmp32 = _Tpl_textString(_l_retType);
          tmp33 = _SimCodeC_tempDecl(tmp31, tmp32.Tpl_textString_rettype_1, _l_varDecls);
          _l_retVar = tmp33.targ1;
          _l_varDecls = tmp33.targ2;
          tmp34 = mmc_mk_nil();
          tmp35 = mmc_mk_nil();
          tmp36 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp34, tmp35);
          tmp37 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp38 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp39 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp40 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp37), mmc_mk_integer(0), mmc_mk_integer(0), tmp38, mmc_mk_integer(0), tmp39);
          tmp41 = _Tpl_pushIter(tmp36, tmp40);
          _l_funArgsStr = tmp41.Tpl_pushIter_rettype_1;
          tmp42 = _SimCodeC_lm__399(_l_funArgsStr, _i_funArgs);
          _l_funArgsStr = tmp42.SimCodeC_lm__399_rettype_1;
          tmp43 = _Tpl_popIter(_l_funArgsStr);
          _l_funArgsStr = tmp43.Tpl_popIter_rettype_1;
          tmp44 = mmc_mk_nil();
          tmp45 = mmc_mk_nil();
          tmp46 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp44, tmp45);
          tmp47 = _SimCodeC_tempDecl(tmp46, "modelica_metatype", _l_varDecls);
          _l_boxRetVar = tmp47.targ1;
          _l_varDecls = tmp47.targ2;
          tmp48 = listLength(_i_funArgs);
          _ret_10 = tmp48;
          tmp49 = _SimCode_incrementInt((modelica_integer)_ret_10, 1);
          _ret_11 = tmp49.SimCode_incrementInt_rettype_1;
          tmp50 = mmc_mk_nil();
          tmp51 = mmc_mk_nil();
          tmp52 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp50, tmp51);
          tmp53 = intString((modelica_integer)_ret_11);
          tmp54 = _Tpl_writeStr(tmp52, tmp53);
          _l_funArgCount = tmp54.Tpl_writeStr_rettype_1;
          tmp55 = _Tpl_writeText(_txt, _l_retType);
          _txt = tmp55.Tpl_writeText_rettype_1;
          tmp56 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" boxptr_"));
          tmp57 = _Tpl_writeTok(_txt, tmp56);
          _txt = tmp57.Tpl_writeTok_rettype_1;
          tmp58 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp58.Tpl_writeText_rettype_1;
          tmp59 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp60 = _Tpl_writeTok(_txt, tmp59);
          _txt = tmp60.Tpl_writeTok_rettype_1;
          tmp61 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp62 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp63 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp64 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp61), mmc_mk_integer(0), mmc_mk_integer(0), tmp62, mmc_mk_integer(0), tmp63);
          tmp65 = _Tpl_pushIter(_txt, tmp64);
          _txt = tmp65.Tpl_pushIter_rettype_1;
          tmp66 = _SimCodeC_lm__400(_txt, _i_funArgs);
          _txt = tmp66.SimCodeC_lm__400_rettype_1;
          tmp67 = _Tpl_popIter(_txt);
          _txt = tmp67.Tpl_popIter_rettype_1;
          tmp68 = mmc_mk_cons(mmc_mk_scon(")\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
          tmp69 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp68, mmc_mk_boolean((1)));
          tmp70 = _Tpl_writeTok(_txt, tmp69);
          _txt = tmp70.Tpl_writeTok_rettype_1;
          tmp71 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp72 = _Tpl_pushBlock(_txt, tmp71);
          _txt = tmp72.Tpl_pushBlock_rettype_1;
          tmp73 = _Tpl_writeText(_txt, _l_varDecls);
          _txt = tmp73.Tpl_writeText_rettype_1;
          tmp74 = _Tpl_softNewLine(_txt);
          _txt = tmp74.Tpl_softNewLine_rettype_1;
          tmp75 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_12 = tmp75.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp76 = _SimCodeC_fun__401(_txt, _ret_12, _l_stateVar);
          _txt = tmp76.SimCodeC_fun__401_rettype_1;
          tmp77 = _Tpl_softNewLine(_txt);
          _txt = tmp77.Tpl_softNewLine_rettype_1;
          tmp78 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp79 = _Tpl_writeTok(_txt, tmp78);
          _txt = tmp79.Tpl_writeTok_rettype_1;
          tmp80 = _Tpl_writeText(_txt, _l_preExp);
          _txt = tmp80.Tpl_writeText_rettype_1;
          tmp81 = _Tpl_softNewLine(_txt);
          _txt = tmp81.Tpl_softNewLine_rettype_1;
          tmp82 = _Tpl_writeText(_txt, _l_boxRetVar);
          _txt = tmp82.Tpl_writeText_rettype_1;
          tmp83 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = mmc_mk_box"));
          tmp84 = _Tpl_writeTok(_txt, tmp83);
          _txt = tmp84.Tpl_writeTok_rettype_1;
          tmp85 = _Tpl_writeText(_txt, _l_funArgCount);
          _txt = tmp85.Tpl_writeText_rettype_1;
          tmp86 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(3, &"));
          tmp87 = _Tpl_writeTok(_txt, tmp86);
          _txt = tmp87.Tpl_writeTok_rettype_1;
          tmp88 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp88.Tpl_writeText_rettype_1;
          tmp89 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("__desc, "));
          tmp90 = _Tpl_writeTok(_txt, tmp89);
          _txt = tmp90.Tpl_writeTok_rettype_1;
          tmp91 = _Tpl_writeText(_txt, _l_funArgsStr);
          _txt = tmp91.Tpl_writeText_rettype_1;
          tmp92 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(");\n"));
          tmp93 = _Tpl_writeTok(_txt, tmp92);
          _txt = tmp93.Tpl_writeTok_rettype_1;
          tmp94 = _Tpl_writeText(_txt, _l_retVar);
          _txt = tmp94.Tpl_writeText_rettype_1;
          tmp95 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp96 = _Tpl_writeTok(_txt, tmp95);
          _txt = tmp96.Tpl_writeTok_rettype_1;
          tmp97 = _Tpl_writeText(_txt, _l_retType);
          _txt = tmp97.Tpl_writeText_rettype_1;
          tmp98 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_1 = "));
          tmp99 = _Tpl_writeTok(_txt, tmp98);
          _txt = tmp99.Tpl_writeTok_rettype_1;
          tmp100 = _Tpl_writeText(_txt, _l_boxRetVar);
          _txt = tmp100.Tpl_writeText_rettype_1;
          tmp101 = mmc_mk_cons(mmc_mk_scon(";\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()));
          tmp102 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp101, mmc_mk_boolean((1)));
          tmp103 = _Tpl_writeTok(_txt, tmp102);
          _txt = tmp103.Tpl_writeTok_rettype_1;
          tmp104 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_13 = tmp104.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp105 = _SimCodeC_fun__402(_txt, _ret_13, _l_stateVar);
          _txt = tmp105.SimCodeC_fun__402_rettype_1;
          tmp106 = _Tpl_softNewLine(_txt);
          _txt = tmp106.Tpl_softNewLine_rettype_1;
          tmp107 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("return "));
          tmp108 = _Tpl_writeTok(_txt, tmp107);
          _txt = tmp108.Tpl_writeTok_rettype_1;
          tmp109 = _Tpl_writeText(_txt, _l_retVar);
          _txt = tmp109.Tpl_writeText_rettype_1;
          tmp110 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(";\n"));
          tmp111 = _Tpl_writeTok(_txt, tmp110);
          _txt = tmp111.Tpl_writeTok_rettype_1;
          tmp112 = _Tpl_popBlock(_txt);
          _txt = tmp112.Tpl_popBlock_rettype_1;
          tmp113 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("}"));
          tmp114 = _Tpl_writeTok(_txt, tmp113);
          _txt = tmp114.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_boxRecordConstructor_rettypeboxed boxptr_SimCodeC_boxRecordConstructor(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_boxRecordConstructor_rettypeboxed tmp1;
  SimCodeC_boxRecordConstructor_rettype tmp2;
  tmp2 = _SimCodeC_boxRecordConstructor(_in_txt, _in_a_fn);
  tmp1.SimCodeC_boxRecordConstructor_rettypeboxed_1 = tmp2.SimCodeC_boxRecordConstructor_rettype_1;
  return tmp1;
}
SimCodeC_fun__402_rettype _SimCodeC_fun__402(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__402_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("restore_memory_state("));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__402_rettypeboxed boxptr_SimCodeC_fun__402(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__402_rettypeboxed tmp1;
  SimCodeC_fun__402_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__402(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__402_rettypeboxed_1 = tmp2.SimCodeC_fun__402_rettype_1;
  return tmp1;
}
SimCodeC_fun__401_rettype _SimCodeC_fun__401(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__401_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          Tpl_writeText_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = get_memory_state();"));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__401_rettypeboxed boxptr_SimCodeC_fun__401(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__401_rettypeboxed tmp1;
  SimCodeC_fun__401_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__401(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__401_rettypeboxed_1 = tmp2.SimCodeC_fun__401_rettype_1;
  return tmp1;
}
SimCodeC_lm__400_rettype _SimCodeC_lm__400(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__400_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgBoxedDefinition_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__400_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgBoxedDefinition(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgBoxedDefinition_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__400(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__400_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__400_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__400(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__400_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__400_rettypeboxed boxptr_SimCodeC_lm__400(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__400_rettypeboxed tmp1;
  SimCodeC_lm__400_rettype tmp2;
  tmp2 = _SimCodeC_lm__400(_in_txt, _in_items);
  tmp1.SimCodeC_lm__400_rettypeboxed_1 = tmp2.SimCodeC_lm__400_rettype_1;
  return tmp1;
}
SimCodeC_lm__399_rettype _SimCodeC_lm__399(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__399_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_contextCref_rettype tmp13;
          Tpl_nextIter_rettype tmp14;
          SimCodeC_lm__399_rettype tmp15;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp8;
          _rest = tmp7;
          tmp12 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp13 = _SimCodeC_contextCref(_txt, _i_name, tmp12);
          _txt = tmp13.SimCodeC_contextCref_rettype_1;
          tmp14 = _Tpl_nextIter(_txt);
          _txt = tmp14.Tpl_nextIter_rettype_1;
          tmp15 = _SimCodeC_lm__399(_txt, _rest);
          _txt = tmp15.SimCodeC_lm__399_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          SimCodeC_lm__399_rettype tmp18;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp16 = MMC_CAR(tmp3_in1);
          tmp17 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp17;
          tmp18 = _SimCodeC_lm__399(_txt, _rest);
          _txt = tmp18.SimCodeC_lm__399_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__399_rettypeboxed boxptr_SimCodeC_lm__399(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__399_rettypeboxed tmp1;
  SimCodeC_lm__399_rettype tmp2;
  tmp2 = _SimCodeC_lm__399(_in_txt, _in_items);
  tmp1.SimCodeC_lm__399_rettypeboxed_1 = tmp2.SimCodeC_lm__399_rettype_1;
  return tmp1;
}
SimCodeC_fun__398_rettype _SimCodeC_fun__398(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__398_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_tempDecl_rettype tmp6;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp6 = _SimCodeC_tempDecl(_txt, "state", _a_varDecls);
          _txt = tmp6.targ1;
          _a_varDecls = tmp6.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__398_rettypeboxed boxptr_SimCodeC_fun__398(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__398_rettypeboxed tmp1;
  SimCodeC_fun__398_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__398(_in_txt, tmp3, _in_a_varDecls);
  tmp1.SimCodeC_fun__398_rettypeboxed_1 = tmp2.SimCodeC_fun__398_rettype_1;
  tmp1.SimCodeC_fun__398_rettypeboxed_2 = tmp2.SimCodeC_fun__398_rettype_2;
  return tmp1;
}
void _System_tmpTickReset(modelica_integer _start)
{
  int _start_ext;
  _start_ext = (int)_start;
  System_tmpTickReset(_start_ext);
  return ;
}


void boxptr_System_tmpTickReset(modelica_metatype _start)
{
  modelica_integer tmp1;
  tmp1 = mmc_unbox_integer(_start);
  _System_tmpTickReset(tmp1);
  return ;
}
SimCodeC_functionBodyBoxedImpl_rettype _SimCodeC_functionBodyBoxedImpl(modelica_metatype _txt, modelica_metatype _a_name, modelica_metatype _a_funargs, modelica_metatype _a_outvars)
{
  SimCodeC_functionBodyBoxedImpl_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_boolean _ret_13;
  modelica_boolean _ret_12;
  modelica_metatype _l_retStr;
  modelica_metatype _l_args;
  modelica_metatype _l_varUnbox;
  modelica_metatype _l_varBox;
  modelica_boolean _ret_7;
  modelica_metatype _l_stateVar;
  modelica_metatype _l_funRetVar;
  modelica_metatype _l_retVar;
  modelica_metatype _l_varDecls;
  modelica_metatype _l_retTypeBoxed;
  modelica_metatype _l_retType;
  modelica_metatype _l_fname;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  SimCodeC_underscorePath_rettype tmp5;
  modelica_metatype tmp6;
  modelica_metatype tmp7;
  modelica_metatype tmp8;
  SimCodeC_fun__386_rettype tmp9;
  modelica_metatype tmp10;
  modelica_metatype tmp11;
  modelica_metatype tmp12;
  SimCodeC_fun__387_rettype tmp13;
  modelica_metatype tmp14;
  modelica_metatype tmp15;
  modelica_metatype tmp16;
  modelica_metatype tmp17;
  modelica_metatype tmp18;
  modelica_metatype tmp19;
  SimCodeC_fun__388_rettype tmp20;
  modelica_metatype tmp21;
  modelica_metatype tmp22;
  modelica_metatype tmp23;
  SimCodeC_fun__389_rettype tmp24;
  RTOpts_acceptMetaModelicaGrammar_rettype tmp25;
  modelica_metatype tmp26;
  modelica_metatype tmp27;
  modelica_metatype tmp28;
  SimCodeC_fun__390_rettype tmp29;
  modelica_metatype tmp30;
  modelica_metatype tmp31;
  modelica_metatype tmp32;
  modelica_metatype tmp33;
  modelica_metatype tmp34;
  modelica_metatype tmp35;
  modelica_metatype tmp36;
  modelica_metatype tmp37;
  modelica_metatype tmp38;
  modelica_metatype tmp39;
  modelica_metatype tmp40;
  modelica_metatype tmp41;
  modelica_metatype tmp42;
  Tpl_pushIter_rettype tmp43;
  SimCodeC_lm__391_rettype tmp44;
  Tpl_popIter_rettype tmp45;
  modelica_metatype tmp46;
  modelica_metatype tmp47;
  modelica_metatype tmp48;
  modelica_metatype tmp49;
  modelica_metatype tmp50;
  modelica_metatype tmp51;
  modelica_metatype tmp52;
  Tpl_pushIter_rettype tmp53;
  SimCodeC_lm__392_rettype tmp54;
  Tpl_popIter_rettype tmp55;
  Tpl_writeText_rettype tmp56;
  modelica_metatype tmp57;
  Tpl_writeTok_rettype tmp58;
  Tpl_writeText_rettype tmp59;
  modelica_metatype tmp60;
  Tpl_writeTok_rettype tmp61;
  modelica_metatype tmp62;
  modelica_metatype tmp63;
  modelica_metatype tmp64;
  modelica_metatype tmp65;
  Tpl_pushIter_rettype tmp66;
  SimCodeC_lm__393_rettype tmp67;
  Tpl_popIter_rettype tmp68;
  modelica_metatype tmp69;
  modelica_metatype tmp70;
  Tpl_writeTok_rettype tmp71;
  modelica_metatype tmp72;
  Tpl_pushBlock_rettype tmp73;
  Tpl_writeText_rettype tmp74;
  Tpl_softNewLine_rettype tmp75;
  RTOpts_acceptMetaModelicaGrammar_rettype tmp76;
  SimCodeC_fun__394_rettype tmp77;
  Tpl_softNewLine_rettype tmp78;
  Tpl_writeText_rettype tmp79;
  Tpl_softNewLine_rettype tmp80;
  SimCodeC_fun__395_rettype tmp81;
  modelica_metatype tmp82;
  Tpl_writeTok_rettype tmp83;
  Tpl_writeText_rettype tmp84;
  modelica_metatype tmp85;
  Tpl_writeTok_rettype tmp86;
  Tpl_writeText_rettype tmp87;
  modelica_metatype tmp88;
  Tpl_writeTok_rettype tmp89;
  Tpl_writeText_rettype tmp90;
  Tpl_softNewLine_rettype tmp91;
  Tpl_writeText_rettype tmp92;
  Tpl_softNewLine_rettype tmp93;
  RTOpts_acceptMetaModelicaGrammar_rettype tmp94;
  SimCodeC_fun__396_rettype tmp95;
  Tpl_softNewLine_rettype tmp96;
  modelica_metatype tmp97;
  Tpl_writeTok_rettype tmp98;
  Tpl_writeText_rettype tmp99;
  modelica_metatype tmp100;
  Tpl_writeTok_rettype tmp101;
  Tpl_popBlock_rettype tmp102;
  modelica_metatype tmp103;
  Tpl_writeTok_rettype tmp104;


  _System_tmpTickReset(1);
  /* NORETCALL */;
  tmp2 = mmc_mk_nil();
  tmp3 = mmc_mk_nil();
  tmp4 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp2, tmp3);
  tmp5 = _SimCodeC_underscorePath(tmp4, _a_name);
  _l_fname = tmp5.SimCodeC_underscorePath_rettype_1;
  tmp6 = mmc_mk_nil();
  tmp7 = mmc_mk_nil();
  tmp8 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp6, tmp7);
  tmp9 = _SimCodeC_fun__386(tmp8, _a_outvars, _l_fname);
  _l_retType = tmp9.SimCodeC_fun__386_rettype_1;
  tmp10 = mmc_mk_nil();
  tmp11 = mmc_mk_nil();
  tmp12 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp10, tmp11);
  tmp13 = _SimCodeC_fun__387(tmp12, _a_outvars, _l_retType);
  _l_retTypeBoxed = tmp13.SimCodeC_fun__387_rettype_1;
  tmp14 = mmc_mk_nil();
  tmp15 = mmc_mk_nil();
  tmp16 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp14, tmp15);
  _l_varDecls = tmp16;
  tmp17 = mmc_mk_nil();
  tmp18 = mmc_mk_nil();
  tmp19 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp17, tmp18);
  tmp20 = _SimCodeC_fun__388(tmp19, _a_outvars, _l_varDecls, _l_retTypeBoxed);
  _l_retVar = tmp20.targ1;
  _l_varDecls = tmp20.targ2;
  tmp21 = mmc_mk_nil();
  tmp22 = mmc_mk_nil();
  tmp23 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp21, tmp22);
  tmp24 = _SimCodeC_fun__389(tmp23, _a_outvars, _l_varDecls, _l_retType);
  _l_funRetVar = tmp24.targ1;
  _l_varDecls = tmp24.targ2;
  tmp25 = _RTOpts_acceptMetaModelicaGrammar();
  _ret_7 = tmp25.RTOpts_acceptMetaModelicaGrammar_rettype_1;
  tmp26 = mmc_mk_nil();
  tmp27 = mmc_mk_nil();
  tmp28 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp26, tmp27);
  tmp29 = _SimCodeC_fun__390(tmp28, _ret_7, _l_varDecls);
  _l_stateVar = tmp29.targ1;
  _l_varDecls = tmp29.targ2;
  tmp30 = mmc_mk_nil();
  tmp31 = mmc_mk_nil();
  tmp32 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp30, tmp31);
  _l_varBox = tmp32;
  tmp33 = mmc_mk_nil();
  tmp34 = mmc_mk_nil();
  tmp35 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp33, tmp34);
  _l_varUnbox = tmp35;
  tmp36 = mmc_mk_nil();
  tmp37 = mmc_mk_nil();
  tmp38 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp36, tmp37);
  tmp39 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
  tmp40 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp41 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp42 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp39), mmc_mk_integer(0), mmc_mk_integer(0), tmp40, mmc_mk_integer(0), tmp41);
  tmp43 = _Tpl_pushIter(tmp38, tmp42);
  _l_args = tmp43.Tpl_pushIter_rettype_1;
  tmp44 = _SimCodeC_lm__391(_l_args, _a_funargs, _l_varBox, _l_varDecls);
  _l_args = tmp44.targ1;
  _l_varBox = tmp44.targ2;
  _l_varDecls = tmp44.targ3;
  tmp45 = _Tpl_popIter(_l_args);
  _l_args = tmp45.Tpl_popIter_rettype_1;
  tmp46 = mmc_mk_nil();
  tmp47 = mmc_mk_nil();
  tmp48 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp46, tmp47);
  tmp49 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp50 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp51 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp52 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_none(), mmc_mk_some(tmp49), mmc_mk_integer(0), mmc_mk_integer(0), tmp50, mmc_mk_integer(0), tmp51);
  tmp53 = _Tpl_pushIter(tmp48, tmp52);
  _l_retStr = tmp53.Tpl_pushIter_rettype_1;
  tmp54 = _SimCodeC_lm__392(_l_retStr, _a_outvars, _l_varDecls, _l_varUnbox, _l_retTypeBoxed, _l_retVar, _l_retType, _l_funRetVar);
  _l_retStr = tmp54.targ1;
  _l_varDecls = tmp54.targ2;
  _l_varUnbox = tmp54.targ3;
  tmp55 = _Tpl_popIter(_l_retStr);
  _l_retStr = tmp55.Tpl_popIter_rettype_1;
  tmp56 = _Tpl_writeText(_txt, _l_retTypeBoxed);
  _out_txt = tmp56.Tpl_writeText_rettype_1;
  tmp57 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" boxptr_"));
  tmp58 = _Tpl_writeTok(_out_txt, tmp57);
  _out_txt = tmp58.Tpl_writeTok_rettype_1;
  tmp59 = _Tpl_writeText(_out_txt, _l_fname);
  _out_txt = tmp59.Tpl_writeText_rettype_1;
  tmp60 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
  tmp61 = _Tpl_writeTok(_out_txt, tmp60);
  _out_txt = tmp61.Tpl_writeTok_rettype_1;
  tmp62 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
  tmp63 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp64 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp65 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp62), mmc_mk_integer(0), mmc_mk_integer(0), tmp63, mmc_mk_integer(0), tmp64);
  tmp66 = _Tpl_pushIter(_out_txt, tmp65);
  _out_txt = tmp66.Tpl_pushIter_rettype_1;
  tmp67 = _SimCodeC_lm__393(_out_txt, _a_funargs);
  _out_txt = tmp67.SimCodeC_lm__393_rettype_1;
  tmp68 = _Tpl_popIter(_out_txt);
  _out_txt = tmp68.Tpl_popIter_rettype_1;
  tmp69 = mmc_mk_cons(mmc_mk_scon(")\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
  tmp70 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp69, mmc_mk_boolean((1)));
  tmp71 = _Tpl_writeTok(_out_txt, tmp70);
  _out_txt = tmp71.Tpl_writeTok_rettype_1;
  tmp72 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
  tmp73 = _Tpl_pushBlock(_out_txt, tmp72);
  _out_txt = tmp73.Tpl_pushBlock_rettype_1;
  tmp74 = _Tpl_writeText(_out_txt, _l_varDecls);
  _out_txt = tmp74.Tpl_writeText_rettype_1;
  tmp75 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp75.Tpl_softNewLine_rettype_1;
  tmp76 = _RTOpts_acceptMetaModelicaGrammar();
  _ret_12 = tmp76.RTOpts_acceptMetaModelicaGrammar_rettype_1;
  tmp77 = _SimCodeC_fun__394(_out_txt, _ret_12, _l_stateVar);
  _out_txt = tmp77.SimCodeC_fun__394_rettype_1;
  tmp78 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp78.Tpl_softNewLine_rettype_1;
  tmp79 = _Tpl_writeText(_out_txt, _l_varBox);
  _out_txt = tmp79.Tpl_writeText_rettype_1;
  tmp80 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp80.Tpl_softNewLine_rettype_1;
  tmp81 = _SimCodeC_fun__395(_out_txt, _a_outvars, _l_funRetVar);
  _out_txt = tmp81.SimCodeC_fun__395_rettype_1;
  tmp82 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
  tmp83 = _Tpl_writeTok(_out_txt, tmp82);
  _out_txt = tmp83.Tpl_writeTok_rettype_1;
  tmp84 = _Tpl_writeText(_out_txt, _l_fname);
  _out_txt = tmp84.Tpl_writeText_rettype_1;
  tmp85 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
  tmp86 = _Tpl_writeTok(_out_txt, tmp85);
  _out_txt = tmp86.Tpl_writeTok_rettype_1;
  tmp87 = _Tpl_writeText(_out_txt, _l_args);
  _out_txt = tmp87.Tpl_writeText_rettype_1;
  tmp88 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(");\n"));
  tmp89 = _Tpl_writeTok(_out_txt, tmp88);
  _out_txt = tmp89.Tpl_writeTok_rettype_1;
  tmp90 = _Tpl_writeText(_out_txt, _l_varUnbox);
  _out_txt = tmp90.Tpl_writeText_rettype_1;
  tmp91 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp91.Tpl_softNewLine_rettype_1;
  tmp92 = _Tpl_writeText(_out_txt, _l_retStr);
  _out_txt = tmp92.Tpl_writeText_rettype_1;
  tmp93 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp93.Tpl_softNewLine_rettype_1;
  tmp94 = _RTOpts_acceptMetaModelicaGrammar();
  _ret_13 = tmp94.RTOpts_acceptMetaModelicaGrammar_rettype_1;
  tmp95 = _SimCodeC_fun__396(_out_txt, _ret_13, _l_stateVar);
  _out_txt = tmp95.SimCodeC_fun__396_rettype_1;
  tmp96 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp96.Tpl_softNewLine_rettype_1;
  tmp97 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("return "));
  tmp98 = _Tpl_writeTok(_out_txt, tmp97);
  _out_txt = tmp98.Tpl_writeTok_rettype_1;
  tmp99 = _Tpl_writeText(_out_txt, _l_retVar);
  _out_txt = tmp99.Tpl_writeText_rettype_1;
  tmp100 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(";\n"));
  tmp101 = _Tpl_writeTok(_out_txt, tmp100);
  _out_txt = tmp101.Tpl_writeTok_rettype_1;
  tmp102 = _Tpl_popBlock(_out_txt);
  _out_txt = tmp102.Tpl_popBlock_rettype_1;
  tmp103 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("}"));
  tmp104 = _Tpl_writeTok(_out_txt, tmp103);
  _out_txt = tmp104.Tpl_writeTok_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionBodyBoxedImpl_rettypeboxed boxptr_SimCodeC_functionBodyBoxedImpl(modelica_metatype _txt, modelica_metatype _a_name, modelica_metatype _a_funargs, modelica_metatype _a_outvars)
{
  SimCodeC_functionBodyBoxedImpl_rettypeboxed tmp1;
  SimCodeC_functionBodyBoxedImpl_rettype tmp2;
  tmp2 = _SimCodeC_functionBodyBoxedImpl(_txt, _a_name, _a_funargs, _a_outvars);
  tmp1.SimCodeC_functionBodyBoxedImpl_rettypeboxed_1 = tmp2.SimCodeC_functionBodyBoxedImpl_rettype_1;
  return tmp1;
}
SimCodeC_fun__396_rettype _SimCodeC_fun__396(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__396_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("restore_memory_state("));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__396_rettypeboxed boxptr_SimCodeC_fun__396(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__396_rettypeboxed tmp1;
  SimCodeC_fun__396_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__396(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__396_rettypeboxed_1 = tmp2.SimCodeC_fun__396_rettype_1;
  return tmp1;
}
SimCodeC_fun__395_rettype _SimCodeC_fun__395(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_funRetVar)
{
  SimCodeC_fun__395_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outvars;
    tmp3_in2 = _in_a_funRetVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_funRetVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_funRetVar = tmp3_in2;
          tmp6 = _Tpl_writeText(_txt, _a_funRetVar);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__395_rettypeboxed boxptr_SimCodeC_fun__395(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_funRetVar)
{
  SimCodeC_fun__395_rettypeboxed tmp1;
  SimCodeC_fun__395_rettype tmp2;
  tmp2 = _SimCodeC_fun__395(_in_txt, _in_a_outvars, _in_a_funRetVar);
  tmp1.SimCodeC_fun__395_rettypeboxed_1 = tmp2.SimCodeC_fun__395_rettype_1;
  return tmp1;
}
SimCodeC_fun__394_rettype _SimCodeC_fun__394(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__394_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_stateVar;
    {
      modelica_metatype _txt;
      modelica_metatype _a_stateVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          Tpl_writeText_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_stateVar = tmp3_in2;
          tmp6 = _Tpl_writeText(_txt, _a_stateVar);
          _txt = tmp6.Tpl_writeText_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = get_memory_state();"));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__394_rettypeboxed boxptr_SimCodeC_fun__394(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_stateVar)
{
  SimCodeC_fun__394_rettypeboxed tmp1;
  SimCodeC_fun__394_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__394(_in_txt, tmp3, _in_a_stateVar);
  tmp1.SimCodeC_fun__394_rettypeboxed_1 = tmp2.SimCodeC_fun__394_rettype_1;
  return tmp1;
}
SimCodeC_lm__393_rettype _SimCodeC_lm__393(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__393_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgBoxedDefinition_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__393_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgBoxedDefinition(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgBoxedDefinition_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__393(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__393_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__393_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__393(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__393_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__393_rettypeboxed boxptr_SimCodeC_lm__393(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__393_rettypeboxed tmp1;
  SimCodeC_lm__393_rettype tmp2;
  tmp2 = _SimCodeC_lm__393(_in_txt, _in_items);
  tmp1.SimCodeC_lm__393_rettypeboxed_1 = tmp2.SimCodeC_lm__393_rettype_1;
  return tmp1;
}
SimCodeC_lm__392_rettype _SimCodeC_lm__392(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varUnbox, modelica_metatype _in_a_retTypeBoxed, modelica_metatype _in_a_retVar, modelica_metatype _in_a_retType, modelica_metatype _in_a_funRetVar)
{
  SimCodeC_lm__392_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_varUnbox;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    modelica_metatype tmp3_in6;
    modelica_metatype tmp3_in7;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_varUnbox;
    tmp3_in4 = _in_a_retTypeBoxed;
    tmp3_in5 = _in_a_retVar;
    tmp3_in6 = _in_a_retType;
    tmp3_in7 = _in_a_funRetVar;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_varUnbox;
      modelica_metatype _a_retTypeBoxed;
      modelica_metatype _a_retVar;
      modelica_metatype _a_retType;
      modelica_metatype _a_funRetVar;
      modelica_integer _x_i1;
      modelica_metatype _i_ty;
      modelica_metatype _l_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_varUnbox = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varUnbox;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_getIteri__i0_rettype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          Tpl_writeText_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          Tpl_writeText_rettype tmp19;
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          intString_rettype tmp22;
          Tpl_writeStr_rettype tmp23;
          Tpl_writeText_rettype tmp24;
          modelica_metatype tmp25;
          Tpl_writeTok_rettype tmp26;
          Tpl_writeText_rettype tmp27;
          modelica_metatype tmp28;
          Tpl_writeTok_rettype tmp29;
          intString_rettype tmp30;
          Tpl_writeStr_rettype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          Tpl_textString_rettype tmp34;
          SimCodeC_funArgBox_rettype tmp35;
          modelica_metatype tmp36;
          Tpl_writeTok_rettype tmp37;
          Tpl_nextIter_rettype tmp38;
          SimCodeC_lm__392_rettype tmp39;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_ty = tmp9;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_varUnbox = tmp3_in3;
          _a_retTypeBoxed = tmp3_in4;
          _a_retVar = tmp3_in5;
          _a_retType = tmp3_in6;
          _a_funRetVar = tmp3_in7;
          tmp12 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp12.Tpl_getIteri__i0_rettype_1;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = _Tpl_writeText(tmp15, _a_funRetVar);
          _l_arg = tmp16.Tpl_writeText_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp18 = _Tpl_writeTok(_l_arg, tmp17);
          _l_arg = tmp18.Tpl_writeTok_rettype_1;
          tmp19 = _Tpl_writeText(_l_arg, _a_retType);
          _l_arg = tmp19.Tpl_writeText_rettype_1;
          tmp20 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp21 = _Tpl_writeTok(_l_arg, tmp20);
          _l_arg = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = intString((modelica_integer)_x_i1);
          tmp23 = _Tpl_writeStr(_l_arg, tmp22);
          _l_arg = tmp23.Tpl_writeStr_rettype_1;
          tmp24 = _Tpl_writeText(_txt, _a_retVar);
          _txt = tmp24.Tpl_writeText_rettype_1;
          tmp25 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp26 = _Tpl_writeTok(_txt, tmp25);
          _txt = tmp26.Tpl_writeTok_rettype_1;
          tmp27 = _Tpl_writeText(_txt, _a_retTypeBoxed);
          _txt = tmp27.Tpl_writeText_rettype_1;
          tmp28 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp29 = _Tpl_writeTok(_txt, tmp28);
          _txt = tmp29.Tpl_writeTok_rettype_1;
          tmp30 = intString((modelica_integer)_x_i1);
          tmp31 = _Tpl_writeStr(_txt, tmp30);
          _txt = tmp31.Tpl_writeStr_rettype_1;
          tmp32 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp33 = _Tpl_writeTok(_txt, tmp32);
          _txt = tmp33.Tpl_writeTok_rettype_1;
          tmp34 = _Tpl_textString(_l_arg);
          tmp35 = _SimCodeC_funArgBox(_txt, tmp34.Tpl_textString_rettype_1, _i_ty, _a_varUnbox, _a_varDecls);
          _txt = tmp35.targ1;
          _a_varUnbox = tmp35.targ2;
          _a_varDecls = tmp35.targ3;
          tmp36 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp37 = _Tpl_writeTok(_txt, tmp36);
          _txt = tmp37.Tpl_writeTok_rettype_1;
          tmp38 = _Tpl_nextIter(_txt);
          _txt = tmp38.Tpl_nextIter_rettype_1;
          tmp39 = _SimCodeC_lm__392(_txt, _rest, _a_varDecls, _a_varUnbox, _a_retTypeBoxed, _a_retVar, _a_retType, _a_funRetVar);
          _txt = tmp39.targ1;
          _a_varDecls = tmp39.targ2;
          _a_varUnbox = tmp39.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varUnbox;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          SimCodeC_lm__392_rettype tmp42;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp40 = MMC_CAR(tmp3_in1);
          tmp41 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp41;
          _a_varDecls = tmp3_in2;
          _a_varUnbox = tmp3_in3;
          _a_retTypeBoxed = tmp3_in4;
          _a_retVar = tmp3_in5;
          _a_retType = tmp3_in6;
          _a_funRetVar = tmp3_in7;
          tmp42 = _SimCodeC_lm__392(_txt, _rest, _a_varDecls, _a_varUnbox, _a_retTypeBoxed, _a_retVar, _a_retType, _a_funRetVar);
          _txt = tmp42.targ1;
          _a_varDecls = tmp42.targ2;
          _a_varUnbox = tmp42.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varUnbox;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_varUnbox = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_varUnbox;
  return tmp1;
}


SimCodeC_lm__392_rettypeboxed boxptr_SimCodeC_lm__392(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varUnbox, modelica_metatype _in_a_retTypeBoxed, modelica_metatype _in_a_retVar, modelica_metatype _in_a_retType, modelica_metatype _in_a_funRetVar)
{
  SimCodeC_lm__392_rettypeboxed tmp1;
  SimCodeC_lm__392_rettype tmp2;
  tmp2 = _SimCodeC_lm__392(_in_txt, _in_items, _in_a_varDecls, _in_a_varUnbox, _in_a_retTypeBoxed, _in_a_retVar, _in_a_retType, _in_a_funRetVar);
  tmp1.SimCodeC_lm__392_rettypeboxed_1 = tmp2.SimCodeC_lm__392_rettype_1;
  tmp1.SimCodeC_lm__392_rettypeboxed_2 = tmp2.SimCodeC_lm__392_rettype_2;
  tmp1.SimCodeC_lm__392_rettypeboxed_3 = tmp2.SimCodeC_lm__392_rettype_3;
  return tmp1;
}
SimCodeC_funArgBox_rettype _SimCodeC_funArgBox(modelica_metatype _txt, modelica_string _a_varName, modelica_metatype _a_ty, modelica_metatype _a_varUnbox, modelica_metatype _a_varDecls)
{
  SimCodeC_funArgBox_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varUnbox;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _l_constructorType;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  SimCodeC_mmcConstructorType_rettype tmp5;
  SimCodeC_fun__410_rettype tmp6;


  tmp2 = mmc_mk_nil();
  tmp3 = mmc_mk_nil();
  tmp4 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp2, tmp3);
  tmp5 = _SimCodeC_mmcConstructorType(tmp4, _a_ty);
  _l_constructorType = tmp5.SimCodeC_mmcConstructorType_rettype_1;
  tmp6 = _SimCodeC_fun__410(_txt, _l_constructorType, _a_varDecls, _a_varUnbox, _a_ty, _a_varName);
  _out_txt = tmp6.targ1;
  _out_a_varDecls = tmp6.targ2;
  _out_a_varUnbox = tmp6.targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varUnbox;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_funArgBox_rettypeboxed boxptr_SimCodeC_funArgBox(modelica_metatype _txt, modelica_metatype _a_varName, modelica_metatype _a_ty, modelica_metatype _a_varUnbox, modelica_metatype _a_varDecls)
{
  SimCodeC_funArgBox_rettypeboxed tmp1;
  SimCodeC_funArgBox_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_a_varName);
  tmp2 = _SimCodeC_funArgBox(_txt, tmp3, _a_ty, _a_varUnbox, _a_varDecls);
  tmp1.SimCodeC_funArgBox_rettypeboxed_1 = tmp2.SimCodeC_funArgBox_rettype_1;
  tmp1.SimCodeC_funArgBox_rettypeboxed_2 = tmp2.SimCodeC_funArgBox_rettype_2;
  tmp1.SimCodeC_funArgBox_rettypeboxed_3 = tmp2.SimCodeC_funArgBox_rettype_3;
  return tmp1;
}
SimCodeC_fun__410_rettype _SimCodeC_fun__410(modelica_metatype _in_txt, modelica_metatype _in_a_constructorType, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varUnbox, modelica_metatype _in_a_ty, modelica_string _in_a_varName)
{
  SimCodeC_fun__410_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_varUnbox;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_string tmp3_in5;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_constructorType;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_varUnbox;
    tmp3_in4 = _in_a_ty;
    tmp3_in5 = _in_a_varName;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_varUnbox;
      modelica_metatype _a_ty;
      modelica_string _a_varName;
      modelica_metatype _i_constructorType;
      modelica_metatype _l_tmpVar;
      modelica_metatype _l_constructor;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_writeStr_rettype tmp8;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          if (!listEmpty(tmp6)) MMC_THROW();
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_varUnbox = tmp3_in3;
          _a_varName = tmp3_in5;
          tmp8 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp8.Tpl_writeStr_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varUnbox;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_mmcConstructor_rettype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          Tpl_textString_rettype tmp16;
          SimCodeC_tempDecl_rettype tmp17;
          Tpl_writeText_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          Tpl_writeText_rettype tmp21;
          modelica_metatype tmp22;
          Tpl_writeTok_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          Tpl_writeText_rettype tmp26;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_constructorType = tmp3_in1;
          _a_varDecls = tmp3_in2;
          _a_varUnbox = tmp3_in3;
          _a_ty = tmp3_in4;
          _a_varName = tmp3_in5;
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp9, tmp10);
          tmp12 = _SimCodeC_mmcConstructor(tmp11, _a_ty, _a_varName, _a_varUnbox, _a_varDecls);
          _l_constructor = tmp12.targ1;
          _a_varUnbox = tmp12.targ2;
          _a_varDecls = tmp12.targ3;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = _Tpl_textString(_i_constructorType);
          tmp17 = _SimCodeC_tempDecl(tmp15, tmp16.Tpl_textString_rettype_1, _a_varDecls);
          _l_tmpVar = tmp17.targ1;
          _a_varDecls = tmp17.targ2;
          tmp18 = _Tpl_writeText(_a_varUnbox, _l_tmpVar);
          _a_varUnbox = tmp18.Tpl_writeText_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp20 = _Tpl_writeTok(_a_varUnbox, tmp19);
          _a_varUnbox = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = _Tpl_writeText(_a_varUnbox, _l_constructor);
          _a_varUnbox = tmp21.Tpl_writeText_rettype_1;
          tmp22 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp23 = _Tpl_writeTok(_a_varUnbox, tmp22);
          _a_varUnbox = tmp23.Tpl_writeTok_rettype_1;
          tmp24 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp25 = _Tpl_writeTok(_a_varUnbox, tmp24);
          _a_varUnbox = tmp25.Tpl_writeTok_rettype_1;
          tmp26 = _Tpl_writeText(_txt, _l_tmpVar);
          _txt = tmp26.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varUnbox;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_varUnbox = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_varUnbox;
  return tmp1;
}


SimCodeC_fun__410_rettypeboxed boxptr_SimCodeC_fun__410(modelica_metatype _in_txt, modelica_metatype _in_a_constructorType, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varUnbox, modelica_metatype _in_a_ty, modelica_metatype _in_a_varName)
{
  SimCodeC_fun__410_rettypeboxed tmp1;
  SimCodeC_fun__410_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_varName);
  tmp2 = _SimCodeC_fun__410(_in_txt, _in_a_constructorType, _in_a_varDecls, _in_a_varUnbox, _in_a_ty, tmp3);
  tmp1.SimCodeC_fun__410_rettypeboxed_1 = tmp2.SimCodeC_fun__410_rettype_1;
  tmp1.SimCodeC_fun__410_rettypeboxed_2 = tmp2.SimCodeC_fun__410_rettype_2;
  tmp1.SimCodeC_fun__410_rettypeboxed_3 = tmp2.SimCodeC_fun__410_rettype_3;
  return tmp1;
}
SimCodeC_mmcConstructor_rettype _SimCodeC_mmcConstructor(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_string _in_a_varName, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_mmcConstructor_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_string tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_type;
    tmp3_in2 = _in_a_varName;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_string _a_varName;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_path;
      modelica_metatype _i_vars;
      modelica_metatype _l_varsStr;
      modelica_integer _ret_2;
      modelica_integer _ret_1;
      modelica_metatype _l_varCount;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 9 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeStr_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_icon("));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp8.Tpl_writeStr_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp11;
          Tpl_writeTok_rettype tmp12;
          Tpl_writeStr_rettype tmp13;
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp11 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_icon("));
          tmp12 = _Tpl_writeTok(_txt, tmp11);
          _txt = tmp12.Tpl_writeTok_rettype_1;
          tmp13 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp13.Tpl_writeStr_rettype_1;
          tmp14 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          Tpl_writeStr_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_rcon("));
          tmp17 = _Tpl_writeTok(_txt, tmp16);
          _txt = tmp17.Tpl_writeTok_rettype_1;
          tmp18 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp18.Tpl_writeStr_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp20 = _Tpl_writeTok(_txt, tmp19);
          _txt = tmp20.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          Tpl_writeStr_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_scon("));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp23.Tpl_writeStr_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp25 = _Tpl_writeTok(_txt, tmp24);
          _txt = tmp25.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          Tpl_writeStr_rettype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,4,3) == 0) MMC_THROW();
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp29 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_icon("));
          tmp30 = _Tpl_writeTok(_txt, tmp29);
          _txt = tmp30.Tpl_writeTok_rettype_1;
          tmp31 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp31.Tpl_writeStr_rettype_1;
          tmp32 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp33 = _Tpl_writeTok(_txt, tmp32);
          _txt = tmp33.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          Tpl_writeTok_rettype tmp37;
          Tpl_writeStr_rettype tmp38;
          modelica_metatype tmp39;
          Tpl_writeTok_rettype tmp40;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,7,2) == 0) MMC_THROW();
          tmp34 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp36 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_acon("));
          tmp37 = _Tpl_writeTok(_txt, tmp36);
          _txt = tmp37.Tpl_writeTok_rettype_1;
          tmp38 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp38.Tpl_writeStr_rettype_1;
          tmp39 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp40 = _Tpl_writeTok(_txt, tmp39);
          _txt = tmp40.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 6: {
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          listLength_rettype tmp45;
          SimCode_incrementInt_rettype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          intString_rettype tmp50;
          Tpl_writeStr_rettype tmp51;
          modelica_metatype tmp52;
          modelica_metatype tmp53;
          modelica_metatype tmp54;
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          Tpl_pushIter_rettype tmp59;
          SimCodeC_lm__413_rettype tmp60;
          Tpl_popIter_rettype tmp61;
          modelica_metatype tmp62;
          Tpl_writeTok_rettype tmp63;
          Tpl_writeText_rettype tmp64;
          modelica_metatype tmp65;
          Tpl_writeTok_rettype tmp66;
          SimCodeC_underscorePath_rettype tmp67;
          modelica_metatype tmp68;
          Tpl_writeTok_rettype tmp69;
          Tpl_writeText_rettype tmp70;
          modelica_metatype tmp71;
          Tpl_writeTok_rettype tmp72;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp41 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp42 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp43 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          if (mmc__uniontype__metarecord__typedef__equal(tmp43,3,1) == 0) MMC_THROW();
          tmp44 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp43), 2));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_vars = tmp42;
          _i_path = tmp44;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp45 = listLength(_i_vars);
          _ret_1 = tmp45;
          tmp46 = _SimCode_incrementInt((modelica_integer)_ret_1, 1);
          _ret_2 = tmp46.SimCode_incrementInt_rettype_1;
          tmp47 = mmc_mk_nil();
          tmp48 = mmc_mk_nil();
          tmp49 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp47, tmp48);
          tmp50 = intString((modelica_integer)_ret_2);
          tmp51 = _Tpl_writeStr(tmp49, tmp50);
          _l_varCount = tmp51.Tpl_writeStr_rettype_1;
          tmp52 = mmc_mk_nil();
          tmp53 = mmc_mk_nil();
          tmp54 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp52, tmp53);
          tmp55 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp56 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp57 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp58 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp55), mmc_mk_integer(0), mmc_mk_integer(0), tmp56, mmc_mk_integer(0), tmp57);
          tmp59 = _Tpl_pushIter(tmp54, tmp58);
          _l_varsStr = tmp59.Tpl_pushIter_rettype_1;
          tmp60 = _SimCodeC_lm__413(_l_varsStr, _i_vars, _a_varDecls, _a_preExp, _a_varName);
          _l_varsStr = tmp60.targ1;
          _a_varDecls = tmp60.targ2;
          _a_preExp = tmp60.targ3;
          tmp61 = _Tpl_popIter(_l_varsStr);
          _l_varsStr = tmp61.Tpl_popIter_rettype_1;
          tmp62 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_box"));
          tmp63 = _Tpl_writeTok(_txt, tmp62);
          _txt = tmp63.Tpl_writeTok_rettype_1;
          tmp64 = _Tpl_writeText(_txt, _l_varCount);
          _txt = tmp64.Tpl_writeText_rettype_1;
          tmp65 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(3, &"));
          tmp66 = _Tpl_writeTok(_txt, tmp65);
          _txt = tmp66.Tpl_writeTok_rettype_1;
          tmp67 = _SimCodeC_underscorePath(_txt, _i_path);
          _txt = tmp67.SimCodeC_underscorePath_rettype_1;
          tmp68 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("__desc, "));
          tmp69 = _Tpl_writeTok(_txt, tmp68);
          _txt = tmp69.Tpl_writeTok_rettype_1;
          tmp70 = _Tpl_writeText(_txt, _l_varsStr);
          _txt = tmp70.Tpl_writeText_rettype_1;
          tmp71 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp72 = _Tpl_writeTok(_txt, tmp71);
          _txt = tmp72.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 7: {
          modelica_metatype tmp73;
          modelica_metatype tmp74;
          modelica_metatype tmp75;
          modelica_metatype tmp76;
          Tpl_writeTok_rettype tmp77;
          Tpl_writeStr_rettype tmp78;
          modelica_metatype tmp79;
          Tpl_writeTok_rettype tmp80;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp73 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp74 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp75 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp76 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_box("));
          tmp77 = _Tpl_writeTok(_txt, tmp76);
          _txt = tmp77.Tpl_writeTok_rettype_1;
          tmp78 = _Tpl_writeStr(_txt, _a_varName);
          _txt = tmp78.Tpl_writeStr_rettype_1;
          tmp79 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp80 = _Tpl_writeTok(_txt, tmp79);
          _txt = tmp80.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 8: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_mmcConstructor_rettypeboxed boxptr_SimCodeC_mmcConstructor(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_metatype _in_a_varName, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_mmcConstructor_rettypeboxed tmp1;
  SimCodeC_mmcConstructor_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_varName);
  tmp2 = _SimCodeC_mmcConstructor(_in_txt, _in_a_type, tmp3, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_mmcConstructor_rettypeboxed_1 = tmp2.SimCodeC_mmcConstructor_rettype_1;
  tmp1.SimCodeC_mmcConstructor_rettypeboxed_2 = tmp2.SimCodeC_mmcConstructor_rettype_2;
  tmp1.SimCodeC_mmcConstructor_rettypeboxed_3 = tmp2.SimCodeC_mmcConstructor_rettype_3;
  return tmp1;
}
SimCodeC_lm__413_rettype _SimCodeC_lm__413(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_string _in_a_varName)
{
  SimCodeC_lm__413_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_string tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varName;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_string _a_varName;
      modelica_metatype _i_tp;
      modelica_string _i_name;
      modelica_metatype _l_varname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_string tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          Tpl_writeStr_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          Tpl_writeStr_rettype tmp17;
          Tpl_textString_rettype tmp18;
          SimCodeC_funArgBox_rettype tmp19;
          Tpl_nextIter_rettype tmp20;
          SimCodeC_lm__413_rettype tmp21;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,2) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = mmc_unbox_string(tmp8);
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp9;
          _i_tp = tmp10;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varName = tmp3_in4;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          tmp14 = _Tpl_writeStr(tmp13, _a_varName);
          _l_varname = tmp14.Tpl_writeStr_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp16 = _Tpl_writeTok(_l_varname, tmp15);
          _l_varname = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = _Tpl_writeStr(_l_varname, _i_name);
          _l_varname = tmp17.Tpl_writeStr_rettype_1;
          tmp18 = _Tpl_textString(_l_varname);
          tmp19 = _SimCodeC_funArgBox(_txt, tmp18.Tpl_textString_rettype_1, _i_tp, _a_preExp, _a_varDecls);
          _txt = tmp19.targ1;
          _a_preExp = tmp19.targ2;
          _a_varDecls = tmp19.targ3;
          tmp20 = _Tpl_nextIter(_txt);
          _txt = tmp20.Tpl_nextIter_rettype_1;
          tmp21 = _SimCodeC_lm__413(_txt, _rest, _a_varDecls, _a_preExp, _a_varName);
          _txt = tmp21.targ1;
          _a_varDecls = tmp21.targ2;
          _a_preExp = tmp21.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          SimCodeC_lm__413_rettype tmp24;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp22 = MMC_CAR(tmp3_in1);
          tmp23 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp23;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varName = tmp3_in4;
          tmp24 = _SimCodeC_lm__413(_txt, _rest, _a_varDecls, _a_preExp, _a_varName);
          _txt = tmp24.targ1;
          _a_varDecls = tmp24.targ2;
          _a_preExp = tmp24.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_lm__413_rettypeboxed boxptr_SimCodeC_lm__413(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varName)
{
  SimCodeC_lm__413_rettypeboxed tmp1;
  SimCodeC_lm__413_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_varName);
  tmp2 = _SimCodeC_lm__413(_in_txt, _in_items, _in_a_varDecls, _in_a_preExp, tmp3);
  tmp1.SimCodeC_lm__413_rettypeboxed_1 = tmp2.SimCodeC_lm__413_rettype_1;
  tmp1.SimCodeC_lm__413_rettypeboxed_2 = tmp2.SimCodeC_lm__413_rettype_2;
  tmp1.SimCodeC_lm__413_rettypeboxed_3 = tmp2.SimCodeC_lm__413_rettype_3;
  return tmp1;
}
SimCodeC_mmcConstructorType_rettype _SimCodeC_mmcConstructorType(modelica_metatype _in_txt, modelica_metatype _in_a_type)
{
  SimCodeC_mmcConstructorType_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_type;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 8 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,4,3) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,7,2) == 0) MMC_THROW();
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 6: {
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp23 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 7: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_mmcConstructorType_rettypeboxed boxptr_SimCodeC_mmcConstructorType(modelica_metatype _in_txt, modelica_metatype _in_a_type)
{
  SimCodeC_mmcConstructorType_rettypeboxed tmp1;
  SimCodeC_mmcConstructorType_rettype tmp2;
  tmp2 = _SimCodeC_mmcConstructorType(_in_txt, _in_a_type);
  tmp1.SimCodeC_mmcConstructorType_rettypeboxed_1 = tmp2.SimCodeC_mmcConstructorType_rettype_1;
  return tmp1;
}
SimCodeC_lm__391_rettype _SimCodeC_lm__391(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varBox, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__391_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varBox;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varBox;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varBox;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varBox = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varBox;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgUnbox_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__391_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          _a_varBox = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp8 = _SimCodeC_funArgUnbox(_txt, _i_arg, _a_varDecls, _a_varBox);
          _txt = tmp8.targ1;
          _a_varDecls = tmp8.targ2;
          _a_varBox = tmp8.targ3;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__391(_txt, _rest, _a_varBox, _a_varDecls);
          _txt = tmp10.targ1;
          _a_varBox = tmp10.targ2;
          _a_varDecls = tmp10.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varBox;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__391_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varBox = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp13 = _SimCodeC_lm__391(_txt, _rest, _a_varBox, _a_varDecls);
          _txt = tmp13.targ1;
          _a_varBox = tmp13.targ2;
          _a_varDecls = tmp13.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varBox;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varBox = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varBox;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__391_rettypeboxed boxptr_SimCodeC_lm__391(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varBox, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__391_rettypeboxed tmp1;
  SimCodeC_lm__391_rettype tmp2;
  tmp2 = _SimCodeC_lm__391(_in_txt, _in_items, _in_a_varBox, _in_a_varDecls);
  tmp1.SimCodeC_lm__391_rettypeboxed_1 = tmp2.SimCodeC_lm__391_rettype_1;
  tmp1.SimCodeC_lm__391_rettypeboxed_2 = tmp2.SimCodeC_lm__391_rettype_2;
  tmp1.SimCodeC_lm__391_rettypeboxed_3 = tmp2.SimCodeC_lm__391_rettype_3;
  return tmp1;
}
SimCodeC_funArgUnbox_rettype _SimCodeC_funArgUnbox(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varBox)
{
  SimCodeC_funArgUnbox_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_varBox;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_varBox;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_varBox;
      modelica_string _i_name_1;
      modelica_metatype _i_ty;
      modelica_metatype _i_name;
      modelica_metatype _l_varName;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_contextCref_rettype tmp14;
          Tpl_textString_rettype tmp15;
          SimCodeC_unboxVariable_rettype tmp16;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp6;
          _i_ty = tmp7;
          _a_varDecls = tmp3_in2;
          _a_varBox = tmp3_in3;
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp10, tmp11);
          tmp13 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp14 = _SimCodeC_contextCref(tmp12, _i_name, tmp13);
          _l_varName = tmp14.SimCodeC_contextCref_rettype_1;
          tmp15 = _Tpl_textString(_l_varName);
          tmp16 = _SimCodeC_unboxVariable(_txt, tmp15.Tpl_textString_rettype_1, _i_ty, _a_varBox, _a_varDecls);
          _txt = tmp16.targ1;
          _a_varBox = tmp16.targ2;
          _a_varDecls = tmp16.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varBox;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp17;
          modelica_string tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          Tpl_writeStr_rettype tmp21;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,3) == 0) MMC_THROW();
          tmp17 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp18 = mmc_unbox_string(tmp17);
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name_1 = tmp18;
          _a_varDecls = tmp3_in2;
          _a_varBox = tmp3_in3;
          tmp21 = _Tpl_writeStr(_txt, _i_name_1);
          _txt = tmp21.Tpl_writeStr_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varBox;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_varBox = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varBox;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_varBox = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_varBox;
  return tmp1;
}


SimCodeC_funArgUnbox_rettypeboxed boxptr_SimCodeC_funArgUnbox(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varBox)
{
  SimCodeC_funArgUnbox_rettypeboxed tmp1;
  SimCodeC_funArgUnbox_rettype tmp2;
  tmp2 = _SimCodeC_funArgUnbox(_in_txt, _in_a_var, _in_a_varDecls, _in_a_varBox);
  tmp1.SimCodeC_funArgUnbox_rettypeboxed_1 = tmp2.SimCodeC_funArgUnbox_rettype_1;
  tmp1.SimCodeC_funArgUnbox_rettypeboxed_2 = tmp2.SimCodeC_funArgUnbox_rettype_2;
  tmp1.SimCodeC_funArgUnbox_rettypeboxed_3 = tmp2.SimCodeC_funArgUnbox_rettype_3;
  return tmp1;
}
SimCodeC_fun__390_rettype _SimCodeC_fun__390(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__390_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_tempDecl_rettype tmp6;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp6 = _SimCodeC_tempDecl(_txt, "state", _a_varDecls);
          _txt = tmp6.targ1;
          _a_varDecls = tmp6.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__390_rettypeboxed boxptr_SimCodeC_fun__390(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__390_rettypeboxed tmp1;
  SimCodeC_fun__390_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__390(_in_txt, tmp3, _in_a_varDecls);
  tmp1.SimCodeC_fun__390_rettypeboxed_1 = tmp2.SimCodeC_fun__390_rettype_1;
  tmp1.SimCodeC_fun__390_rettypeboxed_2 = tmp2.SimCodeC_fun__390_rettype_2;
  return tmp1;
}
SimCodeC_fun__389_rettype _SimCodeC_fun__389(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__389_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outvars;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_retType;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_retType;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_textString_rettype tmp6;
          SimCodeC_tempDecl_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_retType = tmp3_in3;
          tmp6 = _Tpl_textString(_a_retType);
          tmp7 = _SimCodeC_tempDecl(_txt, tmp6.Tpl_textString_rettype_1, _a_varDecls);
          _txt = tmp7.targ1;
          _a_varDecls = tmp7.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__389_rettypeboxed boxptr_SimCodeC_fun__389(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__389_rettypeboxed tmp1;
  SimCodeC_fun__389_rettype tmp2;
  tmp2 = _SimCodeC_fun__389(_in_txt, _in_a_outvars, _in_a_varDecls, _in_a_retType);
  tmp1.SimCodeC_fun__389_rettypeboxed_1 = tmp2.SimCodeC_fun__389_rettype_1;
  tmp1.SimCodeC_fun__389_rettypeboxed_2 = tmp2.SimCodeC_fun__389_rettype_2;
  return tmp1;
}
SimCodeC_fun__388_rettype _SimCodeC_fun__388(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retTypeBoxed)
{
  SimCodeC_fun__388_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outvars;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_retTypeBoxed;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_retTypeBoxed;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_textString_rettype tmp6;
          SimCodeC_tempDecl_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_retTypeBoxed = tmp3_in3;
          tmp6 = _Tpl_textString(_a_retTypeBoxed);
          tmp7 = _SimCodeC_tempDecl(_txt, tmp6.Tpl_textString_rettype_1, _a_varDecls);
          _txt = tmp7.targ1;
          _a_varDecls = tmp7.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__388_rettypeboxed boxptr_SimCodeC_fun__388(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retTypeBoxed)
{
  SimCodeC_fun__388_rettypeboxed tmp1;
  SimCodeC_fun__388_rettype tmp2;
  tmp2 = _SimCodeC_fun__388(_in_txt, _in_a_outvars, _in_a_varDecls, _in_a_retTypeBoxed);
  tmp1.SimCodeC_fun__388_rettypeboxed_1 = tmp2.SimCodeC_fun__388_rettype_1;
  tmp1.SimCodeC_fun__388_rettypeboxed_2 = tmp2.SimCodeC_fun__388_rettype_2;
  return tmp1;
}
SimCodeC_fun__387_rettype _SimCodeC_fun__387(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__387_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outvars;
    tmp3_in2 = _in_a_retType;
    {
      modelica_metatype _txt;
      modelica_metatype _a_retType;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_retType = tmp3_in2;
          tmp8 = _Tpl_writeText(_txt, _a_retType);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("boxed"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__387_rettypeboxed boxptr_SimCodeC_fun__387(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__387_rettypeboxed tmp1;
  SimCodeC_fun__387_rettype tmp2;
  tmp2 = _SimCodeC_fun__387(_in_txt, _in_a_outvars, _in_a_retType);
  tmp1.SimCodeC_fun__387_rettypeboxed_1 = tmp2.SimCodeC_fun__387_rettype_1;
  return tmp1;
}
SimCodeC_fun__386_rettype _SimCodeC_fun__386(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__386_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outvars;
    tmp3_in2 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_metatype _a_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fname = tmp3_in2;
          tmp8 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__386_rettypeboxed boxptr_SimCodeC_fun__386(modelica_metatype _in_txt, modelica_metatype _in_a_outvars, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__386_rettypeboxed tmp1;
  SimCodeC_fun__386_rettype tmp2;
  tmp2 = _SimCodeC_fun__386(_in_txt, _in_a_outvars, _in_a_fname);
  tmp1.SimCodeC_fun__386_rettypeboxed_1 = tmp2.SimCodeC_fun__386_rettype_1;
  return tmp1;
}
SimCodeC_fun__352_rettype _SimCodeC_fun__352(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_fn)
{
  SimCodeC_fun__352_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_fn;
    {
      modelica_metatype _txt;
      modelica_metatype _a_fn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_functionBodyBoxed_rettype tmp6;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fn = tmp3_in2;
          tmp6 = _SimCodeC_functionBodyBoxed(_txt, _a_fn);
          _txt = tmp6.SimCodeC_functionBodyBoxed_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__352_rettypeboxed boxptr_SimCodeC_fun__352(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_fn)
{
  SimCodeC_fun__352_rettypeboxed tmp1;
  SimCodeC_fun__352_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__352(_in_txt, tmp3, _in_a_fn);
  tmp1.SimCodeC_fun__352_rettypeboxed_1 = tmp2.SimCodeC_fun__352_rettype_1;
  return tmp1;
}
SimCodeC_lm__351_rettype _SimCodeC_lm__351(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_outVarAssign, modelica_metatype _in_a_outVarCopy, modelica_metatype _in_a_outVarInits, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retVar)
{
  SimCodeC_lm__351_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_outVarAssign;
  modelica_metatype _out_a_outVarCopy;
  modelica_metatype _out_a_outVarInits;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;
  modelica_metatype tmp2_targ4;
  modelica_metatype tmp2_targ5;


  
  
  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    modelica_metatype tmp3_in6;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_outVarAssign;
    tmp3_in3 = _in_a_outVarCopy;
    tmp3_in4 = _in_a_outVarInits;
    tmp3_in5 = _in_a_varDecls;
    tmp3_in6 = _in_a_retVar;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_outVarAssign;
      modelica_metatype _a_outVarCopy;
      modelica_metatype _a_outVarInits;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_retVar;
      modelica_integer _x_i1;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_outVarAssign = tmp3_in2;
          _a_outVarCopy = tmp3_in3;
          _a_outVarInits = tmp3_in4;
          _a_varDecls = tmp3_in5;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_outVarAssign;
          tmp2_targ3 = _a_outVarCopy;
          tmp2_targ4 = _a_outVarInits;
          tmp2_targ5 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_getIteri__i0_rettype tmp8;
          Tpl_textString_rettype tmp9;
          SimCodeC_varOutput_rettype tmp10;
          Tpl_nextIter_rettype tmp11;
          SimCodeC_lm__351_rettype tmp12;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          _a_outVarAssign = tmp3_in2;
          _a_outVarCopy = tmp3_in3;
          _a_outVarInits = tmp3_in4;
          _a_varDecls = tmp3_in5;
          _a_retVar = tmp3_in6;
          tmp8 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp8.Tpl_getIteri__i0_rettype_1;
          tmp9 = _Tpl_textString(_a_retVar);
          tmp10 = _SimCodeC_varOutput(_txt, _i_var, tmp9.Tpl_textString_rettype_1, (modelica_integer)_x_i1, _a_varDecls, _a_outVarInits, _a_outVarCopy, _a_outVarAssign);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          _a_outVarInits = tmp10.targ3;
          _a_outVarCopy = tmp10.targ4;
          _a_outVarAssign = tmp10.targ5;
          tmp11 = _Tpl_nextIter(_txt);
          _txt = tmp11.Tpl_nextIter_rettype_1;
          tmp12 = _SimCodeC_lm__351(_txt, _rest, _a_outVarAssign, _a_outVarCopy, _a_outVarInits, _a_varDecls, _a_retVar);
          _txt = tmp12.targ1;
          _a_outVarAssign = tmp12.targ2;
          _a_outVarCopy = tmp12.targ3;
          _a_outVarInits = tmp12.targ4;
          _a_varDecls = tmp12.targ5;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_outVarAssign;
          tmp2_targ3 = _a_outVarCopy;
          tmp2_targ4 = _a_outVarInits;
          tmp2_targ5 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          SimCodeC_lm__351_rettype tmp15;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp13 = MMC_CAR(tmp3_in1);
          tmp14 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp14;
          _a_outVarAssign = tmp3_in2;
          _a_outVarCopy = tmp3_in3;
          _a_outVarInits = tmp3_in4;
          _a_varDecls = tmp3_in5;
          _a_retVar = tmp3_in6;
          tmp15 = _SimCodeC_lm__351(_txt, _rest, _a_outVarAssign, _a_outVarCopy, _a_outVarInits, _a_varDecls, _a_retVar);
          _txt = tmp15.targ1;
          _a_outVarAssign = tmp15.targ2;
          _a_outVarCopy = tmp15.targ3;
          _a_outVarInits = tmp15.targ4;
          _a_varDecls = tmp15.targ5;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_outVarAssign;
          tmp2_targ3 = _a_outVarCopy;
          tmp2_targ4 = _a_outVarInits;
          tmp2_targ5 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_outVarAssign = tmp2_targ2;
  _out_a_outVarCopy = tmp2_targ3;
  _out_a_outVarInits = tmp2_targ4;
  _out_a_varDecls = tmp2_targ5;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_outVarAssign;
  tmp1.targ3 = _out_a_outVarCopy;
  tmp1.targ4 = _out_a_outVarInits;
  tmp1.targ5 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__351_rettypeboxed boxptr_SimCodeC_lm__351(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_outVarAssign, modelica_metatype _in_a_outVarCopy, modelica_metatype _in_a_outVarInits, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retVar)
{
  SimCodeC_lm__351_rettypeboxed tmp1;
  SimCodeC_lm__351_rettype tmp2;
  tmp2 = _SimCodeC_lm__351(_in_txt, _in_items, _in_a_outVarAssign, _in_a_outVarCopy, _in_a_outVarInits, _in_a_varDecls, _in_a_retVar);
  tmp1.SimCodeC_lm__351_rettypeboxed_1 = tmp2.SimCodeC_lm__351_rettype_1;
  tmp1.SimCodeC_lm__351_rettypeboxed_2 = tmp2.SimCodeC_lm__351_rettype_2;
  tmp1.SimCodeC_lm__351_rettypeboxed_3 = tmp2.SimCodeC_lm__351_rettype_3;
  tmp1.SimCodeC_lm__351_rettypeboxed_4 = tmp2.SimCodeC_lm__351_rettype_4;
  tmp1.SimCodeC_lm__351_rettypeboxed_5 = tmp2.SimCodeC_lm__351_rettype_5;
  return tmp1;
}
SimCodeC_varOutput_rettype _SimCodeC_varOutput(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_string _in_a_dest, modelica_integer _in_a_ix, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varInits, modelica_metatype _in_a_varCopy, modelica_metatype _in_a_varAssign)
{
  SimCodeC_varOutput_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_varInits;
  modelica_metatype _out_a_varCopy;
  modelica_metatype _out_a_varAssign;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;
  modelica_metatype tmp2_targ4;
  modelica_metatype tmp2_targ5;


  
  
  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_string tmp3_in2;
    modelica_integer tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    modelica_metatype tmp3_in6;
    modelica_metatype tmp3_in7;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    tmp3_in2 = _in_a_dest;
    tmp3_in3 = (modelica_integer)_in_a_ix;
    tmp3_in4 = _in_a_varDecls;
    tmp3_in5 = _in_a_varInits;
    tmp3_in6 = _in_a_varCopy;
    tmp3_in7 = _in_a_varAssign;
    {
      modelica_metatype _txt;
      modelica_string _a_dest;
      modelica_integer _a_ix;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_varInits;
      modelica_metatype _a_varCopy;
      modelica_metatype _a_varAssign;
      modelica_string _i_var_name_1;
      modelica_metatype _i_var_ty;
      modelica_metatype _i_var;
      modelica_metatype _i_instDims;
      modelica_metatype _i_var_name;
      modelica_metatype _l_instDimsInit;
      modelica_boolean _ret_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp10;
          SimCodeC_fun__437_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          if (mmc__uniontype__metarecord__typedef__equal(tmp7,3,0) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var_name = tmp6;
          _a_dest = tmp3_in2;
          _a_ix = tmp3_in3;
          _a_varDecls = tmp3_in4;
          _a_varInits = tmp3_in5;
          _a_varCopy = tmp3_in6;
          _a_varAssign = tmp3_in7;
          tmp10 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_0 = tmp10.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp11 = _SimCodeC_fun__437(_txt, _ret_0, (modelica_integer)_a_ix, _a_dest, _a_varAssign, _i_var_name, _a_varCopy, _a_varDecls);
          _txt = tmp11.targ1;
          _a_varAssign = tmp11.targ2;
          _a_varCopy = tmp11.targ3;
          _a_varDecls = tmp11.targ4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varInits;
          tmp2_targ4 = _a_varCopy;
          tmp2_targ5 = _a_varAssign;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          Tpl_pushIter_rettype tmp23;
          SimCodeC_lm__438_rettype tmp24;
          Tpl_popIter_rettype tmp25;
          SimCodeC_fun__439_rettype tmp26;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp3_in1;
          _i_var_name = tmp12;
          _i_var_ty = tmp13;
          _i_instDims = tmp15;
          _a_dest = tmp3_in2;
          _a_ix = tmp3_in3;
          _a_varDecls = tmp3_in4;
          _a_varInits = tmp3_in5;
          _a_varCopy = tmp3_in6;
          _a_varAssign = tmp3_in7;
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp16, tmp17);
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp22 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp19), mmc_mk_integer(0), mmc_mk_integer(0), tmp20, mmc_mk_integer(0), tmp21);
          tmp23 = _Tpl_pushIter(tmp18, tmp22);
          _l_instDimsInit = tmp23.Tpl_pushIter_rettype_1;
          tmp24 = _SimCodeC_lm__438(_l_instDimsInit, _i_instDims, _a_varDecls, _a_varInits);
          _l_instDimsInit = tmp24.targ1;
          _a_varDecls = tmp24.targ2;
          _a_varInits = tmp24.targ3;
          tmp25 = _Tpl_popIter(_l_instDimsInit);
          _l_instDimsInit = tmp25.Tpl_popIter_rettype_1;
          tmp26 = _SimCodeC_fun__439(_txt, _i_instDims, _l_instDimsInit, _i_var_ty, _i_var_name, (modelica_integer)_a_ix, _a_dest, _a_varAssign, _i_var, _a_varInits);
          _txt = tmp26.targ1;
          _a_varAssign = tmp26.targ2;
          _a_varInits = tmp26.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varInits;
          tmp2_targ4 = _a_varCopy;
          tmp2_targ5 = _a_varAssign;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp27;
          modelica_string tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          Tpl_writeStr_rettype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          intString_rettype tmp34;
          Tpl_writeStr_rettype tmp35;
          modelica_metatype tmp36;
          Tpl_writeTok_rettype tmp37;
          Tpl_writeStr_rettype tmp38;
          modelica_metatype tmp39;
          Tpl_writeTok_rettype tmp40;
          modelica_metatype tmp41;
          Tpl_writeTok_rettype tmp42;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,3) == 0) MMC_THROW();
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp28 = mmc_unbox_string(tmp27);
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var_name_1 = tmp28;
          _a_dest = tmp3_in2;
          _a_ix = tmp3_in3;
          _a_varDecls = tmp3_in4;
          _a_varInits = tmp3_in5;
          _a_varCopy = tmp3_in6;
          _a_varAssign = tmp3_in7;
          tmp31 = _Tpl_writeStr(_a_varAssign, _a_dest);
          _a_varAssign = tmp31.Tpl_writeStr_rettype_1;
          tmp32 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".targ"));
          tmp33 = _Tpl_writeTok(_a_varAssign, tmp32);
          _a_varAssign = tmp33.Tpl_writeTok_rettype_1;
          tmp34 = intString((modelica_integer)_a_ix);
          tmp35 = _Tpl_writeStr(_a_varAssign, tmp34);
          _a_varAssign = tmp35.Tpl_writeStr_rettype_1;
          tmp36 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = (modelica_fnptr) _"));
          tmp37 = _Tpl_writeTok(_a_varAssign, tmp36);
          _a_varAssign = tmp37.Tpl_writeTok_rettype_1;
          tmp38 = _Tpl_writeStr(_a_varAssign, _i_var_name_1);
          _a_varAssign = tmp38.Tpl_writeStr_rettype_1;
          tmp39 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp40 = _Tpl_writeTok(_a_varAssign, tmp39);
          _a_varAssign = tmp40.Tpl_writeTok_rettype_1;
          tmp41 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp42 = _Tpl_writeTok(_a_varAssign, tmp41);
          _a_varAssign = tmp42.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varInits;
          tmp2_targ4 = _a_varCopy;
          tmp2_targ5 = _a_varAssign;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in4;
          _a_varInits = tmp3_in5;
          _a_varCopy = tmp3_in6;
          _a_varAssign = tmp3_in7;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varInits;
          tmp2_targ4 = _a_varCopy;
          tmp2_targ5 = _a_varAssign;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_varInits = tmp2_targ3;
  _out_a_varCopy = tmp2_targ4;
  _out_a_varAssign = tmp2_targ5;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_varInits;
  tmp1.targ4 = _out_a_varCopy;
  tmp1.targ5 = _out_a_varAssign;
  return tmp1;
}


SimCodeC_varOutput_rettypeboxed boxptr_SimCodeC_varOutput(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_metatype _in_a_dest, modelica_metatype _in_a_ix, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varInits, modelica_metatype _in_a_varCopy, modelica_metatype _in_a_varAssign)
{
  SimCodeC_varOutput_rettypeboxed tmp1;
  SimCodeC_varOutput_rettype tmp2;
  modelica_string tmp3;
  modelica_integer tmp4;
  tmp3 = mmc_unbox_string(_in_a_dest);
  tmp4 = mmc_unbox_integer(_in_a_ix);
  tmp2 = _SimCodeC_varOutput(_in_txt, _in_a_var, tmp3, tmp4, _in_a_varDecls, _in_a_varInits, _in_a_varCopy, _in_a_varAssign);
  tmp1.SimCodeC_varOutput_rettypeboxed_1 = tmp2.SimCodeC_varOutput_rettype_1;
  tmp1.SimCodeC_varOutput_rettypeboxed_2 = tmp2.SimCodeC_varOutput_rettype_2;
  tmp1.SimCodeC_varOutput_rettypeboxed_3 = tmp2.SimCodeC_varOutput_rettype_3;
  tmp1.SimCodeC_varOutput_rettypeboxed_4 = tmp2.SimCodeC_varOutput_rettype_4;
  tmp1.SimCodeC_varOutput_rettypeboxed_5 = tmp2.SimCodeC_varOutput_rettype_5;
  return tmp1;
}
SimCodeC_fun__439_rettype _SimCodeC_fun__439(modelica_metatype _in_txt, modelica_metatype _in_a_instDims, modelica_metatype _in_a_instDimsInit, modelica_metatype _in_a_var_ty, modelica_metatype _in_a_var_name, modelica_integer _in_a_ix, modelica_string _in_a_dest, modelica_metatype _in_a_varAssign, modelica_metatype _in_a_var, modelica_metatype _in_a_varInits)
{
  SimCodeC_fun__439_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varAssign;
  modelica_metatype _out_a_varInits;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_integer tmp3_in5;
    modelica_string tmp3_in6;
    modelica_metatype tmp3_in7;
    modelica_metatype tmp3_in8;
    modelica_metatype tmp3_in9;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_instDims;
    tmp3_in2 = _in_a_instDimsInit;
    tmp3_in3 = _in_a_var_ty;
    tmp3_in4 = _in_a_var_name;
    tmp3_in5 = (modelica_integer)_in_a_ix;
    tmp3_in6 = _in_a_dest;
    tmp3_in7 = _in_a_varAssign;
    tmp3_in8 = _in_a_var;
    tmp3_in9 = _in_a_varInits;
    {
      modelica_metatype _txt;
      modelica_metatype _a_instDimsInit;
      modelica_metatype _a_var_ty;
      modelica_metatype _a_var_name;
      modelica_integer _a_ix;
      modelica_string _a_dest;
      modelica_metatype _a_varAssign;
      modelica_metatype _a_var;
      modelica_metatype _a_varInits;
      modelica_metatype _i_instDims;
      modelica_integer _ret_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_initRecordMembers_rettype tmp6;
          Tpl_writeStr_rettype tmp7;
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          intString_rettype tmp10;
          Tpl_writeStr_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          modelica_metatype tmp14;
          SimCodeC_contextCref_rettype tmp15;
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_var_name = tmp3_in4;
          _a_ix = tmp3_in5;
          _a_dest = tmp3_in6;
          _a_varAssign = tmp3_in7;
          _a_var = tmp3_in8;
          _a_varInits = tmp3_in9;
          tmp6 = _SimCodeC_initRecordMembers(_a_varInits, _a_var);
          _a_varInits = tmp6.SimCodeC_initRecordMembers_rettype_1;
          tmp7 = _Tpl_writeStr(_a_varAssign, _a_dest);
          _a_varAssign = tmp7.Tpl_writeStr_rettype_1;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".targ"));
          tmp9 = _Tpl_writeTok(_a_varAssign, tmp8);
          _a_varAssign = tmp9.Tpl_writeTok_rettype_1;
          tmp10 = intString((modelica_integer)_a_ix);
          tmp11 = _Tpl_writeStr(_a_varAssign, tmp10);
          _a_varAssign = tmp11.Tpl_writeStr_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp13 = _Tpl_writeTok(_a_varAssign, tmp12);
          _a_varAssign = tmp13.Tpl_writeTok_rettype_1;
          tmp14 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp15 = _SimCodeC_contextCref(_a_varAssign, _a_var_name, tmp14);
          _a_varAssign = tmp15.SimCodeC_contextCref_rettype_1;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp17 = _Tpl_writeTok(_a_varAssign, tmp16);
          _a_varAssign = tmp17.Tpl_writeTok_rettype_1;
          tmp18 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp19 = _Tpl_writeTok(_a_varAssign, tmp18);
          _a_varAssign = tmp19.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varAssign;
          tmp2_targ3 = _a_varInits;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          SimCodeC_expTypeShort_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          Tpl_writeStr_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          intString_rettype tmp28;
          Tpl_writeStr_rettype tmp29;
          modelica_metatype tmp30;
          Tpl_writeTok_rettype tmp31;
          listLength_rettype tmp32;
          intString_rettype tmp33;
          Tpl_writeStr_rettype tmp34;
          modelica_metatype tmp35;
          Tpl_writeTok_rettype tmp36;
          Tpl_writeText_rettype tmp37;
          modelica_metatype tmp38;
          Tpl_writeTok_rettype tmp39;
          modelica_metatype tmp40;
          Tpl_writeTok_rettype tmp41;
          modelica_metatype tmp42;
          Tpl_writeTok_rettype tmp43;
          SimCodeC_expTypeShort_rettype tmp44;
          modelica_metatype tmp45;
          Tpl_writeTok_rettype tmp46;
          modelica_metatype tmp47;
          SimCodeC_contextCref_rettype tmp48;
          modelica_metatype tmp49;
          Tpl_writeTok_rettype tmp50;
          Tpl_writeStr_rettype tmp51;
          modelica_metatype tmp52;
          Tpl_writeTok_rettype tmp53;
          intString_rettype tmp54;
          Tpl_writeStr_rettype tmp55;
          modelica_metatype tmp56;
          Tpl_writeTok_rettype tmp57;
          modelica_metatype tmp58;
          Tpl_writeTok_rettype tmp59;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_instDims = tmp3_in1;
          _a_instDimsInit = tmp3_in2;
          _a_var_ty = tmp3_in3;
          _a_var_name = tmp3_in4;
          _a_ix = tmp3_in5;
          _a_dest = tmp3_in6;
          _a_varAssign = tmp3_in7;
          _a_varInits = tmp3_in9;
          tmp20 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("alloc_"));
          tmp21 = _Tpl_writeTok(_a_varInits, tmp20);
          _a_varInits = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = _SimCodeC_expTypeShort(_a_varInits, _a_var_ty);
          _a_varInits = tmp22.SimCodeC_expTypeShort_rettype_1;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_array(&"));
          tmp24 = _Tpl_writeTok(_a_varInits, tmp23);
          _a_varInits = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = _Tpl_writeStr(_a_varInits, _a_dest);
          _a_varInits = tmp25.Tpl_writeStr_rettype_1;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".targ"));
          tmp27 = _Tpl_writeTok(_a_varInits, tmp26);
          _a_varInits = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = intString((modelica_integer)_a_ix);
          tmp29 = _Tpl_writeStr(_a_varInits, tmp28);
          _a_varInits = tmp29.Tpl_writeStr_rettype_1;
          tmp30 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp31 = _Tpl_writeTok(_a_varInits, tmp30);
          _a_varInits = tmp31.Tpl_writeTok_rettype_1;
          tmp32 = listLength(_i_instDims);
          _ret_0 = tmp32;
          tmp33 = intString((modelica_integer)_ret_0);
          tmp34 = _Tpl_writeStr(_a_varInits, tmp33);
          _a_varInits = tmp34.Tpl_writeStr_rettype_1;
          tmp35 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp36 = _Tpl_writeTok(_a_varInits, tmp35);
          _a_varInits = tmp36.Tpl_writeTok_rettype_1;
          tmp37 = _Tpl_writeText(_a_varInits, _a_instDimsInit);
          _a_varInits = tmp37.Tpl_writeText_rettype_1;
          tmp38 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp39 = _Tpl_writeTok(_a_varInits, tmp38);
          _a_varInits = tmp39.Tpl_writeTok_rettype_1;
          tmp40 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp41 = _Tpl_writeTok(_a_varInits, tmp40);
          _a_varInits = tmp41.Tpl_writeTok_rettype_1;
          tmp42 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("copy_"));
          tmp43 = _Tpl_writeTok(_a_varAssign, tmp42);
          _a_varAssign = tmp43.Tpl_writeTok_rettype_1;
          tmp44 = _SimCodeC_expTypeShort(_a_varAssign, _a_var_ty);
          _a_varAssign = tmp44.SimCodeC_expTypeShort_rettype_1;
          tmp45 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_array_data(&"));
          tmp46 = _Tpl_writeTok(_a_varAssign, tmp45);
          _a_varAssign = tmp46.Tpl_writeTok_rettype_1;
          tmp47 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp48 = _SimCodeC_contextCref(_a_varAssign, _a_var_name, tmp47);
          _a_varAssign = tmp48.SimCodeC_contextCref_rettype_1;
          tmp49 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", &"));
          tmp50 = _Tpl_writeTok(_a_varAssign, tmp49);
          _a_varAssign = tmp50.Tpl_writeTok_rettype_1;
          tmp51 = _Tpl_writeStr(_a_varAssign, _a_dest);
          _a_varAssign = tmp51.Tpl_writeStr_rettype_1;
          tmp52 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".targ"));
          tmp53 = _Tpl_writeTok(_a_varAssign, tmp52);
          _a_varAssign = tmp53.Tpl_writeTok_rettype_1;
          tmp54 = intString((modelica_integer)_a_ix);
          tmp55 = _Tpl_writeStr(_a_varAssign, tmp54);
          _a_varAssign = tmp55.Tpl_writeStr_rettype_1;
          tmp56 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp57 = _Tpl_writeTok(_a_varAssign, tmp56);
          _a_varAssign = tmp57.Tpl_writeTok_rettype_1;
          tmp58 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp59 = _Tpl_writeTok(_a_varAssign, tmp58);
          _a_varAssign = tmp59.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varAssign;
          tmp2_targ3 = _a_varInits;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varAssign = tmp2_targ2;
  _out_a_varInits = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varAssign;
  tmp1.targ3 = _out_a_varInits;
  return tmp1;
}


SimCodeC_fun__439_rettypeboxed boxptr_SimCodeC_fun__439(modelica_metatype _in_txt, modelica_metatype _in_a_instDims, modelica_metatype _in_a_instDimsInit, modelica_metatype _in_a_var_ty, modelica_metatype _in_a_var_name, modelica_metatype _in_a_ix, modelica_metatype _in_a_dest, modelica_metatype _in_a_varAssign, modelica_metatype _in_a_var, modelica_metatype _in_a_varInits)
{
  SimCodeC_fun__439_rettypeboxed tmp1;
  SimCodeC_fun__439_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_integer(_in_a_ix);
  tmp4 = mmc_unbox_string(_in_a_dest);
  tmp2 = _SimCodeC_fun__439(_in_txt, _in_a_instDims, _in_a_instDimsInit, _in_a_var_ty, _in_a_var_name, tmp3, tmp4, _in_a_varAssign, _in_a_var, _in_a_varInits);
  tmp1.SimCodeC_fun__439_rettypeboxed_1 = tmp2.SimCodeC_fun__439_rettype_1;
  tmp1.SimCodeC_fun__439_rettypeboxed_2 = tmp2.SimCodeC_fun__439_rettype_2;
  tmp1.SimCodeC_fun__439_rettypeboxed_3 = tmp2.SimCodeC_fun__439_rettype_3;
  return tmp1;
}
SimCodeC_initRecordMembers_rettype _SimCodeC_initRecordMembers(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_initRecordMembers_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    {
      modelica_metatype _txt;
      modelica_metatype _i_ty_varLst;
      modelica_metatype _i_name;
      modelica_metatype _l_varName;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          SimCodeC_contextCref_rettype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          Tpl_pushIter_rettype tmp23;
          SimCodeC_lm__441_rettype tmp24;
          Tpl_popIter_rettype tmp25;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          if (mmc__uniontype__metarecord__typedef__equal(tmp7,5,3) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp7), 4));
          if (mmc__uniontype__metarecord__typedef__equal(tmp10,3,1) == 0) MMC_THROW();
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp10), 2));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp6;
          _i_ty_varLst = tmp9;
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_nil();
          tmp16 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp14, tmp15);
          tmp17 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp18 = _SimCodeC_contextCref(tmp16, _i_name, tmp17);
          _l_varName = tmp18.SimCodeC_contextCref_rettype_1;
          tmp19 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp22 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp19), mmc_mk_integer(0), mmc_mk_integer(0), tmp20, mmc_mk_integer(0), tmp21);
          tmp23 = _Tpl_pushIter(_txt, tmp22);
          _txt = tmp23.Tpl_pushIter_rettype_1;
          tmp24 = _SimCodeC_lm__441(_txt, _i_ty_varLst, _l_varName);
          _txt = tmp24.targ1;
          _l_varName = tmp24.targ2;
          tmp25 = _Tpl_popIter(_txt);
          _txt = tmp25.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_initRecordMembers_rettypeboxed boxptr_SimCodeC_initRecordMembers(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_initRecordMembers_rettypeboxed tmp1;
  SimCodeC_initRecordMembers_rettype tmp2;
  tmp2 = _SimCodeC_initRecordMembers(_in_txt, _in_a_var);
  tmp1.SimCodeC_initRecordMembers_rettypeboxed_1 = tmp2.SimCodeC_initRecordMembers_rettype_1;
  return tmp1;
}
SimCodeC_lm__441_rettype _SimCodeC_lm__441(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varName)
{
  SimCodeC_lm__441_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varName;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varName;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varName;
      modelica_metatype _i_v;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varName = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varName;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_recordMemberInit_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__441_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_v = tmp6;
          _rest = tmp7;
          _a_varName = tmp3_in2;
          tmp8 = _SimCodeC_recordMemberInit(_txt, _i_v, _a_varName);
          _txt = tmp8.targ1;
          _a_varName = tmp8.targ2;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__441(_txt, _rest, _a_varName);
          _txt = tmp10.targ1;
          _a_varName = tmp10.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varName;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__441_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varName = tmp3_in2;
          tmp13 = _SimCodeC_lm__441(_txt, _rest, _a_varName);
          _txt = tmp13.targ1;
          _a_varName = tmp13.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varName;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varName = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varName;
  return tmp1;
}


SimCodeC_lm__441_rettypeboxed boxptr_SimCodeC_lm__441(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varName)
{
  SimCodeC_lm__441_rettypeboxed tmp1;
  SimCodeC_lm__441_rettype tmp2;
  tmp2 = _SimCodeC_lm__441(_in_txt, _in_items, _in_a_varName);
  tmp1.SimCodeC_lm__441_rettypeboxed_1 = tmp2.SimCodeC_lm__441_rettype_1;
  tmp1.SimCodeC_lm__441_rettypeboxed_2 = tmp2.SimCodeC_lm__441_rettype_2;
  return tmp1;
}
SimCodeC_recordMemberInit_rettype _SimCodeC_recordMemberInit(modelica_metatype _txt, modelica_metatype _a_v, modelica_metatype _a_varName)
{
  SimCodeC_recordMemberInit_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varName;
  SimCodeC_fun__444_rettype tmp2;


  tmp2 = _SimCodeC_fun__444(_txt, _a_v, _a_varName);
  _out_txt = tmp2.SimCodeC_fun__444_rettype_1;
  _out_a_varName = _a_varName;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varName;
  return tmp1;
}


SimCodeC_recordMemberInit_rettypeboxed boxptr_SimCodeC_recordMemberInit(modelica_metatype _txt, modelica_metatype _a_v, modelica_metatype _a_varName)
{
  SimCodeC_recordMemberInit_rettypeboxed tmp1;
  SimCodeC_recordMemberInit_rettype tmp2;
  tmp2 = _SimCodeC_recordMemberInit(_txt, _a_v, _a_varName);
  tmp1.SimCodeC_recordMemberInit_rettypeboxed_1 = tmp2.SimCodeC_recordMemberInit_rettype_1;
  tmp1.SimCodeC_recordMemberInit_rettypeboxed_2 = tmp2.SimCodeC_recordMemberInit_rettype_2;
  return tmp1;
}
SimCodeC_fun__444_rettype _SimCodeC_fun__444(modelica_metatype _in_txt, modelica_metatype _in_a_v, modelica_metatype _in_a_varName)
{
  SimCodeC_fun__444_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_v;
    tmp3_in2 = _in_a_varName;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varName;
      modelica_string _i_name;
      modelica_metatype _i_tp_arrayDimensions;
      modelica_metatype _i_tp;
      modelica_integer _ret_2;
      modelica_metatype _l_dims;
      modelica_metatype _l_arrayType;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_string tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_expType_rettype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          Tpl_pushIter_rettype tmp22;
          SimCodeC_lm__443_rettype tmp23;
          Tpl_popIter_rettype tmp24;
          modelica_metatype tmp25;
          Tpl_writeTok_rettype tmp26;
          Tpl_writeText_rettype tmp27;
          modelica_metatype tmp28;
          Tpl_writeTok_rettype tmp29;
          Tpl_writeText_rettype tmp30;
          modelica_metatype tmp31;
          Tpl_writeTok_rettype tmp32;
          Tpl_writeStr_rettype tmp33;
          modelica_metatype tmp34;
          Tpl_writeTok_rettype tmp35;
          listLength_rettype tmp36;
          intString_rettype tmp37;
          Tpl_writeStr_rettype tmp38;
          modelica_metatype tmp39;
          Tpl_writeTok_rettype tmp40;
          Tpl_writeText_rettype tmp41;
          modelica_metatype tmp42;
          Tpl_writeTok_rettype tmp43;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = mmc_unbox_string(tmp6);
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          if (mmc__uniontype__metarecord__typedef__equal(tmp8,7,2) == 0) MMC_THROW();
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp8), 2));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp8), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp7;
          _i_tp = tmp8;
          _i_tp_arrayDimensions = tmp10;
          _a_varName = tmp3_in2;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          tmp14 = _SimCodeC_expType(tmp13, _i_tp, (1));
          _l_arrayType = tmp14.SimCodeC_expType_rettype_1;
          tmp15 = mmc_mk_nil();
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp15, tmp16);
          tmp18 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp19 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp18), mmc_mk_integer(0), mmc_mk_integer(0), tmp19, mmc_mk_integer(0), tmp20);
          tmp22 = _Tpl_pushIter(tmp17, tmp21);
          _l_dims = tmp22.Tpl_pushIter_rettype_1;
          tmp23 = _SimCodeC_lm__443(_l_dims, _i_tp_arrayDimensions);
          _l_dims = tmp23.SimCodeC_lm__443_rettype_1;
          tmp24 = _Tpl_popIter(_l_dims);
          _l_dims = tmp24.Tpl_popIter_rettype_1;
          tmp25 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("alloc_"));
          tmp26 = _Tpl_writeTok(_txt, tmp25);
          _txt = tmp26.Tpl_writeTok_rettype_1;
          tmp27 = _Tpl_writeText(_txt, _l_arrayType);
          _txt = tmp27.Tpl_writeText_rettype_1;
          tmp28 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(&"));
          tmp29 = _Tpl_writeTok(_txt, tmp28);
          _txt = tmp29.Tpl_writeTok_rettype_1;
          tmp30 = _Tpl_writeText(_txt, _a_varName);
          _txt = tmp30.Tpl_writeText_rettype_1;
          tmp31 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp32 = _Tpl_writeTok(_txt, tmp31);
          _txt = tmp32.Tpl_writeTok_rettype_1;
          tmp33 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp33.Tpl_writeStr_rettype_1;
          tmp34 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp35 = _Tpl_writeTok(_txt, tmp34);
          _txt = tmp35.Tpl_writeTok_rettype_1;
          tmp36 = listLength(_i_tp_arrayDimensions);
          _ret_2 = tmp36;
          tmp37 = intString((modelica_integer)_ret_2);
          tmp38 = _Tpl_writeStr(_txt, tmp37);
          _txt = tmp38.Tpl_writeStr_rettype_1;
          tmp39 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp40 = _Tpl_writeTok(_txt, tmp39);
          _txt = tmp40.Tpl_writeTok_rettype_1;
          tmp41 = _Tpl_writeText(_txt, _l_dims);
          _txt = tmp41.Tpl_writeText_rettype_1;
          tmp42 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp43 = _Tpl_writeTok(_txt, tmp42);
          _txt = tmp43.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__444_rettypeboxed boxptr_SimCodeC_fun__444(modelica_metatype _in_txt, modelica_metatype _in_a_v, modelica_metatype _in_a_varName)
{
  SimCodeC_fun__444_rettypeboxed tmp1;
  SimCodeC_fun__444_rettype tmp2;
  tmp2 = _SimCodeC_fun__444(_in_txt, _in_a_v, _in_a_varName);
  tmp1.SimCodeC_fun__444_rettypeboxed_1 = tmp2.SimCodeC_fun__444_rettype_1;
  return tmp1;
}
SimCodeC_lm__443_rettype _SimCodeC_lm__443(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__443_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_dim;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_dimension_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__443_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_dim = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_dimension(_txt, _i_dim);
          _txt = tmp8.SimCodeC_dimension_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__443(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__443_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__443_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__443(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__443_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__443_rettypeboxed boxptr_SimCodeC_lm__443(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__443_rettypeboxed tmp1;
  SimCodeC_lm__443_rettype tmp2;
  tmp2 = _SimCodeC_lm__443(_in_txt, _in_items);
  tmp1.SimCodeC_lm__443_rettypeboxed_1 = tmp2.SimCodeC_lm__443_rettype_1;
  return tmp1;
}
SimCodeC_lm__438_rettype _SimCodeC_lm__438(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varInits)
{
  SimCodeC_lm__438_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_varInits;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_varInits;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_varInits;
      modelica_metatype _i_exp;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_varInits = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varInits;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          SimCodeC_daeExp_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__438_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_varInits = tmp3_in3;
          tmp8 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp9 = _SimCodeC_daeExp(_txt, _i_exp, tmp8, _a_varInits, _a_varDecls);
          _txt = tmp9.targ1;
          _a_varInits = tmp9.targ2;
          _a_varDecls = tmp9.targ3;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__438(_txt, _rest, _a_varDecls, _a_varInits);
          _txt = tmp11.targ1;
          _a_varDecls = tmp11.targ2;
          _a_varInits = tmp11.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varInits;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__438_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          _a_varDecls = tmp3_in2;
          _a_varInits = tmp3_in3;
          tmp14 = _SimCodeC_lm__438(_txt, _rest, _a_varDecls, _a_varInits);
          _txt = tmp14.targ1;
          _a_varDecls = tmp14.targ2;
          _a_varInits = tmp14.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_varInits;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_varInits = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_varInits;
  return tmp1;
}


SimCodeC_lm__438_rettypeboxed boxptr_SimCodeC_lm__438(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varInits)
{
  SimCodeC_lm__438_rettypeboxed tmp1;
  SimCodeC_lm__438_rettype tmp2;
  tmp2 = _SimCodeC_lm__438(_in_txt, _in_items, _in_a_varDecls, _in_a_varInits);
  tmp1.SimCodeC_lm__438_rettypeboxed_1 = tmp2.SimCodeC_lm__438_rettype_1;
  tmp1.SimCodeC_lm__438_rettypeboxed_2 = tmp2.SimCodeC_lm__438_rettype_2;
  tmp1.SimCodeC_lm__438_rettypeboxed_3 = tmp2.SimCodeC_lm__438_rettype_3;
  return tmp1;
}
SimCodeC_fun__437_rettype _SimCodeC_fun__437(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_integer _in_a_ix, modelica_string _in_a_dest, modelica_metatype _in_a_varAssign, modelica_metatype _in_a_var_name, modelica_metatype _in_a_varCopy, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__437_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varAssign;
  modelica_metatype _out_a_varCopy;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;
  modelica_metatype tmp2_targ4;


  
  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_integer tmp3_in2;
    modelica_string tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    modelica_metatype tmp3_in6;
    modelica_metatype tmp3_in7;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = (modelica_integer)_in_a_ix;
    tmp3_in3 = _in_a_dest;
    tmp3_in4 = _in_a_varAssign;
    tmp3_in5 = _in_a_var_name;
    tmp3_in6 = _in_a_varCopy;
    tmp3_in7 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_integer _a_ix;
      modelica_string _a_dest;
      modelica_metatype _a_varAssign;
      modelica_metatype _a_var_name;
      modelica_metatype _a_varCopy;
      modelica_metatype _a_varDecls;
      modelica_metatype _l_strVar;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          SimCodeC_tempDecl_rettype tmp9;
          Tpl_writeText_rettype tmp10;
          modelica_metatype tmp11;
          Tpl_writeTok_rettype tmp12;
          modelica_metatype tmp13;
          SimCodeC_contextCref_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          Tpl_writeStr_rettype tmp19;
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          intString_rettype tmp22;
          Tpl_writeStr_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          Tpl_writeText_rettype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          Tpl_writeTok_rettype tmp29;
          Tpl_writeText_rettype tmp30;
          modelica_metatype tmp31;
          Tpl_writeTok_rettype tmp32;
          modelica_metatype tmp33;
          Tpl_writeTok_rettype tmp34;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_ix = tmp3_in2;
          _a_dest = tmp3_in3;
          _a_varAssign = tmp3_in4;
          _a_var_name = tmp3_in5;
          _a_varCopy = tmp3_in6;
          _a_varDecls = tmp3_in7;
          tmp6 = mmc_mk_nil();
          tmp7 = mmc_mk_nil();
          tmp8 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp6, tmp7);
          tmp9 = _SimCodeC_tempDecl(tmp8, "modelica_string_t", _a_varDecls);
          _l_strVar = tmp9.targ1;
          _a_varDecls = tmp9.targ2;
          tmp10 = _Tpl_writeText(_a_varCopy, _l_strVar);
          _a_varCopy = tmp10.Tpl_writeText_rettype_1;
          tmp11 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = strdup("));
          tmp12 = _Tpl_writeTok(_a_varCopy, tmp11);
          _a_varCopy = tmp12.Tpl_writeTok_rettype_1;
          tmp13 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp14 = _SimCodeC_contextCref(_a_varCopy, _a_var_name, tmp13);
          _a_varCopy = tmp14.SimCodeC_contextCref_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp16 = _Tpl_writeTok(_a_varCopy, tmp15);
          _a_varCopy = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp18 = _Tpl_writeTok(_a_varCopy, tmp17);
          _a_varCopy = tmp18.Tpl_writeTok_rettype_1;
          tmp19 = _Tpl_writeStr(_a_varAssign, _a_dest);
          _a_varAssign = tmp19.Tpl_writeStr_rettype_1;
          tmp20 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".targ"));
          tmp21 = _Tpl_writeTok(_a_varAssign, tmp20);
          _a_varAssign = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = intString((modelica_integer)_a_ix);
          tmp23 = _Tpl_writeStr(_a_varAssign, tmp22);
          _a_varAssign = tmp23.Tpl_writeStr_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = init_modelica_string("));
          tmp25 = _Tpl_writeTok(_a_varAssign, tmp24);
          _a_varAssign = tmp25.Tpl_writeTok_rettype_1;
          tmp26 = _Tpl_writeText(_a_varAssign, _l_strVar);
          _a_varAssign = tmp26.Tpl_writeText_rettype_1;
          tmp27 = mmc_mk_cons(mmc_mk_scon(");\n"), mmc_mk_cons(mmc_mk_scon("free("), mmc_mk_nil()));
          tmp28 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp27, mmc_mk_boolean((0)));
          tmp29 = _Tpl_writeTok(_a_varAssign, tmp28);
          _a_varAssign = tmp29.Tpl_writeTok_rettype_1;
          tmp30 = _Tpl_writeText(_a_varAssign, _l_strVar);
          _a_varAssign = tmp30.Tpl_writeText_rettype_1;
          tmp31 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp32 = _Tpl_writeTok(_a_varAssign, tmp31);
          _a_varAssign = tmp32.Tpl_writeTok_rettype_1;
          tmp33 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp34 = _Tpl_writeTok(_a_varAssign, tmp33);
          _a_varAssign = tmp34.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varAssign;
          tmp2_targ3 = _a_varCopy;
          tmp2_targ4 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeStr_rettype tmp35;
          modelica_metatype tmp36;
          Tpl_writeTok_rettype tmp37;
          intString_rettype tmp38;
          Tpl_writeStr_rettype tmp39;
          modelica_metatype tmp40;
          Tpl_writeTok_rettype tmp41;
          modelica_metatype tmp42;
          SimCodeC_contextCref_rettype tmp43;
          modelica_metatype tmp44;
          Tpl_writeTok_rettype tmp45;
          modelica_metatype tmp46;
          Tpl_writeTok_rettype tmp47;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_ix = tmp3_in2;
          _a_dest = tmp3_in3;
          _a_varAssign = tmp3_in4;
          _a_var_name = tmp3_in5;
          _a_varCopy = tmp3_in6;
          _a_varDecls = tmp3_in7;
          tmp35 = _Tpl_writeStr(_a_varAssign, _a_dest);
          _a_varAssign = tmp35.Tpl_writeStr_rettype_1;
          tmp36 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(".targ"));
          tmp37 = _Tpl_writeTok(_a_varAssign, tmp36);
          _a_varAssign = tmp37.Tpl_writeTok_rettype_1;
          tmp38 = intString((modelica_integer)_a_ix);
          tmp39 = _Tpl_writeStr(_a_varAssign, tmp38);
          _a_varAssign = tmp39.Tpl_writeStr_rettype_1;
          tmp40 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = "));
          tmp41 = _Tpl_writeTok(_a_varAssign, tmp40);
          _a_varAssign = tmp41.Tpl_writeTok_rettype_1;
          tmp42 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp43 = _SimCodeC_contextCref(_a_varAssign, _a_var_name, tmp42);
          _a_varAssign = tmp43.SimCodeC_contextCref_rettype_1;
          tmp44 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(";"));
          tmp45 = _Tpl_writeTok(_a_varAssign, tmp44);
          _a_varAssign = tmp45.Tpl_writeTok_rettype_1;
          tmp46 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp47 = _Tpl_writeTok(_a_varAssign, tmp46);
          _a_varAssign = tmp47.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varAssign;
          tmp2_targ3 = _a_varCopy;
          tmp2_targ4 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varAssign = tmp2_targ2;
  _out_a_varCopy = tmp2_targ3;
  _out_a_varDecls = tmp2_targ4;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varAssign;
  tmp1.targ3 = _out_a_varCopy;
  tmp1.targ4 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__437_rettypeboxed boxptr_SimCodeC_fun__437(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_ix, modelica_metatype _in_a_dest, modelica_metatype _in_a_varAssign, modelica_metatype _in_a_var_name, modelica_metatype _in_a_varCopy, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__437_rettypeboxed tmp1;
  SimCodeC_fun__437_rettype tmp2;
  modelica_integer tmp3;
  modelica_integer tmp4;
  modelica_string tmp5;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp4 = mmc_unbox_integer(_in_a_ix);
  tmp5 = mmc_unbox_string(_in_a_dest);
  tmp2 = _SimCodeC_fun__437(_in_txt, tmp3, tmp4, tmp5, _in_a_varAssign, _in_a_var_name, _in_a_varCopy, _in_a_varDecls);
  tmp1.SimCodeC_fun__437_rettypeboxed_1 = tmp2.SimCodeC_fun__437_rettype_1;
  tmp1.SimCodeC_fun__437_rettypeboxed_2 = tmp2.SimCodeC_fun__437_rettype_2;
  tmp1.SimCodeC_fun__437_rettypeboxed_3 = tmp2.SimCodeC_fun__437_rettype_3;
  tmp1.SimCodeC_fun__437_rettypeboxed_4 = tmp2.SimCodeC_fun__437_rettype_4;
  return tmp1;
}
SimCodeC_lm__350_rettype _SimCodeC_lm__350(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__350_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_stmt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funStatement_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__350_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_stmt = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          tmp8 = _SimCodeC_funStatement(_txt, _i_stmt, _a_varDecls);
          _txt = tmp8.targ1;
          _a_varDecls = tmp8.targ2;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__350(_txt, _rest, _a_varDecls);
          _txt = tmp10.targ1;
          _a_varDecls = tmp10.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__350_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varDecls = tmp3_in2;
          tmp13 = _SimCodeC_lm__350(_txt, _rest, _a_varDecls);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__350_rettypeboxed boxptr_SimCodeC_lm__350(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__350_rettypeboxed tmp1;
  SimCodeC_lm__350_rettype tmp2;
  tmp2 = _SimCodeC_lm__350(_in_txt, _in_items, _in_a_varDecls);
  tmp1.SimCodeC_lm__350_rettypeboxed_1 = tmp2.SimCodeC_lm__350_rettype_1;
  tmp1.SimCodeC_lm__350_rettypeboxed_2 = tmp2.SimCodeC_lm__350_rettype_2;
  return tmp1;
}
SimCodeC_funStatement_rettype _SimCodeC_funStatement(modelica_metatype _in_txt, modelica_metatype _in_a_stmt, modelica_metatype _in_a_varDecls)
{
  SimCodeC_funStatement_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_stmt;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_statementLst;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          Tpl_pushIter_rettype tmp11;
          SimCodeC_lm__490_rettype tmp12;
          Tpl_popIter_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,1) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_statementLst = tmp6;
          _a_varDecls = tmp3_in2;
          tmp7 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp8 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp9 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp10 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp7), mmc_mk_integer(0), mmc_mk_integer(0), tmp8, mmc_mk_integer(0), tmp9);
          tmp11 = _Tpl_pushIter(_txt, tmp10);
          _txt = tmp11.Tpl_pushIter_rettype_1;
          tmp12 = _SimCodeC_lm__490(_txt, _i_statementLst, _a_varDecls);
          _txt = tmp12.targ1;
          _a_varDecls = tmp12.targ2;
          tmp13 = _Tpl_popIter(_txt);
          _txt = tmp13.Tpl_popIter_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp14 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("NOT IMPLEMENTED FUN STATEMENT"));
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_funStatement_rettypeboxed boxptr_SimCodeC_funStatement(modelica_metatype _in_txt, modelica_metatype _in_a_stmt, modelica_metatype _in_a_varDecls)
{
  SimCodeC_funStatement_rettypeboxed tmp1;
  SimCodeC_funStatement_rettype tmp2;
  tmp2 = _SimCodeC_funStatement(_in_txt, _in_a_stmt, _in_a_varDecls);
  tmp1.SimCodeC_funStatement_rettypeboxed_1 = tmp2.SimCodeC_funStatement_rettype_1;
  tmp1.SimCodeC_funStatement_rettypeboxed_2 = tmp2.SimCodeC_funStatement_rettype_2;
  return tmp1;
}
SimCodeC_lm__490_rettype _SimCodeC_lm__490(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__490_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_stmt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          SimCodeC_algStatement_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__490_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_stmt = tmp6;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          tmp8 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp9 = _SimCodeC_algStatement(_txt, _i_stmt, tmp8, _a_varDecls);
          _txt = tmp9.targ1;
          _a_varDecls = tmp9.targ2;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__490(_txt, _rest, _a_varDecls);
          _txt = tmp11.targ1;
          _a_varDecls = tmp11.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__490_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          _a_varDecls = tmp3_in2;
          tmp14 = _SimCodeC_lm__490(_txt, _rest, _a_varDecls);
          _txt = tmp14.targ1;
          _a_varDecls = tmp14.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__490_rettypeboxed boxptr_SimCodeC_lm__490(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__490_rettypeboxed tmp1;
  SimCodeC_lm__490_rettype tmp2;
  tmp2 = _SimCodeC_lm__490(_in_txt, _in_items, _in_a_varDecls);
  tmp1.SimCodeC_lm__490_rettypeboxed_1 = tmp2.SimCodeC_lm__490_rettype_1;
  tmp1.SimCodeC_lm__490_rettypeboxed_2 = tmp2.SimCodeC_lm__490_rettype_2;
  return tmp1;
}
SimCodeC_lm__349_rettype _SimCodeC_lm__349(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varInits)
{
  SimCodeC_lm__349_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varInits;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varInits;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varInits;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varInits = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varInits;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_functionArg_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__349_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          _a_varInits = tmp3_in2;
          tmp8 = _SimCodeC_functionArg(_txt, _i_var, _a_varInits);
          _txt = tmp8.targ1;
          _a_varInits = tmp8.targ2;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__349(_txt, _rest, _a_varInits);
          _txt = tmp10.targ1;
          _a_varInits = tmp10.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varInits;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__349_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          _a_varInits = tmp3_in2;
          tmp13 = _SimCodeC_lm__349(_txt, _rest, _a_varInits);
          _txt = tmp13.targ1;
          _a_varInits = tmp13.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varInits;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varInits = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varInits;
  return tmp1;
}


SimCodeC_lm__349_rettypeboxed boxptr_SimCodeC_lm__349(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varInits)
{
  SimCodeC_lm__349_rettypeboxed tmp1;
  SimCodeC_lm__349_rettype tmp2;
  tmp2 = _SimCodeC_lm__349(_in_txt, _in_items, _in_a_varInits);
  tmp1.SimCodeC_lm__349_rettypeboxed_1 = tmp2.SimCodeC_lm__349_rettype_1;
  tmp1.SimCodeC_lm__349_rettypeboxed_2 = tmp2.SimCodeC_lm__349_rettype_2;
  return tmp1;
}
SimCodeC_lm__348_rettype _SimCodeC_lm__348(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varInits, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__348_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varInits;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varInits;
    tmp3_in3 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varInits;
      modelica_metatype _a_varDecls;
      modelica_integer _x_i1;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varInits = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varInits;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_getIteri__i0_rettype tmp8;
          SimCodeC_varInit_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__348_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          _a_varInits = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp8 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp8.Tpl_getIteri__i0_rettype_1;
          tmp9 = _SimCodeC_varInit(_txt, _i_var, "", (modelica_integer)_x_i1, _a_varDecls, _a_varInits);
          _txt = tmp9.targ1;
          _a_varDecls = tmp9.targ2;
          _a_varInits = tmp9.targ3;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__348(_txt, _rest, _a_varInits, _a_varDecls);
          _txt = tmp11.targ1;
          _a_varInits = tmp11.targ2;
          _a_varDecls = tmp11.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varInits;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__348_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          _a_varInits = tmp3_in2;
          _a_varDecls = tmp3_in3;
          tmp14 = _SimCodeC_lm__348(_txt, _rest, _a_varInits, _a_varDecls);
          _txt = tmp14.targ1;
          _a_varInits = tmp14.targ2;
          _a_varDecls = tmp14.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varInits;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varInits = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varInits;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_lm__348_rettypeboxed boxptr_SimCodeC_lm__348(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varInits, modelica_metatype _in_a_varDecls)
{
  SimCodeC_lm__348_rettypeboxed tmp1;
  SimCodeC_lm__348_rettype tmp2;
  tmp2 = _SimCodeC_lm__348(_in_txt, _in_items, _in_a_varInits, _in_a_varDecls);
  tmp1.SimCodeC_lm__348_rettypeboxed_1 = tmp2.SimCodeC_lm__348_rettype_1;
  tmp1.SimCodeC_lm__348_rettypeboxed_2 = tmp2.SimCodeC_lm__348_rettype_2;
  tmp1.SimCodeC_lm__348_rettypeboxed_3 = tmp2.SimCodeC_lm__348_rettype_3;
  return tmp1;
}
SimCodeC_fun__347_rettype _SimCodeC_fun__347(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__347_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_tempDecl_rettype tmp6;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp6 = _SimCodeC_tempDecl(_txt, "state", _a_varDecls);
          _txt = tmp6.targ1;
          _a_varDecls = tmp6.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__347_rettypeboxed boxptr_SimCodeC_fun__347(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__347_rettypeboxed tmp1;
  SimCodeC_fun__347_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__347(_in_txt, tmp3, _in_a_varDecls);
  tmp1.SimCodeC_fun__347_rettypeboxed_1 = tmp2.SimCodeC_fun__347_rettype_1;
  tmp1.SimCodeC_fun__347_rettypeboxed_2 = tmp2.SimCodeC_fun__347_rettype_2;
  return tmp1;
}
SimCodeC_fun__346_rettype _SimCodeC_fun__346(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__346_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_retType;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_retType;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_textString_rettype tmp6;
          SimCodeC_tempDecl_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_retType = tmp3_in3;
          tmp6 = _Tpl_textString(_a_retType);
          tmp7 = _SimCodeC_tempDecl(_txt, tmp6.Tpl_textString_rettype_1, _a_varDecls);
          _txt = tmp7.targ1;
          _a_varDecls = tmp7.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__346_rettypeboxed boxptr_SimCodeC_fun__346(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_retType)
{
  SimCodeC_fun__346_rettypeboxed tmp1;
  SimCodeC_fun__346_rettype tmp2;
  tmp2 = _SimCodeC_fun__346(_in_txt, _in_a_outVars, _in_a_varDecls, _in_a_retType);
  tmp1.SimCodeC_fun__346_rettypeboxed_1 = tmp2.SimCodeC_fun__346_rettype_1;
  tmp1.SimCodeC_fun__346_rettypeboxed_2 = tmp2.SimCodeC_fun__346_rettype_2;
  return tmp1;
}
SimCodeC_fun__345_rettype _SimCodeC_fun__345(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__345_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_metatype _a_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fname = tmp3_in2;
          tmp8 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__345_rettypeboxed boxptr_SimCodeC_fun__345(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__345_rettypeboxed tmp1;
  SimCodeC_fun__345_rettype tmp2;
  tmp2 = _SimCodeC_fun__345(_in_txt, _in_a_outVars, _in_a_fname);
  tmp1.SimCodeC_fun__345_rettypeboxed_1 = tmp2.SimCodeC_fun__345_rettype_1;
  return tmp1;
}
SimCodeC_functionsHeaderFile_rettype _SimCodeC_functionsHeaderFile(modelica_metatype _txt, modelica_string _a_filePrefix, modelica_metatype _a_mainFunction, modelica_metatype _a_functions, modelica_metatype _a_extraRecordDecls, modelica_metatype _a_includes)
{
  SimCodeC_functionsHeaderFile_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_string _ret_1;
  modelica_string _ret_0;
  modelica_metatype tmp2;
  Tpl_writeTok_rettype tmp3;
  System_stringReplace_rettype tmp4;
  Tpl_writeStr_rettype tmp5;
  modelica_metatype tmp6;
  modelica_metatype tmp7;
  Tpl_writeTok_rettype tmp8;
  System_stringReplace_rettype tmp9;
  Tpl_writeStr_rettype tmp10;
  modelica_metatype tmp11;
  Tpl_writeTok_rettype tmp12;
  SimCodeC_commonHeader_rettype tmp13;
  Tpl_softNewLine_rettype tmp14;
  modelica_metatype tmp15;
  modelica_metatype tmp16;
  Tpl_writeTok_rettype tmp17;
  modelica_metatype tmp18;
  modelica_metatype tmp19;
  modelica_metatype tmp20;
  modelica_metatype tmp21;
  Tpl_pushIter_rettype tmp22;
  SimCodeC_lm__255_rettype tmp23;
  Tpl_popIter_rettype tmp24;
  Tpl_softNewLine_rettype tmp25;
  SimCodeC_externalFunctionIncludes_rettype tmp26;
  Tpl_softNewLine_rettype tmp27;
  SimCodeC_functionHeader_rettype tmp28;
  Tpl_softNewLine_rettype tmp29;
  SimCodeC_functionHeaders_rettype tmp30;
  Tpl_softNewLine_rettype tmp31;
  modelica_metatype tmp32;
  modelica_metatype tmp33;
  Tpl_writeTok_rettype tmp34;
  modelica_metatype tmp35;
  Tpl_writeTok_rettype tmp36;


  tmp2 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#ifndef "));
  tmp3 = _Tpl_writeTok(_txt, tmp2);
  _out_txt = tmp3.Tpl_writeTok_rettype_1;
  tmp4 = _System_stringReplace(_a_filePrefix, ".", "_");
  _ret_0 = tmp4.System_stringReplace_rettype_1;
  tmp5 = _Tpl_writeStr(_out_txt, _ret_0);
  _out_txt = tmp5.Tpl_writeStr_rettype_1;
  tmp6 = mmc_mk_cons(mmc_mk_scon("__H\n"), mmc_mk_cons(mmc_mk_scon("#define "), mmc_mk_nil()));
  tmp7 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp6, mmc_mk_boolean((0)));
  tmp8 = _Tpl_writeTok(_out_txt, tmp7);
  _out_txt = tmp8.Tpl_writeTok_rettype_1;
  tmp9 = _System_stringReplace(_a_filePrefix, ".", "_");
  _ret_1 = tmp9.System_stringReplace_rettype_1;
  tmp10 = _Tpl_writeStr(_out_txt, _ret_1);
  _out_txt = tmp10.Tpl_writeStr_rettype_1;
  tmp11 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("__H\n"));
  tmp12 = _Tpl_writeTok(_out_txt, tmp11);
  _out_txt = tmp12.Tpl_writeTok_rettype_1;
  tmp13 = _SimCodeC_commonHeader(_out_txt);
  _out_txt = tmp13.SimCodeC_commonHeader_rettype_1;
  tmp14 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp14.Tpl_softNewLine_rettype_1;
  tmp15 = mmc_mk_cons(mmc_mk_scon("#ifdef __cplusplus\n"), mmc_mk_cons(mmc_mk_scon("extern \"C\" {\n"), mmc_mk_cons(mmc_mk_scon("#endif\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()))));
  tmp16 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp15, mmc_mk_boolean((1)));
  tmp17 = _Tpl_writeTok(_out_txt, tmp16);
  _out_txt = tmp17.Tpl_writeTok_rettype_1;
  tmp18 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp19 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp21 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp18), mmc_mk_integer(0), mmc_mk_integer(0), tmp19, mmc_mk_integer(0), tmp20);
  tmp22 = _Tpl_pushIter(_out_txt, tmp21);
  _out_txt = tmp22.Tpl_pushIter_rettype_1;
  tmp23 = _SimCodeC_lm__255(_out_txt, _a_extraRecordDecls);
  _out_txt = tmp23.SimCodeC_lm__255_rettype_1;
  tmp24 = _Tpl_popIter(_out_txt);
  _out_txt = tmp24.Tpl_popIter_rettype_1;
  tmp25 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp25.Tpl_softNewLine_rettype_1;
  tmp26 = _SimCodeC_externalFunctionIncludes(_out_txt, _a_includes);
  _out_txt = tmp26.SimCodeC_externalFunctionIncludes_rettype_1;
  tmp27 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp27.Tpl_softNewLine_rettype_1;
  tmp28 = _SimCodeC_functionHeader(_out_txt, _a_mainFunction, (1));
  _out_txt = tmp28.SimCodeC_functionHeader_rettype_1;
  tmp29 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp29.Tpl_softNewLine_rettype_1;
  tmp30 = _SimCodeC_functionHeaders(_out_txt, _a_functions);
  _out_txt = tmp30.SimCodeC_functionHeaders_rettype_1;
  tmp31 = _Tpl_softNewLine(_out_txt);
  _out_txt = tmp31.Tpl_softNewLine_rettype_1;
  tmp32 = mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_cons(mmc_mk_scon("#ifdef __cplusplus\n"), mmc_mk_cons(mmc_mk_scon("}\n"), mmc_mk_cons(mmc_mk_scon("#endif\n"), mmc_mk_cons(mmc_mk_scon("#endif\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()))))));
  tmp33 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp32, mmc_mk_boolean((1)));
  tmp34 = _Tpl_writeTok(_out_txt, tmp33);
  _out_txt = tmp34.Tpl_writeTok_rettype_1;
  tmp35 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp36 = _Tpl_writeTok(_out_txt, tmp35);
  _out_txt = tmp36.Tpl_writeTok_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionsHeaderFile_rettypeboxed boxptr_SimCodeC_functionsHeaderFile(modelica_metatype _txt, modelica_metatype _a_filePrefix, modelica_metatype _a_mainFunction, modelica_metatype _a_functions, modelica_metatype _a_extraRecordDecls, modelica_metatype _a_includes)
{
  SimCodeC_functionsHeaderFile_rettypeboxed tmp1;
  SimCodeC_functionsHeaderFile_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_a_filePrefix);
  tmp2 = _SimCodeC_functionsHeaderFile(_txt, tmp3, _a_mainFunction, _a_functions, _a_extraRecordDecls, _a_includes);
  tmp1.SimCodeC_functionsHeaderFile_rettypeboxed_1 = tmp2.SimCodeC_functionsHeaderFile_rettype_1;
  return tmp1;
}
SimCodeC_functionHeaders_rettype _SimCodeC_functionHeaders(modelica_metatype _txt, modelica_metatype _a_functions)
{
  SimCodeC_functionHeaders_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  modelica_metatype tmp5;
  Tpl_pushIter_rettype tmp6;
  SimCodeC_lm__292_rettype tmp7;
  Tpl_popIter_rettype tmp8;


  tmp2 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp3 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp4 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp5 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp2), mmc_mk_integer(0), mmc_mk_integer(0), tmp3, mmc_mk_integer(0), tmp4);
  tmp6 = _Tpl_pushIter(_txt, tmp5);
  _out_txt = tmp6.Tpl_pushIter_rettype_1;
  tmp7 = _SimCodeC_lm__292(_out_txt, _a_functions);
  _out_txt = tmp7.SimCodeC_lm__292_rettype_1;
  tmp8 = _Tpl_popIter(_out_txt);
  _out_txt = tmp8.Tpl_popIter_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionHeaders_rettypeboxed boxptr_SimCodeC_functionHeaders(modelica_metatype _txt, modelica_metatype _a_functions)
{
  SimCodeC_functionHeaders_rettypeboxed tmp1;
  SimCodeC_functionHeaders_rettype tmp2;
  tmp2 = _SimCodeC_functionHeaders(_txt, _a_functions);
  tmp1.SimCodeC_functionHeaders_rettypeboxed_1 = tmp2.SimCodeC_functionHeaders_rettype_1;
  return tmp1;
}
SimCodeC_lm__292_rettype _SimCodeC_lm__292(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__292_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_fn;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_functionHeader_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__292_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_functionHeader(_txt, _i_fn, (0));
          _txt = tmp8.SimCodeC_functionHeader_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__292(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__292_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__292_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__292(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__292_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__292_rettypeboxed boxptr_SimCodeC_lm__292(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__292_rettypeboxed tmp1;
  SimCodeC_lm__292_rettype tmp2;
  tmp2 = _SimCodeC_lm__292(_in_txt, _in_items);
  tmp1.SimCodeC_lm__292_rettypeboxed_1 = tmp2.SimCodeC_lm__292_rettype_1;
  return tmp1;
}
SimCodeC_functionHeader_rettype _SimCodeC_functionHeader(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_boolean _in_a_inFunc)
{
  SimCodeC_functionHeader_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_boolean tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    tmp3_in2 = _in_a_inFunc;
    {
      modelica_metatype _txt;
      modelica_boolean _a_inFunc;
      modelica_metatype _i_fn;
      modelica_metatype _i_funArgs;
      modelica_metatype _i_outVars;
      modelica_metatype _i_functionArguments;
      modelica_metatype _i_name;
      modelica_boolean _ret_9;
      modelica_metatype _l_boxedHeader;
      modelica_boolean _ret_7;
      modelica_metatype _l_funArgsBoxedStr;
      modelica_metatype _l_funArgsStr;
      modelica_metatype _l_fname;
      modelica_metatype _txt_3;
      modelica_metatype _txt_2;
      modelica_metatype _txt_1;
      modelica_metatype _txt_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          SimCodeC_underscorePath_rettype tmp15;
          Tpl_textString_rettype tmp16;
          SimCodeC_functionHeaderNormal_rettype tmp17;
          Tpl_softNewLine_rettype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          SimCodeC_underscorePath_rettype tmp22;
          Tpl_textString_rettype tmp23;
          SimCodeC_functionHeaderBoxed_rettype tmp24;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,6) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp6;
          _i_outVars = tmp8;
          _i_functionArguments = tmp9;
          _a_inFunc = tmp3_in2;
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp12, tmp13);
          tmp15 = _SimCodeC_underscorePath(tmp14, _i_name);
          _txt_0 = tmp15.SimCodeC_underscorePath_rettype_1;
          tmp16 = _Tpl_textString(_txt_0);
          tmp17 = _SimCodeC_functionHeaderNormal(_txt, tmp16.Tpl_textString_rettype_1, _i_functionArguments, _i_outVars, _a_inFunc);
          _txt = tmp17.SimCodeC_functionHeaderNormal_rettype_1;
          tmp18 = _Tpl_softNewLine(_txt);
          _txt = tmp18.Tpl_softNewLine_rettype_1;
          tmp19 = mmc_mk_nil();
          tmp20 = mmc_mk_nil();
          tmp21 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp19, tmp20);
          tmp22 = _SimCodeC_underscorePath(tmp21, _i_name);
          _txt_1 = tmp22.SimCodeC_underscorePath_rettype_1;
          tmp23 = _Tpl_textString(_txt_1);
          tmp24 = _SimCodeC_functionHeaderBoxed(_txt, tmp23.Tpl_textString_rettype_1, _i_functionArguments, _i_outVars);
          _txt = tmp24.SimCodeC_functionHeaderBoxed_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          SimCodeC_underscorePath_rettype tmp37;
          Tpl_textString_rettype tmp38;
          SimCodeC_functionHeaderNormal_rettype tmp39;
          Tpl_softNewLine_rettype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          SimCodeC_underscorePath_rettype tmp44;
          Tpl_textString_rettype tmp45;
          SimCodeC_functionHeaderBoxed_rettype tmp46;
          Tpl_softNewLine_rettype tmp47;
          modelica_metatype tmp48;
          Tpl_writeTok_rettype tmp49;
          SimCodeC_extFunDef_rettype tmp50;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp31 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_fn = tmp3_in1;
          _i_name = tmp25;
          _i_funArgs = tmp27;
          _i_outVars = tmp31;
          _a_inFunc = tmp3_in2;
          tmp34 = mmc_mk_nil();
          tmp35 = mmc_mk_nil();
          tmp36 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp34, tmp35);
          tmp37 = _SimCodeC_underscorePath(tmp36, _i_name);
          _txt_2 = tmp37.SimCodeC_underscorePath_rettype_1;
          tmp38 = _Tpl_textString(_txt_2);
          tmp39 = _SimCodeC_functionHeaderNormal(_txt, tmp38.Tpl_textString_rettype_1, _i_funArgs, _i_outVars, _a_inFunc);
          _txt = tmp39.SimCodeC_functionHeaderNormal_rettype_1;
          tmp40 = _Tpl_softNewLine(_txt);
          _txt = tmp40.Tpl_softNewLine_rettype_1;
          tmp41 = mmc_mk_nil();
          tmp42 = mmc_mk_nil();
          tmp43 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp41, tmp42);
          tmp44 = _SimCodeC_underscorePath(tmp43, _i_name);
          _txt_3 = tmp44.SimCodeC_underscorePath_rettype_1;
          tmp45 = _Tpl_textString(_txt_3);
          tmp46 = _SimCodeC_functionHeaderBoxed(_txt, tmp45.Tpl_textString_rettype_1, _i_funArgs, _i_outVars);
          _txt = tmp46.SimCodeC_functionHeaderBoxed_rettype_1;
          tmp47 = _Tpl_softNewLine(_txt);
          _txt = tmp47.Tpl_softNewLine_rettype_1;
          tmp48 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp49 = _Tpl_writeTok(_txt, tmp48);
          _txt = tmp49.Tpl_writeTok_rettype_1;
          tmp50 = _SimCodeC_extFunDef(_txt, _i_fn);
          _txt = tmp50.SimCodeC_extFunDef_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp51;
          modelica_metatype tmp52;
          modelica_metatype tmp53;
          modelica_metatype tmp54;
          modelica_metatype tmp55;
          SimCodeC_underscorePath_rettype tmp56;
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          modelica_metatype tmp59;
          modelica_metatype tmp60;
          modelica_metatype tmp61;
          modelica_metatype tmp62;
          modelica_metatype tmp63;
          Tpl_pushIter_rettype tmp64;
          SimCodeC_lm__294_rettype tmp65;
          Tpl_popIter_rettype tmp66;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp67;
          modelica_metatype tmp68;
          modelica_metatype tmp69;
          modelica_metatype tmp70;
          SimCodeC_fun__296_rettype tmp71;
          RTOpts_acceptMetaModelicaGrammar_rettype tmp72;
          modelica_metatype tmp73;
          modelica_metatype tmp74;
          modelica_metatype tmp75;
          SimCodeC_fun__297_rettype tmp76;
          modelica_metatype tmp77;
          Tpl_writeTok_rettype tmp78;
          Tpl_writeText_rettype tmp79;
          modelica_metatype tmp80;
          modelica_metatype tmp81;
          Tpl_writeTok_rettype tmp82;
          Tpl_writeText_rettype tmp83;
          modelica_metatype tmp84;
          Tpl_writeTok_rettype tmp85;
          modelica_metatype tmp86;
          Tpl_pushBlock_rettype tmp87;
          modelica_metatype tmp88;
          Tpl_writeTok_rettype tmp89;
          Tpl_writeText_rettype tmp90;
          modelica_metatype tmp91;
          Tpl_writeTok_rettype tmp92;
          Tpl_popBlock_rettype tmp93;
          modelica_metatype tmp94;
          Tpl_writeTok_rettype tmp95;
          Tpl_writeText_rettype tmp96;
          modelica_metatype tmp97;
          modelica_metatype tmp98;
          Tpl_writeTok_rettype tmp99;
          Tpl_writeText_rettype tmp100;
          modelica_metatype tmp101;
          Tpl_writeTok_rettype tmp102;
          Tpl_writeText_rettype tmp103;
          modelica_metatype tmp104;
          Tpl_writeTok_rettype tmp105;
          Tpl_writeText_rettype tmp106;
          modelica_metatype tmp107;
          modelica_metatype tmp108;
          Tpl_writeTok_rettype tmp109;
          Tpl_writeText_rettype tmp110;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,2) == 0) MMC_THROW();
          tmp51 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp52 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp51;
          _i_funArgs = tmp52;
          tmp53 = mmc_mk_nil();
          tmp54 = mmc_mk_nil();
          tmp55 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp53, tmp54);
          tmp56 = _SimCodeC_underscorePath(tmp55, _i_name);
          _l_fname = tmp56.SimCodeC_underscorePath_rettype_1;
          tmp57 = mmc_mk_nil();
          tmp58 = mmc_mk_nil();
          tmp59 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp57, tmp58);
          tmp60 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp61 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp62 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp63 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp60), mmc_mk_integer(0), mmc_mk_integer(0), tmp61, mmc_mk_integer(0), tmp62);
          tmp64 = _Tpl_pushIter(tmp59, tmp63);
          _l_funArgsStr = tmp64.Tpl_pushIter_rettype_1;
          tmp65 = _SimCodeC_lm__294(_l_funArgsStr, _i_funArgs);
          _l_funArgsStr = tmp65.SimCodeC_lm__294_rettype_1;
          tmp66 = _Tpl_popIter(_l_funArgsStr);
          _l_funArgsStr = tmp66.Tpl_popIter_rettype_1;
          tmp67 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_7 = tmp67.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp68 = mmc_mk_nil();
          tmp69 = mmc_mk_nil();
          tmp70 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp68, tmp69);
          tmp71 = _SimCodeC_fun__296(tmp70, _ret_7, _i_funArgs);
          _l_funArgsBoxedStr = tmp71.SimCodeC_fun__296_rettype_1;
          tmp72 = _RTOpts_acceptMetaModelicaGrammar();
          _ret_9 = tmp72.RTOpts_acceptMetaModelicaGrammar_rettype_1;
          tmp73 = mmc_mk_nil();
          tmp74 = mmc_mk_nil();
          tmp75 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp73, tmp74);
          tmp76 = _SimCodeC_fun__297(tmp75, _ret_9, _l_funArgsBoxedStr, _l_fname);
          _l_boxedHeader = tmp76.SimCodeC_fun__297_rettype_1;
          tmp77 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#define "));
          tmp78 = _Tpl_writeTok(_txt, tmp77);
          _txt = tmp78.Tpl_writeTok_rettype_1;
          tmp79 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp79.Tpl_writeText_rettype_1;
          tmp80 = mmc_mk_cons(mmc_mk_scon("_rettype_1 targ1\n"), mmc_mk_cons(mmc_mk_scon("typedef struct "), mmc_mk_nil()));
          tmp81 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp80, mmc_mk_boolean((0)));
          tmp82 = _Tpl_writeTok(_txt, tmp81);
          _txt = tmp82.Tpl_writeTok_rettype_1;
          tmp83 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp83.Tpl_writeText_rettype_1;
          tmp84 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("_rettype_s {\n"));
          tmp85 = _Tpl_writeTok(_txt, tmp84);
          _txt = tmp85.Tpl_writeTok_rettype_1;
          tmp86 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp87 = _Tpl_pushBlock(_txt, tmp86);
          _txt = tmp87.Tpl_pushBlock_rettype_1;
          tmp88 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("struct "));
          tmp89 = _Tpl_writeTok(_txt, tmp88);
          _txt = tmp89.Tpl_writeTok_rettype_1;
          tmp90 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp90.Tpl_writeText_rettype_1;
          tmp91 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(" targ1;\n"));
          tmp92 = _Tpl_writeTok(_txt, tmp91);
          _txt = tmp92.Tpl_writeTok_rettype_1;
          tmp93 = _Tpl_popBlock(_txt);
          _txt = tmp93.Tpl_popBlock_rettype_1;
          tmp94 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("} "));
          tmp95 = _Tpl_writeTok(_txt, tmp94);
          _txt = tmp95.Tpl_writeTok_rettype_1;
          tmp96 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp96.Tpl_writeText_rettype_1;
          tmp97 = mmc_mk_cons(mmc_mk_scon("_rettype;\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()));
          tmp98 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp97, mmc_mk_boolean((1)));
          tmp99 = _Tpl_writeTok(_txt, tmp98);
          _txt = tmp99.Tpl_writeTok_rettype_1;
          tmp100 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp100.Tpl_writeText_rettype_1;
          tmp101 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype _"));
          tmp102 = _Tpl_writeTok(_txt, tmp101);
          _txt = tmp102.Tpl_writeTok_rettype_1;
          tmp103 = _Tpl_writeText(_txt, _l_fname);
          _txt = tmp103.Tpl_writeText_rettype_1;
          tmp104 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp105 = _Tpl_writeTok(_txt, tmp104);
          _txt = tmp105.Tpl_writeTok_rettype_1;
          tmp106 = _Tpl_writeText(_txt, _l_funArgsStr);
          _txt = tmp106.Tpl_writeText_rettype_1;
          tmp107 = mmc_mk_cons(mmc_mk_scon(");\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()));
          tmp108 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp107, mmc_mk_boolean((1)));
          tmp109 = _Tpl_writeTok(_txt, tmp108);
          _txt = tmp109.Tpl_writeTok_rettype_1;
          tmp110 = _Tpl_writeText(_txt, _l_boxedHeader);
          _txt = tmp110.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionHeader_rettypeboxed boxptr_SimCodeC_functionHeader(modelica_metatype _in_txt, modelica_metatype _in_a_fn, modelica_metatype _in_a_inFunc)
{
  SimCodeC_functionHeader_rettypeboxed tmp1;
  SimCodeC_functionHeader_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_inFunc);
  tmp2 = _SimCodeC_functionHeader(_in_txt, _in_a_fn, tmp3);
  tmp1.SimCodeC_functionHeader_rettypeboxed_1 = tmp2.SimCodeC_functionHeader_rettype_1;
  return tmp1;
}
SimCodeC_fun__297_rettype _SimCodeC_fun__297(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_funArgsBoxedStr, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__297_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_funArgsBoxedStr;
    tmp3_in3 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_metatype _a_funArgsBoxedStr;
      modelica_metatype _a_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          Tpl_writeText_rettype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          Tpl_writeText_rettype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          Tpl_writeText_rettype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          Tpl_writeText_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          Tpl_writeText_rettype tmp26;
          modelica_metatype tmp27;
          Tpl_writeTok_rettype tmp28;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_funArgsBoxedStr = tmp3_in2;
          _a_fname = tmp3_in3;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#define "));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_cons(mmc_mk_scon("_rettypeboxed_1 targ1\n"), mmc_mk_cons(mmc_mk_scon("typedef struct "), mmc_mk_nil()));
          tmp10 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp9, mmc_mk_boolean((0)));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp12.Tpl_writeText_rettype_1;
          tmp13 = mmc_mk_cons(mmc_mk_scon("_rettypeboxed_s {\n"), mmc_mk_cons(mmc_mk_scon("  modelica_metatype targ1;\n"), mmc_mk_cons(mmc_mk_scon("} "), mmc_mk_nil())));
          tmp14 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp13, mmc_mk_boolean((0)));
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp16 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp16.Tpl_writeText_rettype_1;
          tmp17 = mmc_mk_cons(mmc_mk_scon("_rettypeboxed;\n"), mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_nil()));
          tmp18 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp17, mmc_mk_boolean((1)));
          tmp19 = _Tpl_writeTok(_txt, tmp18);
          _txt = tmp19.Tpl_writeTok_rettype_1;
          tmp20 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp20.Tpl_writeText_rettype_1;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettypeboxed boxptr_"));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _Tpl_writeText(_txt, _a_fname);
          _txt = tmp23.Tpl_writeText_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp25 = _Tpl_writeTok(_txt, tmp24);
          _txt = tmp25.Tpl_writeTok_rettype_1;
          tmp26 = _Tpl_writeText(_txt, _a_funArgsBoxedStr);
          _txt = tmp26.Tpl_writeText_rettype_1;
          tmp27 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp28 = _Tpl_writeTok(_txt, tmp27);
          _txt = tmp28.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__297_rettypeboxed boxptr_SimCodeC_fun__297(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_funArgsBoxedStr, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__297_rettypeboxed tmp1;
  SimCodeC_fun__297_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__297(_in_txt, tmp3, _in_a_funArgsBoxedStr, _in_a_fname);
  tmp1.SimCodeC_fun__297_rettypeboxed_1 = tmp2.SimCodeC_fun__297_rettype_1;
  return tmp1;
}
SimCodeC_fun__296_rettype _SimCodeC_fun__296(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_metatype _in_a_funArgs)
{
  SimCodeC_fun__296_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_funArgs;
    {
      modelica_metatype _txt;
      modelica_metatype _a_funArgs;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          Tpl_pushIter_rettype tmp10;
          SimCodeC_lm__295_rettype tmp11;
          Tpl_popIter_rettype tmp12;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_funArgs = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp7 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp8 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp9 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp6), mmc_mk_integer(0), mmc_mk_integer(0), tmp7, mmc_mk_integer(0), tmp8);
          tmp10 = _Tpl_pushIter(_txt, tmp9);
          _txt = tmp10.Tpl_pushIter_rettype_1;
          tmp11 = _SimCodeC_lm__295(_txt, _a_funArgs);
          _txt = tmp11.SimCodeC_lm__295_rettype_1;
          tmp12 = _Tpl_popIter(_txt);
          _txt = tmp12.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__296_rettypeboxed boxptr_SimCodeC_fun__296(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_funArgs)
{
  SimCodeC_fun__296_rettypeboxed tmp1;
  SimCodeC_fun__296_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp2 = _SimCodeC_fun__296(_in_txt, tmp3, _in_a_funArgs);
  tmp1.SimCodeC_fun__296_rettypeboxed_1 = tmp2.SimCodeC_fun__296_rettype_1;
  return tmp1;
}
SimCodeC_lm__295_rettype _SimCodeC_lm__295(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__295_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgBoxedDefinition_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__295_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgBoxedDefinition(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgBoxedDefinition_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__295(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__295_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__295_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__295(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__295_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__295_rettypeboxed boxptr_SimCodeC_lm__295(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__295_rettypeboxed tmp1;
  SimCodeC_lm__295_rettype tmp2;
  tmp2 = _SimCodeC_lm__295(_in_txt, _in_items);
  tmp1.SimCodeC_lm__295_rettypeboxed_1 = tmp2.SimCodeC_lm__295_rettype_1;
  return tmp1;
}
SimCodeC_lm__294_rettype _SimCodeC_lm__294(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__294_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_name;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_varType_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          SimCodeC_crefStr_rettype tmp15;
          Tpl_nextIter_rettype tmp16;
          SimCodeC_lm__294_rettype tmp17;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _i_name = tmp8;
          _rest = tmp7;
          tmp12 = _SimCodeC_varType(_txt, _i_var);
          _txt = tmp12.SimCodeC_varType_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = _SimCodeC_crefStr(_txt, _i_name);
          _txt = tmp15.SimCodeC_crefStr_rettype_1;
          tmp16 = _Tpl_nextIter(_txt);
          _txt = tmp16.Tpl_nextIter_rettype_1;
          tmp17 = _SimCodeC_lm__294(_txt, _rest);
          _txt = tmp17.SimCodeC_lm__294_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          SimCodeC_lm__294_rettype tmp20;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp18 = MMC_CAR(tmp3_in1);
          tmp19 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp19;
          tmp20 = _SimCodeC_lm__294(_txt, _rest);
          _txt = tmp20.SimCodeC_lm__294_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__294_rettypeboxed boxptr_SimCodeC_lm__294(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__294_rettypeboxed tmp1;
  SimCodeC_lm__294_rettype tmp2;
  tmp2 = _SimCodeC_lm__294(_in_txt, _in_items);
  tmp1.SimCodeC_lm__294_rettypeboxed_1 = tmp2.SimCodeC_lm__294_rettype_1;
  return tmp1;
}
SimCodeC_extFunDef_rettype _SimCodeC_extFunDef(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_extFunDef_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_fn;
    {
      modelica_metatype _txt;
      modelica_metatype _i_extReturn;
      modelica_metatype _i_extArgs;
      modelica_string _i_language;
      modelica_string _i_extName;
      modelica_metatype _l_fargsStr;
      modelica_metatype _l_fn__name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_string tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_string tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          SimCodeC_extFunctionName_rettype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          SimCodeC_extFunDefArgs_rettype tmp24;
          modelica_metatype tmp25;
          Tpl_writeTok_rettype tmp26;
          SimCodeC_extReturnType_rettype tmp27;
          modelica_metatype tmp28;
          Tpl_writeTok_rettype tmp29;
          Tpl_writeText_rettype tmp30;
          modelica_metatype tmp31;
          Tpl_writeTok_rettype tmp32;
          Tpl_writeText_rettype tmp33;
          modelica_metatype tmp34;
          Tpl_writeTok_rettype tmp35;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,9) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = mmc_unbox_string(tmp7);
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 8));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 9));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 10));
          tmp16 = mmc_unbox_string(tmp15);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extName = tmp8;
          _i_extArgs = tmp10;
          _i_extReturn = tmp11;
          _i_language = tmp16;
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_nil();
          tmp19 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp17, tmp18);
          tmp20 = _SimCodeC_extFunctionName(tmp19, _i_extName, _i_language);
          _l_fn__name = tmp20.SimCodeC_extFunctionName_rettype_1;
          tmp21 = mmc_mk_nil();
          tmp22 = mmc_mk_nil();
          tmp23 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp21, tmp22);
          tmp24 = _SimCodeC_extFunDefArgs(tmp23, _i_extArgs, _i_language);
          _l_fargsStr = tmp24.SimCodeC_extFunDefArgs_rettype_1;
          tmp25 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("extern "));
          tmp26 = _Tpl_writeTok(_txt, tmp25);
          _txt = tmp26.Tpl_writeTok_rettype_1;
          tmp27 = _SimCodeC_extReturnType(_txt, _i_extReturn);
          _txt = tmp27.SimCodeC_extReturnType_rettype_1;
          tmp28 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp29 = _Tpl_writeTok(_txt, tmp28);
          _txt = tmp29.Tpl_writeTok_rettype_1;
          tmp30 = _Tpl_writeText(_txt, _l_fn__name);
          _txt = tmp30.Tpl_writeText_rettype_1;
          tmp31 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp32 = _Tpl_writeTok(_txt, tmp31);
          _txt = tmp32.Tpl_writeTok_rettype_1;
          tmp33 = _Tpl_writeText(_txt, _l_fargsStr);
          _txt = tmp33.Tpl_writeText_rettype_1;
          tmp34 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp35 = _Tpl_writeTok(_txt, tmp34);
          _txt = tmp35.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extFunDef_rettypeboxed boxptr_SimCodeC_extFunDef(modelica_metatype _in_txt, modelica_metatype _in_a_fn)
{
  SimCodeC_extFunDef_rettypeboxed tmp1;
  SimCodeC_extFunDef_rettype tmp2;
  tmp2 = _SimCodeC_extFunDef(_in_txt, _in_a_fn);
  tmp1.SimCodeC_extFunDef_rettypeboxed_1 = tmp2.SimCodeC_extFunDef_rettype_1;
  return tmp1;
}
SimCodeC_extReturnType_rettype _SimCodeC_extReturnType(modelica_metatype _in_txt, modelica_metatype _in_a_extArg)
{
  SimCodeC_extReturnType_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extArg;
    {
      modelica_metatype _txt;
      modelica_metatype _i_type__;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_extType_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_type__ = tmp10;
          tmp11 = _SimCodeC_extType(_txt, _i_type__);
          _txt = tmp11.SimCodeC_extType_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void"));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extReturnType_rettypeboxed boxptr_SimCodeC_extReturnType(modelica_metatype _in_txt, modelica_metatype _in_a_extArg)
{
  SimCodeC_extReturnType_rettypeboxed tmp1;
  SimCodeC_extReturnType_rettype tmp2;
  tmp2 = _SimCodeC_extReturnType(_in_txt, _in_a_extArg);
  tmp1.SimCodeC_extReturnType_rettypeboxed_1 = tmp2.SimCodeC_extReturnType_rettype_1;
  return tmp1;
}
SimCodeC_extFunDefArgs_rettype _SimCodeC_extFunDefArgs(modelica_metatype _txt, modelica_metatype _a_args, modelica_string _a_language)
{
  SimCodeC_extFunDefArgs_rettype tmp1;
  modelica_metatype _out_txt;
  SimCodeC_fun__332_rettype tmp2;


  tmp2 = _SimCodeC_fun__332(_txt, _a_language, _a_args);
  _out_txt = tmp2.SimCodeC_fun__332_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extFunDefArgs_rettypeboxed boxptr_SimCodeC_extFunDefArgs(modelica_metatype _txt, modelica_metatype _a_args, modelica_metatype _a_language)
{
  SimCodeC_extFunDefArgs_rettypeboxed tmp1;
  SimCodeC_extFunDefArgs_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_a_language);
  tmp2 = _SimCodeC_extFunDefArgs(_txt, _a_args, tmp3);
  tmp1.SimCodeC_extFunDefArgs_rettypeboxed_1 = tmp2.SimCodeC_extFunDefArgs_rettype_1;
  return tmp1;
}
SimCodeC_fun__332_rettype _SimCodeC_fun__332(modelica_metatype _in_txt, modelica_string _in_a_language, modelica_metatype _in_a_args)
{
  SimCodeC_fun__332_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_string tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_language;
    tmp3_in2 = _in_a_args;
    {
      modelica_metatype _txt;
      modelica_metatype _a_args;
      modelica_string _i_language;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          Tpl_pushIter_rettype tmp10;
          SimCodeC_lm__330_rettype tmp11;
          Tpl_popIter_rettype tmp12;
          if (strcmp("C", tmp3_in1) != 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_args = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp7 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp8 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp9 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp6), mmc_mk_integer(0), mmc_mk_integer(0), tmp7, mmc_mk_integer(0), tmp8);
          tmp10 = _Tpl_pushIter(_txt, tmp9);
          _txt = tmp10.Tpl_pushIter_rettype_1;
          tmp11 = _SimCodeC_lm__330(_txt, _a_args);
          _txt = tmp11.SimCodeC_lm__330_rettype_1;
          tmp12 = _Tpl_popIter(_txt);
          _txt = tmp12.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          Tpl_pushIter_rettype tmp17;
          SimCodeC_lm__331_rettype tmp18;
          Tpl_popIter_rettype tmp19;
          if (strcmp("FORTRAN 77", tmp3_in1) != 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_args = tmp3_in2;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp14 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp15 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp16 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp13), mmc_mk_integer(0), mmc_mk_integer(0), tmp14, mmc_mk_integer(0), tmp15);
          tmp17 = _Tpl_pushIter(_txt, tmp16);
          _txt = tmp17.Tpl_pushIter_rettype_1;
          tmp18 = _SimCodeC_lm__331(_txt, _a_args);
          _txt = tmp18.SimCodeC_lm__331_rettype_1;
          tmp19 = _Tpl_popIter(_txt);
          _txt = tmp19.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          modelica_metatype tmp22;
          Tpl_writeTok_rettype tmp23;
          Tpl_writeStr_rettype tmp24;
          modelica_metatype tmp25;
          Tpl_writeTok_rettype tmp26;
          modelica_metatype tmp27;
          Tpl_writeTok_rettype tmp28;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_language = tmp3_in1;
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = _Tpl_writeTok(_txt, tmp20);
          _txt = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#error \"UNSUPPORTED_LANGUAGE: "));
          tmp23 = _Tpl_writeTok(_txt, tmp22);
          _txt = tmp23.Tpl_writeTok_rettype_1;
          tmp24 = _Tpl_writeStr(_txt, _i_language);
          _txt = tmp24.Tpl_writeStr_rettype_1;
          tmp25 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
          tmp26 = _Tpl_writeTok(_txt, tmp25);
          _txt = tmp26.Tpl_writeTok_rettype_1;
          tmp27 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp28 = _Tpl_writeTok(_txt, tmp27);
          _txt = tmp28.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__332_rettypeboxed boxptr_SimCodeC_fun__332(modelica_metatype _in_txt, modelica_metatype _in_a_language, modelica_metatype _in_a_args)
{
  SimCodeC_fun__332_rettypeboxed tmp1;
  SimCodeC_fun__332_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_language);
  tmp2 = _SimCodeC_fun__332(_in_txt, tmp3, _in_a_args);
  tmp1.SimCodeC_fun__332_rettypeboxed_1 = tmp2.SimCodeC_fun__332_rettype_1;
  return tmp1;
}
SimCodeC_lm__331_rettype _SimCodeC_lm__331(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__331_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extFunDefArgF77_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__331_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_extFunDefArgF77(_txt, _i_arg);
          _txt = tmp8.SimCodeC_extFunDefArgF77_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__331(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__331_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__331_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__331(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__331_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__331_rettypeboxed boxptr_SimCodeC_lm__331(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__331_rettypeboxed tmp1;
  SimCodeC_lm__331_rettype tmp2;
  tmp2 = _SimCodeC_lm__331(_in_txt, _in_items);
  tmp1.SimCodeC_lm__331_rettypeboxed_1 = tmp2.SimCodeC_lm__331_rettype_1;
  return tmp1;
}
SimCodeC_extFunDefArgF77_rettype _SimCodeC_extFunDefArgF77(modelica_metatype _in_txt, modelica_metatype _in_a_extArg)
{
  SimCodeC_extFunDefArgF77_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extArg;
    {
      modelica_metatype _txt;
      modelica_metatype _i_extArg;
      modelica_metatype _i_t;
      modelica_metatype _i_c;
      modelica_metatype _l_typeStr;
      modelica_metatype _l_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 5 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_integer tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          SimCodeC_contextCref_rettype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          Tpl_writeTok_rettype tmp21;
          SimCodeC_extType_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          Tpl_writeText_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          Tpl_writeText_rettype tmp28;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = mmc_unbox_integer(tmp7);
          if (true != tmp8) MMC_THROW();
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_t = tmp11;
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp12, tmp13);
          tmp15 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp16 = _SimCodeC_contextCref(tmp14, _i_c, tmp15);
          _l_name = tmp16.SimCodeC_contextCref_rettype_1;
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_nil();
          tmp19 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp17, tmp18);
          tmp20 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("const "));
          tmp21 = _Tpl_writeTok(tmp19, tmp20);
          _l_typeStr = tmp21.Tpl_writeTok_rettype_1;
          tmp22 = _SimCodeC_extType(_l_typeStr, _i_t);
          _l_typeStr = tmp22.SimCodeC_extType_rettype_1;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" *"));
          tmp24 = _Tpl_writeTok(_l_typeStr, tmp23);
          _l_typeStr = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = _Tpl_writeText(_txt, _l_typeStr);
          _txt = tmp25.Tpl_writeText_rettype_1;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = _Tpl_writeText(_txt, _l_name);
          _txt = tmp28.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          SimCodeC_extFunDefArg_rettype tmp34;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp31 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extArg = tmp3_in1;
          tmp34 = _SimCodeC_extFunDefArg(_txt, _i_extArg);
          _txt = tmp34.SimCodeC_extFunDefArg_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          SimCodeC_extFunDefArg_rettype tmp37;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,2) == 0) MMC_THROW();
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp36 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_extArg = tmp3_in1;
          tmp37 = _SimCodeC_extFunDefArg(_txt, _i_extArg);
          _txt = tmp37.SimCodeC_extFunDefArg_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          Tpl_writeTok_rettype tmp44;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,5) == 0) MMC_THROW();
          tmp38 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp39 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp40 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp41 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp42 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp43 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("int const *"));
          tmp44 = _Tpl_writeTok(_txt, tmp43);
          _txt = tmp44.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 4: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extFunDefArgF77_rettypeboxed boxptr_SimCodeC_extFunDefArgF77(modelica_metatype _in_txt, modelica_metatype _in_a_extArg)
{
  SimCodeC_extFunDefArgF77_rettypeboxed tmp1;
  SimCodeC_extFunDefArgF77_rettype tmp2;
  tmp2 = _SimCodeC_extFunDefArgF77(_in_txt, _in_a_extArg);
  tmp1.SimCodeC_extFunDefArgF77_rettypeboxed_1 = tmp2.SimCodeC_extFunDefArgF77_rettype_1;
  return tmp1;
}
SimCodeC_extFunDefArg_rettype _SimCodeC_extFunDefArg(modelica_metatype _in_txt, modelica_metatype _in_a_extArg)
{
  SimCodeC_extFunDefArg_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_extArg;
    {
      modelica_metatype _txt;
      modelica_metatype _i_exp;
      modelica_metatype _i_type__;
      modelica_boolean _i_ia;
      modelica_metatype _i_t;
      modelica_boolean _i_ii;
      modelica_metatype _i_c;
      modelica_metatype _l_eStr;
      modelica_metatype _l_typeStr;
      modelica_metatype _l_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_integer tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_integer tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          SimCodeC_contextCref_rettype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          SimCodeC_fun__338_rettype tmp21;
          Tpl_writeText_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          Tpl_writeText_rettype tmp25;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = mmc_unbox_integer(tmp7);
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp11 = mmc_unbox_integer(tmp10);
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp6;
          _i_ii = tmp8;
          _i_ia = tmp11;
          _i_t = tmp12;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          tmp16 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp17 = _SimCodeC_contextCref(tmp15, _i_c, tmp16);
          _l_name = tmp17.SimCodeC_contextCref_rettype_1;
          tmp18 = mmc_mk_nil();
          tmp19 = mmc_mk_nil();
          tmp20 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp18, tmp19);
          tmp21 = _SimCodeC_fun__338(tmp20, _i_ii, _i_ia, _i_t);
          _l_typeStr = tmp21.SimCodeC_fun__338_rettype_1;
          tmp22 = _Tpl_writeText(_txt, _l_typeStr);
          _txt = tmp22.Tpl_writeText_rettype_1;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp24 = _Tpl_writeTok(_txt, tmp23);
          _txt = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = _Tpl_writeText(_txt, _l_name);
          _txt = tmp25.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          SimCodeC_extType_rettype tmp31;
          Tpl_writeText_rettype tmp32;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,2) == 0) MMC_THROW();
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_type__ = tmp27;
          tmp28 = mmc_mk_nil();
          tmp29 = mmc_mk_nil();
          tmp30 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp28, tmp29);
          tmp31 = _SimCodeC_extType(tmp30, _i_type__);
          _l_typeStr = tmp31.SimCodeC_extType_rettype_1;
          tmp32 = _Tpl_writeText(_txt, _l_typeStr);
          _txt = tmp32.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          SimCodeC_contextCref_rettype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          SimCodeC_daeExpToString_rettype tmp46;
          modelica_metatype tmp47;
          Tpl_writeTok_rettype tmp48;
          Tpl_writeText_rettype tmp49;
          modelica_metatype tmp50;
          Tpl_writeTok_rettype tmp51;
          Tpl_writeText_rettype tmp52;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,5) == 0) MMC_THROW();
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp34 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp36 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp37 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c = tmp33;
          _i_exp = tmp37;
          tmp38 = mmc_mk_nil();
          tmp39 = mmc_mk_nil();
          tmp40 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp38, tmp39);
          tmp41 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp42 = _SimCodeC_contextCref(tmp40, _i_c, tmp41);
          _l_name = tmp42.SimCodeC_contextCref_rettype_1;
          tmp43 = mmc_mk_nil();
          tmp44 = mmc_mk_nil();
          tmp45 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp43, tmp44);
          tmp46 = _SimCodeC_daeExpToString(tmp45, _i_exp);
          _l_eStr = tmp46.SimCodeC_daeExpToString_rettype_1;
          tmp47 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("size_t "));
          tmp48 = _Tpl_writeTok(_txt, tmp47);
          _txt = tmp48.Tpl_writeTok_rettype_1;
          tmp49 = _Tpl_writeText(_txt, _l_name);
          _txt = tmp49.Tpl_writeText_rettype_1;
          tmp50 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp51 = _Tpl_writeTok(_txt, tmp50);
          _txt = tmp51.Tpl_writeTok_rettype_1;
          tmp52 = _Tpl_writeText(_txt, _l_eStr);
          _txt = tmp52.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extFunDefArg_rettypeboxed boxptr_SimCodeC_extFunDefArg(modelica_metatype _in_txt, modelica_metatype _in_a_extArg)
{
  SimCodeC_extFunDefArg_rettypeboxed tmp1;
  SimCodeC_extFunDefArg_rettype tmp2;
  tmp2 = _SimCodeC_extFunDefArg(_in_txt, _in_a_extArg);
  tmp1.SimCodeC_extFunDefArg_rettypeboxed_1 = tmp2.SimCodeC_extFunDefArg_rettype_1;
  return tmp1;
}
SimCodeC_daeExpToString_rettype _SimCodeC_daeExpToString(modelica_metatype _txt, modelica_metatype _a_exp)
{
  SimCodeC_daeExpToString_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _l_varDecls;
  modelica_metatype _l_preExp;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  modelica_metatype tmp5;
  modelica_metatype tmp6;
  modelica_metatype tmp7;
  modelica_metatype tmp8;
  SimCodeC_daeExp_rettype tmp9;


  tmp2 = mmc_mk_nil();
  tmp3 = mmc_mk_nil();
  tmp4 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp2, tmp3);
  _l_preExp = tmp4;
  tmp5 = mmc_mk_nil();
  tmp6 = mmc_mk_nil();
  tmp7 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp5, tmp6);
  _l_varDecls = tmp7;
  tmp8 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
  tmp9 = _SimCodeC_daeExp(_txt, _a_exp, tmp8, _l_preExp, _l_varDecls);
  _out_txt = tmp9.targ1;
  _l_preExp = tmp9.targ2;
  _l_varDecls = tmp9.targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_daeExpToString_rettypeboxed boxptr_SimCodeC_daeExpToString(modelica_metatype _txt, modelica_metatype _a_exp)
{
  SimCodeC_daeExpToString_rettypeboxed tmp1;
  SimCodeC_daeExpToString_rettype tmp2;
  tmp2 = _SimCodeC_daeExpToString(_txt, _a_exp);
  tmp1.SimCodeC_daeExpToString_rettypeboxed_1 = tmp2.SimCodeC_daeExpToString_rettype_1;
  return tmp1;
}
SimCodeC_fun__338_rettype _SimCodeC_fun__338(modelica_metatype _in_txt, modelica_boolean _in_a_ii, modelica_boolean _in_a_ia, modelica_metatype _in_a_t)
{
  SimCodeC_fun__338_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_boolean tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_ii;
    tmp3_in2 = _in_a_ia;
    tmp3_in3 = _in_a_t;
    {
      modelica_metatype _txt;
      modelica_boolean _a_ia;
      modelica_metatype _a_t;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_extType_rettype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_t = tmp3_in3;
          tmp6 = _SimCodeC_extType(_txt, _a_t);
          _txt = tmp6.SimCodeC_extType_rettype_1;
          tmp7 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("*"));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_fun__337_rettype tmp9;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_ia = tmp3_in2;
          _a_t = tmp3_in3;
          tmp9 = _SimCodeC_fun__337(_txt, _a_ia, _a_t);
          _txt = tmp9.SimCodeC_fun__337_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__338_rettypeboxed boxptr_SimCodeC_fun__338(modelica_metatype _in_txt, modelica_metatype _in_a_ii, modelica_metatype _in_a_ia, modelica_metatype _in_a_t)
{
  SimCodeC_fun__338_rettypeboxed tmp1;
  SimCodeC_fun__338_rettype tmp2;
  modelica_integer tmp3;
  modelica_integer tmp4;
  tmp3 = mmc_unbox_integer(_in_a_ii);
  tmp4 = mmc_unbox_integer(_in_a_ia);
  tmp2 = _SimCodeC_fun__338(_in_txt, tmp3, tmp4, _in_a_t);
  tmp1.SimCodeC_fun__338_rettypeboxed_1 = tmp2.SimCodeC_fun__338_rettype_1;
  return tmp1;
}
SimCodeC_fun__337_rettype _SimCodeC_fun__337(modelica_metatype _in_txt, modelica_boolean _in_a_ia, modelica_metatype _in_a_t)
{
  SimCodeC_fun__337_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_ia;
    tmp3_in2 = _in_a_t;
    {
      modelica_metatype _txt;
      modelica_metatype _a_t;
      modelica_string _str_1;
      modelica_metatype _txt_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_extType_rettype tmp6;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_t = tmp3_in2;
          tmp6 = _SimCodeC_extType(_txt, _a_t);
          _txt = tmp6.SimCodeC_extType_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          SimCodeC_extType_rettype tmp10;
          Tpl_textString_rettype tmp11;
          SimCodeC_fun__336_rettype tmp12;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_t = tmp3_in2;
          tmp7 = mmc_mk_nil();
          tmp8 = mmc_mk_nil();
          tmp9 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp7, tmp8);
          tmp10 = _SimCodeC_extType(tmp9, _a_t);
          _txt_0 = tmp10.SimCodeC_extType_rettype_1;
          tmp11 = _Tpl_textString(_txt_0);
          _str_1 = tmp11.Tpl_textString_rettype_1;
          tmp12 = _SimCodeC_fun__336(_txt, _str_1, _a_t);
          _txt = tmp12.SimCodeC_fun__336_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__337_rettypeboxed boxptr_SimCodeC_fun__337(modelica_metatype _in_txt, modelica_metatype _in_a_ia, modelica_metatype _in_a_t)
{
  SimCodeC_fun__337_rettypeboxed tmp1;
  SimCodeC_fun__337_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_ia);
  tmp2 = _SimCodeC_fun__337(_in_txt, tmp3, _in_a_t);
  tmp1.SimCodeC_fun__337_rettypeboxed_1 = tmp2.SimCodeC_fun__337_rettype_1;
  return tmp1;
}
SimCodeC_extType_rettype _SimCodeC_extType(modelica_metatype _in_txt, modelica_metatype _in_a_type)
{
  SimCodeC_extType_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_type;
    {
      modelica_metatype _txt;
      modelica_metatype _i_rname;
      modelica_metatype _i_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 11 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("int"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("double"));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("const char*"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("int"));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,4,3) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("int"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          SimCodeC_extType_rettype tmp21;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,7,2) == 0) MMC_THROW();
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_ty = tmp19;
          tmp21 = _SimCodeC_extType(_txt, _i_ty);
          _txt = tmp21.SimCodeC_extType_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 6: {
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp22 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp23 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          if (mmc__uniontype__metarecord__typedef__equal(tmp24,18,1) == 0) MMC_THROW();
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp24), 2));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void *"));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 7: {
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          SimCodeC_underscorePath_rettype tmp34;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          if (mmc__uniontype__metarecord__typedef__equal(tmp30,3,1) == 0) MMC_THROW();
          tmp31 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp30), 2));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_rname = tmp31;
          tmp32 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("struct "));
          tmp33 = _Tpl_writeTok(_txt, tmp32);
          _txt = tmp33.Tpl_writeTok_rettype_1;
          tmp34 = _SimCodeC_underscorePath(_txt, _i_rname);
          _txt = tmp34.SimCodeC_underscorePath_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 8: {
          modelica_metatype tmp35;
          Tpl_writeTok_rettype tmp36;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,13,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp35 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void*"));
          tmp36 = _Tpl_writeTok(_txt, tmp35);
          _txt = tmp36.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 9: {
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          Tpl_writeTok_rettype tmp39;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,14,1) == 0) MMC_THROW();
          tmp37 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp38 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("void*"));
          tmp39 = _Tpl_writeTok(_txt, tmp38);
          _txt = tmp39.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 10: {
          modelica_metatype tmp40;
          Tpl_writeTok_rettype tmp41;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp40 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("OTHER_EXT_TYPE"));
          tmp41 = _Tpl_writeTok(_txt, tmp40);
          _txt = tmp41.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extType_rettypeboxed boxptr_SimCodeC_extType(modelica_metatype _in_txt, modelica_metatype _in_a_type)
{
  SimCodeC_extType_rettypeboxed tmp1;
  SimCodeC_extType_rettype tmp2;
  tmp2 = _SimCodeC_extType(_in_txt, _in_a_type);
  tmp1.SimCodeC_extType_rettypeboxed_1 = tmp2.SimCodeC_extType_rettype_1;
  return tmp1;
}
SimCodeC_fun__336_rettype _SimCodeC_fun__336(modelica_metatype _in_txt, modelica_string _in_mArg, modelica_metatype _in_a_t)
{
  SimCodeC_fun__336_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_string tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_t;
    {
      modelica_metatype _txt;
      modelica_metatype _a_t;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (strcmp("const char*", tmp3_in1) != 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("const char* const *"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          SimCodeC_extType_rettype tmp10;
          modelica_metatype tmp11;
          Tpl_writeTok_rettype tmp12;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_t = tmp3_in2;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("const "));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp10 = _SimCodeC_extType(_txt, _a_t);
          _txt = tmp10.SimCodeC_extType_rettype_1;
          tmp11 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" *"));
          tmp12 = _Tpl_writeTok(_txt, tmp11);
          _txt = tmp12.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__336_rettypeboxed boxptr_SimCodeC_fun__336(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_t)
{
  SimCodeC_fun__336_rettypeboxed tmp1;
  SimCodeC_fun__336_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_mArg);
  tmp2 = _SimCodeC_fun__336(_in_txt, tmp3, _in_a_t);
  tmp1.SimCodeC_fun__336_rettypeboxed_1 = tmp2.SimCodeC_fun__336_rettype_1;
  return tmp1;
}
SimCodeC_lm__330_rettype _SimCodeC_lm__330(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__330_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_arg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_extFunDefArg_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__330_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arg = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_extFunDefArg(_txt, _i_arg);
          _txt = tmp8.SimCodeC_extFunDefArg_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__330(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__330_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__330_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__330(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__330_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__330_rettypeboxed boxptr_SimCodeC_lm__330(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__330_rettypeboxed tmp1;
  SimCodeC_lm__330_rettype tmp2;
  tmp2 = _SimCodeC_lm__330(_in_txt, _in_items);
  tmp1.SimCodeC_lm__330_rettypeboxed_1 = tmp2.SimCodeC_lm__330_rettype_1;
  return tmp1;
}
SimCodeC_extFunctionName_rettype _SimCodeC_extFunctionName(modelica_metatype _txt, modelica_string _a_name, modelica_string _a_language)
{
  SimCodeC_extFunctionName_rettype tmp1;
  modelica_metatype _out_txt;
  SimCodeC_fun__328_rettype tmp2;


  tmp2 = _SimCodeC_fun__328(_txt, _a_language, _a_name);
  _out_txt = tmp2.SimCodeC_fun__328_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_extFunctionName_rettypeboxed boxptr_SimCodeC_extFunctionName(modelica_metatype _txt, modelica_metatype _a_name, modelica_metatype _a_language)
{
  SimCodeC_extFunctionName_rettypeboxed tmp1;
  SimCodeC_extFunctionName_rettype tmp2;
  modelica_string tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_string(_a_name);
  tmp4 = mmc_unbox_string(_a_language);
  tmp2 = _SimCodeC_extFunctionName(_txt, tmp3, tmp4);
  tmp1.SimCodeC_extFunctionName_rettypeboxed_1 = tmp2.SimCodeC_extFunctionName_rettype_1;
  return tmp1;
}
SimCodeC_fun__328_rettype _SimCodeC_fun__328(modelica_metatype _in_txt, modelica_string _in_a_language, modelica_string _in_a_name)
{
  SimCodeC_fun__328_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_string tmp3_in1;
    modelica_string tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_language;
    tmp3_in2 = _in_a_name;
    {
      modelica_metatype _txt;
      modelica_string _a_name;
      modelica_string _i_language;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          Tpl_writeStr_rettype tmp6;
          if (strcmp("C", tmp3_in1) != 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_name = tmp3_in2;
          tmp6 = _Tpl_writeStr(_txt, _a_name);
          _txt = tmp6.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeStr_rettype tmp7;
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          if (strcmp("FORTRAN 77", tmp3_in1) != 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_name = tmp3_in2;
          tmp7 = _Tpl_writeStr(_txt, _a_name);
          _txt = tmp7.Tpl_writeStr_rettype_1;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          Tpl_writeStr_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_language = tmp3_in1;
          tmp10 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#error \"UNSUPPORTED_LANGUAGE: "));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp14 = _Tpl_writeStr(_txt, _i_language);
          _txt = tmp14.Tpl_writeStr_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
          tmp16 = _Tpl_writeTok(_txt, tmp15);
          _txt = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__328_rettypeboxed boxptr_SimCodeC_fun__328(modelica_metatype _in_txt, modelica_metatype _in_a_language, modelica_metatype _in_a_name)
{
  SimCodeC_fun__328_rettypeboxed tmp1;
  SimCodeC_fun__328_rettype tmp2;
  modelica_string tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_string(_in_a_language);
  tmp4 = mmc_unbox_string(_in_a_name);
  tmp2 = _SimCodeC_fun__328(_in_txt, tmp3, tmp4);
  tmp1.SimCodeC_fun__328_rettypeboxed_1 = tmp2.SimCodeC_fun__328_rettype_1;
  return tmp1;
}
SimCodeC_functionHeaderBoxed_rettype _SimCodeC_functionHeaderBoxed(modelica_metatype _txt, modelica_string _a_fname, modelica_metatype _a_fargs, modelica_metatype _a_outVars)
{
  SimCodeC_functionHeaderBoxed_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_boolean _ret_0;
  RTOpts_acceptMetaModelicaGrammar_rettype tmp2;
  SimCodeC_fun__307_rettype tmp3;


  tmp2 = _RTOpts_acceptMetaModelicaGrammar();
  _ret_0 = tmp2.RTOpts_acceptMetaModelicaGrammar_rettype_1;
  tmp3 = _SimCodeC_fun__307(_txt, _ret_0, _a_fname, _a_fargs, _a_outVars);
  _out_txt = tmp3.SimCodeC_fun__307_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionHeaderBoxed_rettypeboxed boxptr_SimCodeC_functionHeaderBoxed(modelica_metatype _txt, modelica_metatype _a_fname, modelica_metatype _a_fargs, modelica_metatype _a_outVars)
{
  SimCodeC_functionHeaderBoxed_rettypeboxed tmp1;
  SimCodeC_functionHeaderBoxed_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_a_fname);
  tmp2 = _SimCodeC_functionHeaderBoxed(_txt, tmp3, _a_fargs, _a_outVars);
  tmp1.SimCodeC_functionHeaderBoxed_rettypeboxed_1 = tmp2.SimCodeC_functionHeaderBoxed_rettype_1;
  return tmp1;
}
SimCodeC_fun__307_rettype _SimCodeC_fun__307(modelica_metatype _in_txt, modelica_boolean _in_mArg, modelica_string _in_a_fname, modelica_metatype _in_a_fargs, modelica_metatype _in_a_outVars)
{
  SimCodeC_fun__307_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_string tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_mArg;
    tmp3_in2 = _in_a_fname;
    tmp3_in3 = _in_a_fargs;
    tmp3_in4 = _in_a_outVars;
    {
      modelica_metatype _txt;
      modelica_string _a_fname;
      modelica_metatype _a_fargs;
      modelica_metatype _a_outVars;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_functionHeaderImpl_rettype tmp6;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fname = tmp3_in2;
          _a_fargs = tmp3_in3;
          _a_outVars = tmp3_in4;
          tmp6 = _SimCodeC_functionHeaderImpl(_txt, _a_fname, _a_fargs, _a_outVars, (0), (1));
          _txt = tmp6.SimCodeC_functionHeaderImpl_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__307_rettypeboxed boxptr_SimCodeC_fun__307(modelica_metatype _in_txt, modelica_metatype _in_mArg, modelica_metatype _in_a_fname, modelica_metatype _in_a_fargs, modelica_metatype _in_a_outVars)
{
  SimCodeC_fun__307_rettypeboxed tmp1;
  SimCodeC_fun__307_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_integer(_in_mArg);
  tmp4 = mmc_unbox_string(_in_a_fname);
  tmp2 = _SimCodeC_fun__307(_in_txt, tmp3, tmp4, _in_a_fargs, _in_a_outVars);
  tmp1.SimCodeC_fun__307_rettypeboxed_1 = tmp2.SimCodeC_fun__307_rettype_1;
  return tmp1;
}
SimCodeC_functionHeaderImpl_rettype _SimCodeC_functionHeaderImpl(modelica_metatype _txt, modelica_string _a_fname, modelica_metatype _a_fargs, modelica_metatype _a_outVars, modelica_boolean _a_inFunc, modelica_boolean _a_boxed)
{
  SimCodeC_functionHeaderImpl_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _l_inFnStr;
  modelica_metatype _l_boxPtrStr;
  modelica_metatype _l_boxStr;
  modelica_metatype _l_fargsStr;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  SimCodeC_fun__311_rettype tmp5;
  modelica_metatype tmp6;
  modelica_metatype tmp7;
  modelica_metatype tmp8;
  SimCodeC_fun__312_rettype tmp9;
  modelica_metatype tmp10;
  modelica_metatype tmp11;
  modelica_metatype tmp12;
  SimCodeC_fun__313_rettype tmp13;
  modelica_metatype tmp14;
  modelica_metatype tmp15;
  modelica_metatype tmp16;
  SimCodeC_fun__315_rettype tmp17;
  SimCodeC_fun__322_rettype tmp18;


  tmp2 = mmc_mk_nil();
  tmp3 = mmc_mk_nil();
  tmp4 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp2, tmp3);
  tmp5 = _SimCodeC_fun__311(tmp4, _a_boxed, _a_fargs);
  _l_fargsStr = tmp5.SimCodeC_fun__311_rettype_1;
  tmp6 = mmc_mk_nil();
  tmp7 = mmc_mk_nil();
  tmp8 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp6, tmp7);
  tmp9 = _SimCodeC_fun__312(tmp8, _a_boxed);
  _l_boxStr = tmp9.SimCodeC_fun__312_rettype_1;
  tmp10 = mmc_mk_nil();
  tmp11 = mmc_mk_nil();
  tmp12 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp10, tmp11);
  tmp13 = _SimCodeC_fun__313(tmp12, _a_boxed);
  _l_boxPtrStr = tmp13.SimCodeC_fun__313_rettype_1;
  tmp14 = mmc_mk_nil();
  tmp15 = mmc_mk_nil();
  tmp16 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp14, tmp15);
  tmp17 = _SimCodeC_fun__315(tmp16, _a_boxed, _a_fname, _a_inFunc);
  _l_inFnStr = tmp17.SimCodeC_fun__315_rettype_1;
  tmp18 = _SimCodeC_fun__322(_txt, _a_outVars, _l_inFnStr, _a_boxed, _l_boxStr, _l_fargsStr, _a_fname, _l_boxPtrStr);
  _out_txt = tmp18.SimCodeC_fun__322_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionHeaderImpl_rettypeboxed boxptr_SimCodeC_functionHeaderImpl(modelica_metatype _txt, modelica_metatype _a_fname, modelica_metatype _a_fargs, modelica_metatype _a_outVars, modelica_metatype _a_inFunc, modelica_metatype _a_boxed)
{
  SimCodeC_functionHeaderImpl_rettypeboxed tmp1;
  SimCodeC_functionHeaderImpl_rettype tmp2;
  modelica_string tmp3;
  modelica_integer tmp4;
  modelica_integer tmp5;
  tmp3 = mmc_unbox_string(_a_fname);
  tmp4 = mmc_unbox_integer(_a_inFunc);
  tmp5 = mmc_unbox_integer(_a_boxed);
  tmp2 = _SimCodeC_functionHeaderImpl(_txt, tmp3, _a_fargs, _a_outVars, tmp4, tmp5);
  tmp1.SimCodeC_functionHeaderImpl_rettypeboxed_1 = tmp2.SimCodeC_functionHeaderImpl_rettype_1;
  return tmp1;
}
SimCodeC_fun__322_rettype _SimCodeC_fun__322(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_inFnStr, modelica_boolean _in_a_boxed, modelica_metatype _in_a_boxStr, modelica_metatype _in_a_fargsStr, modelica_string _in_a_fname, modelica_metatype _in_a_boxPtrStr)
{
  SimCodeC_fun__322_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_boolean tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    modelica_string tmp3_in6;
    modelica_metatype tmp3_in7;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_outVars;
    tmp3_in2 = _in_a_inFnStr;
    tmp3_in3 = _in_a_boxed;
    tmp3_in4 = _in_a_boxStr;
    tmp3_in5 = _in_a_fargsStr;
    tmp3_in6 = _in_a_fname;
    tmp3_in7 = _in_a_boxPtrStr;
    {
      modelica_metatype _txt;
      modelica_metatype _a_inFnStr;
      modelica_boolean _a_boxed;
      modelica_metatype _a_boxStr;
      modelica_metatype _a_fargsStr;
      modelica_string _a_fname;
      modelica_metatype _a_boxPtrStr;
      modelica_metatype _i_outVars;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          Tpl_writeText_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          Tpl_writeStr_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          Tpl_writeText_rettype tmp15;
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fargsStr = tmp3_in5;
          _a_fname = tmp3_in6;
          _a_boxPtrStr = tmp3_in7;
          tmp6 = mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_cons(mmc_mk_scon("void "), mmc_mk_nil()));
          tmp7 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp6, mmc_mk_boolean((0)));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp9 = _Tpl_writeText(_txt, _a_boxPtrStr);
          _txt = tmp9.Tpl_writeText_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = _Tpl_writeStr(_txt, _a_fname);
          _txt = tmp12.Tpl_writeStr_rettype_1;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = _Tpl_writeText(_txt, _a_fargsStr);
          _txt = tmp15.Tpl_writeText_rettype_1;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp17 = _Tpl_writeTok(_txt, tmp16);
          _txt = tmp17.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          Tpl_pushIter_rettype tmp22;
          SimCodeC_lm__316_rettype tmp23;
          Tpl_popIter_rettype tmp24;
          Tpl_softNewLine_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          Tpl_writeStr_rettype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          Tpl_writeText_rettype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          Tpl_writeTok_rettype tmp34;
          modelica_metatype tmp35;
          Tpl_pushBlock_rettype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          Tpl_pushIter_rettype tmp41;
          SimCodeC_lm__321_rettype tmp42;
          Tpl_popIter_rettype tmp43;
          Tpl_softNewLine_rettype tmp44;
          Tpl_popBlock_rettype tmp45;
          modelica_metatype tmp46;
          Tpl_writeTok_rettype tmp47;
          Tpl_writeStr_rettype tmp48;
          modelica_metatype tmp49;
          Tpl_writeTok_rettype tmp50;
          Tpl_writeText_rettype tmp51;
          modelica_metatype tmp52;
          Tpl_writeTok_rettype tmp53;
          Tpl_writeText_rettype tmp54;
          Tpl_softNewLine_rettype tmp55;
          modelica_metatype tmp56;
          Tpl_writeTok_rettype tmp57;
          Tpl_writeStr_rettype tmp58;
          modelica_metatype tmp59;
          Tpl_writeTok_rettype tmp60;
          Tpl_writeText_rettype tmp61;
          modelica_metatype tmp62;
          Tpl_writeTok_rettype tmp63;
          Tpl_writeText_rettype tmp64;
          modelica_metatype tmp65;
          Tpl_writeTok_rettype tmp66;
          Tpl_writeStr_rettype tmp67;
          modelica_metatype tmp68;
          Tpl_writeTok_rettype tmp69;
          Tpl_writeText_rettype tmp70;
          modelica_metatype tmp71;
          Tpl_writeTok_rettype tmp72;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_outVars = tmp3_in1;
          _a_inFnStr = tmp3_in2;
          _a_boxed = tmp3_in3;
          _a_boxStr = tmp3_in4;
          _a_fargsStr = tmp3_in5;
          _a_fname = tmp3_in6;
          _a_boxPtrStr = tmp3_in7;
          tmp18 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp19 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp20 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp21 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_none(), mmc_mk_some(tmp18), mmc_mk_integer(0), mmc_mk_integer(0), tmp19, mmc_mk_integer(0), tmp20);
          tmp22 = _Tpl_pushIter(_txt, tmp21);
          _txt = tmp22.Tpl_pushIter_rettype_1;
          tmp23 = _SimCodeC_lm__316(_txt, _i_outVars, _a_boxStr, _a_fname);
          _txt = tmp23.SimCodeC_lm__316_rettype_1;
          tmp24 = _Tpl_popIter(_txt);
          _txt = tmp24.Tpl_popIter_rettype_1;
          tmp25 = _Tpl_softNewLine(_txt);
          _txt = tmp25.Tpl_softNewLine_rettype_1;
          tmp26 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("typedef struct "));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = _Tpl_writeStr(_txt, _a_fname);
          _txt = tmp28.Tpl_writeStr_rettype_1;
          tmp29 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp30 = _Tpl_writeTok(_txt, tmp29);
          _txt = tmp30.Tpl_writeTok_rettype_1;
          tmp31 = _Tpl_writeText(_txt, _a_boxStr);
          _txt = tmp31.Tpl_writeText_rettype_1;
          tmp32 = mmc_mk_cons(mmc_mk_scon("_s\n"), mmc_mk_cons(mmc_mk_scon("{\n"), mmc_mk_nil()));
          tmp33 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp32, mmc_mk_boolean((1)));
          tmp34 = _Tpl_writeTok(_txt, tmp33);
          _txt = tmp34.Tpl_writeTok_rettype_1;
          tmp35 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp36 = _Tpl_pushBlock(_txt, tmp35);
          _txt = tmp36.Tpl_pushBlock_rettype_1;
          tmp37 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp38 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp39 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp40 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(1), mmc_mk_none(), mmc_mk_some(tmp37), mmc_mk_integer(0), mmc_mk_integer(0), tmp38, mmc_mk_integer(0), tmp39);
          tmp41 = _Tpl_pushIter(_txt, tmp40);
          _txt = tmp41.Tpl_pushIter_rettype_1;
          tmp42 = _SimCodeC_lm__321(_txt, _i_outVars, _a_boxed);
          _txt = tmp42.SimCodeC_lm__321_rettype_1;
          tmp43 = _Tpl_popIter(_txt);
          _txt = tmp43.Tpl_popIter_rettype_1;
          tmp44 = _Tpl_softNewLine(_txt);
          _txt = tmp44.Tpl_softNewLine_rettype_1;
          tmp45 = _Tpl_popBlock(_txt);
          _txt = tmp45.Tpl_popBlock_rettype_1;
          tmp46 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("} "));
          tmp47 = _Tpl_writeTok(_txt, tmp46);
          _txt = tmp47.Tpl_writeTok_rettype_1;
          tmp48 = _Tpl_writeStr(_txt, _a_fname);
          _txt = tmp48.Tpl_writeStr_rettype_1;
          tmp49 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp50 = _Tpl_writeTok(_txt, tmp49);
          _txt = tmp50.Tpl_writeTok_rettype_1;
          tmp51 = _Tpl_writeText(_txt, _a_boxStr);
          _txt = tmp51.Tpl_writeText_rettype_1;
          tmp52 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(";\n"));
          tmp53 = _Tpl_writeTok(_txt, tmp52);
          _txt = tmp53.Tpl_writeTok_rettype_1;
          tmp54 = _Tpl_writeText(_txt, _a_inFnStr);
          _txt = tmp54.Tpl_writeText_rettype_1;
          tmp55 = _Tpl_softNewLine(_txt);
          _txt = tmp55.Tpl_softNewLine_rettype_1;
          tmp56 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp57 = _Tpl_writeTok(_txt, tmp56);
          _txt = tmp57.Tpl_writeTok_rettype_1;
          tmp58 = _Tpl_writeStr(_txt, _a_fname);
          _txt = tmp58.Tpl_writeStr_rettype_1;
          tmp59 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp60 = _Tpl_writeTok(_txt, tmp59);
          _txt = tmp60.Tpl_writeTok_rettype_1;
          tmp61 = _Tpl_writeText(_txt, _a_boxStr);
          _txt = tmp61.Tpl_writeText_rettype_1;
          tmp62 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp63 = _Tpl_writeTok(_txt, tmp62);
          _txt = tmp63.Tpl_writeTok_rettype_1;
          tmp64 = _Tpl_writeText(_txt, _a_boxPtrStr);
          _txt = tmp64.Tpl_writeText_rettype_1;
          tmp65 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp66 = _Tpl_writeTok(_txt, tmp65);
          _txt = tmp66.Tpl_writeTok_rettype_1;
          tmp67 = _Tpl_writeStr(_txt, _a_fname);
          _txt = tmp67.Tpl_writeStr_rettype_1;
          tmp68 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp69 = _Tpl_writeTok(_txt, tmp68);
          _txt = tmp69.Tpl_writeTok_rettype_1;
          tmp70 = _Tpl_writeText(_txt, _a_fargsStr);
          _txt = tmp70.Tpl_writeText_rettype_1;
          tmp71 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(");"));
          tmp72 = _Tpl_writeTok(_txt, tmp71);
          _txt = tmp72.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__322_rettypeboxed boxptr_SimCodeC_fun__322(modelica_metatype _in_txt, modelica_metatype _in_a_outVars, modelica_metatype _in_a_inFnStr, modelica_metatype _in_a_boxed, modelica_metatype _in_a_boxStr, modelica_metatype _in_a_fargsStr, modelica_metatype _in_a_fname, modelica_metatype _in_a_boxPtrStr)
{
  SimCodeC_fun__322_rettypeboxed tmp1;
  SimCodeC_fun__322_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_integer(_in_a_boxed);
  tmp4 = mmc_unbox_string(_in_a_fname);
  tmp2 = _SimCodeC_fun__322(_in_txt, _in_a_outVars, _in_a_inFnStr, tmp3, _in_a_boxStr, _in_a_fargsStr, tmp4, _in_a_boxPtrStr);
  tmp1.SimCodeC_fun__322_rettypeboxed_1 = tmp2.SimCodeC_fun__322_rettype_1;
  return tmp1;
}
SimCodeC_lm__321_rettype _SimCodeC_lm__321(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_boolean _in_a_boxed)
{
  SimCodeC_lm__321_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_boolean tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_boxed;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_boolean _a_boxed;
      modelica_integer _x_i1;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_getIteri__i0_rettype tmp8;
          SimCodeC_fun__320_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__321_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          _a_boxed = tmp3_in2;
          tmp8 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp8.Tpl_getIteri__i0_rettype_1;
          tmp9 = _SimCodeC_fun__320(_txt, _i_var, (modelica_integer)_x_i1, _a_boxed);
          _txt = tmp9.SimCodeC_fun__320_rettype_1;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__321(_txt, _rest, _a_boxed);
          _txt = tmp11.SimCodeC_lm__321_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__321_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          _a_boxed = tmp3_in2;
          tmp14 = _SimCodeC_lm__321(_txt, _rest, _a_boxed);
          _txt = tmp14.SimCodeC_lm__321_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__321_rettypeboxed boxptr_SimCodeC_lm__321(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_boxed)
{
  SimCodeC_lm__321_rettypeboxed tmp1;
  SimCodeC_lm__321_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_boxed);
  tmp2 = _SimCodeC_lm__321(_in_txt, _in_items, tmp3);
  tmp1.SimCodeC_lm__321_rettypeboxed_1 = tmp2.SimCodeC_lm__321_rettype_1;
  return tmp1;
}
SimCodeC_fun__320_rettype _SimCodeC_fun__320(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_integer _in_a_i1, modelica_boolean _in_a_boxed)
{
  SimCodeC_fun__320_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_integer tmp3_in2;
    modelica_boolean tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    tmp3_in2 = (modelica_integer)_in_a_i1;
    tmp3_in3 = _in_a_boxed;
    {
      modelica_metatype _txt;
      modelica_integer _a_i1;
      modelica_boolean _a_boxed;
      modelica_string _i_name_1;
      modelica_metatype _i_name;
      modelica_metatype _i_var;
      modelica_metatype _i_ty;
      modelica_metatype _l_typeStr;
      modelica_metatype _l_dimStr;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_fun__318_rettype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          SimCodeC_fun__319_rettype tmp17;
          Tpl_writeText_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          intString_rettype tmp21;
          Tpl_writeStr_rettype tmp22;
          modelica_metatype tmp23;
          Tpl_writeTok_rettype tmp24;
          SimCodeC_crefStr_rettype tmp25;
          Tpl_writeText_rettype tmp26;
          modelica_metatype tmp27;
          Tpl_writeTok_rettype tmp28;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp3_in1;
          _i_name = tmp6;
          _i_ty = tmp7;
          _a_i1 = tmp3_in2;
          _a_boxed = tmp3_in3;
          tmp10 = mmc_mk_nil();
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp10, tmp11);
          tmp13 = _SimCodeC_fun__318(tmp12, _i_ty);
          _l_dimStr = tmp13.SimCodeC_fun__318_rettype_1;
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_nil();
          tmp16 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp14, tmp15);
          tmp17 = _SimCodeC_fun__319(tmp16, _a_boxed, _i_var);
          _l_typeStr = tmp17.SimCodeC_fun__319_rettype_1;
          tmp18 = _Tpl_writeText(_txt, _l_typeStr);
          _txt = tmp18.Tpl_writeText_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" targ"));
          tmp20 = _Tpl_writeTok(_txt, tmp19);
          _txt = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = intString((modelica_integer)_a_i1);
          tmp22 = _Tpl_writeStr(_txt, tmp21);
          _txt = tmp22.Tpl_writeStr_rettype_1;
          tmp23 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("; /* "));
          tmp24 = _Tpl_writeTok(_txt, tmp23);
          _txt = tmp24.Tpl_writeTok_rettype_1;
          tmp25 = _SimCodeC_crefStr(_txt, _i_name);
          _txt = tmp25.SimCodeC_crefStr_rettype_1;
          tmp26 = _Tpl_writeText(_txt, _l_dimStr);
          _txt = tmp26.Tpl_writeText_rettype_1;
          tmp27 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" */"));
          tmp28 = _Tpl_writeTok(_txt, tmp27);
          _txt = tmp28.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp29;
          modelica_string tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          Tpl_writeTok_rettype tmp34;
          intString_rettype tmp35;
          Tpl_writeStr_rettype tmp36;
          modelica_metatype tmp37;
          Tpl_writeTok_rettype tmp38;
          Tpl_writeStr_rettype tmp39;
          modelica_metatype tmp40;
          Tpl_writeTok_rettype tmp41;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,3) == 0) MMC_THROW();
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp30 = mmc_unbox_string(tmp29);
          tmp31 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name_1 = tmp30;
          _a_i1 = tmp3_in2;
          tmp33 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_fnptr targ"));
          tmp34 = _Tpl_writeTok(_txt, tmp33);
          _txt = tmp34.Tpl_writeTok_rettype_1;
          tmp35 = intString((modelica_integer)_a_i1);
          tmp36 = _Tpl_writeStr(_txt, tmp35);
          _txt = tmp36.Tpl_writeStr_rettype_1;
          tmp37 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("; /* "));
          tmp38 = _Tpl_writeTok(_txt, tmp37);
          _txt = tmp38.Tpl_writeTok_rettype_1;
          tmp39 = _Tpl_writeStr(_txt, _i_name_1);
          _txt = tmp39.Tpl_writeStr_rettype_1;
          tmp40 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" */"));
          tmp41 = _Tpl_writeTok(_txt, tmp40);
          _txt = tmp41.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__320_rettypeboxed boxptr_SimCodeC_fun__320(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_metatype _in_a_i1, modelica_metatype _in_a_boxed)
{
  SimCodeC_fun__320_rettypeboxed tmp1;
  SimCodeC_fun__320_rettype tmp2;
  modelica_integer tmp3;
  modelica_integer tmp4;
  tmp3 = mmc_unbox_integer(_in_a_i1);
  tmp4 = mmc_unbox_integer(_in_a_boxed);
  tmp2 = _SimCodeC_fun__320(_in_txt, _in_a_var, tmp3, tmp4);
  tmp1.SimCodeC_fun__320_rettypeboxed_1 = tmp2.SimCodeC_fun__320_rettype_1;
  return tmp1;
}
SimCodeC_fun__319_rettype _SimCodeC_fun__319(modelica_metatype _in_txt, modelica_boolean _in_a_boxed, modelica_metatype _in_a_var)
{
  SimCodeC_fun__319_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_boxed;
    tmp3_in2 = _in_a_var;
    {
      modelica_metatype _txt;
      modelica_metatype _a_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_varType_rettype tmp6;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_var = tmp3_in2;
          tmp6 = _SimCodeC_varType(_txt, _a_var);
          _txt = tmp6.SimCodeC_varType_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          SimCodeC_varTypeBoxed_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_var = tmp3_in2;
          tmp7 = _SimCodeC_varTypeBoxed(_txt, _a_var);
          _txt = tmp7.SimCodeC_varTypeBoxed_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__319_rettypeboxed boxptr_SimCodeC_fun__319(modelica_metatype _in_txt, modelica_metatype _in_a_boxed, modelica_metatype _in_a_var)
{
  SimCodeC_fun__319_rettypeboxed tmp1;
  SimCodeC_fun__319_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_boxed);
  tmp2 = _SimCodeC_fun__319(_in_txt, tmp3, _in_a_var);
  tmp1.SimCodeC_fun__319_rettypeboxed_1 = tmp2.SimCodeC_fun__319_rettype_1;
  return tmp1;
}
SimCodeC_varTypeBoxed_rettype _SimCodeC_varTypeBoxed(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_varTypeBoxed_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,3) == 0) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_fnptr"));
          tmp16 = _Tpl_writeTok(_txt, tmp15);
          _txt = tmp16.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_varTypeBoxed_rettypeboxed boxptr_SimCodeC_varTypeBoxed(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_varTypeBoxed_rettypeboxed tmp1;
  SimCodeC_varTypeBoxed_rettype tmp2;
  tmp2 = _SimCodeC_varTypeBoxed(_in_txt, _in_a_var);
  tmp1.SimCodeC_varTypeBoxed_rettypeboxed_1 = tmp2.SimCodeC_varTypeBoxed_rettype_1;
  return tmp1;
}
SimCodeC_fun__318_rettype _SimCodeC_fun__318(modelica_metatype _in_txt, modelica_metatype _in_a_ty)
{
  SimCodeC_fun__318_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_ty;
    {
      modelica_metatype _txt;
      modelica_metatype _i_arrayDimensions;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          Tpl_pushIter_rettype tmp14;
          SimCodeC_lm__317_rettype tmp15;
          Tpl_popIter_rettype tmp16;
          modelica_metatype tmp17;
          Tpl_writeTok_rettype tmp18;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,7,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_arrayDimensions = tmp7;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("["));
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp11 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp12 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp13 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp10), mmc_mk_integer(0), mmc_mk_integer(0), tmp11, mmc_mk_integer(0), tmp12);
          tmp14 = _Tpl_pushIter(_txt, tmp13);
          _txt = tmp14.Tpl_pushIter_rettype_1;
          tmp15 = _SimCodeC_lm__317(_txt, _i_arrayDimensions);
          _txt = tmp15.SimCodeC_lm__317_rettype_1;
          tmp16 = _Tpl_popIter(_txt);
          _txt = tmp16.Tpl_popIter_rettype_1;
          tmp17 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("]"));
          tmp18 = _Tpl_writeTok(_txt, tmp17);
          _txt = tmp18.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__318_rettypeboxed boxptr_SimCodeC_fun__318(modelica_metatype _in_txt, modelica_metatype _in_a_ty)
{
  SimCodeC_fun__318_rettypeboxed tmp1;
  SimCodeC_fun__318_rettype tmp2;
  tmp2 = _SimCodeC_fun__318(_in_txt, _in_a_ty);
  tmp1.SimCodeC_fun__318_rettypeboxed_1 = tmp2.SimCodeC_fun__318_rettype_1;
  return tmp1;
}
SimCodeC_lm__317_rettype _SimCodeC_lm__317(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__317_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_dim;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_dimension_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__317_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_dim = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_dimension(_txt, _i_dim);
          _txt = tmp8.SimCodeC_dimension_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__317(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__317_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__317_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__317(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__317_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__317_rettypeboxed boxptr_SimCodeC_lm__317(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__317_rettypeboxed tmp1;
  SimCodeC_lm__317_rettype tmp2;
  tmp2 = _SimCodeC_lm__317(_in_txt, _in_items);
  tmp1.SimCodeC_lm__317_rettypeboxed_1 = tmp2.SimCodeC_lm__317_rettype_1;
  return tmp1;
}
SimCodeC_lm__316_rettype _SimCodeC_lm__316(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_boxStr, modelica_string _in_a_fname)
{
  SimCodeC_lm__316_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_string tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_boxStr;
    tmp3_in3 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_boxStr;
      modelica_string _a_fname;
      modelica_integer _x_i1;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_getIteri__i0_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          Tpl_writeStr_rettype tmp11;
          modelica_metatype tmp12;
          Tpl_writeTok_rettype tmp13;
          Tpl_writeText_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          intString_rettype tmp17;
          Tpl_writeStr_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          intString_rettype tmp21;
          Tpl_writeStr_rettype tmp22;
          Tpl_nextIter_rettype tmp23;
          SimCodeC_lm__316_rettype tmp24;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp7;
          _a_boxStr = tmp3_in2;
          _a_fname = tmp3_in3;
          tmp8 = _Tpl_getIteri__i0(_txt);
          _x_i1 = tmp8.Tpl_getIteri__i0_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#define "));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp11 = _Tpl_writeStr(_txt, _a_fname);
          _txt = tmp11.Tpl_writeStr_rettype_1;
          tmp12 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_rettype"));
          tmp13 = _Tpl_writeTok(_txt, tmp12);
          _txt = tmp13.Tpl_writeTok_rettype_1;
          tmp14 = _Tpl_writeText(_txt, _a_boxStr);
          _txt = tmp14.Tpl_writeText_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("_"));
          tmp16 = _Tpl_writeTok(_txt, tmp15);
          _txt = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = intString((modelica_integer)_x_i1);
          tmp18 = _Tpl_writeStr(_txt, tmp17);
          _txt = tmp18.Tpl_writeStr_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" targ"));
          tmp20 = _Tpl_writeTok(_txt, tmp19);
          _txt = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = intString((modelica_integer)_x_i1);
          tmp22 = _Tpl_writeStr(_txt, tmp21);
          _txt = tmp22.Tpl_writeStr_rettype_1;
          tmp23 = _Tpl_nextIter(_txt);
          _txt = tmp23.Tpl_nextIter_rettype_1;
          tmp24 = _SimCodeC_lm__316(_txt, _rest, _a_boxStr, _a_fname);
          _txt = tmp24.SimCodeC_lm__316_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          SimCodeC_lm__316_rettype tmp27;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp25 = MMC_CAR(tmp3_in1);
          tmp26 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp26;
          _a_boxStr = tmp3_in2;
          _a_fname = tmp3_in3;
          tmp27 = _SimCodeC_lm__316(_txt, _rest, _a_boxStr, _a_fname);
          _txt = tmp27.SimCodeC_lm__316_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__316_rettypeboxed boxptr_SimCodeC_lm__316(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_boxStr, modelica_metatype _in_a_fname)
{
  SimCodeC_lm__316_rettypeboxed tmp1;
  SimCodeC_lm__316_rettype tmp2;
  modelica_string tmp3;
  tmp3 = mmc_unbox_string(_in_a_fname);
  tmp2 = _SimCodeC_lm__316(_in_txt, _in_items, _in_a_boxStr, tmp3);
  tmp1.SimCodeC_lm__316_rettypeboxed_1 = tmp2.SimCodeC_lm__316_rettype_1;
  return tmp1;
}
SimCodeC_fun__315_rettype _SimCodeC_fun__315(modelica_metatype _in_txt, modelica_boolean _in_a_boxed, modelica_string _in_a_fname, modelica_boolean _in_a_inFunc)
{
  SimCodeC_fun__315_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_string tmp3_in2;
    modelica_boolean tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_boxed;
    tmp3_in2 = _in_a_fname;
    tmp3_in3 = _in_a_inFunc;
    {
      modelica_metatype _txt;
      modelica_string _a_fname;
      modelica_boolean _a_inFunc;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          SimCodeC_fun__314_rettype tmp6;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fname = tmp3_in2;
          _a_inFunc = tmp3_in3;
          tmp6 = _SimCodeC_fun__314(_txt, _a_inFunc, _a_fname);
          _txt = tmp6.SimCodeC_fun__314_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__315_rettypeboxed boxptr_SimCodeC_fun__315(modelica_metatype _in_txt, modelica_metatype _in_a_boxed, modelica_metatype _in_a_fname, modelica_metatype _in_a_inFunc)
{
  SimCodeC_fun__315_rettypeboxed tmp1;
  SimCodeC_fun__315_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  modelica_integer tmp5;
  tmp3 = mmc_unbox_integer(_in_a_boxed);
  tmp4 = mmc_unbox_string(_in_a_fname);
  tmp5 = mmc_unbox_integer(_in_a_inFunc);
  tmp2 = _SimCodeC_fun__315(_in_txt, tmp3, tmp4, tmp5);
  tmp1.SimCodeC_fun__315_rettypeboxed_1 = tmp2.SimCodeC_fun__315_rettype_1;
  return tmp1;
}
SimCodeC_fun__314_rettype _SimCodeC_fun__314(modelica_metatype _in_txt, modelica_boolean _in_a_inFunc, modelica_string _in_a_fname)
{
  SimCodeC_fun__314_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_string tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_inFunc;
    tmp3_in2 = _in_a_fname;
    {
      modelica_metatype _txt;
      modelica_string _a_fname;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          Tpl_writeStr_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fname = tmp3_in2;
          tmp6 = mmc_mk_cons(mmc_mk_scon("\n"), mmc_mk_cons(mmc_mk_scon("DLLExport\n"), mmc_mk_cons(mmc_mk_scon("int in_"), mmc_mk_nil())));
          tmp7 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp6, mmc_mk_boolean((0)));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp9 = _Tpl_writeStr(_txt, _a_fname);
          _txt = tmp9.Tpl_writeStr_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("(type_description * inArgs, type_description * outVar);"));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__314_rettypeboxed boxptr_SimCodeC_fun__314(modelica_metatype _in_txt, modelica_metatype _in_a_inFunc, modelica_metatype _in_a_fname)
{
  SimCodeC_fun__314_rettypeboxed tmp1;
  SimCodeC_fun__314_rettype tmp2;
  modelica_integer tmp3;
  modelica_string tmp4;
  tmp3 = mmc_unbox_integer(_in_a_inFunc);
  tmp4 = mmc_unbox_string(_in_a_fname);
  tmp2 = _SimCodeC_fun__314(_in_txt, tmp3, tmp4);
  tmp1.SimCodeC_fun__314_rettypeboxed_1 = tmp2.SimCodeC_fun__314_rettype_1;
  return tmp1;
}
SimCodeC_fun__313_rettype _SimCodeC_fun__313(modelica_metatype _in_txt, modelica_boolean _in_a_boxed)
{
  SimCodeC_fun__313_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_boxed;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("boxptr"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__313_rettypeboxed boxptr_SimCodeC_fun__313(modelica_metatype _in_txt, modelica_metatype _in_a_boxed)
{
  SimCodeC_fun__313_rettypeboxed tmp1;
  SimCodeC_fun__313_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_boxed);
  tmp2 = _SimCodeC_fun__313(_in_txt, tmp3);
  tmp1.SimCodeC_fun__313_rettypeboxed_1 = tmp2.SimCodeC_fun__313_rettype_1;
  return tmp1;
}
SimCodeC_fun__312_rettype _SimCodeC_fun__312(modelica_metatype _in_txt, modelica_boolean _in_a_boxed)
{
  SimCodeC_fun__312_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_boxed;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (false != tmp3_in1) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("boxed"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__312_rettypeboxed boxptr_SimCodeC_fun__312(modelica_metatype _in_txt, modelica_metatype _in_a_boxed)
{
  SimCodeC_fun__312_rettypeboxed tmp1;
  SimCodeC_fun__312_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_boxed);
  tmp2 = _SimCodeC_fun__312(_in_txt, tmp3);
  tmp1.SimCodeC_fun__312_rettypeboxed_1 = tmp2.SimCodeC_fun__312_rettype_1;
  return tmp1;
}
SimCodeC_fun__311_rettype _SimCodeC_fun__311(modelica_metatype _in_txt, modelica_boolean _in_a_boxed, modelica_metatype _in_a_fargs)
{
  SimCodeC_fun__311_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_boolean tmp3_in1;
    modelica_metatype tmp3_in2;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_boxed;
    tmp3_in2 = _in_a_fargs;
    {
      modelica_metatype _txt;
      modelica_metatype _a_fargs;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          Tpl_pushIter_rettype tmp10;
          SimCodeC_lm__309_rettype tmp11;
          Tpl_popIter_rettype tmp12;
          if (false != tmp3_in1) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fargs = tmp3_in2;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp7 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp8 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp9 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp6), mmc_mk_integer(0), mmc_mk_integer(0), tmp7, mmc_mk_integer(0), tmp8);
          tmp10 = _Tpl_pushIter(_txt, tmp9);
          _txt = tmp10.Tpl_pushIter_rettype_1;
          tmp11 = _SimCodeC_lm__309(_txt, _a_fargs);
          _txt = tmp11.SimCodeC_lm__309_rettype_1;
          tmp12 = _Tpl_popIter(_txt);
          _txt = tmp12.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          Tpl_pushIter_rettype tmp17;
          SimCodeC_lm__310_rettype tmp18;
          Tpl_popIter_rettype tmp19;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_fargs = tmp3_in2;
          tmp13 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp14 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp15 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp16 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp13), mmc_mk_integer(0), mmc_mk_integer(0), tmp14, mmc_mk_integer(0), tmp15);
          tmp17 = _Tpl_pushIter(_txt, tmp16);
          _txt = tmp17.Tpl_pushIter_rettype_1;
          tmp18 = _SimCodeC_lm__310(_txt, _a_fargs);
          _txt = tmp18.SimCodeC_lm__310_rettype_1;
          tmp19 = _Tpl_popIter(_txt);
          _txt = tmp19.Tpl_popIter_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__311_rettypeboxed boxptr_SimCodeC_fun__311(modelica_metatype _in_txt, modelica_metatype _in_a_boxed, modelica_metatype _in_a_fargs)
{
  SimCodeC_fun__311_rettypeboxed tmp1;
  SimCodeC_fun__311_rettype tmp2;
  modelica_integer tmp3;
  tmp3 = mmc_unbox_integer(_in_a_boxed);
  tmp2 = _SimCodeC_fun__311(_in_txt, tmp3, _in_a_fargs);
  tmp1.SimCodeC_fun__311_rettypeboxed_1 = tmp2.SimCodeC_fun__311_rettype_1;
  return tmp1;
}
SimCodeC_lm__310_rettype _SimCodeC_lm__310(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__310_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgBoxedDefinition_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__310_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgBoxedDefinition(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgBoxedDefinition_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__310(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__310_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__310_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__310(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__310_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__310_rettypeboxed boxptr_SimCodeC_lm__310(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__310_rettypeboxed tmp1;
  SimCodeC_lm__310_rettype tmp2;
  tmp2 = _SimCodeC_lm__310(_in_txt, _in_items);
  tmp1.SimCodeC_lm__310_rettypeboxed_1 = tmp2.SimCodeC_lm__310_rettype_1;
  return tmp1;
}
SimCodeC_funArgBoxedDefinition_rettype _SimCodeC_funArgBoxedDefinition(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_funArgBoxedDefinition_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    {
      modelica_metatype _txt;
      modelica_string _i_name_1;
      modelica_metatype _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          modelica_metatype tmp12;
          SimCodeC_contextCref_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp6;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_metatype "));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp13 = _SimCodeC_contextCref(_txt, _i_name, tmp12);
          _txt = tmp13.SimCodeC_contextCref_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp14;
          modelica_string tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          Tpl_writeStr_rettype tmp20;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,3) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp15 = mmc_unbox_string(tmp14);
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp17 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name_1 = tmp15;
          tmp18 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_fnptr "));
          tmp19 = _Tpl_writeTok(_txt, tmp18);
          _txt = tmp19.Tpl_writeTok_rettype_1;
          tmp20 = _Tpl_writeStr(_txt, _i_name_1);
          _txt = tmp20.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_funArgBoxedDefinition_rettypeboxed boxptr_SimCodeC_funArgBoxedDefinition(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_funArgBoxedDefinition_rettypeboxed tmp1;
  SimCodeC_funArgBoxedDefinition_rettype tmp2;
  tmp2 = _SimCodeC_funArgBoxedDefinition(_in_txt, _in_a_var);
  tmp1.SimCodeC_funArgBoxedDefinition_rettypeboxed_1 = tmp2.SimCodeC_funArgBoxedDefinition_rettype_1;
  return tmp1;
}
SimCodeC_lm__309_rettype _SimCodeC_lm__309(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__309_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_funArgDefinition_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__309_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_funArgDefinition(_txt, _i_var);
          _txt = tmp8.SimCodeC_funArgDefinition_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__309(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__309_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__309_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__309(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__309_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__309_rettypeboxed boxptr_SimCodeC_lm__309(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__309_rettypeboxed tmp1;
  SimCodeC_lm__309_rettype tmp2;
  tmp2 = _SimCodeC_lm__309(_in_txt, _in_items);
  tmp1.SimCodeC_lm__309_rettypeboxed_1 = tmp2.SimCodeC_lm__309_rettype_1;
  return tmp1;
}
SimCodeC_funArgDefinition_rettype _SimCodeC_funArgDefinition(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_funArgDefinition_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    {
      modelica_metatype _txt;
      modelica_string _i_name_1;
      modelica_metatype _i_name;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          SimCodeC_varType_rettype tmp10;
          modelica_metatype tmp11;
          Tpl_writeTok_rettype tmp12;
          modelica_metatype tmp13;
          SimCodeC_contextCref_rettype tmp14;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,4) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp3_in1;
          _i_name = tmp6;
          tmp10 = _SimCodeC_varType(_txt, _i_var);
          _txt = tmp10.SimCodeC_varType_rettype_1;
          tmp11 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" "));
          tmp12 = _Tpl_writeTok(_txt, tmp11);
          _txt = tmp12.Tpl_writeTok_rettype_1;
          tmp13 = mmc_mk_box1(4, &SimCode_Context_FUNCTION__CONTEXT__desc);
          tmp14 = _SimCodeC_contextCref(_txt, _i_name, tmp13);
          _txt = tmp14.SimCodeC_contextCref_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp15;
          modelica_string tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          Tpl_writeStr_rettype tmp21;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,3) == 0) MMC_THROW();
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp16 = mmc_unbox_string(tmp15);
          tmp17 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp18 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name_1 = tmp16;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("modelica_fnptr "));
          tmp20 = _Tpl_writeTok(_txt, tmp19);
          _txt = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = _Tpl_writeStr(_txt, _i_name_1);
          _txt = tmp21.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_funArgDefinition_rettypeboxed boxptr_SimCodeC_funArgDefinition(modelica_metatype _in_txt, modelica_metatype _in_a_var)
{
  SimCodeC_funArgDefinition_rettypeboxed tmp1;
  SimCodeC_funArgDefinition_rettype tmp2;
  tmp2 = _SimCodeC_funArgDefinition(_in_txt, _in_a_var);
  tmp1.SimCodeC_funArgDefinition_rettypeboxed_1 = tmp2.SimCodeC_funArgDefinition_rettype_1;
  return tmp1;
}
SimCodeC_functionHeaderNormal_rettype _SimCodeC_functionHeaderNormal(modelica_metatype _txt, modelica_string _a_fname, modelica_metatype _a_fargs, modelica_metatype _a_outVars, modelica_boolean _a_inFunc)
{
  SimCodeC_functionHeaderNormal_rettype tmp1;
  modelica_metatype _out_txt;
  SimCodeC_functionHeaderImpl_rettype tmp2;


  tmp2 = _SimCodeC_functionHeaderImpl(_txt, _a_fname, _a_fargs, _a_outVars, _a_inFunc, (0));
  _out_txt = tmp2.SimCodeC_functionHeaderImpl_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_functionHeaderNormal_rettypeboxed boxptr_SimCodeC_functionHeaderNormal(modelica_metatype _txt, modelica_metatype _a_fname, modelica_metatype _a_fargs, modelica_metatype _a_outVars, modelica_metatype _a_inFunc)
{
  SimCodeC_functionHeaderNormal_rettypeboxed tmp1;
  SimCodeC_functionHeaderNormal_rettype tmp2;
  modelica_string tmp3;
  modelica_integer tmp4;
  tmp3 = mmc_unbox_string(_a_fname);
  tmp4 = mmc_unbox_integer(_a_inFunc);
  tmp2 = _SimCodeC_functionHeaderNormal(_txt, tmp3, _a_fargs, _a_outVars, tmp4);
  tmp1.SimCodeC_functionHeaderNormal_rettypeboxed_1 = tmp2.SimCodeC_functionHeaderNormal_rettype_1;
  return tmp1;
}
SimCodeC_externalFunctionIncludes_rettype _SimCodeC_externalFunctionIncludes(modelica_metatype _in_txt, modelica_metatype _in_a_includes)
{
  SimCodeC_externalFunctionIncludes_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_includes;
    {
      modelica_metatype _txt;
      modelica_metatype _i_includes;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          Tpl_writeTok_rettype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          Tpl_pushIter_rettype tmp13;
          SimCodeC_lm__290_rettype tmp14;
          Tpl_popIter_rettype tmp15;
          Tpl_softNewLine_rettype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_includes = tmp3_in1;
          tmp6 = mmc_mk_cons(mmc_mk_scon("#ifdef __cplusplus\n"), mmc_mk_cons(mmc_mk_scon("extern \"C\" {\n"), mmc_mk_cons(mmc_mk_scon("#endif\n"), mmc_mk_nil())));
          tmp7 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp6, mmc_mk_boolean((1)));
          tmp8 = _Tpl_writeTok(_txt, tmp7);
          _txt = tmp8.Tpl_writeTok_rettype_1;
          tmp9 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp10 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp11 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp12 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp9), mmc_mk_integer(0), mmc_mk_integer(0), tmp10, mmc_mk_integer(0), tmp11);
          tmp13 = _Tpl_pushIter(_txt, tmp12);
          _txt = tmp13.Tpl_pushIter_rettype_1;
          tmp14 = _SimCodeC_lm__290(_txt, _i_includes);
          _txt = tmp14.SimCodeC_lm__290_rettype_1;
          tmp15 = _Tpl_popIter(_txt);
          _txt = tmp15.Tpl_popIter_rettype_1;
          tmp16 = _Tpl_softNewLine(_txt);
          _txt = tmp16.Tpl_softNewLine_rettype_1;
          tmp17 = mmc_mk_cons(mmc_mk_scon("#ifdef __cplusplus\n"), mmc_mk_cons(mmc_mk_scon("}\n"), mmc_mk_cons(mmc_mk_scon("#endif"), mmc_mk_nil())));
          tmp18 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp17, mmc_mk_boolean((0)));
          tmp19 = _Tpl_writeTok(_txt, tmp18);
          _txt = tmp19.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_externalFunctionIncludes_rettypeboxed boxptr_SimCodeC_externalFunctionIncludes(modelica_metatype _in_txt, modelica_metatype _in_a_includes)
{
  SimCodeC_externalFunctionIncludes_rettypeboxed tmp1;
  SimCodeC_externalFunctionIncludes_rettype tmp2;
  tmp2 = _SimCodeC_externalFunctionIncludes(_in_txt, _in_a_includes);
  tmp1.SimCodeC_externalFunctionIncludes_rettypeboxed_1 = tmp2.SimCodeC_externalFunctionIncludes_rettype_1;
  return tmp1;
}
SimCodeC_lm__290_rettype _SimCodeC_lm__290(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__290_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_string _i_it;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_string tmp8;
          Tpl_writeStr_rettype tmp9;
          Tpl_nextIter_rettype tmp10;
          SimCodeC_lm__290_rettype tmp11;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          tmp8 = mmc_unbox_string(tmp6);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_it = tmp8;
          _rest = tmp7;
          tmp9 = _Tpl_writeStr(_txt, _i_it);
          _txt = tmp9.Tpl_writeStr_rettype_1;
          tmp10 = _Tpl_nextIter(_txt);
          _txt = tmp10.Tpl_nextIter_rettype_1;
          tmp11 = _SimCodeC_lm__290(_txt, _rest);
          _txt = tmp11.SimCodeC_lm__290_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_lm__290_rettype tmp14;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp12 = MMC_CAR(tmp3_in1);
          tmp13 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp13;
          tmp14 = _SimCodeC_lm__290(_txt, _rest);
          _txt = tmp14.SimCodeC_lm__290_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__290_rettypeboxed boxptr_SimCodeC_lm__290(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__290_rettypeboxed tmp1;
  SimCodeC_lm__290_rettype tmp2;
  tmp2 = _SimCodeC_lm__290(_in_txt, _in_items);
  tmp1.SimCodeC_lm__290_rettypeboxed_1 = tmp2.SimCodeC_lm__290_rettype_1;
  return tmp1;
}
SimCodeC_lm__255_rettype _SimCodeC_lm__255(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__255_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _i_rd;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_recordDeclarationHeader_rettype tmp8;
          Tpl_nextIter_rettype tmp9;
          SimCodeC_lm__255_rettype tmp10;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_rd = tmp6;
          _rest = tmp7;
          tmp8 = _SimCodeC_recordDeclarationHeader(_txt, _i_rd);
          _txt = tmp8.SimCodeC_recordDeclarationHeader_rettype_1;
          tmp9 = _Tpl_nextIter(_txt);
          _txt = tmp9.Tpl_nextIter_rettype_1;
          tmp10 = _SimCodeC_lm__255(_txt, _rest);
          _txt = tmp10.SimCodeC_lm__255_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          SimCodeC_lm__255_rettype tmp13;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp11 = MMC_CAR(tmp3_in1);
          tmp12 = MMC_CDR(tmp3_in1);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp12;
          tmp13 = _SimCodeC_lm__255(_txt, _rest);
          _txt = tmp13.SimCodeC_lm__255_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_lm__255_rettypeboxed boxptr_SimCodeC_lm__255(modelica_metatype _in_txt, modelica_metatype _in_items)
{
  SimCodeC_lm__255_rettypeboxed tmp1;
  SimCodeC_lm__255_rettype tmp2;
  tmp2 = _SimCodeC_lm__255(_in_txt, _in_items);
  tmp1.SimCodeC_lm__255_rettypeboxed_1 = tmp2.SimCodeC_lm__255_rettype_1;
  return tmp1;
}
SimCodeC_dotPath_rettype _SimCodeC_dotPath(modelica_metatype _in_txt, modelica_metatype _in_a_path)
{
  SimCodeC_dotPath_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_path;
    {
      modelica_metatype _txt;
      modelica_metatype _i_path;
      modelica_string _i_name;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 4 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_string tmp7;
          modelica_metatype tmp8;
          Tpl_writeStr_rettype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          SimCodeC_dotPath_rettype tmp12;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = mmc_unbox_string(tmp6);
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp7;
          _i_path = tmp8;
          tmp9 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp9.Tpl_writeStr_rettype_1;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = _SimCodeC_dotPath(_txt, _i_path);
          _txt = tmp12.SimCodeC_dotPath_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp13;
          modelica_string tmp14;
          Tpl_writeStr_rettype tmp15;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,1) == 0) MMC_THROW();
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp14 = mmc_unbox_string(tmp13);
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp14;
          tmp15 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp15.Tpl_writeStr_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp16;
          SimCodeC_dotPath_rettype tmp17;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,1) == 0) MMC_THROW();
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_path = tmp16;
          tmp17 = _SimCodeC_dotPath(_txt, _i_path);
          _txt = tmp17.SimCodeC_dotPath_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 3: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_dotPath_rettypeboxed boxptr_SimCodeC_dotPath(modelica_metatype _in_txt, modelica_metatype _in_a_path)
{
  SimCodeC_dotPath_rettypeboxed tmp1;
  SimCodeC_dotPath_rettype tmp2;
  tmp2 = _SimCodeC_dotPath(_in_txt, _in_a_path);
  tmp1.SimCodeC_dotPath_rettypeboxed_1 = tmp2.SimCodeC_dotPath_rettype_1;
  return tmp1;
}
SimCodeC_recordDeclarationHeader_rettype _SimCodeC_recordDeclarationHeader(modelica_metatype _in_txt, modelica_metatype _in_a_recDecl)
{
  SimCodeC_recordDeclarationHeader_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_recDecl;
    {
      modelica_metatype _txt;
      modelica_metatype _i_fieldNames;
      modelica_metatype _i_path;
      modelica_metatype _i_defPath;
      modelica_metatype _i_variables;
      modelica_string _i_name;
      modelica_integer _ret_5;
      modelica_metatype _txt_4;
      modelica_metatype _txt_3;
      modelica_integer _ret_2;
      modelica_metatype _txt_1;
      modelica_metatype _txt_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_string tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          Tpl_writeTok_rettype tmp11;
          Tpl_writeStr_rettype tmp12;
          modelica_metatype tmp13;
          Tpl_writeTok_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_pushBlock_rettype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          Tpl_pushIter_rettype tmp21;
          SimCodeC_lm__302_rettype tmp22;
          Tpl_popIter_rettype tmp23;
          Tpl_softNewLine_rettype tmp24;
          Tpl_popBlock_rettype tmp25;
          modelica_metatype tmp26;
          Tpl_writeTok_rettype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          SimCodeC_dotPath_rettype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          SimCodeC_underscorePath_rettype tmp35;
          listLength_rettype tmp36;
          Tpl_textString_rettype tmp37;
          Tpl_textString_rettype tmp38;
          SimCodeC_recordDefinitionHeader_rettype tmp39;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,3) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = mmc_unbox_string(tmp6);
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_name = tmp7;
          _i_defPath = tmp8;
          _i_variables = tmp9;
          tmp10 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("struct "));
          tmp11 = _Tpl_writeTok(_txt, tmp10);
          _txt = tmp11.Tpl_writeTok_rettype_1;
          tmp12 = _Tpl_writeStr(_txt, _i_name);
          _txt = tmp12.Tpl_writeStr_rettype_1;
          tmp13 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(" {\n"));
          tmp14 = _Tpl_writeTok(_txt, tmp13);
          _txt = tmp14.Tpl_writeTok_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp16 = _Tpl_pushBlock(_txt, tmp15);
          _txt = tmp16.Tpl_pushBlock_rettype_1;
          tmp17 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp18 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp19 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp20 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp17), mmc_mk_integer(0), mmc_mk_integer(0), tmp18, mmc_mk_integer(0), tmp19);
          tmp21 = _Tpl_pushIter(_txt, tmp20);
          _txt = tmp21.Tpl_pushIter_rettype_1;
          tmp22 = _SimCodeC_lm__302(_txt, _i_variables);
          _txt = tmp22.SimCodeC_lm__302_rettype_1;
          tmp23 = _Tpl_popIter(_txt);
          _txt = tmp23.Tpl_popIter_rettype_1;
          tmp24 = _Tpl_softNewLine(_txt);
          _txt = tmp24.Tpl_softNewLine_rettype_1;
          tmp25 = _Tpl_popBlock(_txt);
          _txt = tmp25.Tpl_popBlock_rettype_1;
          tmp26 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("};\n"));
          tmp27 = _Tpl_writeTok(_txt, tmp26);
          _txt = tmp27.Tpl_writeTok_rettype_1;
          tmp28 = mmc_mk_nil();
          tmp29 = mmc_mk_nil();
          tmp30 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp28, tmp29);
          tmp31 = _SimCodeC_dotPath(tmp30, _i_defPath);
          _txt_0 = tmp31.SimCodeC_dotPath_rettype_1;
          tmp32 = mmc_mk_nil();
          tmp33 = mmc_mk_nil();
          tmp34 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp32, tmp33);
          tmp35 = _SimCodeC_underscorePath(tmp34, _i_defPath);
          _txt_1 = tmp35.SimCodeC_underscorePath_rettype_1;
          tmp36 = listLength(_i_variables);
          _ret_2 = tmp36;
          tmp37 = _Tpl_textString(_txt_0);
          tmp38 = _Tpl_textString(_txt_1);
          tmp39 = _SimCodeC_recordDefinitionHeader(_txt, tmp37.Tpl_textString_rettype_1, tmp38.Tpl_textString_rettype_1, (modelica_integer)_ret_2);
          _txt = tmp39.SimCodeC_recordDefinitionHeader_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          SimCodeC_dotPath_rettype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          SimCodeC_underscorePath_rettype tmp49;
          listLength_rettype tmp50;
          Tpl_textString_rettype tmp51;
          Tpl_textString_rettype tmp52;
          SimCodeC_recordDefinitionHeader_rettype tmp53;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,2) == 0) MMC_THROW();
          tmp40 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp41 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_path = tmp40;
          _i_fieldNames = tmp41;
          tmp42 = mmc_mk_nil();
          tmp43 = mmc_mk_nil();
          tmp44 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp42, tmp43);
          tmp45 = _SimCodeC_dotPath(tmp44, _i_path);
          _txt_3 = tmp45.SimCodeC_dotPath_rettype_1;
          tmp46 = mmc_mk_nil();
          tmp47 = mmc_mk_nil();
          tmp48 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp46, tmp47);
          tmp49 = _SimCodeC_underscorePath(tmp48, _i_path);
          _txt_4 = tmp49.SimCodeC_underscorePath_rettype_1;
          tmp50 = listLength(_i_fieldNames);
          _ret_5 = tmp50;
          tmp51 = _Tpl_textString(_txt_3);
          tmp52 = _Tpl_textString(_txt_4);
          tmp53 = _SimCodeC_recordDefinitionHeader(_txt, tmp51.Tpl_textString_rettype_1, tmp52.Tpl_textString_rettype_1, (modelica_integer)_ret_5);
          _txt = tmp53.SimCodeC_recordDefinitionHeader_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 2: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_recordDeclarationHeader_rettypeboxed boxptr_SimCodeC_recordDeclarationHeader(modelica_metatype _in_txt, modelica_metatype _in_a_recDecl)
{
  SimCodeC_recordDeclarationHeader_rettypeboxed tmp1;
  SimCodeC_recordDeclarationHeader_rettype tmp2;
  tmp2 = _SimCodeC_recordDeclarationHeader(_in_txt, _in_a_recDecl);
  tmp1.SimCodeC_recordDeclarationHeader_rettypeboxed_1 = tmp2.SimCodeC_recordDeclarationHeader_rettype_1;
  return tmp1;
}
SimCodeC_recordDefinitionHeader_rettype _SimCodeC_recordDefinitionHeader(modelica_metatype _txt, modelica_string _a_origName, modelica_string _a_encName, modelica_integer _a_numFields)
{
  SimCodeC_recordDefinitionHeader_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;
  Tpl_writeTok_rettype tmp3;
  Tpl_writeStr_rettype tmp4;
  modelica_metatype tmp5;
  Tpl_writeTok_rettype tmp6;


  tmp2 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("extern struct record_description "));
  tmp3 = _Tpl_writeTok(_txt, tmp2);
  _out_txt = tmp3.Tpl_writeTok_rettype_1;
  tmp4 = _Tpl_writeStr(_out_txt, _a_encName);
  _out_txt = tmp4.Tpl_writeStr_rettype_1;
  tmp5 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("__desc;"));
  tmp6 = _Tpl_writeTok(_out_txt, tmp5);
  _out_txt = tmp6.Tpl_writeTok_rettype_1;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_recordDefinitionHeader_rettypeboxed boxptr_SimCodeC_recordDefinitionHeader(modelica_metatype _txt, modelica_metatype _a_origName, modelica_metatype _a_encName, modelica_metatype _a_numFields)
{
  SimCodeC_recordDefinitionHeader_rettypeboxed tmp1;
  SimCodeC_recordDefinitionHeader_rettype tmp2;
  modelica_string tmp3;
  modelica_string tmp4;
  modelica_integer tmp5;
  tmp3 = mmc_unbox_string(_a_origName);
  tmp4 = mmc_unbox_string(_a_encName);
  tmp5 = mmc_unbox_integer(_a_numFields);
  tmp2 = _SimCodeC_recordDefinitionHeader(_txt, tmp3, tmp4, tmp5);
  tmp1.SimCodeC_recordDefinitionHeader_rettypeboxed_1 = tmp2.SimCodeC_recordDefinitionHeader_rettype_1;
  return tmp1;
}
SimCodeC_daeExpMetaHelperConstant_rettype _SimCodeC_daeExpMetaHelperConstant(modelica_metatype _txt, modelica_metatype _a_e, modelica_metatype _a_context, modelica_metatype _a_preExp, modelica_metatype _a_varDecls)
{
  SimCodeC_daeExpMetaHelperConstant_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _ret_1;
  modelica_metatype _l_expPart;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  SimCodeC_daeExp_rettype tmp5;
  Expression_typeof_rettype tmp6;
  SimCodeC_daeExpMetaHelperConstantNameType_rettype tmp7;


  tmp2 = mmc_mk_nil();
  tmp3 = mmc_mk_nil();
  tmp4 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp2, tmp3);
  tmp5 = _SimCodeC_daeExp(tmp4, _a_e, _a_context, _a_preExp, _a_varDecls);
  _l_expPart = tmp5.targ1;
  _out_a_preExp = tmp5.targ2;
  _out_a_varDecls = tmp5.targ3;
  tmp6 = _Expression_typeof(_a_e);
  _ret_1 = tmp6.Expression_typeof_rettype_1;
  tmp7 = _SimCodeC_daeExpMetaHelperConstantNameType(_txt, _l_expPart, _ret_1, _out_a_preExp, _out_a_varDecls);
  _out_txt = tmp7.targ1;
  _l_expPart = tmp7.targ2;
  _out_a_preExp = tmp7.targ3;
  _out_a_varDecls = tmp7.targ4;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExpMetaHelperConstant_rettypeboxed boxptr_SimCodeC_daeExpMetaHelperConstant(modelica_metatype _txt, modelica_metatype _a_e, modelica_metatype _a_context, modelica_metatype _a_preExp, modelica_metatype _a_varDecls)
{
  SimCodeC_daeExpMetaHelperConstant_rettypeboxed tmp1;
  SimCodeC_daeExpMetaHelperConstant_rettype tmp2;
  tmp2 = _SimCodeC_daeExpMetaHelperConstant(_txt, _a_e, _a_context, _a_preExp, _a_varDecls);
  tmp1.SimCodeC_daeExpMetaHelperConstant_rettypeboxed_1 = tmp2.SimCodeC_daeExpMetaHelperConstant_rettype_1;
  tmp1.SimCodeC_daeExpMetaHelperConstant_rettypeboxed_2 = tmp2.SimCodeC_daeExpMetaHelperConstant_rettype_2;
  tmp1.SimCodeC_daeExpMetaHelperConstant_rettypeboxed_3 = tmp2.SimCodeC_daeExpMetaHelperConstant_rettype_3;
  return tmp1;
}
SimCodeC_daeExpMetaHelperConstantNameType_rettype _SimCodeC_daeExpMetaHelperConstantNameType(modelica_metatype _txt, modelica_metatype _a_varname, modelica_metatype _a_type, modelica_metatype _a_preExp, modelica_metatype _a_varDecls)
{
  SimCodeC_daeExpMetaHelperConstantNameType_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varname;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  SimCodeC_fun__678_rettype tmp2;


  tmp2 = _SimCodeC_fun__678(_txt, _a_type, _a_varname, _a_preExp, _a_varDecls);
  _out_txt = tmp2.targ1;
  _out_a_preExp = tmp2.targ2;
  _out_a_varDecls = tmp2.targ3;
  _out_a_varname = _a_varname;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varname;
  tmp1.targ3 = _out_a_preExp;
  tmp1.targ4 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExpMetaHelperConstantNameType_rettypeboxed boxptr_SimCodeC_daeExpMetaHelperConstantNameType(modelica_metatype _txt, modelica_metatype _a_varname, modelica_metatype _a_type, modelica_metatype _a_preExp, modelica_metatype _a_varDecls)
{
  SimCodeC_daeExpMetaHelperConstantNameType_rettypeboxed tmp1;
  SimCodeC_daeExpMetaHelperConstantNameType_rettype tmp2;
  tmp2 = _SimCodeC_daeExpMetaHelperConstantNameType(_txt, _a_varname, _a_type, _a_preExp, _a_varDecls);
  tmp1.SimCodeC_daeExpMetaHelperConstantNameType_rettypeboxed_1 = tmp2.SimCodeC_daeExpMetaHelperConstantNameType_rettype_1;
  tmp1.SimCodeC_daeExpMetaHelperConstantNameType_rettypeboxed_2 = tmp2.SimCodeC_daeExpMetaHelperConstantNameType_rettype_2;
  tmp1.SimCodeC_daeExpMetaHelperConstantNameType_rettypeboxed_3 = tmp2.SimCodeC_daeExpMetaHelperConstantNameType_rettype_3;
  tmp1.SimCodeC_daeExpMetaHelperConstantNameType_rettypeboxed_4 = tmp2.SimCodeC_daeExpMetaHelperConstantNameType_rettype_4;
  return tmp1;
}
SimCodeC_fun__678_rettype _SimCodeC_fun__678(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_metatype _in_a_varname, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__678_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_type;
    tmp3_in2 = _in_a_varname;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varname;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_cname;
      modelica_metatype _i_varLst;
      modelica_metatype _l_args;
      modelica_integer _ret_2;
      modelica_integer _ret_1;
      modelica_metatype _l_start;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 7 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          Tpl_writeText_rettype tmp8;
          modelica_metatype tmp9;
          Tpl_writeTok_rettype tmp10;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varname = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_icon("));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = _Tpl_writeText(_txt, _a_varname);
          _txt = tmp8.Tpl_writeText_rettype_1;
          tmp9 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp10 = _Tpl_writeTok(_txt, tmp9);
          _txt = tmp10.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp11;
          Tpl_writeTok_rettype tmp12;
          Tpl_writeText_rettype tmp13;
          modelica_metatype tmp14;
          Tpl_writeTok_rettype tmp15;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varname = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp11 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_icon("));
          tmp12 = _Tpl_writeTok(_txt, tmp11);
          _txt = tmp12.Tpl_writeTok_rettype_1;
          tmp13 = _Tpl_writeText(_txt, _a_varname);
          _txt = tmp13.Tpl_writeText_rettype_1;
          tmp14 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp15 = _Tpl_writeTok(_txt, tmp14);
          _txt = tmp15.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          Tpl_writeText_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varname = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_rcon("));
          tmp17 = _Tpl_writeTok(_txt, tmp16);
          _txt = tmp17.Tpl_writeTok_rettype_1;
          tmp18 = _Tpl_writeText(_txt, _a_varname);
          _txt = tmp18.Tpl_writeText_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp20 = _Tpl_writeTok(_txt, tmp19);
          _txt = tmp20.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          Tpl_writeText_rettype tmp23;
          modelica_metatype tmp24;
          Tpl_writeTok_rettype tmp25;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,0) == 0) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varname = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_scon("));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp23 = _Tpl_writeText(_txt, _a_varname);
          _txt = tmp23.Tpl_writeText_rettype_1;
          tmp24 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp25 = _Tpl_writeTok(_txt, tmp24);
          _txt = tmp25.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          Tpl_writeTok_rettype tmp30;
          Tpl_writeText_rettype tmp31;
          modelica_metatype tmp32;
          Tpl_writeTok_rettype tmp33;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,4,3) == 0) MMC_THROW();
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varname = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp29 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_icon("));
          tmp30 = _Tpl_writeTok(_txt, tmp29);
          _txt = tmp30.Tpl_writeTok_rettype_1;
          tmp31 = _Tpl_writeText(_txt, _a_varname);
          _txt = tmp31.Tpl_writeText_rettype_1;
          tmp32 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp33 = _Tpl_writeTok(_txt, tmp32);
          _txt = tmp33.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          listLength_rettype tmp37;
          SimCode_incrementInt_rettype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          SimCodeC_daeExpMetaHelperBoxStart_rettype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          SimCodeC_fun__677_rettype tmp46;
          modelica_metatype tmp47;
          Tpl_writeTok_rettype tmp48;
          Tpl_writeText_rettype tmp49;
          modelica_metatype tmp50;
          Tpl_writeTok_rettype tmp51;
          SimCodeC_underscorePath_rettype tmp52;
          modelica_metatype tmp53;
          Tpl_writeTok_rettype tmp54;
          Tpl_writeText_rettype tmp55;
          modelica_metatype tmp56;
          Tpl_writeTok_rettype tmp57;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,3) == 0) MMC_THROW();
          tmp34 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp36 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_cname = tmp34;
          _i_varLst = tmp35;
          _a_varname = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp37 = listLength(_i_varLst);
          _ret_1 = tmp37;
          tmp38 = _SimCode_incrementInt((modelica_integer)_ret_1, 1);
          _ret_2 = tmp38.SimCode_incrementInt_rettype_1;
          tmp39 = mmc_mk_nil();
          tmp40 = mmc_mk_nil();
          tmp41 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp39, tmp40);
          tmp42 = _SimCodeC_daeExpMetaHelperBoxStart(tmp41, (modelica_integer)_ret_2);
          _l_start = tmp42.SimCodeC_daeExpMetaHelperBoxStart_rettype_1;
          tmp43 = mmc_mk_nil();
          tmp44 = mmc_mk_nil();
          tmp45 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp43, tmp44);
          tmp46 = _SimCodeC_fun__677(tmp45, _i_varLst, _a_varDecls, _a_preExp, _a_varname);
          _l_args = tmp46.targ1;
          _a_varDecls = tmp46.targ2;
          _a_preExp = tmp46.targ3;
          tmp47 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_box"));
          tmp48 = _Tpl_writeTok(_txt, tmp47);
          _txt = tmp48.Tpl_writeTok_rettype_1;
          tmp49 = _Tpl_writeText(_txt, _l_start);
          _txt = tmp49.Tpl_writeText_rettype_1;
          tmp50 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("2, &"));
          tmp51 = _Tpl_writeTok(_txt, tmp50);
          _txt = tmp51.Tpl_writeTok_rettype_1;
          tmp52 = _SimCodeC_underscorePath(_txt, _i_cname);
          _txt = tmp52.SimCodeC_underscorePath_rettype_1;
          tmp53 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("__desc"));
          tmp54 = _Tpl_writeTok(_txt, tmp53);
          _txt = tmp54.Tpl_writeTok_rettype_1;
          tmp55 = _Tpl_writeText(_txt, _l_args);
          _txt = tmp55.Tpl_writeText_rettype_1;
          tmp56 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp57 = _Tpl_writeTok(_txt, tmp56);
          _txt = tmp57.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 6: {
          Tpl_writeText_rettype tmp58;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varname = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp58 = _Tpl_writeText(_txt, _a_varname);
          _txt = tmp58.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_fun__678_rettypeboxed boxptr_SimCodeC_fun__678(modelica_metatype _in_txt, modelica_metatype _in_a_type, modelica_metatype _in_a_varname, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_fun__678_rettypeboxed tmp1;
  SimCodeC_fun__678_rettype tmp2;
  tmp2 = _SimCodeC_fun__678(_in_txt, _in_a_type, _in_a_varname, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_fun__678_rettypeboxed_1 = tmp2.SimCodeC_fun__678_rettype_1;
  tmp1.SimCodeC_fun__678_rettypeboxed_2 = tmp2.SimCodeC_fun__678_rettype_2;
  tmp1.SimCodeC_fun__678_rettypeboxed_3 = tmp2.SimCodeC_fun__678_rettype_3;
  return tmp1;
}
SimCodeC_fun__677_rettype _SimCodeC_fun__677(modelica_metatype _in_txt, modelica_metatype _in_a_varLst, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varname)
{
  SimCodeC_fun__677_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_varLst;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varname;
    {
      modelica_metatype _txt;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varname;
      modelica_metatype _i_varLst;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_pushIter_rettype tmp12;
          SimCodeC_lm__676_rettype tmp13;
          Tpl_popIter_rettype tmp14;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_varLst = tmp3_in1;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varname = tmp3_in4;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(", "));
          tmp9 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp10 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp11 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp8), mmc_mk_integer(0), mmc_mk_integer(0), tmp9, mmc_mk_integer(0), tmp10);
          tmp12 = _Tpl_pushIter(_txt, tmp11);
          _txt = tmp12.Tpl_pushIter_rettype_1;
          tmp13 = _SimCodeC_lm__676(_txt, _i_varLst, _a_varDecls, _a_preExp, _a_varname);
          _txt = tmp13.targ1;
          _a_varDecls = tmp13.targ2;
          _a_preExp = tmp13.targ3;
          tmp14 = _Tpl_popIter(_txt);
          _txt = tmp14.Tpl_popIter_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_fun__677_rettypeboxed boxptr_SimCodeC_fun__677(modelica_metatype _in_txt, modelica_metatype _in_a_varLst, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varname)
{
  SimCodeC_fun__677_rettypeboxed tmp1;
  SimCodeC_fun__677_rettype tmp2;
  tmp2 = _SimCodeC_fun__677(_in_txt, _in_a_varLst, _in_a_varDecls, _in_a_preExp, _in_a_varname);
  tmp1.SimCodeC_fun__677_rettypeboxed_1 = tmp2.SimCodeC_fun__677_rettype_1;
  tmp1.SimCodeC_fun__677_rettypeboxed_2 = tmp2.SimCodeC_fun__677_rettype_2;
  tmp1.SimCodeC_fun__677_rettypeboxed_3 = tmp2.SimCodeC_fun__677_rettype_3;
  return tmp1;
}
SimCodeC_lm__676_rettype _SimCodeC_lm__676(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varname)
{
  SimCodeC_lm__676_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_preExp;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_varDecls;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varname;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_varDecls;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varname;
      modelica_metatype _i_tp;
      modelica_string _i_cvname;
      modelica_metatype _l_nameText;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_string tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          Tpl_writeText_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          Tpl_writeStr_rettype tmp17;
          SimCodeC_daeExpMetaHelperConstantNameType_rettype tmp18;
          Tpl_nextIter_rettype tmp19;
          SimCodeC_lm__676_rettype tmp20;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,2) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = mmc_unbox_string(tmp8);
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_cvname = tmp9;
          _i_tp = tmp10;
          _rest = tmp7;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varname = tmp3_in4;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          tmp14 = _Tpl_writeText(tmp13, _a_varname);
          _l_nameText = tmp14.Tpl_writeText_rettype_1;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("."));
          tmp16 = _Tpl_writeTok(_l_nameText, tmp15);
          _l_nameText = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = _Tpl_writeStr(_l_nameText, _i_cvname);
          _l_nameText = tmp17.Tpl_writeStr_rettype_1;
          tmp18 = _SimCodeC_daeExpMetaHelperConstantNameType(_txt, _l_nameText, _i_tp, _a_preExp, _a_varDecls);
          _txt = tmp18.targ1;
          _l_nameText = tmp18.targ2;
          _a_preExp = tmp18.targ3;
          _a_varDecls = tmp18.targ4;
          tmp19 = _Tpl_nextIter(_txt);
          _txt = tmp19.Tpl_nextIter_rettype_1;
          tmp20 = _SimCodeC_lm__676(_txt, _rest, _a_varDecls, _a_preExp, _a_varname);
          _txt = tmp20.targ1;
          _a_varDecls = tmp20.targ2;
          _a_preExp = tmp20.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          SimCodeC_lm__676_rettype tmp23;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp21 = MMC_CAR(tmp3_in1);
          tmp22 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp22;
          _a_varDecls = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varname = tmp3_in4;
          tmp23 = _SimCodeC_lm__676(_txt, _rest, _a_varDecls, _a_preExp, _a_varname);
          _txt = tmp23.targ1;
          _a_varDecls = tmp23.targ2;
          _a_preExp = tmp23.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_varDecls;
          tmp2_targ3 = _a_preExp;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_varDecls = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_varDecls;
  tmp1.targ3 = _out_a_preExp;
  return tmp1;
}


SimCodeC_lm__676_rettypeboxed boxptr_SimCodeC_lm__676(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varname)
{
  SimCodeC_lm__676_rettypeboxed tmp1;
  SimCodeC_lm__676_rettype tmp2;
  tmp2 = _SimCodeC_lm__676(_in_txt, _in_items, _in_a_varDecls, _in_a_preExp, _in_a_varname);
  tmp1.SimCodeC_lm__676_rettypeboxed_1 = tmp2.SimCodeC_lm__676_rettype_1;
  tmp1.SimCodeC_lm__676_rettypeboxed_2 = tmp2.SimCodeC_lm__676_rettype_2;
  tmp1.SimCodeC_lm__676_rettypeboxed_3 = tmp2.SimCodeC_lm__676_rettype_3;
  return tmp1;
}
Expression_typeof_rettype _Expression_typeof(modelica_metatype _inExp)
{
  Expression_typeof_rettype tmp1;
  modelica_metatype _outType;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    tmp3_in0 = _inExp;
    {
      modelica_metatype _tp;
      modelica_metatype _op;
      modelica_metatype _e1;
      modelica_metatype _e2;
      modelica_metatype _e3;
      modelica_metatype _e;
      modelica_metatype _explist;
      modelica_metatype _tylist;
      modelica_metatype _p;
      modelica_string _msg;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 33 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,0,1) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          tmp7 = mmc_mk_box1(3, &DAE_ExpType_ET__INT__desc);
          tmp2 = tmp7;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,1,1) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          tmp9 = mmc_mk_box1(4, &DAE_ExpType_ET__REAL__desc);
          tmp2 = tmp9;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,2,1) == 0) MMC_THROW();
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          tmp11 = mmc_mk_box1(6, &DAE_ExpType_ET__STRING__desc);
          tmp2 = tmp11;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,3,1) == 0) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          tmp13 = mmc_mk_box1(5, &DAE_ExpType_ET__BOOL__desc);
          tmp2 = tmp13;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,4,2) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _p = tmp14;
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_box4(7, &DAE_ExpType_ET__ENUMERATION__desc, _p, tmp16, tmp17);
          tmp2 = tmp18;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,5,2) == 0) MMC_THROW();
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _tp = tmp20;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 6: {
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          Expression_typeofOp_rettype tmp24;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,6,3) == 0) MMC_THROW();
          tmp21 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp22 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp23 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _op = tmp22;
          tmp24 = _Expression_typeofOp(_op);
          tmp2 = tmp24.Expression_typeofOp_rettype_1;
          tmp5 = 1;
          break;
        }
        case 7: {
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          Expression_typeofOp_rettype tmp27;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,7,2) == 0) MMC_THROW();
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _op = tmp25;
          tmp27 = _Expression_typeofOp(_op);
          tmp2 = tmp27.Expression_typeofOp_rettype_1;
          tmp5 = 1;
          break;
        }
        case 8: {
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          Expression_typeofOp_rettype tmp31;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,8,3) == 0) MMC_THROW();
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _op = tmp29;
          tmp31 = _Expression_typeofOp(_op);
          tmp2 = tmp31.Expression_typeofOp_rettype_1;
          tmp5 = 1;
          break;
        }
        case 9: {
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          Expression_typeofOp_rettype tmp34;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,9,2) == 0) MMC_THROW();
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _op = tmp32;
          tmp34 = _Expression_typeofOp(_op);
          tmp2 = tmp34.Expression_typeofOp_rettype_1;
          tmp5 = 1;
          break;
        }
        case 10: {
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          Expression_typeofOp_rettype tmp38;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,10,3) == 0) MMC_THROW();
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp36 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp37 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _op = tmp36;
          tmp38 = _Expression_typeofOp(_op);
          tmp2 = tmp38.Expression_typeofOp_rettype_1;
          tmp5 = 1;
          break;
        }
        case 11: {
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          Expression_typeof_rettype tmp42;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,11,3) == 0) MMC_THROW();
          tmp39 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp40 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp41 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _e1 = tmp39;
          _e2 = tmp40;
          _e3 = tmp41;
          tmp42 = _Expression_typeof(_e2);
          tmp2 = tmp42.Expression_typeof_rettype_1;
          tmp5 = 1;
          break;
        }
        case 12: {
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,12,6) == 0) MMC_THROW();
          tmp43 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp44 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp45 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          tmp46 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 5));
          tmp47 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 6));
          tmp48 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 7));
          /* Pattern matching succeeded */
          _tp = tmp47;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 13: {
          modelica_metatype tmp49;
          modelica_metatype tmp50;
          modelica_metatype tmp51;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,13,3) == 0) MMC_THROW();
          tmp49 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp50 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp51 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _tp = tmp51;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 14: {
          modelica_metatype tmp52;
          modelica_metatype tmp53;
          modelica_metatype tmp54;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,14,3) == 0) MMC_THROW();
          tmp52 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp53 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp54 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _tp = tmp52;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 15: {
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          modelica_metatype tmp57;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,15,3) == 0) MMC_THROW();
          tmp55 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp56 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp57 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _tp = tmp55;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 16: {
          modelica_metatype tmp58;
          modelica_metatype tmp59;
          modelica_metatype tmp60;
          modelica_metatype tmp61;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,16,4) == 0) MMC_THROW();
          tmp58 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp59 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp60 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          tmp61 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 5));
          /* Pattern matching succeeded */
          _tp = tmp58;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 17: {
          modelica_metatype tmp62;
          modelica_metatype tmp63;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,18,2) == 0) MMC_THROW();
          tmp62 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp63 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _tp = tmp62;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 18: {
          modelica_metatype tmp64;
          modelica_metatype tmp65;
          Util_listMap_rettype tmp66;
          Expression_typeof_rettype tmp67;
          Expression_unliftArrayTypeWithSubs_rettype tmp68;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,19,2) == 0) MMC_THROW();
          tmp64 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp65 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _e = tmp64;
          _explist = tmp65;
          tmp66 = _Util_listMap(_explist, ((modelica_fnptr)boxptr_Expression_makeIndexSubscript));
          tmp67 = _Expression_typeof(_e);
          tmp68 = _Expression_unliftArrayTypeWithSubs(tmp66.Util_listMap_rettype_1, tmp67.Expression_typeof_rettype_1);
          _tp = tmp68.Expression_unliftArrayTypeWithSubs_rettype_1;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 19: {
          modelica_metatype tmp69;
          modelica_metatype tmp70;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,21,2) == 0) MMC_THROW();
          tmp69 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp70 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _tp = tmp70;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 20: {
          modelica_metatype tmp71;
          modelica_metatype tmp72;
          modelica_metatype tmp73;
          modelica_metatype tmp74;
          Expression_typeof_rettype tmp75;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,22,4) == 0) MMC_THROW();
          tmp71 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp72 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp73 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          tmp74 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 5));
          /* Pattern matching succeeded */
          _e = tmp72;
          tmp75 = _Expression_typeof(_e);
          tmp2 = tmp75.Expression_typeof_rettype_1;
          tmp5 = 1;
          break;
        }
        case 21: {
          modelica_metatype tmp76;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,23,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          tmp76 = mmc_mk_box1(9, &DAE_ExpType_ET__OTHER__desc);
          tmp2 = tmp76;
          tmp5 = 1;
          break;
        }
        case 22: {
          modelica_metatype tmp77;
          modelica_metatype tmp78;
          modelica_metatype tmp79;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,20,2) == 0) MMC_THROW();
          tmp77 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp78 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          if (!optionNone(tmp78)) MMC_THROW();
          /* Pattern matching succeeded */
          tmp79 = mmc_mk_box1(3, &DAE_ExpType_ET__INT__desc);
          tmp2 = tmp79;
          tmp5 = 1;
          break;
        }
        case 23: {
          modelica_metatype tmp80;
          modelica_metatype tmp81;
          modelica_metatype tmp82;
          modelica_metatype tmp83;
          modelica_metatype tmp84;
          modelica_metatype tmp85;
          modelica_metatype tmp86;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,20,2) == 0) MMC_THROW();
          tmp80 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp81 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          if (optionNone(tmp81)) MMC_THROW();
          tmp82 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp81), 1));
          /* Pattern matching succeeded */
          tmp83 = mmc_mk_box1(3, &DAE_ExpType_ET__INT__desc);
          tmp85 = mmc_mk_box1(6, &DAE_Dimension_DIM__UNKNOWN__desc);
          tmp84 = mmc_mk_cons(tmp85, mmc_mk_nil());
          tmp86 = mmc_mk_box3(10, &DAE_ExpType_ET__ARRAY__desc, tmp83, tmp84);
          tmp2 = tmp86;
          tmp5 = 1;
          break;
        }
        case 24: {
          modelica_metatype tmp87;
          modelica_metatype tmp88;
          modelica_metatype tmp89;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,24,2) == 0) MMC_THROW();
          tmp87 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp88 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _tp = tmp87;
          tmp89 = mmc_mk_box1(16, &DAE_ExpType_ET__METATYPE__desc);
          tmp2 = tmp89;
          tmp5 = 1;
          break;
        }
        case 25: {
          modelica_metatype tmp90;
          modelica_metatype tmp91;
          modelica_metatype tmp92;
          modelica_metatype tmp93;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,25,3) == 0) MMC_THROW();
          tmp90 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp91 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp92 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          /* Pattern matching succeeded */
          _tp = tmp90;
          tmp93 = mmc_mk_box1(16, &DAE_ExpType_ET__METATYPE__desc);
          tmp2 = tmp93;
          tmp5 = 1;
          break;
        }
        case 26: {
          modelica_metatype tmp94;
          Util_listMap_rettype tmp95;
          modelica_metatype tmp96;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,26,1) == 0) MMC_THROW();
          tmp94 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _explist = tmp94;
          tmp95 = _Util_listMap(_explist, ((modelica_fnptr)boxptr_Expression_typeof));
          _tylist = tmp95.Util_listMap_rettype_1;
          tmp96 = mmc_mk_box1(16, &DAE_ExpType_ET__METATYPE__desc);
          tmp2 = tmp96;
          tmp5 = 1;
          break;
        }
        case 27: {
          modelica_metatype tmp97;
          modelica_metatype tmp98;
          Expression_typeof_rettype tmp99;
          modelica_metatype tmp100;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,27,1) == 0) MMC_THROW();
          tmp97 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          if (optionNone(tmp97)) MMC_THROW();
          tmp98 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp97), 1));
          /* Pattern matching succeeded */
          _e = tmp98;
          tmp99 = _Expression_typeof(_e);
          _tp = tmp99.Expression_typeof_rettype_1;
          tmp100 = mmc_mk_box1(16, &DAE_ExpType_ET__METATYPE__desc);
          tmp2 = tmp100;
          tmp5 = 1;
          break;
        }
        case 28: {
          modelica_metatype tmp101;
          modelica_metatype tmp102;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,27,1) == 0) MMC_THROW();
          tmp101 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          if (!optionNone(tmp101)) MMC_THROW();
          /* Pattern matching succeeded */
          tmp102 = mmc_mk_box1(16, &DAE_ExpType_ET__METATYPE__desc);
          tmp2 = tmp102;
          tmp5 = 1;
          break;
        }
        case 29: {
          modelica_metatype tmp103;
          modelica_metatype tmp104;
          modelica_metatype tmp105;
          modelica_metatype tmp106;
          modelica_metatype tmp107;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,28,4) == 0) MMC_THROW();
          tmp103 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp104 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          tmp105 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 4));
          tmp106 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 5));
          /* Pattern matching succeeded */
          tmp107 = mmc_mk_box1(16, &DAE_ExpType_ET__METATYPE__desc);
          tmp2 = tmp107;
          tmp5 = 1;
          break;
        }
        case 30: {
          modelica_metatype tmp108;
          modelica_metatype tmp109;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,30,1) == 0) MMC_THROW();
          tmp108 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          tmp109 = mmc_mk_box1(16, &DAE_ExpType_ET__METATYPE__desc);
          tmp2 = tmp109;
          tmp5 = 1;
          break;
        }
        case 31: {
          modelica_metatype tmp110;
          modelica_metatype tmp111;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,31,2) == 0) MMC_THROW();
          tmp110 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          tmp111 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 3));
          /* Pattern matching succeeded */
          _tp = tmp111;
          tmp2 = _tp;
          tmp5 = 1;
          break;
        }
        case 32: {
          ExpressionDump_printExpStr_rettype tmp112;
          modelica_string tmp113;
          modelica_metatype tmp114;
          
          /* Pattern matching succeeded */
          _e = tmp3_in0;
          tmp112 = _ExpressionDump_printExpStr(_e);
          tmp113 = stringAppend("- Expression.typeof failed for ",tmp112.ExpressionDump_printExpStr_rettype_1);
          _msg = tmp113;
          tmp114 = mmc_mk_cons(mmc_mk_scon(_msg), mmc_mk_nil());
          _Error_addMessage(63, tmp114);
          /* NORETCALL */;
          MMC_THROW();
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _outType = tmp2;
  
  _return:
  tmp1.targ1 = _outType;
  return tmp1;
}


Expression_typeof_rettypeboxed boxptr_Expression_typeof(modelica_metatype _inExp)
{
  Expression_typeof_rettypeboxed tmp1;
  Expression_typeof_rettype tmp2;
  tmp2 = _Expression_typeof(_inExp);
  tmp1.Expression_typeof_rettypeboxed_1 = tmp2.Expression_typeof_rettype_1;
  return tmp1;
}
Expression_typeofOp_rettype _Expression_typeofOp(modelica_metatype _inOperator)
{
  Expression_typeofOp_rettype tmp1;
  modelica_metatype _outType;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    tmp3_in0 = _inOperator;
    {
      modelica_metatype _t;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 37 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,0,1) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp6;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp7;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,1,1) == 0) MMC_THROW();
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp7;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp8;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,2,1) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp8;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp9;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,3,1) == 0) MMC_THROW();
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp9;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp10;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,4,1) == 0) MMC_THROW();
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp10;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp11;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,5,1) == 0) MMC_THROW();
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp11;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 6: {
          modelica_metatype tmp12;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,6,1) == 0) MMC_THROW();
          tmp12 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp12;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 7: {
          modelica_metatype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,7,1) == 0) MMC_THROW();
          tmp13 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp13;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 8: {
          modelica_metatype tmp14;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,8,1) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp14;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 9: {
          modelica_metatype tmp15;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,9,1) == 0) MMC_THROW();
          tmp15 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp15;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 10: {
          modelica_metatype tmp16;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,10,1) == 0) MMC_THROW();
          tmp16 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp16;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 11: {
          modelica_metatype tmp17;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,11,1) == 0) MMC_THROW();
          tmp17 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp17;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 12: {
          modelica_metatype tmp18;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,12,1) == 0) MMC_THROW();
          tmp18 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp18;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 13: {
          modelica_metatype tmp19;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,13,1) == 0) MMC_THROW();
          tmp19 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp19;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 14: {
          modelica_metatype tmp20;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,14,1) == 0) MMC_THROW();
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp20;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 15: {
          modelica_metatype tmp21;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,15,1) == 0) MMC_THROW();
          tmp21 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp21;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 16: {
          modelica_metatype tmp22;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,16,1) == 0) MMC_THROW();
          tmp22 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp22;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 17: {
          modelica_metatype tmp23;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,17,1) == 0) MMC_THROW();
          tmp23 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp23;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 18: {
          modelica_metatype tmp24;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,18,1) == 0) MMC_THROW();
          tmp24 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp24;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 19: {
          modelica_metatype tmp25;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,19,1) == 0) MMC_THROW();
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp25;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 20: {
          modelica_metatype tmp26;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,20,1) == 0) MMC_THROW();
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp26;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 21: {
          modelica_metatype tmp27;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,21,1) == 0) MMC_THROW();
          tmp27 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp27;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 22: {
          modelica_metatype tmp28;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,22,1) == 0) MMC_THROW();
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp28;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 23: {
          modelica_metatype tmp29;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,23,1) == 0) MMC_THROW();
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp29;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 24: {
          modelica_metatype tmp30;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,24,1) == 0) MMC_THROW();
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp30;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 25: {
          modelica_metatype tmp31;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,25,1) == 0) MMC_THROW();
          tmp31 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp31;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 26: {
          modelica_metatype tmp32;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,26,1) == 0) MMC_THROW();
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp32;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 27: {
          modelica_metatype tmp33;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,27,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          tmp33 = mmc_mk_box1(5, &DAE_ExpType_ET__BOOL__desc);
          tmp2 = tmp33;
          tmp5 = 1;
          break;
        }
        case 28: {
          modelica_metatype tmp34;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,28,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          tmp34 = mmc_mk_box1(5, &DAE_ExpType_ET__BOOL__desc);
          tmp2 = tmp34;
          tmp5 = 1;
          break;
        }
        case 29: {
          modelica_metatype tmp35;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,29,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          tmp35 = mmc_mk_box1(5, &DAE_ExpType_ET__BOOL__desc);
          tmp2 = tmp35;
          tmp5 = 1;
          break;
        }
        case 30: {
          modelica_metatype tmp36;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,30,1) == 0) MMC_THROW();
          tmp36 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp36;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 31: {
          modelica_metatype tmp37;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,31,1) == 0) MMC_THROW();
          tmp37 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp37;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 32: {
          modelica_metatype tmp38;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,32,1) == 0) MMC_THROW();
          tmp38 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp38;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 33: {
          modelica_metatype tmp39;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,33,1) == 0) MMC_THROW();
          tmp39 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp39;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 34: {
          modelica_metatype tmp40;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,34,1) == 0) MMC_THROW();
          tmp40 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp40;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 35: {
          modelica_metatype tmp41;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,35,1) == 0) MMC_THROW();
          tmp41 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          _t = tmp41;
          tmp2 = _t;
          tmp5 = 1;
          break;
        }
        case 36: {
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in0,36,1) == 0) MMC_THROW();
          tmp42 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in0), 2));
          /* Pattern matching succeeded */
          tmp43 = mmc_mk_box1(9, &DAE_ExpType_ET__OTHER__desc);
          tmp2 = tmp43;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _outType = tmp2;
  
  _return:
  tmp1.targ1 = _outType;
  return tmp1;
}


Expression_typeofOp_rettypeboxed boxptr_Expression_typeofOp(modelica_metatype _inOperator)
{
  Expression_typeofOp_rettypeboxed tmp1;
  Expression_typeofOp_rettype tmp2;
  tmp2 = _Expression_typeofOp(_inOperator);
  tmp1.Expression_typeofOp_rettypeboxed_1 = tmp2.Expression_typeofOp_rettype_1;
  return tmp1;
}
SimCodeC_daeExp_rettype _SimCodeC_daeExp(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExp_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_exp;
    tmp3_in2 = _in_a_context;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_context;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_exp;
      modelica_metatype _i_e;
      modelica_integer _i_index;
      modelica_boolean _i_bool;
      modelica_string _i_string;
      modelica_real _i_real;
      modelica_integer _i_integer;
      modelica_string _ret_0;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 28 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_integer tmp7;
          intString_rettype tmp8;
          Tpl_writeStr_rettype tmp9;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,0,1) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = mmc_unbox_integer(tmp6);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_integer = tmp7;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp8 = intString((modelica_integer)_i_integer);
          tmp9 = _Tpl_writeStr(_txt, tmp8);
          _txt = tmp9.Tpl_writeStr_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp10;
          modelica_real tmp11;
          realString_rettype tmp12;
          Tpl_writeStr_rettype tmp13;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,1) == 0) MMC_THROW();
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp11 = mmc_unbox_real(tmp10);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_real = tmp11;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp12 = realString(_i_real);
          tmp13 = _Tpl_writeStr(_txt, tmp12);
          _txt = tmp13.Tpl_writeStr_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp14;
          modelica_string tmp15;
          SimCodeC_daeExpSconst_rettype tmp16;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,2,1) == 0) MMC_THROW();
          tmp14 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp15 = mmc_unbox_string(tmp14);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_string = tmp15;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp16 = _SimCodeC_daeExpSconst(_txt, _i_string, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp16.targ1;
          _a_preExp = tmp16.targ2;
          _a_varDecls = tmp16.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 3: {
          modelica_metatype tmp17;
          modelica_integer tmp18;
          SimCodeC_fun__563_rettype tmp19;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,3,1) == 0) MMC_THROW();
          tmp17 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp18 = mmc_unbox_integer(tmp17);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_bool = tmp18;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp19 = _SimCodeC_fun__563(_txt, _i_bool);
          _txt = tmp19.SimCodeC_fun__563_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 4: {
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_integer tmp22;
          intString_rettype tmp23;
          Tpl_writeStr_rettype tmp24;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,4,2) == 0) MMC_THROW();
          tmp20 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp21 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp22 = mmc_unbox_integer(tmp21);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_index = tmp22;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp23 = intString((modelica_integer)_i_index);
          tmp24 = _Tpl_writeStr(_txt, tmp23);
          _txt = tmp24.Tpl_writeStr_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 5: {
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          SimCodeC_daeExpCrefRhs_rettype tmp27;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,5,2) == 0) MMC_THROW();
          tmp25 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp26 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp27 = _SimCodeC_daeExpCrefRhs(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp27.targ1;
          _a_preExp = tmp27.targ2;
          _a_varDecls = tmp27.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 6: {
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          SimCodeC_daeExpBinary_rettype tmp31;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,6,3) == 0) MMC_THROW();
          tmp28 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp29 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp30 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp31 = _SimCodeC_daeExpBinary(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp31.targ1;
          _a_preExp = tmp31.targ2;
          _a_varDecls = tmp31.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 7: {
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          SimCodeC_daeExpUnary_rettype tmp34;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,7,2) == 0) MMC_THROW();
          tmp32 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp33 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp34 = _SimCodeC_daeExpUnary(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp34.targ1;
          _a_preExp = tmp34.targ2;
          _a_varDecls = tmp34.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 8: {
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          SimCodeC_daeExpLbinary_rettype tmp38;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,8,3) == 0) MMC_THROW();
          tmp35 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp36 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp37 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp38 = _SimCodeC_daeExpLbinary(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp38.targ1;
          _a_preExp = tmp38.targ2;
          _a_varDecls = tmp38.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 9: {
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          SimCodeC_daeExpLunary_rettype tmp41;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,9,2) == 0) MMC_THROW();
          tmp39 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp40 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp41 = _SimCodeC_daeExpLunary(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp41.targ1;
          _a_preExp = tmp41.targ2;
          _a_varDecls = tmp41.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 10: {
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          SimCodeC_daeExpRelation_rettype tmp45;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,10,3) == 0) MMC_THROW();
          tmp42 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp43 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp44 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp45 = _SimCodeC_daeExpRelation(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp45.targ1;
          _a_preExp = tmp45.targ2;
          _a_varDecls = tmp45.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 11: {
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          SimCodeC_daeExpIf_rettype tmp49;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,11,3) == 0) MMC_THROW();
          tmp46 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp47 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp48 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp49 = _SimCodeC_daeExpIf(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp49.targ1;
          _a_preExp = tmp49.targ2;
          _a_varDecls = tmp49.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 12: {
          modelica_metatype tmp50;
          modelica_metatype tmp51;
          modelica_metatype tmp52;
          modelica_metatype tmp53;
          modelica_metatype tmp54;
          modelica_metatype tmp55;
          SimCodeC_daeExpCall_rettype tmp56;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,12,6) == 0) MMC_THROW();
          tmp50 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp51 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp52 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp53 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp54 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          tmp55 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 7));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp56 = _SimCodeC_daeExpCall(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp56.targ1;
          _a_preExp = tmp56.targ2;
          _a_varDecls = tmp56.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 13: {
          modelica_metatype tmp57;
          modelica_metatype tmp58;
          modelica_metatype tmp59;
          SimCodeC_daeExpArray_rettype tmp60;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,14,3) == 0) MMC_THROW();
          tmp57 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp58 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp59 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp60 = _SimCodeC_daeExpArray(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp60.targ1;
          _a_preExp = tmp60.targ2;
          _a_varDecls = tmp60.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 14: {
          modelica_metatype tmp61;
          modelica_metatype tmp62;
          modelica_metatype tmp63;
          SimCodeC_daeExpMatrix_rettype tmp64;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,15,3) == 0) MMC_THROW();
          tmp61 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp62 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp63 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp64 = _SimCodeC_daeExpMatrix(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp64.targ1;
          _a_preExp = tmp64.targ2;
          _a_varDecls = tmp64.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 15: {
          modelica_metatype tmp65;
          modelica_metatype tmp66;
          SimCodeC_daeExpCast_rettype tmp67;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,18,2) == 0) MMC_THROW();
          tmp65 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp66 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp67 = _SimCodeC_daeExpCast(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp67.targ1;
          _a_preExp = tmp67.targ2;
          _a_varDecls = tmp67.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 16: {
          modelica_metatype tmp68;
          modelica_metatype tmp69;
          SimCodeC_daeExpAsub_rettype tmp70;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,19,2) == 0) MMC_THROW();
          tmp68 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp69 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp70 = _SimCodeC_daeExpAsub(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp70.targ1;
          _a_preExp = tmp70.targ2;
          _a_varDecls = tmp70.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 17: {
          modelica_metatype tmp71;
          modelica_metatype tmp72;
          SimCodeC_daeExpSize_rettype tmp73;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,20,2) == 0) MMC_THROW();
          tmp71 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp72 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp73 = _SimCodeC_daeExpSize(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp73.targ1;
          _a_preExp = tmp73.targ2;
          _a_varDecls = tmp73.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 18: {
          modelica_metatype tmp74;
          modelica_metatype tmp75;
          modelica_metatype tmp76;
          modelica_metatype tmp77;
          SimCodeC_daeExpReduction_rettype tmp78;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,22,4) == 0) MMC_THROW();
          tmp74 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp75 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp76 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp77 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp78 = _SimCodeC_daeExpReduction(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp78.targ1;
          _a_preExp = tmp78.targ2;
          _a_varDecls = tmp78.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 19: {
          modelica_metatype tmp79;
          modelica_metatype tmp80;
          SimCodeC_daeExpList_rettype tmp81;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,24,2) == 0) MMC_THROW();
          tmp79 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp80 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp81 = _SimCodeC_daeExpList(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp81.targ1;
          _a_preExp = tmp81.targ2;
          _a_varDecls = tmp81.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 20: {
          modelica_metatype tmp82;
          modelica_metatype tmp83;
          modelica_metatype tmp84;
          SimCodeC_daeExpCons_rettype tmp85;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,25,3) == 0) MMC_THROW();
          tmp82 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp83 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp84 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp85 = _SimCodeC_daeExpCons(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp85.targ1;
          _a_preExp = tmp85.targ2;
          _a_varDecls = tmp85.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 21: {
          modelica_metatype tmp86;
          SimCodeC_daeExpMetaTuple_rettype tmp87;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,26,1) == 0) MMC_THROW();
          tmp86 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp87 = _SimCodeC_daeExpMetaTuple(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp87.targ1;
          _a_preExp = tmp87.targ2;
          _a_varDecls = tmp87.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 22: {
          modelica_metatype tmp88;
          SimCodeC_daeExpMetaOption_rettype tmp89;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,27,1) == 0) MMC_THROW();
          tmp88 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp89 = _SimCodeC_daeExpMetaOption(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp89.targ1;
          _a_preExp = tmp89.targ2;
          _a_varDecls = tmp89.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 23: {
          modelica_metatype tmp90;
          modelica_metatype tmp91;
          modelica_metatype tmp92;
          modelica_metatype tmp93;
          SimCodeC_daeExpMetarecordcall_rettype tmp94;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,28,4) == 0) MMC_THROW();
          tmp90 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp91 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp92 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp93 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp94 = _SimCodeC_daeExpMetarecordcall(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp94.targ1;
          _a_preExp = tmp94.targ2;
          _a_varDecls = tmp94.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 24: {
          modelica_metatype tmp95;
          modelica_metatype tmp96;
          modelica_metatype tmp97;
          modelica_metatype tmp98;
          modelica_metatype tmp99;
          SimCodeC_daeExpMatch_rettype tmp100;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,29,5) == 0) MMC_THROW();
          tmp95 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp96 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp97 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp98 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp99 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp100 = _SimCodeC_daeExpMatch(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp100.targ1;
          _a_preExp = tmp100.targ2;
          _a_varDecls = tmp100.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 25: {
          modelica_metatype tmp101;
          SimCodeC_daeExpBox_rettype tmp102;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,30,1) == 0) MMC_THROW();
          tmp101 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp102 = _SimCodeC_daeExpBox(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp102.targ1;
          _a_preExp = tmp102.targ2;
          _a_varDecls = tmp102.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 26: {
          modelica_metatype tmp103;
          modelica_metatype tmp104;
          SimCodeC_daeExpUnbox_rettype tmp105;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,31,2) == 0) MMC_THROW();
          tmp103 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp104 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_e = tmp3_in1;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp105 = _SimCodeC_daeExpUnbox(_txt, _i_e, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp105.targ1;
          _a_preExp = tmp105.targ2;
          _a_varDecls = tmp105.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 27: {
          modelica_metatype tmp106;
          Tpl_writeTok_rettype tmp107;
          modelica_metatype tmp108;
          Tpl_writeTok_rettype tmp109;
          ExpressionDump_printExpStr_rettype tmp110;
          Tpl_writeStr_rettype tmp111;
          modelica_metatype tmp112;
          Tpl_writeTok_rettype tmp113;
          modelica_metatype tmp114;
          Tpl_writeTok_rettype tmp115;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp = tmp3_in1;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp106 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp107 = _Tpl_writeTok(_txt, tmp106);
          _txt = tmp107.Tpl_writeTok_rettype_1;
          tmp108 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("#error \"UNKNOWN_EXP "));
          tmp109 = _Tpl_writeTok(_txt, tmp108);
          _txt = tmp109.Tpl_writeTok_rettype_1;
          tmp110 = _ExpressionDump_printExpStr(_i_exp);
          _ret_0 = tmp110.ExpressionDump_printExpStr_rettype_1;
          tmp111 = _Tpl_writeStr(_txt, _ret_0);
          _txt = tmp111.Tpl_writeStr_rettype_1;
          tmp112 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("\""));
          tmp113 = _Tpl_writeTok(_txt, tmp112);
          _txt = tmp113.Tpl_writeTok_rettype_1;
          tmp114 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp115 = _Tpl_writeTok(_txt, tmp114);
          _txt = tmp115.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExp_rettypeboxed boxptr_SimCodeC_daeExp(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExp_rettypeboxed tmp1;
  SimCodeC_daeExp_rettype tmp2;
  tmp2 = _SimCodeC_daeExp(_in_txt, _in_a_exp, _in_a_context, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_daeExp_rettypeboxed_1 = tmp2.SimCodeC_daeExp_rettype_1;
  tmp1.SimCodeC_daeExp_rettypeboxed_2 = tmp2.SimCodeC_daeExp_rettype_2;
  tmp1.SimCodeC_daeExp_rettypeboxed_3 = tmp2.SimCodeC_daeExp_rettype_3;
  return tmp1;
}
SimCodeC_daeExpUnbox_rettype _SimCodeC_daeExpUnbox(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpUnbox_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_exp;
    tmp3_in2 = _in_a_context;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_context;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_exp_exp;
      modelica_metatype _i_exp_ty;
      modelica_metatype _l_res;
      modelica_metatype _l_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          SimCodeC_expTypeShort_rettype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          SimCodeC_daeExp_rettype tmp15;
          modelica_metatype tmp16;
          Tpl_writeTok_rettype tmp17;
          Tpl_writeText_rettype tmp18;
          modelica_metatype tmp19;
          Tpl_writeTok_rettype tmp20;
          Tpl_writeText_rettype tmp21;
          modelica_metatype tmp22;
          Tpl_writeTok_rettype tmp23;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,31,2) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp_exp = tmp6;
          _i_exp_ty = tmp7;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp8 = mmc_mk_nil();
          tmp9 = mmc_mk_nil();
          tmp10 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp8, tmp9);
          tmp11 = _SimCodeC_expTypeShort(tmp10, _i_exp_ty);
          _l_ty = tmp11.SimCodeC_expTypeShort_rettype_1;
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp12, tmp13);
          tmp15 = _SimCodeC_daeExp(tmp14, _i_exp_exp, _a_context, _a_preExp, _a_varDecls);
          _l_res = tmp15.targ1;
          _a_preExp = tmp15.targ2;
          _a_varDecls = tmp15.targ3;
          tmp16 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_unbox_"));
          tmp17 = _Tpl_writeTok(_txt, tmp16);
          _txt = tmp17.Tpl_writeTok_rettype_1;
          tmp18 = _Tpl_writeText(_txt, _l_ty);
          _txt = tmp18.Tpl_writeText_rettype_1;
          tmp19 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp20 = _Tpl_writeTok(_txt, tmp19);
          _txt = tmp20.Tpl_writeTok_rettype_1;
          tmp21 = _Tpl_writeText(_txt, _l_res);
          _txt = tmp21.Tpl_writeText_rettype_1;
          tmp22 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp23 = _Tpl_writeTok(_txt, tmp22);
          _txt = tmp23.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExpUnbox_rettypeboxed boxptr_SimCodeC_daeExpUnbox(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpUnbox_rettypeboxed tmp1;
  SimCodeC_daeExpUnbox_rettype tmp2;
  tmp2 = _SimCodeC_daeExpUnbox(_in_txt, _in_a_exp, _in_a_context, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_daeExpUnbox_rettypeboxed_1 = tmp2.SimCodeC_daeExpUnbox_rettype_1;
  tmp1.SimCodeC_daeExpUnbox_rettypeboxed_2 = tmp2.SimCodeC_daeExpUnbox_rettype_2;
  tmp1.SimCodeC_daeExpUnbox_rettypeboxed_3 = tmp2.SimCodeC_daeExpUnbox_rettype_3;
  return tmp1;
}
SimCodeC_daeExpBox_rettype _SimCodeC_daeExpBox(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpBox_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_exp;
    tmp3_in2 = _in_a_context;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_context;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_exp_exp;
      modelica_metatype _l_res;
      modelica_metatype _l_ty;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          SimCodeC_expTypeFromExpShort_rettype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_daeExp_rettype tmp14;
          modelica_metatype tmp15;
          Tpl_writeTok_rettype tmp16;
          Tpl_writeText_rettype tmp17;
          modelica_metatype tmp18;
          Tpl_writeTok_rettype tmp19;
          Tpl_writeText_rettype tmp20;
          modelica_metatype tmp21;
          Tpl_writeTok_rettype tmp22;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,30,1) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp_exp = tmp6;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp7 = mmc_mk_nil();
          tmp8 = mmc_mk_nil();
          tmp9 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp7, tmp8);
          tmp10 = _SimCodeC_expTypeFromExpShort(tmp9, _i_exp_exp);
          _l_ty = tmp10.SimCodeC_expTypeFromExpShort_rettype_1;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          tmp14 = _SimCodeC_daeExp(tmp13, _i_exp_exp, _a_context, _a_preExp, _a_varDecls);
          _l_res = tmp14.targ1;
          _a_preExp = tmp14.targ2;
          _a_varDecls = tmp14.targ3;
          tmp15 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("mmc_mk_"));
          tmp16 = _Tpl_writeTok(_txt, tmp15);
          _txt = tmp16.Tpl_writeTok_rettype_1;
          tmp17 = _Tpl_writeText(_txt, _l_ty);
          _txt = tmp17.Tpl_writeText_rettype_1;
          tmp18 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("("));
          tmp19 = _Tpl_writeTok(_txt, tmp18);
          _txt = tmp19.Tpl_writeTok_rettype_1;
          tmp20 = _Tpl_writeText(_txt, _l_res);
          _txt = tmp20.Tpl_writeText_rettype_1;
          tmp21 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(")"));
          tmp22 = _Tpl_writeTok(_txt, tmp21);
          _txt = tmp22.Tpl_writeTok_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExpBox_rettypeboxed boxptr_SimCodeC_daeExpBox(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpBox_rettypeboxed tmp1;
  SimCodeC_daeExpBox_rettype tmp2;
  tmp2 = _SimCodeC_daeExpBox(_in_txt, _in_a_exp, _in_a_context, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_daeExpBox_rettypeboxed_1 = tmp2.SimCodeC_daeExpBox_rettype_1;
  tmp1.SimCodeC_daeExpBox_rettypeboxed_2 = tmp2.SimCodeC_daeExpBox_rettype_2;
  tmp1.SimCodeC_daeExpBox_rettypeboxed_3 = tmp2.SimCodeC_daeExpBox_rettype_3;
  return tmp1;
}
SimCodeC_daeExpMatch_rettype _SimCodeC_daeExpMatch(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpMatch_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_exp;
    tmp3_in2 = _in_a_context;
    tmp3_in3 = _in_a_preExp;
    tmp3_in4 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_context;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_exp;
      modelica_metatype _i_et;
      modelica_metatype _l_res;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          SimCodeC_fun__643_rettype tmp14;
          SimCodeC_daeExpMatch2_rettype tmp15;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,29,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp = tmp3_in1;
          _i_et = tmp10;
          _a_context = tmp3_in2;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          tmp14 = _SimCodeC_fun__643(tmp13, _i_et, _a_varDecls);
          _l_res = tmp14.targ1;
          _a_varDecls = tmp14.targ2;
          tmp15 = _SimCodeC_daeExpMatch2(_txt, _i_exp, _l_res, _a_context, _a_preExp, _a_varDecls);
          _txt = tmp15.targ1;
          _l_res = tmp15.targ2;
          _a_preExp = tmp15.targ3;
          _a_varDecls = tmp15.targ4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExp = tmp3_in3;
          _a_varDecls = tmp3_in4;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExp;
          tmp2_targ3 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExp = tmp2_targ2;
  _out_a_varDecls = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExp;
  tmp1.targ3 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExpMatch_rettypeboxed boxptr_SimCodeC_daeExpMatch(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpMatch_rettypeboxed tmp1;
  SimCodeC_daeExpMatch_rettype tmp2;
  tmp2 = _SimCodeC_daeExpMatch(_in_txt, _in_a_exp, _in_a_context, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_daeExpMatch_rettypeboxed_1 = tmp2.SimCodeC_daeExpMatch_rettype_1;
  tmp1.SimCodeC_daeExpMatch_rettypeboxed_2 = tmp2.SimCodeC_daeExpMatch_rettype_2;
  tmp1.SimCodeC_daeExpMatch_rettypeboxed_3 = tmp2.SimCodeC_daeExpMatch_rettype_3;
  return tmp1;
}
SimCodeC_daeExpMatch2_rettype _SimCodeC_daeExpMatch2(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_res, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpMatch2_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_res;
  modelica_metatype _out_a_preExp;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;
  modelica_metatype tmp2_targ4;


  
  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_exp;
    tmp3_in2 = _in_a_res;
    tmp3_in3 = _in_a_context;
    tmp3_in4 = _in_a_preExp;
    tmp3_in5 = _in_a_varDecls;
    {
      modelica_metatype _txt;
      modelica_metatype _a_res;
      modelica_metatype _a_context;
      modelica_metatype _a_preExp;
      modelica_metatype _a_varDecls;
      modelica_metatype _i_cases;
      modelica_metatype _i_exp_matchType;
      modelica_metatype _i_inputs;
      modelica_metatype _i_localDecls;
      modelica_integer _ret_15;
      modelica_metatype _l_onPatternFail;
      modelica_metatype _l_done;
      modelica_metatype _l_ix;
      modelica_metatype _l_ignore3;
      modelica_metatype _l_expInput;
      modelica_metatype _l_preExpInput;
      modelica_integer _ret_8;
      modelica_metatype _l_prefix;
      modelica_metatype _ret_6;
      modelica_metatype _l_ignore2;
      modelica_metatype _l_ignore;
      modelica_metatype _l_varDeclsInner;
      modelica_metatype _l_varDeclsInput;
      modelica_metatype _l_preExpRes;
      modelica_metatype _l_preExpInner;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          modelica_metatype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          SimCode_elementVars_rettype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          SimCodeC_lm__645_rettype tmp30;
          modelica_metatype tmp31;
          modelica_metatype tmp32;
          modelica_metatype tmp33;
          modelica_metatype tmp34;
          Tpl_writeTok_rettype tmp35;
          System_tmpTick_rettype tmp36;
          intString_rettype tmp37;
          Tpl_writeStr_rettype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          modelica_metatype tmp42;
          modelica_metatype tmp43;
          modelica_metatype tmp44;
          modelica_metatype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          modelica_metatype tmp48;
          modelica_metatype tmp49;
          modelica_metatype tmp50;
          modelica_metatype tmp51;
          Tpl_pushIter_rettype tmp52;
          SimCodeC_lm__646_rettype tmp53;
          Tpl_popIter_rettype tmp54;
          modelica_metatype tmp55;
          modelica_metatype tmp56;
          modelica_metatype tmp57;
          SimCodeC_tempDecl_rettype tmp58;
          modelica_metatype tmp59;
          modelica_metatype tmp60;
          modelica_metatype tmp61;
          SimCodeC_tempDecl_rettype tmp62;
          modelica_metatype tmp63;
          modelica_metatype tmp64;
          modelica_metatype tmp65;
          SimCodeC_fun__647_rettype tmp66;
          modelica_metatype tmp67;
          Tpl_writeTok_rettype tmp68;
          SimCodeC_fun__648_rettype tmp69;
          modelica_metatype tmp70;
          Tpl_writeTok_rettype tmp71;
          modelica_metatype tmp72;
          Tpl_pushBlock_rettype tmp73;
          Tpl_writeText_rettype tmp74;
          Tpl_softNewLine_rettype tmp75;
          Tpl_writeText_rettype tmp76;
          Tpl_softNewLine_rettype tmp77;
          Tpl_writeText_rettype tmp78;
          Tpl_softNewLine_rettype tmp79;
          modelica_metatype tmp80;
          Tpl_writeTok_rettype tmp81;
          modelica_metatype tmp82;
          Tpl_pushBlock_rettype tmp83;
          Tpl_writeText_rettype tmp84;
          Tpl_softNewLine_rettype tmp85;
          Tpl_writeText_rettype tmp86;
          Tpl_softNewLine_rettype tmp87;
          modelica_metatype tmp88;
          Tpl_writeTok_rettype tmp89;
          Tpl_writeText_rettype tmp90;
          modelica_metatype tmp91;
          Tpl_writeTok_rettype tmp92;
          Tpl_writeText_rettype tmp93;
          modelica_metatype tmp94;
          Tpl_writeTok_rettype tmp95;
          Tpl_writeText_rettype tmp96;
          modelica_metatype tmp97;
          Tpl_writeTok_rettype tmp98;
          listLength_rettype tmp99;
          intString_rettype tmp100;
          Tpl_writeStr_rettype tmp101;
          modelica_metatype tmp102;
          Tpl_writeTok_rettype tmp103;
          Tpl_writeText_rettype tmp104;
          modelica_metatype tmp105;
          Tpl_writeTok_rettype tmp106;
          Tpl_writeText_rettype tmp107;
          modelica_metatype tmp108;
          Tpl_writeTok_rettype tmp109;
          modelica_metatype tmp110;
          Tpl_pushBlock_rettype tmp111;
          SimCodeC_fun__649_rettype tmp112;
          Tpl_softNewLine_rettype tmp113;
          modelica_metatype tmp114;
          Tpl_writeTok_rettype tmp115;
          Tpl_writeText_rettype tmp116;
          modelica_metatype tmp117;
          Tpl_writeTok_rettype tmp118;
          SimCodeC_daeExpMatchCases_rettype tmp119;
          Tpl_softNewLine_rettype tmp120;
          modelica_metatype tmp121;
          Tpl_writeTok_rettype tmp122;
          SimCodeC_fun__650_rettype tmp123;
          Tpl_softNewLine_rettype tmp124;
          Tpl_popBlock_rettype tmp125;
          modelica_metatype tmp126;
          modelica_metatype tmp127;
          Tpl_writeTok_rettype tmp128;
          Tpl_writeText_rettype tmp129;
          modelica_metatype tmp130;
          Tpl_writeTok_rettype tmp131;
          Tpl_popBlock_rettype tmp132;
          modelica_metatype tmp133;
          Tpl_writeTok_rettype tmp134;
          Tpl_popBlock_rettype tmp135;
          modelica_metatype tmp136;
          Tpl_writeTok_rettype tmp137;
          Tpl_writeText_rettype tmp138;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,29,5) == 0) MMC_THROW();
          tmp6 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 2));
          tmp7 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 3));
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 4));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 5));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp3_in1), 6));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_exp_matchType = tmp6;
          _i_inputs = tmp7;
          _i_localDecls = tmp8;
          _i_cases = tmp9;
          _a_res = tmp3_in2;
          _a_context = tmp3_in3;
          _a_preExp = tmp3_in4;
          _a_varDecls = tmp3_in5;
          tmp11 = mmc_mk_nil();
          tmp12 = mmc_mk_nil();
          tmp13 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp11, tmp12);
          _l_preExpInner = tmp13;
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_nil();
          tmp16 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp14, tmp15);
          _l_preExpRes = tmp16;
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_nil();
          tmp19 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp17, tmp18);
          _l_varDeclsInput = tmp19;
          tmp20 = mmc_mk_nil();
          tmp21 = mmc_mk_nil();
          tmp22 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp20, tmp21);
          _l_varDeclsInner = tmp22;
          tmp23 = mmc_mk_nil();
          tmp24 = mmc_mk_nil();
          tmp25 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp23, tmp24);
          _l_ignore = tmp25;
          tmp26 = _SimCode_elementVars(_i_localDecls);
          _ret_6 = tmp26.SimCode_elementVars_rettype_1;
          tmp27 = mmc_mk_nil();
          tmp28 = mmc_mk_nil();
          tmp29 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp27, tmp28);
          tmp30 = _SimCodeC_lm__645(tmp29, _ret_6, _l_preExpInner, _l_varDeclsInner);
          _l_ignore2 = tmp30.targ1;
          _l_preExpInner = tmp30.targ2;
          _l_varDeclsInner = tmp30.targ3;
          tmp31 = mmc_mk_nil();
          tmp32 = mmc_mk_nil();
          tmp33 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp31, tmp32);
          tmp34 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("tmp"));
          tmp35 = _Tpl_writeTok(tmp33, tmp34);
          _l_prefix = tmp35.Tpl_writeTok_rettype_1;
          tmp36 = _System_tmpTick();
          _ret_8 = tmp36.System_tmpTick_rettype_1;
          tmp37 = intString((modelica_integer)_ret_8);
          tmp38 = _Tpl_writeStr(_l_prefix, tmp37);
          _l_prefix = tmp38.Tpl_writeStr_rettype_1;
          tmp39 = mmc_mk_nil();
          tmp40 = mmc_mk_nil();
          tmp41 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp39, tmp40);
          _l_preExpInput = tmp41;
          tmp42 = mmc_mk_nil();
          tmp43 = mmc_mk_nil();
          tmp44 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp42, tmp43);
          _l_expInput = tmp44;
          tmp45 = mmc_mk_nil();
          tmp46 = mmc_mk_nil();
          tmp47 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp45, tmp46);
          tmp48 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(""));
          tmp49 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp50 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp51 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_some(tmp48), mmc_mk_none(), mmc_mk_integer(0), mmc_mk_integer(0), tmp49, mmc_mk_integer(0), tmp50);
          tmp52 = _Tpl_pushIter(tmp47, tmp51);
          _l_ignore3 = tmp52.Tpl_pushIter_rettype_1;
          tmp53 = _SimCodeC_lm__646(_l_ignore3, _i_inputs, _l_preExpInput, _a_context, _l_expInput, _l_varDeclsInput, _l_prefix);
          _l_ignore3 = tmp53.targ1;
          _l_preExpInput = tmp53.targ2;
          _l_expInput = tmp53.targ3;
          _l_varDeclsInput = tmp53.targ4;
          tmp54 = _Tpl_popIter(_l_ignore3);
          _l_ignore3 = tmp54.Tpl_popIter_rettype_1;
          tmp55 = mmc_mk_nil();
          tmp56 = mmc_mk_nil();
          tmp57 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp55, tmp56);
          tmp58 = _SimCodeC_tempDecl(tmp57, "int", _l_varDeclsInner);
          _l_ix = tmp58.targ1;
          _l_varDeclsInner = tmp58.targ2;
          tmp59 = mmc_mk_nil();
          tmp60 = mmc_mk_nil();
          tmp61 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp59, tmp60);
          tmp62 = _SimCodeC_tempDecl(tmp61, "int", _l_varDeclsInner);
          _l_done = tmp62.targ1;
          _l_varDeclsInner = tmp62.targ2;
          tmp63 = mmc_mk_nil();
          tmp64 = mmc_mk_nil();
          tmp65 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp63, tmp64);
          tmp66 = _SimCodeC_fun__647(tmp65, _i_exp_matchType);
          _l_onPatternFail = tmp66.SimCodeC_fun__647_rettype_1;
          tmp67 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("{ /* "));
          tmp68 = _Tpl_writeTok(_a_preExp, tmp67);
          _a_preExp = tmp68.Tpl_writeTok_rettype_1;
          tmp69 = _SimCodeC_fun__648(_a_preExp, _i_exp_matchType);
          _a_preExp = tmp69.SimCodeC_fun__648_rettype_1;
          tmp70 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(" */\n"));
          tmp71 = _Tpl_writeTok(_a_preExp, tmp70);
          _a_preExp = tmp71.Tpl_writeTok_rettype_1;
          tmp72 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp73 = _Tpl_pushBlock(_a_preExp, tmp72);
          _a_preExp = tmp73.Tpl_pushBlock_rettype_1;
          tmp74 = _Tpl_writeText(_a_preExp, _l_varDeclsInput);
          _a_preExp = tmp74.Tpl_writeText_rettype_1;
          tmp75 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp75.Tpl_softNewLine_rettype_1;
          tmp76 = _Tpl_writeText(_a_preExp, _l_preExpInput);
          _a_preExp = tmp76.Tpl_writeText_rettype_1;
          tmp77 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp77.Tpl_softNewLine_rettype_1;
          tmp78 = _Tpl_writeText(_a_preExp, _l_expInput);
          _a_preExp = tmp78.Tpl_writeText_rettype_1;
          tmp79 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp79.Tpl_softNewLine_rettype_1;
          tmp80 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("{\n"));
          tmp81 = _Tpl_writeTok(_a_preExp, tmp80);
          _a_preExp = tmp81.Tpl_writeTok_rettype_1;
          tmp82 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp83 = _Tpl_pushBlock(_a_preExp, tmp82);
          _a_preExp = tmp83.Tpl_pushBlock_rettype_1;
          tmp84 = _Tpl_writeText(_a_preExp, _l_varDeclsInner);
          _a_preExp = tmp84.Tpl_writeText_rettype_1;
          tmp85 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp85.Tpl_softNewLine_rettype_1;
          tmp86 = _Tpl_writeText(_a_preExp, _l_preExpInner);
          _a_preExp = tmp86.Tpl_writeText_rettype_1;
          tmp87 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp87.Tpl_softNewLine_rettype_1;
          tmp88 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("for ("));
          tmp89 = _Tpl_writeTok(_a_preExp, tmp88);
          _a_preExp = tmp89.Tpl_writeTok_rettype_1;
          tmp90 = _Tpl_writeText(_a_preExp, _l_ix);
          _a_preExp = tmp90.Tpl_writeText_rettype_1;
          tmp91 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = 0, "));
          tmp92 = _Tpl_writeTok(_a_preExp, tmp91);
          _a_preExp = tmp92.Tpl_writeTok_rettype_1;
          tmp93 = _Tpl_writeText(_a_preExp, _l_done);
          _a_preExp = tmp93.Tpl_writeText_rettype_1;
          tmp94 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" = 0; "));
          tmp95 = _Tpl_writeTok(_a_preExp, tmp94);
          _a_preExp = tmp95.Tpl_writeTok_rettype_1;
          tmp96 = _Tpl_writeText(_a_preExp, _l_ix);
          _a_preExp = tmp96.Tpl_writeText_rettype_1;
          tmp97 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" < "));
          tmp98 = _Tpl_writeTok(_a_preExp, tmp97);
          _a_preExp = tmp98.Tpl_writeTok_rettype_1;
          tmp99 = listLength(_i_cases);
          _ret_15 = tmp99;
          tmp100 = intString((modelica_integer)_ret_15);
          tmp101 = _Tpl_writeStr(_a_preExp, tmp100);
          _a_preExp = tmp101.Tpl_writeStr_rettype_1;
          tmp102 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(" && !"));
          tmp103 = _Tpl_writeTok(_a_preExp, tmp102);
          _a_preExp = tmp103.Tpl_writeTok_rettype_1;
          tmp104 = _Tpl_writeText(_a_preExp, _l_done);
          _a_preExp = tmp104.Tpl_writeText_rettype_1;
          tmp105 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("; "));
          tmp106 = _Tpl_writeTok(_a_preExp, tmp105);
          _a_preExp = tmp106.Tpl_writeTok_rettype_1;
          tmp107 = _Tpl_writeText(_a_preExp, _l_ix);
          _a_preExp = tmp107.Tpl_writeText_rettype_1;
          tmp108 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("++) {\n"));
          tmp109 = _Tpl_writeTok(_a_preExp, tmp108);
          _a_preExp = tmp109.Tpl_writeTok_rettype_1;
          tmp110 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp111 = _Tpl_pushBlock(_a_preExp, tmp110);
          _a_preExp = tmp111.Tpl_pushBlock_rettype_1;
          tmp112 = _SimCodeC_fun__649(_a_preExp, _i_exp_matchType);
          _a_preExp = tmp112.SimCodeC_fun__649_rettype_1;
          tmp113 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp113.Tpl_softNewLine_rettype_1;
          tmp114 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("switch ("));
          tmp115 = _Tpl_writeTok(_a_preExp, tmp114);
          _a_preExp = tmp115.Tpl_writeTok_rettype_1;
          tmp116 = _Tpl_writeText(_a_preExp, _l_ix);
          _a_preExp = tmp116.Tpl_writeText_rettype_1;
          tmp117 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(") {\n"));
          tmp118 = _Tpl_writeTok(_a_preExp, tmp117);
          _a_preExp = tmp118.Tpl_writeTok_rettype_1;
          tmp119 = _SimCodeC_daeExpMatchCases(_a_preExp, _i_cases, _a_res, _l_prefix, _l_onPatternFail, _l_done, _a_context, _a_varDecls);
          _a_preExp = tmp119.targ1;
          _a_res = tmp119.targ2;
          _l_prefix = tmp119.targ3;
          _l_onPatternFail = tmp119.targ4;
          _l_done = tmp119.targ5;
          _a_varDecls = tmp119.targ6;
          tmp120 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp120.Tpl_softNewLine_rettype_1;
          tmp121 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("}\n"));
          tmp122 = _Tpl_writeTok(_a_preExp, tmp121);
          _a_preExp = tmp122.Tpl_writeTok_rettype_1;
          tmp123 = _SimCodeC_fun__650(_a_preExp, _i_exp_matchType);
          _a_preExp = tmp123.SimCodeC_fun__650_rettype_1;
          tmp124 = _Tpl_softNewLine(_a_preExp);
          _a_preExp = tmp124.Tpl_softNewLine_rettype_1;
          tmp125 = _Tpl_popBlock(_a_preExp);
          _a_preExp = tmp125.Tpl_popBlock_rettype_1;
          tmp126 = mmc_mk_cons(mmc_mk_scon("}\n"), mmc_mk_cons(mmc_mk_scon("if (!"), mmc_mk_nil()));
          tmp127 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp126, mmc_mk_boolean((0)));
          tmp128 = _Tpl_writeTok(_a_preExp, tmp127);
          _a_preExp = tmp128.Tpl_writeTok_rettype_1;
          tmp129 = _Tpl_writeText(_a_preExp, _l_done);
          _a_preExp = tmp129.Tpl_writeText_rettype_1;
          tmp130 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(") MMC_THROW();\n"));
          tmp131 = _Tpl_writeTok(_a_preExp, tmp130);
          _a_preExp = tmp131.Tpl_writeTok_rettype_1;
          tmp132 = _Tpl_popBlock(_a_preExp);
          _a_preExp = tmp132.Tpl_popBlock_rettype_1;
          tmp133 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("}\n"));
          tmp134 = _Tpl_writeTok(_a_preExp, tmp133);
          _a_preExp = tmp134.Tpl_writeTok_rettype_1;
          tmp135 = _Tpl_popBlock(_a_preExp);
          _a_preExp = tmp135.Tpl_popBlock_rettype_1;
          tmp136 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("}"));
          tmp137 = _Tpl_writeTok(_a_preExp, tmp136);
          _a_preExp = tmp137.Tpl_writeTok_rettype_1;
          tmp138 = _Tpl_writeText(_txt, _a_res);
          _txt = tmp138.Tpl_writeText_rettype_1;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_res;
          tmp2_targ3 = _a_preExp;
          tmp2_targ4 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_res = tmp3_in2;
          _a_preExp = tmp3_in4;
          _a_varDecls = tmp3_in5;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_res;
          tmp2_targ3 = _a_preExp;
          tmp2_targ4 = _a_varDecls;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_res = tmp2_targ2;
  _out_a_preExp = tmp2_targ3;
  _out_a_varDecls = tmp2_targ4;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_res;
  tmp1.targ3 = _out_a_preExp;
  tmp1.targ4 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExpMatch2_rettypeboxed boxptr_SimCodeC_daeExpMatch2(modelica_metatype _in_txt, modelica_metatype _in_a_exp, modelica_metatype _in_a_res, modelica_metatype _in_a_context, modelica_metatype _in_a_preExp, modelica_metatype _in_a_varDecls)
{
  SimCodeC_daeExpMatch2_rettypeboxed tmp1;
  SimCodeC_daeExpMatch2_rettype tmp2;
  tmp2 = _SimCodeC_daeExpMatch2(_in_txt, _in_a_exp, _in_a_res, _in_a_context, _in_a_preExp, _in_a_varDecls);
  tmp1.SimCodeC_daeExpMatch2_rettypeboxed_1 = tmp2.SimCodeC_daeExpMatch2_rettype_1;
  tmp1.SimCodeC_daeExpMatch2_rettypeboxed_2 = tmp2.SimCodeC_daeExpMatch2_rettype_2;
  tmp1.SimCodeC_daeExpMatch2_rettypeboxed_3 = tmp2.SimCodeC_daeExpMatch2_rettype_3;
  tmp1.SimCodeC_daeExpMatch2_rettypeboxed_4 = tmp2.SimCodeC_daeExpMatch2_rettype_4;
  return tmp1;
}
SimCodeC_fun__650_rettype _SimCodeC_fun__650(modelica_metatype _in_txt, modelica_metatype _in_a_exp_matchType)
{
  SimCodeC_fun__650_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_exp_matchType;
    {
      modelica_metatype _txt;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          if (mmc__uniontype__metarecord__typedef__equal(tmp3_in1,1,0) == 0) MMC_THROW();
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("MMC_CATCH()"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__650_rettypeboxed boxptr_SimCodeC_fun__650(modelica_metatype _in_txt, modelica_metatype _in_a_exp_matchType)
{
  SimCodeC_fun__650_rettypeboxed tmp1;
  SimCodeC_fun__650_rettype tmp2;
  tmp2 = _SimCodeC_fun__650(_in_txt, _in_a_exp_matchType);
  tmp1.SimCodeC_fun__650_rettypeboxed_1 = tmp2.SimCodeC_fun__650_rettype_1;
  return tmp1;
}
SimCodeC_daeExpMatchCases_rettype _SimCodeC_daeExpMatchCases(modelica_metatype _txt, modelica_metatype _a_cases, modelica_metatype _a_res, modelica_metatype _a_prefix, modelica_metatype _a_onPatternFail, modelica_metatype _a_done, modelica_metatype _a_context, modelica_metatype _a_varDecls)
{
  SimCodeC_daeExpMatchCases_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_res;
  modelica_metatype _out_a_prefix;
  modelica_metatype _out_a_onPatternFail;
  modelica_metatype _out_a_done;
  modelica_metatype _out_a_varDecls;
  modelica_metatype tmp2;
  modelica_metatype tmp3;
  modelica_metatype tmp4;
  Tpl_pushIter_rettype tmp5;
  SimCodeC_lm__658_rettype tmp6;
  Tpl_popIter_rettype tmp7;


  tmp2 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp3 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
  tmp4 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_none(), mmc_mk_integer(0), mmc_mk_integer(0), tmp2, mmc_mk_integer(0), tmp3);
  tmp5 = _Tpl_pushIter(_txt, tmp4);
  _out_txt = tmp5.Tpl_pushIter_rettype_1;
  tmp6 = _SimCodeC_lm__658(_out_txt, _a_cases, _a_done, _a_res, _a_context, _a_onPatternFail, _a_prefix);
  _out_txt = tmp6.targ1;
  _out_a_onPatternFail = tmp6.targ2;
  tmp7 = _Tpl_popIter(_out_txt);
  _out_txt = tmp7.Tpl_popIter_rettype_1;
  _out_a_res = _a_res;
  _out_a_prefix = _a_prefix;
  _out_a_done = _a_done;
  _out_a_varDecls = _a_varDecls;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_res;
  tmp1.targ3 = _out_a_prefix;
  tmp1.targ4 = _out_a_onPatternFail;
  tmp1.targ5 = _out_a_done;
  tmp1.targ6 = _out_a_varDecls;
  return tmp1;
}


SimCodeC_daeExpMatchCases_rettypeboxed boxptr_SimCodeC_daeExpMatchCases(modelica_metatype _txt, modelica_metatype _a_cases, modelica_metatype _a_res, modelica_metatype _a_prefix, modelica_metatype _a_onPatternFail, modelica_metatype _a_done, modelica_metatype _a_context, modelica_metatype _a_varDecls)
{
  SimCodeC_daeExpMatchCases_rettypeboxed tmp1;
  SimCodeC_daeExpMatchCases_rettype tmp2;
  tmp2 = _SimCodeC_daeExpMatchCases(_txt, _a_cases, _a_res, _a_prefix, _a_onPatternFail, _a_done, _a_context, _a_varDecls);
  tmp1.SimCodeC_daeExpMatchCases_rettypeboxed_1 = tmp2.SimCodeC_daeExpMatchCases_rettype_1;
  tmp1.SimCodeC_daeExpMatchCases_rettypeboxed_2 = tmp2.SimCodeC_daeExpMatchCases_rettype_2;
  tmp1.SimCodeC_daeExpMatchCases_rettypeboxed_3 = tmp2.SimCodeC_daeExpMatchCases_rettype_3;
  tmp1.SimCodeC_daeExpMatchCases_rettypeboxed_4 = tmp2.SimCodeC_daeExpMatchCases_rettype_4;
  tmp1.SimCodeC_daeExpMatchCases_rettypeboxed_5 = tmp2.SimCodeC_daeExpMatchCases_rettype_5;
  tmp1.SimCodeC_daeExpMatchCases_rettypeboxed_6 = tmp2.SimCodeC_daeExpMatchCases_rettype_6;
  return tmp1;
}
SimCodeC_lm__658_rettype _SimCodeC_lm__658(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_done, modelica_metatype _in_a_res, modelica_metatype _in_a_context, modelica_metatype _in_a_onPatternFail, modelica_metatype _in_a_prefix)
{
  SimCodeC_lm__658_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_onPatternFail;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;


  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    modelica_metatype tmp3_in6;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_done;
    tmp3_in3 = _in_a_res;
    tmp3_in4 = _in_a_context;
    tmp3_in5 = _in_a_onPatternFail;
    tmp3_in6 = _in_a_prefix;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_done;
      modelica_metatype _a_res;
      modelica_metatype _a_context;
      modelica_metatype _a_onPatternFail;
      modelica_metatype _a_prefix;
      modelica_integer _x_i0;
      modelica_metatype _i_c_localDecls;
      modelica_metatype _i_c_result;
      modelica_metatype _i_c_body;
      modelica_metatype _i_c_patterns;
      modelica_metatype _ret_8;
      modelica_metatype _l_0__;
      modelica_metatype _l_caseRes;
      modelica_metatype _l_stmts;
      modelica_metatype _l_patternMatching;
      modelica_metatype _l_preRes;
      modelica_metatype _l_assignments;
      modelica_metatype _l_preExpCaseInner;
      modelica_metatype _l_varDeclsCaseInner;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_onPatternFail = tmp3_in5;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_onPatternFail;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          modelica_metatype tmp8;
          modelica_metatype tmp9;
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          Tpl_getIteri__i0_rettype tmp12;
          modelica_metatype tmp13;
          modelica_metatype tmp14;
          modelica_metatype tmp15;
          modelica_metatype tmp16;
          modelica_metatype tmp17;
          modelica_metatype tmp18;
          modelica_metatype tmp19;
          modelica_metatype tmp20;
          modelica_metatype tmp21;
          modelica_metatype tmp22;
          modelica_metatype tmp23;
          modelica_metatype tmp24;
          modelica_metatype tmp25;
          modelica_metatype tmp26;
          modelica_metatype tmp27;
          modelica_metatype tmp28;
          modelica_metatype tmp29;
          modelica_metatype tmp30;
          modelica_metatype tmp31;
          Tpl_pushIter_rettype tmp32;
          SimCodeC_lm__652_rettype tmp33;
          Tpl_popIter_rettype tmp34;
          modelica_metatype tmp35;
          modelica_metatype tmp36;
          modelica_metatype tmp37;
          modelica_metatype tmp38;
          modelica_metatype tmp39;
          modelica_metatype tmp40;
          modelica_metatype tmp41;
          Tpl_pushIter_rettype tmp42;
          SimCodeC_lm__653_rettype tmp43;
          Tpl_popIter_rettype tmp44;
          modelica_metatype tmp45;
          modelica_metatype tmp46;
          modelica_metatype tmp47;
          SimCodeC_fun__655_rettype tmp48;
          SimCode_elementVars_rettype tmp49;
          modelica_metatype tmp50;
          modelica_metatype tmp51;
          modelica_metatype tmp52;
          SimCodeC_lm__656_rettype tmp53;
          modelica_metatype tmp54;
          Tpl_writeTok_rettype tmp55;
          intString_rettype tmp56;
          Tpl_writeStr_rettype tmp57;
          modelica_metatype tmp58;
          Tpl_writeTok_rettype tmp59;
          modelica_metatype tmp60;
          Tpl_pushBlock_rettype tmp61;
          Tpl_writeText_rettype tmp62;
          Tpl_softNewLine_rettype tmp63;
          Tpl_writeText_rettype tmp64;
          Tpl_softNewLine_rettype tmp65;
          Tpl_writeText_rettype tmp66;
          Tpl_softNewLine_rettype tmp67;
          modelica_metatype tmp68;
          Tpl_writeTok_rettype tmp69;
          Tpl_writeText_rettype tmp70;
          Tpl_softNewLine_rettype tmp71;
          Tpl_writeText_rettype tmp72;
          Tpl_softNewLine_rettype tmp73;
          SimCodeC_fun__657_rettype tmp74;
          Tpl_softNewLine_rettype tmp75;
          Tpl_writeText_rettype tmp76;
          modelica_metatype tmp77;
          modelica_metatype tmp78;
          Tpl_writeTok_rettype tmp79;
          Tpl_popBlock_rettype tmp80;
          modelica_metatype tmp81;
          Tpl_writeTok_rettype tmp82;
          modelica_metatype tmp83;
          Tpl_writeTok_rettype tmp84;
          Tpl_nextIter_rettype tmp85;
          SimCodeC_lm__658_rettype tmp86;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          if (mmc__uniontype__metarecord__typedef__equal(tmp6,0,4) == 0) MMC_THROW();
          tmp8 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 2));
          tmp9 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 3));
          tmp10 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 4));
          tmp11 = MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR(tmp6), 5));
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_c_patterns = tmp8;
          _i_c_localDecls = tmp9;
          _i_c_body = tmp10;
          _i_c_result = tmp11;
          _rest = tmp7;
          _a_done = tmp3_in2;
          _a_res = tmp3_in3;
          _a_context = tmp3_in4;
          _a_onPatternFail = tmp3_in5;
          _a_prefix = tmp3_in6;
          tmp12 = _Tpl_getIteri__i0(_txt);
          _x_i0 = tmp12.Tpl_getIteri__i0_rettype_1;
          tmp13 = mmc_mk_nil();
          tmp14 = mmc_mk_nil();
          tmp15 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp13, tmp14);
          _l_varDeclsCaseInner = tmp15;
          tmp16 = mmc_mk_nil();
          tmp17 = mmc_mk_nil();
          tmp18 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp16, tmp17);
          _l_preExpCaseInner = tmp18;
          tmp19 = mmc_mk_nil();
          tmp20 = mmc_mk_nil();
          tmp21 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp19, tmp20);
          _l_assignments = tmp21;
          tmp22 = mmc_mk_nil();
          tmp23 = mmc_mk_nil();
          tmp24 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp22, tmp23);
          _l_preRes = tmp24;
          tmp25 = mmc_mk_nil();
          tmp26 = mmc_mk_nil();
          tmp27 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp25, tmp26);
          tmp28 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string(""));
          tmp29 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp30 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp31 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_some(tmp28), mmc_mk_none(), mmc_mk_integer(0), mmc_mk_integer(0), tmp29, mmc_mk_integer(0), tmp30);
          tmp32 = _Tpl_pushIter(tmp27, tmp31);
          _l_patternMatching = tmp32.Tpl_pushIter_rettype_1;
          tmp33 = _SimCodeC_lm__652(_l_patternMatching, _i_c_patterns, _l_assignments, _l_varDeclsCaseInner, _a_onPatternFail, _a_prefix);
          _l_patternMatching = tmp33.targ1;
          _l_assignments = tmp33.targ2;
          _l_varDeclsCaseInner = tmp33.targ3;
          _a_onPatternFail = tmp33.targ4;
          tmp34 = _Tpl_popIter(_l_patternMatching);
          _l_patternMatching = tmp34.Tpl_popIter_rettype_1;
          tmp35 = mmc_mk_nil();
          tmp36 = mmc_mk_nil();
          tmp37 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp35, tmp36);
          tmp38 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp39 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp40 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp41 = mmc_mk_box9(3, &Tpl_IterOptions_ITER__OPTIONS__desc, mmc_mk_integer(0), mmc_mk_none(), mmc_mk_some(tmp38), mmc_mk_integer(0), mmc_mk_integer(0), tmp39, mmc_mk_integer(0), tmp40);
          tmp42 = _Tpl_pushIter(tmp37, tmp41);
          _l_stmts = tmp42.Tpl_pushIter_rettype_1;
          tmp43 = _SimCodeC_lm__653(_l_stmts, _i_c_body, _l_varDeclsCaseInner, _a_context);
          _l_stmts = tmp43.targ1;
          _l_varDeclsCaseInner = tmp43.targ2;
          tmp44 = _Tpl_popIter(_l_stmts);
          _l_stmts = tmp44.Tpl_popIter_rettype_1;
          tmp45 = mmc_mk_nil();
          tmp46 = mmc_mk_nil();
          tmp47 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp45, tmp46);
          tmp48 = _SimCodeC_fun__655(tmp47, _i_c_result, _l_varDeclsCaseInner, _l_preRes, _a_context, _a_res);
          _l_caseRes = tmp48.targ1;
          _l_varDeclsCaseInner = tmp48.targ2;
          _l_preRes = tmp48.targ3;
          tmp49 = _SimCode_elementVars(_i_c_localDecls);
          _ret_8 = tmp49.SimCode_elementVars_rettype_1;
          tmp50 = mmc_mk_nil();
          tmp51 = mmc_mk_nil();
          tmp52 = mmc_mk_box3(3, &Tpl_Text_MEM__TEXT__desc, tmp50, tmp51);
          tmp53 = _SimCodeC_lm__656(tmp52, _ret_8, _l_preExpCaseInner, _l_varDeclsCaseInner);
          _l_0__ = tmp53.targ1;
          _l_preExpCaseInner = tmp53.targ2;
          _l_varDeclsCaseInner = tmp53.targ3;
          tmp54 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("case "));
          tmp55 = _Tpl_writeTok(_txt, tmp54);
          _txt = tmp55.Tpl_writeTok_rettype_1;
          tmp56 = intString((modelica_integer)_x_i0);
          tmp57 = _Tpl_writeStr(_txt, tmp56);
          _txt = tmp57.Tpl_writeStr_rettype_1;
          tmp58 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string(": {\n"));
          tmp59 = _Tpl_writeTok(_txt, tmp58);
          _txt = tmp59.Tpl_writeTok_rettype_1;
          tmp60 = mmc_mk_box2(4, &Tpl_BlockType_BT__INDENT__desc, mmc_mk_integer(2));
          tmp61 = _Tpl_pushBlock(_txt, tmp60);
          _txt = tmp61.Tpl_pushBlock_rettype_1;
          tmp62 = _Tpl_writeText(_txt, _l_varDeclsCaseInner);
          _txt = tmp62.Tpl_writeText_rettype_1;
          tmp63 = _Tpl_softNewLine(_txt);
          _txt = tmp63.Tpl_softNewLine_rettype_1;
          tmp64 = _Tpl_writeText(_txt, _l_preExpCaseInner);
          _txt = tmp64.Tpl_writeText_rettype_1;
          tmp65 = _Tpl_softNewLine(_txt);
          _txt = tmp65.Tpl_softNewLine_rettype_1;
          tmp66 = _Tpl_writeText(_txt, _l_patternMatching);
          _txt = tmp66.Tpl_writeText_rettype_1;
          tmp67 = _Tpl_softNewLine(_txt);
          _txt = tmp67.Tpl_softNewLine_rettype_1;
          tmp68 = mmc_mk_box2(5, &Tpl_StringToken_ST__LINE__desc, mmc_mk_string("/* Pattern matching succeeded */\n"));
          tmp69 = _Tpl_writeTok(_txt, tmp68);
          _txt = tmp69.Tpl_writeTok_rettype_1;
          tmp70 = _Tpl_writeText(_txt, _l_assignments);
          _txt = tmp70.Tpl_writeText_rettype_1;
          tmp71 = _Tpl_softNewLine(_txt);
          _txt = tmp71.Tpl_softNewLine_rettype_1;
          tmp72 = _Tpl_writeText(_txt, _l_stmts);
          _txt = tmp72.Tpl_writeText_rettype_1;
          tmp73 = _Tpl_softNewLine(_txt);
          _txt = tmp73.Tpl_softNewLine_rettype_1;
          tmp74 = _SimCodeC_fun__657(_txt, _i_c_result, _l_caseRes, _l_preRes);
          _txt = tmp74.SimCodeC_fun__657_rettype_1;
          tmp75 = _Tpl_softNewLine(_txt);
          _txt = tmp75.Tpl_softNewLine_rettype_1;
          tmp76 = _Tpl_writeText(_txt, _a_done);
          _txt = tmp76.Tpl_writeText_rettype_1;
          tmp77 = mmc_mk_cons(mmc_mk_scon(" = 1;\n"), mmc_mk_cons(mmc_mk_scon("break;\n"), mmc_mk_nil()));
          tmp78 = mmc_mk_box3(6, &Tpl_StringToken_ST__STRING__LIST__desc, tmp77, mmc_mk_boolean((1)));
          tmp79 = _Tpl_writeTok(_txt, tmp78);
          _txt = tmp79.Tpl_writeTok_rettype_1;
          tmp80 = _Tpl_popBlock(_txt);
          _txt = tmp80.Tpl_popBlock_rettype_1;
          tmp81 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("}"));
          tmp82 = _Tpl_writeTok(_txt, tmp81);
          _txt = tmp82.Tpl_writeTok_rettype_1;
          tmp83 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp84 = _Tpl_writeTok(_txt, tmp83);
          _txt = tmp84.Tpl_writeTok_rettype_1;
          tmp85 = _Tpl_nextIter(_txt);
          _txt = tmp85.Tpl_nextIter_rettype_1;
          tmp86 = _SimCodeC_lm__658(_txt, _rest, _a_done, _a_res, _a_context, _a_onPatternFail, _a_prefix);
          _txt = tmp86.targ1;
          _a_onPatternFail = tmp86.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_onPatternFail;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp87;
          modelica_metatype tmp88;
          SimCodeC_lm__658_rettype tmp89;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp87 = MMC_CAR(tmp3_in1);
          tmp88 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp88;
          _a_done = tmp3_in2;
          _a_res = tmp3_in3;
          _a_context = tmp3_in4;
          _a_onPatternFail = tmp3_in5;
          _a_prefix = tmp3_in6;
          tmp89 = _SimCodeC_lm__658(_txt, _rest, _a_done, _a_res, _a_context, _a_onPatternFail, _a_prefix);
          _txt = tmp89.targ1;
          _a_onPatternFail = tmp89.targ2;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_onPatternFail;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_onPatternFail = tmp2_targ2;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_onPatternFail;
  return tmp1;
}


SimCodeC_lm__658_rettypeboxed boxptr_SimCodeC_lm__658(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_done, modelica_metatype _in_a_res, modelica_metatype _in_a_context, modelica_metatype _in_a_onPatternFail, modelica_metatype _in_a_prefix)
{
  SimCodeC_lm__658_rettypeboxed tmp1;
  SimCodeC_lm__658_rettype tmp2;
  tmp2 = _SimCodeC_lm__658(_in_txt, _in_items, _in_a_done, _in_a_res, _in_a_context, _in_a_onPatternFail, _in_a_prefix);
  tmp1.SimCodeC_lm__658_rettypeboxed_1 = tmp2.SimCodeC_lm__658_rettype_1;
  tmp1.SimCodeC_lm__658_rettypeboxed_2 = tmp2.SimCodeC_lm__658_rettype_2;
  return tmp1;
}
SimCodeC_fun__657_rettype _SimCodeC_fun__657(modelica_metatype _in_txt, modelica_metatype _in_a_c_result, modelica_metatype _in_a_caseRes, modelica_metatype _in_a_preRes)
{
  SimCodeC_fun__657_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype tmp2;


  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_c_result;
    tmp3_in2 = _in_a_caseRes;
    tmp3_in3 = _in_a_preRes;
    {
      modelica_metatype _txt;
      modelica_metatype _a_caseRes;
      modelica_metatype _a_preRes;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 2 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          modelica_metatype tmp6;
          Tpl_writeTok_rettype tmp7;
          modelica_metatype tmp8;
          Tpl_writeTok_rettype tmp9;
          if (!optionNone(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          tmp6 = mmc_mk_box2(4, &Tpl_StringToken_ST__STRING__desc, mmc_mk_string("MMC_THROW();"));
          tmp7 = _Tpl_writeTok(_txt, tmp6);
          _txt = tmp7.Tpl_writeTok_rettype_1;
          tmp8 = mmc_mk_box1(3, &Tpl_StringToken_ST__NEW__LINE__desc);
          tmp9 = _Tpl_writeTok(_txt, tmp8);
          _txt = tmp9.Tpl_writeTok_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        case 1: {
          Tpl_writeText_rettype tmp10;
          Tpl_writeText_rettype tmp11;
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_caseRes = tmp3_in2;
          _a_preRes = tmp3_in3;
          tmp10 = _Tpl_writeText(_txt, _a_preRes);
          _txt = tmp10.Tpl_writeText_rettype_1;
          tmp11 = _Tpl_writeText(_txt, _a_caseRes);
          _txt = tmp11.Tpl_writeText_rettype_1;
          tmp2 = _txt;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2;
  
  _return:
  tmp1.targ1 = _out_txt;
  return tmp1;
}


SimCodeC_fun__657_rettypeboxed boxptr_SimCodeC_fun__657(modelica_metatype _in_txt, modelica_metatype _in_a_c_result, modelica_metatype _in_a_caseRes, modelica_metatype _in_a_preRes)
{
  SimCodeC_fun__657_rettypeboxed tmp1;
  SimCodeC_fun__657_rettype tmp2;
  tmp2 = _SimCodeC_fun__657(_in_txt, _in_a_c_result, _in_a_caseRes, _in_a_preRes);
  tmp1.SimCodeC_fun__657_rettypeboxed_1 = tmp2.SimCodeC_fun__657_rettype_1;
  return tmp1;
}
SimCodeC_lm__656_rettype _SimCodeC_lm__656(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_preExpCaseInner, modelica_metatype _in_a_varDeclsCaseInner)
{
  SimCodeC_lm__656_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_preExpCaseInner;
  modelica_metatype _out_a_varDeclsCaseInner;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_metatype tmp3_in2;
    modelica_metatype tmp3_in3;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_items;
    tmp3_in2 = _in_a_preExpCaseInner;
    tmp3_in3 = _in_a_varDeclsCaseInner;
    {
      modelica_metatype _txt;
      modelica_metatype _rest;
      modelica_metatype _a_preExpCaseInner;
      modelica_metatype _a_varDeclsCaseInner;
      modelica_metatype _i_var;
      int tmp4;
      int tmp5;
      for (tmp4 = 0, tmp5 = 0; tmp4 < 3 && !tmp5; tmp4++) {
        MMC_TRY()
        switch (tmp4) {
        case 0: {
          if (!listEmpty(tmp3_in1)) MMC_THROW();
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _a_preExpCaseInner = tmp3_in2;
          _a_varDeclsCaseInner = tmp3_in3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExpCaseInner;
          tmp2_targ3 = _a_varDeclsCaseInner;
          tmp5 = 1;
          break;
        }
        case 1: {
          modelica_metatype tmp6;
          modelica_metatype tmp7;
          SimCodeC_varInit_rettype tmp8;
          SimCodeC_lm__656_rettype tmp9;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp6 = MMC_CAR(tmp3_in1);
          tmp7 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _i_var = tmp6;
          _rest = tmp7;
          _a_preExpCaseInner = tmp3_in2;
          _a_varDeclsCaseInner = tmp3_in3;
          tmp8 = _SimCodeC_varInit(_txt, _i_var, "", 0, _a_varDeclsCaseInner, _a_preExpCaseInner);
          _txt = tmp8.targ1;
          _a_varDeclsCaseInner = tmp8.targ2;
          _a_preExpCaseInner = tmp8.targ3;
          tmp9 = _SimCodeC_lm__656(_txt, _rest, _a_preExpCaseInner, _a_varDeclsCaseInner);
          _txt = tmp9.targ1;
          _a_preExpCaseInner = tmp9.targ2;
          _a_varDeclsCaseInner = tmp9.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExpCaseInner;
          tmp2_targ3 = _a_varDeclsCaseInner;
          tmp5 = 1;
          break;
        }
        case 2: {
          modelica_metatype tmp10;
          modelica_metatype tmp11;
          SimCodeC_lm__656_rettype tmp12;
          if (listEmpty(tmp3_in1)) MMC_THROW();
          tmp10 = MMC_CAR(tmp3_in1);
          tmp11 = MMC_CDR(tmp3_in1);
          
          /* Pattern matching succeeded */
          _txt = tmp3_in0;
          _rest = tmp11;
          _a_preExpCaseInner = tmp3_in2;
          _a_varDeclsCaseInner = tmp3_in3;
          tmp12 = _SimCodeC_lm__656(_txt, _rest, _a_preExpCaseInner, _a_varDeclsCaseInner);
          _txt = tmp12.targ1;
          _a_preExpCaseInner = tmp12.targ2;
          _a_varDeclsCaseInner = tmp12.targ3;
          tmp2_targ1 = _txt;
          tmp2_targ2 = _a_preExpCaseInner;
          tmp2_targ3 = _a_varDeclsCaseInner;
          tmp5 = 1;
          break;
        }
        }
        MMC_CATCH()
      }
      if (!tmp5) MMC_THROW();
    }
  }
  _out_txt = tmp2_targ1;
  _out_a_preExpCaseInner = tmp2_targ2;
  _out_a_varDeclsCaseInner = tmp2_targ3;
  
  _return:
  tmp1.targ1 = _out_txt;
  tmp1.targ2 = _out_a_preExpCaseInner;
  tmp1.targ3 = _out_a_varDeclsCaseInner;
  return tmp1;
}


SimCodeC_lm__656_rettypeboxed boxptr_SimCodeC_lm__656(modelica_metatype _in_txt, modelica_metatype _in_items, modelica_metatype _in_a_preExpCaseInner, modelica_metatype _in_a_varDeclsCaseInner)
{
  SimCodeC_lm__656_rettypeboxed tmp1;
  SimCodeC_lm__656_rettype tmp2;
  tmp2 = _SimCodeC_lm__656(_in_txt, _in_items, _in_a_preExpCaseInner, _in_a_varDeclsCaseInner);
  tmp1.SimCodeC_lm__656_rettypeboxed_1 = tmp2.SimCodeC_lm__656_rettype_1;
  tmp1.SimCodeC_lm__656_rettypeboxed_2 = tmp2.SimCodeC_lm__656_rettype_2;
  tmp1.SimCodeC_lm__656_rettypeboxed_3 = tmp2.SimCodeC_lm__656_rettype_3;
  return tmp1;
}
SimCodeC_varInit_rettype _SimCodeC_varInit(modelica_metatype _in_txt, modelica_metatype _in_a_var, modelica_string _in_a_outStruct, modelica_integer _in_a_i, modelica_metatype _in_a_varDecls, modelica_metatype _in_a_varInits)
{
  SimCodeC_varInit_rettype tmp1;
  modelica_metatype _out_txt;
  modelica_metatype _out_a_varDecls;
  modelica_metatype _out_a_varInits;
  modelica_metatype tmp2_targ1;
  modelica_metatype tmp2_targ2;
  modelica_metatype tmp2_targ3;


  
  
  
  { /* matchcontinue expression */
    modelica_metatype tmp3_in0;
    modelica_metatype tmp3_in1;
    modelica_string tmp3_in2;
    modelica_integer tmp3_in3;
    modelica_metatype tmp3_in4;
    modelica_metatype tmp3_in5;
    tmp3_in0 = _in_txt;
    tmp3_in1 = _in_a_var;
    tmp3_in2 = _in_a_outStruct;
    tmp3_in3 = (modelica_int