#include "Modelica_Utilities_Strings_substring.h"
#include <algorithm>
#define MODELICA_ASSERT(msg) { fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {
Modelica_Utilities_Strings_substring_rettype _Modelica_Utilities_Strings_substring(modelica_string _string, modelica_integer _startIndex, modelica_integer _endIndex)
{
  Modelica_Utilities_Strings_substring_rettype out;
  state tmp1;
  int _startIndex_ext;
  int _endIndex_ext;
  const char* _result_ext;
  tmp1 = get_memory_state();
  _startIndex_ext = (int)_startIndex;
  _endIndex_ext = (int)_endIndex;
  _result_ext = ModelicaStrings_substring(_string, _startIndex_ext, _endIndex_ext);
  out.targ1 = (modelica_string)_result_ext;
  restore_memory_state(tmp1);
  return out;
}

int in_Modelica_Utilities_Strings_substring(type_description * inArgs, type_description * outVar)
{
  modelica_string _string;
  modelica_integer _startIndex;
  modelica_integer _endIndex;
  Modelica_Utilities_Strings_substring_rettype out;
  if (read_modelica_string(&inArgs, (char**) &_string)) return 1;
  if (read_modelica_integer(&inArgs, &_startIndex)) return 1;
  if (read_modelica_integer(&inArgs, &_endIndex)) return 1;
  out = _Modelica_Utilities_Strings_substring(_string, _startIndex, _endIndex);
  write_modelica_string(outVar, &out.targ1);
  return 0;
}

}

