#include "mylog.h"
#include <algorithm>
#define MODELICA_ASSERT(msg) { fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {
mylog_rettype _mylog(modelica_real _x)
{
  mylog_rettype out;
  state tmp1;
  double _x_ext;
  double _y_ext;
  tmp1 = get_memory_state();
  _x_ext = (double)_x;
  _y_ext = log(_x_ext);
  out.targ1 = (modelica_real)_y_ext;
  restore_memory_state(tmp1);
  return out;
}

int in_mylog(type_description * inArgs, type_description * outVar)
{
  modelica_real _x;
  mylog_rettype out;
  if (read_modelica_real(&inArgs, &_x)) return 1;
  out = _mylog(_x);
  write_modelica_real(outVar, &out.targ1);
  return 0;
}

}

