#include "ModelicaUtilities_myExtFunction.h"
#include <algorithm>
#define MODELICA_ASSERT(msg) { fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {
ModelicaUtilities_myExtFunction_rettype _ModelicaUtilities_myExtFunction(modelica_string _str, modelica_real _t)
{
  ModelicaUtilities_myExtFunction_rettype out;
  state tmp1;
  double _t_ext;
  const char* _out_ext;
  tmp1 = get_memory_state();
  _t_ext = (double)_t;
  _out_ext = myExtFunction(_str, _t_ext);
  out.targ1 = (modelica_string)_out_ext;
  restore_memory_state(tmp1);
  return out;
}

int in_ModelicaUtilities_myExtFunction(type_description * inArgs, type_description * outVar)
{
  modelica_string _str;
  modelica_real _t;
  ModelicaUtilities_myExtFunction_rettype out;
  if (read_modelica_string(&inArgs, (char**) &_str)) return 1;
  if (read_modelica_real(&inArgs, &_t)) return 1;
  out = _ModelicaUtilities_myExtFunction(_str, _t);
  write_modelica_string(outVar, &out.targ1);
  return 0;
}

}

