// Simulation code for TestPkg.subm generated by the OpenModelica Compiler 1.6.0.

#include "modelica.h"
#include "assert.h"
#include "string.h"
#include "simulation_runtime.h"

#include "TestPkg.subm_functions.h"


#define NHELP 0
#define NG 0 // number of zero crossings
#define NG_SAM 0 // number of zero crossings that are samples
#define NX 1
#define NY 0
#define NP 0 // number of parameters
#define NO 0 // number of outputvar on topmodel
#define NI 0 // number of inputvar on topmodel
#define NR 1 // number of residuals for initialialization function
#define NEXT 0 // number of external objects
#define MAXORD 5
#define NYSTR 0 // number of alg. string variables
#define NPSTR 0 // number of alg. string variables
#define NYINT 0 // number of alg. int variables
#define NPINT 0 // number of alg. int variables
#define NYBOOL 1 // number of alg. bool variables
#define NPBOOL 1 // number of alg. bool variables

static DATA* localData = 0;
#define time localData->timeValue
#define $P$old$Ptime localData->oldTime
#define $P$current_step_size globalData->current_stepsize

extern "C" { // adrpo: this is needed for Visual C++ compilation to work!
  const char *model_name="TestPkg.subm";
  const char *model_dir="";
}

// we need to access the inline define that we compiled the simulation with
// from the simulation runtime.
const char *_omc_force_solver=_OMC_FORCE_SOLVER;
const int inline_work_states_ndims=_OMC_SOLVER_WORK_STATES_NDIMS;

struct omc_varInfo state_names[1] = {
  {"$dummy","","",0,0,0,0}
};
struct omc_varInfo derivative_names[1] = {
  {"der($dummy)","","",0,0,0,0}
};
struct omc_varInfo algvars_names[1] = {{"","","",-1,-1,-1,-1}};
struct omc_varInfo input_names[1] = {{"","","",-1,-1,-1,-1}};
struct omc_varInfo output_names[1] = {{"","","",-1,-1,-1,-1}};
struct omc_varInfo param_names[1] = {{"","","",-1,-1,-1,-1}};
struct omc_varInfo int_alg_names[1] = {{"","","",-1,-1,-1,-1}};
struct omc_varInfo int_param_names[1] = {{"","","",-1,-1,-1,-1}};
struct omc_varInfo bool_alg_names[1] = {
  {"q","","InOutRecord.mo",24,5,24,14}
};
struct omc_varInfo bool_param_names[1] = {
  {"init","","InOutRecord.mo",25,5,25,35}
};
struct omc_varInfo string_alg_names[1] = {{"","","",-1,-1,-1,-1}};
struct omc_varInfo string_param_names[1] = {{"","","",-1,-1,-1,-1}};

#define $P$dummy localData->states[0]
#define $P$old$P$dummy localData->states_old[0]
#define $P$old2$P$dummy localData->states_old2[0]
#define $P$DER$P$dummy localData->statesDerivatives[0]
#define $P$old$P$DER$P$dummy localData->statesDerivatives_old[0]
#define $P$old2$P$DER$P$dummy localData->statesDerivatives_old2[0]
#define $Pq localData->boolVariables.algebraics[0]
#define $P$old$Pq localData->boolVariables.algebraics_old[0]
#define $P$old2$Pq localData->boolVariables.algebraics_old2[0]
#define $Pinit localData->boolVariables.parameters[0]
#define $P$old$Pinit localData->boolVariables.parameters_old[0]
#define $P$old2$Pinit localData->boolVariables.parameters_old2[0]

static char init_fixed[NX+NX+NY+NYINT+NYBOOL+NYSTR+NP+NPINT+NPBOOL+NPSTR] = {
  1 /* $dummy */,
  1 /* der($dummy) */,
  0 /* q */,
  1 /* init */
};

char var_attr[NX+NY+NYINT+NYBOOL+NYSTR+NP+NPINT+NPBOOL+NPSTR] = {
  1+0 /* $dummy */,
  8+16 /* q */,
  8+16 /* init */
};

const char* getName(double* ptr)
{
  if (&$P$dummy == ptr) return state_names[0].name;
  if (&$P$DER$P$dummy == ptr) return derivative_names[0].name;
  return "";
}

const char* getName(modelica_integer* ptr)
{
  return "";
}

const char* getName(modelica_boolean* ptr)
{
  if (&$Pq == ptr) return bool_alg_names[0].name;
  if (&$Pinit == ptr) return bool_param_names[0].name;
  return "";
}


/* Commented out by Frenkel TUD because there is a new implementation of
   division by zero problem. */
/*
#define DIVISION(a,b,c) ((b != 0) ? a / b : a / division_error(b,c))

int encounteredDivisionByZero = 0;

double division_error(double b, const char* division_str)
{
  if(!encounteredDivisionByZero) {
    fprintf(stderr, "ERROR: Division by zero in partial equation: %s.\n",division_str);
    encounteredDivisionByZero = 1;
  }
  return b;
}
*/

void setLocalData(DATA* data)
{
  localData = data;
}

DATA* initializeDataStruc(DATA_FLAGS flags)
{
  DATA* returnData = (DATA*)malloc(sizeof(DATA));

  if(!returnData) //error check
    return 0;

  memset(returnData,0,sizeof(DATA));
  returnData->nStates = NX;
  returnData->nAlgebraic = NY;
  returnData->nParameters = NP;
  returnData->nInputVars = NI;
  returnData->nOutputVars = NO;
  returnData->nZeroCrossing = NG;
  returnData->nRawSamples = NG_SAM;
  returnData->nInitialResiduals = NR;
  returnData->nHelpVars = NHELP;
  returnData->stringVariables.nParameters = NPSTR;
  returnData->stringVariables.nAlgebraic = NYSTR;
  returnData->intVariables.nParameters = NPINT;
  returnData->intVariables.nAlgebraic = NYINT;
  returnData->boolVariables.nParameters = NPBOOL;
  returnData->boolVariables.nAlgebraic = NYBOOL;

  if(flags & STATES && returnData->nStates) {
    returnData->states = (double*) malloc(sizeof(double)*returnData->nStates);
    returnData->states_old = (double*) malloc(sizeof(double)*returnData->nStates);
    returnData->states_old2 = (double*) malloc(sizeof(double)*returnData->nStates);
    assert(returnData->states&&returnData->states_old&&returnData->states_old2);
    memset(returnData->states,0,sizeof(double)*returnData->nStates);
    memset(returnData->states_old,0,sizeof(double)*returnData->nStates);
    memset(returnData->states_old2,0,sizeof(double)*returnData->nStates);
  } else {
    returnData->states = 0;
    returnData->states_old = 0;
    returnData->states_old2 = 0;
  }

  if(flags & STATESDERIVATIVES && returnData->nStates) {
    returnData->statesDerivatives = (double*) malloc(sizeof(double)*returnData->nStates);
    returnData->statesDerivatives_old = (double*) malloc(sizeof(double)*returnData->nStates);
    returnData->statesDerivatives_old2 = (double*) malloc(sizeof(double)*returnData->nStates);
    assert(returnData->statesDerivatives&&returnData->statesDerivatives_old&&returnData->statesDerivatives_old2);
    memset(returnData->statesDerivatives,0,sizeof(double)*returnData->nStates);
    memset(returnData->statesDerivatives_old,0,sizeof(double)*returnData->nStates);
    memset(returnData->statesDerivatives_old2,0,sizeof(double)*returnData->nStates);
  } else {
    returnData->statesDerivatives = 0;
    returnData->statesDerivatives_old = 0;
    returnData->statesDerivatives_old2 = 0;
  }

  if(flags & HELPVARS && returnData->nHelpVars) {
    returnData->helpVars = (double*) malloc(sizeof(double)*returnData->nHelpVars);
    assert(returnData->helpVars);
    memset(returnData->helpVars,0,sizeof(double)*returnData->nHelpVars);
  } else {
    returnData->helpVars = 0;
  }

  if(flags & ALGEBRAICS && returnData->nAlgebraic) {
    returnData->algebraics = (double*) malloc(sizeof(double)*returnData->nAlgebraic);
    returnData->algebraics_old = (double*) malloc(sizeof(double)*returnData->nAlgebraic);
    returnData->algebraics_old2 = (double*) malloc(sizeof(double)*returnData->nAlgebraic);
    assert(returnData->algebraics&&returnData->algebraics_old&&returnData->algebraics_old2);
    memset(returnData->algebraics,0,sizeof(double)*returnData->nAlgebraic);
    memset(returnData->algebraics_old,0,sizeof(double)*returnData->nAlgebraic);
    memset(returnData->algebraics_old2,0,sizeof(double)*returnData->nAlgebraic);
  } else {
    returnData->algebraics = 0;
    returnData->algebraics_old = 0;
    returnData->algebraics_old2 = 0;
  }

  if (flags & ALGEBRAICS && returnData->stringVariables.nAlgebraic) {
    returnData->stringVariables.algebraics = (const char**)malloc(sizeof(char*)*returnData->stringVariables.nAlgebraic);
    assert(returnData->stringVariables.algebraics);
    memset(returnData->stringVariables.algebraics,0,sizeof(char*)*returnData->stringVariables.nAlgebraic);
  } else {
    returnData->stringVariables.algebraics=0;
  }

  if (flags & ALGEBRAICS && returnData->intVariables.nAlgebraic) {
    returnData->intVariables.algebraics = (modelica_integer*)malloc(sizeof(modelica_integer)*returnData->intVariables.nAlgebraic);
    returnData->intVariables.algebraics_old = (modelica_integer*)malloc(sizeof(modelica_integer)*returnData->intVariables.nAlgebraic);
    returnData->intVariables.algebraics_old2 = (modelica_integer*)malloc(sizeof(modelica_integer)*returnData->intVariables.nAlgebraic);
    assert(returnData->intVariables.algebraics&&returnData->intVariables.algebraics_old&&returnData->intVariables.algebraics_old2);
    memset(returnData->intVariables.algebraics,0,sizeof(modelica_integer)*returnData->intVariables.nAlgebraic);
    memset(returnData->intVariables.algebraics_old,0,sizeof(modelica_integer)*returnData->intVariables.nAlgebraic);
    memset(returnData->intVariables.algebraics_old2,0,sizeof(modelica_integer)*returnData->intVariables.nAlgebraic);
  } else {
    returnData->intVariables.algebraics=0;
    returnData->intVariables.algebraics_old = 0;
    returnData->intVariables.algebraics_old2 = 0;
  }

  if (flags & ALGEBRAICS && returnData->boolVariables.nAlgebraic) {
    returnData->boolVariables.algebraics = (modelica_boolean*)malloc(sizeof(modelica_boolean)*returnData->boolVariables.nAlgebraic);
    returnData->boolVariables.algebraics_old = (signed char*)malloc(sizeof(modelica_boolean)*returnData->boolVariables.nAlgebraic);
    returnData->boolVariables.algebraics_old2 = (signed char*)malloc(sizeof(modelica_boolean)*returnData->boolVariables.nAlgebraic);
    assert(returnData->boolVariables.algebraics&&returnData->boolVariables.algebraics_old&&returnData->boolVariables.algebraics_old2);
    memset(returnData->boolVariables.algebraics,0,sizeof(modelica_boolean)*returnData->boolVariables.nAlgebraic);
    memset(returnData->boolVariables.algebraics_old,0,sizeof(modelica_boolean)*returnData->boolVariables.nAlgebraic);
    memset(returnData->boolVariables.algebraics_old2,0,sizeof(modelica_boolean)*returnData->boolVariables.nAlgebraic);
  } else {
    returnData->boolVariables.algebraics=0;
    returnData->boolVariables.algebraics_old = 0;
    returnData->boolVariables.algebraics_old2 = 0;
  }

  if(flags & PARAMETERS && returnData->nParameters) {
    returnData->parameters = (double*) malloc(sizeof(double)*returnData->nParameters);
    assert(returnData->parameters);
    memset(returnData->parameters,0,sizeof(double)*returnData->nParameters);
  } else {
    returnData->parameters = 0;
  }

  if (flags & PARAMETERS && returnData->stringVariables.nParameters) {
    returnData->stringVariables.parameters = (const char**)malloc(sizeof(char*)*returnData->stringVariables.nParameters);
      assert(returnData->stringVariables.parameters);
      memset(returnData->stringVariables.parameters,0,sizeof(char*)*returnData->stringVariables.nParameters);
  } else {
      returnData->stringVariables.parameters=0;
  }

  if (flags & PARAMETERS && returnData->intVariables.nParameters) {
    returnData->intVariables.parameters = (modelica_integer*)malloc(sizeof(modelica_integer)*returnData->intVariables.nParameters);
      assert(returnData->intVariables.parameters);
      memset(returnData->intVariables.parameters,0,sizeof(modelica_integer)*returnData->intVariables.nParameters);
  } else {
      returnData->intVariables.parameters=0;
  }

  if (flags & PARAMETERS && returnData->boolVariables.nParameters) {
    returnData->boolVariables.parameters = (modelica_boolean*)malloc(sizeof(modelica_boolean)*returnData->boolVariables.nParameters);
      assert(returnData->boolVariables.parameters);
      memset(returnData->boolVariables.parameters,0,sizeof(modelica_boolean)*returnData->boolVariables.nParameters);
  } else {
      returnData->boolVariables.parameters=0;
  }

  if(flags & OUTPUTVARS && returnData->nOutputVars) {
    returnData->outputVars = (double*) malloc(sizeof(double)*returnData->nOutputVars);
    assert(returnData->outputVars);
    memset(returnData->outputVars,0,sizeof(double)*returnData->nOutputVars);
  } else {
    returnData->outputVars = 0;
  }

  if(flags & INPUTVARS && returnData->nInputVars) {
    returnData->inputVars = (double*) malloc(sizeof(double)*returnData->nInputVars);
    assert(returnData->inputVars);
    memset(returnData->inputVars,0,sizeof(double)*returnData->nInputVars);
  } else {
    returnData->inputVars = 0;
  }

  if(flags & INITIALRESIDUALS && returnData->nInitialResiduals) {
    returnData->initialResiduals = (double*) malloc(sizeof(double)*returnData->nInitialResiduals);
    assert(returnData->initialResiduals);
    memset(returnData->initialResiduals,0,sizeof(double)*returnData->nInitialResiduals);
  } else {
    returnData->initialResiduals = 0;
  }

  if(flags & INITFIXED) {
    returnData->initFixed = init_fixed;
  } else {
    returnData->initFixed = 0;
  }

  /*   names   */
  if(flags & MODELNAME) {
    returnData->modelName = model_name;
  } else {
    returnData->modelName = 0;
  }

  if(flags & STATESNAMES) {
    returnData->statesNames = state_names;
  } else {
    returnData->statesNames = 0;
  }

  if(flags & STATESDERIVATIVESNAMES) {
    returnData->stateDerivativesNames = derivative_names;
  } else {
    returnData->stateDerivativesNames = 0;
  }

  if(flags & ALGEBRAICSNAMES) {
    returnData->algebraicsNames = algvars_names;
  } else {
    returnData->algebraicsNames = 0;
  }

  if(flags & ALGEBRAICSNAMES) {
    returnData->int_alg_names = int_alg_names;
  } else {
    returnData->int_alg_names = 0;
  }

  if(flags & ALGEBRAICSNAMES) {
    returnData->bool_alg_names = bool_alg_names;
  } else {
    returnData->bool_alg_names = 0;
  }

  if(flags & PARAMETERSNAMES) {
    returnData->parametersNames = param_names;
  } else {
    returnData->parametersNames = 0;
  }

  if(flags & PARAMETERSNAMES) {
    returnData->int_param_names = int_param_names;
  } else {
    returnData->int_param_names = 0;
  }

  if(flags & PARAMETERSNAMES) {
    returnData->bool_param_names = bool_param_names;
  } else {
    returnData->bool_param_names = 0;
  }

  if(flags & INPUTNAMES) {
    returnData->inputNames = input_names;
  } else {
    returnData->inputNames = 0;
  }

  if(flags & OUTPUTNAMES) {
    returnData->outputNames = output_names;
  } else {
    returnData->outputNames = 0;
  }

  if(flags & RAWSAMPLES && returnData->nRawSamples) {
    returnData->rawSampleExps = (sample_raw_time*) malloc(sizeof(sample_raw_time)*returnData->nRawSamples);
    assert(returnData->rawSampleExps);
    memset(returnData->rawSampleExps,0,sizeof(sample_raw_time)*returnData->nRawSamples);
  } else {
    returnData->rawSampleExps = 0;
  }

  if (flags & EXTERNALVARS) {
    returnData->extObjs = (void**)malloc(sizeof(void*)*NEXT);
    if (!returnData->extObjs) {
      printf("error allocating external objects\n");
      exit(-2);
    }
    memset(returnData->extObjs,0,sizeof(void*)*NEXT);
  }
  return returnData;
}


/* Has to be performed after _init.txt file has been read */
void callExternalObjectConstructors(DATA* localData) {
}


void deInitializeDataStruc(DATA* data, DATA_FLAGS flags)
{
  if(!data)
    return;

  if(flags & STATES && data->states) {
    free(data->states);
    data->states = 0;
  }

  if(flags & STATES && data->states_old) {
    free(data->states_old);
    data->states_old = 0;
  }

  if(flags & STATES && data->states_old2) {
    free(data->states_old2);
    data->states_old2 = 0;
  }

  if(flags & STATESDERIVATIVES && data->statesDerivatives) {
    free(data->statesDerivatives);
    data->statesDerivatives = 0;
  }

  if(flags & STATESDERIVATIVES && data->statesDerivatives_old) {
    free(data->statesDerivatives_old);
    data->statesDerivatives_old = 0;
  }

  if(flags & STATESDERIVATIVES && data->statesDerivatives_old2) {
    free(data->statesDerivatives_old2);
    data->statesDerivatives_old2 = 0;
  }

  if(flags & ALGEBRAICS && data->algebraics) {
    free(data->algebraics);
    data->algebraics = 0;
  }

  if(flags & ALGEBRAICS && data->algebraics_old) {
    free(data->algebraics_old);
    data->algebraics_old = 0;
  }

  if(flags & ALGEBRAICS && data->algebraics_old2) {
    free(data->algebraics_old2);
    data->algebraics_old2 = 0;
  }

  if(flags & PARAMETERS && data->parameters) {
    free(data->parameters);
    data->parameters = 0;
  }

  if(flags & OUTPUTVARS && data->inputVars) {
    free(data->inputVars);
    data->inputVars = 0;
  }

  if(flags & INPUTVARS && data->outputVars) {
    free(data->outputVars);
    data->outputVars = 0;
  }

  if(flags & INITIALRESIDUALS && data->initialResiduals){
    free(data->initialResiduals);
    data->initialResiduals = 0;
  }
  if (flags & EXTERNALVARS && data->extObjs) {
    free(data->extObjs);
    data->extObjs = 0;
  }
  if(flags & RAWSAMPLES && data->rawSampleExps) {
    free(data->rawSampleExps);
    data->rawSampleExps = 0;
  }
  /* adrpo: 2010-12-17 THIS IS WRONG as WE DO NOT ALLOCATE THIS in function initializeDataStruc!
  if(flags & RAWSAMPLES && data->sampleTimes) {
    free(data->sampleTimes);
    data->sampleTimes = 0;
  }
  */
}


/* for continuous time variables */
int functionDAE_output()
{
  state mem_state;
  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  return 0;
}

/* for discrete time variables */
int functionDAE_output2()
{
  state mem_state;
  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  return 0;
}

int input_function()
{
  return 0;
}

int output_function()
{
  return 0;
}

int functionDAE_res(double *t, double *x, double *xd, double *delta,
                    fortran_integer *ires, double *rpar, fortran_integer *ipar)
{
  int i;
  double temp_xd[NX];
#if NY>0
  double temp_alg[NY];
#endif
  double* statesBackup;
  double* statesDerivativesBackup;
  double* algebraicsBackup;
  double timeBackup;

  statesBackup = localData->states;
  statesDerivativesBackup = localData->statesDerivatives;
#if NY>0
    algebraicsBackup = localData->algebraics;
#endif
  timeBackup = localData->timeValue;
  localData->states = x;

  localData->statesDerivatives = temp_xd;
#if NY>0
  localData->algebraics = temp_alg;
#endif
  localData->timeValue = *t;

  memcpy(localData->statesDerivatives, statesDerivativesBackup, localData->nStates*sizeof(double));
#if NY>0
  memcpy(localData->algebraics, algebraicsBackup, localData->nAlgebraic*sizeof(double));
#endif

  functionODE();

  /* get the difference between the temp_xd(=localData->statesDerivatives)
     and xd(=statesDerivativesBackup) */
  for (i=0; i < localData->nStates; i++) {
    delta[i] = localData->statesDerivatives[i] - statesDerivativesBackup[i];
  }

  localData->states = statesBackup;
  localData->statesDerivatives = statesDerivativesBackup;
#if NY>0
  localData->algebraics = algebraicsBackup;
#endif
  localData->timeValue = timeBackup;

  if (modelErrorCode) {
    if (ires) {
      *ires = -1;
    }
    modelErrorCode =0;
  }

  return 0;
}

int function_zeroCrossing(fortran_integer *neqm, double *t, double *x, fortran_integer *ng,
                          double *gout, double *rpar, fortran_integer* ipar)
{
  double timeBackup;
  state mem_state;

  mem_state = get_memory_state();

  timeBackup = localData->timeValue;
  localData->timeValue = *t;
  
  functionODE();
  functionDAE_output();
  
  
  restore_memory_state(mem_state);
  localData->timeValue = timeBackup;
  
  return 0;
}

/* This function should only save in cases. The rest is done in
   function_updateDependents. */
int handleZeroCrossing(long index)
{
  state mem_state;

  mem_state = get_memory_state();

  switch(index) {
    default:
      break;
  }

  restore_memory_state(mem_state);

  return 0;
}

/* Initializes the raw time events of the simulation using the now
   calcualted parameters. */
void function_sampleInit()
{
  int i = 0; // Current index
}

int function_updateSample()
{
  state mem_state;
  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  return 0;
}

int function_updateDependents()
{
  state mem_state;
  
  inUpdate=initial()?0:1;
  
  mem_state = get_memory_state();
  $P$DER$P$dummy = 0.0; 
  restore_memory_state(mem_state);
  
  inUpdate=0;
  
  return 0;
}

extern int const numDelayExpressionIndex = 0;
int function_storeDelayed()
{
  state mem_state;
  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  return 0;
}

int function_when(int i)
{
  state mem_state;
  
  mem_state = get_memory_state();
  
  switch(i) {
    default:
      break;
  }
  
  restore_memory_state(mem_state);
  
  return 0;
}

int functionODE()
{
  state mem_state;
  
  mem_state = get_memory_state();
  $P$DER$P$dummy = 0.0; 
  restore_memory_state(mem_state);
  
  return 0;
}

#if defined(_OMC_ENABLE_INLINE)
int functionODE_inline()
{
  state mem_state;
  
  mem_state = get_memory_state();
  begin_inline();
  $P$DER$P$dummy = 0.0; 
  inline_integrate($P$DER$P$dummy);
  end_inline();
  restore_memory_state(mem_state);
  
  return 0;
}
#else
int functionODE_inline()
{
  return 0;
}
#endif

int initial_function()
{


  
  return 0;
}

int initial_residual()
{
  int i = 0;
  state mem_state;
  
  mem_state = get_memory_state();
  localData->initialResiduals[i++] = $P$DER$P$dummy;
  restore_memory_state(mem_state);
  
  return 0;
}

int bound_parameters()
{
  state mem_state;
  TestPkg_mk__r_rettype tmp3;
  TestPkg_fkn_rettype tmp4;
  
  mem_state = get_memory_state();
  tmp3 = _TestPkg_mk__r($Pinit, "test");
  tmp4 = _TestPkg_fkn(tmp3.TestPkg_mk__r_rettype_1);
  $Pq = tmp4.TestPkg_fkn_rettype_1; 
  restore_memory_state(mem_state);
  
  return 0;
}

int checkForDiscreteVarChanges()
{
  int needToIterate = 0;


  
  for (long i = 0; i < localData->nHelpVars; i++) {
    if (change(localData->helpVars[i])) {
      needToIterate=1;
    }
  }
  
  return needToIterate;
}

int functionODE_new()
{
  state mem_state;
  
  mem_state = get_memory_state();
  $P$DER$P$dummy = 0.0; 
  restore_memory_state(mem_state);
  
  return 0;
}

int functionODE_residual(double *t, double *x, double *xd, double *delta,
                    fortran_integer *ires, double *rpar, fortran_integer *ipar)
{
  int i;
  double temp_xd[NX];
  double* statesBackup;
  double* statesDerivativesBackup;
  double timeBackup;

  timeBackup = localData->timeValue;
  statesBackup = localData->states;
  statesDerivativesBackup = localData->statesDerivatives;

  localData->timeValue = *t;
  localData->states = x;
  localData->statesDerivatives = temp_xd;

  memcpy(localData->statesDerivatives, statesDerivativesBackup, localData->nStates*sizeof(double));

  functionODE_new();

  /* get the difference between the temp_xd(=localData->statesDerivatives)
     and xd(=statesDerivativesBackup) */
  for (i=0; i < localData->nStates; i++) {
    delta[i] = localData->statesDerivatives[i] - statesDerivativesBackup[i];
  }

  localData->states = statesBackup;
  localData->statesDerivatives = statesDerivativesBackup;
  localData->timeValue = timeBackup;

  if (modelErrorCode) {
    if (ires) {
      *ires = -1;
    }
    modelErrorCode =0;
  }

  return 0;
}

/* for continuous time variables */
int functionAlgebraics()
{
  state mem_state;
  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  return 0;
}

/* for continuous time variables */
int functionAliasEquations()
{
  state mem_state;
  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  return 0;
}

int functionDAE(int &needToIterate)
{
  state mem_state;
  needToIterate = 0;
  inUpdate=initial()?0:1;
  
  mem_state = get_memory_state();
  $P$DER$P$dummy = 0.0; 
  restore_memory_state(mem_state);
  
  inUpdate=0;
  
  return 0;
}

int function_onlyZeroCrossings(double *gout,double *t)
{
  state mem_state;
  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  return 0;
}

int checkForDiscreteChanges()
{
  int needToIterate = 0;

  
  return needToIterate;
}

int functionJacA(double *t, double *x, double *xd, double *jac)
{
  state mem_state;

  double* statesBackup;
  double* statesDerivativesBackup;
  double timeBackup;

  timeBackup = localData->timeValue;
  statesBackup = localData->states;
  statesDerivativesBackup = localData->statesDerivatives;
  localData->timeValue = *t;
  localData->states = x;
  localData->statesDerivatives = xd;

  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  localData->states = statesBackup;
  localData->statesDerivatives = statesDerivativesBackup;
  localData->timeValue = timeBackup;
  
  return 0;
}


int functionJacB(double *t, double *x, double *xd, double *jac)
{
  state mem_state;

  double* statesBackup;
  double* statesDerivativesBackup;
  double timeBackup;

  timeBackup = localData->timeValue;
  statesBackup = localData->states;
  statesDerivativesBackup = localData->statesDerivatives;
  localData->timeValue = *t;
  localData->states = x;
  localData->statesDerivatives = xd;

  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  localData->states = statesBackup;
  localData->statesDerivatives = statesDerivativesBackup;
  localData->timeValue = timeBackup;
  
  return 0;
}


int functionJacC(double *t, double *x, double *xd, double *jac)
{
  state mem_state;

  double* statesBackup;
  double* statesDerivativesBackup;
  double timeBackup;

  timeBackup = localData->timeValue;
  statesBackup = localData->states;
  statesDerivativesBackup = localData->statesDerivatives;
  localData->timeValue = *t;
  localData->states = x;
  localData->statesDerivatives = xd;

  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  localData->states = statesBackup;
  localData->statesDerivatives = statesDerivativesBackup;
  localData->timeValue = timeBackup;
  
  return 0;
}


int functionJacD(double *t, double *x, double *xd, double *jac)
{
  state mem_state;

  double* statesBackup;
  double* statesDerivativesBackup;
  double timeBackup;

  timeBackup = localData->timeValue;
  statesBackup = localData->states;
  statesDerivativesBackup = localData->statesDerivatives;
  localData->timeValue = *t;
  localData->states = x;
  localData->statesDerivatives = xd;

  
  mem_state = get_memory_state();
  restore_memory_state(mem_state);
  
  localData->states = statesBackup;
  localData->statesDerivatives = statesDerivativesBackup;
  localData->timeValue = timeBackup;
  
  return 0;
}


int linear_model_frame(string &out, string A, string B, string C, string D, string x_startvalues, string u_startvalues)
{
  string def_head("model linear_TestPkg.subm\n  parameter Integer n = 1; // states \n  parameter Integer k = 0; // top-level inputs \n  parameter Integer l = 0; // top-level outputs \n");
  
  string def_init_states("  parameter Real x0[1] = {");
  string def_init_states_end("};\n");
  
  string def_init_inputs("  parameter Real u0[0] = {");
  string def_init_inputs_end("};\n");
  
  string def_vectorx("  Real x[1](start=x0);\n");
  string def_vectoru("  input Real u[0];\n");
  string def_vectory("  output Real y[0];\n");

  string def_matrixA_start("  parameter Real A[1,1] = [");
  string def_matrixA_end("];\n");
  string def_matrixB_start("  parameter Real B[1,0] = zeros(1,0);\n");
  string def_matrixB_end("");
  string def_matrixC_start("  parameter Real C[0,1] = zeros(0,1);\n");
  string def_matrixC_end("");
  string def_matrixD_start("  parameter Real D[0,0] = zeros(0,0);\n");
  string def_matrixD_end("");
  
  string def_Variable("\n  Real x_P$dummy = x[1];\n      \n");
  
  string def_tail("equation\n  der(x) = A * x + B * u;\n  y = C * x + D * u;\nend linear_TestPkg.subm;\n");
  
  out += def_head.data();
  out += def_init_states.data();
  out += x_startvalues.data();
  out += def_init_states_end.data();
  out += def_init_inputs.data();
  out += u_startvalues.data();
  out += def_init_inputs_end.data();
  out += def_matrixA_start.data();
  out += A.data();
  out += def_matrixA_end.data();
  out += def_matrixB_start.data();
  out += B.data();
  out += def_matrixB_end.data();
  out += def_matrixC_start.data();
  out += C.data();
  out += def_matrixC_end.data();
  out += def_matrixD_start.data();
  out += D.data();
  out += def_matrixD_end.data();
  out += def_vectorx.data();
  out += def_vectoru.data();
  out += def_vectory.data();
  out += def_Variable.data();
  out += def_tail.data();
  return 0;
}



