/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml.driver;

import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDriver
implements XmlHandler,
Locator,
Attributes,
XMLReader {
    private DefaultHandler base = new DefaultHandler();
    private XmlParser parser;
    private boolean seenDTDEvents = false;
    private EntityResolver entityResolver = this.base;
    private DTDHandler dtdHandler = this.base;
    private ContentHandler documentHandler = this.base;
    private ErrorHandler errorHandler = this.base;
    private String elementName = null;
    private Stack entityStack = new Stack();
    private Vector attributeNames = new Vector();
    private Vector attributeValues = new Vector();
    private Hashtable properties = new Hashtable();
    private Hashtable features = new Hashtable();

    public void setLocale(Locale locale) throws SAXException {
        throw new SAXException("AElfred driver does not yet have locale support.");
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setDocumentHandler(ContentHandler handler) {
        this.documentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputSource source) throws SAXException {
        this.parser = new XmlParser();
        this.parser.setHandler(this);
        try {
            try {
                block12: {
                    if (source.getCharacterStream() == null) break block12;
                    this.parser.parse(source.getSystemId(), source.getPublicId(), source.getCharacterStream());
                    ** GOTO lbl-1000
                }
                if (source.getByteStream() != null) {
                    this.parser.parse(source.getSystemId(), source.getPublicId(), source.getByteStream(), source.getEncoding());
                } else {
                    this.parser.parse(source.getSystemId(), source.getPublicId(), source.getEncoding());
                }
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        catch (Throwable var4_4) {
            var3_5 = null;
            try {
                this.closeStreams(source);
                throw var4_4;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw var4_4;
        }
lbl-1000:
        // 3 sources

        {
            var3_6 = null;
        }
        ** try [egrp 2[TRYBLOCK] [4 : 125->133)] { 
lbl29:
        // 1 sources

        this.closeStreams(source);
        ** GOTO lbl-1000
lbl31:
        // 1 sources

        catch (Exception e) {
            // empty catch block
        }
lbl-1000:
        // 2 sources

        {
            this.closeStreams(source);
            return;
        }
    }

    public void parse(String systemId) throws SAXException {
        this.parse(new InputSource(systemId));
    }

    private void closeStreams(InputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            source.getCharacterStream().close();
        }
        if (source.getByteStream() != null) {
            source.getByteStream().close();
        }
    }

    public void startDocument() throws SAXException {
        this.documentHandler.setDocumentLocator(this);
        this.documentHandler.startDocument();
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    public void endDocument() throws SAXException {
        this.documentHandler.endDocument();
    }

    public Object resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = this.entityResolver.resolveEntity(publicId, systemId);
        if (source == null) {
            return null;
        }
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        }
        if (source.getByteStream() != null) {
            return source.getByteStream();
        }
        return source.getSystemId();
    }

    public void startExternalEntity(String systemId) throws SAXException {
        this.entityStack.push(systemId);
    }

    public void endExternalEntity(String systemId) throws SAXException {
        this.entityStack.pop();
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void attribute(String aname, String value, boolean isSpecified) throws SAXException {
        if (value != null) {
            this.attributeNames.addElement(aname);
            this.attributeValues.addElement(value);
        }
    }

    public void startElement(String elname) throws SAXException {
        if (!this.seenDTDEvents) {
            this.deliverDTDEvents();
            this.seenDTDEvents = true;
        }
        this.elementName = elname;
        this.documentHandler.startElement("", elname, "", this);
        this.elementName = null;
        this.attributeNames.removeAllElements();
        this.attributeValues.removeAllElements();
    }

    public void endElement(String elname) throws SAXException {
        this.documentHandler.endElement("", elname, "");
    }

    public void charData(char[] ch, int start, int length) throws SAXException {
        this.documentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.documentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.documentHandler.processingInstruction(target, data);
    }

    public void error(String message, String url, int line, int column) throws SAXException {
        this.errorHandler.fatalError(new SAXParseException(message, null, url, line, column));
    }

    private void deliverDTDEvents() throws SAXException {
        String systemId;
        String publicId;
        String nname;
        Enumeration notationNames = this.parser.declaredNotations();
        Enumeration entityNames = this.parser.declaredEntities();
        while (notationNames.hasMoreElements()) {
            nname = (String)notationNames.nextElement();
            publicId = this.parser.getNotationPublicId(nname);
            systemId = this.parser.getNotationSystemId(nname);
            this.dtdHandler.notationDecl(nname, publicId, systemId);
        }
        while (entityNames.hasMoreElements()) {
            String ename = (String)entityNames.nextElement();
            if (this.parser.getEntityType(ename) != 2) continue;
            publicId = this.parser.getEntityPublicId(ename);
            systemId = this.parser.getEntitySystemId(ename);
            nname = this.parser.getEntityNotationName(ename);
            this.dtdHandler.unparsedEntityDecl(ename, publicId, systemId, nname);
        }
    }

    public int getLength() {
        return this.attributeNames.size();
    }

    public String getName(int i) {
        return (String)this.attributeNames.elementAt(i);
    }

    public String getType(int i) {
        switch (this.parser.getAttributeType(this.elementName, this.getName(i))) {
            case 0: 
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: 
            case 9: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 10: {
                return "NOTATION";
            }
        }
        return null;
    }

    public String getValue(int i) {
        return (String)this.attributeValues.elementAt(i);
    }

    public String getType(String name) {
        int i = 0;
        while (i < this.getLength()) {
            if (name.equals(this.getName(i))) {
                return this.getType(i);
            }
            ++i;
        }
        return null;
    }

    public String getValue(String name) {
        int i = 0;
        while (i < this.getLength()) {
            if (name.equals(this.getName(i))) {
                return this.getValue(i);
            }
            ++i;
        }
        return null;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return (String)this.entityStack.peek();
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    public boolean getFeature(String name) {
        if (this.features.containsKey(name)) {
            return (Boolean)this.features.get(name);
        }
        return false;
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public Object getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
        this.documentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.documentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public String getURI(int index) {
        return "";
    }

    public String getLocalName(int index) {
        return "";
    }

    public String getQName(int index) {
        return "";
    }

    public int getIndex(String uri, String localPart) {
        return -1;
    }

    public int getIndex(String qName) {
        return -1;
    }

    public String getType(String uri, String localName) {
        return "";
    }

    public String getValue(String uri, String localName) {
        return "";
    }
}

