#include "Modelica_Math_Matrices_LAPACK_dgelsx__vec.h"
#include <algorithm>
#define MODELICA_ASSERT(info,msg) { printInfo(stderr,info); fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {


Modelica_Math_Matrices_LAPACK_dgelsx__vec_rettype _Modelica_Math_Matrices_LAPACK_dgelsx__vec(real_array _A, real_array _b, modelica_real _rcond)
{
  Modelica_Math_Matrices_LAPACK_dgelsx__vec_rettype out;
  state tmp1;
  int tmp2;
  real_array _x_ext;
  int _rank_ext = 0;
  int _info_ext = 0;
  modelica_integer _nrow;
  modelica_integer _nrow_ext;
  modelica_integer tmp3;
  modelica_integer _ncol;
  modelica_integer _ncol_ext;
  modelica_integer tmp4;
  modelica_integer _nx;
  modelica_integer _nx_ext;
  modelica_integer _lwork;
  modelica_integer _lwork_ext;
  real_array _work;
  real_array _work_ext;
  real_array _Awork;
  real_array _Awork_ext;
  integer_array _jpvt;
  integer_array _jpvt_ext;
  integer_array tmp5;
  integer_array tmp6;
  real_array tmp7;
  tmp1 = get_memory_state();
  tmp2 = (modelica_integer) 1;
  tmp3 = size_of_dimension_real_array(_A, (modelica_integer) 1);
  _nrow = tmp3;
  tmp4 = size_of_dimension_real_array(_A, (modelica_integer) 2);
  _ncol = tmp4;
  _nx = modelica_integer_max((modelica_integer)(modelica_integer)_nrow,(modelica_integer)(modelica_integer)_ncol);
  _lwork = modelica_integer_max((modelica_integer)(modelica_integer_min((modelica_integer)(modelica_integer)_nrow,(modelica_integer)(modelica_integer)_ncol) + ((modelica_integer) 3 * (modelica_integer)_ncol)),(modelica_integer)((modelica_integer) 1 + ((modelica_integer) 2 * modelica_integer_min((modelica_integer)(modelica_integer)_nrow,(modelica_integer)(modelica_integer)_ncol))));
  alloc_real_array(&_work, 1, (modelica_integer)_lwork);
  convert_alloc_real_array_to_f77(&_work, &_work_ext);
  _Awork = _A;
  alloc_real_array(&_Awork, 2, (modelica_integer)_nrow, (modelica_integer)_ncol);
  convert_alloc_real_array_to_f77(&_Awork, &_Awork_ext);
  fill_alloc_integer_array(&tmp5, (modelica_integer) 0, 1, (modelica_integer)_ncol);
  _jpvt = tmp5;
  alloc_integer_array(&_jpvt, 1, (modelica_integer)_ncol);
  convert_alloc_integer_array_to_f77(&_jpvt, &_jpvt_ext);
  alloc_real_array(&out.targ1, 1, modelica_integer_max((modelica_integer)(modelica_integer)_nrow,(modelica_integer)(modelica_integer)_ncol));
  fill_alloc_integer_array(&tmp6, (modelica_integer) 0, 1, (modelica_integer_max((modelica_integer)(modelica_integer)_nrow,(modelica_integer)(modelica_integer)_ncol) - (modelica_integer)_nrow));
  cat_alloc_real_array((modelica_integer) 1, &tmp7, 2, &_b, &tmp6);
  _x_ext = tmp7;
  convert_alloc_real_array_to_f77(&out.targ1, &_x_ext);
  dgelsx_((int*) &_nrow, (int*) &_ncol, &tmp2, data_of_real_array(&(_Awork_ext)), (int*) &_nrow, data_of_real_array(&(_x_ext)), (int*) &_nx, data_of_integer_array(&(_jpvt_ext)), &_rcond, (int*) &_rank_ext, data_of_real_array(&(_work_ext)), (int*) &_lwork, (int*) &_info_ext);
  convert_alloc_real_array_from_f77(&_x_ext, &out.targ1);
  out.targ3 = (modelica_integer)_rank_ext;

  out.targ2 = (modelica_integer)_info_ext;
  restore_memory_state(tmp1);
  return out;
}

int in_Modelica_Math_Matrices_LAPACK_dgelsx__vec(type_description * inArgs, type_description * outVar)
{
  real_array _A;
  real_array _b;
  modelica_real _rcond;
  Modelica_Math_Matrices_LAPACK_dgelsx__vec_rettype out;
  if (read_real_array(&inArgs, &_A)) return 1;
  if (read_real_array(&inArgs, &_b)) return 1;
  if (read_modelica_real(&inArgs, &_rcond)) return 1;
  MMC_TRY_TOP()
  out = _Modelica_Math_Matrices_LAPACK_dgelsx__vec(_A, _b, _rcond);
  MMC_CATCH_TOP(return 1)
  write_real_array(outVar, &out.targ1);
  write_modelica_integer(outVar, &out.targ2);
  write_modelica_integer(outVar, &out.targ3);
  return 0;
}

}

