#include "Modelica_Math_Matrices_LAPACK_dgetrf.h"
#include <algorithm>
#define MODELICA_ASSERT(info,msg) { printInfo(stderr,info); fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {


Modelica_Math_Matrices_LAPACK_dgetrf_rettype _Modelica_Math_Matrices_LAPACK_dgetrf(real_array _A)
{
  Modelica_Math_Matrices_LAPACK_dgetrf_rettype out;
  state tmp1;
  int tmp2;
  int tmp3;
  int tmp4;
  real_array _LU_ext;
  integer_array _pivots_ext;
  int _info_ext = 0;
  modelica_integer tmp5;
  modelica_integer tmp6;
  modelica_integer tmp7;
  modelica_integer tmp8;
  tmp1 = get_memory_state();
  tmp2 = size_of_dimension_real_array(_A, (modelica_integer) 1);
  tmp3 = size_of_dimension_real_array(_A, (modelica_integer) 2);
  tmp4 = size_of_dimension_real_array(_A, (modelica_integer) 1);
  tmp5 = size_of_dimension_real_array(_A, (modelica_integer) 1);
  tmp6 = size_of_dimension_real_array(_A, (modelica_integer) 2);
  alloc_real_array(&out.targ1, 2, tmp5, tmp6);
  copy_real_array_data(&_A, &out.targ1);
  _LU_ext = _A;
  tmp7 = size_of_dimension_real_array(_A, (modelica_integer) 1);
  tmp8 = size_of_dimension_real_array(_A, (modelica_integer) 2);
  alloc_integer_array(&out.targ2, 1, modelica_integer_min((modelica_integer)tmp7,(modelica_integer)tmp8));
  convert_alloc_real_array_to_f77(&out.targ1, &_LU_ext);
  convert_alloc_integer_array_to_f77(&out.targ2, &_pivots_ext);
  dgetrf_(&tmp2, &tmp3, data_of_real_array(&(_LU_ext)), &tmp4, data_of_integer_array(&(_pivots_ext)), (int*) &_info_ext);
  convert_alloc_real_array_from_f77(&_LU_ext, &out.targ1);
  convert_alloc_integer_array_from_f77(&_pivots_ext, &out.targ2);
  out.targ3 = (modelica_integer)_info_ext;
  restore_memory_state(tmp1);
  return out;
}

int in_Modelica_Math_Matrices_LAPACK_dgetrf(type_description * inArgs, type_description * outVar)
{
  real_array _A;
  Modelica_Math_Matrices_LAPACK_dgetrf_rettype out;
  if (read_real_array(&inArgs, &_A)) return 1;
  MMC_TRY_TOP()
  out = _Modelica_Math_Matrices_LAPACK_dgetrf(_A);
  MMC_CATCH_TOP(return 1)
  write_real_array(outVar, &out.targ1);
  write_integer_array(outVar, &out.targ2);
  write_modelica_integer(outVar, &out.targ3);
  return 0;
}

}

