#include "mkperson.h"
#include <algorithm>
#define MODELICA_ASSERT(cond,msg) { if (!(cond)) fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {
const char* Person__desc__fields[3] = {"name","age","children"};
struct record_description Person__desc = {
  "Person", /* package_record__X */
  "Person", /* package.record_X */
  Person__desc__fields
};
mkperson_rettype _mkperson(modelica_string _name, modelica_integer _age, string_array _children)
{
  mkperson_rettype tmp1;
  state tmp2;
  struct Person _p;
  string_array tmp3;
  alloc_string_array(&_p.children, 1, 2);
  tmp2 = get_memory_state();


  _p.name = _name;
  _p.age = (modelica_integer)_age;
  array_alloc_scalar_string_array(&tmp3, 2, (modelica_string)(*string_array_element_addr(&_children, 1, 1)), (modelica_string)(*string_array_element_addr(&_children, 1, 2)));
  copy_string_array_data(&tmp3, &_p.children);
  
  _return:
  tmp1.targ1 = _p;
  restore_memory_state(tmp2);
  return tmp1;
}

int in_mkperson(type_description * inArgs, type_description * outVar)
{
  modelica_string _name;
  modelica_integer _age;
  string_array _children;
  mkperson_rettype out;
  if (read_modelica_string(&inArgs, &_name)) return 1;
  if (read_modelica_integer(&inArgs, &_age)) return 1;
  if (read_string_array(&inArgs, &_children)) return 1;
  out = _mkperson(_name, _age, _children);
  write_modelica_record(outVar, &Person__desc, TYPE_DESC_STRING, &(out.targ1.name), TYPE_DESC_INT, &(out.targ1.age), TYPE_DESC_STRING_ARRAY, &(out.targ1.children), TYPE_DESC_NONE);
  return 0;
}

}

